-- [[
-- AlphaMap v2.11.11100 Traditional Chinese Localization File
-- Initial Translated by: Arith Hsu (2006/07/21)
-- Maintained by: Arith Hsu
-- Last Updated: 2006/07/26
-- Comments:
--    2006/07/27 Arith: 翻譯這個插件的文字，工作量是很龐大的，特別是要去查詢各副本裡的 boss 名稱，還有一些對應的任務名稱和
--                      一些任務注意事項等。期望看到後續有人熱心維護這個翻譯，但是請尊重各個維護翻譯的人的辛勞，你可以把你
--                      的名字加在檔頭，但是請勿移除其他人的名字。
--                      使用簡體中文的朋友如果是拿這個正體中文檔案直接轉簡體，我也沒什麼意見，但是請一樣保留原翻譯者的記錄
--                      另外請注意，正體中文和簡體中文的翻譯還是有諸多的不一致，請自行修正。
-- Revision History:
--    7/26: Complete about 95% translations.
-- ]]

if ( GetLocale() == "zhTW" ) then

	AM_TYP_INSTANCE 	= "副本";

	AM_ALPHAMAP_INSTANCES_LIST = {

			{	name = "黑暗深淵",			-- Blackfathom Deeps
				type = AM_TYP_INSTANCE,
				displayname = "黑暗深淵",
				displayshort = "BFD",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackfathomDeeps",
				location = "梣谷 (14, 14)",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "一些水下的區域",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {33, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑暗深淵"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {50, 68} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "加摩拉", colour = AM_RED, coords = { {23.5, 42} }, symbol = { "1" },
						tooltiptxt = "Lvl25 菁英野獸 (巨型烏龜)", lootid = "BFDGhamoora" },
				dtl4  = { text = "潮濕的便箋", colour = AM_ORANGE, coords = { {23.5, 30} }, symbol = { "2" },
						tooltiptxt = "'深淵的知識' 任務物品,\n箱子中" },
				dtl5  = { text = "薩利維絲", colour = AM_RED, coords = { {3, 29} }, symbol = { "3" },
						tooltiptxt = "Lvl25 菁英人形怪", lootid = "BFDLadySarevess" },
				dtl6  = { text = "銀月守衛塞爾瑞德", colour = AM_BLUE, coords = { {11, 51} }, symbol = { "4" },
						tooltiptxt = "'尋找塞爾瑞德'任務的搜尋目標,\n也是'黑暗深淵中的惡魔'任務的開始" },
				dtl7  = { text = "格裏哈斯特", colour = AM_RED, coords = { {43, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl25 菁英人形怪 (魚人)", lootid = "BFDGelihast" },
				dtl8  = { text = "洛古斯‧傑特", colour = AM_RED, coords = { {49, 43}, {55, 46} }, symbol = { "6" },
						tooltiptxt = "Lvl26 菁英人形怪", special = AM_VARIES },
				dtl9  = { text = "阿奎尼斯男爵", colour = AM_RED, coords = { {52, 76} }, symbol = { "7" },
						tooltiptxt = "Lvl28 菁英人形怪", lootid = "BFDBaronAquanis" },
				dtl10 = { text = "深淵之核", colour = AM_BLUE, coords = { {52, 76} }, symbol = { " " },
						tooltiptxt = "部落'廢墟之間'任務物品" },
				dtl11 = { text = "夢遊者克爾裏斯", colour = AM_RED, coords = { {63, 81} }, symbol = { "8" },
						tooltiptxt = "Lvl27 菁英人形怪", lootid = "BFDTwilightLordKelris" },
				dtl12 = { text = "Blackfathom-Tiefen Altar", colour = AM_BLUE, coords = { {63, 81} }, symbol = { " " },
						tooltiptxt = "" },
				dtl13 = { text = "瑟拉吉斯", colour = AM_RED, coords = { {63, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl26 菁英野獸", lootid = "BFDOldSerrakis" },
				dtl14 = { text = "阿庫邁爾", colour = AM_RED, coords = { {95, 85} }, symbol = { "10" },
						tooltiptxt = "Lvl29 菁英野獸 (水蛇)", lootid = "BFDAkumai", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BFDTrash", leaveGap = 1 }
			},

			{	name = "黑石深淵",			-- Blackrock Depths
				type = AM_TYP_INSTANCE,
				displayname = "黑石深淵",
				displayshort = "BRD",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackrockDepths",
				location = "黑石山",
				levels = "52-60",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {21, 83} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "洛考爾", colour = AM_RED, coords = { {33, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl51 菁英元素怪", lootid = "BRDLordRoccor" },
				dtl3  = { text = "審訊官格斯塔恩", colour = AM_RED, coords = { {38, 95} }, symbol = { "2" },
						tooltiptxt = "Lvl52 菁英人形怪", lootid = "BRDHighInterrogatorGerstahn" },
				dtl4  = { text = "溫德索爾元帥", colour = AM_BLUE, coords = { {46, 95} }, symbol = { "3" },
						tooltiptxt = "將連結到奧妮克希亞系列任務" },
				dtl5  = { text = "指揮官哥沙克", colour = AM_BLUE, coords = { {40, 90} }, symbol = { "4" },
						tooltiptxt = "部落'指揮官哥沙克'任務" },
				dtl6  = { text = "卡蘭‧巨錘", colour = AM_BLUE, coords = { {44, 86} }, symbol = { "5" },
						tooltiptxt = "聯盟'卡蘭‧巨錘'任務" },
				dtl7  = { text = "法律之環", colour = AM_GREEN, coords = { {42, 73.4} }, symbol = { "6" },
						tooltiptxt = "在此將所有怪物殺死以使\n上層的觀眾從紅色的侵略形轉為\n黃色中立", lootid = "BRDArena" },
				dtl8  = { text = "瑟爾倫", colour = AM_RED, coords = { {42, 73.4} }, symbol = { " " },
						tooltiptxt = "NPC 群領隊", lootid = "BRDArena" },
				dtl9  = { text = "弗蘭克羅恩‧鑄鐵", colour = AM_BLUE, coords = { {45.8, 78.1} }, symbol = { "7" },
						tooltiptxt = "'黑鐵的遺產' 任務" },
				dtl10  = { text = "控火師羅格雷恩", colour = AM_RED, coords = { {48, 78} }, symbol = { "8" },
						tooltiptxt = "Lvl52 菁英人形怪", special = AM_RARE, lootid = "BRDPyromantLoregrain" },
				dtl11 = { text = "黑色寶庫", colour = AM_GREEN, coords = { {54, 54} }, symbol = { "9" },
						tooltiptxt = "" },
				dtl12  = { text = "弗諾斯‧達克維爾", colour = AM_RED, coords = { {55, 41} }, symbol = { "10" },
						tooltiptxt = "Lvl54 菁英人形怪", lootid = "BRDFineousDarkvire" },
				dtl13 = { text = "典獄官斯迪爾基斯", colour = AM_RED, coords = { {48, 55} }, symbol = { "11" },
						tooltiptxt = "Lvl56 菁英人形怪", lootid = "BRDWarderStilgiss" },
				dtl14 = { text = "維雷克", colour = AM_RED, coords = { {54, 54} }, symbol = { " " },
						tooltiptxt = "Lvl55 菁英" },
				dtl15 = { text = "伊森迪奧斯", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { "12" },
						tooltiptxt = "'伊森迪奧斯!' 任務", lootid = "BRDLordIncendius" },
				dtl16 = { text = "黑鐵砧", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { " " },
						tooltiptxt = "" },
				dtl17 = { text = "暗爐之鎖", colour = AM_GREEN, coords = { {31, 72.4} }, symbol = { "13" },
						tooltiptxt = "打開鎖以使你可以進入更高層的區域\n需要暗爐鑰匙" },
				dtl18 = { text = "貝爾加", colour = AM_RED, coords = { {8, 62} }, symbol = { "14" },
						tooltiptxt = "Lvl57 菁英巨人", lootid = "BRDBaelGar" },
				dtl19 = { text = "安格弗將軍", colour = AM_RED, coords = { {24, 64} }, symbol = { "15" },
						tooltiptxt = "Lvl57 菁英矮人", lootid = "BRDGeneralAngerforge" },
				dtl20 = { text = "傀儡統帥阿格曼奇", colour = AM_RED, coords = { {24, 51} }, symbol = { "16" },
						tooltiptxt = "Lvl58 菁英矮人", lootid = "BRDGolemLordArgelmach" },
				dtl21 = { text = "黑鐵酒吧", colour = AM_GREEN, coords = { {40, 50} }, symbol = { "17" },
						tooltiptxt = "購買六個黑鐵酒杯\n並且將其給予羅克諾特下士", lootid = "BRDGuzzler" },
				dtl22 = { text = "弗萊拉斯大使", colour = AM_RED, coords = { {46, 38} }, symbol = { "18" },
						tooltiptxt = "Lvl57 菁英人形怪", lootid = "BRDFlamelash" },
				dtl23 = { text = "無敵的潘佐爾", colour = AM_RED, coords = { {40, 27} }, symbol = { "19" },
						tooltiptxt = "Lvl57 菁英傀儡", special = AM_RARE, lootid = "BRDPanzor" },
				dtl24 = { text = "召喚者之墓", colour = AM_GREEN, coords = { {46, 18} }, symbol = { "20" },
						tooltiptxt = "依序擊敗七個小王後便可進入夠深處\n箱子", lootid = "BRDTomb" },
				dtl25 = { text = "講學廳", colour = AM_GREEN, coords = { {61, 8.5} }, symbol = { "21" },
						tooltiptxt = "找到並且擊敗兩個暗爐持火者\n並點燃兩個火炬\n打死地一個持火者後只有三分鐘的時間" },
				dtl26 = { text = "瑪格姆斯", colour = AM_RED, coords = { {78, 8.5} }, symbol = { "22" },
						tooltiptxt = "Lvl57 菁英巨人", lootid = "BRDMagmus" },
				dtl27 = { text = "鐵爐堡公主茉艾拉‧銅鬚", colour = AM_RED, coords = { {90, 8} }, symbol = { "23" },
						tooltiptxt = "Lvl58 菁英人形怪", lootid = "BRDPrincess" },
				dtl28 = { text = "達格蘭‧索瑞森大帝", colour = AM_RED, coords = { {93, 8.5} }, symbol = { "24" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "BRDImperatorDagranThaurissan" },
				dtl29 = { text = "黑熔爐", colour = AM_GREEN, coords = { {63, 22} }, symbol = { "23" },
						tooltiptxt = "融煉黑鐵錠,\n也是製作濃煙山脈之心的地方" },
				dtl30 = { text = "熔火之心", colour = AM_ORANGE, coords = { {65, 30} }, symbol = { "24" },
						tooltiptxt = "'熔火之心的傳送門' 任務\n熔火之心入口", toMap = "熔火之心", leaveGap = 1 }
			},

			{	name = "黑石塔",		-- Blackrock Spire
				type = AM_TYP_INSTANCE,
				displayname = "黑石塔 (下層)",
				displayshort = "LBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\LBRS",			-- LBRS
				location = "黑石山",
				levels = "53-60",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR },
				dtl2  = { text = "黑石塔 (上層)", colour = AM_BLUE, coords = { {22, 4} }, symbol = { "U" },
						tooltiptxt = "", toMap = "黑石塔 (上層)" },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {45.2, 29}, {73, 46} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "通往歐莫克大王的橋", colour = AM_GREEN, coords = { {38, 32.1}, {15, 32.1} }, symbol = { "B" },
						tooltiptxt = "" },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {71, 22}, {94, 26} }, symbol = { "x2" },
						tooltiptxt = "下層" },
				dtl6  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {29, 53}, {29, 77} }, symbol = { "x3" },
						tooltiptxt = "" },
				dtl7  = { text = "斜坡", colour = AM_BLUE, coords = { {86, 40}, {89, 58} }, symbol = { "R" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "維埃蘭", colour = AM_RED, coords = { {31, 17} }, symbol = { "1" },
						tooltiptxt = "Lvl55 菁英\n'晉升印章'任務"  },
				dtl9  = { text = "瓦羅什", colour = AM_RED, coords = { {53, 14} }, symbol = { "2" },
						tooltiptxt = "Lvl60 菁英人形怪"  },
				dtl10 = { text = "尖銳長矛", colour = AM_ORANGE, coords = { {69, 29} }, symbol = { "3" },
						tooltiptxt = "任務物品"  },
				dtl11 = { text = "寶鑽", colour = AM_BLUE, coords = { {62, 25 } }, symbol = { "4" },
						tooltiptxt = "寶鑽任務系列\n不在下層" },
				dtl12 = { text = "尖石屠夫", colour = AM_RED, coords = { {42, 32.1} }, symbol = { "5" },
						tooltiptxt = "Lvl59 菁英人形怪\n在通往歐莫克大王的橋上巡邏", lootid = "LBRSSpirestoneButcher", special = AM_RARE  },
				dtl13 = { text = "歐莫克大王", colour = AM_RED, coords = { {2, 32.1} }, symbol = { "6" },
						tooltiptxt = "Lvl?? 菁英人形怪", lootid = "LBRSOmokk"  },
				dtl14 = { text = "尖石統帥", colour = AM_RED, coords = { {2, 32.1} }, symbol = { " " },
						tooltiptxt = "在歐莫克大王附近的小丘上", lootid = "LBRSSpirestoneLord", special = AM_RARE },
				dtl15 = { text = "暗影獵手沃什加斯", colour = AM_RED, coords = { {77, 64} }, symbol = { "7" },
						tooltiptxt = "Lvl?? 菁英人形怪", lootid = "LBRSVosh"  },
				dtl16 = { text = "第五塊摩沙魯石板", colour = AM_ORANGE, coords = { {77, 68} }, symbol = { "8" },
						tooltiptxt = "任務物品"  },
				dtl17 = { text = "班諾克‧巨斧", colour = AM_RED, coords = { {41.5, 26.5} }, symbol = { "9" },
						tooltiptxt = "Lvl59 菁英人形怪\n在下層", lootid = "LBRSGrimaxe", special = AM_RARE },
				dtl18 = { text = "維姆薩拉克", colour = AM_RED, coords = { {73, 32} }, symbol = { "10" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "LBRSVoone" },
				dtl19 = { text = "第六塊摩沙魯石板", colour = AM_ORANGE, coords = { {75, 29} }, symbol = { "11" },
						tooltiptxt = "任務物品"  },
				dtl20 = { text = "莫爾‧灰蹄", colour = AM_RED, coords = { {75, 35} }, symbol = { "12" },
						tooltiptxt = "Lvl60 菁英\n需要召喚火盆\n需中斷其治療", lootid = "LBRSGrayhoof" },
				dtl21  = { text = "煙網蛛后", colour = AM_RED, coords = { {54, 58} }, symbol = { "13" },
						tooltiptxt = "Lvl59 菁英野獸", lootid = "LBRSSmolderweb"  },
				dtl22 = { text = "水晶之牙", colour = AM_RED, coords = { {36, 49} }, symbol = { "14" },
						tooltiptxt = "Lvl60 菁英野獸", special = AM_RARE, lootid = "LBRSCrystalFang"  },
				dtl23 = { text = "烏洛克", colour = AM_RED, coords = { {30, 30} }, symbol = { "15" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "LBRSDoomhowl"  },
				dtl24 = { text = "軍需官茲格雷斯", colour = AM_RED, coords = { {50, 89} }, symbol = { "16" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "LBRSZigris"  },
				dtl25 = { text = "哈雷肯", colour = AM_RED, coords = { {19, 92} }, symbol = { "17" },
						tooltiptxt = "Lvl59 菁英野獸\nKill to trigger spawn of Gizrul", lootid = "LBRSHalycon"  },
				dtl26 = { text = "奴役者基茲盧爾", colour = AM_RED, coords = { {19, 92} }, symbol = { " " },
						tooltiptxt = "Lvl60 菁英野獸\n在哈雷肯死後被觸發產生", lootid = "LBRSSlavener"  },
				dtl27 = { text = "維姆薩拉克", colour = AM_RED, coords = { {42, 62} }, symbol = { "18" },
						tooltiptxt = "Lvl?? 菁英龍", lootid = "LBRSWyrmthalak", leaveGap = 1  },
				dtl28 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "LBRSTrash", leaveGap = 1 }
			},

			{	name = "黑石塔 (上層)",
				type = AM_TYP_INSTANCE,
				displayname = "黑石塔 (上層)",
				displayshort = "UBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\UBRS",			-- UBRS
				location = "黑石山",
				levels = "53-60",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 80.7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR },
				dtl2  = { text = "黑石塔 (下層)", colour = AM_BLUE, coords = { {18.2, 86.6} }, symbol = { "L" },
						tooltiptxt = "", toMap = "黑石塔", leaveGap = 1 },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {11.9, 58.4}, {8.65, 25} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "烈焰衛士艾博希爾", colour = AM_RED, coords = { {8.2, 31.0} }, symbol = { "1" },
						tooltiptxt = "Lvl?? 菁英元素怪", lootid = "UBRSEmberseer", leaveGap = 1  },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {8.6, 38.9}, {36.4, 61.2} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl6  = { text = "末日扣環", colour = AM_ORANGE, coords = { {41.3, 68.65} }, symbol = { "2" },
						tooltiptxt = "任務物品\n在一堆傾倒的柱子附近的箱子裡\n不是很容易可以被看見\n可以從達基薩斯將軍的房間跳下"  },
				dtl7  = { text = "烈焰之父", colour = AM_ORANGE, coords = { {50, 65.45} }, symbol = { "3" },
						tooltiptxt = "在靠近通到的底端\n先避免龍蛋孵化再去開啟", lootid = "UBRSFLAME"  },
				dtl8  = { text = "索拉卡‧火冠", colour = AM_RED, coords = { {50, 65.45} }, symbol = { " " },
						tooltiptxt = "Lvl60 菁英龍族\n在拾取烈焰之父之後出現", lootid = "UBRSSolakar" },
				dtl9  = { text = "傑德", colour = AM_RED, coords = { {47, 52.6} }, symbol = { "4" },
						tooltiptxt = "Lvl59 菁英人形怪", special = AM_RARE, lootid = "UBRSRunewatcher"  },
				dtl10 = { text = "古拉魯克", colour = AM_RED, coords = { {34, 52.6} }, symbol = { "5" },
						tooltiptxt = "Lvl61 菁英人形怪", lootid = "UBRSAnvilcrack"  },
				dtl11 = { text = "大酋長雷德‧黑手", colour = AM_RED, coords = { {67.5, 51} }, symbol = { "6" },
						tooltiptxt = "首領\n僅限部落的'為了部落'任務\n騎著蓋斯下來", lootid = "UBRSRend"  },
				dtl12  = { text = "蓋斯", colour = AM_RED, coords = { {67.5, 51} }, symbol = { " " },
						tooltiptxt = "Lvl?? 菁英龍", lootid = "UBRSGyth" },
				dtl13 = { text = "奧比", colour = AM_BLUE, coords = { {68.1, 65.9} }, symbol = { "7" },
						tooltiptxt = "僅限於'監護者'任務"  },
				dtl14 = { text = "比斯巨獸", colour = AM_RED, coords = { {95.7, 60.8} }, symbol = { "8" },
						tooltiptxt = "Lvl?? 菁英野獸", lootid = "UBRSBeast"  },
				dtl15 = { text = "瓦薩拉克", colour = AM_RED, coords = { {95.7, 56.5} }, symbol = { "9" },
						tooltiptxt = "Lvl?? 菁英\n需有任務才可召喚\n先將黑手大廳清完後再召喚", lootid = "UBRSValthalak" },
				dtl16  = { text = "達基薩斯將軍", colour = AM_RED, coords = { {41.6, 73.2} }, symbol = { "10" },
						tooltiptxt = "Lvl?? 菁英龍", lootid = "UBRSDrakkisath"  },
				dtl17 = { text = "黑翼之巢", colour = AM_BLUE, coords = { {78.5, 27.6} }, symbol = { "BWL" },
						tooltiptxt = "", toMap = "黑翼之巢", leaveGap = 1 },
				dtl18 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl19 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UBRSTrash", leaveGap = 1 }
			},

			{	name = "黑翼之巢",		-- Blackwing Lair
				type = AM_TYP_INSTANCE,
				displayname = "黑翼之巢",
				displayshort = "BWL",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackwingLair",
				location = "黑石塔",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {65, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石塔 (上層)", leaveGap = 1 },
				dtl2 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {32.8, 78}, {61, 48} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl3 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {40, 96}, {68, 65} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl4 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {47, 51}, {17, 52} }, symbol = { "x3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "狂野的拉佐格爾", colour = AM_RED, coords = { {51, 66} }, symbol = { "1" },
						tooltiptxt = "首領", lootid = "BWLRazorgore"  },
				dtl6  = { text = "墮落的瓦拉斯塔茲", colour = AM_RED, coords = { {32.5, 67} }, symbol = { "2" },
						tooltiptxt = "首領", lootid = "BWLVaelastrasz"  },
				dtl7  = { text = "勒西雷爾", colour = AM_RED, coords = { {77, 42} }, symbol = { "3" },
						tooltiptxt = "首領", lootid = "BWLLashlayer"  },
				dtl8  = { text = "費爾默", colour = AM_RED, coords = { {12, 44} }, symbol = { "4" },
						tooltiptxt = "首領", lootid = "BWLFiremaw"  },
				dtl9  = { text = "埃博諾克", colour = AM_RED, coords = { {10, 29} }, symbol = { "5" },
						tooltiptxt = "首領", lootid = "BWLEbonroc"  },
				dtl10 = { text = "弗萊格爾", colour = AM_RED, coords = { {18, 29} }, symbol = { "6" },
						tooltiptxt = "首領", lootid = "BWLFlamegor"  },
				dtl11 = { text = "克洛瑪古斯", colour = AM_RED, coords = { {33, 40} }, symbol = { "7" },
						tooltiptxt = "首領", lootid = "BWLChromaggus"  },
				dtl12 = { text = "奈法利安", colour = AM_RED, coords = { {60, 14} }, symbol = { "8" },
						tooltiptxt = "首領", lootid = "BWLNefarian", leaveGap = 1 },
				dtl13 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BWLTrashMobs", leaveGap = 1 },
				dtl14 = { text = AM_TIER2_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T2SET", leaveGap = 1 }
			},

			{	name = "厄運之槌",		-- Dire Maul
				type = AM_TYP_INSTANCE,
				displayname = "厄運之槌 - 概觀",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DireMaul",
				location = "菲拉斯 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "厄運之槌 (東)", colour = AM_GREEN, coords = { {53, 81}, {57, 96}, {100, 80} }, symbol = { "E" },
						tooltiptxt = "按下以打開 '厄運之槌 (東)' 的地圖", toMap = "厄運之槌 (東)" },
				dtl2  = { text = "厄運之槌 (北)", colour = AM_GREEN, coords = { {67.5, 38} }, symbol = { "N" },
						tooltiptxt = "按下以打開 '厄運之槌 (北)' 的地圖", toMap = "厄運之槌 (北)" },
				dtl3  = { text = "厄運之槌 (西)", colour = AM_GREEN, coords = { {47, 88} }, symbol = { "W" },
						tooltiptxt = "按下以打開 '厄運之槌 (西)' 的地圖", toMap = "厄運之槌 (西)", leaveGap = 1 },
				dtl4  = { text = "圖書館", colour = AM_BLUE, coords = { {24, 58}, {41, 41} }, symbol = { "L" },
						tooltiptxt = "從北厄/西厄可以抵達", leaveGap = 1 }
			},


			{	name = "厄運之槌 (東)",		-- Dire Maul East
				type = AM_TYP_INSTANCE,
				displayname = "厄運之槌 (東)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMEast",		--DMEast
				location = "菲拉斯 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "入口 : Broken Commons", colour = AM_GREEN, coords = { {6, 58}  }, symbol = { "X1" },
						tooltiptxt = "", toMap = "厄運之槌"..AM_EXTERIOR },
				dtl2  = { text = "入口 : Eldereth Row", colour = AM_GREEN, coords = { {12, 92} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "厄運之槌"..AM_EXTERIOR },
				dtl3  = { text = "入口 : Pavillion", colour = AM_GREEN, coords = { {98, 64} }, symbol = { "X3" },
						tooltiptxt = "" },
				dtl4  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {8, 40} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "Drop to Broken Commons\nside Chamber" },
				dtl5  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {41, 85}, {61, 93} }, symbol = { "L1" },
						tooltiptxt = "" },
				dtl6  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {75, 92}, {55, 82} }, symbol = { "L2" },
						tooltiptxt = "" },
				dtl7  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {67, 63}, {83, 73} }, symbol = { "L3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "開始追捕普希林", colour = AM_GREEN, coords = { {10, 50} }, symbol = { "P" },
						tooltiptxt = "追捕以取得厄運之槌鑰匙(月牙鑰匙)", lootid = "DMEPusillin"  },
				dtl9  = { text = "結束追捕普希林", colour = AM_RED, coords = { {79, 61} }, symbol = { "P" },
						tooltiptxt = "喔, 你這小惡魔!", lootid = "DMEPusillin"  },
				dtl10 = { text = "瑟雷姆·刺蹄", colour = AM_RED, coords = { {83, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl57 菁英惡魔", lootid = "DMEZevrimThornhoof"  },
				dtl11 = { text = "海多斯博恩", colour = AM_RED, coords = { {64, 77} }, symbol = { "2" },
						tooltiptxt = "Lvl57 菁英元素怪", lootid = "DMEHydro"  },
				dtl12 = { text = "蕾瑟塔蒂絲", colour = AM_RED, coords = { {46, 66} }, symbol = { "3" },
						tooltiptxt = "Lvl57 菁英人形怪", lootid = "DMELethtendris"  },
				dtl13 = { text = "埃隆巴克", colour = AM_RED, coords = { {21, 69} }, symbol = { "4" },
						tooltiptxt = "打開門"  },
				dtl14 = { text = "奧茲恩", colour = AM_RED, coords = { {42, 23} }, symbol = { "5" },
						tooltiptxt = "Lvl58 菁英惡魔", lootid = "DMEAlzzin"  },
				dtl15 = { text = "依薩利恩", colour = AM_RED, coords = { {42, 23} }, symbol = { " " },
						tooltiptxt = "需要召喚火盆\n任務從黑石山的布德利取得", lootid = "DMEIsalien", leaveGap = 2 },
				dtl16 = { text = "書籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMETrash", leaveGap = 1 }
			},

			{	name = "厄運之槌 (北)",		-- Dire Maul North
				type = AM_TYP_INSTANCE,
				displayname = "厄運之槌 (北)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMNorth",		-- DMNorth
				location = "菲拉斯 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "需要從東厄普希林拿到的月牙鑰匙",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {74, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "厄運之槌"..AM_EXTERIOR },
				dtl2  = { text = "厄運之槌 (西)", colour = AM_GREEN, coords = { {9, 98} }, symbol = { "W" },
						tooltiptxt = "", toMap = "厄運之槌 (西)" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {49.2, 59.4} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "衛兵摩爾達", colour = AM_RED, coords = { {76.4, 55.5} }, symbol = { "1" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "DMNGuardMoldar"  },
				dtl5  = { text = "踐踏者克雷格", colour = AM_RED, coords = { {67, 49} }, symbol = { "2" },
						tooltiptxt = "Lvl57 菁英惡魔", lootid = "DMNStomperKreeg"  },
				dtl6  = { text = "衛兵芬古斯", colour = AM_RED, coords = { {49.2, 56.1} }, symbol = { "3" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "DMNGuardFengus"  },
				dtl7  = { text = "衛兵斯里基克", colour = AM_RED, coords = { {17, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "DMNGuardSlipkik"  },
				dtl8  = { text = "諾特‧希姆加克", colour = AM_RED, coords = { {19, 37} }, symbol = { "5" },
						tooltiptxt = "", lootid = "DMNThimblejack"  },
				dtl9  = { text = "克羅卡斯", colour = AM_RED, coords = { {24.6, 34.8} }, symbol = { "6" },
						tooltiptxt = "", lootid = "DMNCaptainKromcrush"  },
				dtl10 = { text = "戈多克大王", colour = AM_RED, coords = { {24.2, 11.2} }, symbol = { "7" },
						tooltiptxt = "", lootid = "DMNKingGordok"  },
				dtl11 = { text = "圖書館", colour = AM_BLUE, coords = { {20, 89} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 2  },
				dtl12 = { text = "貢品進貢", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "DMNTRIBUTERUN" },
				dtl13 = { text = "書籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 }
			},

			{	name = "厄運之槌 (西)",		-- Dire Maul West
				type = AM_TYP_INSTANCE,
				displayname = "厄運之槌 (西)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMWest",		-- DMWest
				location = "菲拉斯 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "需要從東厄普希林拿到的月牙鑰匙",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {97, 78} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "厄運之槌"..AM_EXTERIOR },
				dtl2  = { text = "厄運之槌 (北)", colour = AM_GREEN, coords = { {66, 9} }, symbol = { "N" },
						tooltiptxt = "", toMap = "厄運之槌 (北)", leaveGap = 1 },
				dtl3  = { text = "階梯", colour = AM_BLUE, coords = { {49.2, 25}, {52, 60} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "水晶塔", colour = AM_GREEN, coords = { {83, 80}, {64, 61}, {64, 87}, {27, 62}, {27, 37} }, symbol = { "P" },
						tooltiptxt = "將這些都摧毀", leaveGap = 1 },
				dtl5  = { text = "辛德拉古靈", colour = AM_ORANGE, coords = { {68, 74} }, symbol = { "1" },
						tooltiptxt = "任務接到'挑戰托塞德林王子'" },
				dtl6  = { text = "特迪斯‧扭木", colour = AM_RED, coords = { {58, 74} }, symbol = { "2" },
						tooltiptxt = "Lvl60 菁英元素怪", lootid = "DMWTendrisWarpwood" },
				dtl7  = { text = "伊琳娜‧暗木", colour = AM_RED, coords = { {49, 87} }, symbol = { "3" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "DMWIllyannaRavenoak" },
				dtl8  = { text = "蘇斯", colour = AM_RED, coords = { {48, 60} }, symbol = { "4" },
						tooltiptxt = "Lvl59 菁英不死族", special = AM_RARE, lootid = "DMWTsuzee" },
				dtl9  = { text = "卡雷迪斯鎮長", colour = AM_RED, coords = { {53, 51} }, symbol = { "5" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "DMWMagisterKalendris" },
				dtl10 = { text = "伊莫塔爾", colour = AM_RED, coords = { {19, 49} }, symbol = { "6" },
						tooltiptxt = "Lvl61 菁英惡魔", lootid = "DMWImmolthar" },
				dtl11 = { text = "赫爾努拉斯", colour = AM_RED, coords = { { 19, 49} }, symbol = { " " },
						tooltiptxt = "Lvl62 菁英惡魔", lootid = "DMWHelnurath" },
				dtl12 = { text = "托塞德林王子", colour = AM_RED, coords = { {41, 26} }, symbol = { "7" },
						tooltiptxt = "Lvl61 菁英人形怪", lootid = "DMWPrinceTortheldrin", leaveGap = 1  },
				dtl13 = { text = "圖書館", colour = AM_BLUE, coords = { {51, 20} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "書籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMWTrash", leaveGap = 1 }
			},

			{	name = "諾姆瑞根",			-- Gnomeregan
				type = AM_TYP_INSTANCE,
				displayname = "諾姆瑞根",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Gnomeregan",
				location = "丹莫洛 (25, 41)",
				levels = "26-33",
				players = "10",
				prereq = "",
				general = "部落可由藏寶海灣傳送過來.\n起始任務來自奧格瑪工程師.",
				dtl1  = { text = "正門入口 (Clockwerk Run)", colour = AM_GREEN, coords = { {70.5, 16} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "諾姆瑞根"..AM_EXTERIOR },
				dtl2  = { text = "後門入口 (車庫)", colour = AM_GREEN, coords = { {87, 59} }, symbol = { "X2" },
						tooltiptxt = "需要車間鑰匙", toMap = "Gnomeregan"..AM_EXTERIOR },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {75, 38}, {79, 56} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "粘性輻射塵", colour = AM_RED, coords = { {71.5, 33.5} }, symbol = { "1" },
						tooltiptxt = "Lvl30 菁英元素怪\n下層", lootid = "GnViscousFallout" },
				dtl5  = { text = "格魯比斯", colour = AM_RED, coords = { {95, 46} }, symbol = { "2" },
						tooltiptxt = "Lvl32 菁英人形怪\n觸發後出現\n在同一個地方和爆破專家艾米·短線講話", lootid = "GnGrubbis"  },
				dtl6  = { text = "克努比 (宿舍區)", colour = AM_BLUE, coords = { {76, 54} }, symbol = { "3" },
						tooltiptxt = ""  },
				dtl7  = { text = "矩陣式打孔電腦 3005-B", colour = AM_GREEN, coords = { {70, 50} }, symbol = { "B" },
						tooltiptxt = "卡片升級"  },
				dtl8  = { text = "清洗區", colour = AM_GREEN, coords = { {64, 46} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "電刑器 6000 型", colour = AM_RED, coords = { {30, 49} }, symbol = { "5" },
						tooltiptxt = "Lvl32 菁英機器人\n會掉落車間鑰匙", lootid = "GnElectrocutioner6000"  },
				dtl10 = { text = "矩陣式打孔電腦 3005-C", colour = AM_GREEN, coords = { {33.2, 49.6} }, symbol = { "C" },
						tooltiptxt = "卡片升級"  },
				dtl11 = { text = "群體打擊者 9-60", colour = AM_RED, coords = { {47.6, 77.3} }, symbol = { "6" },
						tooltiptxt = "Lvl32 菁英機器人", lootid = "GnCrowdPummeler960"  },
				dtl12 = { text = "矩陣式打孔電腦 3005-D", colour = AM_GREEN, coords = { {48.9, 75.7} }, symbol = { "D" },
						tooltiptxt = "卡片升級"  },
				dtl13 = { text = "黑鐵大師", colour = AM_RED, coords = { {9, 52} }, symbol = { "5" },
						tooltiptxt = "Lvl33 菁英人形怪", special = AM_RARE, lootid = "GnDIAmbassador"  },
				dtl14 = { text = "麥克尼爾‧瑟瑪普拉格", colour = AM_RED, coords = { {11.8, 42.2} }, symbol = { "8" },
						tooltiptxt = "Lvl35 菁英惡魔", lootid = "GnMekgineerThermaplugg", leaveGap = 1  },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "GnTrash", leaveGap = 1 }
			},

			{	name = "瑪拉頓",			-- Maraudon
				type = AM_TYP_INSTANCE,
				displayname = "瑪拉頓",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Maraudon",
				location = "淒涼之地 (29, 62)",
				levels = "40-49",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "入口 (橙區)", colour = AM_ORANGE, coords = { {71, 12} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "瑪拉頓"..AM_EXTERIOR },
				dtl2  = { text = "入口 (紫區)", colour = AM_PURPLE, coords = { {85, 31} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "瑪拉頓"..AM_EXTERIOR },
				dtl3  = { text = "入口 (傳送)", colour = AM_GREEN, coords = { {36, 55} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {64, 44}, {39, 31} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "溫格 (第五可汗)", colour = AM_RED, coords = { {59, 6} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS  },
				dtl6  = { text = "諾克賽恩", colour = AM_RED, coords = { {51, 3} }, symbol = { "2" },
						tooltiptxt = "Lvl48 菁英元素怪", lootid = "MaraNoxxion"  },
				dtl7  = { text = "銳刺鞭笞者", colour = AM_RED, coords = { {36, 14} }, symbol = { "3" },
						tooltiptxt = "Lvl47 菁英野獸", lootid = "MaraRazorlash"  },
				dtl8  = { text = "瑪勞杜斯 (第四可汗)", colour = AM_RED, coords = { {64, 27} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "維利塔恩", colour = AM_RED, coords = { {53.3, 32} }, symbol = { "5" },
						tooltiptxt = "Lvl47 菁英人形怪", lootid = "MaraLordVyletongue"  },
				dtl10 = { text = "收割者麥什洛克", colour = AM_RED, coords = { {43, 30} }, symbol = { "6" },
						tooltiptxt = "", special = AM_RARE, lootid = "MaraMeshlok"  },
				dtl11 = { text = "被詛咒的塞雷布拉斯", colour = AM_RED, coords = { {31, 35} }, symbol = { "7" },
						tooltiptxt = "Lvl49 菁英人形怪", lootid = "MaraCelebras"  },
				dtl12 = { text = "蘭斯利德", colour = AM_RED, coords = { {51.3, 60} }, symbol = { "8" },
						tooltiptxt = "Lvl50 菁英元素怪", lootid = "MaraLandslide"  },
				dtl13 = { text = "工匠吉茲洛克", colour = AM_RED, coords = { {61, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl50 菁英人形怪", lootid = "MaraTinkererGizlock"  },
				dtl14 = { text = "洛特格里普", colour = AM_RED, coords = { {45, 82} }, symbol = { "10" },
						tooltiptxt = "Lvl50 菁英野獸", lootid = "MaraRotgrip"  },
				dtl15 = { text = "瑟萊德絲公主", colour = AM_RED, coords = { {32, 85} }, symbol = { "11" },
						tooltiptxt = "Lvl51 菁英元素怪", lootid = "MaraPrincessTheradras" },
				dtl16 = { text = "札爾塔的靈魂", colour = AM_RED, coords = { {32, 85} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 }
			},

			{	name = "熔火之心",			-- Molten Core
				type = AM_TYP_INSTANCE,
				displayname = "熔火之心",
				displayshort = "MC",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MoltenCore",
				location = "黑石深淵",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 20} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石深淵", leaveGap = 1 },
				dtl2  = { text = "魯西弗隆", colour = AM_RED, coords = { {62, 35} }, symbol = { "1" },
						tooltiptxt = "首領 人形", lootid = "MCLucifron" },
				dtl3  = { text = "瑪格曼達", colour = AM_RED, coords = { {70, 16} }, symbol = { "2" },
						tooltiptxt = "首領 野獸", lootid = "MCMagmadar" },
				dtl4  = { text = "基赫納斯", colour = AM_RED, coords = { {13, 46} }, symbol = { "3" },
						tooltiptxt = "首領 人形", lootid = "MCGehennas" },
				dtl5  = { text = "加爾", colour = AM_RED, coords = { {8, 71} }, symbol = { "4" },
						tooltiptxt = "首領 元素怪", lootid = "MCGarr"  },
				dtl6  = { text = "沙斯拉爾", colour = AM_RED, coords = { {44, 80} }, symbol = { "5" },
						tooltiptxt = "首領 人形", lootid = "MCShazzrah"  },
				dtl7  = { text = "迦頓男爵", colour = AM_RED, coords = { {53, 68} }, symbol = { "6" },
						tooltiptxt = "首領 元素怪", lootid = "MCGeddon"  },
				dtl8  = { text = "焚化者古雷曼格", colour = AM_RED, coords = { {66, 57} }, symbol = { "7" },
						tooltiptxt = "首領 巨人", lootid = "MCGolemagg"  },
				dtl9  = { text = "薩弗隆先驅者", colour = AM_RED, coords = { {87, 80} }, symbol = { "8" },
						tooltiptxt = "首領 人形", lootid = "MCSulfuron"  },
				dtl10 = { text = "管理者埃克索圖斯", colour = AM_RED, coords = { {89, 62} }, symbol = { "9" },
						tooltiptxt = "首領 人形", lootid = "MCMajordomo"  },
				dtl11 = { text = "拉格納羅斯", colour = AM_RED, coords = { {47, 52} }, symbol = { "10" },
						tooltiptxt = "首領 元素怪", lootid = "MCRagnaros", leaveGap = 2  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCTrashMobs", lootlink = true },
				dtl13 = { text = AM_RBOSS_DROP, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCRANDOMBOSSDROPPS", leaveGap = 1 },
				dtl14 = { text = AM_TIER1_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T1SET", leaveGap = 1 }
			},

			{	name = "納克薩瑪斯",			-- Naxxramas
				type = AM_TYP_INSTANCE,
				displayname = "納克薩瑪斯",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Naxxramas",
				location = "斯坦索姆",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text ="憎惡區" , colour = AM_BLUE, coords = { {2, 15} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "縫補者", colour = AM_RED, coords = { {22, 36} }, symbol = { "1" },
						tooltiptxt = "憎惡區", lootid = "NAXPatchwerk" },
				dtl3  = { text = "葛羅巴斯", colour = AM_RED, coords = { {32, 29} }, symbol = { "2" },
						tooltiptxt = "憎惡區", lootid = "NAXGrobbulus" },
				dtl4  = { text = "古魯斯", colour = AM_RED, coords = { {20, 20} }, symbol = { "3" },
						tooltiptxt = "憎惡區", lootid = "NAXGluth" },
				dtl5  = { text = "泰迪斯", colour = AM_RED, coords = { {5, 4} }, symbol = { "4" },
						tooltiptxt = "憎惡區", lootid = "NAXThaddius", leaveGap = 1  },
				dtl6  = { text = "蜘蛛區", colour = AM_BLUE, coords = { {67, 3} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl7  = { text = "阿努比瑞克漢", colour = AM_RED, coords = { {45.2, 20} }, symbol = { "1" },
						tooltiptxt = "蜘蛛區", lootid = "NAXAnubRekhan"  },
				dtl8  = { text = "大寡婦費琳娜", colour = AM_RED, coords = { {55, 16} }, symbol = { "2" },
						tooltiptxt = "蜘蛛區", lootid = "NAXGrandWidowFaerlina"  },
				dtl9  = { text = "梅克絲娜", colour = AM_RED, coords = { {74, 5} }, symbol = { "3" },
						tooltiptxt = "蜘蛛區", lootid = "NAXMaexxna", leaveGap = 1  },
				dtl10 = { text = "瘟疫區", colour = AM_BLUE, coords = { {79, 56} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl11 = { text = "瘟疫者諾斯", colour = AM_RED, coords = { {47, 64} }, symbol = { "1" },
						tooltiptxt = "瘟疫區", lootid = "NAXNothderPlaguebringer"  },
				dtl12 = { text = "骯髒者海根", colour = AM_RED, coords = { {60, 58} }, symbol = { "2" },
						tooltiptxt = "瘟疫區", lootid = "NAXHeiganderUnclean"  },
				dtl13 = { text = "洛斯伯", colour = AM_RED, coords = { {82, 47} }, symbol = { "3" },
						tooltiptxt = "瘟疫區", lootid = "NAXLoatheb", leaveGap = 1  },
				dtl14 = { text = "死亡騎士區", colour = AM_BLUE, coords = { {15, 79} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl15 = { text = "講師拉祖維斯", colour = AM_RED, coords = { {18, 58} }, symbol = { "1" },
						tooltiptxt = "死亡騎士區", lootid = "NAXInstructorRazuvious"  },
				dtl16 = { text = "收割者高希", colour = AM_RED, coords = { {37, 64} }, symbol = { "2" },
						tooltiptxt = "死亡騎士區", lootid = "NAXGothikderHarvester" },
				dtl17 = { text = "四騎士", colour = AM_RED, coords = { {8, 75} }, symbol = { "3" },
						tooltiptxt = "死亡騎士區", lootid = "NAXTheFourHorsemen" },
				dtl18 = { text = "庫爾塔茲領主", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "瑟裡耶克爵士", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "莫格萊尼公爵", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "女公爵布勞繆克絲", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl22 = { text = "冰霜巨龍的巢穴", colour = AM_BLUE, coords = { {74, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "冰霜巨龍的巢穴"  },
				dtl23 = { text = "薩菲隆", colour = AM_RED, coords = { {87, 91} }, symbol = { "1" },
						tooltiptxt = "冰霜巨龍的巢穴", lootid = "NAXSapphiron"  },
				dtl24 = { text = "科爾蘇加德", colour = AM_RED, coords = { {75, 79} }, symbol = { "2" },
						tooltiptxt = "冰霜巨龍的巢穴", lootid = "NAXKelThuzard", leaveGap = 2  },
				dtl25 = { text = AM_TIER3_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T3SET", leaveGap = 1 },
				dtl26 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "NAXTrash", leaveGap = 1 }
			},

			{	name = "奧妮克希亞的巢穴",				-- Onyxia's Lair
				type = AM_TYP_INSTANCE,
				displayname = "奧妮克希亞的巢穴",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OnyxiasLair",
				location = "塵泥沼澤 (52, 76)",
				levels = "60+",
				players = "40",
				prereq = "需要龍火護符\n(完整的任務是在黑石塔上層殺死達基薩斯將軍)",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 12} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "奧妮克希亞守衛", colour = AM_RED, coords = { {26, 41}, {29, 56}, {39, 68}, {50, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl62 菁英龍族" },
				dtl3  = { text = "雛龍蛋", colour = AM_RED, coords = { {45, 40}, {51, 54}, {84, 41}, {79, 54} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "奧妮克希亞", colour = AM_RED, coords = { {66, 27} }, symbol = { "3" },
						tooltiptxt = "首領 龍族", lootid = "Onyxia", leaveGap = 1 }
			},

			{	name = "怒焰裂谷",			-- Ragefire Chasm
				type = AM_TYP_INSTANCE,
				displayname = "怒焰裂谷",
				displayshort = "RFC",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RagefireChasm",			-- RagefireChasm
				location = "奧格瑪",
				levels = "13-18",
				players = "10",
				general = "",
				dtl1  = { text = "入口", colour = AM_GREEN, coords = { {72, 4} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "瑪爾·恐怖圖騰", colour = AM_GOLD, coords = { {71, 53} }, symbol = { "1" },
						tooltiptxt = "'歸還背包'任務"  },
				dtl3  = { text = "饑餓者塔拉加曼", colour = AM_RED, coords = { {34, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl16 菁英惡魔", lootid = "RFCTaragaman" },
				dtl4  = { text = "祈求者耶戈什", colour = AM_RED, coords = { {24, 86} }, symbol = { "3" },
						tooltiptxt = "Lvl16 菁英人形怪", lootid = "RFCJergosh" },
				dtl5  = { text = "巴紮蘭", colour = AM_RED, coords = { {36, 91} }, symbol = { "4" },
						tooltiptxt = "Lvl16 菁英惡魔", leaveGap = 1  }

			},

			{	name = "剃刀高地",			-- Razorfen Downs
				type = AM_TYP_INSTANCE,
				displayname = "剃刀高地",
				displayshort = "RFD",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenDowns",
				location = "南貧瘠之地 (48, 88)",
				levels = "38-43",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {4, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {77, 45} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "圖特卡什", colour = AM_RED, coords = { {52, 36} }, symbol = { "1" },
						tooltiptxt = "Lvl40 菁英不死族", lootid = "RFDTutenkash" },
				dtl4  = { text = "銅鑼以叫出圖特卡什", colour = AM_GREEN, coords = { {54, 30} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "亨利‧斯特恩,\n貝尼斯特拉茲", colour = AM_BLUE, coords = { {76, 27} }, symbol = { "3" },
						tooltiptxt = "學會如何製造 :\n金棘茶, \n超強食人妖之血藥水"  },
				dtl6  = { text = "火眼莫德雷斯", colour = AM_RED, coords = { {87, 47} }, symbol = { "4" },
						tooltiptxt = "Lvl39 菁英不死族", lootid = "RFDMordreshFireEye"  },
				dtl7  = { text = "暴食者", colour = AM_RED, coords = { {19, 65} }, symbol = { "5" },
						tooltiptxt = "Lvl40 菁英人形怪", lootid = "RFDGlutton"  },
				dtl8  = { text = "拉戈斯諾特", colour = AM_RED, coords = { {41, 67} }, symbol = { "6" },
						tooltiptxt = "Lvl40 菁英人形怪", special = AM_RARE, lootid = "RFDRagglesnout"  },
				dtl9  = { text = "寒冰之王亞門納爾", colour = AM_RED, coords = { {33, 59} }, symbol = { "0" },
						tooltiptxt = "Lvl41 菁英不死族", lootid = "RFDAmnennar", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFDTrash", leaveGap = 1 }
			},

			{	name = "剃刀沼澤",			-- Razorfen Kraul
				type = AM_TYP_INSTANCE,
				displayname = "剃刀沼澤",
				displayshort = "RFK",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenKraul",
				location = "貧瘠之地 (42, 86)",
				levels = "28-33",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 71} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "魯古格", colour = AM_RED, coords = { {73, 44} }, symbol = { "1" },
						tooltiptxt = "Lvl28 菁英人形怪" },
				dtl3  = { text = "阿格姆", colour = AM_RED, coords = { {88, 48} }, symbol = { "2" },
						tooltiptxt = "Lvl30 菁英人形怪" },
				dtl4  = { text = "亡語者賈格巴", colour = AM_RED, coords = { {93, 38} }, symbol = { "3" },
						tooltiptxt = "Lvl30 菁英人形怪", lootid = "RFKDeathSpeakerJargba" },
				dtl5  = { text = "主宰拉姆塔斯", colour = AM_RED, coords = { {60, 29} }, symbol = { "4" },
						tooltiptxt = "Lvl32 菁英人形怪", lootid = "RFKOverlordRamtusk"  },
				dtl6 = { text = "喚地者哈穆加", colour = AM_RED, coords = { {49, 37} }, symbol = { "5" },
						tooltiptxt = "Lvl32 菁英人形怪", special = AM_RARE, lootid = "RFKEarthcallerHalmgar"  },
				dtl7 = { text = "進口商威利克斯,\n赫爾拉斯‧靜水", colour = AM_BLUE, coords = { {35, 33} }, symbol = { "6" },
						tooltiptxt = ""  },
				dtl8  = { text = "卡爾加‧刺肋", colour = AM_RED, coords = { {21, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl33 菁英人形怪", lootid = "RFKCharlgaRazorflank"  },
				dtl9  = { text = "盲眼獵手", colour = AM_RED, coords = { {6, 32} }, symbol = { "8" },
						tooltiptxt = "Lvl32 菁英野獸\n& Chest", special = AM_RARE, lootid = "RFKBlindHunter"  },
				dtl10  = { text = "Ward Sealing Agathelos", colour = AM_GREEN, coords = { {4, 54} }, symbol = { "9" },
						tooltiptxt = ""  },
				dtl11  = { text = "暴怒的阿迦賽羅斯", colour = AM_RED, coords = { {11, 65} }, symbol = { "10" },
						tooltiptxt = "Lvl33 菁英野獸", lootid = "RFKAgathelos", leaveGap = 1  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFKTrash", leaveGap = 1 }
			},

			{	name = "安其拉廢墟",		-- Ruins of Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "安其拉廢墟",
				displayshort = "AQ20",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RuinsofAhnQiraj",		-- RuinsofAhnQiraj
				location = "希利蘇斯 (29, 96)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {64, 2} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "庫林納克斯", colour = AM_RED, coords = { {55, 29} }, symbol = { "1" },
						tooltiptxt = "首領 & 菁英", lootid = "AQ20Kurinnaxx" },
				dtl3  = { text ="安多洛夫中將,\n四個卡多雷精英", colour = AM_RED, coords = { {55, 29} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20Andorov" },
				dtl4  = { text = "奎茲上尉", colour = AM_RED, coords = { {52.1, 46.9} }, symbol = { "2" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN" },
				dtl5  = { text = "圖畢德上尉", colour = AM_RED, coords = { {55.4, 46.9} }, symbol = { "3" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN" },
				dtl6  = { text = "德蘭上尉", colour = AM_RED, coords = { {57.2, 47.9} }, symbol = { "4" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN"  },
				dtl7  = { text = "瑟瑞姆上尉", colour = AM_RED, coords = { {59.2, 49.2} }, symbol = { "5" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN"  },
				dtl8  = { text = "葉吉斯少校", colour = AM_RED, coords = { {61.3, 50.3} }, symbol = { "6" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN"  },
				dtl9  = { text = "帕康少校", colour = AM_RED, coords = { {60, 53.4} }, symbol = { "7" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN"  },
				dtl10  = { text = "澤朗上校", colour = AM_RED, coords = { {56, 51.2} }, symbol = { "8" },
						tooltiptxt = "Lvl63 菁英", lootid = "AQ20CAPTIAN"  },
				dtl11 = { text = "拉賈克斯將軍", colour = AM_RED, coords = { {52.2, 49.5} }, symbol = { "9" },
						tooltiptxt = "首領", lootid = "AQ20Rajaxx"  },
				dtl12 = { text = "莫阿姆", colour = AM_RED, coords = { {13, 31} }, symbol = { "10" },
						tooltiptxt = "首領", lootid = "AQ20Moam"  },
				dtl13 = { text = "吞咽者布魯", colour = AM_RED, coords = { {83, 55} }, symbol = { "11" },
						tooltiptxt = "首領", lootid = "AQ20Buru"  },
				dtl14 = { text = "安全的房間", colour = AM_GREEN, coords = { {65, 70} }, symbol = { "12" },
						tooltiptxt = ""  },
				dtl15 = { text = "狩獵者阿亞米斯", colour = AM_RED, coords = { {67, 91} }, symbol = { "13" },
						tooltiptxt = "首領", lootid = "AQ20Ayamiss"  },
				dtl16 = { text = "無疤者奧斯里安", colour = AM_RED, coords = { {29, 73} }, symbol = { "14" },
						tooltiptxt = "首領", lootid = "AQ20Ossirian", leaveGap = 2  },
				dtl17 = { text = "職業書籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20ClassBooks" },
				dtl18 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants" },
				dtl19 = { text = "AQ20"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20SET", leaveGap = 1 }
			},

			{	name = "血色修道院",			-- Scarlet Monastery
				type = AM_TYP_INSTANCE,
				displayname = "血色修道院",
				displayshort = "SM",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ScarletMonastery",
				location = "提里斯法林地 (83.6, 34)",
				levels = "30-40",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "墓地入口", colour = AM_GREEN, coords = { {61, 97} }, symbol = { "G" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl2  = { text = "鐵脊死靈", colour = AM_RED, coords = { {21, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl33 菁英不死族\n墓地", special = AM_RARE, lootid = "SMIronspine"  },
				dtl3  = { text = "永醒的艾希爾", colour = AM_RED, coords = { {5, 88} }, symbol = { "2" },
						tooltiptxt = "Lvl33 菁英不死族\n墓地", special = AM_RARE, lootid = "SMAzshir"  },
				dtl4  = { text = "死靈勇士", colour = AM_RED, coords = { {8, 80} }, symbol = { "3" },
						tooltiptxt = "Lvl33 菁英不死族\n墓地", special = AM_RARE, lootid = "SMFallenChampion" },
				dtl5  = { text = "血法師薩爾諾斯", colour = AM_RED, coords = { {5, 77} }, symbol = { "4" },
						tooltiptxt = "Lvl34 菁英不死族\n墓地", lootid = "SMBloodmageThalnos" },
				dtl6  = { text = "圖書館入口", colour = AM_GREEN, coords = { {56, 74} }, symbol = { "L" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl7  = { text = "馴犬者洛克希", colour = AM_RED, coords = { {66.1, 95} }, symbol = { "5" },
						tooltiptxt = "Lvl34 菁英人形怪\n圖書館", lootid = "SMHoundmasterLoksey"  },
				dtl8  = { text = "奧法師杜安", colour = AM_RED, coords = { {95.1, 92} }, symbol = { "6" },
						tooltiptxt = "Lvl37 菁英人形怪\n圖書館", lootid = "SMDoan", leaveGap = 1  },
				dtl9  = { text = "軍械庫入口", colour = AM_GREEN, coords = { {54, 65} }, symbol = { "A" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl10 = { text = "赫洛德", colour = AM_RED, coords = { {74.8, 6.2} }, symbol = { "7" },
						tooltiptxt = "Lvl40 菁英人形怪\n軍械庫", lootid = "SMHerod", leaveGap = 1  },
				dtl11 = { text = "大教堂入口", colour = AM_GREEN, coords = { {37, 65} }, symbol = { "C" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl12 = { text = "大檢察官法爾班克斯", colour = AM_RED, coords = { {31, 11} }, symbol = { "8" },
						tooltiptxt = "Lvl40 菁英人形怪\n大教堂", lootid = "SMFairbanks"  },
				dtl13 = { text = "血色十字軍指揮官莫格萊尼", colour = AM_RED, coords = { {23.4, 12} }, symbol = { "9" },
						tooltiptxt = "Lvl42 菁英人形怪\n大教堂", lootid = "SMMograine"  },
				dtl14 = { text = "大檢察官懷特邁恩", colour = AM_RED, coords = { {23.4, 4.4} }, symbol = { "10" },
						tooltiptxt = "Lvl42 菁英人形怪\n大教堂", lootid = "SMWhitemane", leaveGap = 2  },
				dtl15 = { text = "套裝 : 血色十字軍系列", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "6 件", lootid = "SMScarletSET", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "SMTrash", leaveGap = 1 }
			},

			{	name = "安其拉",			-- Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "安其拉神廟",
				displayshort = "AQ40",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TempleofAhnQiraj",		-- TempleofAhnQiraj
				location = "希利蘇斯 (29, 96)",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {16, 37} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "亞雷戈斯\n凱雷斯特拉茲\n夢境之龍麥琳瑟拉", colour = AM_BLUE, coords = { {21, 56} }, symbol = { "A" },
						tooltiptxt = ""  },
				dtl3  = { text = "安多葛斯\n溫瑟拉\n坎多斯特拉茲", colour = AM_BLUE, coords = { {27, 43} }, symbol = { "B" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "預言者斯克拉姆", colour = AM_RED, coords = { {19, 41} }, symbol = { "1" },
						tooltiptxt = "首領\n戶外", lootid = "AQ40Skeram" },
				dtl5  = { text = "維姆/克里勳爵/亞爾基公主", colour = AM_RED, coords = { {15, 52} }, symbol = { "2" },
						tooltiptxt = "首領", special = AM_OPTIONAL, lootid = "AQ40Vem" },
				dtl6  = { text = "沙爾圖拉", colour = AM_RED, coords = { {40, 30} }, symbol = { "3" },
						tooltiptxt = "首領", lootid = "AQ40Sartura" },
				dtl7  = { text = "頑強的范克里斯", colour = AM_RED, coords = { {67, 14} }, symbol = { "4" },
						tooltiptxt = "首領", lootid = "AQ40Fankriss"  },
				dtl8  = { text = "維希度斯", colour = AM_RED, coords = { {82, 7} }, symbol = { "5" },
						tooltiptxt = "首領", special = AM_OPTIONAL, lootid = "AQ40Viscidus"  },
				dtl9  = { text = "哈霍蘭公主", colour = AM_RED, coords = { {41, 49} }, symbol = { "6" },
						tooltiptxt = "首領", lootid = "AQ40Huhuran"  },
				dtl10 = { text = "雙子帝王", colour = AM_RED, coords = { {72, 67} }, symbol = { "7" },
						tooltiptxt = "首領\n維克尼拉斯大帝\n維克洛爾大帝", lootid = "AQ40Emperors"  },
				dtl11 = { text = "奧羅", colour = AM_RED, coords = { { 22, 87 } }, symbol = { "8" },
						tooltiptxt = "首領", special = AM_OPTIONAL, lootid = "AQ40Ouro" },
				dtl12 = { text = "克蘇恩之眼", colour = AM_RED, coords = { {25, 50} }, symbol = { "9" },
						tooltiptxt = "", lootid = "AQ40CThun" },
				dtl13 = { text = "克蘇恩", colour = AM_RED, coords = { {25, 50} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40CThun", leaveGap = 2 },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40Trash", leaveGap = 1 },
				dtl15 = { text = "AQ40 "..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40SET", leaveGap = 1 },
				dtl16 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants", leaveGap = 1 },
				dtl17 = { text = "AQ Brood Rings", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQBroodRings", leaveGap = 1 },
				dtl18 = { text = AM_OPENING, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQOpening", leaveGap = 1 }
			},

			{	name = "死亡礦井",			-- The Deadmines
				type = AM_TYP_INSTANCE,
				displayname = "死亡礦井",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheDeadmines",
				location = "西部荒野 (42, 72)",
				levels = "16-26",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "死亡礦井"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {99, 42} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {80, 40} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "拉克佐", colour = AM_RED, coords = { {21, 58} }, symbol = { "1" },
						tooltiptxt = "Lvl19 菁英人形怪", lootid = "VCRhahkZor" },
				dtl5  = { text = "礦工約翰森", colour = AM_RED, coords = { {41, 50} }, symbol = { "2" },
						tooltiptxt = "Lvl19 菁英人形怪", lootid = "VCMinerJohnson", special = AM_RARE  },
				dtl6  = { text = "斯尼德", colour = AM_RED, coords = { {37, 77} }, symbol = { "3" },
						tooltiptxt = "Lvl20 菁英機器人 (伐木機上)", lootid = "VCSneed"  },
				dtl7  = { text = "基爾尼格", colour = AM_RED, coords = { {48.8, 60.2} }, symbol = { "4" },
						tooltiptxt = "Lvl20 菁英人形怪", lootid = "VCGilnid"  },
				dtl8  = { text = "迪菲亞火藥", colour = AM_GREEN, coords = { {55.6, 39} }, symbol = { "5" },
						tooltiptxt = "...火藥用於炸開大門"  },
				dtl9  = { text = "重拳先生", colour = AM_RED, coords = { {76, 31} }, symbol = { "6" },
						tooltiptxt = "Lvl20 菁英人形怪", lootid = "VCMrSmite"  },
				dtl10 = { text = "曲奇", colour = AM_RED, coords = { {81, 36} }, symbol = { "7" },
						tooltiptxt = "", lootid = "VCCookie"  },
				dtl11 = { text = "綠皮隊長", colour = AM_RED, coords = { {76, 37} }, symbol = { "8" },
						tooltiptxt = "Lvl21 菁英人形怪", lootid = "VCCaptainGreenskin"  },
				dtl12 = { text = "艾德溫‧范克里夫", colour = AM_RED, coords = { {79, 37} }, symbol = { "9" },
						tooltiptxt = "Lvl21 菁英人形怪", lootid = "VCVanCleef", leaveGap = 2 },
				dtl13 = { text = "套裝 : 迪菲亞皮甲", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "5 件", lootid = "VCDefiasSET", leaveGap = 1 }
			},

			{	name = "監獄",			-- The Stockade
				type = AM_TYP_INSTANCE,
				displayname = "監獄",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheStockade",
				location = "暴風城",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {69, 60}, {75, 40}, {26, 57}, {31, 36}, {18, 29} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "可怕的塔高爾", colour = AM_RED, coords = { {58, 63}, {41, 55}, {50, 37}, {27, 50} }, symbol = { "1" },
						tooltiptxt = "Lvl24 菁英人形怪", special = AM_VARIES },
				dtl4  = { text = "卡姆‧深怒", colour = AM_RED, coords = { {73, 43} }, symbol = { "2" },
						tooltiptxt = "Lvl27 菁英人形怪", lootid = "SWStKamDeepfury" },
				dtl5  = { text = "哈姆霍克", colour = AM_RED, coords = { {85, 56} }, symbol = { "3" },
						tooltiptxt = "Lvl28 菁英人形怪"  },
				dtl6  = { text = "巴基爾‧斯瑞德", colour = AM_RED, coords = { {95, 62} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl7  = { text = "迪克斯特‧瓦德", colour = AM_RED, coords = { {15, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl26 菁英人形怪"  },
				dtl8  = { text = "布魯戈‧艾爾克納寇", colour = AM_RED, coords = { {22, 54} }, symbol = { "6" },
						tooltiptxt = "Lvl26 菁英人形怪", special = AM_RARE, lootid = "SWStBruegalIronknuckle", leaveGap = 1 }
			},

			{	name = "阿塔哈卡神廟",			-- The Sunken Temple
				type = AM_TYP_INSTANCE,
				displayname = "沈沒的神廟",
				displayshort = "ST",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSunkenTemple",
				location = "悲傷沼澤 (70, 53)",
				levels = "45-60",
				players = "10",
				prereq = "",
				general = "也被稱呼為阿塔哈卡神廟",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "阿塔哈卡神廟"..AM_EXTERIOR },
				dtl2  = { text = "入口處通往高層的階梯", colour = AM_GREEN, coords = { {54, 11.3}, {13.9, 47} }, symbol = { "SL" },
						tooltiptxt = "" },
				dtl3  = { text = "入口處通往中層的階梯", colour = AM_GREEN, coords = { {69, 11.3} }, symbol = { "SM" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "通往上層的階梯", colour = AM_BLUE, coords = { {52, 18}, {69, 18}, {52, 48}, {69, 48} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "" },
				dtl5  = { text = "食人妖小首領 (上層)", colour = AM_RED, coords = { {55, 23}, {66, 23}, {72, 33}, {49, 33}, {54, 43}, {66, 43} }, symbol = { "T1", "T2", "T3", "T4", "T5", "T6" },
						tooltiptxt = "全部殺死後,然後是迦瑪蘭\n接著是伊蘭尼庫斯", lootid = "STTrollMinibosses", leaveGap = 1 },
				dtl6  = { text = "雕像 (下層)", colour = AM_ORANGE, coords = { {22, 82}, {22, 64}, {13, 77}, {30, 77}, {13, 68}, {30, 68} }, symbol = { "S1", "S2", "S3", "S4", "S5", "S6" },
						tooltiptxt = "依標示的順序啟動雕像\n以召喚阿塔拉利恩" },
				dtl7  = { text = "哈卡祭壇", colour = AM_ORANGE, coords = { {22, 74} }, symbol = { "1" },
						tooltiptxt = ""  },
				dtl8  = { text = "阿塔拉利恩", colour = AM_RED, coords = { {22, 71} }, symbol = { "2" },
						tooltiptxt = "Lvl50 菁英人形怪", lootid = "STAtalalarion", leaveGap = 1  },
				dtl9  = { text = "德姆塞卡爾", colour = AM_RED, coords = { {58, 33} }, symbol = { "3" },
						tooltiptxt = "Lvl53 菁英龍族", lootid = "STDreamscythe"  },
				dtl10 = { text = "德拉維沃爾", colour = AM_RED, coords = { {62, 33} }, symbol = { "4" },
						tooltiptxt = "Lvl51 菁英龍族", lootid = "STWeaver"  },
				dtl11 = { text = "哈卡的化身", colour = AM_RED, coords = { {32, 33} }, symbol = { "5" },
						tooltiptxt = "Lvl50 菁英龍", lootid = "STAvatarofHakkar"  },
				dtl12 = { text = "預言者迦瑪蘭", colour = AM_RED, coords = { {88, 27} }, symbol = { "6" },
						tooltiptxt = "Lvl54 菁英人形怪", lootid = "STJammalan"  },
				dtl13 = { text = "可悲的奧戈姆", colour = AM_RED, coords = { {88, 31} }, symbol = { "7" },
						tooltiptxt = "Lvl53 菁英不死族", lootid = "STOgom"  },
				dtl14 = { text = "摩弗拉斯", colour = AM_RED, coords = { {59, 62} }, symbol = { "8" },
						tooltiptxt = "Lvl52 菁英龍", lootid = "STMorphaz"  },
				dtl15 = { text = "哈札斯", colour = AM_RED, coords = { {62, 62} }, symbol = { "9" },
						tooltiptxt = "Lvl53 菁英龍", lootid = "STHazzas"  },
				dtl16 = { text = "伊蘭尼庫斯的陰影", colour = AM_RED, coords = { {80, 62} }, symbol = { "10" },
						tooltiptxt = "Lvl55 菁英龍", lootid = "STEranikus"  },
				dtl17 = { text = "精華之泉", colour = AM_ORANGE, coords = { {85, 57} }, symbol = { "11" },
						tooltiptxt = "把伊蘭尼庫斯精華放在精華之泉裡", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "STTrash", leaveGap = 1 }
			},

			{	name = "奧達曼",			-- Uldaman
				type = AM_TYP_INSTANCE,
				displayname = "奧達曼",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Uldaman",
				location = "荒蕪之地 (44, 12)",
				levels = "35-50",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "正門入口", colour = AM_GREEN, coords = { {89, 73.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奧達曼"..AM_EXTERIOR },
				dtl2  = { text = "後門入口", colour = AM_GREEN, coords = { {21, 71} }, symbol = { "XR" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "巴爾洛戈", colour = AM_RED, coords = { {73, 93} }, symbol = { "1" },
						tooltiptxt = "Lvl41 Elite" },
				dtl4  = { text = "聖騎士的遺體", colour = AM_ORANGE, coords = { {62.8, 63.2} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "魯維羅什", colour = AM_RED, coords = { {64, 73.3} }, symbol = { "3" },
						tooltiptxt = "Lvl40 菁英人形怪", lootid = "UldRevelosh"  },
				dtl6  = { text = "艾隆納亞", colour = AM_RED, coords = { {38, 75} }, symbol = { "4" },
						tooltiptxt = "首領 Giant", lootid = "UldIronaya"  },
				dtl7  = { text = "安諾拉 (大師級附魔師)", colour = AM_BLUE, coords = { {56, 61} }, symbol = { "5" },
						tooltiptxt = ""  },
				dtl8  = { text = "黑曜石哨兵", colour = AM_RED, coords = { {24.4, 62} }, symbol = { "6" },
						tooltiptxt = "Lvl42 菁英機器人"  },
				dtl9  = { text = "古代的石頭看守者", colour = AM_RED, coords = { {54.7, 43} }, symbol = { "7" },
						tooltiptxt = "Lvl44 菁英元素怪", lootid = "UldAncientStoneKeeper"  },
				dtl10 = { text = "加加恩‧火錘", colour = AM_RED, coords = { {21, 31} }, symbol = { "8" },
						tooltiptxt = "首領 人形怪", lootid = "UldGalgannFirehammer"  },
				dtl11 = { text = "格瑞姆洛克", colour = AM_RED, coords = { {17, 19} }, symbol = { "9" },
						tooltiptxt = "Lvl45 菁英人形怪", lootid = "UldGrimlok"  },
				dtl12 = { text = "阿札達斯", colour = AM_RED, coords = { {45.2, 14.4} }, symbol = { "10" },
						tooltiptxt = "首領 巨人\n下層", lootid = "UldArchaedas"  },
				dtl13 = { text = "諾甘農圓盤", colour = AM_ORANGE, coords = { {39.7, 6.2} }, symbol = { "11" },
						tooltiptxt = "上層"  },
				dtl14 = { text = "古代寶藏", colour = AM_ORANGE, coords = { {42.3, 4.9} }, symbol = { "12" },
						tooltiptxt = "下層", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UldTrash", leaveGap = 1 }
			},

			{ 	name = "哀嚎洞穴",			-- Wailing Caverns
				type = AM_TYP_INSTANCE,
				displayname = "哀嚎洞穴",
				displayshort = "WC",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\WailingCaverns",
				location = "貧瘠之地 (46, 36)",
				levels = "16-25",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {44, 58} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "哀嚎洞穴"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {62, 47}, {94, 49} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "納拉雷克斯的信徒", colour = AM_BLUE, coords = { {45, 53} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl4  = { text = "考布萊恩", colour = AM_RED, coords = { {14, 55} }, symbol = { "2" },
						tooltiptxt = "Lvl20 菁英人形怪", lootid = "WCLordCobrahn" },
				dtl5  = { text = "安娜科德拉", colour = AM_RED, coords = { {39, 35} }, symbol = { "3" },
						tooltiptxt = "Lvl20 菁英人形怪", lootid = "WCLadyAnacondra" },
				dtl6  = { text = "克雷什", colour = AM_RED, coords = { {45, 42} }, symbol = { "4" },
						tooltiptxt = "Lvl20 菁英人形怪", lootid = "WCKresh"  },
				dtl7  = { text = "變異精靈龍", colour = AM_RED, coords = { {63, 43} }, symbol = { "5" },
						tooltiptxt = "Lvl20 菁英龍族", lootid = "WCDeviateFaerieDragon", special = AM_RARE },
				dtl8  = { text = "皮薩斯", colour = AM_RED, coords = { {86, 34} }, symbol = { "6" },
						tooltiptxt = "Lvl22 菁英人形怪", lootid = "WCLordPythas"  },
				dtl9  = { text = "斯卡姆", colour = AM_RED, coords = { {93, 69} }, symbol = { "7" },
						tooltiptxt = "Lvl21 菁英人形怪", lootid = "WCSkum"  },
				dtl10  = { text = "瑟芬迪斯", colour = AM_RED, coords = { {60, 52} }, symbol = { "8" },
						tooltiptxt = "Lvl22 菁英人形怪\n上層 level", lootid = "WCLordSerpentis"  },
				dtl11 = { text = "永生者沃爾丹", colour = AM_RED, coords = { {56, 48} }, symbol = { "9" },
						tooltiptxt = "Lvl24 菁英元素怪\n上層 level", lootid = "WCVerdan"  },
				dtl12 = { text = "吞噬者穆坦努斯", colour = AM_RED, coords = { {29.9, 23.9} }, symbol = { "10" },
						tooltiptxt = "Lvl22 菁英人形怪\nTriggered Spawn", lootid = "WCMutanus"  },
				dtl13 = { text = "納拉雷克斯", colour = AM_RED, coords = { {32.4, 25.4} }, symbol = { "11" },
						tooltiptxt = "Lvl25 菁英人形怪", leaveGap = 2  },
				dtl14 = { text = "套裝 : 毒蛇的擁抱", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "5 件", lootid = "WCViperSET", leaveGap = 1 }
			},

			{	name = "祖爾法拉克",			-- Zul'Farrak
				type = AM_TYP_INSTANCE,
				displayname = "祖爾法拉克",
				displayshort = "ZF",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulFarrak",
				location = "塔納利斯 (37, 15)",
				levels = "43-47",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {69, 89} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "澤雷利斯", colour = AM_RED, coords = { {63, 47} }, symbol = { "1" },
						tooltiptxt = "Lvl45 菁英人形怪", special = AM_RARE.." "..AM_WANDERS, lootid = "ZFZerillis" },
				dtl3  = { text = "杉達爾‧沙掠者", colour = AM_RED, coords = { {55, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl45 菁英人形怪", special = AM_RARE },
				dtl4  = { text = "水占師維蕾薩", colour = AM_RED, coords = { {34, 43} }, symbol = { "3" },
						tooltiptxt = "Lvl46 菁英人形怪" },
				dtl5  = { text = "加茲瑞拉", colour = AM_RED, coords = { {37, 46} }, symbol = { "4" },
						tooltiptxt = "Lvl46 菁英野獸", lootid = "ZFGahzrilla"  },
				dtl6  = { text = "灰塵怨靈", colour = AM_RED, coords = { {32, 46} }, symbol = { "5" },
						tooltiptxt = "Lvl45 菁英人形怪", special = AM_RARE, lootid = "ZFDustwraith"  },
				dtl7  = { text = "安圖蘇爾", colour = AM_RED, coords = { {80, 35} }, symbol = { "6" },
						tooltiptxt = "Lvl48 菁英人形怪", lootid = "ZFAntusul"  },
				dtl8  = { text = "殉教者塞卡", colour = AM_RED, coords = { {67, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl46 菁英人形怪"  },
				dtl9  = { text = "巫醫祖穆拉恩", colour = AM_RED, coords = { {53, 23} }, symbol = { "8" },
						tooltiptxt = "Lvl46 菁英人形怪", lootid = "ZFWitchDoctorZumrah"  },
				dtl10 = { text = "祖爾法拉克陣亡英雄", colour = AM_RED, coords = { {51, 27} }, symbol = { "9" },
						tooltiptxt = "Lvl46 菁英人形怪"  },
				dtl11 = { text = "暗影祭司塞瑟斯", colour = AM_RED, coords = { {36, 26} }, symbol = { "10" },
						tooltiptxt = "Lvl47 菁英人形怪", lootid = "ZFSezzziz" },
				dtl12 = { text = "耐克魯姆", colour = AM_RED, coords = { {36, 26} }, symbol = { " " },
						tooltiptxt = "Lvl46 菁英不死族"  },
				dtl13 = { text = "布萊中士", colour = AM_ORANGE, coords = { {26, 26} }, symbol = { "11" },
						tooltiptxt = "探水棒任務\n敵對/友善依陣營與採取的動作而定" },
				dtl14 = { text = "Ruuzlu", colour = AM_RED, coords = { {51, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl46 菁英人形怪"  },
				dtl15 = { text = "烏克茲‧沙頂", colour = AM_RED, coords = { {55, 42} }, symbol = { "13" },
						tooltiptxt = "Lvl48 菁英人形怪", lootid = "ZFChiefUkorzSandscalp", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZFTrash", leaveGap = 1 }
			},

			{	name = "祖爾格拉布",			-- Zul'Gurub
				type = AM_TYP_INSTANCE,
				displayname = "祖爾格拉布",
				displayshort = "ZG",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulGurub",
				location = "荊棘谷 (54, 17)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 50} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "混濁的水", colour = AM_BLUE, coords = { {33, 41}, {47, 48}, {57, 47}, {60, 32}, {47, 30} }, symbol = { "W" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "高階祭司 耶克里克", colour = AM_RED, coords = { {34, 78} }, symbol = { "1" },
						tooltiptxt = "首領 人形怪", special = "(蝙蝠王)", lootid = "ZGJeklik" },
				dtl4  = { text = "高階祭司 溫諾希斯", colour = AM_RED, coords = { {56, 57} }, symbol = { "2" },
						tooltiptxt = "首領 人形怪", special = "(蛇王)", lootid = "ZGVenoxis" },
				dtl5  = { text = "高階祭司 瑪爾羅", colour = AM_RED, coords = { {48, 85} }, symbol = { "3" },
						tooltiptxt = "首領 人形怪", special = "(蜘蛛王)", lootid = "ZGMarli"  },
				dtl6  = { text = "血領主 曼多基爾", colour = AM_RED, coords = { {76, 73} }, symbol = { "4" },
						tooltiptxt = "首領 人形怪", special = "(恐龍王)"..AM_OPTIONAL, lootid = "ZGMandokir"  },
				dtl7  = { text = "瘋狂之源", colour = AM_RED, coords = { {72, 47} }, symbol = { "5" },
						tooltiptxt = "", special = AM_OPTIONAL  },
				dtl8  = { text = "格里雷克‧鋼鐵之血", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首領 不死族", lootid = "ZGGrilek"  },
				dtl9  = { text = "哈札拉爾‧織夢者", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首領 不死族", lootid = "ZGHazzarah"  },
				dtl10 = { text = "雷納塔基‧千刃之王", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首領 不死族", lootid = "ZGRenataki"  },
				dtl11 = { text = "烏蘇雷‧雷巫", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首領 不死族", lootid = "ZGWushoolay"  },
				dtl12 = { text = "加茲蘭卡", colour = AM_RED, coords = { {66, 33} }, symbol = { "6" },
						tooltiptxt = "首領 人形怪", special = AM_OPTIONAL, lootid = "ZGGahzranka"  },
				dtl13 = { text = "高階祭司 塞卡爾", colour = AM_RED, coords = { {80, 32} }, symbol = { "7" },
						tooltiptxt = "首領 人形怪", special = "(虎王)", lootid = "ZGThekal" },
				dtl14 = { text = "高階祭司 婭爾羅", colour = AM_RED, coords = { {49, 16} }, symbol = { "8" },
						tooltiptxt = "首領 人形怪", special = "(豹王)", lootid = "ZGArlokk"  },
				dtl15 = { text = "妖術師 金度", colour = AM_RED, coords = { {20, 18} }, symbol = { "9" },
						tooltiptxt = "首領 人形怪", special = "(瘟疫之神)"..AM_OPTIONAL, lootid = "ZGJindo" },
				dtl16 = { text = "哈卡", colour = AM_RED, coords = { {54, 40} }, symbol = { "10" },
						tooltiptxt = "首領 龍", lootid = "ZGHakkar", leaveGap = 2 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGTrash", leaveGap = 1 },
				dtl18 = { text = "ZG"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGSET", leaveGap = 1 },
				dtl19 = { text = AM_RBOSS_DROP, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGShared", leaveGap = 1 },
				dtl20 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGEnchants", leaveGap = 1 }
			},

			{	name = "通靈學院",			-- Scholomance
				type = AM_TYP_INSTANCE,
				displayname = "通靈學院",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Scholomance",		-- Scholomance*
				location = "西瘟疫之地 (69, 73)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {24, 30} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {28, 38} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {6.5, 22}, {62, 22} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl4  = {text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {41, 41}, {34, 80} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "基爾圖諾斯的衛士", colour = AM_RED, coords = { {54, 32} }, symbol = { "1" },
						tooltiptxt = "Lvl61 菁英惡魔", lootid = "SCHOLOBloodSteward"  },
				dtl6  = { text = "傳令官基爾圖諾斯", colour = AM_RED, coords = { {30, 5} }, symbol = { "2" },
						tooltiptxt = "", lootid = "SCHOLOKirtonostheHerald" },
				dtl7  = { text = "詹迪斯‧巴羅夫", colour = AM_RED, coords = { {96, 8.5} }, symbol = { "3" },
						tooltiptxt = "Lvl61 菁英不死族", lootid = "SCHOLOJandiceBarov"  },
				dtl8  = { text = "血骨傀儡", colour = AM_RED, coords = { {10, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl61 菁英不死族\n下層\n會掉落觀察室鑰匙", lootid = "SCHOLORattlegore"  },
				dtl9  = { text = "死亡騎士達克雷爾", colour = AM_RED, coords = { {10, 41} }, symbol = { " " },
						tooltiptxt = "Lvl62 菁英不死族", lootid = "SCHOLODeathKnight" },
				dtl10  = { text = "馬杜克‧布萊克波爾", colour = AM_BLUE, coords = { {23.7, 42} }, symbol = { "5" },
						tooltiptxt = "Lvl58 菁英\n在觀察室放下黎明先鋒的箱子後\n會轉為敵對", lootid = "SCHOLOMarduk"  },
				dtl11 = { text = "維克圖斯", colour = AM_BLUE, coords = { {27.2, 42} }, symbol = { "6" },
						tooltiptxt = "Lvl60 菁英不死族\n在觀察室放下黎明先鋒的箱子後\n會轉為敵對", lootid = "SCHOLOVectus"  },
				dtl12 = { text = "萊斯‧霜語", colour = AM_RED, coords = { {18, 87} }, symbol = { "8" },
						tooltiptxt = "Lvl62 菁英不死族", lootid = "SCHOLORasFrostwhisper"  },
				dtl13 = { text = "科爾莫克", colour = AM_RED, coords = { {18, 80} }, symbol = { "9" },
						tooltiptxt = "Lvl60 菁英", lootid = "SCHOLOKormok" },
				dtl14 = { text = "講師瑪麗希亞", colour = AM_RED, coords = { {44.5, 94} }, symbol = { "10" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "SCHOLOInstructorMalicia"  },
				dtl15 = { text = "瑟爾林‧卡斯迪諾夫教授", colour = AM_RED, coords = { {64, 74.2} }, symbol = { "11" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "SCHOLODoctorTheolenKrastinov"  },
				dtl16 = { text = "博學者普克爾特", colour = AM_RED, coords = { {44.8, 55.2} }, symbol = { "12" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "SCHOLOLorekeeperPolkelt"  },
				dtl17 = { text = "拉文尼亞", colour = AM_RED, coords = { {75.8, 92} }, symbol = { "13" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "SCHOLOTheRavenian"  },
				dtl18 = { text = "阿萊克斯‧巴羅夫", colour = AM_RED, coords = { {96.2, 74.5} }, symbol = { "14" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "SCHOLOLordAlexeiBarov"  },
				dtl19 = { text = "伊露希亞‧巴羅夫", colour = AM_RED, coords = { {75.6, 54} }, symbol = { "15" },
						tooltiptxt = "Lvl60 菁英不死族", lootid = "SCHOLOLadyIlluciaBarov" },
				dtl20 = { text = "黑暗院長加丁", colour = AM_RED, coords = { {76.2, 74.4} }, symbol = { "16" },
						tooltiptxt = "Lvl61 菁英人形怪", lootid = "SCHOLODarkmasterGandling", leaveGap = 1 },
				dtl21 = { text = "火炬", colour = AM_GREEN, coords = { {89, 19} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl22 = { text = "煉金實驗室", colour = AM_GREEN, coords = { {14, 70} }, symbol = { "AL" },
						tooltiptxt = "", leaveGap = 1 },
				dtl23 = { text = "南海鎮地契", colour = AM_ORANGE, coords = { {56, 25} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl24 = { text = "塔倫米爾地契", colour = AM_ORANGE, coords = { {11, 36} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl25 = { text = "布瑞爾地契", colour = AM_ORANGE, coords = { {15, 77} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl26 = { text = "凱爾達隆地契", colour = AM_ORANGE, coords = { {94, 72} }, symbol = { "D" },
						tooltiptxt = "", leaveGap = 1},
			},

			{	name = "斯坦索姆",			-- Stratholme
				type = AM_TYP_INSTANCE,
				displayname = "斯坦索姆",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Stratholme",
				location = "東瘟疫之地 (30, 12)",
				levels = "55-60",
				players = "5",
				prereq = "",
				general = "側門入口在 (47, 24)",
				dtl1  = { text = "正門入口", colour = AM_GREEN, coords = { {50, 91} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "側門入口", colour = AM_GREEN, coords = { {83, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "弗拉斯‧希亞比的郵箱", colour = AM_ORANGE, coords = { {37, 86} }, symbol = { "P1" },
						tooltiptxt = "" },
				dtl4  = { text = "國王廣場郵箱", colour = AM_ORANGE, coords = { {47, 74} }, symbol = { "P2" },
						tooltiptxt = "" },
				dtl5  = { text = "十字軍廣場郵箱", colour = AM_ORANGE, coords = { {24, 66} }, symbol = { "P3" },
						tooltiptxt = "" },
				dtl6  = { text = "市場郵箱", colour = AM_ORANGE, coords = { {50, 62} }, symbol = { "P4" },
						tooltiptxt = ""  },
				dtl7  = { text = "節日小道的郵箱", colour = AM_ORANGE, coords = { {61, 62} }, symbol = { "P5" },
						tooltiptxt = ""  },
				dtl8  = { text = "長者廣場郵箱", colour = AM_ORANGE, coords = { {80, 68} }, symbol = { "P6" },
						tooltiptxt = "" },
				dtl9 = { text = "郵差瑪羅恩", colour = AM_RED, coords = { {37, 86}, {47, 74}, {24, 66}, {50, 62}, {61, 62}, {80, 68} }, symbol = { " " },
						tooltiptxt = "Lvl60 菁英不死族\n在打開第三個郵箱時出現\n郵箱鑰匙從信差身上拾取", leaveGap = 1 },
				dtl10 = { text = "斯庫爾", colour = AM_RED, coords = { {42, 83} }, symbol = { "1" },
						tooltiptxt = "Lvl58 菁英不死族", special = AM_RARE.." "..AM_WANDERS, lootid = "STRATSkull" },
				dtl11 = { text = "斯坦索姆信差", colour = AM_RED, coords = { {43, 78} }, symbol = { "2" },
						tooltiptxt = "Lvl57 菁英不死族", lootid = "STRATStratholmeCourier"  },
				dtl12 = { text = "弗拉斯‧希亞比", colour = AM_RED, coords = { {39, 83} }, symbol = { "3" },
						tooltiptxt = "Lvl61 菁英不死族", lootid = "STRATFrasSiabi"  },
				dtl13 = { text = "弗雷斯特恩", colour = AM_RED, coords = { {45, 62}, {65, 58}, {66, 66} }, symbol = { "4" },
						tooltiptxt = "Lvl57 菁英不死族", special = AM_VARIES, lootid = "STRATHearthsingerForresten" },
				dtl14 = { text = "不可寬恕者", colour = AM_RED, coords = { {56, 57} }, symbol = { "5" },
						tooltiptxt = "Lvl57 菁英不死族", lootid = "STRATTheUnforgiven"  },
				dtl15 = { text = "悲慘的提米", colour = AM_RED, coords = { {26, 61.5} }, symbol = { "6" },
						tooltiptxt = "Lvl58 菁英不死族", lootid = "STRATTimmytheCruel"  },
				dtl16 = { text = "炮手威利", colour = AM_RED, coords = { {1, 74} }, symbol = { "7" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "STRATCannonMasterWilley"  },
				dtl17 = { text = "檔案管理員加爾福特", colour = AM_RED, coords = { {24, 92} }, symbol = { "8" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "STRATArchivistGalford"  },
				dtl18 = { text = "巴納札爾", colour = AM_RED, coords = { {17, 97} }, symbol = { "9" },
						tooltiptxt = "Lvl62 菁英惡魔", lootid = "STRATBalnazzar"  },
				dtl19 = { text = "索索斯", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "需要召喚火盆", lootid = "STRATSothosJarien" },
				dtl20 = { text = "賈琳", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "需要召喚火盆", lootid = "STRATSothosJarien" },
				dtl21 = { text = "奧裏克斯", colour = AM_BLUE, coords = { {81, 61} }, symbol = { "10" },
						tooltiptxt = ""  },
				dtl22 = { text = "石脊", colour = AM_RED, coords = { {78, 42} }, symbol = { "11" },
						tooltiptxt = "Lvl60 菁英人形怪", special = AM_RARE, lootid = "STRATStonespine"  },
				dtl23 = { text = "安娜絲塔麗男爵夫人", colour = AM_RED, coords = { {90, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl59 菁英人形怪", lootid = "STRATBaronessAnastari"  },
				dtl24 = { text = "奈魯布恩坎", colour = AM_RED, coords = { {64, 39} }, symbol = { "13" },
						tooltiptxt = "Lvl60 菁英人形怪", lootid = "STRATNerubenkan"  },
				dtl25 = { text = "蒼白的瑪勒基", colour = AM_RED, coords = { {81, 14} }, symbol = { "14" },
						tooltiptxt = "Lvl61 菁英人形怪", lootid = "STRATMalekithePallid"  },
				dtl26 = { text = "巴瑟拉斯鎮長", colour = AM_RED, coords = { {66, 10}, {74, 60} }, symbol = { "15" },
						tooltiptxt = "Lvl58 菁英人形怪", special = AM_VARIES, lootid = "STRATMagistrateBarthilas" },
				dtl27 = { text = "吞咽者拉姆斯登", colour = AM_RED, coords = { {56, 15} }, symbol = { "16" },
						tooltiptxt = "Lvl61 菁英人形怪", lootid = "STRATRamsteintheGorger"  },
				dtl28 = { text = "瑞文戴爾男爵", colour = AM_RED, coords = { {42, 15} }, symbol = { "17" },
						tooltiptxt = "Lvl62 菁英人形怪", lootid = "STRATBaronRivendare", leaveGap = 1 }
			},

			{	name = "影牙城堡",			-- Shadowfang Keep
				type = AM_TYP_INSTANCE,
				displayname = "影牙城堡",
				displayshort = "SFK",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowfangKeep",
				location = "銀松森林 (45, 67)",
				levels = "20-30",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 69} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {57, 57}, {36, 55}, {29, 12} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = "城垛", colour = AM_BLUE, coords = { {38, 71}, {54, 93} }, symbol = { "B1" },
						tooltiptxt = "" },
				dtl4  = {text = "城垛", colour = AM_BLUE, coords = { {69, 85}, {35, 37} }, symbol = { "B2" },
						tooltiptxt = "" },
				dtl5  = { text = "死亡之誓", colour = AM_RED, coords = { {69, 85}, {35, 37} }, symbol = { " " },
						tooltiptxt = "Lvl25 菁英不死族", special = AM_RARE  },
				dtl6  = { text = "階梯", colour = AM_GREEN, coords = { {29.8, 34.8}, {50, 46.8} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl7  = { text = "階梯", colour = AM_GREEN, coords = { {42, 32}, {67, 33} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "雷希戈爾", colour = AM_RED, coords = { {70, 78} }, symbol = { "1" },
						tooltiptxt = "Lvl20 菁英人形怪" },
				dtl9  = { text = "巫師阿克魯比", colour = AM_RED, coords = { {67, 73} }, symbol = { "2" },
						tooltiptxt = "Lvl18 菁英人形怪"  },
				dtl10 = { text = "亡靈哨兵阿達曼特", colour = AM_RED, coords = { {71, 74} }, symbol = { "3" },
						tooltiptxt = "Lvl18 菁英人形怪"  },
				dtl11 = { text = "屠夫拉佐克勞", colour = AM_RED, coords = { {25, 59} }, symbol = { "4" },
						tooltiptxt = "Lvl22 菁英人形怪", lootid = "BSFRazorclawtheButcher"  },
				dtl12 = { text = "席瓦萊恩男爵", colour = AM_RED, coords = { {13, 87} }, symbol = { "5" },
						tooltiptxt = "Lvl24 菁英不死族", lootid = "BSFSilverlaine" },
				dtl13 = { text = "指揮官斯普林瓦爾", colour = AM_RED, coords = { {26, 69} }, symbol = { "6" },
						tooltiptxt = "Lvl24 菁英不死族", lootid = "BSFSpringvale"  },
				dtl14 = { text = "盲眼守衛奧杜", colour = AM_RED, coords = { {61, 84} }, symbol = { "7" },
						tooltiptxt = "Lvl24 菁英人形怪", lootid = "BSFOdotheBlindwatcher"  },
				dtl15 = { text = "吞噬者芬魯斯", colour = AM_RED, coords = { {53.4, 33.4} }, symbol = { "8" },
						tooltiptxt = "Lvl25 菁英野獸", lootid = "BSFFenrustheDevourer"  },
				dtl16 = { text = "狼王南杜斯", colour = AM_RED, coords = { {80, 29} }, symbol = { "9" },
						tooltiptxt = "Lvl25 菁英人形怪", lootid = "BSFWolfMasterNandos"  },
				dtl17 = { text = "大法師阿魯高", colour = AM_RED, coords = { {84, 13} }, symbol = { "10" },
						tooltiptxt = "Lvl26 菁英人形怪", lootid = "BSFArchmageArugal", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BSFTrash", leaveGap = 1 }
			},

			{	name = "地獄火堡壘: 地獄火壁壘",		-- Hellfire Ramparts
				type = AM_TYP_INSTANCE,
				displayname = "地獄火堡壘: 地獄火壁壘",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCRampart",			-- HellfireRampart
				location = "地獄火堡壘, 地獄火半島",
				levels = "60-62",
				players = "20",
				prereq = "鑰匙: 火鑄之鑰 (英雄模式)",
				general = "聲望: 索爾瑪 (部落)\n聲望: 榮譽堡 (聯盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 63} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "看護者卡爾古瑪", colour = AM_RED, coords = { {80, 24} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "HCRampWatchkeeper" },
				dtl3  = { text = "無疤者歐瑪爾", colour = AM_RED, coords = { {22, 14} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCRampOmor" },
				dtl4  = { text = "先驅者維斯路登", colour = AM_RED, coords = { {16, 81} }, symbol = { "3" },
						tooltiptxt = "Kill both hellfire sentry to start encounter", lootid = "HCRampVazruden" },
				dtl5  = { text = "納桑", colour = AM_RED, coords = { {16, 81} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampNazan", leaveGap = 1 },
				dtl6  = { text = "強化惡魔鐵箱", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampFelIronChest", leaveGap = 1 }
			},
	
			{	name = "地獄火堡壘: 血熔爐",		-- The Blood Furnace
				type = AM_TYP_INSTANCE,
				displayname = "地獄火堡壘: 血熔爐",
				displayshort = "BF",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCBloodFurnace",		-- HCBloodFurnace
				location = "地獄火堡壘, 地獄火半島",
				levels = "61-63",
				players = "20",
				prereq = "鑰匙: 火鑄之鑰 (英雄模式)",
				general = "聲望: 索爾瑪 (部落)\n聲望: 榮譽堡 (聯盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 91.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "創造者", colour = AM_RED, coords = { {29.3, 35} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCFurnaceMaker" },
				dtl3  = { text = "布洛克", colour = AM_RED, coords = { {41, 13.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCFurnaceBroggok" },
				dtl4  = { text = "破壞者·凱利丹", colour = AM_RED, coords = { {65.6, 35.2} }, symbol = { "3" },
						tooltiptxt = "", lootid = "HCFurnaceBreaker", leaveGap = 1 }
			},

			{	name = "地獄火堡壘: 破碎大廳",		-- Shattered Halls
				type = AM_TYP_INSTANCE,
				displayname = "地獄火堡壘: 破碎大廳",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCShatteredHalls",		-- HCShatteredHalls
				location = "地獄火堡壘, 地獄火半島",
				levels = "70-72",
				players = "20",
				prereq = "鑰匙: 火鑄之鑰 (英雄模式)",
				general = "聲望: 索爾瑪 (部落)\n聲望: 榮譽堡 (聯盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {67, 97.66} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "藍迪·威索洛克", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { "1" },
						tooltiptxt = "", special = "(聯盟, 英雄)" },
				dtl3  = { text = "崔賽拉", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄)" },
				dtl4  = { text = "大術士·奈德克斯", colour = AM_RED, coords = { {23.63, 66.02} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCHallsNethekurse" },
				dtl5  = { text = "血衛士波洛克", colour = AM_RED, coords = { {15.23, 10.55} }, symbol = { "3" },
						tooltiptxt = "", special = "(英雄)", lootid = "HCHallsPorung" },
				dtl6  = { text = "戰爭製造者·歐姆拉格", colour = AM_RED, coords = { {57.42, 33.79} }, symbol = { "4" },
						tooltiptxt = "", lootid = "HCHallsOmrogg" },
				dtl7  = { text = "大酋長卡加斯·刃拳", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { "5" },
						tooltiptxt = "", lootid = "HCHallsKargath" },
				dtl8  = { text = "破碎之手劊子手", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(英雄)", lootid = "HCHallsExecutioner" },
				dtl9  = { text = "士兵賈辛特", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(聯盟, 英雄)" },
				dtl10 = { text = "槍兵伯朗畢爾", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(聯盟, 英雄)" },
				dtl11 = { text = "隊長阿蓮娜", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(聯盟, 英雄)" },
				dtl12 = { text = "斥候歐卡爾", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄)" },
				dtl13 = { text = "科洛特·波特曼", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄)" },
				dtl14 = { text = "隊長碎骨", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄)", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }
			},
	
			{	name = "地獄火堡壘: 瑪瑟里頓的巢穴",		-- Magtheridon's Lair
				type = AM_TYP_INSTANCE,
				displayname = "地獄火堡壘: 瑪瑟里頓的巢穴",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagtheridonsLair",		-- MagtheridonsLair
				location = "地獄火堡壘, 地獄火半島",
				levels = "70",
				players = "40",
				prereq = "鑰匙: 火鑄之鑰 (英雄模式)",
				general = "聲望: 索爾瑪 (部落)\n聲望: 榮譽堡 (聯盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.44, 14.26} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "瑪瑟里頓", colour = AM_PURPLE, coords = { {53.13, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCMagtheridon", leaveGap = 1 },
				dtl3  = { text = AM_TIER4_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T4SET", leaveGap = 1 }
			},
	
			{	name = "盤牙洞穴: 奴隸監獄",		-- The Slave Pens
				type = AM_TYP_INSTANCE,
				displayname = "盤牙洞穴: 奴隸監獄",
				displayshort = "SP",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSlavePens",		-- TheSlavePens
				location = "盤牙洞穴, 贊格沼澤",
				levels = "62-64",
				players = "20",
				prereq = "聲望: 塞納里奧遠征隊",
				general = "鑰匙: 倉庫之鑰 (英雄模式)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.24, 21.29} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盤牙洞穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "背叛者曼紐", colour = AM_RED, coords = { {48.83, 31.84} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSlaveMennu" },
				dtl3  = { text = "威德·綠指", colour = AM_RED, coords = { {48.83, 71.29} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "異教徒司卡利斯", colour = AM_RED, coords = { {58.2, 72.66} }, symbol = { "3" },
						tooltiptxt = "", special = "(英雄模式)" },
				dtl5  = { text = "爆破者洛克瑪", colour = AM_RED, coords = { {57.81, 41.99} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSlaveRokmar" },
				dtl6  = { text = "博物學家·拜特", colour = AM_RED, coords = { {96.09, 61.13} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl7  = { text = "奎克米瑞", colour = AM_RED, coords = { {80.86, 72.27} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSlaveQuagmirran" }

			},

			{	name = "盤牙洞穴: 毒牙沼澤",			-- The Underbog
				type = AM_TYP_INSTANCE,
				displayname = "盤牙洞穴: 毒牙沼澤",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheUnderbog",		-- TheUnderbog
				location = "盤牙洞穴, 贊格沼澤",
				levels = "63-65",
				players = "20",
				prereq = "鑰匙: 倉庫之鑰 (英雄模式)",
				general = "聲望: 塞納里奧遠征隊",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {120, 346} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盤牙洞穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "飢餓之牙", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRUnderHungarfen" },
				dtl3  = { text = "地孢", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "高薩安", colour = AM_RED, coords = { {81.84, 34.18} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRUnderGhazan" },
				dtl5  = { text = "大地束縛者瑞吉", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl6  = { text = "喚風者卡勞", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "沼澤王莫斯萊克", colour = AM_RED, coords = { {39.84, 30.27} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRUnderSwamplord" },
				dtl8  = { text = "黑色捕獵者", colour = AM_RED, coords = { {21.09, 45.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRUnderStalker", leaveGap = 1 }
			},

			{	name = "盤牙洞穴: 蒸汽洞窟",			-- The Steamvault
				type = AM_TYP_INSTANCE,
				displayname = "盤牙洞穴: 蒸汽洞窟",
				displayshort = "SV",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSteamvault",			-- The Steamvault
				location = "盤牙洞穴, 贊格沼澤",
				levels = "70-72",
				players = "20",
				prereq = "鑰匙: 倉庫之鑰 (英雄模式)",
				general = "聲望: 塞納里奧遠征隊",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 35.74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盤牙洞穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "海法師希斯比亞", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { "1" },
						tooltiptxt = "Elite Lvl 72", lootid = "CFRSteamThespia" },
				dtl3  = { text = "主房間通道面板", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "第二部守衛者", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSteamSecondFragmentGuardian" },
				dtl5  = { text = "秘法容器", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = "米克吉勒·蒸氣操控者", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSteamSteamrigger" },
				dtl7  = { text = "主房間通道面板", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "督軍卡利斯瑞", colour = AM_RED, coords = { {92.19, 43.95} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSteamWarlord" },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }
			},
	
			{	name = "盤牙洞穴: 毒蛇神殿洞穴",			-- SerpentShrine Cavern
				type = AM_TYP_INSTANCE,
				displayname = "盤牙洞穴: 毒蛇神殿洞穴",
				displayshort = "SC",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SerpentShrine",			-- SerpentshrineCavern
				location = "盤牙洞穴, 贊格沼澤",
				levels = "70",
				players = "40",
				prereq = "",
				general = "聲望: 塞納里奧遠征隊",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 67.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盤牙洞穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "不穩定者海卓司", colour = AM_RED, coords = { {37.89, 75} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSerpentHydross" },
				dtl3  = { text = "海底潛伏者", colour = AM_RED, coords = { {40.82, 54.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSerpentLurker" },
				dtl4  = { text = "盲目者李奧薩拉斯", colour = AM_RED, coords = { {43.75, 27.15} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSerpentLeotheras" },
				dtl5  = { text = "深淵之王卡拉薩瑞斯", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSerpentKarathress" },
				dtl6  = { text = "先知歐蘭", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "莫洛葛利姆·潮行者", colour = AM_RED, coords = { {66.02, 28.52} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRSerpentMorogrim" },
				dtl8  = { text = "瓦許女士", colour = AM_RED, coords = { {81.64, 55.47} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSerpentVashj", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSerpentTrash" }
			},
	
			{	name = "奧齊頓: 奧奇奈地穴",			-- Auchenai Crypts
				type = AM_TYP_INSTANCE,
				displayname = "奧齊頓: 奧奇奈地穴",
				displayshort = "AC",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\AuchenaiCrypts",			-- AuchenaiCrypts
				location = "奧齊頓, 白骨荒野",
				levels = "64-66",
				players = "20",
				prereq = "鑰匙: 奧奇奈鑰匙 (英雄模式)",
				general = "聲望: 陰鬱城",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {22, 79.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奧齊頓"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "死亡看守者辛瑞克", colour = AM_RED, coords = { {44, 70} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchCryptsShirrak" },
				dtl3  = { text = "主教瑪拉達爾", colour = AM_RED, coords = { {88, 49} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchCryptsExarch" },
				dtl4  = { text = "馬丁瑞德的化身", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsAvatar" },
				dtl5  = { text = "迪歐瑞", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsTrash" }
			},
	
			{	name = "奧齊頓: 暗影迷宮",			-- Shadow Labyrinth
				type = AM_TYP_INSTANCE,
				displayname = "奧齊頓: 暗影迷宮",
				displayshort = "SL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowLabyrinth",			-- ShadowLabyrinth
				location = "奧齊頓, 白骨荒野",
				levels = "65-67",
				players = "20",
				prereq = "鑰匙: 暗影迷宮鑰匙\n鑰匙: 奧奇奈鑰匙 (英雄模式)",
				general = "聲望: 陰鬱城",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {6, 8.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奧齊頓"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "間諜·吐剛", colour = AM_RED, coords = { {14, 44} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl3  = { text = "海爾瑪大使", colour = AM_RED, coords = { {14, 44} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchShadowHellmaw" },
				dtl4  = { text = "激勵者布萊克哈特", colour = AM_RED, coords = { {20, 73} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchShadowBlackheart" },
				dtl5  = { text = "領導者瓦皮歐", colour = AM_RED, coords = { {55, 59} }, symbol = { "4" },
						tooltiptxt = "血之聖典", lootid = "AuchShadowGrandmaster" },
				dtl6  = { text = "莫爾墨", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchShadowMurmur" },
				dtl7  = { text = "第一部守衛者", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "6" },
						tooltiptxt = "", lootid = "AuchShadowFirstFragmentGuardian" },
				dtl8  = { text = "秘法容器", colour = AM_RED, coords = { {90.38, 37.7} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchShadowTrash" }
			},

			{	name = "奧齊頓: 塞司克大廳",				-- Sethekk Halls
				type = AM_TYP_INSTANCE,
				displayname = "奧齊頓: 塞司克大廳",
				displayshort = "SH",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SethekkHalls",			-- SethekkHalls
				location = "奧齊頓, 白骨荒野",
				levels = "67-69",
				players = "20",
				prereq = "鑰匙: 奧奇奈鑰匙 (英雄模式)\n鑰匙: 注滿精華的月亮石 (安祖)",
				general = "聲望: 陰鬱城",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {98, 46} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奧齊頓"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "暗法師希斯", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchSethekkDarkweaver" },
				dtl3  = { text = "拉卡", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "泰洛克的傳說", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchSethekkTheSagaofTerokk" },
				dtl5  = { text = "安祖", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkRavenGod", special = "(召喚, 英雄模式)" },
				dtl6  = { text = "鷹王伊奇斯", colour = AM_RED, coords = { {20, 18.5} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchSethekkTalonKing", leaveGap = 1 },
				dtl7 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkTrash" }
			},
	
			{	name = "奧齊頓: 法力墓地",				-- Mana Tombs
				type = AM_TYP_INSTANCE,
				displayname = "奧齊頓: 法力墓地",
				displayshort = "MT",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ManaTombs",				-- ManaTombs
				location = "奧齊頓, 白骨荒野",
				levels = "70-72",
				players = "40",
				prereq = "鑰匙: 奧奇奈鑰匙 (英雄模式)\n鑰匙: 哈拉瑪德之眼 (崇拜, 約兒)",
				general = "聲望: 聯合團",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 4.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奧齊頓"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "班提蒙尼厄斯", colour = AM_RED, coords = { {46, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchManaPandemonius" },
				dtl3  = { text = "暗影之王希瑞西斯", colour = AM_RED, coords = { {46, 30} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "帕克西維大使", colour = AM_RED, coords = { {71.29, 16.41} }, symbol = { "2" },
						tooltiptxt = "", special = "(英雄)" },
				dtl5  = { text = "塔瓦洛克", colour = AM_RED, coords = { {71, 76} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchManaTavarok" },
				dtl6  = { text = "工程師薩希恩", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl7  = { text = "虛空傳送者控制面板", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "奈薩斯王子薩法爾", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchManaNexusPrince" },
				dtl9  = { text = "約兒", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { " " },
						tooltiptxt = "靜止密室", special = "(召喚, 英雄)", lootid = "AuchManaYor", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchManaTrash" }
			},

			{	name = "戈魯爾之巢",				-- Gruul's Lair
				type = AM_TYP_INSTANCE,
				displayname = "戈魯爾之巢",
				displayshort = "GL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\GruulsLair",			-- GruulsLair
				location = "劍刃山脈",
				levels = "70",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "大君王莫卡爾", colour = AM_RED, coords = { {55, 48} }, symbol = { "1" },
						tooltiptxt = "Boss", lootid = "GruulsLairHighKingMaulgar" },
				dtl3  = { text = "瘋癲者奇克勒", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(薩滿)" },
				dtl4  = { text = "克羅斯·火手", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(法師)" },
				dtl5  = { text = "先知盲眼", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(牧師)" },
				dtl6  = { text = "召喚者歐莫", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(術士)" },
				dtl7  = { text = "弒龍者戈魯爾", colour = AM_RED, coords = { {20, 27} }, symbol = { "2" },
						tooltiptxt = "", lootid = "GruulGruul", leaveGap = 1 },
			},
	
			{	name = "黑暗神廟",				-- Black Temple
				type = AM_TYP_INSTANCE,
				displayname = "黑暗神廟",
				displayshort = "BT",
				continent = 3,
--				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Placeholder",
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackTemple",			-- BlackTemple
				location = "影月谷",
				levels = "70",
				players = "40",
				prereq = "需完成傳送門/鑰匙前置任務\n鑰匙: 卡拉伯爾獎章",
				general = "聲望: 灰舌死亡誓言者",
				dtl1  = { text = "黑暗神廟 - 開始", colour = AM_ORANGE, coords = { {5.27, 32.03} }, symbol = { "-" },
						tooltiptxt = "" },
				dtl2  = { text = "黑暗神廟 - 上層", colour = AM_ORANGE, coords = { {49.61, 5.66} }, symbol = { "^" },
						tooltiptxt = "" },
				dtl3  = { text = "黑暗神廟 - 地下室", colour = AM_ORANGE, coords = { {63.87, 60.74} }, symbol = { "v" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {7.62, 77.34} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
	            dtl5  = { text = "歐蘭的靈魂", colour = AM_BLUE, coords = { {7.23, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "BTNajentus" },
	            dtl6  = { text = "高階督軍納珍塔斯", colour = AM_RED, coords = { {24.8, 56.25} }, symbol = { "2" },
						tooltiptxt = "", lootid = "BTNajentus" },
				dtl7  = { text = "瑟普莫斯", colour = AM_RED, coords = { {21.29, 45.12} }, symbol = { "3" },
						tooltiptxt = "", lootid = "BTSupremus" },
	            dtl8  = { text = "阿卡瑪的黑暗面", colour = AM_RED, coords = { {33.59, 63.09} }, symbol = { "4" },
						tooltiptxt = "", lootid = "BTAkama" },
	            dtl9  = { text = "烏達羅之靈", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { "5" },
						tooltiptxt = "" },
	            dtl10 = { text = "阿魯焰", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(卷軸商人)" },
	            dtl11 = { text = "歐庫諾", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(灰舌死亡誓言者)" },
	            dtl12 = { text = "先知卡奈", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl13 = { text = "通往泰朗·血魔", colour = AM_GREEN, coords = { {48.83, 51.76}, {79.1, 78.32} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl14 = { text = "通往靈魂聖盒", colour = AM_GREEN, coords = { {48.83, 37.5}, {84.18, 67.38} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl15 = { text = "通往伊利丹·怒風", colour = AM_GREEN, coords = { {23.83, 33.2}, {58.2, 10.74} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl16  = { text = "葛塔格·血沸", colour = AM_RED, coords = { {75.59, 57.23} }, symbol = { "6" },
						tooltiptxt = "", lootid = "BTBloodboil" },
				dtl17 = { text = "靈魂聖盒", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { "7" },
						tooltiptxt = "", lootid = "BTEssencofSouls" },
				dtl18 = { text = "憤怒精華", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "慾望精華", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "受難精華", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "泰朗·血魔", colour = AM_RED, coords = { {59.77, 81.45} }, symbol = { "8" },
						tooltiptxt = "", lootid = "BTGorefiend" },
				dtl22 = { text = "薩拉茲女士", colour = AM_RED, coords = { {92.77, 4.88} }, symbol = { "9" },
						tooltiptxt = "", lootid = "BTShahraz" },
				dtl23 = { text = "伊利達瑞議事", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { "10" },
						tooltiptxt = "", lootid = "BTCouncil" },
				dtl24 = { text = "瑪蘭黛女士", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(牧師)" },
				dtl25 = { text = "粉碎者高希歐", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(聖騎士)" },
				dtl26 = { text = "高等虛空術師札瑞佛", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(法師)" },
				dtl27 = { text = "維拉斯·深影", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(盜賊)" },
	            dtl28  = { text = "伊利丹·怒風", colour = AM_RED, coords = { {59.18, 36.13} }, symbol = { "11" },
						tooltiptxt = "", lootid = "BTIllidanStormrage", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTPatterns" },
				dtl30 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTTrash" }
			},

			{	name = "風暴要塞: 麥克那爾",				-- The Mechanar
				type = AM_TYP_INSTANCE,
				displayname = "風暴要塞: 麥克那爾",
				displayshort = "Mech",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Mechanar",			-- TheMechanar
				location = "風暴要塞, 虛空風暴",
				levels = "69-72",
				players = "20",
				prereq = "鑰匙: 扭曲鍛造鑰匙 (英雄模式)",
				general = "聲望: 薩塔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {43, 92.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "看守者蓋洛奇歐", colour = AM_RED, coords = { {46, 56} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKMechGyro" },
				dtl3  = { text = "看守者鐵手", colour = AM_RED, coords = { {64.5, 52} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKMechIron" },
				dtl4  = { text = "軍團儲藏處", colour = AM_RED, coords = { {64.5, 52} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechCacheoftheLegion" },
				dtl5  = { text = "機械王卡帕希特斯", colour = AM_RED, coords = { {58, 37} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKMechCapacitus" },
				dtl6  = { text = "滿溢的法力容器", colour = AM_RED, coords = { {58, 37} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechOverchargedManacell" },
				dtl7  = { text = "虛空術師賽派斯瑞", colour = AM_RED, coords = { {47, 9.9} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKMechSepethrea" },
				dtl8  = { text = "計算者帕薩里歐", colour = AM_RED, coords = { {18.5, 47} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKMechCalc", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechTrash" }
			},

			{	name = "風暴要塞: 波塔尼卡",				-- The Botanica
				type = AM_TYP_INSTANCE,
				displayname = "風暴要塞: 波塔尼卡",
				displayshort = "Bota",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Botanica",			-- TheBotanica
				location = "風暴要塞, 虛空風暴",
				levels = "70-72",
				players = "40",
				prereq = "鑰匙: 扭曲鍛造鑰匙 (英雄模式)",
				general = "聲望: 薩塔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {96.2, 44.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "指揮官薩瑞尼斯", colour = AM_RED, coords = { {45, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKBotSarannis" },
				dtl3  = { text = "大植物學家費瑞衛恩", colour = AM_RED, coords = { {24, 30} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKBotFreywinn" },
				dtl4  = { text = "看管者索古林", colour = AM_RED, coords = { {9, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKBotThorngrin" },
				dtl5  = { text = "拉杰", colour = AM_RED, coords = { {35, 69} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKBotLaj" },
				dtl6  = { text = "扭曲分裂者", colour = AM_RED, coords = { {34.5, 40} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKBotSplinter", leaveGap = 1 },
				dtl7  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKBotTrash" }
			},
	
			{	name = "風暴要塞: 亞克崔茲",				-- The Arcatraz
				type = AM_TYP_INSTANCE,
				displayname = "風暴要塞: 亞克崔茲",
				displayshort = "Arca",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Arcatraz",			-- TheArcatraz
				location = "風暴要塞, 虛空風暴",
				levels = "70-72",
				players = "40",
				prereq = "鑰匙: 亞克崔茲鑰匙\n鑰匙: 扭曲鍛造鑰匙 (英雄模式)",
				general = "聲望: 薩塔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {38, 98} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "無約束的希瑞奇斯", colour = AM_RED, coords = { {45.5, 58.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKArcUnbound" },
				dtl3  = { text = "第三部守衛者", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKArcThirdFragmentGuardian" },
				dtl4  = { text = "秘法容器", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { " " },
						tooltiptxt = "" },
				dtl5  = { text = "怒鐮者索扣斯瑞特", colour = AM_RED, coords = { {11.5, 70} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKArcScryer" },
				dtl6  = { text = "末日預言者達利亞", colour = AM_RED, coords = { {31, 70} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKArcDalliah" },
				dtl7  = { text = "先知烏達羅", colour = AM_RED, coords = { {37.89, 15.04} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl8  = { text = "先驅者史蓋力司", colour = AM_RED, coords = { {73.5, 17} }, symbol = { "6" },
						tooltiptxt = "", lootid = "TKArcHarbinger" },
				dtl9  = { text = "守望者米利恰爾", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl10 = { text = "米歐浩斯·曼納斯頓", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKArcTrash" }
			},

			{	name = "時光之穴: 希爾斯布萊德丘陵舊址",				-- Old Hilsbrad
				type = AM_TYP_INSTANCE,
				displayname = "時光之穴: 希爾斯布萊德丘陵舊址",
				displayshort = "CoT1",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OldHilsbrad",			-- OldHilsbrad
				location = "時光之穴, 塔納利斯",
				levels = "",
				players = "",
				prereq = "需完成傳送門鑰匙前置任務\n鑰匙: 時光之鑰 (英雄模式)",
				general = "事件: 逃離敦霍爾德\n聲望: 時光守衛者",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {13, 47} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "時光之穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "伊洛森", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl3  = { text = "布瑞茲恩", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "中尉崔克", colour = AM_RED, coords = { {83, 64.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CoTHillsbradDrake" },
				dtl5  = { text = "索爾", colour = AM_BLUE, coords = { {79.49, 57.23} }, symbol = { "2" },
						tooltiptxt = "(下層)", lootid = "CoTHillsbradDrake" },
				dtl6  = { text = "史卡拉克上尉", colour = AM_RED, coords = { {72, 68} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CoTHillsbradSkarloc" },
				dtl7  = { text = "索爾的第二停留點", colour = AM_BLUE, coords = { {72, 68} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "索爾的第三停留點", colour = AM_BLUE, coords = { {47.07, 41.41} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl9  = { text = "伊波奇獵人", colour = AM_RED, coords = { {44.5, 30.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CoTHillsbradHunter" },
				dtl10 = { text = "索爾的第四停留點", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(屋內樓上)" },
				dtl11 = { text = "塔蕾莎", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(屋內樓上)" },
				dtl12 = { text = "強納森·瑞瓦", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { "6" },
						tooltiptxt = "" },
				dtl13 = { text = "傑瑞·卡特", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "湯瑪斯·陽斯", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "7" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradThomasYance" },
				dtl15 = { text = "年邁的達拉然法師", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "8" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradAgedDalaranWizard", leaveGap = 1 }
			},

			{	name = "時光之穴: 黑色沼澤",				-- The Black Morass
				type = AM_TYP_INSTANCE,
				displayname = "時光之穴: 黑色沼澤",
				displayshort = "CoT2",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackMorass",			-- The Black Morass
				location = "時光之穴, 塔納利斯",
				levels = "",
				players = "",
				prereq = "需完成傳送門/鑰匙前置任務\n鑰匙: 時光之鑰 (英雄模式)",
				general = "事件: 開啟黑暗之門\n聲望: 時光守衛者",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45.4, 22} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "時光之穴"..AM_EXTERIOR, special = "塞特", leaveGap = 1 },
				dtl2  = { text = "生成點", colour = AM_RED, coords = { {58, 70}, {58.5, 61.5}, {41, 60.5}, {48, 52.5} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "克洛諾斯領主迪賈", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第六波)", lootid = "CoTMorassDeja" },
				dtl4  = { text = "坦普拉斯", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第十二波)", lootid = "CoTMorassTemporus" },
				dtl5  = { text = "艾奧那斯", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第十八波)", lootid = "CoTMorassAeonus", leaveGap = 1 },
				dtl5  = { text = "黑暗之門", colour = AM_BLUE, coords = { {44.14, 74.22} }, symbol = { "1" },
						tooltiptxt = "", special = "麥迪文" },
			},

			{	name = "時光之穴: 海加爾山",			-- Battle for Mount Hyjal
				type = AM_TYP_INSTANCE,
				displayname = "時光之穴: 海加爾山",
				displayshort = "CoT3",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MountHyjal",			-- Battle for Mount Hyjal
				location = "時光之穴, 塔納利斯",
				levels = "70",
				players = "25",
				prereq = "需完成傳送門/鑰匙前置任務",
				general = "事件: 海加爾山戰場\n聲望: 流沙之鱗",
				dtl1  = { text = "聯盟營地", colour = AM_GREEN, coords = { {18.36, 48.83} }, symbol = { "A" },
						tooltiptxt = "", toMap = "時光之穴"..AM_EXTERIOR, special = "(珍娜·普勞德摩爾女士)" },
				dtl2  = { text = "部落營地", colour = AM_GREEN, coords = { {57.23, 35.74} }, symbol = { "B" },
						tooltiptxt = "", special = "(索爾)" },
				dtl3  = { text = "夜精靈營地", colour = AM_GREEN, coords = { {75.39, 44.34} }, symbol = { "C" },
						tooltiptxt = "", special = "(泰蘭妲·語風)", leaveGap = 1 },
	            dtl4  = { text = "瑞奇·寒冬", colour = AM_RED, coords = { {21.48, 46.88} }, symbol = { "1" },
						tooltiptxt = "", lootid = "MountHyjalWinterchill" },
				dtl5  = { text = "安納斯隆", colour = AM_RED, coords = { {21.48, 50.98} }, symbol = { "2" },
						tooltiptxt = "", lootid = "MountHyjalAnetheron" },
				dtl6  = { text = "卡斯羅高", colour = AM_RED, coords = { {58.98, 32.81} }, symbol = { "3" },
						tooltiptxt = "", lootid = "MountHyjalKazrogal" },
				dtl7  = { text = "埃加洛爾", colour = AM_RED, coords = { {58.98, 38.67} }, symbol = { "4" },
						tooltiptxt = "", lootid = "MountHyjalAzgalor" },
	            dtl8  = { text = "阿克蒙德", colour = AM_RED, coords = { {83.01, 31.25} }, symbol = { "5" },
						tooltiptxt = "", lootid = "MountHyjalArchimonde" },
--				dtl9 = { text = "隱多米", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "", lootid = "MountHyjalArchimonde" },
--				dtl10 = { text = "提多姆", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "", lootid = "MountHyjalArchimonde" },
			},

			{	name = "卡拉贊",					-- Karazahn
				type = AM_TYP_INSTANCE,
				displayname = "卡拉贊",
				displayshort = "Kara",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Karazahn",				-- Karazahn
				location = "逆風小徑",
				levels = "70",
				players = "10",
				prereq = "需完成傳送門/鑰匙前置任務\n鑰匙: 主人鑰匙\n鑰匙: 燻黑的骨灰甕 (夜禍)",
				general = "聲望: 紫羅蘭之眼",
				dtl1  = { text = "前方入口 1", colour = AM_GREEN, coords = { {29.88, 31.45} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉贊"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "前方入口 2", colour = AM_GREEN, coords = { {28.13, 20.31} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉贊"..AM_EXTERIOR, leaveGap = 1 },
				dtl3  = { text = "哈斯丁", colour = AM_BLUE, coords = { {27.93, 25.39} }, symbol = { "a" },
						tooltiptxt = "" },
				dtl4  = { text = "勃特霍德", colour = AM_BLUE, coords = { {23.05, 25.98} }, symbol = { "b" },
						tooltiptxt = "" },
				dtl5  = { text = "摩洛", colour = AM_RED, coords = { {23.05, 25.98}, {65.23, 23.24} }, symbol = { "1" },
						tooltiptxt = "", special = "(通往舞廳的樓梯間)", lootid = "KaraMoroes" },
				dtl6  = { text = "卡利卡", colour = AM_BLUE, coords = { {23.44, 33.4} }, symbol = { "c" },
						tooltiptxt = "" },
				dtl7  = { text = "獵人阿圖曼", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { "2" },
						tooltiptxt = "", lootid = "KaraAttumen" },
				dtl8  = { text = "午夜", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9  = { text = "卡爾侖", colour = AM_BLUE, coords = { {16.02, 30.47} }, symbol = { "d" },
						tooltiptxt = "" },
				dtl10 = { text = "通往上層的樓梯", colour = AM_GREEN, coords = { {18.55, 37.5} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl11 = { text = "班尼特", colour = AM_BLUE, coords = { {19.53, 35.55} }, symbol = { "e" },
						tooltiptxt = "", special = "上層" },
				dtl12 = { text = "埃伯洛克", colour = AM_BLUE, coords = { {74.8, 36.52} }, symbol = { "f" },
						tooltiptxt = "" },
				dtl13 = { text = "", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl14 = { text = "潛伏者亞奇斯", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 隨機)", lootid = "KaraNamed" },
				dtl15 = { text = "劫掠者·拉卡", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 隨機)", lootid = "KaraNamed" },
				dtl16 = { text = "滑翔者·薛迪依斯", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 隨機)", lootid = "KaraNamed", leaveGap = 1 },
				dtl17 = { text = "通往迎賓廳斜坡", colour = AM_GREEN, coords = { {17.77, 3.32}, {73.24, 10.16} }, symbol = { "P" },
						tooltiptxt = "", },
				dtl18 = { text = "琪安娜的日誌", colour = AM_ORANGE, coords = { {82.52, 4.69} }, symbol = { "3" },
						tooltiptxt = "", lootid = "KaraKeannaLog" },
				dtl19 = { text = "貞潔聖女", colour = AM_RED, coords = { {92.38, 16.21} }, symbol = { "4" },
						tooltiptxt = "", lootid = "KaraMaiden" },
				dtl20 = { text = "通往歌劇院樂團層的樓梯", colour = AM_GREEN, coords = { {84.18, 15.04} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl21 = { text = "塞巴斯汀", colour = AM_BLUE, coords = { {55.08, 18.55} }, symbol = { "g" },
						tooltiptxt = "" },
				dtl22 = { text = "巴奈斯", colour = AM_BLUE, coords = { {51.95, 10.35} }, symbol = { "h" },
						tooltiptxt = "" },
				dtl23 = { text = "歌劇事件", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { "O" },
						tooltiptxt = "隨機", lootid = "KaraOperaEvent" },
				dtl24 = { text = "綠野仙蹤", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(隨機)", lootid = "KaraOperaEvent" },
				dtl25 = { text = "小紅帽", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(隨機)", lootid = "KaraOperaEvent" },
				dtl26 = { text = "羅密歐與茱莉葉", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(隨機)", lootid = "KaraOperaEvent" },
				dtl27 = { text = "夾層至包廂的斜坡", colour = AM_GREEN, coords = { {62.11, 8.79} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl28 = { text = "大師的露台", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl29 = { text = "夜禍", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Summoned)", lootid = "KaraOperaEvent" },
				dtl30 = { text = "通往損壞的階梯", colour = AM_GREEN, coords = { {30.66, 24.02} }, symbol = { "P" },
						tooltiptxt = "", special = "(上層)" },
				dtl31 = { text = "損壞的階梯", colour = AM_GREEN, coords = { {18.36, 24.41} }, symbol = { "P" },
						tooltiptxt = "", special = "(上層)" },
				dtl32 = { text = "館長", colour = AM_RED, coords = { {10.16, 35.16} }, symbol = { "5" },
						tooltiptxt = "", lootid = "KaraCurator" },
				dtl33 = { text = "通往:", colour = AM_GREEN, coords = { {13.67, 44.92}, {30.47, 68.55} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl34 = { text = "瑞依恩", colour = AM_BLUE, coords = { {23.24, 69.73} }, symbol = { "i" },
						tooltiptxt = "" },
				dtl35 = { text = "葛瑞戴", colour = AM_BLUE, coords = { {17.97, 69.34} }, symbol = { "j" },
						tooltiptxt = "" },
				dtl36 = { text = "坎希斯", colour = AM_BLUE, coords = { {16.41, 73.83} }, symbol = { "k" },
						tooltiptxt = "" },
				dtl37 = { text = "通往管理員圖書館的斜坡", colour = AM_GREEN, coords = { {19.92, 76.56} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl38 = { text = "神秘的書架", colour = AM_GREEN, coords = { {20.51, 66.6} }, symbol = { "P" },
						tooltiptxt = "(-> 通往泰瑞斯提安·疫蹄)" },
				dtl39 = { text = "泰瑞斯提安·疫蹄", colour = AM_RED, coords = { {17.19, 72.85} }, symbol = { "6" },
						tooltiptxt = "基瑞克", lootid = "KaraIllhoof" },
				dtl40 = { text = "艾蘭之影", colour = AM_RED, coords = { {33.2, 66.21} }, symbol = { "7" },
						tooltiptxt = "", lootid = "KaraAran" },
				dtl41 = { text = "通往天文觀測台的斜坡", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(尼德斯)" },
				dtl42 = { text = "通往投機者大廳的斜坡", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(西洋棋事件)" },
				dtl43 = { text = "尼德斯", colour = AM_RED, coords = { {9.38, 65.82} }, symbol = { "8" },
						tooltiptxt = "", lootid = "KaraNetherspite" },
				dtl44 = { text = "伊斯亞爾", colour = AM_GREEN, coords = { {27.15, 66.21} }, symbol = { "l" },
						tooltiptxt = "" },
				dtl45 = { text = "通往:", colour = AM_GREEN, coords = { {26.76, 63.48}, {62.5, 39.84} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl46 = { text = "麥迪文的回音", colour = AM_BLUE, coords = { {65.04, 37.5} }, symbol = { "k" },
						tooltiptxt = "" },
				dtl47 = { text = "西洋棋事件", colour = AM_RED, coords = { {67.58, 34.96} }, symbol = { "9" },
						tooltiptxt = "", lootid = "KaraChess" },
				dtl48 = { text = "通往麥迪文房間的斜坡", colour = AM_GREEN, coords = { {63.09, 29.88} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl49 = { text = "通往虛空空間的螺旋梯", colour = AM_GREEN, coords = { {81.64, 32.62} }, symbol = { "P" },
						tooltiptxt = "", special = "(莫克札王子)" },
				dtl50 = { text = "莫克札王子", colour = AM_RED, coords = { {76.37, 31.05} }, symbol = { "10" },
						tooltiptxt = "", special = "Leads to...", lootid = "KaraPrince" },
			},

			{	name = "祖阿曼",				-- Zul'Aman
				type = AM_TYP_INSTANCE,
				displayname = "祖阿曼",
				displayshort = "ZA",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulAman",				-- Zul'Aman
				location = "鬼魂之地",
				levels = "70",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 53} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "納羅拉克", colour = AM_RED, coords = { {36.3, 71.9} }, symbol = { "1" },
						tooltiptxt = "", special = "(熊)", lootid = "ZANalorakk" },
				dtl3  = { text = "阿奇爾森", colour = AM_RED, coords = { {31.25, 31.25} }, symbol = { "2" },
						tooltiptxt = "", special = "(鷹)", lootid = "ZAAkilZon" },
				dtl4  = { text = "賈納雷", colour = AM_RED, coords = { {53.3, 67.2} }, symbol = { "3" },
						tooltiptxt = "", special = "(龍鷹)", lootid = "ZAJanAlai" },
				dtl5  = { text = "哈拉齊", colour = AM_RED, coords = { {56.05, 36.62} }, symbol = { "4" },
						tooltiptxt = "", special = "(山貓)", lootid = "ZAHalazzi" },
				dtl6  = { text = "妖術領主瑪拉克雷斯", colour = AM_RED, coords = { {68.75, 54.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "ZAMalacrass" },
				dtl7  = { text = "祖爾金", colour = AM_RED, coords = { {91.4, 54.7} }, symbol = { "6" },
						tooltiptxt = "", lootid = "ZAZuljin", leaveGap = 1 },
			},

			{	name = "風暴要塞",				-- The Eye
				type = AM_TYP_INSTANCE,
				displayname = "風暴要塞: 風暴要塞",
				displayshort = "Eye",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheEye",			-- TheEye
				location = "風暴要塞, 虛空風暴",
				levels = "69-72",
				players = "5",
				prereq = "鑰匙: 風暴之鑰",
				general = "聲望: 薩塔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "歐爾", colour = AM_RED, coords = { {50, 57} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKEyeAlar" },
				dtl3  = { text = "虛空劫掠者", colour = AM_RED, coords = { {14, 47} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKEyeVoidReaver" },
				dtl4  = { text = "大星術師索拉瑞恩", colour = AM_RED, coords = { {86, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKEyeSolarian" },
				dtl5  = { text = "凱爾薩斯·日行者", colour = AM_RED, coords = { {50, 13} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKEyeKaelthas" },
				dtl6  = { text = "扭曲預言家薩拉瑞德", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(戰士)" },
				dtl7  = { text = "首席技師泰隆尼卡斯", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(獵人)" },
				dtl8  = { text = "大星術師卡普尼恩", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", speical = "(法師)" },
				dtl9  = { text = "桑古納爾", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(聖騎士)", leaveGap = 1 },
				dtl10 = { text = "Legendary", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeLegendaries" },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeTrash" },
			},

			{	name = "博學者殿堂",				-- Magister's Terrace
				type = AM_TYP_INSTANCE,
				displayname = "博學者殿堂",
				displayshort = "MagT",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagistersTerrace",			-- Magister's Terrace
				location = "奎爾達納斯之島",
				levels = "69-72",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {42.19, 78.32} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "斯琳·炎心", colour = AM_RED, coords = { {42.19, 26.17} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SMTFireheart" },
--			dtl3  = { text = "Fel Crystals", colour = AM_ORANGE, coords = { {43.36, 37.5}, {43.36, 50.2}, {42.19, 29.88}, {50.39, 50.2}, {50.39, 37.5} }, symbol = { "C" },
				dtl3  = { text = "惡魔水晶", colour = AM_ORANGE, coords = { {42.19, 26.17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "提里斯", colour = AM_GREEN, coords = { {59.96, 29.88} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "維克索魯斯", colour = AM_RED, coords = { {83.4, 31.84} }, symbol = { "3" },
						tooltiptxt = "", lootid = "SMTVexallus" },
				dtl6  = { text = "索蘭尼亞的占卜寶珠", colour = AM_GREEN, coords = { {94.53, 31.64} }, symbol = { "4" },
						tooltiptxt = "", special = "(卡雷苟斯)" },
				dtl7  = { text = "女牧師戴利莎", colour = AM_RED, coords = { {38.67, 52.54} }, symbol = { "5" },
						tooltiptxt = "", special = "(下層)", lootid = "SMTDelrissa" },
				dtl8  = { text = "凱爾薩斯·逐日者", colour = AM_RED, coords = { {6.05, 48.24} }, symbol = { "6" },
						tooltiptxt = "", lootid = "SMTKaelthas", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SMTTrash" },
			},

			{	name = "Plateau du Puits de soleil",				-- Sunwell Plateau
				type = AM_TYP_INSTANCE,
				displayname = "Plateau du Puits de soleil",
				displayshort = "SunP",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SunwellPlateau",			-- Sunwell Plateau
				location = "奎爾達納斯之島",
				levels = "69-72",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {31.45, 17.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "卡雷苟斯", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SPKalecgos" },
				dtl3  = { text = "『墮落者』塞斯諾瓦", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "瑪德里茍沙", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "布魯托魯斯", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPBrutallus" },
				dtl6  = { text = "魔霧", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPFelmyst" },
				dtl7  = { text = "???", colour = AM_GREEN, coords = { {74.41, 33.2} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl8  = { text = "埃雷達爾雙子", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { "4" },
						tooltiptxt = "", special = "(下層)", lootid = "SPEredarTwins" },
				dtl9  = { text = "大術士艾黎瑟絲", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(下層)" },
				dtl10 = { text = "莎珂蕾希女士", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(下層)" },
				dtl11 = { text = "莫魯", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { "5" },
						tooltiptxt = "", special = "(En haut)" },
				dtl12 = { text = "安卓普斯", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { " " },
						tooltiptxt = "", special = "(En haut)" },
				dtl13 = { text = "基爾加丹", colour = AM_GREEN, coords = { {61.71, 32.62} }, symbol = { "6" },
						tooltiptxt = "", leaveGap = 1, lootid = "SPKiljaeden" },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SPTrash" },
			},

		};

end