--------------------------------------------------------------------------
-- localization.lua
--------------------------------------------------------------------------

AM_TYP_INSTANCE 	= "Instances";

-- Including "continent" will split the maps in to separate options on the DropDown menu, 1 for each continent...
-- If one map of this type mentions continent, then they ALL must mention continent

AM_ALPHAMAP_INSTANCES_LIST = {

		{	name = "Blackfathom Deeps",			-- Blackfathom Deeps
			type = AM_TYP_INSTANCE,
			displayname = "Blackfathom Deeps",
			displayshort = "BFD",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackfathomDeeps",
			location = "Ashenvale (14, 14)",
			levels = "24-32",
			players = "10",
			prereq = "",
			general = "Some underwater sections",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {33, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackfathom Deeps"..AM_EXTERIOR },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {50, 68} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Ghamoo-ra", colour = AM_RED, coords = { {23.5, 42} }, symbol = { "1" },
					tooltiptxt = "Lvl25 Elite Beast (Giant Turtle)", lootid = "BFDGhamoora" },
			dtl4  = { text = "Lorgalis Manuscript", colour = AM_ORANGE, coords = { {23.5, 30} }, symbol = { "2" },
					tooltiptxt = "Quest Item for 'Knowledge of the Deeps',\nin chest" },
			dtl5  = { text = "Lady Sarevess", colour = AM_RED, coords = { {3, 29} }, symbol = { "3" },
					tooltiptxt = "Lvl25 Elite Humanoid", lootid = "BFDLadySarevess" },
			dtl6  = { text = "Argent Guard Thaelrid", colour = AM_BLUE, coords = { {11, 51} }, symbol = { "4" },
					tooltiptxt = "Target of Quest 'In Search of Thaelrid',\n& Quest Start for 'Villainy'" },
			dtl7  = { text = "Gelihast", colour = AM_RED, coords = { {43, 40} }, symbol = { "5" },
					tooltiptxt = "Lvl25 Elite Humanoid (Murloc)", lootid = "BFDGelihast" },
			dtl8  = { text = "Lorgus Jett", colour = AM_RED, coords = { {49, 43}, {55, 46} }, symbol = { "6" },
					tooltiptxt = "Lvl26 Elite Humanoid", special = AM_VARIES },
			dtl9  = { text = "Baron Aquanis", colour = AM_RED, coords = { {52, 76} }, symbol = { "7" },
					tooltiptxt = "Lvl28 Elite Humanoid", lootid = "BFDBaronAquanis" },
			dtl10 = { text = "Fathom Core", colour = AM_BLUE, coords = { {52, 76} }, symbol = { " " },
					tooltiptxt = "" },
			dtl11 = { text = "Twilight Lord Kelris", colour = AM_RED, coords = { {63, 81} }, symbol = { "8" },
					tooltiptxt = "Lvl27 Elite Humanoid", lootid = "BFDTwilightLordKelris" },
			dtl12 = { text = "Blackfathom-Tiefen Altar", colour = AM_BLUE, coords = { {63, 81} }, symbol = { " " },
					tooltiptxt = "" },
			dtl13 = { text = "Old Serra'kis", colour = AM_RED, coords = { {63, 74} }, symbol = { "9" },
					tooltiptxt = "Lvl26 Elite Beast", lootid = "BFDOldSerrakis" },
			dtl14 = { text = "Aku'mai", colour = AM_RED, coords = { {95, 85} }, symbol = { "10" },
					tooltiptxt = "Lvl29 Elite Beast (Hydra)", lootid = "BFDAkumai", leaveGap = 1 },
			dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "BFDTrash", leaveGap = 1 }
		},

		{	name = "Blackrock Depths",			-- Blackrock Depths
			type = AM_TYP_INSTANCE,
			displayname = "Blackrock Depths",
			displayshort = "BRD",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackrockDepths",
			location = "Blackrock Mountain",
			levels = "52-60",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {21, 83} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap  = "Blackrock Mountain"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Lord Roccor", colour = AM_RED, coords = { {33, 80} }, symbol = { "1" },
					tooltiptxt = "Lvl51 Elite Elemental", lootid = "BRDLordRoccor" },
			dtl3  = { text = "High Interrogator Gerstahn", colour = AM_RED, coords = { {38, 95} }, symbol = { "2" },
					tooltiptxt = "Lvl52 Elite Humanoid", lootid = "BRDHighInterrogatorGerstahn" },
			dtl4  = { text = "Marshal Windsor", colour = AM_BLUE, coords = { {46, 95} }, symbol = { "3" },
					tooltiptxt = "Link in Onyxia Quest Chain" },
			dtl5  = { text = "Commander Gor'shak", colour = AM_BLUE, coords = { {40, 90} }, symbol = { "4" },
					tooltiptxt = "'Commander Gor'shak' Quest" },
			dtl6  = { text = "Kharan Mighthammer", colour = AM_BLUE, coords = { {44, 86} }, symbol = { "5" },
					tooltiptxt = "'Kharan Mighthammer' Quest" },
			dtl7  = { text = "Ring of Law", colour = AM_GREEN, coords = { {42, 73.4} }, symbol = { "6" },
					tooltiptxt = "Defeat Mobs here to turn \nUpper level spectators from \nRed Aggro. to Yellow", lootid = "BRDArena" },
			dtl8  = { text = "Theldren", colour = AM_RED, coords = { {42, 73.4} }, symbol = { " " },
					tooltiptxt = "NPC Group Leader", lootid = "BRDArena" },
			dtl9  = { text = "Franclorn Forgewright", colour = AM_BLUE, coords = { {45.8, 78.1} }, symbol = { "7" },
					tooltiptxt = "'Dark Iron Legacy' Quest" },
			dtl10  = { text = "Pyromancer Loregrain", colour = AM_RED, coords = { {48, 78} }, symbol = { "8" },
					tooltiptxt = "Lvl52 Elite Humanoid", special = AM_RARE, lootid = "BRDPyromantLoregrain" },
			dtl11 = { text = "The Vault", colour = AM_GREEN, coords = { {54, 54} }, symbol = { "9" },
					tooltiptxt = "" },
			dtl12  = { text = "Fineous Darkvire", colour = AM_RED, coords = { {55, 41} }, symbol = { "10" },
					tooltiptxt = "Lvl54 Elite Humanoid", lootid = "BRDFineousDarkvire" },
			dtl13 = { text = "Warder Stilgliss", colour = AM_RED, coords = { {48, 55} }, symbol = { "11" },
					tooltiptxt = "Lvl56 Elite Humanoid", lootid = "BRDWarderStilgiss" },
			dtl14 = { text = "Verek", colour = AM_RED, coords = { {54, 54} }, symbol = { " " },
					tooltiptxt = "Lvl55 Elite" },
			dtl15 = { text = "Lord Incendius", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { "12" },
					tooltiptxt = "'Incendius!' Quest", lootid = "BRDLordIncendius" },
			dtl16 = { text = "The Black Anvil", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { " " },
					tooltiptxt = "" },
			dtl17 = { text = "ShadowForge Lock", colour = AM_GREEN, coords = { {31, 72.4} }, symbol = { "13" },
					tooltiptxt = "Unlock to allow deeper access to higher level areas\nRequires Shadowforge Key" },
			dtl18 = { text = "Bael'Gar", colour = AM_RED, coords = { {8, 62} }, symbol = { "14" },
					tooltiptxt = "Lvl57 Elite Mountain Giant", lootid = "BRDBaelGar" },
			dtl19 = { text = "General Angerforge", colour = AM_RED, coords = { {24, 64} }, symbol = { "15" },
					tooltiptxt = "Lvl57 Elite Dwarf", lootid = "BRDGeneralAngerforge" },
			dtl20 = { text = "Golem Lord Argelmach", colour = AM_RED, coords = { {24, 51} }, symbol = { "16" },
					tooltiptxt = "Lvl58 Elite Dwarf", lootid = "BRDGolemLordArgelmach" },
			dtl21 = { text = "The Grim Guzzler", colour = AM_GREEN, coords = { {40, 50} }, symbol = { "17" },
					tooltiptxt = "Buy 6 Dark Iron Ale mugs\nand give them to Rocknot ;P", lootid = "BRDGuzzler" },
			dtl22 = { text = "Ambassador Flamelash", colour = AM_RED, coords = { {46, 38} }, symbol = { "18" },
					tooltiptxt = "Lvl57 Elite Humanoid", lootid = "BRDFlamelash" },
			dtl23 = { text = "Panzor the Invincible", colour = AM_RED, coords = { {40, 27} }, symbol = { "19" },
					tooltiptxt = "Lvl57 Elite Golem", special = AM_RARE, lootid = "BRDPanzor" },
			dtl24 = { text = "Summoner's Tomb", colour = AM_GREEN, coords = { {46, 18} }, symbol = { "20" },
					tooltiptxt = "Defeat 7 bosses in sequence to go deeper\n& Chest", lootid = "BRDTomb" },
			dtl25 = { text = "The Lyceum", colour = AM_GREEN, coords = { {61, 8.5} }, symbol = { "21" },
					tooltiptxt = "Find and defeat 2 Flamekeepers\nand light both torches to progress.\nOnly have 3 minutes from killing the first." },
			dtl26 = { text = "Magmus", colour = AM_RED, coords = { {78, 8.5} }, symbol = { "22" },
					tooltiptxt = "Lvl57 Elite Mountain Giant", lootid = "BRDMagmus" },
			dtl27 = { text = "Princess Moira Bronzebeard", colour = AM_RED, coords = { {90, 8} }, symbol = { "23" },
					tooltiptxt = "Lvl58 Elite Humanoid", lootid = "BRDPrincess" },
			dtl28 = { text = "Emperor Dagran Thaurissan", colour = AM_RED, coords = { {93, 8.5} }, symbol = { "24" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "BRDImperatorDagranThaurissan" },
			dtl29 = { text = "The Black Forge", colour = AM_GREEN, coords = { {63, 22} }, symbol = { "23" },
					tooltiptxt = "Forge Dark Iron,\nand make Smoking Heart of the Mountain" },
			dtl30 = { text = "Molten Core", colour = AM_ORANGE, coords = { {65, 30} }, symbol = { "24" },
					tooltiptxt = "'Attunement to the Core' Quest\nMolten Core Entrance", toMap = "Molten Core", leaveGap = 1 }
		},

		{	name = "Blackrock Spire",		-- Blackrock Spire
			type = AM_TYP_INSTANCE,
			displayname = "Blackrock Spire (Lower)",
			displayshort = "LBRS",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\LBRS",			-- LBRS
			location = "Blackrock Mountain",
			levels = "53-60",
			players = "15",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap  = "Blackrock Mountain"..AM_EXTERIOR },
			dtl2  = { text = "Blacrock Spire (Upper)", colour = AM_BLUE, coords = { {22, 4} }, symbol = { "U" },
					tooltiptxt = "", toMap = "Blackrock Spire (Upper)" },
			dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {45.2, 29}, {73, 46} }, symbol = { "x1" },
					tooltiptxt = "" },
			dtl4  = { text = "Bridge to High Lord Omokk", colour = AM_GREEN, coords = { {38, 32.1}, {15, 32.1} }, symbol = { "B" },
					tooltiptxt = "" },
			dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {71, 22}, {94, 26} }, symbol = { "x2" },
					tooltiptxt = "Lower Level" },
			dtl6  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {29, 53}, {29, 77} }, symbol = { "x3" },
					tooltiptxt = "" },
			dtl7  = { text = "Ramps", colour = AM_BLUE, coords = { {86, 40}, {89, 58} }, symbol = { "R" },
					tooltiptxt = "", leaveGap = 1 },
			dtl8  = { text = "Vaelan", colour = AM_RED, coords = { {31, 17} }, symbol = { "1" },
					tooltiptxt = "Lvl55 Elite\nSeal of Ascension Quest"  },
			dtl9  = { text = "Warosh", colour = AM_RED, coords = { {53, 14} }, symbol = { "2" },
					tooltiptxt = "Lvl60 Elite Humanoid"  },
			dtl10 = { text = "Roughshod Pike", colour = AM_ORANGE, coords = { {69, 29} }, symbol = { "3" },
					tooltiptxt = "Quest Item"  },
			dtl11 = { text = "Bijou", colour = AM_BLUE, coords = { {62, 25 } }, symbol = { "4" },
					tooltiptxt = "Bijou Quest chain\nNot Lower Level" },
			dtl12 = { text = "Spirestone Butcher", colour = AM_RED, coords = { {42, 32.1} }, symbol = { "5" },
					tooltiptxt = "Lvl59 Elite Humanoid\nPatrols bridge to Highlord Omokk", lootid = "LBRSSpirestoneButcher", special = AM_RARE  },
			dtl13 = { text = "Highlord Omokk", colour = AM_RED, coords = { {2, 32.1} }, symbol = { "6" },
					tooltiptxt = "Lvl?? Elite Humanoid", lootid = "LBRSOmokk"  },
			dtl14 = { text = "Spirestone Battle Lord", colour = AM_RED, coords = { {2, 32.1} }, symbol = { " " },
					tooltiptxt = "Spawns on hill near Lord Omokk", lootid = "LBRSSpirestoneLord", special = AM_RARE },
			dtl15 = { text = "Shadow Hunter Vosh'gajin", colour = AM_RED, coords = { {77, 64} }, symbol = { "7" },
					tooltiptxt = "Lvl?? Elite Humanoid", lootid = "LBRSVosh"  },
			dtl16 = { text = "Fith Mosh'aru Tablet", colour = AM_ORANGE, coords = { {77, 68} }, symbol = { "8" },
					tooltiptxt = "Quest Item"  },
			dtl17 = { text = "Bannok Grimaxe", colour = AM_RED, coords = { {41.5, 26.5} }, symbol = { "9" },
					tooltiptxt = "Lvl59 Elite Humanoid\nOn Lower Level", lootid = "LBRSGrimaxe", special = AM_RARE },
			dtl18 = { text = "War Master Voone", colour = AM_RED, coords = { {73, 32} }, symbol = { "10" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "LBRSVoone" },
			dtl19 = { text = "Sixth Mosh'aru Tablet", colour = AM_ORANGE, coords = { {75, 29} }, symbol = { "11" },
					tooltiptxt = "Quest Item"  },
			dtl20 = { text = "Mor Grayhoof", colour = AM_RED, coords = { {75, 35} }, symbol = { "12" },
					tooltiptxt = "Lvl60 Elite\nRequires Summoning Brazier\nInterrupt their heals", lootid = "LBRSGrayhoof" },
			dtl21  = { text = "Mother Smolderweb", colour = AM_RED, coords = { {54, 58} }, symbol = { "13" },
					tooltiptxt = "Lvl59 Elite Beast", lootid = "LBRSSmolderweb"  },
			dtl22 = { text = "Crystal Fang", colour = AM_RED, coords = { {36, 49} }, symbol = { "14" },
					tooltiptxt = "Lvl60 Elite Beast", special = AM_RARE, lootid = "LBRSCrystalFang"  },
			dtl23 = { text = "Urok Doomhowl", colour = AM_RED, coords = { {30, 30} }, symbol = { "15" },
					tooltiptxt = "Lvl60 Elite Humanoid", lootid = "LBRSDoomhowl"  },
			dtl24 = { text = "Quartermaster Zigris", colour = AM_RED, coords = { {50, 89} }, symbol = { "16" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "LBRSZigris"  },
			dtl25 = { text = "Halcyon", colour = AM_RED, coords = { {19, 92} }, symbol = { "17" },
					tooltiptxt = "Lvl59 Elite Beast\nKill to trigger spawn of Gizrul", lootid = "LBRSHalycon"  },
			dtl26 = { text = "Gizrul the Slavener", colour = AM_RED, coords = { {19, 92} }, symbol = { " " },
					tooltiptxt = "Lvl60 Elite Beast\nSpawn triggered by death of Halcyon", lootid = "LBRSSlavener"  },
			dtl27 = { text = "Overlord Wyrmthalak", colour = AM_RED, coords = { {42, 62} }, symbol = { "18" },
					tooltiptxt = "Lvl?? Elite Dragon", lootid = "LBRSWyrmthalak", leaveGap = 1  },
			dtl28 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "LBRSTrash", leaveGap = 1 }
		},

		{	name = "Blackrock Spire (Upper)",
			type = AM_TYP_INSTANCE,
			displayname = "Blackrock Spire (Upper)",
			displayshort = "UBRS",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\UBRS",			-- UBRS
			location = "Blackrock Mountain",
			levels = "53-60",
			players = "15",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 80.7} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap  = "Blackrock Mountain"..AM_EXTERIOR },
			dtl2  = { text = "Blackrock Spire (Lower)", colour = AM_BLUE, coords = { {18.2, 86.6} }, symbol = { "L" },
					tooltiptxt = "", toMap = "Blackrock Spire", leaveGap = 1 },
			dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {11.9, 58.4}, {8.65, 25} }, symbol = { "x1" },
					tooltiptxt = "" },
			dtl4  = { text = "Pyroguard Emberseer", colour = AM_RED, coords = { {8.2, 31.0} }, symbol = { "1" },
					tooltiptxt = "Lvl?? Elite Elemental", lootid = "UBRSEmberseer", leaveGap = 1  },
			dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {8.6, 38.9}, {36.4, 61.2} }, symbol = { "x2" },
					tooltiptxt = "" },
			dtl6  = { text = "Doomrigger's Clasp", colour = AM_ORANGE, coords = { {41.3, 68.65} }, symbol = { "2" },
					tooltiptxt = "Quest Item\nIn large Chest among toppled pillars\nCan be hard to spot\nCan drop down from General Drakkisath"  },
			dtl7  = { text = "Father Flame", colour = AM_ORANGE, coords = { {50, 65.45} }, symbol = { "3" },
					tooltiptxt = "Fight spawns near doorway\nStop hatchers hatching eggs", lootid = "UBRSFLAME"  },
			dtl8  = { text = "Solakar Flamewreath", colour = AM_RED, coords = { {50, 65.45} }, symbol = { " " },
					tooltiptxt = "Lvl60 Elite Dragonkin\nSpawned after Looting Father Flame", lootid = "UBRSSolakar" },
			dtl9  = { text = "Jed Runewatcher", colour = AM_RED, coords = { {47, 52.6} }, symbol = { "4" },
					tooltiptxt = "Lvl59 Elite Humanoid", special = AM_RARE, lootid = "UBRSRunewatcher"  },
			dtl10 = { text = "Goraluk Anvilcrack", colour = AM_RED, coords = { {34, 52.6} }, symbol = { "5" },
					tooltiptxt = "Lvl61 Elite Humanoid", lootid = "UBRSAnvilcrack"  },
			dtl11 = { text = "Warchief Rend Blackhand", colour = AM_RED, coords = { {67.5, 51} }, symbol = { "6" },
					tooltiptxt = "Boss\nLimited to 'For the Horde!' Quest\nComes mounted on Gyth", lootid = "UBRSRend"  },
			dtl12  = { text = "Gyth", colour = AM_RED, coords = { {67.5, 51} }, symbol = { " " },
					tooltiptxt = "Lvl?? Elite Dragon", lootid = "UBRSGyth" },
			dtl13 = { text = "Awbee", colour = AM_BLUE, coords = { {68.1, 65.9} }, symbol = { "7" },
					tooltiptxt = "Limited to 'The Matron Protectorate' Quest"  },
			dtl14 = { text = "The Beast", colour = AM_RED, coords = { {95.7, 60.8} }, symbol = { "8" },
					tooltiptxt = "Lvl?? Elite Beast", lootid = "UBRSBeast"  },
			dtl15 = { text = "Lord Valthalak", colour = AM_RED, coords = { {95.7, 56.5} }, symbol = { "9" },
					tooltiptxt = "Lvl?? Elite\nNeed Quest to Summon\nClear Hall of Blackhand first", lootid = "UBRSValthalak" },
			dtl16  = { text = "General Drakkisath", colour = AM_RED, coords = { {41.6, 73.2} }, symbol = { "10" },
					tooltiptxt = "Lvl?? Elite Dragon", lootid = "UBRSDrakkisath"  },
			dtl17 = { text = "Blackwing Lair", colour = AM_BLUE, coords = { {78.5, 27.6} }, symbol = { "BWL" },
					tooltiptxt = "", toMap = "Blackwing Lair", leaveGap = 1 },
			dtl18 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "UBRSTrash", leaveGap = 1 }
		},

		{	name = "Blackwing Lair",		-- Blackwing Lair
			type = AM_TYP_INSTANCE,
			displayname = "Blackwing Lair",
			displayshort = "BWL",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackwingLair",
			location = "Blackrock Spire",
			levels = "60+",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {65, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Spire (Upper)", leaveGap = 1 },
			dtl2 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {32.8, 78}, {61, 48} }, symbol = { "x1" },
					tooltiptxt = "" },
			dtl3 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {40, 96}, {68, 65} }, symbol = { "x2" },
					tooltiptxt = "" },
			dtl4 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {47, 51}, {17, 52} }, symbol = { "x3" },
					tooltiptxt = "", leaveGap = 1 },
			dtl5  = { text = "Razorgore the Untamed", colour = AM_RED, coords = { {51, 66} }, symbol = { "1" },
					tooltiptxt = "Boss", lootid = "BWLRazorgore"  },
			dtl6  = { text = "Vaelastrasz the Corrupt", colour = AM_RED, coords = { {32.5, 67} }, symbol = { "2" },
					tooltiptxt = "Boss", lootid = "BWLVaelastrasz"  },
			dtl7  = { text = "Broodlord Lashlayer", colour = AM_RED, coords = { {77, 42} }, symbol = { "3" },
					tooltiptxt = "Boss", lootid = "BWLLashlayer"  },
			dtl8  = { text = "Firemaw", colour = AM_RED, coords = { {12, 44} }, symbol = { "4" },
					tooltiptxt = "Boss", lootid = "BWLFiremaw"  },
			dtl9  = { text = "Ebonroc", colour = AM_RED, coords = { {10, 29} }, symbol = { "5" },
					tooltiptxt = "Boss", lootid = "BWLEbonroc"  },
			dtl10 = { text = "Flamegor", colour = AM_RED, coords = { {18, 29} }, symbol = { "6" },
					tooltiptxt = "Boss", lootid = "BWLFlamegor"  },
			dtl11 = { text = "Chromaggus", colour = AM_RED, coords = { {33, 40} }, symbol = { "7" },
					tooltiptxt = "Boss", lootid = "BWLChromaggus"  },
			dtl12 = { text = "Nefarian", colour = AM_RED, coords = { {60, 14} }, symbol = { "8" },
					tooltiptxt = "Boss", lootid = "BWLNefarian", leaveGap = 1 },
			dtl13 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "BWLTrashMobs", leaveGap = 1 },
		},

		{	name = "Dire Maul",		-- Dire Maul
			type = AM_TYP_INSTANCE,
			displayname = "Dire Maul - Overview",
			displayshort = "DM",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DireMaul",
			location = "Feralas (59, 44)",
			levels = "56-60",
			players = "5",
			prereq = "",
			general = "",
			dtl1  = { text = "Dire Maul East", colour = AM_GREEN, coords = { {53, 81}, {57, 96}, {100, 80} }, symbol = { "E" },
					tooltiptxt = "Click to Open Dire Maul East Map", toMap = "Dire Maul East" },
			dtl2  = { text = "Dire Maul North", colour = AM_GREEN, coords = { {67.5, 38} }, symbol = { "N" },
					tooltiptxt = "Click to Open Dire Maul North Map", toMap = "Dire Maul North" },
			dtl3  = { text = "Dire Maul West", colour = AM_GREEN, coords = { {47, 88} }, symbol = { "W" },
					tooltiptxt = "Click to Open Dire Maul West Map", toMap = "Dire Maul West", leaveGap = 1 },
			dtl4  = { text = "Library", colour = AM_BLUE, coords = { {24, 58}, {41, 41} }, symbol = { "L" },
					tooltiptxt = "Reached from North or West Dire Maul", leaveGap = 1 }
		},

		{	name = "Dire Maul East",		-- Dire Maul East
			type = AM_TYP_INSTANCE,
			displayname = "Dire Maul (East)",
			displayshort = "DM",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMEast",		--DMEast
			location = "Feralas (59, 44)",
			levels = "56-60",
			players = "5",
			prereq = "",
			general = "",
			dtl1  = { text = "Entrance : Broken Commons", colour = AM_GREEN, coords = { {6, 58}  }, symbol = { "X1" },
					tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
			dtl2  = { text = "Entrance : Eldereth Row", colour = AM_GREEN, coords = { {12, 92} }, symbol = { "X2" },
					tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
			dtl3  = { text = "Entrance : Pavillion", colour = AM_GREEN, coords = { {98, 64} }, symbol = { "X3" },
					tooltiptxt = "" },
			dtl4  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {8, 40} }, symbol = { AM_EXIT_SYMBOL },
					tooltiptxt = "Drop to Broken Commons\nside Chamber" },
			dtl5  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {41, 85}, {61, 93} }, symbol = { "L1" },
					tooltiptxt = "" },
			dtl6  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {75, 92}, {55, 82} }, symbol = { "L2" },
					tooltiptxt = "" },
			dtl7  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {67, 63}, {83, 73} }, symbol = { "L3" },
					tooltiptxt = "", leaveGap = 1 },
			dtl8  = { text = "Pusillin Chase Starts", colour = AM_GREEN, coords = { {10, 50} }, symbol = { "P" },
					tooltiptxt = "Chase to get Dire Maul (Crescent) Key", lootid = "DMEPusillin"  },
			dtl9  = { text = "Pusillin Chase End", colour = AM_RED, coords = { {79, 61} }, symbol = { "P" },
					tooltiptxt = "Oooh, you little Imp!", lootid = "DMEPusillin"  },
			dtl10 = { text = "Zevrim Thornhoof", colour = AM_RED, coords = { {83, 88} }, symbol = { "1" },
					tooltiptxt = "Lvl57 Elite Demon", lootid = "DMEZevrimThornhoof"  },
			dtl11 = { text = "Hydrospawn", colour = AM_RED, coords = { {64, 77} }, symbol = { "2" },
					tooltiptxt = "Lvl57 Elite Elemental", lootid = "DMEHydro"  },
			dtl12 = { text = "Lethendris", colour = AM_RED, coords = { {46, 66} }, symbol = { "3" },
					tooltiptxt = "Lvl57 Elite Humanoid", lootid = "DMELethtendris"  },
			dtl13 = { text = "Old Ironbark", colour = AM_RED, coords = { {21, 69} }, symbol = { "4" },
					tooltiptxt = "Opens door"  },
			dtl14 = { text = "Alzzin the Wildshaper", colour = AM_RED, coords = { {42, 23} }, symbol = { "5" },
					tooltiptxt = "Lvl58 Elite Demon", lootid = "DMEAlzzin"  },
			dtl15 = { text = "Isalien", colour = AM_RED, coords = { {42, 23} }, symbol = { " " },
					tooltiptxt = "Need Brazier of Beckoning to summon\nQuest from Bodley in Blackrock Mountain", lootid = "DMEIsalien", leaveGap = 2 },
			dtl16 = { text = "Books", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
			dtl17 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DMETrash", leaveGap = 1 }
		},

		{	name = "Dire Maul North",		-- Dire Maul North
			type = AM_TYP_INSTANCE,
			displayname = "Dire Maul (North)",
			displayshort = "DM",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMNorth",		-- DMNorth
			location = "Feralas (59, 44)",
			levels = "56-60",
			players = "5",
			prereq = "Requires Crescent Key from Pusillin Chase in DM East",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {74, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
			dtl2  = { text = "Dire Maul(West)", colour = AM_GREEN, coords = { {9, 98} }, symbol = { "W" },
					tooltiptxt = "", toMap = "Dire Maul West" },
			dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {49.2, 59.4} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "Guard Mol'dar", colour = AM_RED, coords = { {76.4, 55.5} }, symbol = { "1" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "DMNGuardMoldar"  },
			dtl5  = { text = "Stomper Kreeg", colour = AM_RED, coords = { {67, 49} }, symbol = { "2" },
					tooltiptxt = "Lvl57 Elite Demon", lootid = "DMNStomperKreeg"  },
			dtl6  = { text = "Guard Fengus", colour = AM_RED, coords = { {49.2, 56.1} }, symbol = { "3" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "DMNGuardFengus"  },
			dtl7  = { text = "Guard Slip'kik", colour = AM_RED, coords = { {17, 41} }, symbol = { "4" },
					tooltiptxt = "Lvl59 Elite Humanoid", lootid = "DMNGuardSlipkik"  },
			dtl8  = { text = "Knot Thimblejack", colour = AM_RED, coords = { {19, 37} }, symbol = { "5" },
					tooltiptxt = "", lootid = "DMNThimblejack"  },
			dtl9  = { text = "Captain Kromcrush", colour = AM_RED, coords = { {24.6, 34.8} }, symbol = { "6" },
					tooltiptxt = "", lootid = "DMNCaptainKromcrush"  },
			dtl10 = { text = "King Gordok", colour = AM_RED, coords = { {24.2, 11.2} }, symbol = { "7" },
					tooltiptxt = "", lootid = "DMNKingGordok"  },
			dtl11 = { text = "Library", colour = AM_BLUE, coords = { {20, 89} }, symbol = { "8" },
					tooltiptxt = "", leaveGap = 2  },
			dtl12 = { text = "Tribute Run", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { " " },
					tooltiptxt = "", lootid = "DMNTRIBUTERUN" },
			dtl13 = { text = "Books", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 }
		},

		{	name = "Dire Maul West",		-- Dire Maul West
			type = AM_TYP_INSTANCE,
			displayname = "Dire Maul (West)",
			displayshort = "DM",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMWest",		-- DMWest
			location = "Feralas (59, 44)",
			levels = "56-60",
			players = "5",
			prereq = "Requires Crescent Key from Pusillin Chase in DM East",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {97, 78} }, symbol = { "X1" },
					tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
			dtl2  = { text = "Dire Maul (North)", colour = AM_GREEN, coords = { {66, 9} }, symbol = { "N" },
					tooltiptxt = "", toMap = "Dire Maul North", leaveGap = 1 },
			dtl3  = { text = "Stairs", colour = AM_BLUE, coords = { {49.2, 25}, {52, 60} }, symbol = { AM_STAIRS_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "Pylons", colour = AM_GREEN, coords = { {83, 80}, {64, 61}, {64, 87}, {27, 62}, {27, 37} }, symbol = { "P" },
					tooltiptxt = "Destroy these", leaveGap = 1 },
			dtl5  = { text = "Shen'dralar Ancient", colour = AM_ORANGE, coords = { {68, 74} }, symbol = { "1" },
					tooltiptxt = "Quest to Kill Prince" },
			dtl6  = { text = "Tendris Warpwood", colour = AM_RED, coords = { {58, 74} }, symbol = { "2" },
					tooltiptxt = "Lvl60 Elite Elemental", lootid = "DMWTendrisWarpwood" },
			dtl7  = { text = "Illyanna Ravnoak", colour = AM_RED, coords = { {49, 87} }, symbol = { "3" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "DMWIllyannaRavenoak" },
			dtl8  = { text = "Tsu'Zee", colour = AM_RED, coords = { {48, 60} }, symbol = { "4" },
					tooltiptxt = "Lvl59 Elite Undead", special = AM_RARE, lootid = "DMWTsuzee" },
			dtl9  = { text = "Magister Kalendris", colour = AM_RED, coords = { {53, 51} }, symbol = { "5" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "DMWMagisterKalendris" },
			dtl10 = { text = "Immol'thar", colour = AM_RED, coords = { {19, 49} }, symbol = { "6" },
					tooltiptxt = "Lvl61 Elite Demon", lootid = "DMWImmolthar" },
			dtl11 = { text = "Lord Hel'nurath", colour = AM_RED, coords = { { 19, 49} }, symbol = { " " },
					tooltiptxt = "Lvl62 Elite Demon\nSummon as part of Warlock Epic Mount quest", lootid = "DMWHelnurath" },
			dtl12 = { text = "Prince Tortheldrin", colour = AM_RED, coords = { {41, 26} }, symbol = { "7" },
					tooltiptxt = "Lvl61 Elite Humanoid", lootid = "DMWPrinceTortheldrin", leaveGap = 1  },
			dtl13 = { text = "Library", colour = AM_BLUE, coords = { {51, 20} }, symbol = { "8" },
					tooltiptxt = "", leaveGap = 1 },
			dtl14 = { text = "Books", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
			dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "DMWTrash", leaveGap = 1 }
		},

		{	name = "Gnomeregan",			-- Gnomeregan
			type = AM_TYP_INSTANCE,
			displayname = "Gnomeregan",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Gnomeregan",
			location = "Dun Morogh (25, 41)",
			levels = "26-33",
			players = "10",
			prereq = "",
			general = "Horde access via Teleporter in Booty Bay.\nInitial Quest from Orgrimmar Engineer.",
			dtl1  = { text = "Front Entrance (Clockwerk Run)", colour = AM_GREEN, coords = { {70.5, 16} }, symbol = { "X1" },
					tooltiptxt = "", toMap = "Gnomeregan"..AM_EXTERIOR },
			dtl2  = { text = "Rear Entrance (Workshop)", colour = AM_GREEN, coords = { {87, 59} }, symbol = { "X2" },
					tooltiptxt = "Workshop Key Required", toMap = "Gnomeregan"..AM_EXTERIOR },
			dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {75, 38}, {79, 56} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "Viscous Fallout", colour = AM_RED, coords = { {71.5, 33.5} }, symbol = { "1" },
					tooltiptxt = "Lvl30 Elite Elemental\nLower level", lootid = "GnViscousFallout" },
			dtl5  = { text = "Grubbis", colour = AM_RED, coords = { {95, 46} }, symbol = { "2" },
					tooltiptxt = "Lvl32 Elite Humanoid\nTriggered Spawn\nSpeak to Blastmaster at same location", lootid = "GnGrubbis"  },
			dtl6  = { text = "Kernobee (The Dormitory)", colour = AM_BLUE, coords = { {76, 54} }, symbol = { "3" },
					tooltiptxt = ""  },
			dtl7  = { text = "Matrix Punchograh 3005-B", colour = AM_GREEN, coords = { {70, 50} }, symbol = { "B" },
					tooltiptxt = "Card Upgrade"  },
			dtl8  = { text = "The Clean Zone", colour = AM_GREEN, coords = { {64, 46} }, symbol = { "4" },
					tooltiptxt = ""  },
			dtl9  = { text = "Electrocutioner 6000", colour = AM_RED, coords = { {30, 49} }, symbol = { "5" },
					tooltiptxt = "Lvl32 Elite Mechanical\nDrops Workshop Key", lootid = "GnElectrocutioner6000"  },
			dtl10 = { text = "Matrix Puchograph 3005-C", colour = AM_GREEN, coords = { {33.2, 49.6} }, symbol = { "C" },
					tooltiptxt = "Card Upgrade"  },
			dtl11 = { text = "Crowd Pummeler 9-60", colour = AM_RED, coords = { {47.6, 77.3} }, symbol = { "6" },
					tooltiptxt = "Lvl32 Elite Mechanical", lootid = "GnCrowdPummeler960"  },
			dtl12 = { text = "Matrix Punchograph 3005-D", colour = AM_GREEN, coords = { {48.9, 75.7} }, symbol = { "D" },
					tooltiptxt = "Card Upgrade"  },
			dtl13 = { text = "Dark Iron Ambassador", colour = AM_RED, coords = { {9, 52} }, symbol = { "5" },
					tooltiptxt = "Lvl33 Elite Humanoid", special = AM_RARE, lootid = "GnDIAmbassador"  },
			dtl14 = { text = "Mekgineer Thermoplugg", colour = AM_RED, coords = { {11.8, 42.2} }, symbol = { "8" },
					tooltiptxt = "Lvl35 Elite Demon", lootid = "GnMekgineerThermaplugg", leaveGap = 1  },
			dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "GnTrash", leaveGap = 1 }
		},

		{	name = "Maraudon",			-- Maraudon
			type = AM_TYP_INSTANCE,
			displayname = "Maraudon",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Maraudon",
			location = "Desolace (29, 62)",
			levels = "40-49",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = "Entrance (Orange)", colour = AM_ORANGE, coords = { {71, 12} }, symbol = { "X1" },
					tooltiptxt = "", toMap = "Maraudon"..AM_EXTERIOR },
			dtl2  = { text = "Entrance (Purple)", colour = AM_PURPLE, coords = { {85, 31} }, symbol = { "X2" },
					tooltiptxt = "", toMap = "Maraudon"..AM_EXTERIOR },
			dtl3  = { text = "Entrance (Portal)", colour = AM_GREEN, coords = { {36, 55} }, symbol = { "P" },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {64, 44}, {39, 31} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl5  = { text = "Veng (Fifth Khan)", colour = AM_RED, coords = { {59, 6} }, symbol = { "1" },
					tooltiptxt = "", special = AM_WANDERS  },
			dtl6  = { text = "Noxxion", colour = AM_RED, coords = { {51, 3} }, symbol = { "2" },
					tooltiptxt = "Lvl48 Elite Elemental", lootid = "MaraNoxxion"  },
			dtl7  = { text = "Razorlash", colour = AM_RED, coords = { {36, 14} }, symbol = { "3" },
					tooltiptxt = "Lvl47 Elite Beast", lootid = "MaraRazorlash"  },
			dtl8  = { text = "Maraudos (Fourth Khan)", colour = AM_RED, coords = { {64, 27} }, symbol = { "4" },
					tooltiptxt = ""  },
			dtl9  = { text = "Lord Vyletongue", colour = AM_RED, coords = { {53.3, 32} }, symbol = { "5" },
					tooltiptxt = "Lvl47 Elite Humanoid", lootid = "MaraLordVyletongue"  },
			dtl10 = { text = "Meshlok the Harvester", colour = AM_RED, coords = { {43, 30} }, symbol = { "6" },
					tooltiptxt = "", special = AM_RARE, lootid = "MaraMeshlok"  },
			dtl11 = { text = "Celebras the Cursed", colour = AM_RED, coords = { {31, 35} }, symbol = { "7" },
					tooltiptxt = "Lvl49 Elite Humanoid", lootid = "MaraCelebras"  },
			dtl12 = { text = "Landslide", colour = AM_RED, coords = { {51.3, 60} }, symbol = { "8" },
					tooltiptxt = "Lvl50 Elite Elemental", lootid = "MaraLandslide"  },
			dtl13 = { text = "Tinkerer Gizlock", colour = AM_RED, coords = { {61, 74} }, symbol = { "9" },
					tooltiptxt = "Lvl50 Elite Humanoid", lootid = "MaraTinkererGizlock"  },
			dtl14 = { text = "Rotgrip", colour = AM_RED, coords = { {45, 82} }, symbol = { "10" },
					tooltiptxt = "Lvl50 Elite Beast", lootid = "MaraRotgrip"  },
			dtl15 = { text = "Princess Theradras", colour = AM_RED, coords = { {32, 85} }, symbol = { "11" },
					tooltiptxt = "Lvl51 Elite Elemental", lootid = "MaraPrincessTheradras" },
			dtl16 = { text = "Zaetar's Spirit", colour = AM_RED, coords = { {32, 85} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 }
		},

		{	name = "Molten Core",			-- Molten Core
			type = AM_TYP_INSTANCE,
			displayname = "Molten Core",
			displayshort = "MC",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MoltenCore",
			location = "Blackrock Depths",
			levels = "60+",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 20} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Blackrock Depths", leaveGap = 1 },
			dtl2  = { text = "Lucifron", colour = AM_RED, coords = { {62, 35} }, symbol = { "1" },
					tooltiptxt = "Boss Humanoid", lootid = "MCLucifron" },
			dtl3  = { text = "Magmadar", colour = AM_RED, coords = { {70, 16} }, symbol = { "2" },
					tooltiptxt = "Boss Beast", lootid = "MCMagmadar" },
			dtl4  = { text = "Gehennas", colour = AM_RED, coords = { {13, 46} }, symbol = { "3" },
					tooltiptxt = "Boss Humanoid", lootid = "MCGehennas" },
			dtl5  = { text = "Garr", colour = AM_RED, coords = { {8, 71} }, symbol = { "4" },
					tooltiptxt = "Boss Elemental", lootid = "MCGarr"  },
			dtl6  = { text = "Shazzrah", colour = AM_RED, coords = { {44, 80} }, symbol = { "5" },
					tooltiptxt = "Boss Humanoid", lootid = "MCShazzrah"  },
			dtl7  = { text = "Baron Geddon", colour = AM_RED, coords = { {53, 68} }, symbol = { "6" },
					tooltiptxt = "Boss Elemental", lootid = "MCGeddon"  },
			dtl8  = { text = "Golemagg the Incinerator", colour = AM_RED, coords = { {66, 57} }, symbol = { "7" },
					tooltiptxt = "Boss Giant", lootid = "MCGolemagg"  },
			dtl9  = { text = "Sulfuron Harbinger", colour = AM_RED, coords = { {87, 80} }, symbol = { "8" },
					tooltiptxt = "Boss Humanoid", lootid = "MCSulfuron"  },
			dtl10 = { text = "Majordomo Executus", colour = AM_RED, coords = { {89, 62} }, symbol = { "9" },
					tooltiptxt = "Boss Humanoid", lootid = "MCMajordomo"  },
			dtl11 = { text = "Ragnaros", colour = AM_RED, coords = { {47, 52} }, symbol = { "10" },
					tooltiptxt = "Boss Elemental", lootid = "MCRagnaros", leaveGap = 2  },
			dtl12 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "MCTrashMobs", lootlink = true },
			dtl13 = { text = AM_RBOSS_DROP, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "MCRANDOMBOSSDROPPS", leaveGap = 1 },
		},

		{	name = "Naxxramas",			-- Naxxramas
			type = AM_TYP_INSTANCE,
			displayname = "Naxxramas",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Naxxramas",
			location = "Stratholme",
			levels = "60+",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text ="Abomination Wing" , colour = AM_BLUE, coords = { {2, 15} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = "Patchwerk", colour = AM_RED, coords = { {22, 36} }, symbol = { "1" },
					tooltiptxt = "Abomination Wing", lootid = "NAXPatchwerk" },
			dtl3  = { text = "Grobbulus", colour = AM_RED, coords = { {32, 29} }, symbol = { "2" },
					tooltiptxt = "Abomination Wing", lootid = "NAXGrobbulus" },
			dtl4  = { text = "Gluth", colour = AM_RED, coords = { {20, 20} }, symbol = { "3" },
					tooltiptxt = "Abomination Wing", lootid = "NAXGluth" },
			dtl5  = { text = "Thaddius", colour = AM_RED, coords = { {5, 4} }, symbol = { "4" },
					tooltiptxt = "Abomination Wing", lootid = "NAXThaddius", leaveGap = 1  },
			dtl6  = { text = "Spider Wing", colour = AM_BLUE, coords = { {67, 3} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = ""  },
			dtl7  = { text = "Anub'Rekhan", colour = AM_RED, coords = { {45.2, 20} }, symbol = { "1" },
					tooltiptxt = "Spider Wing", lootid = "NAXAnubRekhan"  },
			dtl8  = { text = "Grand Widow Faerlina", colour = AM_RED, coords = { {55, 16} }, symbol = { "2" },
					tooltiptxt = "Spider Wing", lootid = "NAXGrandWidowFaerlina"  },
			dtl9  = { text = "Maexxna", colour = AM_RED, coords = { {74, 5} }, symbol = { "3" },
					tooltiptxt = "Spider Wing", lootid = "NAXMaexxna", leaveGap = 1  },
			dtl10 = { text = "Necro Wing", colour = AM_BLUE, coords = { {79, 56} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = ""  },
			dtl11 = { text = "Noth the Plaguebringer", colour = AM_RED, coords = { {47, 64} }, symbol = { "1" },
					tooltiptxt = "Necro Wing", lootid = "NAXNothderPlaguebringer"  },
			dtl12 = { text = "Helgan the Unclean", colour = AM_RED, coords = { {60, 58} }, symbol = { "2" },
					tooltiptxt = "Necro Wing", lootid = "NAXHeiganderUnclean"  },
			dtl13 = { text = "Loatheb", colour = AM_RED, coords = { {82, 47} }, symbol = { "3" },
					tooltiptxt = "Necro Wing", lootid = "NAXLoatheb", leaveGap = 1  },
			dtl14 = { text = "Deathknight Wing", colour = AM_BLUE, coords = { {15, 79} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = ""  },
			dtl15 = { text = "Instructor Razuvious", colour = AM_RED, coords = { {18, 58} }, symbol = { "1" },
					tooltiptxt = "Deathknight Wing", lootid = "NAXInstructorRazuvious"  },
			dtl16 = { text = "Gothik the Harvester", colour = AM_RED, coords = { {37, 64} }, symbol = { "2" },
					tooltiptxt = "Deathknight Wing", lootid = "NAXGothikderHarvester" },
			dtl17 = { text = "The Four Horsemen", colour = AM_RED, coords = { {8, 75} }, symbol = { "3" },
					tooltiptxt = "Deathknight Wing", lootid = "NAXTheFourHorsemen" },
			dtl18 = { text = "Thane Korth'azz", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl19 = { text = "Sir Zeliek", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl20 = { text = "Highlord Mograine", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl21 = { text = "Lady Blaumeaux", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl22 = { text = "Frostwyrm Lair", colour = AM_BLUE, coords = { {74, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "Frostwyrm Lair"  },
			dtl23 = { text = "Sapphiron", colour = AM_RED, coords = { {87, 91} }, symbol = { "1" },
					tooltiptxt = "Frostwyrm Lair", lootid = "NAXSapphiron"  },
			dtl24 = { text = "Kel'Thuzard", colour = AM_RED, coords = { {75, 79} }, symbol = { "2" },
					tooltiptxt = "Frostwyrm Lair", lootid = "NAXKelThuzard", leaveGap = 2  },
			dtl25 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "NAXTrash", leaveGap = 1 }
		},

		{	name = "Onyxia's Lair",				-- Onyxia's Lair
			type = AM_TYP_INSTANCE,
			displayname = "Onyxia's Lair",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OnyxiasLair",
			location = "Dustwallow Marsh (52, 76)",
			levels = "60+",
			players = "40",
			prereq = "Requires Drakefire Amulet\n(Complete quest in UBRS to kill General Drakkisath)",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 12} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = "Onyxian Warders", colour = AM_RED, coords = { {26, 41}, {29, 56}, {39, 68}, {50, 80} }, symbol = { "1" },
					tooltiptxt = "Lvl62 Elite Dragonkin" },
			dtl3  = { text = "Whelp Eggs", colour = AM_RED, coords = { {45, 40}, {51, 54}, {84, 41}, {79, 54} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl4  = { text = "Onyxia", colour = AM_RED, coords = { {66, 27} }, symbol = { "3" },
					tooltiptxt = "Boss Dragonkin", lootid = "Onyxia", leaveGap = 1 }
		},

		{	name = "Ragefire Chasm",			-- Ragefire Chasm
			type = AM_TYP_INSTANCE,
			displayname = "Ragefire Chasm",
			displayshort = "RFC",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RagefireChasm",			-- RagefireChasm
			location = "Orgrimmar",
			levels = "13-18",
			players = "10",
			general = "",
			dtl1  = { text = "Entrance", colour = AM_GREEN, coords = { {72, 4} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Maur Grimtotem", colour = AM_GOLD, coords = { {71, 53} }, symbol = { "1" },
					tooltiptxt = "Satchel Quest"  },
			dtl3  = { text = "Taragaman the Hungerer", colour = AM_RED, coords = { {34, 59} }, symbol = { "2" },
					tooltiptxt = "Lvl16 Elite Demon", lootid = "RFCTaragaman" },
			dtl4  = { text = "Jergosh the Invoker", colour = AM_RED, coords = { {24, 86} }, symbol = { "3" },
					tooltiptxt = "Lvl16 Elite Humanoid", lootid = "RFCJergosh" },
			dtl5  = { text = "Bazzalan", colour = AM_RED, coords = { {36, 91} }, symbol = { "4" },
					tooltiptxt = "Lvl16 Elite Demon", leaveGap = 1  }

		},

		{	name = "Razorfen Downs",			-- Razorfen Downs
			type = AM_TYP_INSTANCE,
			displayname = "Razorfen Downs",
			displayshort = "RFD",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenDowns",
			location = "Southern Barrens (48, 88)",
			levels = "38-43",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {4, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {77, 45} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Tuten'kash", colour = AM_RED, coords = { {52, 36} }, symbol = { "1" },
					tooltiptxt = "Lvl40 Elite Undead", lootid = "RFDTutenkash" },
			dtl4  = { text = "Gong to spawn Tuten'kash", colour = AM_GREEN, coords = { {54, 30} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl5  = { text = "Henry Stern,\n& Belnistrasz", colour = AM_BLUE, coords = { {76, 27} }, symbol = { "3" },
					tooltiptxt = "Learn how to make :\nGoldthorn Tea, \nMighty Troll's Blood Potion"  },
			dtl6  = { text = "Mordresh Fire Eye", colour = AM_RED, coords = { {87, 47} }, symbol = { "4" },
					tooltiptxt = "Lvl39 Elite Undead", lootid = "RFDMordreshFireEye"  },
			dtl7  = { text = "Glutton", colour = AM_RED, coords = { {19, 65} }, symbol = { "5" },
					tooltiptxt = "Lvl40 Elite Humanoid", lootid = "RFDGlutton"  },
			dtl8  = { text = "Ragglesnout", colour = AM_RED, coords = { {41, 67} }, symbol = { "6" },
					tooltiptxt = "Lvl40 Elite Humanoid", special = AM_RARE, lootid = "RFDRagglesnout"  },
			dtl9  = { text = "Amnennar the Coldbringer", colour = AM_RED, coords = { {33, 59} }, symbol = { "0" },
					tooltiptxt = "Lvl41 Elite Undead", lootid = "RFDAmnennar", leaveGap = 1 },
			dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "RFDTrash", leaveGap = 1 }
		},

		{	name = "Razorfen Kraul",			-- Razorfen Kraul
			type = AM_TYP_INSTANCE,
			displayname = "Razorfen Kraul",
			displayshort = "RFK",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenKraul",
			location = "Southern Barrens (42, 86)",
			levels = "28-33",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 71} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Roogug", colour = AM_RED, coords = { {73, 44} }, symbol = { "1" },
					tooltiptxt = "Lvl28 Elite Humanoid" },
			dtl3  = { text = "Aggem Thorncurse", colour = AM_RED, coords = { {88, 48} }, symbol = { "2" },
					tooltiptxt = "Lvl30 Elite Humanoid" },
			dtl4  = { text = "Death Speaker Jargba", colour = AM_RED, coords = { {93, 38} }, symbol = { "3" },
					tooltiptxt = "Lvl30 Elite Humanoid", lootid = "RFKDeathSpeakerJargba" },
			dtl5  = { text = "Overlord Ramtusk", colour = AM_RED, coords = { {60, 29} }, symbol = { "4" },
					tooltiptxt = "Lvl32 Elite Humanoid", lootid = "RFKOverlordRamtusk"  },
			dtl6 = { text = "Earthcaller Halmgar", colour = AM_RED, coords = { {49, 37} }, symbol = { "5" },
					tooltiptxt = "Lvl32 Elite Humanoid", special = AM_RARE, lootid = "RFKEarthcallerHalmgar"  },
			dtl7 = { text = "Willix the Importer,\n& Heralath Fallowbrook", colour = AM_BLUE, coords = { {35, 33} }, symbol = { "6" },
					tooltiptxt = ""  },
			dtl8  = { text = "Charlga Razorflank", colour = AM_RED, coords = { {21, 33} }, symbol = { "7" },
					tooltiptxt = "Lvl33 Elite Humanoid", lootid = "RFKCharlgaRazorflank"  },
			dtl9  = { text = "Blind Hunter", colour = AM_RED, coords = { {6, 32} }, symbol = { "8" },
					tooltiptxt = "Lvl32 Elite Beast\n& Chest", special = AM_RARE, lootid = "RFKBlindHunter"  },
			dtl10  = { text = "Ward Sealing Agathelos", colour = AM_GREEN, coords = { {4, 54} }, symbol = { "9" },
					tooltiptxt = ""  },
			dtl11  = { text = "Agathelos the Raging", colour = AM_RED, coords = { {11, 65} }, symbol = { "10" },
					tooltiptxt = "Lvl33 Elite Beast", lootid = "RFKAgathelos", leaveGap = 1  },
			dtl12 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "RFKTrash", leaveGap = 1 }
		},

		{	name = "Ruins of Ahn'Qiraj",		-- Ruins of Ahn'Qiraj
			type = AM_TYP_INSTANCE,
			displayname = "Ruins of Ahn'Qiraj",
			displayshort = "AQ20",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RuinsofAhnQiraj",		-- RuinsofAhnQiraj
			location = "Silithus (29, 96)",
			levels = "60+",
			players = "20",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {64, 2} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Kurinnaxx", colour = AM_RED, coords = { {55, 29} }, symbol = { "1" },
					tooltiptxt = "Boss & Elites", lootid = "AQ20Kurinnaxx" },
			dtl3  = { text ="Lieutenant General Andorov,\n&Four Kaldorei Elites", colour = AM_RED, coords = { {55, 29} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQ20Andorov" },
			dtl4  = { text = "Captain Qeez", colour = AM_RED, coords = { {52.1, 46.9} }, symbol = { "2" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN" },
			dtl5  = { text = "Captain Tuubid", colour = AM_RED, coords = { {55.4, 46.9} }, symbol = { "3" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN" },
			dtl6  = { text = "Captain Drenn", colour = AM_RED, coords = { {57.2, 47.9} }, symbol = { "4" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
			dtl7  = { text = "Captain Xurrem", colour = AM_RED, coords = { {59.2, 49.2} }, symbol = { "5" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
			dtl8  = { text = "Major Yeggeth", colour = AM_RED, coords = { {61.3, 50.3} }, symbol = { "6" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
			dtl9  = { text = "Major Pakkong", colour = AM_RED, coords = { {60, 53.4} }, symbol = { "7" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
			dtl10  = { text = "Colonel Zerran", colour = AM_RED, coords = { {56, 51.2} }, symbol = { "8" },
					tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
			dtl11 = { text = "General Rajaxx", colour = AM_RED, coords = { {52.2, 49.5} }, symbol = { "9" },
					tooltiptxt = "Boss", lootid = "AQ20Rajaxx"  },
			dtl12 = { text = "Moam", colour = AM_RED, coords = { {13, 31} }, symbol = { "10" },
					tooltiptxt = "Boss", lootid = "AQ20Moam"  },
			dtl13 = { text = "Buru the Gorger", colour = AM_RED, coords = { {83, 55} }, symbol = { "11" },
					tooltiptxt = "Boss", lootid = "AQ20Buru"  },
			dtl14 = { text = "Safe Room", colour = AM_GREEN, coords = { {65, 70} }, symbol = { "12" },
					tooltiptxt = ""  },
			dtl15 = { text = "Ayamiss the Hunter", colour = AM_RED, coords = { {67, 91} }, symbol = { "13" },
					tooltiptxt = "Boss", lootid = "AQ20Ayamiss"  },
			dtl16 = { text = "Ossirian the Unscarred", colour = AM_RED, coords = { {29, 73} }, symbol = { "14" },
					tooltiptxt = "Boss", lootid = "AQ20Ossirian", leaveGap = 2  },
			dtl17 = { text = "Class Books", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQ20ClassBooks" },
			dtl18 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQEnchants" },
		},

		{	name = "Scarlet Monastery",			-- Scarlet Monastery
			type = AM_TYP_INSTANCE,
			displayname = "Scarlet Monastery",
			displayshort = "SM",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ScarletMonastery",
			location = "Tirisfal Glades (83.6, 34)",
			levels = "30-40",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = "Graveyard Entrance", colour = AM_GREEN, coords = { {61, 97} }, symbol = { "G" },
					tooltiptxt = "", toMap = "Scarlet Monastery"..AM_EXTERIOR },
			dtl2  = { text = "Ironspine", colour = AM_RED, coords = { {21, 88} }, symbol = { "1" },
					tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMIronspine"  },
			dtl3  = { text = "Azshir the Sleepless", colour = AM_RED, coords = { {5, 88} }, symbol = { "2" },
					tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMAzshir"  },
			dtl4  = { text = "Fallen Champion", colour = AM_RED, coords = { {8, 80} }, symbol = { "3" },
					tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMFallenChampion" },
			dtl5  = { text = "Bloodmage Thalnos", colour = AM_RED, coords = { {5, 77} }, symbol = { "4" },
					tooltiptxt = "Lvl34 Elite Undead\nGraveyard", lootid = "SMBloodmageThalnos" },
			dtl6  = { text = "Library Entrance", colour = AM_GREEN, coords = { {56, 74} }, symbol = { "L" },
					tooltiptxt = "", toMap = "Scarlet Monastery"..AM_EXTERIOR },
			dtl7  = { text = "Houndmaster Loksey", colour = AM_RED, coords = { {66.1, 95} }, symbol = { "5" },
					tooltiptxt = "Lvl34 Elite Humanoid\nLibrary", lootid = "SMHoundmasterLoksey"  },
			dtl8  = { text = "Arcanist Doan", colour = AM_RED, coords = { {95.1, 92} }, symbol = { "6" },
					tooltiptxt = "Lvl37 Elite Humanoid\nLibrary", lootid = "SMDoan", leaveGap = 1  },
			dtl9  = { text = "Armoury Entrance", colour = AM_GREEN, coords = { {54, 65} }, symbol = { "A" },
					tooltiptxt = "", toMap = "Scarlet Monastery"..AM_EXTERIOR },
			dtl10 = { text = "Herod", colour = AM_RED, coords = { {74.8, 6.2} }, symbol = { "7" },
					tooltiptxt = "Lvl40 Elite Humanoid\nArmoury", lootid = "SMHerod", leaveGap = 1  },
			dtl11 = { text = "Cathedral Entrance", colour = AM_GREEN, coords = { {37, 65} }, symbol = { "C" },
					tooltiptxt = "", toMap = "Scarlet Monastery"..AM_EXTERIOR },
			dtl12 = { text = "High Inquisitor Fairbanks", colour = AM_RED, coords = { {31, 11} }, symbol = { "8" },
					tooltiptxt = "Lvl40 Elite Humanoid\nCathedral", lootid = "SMFairbanks"  },
			dtl13 = { text = "Scarlet Commander Mograine", colour = AM_RED, coords = { {23.4, 12} }, symbol = { "9" },
					tooltiptxt = "Lvl42 Elite Humanoid\nCathedral", lootid = "SMMograine"  },
			dtl14 = { text = "High Inquisitor Whitemane", colour = AM_RED, coords = { {23.4, 4.4} }, symbol = { "10" },
					tooltiptxt = "Lvl42 Elite Humanoid\nCathedral", lootid = "SMWhitemane", leaveGap = 2  },
			dtl15 = { text = "Set : Chain of the Scarlet Crusade", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "6 Piece", lootid = "SMScarletSET", leaveGap = 1 },
			dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "SMTrash", leaveGap = 1 }
		},

		{	name = "Ahn'Qiraj",			-- Ahn'Qiraj
			type = AM_TYP_INSTANCE,
			displayname = "Temple of Ahn'Qiraj",
			displayshort = "AQ40",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TempleofAhnQiraj",		-- TempleofAhnQiraj
			location = "Silithus (29, 96)",
			levels = "60+",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {16, 37} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Arygos\n& Caelestrasz\n& Merithra of the Dream", colour = AM_BLUE, coords = { {21, 56} }, symbol = { "A" },
					tooltiptxt = ""  },
			dtl3  = { text = "Andorgos\n& Vethsera\n& Kandrostrasz", colour = AM_BLUE, coords = { {27, 43} }, symbol = { "B" },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "The Prophet Skeram", colour = AM_RED, coords = { {19, 41} }, symbol = { "1" },
					tooltiptxt = "Boss\nOutside", lootid = "AQ40Skeram" },
			dtl5  = { text = "Vem & Co", colour = AM_RED, coords = { {15, 52} }, symbol = { "2" },
					tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Vem" },
			dtl6  = { text = "Battleguard Sartura", colour = AM_RED, coords = { {40, 30} }, symbol = { "3" },
					tooltiptxt = "Boss", lootid = "AQ40Sartura" },
			dtl7  = { text = "Fankriss the Unyielding", colour = AM_RED, coords = { {67, 14} }, symbol = { "4" },
					tooltiptxt = "Boss", lootid = "AQ40Fankriss"  },
			dtl8  = { text = "Viscidus", colour = AM_RED, coords = { {82, 7} }, symbol = { "5" },
					tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Viscidus"  },
			dtl9  = { text = "Princess Huhuran", colour = AM_RED, coords = { {41, 49} }, symbol = { "6" },
					tooltiptxt = "Boss", lootid = "AQ40Huhuran"  },
			dtl10 = { text = "Twin Emperors", colour = AM_RED, coords = { {72, 67} }, symbol = { "7" },
					tooltiptxt = "Boss", lootid = "AQ40Emperors"  },
			dtl11 = { text = "Ouro", colour = AM_RED, coords = { { 22, 87 } }, symbol = { "8" },
					tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Ouro" },
			dtl12 = { text = "Eye of C'Thun", colour = AM_RED, coords = { {25, 50} }, symbol = { "9" },
					tooltiptxt = "", lootid = "AQ40CThun" },
			dtl13 = { text = "C'Thun", colour = AM_RED, coords = { {25, 50} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQ40CThun", leaveGap = 2 },
			dtl14 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQ40Trash", leaveGap = 1 },
			dtl15 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0 } }, symbol = { " " },
					tooltiptxt = "", lootid = "AQEnchants", leaveGap = 1 },
			dtl16 = { text = "AQ Brood Rings", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQBroodRings", leaveGap = 1 },
			dtl17 = { text = AM_OPENING, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AQOpening", leaveGap = 1 }
		},

		{	name = "The Deadmines",			-- The Deadmines
			type = AM_TYP_INSTANCE,
			displayname = "The Deadmines",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheDeadmines",
			location = "Westfall (42, 72)",
			levels = "16-26",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "The Deadmines"..AM_EXTERIOR },
			dtl2  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {99, 42} }, symbol = { AM_EXIT_SYMBOL },
					tooltiptxt = "" },
			dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {80, 40} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "Rhahk'Zor", colour = AM_RED, coords = { {21, 58} }, symbol = { "1" },
					tooltiptxt = "Lvl19 Elite Humanoid", lootid = "VCRhahkZor" },
			dtl5  = { text = "Miner Johnson", colour = AM_RED, coords = { {41, 50} }, symbol = { "2" },
					tooltiptxt = "Lvl19 Elite Humanoid", lootid = "VCMinerJohnson", special = AM_RARE  },
			dtl6  = { text = "Sneed", colour = AM_RED, coords = { {37, 77} }, symbol = { "3" },
					tooltiptxt = "Lvl20 Elite Mechanical (in Shredder)", lootid = "VCSneed"  },
			dtl7  = { text = "Gilnid", colour = AM_RED, coords = { {48.8, 60.2} }, symbol = { "4" },
					tooltiptxt = "Lvl20 Elite Humanoid", lootid = "VCGilnid"  },
			dtl8  = { text = "Defias Gunpowder", colour = AM_GREEN, coords = { {55.6, 39} }, symbol = { "5" },
					tooltiptxt = "...Blast Powder to blow the doors"  },
			dtl9  = { text = "Mr. Smite", colour = AM_RED, coords = { {76, 31} }, symbol = { "6" },
					tooltiptxt = "Lvl20 Elite Humanoid", lootid = "VCMrSmite"  },
			dtl10 = { text = "Cookie", colour = AM_RED, coords = { {81, 36} }, symbol = { "7" },
					tooltiptxt = "", lootid = "VCCookie"  },
			dtl11 = { text = "Captain Greenskin", colour = AM_RED, coords = { {76, 37} }, symbol = { "8" },
					tooltiptxt = "Lvl21 Elite Humanoid", lootid = "VCCaptainGreenskin"  },
			dtl12 = { text = "Edwin VanCleef", colour = AM_RED, coords = { {79, 37} }, symbol = { "9" },
					tooltiptxt = "Lvl21 Elite Humanoid", lootid = "VCVanCleef", leaveGap = 2 },
			dtl13 = { text = "Set : Defias Leather", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "VCDefiasSET", leaveGap = 1 }
		},

		{	name = "The Stockade",			-- The Stockade
			type = AM_TYP_INSTANCE,
			displayname = "The Stockade",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheStockade",
			location = "Stormwind City",
			levels = "24-32",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {69, 60}, {75, 40}, {26, 57}, {31, 36}, {18, 29} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Targorr the Dread", colour = AM_RED, coords = { {58, 63}, {41, 55}, {50, 37}, {27, 50} }, symbol = { "1" },
					tooltiptxt = "Lvl24 Elite Humanoid", special = AM_VARIES },
			dtl4  = { text = "Kam Deepfury", colour = AM_RED, coords = { {73, 43} }, symbol = { "2" },
					tooltiptxt = "Lvl27 Elite Humanoid", lootid = "SWStKamDeepfury" },
			dtl5  = { text = "Hamhock", colour = AM_RED, coords = { {85, 56} }, symbol = { "3" },
					tooltiptxt = "Lvl28 Elite Humanoid"  },
			dtl6  = { text = "Bazil Thredd", colour = AM_RED, coords = { {95, 62} }, symbol = { "4" },
					tooltiptxt = ""  },
			dtl7  = { text = "Dextren Ward", colour = AM_RED, coords = { {15, 40} }, symbol = { "5" },
					tooltiptxt = "Lvl26 Elite Humanoid"  },
			dtl8  = { text = "Bruegal Ironknuckle", colour = AM_RED, coords = { {22, 54} }, symbol = { "6" },
					tooltiptxt = "Lvl26 Elite Humanoid", special = AM_RARE, lootid = "SWStBruegalIronknuckle", leaveGap = 1 }
		},

		{	name = "The Temple of Atal'Hakkar",			-- The Sunken Temple
			type = AM_TYP_INSTANCE,
			displayname = "Sunken Temple",
			displayshort = "ST",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSunkenTemple",
			location = "Swamp of Sorrows (70, 53)",
			levels = "45-60",
			players = "10",
			prereq = "",
			general = "Also called Temple of Atal'Hakkar",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 7} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Sunken Temple"..AM_EXTERIOR },
			dtl2  = { text = "Stairs at Entrance to Lower", colour = AM_GREEN, coords = { {54, 11.3}, {13.9, 47} }, symbol = { "SL" },
					tooltiptxt = "" },
			dtl3  = { text = "Stairs at Entrance to Mid", colour = AM_GREEN, coords = { {69, 11.3} }, symbol = { "SM" },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = "Stairs reaching Upper levels", colour = AM_BLUE, coords = { {52, 18}, {69, 18}, {52, 48}, {69, 48} }, symbol = { AM_STAIRS_SYMBOL },
					tooltiptxt = "" },
			dtl5  = { text = "Troll Minibosses (Upper level)", colour = AM_RED, coords = { {55, 23}, {66, 23}, {72, 33}, {49, 33}, {54, 43}, {66, 43} }, symbol = { "T1", "T2", "T3", "T4", "T5", "T6" },
					tooltiptxt = "Kill all, then Jammal'an\nto fight Eranikus", lootid = "STTrollMinibosses", leaveGap = 1 },
			dtl6  = { text = "Statues (Lower level)", colour = AM_ORANGE, coords = { {22, 82}, {22, 64}, {13, 77}, {30, 77}, {13, 68}, {30, 68} }, symbol = { "S1", "S2", "S3", "S4", "S5", "S6" },
					tooltiptxt = "Activate in numerical order to\nsummon Atal'alarion" },
			dtl7  = { text = "Altar of Hakkar", colour = AM_ORANGE, coords = { {22, 74} }, symbol = { "1" },
					tooltiptxt = ""  },
			dtl8  = { text = "Atal'alarion", colour = AM_RED, coords = { {22, 71} }, symbol = { "2" },
					tooltiptxt = "Lvl50 Elite Humanoid", lootid = "STAtalalarion", leaveGap = 1  },
			dtl9  = { text = "Dreamscythe", colour = AM_RED, coords = { {58, 33} }, symbol = { "3" },
					tooltiptxt = "Lvl53 Elite Dragonkin", lootid = "STDreamscythe"  },
			dtl10 = { text = "Weaver", colour = AM_RED, coords = { {62, 33} }, symbol = { "4" },
					tooltiptxt = "Lvl51 Elite Dragonkin", lootid = "STWeaver"  },
			dtl11 = { text = "Avatar of Hakkar", colour = AM_RED, coords = { {32, 33} }, symbol = { "5" },
					tooltiptxt = "Lvl50 Elite Dragon", lootid = "STAvatarofHakkar"  },
			dtl12 = { text = "Jammal'an the Prophet", colour = AM_RED, coords = { {88, 27} }, symbol = { "6" },
					tooltiptxt = "Lvl54 Elite Humanoid", lootid = "STJammalan"  },
			dtl13 = { text = "Ogom the Wretched", colour = AM_RED, coords = { {88, 31} }, symbol = { "7" },
					tooltiptxt = "Lvl53 Elite Undead", lootid = "STOgom"  },
			dtl14 = { text = "Morphaz", colour = AM_RED, coords = { {59, 62} }, symbol = { "8" },
					tooltiptxt = "Lvl52 Elite Dragon", lootid = "STMorphaz"  },
			dtl15 = { text = "Hazzas", colour = AM_RED, coords = { {62, 62} }, symbol = { "9" },
					tooltiptxt = "Lvl53 Elite Dragon", lootid = "STHazzas"  },
			dtl16 = { text = "Shade of Eranikus", colour = AM_RED, coords = { {80, 62} }, symbol = { "10" },
					tooltiptxt = "Lvl55 Elite Dragon", lootid = "STEranikus"  },
			dtl17 = { text = "Essence Font", colour = AM_ORANGE, coords = { {85, 57} }, symbol = { "11" },
					tooltiptxt = "", leaveGap = 1 },
			dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "STTrash", leaveGap = 1 }
		},

		{	name = "Uldaman",			-- Uldaman
			type = AM_TYP_INSTANCE,
			displayname = "Uldaman",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Uldaman",
			location = "The Badlands (44, 12)",
			levels = "35-50",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = "Front Entrance", colour = AM_GREEN, coords = { {89, 73.1} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "Click to open Uldaman Exterior Map", toMap = "Uldaman"..AM_EXTERIOR },
			dtl2  = { text = "Rear Entrance", colour = AM_GREEN, coords = { {21, 71} }, symbol = { "XR" },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Baelog", colour = AM_RED, coords = { {73, 93} }, symbol = { "1" },
					tooltiptxt = "Lvl41 Elite" },
			dtl4  = { text = "Remains of a Paladin", colour = AM_ORANGE, coords = { {62.8, 63.2} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl5  = { text = "Revelosh", colour = AM_RED, coords = { {64, 73.3} }, symbol = { "3" },
					tooltiptxt = "Lvl40 Elite Humanoid", lootid = "UldRevelosh"  },
			dtl6  = { text = "Ironaya", colour = AM_RED, coords = { {38, 75} }, symbol = { "4" },
					tooltiptxt = "Boss Giant", lootid = "UldIronaya"  },
			dtl7  = { text = "Annora (Master Enchanter)", colour = AM_BLUE, coords = { {56, 61} }, symbol = { "5" },
					tooltiptxt = ""  },
			dtl8  = { text = "Obsidian Sentinel", colour = AM_RED, coords = { {24.4, 62} }, symbol = { "6" },
					tooltiptxt = "Lvl42 Elite Mechanical"  },
			dtl9  = { text = "Ancient Stone Keeper", colour = AM_RED, coords = { {54.7, 43} }, symbol = { "7" },
					tooltiptxt = "Lvl44 Elite Elemental", lootid = "UldAncientStoneKeeper"  },
			dtl10 = { text = "Galgann Firehammer", colour = AM_RED, coords = { {21, 31} }, symbol = { "8" },
					tooltiptxt = "Boss Humanoid", lootid = "UldGalgannFirehammer"  },
			dtl11 = { text = "Grimlok", colour = AM_RED, coords = { {17, 19} }, symbol = { "9" },
					tooltiptxt = "Lvl45 Elite Humanoid", lootid = "UldGrimlok"  },
			dtl12 = { text = "Archaedas", colour = AM_RED, coords = { {45.2, 14.4} }, symbol = { "10" },
					tooltiptxt = "Boss Giant\nLower level", lootid = "UldArchaedas"  },
			dtl13 = { text = "The Discs of Norgannon", colour = AM_ORANGE, coords = { {39.7, 6.2} }, symbol = { "11" },
					tooltiptxt = "Upper level"  },
			dtl14 = { text = "Ancient Treasure", colour = AM_ORANGE, coords = { {42.3, 4.9} }, symbol = { "12" },
					tooltiptxt = "Lower level", leaveGap = 1 },
			dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "UldTrash", leaveGap = 1 }
		},

		{ 	name = "Wailing Caverns",			-- Wailing Caverns
			type = AM_TYP_INSTANCE,
			displayname = "Wailing Caverns",
			displayshort = "WC",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\WailingCaverns",
			location = "The Barrens (46, 36)",
			levels = "16-25",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {44, 58} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Wailing Caverns"..AM_EXTERIOR },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {62, 47}, {94, 49} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Disciple of Naralex", colour = AM_BLUE, coords = { {45, 53} }, symbol = { "1" },
					tooltiptxt = "Triggers Instance Final" },
			dtl4  = { text = "Lord Cobrahn", colour = AM_RED, coords = { {14, 55} }, symbol = { "2" },
					tooltiptxt = "Lvl20 Elite Humanoid", lootid = "WCLordCobrahn" },
			dtl5  = { text = "Lady Anacondra", colour = AM_RED, coords = { {39, 35} }, symbol = { "3" },
					tooltiptxt = "Lvl20 Elite Humanoid", lootid = "WCLadyAnacondra" },
			dtl6  = { text = "Kresh", colour = AM_RED, coords = { {45, 42} }, symbol = { "4" },
					tooltiptxt = "Lvl20 Elite Humanoid", lootid = "WCKresh"  },
			dtl7  = { text = "Deviate Faerie Dragon", colour = AM_RED, coords = { {63, 43} }, symbol = { "5" },
					tooltiptxt = "Lvl20 Elite Dragonkin", lootid = "WCDeviateFaerieDragon", special = AM_RARE },
			dtl8  = { text = "Lord Pythas", colour = AM_RED, coords = { {86, 34} }, symbol = { "6" },
					tooltiptxt = "Lvl22 Elite Humanoid", lootid = "WCLordPythas"  },
			dtl9  = { text = "Skum", colour = AM_RED, coords = { {93, 69} }, symbol = { "7" },
					tooltiptxt = "Lvl21 Elite Humanoid", lootid = "WCSkum"  },
			dtl10  = { text = "Lord Serpentis", colour = AM_RED, coords = { {60, 52} }, symbol = { "8" },
					tooltiptxt = "Lvl22 Elite Humanoid\nUpper level", lootid = "WCLordSerpentis"  },
			dtl11 = { text = "Verdan the Everliving", colour = AM_RED, coords = { {56, 48} }, symbol = { "9" },
					tooltiptxt = "Lvl24 Elite Elemental\nUpper level", lootid = "WCVerdan"  },
			dtl12 = { text = "Mutanus the Devourer", colour = AM_RED, coords = { {29.9, 23.9} }, symbol = { "10" },
					tooltiptxt = "Lvl22 Elite Humanoid\nTriggered Spawn", lootid = "WCMutanus"  },
			dtl13 = { text = "Naralex", colour = AM_RED, coords = { {32.4, 25.4} }, symbol = { "11" },
					tooltiptxt = "Lvl25 Elite Humanoid", leaveGap = 2  },
			dtl14 = { text = "Set : Embrace of the Viper", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "WCViperSET", leaveGap = 1 }
		},

		{	name = "Zul'Farrak",			-- Zul'Farrak
			type = AM_TYP_INSTANCE,
			displayname = "Zul'Farrak",
			displayshort = "ZF",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulFarrak",
			location = "Tanaris (37, 15)",
			levels = "43-47",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {69, 89} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Zerillis", colour = AM_RED, coords = { {63, 47} }, symbol = { "1" },
					tooltiptxt = "Lvl45 Elite Humanoid", special = AM_RARE.." "..AM_WANDERS, lootid = "ZFZerillis" },
			dtl3  = { text = "Sandarr Dunereaver", colour = AM_RED, coords = { {55, 59} }, symbol = { "2" },
					tooltiptxt = "Lvl45 Elite Humanoid", special = AM_RARE },
			dtl4  = { text = "Hydromancer Velratha", colour = AM_RED, coords = { {34, 43} }, symbol = { "3" },
					tooltiptxt = "Lvl46 Elite Humanoid" },
			dtl5  = { text = "Gahz'rilla", colour = AM_RED, coords = { {37, 46} }, symbol = { "4" },
					tooltiptxt = "Lvl46 Elite Beast", lootid = "ZFGahzrilla"  },
			dtl6  = { text = "Dustwraith", colour = AM_RED, coords = { {32, 46} }, symbol = { "5" },
					tooltiptxt = "Lvl45 Elite Humanoid", special = AM_RARE, lootid = "ZFDustwraith"  },
			dtl7  = { text = "Antu'sul", colour = AM_RED, coords = { {80, 35} }, symbol = { "6" },
					tooltiptxt = "Lvl48 Elite Humanoid", lootid = "ZFAntusul"  },
			dtl8  = { text = "Theka the Martyr", colour = AM_RED, coords = { {67, 33} }, symbol = { "7" },
					tooltiptxt = "Lvl46 Elite Humanoid"  },
			dtl9  = { text = "Witch Doctor Zum'rah", colour = AM_RED, coords = { {53, 23} }, symbol = { "8" },
					tooltiptxt = "Lvl46 Elite Humanoid", lootid = "ZFWitchDoctorZumrah"  },
			dtl10 = { text = "Zul'Farrak Dead Hero", colour = AM_RED, coords = { {51, 27} }, symbol = { "9" },
					tooltiptxt = "Lvl46 Elite Humanoid"  },
			dtl11 = { text = "Shadowpriest Sezz'ziz", colour = AM_RED, coords = { {36, 26} }, symbol = { "10" },
					tooltiptxt = "Lvl47 Elite Humanoid", lootid = "ZFSezzziz" },
			dtl12 = { text = "Nekrum Gutchewer", colour = AM_RED, coords = { {36, 26} }, symbol = { " " },
					tooltiptxt = "Lvl46 Elite Undead"  },
			dtl13 = { text = "Sergeant Bly", colour = AM_ORANGE, coords = { {26, 26} }, symbol = { "11" },
					tooltiptxt = "Divino-matic Rod Quest\nHostile/Friendly depending on\nfaction and actions taken" },
			dtl14 = { text = "Ruuzlu", colour = AM_RED, coords = { {51, 39} }, symbol = { "12" },
					tooltiptxt = "Lvl46 Elite Humanoid"  },
			dtl15 = { text = "Chief Ukorz Sandscalp", colour = AM_RED, coords = { {55, 42} }, symbol = { "13" },
					tooltiptxt = "Lvl48 Elite Humanoid", lootid = "ZFChiefUkorzSandscalp", leaveGap = 1 },
			dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "ZFTrash", leaveGap = 1 }
		},

		{	name = "Zul'Gurub",			-- Zul'Gurub
			type = AM_TYP_INSTANCE,
			displayname = "Zul'Gurub",
			displayshort = "ZG",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulGurub",
			location = "Stranglethorn Vale (54, 17)",
			levels = "60+",
			players = "20",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 50} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = "Muddy Churning Waters", colour = AM_BLUE, coords = { {33, 41}, {47, 48}, {57, 47}, {60, 32}, {47, 30} }, symbol = { "W" },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "High Priestess Jeklik", colour = AM_RED, coords = { {34, 78} }, symbol = { "1" },
					tooltiptxt = "Boss Humanoid", special = "(Bat)", lootid = "ZGJeklik" },
			dtl4  = { text = "High Priest Venoxis", colour = AM_RED, coords = { {56, 57} }, symbol = { "2" },
					tooltiptxt = "Boss Humanoid", special = "(Snake)", lootid = "ZGVenoxis" },
			dtl5  = { text = "High Priestess Mar'li", colour = AM_RED, coords = { {48, 85} }, symbol = { "3" },
					tooltiptxt = "Boss Humanoid", special = "(Spider)", lootid = "ZGMarli"  },
			dtl6  = { text = "Bloodlord Mandokir", colour = AM_RED, coords = { {76, 73} }, symbol = { "4" },
					tooltiptxt = "Boss Humanoid", special = "(Raptor)"..AM_OPTIONAL, lootid = "ZGMandokir"  },
			dtl7  = { text = "Edge of Madness", colour = AM_RED, coords = { {72, 47} }, symbol = { "5" },
					tooltiptxt = "", special = AM_OPTIONAL  },
			dtl8  = { text = "Gri'lek, of the Iron Blood", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
					tooltiptxt = "Boss Undead", lootid = "ZGGrilek"  },
			dtl9  = { text = "Hazza'rah, the Dreamweaver", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
					tooltiptxt = "Boss Undead", lootid = "ZGHazzarah"  },
			dtl10 = { text = "Renataki, of the Thousand Blades", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
					tooltiptxt = "Boss Undead", lootid = "ZGRenataki"  },
			dtl11 = { text = "Wushoolay, the Storm Witch", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
					tooltiptxt = "Boss Undead", lootid = "ZGWushoolay"  },
			dtl12 = { text = "Gahz'ranka", colour = AM_RED, coords = { {66, 33} }, symbol = { "6" },
					tooltiptxt = "Boss Humanoid", special = AM_OPTIONAL, lootid = "ZGGahzranka"  },
			dtl13 = { text = "High Priest Thekal", colour = AM_RED, coords = { {80, 32} }, symbol = { "7" },
					tooltiptxt = "Boss Humanoid", special = "(Tiger)", lootid = "ZGThekal" },
			dtl14 = { text = "High Priestess Arlokk", colour = AM_RED, coords = { {49, 16} }, symbol = { "8" },
					tooltiptxt = "Boss Humanoid", special = "(Panther)", lootid = "ZGArlokk"  },
			dtl15 = { text = "Jin'do the Hexxer", colour = AM_RED, coords = { {20, 18} }, symbol = { "9" },
					tooltiptxt = "Boss Humanoid", special = "(Undead)"..AM_OPTIONAL, lootid = "ZGJindo" },
			dtl16 = { text = "Hakkar", colour = AM_RED, coords = { {54, 40} }, symbol = { "10" },
					tooltiptxt = "Boss Dragon", lootid = "ZGHakkar", leaveGap = 2 },
			dtl17 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "ZGTrash", leaveGap = 1 },
			dtl18 = { text = AM_RBOSS_DROP, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "ZGShared", leaveGap = 1 },
			dtl19 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "ZGEnchants", leaveGap = 1 }
		},

		{	name = "Scholomance",			-- Scholomance
			type = AM_TYP_INSTANCE,
			displayname = "Scholomance",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Scholomance",		-- Scholomance*
			location = "Western Plaguelands (69, 73)",
			levels = "56-60",
			players = "5",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {24, 30} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {28, 38} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "" },
			dtl3  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {6.5, 22}, {62, 22} }, symbol = { "S1" },
					tooltiptxt = "" },
			dtl4  = {text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {41, 41}, {34, 80} }, symbol = { "S2" },
					tooltiptxt = "", leaveGap = 1 },
			dtl5  = { text = "Blood Steward of Kirtonos", colour = AM_RED, coords = { {54, 32} }, symbol = { "1" },
					tooltiptxt = "Lvl61 Elite Demon", lootid = "SCHOLOBloodSteward"  },
			dtl6  = { text = "Kirtonos the Herald", colour = AM_RED, coords = { {30, 5} }, symbol = { "2" },
					tooltiptxt = "", lootid = "SCHOLOKirtonostheHerald" },
			dtl7  = { text = "Jandice Barov", colour = AM_RED, coords = { {96, 8.5} }, symbol = { "3" },
					tooltiptxt = "Lvl61 Elite Undead", lootid = "SCHOLOJandiceBarov"  },
			dtl8  = { text = "Rattlegore", colour = AM_RED, coords = { {10, 41} }, symbol = { "4" },
					tooltiptxt = "Lvl61 Elite Undead\nLower level\nDrops key to Viewing Room", lootid = "SCHOLORattlegore"  },
			dtl9  = { text = "Death Knight Darkreaver", colour = AM_RED, coords = { {10, 41} }, symbol = { " " },
					tooltiptxt = "Lvl62 Elite Undead\nPaladins/Shaman Quest to Summon", lootid = "SCHOLODeathKnight" },
			dtl10  = { text = "Marduk Blackpool", colour = AM_BLUE, coords = { {23.7, 42} }, symbol = { "5" },
					tooltiptxt = "Lvl58 Elite\nAggro by placing Dawn's Gambit\nin Viewing room", lootid = "SCHOLOMarduk"  },
			dtl11 = { text = "Vectus", colour = AM_BLUE, coords = { {27.2, 42} }, symbol = { "6" },
					tooltiptxt = "Lvl60 Elite Undead\nAggro by placing Dawn's Gambit\nin Viewing room", lootid = "SCHOLOVectus"  },
			dtl12 = { text = "Ras Frostwhisper", colour = AM_RED, coords = { {18, 87} }, symbol = { "8" },
					tooltiptxt = "Lvl62 Elite Undead", lootid = "SCHOLORasFrostwhisper"  },
			dtl13 = { text = "Kormok", colour = AM_RED, coords = { {18, 80} }, symbol = { "9" },
					tooltiptxt = "Lvl60 Elite", lootid = "SCHOLOKormok" },
			dtl14 = { text = "Instructor Malicia", colour = AM_RED, coords = { {44.5, 94} }, symbol = { "10" },
					tooltiptxt = "Lvl60 Elite Humanoid", lootid = "SCHOLOInstructorMalicia"  },
			dtl15 = { text = "Doctor Theolen Krastinov", colour = AM_RED, coords = { {64, 74.2} }, symbol = { "11" },
					tooltiptxt = "Lvl60 Elite Humanoid", lootid = "SCHOLODoctorTheolenKrastinov"  },
			dtl16 = { text = "Lorekeeper Polkelt", colour = AM_RED, coords = { {44.8, 55.2} }, symbol = { "12" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLorekeeperPolkelt"  },
			dtl17 = { text = "The Ravenian", colour = AM_RED, coords = { {75.8, 92} }, symbol = { "13" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOTheRavenian"  },
			dtl18 = { text = "Lord Alexei Barov", colour = AM_RED, coords = { {96.2, 74.5} }, symbol = { "14" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLordAlexeiBarov"  },
			dtl19 = { text = "Lady Illucia Barov", colour = AM_RED, coords = { {75.6, 54} }, symbol = { "15" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLadyIlluciaBarov" },
			dtl20 = { text = "Darkmaster Gandling", colour = AM_RED, coords = { {76.2, 74.4} }, symbol = { "16" },
					tooltiptxt = "Lvl61 Elite Humanoid", lootid = "SCHOLODarkmasterGandling", leaveGap = 1 },
			dtl21 = { text = "Torch Lever", colour = AM_GREEN, coords = { {89, 19} }, symbol = { "T" },
					tooltiptxt = "" },
			dtl22 = { text = "Alchemy Lab", colour = AM_GREEN, coords = { {14, 70} }, symbol = { "AL" },
					tooltiptxt = "", leaveGap = 1 },
			dtl23 = { text = "Deed to Southshore", colour = AM_ORANGE, coords = { {56, 25} }, symbol = { "D" },
					tooltiptxt = ""  },
			dtl24 = { text = "Deed to Tarren Mill", colour = AM_ORANGE, coords = { {11, 36} }, symbol = { "D" },
					tooltiptxt = ""  },
			dtl25 = { text = "Deed to Brill", colour = AM_ORANGE, coords = { {15, 77} }, symbol = { "D" },
					tooltiptxt = ""  },
			dtl26 = { text = "Deed to Caer Darrow", colour = AM_ORANGE, coords = { {94, 72} }, symbol = { "D" },
					tooltiptxt = "Lvl60 Elite Humanoid", leaveGap = 1},
		},

		{	name = "Stratholme",			-- Stratholme
			type = AM_TYP_INSTANCE,
			displayname = "Stratholme",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Stratholme",
			location = "Eastern Plaguelands (30, 12)",
			levels = "55-60",
			players = "5",
			prereq = "",
			general = "Side entrance at EP (47, 24)",
			dtl1  = { text = "Front Entrance", colour = AM_GREEN, coords = { {50, 91} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = "Side Entrance", colour = AM_GREEN, coords = { {83, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Fras Siabi's Postbox", colour = AM_ORANGE, coords = { {37, 86} }, symbol = { "P1" },
					tooltiptxt = "" },
			dtl4  = { text = "King's Square Postbox", colour = AM_ORANGE, coords = { {47, 74} }, symbol = { "P2" },
					tooltiptxt = "" },
			dtl5  = { text = "Crusader's Postbox", colour = AM_ORANGE, coords = { {24, 66} }, symbol = { "P3" },
					tooltiptxt = "" },
			dtl6  = { text = "Market Row Postbox", colour = AM_ORANGE, coords = { {50, 62} }, symbol = { "P4" },
					tooltiptxt = ""  },
			dtl7  = { text = "Festival Lane Postbox", colour = AM_ORANGE, coords = { {61, 62} }, symbol = { "P5" },
					tooltiptxt = ""  },
			dtl8  = { text = "Elders' Square Postbox", colour = AM_ORANGE, coords = { {80, 68} }, symbol = { "P6" },
					tooltiptxt = "" },
			dtl9 = { text = "Postmaster Malown", colour = AM_RED, coords = { {37, 86}, {47, 74}, {24, 66}, {50, 62}, {61, 62}, {80, 68} }, symbol = { " " },
					tooltiptxt = "Lvl60 Elite Undead\nSpawns on opening of a 3rd Mail box\nMail box keys looted from Courier", leaveGap = 1 },
			dtl10 = { text = "Skul", colour = AM_RED, coords = { {42, 83} }, symbol = { "1" },
					tooltiptxt = "Lvl58 Elite Undead", special = AM_RARE.." "..AM_WANDERS, lootid = "STRATSkull" },
			dtl11 = { text = "Stratholme Courier", colour = AM_RED, coords = { {43, 78} }, symbol = { "2" },
					tooltiptxt = "Lvl57 Elite Undead", lootid = "STRATStratholmeCourier"  },
			dtl12 = { text = "Fras Siabi", colour = AM_RED, coords = { {39, 83} }, symbol = { "3" },
					tooltiptxt = "Lvl61 Elite Undead", lootid = "STRATFrasSiabi"  },
			dtl13 = { text = "Hearthsinger Forresten", colour = AM_RED, coords = { {45, 62}, {65, 58}, {66, 66} }, symbol = { "4" },
					tooltiptxt = "Lvl57 Elite Undead\nWill continue to respawn if any\nGhouls that spawn in his place\nare killed", special = AM_VARIES, lootid = "STRATHearthsingerForresten" },
			dtl14 = { text = "The Unforgiven", colour = AM_RED, coords = { {56, 57} }, symbol = { "5" },
					tooltiptxt = "Lvl57 Elite Undead", lootid = "STRATTheUnforgiven"  },
			dtl15 = { text = "Timmy the Cruel", colour = AM_RED, coords = { {26, 61.5} }, symbol = { "6" },
					tooltiptxt = "Lvl58 Elite Undead", lootid = "STRATTimmytheCruel"  },
			dtl16 = { text = "Cannon Master Willey", colour = AM_RED, coords = { {1, 74} }, symbol = { "7" },
					tooltiptxt = "Lvl60 Elite Humanoid", lootid = "STRATCannonMasterWilley"  },
			dtl17 = { text = "Archivist Galford", colour = AM_RED, coords = { {24, 92} }, symbol = { "8" },
					tooltiptxt = "Lvl60 Elite Humanoid", lootid = "STRATArchivistGalford"  },
			dtl18 = { text = "Balnazzar", colour = AM_RED, coords = { {17, 97} }, symbol = { "9" },
					tooltiptxt = "Lvl62 Elite Demon", lootid = "STRATBalnazzar"  },
			dtl19 = { text = "Sothos", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
					tooltiptxt = "Requires Jarien & Sothos's Brazier of Summoning", lootid = "STRATSothosJarien" },
			dtl20 = { text = "Jarien", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
					tooltiptxt = "Requires Jarien & Sothos's Brazier of Summoning", lootid = "STRATSothosJarien" },
			dtl21 = { text = "Aurius", colour = AM_BLUE, coords = { {81, 61} }, symbol = { "10" },
					tooltiptxt = ""  },
			dtl22 = { text = "Stonespine", colour = AM_RED, coords = { {78, 42} }, symbol = { "11" },
					tooltiptxt = "Lvl60 Elite Undead", special = AM_RARE, lootid = "STRATStonespine"  },
			dtl23 = { text = "Baroness Anastari", colour = AM_RED, coords = { {90, 39} }, symbol = { "12" },
					tooltiptxt = "Lvl59 Elite Undead", lootid = "STRATBaronessAnastari"  },
			dtl24 = { text = "Nerub'enkan", colour = AM_RED, coords = { {64, 39} }, symbol = { "13" },
					tooltiptxt = "Lvl60 Elite Undead", lootid = "STRATNerubenkan"  },
			dtl25 = { text = "Maleki the Pallid", colour = AM_RED, coords = { {81, 14} }, symbol = { "14" },
					tooltiptxt = "Lvl61 Elite Humanoid", lootid = "STRATMalekithePallid"  },
			dtl26 = { text = "Magistrate Barthilas", colour = AM_RED, coords = { {66, 10}, {74, 60} }, symbol = { "15" },
					tooltiptxt = "Lvl58 Elite Undead", special = AM_VARIES, lootid = "STRATMagistrateBarthilas" },
			dtl27 = { text = "Ramstein the Gorger", colour = AM_RED, coords = { {56, 15} }, symbol = { "16" },
					tooltiptxt = "Lvl61 Elite Undead", lootid = "STRATRamsteintheGorger"  },
			dtl28 = { text = "Baron Rivendare", colour = AM_RED, coords = { {42, 15} }, symbol = { "17" },
					tooltiptxt = "Lvl62 Elite Undead", lootid = "STRATBaronRivendare", leaveGap = 1 }
		},

		{	name = "Shadowfang Keep",			-- Shadowfang Keep
			type = AM_TYP_INSTANCE,
			displayname = "Shadowfang Keep",
			displayshort = "SFK",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowfangKeep",
			location = "Silverpine Forest (45, 67)",
			levels = "20-30",
			players = "10",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 69} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {57, 57}, {36, 55}, {29, 12} }, symbol = { AM_CHEST_SYMBOL },
					tooltiptxt = "" },
			dtl3  = { text = "Battlements", colour = AM_BLUE, coords = { {38, 71}, {54, 93} }, symbol = { "B1" },
					tooltiptxt = "" },
			dtl4  = {text = "Battlements", colour = AM_BLUE, coords = { {69, 85}, {35, 37} }, symbol = { "B2" },
					tooltiptxt = "" },
			dtl5  = { text = "Deathsworn Captain", colour = AM_RED, coords = { {69, 85}, {35, 37} }, symbol = { " " },
					tooltiptxt = "Lvl25 Elite Undead", special = AM_RARE  },
			dtl6  = { text = "Stairs", colour = AM_GREEN, coords = { {29.8, 34.8}, {50, 46.8} }, symbol = { "S1" },
					tooltiptxt = "" },
			dtl7  = { text = "Stairs", colour = AM_GREEN, coords = { {42, 32}, {67, 33} }, symbol = { "S2" },
					tooltiptxt = "", leaveGap = 1 },
			dtl8  = { text = "Rethilgore", colour = AM_RED, coords = { {70, 78} }, symbol = { "1" },
					tooltiptxt = "Lvl20 Elite Humanoid\nThe Cell Keeper" },
			dtl9  = { text = "Sorcerer Ashcrombe", colour = AM_RED, coords = { {67, 73} }, symbol = { "2" },
					tooltiptxt = "Lvl18 Elite Humanoid"  },
			dtl10 = { text = "Deathstalker Adamant", colour = AM_RED, coords = { {71, 74} }, symbol = { "3" },
					tooltiptxt = "Lvl18 Elite Humanoid"  },
			dtl11 = { text = "Razorclaw the Butcher", colour = AM_RED, coords = { {25, 59} }, symbol = { "4" },
					tooltiptxt = "Lvl22 Elite Humanoid", lootid = "BSFRazorclawtheButcher"  },
			dtl12 = { text = "Baron Silverlaine", colour = AM_RED, coords = { {13, 87} }, symbol = { "5" },
					tooltiptxt = "Lvl24 Elite Undead", lootid = "BSFSilverlaine" },
			dtl13 = { text = "Commander Springvale", colour = AM_RED, coords = { {26, 69} }, symbol = { "6" },
					tooltiptxt = "Lvl24 Elite Undead", lootid = "BSFSpringvale"  },
			dtl14 = { text = "Odo the Blindwatcher", colour = AM_RED, coords = { {61, 84} }, symbol = { "7" },
					tooltiptxt = "Lvl24 Elite Humanoid", lootid = "BSFOdotheBlindwatcher"  },
			dtl15 = { text = "Fenrus the Devourer", colour = AM_RED, coords = { {53.4, 33.4} }, symbol = { "8" },
					tooltiptxt = "Lvl25 Elite Beast", lootid = "BSFFenrustheDevourer"  },
			dtl16 = { text = "Wolf Master Nandos", colour = AM_RED, coords = { {80, 29} }, symbol = { "9" },
					tooltiptxt = "Lvl25 Elite Humanoid", lootid = "BSFWolfMasterNandos"  },
			dtl17 = { text = "Archmage Arugal", colour = AM_RED, coords = { {84, 13} }, symbol = { "10" },
					tooltiptxt = "Lvl26 Elite Humanoid", lootid = "BSFArchmageArugal", leaveGap = 1 },
			dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "BSFTrash", leaveGap = 1 }
		},

		{	name = "Hellfire Ramparts",		-- Hellfire Ramparts
			type = AM_TYP_INSTANCE,
			displayname = "HC: Ramparts",
			displayshort = "",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCRampart",			-- HellfireRampart
			location = "Hellfire Peninsula",
			levels = "60-62",
			players = "5",
			prereq = "Key: Flamewrought Key (Heroic)",
			general = "Hellfire Citadel\nRep: Thrallmar (Horde)\nRep: Honor Hold (Alliance)",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 63} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Watchkeeper Gargolmar", colour = AM_RED, coords = { {80, 24} }, symbol = { "1" },
					tooltiptxt = "", special = AM_WANDERS, lootid = "HCRampWatchkeeper" },
			dtl3  = { text = "Omor the Unscarred", colour = AM_RED, coords = { {22, 14} }, symbol = { "2" },
					tooltiptxt = "", lootid = "HCRampOmor" },
			dtl4  = { text = "Vazruden the Herald", colour = AM_RED, coords = { {16, 81} }, symbol = { "3" },
					tooltiptxt = "Kill both hellfire sentry to start encounter", lootid = "HCRampVazruden" },
			dtl5  = { text = "Nazan", colour = AM_RED, coords = { {16, 81} }, symbol = { " " },
					tooltiptxt = "", lootid = "HCRampNazan", leaveGap = 1 },
			dtl6  = { text = "Fel Iron Chest", colour = AM_BLUE, coords = { {16, 81} }, symbol = { " " },
					tooltiptxt = "", lootid = "HCRampFelIronChest", leaveGap = 1 }

		},

		{	name = "The Blood Furnace",		-- The Blood Furnace
			type = AM_TYP_INSTANCE,
			displayname = "HC: The Blood Furnace",
			displayshort = "BF",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCBloodFurnace",		-- HCBloodFurnace
			location = "Hellfire Peninsula",
			levels = "61-63",
			players = "5",
			prereq = "Key: Flamewrought Key (Heroic)",
			general = "Hellfire Citadel\nRep: Thrallmar (Horde)\nRep: Honor Hold (Alliance)",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 91.8} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "The Maker", colour = AM_RED, coords = { {29.3, 35} }, symbol = { "1" },
					tooltiptxt = "", lootid = "HCFurnaceMaker" },
			dtl3  = { text = "Broggok", colour = AM_RED, coords = { {41, 13.1} }, symbol = { "2" },
					tooltiptxt = "", lootid = "HCFurnaceBroggok" },
			dtl4  = { text = "Kell'dan the Breaker", colour = AM_RED, coords = { {65.6, 35.2} }, symbol = { "3" },
					tooltiptxt = "", lootid = "HCFurnaceBreaker", leaveGap = 1 }
		},

		{	name = "The Shattered Halls",		-- Shattered Halls
			type = AM_TYP_INSTANCE,
			displayname = "HC: The Shattered Halls",
			displayshort = "",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCShatteredHalls",		-- HCShatteredHalls
			location = "Hellfire Peninsula",
			levels = "70-72",
			players = "5",
			prereq = "Key: Shattered Halls Key\nKey: Flamewrought Key (Heroic)",
			general = "Hellfire Citadel\nRep: Thrallmar (Horde)\nRep: Honor Hold (Alliance)",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {67, 97.66} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Randy Whizzlesprocket", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { "1" },
					tooltiptxt = "", special = "(Alliance, Heroic)" },
			dtl3  = { text = "Drisella", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { " " },
					tooltiptxt = "", special = "(Horde, Heroic)" },
			dtl4  = { text = "Grand Warlock Nethekurse", colour = AM_RED, coords = { {23.63, 66.02} }, symbol = { "2" },
					tooltiptxt = "", lootid = "HCHallsNethekurse" },
			dtl5  = { text = "Blood Guard Porung", colour = AM_RED, coords = { {15.23, 10.55} }, symbol = { "3" },
					tooltiptxt = "", special = "(Heroic)", lootid = "HCHallsPorung" },
			dtl6  = { text = "Warbringer O'mrogg", colour = AM_RED, coords = { {57.42, 33.79} }, symbol = { "4" },
					tooltiptxt = "", lootid = "HCHallsOmrogg" },
			dtl7  = { text = "Warchief Kargath Bladefist", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { "5" },
					tooltiptxt = "", lootid = "HCHallsKargath" },
			dtl8  = { text = "Shattered Hand Executioner", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Heroic)", lootid = "HCHallsExecutioner" },
			dtl9  = { text = "Private Jacint (Alliance", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Alliance, Heroic)" },
			dtl10 = { text = "Rifleman Brownbeard", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Alliance, Heroic)" },
			dtl11 = { text = "Captain Alina", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Alliance, Heroic)" },
			dtl12 = { text = "Scout Orgarr", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Horde, Heroic)" },
			dtl13 = { text = "Korag Proudmane", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Horde, Heroic)" },
			dtl14 = { text = "Captain Boneshatter", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Horde, Heroic)", leaveGap = 1 },
			dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "HCHallsTrash" }
		},

		{	name = "Magtheridon's Lair",		-- Magtheridon's Lair
			type = AM_TYP_INSTANCE,
			displayname = "HC: Magtheridon's Lair",
			displayshort = "",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagtheridonsLair",		-- MagtheridonsLair
			location = "Hellfire Peninsula",
			levels = "70",
			players = "25",
			prereq = "Key: Flamewrought Key (Heroic)",
			general = "Hellfire Citadel\nRep: Thrallmar (Horde)\nRep: Honor Hold (Alliance)",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.44, 14.26} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Magtheridon", colour = AM_PURPLE, coords = { {53.13, 72.07} }, symbol = { "1" },
					tooltiptxt = "", lootid = "HCMagtheridon", leaveGap = 1 },
		},

		{	name = "The Slave Pens",		-- The Slave Pens
			type = AM_TYP_INSTANCE,
			displayname = "CFR: The Slave Pens",
			displayshort = "SP",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSlavePens",		-- TheSlavePens
			location = "Zangarmarsh",
			levels = "62-64",
			players = "5",
			prereq = "Key: Reservoir Key (Heroic)",
			general = "Coilfang Reservoir\nRep: Cenarion Expedition",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.24, 21.29} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Coilfang Reservoir"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Mennu the Betrayer", colour = AM_RED, coords = { {48.83, 31.84} }, symbol = { "1" },
					tooltiptxt = "", lootid = "CFRSlaveMennu" },
			dtl3  = { text = "Weeder Greenthumb", colour = AM_RED, coords = { {48.83, 71.29} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl4  = { text = "Skar'this the Heretic", colour = AM_RED, coords = { {58.2, 72.66} }, symbol = { "3" },
					tooltiptxt = "", special = "(Heroic)" },
			dtl5  = { text = "Rokmar the Cracker", colour = AM_RED, coords = { {57.81, 41.99} }, symbol = { "4" },
					tooltiptxt = "", lootid = "CFRSlaveRokmar" },
			dtl6  = { text = "Naturalist Bite", colour = AM_RED, coords = { {96.09, 61.13} }, symbol = { "5" },
					tooltiptxt = "" },
			dtl7  = { text = "Quagmirran", colour = AM_RED, coords = { {80.86, 72.27} }, symbol = { "6" },
					tooltiptxt = "", lootid = "CFRSlaveQuagmirran" }
		},

		{	name = "The Underbog",			-- The Underbog
			type = AM_TYP_INSTANCE,
			displayname = "CFR: The Underbog",
			displayshort = "UB",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheUnderbog",		-- TheUnderbog
			location = "Zangarmarsh",
			levels = "63-65",
			players = "5",
			prereq = "Key: Reservoir Key (Heroic)",
			general = "Coilfang Reservoir\nRep: Cenarion Expedition",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {120, 346} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Coilfang Reservoir"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Hungarfen", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { "1" },
					tooltiptxt = "", lootid = "CFRUnderHungarfen" },
			dtl3  = { text = "The Underspore", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Ghaz'an", colour = AM_RED, coords = { {81.84, 34.18} }, symbol = { "2" },
					tooltiptxt = "", lootid = "CFRUnderGhazan" },
			dtl5  = { text = "Earthbinder Rayge", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { "3" },
					tooltiptxt = "" },
			dtl6  = { text = "Windcaller Claw", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { " " },
					tooltiptxt = "" },
			dtl7  = { text = "Swamplord Musel'ek", colour = AM_RED, coords = { {39.84, 30.27} }, symbol = { "4" },
					tooltiptxt = "", lootid = "CFRUnderSwamplord" },
			dtl8  = { text = "The Black Stalker", colour = AM_RED, coords = { {21.09, 45.9} }, symbol = { "5" },
					tooltiptxt = "", lootid = "CFRUnderStalker", leaveGap = 1 }
		},

		{	name = "The Steamvault",			-- The Steamvault
			type = AM_TYP_INSTANCE,
			displayname = "CFR: The Steamvault",
			displayshort = "SV",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSteamvault",			-- The Steamvault
			location = "Zangarmarsh",
			levels = "70-72",
			players = "5",
			prereq = "Key: Reservoir Key (Heroic)",
			general = "Coilfang Reservoir\nRep: Cenarion Expedition",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 35.74} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Coilfang Reservoir"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Hydromancer Thespia", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { "1" },
					tooltiptxt = "Elite Lvl 72", lootid = "CFRSteamThespia" },
			dtl3  = { text = "Main Chamber Access Panel", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Second Fragment Guardian", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { "2" },
					tooltiptxt = "", lootid = "CFRSteamSecondFragmentGuardian" },
			dtl5  = { text = "Arcane Container", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { " " },
					tooltiptxt = "" },
			dtl6  = { text = "Mekgineer Steamrigger", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { "3" },
					tooltiptxt = "", lootid = "CFRSteamSteamrigger" },
			dtl7  = { text = "Main Chamber Access Panel", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { " " },
					tooltiptxt = "" },
			dtl8  = { text = "Warlord Kalithresh", colour = AM_RED, coords = { {92.19, 43.95} }, symbol = { "4" },
					tooltiptxt = "", lootid = "CFRSteamWarlord", leaveGap = 1 },
			dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "CFRSteamTrash" }
		},

		{	name = "Serpentshrine Cavern",			-- SerpentShrine Cavern
			type = AM_TYP_INSTANCE,
			displayname = "CFR: Serpentshrine Cavern",
			displayshort = "SC",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SerpentShrine",			-- SerpentshrineCavern
			location = "Zangarmarsh",
			levels = "70",
			players = "25",
			prereq = "",
			general = "Coilfang Reservoir\nRequires Attunement\nRep: Cenarion Expedition",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 67.19} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Coilfang Reservoir"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Hydross the Unstable", colour = AM_RED, coords = { {37.89, 75} }, symbol = { "1" },
					tooltiptxt = "", lootid = "CFRSerpentHydross" },
			dtl3  = { text = "The Lurker Below", colour = AM_RED, coords = { {40.82, 54.1} }, symbol = { "2" },
					tooltiptxt = "", lootid = "CFRSerpentLurker" },
			dtl4  = { text = "Leotheras the Blind", colour = AM_RED, coords = { {43.75, 27.15} }, symbol = { "3" },
					tooltiptxt = "", lootid = "CFRSerpentLeotheras" },
			dtl5  = { text = "Fathom-Lord Karathress", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { "4" },
					tooltiptxt = "", lootid = "CFRSerpentKarathress" },
			dtl6  = { text = "Seer Olum", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { " " },
					tooltiptxt = "" },
			dtl7  = { text = "Morogrim Tidewalker", colour = AM_RED, coords = { {66.02, 28.52} }, symbol = { "5" },
					tooltiptxt = "", lootid = "CFRSerpentMorogrim" },
			dtl8  = { text = "Lady Vashj", colour = AM_RED, coords = { {81.64, 55.47} }, symbol = { "6" },
					tooltiptxt = "", lootid = "CFRSerpentVashj", leaveGap = 1 },
			dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "CFRSerpentTrash" }
		},

		{	name = "Auchenai Crypts",			-- Auchenai Crypts
			type = AM_TYP_INSTANCE,
			displayname = "Auch: Auchenai Crypts",
			displayshort = "AC",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\AuchenaiCrypts",			-- AuchenaiCrypts
			location = "Terokkar Forest",
			levels = "64-66",
			players = "5",
			prereq = "Key: Auchenai Key (Heroic)",
			general = "Auchindoun\nRep: Lower City",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {22, 79.1} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Shirrak the Dead Watcher", colour = AM_RED, coords = { {44, 70} }, symbol = { "1" },
					tooltiptxt = "", lootid = "AuchCryptsShirrak" },
			dtl3  = { text = "Exarch Maladaar", colour = AM_RED, coords = { {88, 49} }, symbol = { "2" },
					tooltiptxt = "", lootid = "AuchCryptsExarch" },
			dtl4  = { text = "Avatar of the Martyred", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchCryptsAvatar" },
			dtl5  = { text = "D'ore", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl6  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchCryptsTrash" }
		},

		{	name = "Shadow Labyrinth",			-- Shadow Labyrinth
			type = AM_TYP_INSTANCE,
			displayname = "Auch: Shadow Labyrinth",
			displayshort = "SL",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowLabyrinth",			-- ShadowLabyrinth
			location = "Terokkar Forest",
			levels = "65-67",
			players = "5",
			prereq = "Key: Shadow Labyrinth Key\nKey: Auchenai Key (Heroic)",
			general = "Auchindoun\nRep: Lower City",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {6, 8.5} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Spy To'gun", colour = AM_RED, coords = { {14, 44} }, symbol = { "1" },
					tooltiptxt = "" },
			dtl3  = { text = "Ambassador Hellmaw", colour = AM_RED, coords = { {14, 44} }, symbol = { "2" },
					tooltiptxt = "", lootid = "AuchShadowHellmaw" },
			dtl4  = { text = "Blackheart the Inciter", colour = AM_RED, coords = { {20, 73} }, symbol = { "3" },
					tooltiptxt = "", lootid = "AuchShadowBlackheart" },
			dtl5  = { text = "Grandmaster Vorpil", colour = AM_RED, coords = { {55, 59} }, symbol = { "4" },
					tooltiptxt = "Codex of Blood", lootid = "AuchShadowGrandmaster" },
			dtl6  = { text = "Murmur", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "5" },
					tooltiptxt = "", lootid = "AuchShadowMurmur" },
			dtl7  = { text = "First Fragment Guardian", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "6" },
					tooltiptxt = "", lootid = "AuchShadowFirstFragmentGuardian" },
			dtl8  = { text = "Arcane Container", colour = AM_RED, coords = { {90.38, 37.7} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl9 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchShadowTrash" }
		},

		{	name = "Sethekk Halls",				-- Sethekk Halls
			type = AM_TYP_INSTANCE,
			displayname = "Auch: Sethekk Halls",
			displayshort = "SH",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SethekkHalls",			-- SethekkHalls
			location = "Terokkar Forest",
			levels = "67-69",
			players = "5",
			prereq = "Key: Essence-Infused Moonstone (Anzu)\nKey: Auchenai Key (Heroic)",
			general = "Auchindoun\nRep: Lower City",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {98, 46} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Darkweaver Syth", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "1" },
					tooltiptxt = "", lootid = "AuchSethekkDarkweaver" },
			dtl3  = { text = "Lakka", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "The Saga of Terokk", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "2" },
					tooltiptxt = "", lootid = "AuchSethekkTheSagaofTerokk" },
			dtl5  = { text = "Anzu", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchSethekkRavenGod", special = "(Heroic, Summoned)" },
			dtl6  = { text = "Talon King Ikiss", colour = AM_RED, coords = { {20, 18.5} }, symbol = { "3" },
					tooltiptxt = "", lootid = "AuchSethekkTalonKing", leaveGap = 1 },
			dtl7 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchSethekkTrash" }
		},

		{	name = "Mana-Tombs",				-- Mana Tombs
			type = AM_TYP_INSTANCE,
			displayname = "Auch: Mana-Tombs",
			displayshort = "MT",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ManaTombs",				-- ManaTombs
			location = "Terokkar Forest",
			levels = "70-72",
			players = "5",
			prereq = "Key: The Eye of Haramad (Exalted, Yor)\nKey: Auchenai Key (Heroic)",
			general = "Auchindoun\nRep: The Consortium",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 4.5} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Pandemonius", colour = AM_RED, coords = { {46, 30} }, symbol = { "1" },
					tooltiptxt = "", lootid = "AuchManaPandemonius" },
			dtl3  = { text = "Shadow Lord Xiraxis", colour = AM_RED, coords = { {46, 30} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Ambassador Pax'ivi", colour = AM_RED, coords = { {71.29, 16.41} }, symbol = { "2" },
					tooltiptxt = "", special = "(Heroic)" },
			dtl5  = { text = "Tavarok", colour = AM_RED, coords = { {71, 76} }, symbol = { "3" },
					tooltiptxt = "", lootid = "AuchManaTavarok" },
			dtl6  = { text = "Cryo-Engineer Sha'heen", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { "4" },
					tooltiptxt = "" },
			dtl7  = { text = "Ethereal Transporter Control Panel", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { " " },
					tooltiptxt = "" },
			dtl8  = { text = "Nexus-Prince Shaffar", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { "5" },
					tooltiptxt = "", lootid = "AuchManaNexusPrince" },
			dtl9  = { text = "Yor", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { " " },
					tooltiptxt = "Stasis Chamber", special = "(Heroic, Summoned)", lootid = "AuchManaYor", leaveGap = 1 },
			dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "AuchManaTrash" }
		},

		{	name = "Gruul's Lair",				-- Gruul's Lair
			type = AM_TYP_INSTANCE,
			displayname = "Gruul's Lair",
			displayshort = "GL",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\GruulsLair",			-- GruulsLair
			location = "Blade's Edge Mountain",
			levels = "70",
			players = "25",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {88, 76} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "High King Maulgar", colour = AM_RED, coords = { {55, 48} }, symbol = { "1" },
					tooltiptxt = "Boss", lootid = "GruulsLairHighKingMaulgar" },
			dtl3  = { text = "Kiggler the Crazed", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
					tooltiptxt = "", special = "(Shaman)" },
			dtl4  = { text = "Krosh Firehand", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
					tooltiptxt = "", special = "(Mage)" },
			dtl5  = { text = "Blindeye the Seer", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
					tooltiptxt = "", special = "(Priest)" },
			dtl6  = { text = "Olm the Summoner", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
					tooltiptxt = "", special = "(Warlock)" },
			dtl7  = { text = "Gruul the Dragonkiller", colour = AM_RED, coords = { {20, 27} }, symbol = { "2" },
					tooltiptxt = "Boss", lootid = "GruulGruul", leaveGap = 1 },
		},

		{	name = "Black Temple",				-- Black Temple
			type = AM_TYP_INSTANCE,
			displayname = "Black Temple",
			displayshort = "BT",
			continent = 3,
--			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Placeholder",
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackTemple",			-- BlackTemple
			location = "Shadowmoon Valley",
			levels = "70",
			players = "40",
			prereq = "Attunement Required\nKey: Medallion of Karabor",
			general = "Rep: Ashtongue Deathsworn",
			dtl1  = { text = "Black Temple Start", colour = AM_ORANGE, coords = { {5.27, 32.03} }, symbol = { "-" },
					tooltiptxt = "" },
			dtl2  = { text = "Black Temple Top", colour = AM_ORANGE, coords = { {49.61, 5.66} }, symbol = { "^" },
					tooltiptxt = "" },
			dtl3  = { text = "Black Temple Basement", colour = AM_ORANGE, coords = { {63.87, 60.74} }, symbol = { "v" },
					tooltiptxt = "", leaveGap = 1 },
			dtl4  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {7.62, 77.34} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
            dtl5  = { text = "Spirit of Olum", colour = AM_BLUE, coords = { {7.23, 72.07} }, symbol = { "1" },
					tooltiptxt = "", lootid = "BTNajentus" },
            dtl6  = { text = "High Warlord Naj'entus", colour = AM_RED, coords = { {24.8, 56.25} }, symbol = { "2" },
					tooltiptxt = "", lootid = "BTNajentus" },
			dtl7  = { text = "Supremus", colour = AM_RED, coords = { {21.29, 45.12} }, symbol = { "3" },
					tooltiptxt = "", lootid = "BTSupremus" },
            dtl8  = { text = "Shade of Akama", colour = AM_RED, coords = { {33.59, 63.09} }, symbol = { "4" },
					tooltiptxt = "", lootid = "BTAkama" },
            dtl9  = { text = "Spirit of Udalo", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { "5" },
					tooltiptxt = "" },
            dtl10 = { text = "Aluyen", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
					tooltiptxt = "", special = "(Reagent Vendor)" },
            dtl11 = { text = "Okuno", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
					tooltiptxt = "(Ashtongue Deathsworn)", special = "(Quartermaster)" },
            dtl12 = { text = "Seer Kanai", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl13 = { text = "Path to Teron Gorefiend", colour = AM_GREEN, coords = { {48.83, 51.76}, {79.1, 78.32} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl14 = { text = "Path to Reliquary of Souls", colour = AM_GREEN, coords = { {48.83, 37.5}, {84.18, 67.38} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl15 = { text = "Path to Illidan Stormrage", colour = AM_GREEN, coords = { {23.83, 33.2}, {58.2, 10.74} }, symbol = { "P" },
					tooltiptxt = "", leaveGap = 1 },
			dtl16  = { text = "Gurtogg Bloodboil", colour = AM_RED, coords = { {75.59, 57.23} }, symbol = { "6" },
					tooltiptxt = "", lootid = "BTBloodboil" },
			dtl17 = { text = "Reliquary of Souls", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { "7" },
					tooltiptxt = "", lootid = "BTEssencofSouls" },
			dtl18 = { text = "Essence of Anger", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl19 = { text = "Essence of Desire", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl20 = { text = "Essence of Suffering", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
					tooltiptxt = "" },
			dtl21 = { text = "Teron Gorefiend", colour = AM_RED, coords = { {59.77, 81.45} }, symbol = { "8" },
					tooltiptxt = "", lootid = "BTGorefiend" },
			dtl22 = { text = "Mother Shahraz", colour = AM_RED, coords = { {92.77, 4.88} }, symbol = { "9" },
					tooltiptxt = "", lootid = "BTShahraz" },
			dtl23 = { text = "Illidari Council", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { "10" },
					tooltiptxt = "", lootid = "BTCouncil" },
			dtl24 = { text = "Lady Malande", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
					tooltiptxt = "", special = "(Priest)" },
			dtl25 = { text = "Gathios the Shatterer", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
					tooltiptxt = "", special = "(Paladin)" },
			dtl26 = { text = "High Nethermancer Zerevor", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
					tooltiptxt = "", special = "(Mage)" },
			dtl27 = { text = "Veras Darkshadow", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
					tooltiptxt = "", special = "(Rogue)" },
            dtl28  = { text = "Illidan Stormrage", colour = AM_RED, coords = { {59.18, 36.13} }, symbol = { "11" },
					tooltiptxt = "", lootid = "BTIllidanStormrage", leaveGap = 1 },
			dtl29 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "BTPatterns" },
			dtl30 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "BTTrash" }
		},

		{	name = "The Mechanar",				-- The Mechanar
			type = AM_TYP_INSTANCE,
			displayname = "TK: The Mechanar",
			displayshort = "Mech",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Mechanar",			-- TheMechanar
			location = "Netherstorm",
			levels = "69-72",
			players = "5",
			prereq = "Key: Warpforged Key (Heroic)",
			general = "Tempest Keep\nRep: The Sha'tar",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {43, 92.5} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Gatewatcher Gyro-Kill", colour = AM_RED, coords = { {46, 56} }, symbol = { "1" },
					tooltiptxt = "", lootid = "TKMechGyro" },
			dtl3  = { text = "Gatewatcher Iron-Hand", colour = AM_RED, coords = { {64.5, 52} }, symbol = { "2" },
					tooltiptxt = "", lootid = "TKMechIron" },
			dtl4  = { text = "Cache of the Legion", colour = AM_RED, coords = { {64.5, 52} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKMechCacheoftheLegion" },
			dtl5  = { text = "Mechano-Lord Capacitus", colour = AM_RED, coords = { {58, 37} }, symbol = { "3" },
					tooltiptxt = "", lootid = "TKMechCapacitus" },
			dtl6  = { text = "Overcharged Manacell", colour = AM_RED, coords = { {58, 37} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKMechOverchargedManacell" },
			dtl7  = { text = "Nethermancer Sepethrea", colour = AM_RED, coords = { {47, 9.9} }, symbol = { "4" },
					tooltiptxt = "", lootid = "TKMechSepethrea" },
			dtl8  = { text = "Pathaleon the Calculator", colour = AM_RED, coords = { {18.5, 47} }, symbol = { "5" },
					tooltiptxt = "", lootid = "TKMechCalc", leaveGap = 1 },
			dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKMechTrash" }
		},
--60
		{	name = "The Botanica",				-- The Botanica
			type = AM_TYP_INSTANCE,
			displayname = "TK: The Botanica",
			displayshort = "Bota",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Botanica",			-- TheBotanica
			location = "Netherstorm",
			levels = "70-72",
			players = "5",
			prereq = "Key: Warpforged Key (Heroic)",
			general = "Tempest Keep\nRep: The Sha'tar",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {96.2, 44.8} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Commander Sarannis", colour = AM_RED, coords = { {45, 30} }, symbol = { "1" },
					tooltiptxt = "", lootid = "TKBotSarannis" },
			dtl3  = { text = "High Botanist Freywinn", colour = AM_RED, coords = { {24, 30} }, symbol = { "2" },
					tooltiptxt = "", lootid = "TKBotFreywinn" },
			dtl4  = { text = "Thorngrin the Tender", colour = AM_RED, coords = { {9, 47} }, symbol = { "3" },
					tooltiptxt = "", lootid = "TKBotThorngrin" },
			dtl5  = { text = "Laj", colour = AM_RED, coords = { {35, 69} }, symbol = { "4" },
					tooltiptxt = "", lootid = "TKBotLaj" },
			dtl6  = { text = "Warp Splinter", colour = AM_RED, coords = { {34.5, 40} }, symbol = { "5" },
					tooltiptxt = "", lootid = "TKBotSplinter", leaveGap = 1 },
			dtl7  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKBotTrash" }
		},

		{	name = "The Arcatraz",				-- The Arcatraz
			type = AM_TYP_INSTANCE,
			displayname = "TK: The Arcatraz",
			displayshort = "Arca",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Arcatraz",			-- TheArcatraz
			location = "Netherstorm",
			levels = "70-72",
			players = "5",
			prereq = "Key: Key to the Arcatraz\nKey: Warpforged Key (Heroic)",
			general = "Tempest Keep\nRep: The Sha'tar",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {38, 98} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Zereketh the Unbound", colour = AM_RED, coords = { {45.5, 58.5} }, symbol = { "1" },
					tooltiptxt = "", lootid = "TKArcUnbound" },
			dtl3  = { text = "Third Fragment Guardian", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { "2" },
					tooltiptxt = "", lootid = "TKArcThirdFragmentGuardian" },
			dtl4  = { text = "Arcane Container", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { " " },
					tooltiptxt = "" },
			dtl5  = { text = "Wrath-Scryer Soccothrates", colour = AM_RED, coords = { {11.5, 70} }, symbol = { "3" },
					tooltiptxt = "", lootid = "TKArcScryer" },
			dtl6  = { text = "Dalliah the Doomsayer", colour = AM_RED, coords = { {31, 70} }, symbol = { "4" },
					tooltiptxt = "", lootid = "TKArcDalliah" },
			dtl7  = { text = "Seer Udalo", colour = AM_RED, coords = { {37.89, 15.04} }, symbol = { "5" },
					tooltiptxt = "" },
			dtl8  = { text = "Harbinger Skyriss", colour = AM_RED, coords = { {73.5, 17} }, symbol = { "6" },
					tooltiptxt = "", lootid = "TKArcHarbinger" },
			dtl9  = { text = "Warden Mellichar", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
					tooltiptxt = "" },
			dtl10 = { text = "Millhouse Manastorm", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKArcTrash" }
		},

		{	name = "Old Hillsbrad Foothills",		-- Old Hillsbrad
			type = AM_TYP_INSTANCE,
			displayname = "CoT: Old Hillsbrad",
			displayshort = "CoT1",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OldHilsbrad",			-- OldHilsbrad
			location = "Caverns of Time",
			levels = "",
			players = "",
			prereq = "Attunement Required\nKey: Key of Time (Heroic)",
			general = "Tanaris\nEvent: Escape from Durnholde Keep\nRep: Keepers of Time",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {13, 47} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Caverns of Time"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Erozion", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
					tooltiptxt = "" },
			dtl3  = { text = "Brazen", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Lieutenant Drake", colour = AM_RED, coords = { {83, 64.5} }, symbol = { "1" },
					tooltiptxt = "", lootid = "CoTHillsbradDrake" },
			dtl5  = { text = "Thrall", colour = AM_BLUE, coords = { {79.49, 57.23} }, symbol = { "2" },
					tooltiptxt = "(Lower)", lootid = "CoTHillsbradDrake" },
			dtl6  = { text = "Captain Skarloc", colour = AM_RED, coords = { {72, 68} }, symbol = { "3" },
					tooltiptxt = "", lootid = "CoTHillsbradSkarloc" },
			dtl7  = { text = "Thrall's Second Stop", colour = AM_BLUE, coords = { {72, 68} }, symbol = { " " },
					tooltiptxt = "" },
			dtl8  = { text = "Thrall's Third Stop", colour = AM_BLUE, coords = { {47.07, 41.41} }, symbol = { "4" },
					tooltiptxt = "" },
			dtl9  = { text = "Epoch Hunter", colour = AM_RED, coords = { {44.5, 30.5} }, symbol = { "5" },
					tooltiptxt = "", lootid = "CoTHillsbradHunter" },
			dtl10 = { text = "Thrall's Fourth Stop", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
					tooltiptxt = "(Upper)" },
			dtl11 = { text = "Taretha", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
					tooltiptxt = "(Upper)" },
			dtl12 = { text = "Jonathan Revah", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { "6" },
					tooltiptxt = "" },
			dtl13 = { text = "Jerry Carter", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl14 = { text = "Thomas Yance", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "7" },
					tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradThomasYance" },
			dtl15 = { text = "Aged Dalaran Wizard", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "8" },
					tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradAgedDalaranWizard", leaveGap = 1 }
		},

		{	name = "Black Morass",				-- The Black Morass
			type = AM_TYP_INSTANCE,
			displayname = "CoT: Black Morass",
			displayshort = "CoT2",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackMorass",			-- The Black Morass
			location = "Caverns of Time",
			levels = "",
			players = "",
			prereq = "Attunement Required\nKey: Key of Time (Heroic)",
			general = "Tanaris\nEvent: Opening of the Dark Portal\nRep: Keepers of Time",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45.4, 22} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", special = "Sa'at", toMap = "Caverns of Time"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Spawn Points", colour = AM_RED, coords = { {58, 70}, {58.5, 61.5}, {41, 60.5}, {48, 52.5} }, symbol = { "P" },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Chrono Lord Deja", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", special = "(Wave 6)", lootid = "CoTMorassDeja" },
			dtl4  = { text = "Temporus", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", special = "(Wave 12)", lootid = "CoTMorassTemporus" },
			dtl5  = { text = "Aeonus", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", special = "(Wave 18)", lootid = "CoTMorassAeonus", leaveGap = 1 },
			dtl5  = { text = "The Dark Portal", colour = AM_BLUE, coords = { {44.14, 74.22} }, symbol = { "1" },
					tooltiptxt = "", special = "Medivh" },
		},

		{	name = "Battle for Mount Hyjal",		-- Battle for Mount Hyjal
			type = AM_TYP_INSTANCE,
			displayname = "CoT: Hyjal Summit",
			displayshort = "CoT3",
			continent = 1,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MountHyjal",			-- Battle for Mount Hyjal
			location = "Caverns of Time",
			levels = "70",
			players = "25",
			prereq = "Attunement Required\n",
			general = "Tanaris\nEvent: The Battle for Mount Hyjal\nRep: The Scale of the Sands",
			dtl1  = { text = "Alliance Base", colour = AM_GREEN, coords = { {18.36, 48.83} }, symbol = { "A" },
					tooltiptxt = "", toMap = "Caverns of Time"..AM_EXTERIOR, special = "(Lady Jaina Proudmoore)" },
			dtl2  = { text = "Horde Base", colour = AM_GREEN, coords = { {57.23, 35.74} }, symbol = { "B" },
					tooltiptxt = "", special = "(Thrall)" },
			dtl3  = { text = "Night Elf Base", colour = AM_GREEN, coords = { {75.39, 44.34} }, symbol = { "C" },
					tooltiptxt = "", special = "(Tyrande Whisperwind)", leaveGap = 1 },
            dtl4  = { text = "Rage Winterchill", colour = AM_RED, coords = { {21.48, 46.88} }, symbol = { "1" },
					tooltiptxt = "", lootid = "MountHyjalWinterchill" },
			dtl5  = { text = "Anetheron", colour = AM_RED, coords = { {21.48, 50.98} }, symbol = { "2" },
					tooltiptxt = "", lootid = "MountHyjalAnetheron" },
			dtl6  = { text = "Kaz'rogal", colour = AM_RED, coords = { {58.98, 32.81} }, symbol = { "3" },
					tooltiptxt = "", lootid = "MountHyjalKazrogal" },
			dtl7  = { text = "Azgalor", colour = AM_RED, coords = { {58.98, 38.67} }, symbol = { "4" },
					tooltiptxt = "", lootid = "MountHyjalAzgalor" },
            dtl8  = { text = "Archimonde", colour = AM_RED, coords = { {83.01, 31.25} }, symbol = { "5" },
					tooltiptxt = "", lootid = "MountHyjalArchimonde" },
--			dtl9 = { text = "Indormi", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = ""},
--			dtl10 = { text = "Tydormu", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "" },
		},

		{	name = "Karazhan",				-- Karazhan
			type = AM_TYP_INSTANCE,
			displayname = "Karazhan",
			displayshort = "Kara",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Karazahn",				-- Karazhan
			location = "Deadwind Pass",
			levels = "70",
			players = "10",
			prereq = "Attunement Required\nKey: The Master's Key\nKey: Blackened Urn (Nightbane)",
			general = "Rep: The Violet Eye",
			dtl1  = { text = "Front Entrance", colour = AM_GREEN, coords = { {29.88, 31.45} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Karazhan"..AM_EXTERIOR, leaveGap = 1 },
			dtl2  = { text = "Back Entrance", colour = AM_GREEN, coords = { {28.13, 20.31} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", toMap = "Karazhan"..AM_EXTERIOR, leaveGap = 1 },
			dtl3  = { text = "Hastings", colour = AM_BLUE, coords = { {27.93, 25.39} }, symbol = { "a" },
					tooltiptxt = "", special = "The Caretaker" },
			dtl4  = { text = "Berthold", colour = AM_BLUE, coords = { {23.05, 25.98} }, symbol = { "b" },
					tooltiptxt = "", special = "The Doorman" },
			dtl5  = { text = "Moroes", colour = AM_RED, coords = { {23.05, 25.98}, {65.23, 23.24} }, symbol = { "1" },
					tooltiptxt = "", special = "(Staircase to the Ballroom)", lootid = "KaraMoroes" },
			dtl6  = { text = "Calliard", colour = AM_BLUE, coords = { {23.44, 33.4} }, symbol = { "c" },
					tooltiptxt = "", special = "The Nightman" },
			dtl7  = { text = "Attumen the Huntsman", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { "2" },
					tooltiptxt = "", lootid = "KaraAttumen" },
			dtl8  = { text = "Midnight", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1 },
			dtl9  = { text = "Koren", colour = AM_BLUE, coords = { {16.02, 30.47} }, symbol = { "d" },
					tooltiptxt = "", special = "The Blacksmith" },
			dtl10 = { text = "Stairs to Upper Stable", colour = AM_GREEN, coords = { {18.55, 37.5} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl11 = { text = "Bennett", colour = AM_BLUE, coords = { {19.53, 35.55} }, symbol = { "e" },
					tooltiptxt = "", special = "The Sergeant at Arms" },
			dtl12 = { text = "Ebonlocke", colour = AM_BLUE, coords = { {74.8, 36.52} }, symbol = { "f" },
					tooltiptxt = "", special = "The Noble" },
			dtl13 = { text = "The Servant's Quarters", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { "S" },
					tooltiptxt = "Random Boss" },
			dtl14 = { text = "Hyakiss the Lurker", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
					tooltiptxt = "", lootid = "KaraNamed" },
			dtl15 = { text = "Rakad the Ravager", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
					tooltiptxt = "", lootid = "KaraNamed" },
			dtl16 = { text = "Shadikith the Glider", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
					tooltiptxt = "", lootid = "KaraNamed", leaveGap = 1 },
			dtl17 = { text = "Ramp to the Guest Chambers", colour = AM_GREEN, coords = { {17.77, 3.32}, {73.24, 10.16} }, symbol = { "P" },
					tooltiptxt = "", },
			dtl18 = { text = "Keanna's Log", colour = AM_ORANGE, coords = { {82.52, 4.69} }, symbol = { "3" },
					tooltiptxt = "", lootid = "KaraKeannaLog" },
			dtl19 = { text = "Maiden of Virtue", colour = AM_RED, coords = { {92.38, 16.21} }, symbol = { "4" },
					tooltiptxt = "", lootid = "KaraMaiden" },
			dtl20 = { text = "Stairs to Opera House Orchestra Level", colour = AM_GREEN, coords = { {84.18, 15.04} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl21 = { text = "Sebastian", colour = AM_BLUE, coords = { {55.08, 18.55} }, symbol = { "g" },
					tooltiptxt = "", special = "The Organist" },
			dtl22 = { text = "Barnes", colour = AM_BLUE, coords = { {51.95, 10.35} }, symbol = { "h" },
					tooltiptxt = "", special = "The Stage Manager" },
			dtl23 = { text = "The Opera House", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { "O" },
					tooltiptxt = "Random Boss", lootid = "KaraOperaEvent" },
			dtl24 = { text = "The Wizard of Oz", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
					tooltiptxt = "", special = "(Random)", lootid = "KaraOperaEvent" },
			dtl25 = { text = "Little Red Riding Hood", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
					tooltiptxt = "", special = "(Random)", lootid = "KaraOperaEvent" },
			dtl26 = { text = "Romulo & Julianne", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
					tooltiptxt = "", special = "(Random)", lootid = "KaraOperaEvent" },
			dtl27 = { text = "Ramp from Mezzanine to Balcony", colour = AM_GREEN, coords = { {62.11, 8.79} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl28 = { text = "The Master's Terrace", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { "T" },
					tooltiptxt = "" },
			dtl29 = { text = "Nightbane", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { " " },
					tooltiptxt = "", special = "(Summoned)", lootid = "KaraOperaEvent" },
			dtl30 = { text = "Path to the Broken Stairs", colour = AM_GREEN, coords = { {30.66, 24.02} }, symbol = { "P" },
					tooltiptxt = "", special = "(Upper)" },
			dtl31 = { text = "The Broken Stairs", colour = AM_GREEN, coords = { {18.36, 24.41} }, symbol = { "P" },
					tooltiptxt = "", special = "(Upper)" },
			dtl32 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "" },
			dtl33 = { text = "The Curator", colour = AM_RED, coords = { {10.16, 35.16} }, symbol = { "5" },
					tooltiptxt = "", lootid = "KaraCurator" },
			dtl34 = { text = "Connects :", colour = AM_GREEN, coords = { {13.67, 44.92}, {30.47, 68.55} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl35 = { text = "Wravien", colour = AM_BLUE, coords = { {23.24, 69.73} }, symbol = { "i" },
					tooltiptxt = "", special = "The Mage" },
			dtl36 = { text = "Gradav", colour = AM_BLUE, coords = { {17.97, 69.34} }, symbol = { "j" },
					tooltiptxt = "", special = "The Warlock" },
			dtl37 = { text = "Kamsis", colour = AM_BLUE, coords = { {16.41, 73.83} }, symbol = { "k" },
					tooltiptxt = "", special = "The Conjurer" },
			dtl38 = { text = "Ramp to Guardian's Library", colour = AM_GREEN, coords = { {19.92, 76.56} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl39 = { text = "Suspicious Bookshelf", colour = AM_GREEN, coords = { {20.51, 66.6} }, symbol = { "P" },
					tooltiptxt = "(-> Terestian Illhoof)" },
			dtl40 = { text = "Terestian Illhoof", colour = AM_RED, coords = { {17.19, 72.85} }, symbol = { "6" },
					tooltiptxt = "", special = "Kil'rek (Imp)", lootid = "KaraIllhoof" },
			dtl41 = { text = "Shade of Aran", colour = AM_RED, coords = { {33.2, 66.21} }, symbol = { "7" },
					tooltiptxt = "", lootid = "KaraAran" },
			dtl42 = { text = "Ramp up to the Celestial Watch", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
					tooltiptxt = "", special = "Netherspite" },
			dtl43 = { text = "Ramp down to the Gamesman's Hall", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
					tooltiptxt = "", special = "Chess Event" },
			dtl44 = { text = "Netherspite", colour = AM_RED, coords = { {9.38, 65.82} }, symbol = { "8" },
					tooltiptxt = "", lootid = "KaraNetherspite" },
			dtl45 = { text = "Ythar", colour = AM_GREEN, coords = { {27.15, 66.21} }, symbol = { "l" },
					tooltiptxt = "", special = "Repair and Rewards" },
			dtl46 = { text = "Connects :", colour = AM_GREEN, coords = { {26.76, 63.48}, {62.5, 39.84} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl47 = { text = "Echo of Medivh", colour = AM_BLUE, coords = { {65.04, 37.5} }, symbol = { "k" },
					tooltiptxt = "" },
			dtl48 = { text = "Chess Event", colour = AM_RED, coords = { {67.58, 34.96} }, symbol = { "9" },
					tooltiptxt = "", lootid = "KaraChess" },
			dtl49 = { text = "Ramp to Medivh's Chamber", colour = AM_GREEN, coords = { {63.09, 29.88} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl50 = { text = "Spiral Stairs to Netherspace", colour = AM_GREEN, coords = { {81.64, 32.62} }, symbol = { "P" },
					tooltiptxt = "", special = "Prince" },
			dtl51 = { text = "Prince Malchezaar", colour = AM_RED, coords = { {76.37, 31.05} }, symbol = { "10" },
					tooltiptxt = "Defeat to allow summoning of Nightbane", special = "Leads to...", lootid = "KaraPrince" },
		},

		{	name = "Zul'Aman",				-- Zul'Aman
			type = AM_TYP_INSTANCE,
			displayname = "Zul'Aman",
			displayshort = "ZA",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulAman",				-- Zul'Aman
			location = "Ghostlands",
			levels = "70",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 53} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Nalorakk", colour = AM_RED, coords = { {36.3, 71.9} }, symbol = { "1" },
					tooltiptxt = "", special = "(Bear)", lootid = "ZANalorakk" },
			dtl3  = { text = "Akil'Zon", colour = AM_RED, coords = { {31.25, 31.25} }, symbol = { "2" },
					tooltiptxt = "", special = "(Eagle)", lootid = "ZAAkilZon" },
			dtl4  = { text = "Jan'Alai", colour = AM_RED, coords = { {53.3, 67.2} }, symbol = { "3" },
					tooltiptxt = "", special = "(Dragonhawk)", lootid = "ZAJanAlai" },
			dtl5  = { text = "Halazzi", colour = AM_RED, coords = { {56.05, 36.62} }, symbol = { "4" },
					tooltiptxt = "", special = "(Lynx)", lootid = "ZAHalazzi" },
			dtl6  = { text = "Hex Lord Malacrass", colour = AM_RED, coords = { {68.75, 54.9} }, symbol = { "5" },
					tooltiptxt = "", lootid = "ZAMalacrass" },
			dtl7  = { text = "Zul'Jin", colour = AM_RED, coords = { {91.4, 54.7} }, symbol = { "6" },
					tooltiptxt = "", lootid = "ZAZuljin", leaveGap = 1 },
		},

		{	name = "The Eye",				-- The Eye
			type = AM_TYP_INSTANCE,
			displayname = "TK: The Eye",
			displayshort = "Eye",
			continent = 3,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheEye",			-- TheEye
			location = "Netherstorm",
			levels = "69-72",
			players = "5",
			prereq = "Key: Warpforged Key (Heroic)",
			general = "Tempest Keep\nRep: The Sha'tar",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Al'ar", colour = AM_RED, coords = { {50, 57} }, symbol = { "1" },
					tooltiptxt = "", lootid = "TKEyeAlar" },
			dtl3  = { text = "Void Reaver", colour = AM_RED, coords = { {14, 47} }, symbol = { "2" },
					tooltiptxt = "", lootid = "TKEyeVoidReaver" },
			dtl4  = { text = "High Astromancer Solarian", colour = AM_RED, coords = { {86, 47} }, symbol = { "3" },
					tooltiptxt = "", lootid = "TKEyeSolarian" },
			dtl5  = { text = "Prince Kael'thas Sunstrider", colour = AM_RED, coords = { {50, 13} }, symbol = { "4" },
					tooltiptxt = "", lootid = "TKEyeKaelthas" },
			dtl6  = { text = "Thaladred the Darkener", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
					tooltiptxt = "", special = "(Warrior)" },
			dtl7  = { text = "Master Engineer Telonicus", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
					tooltiptxt = "", special = "(Hunter)" },
			dtl8  = { text = "Grand Astromancer Capernian", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
					tooltiptxt = "", speical = "(Mage)" },
			dtl9  = { text = "Lord Sanguinar", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
					tooltiptxt = "", special = "(Paladin)", leaveGap = 1 },
			dtl10 = { text = "Legendary", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKEyeLegendaries" },
			dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", lootid = "TKEyeTrash" },
		},

		{	name = "Magister's Terrace",				-- Magister's Terrace
			type = AM_TYP_INSTANCE,
			displayname = "Magister's Terrace",
			displayshort = "MagT",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagistersTerrace",			-- Magister's Terrace
			location = "Isle of Quel'Danas",
			levels = "69-72",
			players = "5",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {42.19, 78.32} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Selin Fireheart", colour = AM_RED, coords = { {42.19, 26.17} }, symbol = { "1" },
					tooltiptxt = "", lootid = "SMTFireheart" },
--			dtl3  = { text = "Fel Crystals", colour = AM_ORANGE, coords = { {43.36, 37.5}, {43.36, 50.2}, {42.19, 29.88}, {50.39, 50.2}, {50.39, 37.5} }, symbol = { "C" },
			dtl3  = { text = "Fel Crystals", colour = AM_ORANGE, coords = { {42.19, 26.17} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Tyrith", colour = AM_GREEN, coords = { {59.96, 29.88} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl5  = { text = "Vexallus", colour = AM_RED, coords = { {83.4, 31.84} }, symbol = { "3" },
					tooltiptxt = "", lootid = "SMTVexallus" },
			dtl6  = { text = "Scrying Orb", colour = AM_GREEN, coords = { {94.53, 31.64} }, symbol = { "4" },
					tooltiptxt = "", special = "(Kalecgos)" },
			dtl7  = { text = "Priestess Delrissa", colour = AM_RED, coords = { {38.67, 52.54} }, symbol = { "5" },
					tooltiptxt = "", special = "(Lower Level)", lootid = "SMTDelrissa" },
			dtl8  = { text = "Kael'Thas Sunstrider", colour = AM_RED, coords = { {6.05, 48.24} }, symbol = { "6" },
					tooltiptxt = "", lootid = "SMTKaelthas", leaveGap = 1 },
			dtl9 = { text = "Exit", colour = AM_BLUE, coords = { {2.73, 47.85} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", special = "(Orb)", leaveGap = 1 },
			dtl10 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1, lootid = "SMTTrash" },
		},

		{	name = "Sunwell Plateau",				-- Sunwell Plateau
			type = AM_TYP_INSTANCE,
			displayname = "Sunwell Plateau",
			displayshort = "SunP",
			continent = 2,
			filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SunwellPlateau",			-- Sunwell Plateau
			location = "Isle of Quel'Danas",
			levels = "69-72",
			players = "40",
			prereq = "",
			general = "",
			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {31.45, 17.19} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl2  = { text = "Kalecgos", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { "1" },
					tooltiptxt = "", lootid = "SPKalecgos" },
			dtl3  = { text = "Sathrovarr the Corruptor", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { " " },
					tooltiptxt = "" },
			dtl4  = { text = "Madrigosa", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { "2" },
					tooltiptxt = "" },
			dtl5  = { text = "Brutallus", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
					tooltiptxt = "", lootid = "SPBrutallus" },
			dtl6  = { text = "Felmyst", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
					tooltiptxt = "", lootid = "SPFelmyst" },
			dtl7  = { text = "???", colour = AM_GREEN, coords = { {74.41, 33.2} }, symbol = { "3" },
					tooltiptxt = "" },
			dtl8  = { text = "Eredar Twins", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { "4" },
					tooltiptxt = "", special = "(Lower)", lootid = "SPEredarTwins" },
			dtl9  = { text = "Grand Warlock Alythess", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
					tooltiptxt = "", special = "(Lower)" },
			dtl10 = { text = "Lady Sacrolash", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
					tooltiptxt = "", special = "(Lower)" },
			dtl11 = { text = "M'uru", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { "5" },
					tooltiptxt = "", special = "(Upper)" },
			dtl12 = { text = "Entropius", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { " " },
					tooltiptxt = "", special = "(Upper)" },
			dtl13 = { text = "Kil'jaeden", colour = AM_GREEN, coords = { {61.71, 32.62} }, symbol = { "6" },
					tooltiptxt = "", leaveGap = 1, lootid = "SPKiljaeden" },
			dtl14 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "", leaveGap = 1, lootid = "SPTrash" },
		},

};



---------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------
-- Below is the template for Adding new Instance Maps with Text and Information
-- The fields   name, type, filename, location, levels, and players   are Mandatory
-- All other fields are optional and can be deleted or left blank
-- Fields can contain multiple co-ordinates up to a maximum of AM_MAX_MULT_COORDS which
--  is set to 8 by default - Different symbols can be used at each coordinate, or just 1
-- As long as a blp/tga exists with the given filename, then nothing else needs to be
-- done to see notes on the map
-- Use 'lootid = ""' where a link to Atlas Loot information exists - must be the same as the id
--  used in that AddOn to identify the mob/set
-- Use 'toMap = ""' to place a link to a different map, e.g. links between DM West and North,
--  so that when the user clicks on the button, the map changes to the other
-- Use 'special = ' to add information such as Rare/Wanders, etc to the Key in a different colour
-- Use 'leaveGap = x' where 'x' is a number specifying the size of the gap to appear AFTER the
--  current Map Key entry
-- A symbol of "" will be blank on the map and the key. A symbol of " " will use the default
-- After 32 dtl_ fields, there will be a page break on the Map Key with arrows to show the
-- the other fields.  You can control where the page break appears amongst your notes by
-- padding with extra blank dtl_ records as per Alterac Valley above
--
-- COORDINATE MAPPING
-- wmData and amData are used to translate WorldMap coordinates in to coordinates on the
-- Instance style map. Obviously this won't help in an Instance as player coordinates are
-- not given, but plotting player positions is possible in BattleGrounds and in 'external'
-- dungeons/raid maps  -  The basic process for calulating these figures is as follows :
--  First create your map to be displayed in AlphaMap so you can see it in game and it is
--    possible to mark down mouse coordinates
--  Then move to the Far West of the dungeon/location and record your Player coordinates as
--    they would be calculated by GetPlayerMapPosition("player") - In caves like Gnomeregan and Maraudon
--    the player coordinates are actually your coords on the Continent. For Azuregos and other maps,
--    the player coordinates are normal map coords - call the West most 'X' coordinate wmData.minX
--  Then display the AlphaMap of the area, and move your mouse to the point where your player
--    is and mark down the cursor coords - call the mouse's 'X' coordinate amData.minX
--  Basically, the furthest West point of the AlphaMap is the Minimum X value where a player
--    can be displayed on the map and wmData.minX on the WorldMap is equivalent to amData.minX on the
--    AlphaMap
--  Then repeat this process for the furthest Eastern point and wmData.maxX = amData.maxX
--  Then repeat for Northern and Southern most points, .minY and maxY
--  AlphaMap should then use these comparitive coordinate systems to plot your player positions
--    on the AlphaMap based on World Map coordinates
--  This process can take a lot of fine tuning.  I found 5 decimal places was accurate enough when
--    dealing with Continent based player coords for cave systems.  Also be very wary of the fact
--    that some maps are slightly rotated in game, which can make your coordinate system accurate
--    in the middle, but with increasing variance toward the edges of the map. Also, if you make
--    any errors when you create the map, by overlapping tiles or stretching one to make it fit,
--    or whatever,  then these kinds of issues can result in strange coordinate problems too.
--
--------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------
--		{	name = "",
--			type = AM_TYP_INSTANCE,
--			displayname = "",
--			filename = "",
--			location = "",
--			levels = "",
--			players = "",
--			prereq = "",
--			general = "",
--			dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_ENTRANCE_SYMBOL },
--					tooltiptxt = "" },
--			dtl2  = { text = AM_INSTANCE_EXITS, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_EXIT_SYMBOL },
--					tooltiptxt = "" },
--			dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {0, 0} }, symbol = { AM_CHEST_SYMBOL },
--					tooltiptxt = "" },
--			dtl4  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_STAIRS_SYMBOL },
--					tooltiptxt = "", toMap = "", leaveGap = 1,  },
--			dtl5  = { text = "", colour = AM_RED, coords = { {0, 0} }, symbol = { "0" },
--					tooltiptxt = "", special = AM_RARE..AM_WANDERS, leaveGap = 2  },
--			dtl6  = { text = "", colour = AM_RED, coords = { {0, 0} }, symbol = { "0" },
--					tooltiptxt = ""  },
--			dtl7  = { text = "", colour = AM_RED, coords = { {0, 0} }, symbol = { "0" },
--					tooltiptxt = ""  },
--			...............
--		}
--
---------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------


