--------------------------------------------------------------------------
-- localization.lua <German>
-- Translation by : Eike Hanus, StarDust
-- Last Update : 8/23/2006
--------------------------------------------------------------------------

-- Ä: C3 84 - \195\132 - 
-- Ö: C3 96 - \195\150 - 
-- Ü: C3 9C - \195\156 - 
-- ß: C3 9F - \195\159 - 
-- ä: C3 A4 - \195\164 - 
-- ö: C3 B6 - \195\182 - 
-- ü: C3 BC - \195\188 - 

if ( GetLocale() == "deDE" ) then

	AM_TYP_INSTANCE 	= "Instanzen";

	AM_ALPHAMAP_INSTANCES_LIST = {

			{	name = "Blackfathom-Tiefen",			-- Blackfathom-Tiefen
				type = AM_TYP_INSTANCE,
				displayname = "Blackfathom-Tiefen",
				displayshort = "BFD",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackfathomDeeps",
				location = "Ashenvale (14, 14)",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "Some underwater sections",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {33, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Blackfathom-Tiefen"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {50, 68} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Ghamoo-ra", colour = AM_RED, coords = { {23.5, 42} }, symbol = { "1" },
						tooltiptxt = "Lvl25 Elite Bestie (Giant Turtle)", lootid = "BFDGhamoora" },
				dtl4  = { text = "Lorgalis Manuskript", colour = AM_ORANGE, coords = { {23.5, 30} }, symbol = { "2" },
						tooltiptxt = "Questgegestand f\195\188r 'Knowledge of the Deeps',\nin der Truhe" },
				dtl5  = { text = "Lady Sarevess", colour = AM_RED, coords = { {3, 29} }, symbol = { "3" },
						tooltiptxt = "Lvl25 Elite Mensch", lootid = "BFDLadySarevess" },
				dtl6  = { text = "Argentumwache Thaelrid", colour = AM_BLUE, coords = { {11, 51} }, symbol = { "4" },
						tooltiptxt = "Questziel f\195\188r 'In Search of Thaelrid',\n& Quest startet vor 'Villainy'" },
				dtl7  = { text = "Gelihast", colour = AM_RED, coords = { {43, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl25 Elite Mensch (Murloc)", lootid = "BFDGelihast" },
				dtl8  = { text = "Lorgus Jett", colour = AM_RED, coords = { {49, 43}, {55, 46} }, symbol = { "6" },
						tooltiptxt = "Lvl26 Elite Mensch", special = AM_VARIES },
				dtl9  = { text = "Baron Aquanis", colour = AM_RED, coords = { {52, 76} }, symbol = { "7" },
						tooltiptxt = "Lvl28 Elite Mensch", lootid = "BFDBaronAquanis" },
				dtl10 = { text = "Fathomkern", colour = AM_BLUE, coords = { {52, 76} }, symbol = { " " },
						tooltiptxt = "" },
				dtl11 = { text = "Twilight Lord Kelris", colour = AM_RED, coords = { {63, 81} }, symbol = { "8" },
						tooltiptxt = "Lvl27 Elite Mensch", lootid = "BFDTwilightLordKelris" },
				dtl12 = { text = "Blackfathom-Tiefen Altar", colour = AM_BLUE, coords = { {63, 81} }, symbol = { " " },
						tooltiptxt = "" },
				dtl13 = { text = "Alt Serra'kis", colour = AM_RED, coords = { {63, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl26 Elite Bestie", lootid = "BFDOldSerrakis" },
				dtl14 = { text = "Aku'mai", colour = AM_RED, coords = { {95, 85} }, symbol = { "10" },
						tooltiptxt = "Lvl29 Elite Bestie (Hydra)", lootid = "BFDAkumai", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BFDTrash", leaveGap = 1 }
			},

			{	name = "Schwarzfelstiefen",			-- Blackrocktiefen
				type = AM_TYP_INSTANCE,
				displayname = "Schwarzfelstiefen",
				displayshort = "BRT",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackrockDepths",
				location = "Schwarzfels",
				levels = "52-60",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {21, 83} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Schwarzfels "..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Lord Roccor", colour = AM_RED, coords = { {33, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl51 Elite Elementar", lootid = "BRDLordRoccor" },
				dtl3  = { text = "Verh\195\182rmeisterin Gerstahn", colour = AM_RED, coords = { {38, 95} }, symbol = { "2" },
						tooltiptxt = "Lvl52 Elite Mensch", lootid = "BRDHighInterrogatorGerstahn" },
				dtl4  = { text = "Marshal Windsor", colour = AM_BLUE, coords = { {46, 95} }, symbol = { "3" },
						tooltiptxt = "Bestandteil der Onyxia Questlinie" },
				dtl5  = { text = "Kommandant Gor'shak", colour = AM_BLUE, coords = { {40, 90} }, symbol = { "4" },
						tooltiptxt = "'Kommandant Gor'shak' Quest" },
				dtl6  = { text = "Kharan Mighthammer", colour = AM_BLUE, coords = { {44, 86} }, symbol = { "5" },
						tooltiptxt = "'Kharan Mighthammer' Quest" },
				dtl7  = { text = "Ring des Gesetzes", colour = AM_GREEN, coords = { {42, 73.4} }, symbol = { "6" },
						tooltiptxt = "Besiege Mobs hier um die \nZuschauer im oberen Level \nvon Feindlich auf Neutral zu bringen", lootid = "BRDArena" },
				dtl8  = { text = "Theldren", colour = AM_RED, coords = { {42, 73.4} }, symbol = { " " },
						tooltiptxt = "NPC Gruppenanf\195\188hrer", lootid = "BRDArena" },
				dtl9  = { text = "Mon. von Franclorn Forgewright", colour = AM_BLUE, coords = { {45.8, 78.1} }, symbol = { "7" },
						tooltiptxt = "'Dark Iron Legacy' Quest" },
				dtl10  = { text = "Pyromant Loregrain", colour = AM_RED, coords = { {48, 78} }, symbol = { "8" },
						tooltiptxt = "Lvl52 Elite Mensch", special = AM_RARE, lootid = "BRDPyromantLoregrain" },
				dtl11 = { text = "Das Gew\195\182lbe", colour = AM_GREEN, coords = { {54, 54} }, symbol = { "9" },
						tooltiptxt = "" },
				dtl12  = { text = "Fineous Darkvire", colour = AM_RED, coords = { {55, 41} }, symbol = { "10" },
						tooltiptxt = "Lvl54 Elite Mensch", lootid = "BRDFineousDarkvire" },
				dtl13 = { text = "W\195\164rter Stilgiss", colour = AM_RED, coords = { {48, 55} }, symbol = { "11" },
						tooltiptxt = "Lvl56 Elite Mensch", lootid = "BRDWarderStilgiss" },
				dtl14 = { text = "Verek", colour = AM_RED, coords = { {54, 54} }, symbol = { " " },
						tooltiptxt = "Lvl55 Elite" },
				dtl15 = { text = "Lord Incendius", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { "12" },
						tooltiptxt = "'Incendius!' Quest", lootid = "BRDLordIncendius" },
				dtl16 = { text = "Der schwarze Amboss", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { " " },
						tooltiptxt = "" },
				dtl17 = { text = "Shadowforge-Schloss", colour = AM_GREEN, coords = { {31, 72.4} }, symbol = { "13" },
						tooltiptxt = "Aufsperren um Zugang zu tiefenen Bereichen zu erm\195\182glichen.\nBen\195\182tigt den Shadowforge Key" },
				dtl18 = { text = "Bael'Gar", colour = AM_RED, coords = { {8, 62} }, symbol = { "14" },
						tooltiptxt = "Lvl57 Elite Bergriese", lootid = "BRDBaelGar" },
				dtl19 = { text = "General Zornesschmied", colour = AM_RED, coords = { {24, 64} }, symbol = { "15" },
						tooltiptxt = "Lvl57 Elite Zwerg", lootid = "BRDGeneralAngerforge" },
				dtl20 = { text = "Golemlord Argelmach", colour = AM_RED, coords = { {24, 51} }, symbol = { "16" },
						tooltiptxt = "Lvl58 Elite Zwerg", lootid = "BRDGolemLordArgelmach" },
				dtl21 = { text = "The Grim Guzzler", colour = AM_GREEN, coords = { {40, 50} }, symbol = { "17" },
						tooltiptxt = "Kaufe 6 Kr\195\188ge Dunkeleisenbier \nund gieb sie Rocknot ;P", lootid = "BRDGuzzler" },
				dtl22 = { text = "Botschafter Flammenschlag", colour = AM_RED, coords = { {46, 38} }, symbol = { "18" },
						tooltiptxt = "Lvl57 Elite Mensch", lootid = "BRDFlamelash" },
				dtl23 = { text = "Panzor der Unbesiegbare", colour = AM_RED, coords = { {40, 27} }, symbol = { "19" },
						tooltiptxt = "Lvl57 Elite Golem", special = AM_RARE, lootid = "BRDPanzor" },
				dtl24 = { text = "Grabmal der Boten", colour = AM_GREEN, coords = { {46, 18} }, symbol = { "20" },
						tooltiptxt = "Besiege 7 Bosse nacheinander um tiefer zu gelangen \n& Truhe", lootid = "BRDTomb" },
				dtl25 = { text = "Das Lyzeum", colour = AM_GREEN, coords = { {61, 8.5} }, symbol = { "21" },
						tooltiptxt = "Find and defeat 2 Flamekeepers\nand light both torches to progress.\nOnly have 3 minutes from killing the first." },
				dtl26 = { text = "Magmus", colour = AM_RED, coords = { {78, 8.5} }, symbol = { "22" },
						tooltiptxt = "Lvl57 Elite Bergriese", lootid = "BRDMagmus" },
				dtl27 = { text = "Prinzessin Moira Bronzebeard", colour = AM_RED, coords = { {90, 8} }, symbol = { "23" },
						tooltiptxt = "Lvl58 Elite Mensch", lootid = "BRDPrincess" },
				dtl28 = { text = "Imperator Dagran Thaurissan", colour = AM_RED, coords = { {93, 8.5} }, symbol = { "24" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "BRDImperatorDagranThaurissan" },
				dtl29 = { text = "Die schwarze Schmiede", colour = AM_GREEN, coords = { {63, 22} }, symbol = { "23" },
						tooltiptxt = "Forge Dark Iron,\nand make Smoking Heart of the Mountain" },
				dtl30 = { text = "Der Geschmolzene Kern", colour = AM_ORANGE, coords = { {65, 30} }, symbol = { "24" },
						tooltiptxt = "'Attunement to the Core' Quest\nMolten Core Entrance", toMap = "Geschmolzener Kern", leaveGap = 1 }
			},

			{	name = "Schwarzfelsspitze",		-- Blackrockspitze
				type = AM_TYP_INSTANCE,
				displayname = "Schwarzfelsspitze (Unten)",
				displayshort = "LBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\LBRS",			-- LBRS
				location = "Schwarzfels",
				levels = "53-60",
				players = "15",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Schwarzfels "..AM_EXTERIOR },
				dtl2  = { text = "Schwarzfelsspitze (Oben)", colour = AM_BLUE, coords = { {22, 4} }, symbol = { "U" },
						tooltiptxt = "", toMap = "Schwarzfelsspitze (Oben)" },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {45.2, 29}, {73, 46} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "Br\195\188cke zum Hochlord Omokk", colour = AM_GREEN, coords = { {38, 32.1}, {15, 32.1} }, symbol = { "B" },
						tooltiptxt = "" },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {71, 22}, {94, 26} }, symbol = { "x2" },
						tooltiptxt = "Lower Level" },
				dtl6  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {29, 53}, {29, 77} }, symbol = { "x3" },
						tooltiptxt = "" },
				dtl7  = { text = "Rampen", colour = AM_BLUE, coords = { {86, 40}, {89, 58} }, symbol = { "R" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "Vaelan", colour = AM_RED, coords = { {31, 17} }, symbol = { "1" },
						tooltiptxt = "Lvl55 Elite\nSeal of Ascension Quest"  },
				dtl9  = { text = "Warosh", colour = AM_RED, coords = { {53, 14} }, symbol = { "2" },
						tooltiptxt = "Lvl60 Elite Mensch"  },
				dtl10 = { text = "Beschlagene Pike", colour = AM_ORANGE, coords = { {69, 29} }, symbol = { "3" },
						tooltiptxt = "Questgegenstand"  },
				dtl11 = { text = "Bijou", colour = AM_BLUE, coords = { {62, 25 } }, symbol = { "4" },
						tooltiptxt = "Bijou Questlienie\nNicht unterer Level" },
				dtl12 = { text = "Metzger der Felsspitzoger", colour = AM_RED, coords = { {42, 32.1} }, symbol = { "5" },
						tooltiptxt = "Lvl59 Elite Mensch\nPatrols bridge to Highlord Omokk", lootid = "LBRSSpirestoneButcher", special = AM_RARE  },
				dtl13 = { text = "Hochlord Omokk", colour = AM_RED, coords = { {2, 32.1} }, symbol = { "6" },
						tooltiptxt = "Lvl?? Elite Mensch", lootid = "LBRSOmokk"  },
				dtl14 = { text = "Kampflord der Felsspitzoger", colour = AM_RED, coords = { {2, 32.1} }, symbol = { " " },
						tooltiptxt = "Spawns on hill near Lord Omokk", lootid = "LBRSSpirestoneLord", special = AM_RARE },
				dtl15 = { text = "Schattenj\195\164gerin Vosh'gajin", colour = AM_RED, coords = { {77, 64} }, symbol = { "7" },
						tooltiptxt = "Lvl?? Elite Mensch", lootid = "LBRSVosh"  },
				dtl16 = { text = "F\195\188nfte Mosh'aru-Schrifttafel", colour = AM_ORANGE, coords = { {77, 68} }, symbol = { "8" },
						tooltiptxt = "Questgegenstand"  },
				dtl17 = { text = "Bannok Grimaxe", colour = AM_RED, coords = { {41.5, 26.5} }, symbol = { "9" },
						tooltiptxt = "Lvl59 Elite Mensch\nUnterer Level", lootid = "LBRSGrimaxe", special = AM_RARE },
				dtl18 = { text = "Kriegsmeister Voone", colour = AM_RED, coords = { {73, 32} }, symbol = { "10" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "LBRSVoone" },
				dtl19 = { text = "Sechste Mosh'aru-Schrifttafel", colour = AM_ORANGE, coords = { {75, 29} }, symbol = { "11" },
						tooltiptxt = "Questgegenstand"  },
				dtl20 = { text = "Mor Grayhoof", colour = AM_RED, coords = { {75, 35} }, symbol = { "12" },
						tooltiptxt = "Lvl60 Elite\nRequires Summoning Brazier\nInterrupt their heals", lootid = "LBRSGrayhoof" },
				dtl21  = { text = "Mutter Glimmernetz", colour = AM_RED, coords = { {54, 58} }, symbol = { "13" },
						tooltiptxt = "Lvl59 Elite Bestie", lootid = "LBRSSmolderweb"  },
				dtl22 = { text = "Kristallfangzahn", colour = AM_RED, coords = { {36, 49} }, symbol = { "14" },
						tooltiptxt = "Lvl60 Elite Bestie", special = AM_RARE, lootid = "LBRSCrystalFang"  },
				dtl23 = { text = "Urok Schreckensbote", colour = AM_RED, coords = { {30, 30} }, symbol = { "15" },
						tooltiptxt = "Lvl60 Elite Mensch", lootid = "LBRSDoomhowl"  },
				dtl24 = { text = "Quartiermeister Zigris", colour = AM_RED, coords = { {50, 89} }, symbol = { "16" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "LBRSZigris"  },
				dtl25 = { text = "Halcyon", colour = AM_RED, coords = { {19, 92} }, symbol = { "17" },
						tooltiptxt = "Lvl59 Elite Bestie\nKill to trigger spawn of Gizrul", lootid = "LBRSHalycon"  },
				dtl26 = { text = "Gizrul der Sklavenhalter", colour = AM_RED, coords = { {19, 92} }, symbol = { " " },
						tooltiptxt = "Lvl60 Elite Bestie\nSpawn triggered by death of Halcyon", lootid = "LBRSSlavener"  },
				dtl27 = { text = "Hochlord Wyrmthalak", colour = AM_RED, coords = { {42, 62} }, symbol = { "18" },
						tooltiptxt = "Lvl?? Elite Dragon", lootid = "LBRSWyrmthalak", leaveGap = 1  },
				dtl28 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "LBRSTrash", leaveGap = 1 }
			},

			{	name = "Schwarzfelsspitze (Oben)",
				type = AM_TYP_INSTANCE,
				displayname = "Schwarzfelsspitze (Oben)",
				displayshort = "UBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\UBRS",			-- UBRS
				location = "Schwarzfels",
				levels = "53-60",
				players = "15",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 80.7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Schwarzfels "..AM_EXTERIOR },
				dtl2  = { text = "Schwarzfelsspitze (Unten)", colour = AM_BLUE, coords = { {18.2, 86.6} }, symbol = { "L" },
						tooltiptxt = "", toMap = "Schwarzfelsspitze", leaveGap = 1 },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {11.9, 58.4}, {8.65, 25} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "Feuerwache Glutseher", colour = AM_RED, coords = { {8.2, 31.0} }, symbol = { "1" },
						tooltiptxt = "Lvl?? Elite Elementar", lootid = "UBRSEmberseer", leaveGap = 1  },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {8.6, 38.9}, {36.4, 61.2} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl6  = { text = "Doomrigger's Schnalle", colour = AM_ORANGE, coords = { {41.3, 68.65} }, symbol = { "2" },
						tooltiptxt = "Questgegenstand\nIn large Chest among toppled pillars\nCan be hard to spot\nCan drop down from General Drakkisath"  },
				dtl7  = { text = "Father Flame", colour = AM_ORANGE, coords = { {50, 65.45} }, symbol = { "3" },
						tooltiptxt = "Fight spawns near doorway\nStop hatchers hatching eggs", lootid = "UBRSFLAME"  },
				dtl8  = { text = "Solakar Feuerkrone", colour = AM_RED, coords = { {50, 65.45} }, symbol = { " " },
						tooltiptxt = "Lvl60 Elite Dragonkin\nSpawned after Looting Father Flame", lootid = "UBRSSolakar" },
				dtl9  = { text = "Jed Runewatcher", colour = AM_RED, coords = { {47, 52.6} }, symbol = { "4" },
						tooltiptxt = "Lvl59 Elite Mensch", special = AM_RARE, lootid = "UBRSRunewatcher"  },
				dtl10 = { text = "Goraluk Anvilcrack", colour = AM_RED, coords = { {34, 52.6} }, symbol = { "5" },
						tooltiptxt = "Lvl61 Elite Mensch", lootid = "UBRSAnvilcrack"  },
				dtl11 = { text = "Kriegsh\195\164uptling Rend Blackhand", colour = AM_RED, coords = { {67.5, 51} }, symbol = { "6" },
						tooltiptxt = "Boss\nLimited to 'For the Horde!' Quest\nComes mounted on Gyth", lootid = "UBRSRend"  },
				dtl12  = { text = "Gyth", colour = AM_RED, coords = { {67.5, 51} }, symbol = { " " },
						tooltiptxt = "Lvl?? Elite Dragon", lootid = "UBRSGyth" },
				dtl13 = { text = "Awbee", colour = AM_BLUE, coords = { {68.1, 65.9} }, symbol = { "7" },
						tooltiptxt = "Limited to 'The Matron Protectorate' Quest"  },
				dtl14 = { text = "Die Bestie", colour = AM_RED, coords = { {95.7, 60.8} }, symbol = { "8" },
						tooltiptxt = "Lvl?? Elite Bestie", lootid = "UBRSBestie"  },
				dtl15 = { text = "Lord Valthalak", colour = AM_RED, coords = { {95.7, 56.5} }, symbol = { "9" },
						tooltiptxt = "Lvl?? Elite\nNeed Quest to Summon\nClear Hall of Blackhand first", lootid = "UBRSValthalak" },
				dtl16  = { text = "General Drakkisath", colour = AM_RED, coords = { {41.6, 73.2} }, symbol = { "10" },
						tooltiptxt = "Lvl?? Elite Dragon", lootid = "UBRSDrakkisath"  },
				dtl17 = { text = "Pechschwingenhort", colour = AM_BLUE, coords = { {78.5, 27.6} }, symbol = { "BWL" },
						tooltiptxt = "", toMap = "Pechschwingenhort", leaveGap = 1 },
				dtl18 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl19 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UBRSTrash", leaveGap = 1 }
			},

			{	name = "Pechschwingenhort",		-- Pechschwingenhort
				type = AM_TYP_INSTANCE,
				displayname = "Pechschwingenhort",
				displayshort = "BWL",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackwingLair",
				location = "Schwarzfelsspitze",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {65, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Schwarzfelsspitze (Oben)", leaveGap = 1 },
				dtl2 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {32.8, 78}, {61, 48} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl3 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {40, 96}, {68, 65} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl4 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {47, 51}, {17, 52} }, symbol = { "x3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "Razorgore der Ungez\195\164hmte", colour = AM_RED, coords = { {51, 66} }, symbol = { "1" },
						tooltiptxt = "Boss", lootid = "BWLRazorgore"  },
				dtl6  = { text = "Vaelastrasz der Verdorbene", colour = AM_RED, coords = { {32.5, 67} }, symbol = { "2" },
						tooltiptxt = "Boss", lootid = "BWLVaelastrasz"  },
				dtl7  = { text = "Brutw\195\164chter Dreschbringer", colour = AM_RED, coords = { {77, 42} }, symbol = { "3" },
						tooltiptxt = "Boss", lootid = "BWLLashlayer"  },
				dtl8  = { text = "Feuerschwinge", colour = AM_RED, coords = { {12, 44} }, symbol = { "4" },
						tooltiptxt = "Boss", lootid = "BWLFiremaw"  },
				dtl9  = { text = "Schattenschwinge", colour = AM_RED, coords = { {10, 29} }, symbol = { "5" },
						tooltiptxt = "Boss", lootid = "BWLEbonroc"  },
				dtl10 = { text = "Flammenmaul", colour = AM_RED, coords = { {18, 29} }, symbol = { "6" },
						tooltiptxt = "Boss", lootid = "BWLFlamegor"  },
				dtl11 = { text = "Chromaggus", colour = AM_RED, coords = { {33, 40} }, symbol = { "7" },
						tooltiptxt = "Boss", lootid = "BWLChromaggus"  },
				dtl12 = { text = "Nefarian", colour = AM_RED, coords = { {60, 14} }, symbol = { "8" },
						tooltiptxt = "Boss", lootid = "BWLNefarian", leaveGap = 1 },
				dtl13 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BWLTrashMobs", leaveGap = 1 },
				dtl14 = { text = AM_TIER2_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T2SET", leaveGap = 1 }
			},

			{	name = "D\195\188sterbruch",		-- D\195\188sterbruch
				type = AM_TYP_INSTANCE,
				displayname = "D\195\188sterbruch - Overview",
				displayshort = "DB",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DireMaul",
				location = "Feralas (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "D\195\188sterbruch Ost", colour = AM_GREEN, coords = { {53, 81}, {57, 96}, {100, 80} }, symbol = { "E" },
						tooltiptxt = "Click to Open Dire Maul East Map", toMap = "D\195\188sterbruch Ost" },
				dtl2  = { text = "D\195\188sterbruch Nord", colour = AM_GREEN, coords = { {67.5, 38} }, symbol = { "N" },
						tooltiptxt = "Click to Open Dire Maul North Map", toMap = "D\195\188sterbruch Nord" },
				dtl3  = { text = "D\195\188sterbruch West", colour = AM_GREEN, coords = { {47, 88} }, symbol = { "W" },
						tooltiptxt = "Click to Open Dire Maul West Map", toMap = "D\195\188sterbruch West", leaveGap = 1 },
				dtl4  = { text = "Bibliothek", colour = AM_BLUE, coords = { {24, 58}, {41, 41} }, symbol = { "L" },
						tooltiptxt = "Reached from North or West Dire Maul", leaveGap = 1 }
			},


			{	name = "D\195\188sterbruch Ost",		-- D\195\188sterbruch Ost
				type = AM_TYP_INSTANCE,
				displayname = "D\195\188sterbruch (Ost)",
				displayshort = "DB",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMEast",		--DMEast
				location = "Feralas (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "Eingang : Die gebrochenen Gemeinlande", colour = AM_GREEN, coords = { {6, 58}  }, symbol = { "X1" },
						tooltiptxt = "", toMap = "D\195\188sterbruch"..AM_EXTERIOR },
				dtl2  = { text = "Eingang : Elderethgasse", colour = AM_GREEN, coords = { {12, 92} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "D\195\188sterbruch"..AM_EXTERIOR },
				dtl3  = { text = "Eingang : Pavillion", colour = AM_GREEN, coords = { {98, 64} }, symbol = { "X3" },
						tooltiptxt = "" },
				dtl4  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {8, 40} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "Drop to D\195\188sterbruch\nside Chamber" },
				dtl5  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {41, 85}, {61, 93} }, symbol = { "L1" },
						tooltiptxt = "" },
				dtl6  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {75, 92}, {55, 82} }, symbol = { "L2" },
						tooltiptxt = "" },
				dtl7  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {67, 63}, {83, 73} }, symbol = { "L3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "Pusillins Jagd beginnt", colour = AM_GREEN, coords = { {10, 50} }, symbol = { "P" },
						tooltiptxt = "Chase to get Dire Maul (Crescent) Key", lootid = "DMEPusillin"  },
				dtl9  = { text = "Pusillins Jagd endet", colour = AM_RED, coords = { {79, 61} }, symbol = { "P" },
						tooltiptxt = "Oooh, you little Imp!", lootid = "DMEPusillin"  },
				dtl10 = { text = "Zevrim Dornhuf", colour = AM_RED, coords = { {83, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl57 Elite Demon", lootid = "DMEZevrimThornhoof"  },
				dtl11 = { text = "Hydrobrut", colour = AM_RED, coords = { {64, 77} }, symbol = { "2" },
						tooltiptxt = "Lvl57 Elite Elementar", lootid = "DMEHydro"  },
				dtl12 = { text = "Lethtendris", colour = AM_RED, coords = { {46, 66} }, symbol = { "3" },
						tooltiptxt = "Lvl57 Elite Mensch", lootid = "DMELethtendris"  },
				dtl13 = { text = "Eisenborke der Gro\195\159e", colour = AM_RED, coords = { {21, 69} }, symbol = { "4" },
						tooltiptxt = "Opens door"  },
				dtl14 = { text = "Alzzin der Wildformer", colour = AM_RED, coords = { {42, 23} }, symbol = { "5" },
						tooltiptxt = "Lvl58 Elite Demon", lootid = "DMEAlzzin"  },
				dtl15 = { text = "Isalien", colour = AM_RED, coords = { {42, 23} }, symbol = { " " },
						tooltiptxt = "Need Brazier of Beckoning to summon\nQuest from Bodley in Blackrock Mountain", lootid = "DMEIsalien", leaveGap = 2 },
				dtl16 = { text = "B\195\188cher", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMETrash", leaveGap = 1 }
			},

			{	name = "D\195\188sterbruch Nord",		-- D\195\188sterbruch Nord
				type = AM_TYP_INSTANCE,
				displayname = "D\195\188sterbruch (Nord)",
				displayshort = "DB",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMNorth",		-- DMNorth
				location = "Feralas (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "Requires Crescent Key from Pusillin Chase in DM East",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {74, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "D\195\188sterbruch"..AM_EXTERIOR },
				dtl2  = { text = "D\195\188sterbruch (West)", colour = AM_GREEN, coords = { {9, 98} }, symbol = { "W" },
						tooltiptxt = "", toMap = "D\195\188sterbruch West" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {49.2, 59.4} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Wache Mol'dar", colour = AM_RED, coords = { {76.4, 55.5} }, symbol = { "1" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "DMNGuardMoldar"  },
				dtl5  = { text = "Stampfer Kreeg", colour = AM_RED, coords = { {67, 49} }, symbol = { "2" },
						tooltiptxt = "Lvl57 Elite Demon", lootid = "DMNStomperKreeg"  },
				dtl6  = { text = "Wache Fengus", colour = AM_RED, coords = { {49.2, 56.1} }, symbol = { "3" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "DMNGuardFengus"  },
				dtl7  = { text = "Wache Slip'kik", colour = AM_RED, coords = { {17, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl59 Elite Mensch", lootid = "DMNGuardSlipkik"  },
				dtl8  = { text = "Knot Thimblejack", colour = AM_RED, coords = { {19, 37} }, symbol = { "5" },
						tooltiptxt = "", lootid = "DMNThimblejack"  },
				dtl9  = { text = "Captain Kromcrush", colour = AM_RED, coords = { {24.6, 34.8} }, symbol = { "6" },
						tooltiptxt = "", lootid = "DMNCaptainKromcrush"  },
				dtl10 = { text = "K\195\182nig Gordok", colour = AM_RED, coords = { {24.2, 11.2} }, symbol = { "7" },
						tooltiptxt = "", lootid = "DMNKingGordok"  },
				dtl11 = { text = "Bibliothek", colour = AM_BLUE, coords = { {20, 89} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 2  },
				dtl12 = { text = "Tribut Run", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "DMNTRIBUTERUN" },
				dtl13 = { text = "B\195\188cher", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 }
			},

			{	name = "D\195\188sterbruch West",		-- D\195\188sterbruch West
				type = AM_TYP_INSTANCE,
				displayname = "D\195\188sterbruch (West)",
				displayshort = "DB",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMWest",		-- DMWest
				location = "Feralas (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "Requires Crescent Key from Pusillin Chase in DM East",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {97, 78} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "D\195\188sterbruch"..AM_EXTERIOR },
				dtl2  = { text = "D\195\188sterbruch (Nord)", colour = AM_GREEN, coords = { {66, 9} }, symbol = { "N" },
						tooltiptxt = "", toMap = "D\195\188sterbruch Nord", leaveGap = 1 },
				dtl3  = { text = AM_INSTANCE_STAIRS, colour = AM_BLUE, coords = { {49.2, 25}, {52, 60} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Pylonen", colour = AM_GREEN, coords = { {83, 80}, {64, 61}, {64, 87}, {27, 62}, {27, 37} }, symbol = { "P" },
						tooltiptxt = "Destroy these", leaveGap = 1 },
				dtl5  = { text = "Shen'dralar Uralter", colour = AM_ORANGE, coords = { {68, 74} }, symbol = { "1" },
						tooltiptxt = "Quest to Kill Prince" },
				dtl6  = { text = "Tendris Warpwood", colour = AM_RED, coords = { {58, 74} }, symbol = { "2" },
						tooltiptxt = "Lvl60 Elite Elementar", lootid = "DMWTendrisWarpwood" },
				dtl7  = { text = "Illyanna Rabeneiche", colour = AM_RED, coords = { {49, 87} }, symbol = { "3" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "DMWIllyannaRavenoak" },
				dtl8  = { text = "Tsu'Zee", colour = AM_RED, coords = { {48, 60} }, symbol = { "4" },
						tooltiptxt = "Lvl59 Elite Undead", special = AM_RARE, lootid = "DMWTsuzee" },
				dtl9  = { text = "Magister Kalendris", colour = AM_RED, coords = { {53, 51} }, symbol = { "5" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "DMWMagisterKalendris" },
				dtl10 = { text = "Immol'thar", colour = AM_RED, coords = { {19, 49} }, symbol = { "6" },
						tooltiptxt = "Lvl61 Elite Demon", lootid = "DMWImmolthar" },
				dtl11 = { text = "F\195\188rst Hel'nurath", colour = AM_RED, coords = { { 19, 49} }, symbol = { " " },
						tooltiptxt = "Lvl62 Elite Demon\nSummon as part of Warlock Epic Mount quest", lootid = "DMWHelnurath" },
				dtl12 = { text = "Prinz Tortheldrin", colour = AM_RED, coords = { {41, 26} }, symbol = { "7" },
						tooltiptxt = "Lvl61 Elite Mensch", lootid = "DMWPrinceTortheldrin", leaveGap = 1  },
				dtl13 = { text = "Bibliothek", colour = AM_BLUE, coords = { {51, 20} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "B\195\188cher", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMWTrash", leaveGap = 1 }
			},

			{	name = "Gnomeregan",			-- Gnomeregan
				type = AM_TYP_INSTANCE,
				displayname = "Gnomeregan",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Gnomeregan",
				location = "Dun Morogh (25, 41)",
				levels = "26-33",
				players = "10",
				prereq = "",
				general = "Horde access via Teleporter in Booty Bay.\nInitial Quest from Orgrimmar Engineer.",
				dtl1  = { text = "Eingang (Vorne)", colour = AM_GREEN, coords = { {70.5, 16} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "Gnomeregan"..AM_EXTERIOR },
				dtl2  = { text = "Eingang (Hinten)", colour = AM_GREEN, coords = { {87, 59} }, symbol = { "X2" },
						tooltiptxt = "Workshop Key Required", toMap = "Gnomeregan"..AM_EXTERIOR },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {75, 38}, {79, 56} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Z\195\164hfl\195\188ssiger Niederschlag", colour = AM_RED, coords = { {71.5, 33.5} }, symbol = { "1" },
						tooltiptxt = "Lvl30 Elite Elementar\nLower level", lootid = "GnViscousFallout" },
				dtl5  = { text = "Grubbis", colour = AM_RED, coords = { {95, 46} }, symbol = { "2" },
						tooltiptxt = "Lvl32 Elite Mensch\nTriggered Spawn\nSpeak to Blastmaster at same location", lootid = "GnGrubbis"  },
				dtl6  = { text = "Kernobee", colour = AM_BLUE, coords = { {76, 54} }, symbol = { "3" },
						tooltiptxt = ""  },
				dtl7  = { text = "Lochkarten-Automat 3005-B", colour = AM_GREEN, coords = { {70, 50} }, symbol = { "B" },
						tooltiptxt = "Card Upgrade"  },
				dtl8  = { text = "Die Saubere Zone", colour = AM_GREEN, coords = { {64, 46} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "Electrocutioner 6000", colour = AM_RED, coords = { {30, 49} }, symbol = { "5" },
						tooltiptxt = "Lvl32 Elite Mechanical\nDrops Workshop Key", lootid = "GnElectrocutioner6000"  },
				dtl10 = { text = "Lochkarten-Automat 3005-C", colour = AM_GREEN, coords = { {33.2, 49.6} }, symbol = { "C" },
						tooltiptxt = "Card Upgrade"  },
				dtl11 = { text = "Meute Verpr\195\188geler 9-60", colour = AM_RED, coords = { {47.6, 77.3} }, symbol = { "6" },
						tooltiptxt = "Lvl32 Elite Mechanical", lootid = "GnCrowdPummeler960"  },
				dtl12 = { text = "Lochkarten-Automat 3005-D", colour = AM_GREEN, coords = { {48.9, 75.7} }, symbol = { "D" },
						tooltiptxt = "Card Upgrade"  },
				dtl13 = { text = "Dark Iron Botschafter", colour = AM_RED, coords = { {9, 52} }, symbol = { "5" },
						tooltiptxt = "Lvl33 Elite Mensch", special = AM_RARE, lootid = "GnDIAmbassador"  },
				dtl14 = { text = "Robogenieur Thermoplugg", colour = AM_RED, coords = { {11.8, 42.2} }, symbol = { "8" },
						tooltiptxt = "Lvl35 Elite Demon", lootid = "GnMekgineerThermaplugg", leaveGap = 1  },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "GnTrash", leaveGap = 1 }
			},

			{	name = "Maraudon",			-- Maraudon
				type = AM_TYP_INSTANCE,
				displayname = "Maraudon",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Maraudon",
				location = "Desolace (29, 62)",
				levels = "40-49",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "Eingang (Orange)", colour = AM_ORANGE, coords = { {71, 12} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "Maraudon"..AM_EXTERIOR },
				dtl2  = { text = "Eingang (Lila)", colour = AM_PURPLE, coords = { {85, 31} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "Maraudon"..AM_EXTERIOR },
				dtl3  = { text = "Eingang (Portal)", colour = AM_GREEN, coords = { {36, 55} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {64, 44}, {39, 31} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "Veng (Der f\195\188nfte Khan)", colour = AM_RED, coords = { {59, 6} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS  },
				dtl6  = { text = "Noxxion", colour = AM_RED, coords = { {51, 3} }, symbol = { "2" },
						tooltiptxt = "Lvl48 Elite Elementar", lootid = "MaraNoxxion"  },
				dtl7  = { text = "Schlingwurzler", colour = AM_RED, coords = { {36, 14} }, symbol = { "3" },
						tooltiptxt = "Lvl47 Elite Bestie", lootid = "MaraRazorlash"  },
				dtl8  = { text = "Maraudos (Der vierte Khan)", colour = AM_RED, coords = { {64, 27} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "Lord Schlangenzunge", colour = AM_RED, coords = { {53.3, 32} }, symbol = { "5" },
						tooltiptxt = "Lvl47 Elite Mensch", lootid = "MaraLordVyletongue"  },
				dtl10 = { text = "Meshlok der Ernter", colour = AM_RED, coords = { {43, 30} }, symbol = { "6" },
						tooltiptxt = "", special = AM_RARE, lootid = "MaraMeshlok"  },
				dtl11 = { text = "Celebras der Verbannte", colour = AM_RED, coords = { {31, 35} }, symbol = { "7" },
						tooltiptxt = "Lvl49 Elite Mensch", lootid = "MaraCelebras"  },
				dtl12 = { text = "Erdrutsch", colour = AM_RED, coords = { {51.3, 60} }, symbol = { "8" },
						tooltiptxt = "Lvl50 Elite Elementar", lootid = "MaraLandslide"  },
				dtl13 = { text = "T\195\188ftler Gizlock", colour = AM_RED, coords = { {61, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl50 Elite Mensch", lootid = "MaraTinkererGizlock"  },
				dtl14 = { text = "Faulschnapper", colour = AM_RED, coords = { {45, 82} }, symbol = { "10" },
						tooltiptxt = "Lvl50 Elite Bestie", lootid = "MaraRotgrip"  },
				dtl15 = { text = "Prinzessin Theradras", colour = AM_RED, coords = { {32, 85} }, symbol = { "11" },
						tooltiptxt = "Lvl51 Elite Elementar", lootid = "MaraPrincessTheradras" },
				dtl16 = { text = "Zaetar's Spirit", colour = AM_RED, coords = { {32, 85} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 }
			},

			{	name = "Geschmolzener Kern",			-- Geschmolzener Kern
				type = AM_TYP_INSTANCE,
				displayname = "Geschmolzener Kern",
				displayshort = "MC",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MoltenCore",
				location = "Schwarzfelstiefen",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 20} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Schwarzfelstiefen", leaveGap = 1 },
				dtl2  = { text = "Lucifron", colour = AM_RED, coords = { {62, 35} }, symbol = { "1" },
						tooltiptxt = "Boss Mensch", lootid = "MCLucifron" },
				dtl3  = { text = "Magmadar", colour = AM_RED, coords = { {70, 16} }, symbol = { "2" },
						tooltiptxt = "Boss Bestie", lootid = "MCMagmadar" },
				dtl4  = { text = "Gehennas", colour = AM_RED, coords = { {13, 46} }, symbol = { "3" },
						tooltiptxt = "Boss Mensch", lootid = "MCGehennas" },
				dtl5  = { text = "Garr", colour = AM_RED, coords = { {8, 71} }, symbol = { "4" },
						tooltiptxt = "Boss Elementar", lootid = "MCGarr"  },
				dtl6  = { text = "Shazzrah", colour = AM_RED, coords = { {44, 80} }, symbol = { "5" },
						tooltiptxt = "Boss Mensch", lootid = "MCShazzrah"  },
				dtl7  = { text = "Baron Geddon", colour = AM_RED, coords = { {53, 68} }, symbol = { "6" },
						tooltiptxt = "Boss Elementar", lootid = "MCGeddon"  },
				dtl8  = { text = "Golemagg der Verbrenner", colour = AM_RED, coords = { {66, 57} }, symbol = { "7" },
						tooltiptxt = "Boss Giant", lootid = "MCGolemagg"  },
				dtl9  = { text = "Sulfuron-Herold", colour = AM_RED, coords = { {87, 80} }, symbol = { "8" },
						tooltiptxt = "Boss Mensch", lootid = "MCSulfuron"  },
				dtl10 = { text = "Majordomo Executus", colour = AM_RED, coords = { {89, 62} }, symbol = { "9" },
						tooltiptxt = "Boss Mensch", lootid = "MCMajordomo"  },
				dtl11 = { text = "Ragnaros", colour = AM_RED, coords = { {47, 52} }, symbol = { "10" },
						tooltiptxt = "Boss Elementar", lootid = "MCRagnaros", leaveGap = 2  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCTrashMobs", lootlink = true },
				dtl13 = { text = AM_RBOSS_DROP, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCRANDOMBOSSDROPPS", leaveGap = 1 },
				dtl14 = { text = AM_TIER1_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T1SET", leaveGap = 1 }
			},

			{	name = "Naxxramas",			-- Naxxramas
				type = AM_TYP_INSTANCE,
				displayname = "Naxxramas",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Naxxramas",
				location = "Stratholme/\195\150stliche Pestl\195\164nder",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text ="Monstr\195\182sit\195\164tenfl\195\188gel" , colour = AM_BLUE, coords = { {2, 15} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "Flickwerk", colour = AM_RED, coords = { {22, 36} }, symbol = { "1" },
						tooltiptxt = "Abomination Wing", lootid = "NAXPatchwerk" },
				dtl3  = { text = "Grobbulus", colour = AM_RED, coords = { {32, 29} }, symbol = { "2" },
						tooltiptxt = "Abomination Wing", lootid = "NAXGrobbulus" },
				dtl4  = { text = "Gluth", colour = AM_RED, coords = { {20, 20} }, symbol = { "3" },
						tooltiptxt = "Abomination Wing", lootid = "NAXGluth" },
				dtl5  = { text = "Thaddius", colour = AM_RED, coords = { {5, 4} }, symbol = { "4" },
						tooltiptxt = "Abomination Wing", lootid = "NAXThaddius", leaveGap = 1  },
				dtl6  = { text = "Spinnenfl\195\188gel", colour = AM_BLUE, coords = { {67, 3} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl7  = { text = "Anub'Rekhan", colour = AM_RED, coords = { {45.2, 20} }, symbol = { "1" },
						tooltiptxt = "Spider Wing", lootid = "NAXAnubRekhan"  },
				dtl8  = { text = "Gro\195\159witwe Faerlina", colour = AM_RED, coords = { {55, 16} }, symbol = { "2" },
						tooltiptxt = "Spider Wing", lootid = "NAXGrandWidowFaerlina"  },
				dtl9  = { text = "Maexxna", colour = AM_RED, coords = { {74, 5} }, symbol = { "3" },
						tooltiptxt = "Spider Wing", lootid = "NAXMaexxna", leaveGap = 1  },
				dtl10 = { text = "Seuchenfl\195\188gel", colour = AM_BLUE, coords = { {79, 56} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl11 = { text = "Noth der Seuchenf\195\188rst", colour = AM_RED, coords = { {47, 64} }, symbol = { "1" },
						tooltiptxt = "Necro Wing", lootid = "NAXNothderPlaguebringer"  },
				dtl12 = { text = "Heigan der Unreine", colour = AM_RED, coords = { {60, 58} }, symbol = { "2" },
						tooltiptxt = "Necro Wing", lootid = "NAXHeiganderUnclean"  },
				dtl13 = { text = "Loatheb", colour = AM_RED, coords = { {82, 47} }, symbol = { "3" },
						tooltiptxt = "Necro Wing", lootid = "NAXLoatheb", leaveGap = 1  },
				dtl14 = { text = "Todesritterfl\195\188gel", colour = AM_BLUE, coords = { {15, 79} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl15 = { text = "Instrukteur Razuvious", colour = AM_RED, coords = { {18, 58} }, symbol = { "1" },
						tooltiptxt = "Deathknight Wing", lootid = "NAXInstructorRazuvious"  },
				dtl16 = { text = "Gothik der Seelenj\195\164ger", colour = AM_RED, coords = { {37, 64} }, symbol = { "2" },
						tooltiptxt = "Deathknight Wing", lootid = "NAXGothikderHarvester" },
				dtl17 = { text = "Die vier Ritter", colour = AM_RED, coords = { {8, 75} }, symbol = { "3" },
						tooltiptxt = "Deathknight Wing", lootid = "NAXTheFourHorsemen" },
				dtl18 = { text = "Thane Korth'azz", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "Sir Zeliek", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "Hochlord Mograine", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "Lady Blaumeaux", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl22 = { text = "Frostwyrm Lair", colour = AM_BLUE, coords = { {74, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "Frostwyrm Lair"  },
				dtl23 = { text = "Sapphiron", colour = AM_RED, coords = { {87, 91} }, symbol = { "1" },
						tooltiptxt = "Frostwyrm Lair", lootid = "NAXSapphiron"  },
				dtl24 = { text = "Kel'Thuzard", colour = AM_RED, coords = { {75, 79} }, symbol = { "2" },
						tooltiptxt = "Frostwyrm Lair", lootid = "NAXKelThuzard", leaveGap = 2  },
				dtl25 = { text = AM_TIER3_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T3SET", leaveGap = 1 },
				dtl26 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "NAXTrash", leaveGap = 1 }
			},

			{	name = "Onyxias Hort",				-- Onyxias Hort
				type = AM_TYP_INSTANCE,
				displayname = "Onyxias Hort",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OnyxiasLair",
				location = "Marschen von Dustwallow (52, 76)",
				levels = "60+",
				players = "40",
				prereq = "Requires Drakefire Amulet\n(Complete quest in UBRS to kill General Drakkisath)",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 12} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "Onyxias Wachen", colour = AM_RED, coords = { {26, 41}, {29, 56}, {39, 68}, {50, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl62 Elite Dragonkin" },
				dtl3  = { text = "Welpeneier", colour = AM_RED, coords = { {45, 40}, {51, 54}, {84, 41}, {79, 54} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "Onyxia", colour = AM_RED, coords = { {66, 27} }, symbol = { "3" },
						tooltiptxt = "Boss Dragonkin", lootid = "Onyxia", leaveGap = 1 }
			},

			{	name = "Der Flammenschlund",			-- Ragefireabgrund
				type = AM_TYP_INSTANCE,
				displayname = "Der Flammenschlund",
				displayshort = "RF",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RagefireChasm",			-- RagefireChasm
				location = "Orgrimmar",
				levels = "13-18",
				players = "10",
				general = "",
				dtl1  = { text = "Eingang", colour = AM_GREEN, coords = { {72, 4} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Maur Grimtotem", colour = AM_GOLD, coords = { {71, 53} }, symbol = { "1" },
						tooltiptxt = "Satchel Quest"  },
				dtl3  = { text = "Taragaman der Hungerleider", colour = AM_RED, coords = { {34, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl16 Elite Demon", lootid = "RFCTaragaman" },
				dtl4  = { text = "Jergosh der Herbeirufer", colour = AM_RED, coords = { {24, 86} }, symbol = { "3" },
						tooltiptxt = "Lvl16 Elite Mensch", lootid = "RFCJergosh" },
				dtl5  = { text = "Bazzalan", colour = AM_RED, coords = { {36, 91} }, symbol = { "4" },
						tooltiptxt = "Lvl16 Elite Demon", leaveGap = 1  }

			},

			{	name = "Die H\195\188gel von Razorfen",			-- Die H\195\188gel von Razorfen
				type = AM_TYP_INSTANCE,
				displayname = "Die H\195\188gel von Razorfen",
				displayshort = "HvR",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenDowns",
				location = "Brachland (48, 88)",
				levels = "38-43",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {4, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {77, 45} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Tuten'kash", colour = AM_RED, coords = { {52, 36} }, symbol = { "1" },
						tooltiptxt = "Lvl40 Elite Undead", lootid = "RFDTutenkash" },
				dtl4  = { text = "Gong to spawn Tuten'kash", colour = AM_GREEN, coords = { {54, 30} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "Henry Stern,\n& Belnistrasz", colour = AM_BLUE, coords = { {76, 27} }, symbol = { "3" },
						tooltiptxt = "Learn how to make :\nGoldthorn Tea, \nMighty Troll's Blood Potion"  },
				dtl6  = { text = "Mordresh Feuerauge", colour = AM_RED, coords = { {87, 47} }, symbol = { "4" },
						tooltiptxt = "Lvl39 Elite Undead", lootid = "RFDMordreshFireEye"  },
				dtl7  = { text = "Nimmersatt", colour = AM_RED, coords = { {19, 65} }, symbol = { "5" },
						tooltiptxt = "Lvl40 Elite Mensch", lootid = "RFDGlutton"  },
				dtl8  = { text = "Ragglesnout", colour = AM_RED, coords = { {41, 67} }, symbol = { "6" },
						tooltiptxt = "Lvl40 Elite Mensch", special = AM_RARE, lootid = "RFDRagglesnout"  },
				dtl9  = { text = "Amnennar der K\195\164ltebringer", colour = AM_RED, coords = { {33, 59} }, symbol = { "0" },
						tooltiptxt = "Lvl41 Elite Undead", lootid = "RFDAmnennar", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFDTrash", leaveGap = 1 }
			},

			{	name = "Der Kral von Razorfen",			-- Der Kral von Razorfen
				type = AM_TYP_INSTANCE,
				displayname = "Der Kral von Razorfen",
				displayshort = "KvR",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenKraul",
				location = "Brachland (42, 86)",
				levels = "28-33",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 71} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Roogug", colour = AM_RED, coords = { {73, 44} }, symbol = { "1" },
						tooltiptxt = "Lvl28 Elite Mensch" },
				dtl3  = { text = "Aggem Thorncurse", colour = AM_RED, coords = { {88, 48} }, symbol = { "2" },
						tooltiptxt = "Lvl30 Elite Mensch" },
				dtl4  = { text = "Todessprecher Jargba", colour = AM_RED, coords = { {93, 38} }, symbol = { "3" },
						tooltiptxt = "Lvl30 Elite Mensch", lootid = "RFKDeathSpeakerJargba" },
				dtl5  = { text = "Oberanf\195\188hrer Rammhauer", colour = AM_RED, coords = { {60, 29} }, symbol = { "4" },
						tooltiptxt = "Lvl32 Elite Mensch", lootid = "RFKOverlordRamtusk"  },
				dtl6 = { text = "Erdenrufer Halmgar", colour = AM_RED, coords = { {49, 37} }, symbol = { "5" },
						tooltiptxt = "Lvl32 Elite Mensch", special = AM_RARE, lootid = "RFKEarthcallerHalmgar"  },
				dtl7 = { text = "Willix der Importeur,\n& Heralath Fallowbrook", colour = AM_BLUE, coords = { {35, 33} }, symbol = { "6" },
						tooltiptxt = ""  },
				dtl8  = { text = "Charlga Razorflank", colour = AM_RED, coords = { {21, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl33 Elite Mensch", lootid = "RFKCharlgaRazorflank"  },
				dtl9  = { text = "Blind Hunter", colour = AM_RED, coords = { {6, 32} }, symbol = { "8" },
						tooltiptxt = "Lvl32 Elite Bestie\n& Chest", special = AM_RARE, lootid = "RFKBlindHunter"  },
				dtl10  = { text = "Ward Sealing Agathelos", colour = AM_GREEN, coords = { {4, 54} }, symbol = { "9" },
						tooltiptxt = ""  },
				dtl11  = { text = "Agathelos der Tobende", colour = AM_RED, coords = { {11, 65} }, symbol = { "10" },
						tooltiptxt = "Lvl33 Elite Bestie", lootid = "RFKAgathelos", leaveGap = 1  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFKTrash", leaveGap = 1 }
			},

			{	name = "Ruinen von Ahn'Qiraj",		-- Die Ruinen von Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "Ruinen von Ahn'Qiraj",
				displayshort = "AQ20",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RuinsofAhnQiraj",		-- RuinsofAhnQiraj
				location = "Silithus (29, 96)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {64, 2} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Kurinnaxx", colour = AM_RED, coords = { {55, 29} }, symbol = { "1" },
						tooltiptxt = "Boss & Elites", lootid = "AQ20Kurinnaxx" },
				dtl3  = { text ="Generallieutenant Andorov,\n&Four Kaldorei Elites", colour = AM_RED, coords = { {55, 29} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20Andorov" },
				dtl4  = { text = "Captain Qeez", colour = AM_RED, coords = { {52.1, 46.9} }, symbol = { "2" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN" },
				dtl5  = { text = "Captain Tuubid", colour = AM_RED, coords = { {55.4, 46.9} }, symbol = { "3" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN" },
				dtl6  = { text = "Captain Drenn", colour = AM_RED, coords = { {57.2, 47.9} }, symbol = { "4" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
				dtl7  = { text = "Captain Xurrem", colour = AM_RED, coords = { {59.2, 49.2} }, symbol = { "5" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
				dtl8  = { text = "Major Yeggeth", colour = AM_RED, coords = { {61.3, 50.3} }, symbol = { "6" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
				dtl9  = { text = "Major Pakkong", colour = AM_RED, coords = { {60, 53.4} }, symbol = { "7" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
				dtl10  = { text = "Colonel Zerran", colour = AM_RED, coords = { {56, 51.2} }, symbol = { "8" },
						tooltiptxt = "Lvl63 Elite", lootid = "AQ20CAPTIAN"  },
				dtl11 = { text = "General Rajaxx", colour = AM_RED, coords = { {52.2, 49.5} }, symbol = { "9" },
						tooltiptxt = "Boss", lootid = "AQ20Rajaxx"  },
				dtl12 = { text = "Moam", colour = AM_RED, coords = { {13, 31} }, symbol = { "10" },
						tooltiptxt = "Boss", lootid = "AQ20Moam"  },
				dtl13 = { text = "Buru der Verschlinger", colour = AM_RED, coords = { {83, 55} }, symbol = { "11" },
						tooltiptxt = "Boss", lootid = "AQ20Buru"  },
				dtl14 = { text = "Sicherer Raum", colour = AM_GREEN, coords = { {65, 70} }, symbol = { "12" },
						tooltiptxt = ""  },
				dtl15 = { text = "Ayamiss der J\195\164ger", colour = AM_RED, coords = { {67, 91} }, symbol = { "13" },
						tooltiptxt = "Boss", lootid = "AQ20Ayamiss"  },
				dtl16 = { text = "Ossirian der Narbenlose", colour = AM_RED, coords = { {29, 73} }, symbol = { "14" },
						tooltiptxt = "Boss", lootid = "AQ20Ossirian", leaveGap = 2  },
				dtl17 = { text = "B\195\188cher", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20ClassBooks" },
				dtl18 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants" },
				dtl19 = { text = "AQ20"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20SET", leaveGap = 1 }
			},

			{	name = "Das scharlachrote Kloster",			-- Scarlet Monastery
				type = AM_TYP_INSTANCE,
				displayname = "Das scharlachrote Kloster",
				displayshort = "SM",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ScarletMonastery",
				location = "Tirisfal (83.6, 34)",
				levels = "30-40",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "Eingang Friedhof", colour = AM_GREEN, coords = { {61, 97} }, symbol = { "G" },
						tooltiptxt = "", toMap = "Das scharlachrote Kloster"..AM_EXTERIOR },
				dtl2  = { text = "Eisenstachel", colour = AM_RED, coords = { {21, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMIronspine"  },
				dtl3  = { text = "Azshir der Schlaflose", colour = AM_RED, coords = { {5, 88} }, symbol = { "2" },
						tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMAzshir"  },
				dtl4  = { text = "Gefallener Held", colour = AM_RED, coords = { {8, 80} }, symbol = { "3" },
						tooltiptxt = "Lvl33 Elite Undead\nGraveyard", special = AM_RARE, lootid = "SMFallenChampion" },
				dtl5  = { text = "Blutmagier Thalnos", colour = AM_RED, coords = { {5, 77} }, symbol = { "4" },
						tooltiptxt = "Lvl34 Elite Undead\nGraveyard", lootid = "SMBloodmageThalnos" },
				dtl6  = { text = "Eingang Bibliothek", colour = AM_GREEN, coords = { {56, 74} }, symbol = { "L" },
						tooltiptxt = "", toMap = "Das scharlachrote Kloster"..AM_EXTERIOR },
				dtl7  = { text = "Hundemeister Loksey", colour = AM_RED, coords = { {66.1, 95} }, symbol = { "5" },
						tooltiptxt = "Lvl34 Elite Mensch\nBibliothek", lootid = "SMHoundmasterLoksey"  },
				dtl8  = { text = "Arkanist Doan", colour = AM_RED, coords = { {95.1, 92} }, symbol = { "6" },
						tooltiptxt = "Lvl37 Elite Mensch\nBibliothek", lootid = "SMDoan", leaveGap = 1  },
				dtl9  = { text = "Eingang Waffenkammer", colour = AM_GREEN, coords = { {54, 65} }, symbol = { "A" },
						tooltiptxt = "", toMap = "Das scharlachrote Kloster"..AM_EXTERIOR },
				dtl10 = { text = "Herod", colour = AM_RED, coords = { {74.8, 6.2} }, symbol = { "7" },
						tooltiptxt = "Lvl40 Elite Mensch\nArmoury", lootid = "SMHerod", leaveGap = 1  },
				dtl11 = { text = "Eingang Kathedrale", colour = AM_GREEN, coords = { {37, 65} }, symbol = { "C" },
						tooltiptxt = "", toMap = "Das scharlachrote Kloster"..AM_EXTERIOR },
				dtl12 = { text = "Hochinquisitor Fairbanks", colour = AM_RED, coords = { {31, 11} }, symbol = { "8" },
						tooltiptxt = "Lvl40 Elite Mensch\nCathedral", lootid = "SMFairbanks"  },
				dtl13 = { text = "Scharlachroter Mograine", colour = AM_RED, coords = { {23.4, 12} }, symbol = { "9" },
						tooltiptxt = "Lvl42 Elite Mensch\nCathedral", lootid = "SMMograine"  },
				dtl14 = { text = "Hochinquisitor Whitemane", colour = AM_RED, coords = { {23.4, 4.4} }, symbol = { "10" },
						tooltiptxt = "Lvl42 Elite Mensch\nCathedral", lootid = "SMWhitemane", leaveGap = 2  },
				dtl15 = { text = "Set : Chain of the Scarlet Crusade", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "6 Piece", lootid = "SMScarletSET", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "SMTrash", leaveGap = 1 }
			},

			{	name = "Ahn'Qiraj",			-- Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "Tempel von Ahn'Qiraj",
				displayshort = "AQ40",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TempleofAhnQiraj",		-- TempleofAhnQiraj
				location = "Silithus (29, 96)",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {16, 37} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Arygos\n& Caelestrasz\n& Merithra des Traums", colour = AM_BLUE, coords = { {21, 56} }, symbol = { "A" },
						tooltiptxt = ""  },
				dtl3  = { text = "Andorgos\n& Vethsera\n& Kandrostrasz", colour = AM_BLUE, coords = { {27, 43} }, symbol = { "B" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Der Prophet Skeram", colour = AM_RED, coords = { {19, 41} }, symbol = { "1" },
						tooltiptxt = "Boss\nDrau\195\159en", lootid = "AQ40Skeram" },
				dtl5  = { text = "Vem & Co", colour = AM_RED, coords = { {15, 52} }, symbol = { "2" },
						tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Vem" },
				dtl6  = { text = "Schlachtwache Sartura", colour = AM_RED, coords = { {40, 30} }, symbol = { "3" },
						tooltiptxt = "Boss", lootid = "AQ40Sartura" },
				dtl7  = { text = "Fankriss der Unnachgiebige", colour = AM_RED, coords = { {67, 14} }, symbol = { "4" },
						tooltiptxt = "Boss", lootid = "AQ40Fankriss"  },
				dtl8  = { text = "Viscidus", colour = AM_RED, coords = { {82, 7} }, symbol = { "5" },
						tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Viscidus"  },
				dtl9  = { text = "Prinzessin Huhuran", colour = AM_RED, coords = { {41, 49} }, symbol = { "6" },
						tooltiptxt = "Boss", lootid = "AQ40Huhuran"  },
				dtl10 = { text = "Die Zwillingsimperatoren", colour = AM_RED, coords = { {72, 67} }, symbol = { "7" },
						tooltiptxt = "Boss", lootid = "AQ40Emperors"  },
				dtl11 = { text = "Ouro", colour = AM_RED, coords = { { 22, 87 } }, symbol = { "8" },
						tooltiptxt = "Boss", special = AM_OPTIONAL, lootid = "AQ40Ouro" },
				dtl12 = { text = "Auge von C'Thun", colour = AM_RED, coords = { {25, 50} }, symbol = { "9" },
						tooltiptxt = "", lootid = "AQ40CThun" },
				dtl13 = { text = "C'Thun", colour = AM_RED, coords = { {25, 50} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40CThun", leaveGap = 2 },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40Trash", leaveGap = 1 },
				dtl15 = { text = "AQ40 "..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40SET", leaveGap = 1 },
				dtl16 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants", leaveGap = 1 },
				dtl17 = { text = "AQ Brood Rings", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQBroodRings", leaveGap = 1 },
				dtl18 = { text = AM_OPENING, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQOpening", leaveGap = 1 }
			},

			{	name = "Die Todesminen",			-- The Deadmines
				type = AM_TYP_INSTANCE,
				displayname = "Die Todesminen",
				displayshort = "DM",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheDeadmines",
				location = "Westfall (42, 72)",
				levels = "16-26",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Die Todesminen"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {99, 42} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {80, 40} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Rhahk'Zor", colour = AM_RED, coords = { {21, 58} }, symbol = { "1" },
						tooltiptxt = "Lvl19 Elite Mensch", lootid = "VCRhahkZor" },
				dtl5  = { text = "Minenarbeiter Johnson", colour = AM_RED, coords = { {41, 50} }, symbol = { "2" },
						tooltiptxt = "Lvl19 Elite Mensch", lootid = "VCMinerJohnson", special = AM_RARE  },
				dtl6  = { text = "Sneed", colour = AM_RED, coords = { {37, 77} }, symbol = { "3" },
						tooltiptxt = "Lvl20 Elite Mechanical (in Shredder)", lootid = "VCSneed"  },
				dtl7  = { text = "Gilnid", colour = AM_RED, coords = { {48.8, 60.2} }, symbol = { "4" },
						tooltiptxt = "Lvl20 Elite Mensch", lootid = "VCGilnid"  },
				dtl8  = { text = "Defias Gunpowder", colour = AM_GREEN, coords = { {55.6, 39} }, symbol = { "5" },
						tooltiptxt = "...Blast Powder to blow the doors"  },
				dtl9  = { text = "Mr. Smite", colour = AM_RED, coords = { {76, 31} }, symbol = { "6" },
						tooltiptxt = "Lvl20 Elite Mensch", lootid = "VCMrSmite"  },
				dtl10 = { text = "Cookie", colour = AM_RED, coords = { {81, 36} }, symbol = { "7" },
						tooltiptxt = "", lootid = "VCCookie"  },
				dtl11 = { text = "Captain Greenskin", colour = AM_RED, coords = { {76, 37} }, symbol = { "8" },
						tooltiptxt = "Lvl21 Elite Mensch", lootid = "VCCaptainGreenskin"  },
				dtl12 = { text = "Edwin VanCleef", colour = AM_RED, coords = { {79, 37} }, symbol = { "9" },
						tooltiptxt = "Lvl21 Elite Mensch", lootid = "VCVanCleef", leaveGap = 2 },
				dtl13 = { text = "Set : Defiasleder (5 Teile)", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "VCDefiasSET", leaveGap = 1 }
			},

			{	name = "Das Verlies",			-- Das Verlies
				type = AM_TYP_INSTANCE,
				displayname = "Das Verlies",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheStockade",
				location = "Stormwind",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {69, 60}, {75, 40}, {26, 57}, {31, 36}, {18, 29} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Targorr der Schreckliche", colour = AM_RED, coords = { {58, 63}, {41, 55}, {50, 37}, {27, 50} }, symbol = { "1" },
						tooltiptxt = "Lvl24 Elite Mensch", special = AM_VARIES },
				dtl4  = { text = "Kam Deepfury", colour = AM_RED, coords = { {73, 43} }, symbol = { "2" },
						tooltiptxt = "Lvl27 Elite Mensch", lootid = "SWStKamDeepfury" },
				dtl5  = { text = "Hamhock", colour = AM_RED, coords = { {85, 56} }, symbol = { "3" },
						tooltiptxt = "Lvl28 Elite Mensch"  },
				dtl6  = { text = "Bazil Thredd", colour = AM_RED, coords = { {95, 62} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl7  = { text = "Dextren Ward", colour = AM_RED, coords = { {15, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl26 Elite Mensch"  },
				dtl8  = { text = "Bruegal Ironknuckle", colour = AM_RED, coords = { {22, 54} }, symbol = { "6" },
						tooltiptxt = "Lvl26 Elite Mensch", special = AM_RARE, lootid = "SWStBruegalIronknuckle", leaveGap = 1 }
			},

			{	name = "Der versunkene Tempel",			-- Sunken Temple
				type = AM_TYP_INSTANCE,
				displayname = "Der versunkene Tempel",
				displayshort = "ST",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSunkenTemple",
				location = "S\195\188mpfe des Elends (70, 53)",
				levels = "45-60",
				players = "10",
				prereq = "",
				general = "Tempel Atal'Hakkar",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der versunkene Tempel"..AM_EXTERIOR },
				dtl2  = { text = "Treppen zum Unten", colour = AM_GREEN, coords = { {54, 11.3}, {13.9, 47} }, symbol = { "SL" },
						tooltiptxt = "" },
				dtl3  = { text = "Treppen", colour = AM_GREEN, coords = { {69, 11.3} }, symbol = { "SM" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "Treppen zum Oben", colour = AM_BLUE, coords = { {52, 18}, {69, 18}, {52, 48}, {69, 48} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "" },
				dtl5  = { text = "Troll Minibosses (Oben level)", colour = AM_RED, coords = { {55, 23}, {66, 23}, {72, 33}, {49, 33}, {54, 43}, {66, 43} }, symbol = { "T1", "T2", "T3", "T4", "T5", "T6" },
						tooltiptxt = "Kill all, then Jammal'an\nto fight Eranikus", lootid = "STTrollMinibosses", leaveGap = 1 },
				dtl6  = { text = "Statuen", colour = AM_ORANGE, coords = { {22, 82}, {22, 64}, {13, 77}, {30, 77}, {13, 68}, {30, 68} }, symbol = { "S1", "S2", "S3", "S4", "S5", "S6" },
						tooltiptxt = "Activate in numerical order to\nsummon Atal'alarion" },
				dtl7  = { text = "Altar von Hakkar", colour = AM_ORANGE, coords = { {22, 74} }, symbol = { "1" },
						tooltiptxt = ""  },
				dtl8  = { text = "Atal'alarion", colour = AM_RED, coords = { {22, 71} }, symbol = { "2" },
						tooltiptxt = "Lvl50 Elite Mensch", lootid = "STAtalalarion", leaveGap = 1  },
				dtl9  = { text = "Traumsense", colour = AM_RED, coords = { {58, 33} }, symbol = { "3" },
						tooltiptxt = "Lvl53 Elite Dragonkin", lootid = "STDreamscythe"  },
				dtl10 = { text = "Wirker", colour = AM_RED, coords = { {62, 33} }, symbol = { "4" },
						tooltiptxt = "Lvl51 Elite Dragonkin", lootid = "STWeaver"  },
				dtl11 = { text = "Avatar of Hakkar", colour = AM_RED, coords = { {32, 33} }, symbol = { "5" },
						tooltiptxt = "Lvl50 Elite Dragon", lootid = "STAvatarofHakkar"  },
				dtl12 = { text = "Jammal'an der Prophet", colour = AM_RED, coords = { {88, 27} }, symbol = { "6" },
						tooltiptxt = "Lvl54 Elite Mensch", lootid = "STJammalan"  },
				dtl13 = { text = "Ogom der Elende", colour = AM_RED, coords = { {88, 31} }, symbol = { "7" },
						tooltiptxt = "Lvl53 Elite Undead", lootid = "STOgom"  },
				dtl14 = { text = "Morphaz", colour = AM_RED, coords = { {59, 62} }, symbol = { "8" },
						tooltiptxt = "Lvl52 Elite Dragon", lootid = "STMorphaz"  },
				dtl15 = { text = "Hazzas", colour = AM_RED, coords = { {62, 62} }, symbol = { "9" },
						tooltiptxt = "Lvl53 Elite Dragon", lootid = "STHazzas"  },
				dtl16 = { text = "Eranikus' Schemen", colour = AM_RED, coords = { {80, 62} }, symbol = { "10" },
						tooltiptxt = "Lvl55 Elite Dragon", lootid = "STEranikus"  },
				dtl17 = { text = "Essenzen Schriftsatz", colour = AM_ORANGE, coords = { {85, 57} }, symbol = { "11" },
						tooltiptxt = "", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "STTrash", leaveGap = 1 }
			},

			{	name = "Uldaman",			-- Uldaman
				type = AM_TYP_INSTANCE,
				displayname = "Uldaman",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Uldaman",
				location = "Das \195\150dland (44, 12)",
				levels = "35-50",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "Eingang (Vorne)", colour = AM_GREEN, coords = { {89, 73.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Uldaman"..AM_EXTERIOR },
				dtl2  = { text = "Eingang (Hinten)", colour = AM_GREEN, coords = { {21, 71} }, symbol = { "XR" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Baelog", colour = AM_RED, coords = { {73, 93} }, symbol = { "1" },
						tooltiptxt = "Lvl41 Elite" },
				dtl4  = { text = "\195\156berreste eines Paladins", colour = AM_ORANGE, coords = { {62.8, 63.2} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "Revelosh", colour = AM_RED, coords = { {64, 73.3} }, symbol = { "3" },
						tooltiptxt = "Lvl40 Elite Mensch", lootid = "UldRevelosh"  },
				dtl6  = { text = "Ironaya", colour = AM_RED, coords = { {38, 75} }, symbol = { "4" },
						tooltiptxt = "Boss Giant", lootid = "UldIronaya"  },
				dtl7  = { text = "Annora (Verzauberungsmeister)", colour = AM_BLUE, coords = { {56, 61} }, symbol = { "5" },
						tooltiptxt = ""  },
				dtl8  = { text = "Obsidian-Schildwache", colour = AM_RED, coords = { {24.4, 62} }, symbol = { "6" },
						tooltiptxt = "Lvl42 Elite Mechanical"  },
				dtl9  = { text = "Uralter Steinbewahrer", colour = AM_RED, coords = { {54.7, 43} }, symbol = { "7" },
						tooltiptxt = "Lvl44 Elite Elementar", lootid = "UldAncientStoneKeeper"  },
				dtl10 = { text = "Galgann Firehammer", colour = AM_RED, coords = { {21, 31} }, symbol = { "8" },
						tooltiptxt = "Boss Mensch", lootid = "UldGalgannFirehammer"  },
				dtl11 = { text = "Grimlok", colour = AM_RED, coords = { {17, 19} }, symbol = { "9" },
						tooltiptxt = "Lvl45 Elite Mensch", lootid = "UldGrimlok"  },
				dtl12 = { text = "Archaedas", colour = AM_RED, coords = { {45.2, 14.4} }, symbol = { "10" },
						tooltiptxt = "Boss Giant\nLower level", lootid = "UldArchaedas"  },
				dtl13 = { text = "Die Scheiben von Norgannon", colour = AM_ORANGE, coords = { {39.7, 6.2} }, symbol = { "11" },
						tooltiptxt = "Oben level"  },
				dtl14 = { text = "Antiker Schatz", colour = AM_ORANGE, coords = { {42.3, 4.9} }, symbol = { "12" },
						tooltiptxt = "Lower level", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UldTrash", leaveGap = 1 }
			},

			{ 	name = "Die H\195\182hlen des Wehklagens",			-- Die H\195\182hlen des Wehklagens
				type = AM_TYP_INSTANCE,
				displayname = "Die H\195\182hlen des Wehklagens",
				displayshort = "WC",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\WailingCaverns",
				location = "Brachland (46, 36)",
				levels = "16-25",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {44, 58} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Die H\195\182hlen des Wehklagens"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {62, 47}, {94, 49} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "J\195\188nger von Naralex", colour = AM_BLUE, coords = { {45, 53} }, symbol = { "1" },
						tooltiptxt = "Triggers Instance Final" },
				dtl4  = { text = "Lord Kobrahn", colour = AM_RED, coords = { {14, 55} }, symbol = { "2" },
						tooltiptxt = "Lvl20 Elite Mensch", lootid = "WCLordCobrahn" },
				dtl5  = { text = "Lady Anacondra", colour = AM_RED, coords = { {39, 35} }, symbol = { "3" },
						tooltiptxt = "Lvl20 Elite Mensch", lootid = "WCLadyAnacondra" },
				dtl6  = { text = "Kresh", colour = AM_RED, coords = { {45, 42} }, symbol = { "4" },
						tooltiptxt = "Lvl20 Elite Mensch", lootid = "WCKresh"  },
				dtl7  = { text = "Deviatfeendrache", colour = AM_RED, coords = { {63, 43} }, symbol = { "5" },
						tooltiptxt = "Lvl20 Elite Dragonkin", lootid = "WCDeviateFaerieDragon", special = AM_RARE },
				dtl8  = { text = "Lord Pythas", colour = AM_RED, coords = { {86, 34} }, symbol = { "6" },
						tooltiptxt = "Lvl22 Elite Mensch", lootid = "WCLordPythas"  },
				dtl9  = { text = "Skum", colour = AM_RED, coords = { {93, 69} }, symbol = { "7" },
						tooltiptxt = "Lvl21 Elite Mensch", lootid = "WCSkum"  },
				dtl10  = { text = "Lord Serpentis", colour = AM_RED, coords = { {60, 52} }, symbol = { "8" },
						tooltiptxt = "Lvl22 Elite Mensch\nOben level", lootid = "WCLordSerpentis"  },
				dtl11 = { text = "Verdan der Ewiglebende", colour = AM_RED, coords = { {56, 48} }, symbol = { "9" },
						tooltiptxt = "Lvl24 Elite Elementar\nOben level", lootid = "WCVerdan"  },
				dtl12 = { text = "Mutanus der Verschlinger", colour = AM_RED, coords = { {29.9, 23.9} }, symbol = { "10" },
						tooltiptxt = "Lvl22 Elite Mensch\nTriggered Spawn", lootid = "WCMutanus"  },
				dtl13 = { text = "Naralex", colour = AM_RED, coords = { {32.4, 25.4} }, symbol = { "11" },
						tooltiptxt = "Lvl25 Elite Mensch", leaveGap = 2  },
				dtl14 = { text = "Set : Embrace of the Viper", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "WCViperSET", leaveGap = 1 }
			},

			{	name = "Zul'Farrak",			-- Zul'Farrak
				type = AM_TYP_INSTANCE,
				displayname = "Zul'Farrak",
				displayshort = "ZF",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulFarrak",
				location = "Tanaris (37, 15)",
				levels = "43-47",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {69, 89} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Zerillis", colour = AM_RED, coords = { {63, 47} }, symbol = { "1" },
						tooltiptxt = "Lvl45 Elite Mensch", special = AM_RARE.." "..AM_WANDERS, lootid = "ZFZerillis" },
				dtl3  = { text = "Sandarr Dunereaver", colour = AM_RED, coords = { {55, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl45 Elite Mensch", special = AM_RARE },
				dtl4  = { text = "Wasserbeschw\195\182rerin Velratha", colour = AM_RED, coords = { {34, 43} }, symbol = { "3" },
						tooltiptxt = "Lvl46 Elite Mensch" },
				dtl5  = { text = "Gahz'rilla", colour = AM_RED, coords = { {37, 46} }, symbol = { "4" },
						tooltiptxt = "Lvl46 Elite Bestie", lootid = "ZFGahzrilla"  },
				dtl6  = { text = "Dustwraith", colour = AM_RED, coords = { {32, 46} }, symbol = { "5" },
						tooltiptxt = "Lvl45 Elite Mensch", special = AM_RARE, lootid = "ZFDustwraith"  },
				dtl7  = { text = "Antu'sul", colour = AM_RED, coords = { {80, 35} }, symbol = { "6" },
						tooltiptxt = "Lvl48 Elite Mensch", lootid = "ZFAntusul"  },
				dtl8  = { text = "Theka der M\195\164rtyrer", colour = AM_RED, coords = { {67, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl46 Elite Mensch"  },
				dtl9  = { text = "Hexendoktor Zum'rah", colour = AM_RED, coords = { {53, 23} }, symbol = { "8" },
						tooltiptxt = "Lvl46 Elite Mensch", lootid = "ZFWitchDoctorZumrah"  },
				dtl10 = { text = "Toter Zul'Farrak-Held", colour = AM_RED, coords = { {51, 27} }, symbol = { "9" },
						tooltiptxt = "Lvl46 Elite Mensch"  },
				dtl11 = { text = "Schattenpriester Sezz'ziz", colour = AM_RED, coords = { {36, 26} }, symbol = { "10" },
						tooltiptxt = "Lvl47 Elite Mensch", lootid = "ZFSezzziz" },
				dtl12 = { text = "Nekrum Gutchewer", colour = AM_RED, coords = { {36, 26} }, symbol = { " " },
						tooltiptxt = "Lvl46 Elite Undead"  },
				dtl13 = { text = "Sergeant Bly", colour = AM_ORANGE, coords = { {26, 26} }, symbol = { "11" },
						tooltiptxt = "Divino-matic Rod Quest\nHostile/Friendly depending on\nfaction and actions taken" },
				dtl14 = { text = "Ruuzlu", colour = AM_RED, coords = { {51, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl46 Elite Mensch"  },
				dtl15 = { text = "H\195\164uptling Ukorz Sandscalp", colour = AM_RED, coords = { {55, 42} }, symbol = { "13" },
						tooltiptxt = "Lvl48 Elite Mensch", lootid = "ZFChiefUkorzSandscalp", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZFTrash", leaveGap = 1 }
			},

			{	name = "Zul'Gurub",			-- Zul'Gurub
				type = AM_TYP_INSTANCE,
				displayname = "Zul'Gurub",
				displayshort = "ZG",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulGurub",
				location = "Schlingendorntal (54, 17)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 50} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "Schlammiges aufgew\195\188hltes Gew\195\164sser", colour = AM_BLUE, coords = { {33, 41}, {47, 48}, {57, 47}, {60, 32}, {47, 30} }, symbol = { "W" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Hohepriesterin Jeklik", colour = AM_RED, coords = { {34, 78} }, symbol = { "1" },
						tooltiptxt = "Boss Mensch", special = "(Bat)", lootid = "ZGJeklik" },
				dtl4  = { text = "Hohepriester Venoxis", colour = AM_RED, coords = { {56, 57} }, symbol = { "2" },
						tooltiptxt = "Boss Mensch", special = "(Snake)", lootid = "ZGVenoxis" },
				dtl5  = { text = "Hohepriesterin Mar'li", colour = AM_RED, coords = { {48, 85} }, symbol = { "3" },
						tooltiptxt = "Boss Mensch", special = "(Spider)", lootid = "ZGMarli"  },
				dtl6  = { text = "Blutlord Mandokir", colour = AM_RED, coords = { {76, 73} }, symbol = { "4" },
						tooltiptxt = "Boss Mensch", special = "(Raptor)"..AM_OPTIONAL, lootid = "ZGMandokir"  },
				dtl7  = { text = "Rand des Wahnsinns", colour = AM_RED, coords = { {72, 47} }, symbol = { "5" },
						tooltiptxt = "", special = AM_OPTIONAL  },
				dtl8  = { text = "Gri'lek, of the Iron Blood", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "Boss Undead", lootid = "ZGGrilek"  },
				dtl9  = { text = "Hazza'rah, the Dreamweaver", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "Boss Undead", lootid = "ZGHazzarah"  },
				dtl10 = { text = "Renataki, of the Thousand Blades", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "Boss Undead", lootid = "ZGRenataki"  },
				dtl11 = { text = "Wushoolay, the Storm Witch", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "Boss Undead", lootid = "ZGWushoolay"  },
				dtl12 = { text = "Gahz'ranka", colour = AM_RED, coords = { {66, 33} }, symbol = { "6" },
						tooltiptxt = "Boss Mensch", special = AM_OPTIONAL, lootid = "ZGGahzranka"  },
				dtl13 = { text = "Hohepriester Thekal", colour = AM_RED, coords = { {80, 32} }, symbol = { "7" },
						tooltiptxt = "Boss Mensch", special = "(Tiger)", lootid = "ZGThekal" },
				dtl14 = { text = "Hohepriesterin Arlokk", colour = AM_RED, coords = { {49, 16} }, symbol = { "8" },
						tooltiptxt = "Boss Mensch", special = "(Panther)", lootid = "ZGArlokk"  },
				dtl15 = { text = "Jin'do der Hexxer", colour = AM_RED, coords = { {20, 18} }, symbol = { "9" },
						tooltiptxt = "Boss Mensch", special = "(Undead)"..AM_OPTIONAL, lootid = "ZGJindo" },
				dtl16 = { text = "Hakkar", colour = AM_RED, coords = { {54, 40} }, symbol = { "10" },
						tooltiptxt = "Boss Dragon", lootid = "ZGHakkar", leaveGap = 2 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGTrash", leaveGap = 1 },
				dtl18 = { text = "ZG"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGSET", leaveGap = 1 },
				dtl19 = { text = AM_RBOSS_DROP, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGShared", leaveGap = 1 },
				dtl20 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGEnchants", leaveGap = 1 }
			},

			{	name = "Scholomance",			-- Scholomance
				type = AM_TYP_INSTANCE,
				displayname = "Scholomance",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Scholomance",		-- Scholomance*
				location = "Die westlichen Pestl\195\164nder (69, 73)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {24, 30} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {28, 38} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {6.5, 22}, {62, 22} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl4  = {text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {41, 41}, {34, 80} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "Blutschale von Kirtonos", colour = AM_RED, coords = { {54, 32} }, symbol = { "1" },
						tooltiptxt = "Lvl61 Elite Demon", lootid = "SCHOLOBloodSteward"  },
				dtl6  = { text = "Kirtonos der Herold", colour = AM_RED, coords = { {30, 5} }, symbol = { "2" },
						tooltiptxt = "", lootid = "SCHOLOKirtonostheHerald" },
				dtl7  = { text = "Jandice Barov", colour = AM_RED, coords = { {96, 8.5} }, symbol = { "3" },
						tooltiptxt = "Lvl61 Elite Undead", lootid = "SCHOLOJandiceBarov"  },
				dtl8  = { text = "Blutrippe", colour = AM_RED, coords = { {10, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl61 Elite Undead\nLower level\nDrops key to Viewing Room", lootid = "SCHOLORattlegore"  },
				dtl9  = { text = "Todesritter Schattensichel", colour = AM_RED, coords = { {10, 41} }, symbol = { " " },
						tooltiptxt = "Lvl62 Elite Undead\nPaladins/Shaman Quest to Summon", lootid = "SCHOLODeathKnight" },
				dtl10  = { text = "Marduk Blackpool", colour = AM_BLUE, coords = { {23.7, 42} }, symbol = { "5" },
						tooltiptxt = "Lvl58 Elite\nAggro by placing Dawn's Gambit\nin Viewing room", lootid = "SCHOLOMarduk"  },
				dtl11 = { text = "Vectus", colour = AM_BLUE, coords = { {27.2, 42} }, symbol = { "6" },
						tooltiptxt = "Lvl60 Elite Undead\nAggro by placing Dawn's Gambit\nin Viewing room", lootid = "SCHOLOVectus"  },
				dtl12 = { text = "Ras Frostraunen", colour = AM_RED, coords = { {18, 87} }, symbol = { "8" },
						tooltiptxt = "Lvl62 Elite Undead", lootid = "SCHOLORasFrostwhisper"  },
				dtl13 = { text = "Kormok", colour = AM_RED, coords = { {18, 80} }, symbol = { "9" },
						tooltiptxt = "Lvl60 Elite", lootid = "SCHOLOKormok" },
				dtl14 = { text = "Instrukteurin Malicia", colour = AM_RED, coords = { {44.5, 94} }, symbol = { "10" },
						tooltiptxt = "Lvl60 Elite Mensch", lootid = "SCHOLOInstructorMalicia"  },
				dtl15 = { text = "Doktor Theolen Krastinov", colour = AM_RED, coords = { {64, 74.2} }, symbol = { "11" },
						tooltiptxt = "Lvl60 Elite Mensch", lootid = "SCHOLODoctorTheolenKrastinov"  },
				dtl16 = { text = "H\195\188ter des Wissens Polkelt", colour = AM_RED, coords = { {44.8, 55.2} }, symbol = { "12" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLorekeeperPolkelt"  },
				dtl17 = { text = "Der Ravenier", colour = AM_RED, coords = { {75.8, 92} }, symbol = { "13" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOTheRavenian"  },
				dtl18 = { text = "Lord Alexei Barov", colour = AM_RED, coords = { {96.2, 74.5} }, symbol = { "14" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLordAlexeiBarov"  },
				dtl19 = { text = "Lady Illucia Barov", colour = AM_RED, coords = { {75.6, 54} }, symbol = { "15" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "SCHOLOLadyIlluciaBarov" },
				dtl20 = { text = "Dunkelmeister Gandling", colour = AM_RED, coords = { {76.2, 74.4} }, symbol = { "16" },
						tooltiptxt = "Lvl61 Elite Mensch", lootid = "SCHOLODarkmasterGandling", leaveGap = 1 },
				dtl21 = { text = "Kerzenhebel", colour = AM_GREEN, coords = { {89, 19} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl22 = { text = "Alchimielabor", colour = AM_GREEN, coords = { {14, 70} }, symbol = { "AL" },
						tooltiptxt = "", leaveGap = 1 },
				dtl23 = { text = "Besitzurkunde f\195\188r Southshore", colour = AM_ORANGE, coords = { {56, 25} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl24 = { text = "Besitzurkunde f\195\188r Tarrens M\195\188hle", colour = AM_ORANGE, coords = { {11, 36} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl25 = { text = "Besitzurkunde f\195\188r Brill", colour = AM_ORANGE, coords = { {15, 77} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl26 = { text = "Besitzurkunde f\195\188r Caer Darrow", colour = AM_ORANGE, coords = { {94, 72} }, symbol = { "D" },
						tooltiptxt = "Lvl60 Elite Mensch", leaveGap = 1},
			},

			{	name = "Stratholme",			-- Stratholme
				type = AM_TYP_INSTANCE,
				displayname = "Stratholme",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Stratholme",
				location = "Die \195\182stlichen Pestl\195\164nder (30, 12)",
				levels = "55-60",
				players = "5",
				prereq = "",
				general = "Side entrance at EP (47, 24)",
				dtl1  = { text = "Haupteingang", colour = AM_GREEN, coords = { {50, 91} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "Seiteneingang", colour = AM_GREEN, coords = { {83, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Fras Siabis Briefkasten", colour = AM_ORANGE, coords = { {37, 86} }, symbol = { "P1" },
						tooltiptxt = "" },
				dtl4  = { text = "K\195\182nigsplatz Briefkasten", colour = AM_ORANGE, coords = { {47, 74} }, symbol = { "P2" },
						tooltiptxt = "" },
				dtl5  = { text = "\195\132ltestenplatz Briefkasten", colour = AM_ORANGE, coords = { {24, 66} }, symbol = { "P3" },
						tooltiptxt = "" },
				dtl6  = { text = "Marktgasse Briefkasten", colour = AM_ORANGE, coords = { {50, 62} }, symbol = { "P4" },
						tooltiptxt = ""  },
				dtl7  = { text = "Feststra\195\159e Briefkasten", colour = AM_ORANGE, coords = { {61, 62} }, symbol = { "P5" },
						tooltiptxt = ""  },
				dtl8  = { text = "Elders' Square Briefkasten", colour = AM_ORANGE, coords = { {80, 68} }, symbol = { "P6" },
						tooltiptxt = "" },
				dtl9 = { text = "Postmaster Malown", colour = AM_RED, coords = { {37, 86}, {47, 74}, {24, 66}, {50, 62}, {61, 62}, {80, 68} }, symbol = { " " },
						tooltiptxt = "Lvl60 Elite Undead\nSpawns on opening of a 3rd Mail box\nMail box keys looted from Courier", leaveGap = 1 },
				dtl10 = { text = "Skul", colour = AM_RED, coords = { {42, 83} }, symbol = { "1" },
						tooltiptxt = "Lvl58 Elite Undead", special = AM_RARE.." "..AM_WANDERS, lootid = "STRATSkull" },
				dtl11 = { text = "Kurier von Stratholme", colour = AM_RED, coords = { {43, 78} }, symbol = { "2" },
						tooltiptxt = "Lvl57 Elite Undead", lootid = "STRATStratholmeCourier"  },
				dtl12 = { text = "Fras Siabi", colour = AM_RED, coords = { {39, 83} }, symbol = { "3" },
						tooltiptxt = "Lvl61 Elite Undead", lootid = "STRATFrasSiabi"  },
				dtl13 = { text = "Herdsinger Forresten", colour = AM_RED, coords = { {45, 62}, {65, 58}, {66, 66} }, symbol = { "4" },
						tooltiptxt = "Lvl57 Elite Undead\nWill continue to respawn if any\nGhouls that spawn in his place\nare killed", special = AM_VARIES, lootid = "STRATHearthsingerForresten" },
				dtl14 = { text = "Der Unverziehene", colour = AM_RED, coords = { {56, 57} }, symbol = { "5" },
						tooltiptxt = "Lvl57 Elite Undead", lootid = "STRATTheUnforgiven"  },
				dtl15 = { text = "Timmy der Grausame", colour = AM_RED, coords = { {26, 61.5} }, symbol = { "6" },
						tooltiptxt = "Lvl58 Elite Undead", lootid = "STRATTimmytheCruel"  },
				dtl16 = { text = "Kanonenmeister Willey", colour = AM_RED, coords = { {1, 74} }, symbol = { "7" },
						tooltiptxt = "Lvl60 Elite Mensch", lootid = "STRATCannonMasterWilley"  },
				dtl17 = { text = "Archivar Galford", colour = AM_RED, coords = { {24, 92} }, symbol = { "8" },
						tooltiptxt = "Lvl60 Elite Mensch", lootid = "STRATArchivistGalford"  },
				dtl18 = { text = "Balnazzar", colour = AM_RED, coords = { {17, 97} }, symbol = { "9" },
						tooltiptxt = "Lvl62 Elite Demon", lootid = "STRATBalnazzar"  },
				dtl19 = { text = "Sothos", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "Requires Jarien & Sothos's Brazier of Summoning", lootid = "STRATSothosJarien" },
				dtl20 = { text = "Jarien", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "Requires Jarien & Sothos's Brazier of Summoning", lootid = "STRATSothosJarien" },
				dtl21 = { text = "Aurius", colour = AM_BLUE, coords = { {81, 61} }, symbol = { "10" },
						tooltiptxt = ""  },
				dtl22 = { text = "Steinbuckel", colour = AM_RED, coords = { {78, 42} }, symbol = { "11" },
						tooltiptxt = "Lvl60 Elite Undead", special = AM_RARE, lootid = "STRATStonespine"  },
				dtl23 = { text = "Baroness Anastari", colour = AM_RED, coords = { {90, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl59 Elite Undead", lootid = "STRATBaronessAnastari"  },
				dtl24 = { text = "Nerub'enkan", colour = AM_RED, coords = { {64, 39} }, symbol = { "13" },
						tooltiptxt = "Lvl60 Elite Undead", lootid = "STRATNerubenkan"  },
				dtl25 = { text = "Maleki der Leichenblasse", colour = AM_RED, coords = { {81, 14} }, symbol = { "14" },
						tooltiptxt = "Lvl61 Elite Mensch", lootid = "STRATMalekithePallid"  },
				dtl26 = { text = "Magistrate Barthilas", colour = AM_RED, coords = { {66, 10}, {74, 60} }, symbol = { "15" },
						tooltiptxt = "Lvl58 Elite Undead", special = AM_VARIES, lootid = "STRATMagistrateBarthilas" },
				dtl27 = { text = "Ramstein der Verschlinger", colour = AM_RED, coords = { {56, 15} }, symbol = { "16" },
						tooltiptxt = "Lvl61 Elite Undead", lootid = "STRATRamsteintheGorger"  },
				dtl28 = { text = "Baron Rivendare", colour = AM_RED, coords = { {42, 15} }, symbol = { "17" },
						tooltiptxt = "Lvl62 Elite Undead", lootid = "STRATBaronRivendare", leaveGap = 1 }
			},

			{	name = "Burg Shadowfang",			-- Burg Shadowfang
				type = AM_TYP_INSTANCE,
				displayname = "SBurg Shadowfang",
				displayshort = "BSF",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowfangKeep",
				location = "Silberwald (45, 67)",
				levels = "20-30",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 69} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {57, 57}, {36, 55}, {29, 12} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = "Zinnen", colour = AM_BLUE, coords = { {38, 71}, {54, 93} }, symbol = { "B1" },
						tooltiptxt = "" },
				dtl4  = {text = "Zinnen", colour = AM_BLUE, coords = { {69, 85}, {35, 37} }, symbol = { "B2" },
						tooltiptxt = "" },
				dtl5  = { text = "Todesh\195\182riger Captain", colour = AM_RED, coords = { {69, 85}, {35, 37} }, symbol = { " " },
						tooltiptxt = "Lvl25 Elite Undead", special = AM_RARE  },
				dtl6  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {29.8, 34.8}, {50, 46.8} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl7  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {42, 32}, {67, 33} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "Rethilgore", colour = AM_RED, coords = { {70, 78} }, symbol = { "1" },
						tooltiptxt = "Lvl20 Elite Mensch\nThe Cell Keeper" },
				dtl9  = { text = "Zauberhexer Ashcrombe", colour = AM_RED, coords = { {67, 73} }, symbol = { "2" },
						tooltiptxt = "Lvl18 Elite Mensch"  },
				dtl10 = { text = "Deathstalker Adamant", colour = AM_RED, coords = { {71, 74} }, symbol = { "3" },
						tooltiptxt = "Lvl18 Elite Mensch"  },
				dtl11 = { text = "Klingenklaue der Metzger", colour = AM_RED, coords = { {25, 59} }, symbol = { "4" },
						tooltiptxt = "Lvl22 Elite Mensch", lootid = "BSFRazorclawtheButcher"  },
				dtl12 = { text = "Kommandant Silverlaine", colour = AM_RED, coords = { {13, 87} }, symbol = { "5" },
						tooltiptxt = "Lvl24 Elite Undead", lootid = "BSFSilverlaine" },
				dtl13 = { text = "Commander Springvale", colour = AM_RED, coords = { {26, 69} }, symbol = { "6" },
						tooltiptxt = "Lvl24 Elite Undead", lootid = "BSFSpringvale"  },
				dtl14 = { text = "Odo der Blindseher", colour = AM_RED, coords = { {61, 84} }, symbol = { "7" },
						tooltiptxt = "Lvl24 Elite Mensch", lootid = "BSFOdotheBlindwatcher"  },
				dtl15 = { text = "Fenrus der Verschlinger", colour = AM_RED, coords = { {53.4, 33.4} }, symbol = { "8" },
						tooltiptxt = "Lvl25 Elite Bestie", lootid = "BSFFenrustheDevourer"  },
				dtl16 = { text = "Wolfmeister Nandos", colour = AM_RED, coords = { {80, 29} }, symbol = { "9" },
						tooltiptxt = "Lvl25 Elite Mensch", lootid = "BSFWolfMasterNandos"  },
				dtl17 = { text = "Erzmagier Arugal", colour = AM_RED, coords = { {84, 13} }, symbol = { "10" },
						tooltiptxt = "Lvl26 Elite Mensch", lootid = "BSFArchmageArugal", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BSFTrash", leaveGap = 1 }
			},

			{	name = "H\195\182llenfeuerbollwerk",		-- Hellfire Rampart
				type = AM_TYP_INSTANCE,
				displayname = "HZ: H\195\182llenfeuerbollwerk",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCRampart",				-- HCRampart
				location = "H\195\182llenfeuerhalbinsel",
				levels = "60-62",
				players = "20",
				prereq = "Key: Flammengeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "H\195\182llenfeuerzitadelle\nRuf: Thrallmar (Horde)\nRuf: Ehrenfeste (Allianz)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 63} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Wachhabender Gargolmar", colour = AM_RED, coords = { {80, 24} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "HCRampWatchkeeper" },
				dtl3  = { text = "Omor der Narbenlose", colour = AM_RED, coords = { {22, 14} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCRampOmor" },
				dtl4  = { text = "Vazruden der Herold", colour = AM_RED, coords = { {16, 81} }, symbol = { "3" },
						tooltiptxt = "Kill both hellfire sentry to start encounter", lootid = "HCRampVazruden" },
				dtl5  = { text = "Nazan", colour = AM_RED, coords = { {16, 81} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampNazan", leaveGap = 1 },
				dtl6  = { text = "Verst\195\164rkte Teufelseisentruhe", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampFelIronChest", leaveGap = 1 }
			},

			{	name = "Der Blutkessel",			-- The Blood Furnace
				type = AM_TYP_INSTANCE,
				displayname = "HZ: Der Blutkessel",
				displayshort = "BF",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCBloodFurnace",			-- HCBloodFurnace
				location = "H\195\182llenfeuerhalbinsel",
				levels = "61-63",
				players = "20",
				prereq = "Key: Flammengeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "H\195\182llenfeuerzitadelle\nRuf: Thrallmar (Horde)\nRuf: Ehrenfeste (Allianz)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 91.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Der Sch\195\182pfer", colour = AM_RED, coords = { {29.3, 35} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCFurnaceMaker" },
				dtl3  = { text = "Broggok", colour = AM_RED, coords = { {41, 13.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCFurnaceBroggok" },
				dtl4  = { text = "Keli'dan der Zerst\195\182rer", colour = AM_RED, coords = { {65.6, 35.2} }, symbol = { "3" },
						tooltiptxt = "", lootid = "HCFurnaceBreaker", leaveGap = 1 }
			},

			{	name = "Die zerschmetterten Hallen",		-- Shattered Halls
				type = AM_TYP_INSTANCE,
				displayname = "HZ: Die zerschmetterten Hallen",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCShatteredHalls",			-- HCShatteredHalls
				location = "H\195\182llenfeuerhalbinsel",
				levels = "70-72",
				players = "20",
				prereq = "Key: Flammengeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "H\195\182llenfeuerzitadelle\nRuf: Thrallmar (Horde)\nRuf: Ehrenfeste (Allianz)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {67, 97.66} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Randy Sauseritzel", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { "1" },
						tooltiptxt = "", special = "(Allianz, Heroisch)" },
				dtl3  = { text = "Drisella", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { " " },
						tooltiptxt = "", special = "(Horde, Heroisch)" },
				dtl4  = { text = "Gro\195\159hexenmeister", colour = AM_RED, coords = { {23.63, 66.02} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCHallsNethekurse" },
				dtl5  = { text = "Blutwache Porung", colour = AM_RED, coords = { {15.23, 10.55} }, symbol = { "3" },
						tooltiptxt = "", special = "(Heroisch)", lootid = "HCHallsPorung" },
				dtl6  = { text = "Kriegshetzer O'mrogg", colour = AM_RED, coords = { {57.42, 33.79} }, symbol = { "4" },
						tooltiptxt = "", lootid = "HCHallsOmrogg" },
				dtl7  = { text = "Kriegsh\195\164uptling Kargath Messerfaust", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { "5" },
						tooltiptxt = "", lootid = "HCHallsKargath" },
				dtl8  = { text = "Henker der Zerschmetterten Hand", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Heroisch)", lootid = "HCHallsExecutioner" },
				dtl9  = { text = "Gefreiter Jacint", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Allianz, Heroisch)" },
				dtl10 = { text = "Scharfsch\195\188tze Braunbart", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Allianz, Heroisch)" },
				dtl11 = { text = "Hauptmann Alina", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Allianz, Heroisch)" },
				dtl12 = { text = "Sp\195\164her Orgarr", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Horde, Heroisch)" },
				dtl13 = { text = "Korag M\195\164hnenstolz", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Horde, Heroisch)" },
				dtl14 = { text = "Hauptmann Knochenbrecher", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Horde, Heroisch)", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }
			},

			{	name = "Magtheridons Kammer",			-- Magtheridon's Lair
				type = AM_TYP_INSTANCE,
				displayname = "HZ: Magtheridons Kammer",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagtheridonsLair",			-- MagtheridonsLair
				location = "H\195\182llenfeuerhalbinsel",
				levels = "70",
				players = "40",
				prereq = "Key: Flammengeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "H\195\182llenfeuerzitadelle\nRuf: Thrallmar (Horde)\nRuf: Ehrenfeste (Allianz)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.44, 14.26} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Magtheridon", colour = AM_PURPLE, coords = { {53.13, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCMagtheridon", leaveGap = 1 },
				dtl3  = { text = AM_TIER4_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T4SET", leaveGap = 1 }
			},

			{	name = "Die Sklavenunterk\195\188nfte",		-- The Slave Pens
				type = AM_TYP_INSTANCE,
				displayname = "EK: Die Sklavenunterk\195\188nfte",
				displayshort = "SU",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSlavePens",			-- TheSlavePens
				location = "Zangarmarschen",
				levels = "62-64",
				players = "20",
				prereq = "Key: Schl\195\188ssel des Kessels (Heroisch)",
				general = "Der Echsenkessel\nRuf: Expedition des Cenarius",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.24, 21.29} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Echsenkessel"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Mennu der Verr\195\164ter", colour = AM_RED, coords = { {48.83, 31.84} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSlaveMennu" },
				dtl3  = { text = "J\195\164ter Gr\195\188ndaum", colour = AM_RED, coords = { {48.83, 71.29} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "Nar'biss der Ketzer", colour = AM_RED, coords = { {58.2, 72.66} }, symbol = { "3" },
						tooltiptxt = "", special = "(Heroisch)" },
				dtl5  = { text = "Rokmar der Zerquetscher", colour = AM_RED, coords = { {57.81, 41.99} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSlaveRokmar" },
				dtl6  = { text = "Naturalist Biss", colour = AM_RED, coords = { {96.09, 61.13} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl7  = { text = "Quagmirran", colour = AM_RED, coords = { {80.86, 72.27} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSlaveQuagmirran" }
			},

			{	name = "Der Tiefensumpf",			-- The Underbog
				type = AM_TYP_INSTANCE,
				displayname = "EK: Der Tiefensumpf",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheUnderbog",			-- TheUnderbog
				location = "Zangarmarschen",
				levels = "63-65",
				players = "20",
				prereq = "Key: Schl\195\188ssel des Kessels (Heroisch)",
				general = "Der Echsenkessel\nRuf: Expedition des Cenarius",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {120, 346} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Echsenkessel"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Hungarfenn", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRUnderHungarfen" },
				dtl3  = { text = "Die Tiefenspore", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Ghaz'an", colour = AM_RED, coords = { {81.84, 34.18} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRUnderGhazan" },
				dtl5  = { text = "Erdbinder Rayge", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl6  = { text = "Windrufer Klaue", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "Sumpff\195\188rst Musel'ek", colour = AM_RED, coords = { {39.84, 30.27} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRUnderSwamplord" },
				dtl8  = { text = "Die Schattenmutter", colour = AM_RED, coords = { {21.09, 45.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRUnderStalker", leaveGap = 1 }
			},

			{	name = "Die Dampfkammer",			-- The Steamvault
				type = AM_TYP_INSTANCE,
				displayname = "EK: Die Dampfkammer",
				displayshort = "DK",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSteamvault",			-- The Steamvault
				location = "Zangarmarschen",
				levels = "70-72",
				players = "20",
				prereq = "Key: Schl\195\188ssel des Kessels (Heroisch)",
				general = "Der Echsenkessel\nRuf: Expedition des Cenarius",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 35.74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Echsenkessel"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Wasserbeschw\195\182rerin Thespia", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSteamThespia" },
				dtl3  = { text = "Hautpkammer Zugangskonsole", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "W\195\164chter des zweiten Teils", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSteamSecondFragmentGuardian" },
				dtl5  = { text = "Arkaner Beh\195\164lter", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = "Robogenieur Dampfhammer", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSteamSteamrigger" },
				dtl7  = { text = "Hautpkammer Zugangskonsole", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "Kriegsherr Kalithresh", colour = AM_RED, coords = { {92.19, 43.95} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSteamWarlord" },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }
			},

			{	name = "H\195\182hle des Schlangenschreins",	-- SerpentShrine Cavern
				type = AM_TYP_INSTANCE,
				displayname = "EK: H\195\182hle des Schlangenschreins",
				displayshort = "SC",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SerpentShrine",			-- SerpentshrineCavern
				location = "Zangarmarschen",
				levels = "70",
				players = "40",
				prereq = "",
				general = "Der Echsenkessel\nRuf: Expedition des Cenarius",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 67.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Der Echsenkessel"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Hydross der Unstete", colour = AM_RED, coords = { {37.89, 75} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSerpentHydross" },
				dtl3  = { text = "Das Grauen aus der Tiefe", colour = AM_RED, coords = { {40.82, 54.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSerpentLurker" },
				dtl4  = { text = "Leotheras der Blinde", colour = AM_RED, coords = { {43.75, 27.15} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSerpentLeotheras" },
				dtl5  = { text = "Tiefenlord Karathress", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSerpentKarathress" },
				dtl6  = { text = "Seher Olum", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "Morogrim Gezeitenwandler", colour = AM_RED, coords = { {66.02, 28.52} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRSerpentMorogrim" },
				dtl8  = { text = "Lady Vashj", colour = AM_RED, coords = { {81.64, 55.47} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSerpentVashj", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSerpentTrash" }
			},

			{	name = "Auchenaikrypta",			-- Auchenai Crypts
				type = AM_TYP_INSTANCE,
				displayname = "Auch: Auchenaikrypta",
				displayshort = "Krypta",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\AuchenaiCrypts",			-- AuchenaiCrypts
				location = "W\195\164lder von Terokkar",
				levels = "64-66",
				players = "20",
				prereq = "Key: Schl\195\188ssel der Auchenai (Heroisch)",
				general = "Auchindoun\nRuf: Unteres Viertel",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {22, 79.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Shirrak der Totenw\195\164chter", colour = AM_RED, coords = { {44, 70} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchCryptsShirrak" },
				dtl3  = { text = "Exarch Maladaar", colour = AM_RED, coords = { {88, 49} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchCryptsExarch" },
				dtl4  = { text = "Avatar des Gemarterten", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsAvatar" },
				dtl5  = { text = "D'ore", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsTrash" }
			},

			{	name = "Schattenlabyrinth",			-- Shadow Labyrinth
				type = AM_TYP_INSTANCE,
				displayname = "Auch: Schattenlabyrinth",
				displayshort = "SL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowLabyrinth",			-- ShadowLabyrinth
				location = "W\195\164lder von Terokkar",
				levels = "65-67",
				players = "20",
				prereq = "Key: Schl\195\188ssel des Schattenlabyrinths\nKey: Schl\195\188ssel der Auchenai (Heroisch)",
				general = "Auchindoun\nRuf: Unteres Viertel",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {6, 8.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Spion To'gun", colour = AM_RED, coords = { {14, 44} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl3  = { text = "Botschafter H\195\182llenschlund", colour = AM_RED, coords = { {14, 44} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchShadowHellmaw" },
				dtl4  = { text = "Schwarzherz der Hetzer", colour = AM_RED, coords = { {20, 73} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchShadowBlackheart" },
				dtl5  = { text = "Gro\195\159meister Vorpil", colour = AM_RED, coords = { {55, 59} }, symbol = { "4" },
						tooltiptxt = "Kodex des Blutes", lootid = "AuchShadowGrandmaster" },
				dtl6  = { text = "Murmur", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchShadowMurmur" },
				dtl7  = { text = "W\195\164chter des ersten Teils", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "6" },
						tooltiptxt = "", lootid = "AuchShadowFirstFragmentGuardian" },
				dtl8  = { text = "Arkaner Beh\195\164lter", colour = AM_RED, coords = { {90.38, 37.7} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchShadowTrash" }
			},

			{	name = "Sethekkhallen",				-- Sethekk Halls
				type = AM_TYP_INSTANCE,
				displayname = "Auch: Sethekkhallen",
				displayshort = "SH",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SethekkHalls",			-- SethekkHalls
				location = "W\195\164lder von Terokkar",
				levels = "67-69",
				players = "20",
				prereq = "Key: Schl\195\188ssel der Auchenai (Heroisch)\nKey: Mit Essenz erf\195\188llter Mondstein (Anzu)",
				general = "Auchindoun\nRuf: Unteres Viertel",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {98, 46} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Dunkelwirker Syth", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchSethekkDarkweaver" },
				dtl3  = { text = "Lakka", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Die Sage von Terokk", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchSethekkTheSagaofTerokk" },
				dtl5  = { text = "Anzu", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkRavenGod", special = "(Beschw\195\182rbar, Heroisch)" },
				dtl6  = { text = "Klauenk\195\182nig Ikiss", colour = AM_RED, coords = { {20, 18.5} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchSethekkTalonKing", leaveGap = 1 },
				dtl7 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkTrash" }
			},

			{	name = "Managruft",				-- Mana Tombs
				type = AM_TYP_INSTANCE,
				displayname = "Auch: Managruft",
				displayshort = "Gruft",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ManaTombs",				-- ManaTombs
				location = "W\195\164lder von Terokkar",
				levels = "70-72",
				players = "40",
				prereq = "Key: Schl\195\188ssel der Auchenai (Heroisch)\nKey: Das Auge des Haramad (Ehrf\195\188rchtig, Yor)",
				general = "Auchindoun\nRuf: Das Konsortium",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 4.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Auchindoun"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Pandemonius", colour = AM_RED, coords = { {46, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchManaPandemonius" },
				dtl3  = { text = "Schattenlord Xiraxis", colour = AM_RED, coords = { {46, 30} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Botschafter Pax'ivi", colour = AM_RED, coords = { {71.29, 16.41} }, symbol = { "2" },
						tooltiptxt = "", special = "(Heroisch)" },
				dtl5  = { text = "Tavarok", colour = AM_RED, coords = { {71, 76} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchManaTavarok" },
				dtl6  = { text = "Kryoingenieur Sha'heen", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl7  = { text = "Bedienungskonsole des Astraltransporters", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "Nexusprinz Shaffar", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchManaNexusPrince" },
				dtl9  = { text = "Yor", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { " " },
						tooltiptxt = "Stasiskammer", special = "(Beschw\195\182rbar, Heroisch)", lootid = "AuchManaYor", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchManaTrash" }
			},

			{	name = "Gruuls Unterschlupf",			-- Gruul's Lair
				type = AM_TYP_INSTANCE,
				displayname = "Gruuls Unterschlupf",
				displayshort = "GL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\GruulsLair",			-- GruulsLair
				location = "Schergrat",
				levels = "65-68",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "High King Maulgar", colour = AM_RED, coords = { {55, 48} }, symbol = { "1" },
						tooltiptxt = "Boss", lootid = "GruulsLairHighKingMaulgar" },
				dtl3  = { text = "Gicherer der Wahnsinnige", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(Schamane)" },
				dtl4  = { text = "Krosh Feuerhand", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(Magier)" },
				dtl5  = { text = "Blindauge der Seher", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(Priester)" },
				dtl6  = { text = "Olm der Beschw\195\182rer", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(Hexenmeister)" },
				dtl7  = { text = "Gruul", colour = AM_RED, coords = { {20, 27} }, symbol = { "2" },
						tooltiptxt = "", lootid = "GruulGruul", leaveGap = 1 },
			},

			{	name = "Schwarzer Tempel",			-- Black Temple
				type = AM_TYP_INSTANCE,
				displayname = "Der Schwarze Tempel",
				displayshort = "BT",
				continent = 3,
--				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Placeholder",
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackTemple",			-- BlackTemple
				location = "Schattenmondtal",
				levels = "67-70",
				players = "40",
				prereq = "Zugangsquest erforderlich\nKey: Medaillon von Karabor",
				general = "Ruf: Todesh\195\182rige der Aschenzungen",
				dtl1  = { text = "Der Schwarze Tempel (Anfang)", colour = AM_ORANGE, coords = { {5.27, 32.03} }, symbol = { "-" },
						tooltiptxt = "" },
				dtl2  = { text = "Der Schwarze Tempel (Spitze)", colour = AM_ORANGE, coords = { {49.61, 5.66} }, symbol = { "^" },
						tooltiptxt = "" },
				dtl3  = { text = "Der Schwarze Tempel (Keller)", colour = AM_ORANGE, coords = { {63.87, 60.74} }, symbol = { "v" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {7.62, 77.34} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
	            dtl5  = { text = "Geist von Olum", colour = AM_BLUE, coords = { {7.23, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "BTNajentus" },
	            dtl6  = { text = "Oberster Kriegsf\195\188rst Naj'entus", colour = AM_RED, coords = { {24.8, 56.25} }, symbol = { "2" },
						tooltiptxt = "", lootid = "BTNajentus" },
				dtl7  = { text = "Supremus", colour = AM_RED, coords = { {21.29, 45.12} }, symbol = { "3" },
						tooltiptxt = "", lootid = "BTSupremus" },
	            dtl8  = { text = "Akamas Schemen", colour = AM_RED, coords = { {33.59, 63.09} }, symbol = { "4" },
						tooltiptxt = "", lootid = "BTAkama" },
	            dtl9  = { text = "Geist von Udalo", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { "5" },
						tooltiptxt = "" },
	            dtl10 = { text = "Aluyen", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(Reagenzien Verk\195\164ufer)" },
	            dtl11 = { text = "Okuno", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(R\195\188stmeister der Todesh\195\182rigen)" },
	            dtl12 = { text = "Seher Kanai", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl13 = { text = "Zu Teron Blutschatten", colour = AM_GREEN, coords = { {48.83, 51.76}, {79.1, 78.32} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl14 = { text = "Zu Reliquiar der Verirrten", colour = AM_GREEN, coords = { {48.83, 37.5}, {84.18, 67.38} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl15 = { text = "Zu Illidan Sturmgrimm", colour = AM_GREEN, coords = { {23.83, 33.2}, {58.2, 10.74} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl16  = { text = "Gurtogg Siedeblut", colour = AM_RED, coords = { {75.59, 57.23} }, symbol = { "6" },
						tooltiptxt = "", lootid = "BTBloodboil" },
				dtl17 = { text = "Reliquiar der Verirrten", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { "7" },
						tooltiptxt = "", lootid = "BTEssencofSouls" },
				dtl18 = { text = "Essenz des Zorns", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "Essenz der Begierde", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "Essenz des Leidens", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "Teron Blutschatten", colour = AM_RED, coords = { {59.77, 81.45} }, symbol = { "8" },
						tooltiptxt = "", lootid = "BTGorefiend" },
				dtl22 = { text = "Mutter Shahraz", colour = AM_RED, coords = { {92.77, 4.88} }, symbol = { "9" },
						tooltiptxt = "", lootid = "BTShahraz" },
				dtl23 = { text = "Rat der Illidari", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { "10" },
						tooltiptxt = "", lootid = "BTCouncil" },
				dtl24 = { text = "Lady Malande", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(Priesterin)" },
				dtl25 = { text = "Gathios der Zerschmetterer", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(Paladin)" },
				dtl26 = { text = "Hochnethermant Zerevor", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(Magier)" },
				dtl27 = { text = "Veras Schwarzschatten", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(Schurke)" },
	            dtl28  = { text = "Illidan Sturmgrimm", colour = AM_RED, coords = { {59.18, 36.13} }, symbol = { "11" },
						tooltiptxt = "", lootid = "BTIllidanStormrage", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTPatterns" },
				dtl30 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTTrash" }
			},

			{	name = "Mechanar",				-- The Mechanar
				type = AM_TYP_INSTANCE,
				displayname = "FdS: Mechanar",
				displayshort = "Mech",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Mechanar",			-- TheMechanar
				location = "Nethersturm",
				levels = "69-72",
				players = "20",
				prereq = "Key: Warpgeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "Festung der St\195\188rme\nRuf: Die Sha'tar",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {43, 92.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Torw\195\164chter Gyrotod", colour = AM_RED, coords = { {46, 56} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKMechGyro" },
				dtl3  = { text = "Torw\195\164chter Eisenhand", colour = AM_RED, coords = { {64.5, 52} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKMechIron" },
				dtl4  = { text = "Beh\195\164lter der Legion", colour = AM_RED, coords = { {64.5, 52} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechCacheoftheLegion" },
				dtl5  = { text = "Mechanolord Kapazitus", colour = AM_RED, coords = { {58, 37} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKMechCapacitus" },
				dtl6  = { text = "\195\188berladene Manazelle", colour = AM_RED, coords = { {58, 37} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechOverchargedManacell" },
				dtl7  = { text = "Nethermantin Sepethrea", colour = AM_RED, coords = { {47, 9.9} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKMechSepethrea" },
				dtl8  = { text = "Pathaleon der Kalkulator", colour = AM_RED, coords = { {18.5, 47} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKMechCalc", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechTrash" }
			},

			{	name = "Botanica",				-- The Botanica
				type = AM_TYP_INSTANCE,
				displayname = "FdS: Botanica",
				displayshort = "Bota",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Botanica",			-- TheBotanica
				location = "Nethersturm",
				levels = "70-72",
				players = "40",
				prereq = "Key: Warpgeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "Festung der St\195\188rme\nRuf: Die Sha'tar",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {96.2, 44.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Commander Sarannis", colour = AM_RED, coords = { {45, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKBotSarannis" },
				dtl3  = { text = "High Botanist Freywinn", colour = AM_RED, coords = { {24, 30} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKBotFreywinn" },
				dtl4  = { text = "Thorngrin the Tender", colour = AM_RED, coords = { {9, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKBotThorngrin" },
				dtl5  = { text = "Laj", colour = AM_RED, coords = { {35, 69} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKBotLaj" },
				dtl6  = { text = "Warp Splinter", colour = AM_RED, coords = { {34.5, 40} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKBotSplinter", leaveGap = 1 },
				dtl7  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKBotTrash" }
			},

			{	name = "Arcatraz",				-- The Arcatraz
				type = AM_TYP_INSTANCE,
				displayname = "FdS: Arcatraz",
				displayshort = "Arca",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Arcatraz",			-- TheArcatraz
				location = "Nethersturm",
				levels = "70-72",
				players = "40",
				prereq = "Key: Schl\195\188ssel zu Arkatraz\nKey: Warpgeschmiedeter Schl\195\188ssel (Heroisch)",
				general = "Festung der St\195\188rme\nRuf: Die Sha'tar",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {38, 98} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Zereketh der Unabh\195\164ngige", colour = AM_RED, coords = { {45.5, 58.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKArcUnbound" },
				dtl3  = { text = "Zereketh der Unabh\195\164ngige", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKArcThirdFragmentGuardian" },
				dtl4  = { text = "Arkaner Beh\195\164lter", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { " " },
						tooltiptxt = "" },
				dtl5  = { text = "Zornseher Soccothrates", colour = AM_RED, coords = { {11.5, 70} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKArcScryer" },
				dtl6  = { text = "Dalliah die Verdammnisverk\195\188nderin", colour = AM_RED, coords = { {31, 70} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKArcDalliah" },
				dtl7  = { text = "Seher Udalo", colour = AM_RED, coords = { {37.89, 15.04} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl8  = { text = "Herold Horizontiss", colour = AM_RED, coords = { {73.5, 17} }, symbol = { "6" },
						tooltiptxt = "", lootid = "TKArcHarbinger" },
				dtl9  = { text = "Aufseher Mellichar", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl10 = { text = "Millhaus Manasturm", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKArcTrash" }
			},

			{	name = "Vorgebirge des Alten H\195\188gellands",	-- Old Hillsbrad
				type = AM_TYP_INSTANCE,
				displayname = "HdZ: Vorgebirge des Alten H\195\188gellands",
				displayshort = "HdZ1",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OldHilsbrad",			-- OldHilsbrad
				location = "H\195\182hlen der Zeit",
				levels = "",
				players = "",
				prereq = "Zugangsquest erforderlich\nKey: Schl\195\188ssel der Zeit (Heroisch)",
				general = "Tanaris\nEreignis: Flucht aus Burg Durnholde\nRuf: H\195\188ter der Zeit",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {13, 47} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "H\195\182hlen der Zeit"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Erozion", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl3  = { text = "Brazen", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Leutnant Drach", colour = AM_RED, coords = { {83, 64.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CoTHillsbradDrake" },
				dtl5  = { text = "Thrall", colour = AM_BLUE, coords = { {79.49, 57.23} }, symbol = { "2" },
						tooltiptxt = "(Unten)", lootid = "CoTHillsbradDrake" },
				dtl6  = { text = "Kapit\195\164n Skarloc", colour = AM_RED, coords = { {72, 68} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CoTHillsbradSkarloc" },
				dtl7  = { text = "Thralls 2. Halt", colour = AM_BLUE, coords = { {72, 68} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "Thralls 3. Halt", colour = AM_BLUE, coords = { {47.07, 41.41} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl9  = { text = "Epochenj\195\164ger", colour = AM_RED, coords = { {44.5, 30.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CoTHillsbradHunter" },
				dtl10 = { text = "Thralls 4. Halt", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(Oben)" },
				dtl11 = { text = "Taretha", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(Oben)" },
				dtl12 = { text = "Jonathan Revah", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { "6" },
						tooltiptxt = "" },
				dtl13 = { text = "Jerry Carter", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "Thomas Yance", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "7" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradThomasYance" },
				dtl15 = { text = "Gealterter Hexer von Dalaran", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "8" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradAgedDalaranWizard", leaveGap = 1 }
			},

			{	name = "Schwarzen Morast",				-- The Black Morass
				type = AM_TYP_INSTANCE,
				displayname = "HdZ: Schwarzen Morast",
				displayshort = "HdZ2",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackMorass",			-- The Black Morass
				location = "H\195\182hlen der Zeit",
				levels = "",
				players = "",
				prereq = "Zugangsquest erforderlich\nKey: Schl\195\188ssel der Zeit (Heroisch)",
				general = "Tanaris\nEreignis: \195\182ffnung des Dunklen Portals\nRuf: H\195\188ter der Zeit",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45.4, 22} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "H\195\182hlen der Zeit"..AM_EXTERIOR, special = "Sa'at", leaveGap = 1 },
				dtl2  = { text = "Spawnpunkte", colour = AM_RED, coords = { {58, 70}, {58.5, 61.5}, {41, 60.5}, {48, 52.5} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "Chronolord Deja", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(Welle 6)", lootid = "CoTMorassDeja" },
				dtl4  = { text = "Temporus", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(Welle 12)", lootid = "CoTMorassTemporus" },
				dtl5  = { text = "Aeonus", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(Welle 18)", lootid = "CoTMorassAeonus", leaveGap = 1 },
				dtl5  = { text = "Das Dunkle Portal", colour = AM_BLUE, coords = { {44.14, 74.22} }, symbol = { "1" },
						tooltiptxt = "", special = "Medivh" },
			},

			{	name = "Die Schlacht am Berg Hyjal",		-- Battle for Mount Hyjal
				type = AM_TYP_INSTANCE,
				displayname = "HdZ: Die Schlacht am Berg Hyjal",
				displayshort = "HdZ3",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MountHyjal",			-- Battle for Mount Hyjal
				location = "H\195\182hlen der Zeit",
				levels = "70",
				players = "25",
				prereq = "Zugangsquest erforderlich",
				general = "Tanaris\nEreignis: Schlacht um Berg Hyjal\nRuf: Die W\195\164chter der Sande",
				dtl1  = { text = "Basis der Allianz", colour = AM_GREEN, coords = { {18.36, 48.83} }, symbol = { "A" },
						tooltiptxt = "", toMap = "H\195\182hlen der Zeit"..AM_EXTERIOR, special = "(Lady Jaina Prachtmeer)" },
				dtl2  = { text = "Basis der Horde", colour = AM_GREEN, coords = { {57.23, 35.74} }, symbol = { "B" },
						tooltiptxt = "", special = "(Thrall)" },
				dtl3  = { text = "Basis der Nachtelfen", colour = AM_GREEN, coords = { {75.39, 44.34} }, symbol = { "C" },
						tooltiptxt = "", special = "(Tyrande Wisperwind)", leaveGap = 1 },
	            dtl4  = { text = "Furor Winterfrost", colour = AM_RED, coords = { {21.48, 46.88} }, symbol = { "1" },
						tooltiptxt = "", lootid = "MountHyjalWinterchill" },
				dtl5  = { text = "Anetheron", colour = AM_RED, coords = { {21.48, 50.98} }, symbol = { "2" },
						tooltiptxt = "", lootid = "MountHyjalAnetheron" },
				dtl6  = { text = "Kaz'rogal", colour = AM_RED, coords = { {58.98, 32.81} }, symbol = { "3" },
						tooltiptxt = "", lootid = "MountHyjalKazrogal" },
				dtl7  = { text = "Azgalor", colour = AM_RED, coords = { {58.98, 38.67} }, symbol = { "4" },
						tooltiptxt = "", lootid = "MountHyjalAzgalor" },
	            dtl8  = { text = "Archimonde", colour = AM_RED, coords = { {83.01, 31.25} }, symbol = { "5" },
						tooltiptxt = "", lootid = "MountHyjalArchimonde" },
--				dtl9 = { text = "Indormi", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "" },
--				dtl10 = { text = "Tydormu", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "" },
			},

			{	name = "Karazahn",				-- Karazahn
				type = AM_TYP_INSTANCE,
				displayname = "Karazahn",
				displayshort = "Kara",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Karazahn",				-- Karazahn
				location = "Deadwind Pass",
				levels = "70",
				players = "10",
				prereq = "Zugangsquest erforderlich\nKey: Der Schl\195\188ssel des Meisters\nKey: Geschw\195\164rzte Urne (Schrecken der Nacht)",
				general = "Ruf: Das Violette Auge",
				dtl1  = { text = "Eingang (Vorne)", colour = AM_GREEN, coords = { {29.88, 31.45} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Karazhan"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "Eingang (Hinten)", colour = AM_GREEN, coords = { {28.13, 20.31} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Karazhan"..AM_EXTERIOR, leaveGap = 1 },
				dtl3  = { text = "Hastings", colour = AM_BLUE, coords = { {27.93, 25.39} }, symbol = { "a" },
						tooltiptxt = "", special = "Der Hauswart" },
				dtl4  = { text = "Berthold", colour = AM_BLUE, coords = { {23.05, 25.98} }, symbol = { "b" },
						tooltiptxt = "", special = "Der Pf\195\182rtner" },
				dtl5  = { text = "Moroes", colour = AM_RED, coords = { {23.05, 25.98}, {65.23, 23.24} }, symbol = { "1" },
						tooltiptxt = "", special = "(Treppen zum Ballsaal)", lootid = "KaraMoroes" },
				dtl6  = { text = "Calliard", colour = AM_BLUE, coords = { {23.44, 33.4} }, symbol = { "c" },
						tooltiptxt = "", special = "Der Nachtw\195\164chter" },
				dtl7  = { text = "Attumen der J\195\164ger", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { "2" },
						tooltiptxt = "", lootid = "KaraAttumen" },
				dtl8  = { text = "Mittnacht", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9  = { text = "Koren", colour = AM_BLUE, coords = { {16.02, 30.47} }, symbol = { "d" },
						tooltiptxt = "", special = "Der Schmied" },
				dtl10 = { text = "Treppen zum Oberen Stall", colour = AM_GREEN, coords = { {18.55, 37.5} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl11 = { text = "Bennett", colour = AM_BLUE, coords = { {19.53, 35.55} }, symbol = { "e" },
						tooltiptxt = "", special = "Die Schutzwache", special = "Oben" },
				dtl12 = { text = "Schwarzhaupt", colour = AM_BLUE, coords = { {74.8, 36.52} }, symbol = { "f" },
						tooltiptxt = "", special = "Der Adlige" },
				dtl13 = { text = "", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl14 = { text = "Hyakiss der Lauerer", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(Rar, Zuf\195\164llig)", lootid = "KaraNamed" },
				dtl15 = { text = "Rokad der Verheerer", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(Rar, Zuf\195\164llig)", lootid = "KaraNamed" },
				dtl16 = { text = "Shadikith der Gleiter", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(Rar, Zuf\195\164llig)", lootid = "KaraNamed", leaveGap = 1 },
				dtl17 = { text = "Rampe zu den G\195\164stekammern", colour = AM_GREEN, coords = { {17.77, 3.32}, {73.24, 10.16} }, symbol = { "P" },
						tooltiptxt = "", },
				dtl18 = { text = "Keannas Aufzeichnungen", colour = AM_ORANGE, coords = { {82.52, 4.69} }, symbol = { "3" },
						tooltiptxt = "", lootid = "KaraKeannaLog" },
				dtl19 = { text = "Tugendhafte Maid", colour = AM_RED, coords = { {92.38, 16.21} }, symbol = { "4" },
						tooltiptxt = "", lootid = "KaraMaiden" },
				dtl20 = { text = "Treppen zur Opernhaus Orchester Ebene", colour = AM_GREEN, coords = { {84.18, 15.04} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl21 = { text = "Sebastian", colour = AM_BLUE, coords = { {55.08, 18.55} }, symbol = { "g" },
						tooltiptxt = "", special = "Der Orgelspieler" },
				dtl22 = { text = "Barnes", colour = AM_BLUE, coords = { {51.95, 10.35} }, symbol = { "h" },
						tooltiptxt = "", special = "Der Inspizient" },
				dtl23 = { text = "Opernevent", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { "O" },
						tooltiptxt = "Zuf\195\164llig", lootid = "KaraOperaEvent" },
				dtl24 = { text = "Der Zauberer von Oz", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(Zuf\195\164llig)", lootid = "KaraOperaEvent" },
				dtl25 = { text = "Rotk\195\164ppchen", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(Zuf\195\164llig)", lootid = "KaraOperaEvent" },
				dtl26 = { text = "Romeo und Julia", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(Zuf\195\164llig)", lootid = "KaraOperaEvent" },
				dtl27 = { text = "Rampe vom Zwischengeschoss zum Balkon", colour = AM_GREEN, coords = { {62.11, 8.79} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl28 = { text = "Terrasse des Meisters", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl29 = { text = "Schrecken der Nacht", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Summoned)", lootid = "KaraOperaEvent" },
				dtl30 = { text = "Weg zur Besch\195\164digten Treppe", colour = AM_GREEN, coords = { {30.66, 24.02} }, symbol = { "P" },
						tooltiptxt = "", special = "(Oben)" },
				dtl31 = { text = "Besch\195\164digte Treppe", colour = AM_GREEN, coords = { {18.36, 24.41} }, symbol = { "P" },
						tooltiptxt = "", special = "(Oben)" },
				dtl32 = { text = "Der Kurator", colour = AM_RED, coords = { {10.16, 35.16} }, symbol = { "5" },
						tooltiptxt = "", lootid = "KaraCurator" },
				dtl33 = { text = "Verbindung zu:", colour = AM_GREEN, coords = { {13.67, 44.92}, {30.47, 68.55} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl34 = { text = "Wravien", colour = AM_BLUE, coords = { {23.24, 69.73} }, symbol = { "i" },
						tooltiptxt = "", special = "Der Magier" },
				dtl35 = { text = "Gradav", colour = AM_BLUE, coords = { {17.97, 69.34} }, symbol = { "j" },
						tooltiptxt = "", special = "Der Hexenmeister" },
				dtl36 = { text = "Kamsis", colour = AM_BLUE, coords = { {16.41, 73.83} }, symbol = { "k" },
						tooltiptxt = "", special = "Die Beschw\195\182rerin" },
				dtl37 = { text = "Rampe zur Bibliothek der Besch\195\188tzer", colour = AM_GREEN, coords = { {19.92, 76.56} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl38 = { text = "Verd\195\164chtiges B\195\188cherregal", colour = AM_GREEN, coords = { {20.51, 66.6} }, symbol = { "P" },
						tooltiptxt = "(-> Passage zu Siechhuf)" },
				dtl39 = { text = "Terestian Siechhuf", colour = AM_RED, coords = { {17.19, 72.85} }, symbol = { "6" },
						tooltiptxt = "", special = "Kil'rek (Wichtel)", lootid = "KaraIllhoof" },
				dtl40 = { text = "Arans Schemen", colour = AM_RED, coords = { {33.2, 66.21} }, symbol = { "7" },
						tooltiptxt = "", lootid = "KaraAran" },
				dtl41 = { text = "Rampe nach oben zur Himmelswacht", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(Nethergroll)" },
				dtl42 = { text = "Rampe nach unten zur Halle der Spieler", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(Schachevent)" },
				dtl43 = { text = "Nethergroll", colour = AM_RED, coords = { {9.38, 65.82} }, symbol = { "8" },
						tooltiptxt = "", lootid = "KaraNetherspite" },
				dtl44 = { text = "Ythar", colour = AM_GREEN, coords = { {27.15, 66.21} }, symbol = { "l" },
						tooltiptxt =  "", special ="(Reparieren und Belohnungen)" },
				dtl45 = { text = "Verbindung zu:", colour = AM_GREEN, coords = { {26.76, 63.48}, {62.5, 39.84} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl46 = { text = "Echo Medivhs", colour = AM_BLUE, coords = { {65.04, 37.5} }, symbol = { "k" },
						tooltiptxt = "" },
				dtl47 = { text = "Schachevent", colour = AM_RED, coords = { {67.58, 34.96} }, symbol = { "9" },
						tooltiptxt = "", lootid = "KaraChess" },
				dtl48 = { text = "Rampe zu Medivhs Kammer", colour = AM_GREEN, coords = { {63.09, 29.88} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl49 = { text = "Wendeltreppe zum Netherraum", colour = AM_GREEN, coords = { {81.64, 32.62} }, symbol = { "P" },
						tooltiptxt = "", special = "(Prinz)" },
				dtl50 = { text = "Prinz Malchezaar", colour = AM_RED, coords = { {76.37, 31.05} }, symbol = { "10" },
						tooltiptxt = "Defeat to allow summoning of Nightbane", special = "Leads to...", lootid = "KaraPrince" },
			},

			{	name = "Zul'Aman",				-- Zul'Aman
				type = AM_TYP_INSTANCE,
				displayname = "Zul'Aman",
				displayshort = "ZA",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulAman",				-- Zul'Aman
				location = "Geisterlande",
				levels = "70",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 53} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Nalorakk", colour = AM_RED, coords = { {36.3, 71.9} }, symbol = { "1" },
						tooltiptxt = "", special = "(B\195\164r)", lootid = "ZANalorakk" },
				dtl3  = { text = "Akil'zon", colour = AM_RED, coords = { {31.25, 31.25} }, symbol = { "2" },
						tooltiptxt = "", special = "(Adler)", lootid = "ZAAkilZon" },
				dtl4  = { text = "Jan'alai", colour = AM_RED, coords = { {53.3, 67.2} }, symbol = { "3" },
						tooltiptxt = "", special = "(Drachenfalke)", lootid = "ZAJanAlai" },
				dtl5  = { text = "Halazzi", colour = AM_RED, coords = { {56.05, 36.62} }, symbol = { "4" },
						tooltiptxt = "", special = "(Luchs)", lootid = "ZAHalazzi" },
				dtl6  = { text = "Hexlord Malacrass", colour = AM_RED, coords = { {68.75, 54.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "ZAMalacrass" },
				dtl7  = { text = "Zul'jin", colour = AM_RED, coords = { {91.4, 54.7} }, symbol = { "6" },
						tooltiptxt = "", lootid = "ZAZuljin", leaveGap = 1 },
			},
--71
			{	name = "Festung der St\195\188rme",				-- The Eye
				type = AM_TYP_INSTANCE,
				displayname = "FdS: Festung der St\195\188rme",
				displayshort = "FdS",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheEye",			-- TheEye
				location = "Nethersturm",
				levels = "70",
				players = "40",
				prereq = "Key: Schl\195\188ssel der St\195\188rme",
				general = "Ruf: Die Sha'tar",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Al'ar", colour = AM_RED, coords = { {50, 57} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKEyeAlar" },
				dtl3  = { text = "Leerh\195\164scher", colour = AM_RED, coords = { {14, 47} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKEyeVoidReaver" },
				dtl4  = { text = "Hochastronom Solarian", colour = AM_RED, coords = { {86, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKEyeSolarian" },
				dtl5  = { text = "Kael'thas Sonnenwanderer", colour = AM_RED, coords = { {50, 13} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKEyeKaelthas" },
				dtl6  = { text = "Thaladred der Verfinsterer", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(Krieger)" },
				dtl7  = { text = "Meisteringenieur Telonicus", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(J\195\164ger)" },
				dtl8  = { text = "Gro\195\159astronom Capernian", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", speical = "(Magier)" },
				dtl9  = { text = "F\195\188rst Blutdurst", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(Paladin)", leaveGap = 1 },
				dtl10 = { text = "Legendary", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeLegendaries" },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeTrash" },
			},

			{	name = "Terrasse der Magister",				-- Magister's Terrace
				type = AM_TYP_INSTANCE,
				displayname = "Terrasse der Magister",
				displayshort = "MagT",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagistersTerrace",			-- Magister's Terrace
				location = "Insel von Quel'Danas",
				levels = "69-72",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {42.19, 78.32} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Selin Feuerherz", colour = AM_RED, coords = { {42.19, 26.17} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SMTFireheart" },
--			dtl3  = { text = "Fel Crystals", colour = AM_ORANGE, coords = { {43.36, 37.5}, {43.36, 50.2}, {42.19, 29.88}, {50.39, 50.2}, {50.39, 37.5} }, symbol = { "C" },
				dtl3  = { text = "Teufelskristalle", colour = AM_ORANGE, coords = { {42.19, 26.17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Tyrith", colour = AM_GREEN, coords = { {59.96, 29.88} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "Vexallus", colour = AM_RED, coords = { {83.4, 31.84} }, symbol = { "3" },
						tooltiptxt = "", lootid = "SMTVexallus" },
				dtl6  = { text = "Seherkugel", colour = AM_GREEN, coords = { {94.53, 31.64} }, symbol = { "4" },
						tooltiptxt = "", special = "(Kalecgos)" },
				dtl7  = { text = "Priesterin Delrissa", colour = AM_RED, coords = { {38.67, 52.54} }, symbol = { "5" },
						tooltiptxt = "", special = "(Unter)", lootid = "SMTDelrissa" },
				dtl8  = { text = "Kael'Thas Sonnenwanderer", colour = AM_RED, coords = { {6.05, 48.24} }, symbol = { "6" },
						tooltiptxt = "", lootid = "SMTKaelthas", leaveGap = 1 },
				dtl9 = { text = "Exit", colour = AM_BLUE, coords = { {2.73, 47.85} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", special = "(Orb)", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SMTTrash" },
			},

			{	name = "Sonnenbrunnenplateau",				-- Sunwell Plateau
				type = AM_TYP_INSTANCE,
				displayname = "Sonnenbrunnenplateau",
				displayshort = "SunP",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SunwellPlateau",			-- Sunwell Plateau
				location = "Insel von Quel'Danas",
				levels = "69-72",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {31.45, 17.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "Kalecgos", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SPKalecgos" },
				dtl3  = { text = "Sathrovarr der Verderber", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "Madrigosa", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "Brutallus", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPBrutallus" },
				dtl6  = { text = "Teufelsruch", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPFelmyst" },
				dtl7  = { text = "", colour = AM_GREEN, coords = { {74.41, 33.2} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "Eredar Zwillinge", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { "4" },
						tooltiptxt = "", special = "(Lower)", lootid = "SPEredarTwins" },
				dtl9  = { text = "Gro\195\159hexenmeister Alythess", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(Lower)" },
				dtl10 = { text = "Lady Sacrolash", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(Lower)" },
				dtl11 = { text = "M'uru", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { "5" },
						tooltiptxt = "", special = "(Upper)" },
				dtl12 = { text = "Entropius", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { " " },
						tooltiptxt = "", special = "(Upper)" },
				dtl13 = { text = "Kil'jaeden", colour = AM_GREEN, coords = { {61.71, 32.62} }, symbol = { "6" },
						tooltiptxt = "", leaveGap = 1, lootid = "SPKiljaeden" },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SPTrash" },
			},

		};

end