
--[[
--AlphaMap Simplified Chinese
--Locolized by springsnow (2006/7/14)(3区-吉安娜-浮云)
--Last Updated:2006/9/23
--之所以汉化此插件其实是因为自己一直在用，以前用的旧版本的有人汉化，大约已经有一年没有更新国汉化了，
--为了自己使用方便，于是就尝试自己汉化了，由于本人基本没进过战场，所以战场部分可能汉化不太完整，
--希望大家能够给予帮助。
--]]


if( GetLocale() == "zhCN" ) then

	AM_TYP_INSTANCE 	= "副本";

	AM_ALPHAMAP_INSTANCES_LIST = {

			{	name = "黑暗深渊",			-- Blackfathom Deeps
				type = AM_TYP_INSTANCE,
				displayname = "黑暗深渊",
				displayshort = "BFD",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackfathomDeeps",
				location = "灰谷 (14, 14)",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "有一些水下部分",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {33, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑暗深渊"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {50, 68} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "加摩拉", colour = AM_RED, coords = { {23.5, 42} }, symbol = { "1" },
						tooltiptxt = "Lvl25 精英野兽 (巨型海龟)", lootid = "BFDGhamoora" },
				dtl4  = { text = "潮湿的便笺", colour = AM_ORANGE, coords = { {23.5, 30} }, symbol = { "2" },
						tooltiptxt = "箱子中,'深渊中的知识',\n的任务物品" },
				dtl5  = { text = "萨利维丝", colour = AM_RED, coords = { {3, 29} }, symbol = { "3" },
						tooltiptxt = "Lvl25 精英人形生物", lootid = "BFDLadySarevess" },
				dtl6  = { text = "银月守卫塞尔瑞德", colour = AM_BLUE, coords = { {11, 51} }, symbol = { "4" },
						tooltiptxt = "'寻找塞尔瑞德'的任务目标,\n& 任务'黑暗深渊中的邪恶'起始" },
				dtl7  = { text = "格里哈斯特", colour = AM_RED, coords = { {43, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl25 精英人形生物 (鱼人)", lootid = "BFDGelihast" },
				dtl8  = { text = "洛古斯·杰特", colour = AM_RED, coords = { {49, 43}, {55, 46} }, symbol = { "6" },
						tooltiptxt = "Lvl26 精英人形生物", special = AM_VARIES },
				dtl9  = { text = "阿奎尼斯男爵", colour = AM_RED, coords = { {52, 76} }, symbol = { "7" },
						tooltiptxt = "Lvl28 精英人形生物", lootid = "BFDBaronAquanis" },
				dtl10 = { text = "深渊之核", colour = AM_BLUE, coords = { {52, 76} }, symbol = { " " },
						tooltiptxt = "" },
				dtl11 = { text = "梦游者克尔里斯", colour = AM_RED, coords = { {63, 81} }, symbol = { "8" },
						tooltiptxt = "Lvl27 精英人形生物", lootid = "BFDTwilightLordKelris" },
				dtl12 = { text = "黑暗深渊祭坛", colour = AM_BLUE, coords = { {63, 81} }, symbol = { " " },
						tooltiptxt = "" },
				dtl13 = { text = "瑟拉吉斯", colour = AM_RED, coords = { {63, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl26 精英野兽", lootid = "BFDOldSerrakis" },
				dtl14 = { text = "阿库迈尔", colour = AM_RED, coords = { {95, 85} }, symbol = { "10" },
						tooltiptxt = "Lvl29 精英野兽 (九头蛇)", lootid = "BFDAkumai", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BFDTrash", leaveGap = 1 }
			},

			{	name = "黑石深渊",			-- Blackrock Depths
				type = AM_TYP_INSTANCE,
				displayname = "黑石深渊",
				displayshort = "BRD",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackrockDepths",
				location = "黑石山",
				levels = "52-60",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {21, 83} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "洛考尔", colour = AM_RED, coords = { {33, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl51 精英元素生物", lootid = "BRDLordRoccor" },
				dtl3  = { text = "审讯官格斯塔恩", colour = AM_RED, coords = { {38, 95} }, symbol = { "2" },
						tooltiptxt = "Lvl52 精英人形生物", lootid = "BRDHighInterrogatorGerstahn" },
				dtl4  = { text = "温德索尔元帅", colour = AM_BLUE, coords = { {46, 95} }, symbol = { "3" },
						tooltiptxt = "奥妮克希亚任务链中的一个环节" },
				dtl5  = { text = "指挥官哥沙克", colour = AM_BLUE, coords = { {40, 90} }, symbol = { "4" },
						tooltiptxt = "任务'指挥官哥沙克'" },
				dtl6  = { text = "卡兰·巨锤", colour = AM_BLUE, coords = { {44, 86} }, symbol = { "5" },
						tooltiptxt = "任务'卡兰·巨锤'" },
				dtl7  = { text = "法律之环", colour = AM_GREEN, coords = { {42, 73.4} }, symbol = { "6" },
						tooltiptxt = "击败这里的怪物以转换\n上层的观众从\n红色敌对状态到黄色中立状态", lootid = "BRDArena" },
				dtl8  = { text = "塞尔德林", colour = AM_RED, coords = { {42, 73.4} }, symbol = { " " },
						tooltiptxt = "NPC小组队长" , lootid = "BRDArena" },
				dtl9  = { text = "弗兰克罗恩·铸铁的雕像", colour = AM_BLUE, coords = { {45.8, 78.1} }, symbol = { "7" },
						tooltiptxt = "任务'黑铁的遗产'" },
				dtl10 = { text = "控火师罗格雷恩", colour = AM_RED, coords = { {48, 78} }, symbol = { "8" },
						tooltiptxt = "Lvl52 精英人形生物", special = AM_RARE, lootid = "BRDPyromantLoregrain" },
				dtl11 = { text = "黑色宝库", colour = AM_GREEN, coords = { {54, 54} }, symbol = { "9" },
						tooltiptxt = "" },
				dtl12  = { text = "弗诺斯·达克维尔", colour = AM_RED, coords = { {55, 41} }, symbol = { "10" },
						tooltiptxt = "Lvl54 精英人形生物", lootid = "BRDFineousDarkvire" },
				dtl13 = { text = "典狱官斯迪尔基斯", colour = AM_RED, coords = { {48, 55} }, symbol = { "11" },
						tooltiptxt = "Lvl56 精英人形生物", lootid = "BRDWarderStilgiss" },
				dtl14 = { text = "维雷克", colour = AM_RED, coords = { {54, 54} }, symbol = { " " },
						tooltiptxt = "Lvl55 精英" },
				dtl15 = { text = "伊森迪奥斯", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { "12" },
						tooltiptxt = "任务'伊森迪奥斯!'", lootid = "BRDLordIncendius" },
				dtl16 = { text = "黑铁砧", colour = AM_RED, coords = { {48.7, 48.1} }, symbol = { " " },
						tooltiptxt = "" },
				dtl17 = { text = "暗炉之锁", colour = AM_GREEN, coords = { {31, 72.4} }, symbol = { "13" },
						tooltiptxt = "开启以打开下层到上层区域的通道\n需要暗炉钥匙" },
				dtl18 = { text = "贝尔加", colour = AM_RED, coords = { {8, 62} }, symbol = { "14" },
						tooltiptxt = "Lvl57 精英山岭巨人", lootid = "BRDBaelGar" },
				dtl19 = { text = "安格弗将军", colour = AM_RED, coords = { {24, 64} }, symbol = { "15" },
						tooltiptxt = "Lvl57 精英侏儒", lootid = "BRDGeneralAngerforge" },
				dtl20 = { text = "傀儡统帅阿格曼奇", colour = AM_RED, coords = { {24, 51} }, symbol = { "16" },
						tooltiptxt = "Lvl58 精英侏儒", lootid = "BRDGolemLordArgelmach" },
				dtl21 = { text = "黑铁酒吧", colour = AM_GREEN, coords = { {40, 50} }, symbol = { "17" },
						tooltiptxt = "买6个黑铁酒杯\n然后给他们干杯 ;P", lootid = "BRDGuzzler" },
				dtl22 = { text = "弗莱拉斯大使", colour = AM_RED, coords = { {46, 38} }, symbol = { "18" },
						tooltiptxt = "Lvl57 精英人形生物", lootid = "BRDFlamelash" },
				dtl23 = { text = "无敌的潘佐尔", colour = AM_RED, coords = { {40, 27} }, symbol = { "19" },
						tooltiptxt = "Lvl57 精英机器", special = AM_RARE, lootid = "BRDPanzor" },
				dtl24 = { text = "召唤者之墓", colour = AM_GREEN, coords = { {46, 18} }, symbol = { "20" },
						tooltiptxt = "逐一击败7个首领以到达更深处\n& 获得箱子", lootid = "BRDTomb" },
				dtl25 = { text = "讲学厅", colour = AM_GREEN, coords = { {61, 8.5} }, symbol = { "21" },
						tooltiptxt = "找到并击败2个暗炉持火者\n然后点亮两个火炬以继续.\n从杀死第一个起只有3分钟时间." },
				dtl26 = { text = "玛格姆斯", colour = AM_RED, coords = { {78, 8.5} }, symbol = { "22" },
						tooltiptxt = "Lvl57 精英山岭巨人", lootid = "BRDMagmus" },
				dtl27 = { text = "铁炉堡公主茉艾拉·铜须", colour = AM_RED, coords = { {90, 8} }, symbol = { "23" },
						tooltiptxt = "Lvl58 精英人形生物", lootid = "BRDPrincess" },
				dtl28 = { text = "达格兰·索瑞森大帝", colour = AM_RED, coords = { {93, 8.5} }, symbol = { "24" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "BRDImperatorDagranThaurissan" },
				dtl29 = { text = "黑熔炉", colour = AM_GREEN, coords = { {63, 22} }, symbol = { "23" },
						tooltiptxt = "熔炼黑铁,\n及制造浓烟山脉之心" },
				dtl30 = { text = "熔火之心", colour = AM_ORANGE, coords = { {65, 30} }, symbol = { "24" },
						tooltiptxt = "任务'熔火之心的传送门'\n熔火之心入口", toMap = "熔火之心", leaveGap = 1 }
			},

			{	name = "黑石塔",		-- Blackrock Spire
				type = AM_TYP_INSTANCE,
				displayname = "黑石塔 (下层)",
				displayshort = "LBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\LBRS",			-- LBRS
				location = "黑石山",
				levels = "53-60",
				players = "15",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 10} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR },
				dtl2  = { text = "黑石塔 (上层)", colour = AM_BLUE, coords = { {22, 4} }, symbol = { "U" },
						tooltiptxt = "", toMap = "黑石塔 (上层)" },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {45.2, 29}, {73, 46} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "通往欧莫克大王的桥", colour = AM_GREEN, coords = { {38, 32.1}, {15, 32.1} }, symbol = { "B" },
						tooltiptxt = "" },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {71, 22}, {94, 26} }, symbol = { "x2" },
						tooltiptxt = "下层" },
				dtl6  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {29, 53}, {29, 77} }, symbol = { "x3" },
						tooltiptxt = "" },
				dtl7  = { text = "斜坡", colour = AM_BLUE, coords = { {86, 40}, {89, 58} }, symbol = { "R" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "维埃兰", colour = AM_RED, coords = { {31, 17} }, symbol = { "1" },
						tooltiptxt = "Lvl55 精英\n晋升印章任务"  },
				dtl9  = { text = "瓦罗什", colour = AM_RED, coords = { {53, 14} }, symbol = { "2" },
						tooltiptxt = "Lvl60 精英人形生物"  },
				dtl10 = { text = "尖锐长矛", colour = AM_ORANGE, coords = { {69, 29} }, symbol = { "3" },
						tooltiptxt = "任务物品"  },
				dtl11 = { text = "比修", colour = AM_BLUE, coords = { {62, 25 } }, symbol = { "4" },
						tooltiptxt = "比修任务链\n不在下层" },
				dtl12 = { text = "尖石屠夫", colour = AM_RED, coords = { {42, 32.1} }, symbol = { "5" },
						tooltiptxt = "Lvl59 精英人形生物\n在通往欧莫克大王的桥上巡逻", lootid = "LBRSSpirestoneButcher", special = AM_RARE  },
				dtl13 = { text = "欧莫克大王", colour = AM_RED, coords = { {2, 32.1} }, symbol = { "6" },
						tooltiptxt = "Lvl?? 精英人形生物", lootid = "LBRSOmokk"  },
				dtl14 = { text = "尖石统帅", colour = AM_RED, coords = { {2, 32.1} }, symbol = { " " },
						tooltiptxt = "出现在欧莫克大王附近的小山", lootid = "LBRSSpirestoneLord", special = AM_RARE },
				dtl15 = { text = "暗影猎手沃什加斯", colour = AM_RED, coords = { {77, 64} }, symbol = { "7" },
						tooltiptxt = "Lvl?? 精英人形生物", lootid = "LBRSVosh"  },
				dtl16 = { text = "第五块摩沙鲁石板", colour = AM_ORANGE, coords = { {77, 68} }, symbol = { "8" },
						tooltiptxt = "任务物品"  },
				dtl17 = { text = "班诺克·巨斧", colour = AM_RED, coords = { {41.5, 26.5} }, symbol = { "9" },
						tooltiptxt = "Lvl59 精英人形生物\n在下层", lootid = "LBRSGrimaxe", special = AM_RARE },
				dtl18 = { text = "指挥官沃恩", colour = AM_RED, coords = { {73, 32} }, symbol = { "10" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "LBRSVoone" },
				dtl19 = { text = "第六块摩沙鲁石板", colour = AM_ORANGE, coords = { {75, 29} }, symbol = { "11" },
						tooltiptxt = "任务物品"  },
				dtl20 = { text = "莫尔·灰蹄", colour = AM_RED, coords = { {75, 35} }, symbol = { "12" },
						tooltiptxt = "Lvl60 精英\n需要召唤火盆\n打断他们的治疗", lootid = "LBRSGrayhoof" },
				dtl21 = { text = "烟网蛛后", colour = AM_RED, coords = { {54, 58} }, symbol = { "13" },
						tooltiptxt = "Lvl59 精英野兽", lootid = "LBRSSmolderweb"  },
				dtl22 = { text = "水晶之牙", colour = AM_RED, coords = { {36, 49} }, symbol = { "14" },
						tooltiptxt = "Lvl60 精英野兽", special = AM_RARE, lootid = "LBRSCrystalFang"  },
				dtl23 = { text = "乌洛克", colour = AM_RED, coords = { {30, 30} }, symbol = { "15" },
						tooltiptxt = "Lvl60 精英人形生物", lootid = "LBRSDoomhowl"  },
				dtl24 = { text = "军需官兹格雷斯", colour = AM_RED, coords = { {50, 89} }, symbol = { "16" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "LBRSZigris"  },
				dtl25 = { text = "哈雷肯", colour = AM_RED, coords = { {19, 92} }, symbol = { "17" },
						tooltiptxt = "Lvl59 精英野兽\n杀死以触发基兹鲁尔出现", lootid = "LBRSHalycon"  },
				dtl26 = { text = "奴役者基兹鲁尔", colour = AM_RED, coords = { {19, 92} }, symbol = { " " },
						tooltiptxt = "Lvl60 精英野兽\n哈雷肯死亡后触发其出现", lootid = "LBRSSlavener"  },
				dtl27 = { text = "维姆萨拉克", colour = AM_RED, coords = { {42, 62} }, symbol = { "18" },
						tooltiptxt = "Lvl?? 精英龙类", lootid = "LBRSWyrmthalak", leaveGap = 1  },
				dtl28 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "LBRSTrash", leaveGap = 1 }
			},

			{	name = "黑石塔 (上层)",
				type = AM_TYP_INSTANCE,
				displayname = "黑石塔 (上层)",
				displayshort = "UBRS",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\UBRS",			-- UBRS
				location = "黑石山",
				levels = "53-60",
				players = "15",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 80.7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石山"..AM_EXTERIOR },
				dtl2  = { text = "黑石塔 (下层)", colour = AM_BLUE, coords = { {18.2, 86.6} }, symbol = { "L" },
						tooltiptxt = "", toMap = "黑石塔", leaveGap = 1 },
				dtl3  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {11.9, 58.4}, {8.65, 25} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl4  = { text = "烈焰卫士艾博希尔", colour = AM_RED, coords = { {8.2, 31.0} }, symbol = { "1" },
						tooltiptxt = "Lvl?? 精英元素生物", lootid = "UBRSEmberseer", leaveGap = 1  },
				dtl5  = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {8.6, 38.9}, {36.4, 61.2} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl6  = { text = "末日扣环", colour = AM_ORANGE, coords = { {41.3, 68.65} }, symbol = { "2" },
						tooltiptxt = "任务物品\n在坍塌的柱子中间的巨大箱子里\n难以辨认\n可以从达基萨斯将军处下来"  },
				dtl7  = { text = "烈焰之父", colour = AM_ORANGE, coords = { {50, 65.45} }, symbol = { "3" },
						tooltiptxt = "战斗触发于门口附近\n阻止群居孵化者孵化蛋", lootid = "UBRSFLAME"  },
				dtl8  = { text = "索拉卡·火冠", colour = AM_RED, coords = { {50, 65.45} }, symbol = { " " },
						tooltiptxt = "Lvl60 精英龙类\n拾取烈焰之父后出现", lootid = "UBRSSolakar" },
				dtl9  = { text = "杰德", colour = AM_RED, coords = { {47, 52.6} }, symbol = { "4" },
						tooltiptxt = "Lvl59 精英人形生物", special = AM_RARE, lootid = "UBRSRunewatcher"  },
				dtl10 = { text = "古拉鲁克", colour = AM_RED, coords = { {34, 52.6} }, symbol = { "5" },
						tooltiptxt = "Lvl61 精英人形生物", lootid = "UBRSAnvilcrack"  },
				dtl11 = { text = "大酋长雷德·黑手", colour = AM_RED, coords = { {67.5, 51} }, symbol = { "6" },
						tooltiptxt = "首领 \n限制性任务'为部落而战!'\n出现时乘坐盖斯", lootid = "UBRSRend"  },
				dtl12 = { text = "盖斯", colour = AM_RED, coords = { {67.5, 51} }, symbol = { " " },
						tooltiptxt = "Lvl?? 精英龙类", lootid = "UBRSGyth" },
				dtl13 = { text = "奥比", colour = AM_BLUE, coords = { {68.1, 65.9} }, symbol = { "7" },
						tooltiptxt = "限制性任务'监护者'"  },
				dtl14 = { text = "比斯巨兽", colour = AM_RED, coords = { {95.7, 60.8} }, symbol = { "8" },
						tooltiptxt = "Lvl?? 精英野兽", lootid = "UBRSBeast"  },
				dtl15 = { text = "瓦塔拉克公爵", colour = AM_RED, coords = { {95.7, 56.5} }, symbol = { "9" },
						tooltiptxt = "Lvl?? 精英\n需要任务召唤\n请首先清理黑手大厅", lootid = "UBRSValthalak" },
				dtl16 = { text = "达基萨斯将军", colour = AM_RED, coords = { {41.6, 73.2} }, symbol = { "10" },
						tooltiptxt = "Lvl?? 精英龙类", lootid = "UBRSDrakkisath"  },
				dtl17 = { text = "黑翼之巢", colour = AM_BLUE, coords = { {78.5, 27.6} }, symbol = { "BWL" },
						tooltiptxt = "", toMap = "黑翼之巢", leaveGap = 1 },
				dtl18 = { text = AM_TIER0_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T0SET", leaveGap = 1 },
				dtl19 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UBRSTrash", leaveGap = 1 }
			},

			{	name = "黑翼之巢",		-- Blackwing Lair
				type = AM_TYP_INSTANCE,
				displayname = "黑翼之巢",
				displayshort = "BWL",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackwingLair",
				location = "黑石山",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {65, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石塔 (上层)", leaveGap = 1 },
				dtl2 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {32.8, 78}, {61, 48} }, symbol = { "x1" },
						tooltiptxt = "" },
				dtl3 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {40, 96}, {68, 65} }, symbol = { "x2" },
						tooltiptxt = "" },
				dtl4 = { text = AM_LEADSTO, colour = AM_GREEN, coords = { {47, 51}, {17, 52} }, symbol = { "x3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "狂野的拉格佐尔", colour = AM_RED, coords = { {51, 66} }, symbol = { "1" },
						tooltiptxt = "首领", lootid = "BWLRazorgore"  },
				dtl6  = { text = "堕落的瓦拉斯塔兹", colour = AM_RED, coords = { {32.5, 67} }, symbol = { "2" },
						tooltiptxt = "首领", lootid = "BWLVaelastrasz"  },
				dtl7  = { text = "勒什雷尔", colour = AM_RED, coords = { {77, 42} }, symbol = { "3" },
						tooltiptxt = "首领", lootid = "BWLLashlayer"  },
				dtl8  = { text = "费尔默", colour = AM_RED, coords = { {12, 44} }, symbol = { "4" },
						tooltiptxt = "首领", lootid = "BWLFiremaw"  },
				dtl9  = { text = "埃博诺克", colour = AM_RED, coords = { {10, 29} }, symbol = { "5" },
						tooltiptxt = "首领", lootid = "BWLEbonroc"  },
				dtl10 = { text = "弗莱格尔", colour = AM_RED, coords = { {18, 29} }, symbol = { "6" },
						tooltiptxt = "首领", lootid = "BWLFlamegor"  },
				dtl11 = { text = "克洛玛古斯", colour = AM_RED, coords = { {33, 40} }, symbol = { "7" },
						tooltiptxt = "首领", lootid = "BWLChromaggus"  },
				dtl12 = { text = "奈法利安", colour = AM_RED, coords = { {60, 14} }, symbol = { "8" },
						tooltiptxt = "首领", lootid = "BWLNefarian", leaveGap = 1 },
				dtl13 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BWLTrashMobs", leaveGap = 1 },
				dtl14 = { text = AM_TIER2_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T2SET", leaveGap = 1 }
			},

			{	name = "厄运之槌",		-- Dire Maul
				type = AM_TYP_INSTANCE,
				displayname = "厄运之槌 - 概貌",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DireMaul",
				location = "菲拉斯 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "厄运之槌东", colour = AM_GREEN, coords = { {53, 81}, {57, 96}, {100, 80} }, symbol = { "E" },
						tooltiptxt = "点击打开厄运之槌东地图", toMap = "厄运之槌 (东)" },
				dtl2  = { text = "厄运之槌北", colour = AM_GREEN, coords = { {67.5, 38} }, symbol = { "N" },
						tooltiptxt = "点击打开厄运之槌北地图", toMap = "厄运之槌 (北)" },
				dtl3  = { text = "厄运之槌西", colour = AM_GREEN, coords = { {47, 88} }, symbol = { "W" },
						tooltiptxt = "点击打开厄运之槌西地图", toMap = "厄运之槌 (西)", leaveGap = 1 },
				dtl4  = { text = "图书馆", colour = AM_BLUE, coords = { {24, 58}, {41, 41} }, symbol = { "L" },
						tooltiptxt = "从北或西厄运之槌到达", leaveGap = 1 }
			},


			{	name = "厄运之槌 (东)",		-- Dire Maul East
				type = AM_TYP_INSTANCE,
				displayname = "厄运之槌 (东)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMEast",		--DMEast
				location = "厄运之槌 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = "入口 : 被毁坏的庭院", colour = AM_GREEN, coords = { {6, 58}  }, symbol = { "X1" },
						tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
				dtl2  = { text = "入口 : 艾德雷斯区", colour = AM_GREEN, coords = { {12, 92} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
				dtl3  = { text = "入口 : 拉瑞斯小亭", colour = AM_GREEN, coords = { {98, 64} }, symbol = { "X3" },
						tooltiptxt = "" },
				dtl4  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {8, 40} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "掉下到达被毁坏的庭院\n旁的房间" },
				dtl5  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {41, 85}, {61, 93} }, symbol = { "L1" },
						tooltiptxt = "" },
				dtl6  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {75, 92}, {55, 82} }, symbol = { "L2" },
						tooltiptxt = "" },
				dtl7  = { text = AM_LEADSTO, colour = AM_BLUE, coords = { {67, 63}, {83, 73} }, symbol = { "L3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "开始追捕普希林", colour = AM_GREEN, coords = { {10, 50} }, symbol = { "P" },
						tooltiptxt = "追捕以获得厄运之槌(月牙)钥匙", lootid = "DMEPusillin"  },
				dtl9  = { text = "结束追捕普希林", colour = AM_RED, coords = { {79, 61} }, symbol = { "P" },
						tooltiptxt = "Oooh, you little Imp!", lootid = "DMEPusillin"  },
				dtl10 = { text = "瑟雷姆·刺蹄", colour = AM_RED, coords = { {83, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl57 精英恶魔", lootid = "DMEZevrimThornhoof"  },
				dtl11 = { text = "海多斯博恩", colour = AM_RED, coords = { {64, 77} }, symbol = { "2" },
						tooltiptxt = "Lvl57 精英元素生物", lootid = "DMEHydro"  },
				dtl12 = { text = "雷瑟塔帝丝", colour = AM_RED, coords = { {46, 66} }, symbol = { "3" },
						tooltiptxt = "Lvl57 精英人形生物", lootid = "DMELethtendris"  },
				dtl13 = { text = "埃隆巴克", colour = AM_RED, coords = { {21, 69} }, symbol = { "4" },
						tooltiptxt = "开门"  },
				dtl14 = { text = "奥兹恩", colour = AM_RED, coords = { {42, 23} }, symbol = { "5" },
						tooltiptxt = "Lvl58 精英恶魔", lootid = "DMEAlzzin"  },
				dtl15 = { text = "伊萨莉恩", colour = AM_RED, coords = { {42, 23} }, symbol = { " " },
						tooltiptxt = "需要召唤火盆召唤\n从黑石山的伯德雷处获取任务", lootid = "DMEIsalien", leaveGap = 2 },
				dtl16 = { text = "书籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMETrash", leaveGap = 1 }
			},

			{	name = "厄运之槌 (北)",		-- Dire Maul North
				type = AM_TYP_INSTANCE,
				displayname = "厄运之槌 (北)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMNorth",		-- DMNorth
				location = "厄运之槌 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "需要从厄运之槌东追捕追捕普希林任务的月牙钥匙",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {74, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
				dtl2  = { text = "厄运之槌(西)", colour = AM_GREEN, coords = { {9, 98} }, symbol = { "W" },
						tooltiptxt = "", toMap = "厄运之槌 (西)" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {49.2, 59.4} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "卫兵摩尔达", colour = AM_RED, coords = { {76.4, 55.5} }, symbol = { "1" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "DMNGuardMoldar"  },
				dtl5  = { text = "践踏者克雷格", colour = AM_RED, coords = { {67, 49} }, symbol = { "2" },
						tooltiptxt = "Lvl57 精英恶魔", lootid = "DMNStomperKreeg"  },
				dtl6  = { text = "卫兵芬古斯", colour = AM_RED, coords = { {49.2, 56.1} }, symbol = { "3" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "DMNGuardFengus"  },
				dtl7  = { text = "卫兵斯里基克", colour = AM_RED, coords = { {17, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl59 精英人形生物", lootid = "DMNGuardSlipkik"  },
				dtl8  = { text = "诺特·希姆加可", colour = AM_RED, coords = { {19, 37} }, symbol = { "5" },
						tooltiptxt = "", lootid = "DMNThimblejack"  },
				dtl9  = { text = "克罗卡斯", colour = AM_RED, coords = { {24.6, 34.8} }, symbol = { "6" },
						tooltiptxt = "", lootid = "DMNCaptainKromcrush"  },
				dtl10 = { text = "戈多克大王", colour = AM_RED, coords = { {24.2, 11.2} }, symbol = { "7" },
						tooltiptxt = "", lootid = "DMNKingGordok"  },
				dtl11 = { text = "图书馆", colour = AM_BLUE, coords = { {20, 89} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 2  },
				dtl12 = { text = "贡品", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "DMNTRIBUTERUN" },
				dtl13 = { text = "书籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 }
			},

			{	name = "厄运之槌 (西)",		-- Dire Maul West
				type = AM_TYP_INSTANCE,
				displayname = "厄运之槌 (西)",
				displayshort = "DM",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\DMWest",		-- DMWest
				location = "厄运之槌 (59, 44)",
				levels = "56-60",
				players = "5",
				prereq = "需要从厄运之槌东追捕追捕普希林任务的月牙钥匙",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {97, 78} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "Dire Maul"..AM_EXTERIOR },
				dtl2  = { text = "厄运之槌 (北)", colour = AM_GREEN, coords = { {66, 9} }, symbol = { "N" },
						tooltiptxt = "", toMap = "厄运之槌 (北)", leaveGap = 1 },
				dtl3  = { text = "楼梯", colour = AM_BLUE, coords = { {49.2, 25}, {52, 60} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "水晶塔", colour = AM_GREEN, coords = { {83, 80}, {64, 61}, {64, 87}, {27, 62}, {27, 37} }, symbol = { "P" },
						tooltiptxt = "摧毁这些", leaveGap = 1 },
				dtl5  = { text = "辛德拉古灵", colour = AM_ORANGE, coords = { {68, 74} }, symbol = { "1" },
						tooltiptxt = "杀死王子的任务" },
				dtl6  = { text = "特迪斯·扭木", colour = AM_RED, coords = { {58, 74} }, symbol = { "2" },
						tooltiptxt = "Lvl60 精英元素生物", lootid = "DMWTendrisWarpwood" },
				dtl7  = { text = "伊琳娜·暗木", colour = AM_RED, coords = { {49, 87} }, symbol = { "3" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "DMWIllyannaRavenoak" },
				dtl8  = { text = "苏斯", colour = AM_RED, coords = { {48, 60} }, symbol = { "4" },
						tooltiptxt = "Lvl59 精英亡灵", special = AM_RARE, lootid = "DMWTsuzee" },
				dtl9  = { text = "卡雷迪斯镇长", colour = AM_RED, coords = { {53, 51} }, symbol = { "5" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "DMWMagisterKalendris" },
				dtl10 = { text = "伊莫塔尔", colour = AM_RED, coords = { {19, 49} }, symbol = { "6" },
						tooltiptxt = "Lvl61 精英恶魔", lootid = "DMWImmolthar" },
				dtl11 = { text = "赫尔努拉斯", colour = AM_RED, coords = { { 19, 49} }, symbol = { " " },
						tooltiptxt = "Lvl62 精英恶魔\n术士史诗坐骑任务召唤部分", lootid = "DMWHelnurath" },
				dtl12 = { text = "托塞德林王子", colour = AM_RED, coords = { {41, 26} }, symbol = { "7" },
						tooltiptxt = "Lvl61 精英人形生物", lootid = "DMWPrinceTortheldrin", leaveGap = 1  },
				dtl13 = { text = "图书馆", colour = AM_BLUE, coords = { {51, 20} }, symbol = { "8" },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "书籍", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMBooks", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "DMWTrash", leaveGap = 1 }
			},

			{	name = "诺莫瑞根",			-- Gnomeregan
				type = AM_TYP_INSTANCE,
				displayname = "诺莫瑞根",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Gnomeregan",
				location = "丹莫罗 (25, 41)",
				levels = "26-33",
				players = "10",
				prereq = "",
				general = "部落经由藏宝海湾传送器进入.\n从奥格瑞玛工程师处获得起始任务.",
				dtl1  = { text = "正门入口 (发条小径)", colour = AM_GREEN, coords = { {70.5, 16} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "诺莫瑞根"..AM_EXTERIOR },
				dtl2  = { text = "后门入口 (车间)", colour = AM_GREEN, coords = { {87, 59} }, symbol = { "X2" },
						tooltiptxt = "需要车间钥匙", toMap = "诺莫瑞根"..AM_EXTERIOR },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {75, 38}, {79, 56} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "粘性辐射尘", colour = AM_RED, coords = { {71.5, 33.5} }, symbol = { "1" },
						tooltiptxt = "Lvl30 精英元素生物\n下层", lootid = "GnViscousFallout" },
				dtl5  = { text = "格鲁比斯", colour = AM_RED, coords = { {95, 46} }, symbol = { "2" },
						tooltiptxt = "Lvl32 精英人形生物\n触发出现\n与同一位置的爆破专家艾米·短线交谈", lootid = "GnGrubbis"  },
				dtl6  = { text = "克努比 (The Dormitory)", colour = AM_BLUE, coords = { {76, 54} }, symbol = { "3" },
						tooltiptxt = ""  },
				dtl7  = { text = "矩阵式打孔计算机 3005-B", colour = AM_GREEN, coords = { {70, 50} }, symbol = { "B" },
						tooltiptxt = "卡片升级"  },
				dtl8  = { text = "清洗区", colour = AM_GREEN, coords = { {64, 46} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "电刑器6000型", colour = AM_RED, coords = { {30, 49} }, symbol = { "5" },
						tooltiptxt = "Lvl32 精英机械\n掉落车间钥匙", lootid = "GnElectrocutioner6000"  },
				dtl10 = { text = "矩阵式打孔计算机 3005-C", colour = AM_GREEN, coords = { {33.2, 49.6} }, symbol = { "C" },
						tooltiptxt = "卡片升级"  },
				dtl11 = { text = "群体打击者 9-60", colour = AM_RED, coords = { {47.6, 77.3} }, symbol = { "6" },
						tooltiptxt = "Lvl32 精英机械", lootid = "GnCrowdPummeler960"  },
				dtl12 = { text = "矩阵式打孔计算机 3005-D", colour = AM_GREEN, coords = { {48.9, 75.7} }, symbol = { "D" },
						tooltiptxt = "卡片升级"  },
				dtl13 = { text = "黑铁大师", colour = AM_RED, coords = { {9, 52} }, symbol = { "5" },
						tooltiptxt = "Lvl33 精英人形生物", special = AM_RARE, lootid = "GnDIAmbassador"  },
				dtl14 = { text = "麦克尼尔·瑟玛普拉格", colour = AM_RED, coords = { {11.8, 42.2} }, symbol = { "8" },
						tooltiptxt = "Lvl35 精英恶魔", lootid = "GnMekgineerThermaplugg", leaveGap = 1  },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "GnTrash", leaveGap = 1 }
			},

			{	name = "玛拉顿",			-- Maraudon
				type = AM_TYP_INSTANCE,
				displayname = "玛拉顿",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Maraudon",
				location = "凄凉之地 (29, 62)",
				levels = "40-49",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "入口 (橙色)", colour = AM_ORANGE, coords = { {71, 12} }, symbol = { "X1" },
						tooltiptxt = "", toMap = "玛拉顿"..AM_EXTERIOR },
				dtl2  = { text = "入口 (紫色)", colour = AM_PURPLE, coords = { {85, 31} }, symbol = { "X2" },
						tooltiptxt = "", toMap = "玛拉顿"..AM_EXTERIOR },
				dtl3  = { text = "入口 (传送)", colour = AM_GREEN, coords = { {36, 55} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {64, 44}, {39, 31} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "温格 (第五可汗)", colour = AM_RED, coords = { {59, 6} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS  },
				dtl6  = { text = "诺克赛恩", colour = AM_RED, coords = { {51, 3} }, symbol = { "2" },
						tooltiptxt = "Lvl48 精英元素生物", lootid = "MaraNoxxion"  },
				dtl7  = { text = "锐刺鞭笞者", colour = AM_RED, coords = { {36, 14} }, symbol = { "3" },
						tooltiptxt = "Lvl47 精英野兽", lootid = "MaraRazorlash"  },
				dtl8  = { text = "玛劳杜斯 (第四可汗)", colour = AM_RED, coords = { {64, 27} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl9  = { text = "维利塔恩", colour = AM_RED, coords = { {53.3, 32} }, symbol = { "5" },
						tooltiptxt = "Lvl47 精英人形生物", lootid = "MaraLordVyletongue"  },
				dtl10 = { text = "收割者麦什洛克", colour = AM_RED, coords = { {43, 30} }, symbol = { "6" },
						tooltiptxt = "", special = AM_RARE, lootid = "MaraMeshlok"  },
				dtl11 = { text = "被诅咒的塞雷布拉斯", colour = AM_RED, coords = { {31, 35} }, symbol = { "7" },
						tooltiptxt = "Lvl49 精英人形生物", lootid = "MaraCelebras"  },
				dtl12 = { text = "兰斯利德", colour = AM_RED, coords = { {51.3, 60} }, symbol = { "8" },
						tooltiptxt = "Lvl50 精英元素生物", lootid = "MaraLandslide"  },
				dtl13 = { text = "工匠吉兹洛克", colour = AM_RED, coords = { {61, 74} }, symbol = { "9" },
						tooltiptxt = "Lvl50 精英人形生物", lootid = "MaraTinkererGizlock"  },
				dtl14 = { text = "洛特格里普", colour = AM_RED, coords = { {45, 82} }, symbol = { "10" },
						tooltiptxt = "Lvl50 精英野兽", lootid = "MaraRotgrip"  },
				dtl15 = { text = "瑟莱德丝公主", colour = AM_RED, coords = { {32, 85} }, symbol = { "11" },
						tooltiptxt = "Lvl51 精英元素生物", lootid = "MaraPrincessTheradras" },
				dtl16 = { text = "扎尔塔的灵魂", colour = AM_RED, coords = { {32, 85} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 }
			},

			{	name = "熔火之心",			-- Molten Core
				type = AM_TYP_INSTANCE,
				displayname = "熔火之心",
				displayshort = "MC",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MoltenCore",
				location = "黑石深渊",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {3, 20} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石深渊", leaveGap = 1 },
				dtl2  = { text = "鲁西弗隆", colour = AM_RED, coords = { {62, 35} }, symbol = { "1" },
						tooltiptxt = "首领 人形生物", lootid = "MCLucifron" },
				dtl3  = { text = "玛格曼达", colour = AM_RED, coords = { {70, 16} }, symbol = { "2" },
						tooltiptxt = "首领 野兽", lootid = "MCMagmadar" },
				dtl4  = { text = "基赫纳斯", colour = AM_RED, coords = { {13, 46} }, symbol = { "3" },
						tooltiptxt = "首领 人形生物", lootid = "MCGehennas" },
				dtl5  = { text = "加尔", colour = AM_RED, coords = { {8, 71} }, symbol = { "4" },
						tooltiptxt = "首领 元素生物", lootid = "MCGarr"  },
				dtl6  = { text = "沙斯拉尔", colour = AM_RED, coords = { {44, 80} }, symbol = { "5" },
						tooltiptxt = "首领 人形生物", lootid = "MCShazzrah"  },
				dtl7  = { text = "迦顿男爵", colour = AM_RED, coords = { {53, 68} }, symbol = { "6" },
						tooltiptxt = "首领 元素生物", lootid = "MCGeddon"  },
				dtl8  = { text = "焚化者古雷曼格", colour = AM_RED, coords = { {66, 57} }, symbol = { "7" },
						tooltiptxt = "首领 巨人", lootid = "MCGolemagg"  },
				dtl9  = { text = "萨弗隆先驱者", colour = AM_RED, coords = { {87, 80} }, symbol = { "8" },
						tooltiptxt = "首领 人形生物", lootid = "MCSulfuron"  },
				dtl10 = { text = "管理者埃克索图斯", colour = AM_RED, coords = { {89, 62} }, symbol = { "9" },
						tooltiptxt = "首领 人形生物", lootid = "MCMajordomo"  },
				dtl11 = { text = "拉格纳罗斯", colour = AM_RED, coords = { {47, 52} }, symbol = { "10" },
						tooltiptxt = "首领 元素生物", lootid = "MCRagnaros", leaveGap = 2  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCTrashMobs", lootlink = true },
				dtl13 = { text = AM_RBOSS_DROP, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "MCRANDOMBOSSDROPPS", leaveGap = 1 },
				dtl14 = { text = AM_TIER1_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T1SET", leaveGap = 1 }
			},

			{	name = "纳克萨玛斯",			-- Naxxramas
				type = AM_TYP_INSTANCE,
				displayname = "纳克萨玛斯",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Naxxramas",
				location = "斯坦索姆",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text ="憎恶翼" , colour = AM_BLUE, coords = { {2, 15} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "帕奇维克", colour = AM_RED, coords = { {22, 36} }, symbol = { "1" },
						tooltiptxt = "憎恶翼", lootid = "NAXPatchwerk" },
				dtl3  = { text = "格罗布鲁斯", colour = AM_RED, coords = { {32, 29} }, symbol = { "2" },
						tooltiptxt = "憎恶翼", lootid = "NAXGrobbulus" },
				dtl4  = { text = "格拉斯", colour = AM_RED, coords = { {20, 20} }, symbol = { "3" },
						tooltiptxt = "憎恶翼", lootid = "NAXGluth" },
				dtl5  = { text = "塔迪乌斯", colour = AM_RED, coords = { {5, 4} }, symbol = { "4" },
						tooltiptxt = "憎恶翼", lootid = "NAXThaddius", leaveGap = 1  },
				dtl6  = { text = "地穴蜘蛛翼", colour = AM_BLUE, coords = { {67, 3} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl7  = { text = "阿努布雷坎", colour = AM_RED, coords = { {45.2, 20} }, symbol = { "1" },
						tooltiptxt = "地穴蜘蛛翼", lootid = "NAXAnubRekhan"  },
				dtl8  = { text = "黑女巫法琳娜", colour = AM_RED, coords = { {55, 16} }, symbol = { "2" },
						tooltiptxt = "地穴蜘蛛翼", lootid = "NAXGrandWidowFaerlina"  },
				dtl9  = { text = "迈克斯纳", colour = AM_RED, coords = { {74, 5} }, symbol = { "3" },
						tooltiptxt = "地穴蜘蛛翼", lootid = "NAXMaexxna", leaveGap = 1  },
				dtl10 = { text = "瘟疫翼", colour = AM_BLUE, coords = { {79, 56} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl11 = { text = "瘟疫使者诺斯", colour = AM_RED, coords = { {47, 64} }, symbol = { "1" },
						tooltiptxt = "瘟疫翼", lootid = "NAXNothderPlaguebringer"  },
				dtl12 = { text = "肮脏的希尔盖", colour = AM_RED, coords = { {60, 58} }, symbol = { "2" },
						tooltiptxt = "瘟疫翼", lootid = "NAXHeiganderUnclean"  },
				dtl13 = { text = "洛欧塞布", colour = AM_RED, coords = { {82, 47} }, symbol = { "3" },
						tooltiptxt = "瘟疫翼", lootid = "NAXLoatheb", leaveGap = 1  },
				dtl14 = { text = "死亡骑士翼", colour = AM_BLUE, coords = { {15, 79} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = ""  },
				dtl15 = { text = "教官拉苏维奥斯", colour = AM_RED, coords = { {18, 58} }, symbol = { "1" },
						tooltiptxt = "死亡骑士翼", lootid = "NAXInstructorRazuvious"  },
				dtl16 = { text = "收割者戈提克", colour = AM_RED, coords = { {37, 64} }, symbol = { "2" },
						tooltiptxt = "死亡骑士翼", lootid = "NAXGothikderHarvester" },
				dtl17 = { text = "四死亡骑士", colour = AM_RED, coords = { {8, 75} }, symbol = { "3" },
						tooltiptxt = "死亡骑士翼", lootid = "NAXTheFourHorsemen" },
				dtl18 = { text = "库尔塔兹领主", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "瑟里耶克爵士", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "大领主莫格莱尼", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "女公爵布劳缪克丝", colour = AM_RED, coords = { {8, 75} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl22 = { text = "冰霜飞龙巢穴", colour = AM_BLUE, coords = { {74, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "冰霜飞龙巢穴"  },
				dtl23 = { text = "萨菲隆", colour = AM_RED, coords = { {87, 91} }, symbol = { "1" },
						tooltiptxt = "冰霜飞龙巢穴", lootid = "NAXSapphiron"  },
				dtl24 = { text = "克尔苏加德", colour = AM_RED, coords = { {75, 79} }, symbol = { "2" },
						tooltiptxt = "冰霜飞龙巢穴", lootid = "NAXKelThuzard", leaveGap = 2  },
				dtl25 = { text = AM_TIER3_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T3SET", leaveGap = 1 },
				dtl26 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "NAXTrash", leaveGap = 1 }
			},

			{	name = "奥妮克希亚的巢穴",				-- Onyxia's Lair
				type = AM_TYP_INSTANCE,
				displayname = "奥妮克希亚的巢穴",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OnyxiasLair",
				location = "尘泥沼泽 (52, 76)",
				levels = "60+",
				players = "40",
				prereq = "需要龙火护符\n(完成在黑石塔上层杀死达基萨斯将军的任务)",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {9, 12} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "奥妮克希亚守卫", colour = AM_RED, coords = { {26, 41}, {29, 56}, {39, 68}, {50, 80} }, symbol = { "1" },
						tooltiptxt = "Lvl62 精英龙类" },
				dtl3  = { text = "雏龙蛋", colour = AM_RED, coords = { {45, 40}, {51, 54}, {84, 41}, {79, 54} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "奥妮克希亚", colour = AM_RED, coords = { {66, 27} }, symbol = { "3" },
						tooltiptxt = "首领 龙类", lootid = "Onyxia", leaveGap = 1 }
			},

			{	name = "怒焰裂谷",			-- Ragefire Chasm
				type = AM_TYP_INSTANCE,
				displayname = "怒焰裂谷",
				displayshort = "RFC",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RagefireChasm",			-- RagefireChasm
				location = "奥格瑞玛",
				levels = "13-18",
				players = "10",
				general = "",
				dtl1  = { text = "入口", colour = AM_GREEN, coords = { {72, 4} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "玛尔·恐怖图腾", colour = AM_GOLD, coords = { {71, 53} }, symbol = { "1" },
						tooltiptxt = "背包任务"  },
				dtl3  = { text = "饥饿者塔拉加曼", colour = AM_RED, coords = { {34, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl16 精英恶魔", lootid = "RFCTaragaman" },
				dtl4  = { text = "祈求者耶戈什", colour = AM_RED, coords = { {24, 86} }, symbol = { "3" },
						tooltiptxt = "Lvl16 精英人形生物", lootid = "RFCJergosh" },
				dtl5  = { text = "巴扎兰", colour = AM_RED, coords = { {36, 91} }, symbol = { "4" },
						tooltiptxt = "Lvl16 精英恶魔", leaveGap = 1  }

			},

			{	name = "剃刀高地",			-- Razorfen Downs
				type = AM_TYP_INSTANCE,
				displayname = "剃刀高地",
				displayshort = "RFD",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenDowns",
				location = "南贫瘠之地 (48, 88)",
				levels = "38-43",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {4, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {77, 45} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "图特卡什", colour = AM_RED, coords = { {52, 36} }, symbol = { "1" },
						tooltiptxt = "Lvl40 精英亡灵", lootid = "RFDTutenkash" },
				dtl4  = { text = "敲锣召唤图特卡什", colour = AM_GREEN, coords = { {54, 30} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "亨利·斯特恩,\n& 奔尼斯特拉兹", colour = AM_BLUE, coords = { {76, 27} }, symbol = { "3" },
						tooltiptxt = "学习如何制造 :\n金棘茶, \n强力巨魔之血药水"  },
				dtl6  = { text = "火眼莫德雷斯", colour = AM_RED, coords = { {87, 47} }, symbol = { "4" },
						tooltiptxt = "Lvl39 精英亡灵", lootid = "RFDMordreshFireEye"  },
				dtl7  = { text = "暴食者", colour = AM_RED, coords = { {19, 65} }, symbol = { "5" },
						tooltiptxt = "Lvl40 精英人形生物", lootid = "RFDGlutton"  },
				dtl8  = { text = "拉戈斯诺特", colour = AM_RED, coords = { {41, 67} }, symbol = { "6" },
						tooltiptxt = "Lvl40 精英人形生物", special = AM_RARE, lootid = "RFDRagglesnout"  },
				dtl9  = { text = "寒冰之王亚门纳尔", colour = AM_RED, coords = { {33, 59} }, symbol = { "0" },
						tooltiptxt = "Lvl41 精英亡灵", lootid = "RFDAmnennar", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFDTrash", leaveGap = 1 }
			},

			{	name = "剃刀沼泽",			-- Razorfen Kraul
				type = AM_TYP_INSTANCE,
				displayname = "剃刀沼泽",
				displayshort = "RFK",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RazorfenKraul",
				location = "南贫瘠之地 (42, 86)",
				levels = "28-33",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 71} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "鲁古格", colour = AM_RED, coords = { {73, 44} }, symbol = { "1" },
						tooltiptxt = "Lvl28 精英人形生物" },
				dtl3  = { text = "阿格姆", colour = AM_RED, coords = { {88, 48} }, symbol = { "2" },
						tooltiptxt = "Lvl30 精英人形生物" },
				dtl4  = { text = "亡语者贾格巴", colour = AM_RED, coords = { {93, 38} }, symbol = { "3" },
						tooltiptxt = "Lvl30 精英人形生物", lootid = "RFKDeathSpeakerJargba" },
				dtl5  = { text = "主宰拉姆塔斯", colour = AM_RED, coords = { {60, 29} }, symbol = { "4" },
						tooltiptxt = "Lvl32 精英人形生物", lootid = "RFKOverlordRamtusk"  },
				dtl6  = { text = "唤地者哈穆加", colour = AM_RED, coords = { {49, 37} }, symbol = { "5" },
						tooltiptxt = "Lvl32 精英人形生物", special = AM_RARE, lootid = "RFKEarthcallerHalmgar"  },
				dtl7  = { text = "进口商威利克斯,\n& 赫尔拉斯·静水", colour = AM_BLUE, coords = { {35, 33} }, symbol = { "6" },
						tooltiptxt = ""  },
				dtl8  = { text = "卡尔加·刺肋", colour = AM_RED, coords = { {21, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl33 精英人形生物", lootid = "RFKCharlgaRazorflank"  },
				dtl9  = { text = "盲眼猎手", colour = AM_RED, coords = { {6, 32} }, symbol = { "8" },
						tooltiptxt = "Lvl32 精英野兽\n& 箱子", special = AM_RARE, lootid = "RFKBlindHunter"  },
				dtl10 = { text = "Ward Sealing Agathelos", colour = AM_GREEN, coords = { {4, 54} }, symbol = { "9" },
						tooltiptxt = ""  },
				dtl11 = { text = "暴怒的阿迦赛罗斯", colour = AM_RED, coords = { {11, 65} }, symbol = { "10" },
						tooltiptxt = "Lvl33 精英野兽", lootid = "RFKAgathelos", leaveGap = 1  },
				dtl12 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "RFKTrash", leaveGap = 1 }
			},

			{	name = "安其拉废墟",		-- Ruins of Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "安其拉废墟",
				displayshort = "AQ20",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\RuinsofAhnQiraj",		-- RuinsofAhnQiraj
				location = "希利苏斯 (29, 96)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {64, 2} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "库林纳克斯", colour = AM_RED, coords = { {55, 29} }, symbol = { "1" },
						tooltiptxt = "首领 & 精英", lootid = "AQ20Kurinnaxx" },
				dtl3  = { text ="安多洛夫中将,\n&卡多雷四精英", colour = AM_RED, coords = { {55, 29} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20Andorov" },
				dtl4  = { text = "奎兹上尉", colour = AM_RED, coords = { {52.1, 46.9} }, symbol = { "2" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN" },
				dtl5  = { text = "图比德上尉", colour = AM_RED, coords = { {55.4, 46.9} }, symbol = { "3" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN" },
				dtl6  = { text = "德雷恩上尉", colour = AM_RED, coords = { {57.2, 47.9} }, symbol = { "4" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN"  },
				dtl7  = { text = "库雷姆上尉", colour = AM_RED, coords = { {59.2, 49.2} }, symbol = { "5" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN"  },
				dtl8  = { text = "耶吉斯少校", colour = AM_RED, coords = { {61.3, 50.3} }, symbol = { "6" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN"  },
				dtl9  = { text = "帕库少校", colour = AM_RED, coords = { {60, 53.4} }, symbol = { "7" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN"  },
				dtl10 = { text = "泽兰上校", colour = AM_RED, coords = { {56, 51.2} }, symbol = { "8" },
						tooltiptxt = "Lvl63 精英", lootid = "AQ20CAPTIAN"  },
				dtl11 = { text = "拉贾克斯将军", colour = AM_RED, coords = { {52.2, 49.5} }, symbol = { "9" },
						tooltiptxt = "首领", lootid = "AQ20Rajaxx"  },
				dtl12 = { text = "莫阿姆", colour = AM_RED, coords = { {13, 31} }, symbol = { "10" },
						tooltiptxt = "首领", lootid = "AQ20Moam"  },
				dtl13 = { text = "吞咽者布鲁", colour = AM_RED, coords = { {83, 55} }, symbol = { "11" },
						tooltiptxt = "首领", lootid = "AQ20Buru"  },
				dtl14 = { text = "安全房间", colour = AM_GREEN, coords = { {65, 70} }, symbol = { "12" },
						tooltiptxt = ""  },
				dtl15 = { text = "狩猎者阿亚米斯", colour = AM_RED, coords = { {67, 91} }, symbol = { "13" },
						tooltiptxt = "首领", lootid = "AQ20Ayamiss"  },
				dtl16 = { text = "无疤者奥斯里安", colour = AM_RED, coords = { {29, 73} }, symbol = { "14" },
						tooltiptxt = "首领", lootid = "AQ20Ossirian", leaveGap = 2  },
				dtl17 = { text = "职业技能书", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20ClassBooks" },
				dtl18 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants" },
				dtl19 = { text = "AQ20"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ20SET", leaveGap = 1 }
			},

			{	name = "血色修道院",			-- Scarlet Monastery
				type = AM_TYP_INSTANCE,
				displayname = "血色修道院",
				displayshort = "SM",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ScarletMonastery",
				location = "提瑞斯法林地 (83.6, 34)",
				levels = "30-40",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "墓地入口", colour = AM_GREEN, coords = { {61, 97} }, symbol = { "G" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl2  = { text = "铁脊死灵", colour = AM_RED, coords = { {21, 88} }, symbol = { "1" },
						tooltiptxt = "Lvl33 精英亡灵\n墓地", special = AM_RARE, lootid = "SMIronspine"  },
				dtl3  = { text = "永醒的艾希尔", colour = AM_RED, coords = { {5, 88} }, symbol = { "2" },
						tooltiptxt = "Lvl33 精英亡灵\n墓地", special = AM_RARE, lootid = "SMAzshir"  },
				dtl4  = { text = "死灵勇士", colour = AM_RED, coords = { {8, 80} }, symbol = { "3" },
						tooltiptxt = "Lvl33 精英亡灵\n墓地", special = AM_RARE, lootid = "SMFallenChampion" },
				dtl5  = { text = "血法师萨尔诺斯", colour = AM_RED, coords = { {5, 77} }, symbol = { "4" },
						tooltiptxt = "Lvl34 精英亡灵\n墓地", lootid = "SMBloodmageThalnos" },
				dtl6  = { text = "图书馆入口", colour = AM_GREEN, coords = { {56, 74} }, symbol = { "L" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl7  = { text = "驯犬者洛克希", colour = AM_RED, coords = { {66.1, 95} }, symbol = { "5" },
						tooltiptxt = "Lvl34 精英人形生物\n图书馆", lootid = "SMHoundmasterLoksey"  },
				dtl8  = { text = "奥法师杜安", colour = AM_RED, coords = { {95.1, 92} }, symbol = { "6" },
						tooltiptxt = "Lvl37 精英人形生物\n图书馆", lootid = "SMDoan", leaveGap = 1  },
				dtl9  = { text = "军械库入口", colour = AM_GREEN, coords = { {54, 65} }, symbol = { "A" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl10 = { text = "赫洛德", colour = AM_RED, coords = { {74.8, 6.2} }, symbol = { "7" },
						tooltiptxt = "Lvl40 精英人形生物\n军械库", lootid = "SMHerod", leaveGap = 1  },
				dtl11 = { text = "大教堂入口", colour = AM_GREEN, coords = { {37, 65} }, symbol = { "C" },
						tooltiptxt = "", toMap = "血色修道院"..AM_EXTERIOR },
				dtl12 = { text = "大检察官法尔班克斯", colour = AM_RED, coords = { {31, 11} }, symbol = { "8" },
						tooltiptxt = "Lvl40 精英人形生物\n大教堂", lootid = "SMFairbanks"  },
				dtl13 = { text = "血色十字军指挥官莫格莱尼", colour = AM_RED, coords = { {23.4, 12} }, symbol = { "9" },
						tooltiptxt = "Lvl42 精英人形生物\n大教堂", lootid = "SMMograine"  },
				dtl14 = { text = "大检察官怀特迈恩", colour = AM_RED, coords = { {23.4, 4.4} }, symbol = { "10" },
						tooltiptxt = "Lvl42 精英人形生物\n大教堂", lootid = "SMWhitemane", leaveGap = 2  },
				dtl15 = { text = "套装 : 血色十字军链甲", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "6 部分", lootid = "SMScarletSET", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "SMTrash", leaveGap = 1 }
			},

			{	name = "安其拉神殿",			-- Ahn'Qiraj
				type = AM_TYP_INSTANCE,
				displayname = "安其拉神殿",
				displayshort = "AQ40",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TempleofAhnQiraj",		-- TempleofAhnQiraj
				location = "希利苏斯 (29, 96)",
				levels = "60+",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {16, 37} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "亚雷戈斯\n& 凯雷斯特拉兹\n& 梦境之龙麦琳瑟拉", colour = AM_BLUE, coords = { {21, 56} }, symbol = { "A" },
						tooltiptxt = ""  },
				dtl3  = { text = "安多葛斯\n& 温瑟拉\n& 坎多斯特拉兹", colour = AM_BLUE, coords = { {27, 43} }, symbol = { "B" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "预言者斯克拉姆", colour = AM_RED, coords = { {19, 41} }, symbol = { "1" },
						tooltiptxt = "首领 \n外部", lootid = "AQ40Skeram" },
				dtl5  = { text = "维姆 & 组合", colour = AM_RED, coords = { {15, 52} }, symbol = { "2" },
						tooltiptxt = "首领", special = AM_OPTIONAL, lootid = "AQ40Vem" },
				dtl6  = { text = "沙尔图拉", colour = AM_RED, coords = { {40, 30} }, symbol = { "3" },
						tooltiptxt = "首领", lootid = "AQ40Sartura" },
				dtl7  = { text = "顽强的范克瑞斯", colour = AM_RED, coords = { {67, 14} }, symbol = { "4" },
						tooltiptxt = "首领", lootid = "AQ40Fankriss"  },
				dtl8  = { text = "维希度斯", colour = AM_RED, coords = { {82, 7} }, symbol = { "5" },
						tooltiptxt = "首领", special = AM_OPTIONAL, lootid = "AQ40Viscidus"  },
				dtl9  = { text = "哈霍兰公主", colour = AM_RED, coords = { {41, 49} }, symbol = { "6" },
						tooltiptxt = "首领", lootid = "AQ40Huhuran"  },
				dtl10 = { text = "双子皇帝", colour = AM_RED, coords = { {72, 67} }, symbol = { "7" },
						tooltiptxt = "首领", lootid = "AQ40Emperors"  },
				dtl11 = { text = "奥罗", colour = AM_RED, coords = { { 22, 87 } }, symbol = { "8" },
						tooltiptxt = "首领", special = AM_OPTIONAL, lootid = "AQ40Ouro" },
				dtl12 = { text = "克苏恩之眼", colour = AM_RED, coords = { {25, 50} }, symbol = { "9" },
						tooltiptxt = "", lootid = "AQ40CThun" },
				dtl13 = { text = "克苏恩", colour = AM_RED, coords = { {25, 50} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40CThun", leaveGap = 2 },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40Trash", leaveGap = 1 },
				dtl15 = { text = "AQ40 "..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQ40SET", leaveGap = 1 },
				dtl16 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0 } }, symbol = { " " },
						tooltiptxt = "", lootid = "AQEnchants", leaveGap = 1 },
				dtl17 = { text = "AQ Brood Rings", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQBroodRings", leaveGap = 1 },
				dtl18 = { text = AM_OPENING, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AQOpening", leaveGap = 1 }
			},

			{	name = "死亡矿井",			-- The Deadmines
				type = AM_TYP_INSTANCE,
				displayname = "死亡矿井",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheDeadmines",
				location = "西部荒野 (42, 72)",
				levels = "16-26",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 23} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "死亡矿井"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_EXITS, colour = AM_RED, coords = { {99, 42} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {80, 40} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "拉克佐", colour = AM_RED, coords = { {21, 58} }, symbol = { "1" },
						tooltiptxt = "Lvl19 精英人形生物", lootid = "VCRhahkZor" },
				dtl5  = { text = "矿工约翰森", colour = AM_RED, coords = { {41, 50} }, symbol = { "2" },
						tooltiptxt = "Lvl19 精英人形生物", lootid = "VCMinerJohnson", special = AM_RARE  },
				dtl6  = { text = "斯尼德", colour = AM_RED, coords = { {37, 77} }, symbol = { "3" },
						tooltiptxt = "Lvl20 精英机械 (in Shredder)", lootid = "VCSneed"  },
				dtl7  = { text = "基尔尼格", colour = AM_RED, coords = { {48.8, 60.2} }, symbol = { "4" },
						tooltiptxt = "Lvl20 精英人形生物", lootid = "VCGilnid"  },
				dtl8  = { text = "迪菲亚火药", colour = AM_GREEN, coords = { {55.6, 39} }, symbol = { "5" },
						tooltiptxt = "...爆破粉，用于打破大门"  },
				dtl9  = { text = "重拳先生", colour = AM_RED, coords = { {76, 31} }, symbol = { "6" },
						tooltiptxt = "Lvl20 精英人形生物", lootid = "VCMrSmite"  },
				dtl10 = { text = "曲奇", colour = AM_RED, coords = { {81, 36} }, symbol = { "7" },
						tooltiptxt = "", lootid = "VCCookie"  },
				dtl11 = { text = "绿皮队长", colour = AM_RED, coords = { {76, 37} }, symbol = { "8" },
						tooltiptxt = "Lvl21 精英人形生物", lootid = "VCCaptainGreenskin"  },
				dtl12 = { text = "艾德温·范克利夫", colour = AM_RED, coords = { {79, 37} }, symbol = { "9" },
						tooltiptxt = "Lvl21 精英人形生物", lootid = "VCVanCleef", leaveGap = 2 },
				dtl13 = { text = "套装 : 迪菲亚皮甲", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "VCDefiasSET", leaveGap = 1 }
			},

			{	name = "监狱",			-- The Stockade
				type = AM_TYP_INSTANCE,
				displayname = "监狱",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheStockade",
				location = "暴风城",
				levels = "24-32",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {69, 60}, {75, 40}, {26, 57}, {31, 36}, {18, 29} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "可怕的塔格尔", colour = AM_RED, coords = { {58, 63}, {41, 55}, {50, 37}, {27, 50} }, symbol = { "1" },
						tooltiptxt = "Lvl24 精英人形生物", special = AM_VARIES },
				dtl4  = { text = "卡姆·深怒", colour = AM_RED, coords = { {73, 43} }, symbol = { "2" },
						tooltiptxt = "Lvl27 精英人形生物", lootid = "SWStKamDeepfury" },
				dtl5  = { text = "哈姆霍克", colour = AM_RED, coords = { {85, 56} }, symbol = { "3" },
						tooltiptxt = "Lvl28 精英人形生物"  },
				dtl6  = { text = "巴吉尔·特雷德", colour = AM_RED, coords = { {95, 62} }, symbol = { "4" },
						tooltiptxt = ""  },
				dtl7  = { text = "迪克斯特·瓦德", colour = AM_RED, coords = { {15, 40} }, symbol = { "5" },
						tooltiptxt = "Lvl26 精英人形生物"  },
				dtl8  = { text = "Bruegal Ironknuckle", colour = AM_RED, coords = { {22, 54} }, symbol = { "6" },
						tooltiptxt = "Lvl26 精英人形生物", special = AM_RARE, lootid = "SWStBruegalIronknuckle", leaveGap = 1 }
			},

			{	name = "T阿塔哈卡神庙",			-- The Sunken Temple
				type = AM_TYP_INSTANCE,
				displayname = "阿塔哈卡神庙",
				displayshort = "ST",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSunkenTemple",
				location = "悲伤沼泽 (70, 53)",
				levels = "45-60",
				players = "10",
				prereq = "",
				general = "也称为沉没的神庙",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 7} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "T阿塔哈卡神庙"..AM_EXTERIOR },
				dtl2  = { text = "入口通往下层楼梯", colour = AM_GREEN, coords = { {54, 11.3}, {13.9, 47} }, symbol = { "SL" },
						tooltiptxt = "" },
				dtl3  = { text = "入口通往中层楼梯", colour = AM_GREEN, coords = { {69, 11.3} }, symbol = { "SM" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = "到达上层楼梯", colour = AM_BLUE, coords = { {52, 18}, {69, 18}, {52, 48}, {69, 48} }, symbol = { AM_STAIRS_SYMBOL },
						tooltiptxt = "" },
				dtl5  = { text = "巨魔小首领 (上层)", colour = AM_RED, coords = { {55, 23}, {66, 23}, {72, 33}, {49, 33}, {54, 43}, {66, 43} }, symbol = { "T1", "T2", "T3", "T4", "T5", "T6" },
						tooltiptxt = "全部杀死, 然后再杀死迦玛兰\n以挑战伊兰尼库斯", lootid = "STTrollMinibosses", leaveGap = 1 },
				dtl6  = { text = "雕像 (下层)", colour = AM_ORANGE, coords = { {22, 82}, {22, 64}, {13, 77}, {30, 77}, {13, 68}, {30, 68} }, symbol = { "S1", "S2", "S3", "S4", "S5", "S6" },
						tooltiptxt = "按数字顺序激活以\n召唤阿塔拉利恩" },
				dtl7  = { text = "哈卡祭坛", colour = AM_ORANGE, coords = { {22, 74} }, symbol = { "1" },
						tooltiptxt = ""  },
				dtl8  = { text = "阿塔拉利恩", colour = AM_RED, coords = { {22, 71} }, symbol = { "2" },
						tooltiptxt = "Lvl50 精英人形生物", lootid = "STAtalalarion", leaveGap = 1  },
				dtl9  = { text = "德姆赛卡尔", colour = AM_RED, coords = { {58, 33} }, symbol = { "3" },
						tooltiptxt = "Lvl53 精英龙类", lootid = "STDreamscythe"  },
				dtl10 = { text = "德拉维沃尔", colour = AM_RED, coords = { {62, 33} }, symbol = { "4" },
						tooltiptxt = "Lvl51 精英龙类", lootid = "STWeaver"  },
				dtl11 = { text = "哈卡的化身", colour = AM_RED, coords = { {32, 33} }, symbol = { "5" },
						tooltiptxt = "Lvl50 精英龙类", lootid = "STAvatarofHakkar"  },
				dtl12 = { text = "预言者迦玛兰", colour = AM_RED, coords = { {88, 27} }, symbol = { "6" },
						tooltiptxt = "Lvl54 精英人形生物", lootid = "STJammalan"  },
				dtl13 = { text = "可悲的奥戈姆", colour = AM_RED, coords = { {88, 31} }, symbol = { "7" },
						tooltiptxt = "Lvl53 精英亡灵", lootid = "STOgom"  },
				dtl14 = { text = "摩弗拉斯", colour = AM_RED, coords = { {59, 62} }, symbol = { "8" },
						tooltiptxt = "Lvl52 精英龙类", lootid = "STMorphaz"  },
				dtl15 = { text = "哈扎斯", colour = AM_RED, coords = { {62, 62} }, symbol = { "9" },
						tooltiptxt = "Lvl53 精英龙类", lootid = "STHazzas"  },
				dtl16 = { text = "伊兰尼库斯的阴影", colour = AM_RED, coords = { {80, 62} }, symbol = { "10" },
						tooltiptxt = "Lvl55 精英龙类", lootid = "STEranikus"  },
				dtl17 = { text = "精华之泉", colour = AM_ORANGE, coords = { {85, 57} }, symbol = { "11" },
						tooltiptxt = "", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "STTrash", leaveGap = 1 }
			},

			{	name = "奥达曼",			-- Uldaman
				type = AM_TYP_INSTANCE,
				displayname = "奥达曼",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Uldaman",
				location = "荒芜之地 (44, 12)",
				levels = "35-50",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = "前门入口", colour = AM_GREEN, coords = { {89, 73.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "点击打开奥达曼外部地图", toMap = "奥达曼"..AM_EXTERIOR },
				dtl2  = { text = "旁门入口", colour = AM_GREEN, coords = { {21, 71} }, symbol = { "XR" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "巴尔洛戈", colour = AM_RED, coords = { {73, 93} }, symbol = { "1" },
						tooltiptxt = "Lvl41 精英" },
				dtl4  = { text = "圣骑士的遗体", colour = AM_ORANGE, coords = { {62.8, 63.2} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "鲁维罗什", colour = AM_RED, coords = { {64, 73.3} }, symbol = { "3" },
						tooltiptxt = "Lvl40 精英人形生物", lootid = "UldRevelosh"  },
				dtl6  = { text = "艾隆纳亚", colour = AM_RED, coords = { {38, 75} }, symbol = { "4" },
						tooltiptxt = "首领 巨人", lootid = "UldIronaya"  },
				dtl7  = { text = "安诺拉 (大师级附魔师)", colour = AM_BLUE, coords = { {56, 61} }, symbol = { "5" },
						tooltiptxt = ""  },
				dtl8  = { text = "黑曜石哨兵", colour = AM_RED, coords = { {24.4, 62} }, symbol = { "6" },
						tooltiptxt = "Lvl42 精英机械"  },
				dtl9  = { text = "古代的石头看守者", colour = AM_RED, coords = { {54.7, 43} }, symbol = { "7" },
						tooltiptxt = "Lvl44 精英元素生物", lootid = "UldAncientStoneKeeper"  },
				dtl10 = { text = "加加恩·火锤", colour = AM_RED, coords = { {21, 31} }, symbol = { "8" },
						tooltiptxt = "首领 人形生物", lootid = "UldGalgannFirehammer"  },
				dtl11 = { text = "格瑞姆洛克", colour = AM_RED, coords = { {17, 19} }, symbol = { "9" },
						tooltiptxt = "Lvl45 精英人形生物", lootid = "UldGrimlok"  },
				dtl12 = { text = "阿扎达斯", colour = AM_RED, coords = { {45.2, 14.4} }, symbol = { "10" },
						tooltiptxt = "首领 巨人\n下层", lootid = "UldArchaedas"  },
				dtl13 = { text = "诺甘农圆盘", colour = AM_ORANGE, coords = { {39.7, 6.2} }, symbol = { "11" },
						tooltiptxt = "上层"  },
				dtl14 = { text = "古代宝藏", colour = AM_ORANGE, coords = { {42.3, 4.9} }, symbol = { "12" },
						tooltiptxt = "上层", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "UldTrash", leaveGap = 1 }
			},

			{ 	name = "哀嚎洞穴",			-- Wailing Caverns
				type = AM_TYP_INSTANCE,
				displayname = "哀嚎洞穴",
				displayshort = "WC",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\WailingCaverns",
				location = "贫瘠之地 (46, 36)",
				levels = "16-25",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {44, 58} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "哀嚎洞穴"..AM_EXTERIOR },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {62, 47}, {94, 49} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "纳拉雷克斯的信徒", colour = AM_BLUE, coords = { {45, 53} }, symbol = { "1" },
						tooltiptxt = "触发副本终结" },
				dtl4  = { text = "考布莱恩", colour = AM_RED, coords = { {14, 55} }, symbol = { "2" },
						tooltiptxt = "Lvl20 精英人形生物", lootid = "WCLordCobrahn" },
				dtl5  = { text = "安娜科德拉", colour = AM_RED, coords = { {39, 35} }, symbol = { "3" },
						tooltiptxt = "Lvl20 精英人形生物", lootid = "WCLadyAnacondra" },
				dtl6  = { text = "克雷什", colour = AM_RED, coords = { {45, 42} }, symbol = { "4" },
						tooltiptxt = "Lvl20 精英人形生物", lootid = "WCKresh"  },
				dtl7  = { text = "变异精灵龙", colour = AM_RED, coords = { {63, 43} }, symbol = { "5" },
						tooltiptxt = "Lvl20 精英龙类", lootid = "WCDeviateFaerieDragon", special = AM_RARE },
				dtl8  = { text = "皮萨斯", colour = AM_RED, coords = { {86, 34} }, symbol = { "6" },
						tooltiptxt = "Lvl22 精英人形生物", lootid = "WCLordPythas"  },
				dtl9  = { text = "斯卡姆", colour = AM_RED, coords = { {93, 69} }, symbol = { "7" },
						tooltiptxt = "Lvl21 精英人形生物", lootid = "WCSkum"  },
				dtl10 = { text = "瑟芬迪斯", colour = AM_RED, coords = { {60, 52} }, symbol = { "8" },
						tooltiptxt = "Lvl22 精英人形生物\n上层", lootid = "WCLordSerpentis"  },
				dtl11 = { text = "永生者沃尔丹", colour = AM_RED, coords = { {56, 48} }, symbol = { "9" },
						tooltiptxt = "Lvl24 精英元素生物\n上层", lootid = "WCVerdan"  },
				dtl12 = { text = "吞噬者穆坦努斯", colour = AM_RED, coords = { {29.9, 23.9} }, symbol = { "10" },
						tooltiptxt = "Lvl22 精英人形生物\n触发出现", lootid = "WCMutanus"  },
				dtl13 = { text = "纳拉雷克斯", colour = AM_RED, coords = { {32.4, 25.4} }, symbol = { "11" },
						tooltiptxt = "Lvl25 精英人形生物", leaveGap = 2  },
				dtl14 = { text = "套装 : 毒蛇的拥抱", colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "WCViperSET", leaveGap = 1 }
			},

			{	name = "祖尔法拉克",			-- Zul'Farrak
				type = AM_TYP_INSTANCE,
				displayname = "祖尔法拉克",
				displayshort = "ZF",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulFarrak",
				location = "塔纳利斯 (37, 15)",
				levels = "43-47",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {69, 89} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "泽雷利斯", colour = AM_RED, coords = { {63, 47} }, symbol = { "1" },
						tooltiptxt = "Lvl45 精英人形生物", special = AM_RARE.." "..AM_WANDERS, lootid = "ZFZerillis" },
				dtl3  = { text = "杉达尔·沙掠者", colour = AM_RED, coords = { {55, 59} }, symbol = { "2" },
						tooltiptxt = "Lvl45 精英人形生物", special = AM_RARE },
				dtl4  = { text = "水占师维蕾萨", colour = AM_RED, coords = { {34, 43} }, symbol = { "3" },
						tooltiptxt = "Lvl46 精英人形生物" },
				dtl5  = { text = "加兹瑞拉", colour = AM_RED, coords = { {37, 46} }, symbol = { "4" },
						tooltiptxt = "Lvl46 精英野兽", lootid = "ZFGahzrilla"  },
				dtl6  = { text = "灰尘怨灵", colour = AM_RED, coords = { {32, 46} }, symbol = { "5" },
						tooltiptxt = "Lvl45 精英人形生物", special = AM_RARE, lootid = "ZFDustwraith"  },
				dtl7  = { text = "安图苏尔", colour = AM_RED, coords = { {80, 35} }, symbol = { "6" },
						tooltiptxt = "Lvl48 精英人形生物", lootid = "ZFAntusul"  },
				dtl8  = { text = "殉教者塞卡", colour = AM_RED, coords = { {67, 33} }, symbol = { "7" },
						tooltiptxt = "Lvl46 精英人形生物"  },
				dtl9  = { text = "巫医祖穆拉恩", colour = AM_RED, coords = { {53, 23} }, symbol = { "8" },
						tooltiptxt = "Lvl46 精英人形生物", lootid = "ZFWitchDoctorZumrah"  },
				dtl10 = { text = "祖尔法拉克阵亡英雄", colour = AM_RED, coords = { {51, 27} }, symbol = { "9" },
						tooltiptxt = "Lvl46 精英人形生物"  },
				dtl11 = { text = "暗影祭司塞瑟斯", colour = AM_RED, coords = { {36, 26} }, symbol = { "10" },
						tooltiptxt = "Lvl47 精英人形生物", lootid = "ZFSezzziz" },
				dtl12 = { text = "耐克鲁姆", colour = AM_RED, coords = { {36, 26} }, symbol = { " " },
						tooltiptxt = "Lvl46 精英亡灵"  },
				dtl13 = { text = "布莱中士", colour = AM_ORANGE, coords = { {26, 26} }, symbol = { "11" },
						tooltiptxt = "探水棒任务\n敌对/中立取决于\n阵营及采取的行动" },
				dtl14 = { text = "卢兹鲁", colour = AM_RED, coords = { {51, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl46 精英人形生物"  },
				dtl15 = { text = "乌克兹·沙顶", colour = AM_RED, coords = { {55, 42} }, symbol = { "13" },
						tooltiptxt = "Lvl48 精英人形生物", lootid = "ZFChiefUkorzSandscalp", leaveGap = 1 },
				dtl16 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZFTrash", leaveGap = 1 }
			},

			{	name = "祖而格拉布",			-- Zul'Gurub
				type = AM_TYP_INSTANCE,
				displayname = "祖而格拉布",
				displayshort = "ZG",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulGurub",
				location = "荆棘谷 (54, 17)",
				levels = "60+",
				players = "20",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {12, 50} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "混浊的水", colour = AM_BLUE, coords = { {33, 41}, {47, 48}, {57, 47}, {60, 32}, {47, 30} }, symbol = { "W" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "高阶祭司耶克里克", colour = AM_RED, coords = { {34, 78} }, symbol = { "1" },
						tooltiptxt = "首领 人形生物", special = "(蝙蝠)", lootid = "ZGJeklik" },
				dtl4  = { text = "高阶祭司温诺西斯", colour = AM_RED, coords = { {56, 57} }, symbol = { "2" },
						tooltiptxt = "首领 人形生物", special = "(毒蛇)", lootid = "ZGVenoxis" },
				dtl5  = { text = "高阶祭司玛尔里", colour = AM_RED, coords = { {48, 85} }, symbol = { "3" },
						tooltiptxt = "首领 人形生物", special = "(蜘蛛)", lootid = "ZGMarli"  },
				dtl6  = { text = "血领主曼多基尔", colour = AM_RED, coords = { {76, 73} }, symbol = { "4" },
						tooltiptxt = "首领 人形生物", special = "(迅猛龙)"..AM_OPTIONAL, lootid = "ZGMandokir"  },
				dtl7  = { text = "疯狂之源", colour = AM_RED, coords = { {72, 47} }, symbol = { "5" },
						tooltiptxt = "", special = AM_OPTIONAL  },
				dtl8  = { text = "格里雷克，钢铁之血", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首领 亡灵", lootid = "ZGGrilek"  },
				dtl9  = { text = "哈扎拉尔，织梦者", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首领 亡灵", lootid = "ZGHazzarah"  },
				dtl10 = { text = "雷纳塔基，千刃之王", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首领 亡灵", lootid = "ZGRenataki"  },
				dtl11 = { text = "雷巫乌苏雷", colour = AM_RED, coords = { {72, 47} }, symbol = { " " },
						tooltiptxt = "首领 亡灵", lootid = "ZGWushoolay"  },
				dtl12 = { text = "加兹兰卡", colour = AM_RED, coords = { {66, 33} }, symbol = { "6" },
						tooltiptxt = "首领 人形生物", special = AM_OPTIONAL, lootid = "ZGGahzranka"  },
				dtl13 = { text = "高阶祭司塞卡尔", colour = AM_RED, coords = { {80, 32} }, symbol = { "7" },
						tooltiptxt = "首领 人形生物", special = "(猛虎)", lootid = "ZGThekal" },
				dtl14 = { text = "高阶祭司娅尔罗", colour = AM_RED, coords = { {49, 16} }, symbol = { "8" },
						tooltiptxt = "首领 人形生物", special = "(猎豹)", lootid = "ZGArlokk"  },
				dtl15 = { text = "妖术师金度", colour = AM_RED, coords = { {20, 18} }, symbol = { "9" },
						tooltiptxt = "首领 人形生物", special = "(亡灵)"..AM_OPTIONAL, lootid = "ZGJindo" },
				dtl16 = { text = "哈卡", colour = AM_RED, coords = { {54, 40} }, symbol = { "10" },
						tooltiptxt = "首领 龙类", lootid = "ZGHakkar", leaveGap = 2 },
				dtl17 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGTrash", leaveGap = 1 },
				dtl18 = { text = "ZG"..AM_CLASS_SETS, colour = AM_ORANGE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGSET", leaveGap = 1 },
				dtl19 = { text = AM_RBOSS_DROP, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGShared", leaveGap = 1 },
				dtl20 = { text = AM_ENCHANTS, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "ZGEnchants", leaveGap = 1 }
			},

			{	name = "通灵学院",			-- Scholomance
				type = AM_TYP_INSTANCE,
				displayname = "通灵学院",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Scholomance",		-- Scholomance*
				location = "西瘟疫之地 (69, 73)",
				levels = "56-60",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {24, 30} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {28, 38} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {6.5, 22}, {62, 22} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl4  = {text = AM_INSTANCE_STAIRS, colour = AM_GREEN, coords = { {41, 41}, {34, 80} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "基尔图诺斯的卫士", colour = AM_RED, coords = { {54, 32} }, symbol = { "1" },
						tooltiptxt = "Lvl61 精英恶魔", lootid = "SCHOLOBloodSteward"  },
				dtl6  = { text = "传令官基尔图诺斯", colour = AM_RED, coords = { {30, 5} }, symbol = { "2" },
						tooltiptxt = "", lootid = "SCHOLOKirtonostheHerald" },
				dtl7  = { text = "詹迪斯·巴罗夫", colour = AM_RED, coords = { {96, 8.5} }, symbol = { "3" },
						tooltiptxt = "Lvl61 精英亡灵", lootid = "SCHOLOJandiceBarov"  },
				dtl8  = { text = "血骨傀儡", colour = AM_RED, coords = { {10, 41} }, symbol = { "4" },
						tooltiptxt = "Lvl61 精英亡灵\n下层\n掉落观察室钥匙", lootid = "SCHOLORattlegore"  },
				dtl9  = { text = "死亡骑士达克雷尔", colour = AM_RED, coords = { {10, 41} }, symbol = { " " },
						tooltiptxt = "Lvl62 精英亡灵\n骑士/萨满祭司任务召唤", lootid = "SCHOLODeathKnight" },
				dtl10 = { text = "马杜克·布莱克波尔", colour = AM_BLUE, coords = { {23.7, 42} }, symbol = { "5" },
						tooltiptxt = "Lvl58 精英\n在观察室中放置黎明先锋\n以激怒他", lootid = "SCHOLOMarduk"  },
				dtl11 = { text = "维克图斯", colour = AM_BLUE, coords = { {27.2, 42} }, symbol = { "6" },
						tooltiptxt = "Lvl60 精英亡灵\n在观察室中放置黎明先锋\n以激怒他", lootid = "SCHOLOVectus"  },
				dtl12 = { text = "莱斯·霜语", colour = AM_RED, coords = { {18, 87} }, symbol = { "8" },
						tooltiptxt = "Lvl62 精英亡灵", lootid = "SCHOLORasFrostwhisper"  },
				dtl13 = { text = "库尔莫克", colour = AM_RED, coords = { {18, 80} }, symbol = { "9" },
						tooltiptxt = "Lvl60 精英", lootid = "SCHOLOKormok" },
				dtl14 = { text = "讲师玛丽希亚", colour = AM_RED, coords = { {44.5, 94} }, symbol = { "10" },
						tooltiptxt = "Lvl60 精英人形生物", lootid = "SCHOLOInstructorMalicia"  },
				dtl15 = { text = "瑟尔林·卡斯迪诺夫教授", colour = AM_RED, coords = { {64, 74.2} }, symbol = { "11" },
						tooltiptxt = "Lvl60 精英人形生物", lootid = "SCHOLODoctorTheolenKrastinov"  },
				dtl16 = { text = "博学者普克尔特", colour = AM_RED, coords = { {44.8, 55.2} }, symbol = { "12" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "SCHOLOLorekeeperPolkelt"  },
				dtl17 = { text = "拉文尼亚", colour = AM_RED, coords = { {75.8, 92} }, symbol = { "13" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "SCHOLOTheRavenian"  },
				dtl18 = { text = "阿雷克斯·巴罗夫", colour = AM_RED, coords = { {96.2, 74.5} }, symbol = { "14" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "SCHOLOLordAlexeiBarov"  },
				dtl19 = { text = "伊露希亚·巴罗夫", colour = AM_RED, coords = { {75.6, 54} }, symbol = { "15" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "SCHOLOLadyIlluciaBarov" },
				dtl20 = { text = "黑暗院长加丁", colour = AM_RED, coords = { {76.2, 74.4} }, symbol = { "16" },
						tooltiptxt = "Lvl61 精英人形生物", lootid = "SCHOLODarkmasterGandling", leaveGap = 1 },
				dtl21 = { text = "火炬", colour = AM_GREEN, coords = { {89, 19} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl22 = { text = "炼金实验室", colour = AM_GREEN, coords = { {14, 70} }, symbol = { "AL" },
						tooltiptxt = "", leaveGap = 1 },
				dtl23 = { text = "南海镇地契", colour = AM_ORANGE, coords = { {56, 25} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl24 = { text = "塔伦米尔地契", colour = AM_ORANGE, coords = { {11, 36} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl25 = { text = "布瑞尔地契	", colour = AM_ORANGE, coords = { {15, 77} }, symbol = { "D" },
						tooltiptxt = ""  },
				dtl26 = { text = "凯尔达隆地契", colour = AM_ORANGE, coords = { {94, 72} }, symbol = { "D" },
						tooltiptxt = "Lvl60 精英人形生物", leaveGap = 1},
			},

			{	name = "斯坦索姆",			-- Stratholme
				type = AM_TYP_INSTANCE,
				displayname = "斯坦索姆",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Stratholme",
				location = "东瘟疫之地 (30, 12)",
				levels = "55-60",
				players = "5",
				prereq = "",
				general = "旁门入口在 EP (47, 24)",
				dtl1  = { text = "正门入口", colour = AM_GREEN, coords = { {50, 91} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "旁门入口", colour = AM_GREEN, coords = { {83, 72} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "弗拉斯·希亚比的邮箱", colour = AM_ORANGE, coords = { {37, 86} }, symbol = { "P1" },
						tooltiptxt = "" },
				dtl4  = { text = "国王广场邮箱", colour = AM_ORANGE, coords = { {47, 74} }, symbol = { "P2" },
						tooltiptxt = "" },
				dtl5  = { text = "十字军广场邮箱", colour = AM_ORANGE, coords = { {24, 66} }, symbol = { "P3" },
						tooltiptxt = "" },
				dtl6  = { text = "市场邮箱", colour = AM_ORANGE, coords = { {50, 62} }, symbol = { "P4" },
						tooltiptxt = ""  },
				dtl7  = { text = "节日小道的邮箱", colour = AM_ORANGE, coords = { {61, 62} }, symbol = { "P5" },
						tooltiptxt = ""  },
				dtl8  = { text = "长者广场邮箱", colour = AM_ORANGE, coords = { {80, 68} }, symbol = { "P6" },
						tooltiptxt = "" },
				dtl9  = { text = "邮差马龙", colour = AM_RED, coords = { {37, 86}, {47, 74}, {24, 66}, {50, 62}, {61, 62}, {80, 68} }, symbol = { " " },
						tooltiptxt = "Lvl60 精英亡灵\n打开第三个邮箱时召唤出来\n邮箱钥匙掉落自信使", leaveGap = 1 },
				dtl10 = { text = "斯库尔", colour = AM_RED, coords = { {42, 83} }, symbol = { "1" },
						tooltiptxt = "Lvl58 精英亡灵", special = AM_RARE.." "..AM_WANDERS, lootid = "STRATSkull" },
				dtl11 = { text = "斯坦索姆信使", colour = AM_RED, coords = { {43, 78} }, symbol = { "2" },
						tooltiptxt = "Lvl57 精英亡灵", lootid = "STRATStratholmeCourier"  },
				dtl12 = { text = "弗拉斯·希亚比", colour = AM_RED, coords = { {39, 83} }, symbol = { "3" },
						tooltiptxt = "Lvl61 精英亡灵", lootid = "STRATFrasSiabi"  },
				dtl13 = { text = "弗雷斯特恩", colour = AM_RED, coords = { {45, 62}, {65, 58}, {66, 66} }, symbol = { "4" },
						tooltiptxt = "Lvl57 精英亡灵\n如果任何出现在他的位置\n的食尸鬼被杀死\n则将连续刷新", special = AM_VARIES, lootid = "STRATHearthsingerForresten" },
				dtl14 = { text = "不可宽恕者", colour = AM_RED, coords = { {56, 57} }, symbol = { "5" },
						tooltiptxt = "Lvl57 精英亡灵", lootid = "STRATTheUnforgiven"  },
				dtl15 = { text = "悲惨的提米", colour = AM_RED, coords = { {26, 61.5} }, symbol = { "6" },
						tooltiptxt = "Lvl58 精英亡灵", lootid = "STRATTimmytheCruel"  },
				dtl16 = { text = "炮手威利", colour = AM_RED, coords = { {1, 74} }, symbol = { "7" },
						tooltiptxt = "Lvl60 精英人形生物", lootid = "STRATCannonMasterWilley"  },
				dtl17 = { text = "档案管理员加尔福特", colour = AM_RED, coords = { {24, 92} }, symbol = { "8" },
						tooltiptxt = "Lvl60 精英人形生物", lootid = "STRATArchivistGalford"  },
				dtl18 = { text = "巴纳扎尔", colour = AM_RED, coords = { {17, 97} }, symbol = { "9" },
						tooltiptxt = "Lvl62 精英恶魔", lootid = "STRATBalnazzar"  },
				dtl19 = { text = "索托斯", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "需要亚雷恩 & 索托斯的召唤火盆", lootid = "STRATSothosJarien" },
				dtl20 = { text = "亚雷恩", colour = AM_RED, coords = { {17, 97} }, symbol = { " " },
						tooltiptxt = "需要亚雷恩 & 索托斯的召唤火盆", lootid = "STRATSothosJarien" },
				dtl21 = { text = "奥里克斯", colour = AM_BLUE, coords = { {81, 61} }, symbol = { "10" },
						tooltiptxt = ""  },
				dtl22 = { text = "石脊", colour = AM_RED, coords = { {78, 42} }, symbol = { "11" },
						tooltiptxt = "Lvl60 精英亡灵", special = AM_RARE, lootid = "STRATStonespine"  },
				dtl23 = { text = "安娜丝塔丽男爵夫人", colour = AM_RED, coords = { {90, 39} }, symbol = { "12" },
						tooltiptxt = "Lvl59 精英亡灵", lootid = "STRATBaronessAnastari"  },
				dtl24 = { text = "奈鲁布恩坎", colour = AM_RED, coords = { {64, 39} }, symbol = { "13" },
						tooltiptxt = "Lvl60 精英亡灵", lootid = "STRATNerubenkan"  },
				dtl25 = { text = "苍白的玛勒基", colour = AM_RED, coords = { {81, 14} }, symbol = { "14" },
						tooltiptxt = "Lvl61 精英人形生物", lootid = "STRATMalekithePallid"  },
				dtl26 = { text = "巴瑟拉斯镇长", colour = AM_RED, coords = { {66, 10}, {74, 60} }, symbol = { "15" },
						tooltiptxt = "Lvl58 精英亡灵", special = AM_VARIES, lootid = "STRATMagistrateBarthilas" },
				dtl27 = { text = "吞咽者拉姆斯登", colour = AM_RED, coords = { {56, 15} }, symbol = { "16" },
						tooltiptxt = "Lvl61 精英亡灵", lootid = "STRATRamsteintheGorger"  },
				dtl28 = { text = "瑞文戴尔男爵", colour = AM_RED, coords = { {42, 15} }, symbol = { "17" },
						tooltiptxt = "Lvl62 精英亡灵", lootid = "STRATBaronRivendare", leaveGap = 1 }
			},

			{	name = "影牙城堡",			-- Shadowfang Keep
				type = AM_TYP_INSTANCE,
				displayname = "影牙城堡",
				displayshort = "SFK",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowfangKeep",
				location = "银松森林 (45, 67)",
				levels = "20-30",
				players = "10",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {75, 69} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_GOLD, coords = { {57, 57}, {36, 55}, {29, 12} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "" },
				dtl3  = { text = "碉堡", colour = AM_BLUE, coords = { {38, 71}, {54, 93} }, symbol = { "B1" },
						tooltiptxt = "" },
				dtl4  = { text = "碉堡", colour = AM_BLUE, coords = { {69, 85}, {35, 37} }, symbol = { "B2" },
						tooltiptxt = "" },
				dtl5  = { text = "死亡之誓", colour = AM_RED, coords = { {69, 85}, {35, 37} }, symbol = { " " },
						tooltiptxt = "Lvl25 精英亡灵", special = AM_RARE  },
				dtl6  = { text = "楼梯", colour = AM_GREEN, coords = { {29.8, 34.8}, {50, 46.8} }, symbol = { "S1" },
						tooltiptxt = "" },
				dtl7  = { text = "楼梯", colour = AM_GREEN, coords = { {42, 32}, {67, 33} }, symbol = { "S2" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "雷希戈尔", colour = AM_RED, coords = { {70, 78} }, symbol = { "1" },
						tooltiptxt = "Lvl20 精英人形生物\n牢房看守" },
				dtl9  = { text = "巫师阿克鲁比", colour = AM_RED, coords = { {67, 73} }, symbol = { "2" },
						tooltiptxt = "Lvl18 精英人形生物"  },
				dtl10 = { text = "亡灵哨兵阿达曼特", colour = AM_RED, coords = { {71, 74} }, symbol = { "3" },
						tooltiptxt = "Lvl18 精英人形生物"  },
				dtl11 = { text = "夫拉佐克劳", colour = AM_RED, coords = { {25, 59} }, symbol = { "4" },
						tooltiptxt = "Lvl22 精英人形生物", lootid = "BSFRazorclawtheButcher"  },
				dtl12 = { text = "席瓦莱恩男爵", colour = AM_RED, coords = { {13, 87} }, symbol = { "5" },
						tooltiptxt = "Lvl24 精英亡灵", lootid = "BSFSilverlaine" },
				dtl13 = { text = "指挥官斯普林瓦尔", colour = AM_RED, coords = { {26, 69} }, symbol = { "6" },
						tooltiptxt = "Lvl24 精英亡灵", lootid = "BSFSpringvale"  },
				dtl14 = { text = "盲眼守卫奥杜", colour = AM_RED, coords = { {61, 84} }, symbol = { "7" },
						tooltiptxt = "Lvl24 精英人形生物", lootid = "BSFOdotheBlindwatcher"  },
				dtl15 = { text = "吞噬者芬鲁斯", colour = AM_RED, coords = { {53.4, 33.4} }, symbol = { "8" },
						tooltiptxt = "Lvl25 精英野兽", lootid = "BSFFenrustheDevourer"  },
				dtl16 = { text = "狼王南杜斯", colour = AM_RED, coords = { {80, 29} }, symbol = { "9" },
						tooltiptxt = "Lvl25 精英人形生物", lootid = "BSFWolfMasterNandos"  },
				dtl17 = { text = "大法师阿鲁高", colour = AM_RED, coords = { {84, 13} }, symbol = { "10" },
						tooltiptxt = "Lvl26 精英人形生物", lootid = "BSFArchmageArugal", leaveGap = 1 },
				dtl18 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BSFTrash", leaveGap = 1 }
			},

			{	name = "地狱火堡垒 - 地狱火城墙",		-- Hellfire Ramparts
				type = AM_TYP_INSTANCE,
				displayname = "地狱火堡垒 - 地狱火城墙",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCRampart",			-- HellfireRampart
				location = "地狱火半岛",
				levels = "60-62",
				players = "20",
				prereq = "钥匙：焰铸钥匙 (英雄模式)",
				general = "阵营：萨尔玛 (部落)\n阵营：荣耀堡 (联盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {62, 63} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "巡视者加戈玛", colour = AM_RED, coords = { {80, 24} }, symbol = { "1" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "HCRampWatchkeeper" },
				dtl3  = { text = "无疤者奥摩尔", colour = AM_RED, coords = { {22, 14} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCRampOmor" },
				dtl4  = { text = "传令官瓦兹德", colour = AM_RED, coords = { {16, 81} }, symbol = { "3" },
						tooltiptxt = "Kill both hellfire sentry to start encounter", lootid = "HCRampVazruden" },
				dtl5  = { text = "纳杉", colour = AM_RED, coords = { {16, 81} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampNazan", leaveGap = 1 },
				dtl6  = { text = "强化魔铁箱", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "HCRampFelIronChest", leaveGap = 1 }
			},
	
			{	name = "地狱火堡垒 - 鲜血熔炉",		-- The Blood Furnace
				type = AM_TYP_INSTANCE,
				displayname = "地狱火堡垒 - 鲜血熔炉",
				displayshort = "BF",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCBloodFurnace",		-- HCBloodFurnace
				location = "地狱火半岛",
				levels = "61-63",
				players = "20",
				prereq = "钥匙：焰铸钥匙 (英雄模式)",
				general = "阵营：萨尔玛 (部落)\n阵营：荣耀堡 (联盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {50, 91.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "制造者", colour = AM_RED, coords = { {29.3, 35} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCFurnaceMaker" },
				dtl3  = { text = "布洛戈克", colour = AM_RED, coords = { {41, 13.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCFurnaceBroggok" },
				dtl4  = { text = "击碎者克里丹", colour = AM_RED, coords = { {65.6, 35.2} }, symbol = { "3" },
						tooltiptxt = "", lootid = "HCFurnaceBreaker", leaveGap = 1 }
			},
	
			{	name = "地狱火堡垒 - 破碎大厅",		-- Shattered Halls
				type = AM_TYP_INSTANCE,
				displayname = "地狱火堡垒 - 破碎大厅",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\HCShatteredHalls",		-- HCShatteredHalls
				location = "地狱火半岛",
				levels = "70-72",
				players = "20",
				prereq = "钥匙：焰铸钥匙 (英雄模式)",
				general = "阵营：萨尔玛 (部落)\n阵营：荣耀堡 (联盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {67, 97.66} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "兰迪·维兹普罗克", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { "1" },
						tooltiptxt = "", special = "(联盟, 英雄模式)" },
				dtl3  = { text = "德雷希拉", colour = AM_RED, coords = { {23.63, 74.8} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄模式)" },
				dtl4  = { text = "高阶术士奈瑟库斯", colour = AM_RED, coords = { {23.63, 66.02} }, symbol = { "2" },
						tooltiptxt = "", lootid = "HCHallsNethekurse" },
				dtl5  = { text = "血卫士伯鲁恩", colour = AM_RED, coords = { {15.23, 10.55} }, symbol = { "3" },
						tooltiptxt = "", special = "(英雄模式)", lootid = "HCHallsPorung" },
				dtl6  = { text = "战争使者沃姆罗格", colour = AM_RED, coords = { {57.42, 33.79} }, symbol = { "4" },
						tooltiptxt = "", lootid = "HCHallsOmrogg" },
				dtl7  = { text = "酋长卡加斯·刃拳", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { "5" },
						tooltiptxt = "", lootid = "HCHallsKargath" },
				dtl8  = { text = "碎手斩杀者", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(英雄模式)", lootid = "HCHallsExecutioner" },
				dtl9  = { text = "列兵亚森特", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(联盟, 英雄模式)" },
				dtl10 = { text = "火枪手布隆恩·棕须", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(联盟, 英雄模式)" },
				dtl11 = { text = "奥琳娜上尉", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(联盟, 英雄模式)" },
				dtl12 = { text = "斥候奥贾尔", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄模式)" },
				dtl13 = { text = "克拉格·傲鬃", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄模式)" },
				dtl14 = { text = "沙塔·碎骨上尉", colour = AM_RED, coords = { {80.86, 57.81} }, symbol = { " " },
						tooltiptxt = "", special = "(部落, 英雄模式)", leaveGap = 1 },
				dtl15 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }
			},

			{	name = "地狱火堡垒 - 玛瑟里顿的巢穴",		-- Magtheridon's Lair
				type = AM_TYP_INSTANCE,
				displayname = "地狱火堡垒 - 玛瑟里顿的巢穴",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagtheridonsLair",		-- MagtheridonsLair
				location = "地狱火半岛",
				levels = "70",
				players = "40",
				prereq = "钥匙：焰铸钥匙 (英雄模式)",
				general = "阵营：萨尔玛 (部落)\n阵营：荣耀堡 (联盟)",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.44, 14.26} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "玛瑟里顿", colour = AM_PURPLE, coords = { {53.13, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "HCMagtheridon", leaveGap = 1 },
				dtl3  = { text = AM_TIER4_SET, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "T4SET", leaveGap = 1 }
			},
	
			{	name = "盘牙水库 - 奴隶围栏",		-- The Slave Pens
				type = AM_TYP_INSTANCE,
				displayname = "盘牙水库 - 奴隶围栏",
				displayshort = "SP",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSlavePens",		-- TheSlavePens
				location = "赞加沼泽",
				levels = "62-64",
				players = "20",
				prereq = "钥匙：水库钥匙 (英雄模式)",
				general = "阵营：塞纳里奥远征队",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {23.24, 21.29} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盘牙水库"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "背叛者门努", colour = AM_RED, coords = { {48.83, 31.84} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSlaveMennu" },
				dtl3  = { text = "除草者格林萨姆", colour = AM_RED, coords = { {48.83, 71.29} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "异教徒斯卡希斯", colour = AM_RED, coords = { {58.2, 72.66} }, symbol = { "3" },
						tooltiptxt = "", special = "(英雄模式)" },
				dtl5  = { text = "巨钳鲁克玛尔", colour = AM_RED, coords = { {57.81, 41.99} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSlaveRokmar" },
				dtl6  = { text = "博学者拜特", colour = AM_RED, coords = { {96.09, 61.13} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl7  = { text = "夸格米拉", colour = AM_RED, coords = { {80.86, 72.27} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSlaveQuagmirran" }

			},
	
			{	name = "盘牙水库 - 幽暗沼泽",			-- The Underbog
				type = AM_TYP_INSTANCE,
				displayname = "盘牙水库 - 幽暗沼泽",
				displayshort = "",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheUnderbog",		-- TheUnderbog
				location = "赞加沼泽",
				levels = "63-65",
				players = "20",
				prereq = "钥匙：水库钥匙 (英雄模式)",
				general = "阵营：塞纳里奥远征队",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {120, 346} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盘牙水库"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "霍加尔芬", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRUnderHungarfen" },
				dtl3  = { text = "幽暗孢子", colour = AM_RED, coords = { {71.09, 83.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "加兹安", colour = AM_RED, coords = { {81.84, 34.18} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRUnderGhazan" },
				dtl5  = { text = "缚地者雷葛", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl6  = { text = "唤风者克劳恩", colour = AM_RED, coords = { {69.53, 28.91} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "沼地领主穆塞雷克", colour = AM_RED, coords = { {39.84, 30.27} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRUnderSwamplord" },
				dtl8  = { text = "黑色阔步者", colour = AM_RED, coords = { {21.09, 45.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRUnderStalker", leaveGap = 1 }
			},
	
			{	name = "盘牙水库 - 蒸汽地窟",			-- The Steamvault
				type = AM_TYP_INSTANCE,
				displayname = "盘牙水库 - 蒸汽地窟",
				displayshort = "SV",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheSteamvault",			-- The Steamvault
				location = "赞加沼泽",
				levels = "70-72",
				players = "20",
				prereq = "钥匙：水库钥匙 (英雄模式)",
				general = "阵营：塞纳里奥远征队",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 35.74} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盘牙水库"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "水术师瑟丝比娅", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { "1" },
						tooltiptxt = "Elite Lvl 72", lootid = "CFRSteamThespia" },
				dtl3  = { text = "主厅控制面板", colour = AM_RED, coords = { {54.3, 17.19} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "第二块碎片的守护者", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSteamSecondFragmentGuardian" },
				dtl5  = { text = "奥术容器", colour = AM_RED, coords = { {52.54, 25.59} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = "机械师斯蒂里格", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSteamSteamrigger" },
				dtl7  = { text = "主厅控制面板", colour = AM_RED, coords = { {23.05, 80.08} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "督军卡利瑟里斯", colour = AM_RED, coords = { {92.19, 43.95} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSteamWarlord" },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSteamTrash" }

			},
	
			{	name = "盘牙水库 - 毒蛇神殿",			-- SerpentShrine Cavern
				type = AM_TYP_INSTANCE,
				displayname = "盘牙水库 - 毒蛇神殿",
				displayshort = "SC",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SerpentShrine",			-- SerpentshrineCavern
				location = "赞加沼泽",
				levels = "70",
				players = "40",
				prereq = "",
				general = "阵营：塞纳里奥远征队",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {1.56, 67.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "盘牙水库"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "不稳定的海度斯", colour = AM_RED, coords = { {37.89, 75} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CFRSerpentHydross" },
				dtl3  = { text = "鱼斯拉", colour = AM_RED, coords = { {40.82, 54.1} }, symbol = { "2" },
						tooltiptxt = "", lootid = "CFRSerpentLurker" },
				dtl4  = { text = "盲眼者莱欧瑟拉斯", colour = AM_RED, coords = { {43.75, 27.15} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CFRSerpentLeotheras" },
				dtl5  = { text = "深水领主卡拉瑟雷斯", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { "4" },
						tooltiptxt = "", lootid = "CFRSerpentKarathress" },
				dtl6  = { text = "先知奥鲁姆", colour = AM_RED, coords = { {49.22, 17.77} }, symbol = { " " },
						tooltiptxt = "" },
				dtl7  = { text = "莫洛格里·踏潮者", colour = AM_RED, coords = { {66.02, 28.52} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CFRSerpentMorogrim" },
				dtl8  = { text = "瓦丝琪", colour = AM_RED, coords = { {81.64, 55.47} }, symbol = { "6" },
						tooltiptxt = "", lootid = "CFRSerpentVashj", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "CFRSerpentTrash" }
			},
	
			{	name = "奥金顿 - 奥金尼地穴",			-- Auchenai Crypts
				type = AM_TYP_INSTANCE,
				displayname = "奥金顿 - 奥金尼地穴",
				displayshort = "AC",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\AuchenaiCrypts",			-- AuchenaiCrypts
				location = "白骨荒野，泰罗卡森林",
				levels = "64-66",
				players = "20",
				prereq = "钥匙：奥金尼钥匙 (英雄模式)",
				general = "阵营：贫民窟",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {22, 79.1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奥金顿"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "死亡观察者希尔拉克", colour = AM_RED, coords = { {44, 70} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchCryptsShirrak" },
				dtl3  = { text = "大主教玛拉达尔", colour = AM_RED, coords = { {88, 49} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchCryptsExarch" },
				dtl4  = { text = "殉难者的化身", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsAvatar" },
				dtl5  = { text = "德欧里", colour = AM_RED, coords = { {88, 49} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchCryptsTrash" }
			},
	
			{	name = "奥金顿 - 暗影迷宫",			-- Shadow Labyrinth
				type = AM_TYP_INSTANCE,
				displayname = "奥金顿 - 暗影迷宫",
				displayshort = "SL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ShadowLabyrinth",			-- ShadowLabyrinth
				location = "白骨荒野，泰罗卡森林",
				levels = "65-67",
				players = "20",
				prereq = "钥匙：暗影迷宫钥匙\n钥匙：奥金尼钥匙 (英雄模式)",
				general = "阵营：贫民窟",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {6, 8.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奥金顿"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "间谍托古恩", colour = AM_RED, coords = { {14, 44} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl3  = { text = "赫尔默大使", colour = AM_RED, coords = { {14, 44} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchShadowHellmaw" },
				dtl4  = { text = "煽动者布莱卡特", colour = AM_RED, coords = { {20, 73} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchShadowBlackheart" },
				dtl5  = { text = "沃匹尔大师", colour = AM_RED, coords = { {55, 59} }, symbol = { "4" },
						tooltiptxt = "鲜血法典", lootid = "AuchShadowGrandmaster" },
				dtl6  = { text = "摩摩尔", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchShadowMurmur" },
				dtl7  = { text = "第一块碎片的守护者", colour = AM_RED, coords = { {90.1, 44} }, symbol = { "6" },
						tooltiptxt = "", lootid = "AuchShadowFirstFragmentGuardian" },
				dtl8  = { text = "奥术容器", colour = AM_RED, coords = { {90.38, 37.7} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchShadowTrash" }
			},
	
			{	name = "奥金顿 - 塞泰克大厅",				-- Sethekk Halls
				type = AM_TYP_INSTANCE,
				displayname = "奥金顿 - 塞泰克大厅",
				displayshort = "SH",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SethekkHalls",			-- SethekkHalls
				location = "白骨荒野，泰罗卡森林",
				levels = "67-69",
				players = "20",
				prereq = "钥匙：奥金尼钥匙 (英雄模式)\n钥匙：灌注精华的月亮石 (安苏)",
				general = "阵营：贫民窟",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {98, 46} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奥金顿"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "黑暗编织者塞斯", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchSethekkDarkweaver" },
				dtl3  = { text = "拉卡", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "泰罗克的传说", colour = AM_RED, coords = { {47.3, 64} }, symbol = { "2" },
						tooltiptxt = "", lootid = "AuchSethekkTheSagaofTerokk" },
				dtl5  = { text = "安苏", colour = AM_RED, coords = { {47.3, 64} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkRavenGod", special = "(召唤, 英雄模式)" },
				dtl6  = { text = "利爪之王艾吉斯", colour = AM_RED, coords = { {20, 18.5} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchSethekkTalonKing", leaveGap = 1 },
				dtl7 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchSethekkTrash" }
			},
	
			{	name = "奥金顿 - 法力陵墓",				-- Mana Tombs
				type = AM_TYP_INSTANCE,
				displayname = "奥金顿 - 法力陵墓",
				displayshort = "MT",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ManaTombs",				-- ManaTombs
				location = "白骨荒野，泰罗卡森林",
				levels = "70-72",
				players = "40",
				prereq = "钥匙：奥金尼钥匙 (英雄模式)\n钥匙：哈拉迈德之眼 (崇拜, 尤尔)",
				general = "阵营：星界财团",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 4.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "奥金顿"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "潘德莫努斯", colour = AM_RED, coords = { {46, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "AuchManaPandemonius" },
				dtl3  = { text = "暗影领主希拉卡希斯", colour = AM_RED, coords = { {46, 30} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "帕克希维大使", colour = AM_RED, coords = { {71.29, 16.41} }, symbol = { "2" },
						tooltiptxt = "", special = "(英雄模式)" },
				dtl5  = { text = "塔瓦洛克", colour = AM_RED, coords = { {71, 76} }, symbol = { "3" },
						tooltiptxt = "", lootid = "AuchManaTavarok" },
				dtl6  = { text = "低温工程师沙赫恩", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl7  = { text = "虚灵传送器控制台", colour = AM_RED, coords = { {42.58, 87.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "节点亲王沙法尔", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "AuchManaNexusPrince" },
				dtl9  = { text = "尤尔", colour = AM_RED, coords = { {40.5, 84.5} }, symbol = { " " },
						tooltiptxt = "静止间", special = "(召唤, 英雄模式)", lootid = "AuchManaYor", leaveGap = 1 },
				dtl10 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "AuchManaTrash" }
			},

			{	name = "格鲁尔的巢穴",				-- Gruul's Lair
				type = AM_TYP_INSTANCE,
				displayname = "格鲁尔的巢穴",
				displayshort = "GL",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\GruulsLair",			-- GruulsLair
				location = "刀锋山",
				levels = "70",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {0, 0} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "莫加尔大王", colour = AM_RED, coords = { {55, 48} }, symbol = { "1" },
						tooltiptxt = "Boss", lootid = "GruulsLairHighKingMaulgar" },
				dtl3  = { text = "疯狂的基戈尔", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(萨满祭司)" },
				dtl4  = { text = "克洛什·火拳", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(法师)" },
				dtl5  = { text = "盲眼先知", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(牧师)" },
				dtl6  = { text = "召唤者沃尔姆", colour = AM_RED, coords = { {55, 48} }, symbol = { " " },
						tooltiptxt = "", special = "(牧师)" },
				dtl7  = { text = "屠龙者格鲁尔", colour = AM_RED, coords = { {20, 27} }, symbol = { "2" },
						tooltiptxt = "", lootid = "GruulGruul", leaveGap = 1 },
			},
	
			{	name = "黑暗神殿",				-- Black Temple
				type = AM_TYP_INSTANCE,
				displayname = "黑暗神殿",
				displayshort = "BT",
				continent = 3,
--				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Placeholder",
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackTemple",			-- BlackTemple
				location = "影月谷",
				levels = "70",
				players = "40",
				prereq = "需要完成入口任务\n钥匙：卡拉波勋章",
				general = "阵营：灰舌死誓者",
				dtl1  = { text = "黑暗神殿 (入门)", colour = AM_ORANGE, coords = { {5.27, 32.03} }, symbol = { "-" },
						tooltiptxt = "" },
				dtl2  = { text = "黑暗神殿 (顶层)", colour = AM_ORANGE, coords = { {49.61, 5.66} }, symbol = { "^" },
						tooltiptxt = "" },
				dtl3  = { text = "黑暗神殿 (底层)", colour = AM_ORANGE, coords = { {63.87, 60.74} }, symbol = { "v" },
						tooltiptxt = "", leaveGap = 1 },
				dtl4  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {7.62, 77.34} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
	            dtl5  = { text = "奥鲁姆之魂", colour = AM_BLUE, coords = { {7.23, 72.07} }, symbol = { "1" },
						tooltiptxt = "", lootid = "BTNajentus" },
	            dtl6  = { text = "高阶督军纳因图斯", colour = AM_RED, coords = { {24.8, 56.25} }, symbol = { "2" },
						tooltiptxt = "", lootid = "BTNajentus" },
				dtl7  = { text = "苏普雷姆斯", colour = AM_RED, coords = { {21.29, 45.12} }, symbol = { "3" },
						tooltiptxt = "", lootid = "BTSupremus" },
	            dtl8  = { text = "阿卡玛之影", colour = AM_RED, coords = { {33.59, 63.09} }, symbol = { "4" },
						tooltiptxt = "", lootid = "BTAkama" },
	            dtl9  = { text = "乌达鲁之魂", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { "5" },
						tooltiptxt = "" },
	            dtl10 = { text = "奥鲁尤", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(材料商)" },
	            dtl11 = { text = "沃库诺", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", special = "(灰舌死誓者军需官)" },
	            dtl12 = { text = "先知坎奈", colour = AM_RED, coords = { {46.88, 44.53} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl13 = { text = "通往塔隆·血魔", colour = AM_GREEN, coords = { {48.83, 51.76}, {79.1, 78.32} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl14 = { text = "通往灵魂之匣", colour = AM_GREEN, coords = { {48.83, 37.5}, {84.18, 67.38} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl15 = { text = "通往伊利丹·怒风", colour = AM_GREEN, coords = { {23.83, 33.2}, {58.2, 10.74} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl16  = { text = "古尔图格·血沸", colour = AM_RED, coords = { {75.59, 57.23} }, symbol = { "6" },
						tooltiptxt = "", lootid = "BTBloodboil" },
				dtl17 = { text = "灵魂之匣", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { "7" },
						tooltiptxt = "", lootid = "BTEssencofSouls" },
				dtl18 = { text = "愤怒精华", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl19 = { text = "欲望精华", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "苦痛精华", colour = AM_RED, coords = { {86.52, 93.75} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "塔隆·血魔", colour = AM_RED, coords = { {59.77, 81.45} }, symbol = { "8" },
						tooltiptxt = "", lootid = "BTGorefiend" },
				dtl22 = { text = "莎赫拉丝主母", colour = AM_RED, coords = { {92.77, 4.88} }, symbol = { "9" },
						tooltiptxt = "", lootid = "BTShahraz" },
				dtl23 = { text = "伊利达雷议会", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { "10" },
						tooltiptxt = "", lootid = "BTCouncil" },
				dtl24 = { text = "女公爵玛兰德", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(牧师)" },
				dtl25 = { text = "击碎者加西奥斯", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(圣骑士)" },
				dtl26 = { text = "高阶灵术师塞勒沃尔", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(法师)" },
				dtl27 = { text = "薇尔莱丝·深影", colour = AM_RED, coords = { {79.1, 25.59} }, symbol = { " " },
						tooltiptxt = "", special = "(潜行者)" },
	            dtl28  = { text = "伊利丹·怒风", colour = AM_RED, coords = { {59.18, 36.13} }, symbol = { "11" },
						tooltiptxt = "", lootid = "BTIllidanStormrage", leaveGap = 1 },
				dtl29 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTPatterns" },
				dtl30 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "BTTrash" }
			},
	
			{	name = "风暴要塞 - 能源舰",				-- The Mechanar
				type = AM_TYP_INSTANCE,
				displayname = "风暴要塞 - 能源舰",
				displayshort = "Mech",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Mechanar",			-- TheMechanar
				location = "虚空风暴",
				levels = "69-72",
				players = "20",
				prereq = "钥匙：星船钥匙 (英雄模式)",
				general = "阵营：沙塔尔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {43, 92.5} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "看守者盖罗基尔", colour = AM_RED, coords = { {46, 56} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKMechGyro" },
				dtl3  = { text = "看守者埃隆汉", colour = AM_RED, coords = { {64.5, 52} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKMechIron" },
				dtl4  = { text = "军团储藏室", colour = AM_RED, coords = { {64.5, 52} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechCacheoftheLegion" },
				dtl5  = { text = "机械领主卡帕西图斯", colour = AM_RED, coords = { {58, 37} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKMechCapacitus" },
				dtl6  = { text = "超载的魔法晶格", colour = AM_RED, coords = { {58, 37} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechOverchargedManacell" },
				dtl7  = { text = "灵术师塞比瑟蕾", colour = AM_RED, coords = { {47, 9.9} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKMechSepethrea" },
				dtl8  = { text = "计算者帕萨雷恩", colour = AM_RED, coords = { {18.5, 47} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKMechCalc", leaveGap = 1 },
				dtl9  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKMechTrash" }
			},

			{	name = "风暴要塞 - 生态船",				-- The Botanica
				type = AM_TYP_INSTANCE,
				displayname = "风暴要塞 - 生态船",
				displayshort = "Bota",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Botanica",			-- TheBotanica
				location = "虚空风暴",
				levels = "70-72",
				players = "40",
				prereq = "钥匙：星船钥匙 (英雄模式)",
				general = "阵营：沙塔尔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {96.2, 44.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "指挥官萨拉妮丝", colour = AM_RED, coords = { {45, 30} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKBotSarannis" },
				dtl3  = { text = "高级植物学家弗雷温", colour = AM_RED, coords = { {24, 30} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKBotFreywinn" },
				dtl4  = { text = "看管者索恩格林", colour = AM_RED, coords = { {9, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKBotThorngrin" },
				dtl5  = { text = " 拉伊", colour = AM_RED, coords = { {35, 69} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKBotLaj" },
				dtl6  = { text = "迁跃扭木", colour = AM_RED, coords = { {34.5, 40} }, symbol = { "5" },
						tooltiptxt = "", lootid = "TKBotSplinter", leaveGap = 1 },
				dtl7  = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKBotTrash" }
			},

			{	name = "风暴要塞 - 禁魔监狱",				-- The Arcatraz
				type = AM_TYP_INSTANCE,
				displayname = "风暴要塞 - 禁魔监狱",
				displayshort = "Arca",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Arcatraz",			-- TheArcatraz
				location = "虚空风暴",
				levels = "70-72",
				players = "40",
				prereq = "钥匙：禁魔监狱钥匙\n钥匙：星船钥匙 (英雄模式)",
				general = "阵营：沙塔尔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {38, 98} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "自由的瑟雷凯斯", colour = AM_RED, coords = { {45.5, 58.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKArcUnbound" },
				dtl3  = { text = "自由的瑟雷凯斯", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKArcThirdFragmentGuardian" },
				dtl4  = { text = "奥术容器", colour = AM_RED, coords = { {47.46, 37.3} }, symbol = { " " },
						tooltiptxt = "" },
				dtl5  = { text = "天怒预言者苏克拉底", colour = AM_RED, coords = { {11.5, 70} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKArcScryer" },
				dtl6  = { text = "末日预言者达尔莉安", colour = AM_RED, coords = { {31, 70} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKArcDalliah" },
				dtl7  = { text = "先知乌达鲁", colour = AM_RED, coords = { {37.89, 15.04} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl8  = { text = "预言者斯克瑞斯", colour = AM_RED, coords = { {73.5, 17} }, symbol = { "6" },
						tooltiptxt = "", lootid = "TKArcHarbinger" },
				dtl9  = { text = "监护者梅里卡尔", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl10 = { text = "米尔豪斯·法力风暴", colour = AM_RED, coords = { {73.5, 17} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKArcTrash" }

			},

			{	name = "时光之穴 - 旧希尔希布莱德",				-- Old Hillsbrad
				type = AM_TYP_INSTANCE,
				displayname = "时光之穴 - 旧希尔希布莱德",
				displayshort = "CoT1",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\OldHillsbrad",			-- OldHillsbrad
				location = "塔纳利斯",
				levels = "",
				players = "",
				prereq = "需要完成入口任务\n钥匙：时光之匙 (英雄模式)",
				general = "事件：逃离敦霍尔德堡\n阵营：时光守护者",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {13, 47} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "时光之穴"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "伊洛希恩", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl3  = { text = "布拉森", colour = AM_GREEN, coords = { {13, 47} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "德拉克中尉", colour = AM_RED, coords = { {83, 64.5} }, symbol = { "1" },
						tooltiptxt = "", lootid = "CoTHillsbradDrake" },
				dtl5  = { text = " 萨尔", colour = AM_BLUE, coords = { {79.49, 57.23} }, symbol = { "2" },
						tooltiptxt = "(下层)", lootid = "CoTHillsbradDrake" },
				dtl6  = { text = "斯卡洛克上尉", colour = AM_RED, coords = { {72, 68} }, symbol = { "3" },
						tooltiptxt = "", lootid = "CoTHillsbradSkarloc" },
				dtl7  = { text = "萨尔的第二次止步", colour = AM_BLUE, coords = { {72, 68} }, symbol = { " " },
						tooltiptxt = "" },
				dtl8  = { text = "萨尔的第三次止步", colour = AM_BLUE, coords = { {47.07, 41.41} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl9  = { text = "时空猎手", colour = AM_RED, coords = { {44.5, 30.5} }, symbol = { "5" },
						tooltiptxt = "", lootid = "CoTHillsbradHunter" },
				dtl10 = { text = "萨尔的第四次止步", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(上层)" },
				dtl11 = { text = "塔蕾莎", colour = AM_BLUE, coords = { {44.5, 30.5} }, symbol = { " " },
						tooltiptxt = "(上层)" },
				dtl12 = { text = "乔纳森·雷瓦", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { "6" },
						tooltiptxt = "" },
				dtl13 = { text = "杰瑞·卡特尔", colour = AM_BLUE, coords = { {28.71, 49.02} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl14 = { text = "托马斯·杨斯", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "7" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradThomasYance" },
				dtl15 = { text = "老迈的达拉然巫师", colour = AM_BLUE, coords = { {0, 0} }, symbol = { "8" },
						tooltiptxt = "", special = AM_WANDERS, lootid = "CoTHillsbradAgedDalaranWizard", leaveGap = 1 }

			},

			{	name = "时光之穴 - 黑色沼泽",				-- The Black Morass
				type = AM_TYP_INSTANCE,
				displayname = "时光之穴 - 黑色沼泽",
				displayshort = "CoT2",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\BlackMorass",			-- The Black Morass
				location = "塔纳利斯",
				levels = "",
				players = "",
				prereq = "需要完成入口任务\n钥匙：时光之匙 (英雄模式)",
				general = "事件：开启黑暗之门\n阵营：时光守护者",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45.4, 22} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "时光之穴"..AM_EXTERIOR, special = "萨艾特", leaveGap = 1 },
				dtl2  = { text = "刷新点", colour = AM_RED, coords = { {58, 70}, {58.5, 61.5}, {41, 60.5}, {48, 52.5} }, symbol = { "P" },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "波：时空领主德亚", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第6)", lootid = "CoTMorassDeja" },
				dtl4  = { text = "波：坦普卢斯", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第12)", lootid = "CoTMorassTemporus" },
				dtl5  = { text = "波：埃欧努斯", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(第18)", lootid = "CoTMorassAeonus", leaveGap = 1 },
				dtl5  = { text = "黑暗之门", colour = AM_BLUE, coords = { {44.14, 74.22} }, symbol = { "1" },
						tooltiptxt = "", special = "麦迪文" },
			},

			{	name = "时光之穴 - 海加尔峰",			-- Battle for Mount Hyjal
				type = AM_TYP_INSTANCE,
				displayname = "时光之穴 - 海加尔峰",
				displayshort = "CoT3",
				continent = 1,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MountHyjal",			-- Battle for Mount Hyjal
				location = "塔纳利斯",
				levels = "70",
				players = "25",
				prereq = "需要完成入口任务",
				general = "事件：海加尔之战\n阵营：流沙之鳞",
				dtl1  = { text = "联盟基地", colour = AM_GREEN, coords = { {18.36, 48.83} }, symbol = { "A" },
						tooltiptxt = "", toMap = "时光之穴"..AM_EXTERIOR, special = "(吉安娜·普罗德摩尔)" },
				dtl2  = { text = "部落基地", colour = AM_GREEN, coords = { {57.23, 35.74} }, symbol = { "B" },
						tooltiptxt = "", special = "(萨尔)" },
				dtl3  = { text = "暗夜精灵基地", colour = AM_GREEN, coords = { {75.39, 44.34} }, symbol = { "C" },
						tooltiptxt = "", special = "(泰兰德·语风)", leaveGap = 1 },
	            dtl4  = { text = "雷基·冬寒", colour = AM_RED, coords = { {21.48, 46.88} }, symbol = { "1" },
						tooltiptxt = "", lootid = "MountHyjalWinterchill" },
				dtl5  = { text = "安纳塞隆", colour = AM_RED, coords = { {21.48, 50.98} }, symbol = { "2" },
						tooltiptxt = "", lootid = "MountHyjalAnetheron" },
				dtl6  = { text = "卡兹洛加", colour = AM_RED, coords = { {58.98, 32.81} }, symbol = { "3" },
						tooltiptxt = "", lootid = "MountHyjalKazrogal" },
				dtl7  = { text = "阿兹加洛", colour = AM_RED, coords = { {58.98, 38.67} }, symbol = { "4" },
						tooltiptxt = "", lootid = "MountHyjalAzgalor" },
	            dtl8  = { text = "阿克蒙德", colour = AM_RED, coords = { {83.01, 31.25} }, symbol = { "5" },
						tooltiptxt = "", lootid = "MountHyjalArchimonde" },
--				dtl9 = { text = "因多米", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = "" },
--				dtl10 = { text = "泰多姆", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
--					tooltiptxt = ""},
			},

			{	name = "卡拉赞",				-- Karazahn
				type = AM_TYP_INSTANCE,
				displayname = "卡拉赞",
				displayshort = "Kara",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\Karazahn",				-- Karazahn
				location = "逆风小径",
				levels = "70",
				players = "10",
				prereq = "需要完成入口任务\n钥匙：麦迪文的钥匙\n钥匙：黑色骨灰 (夜之魇)",
				general = "阵营：紫罗兰之眼",
				dtl1  = { text = "前门入口 1", colour = AM_GREEN, coords = { {29.88, 31.45} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉赞"..AM_EXTERIOR, leaveGap = 1 },
				dtl2  = { text = "前门入口 2", colour = AM_GREEN, coords = { {28.13, 20.31} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉赞"..AM_EXTERIOR, leaveGap = 1 },
				dtl3  = { text = "哈斯汀斯", colour = AM_BLUE, coords = { {27.93, 25.39} }, symbol = { "a" },
						tooltiptxt = "", special = "看管者" },
				dtl4  = { text = "伯特霍德", colour = AM_BLUE, coords = { {23.05, 25.98} }, symbol = { "b" },
						tooltiptxt = "", special = "门卫" },
				dtl5  = { text = "莫罗斯", colour = AM_RED, coords = { {23.05, 25.98}, {65.23, 23.24} }, symbol = { "1" },
						tooltiptxt = "", special = "(通往宴会厅的楼梯)", lootid = "KaraMoroes" },
				dtl6  = { text = "卡利亚德", colour = AM_BLUE, coords = { {23.44, 33.4} }, symbol = { "c" },
						tooltiptxt = "", special = "清洁工" },
				dtl7  = { text = "猎手阿图门", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { "2" },
						tooltiptxt = "", lootid = "KaraAttumen" },
				dtl8  = { text = "午夜", colour = AM_RED, coords = { {19.53, 33.01} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1 },
				dtl9  = { text = "库雷恩", colour = AM_BLUE, coords = { {16.02, 30.47} }, symbol = { "d" },
						tooltiptxt = "", special = "铁匠" },
				dtl10 = { text = "通往马厩上层的楼梯", colour = AM_GREEN, coords = { {18.55, 37.5} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl11 = { text = "本内特", colour = AM_BLUE, coords = { {19.53, 35.55} }, symbol = { "e" },
						tooltiptxt = "", special = "警卫", special = "上层" },
				dtl12 = { text = "埃伯洛克", colour = AM_BLUE, coords = { {74.8, 36.52} }, symbol = { "f" },
						tooltiptxt = "", special = "贵族" },
				dtl13 = { text = "", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "" },
				dtl14 = { text = "潜伏者希亚其斯", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 随机)", lootid = "KaraNamed" },
				dtl15 = { text = "蹂躏者洛卡德", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 随机)", lootid = "KaraNamed" },
				dtl16 = { text = "滑翔者沙德基斯", colour = AM_RED, coords = { {31.05, 8.79} }, symbol = { " " },
						tooltiptxt = "", special = "(稀有, 随机)", lootid = "KaraNamed", leaveGap = 1 },
				dtl17 = { text = "通往会客间的斜坡", colour = AM_GREEN, coords = { {17.77, 3.32}, {73.24, 10.16} }, symbol = { "P" },
						tooltiptxt = "", },
				dtl18 = { text = "金娜的日记", colour = AM_ORANGE, coords = { {82.52, 4.69} }, symbol = { "3" },
						tooltiptxt = "", lootid = "KaraKeannaLog" },
				dtl19 = { text = "贞节圣女", colour = AM_RED, coords = { {92.38, 16.21} }, symbol = { "4" },
						tooltiptxt = "", lootid = "KaraMaiden" },
				dtl20 = { text = "通往歌剧院正厅的楼梯", colour = AM_GREEN, coords = { {84.18, 15.04} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl21 = { text = "塞巴斯蒂安", colour = AM_BLUE, coords = { {55.08, 18.55} }, symbol = { "g" },
						tooltiptxt = "风琴手" },
				dtl22 = { text = "巴内斯", colour = AM_BLUE, coords = { {51.95, 10.35} }, symbol = { "h" },
						tooltiptxt = "舞台管理员" },
				dtl23 = { text = "歌剧院事件", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { "O" },
						tooltiptxt = "随机", lootid = "KaraOperaEvent" },
				dtl24 = { text = "绿叶仙踪", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(随机)", lootid = "KaraOperaEvent" },
				dtl25 = { text = "小红帽", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(随机)", lootid = "KaraOperaEvent" },
				dtl26 = { text = "罗密欧与朱丽叶", colour = AM_RED, coords = { {51.17, 14.26} }, symbol = { " " },
						tooltiptxt = "", special = "(随机)", lootid = "KaraOperaEvent" },
				dtl27 = { text = "楼座与露台间的斜坡", colour = AM_GREEN, coords = { {62.11, 8.79} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl28 = { text = "主宰的露台", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { "T" },
						tooltiptxt = "" },
				dtl29 = { text = "夜之魇", colour = AM_RED, coords = { {76.17, 32.81} }, symbol = { " " },
						tooltiptxt = "", special = "(Summoned)", lootid = "KaraOperaEvent" },
				dtl30 = { text = "通往破碎阶梯的通道", colour = AM_GREEN, coords = { {30.66, 24.02} }, symbol = { "P" },
						tooltiptxt = "", special = "(上层)" },
				dtl31 = { text = "破碎阶梯", colour = AM_GREEN, coords = { {18.36, 24.41} }, symbol = { "P" },
						tooltiptxt = "", special = "(上层)" },
				dtl32 = { text = "馆长", colour = AM_RED, coords = { {10.16, 35.16} }, symbol = { "5" },
						tooltiptxt = "", lootid = "KaraCurator" },
				dtl33 = { text = "通往:", colour = AM_GREEN, coords = { {13.67, 44.92}, {30.47, 68.55} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl34 = { text = "拉维恩", colour = AM_BLUE, coords = { {23.24, 69.73} }, symbol = { "i" },
						tooltiptxt = "", special = "法师" },
				dtl35 = { text = "格拉达夫", colour = AM_BLUE, coords = { {17.97, 69.34} }, symbol = { "j" },
						tooltiptxt = "", special = "术士" },
				dtl36 = { text = "卡姆希丝", colour = AM_BLUE, coords = { {16.41, 73.83} }, symbol = { "k" },
						tooltiptxt = "", special = "咒术师" },
				dtl37 = { text = "通往守护者的图书馆的斜坡", colour = AM_GREEN, coords = { {19.92, 76.56} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl38 = { text = "奇怪的书架", colour = AM_GREEN, coords = { {20.51, 66.6} }, symbol = { "P" },
						tooltiptxt = "(-> 特雷斯坦·邪蹄)" },
				dtl39 = { text = "特雷斯坦·邪蹄", colour = AM_RED, coords = { {17.19, 72.85} }, symbol = { "6" },
						tooltiptxt = "", special = "基尔里克 (小鬼)", lootid = "KaraIllhoof" },
				dtl40 = { text = "埃兰之影", colour = AM_RED, coords = { {33.2, 66.21} }, symbol = { "7" },
						tooltiptxt = "", lootid = "KaraAran" },
				dtl41 = { text = "通往观星大厅的斜坡", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(虚空幽龙)" },
				dtl42 = { text = "通往象棋大厅的斜坡", colour = AM_GREEN, coords = { {22.27, 79.49} }, symbol = { "P" },
						tooltiptxt = "", special = "(象棋事件)" },
				dtl43 = { text = "虚空幽龙", colour = AM_RED, coords = { {9.38, 65.82} }, symbol = { "8" },
						tooltiptxt = "", lootid = "KaraNetherspite" },
				dtl44 = { text = "伊萨尔", colour = AM_GREEN, coords = { {27.15, 66.21} }, symbol = { "l" },
						tooltiptxt = "", special = "(修理, 出售商品)" },
				dtl45 = { text = "通往:", colour = AM_GREEN, coords = { {26.76, 63.48}, {62.5, 39.84} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl46 = { text = "麦迪文的回音", colour = AM_BLUE, coords = { {65.04, 37.5} }, symbol = { "k" },
						tooltiptxt = "" },
				dtl47 = { text = "象棋事件", colour = AM_RED, coords = { {67.58, 34.96} }, symbol = { "9" },
						tooltiptxt = "", lootid = "KaraChess" },
				dtl48 = { text = "通往麦迪文房间的斜坡", colour = AM_GREEN, coords = { {63.09, 29.88} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl49 = { text = "通往虚空异界的楼梯", colour = AM_GREEN, coords = { {81.64, 32.62} }, symbol = { "P" },
						tooltiptxt = "", special = "(王子)" },
				dtl50 = { text = "玛克扎尔王子", colour = AM_RED, coords = { {76.37, 31.05} }, symbol = { "10" },
						tooltiptxt = "", special = "Leads to...", lootid = "KaraPrince" },
			},

			{	name = "祖阿曼",				-- Zul'Aman
				type = AM_TYP_INSTANCE,
				displayname = "祖阿曼",
				displayshort = "ZA",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\ZulAman",				-- Zul'Aman
				location = "幽魂之地",
				levels = "70",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {18, 53} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "纳洛拉克", colour = AM_RED, coords = { {36.3, 71.9} }, symbol = { "1" },
						tooltiptxt = "", special = "(野熊)", lootid = "ZANalorakk" },
				dtl3  = { text = "埃基尔松", colour = AM_RED, coords = { {31.25, 31.25} }, symbol = { "2" },
						tooltiptxt = "", special = "(雄鹰)", lootid = "ZAAkilZon" },
				dtl4  = { text = "加亚莱", colour = AM_RED, coords = { {53.3, 67.2} }, symbol = { "3" },
						tooltiptxt = "", special = "(龙鹰)", lootid = "ZAJanAlai" },
				dtl5  = { text = "哈尔拉兹", colour = AM_RED, coords = { {56.05, 36.62} }, symbol = { "4" },
						tooltiptxt = "", special = "(山猫)", lootid = "ZAHalazzi" },
				dtl6  = { text = "妖术领主玛拉卡斯", colour = AM_RED, coords = { {68.75, 54.9} }, symbol = { "5" },
						tooltiptxt = "", lootid = "ZAMalacrass" },
				dtl7  = { text = "祖尔金", colour = AM_RED, coords = { {91.4, 54.7} }, symbol = { "6" },
						tooltiptxt = "", lootid = "ZAZuljin", leaveGap = 1 },
			},
--71
			{	name = "风暴之眼",				-- The Eye
				type = AM_TYP_INSTANCE,
				displayname = "风暴要塞 - 风暴之眼",
				displayshort = "Eye",
				continent = 3,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\TheEye",			-- TheEye
				location = "风暴要塞",
				levels = "69-72",
				players = "5",
				prereq = "钥匙：风暴钥匙",
				general = "阵营：沙塔尔",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {45, 93} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "奥", colour = AM_RED, coords = { {50, 57} }, symbol = { "1" },
						tooltiptxt = "", lootid = "TKEyeAlar" },
				dtl3  = { text = "空灵机甲", colour = AM_RED, coords = { {14, 47} }, symbol = { "2" },
						tooltiptxt = "", lootid = "TKEyeVoidReaver" },
				dtl4  = { text = "大星术师索兰莉安", colour = AM_RED, coords = { {86, 47} }, symbol = { "3" },
						tooltiptxt = "", lootid = "TKEyeSolarian" },
				dtl5  = { text = "凯尔萨斯·逐日者", colour = AM_RED, coords = { {50, 13} }, symbol = { "4" },
						tooltiptxt = "", lootid = "TKEyeKaelthas" },
				dtl6  = { text = "亵渎者萨拉德雷", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(战士)" },
				dtl7  = { text = "首席技师塔隆尼库斯", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(猎人)" },
				dtl8  = { text = "星术师卡波妮娅", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", speical = "(法师)" },
				dtl9  = { text = "萨古纳尔男爵", colour = AM_RED, coords = { {50, 13} }, symbol = { " " },
						tooltiptxt = "", special = "(圣骑士)", leaveGap = 1 },
				dtl10 = { text = "Legendary", colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeLegendaries" },
				dtl11 = { text = AM_MOB_LOOT, colour = AM_BLUE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", lootid = "TKEyeTrash" },
			},

			{	name = "魔导师平台",				-- Magister's Terrace
				type = AM_TYP_INSTANCE,
				displayname = "魔导师平台",
				displayshort = "MagT",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\MagistersTerrace",			-- Magister's Terrace
				location = "奎尔丹纳斯岛",
				levels = "69-72",
				players = "5",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {42.19, 78.32} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "塞林·火心", colour = AM_RED, coords = { {42.19, 26.17} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SMTFireheart" },
--			dtl3  = { text = "Fel Crystals", colour = AM_ORANGE, coords = { {43.36, 37.5}, {43.36, 50.2}, {42.19, 29.88}, {50.39, 50.2}, {50.39, 37.5} }, symbol = { "C" },
				dtl3  = { text = "邪能水晶", colour = AM_ORANGE, coords = { {42.19, 26.17} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "塔雷斯", colour = AM_GREEN, coords = { {59.96, 29.88} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "维萨鲁斯", colour = AM_RED, coords = { {83.4, 31.84} }, symbol = { "3" },
						tooltiptxt = "", lootid = "SMTVexallus" },
				dtl6  = { text = "占卜宝珠", colour = AM_GREEN, coords = { {94.53, 31.64} }, symbol = { "4" },
						tooltiptxt = "", special = "(卡雷苟斯)" },
				dtl7  = { text = "女祭司德莉希亚", colour = AM_RED, coords = { {38.67, 52.54} }, symbol = { "5" },
						tooltiptxt = "", special = "(下层)", lootid = "SMTDelrissa" },
				dtl8  = { text = "凯尔萨斯·逐日者", colour = AM_RED, coords = { {6.05, 48.24} }, symbol = { "6" },
						tooltiptxt = "", lootid = "SMTKaelthas", leaveGap = 1 },
				dtl9 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SMTTrash" },
			},

			{	name = "Plateau du Puits de soleil",				-- Sunwell Plateau
				type = AM_TYP_INSTANCE,
				displayname = "Plateau du Puits de soleil",
				displayshort = "SunP",
				continent = 2,
				filename = "Interface\\AddOns\\AlphaMap_Instances\\Maps\\SunwellPlateau",			-- Sunwell Plateau
				location = "奎尔丹纳斯岛",
				levels = "69-72",
				players = "40",
				prereq = "",
				general = "",
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {31.45, 17.19} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "卡雷苟斯", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { "1" },
						tooltiptxt = "", lootid = "SPKalecgos" },
				dtl3  = { text = "腐蚀者萨索瓦尔", colour = AM_RED, coords = { {30.08, 32.03} }, symbol = { " " },
						tooltiptxt = "" },
				dtl4  = { text = "玛蒂苟萨", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl5  = { text = "布鲁塔卢斯", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPBrutallus" },
				dtl6  = { text = "菲米丝", colour = AM_RED, coords = { {64.45, 60.55} }, symbol = { " " },
						tooltiptxt = "", lootid = "SPFelmyst" },
				dtl7  = { text = "???", colour = AM_GREEN, coords = { {74.41, 33.2} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl8  = { text = "艾瑞达双子", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { "4" },
						tooltiptxt = "", special = "(下层)", lootid = "SPEredarTwins" },
				dtl9  = { text = "高阶术士奥蕾塞丝", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(下层)" },
				dtl10 = { text = "萨洛拉丝女王", colour = AM_RED, coords = { {58.79, 16.99} }, symbol = { " " },
						tooltiptxt = "", special = "(下层)" },
				dtl11 = { text = "穆鲁", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { "5" },
						tooltiptxt = "", special = "(上层)" },
				dtl12 = { text = "熵魔", colour = AM_GREEN, coords = { {61.72, 20.12} }, symbol = { " " },
						tooltiptxt = "", special = "(上层)" },
				dtl13 = { text = "基尔加丹", colour = AM_GREEN, coords = { {61.71, 32.62} }, symbol = { "6" },
						tooltiptxt = "", leaveGap = 1, lootid = "SPKiljaeden" },
				dtl14 = { text = AM_MOB_LOOT, colour = AM_PURPLE, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", leaveGap = 1, lootid = "SPTrash" },
			},

		};

end