-- [[
-- AlphaMap v2.11.11100 Traditional Chinese Localization File
-- Initial Translated by: Arith Hsu (2006/07/21)
-- Maintained by: Arith Hsu
-- Last Updated: 2006/07/26
-- Comments:
--    2006/07/27 Arith: 翻譯這個插件的文字，工作量是很龐大的，特別是要去查詢各副本裡的 boss 名稱，還有一些對應的任務名稱和
--                      一些任務注意事項等。期望看到後續有人熱心維護這個翻譯，但是請尊重各個維護翻譯的人的辛勞，你可以把你
--                      的名字加在檔頭，但是請勿移除其他人的名字。
--                      使用簡體中文的朋友如果是拿這個正體中文檔案直接轉簡體，我也沒什麼意見，但是請一樣保留原翻譯者的記錄
--                      另外請注意，正體中文和簡體中文的翻譯還是有諸多的不一致，請自行修正。
-- Revision History:
--    7/26: Complete about 95% translations.
-- ]]

if ( GetLocale() == "zhTW" ) then

	AM_TYP_EXTERIORS		= "Caves";

	AM_ALPHAMAP_EXTERIORS_LIST = {

			{	name = "厄運之槌"..AM_EXTERIOR,		-- Dire Maul Exterior
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 厄運之槌",
				displayshort = "DM",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\DireMaulExt",
				location = "菲拉斯 (59, 44)",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "Kalimdor",
				wmData = { minX = 0.4268, maxX = 0.441, minY =  0.6648, maxY = 0.696 },
				amData = { minX = 0.29, maxX = 0.97, minY = 0.025, maxY = 0.98 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {32, 97}  }, symbol = { "X" },
						tooltiptxt = "", toMap = "厄運之槌", leaveGap = 1 },
				dtl2  = { text = "Eldereth Row", colour = AM_BLUE, coords = { {57, 73} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl3  = { text = "Broken Commons", colour = AM_BLUE, coords = { {62, 50} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl4  = { text = "Skarr the Unbreakable", colour = AM_RED, coords = { {62, 33} }, symbol = { "3" },
						tooltiptxt = "Lvl58 菁英人形怪" },
				dtl5  = { text = "The Maul", colour = AM_RED, coords = { {62, 26} }, symbol = { "4" },
						tooltiptxt = "PvP 區域" },
				dtl6  = { text = "Path to The Maul", colour = AM_BLUE, coords = { {44, 47}, {58, 33} }, symbol = { "P" },
						tooltiptxt = "Sleeping Hyena Guards" },
				dtl7  = { text = "Chamber with roof Exit from DM East", colour = AM_BLUE, coords = { {85, 19.4} }, symbol = { "5" },
						tooltiptxt = "", leaveGap = 1 },
				dtl8  = { text = "厄運之槌 (東)", colour = AM_GREEN, coords = { {84, 32}, {96, 62} }, symbol = { "E" },
						tooltiptxt = "按下以打開 '厄運之槌 (東)' 的地圖", toMap = "厄運之槌 (東)" },
				dtl9  = { text = "厄運之槌 (北)", colour = AM_GREEN, coords = { {62, 4} }, symbol = { "N" },
						tooltiptxt = "按下以打開 '厄運之槌 (北)' 的地圖", toMap = "厄運之槌 (北)" },
				dtl10 = { text = "厄運之槌 (西)", colour = AM_GREEN, coords = { {42, 40} }, symbol = { "W" },
						tooltiptxt = "按下以打開 '厄運之槌 (西)' 的地圖", toMap = "厄運之槌 (西)", leaveGap = 1 }
			},

			{	name = "諾姆瑞根"..AM_EXTERIOR,			-- Gnomeregan
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 諾姆瑞根",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\GnomereganExt",
				location = "丹莫洛 (25, 41)",
				levels = "",
				players = "",
				prereq = "",
				general = "部落可由藏寶海灣傳送過來.\n起始任務來自奧格瑪工程師.",
				wmData = { minX = 0.423202, maxX = 0.430997, minY = 0.590355, maxY = 0.602768 },
				amData = { minX = 0.198, maxX = 0.92, minY = 0.21, maxY = 0.926 },
				dtl1  = { text = "外部", colour = AM_GREEN, coords = { {91.0, 92.5} }, symbol = { "O" },
						tooltiptxt = "" },
				dtl2  = { text = "升降梯", colour = AM_GREEN, coords = { {81.59, 87.65} }, symbol = { "L" },
						tooltiptxt = "" },
				dtl3  = { text = "傳送器", colour = AM_GREEN, coords = { {60.95, 72.95} }, symbol = { "P" },
						tooltiptxt = "從藏寶海灣" },
				dtl4  = { text = "斯普洛克", colour = AM_BLUE, coords = { {60.95, 72.95} }, symbol = { " " },
						tooltiptxt = "Away Team", leaveGap = 1 },
				dtl5  = { text = "矩陣式打孔電腦 3005-A", colour = AM_PURPLE, coords = { {67.29, 42.22}, {61.43, 41.78}, {64.00, 26.52}, {69.46, 26.75} }, symbol = { "A" },
						tooltiptxt = "卡片升級" },
				dtl6  = { text = "尖端機器人", colour = AM_RED, coords = { {44.0, 36.53} }, symbol = { "1" },
						tooltiptxt = "Lvl26 菁英機器人", leaveGap = 1 },
				dtl7  = { text = "主要副本入口", colour = AM_ORANGE, coords = { {18.89, 88.0} }, symbol = { "I" },
						tooltiptxt = "", toMap = "諾姆瑞根" },
				dtl8  = { text = "車間入口", colour = AM_ORANGE, coords = { {62.46, 22.75} }, symbol = { "W" },
						tooltiptxt = "需要車間鑰匙", toMap = "Gnomeregan", leaveGap = 1  }
			},

			{	name = "瑪拉頓"..AM_EXTERIOR,		-- Maraudon Exterior
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 瑪拉頓",
				displayshort = "",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\MaraudonExt",
				location = "淒涼之地 (29, 62)",
				levels = "40-49",
				players = "",
				prereq = "",
				general = "",
				area = "Kalimdor",
				wmData = { minX = 0.3807325, maxX = 0.393785, minY =  0.5679875, maxY = 0.58772 },
				amData = { minX = 0.02, maxX = 0.92, minY = 0.01, maxY = 0.98 },
				dtl1  = { text = "入口", colour = AM_GREEN, coords = { {23, 59}  }, symbol = { "X" },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "第一可汗", colour = AM_RED, coords = { {31, 45} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl3  = { text = "S第二可汗", colour = AM_RED, coords = { {24, 29} }, symbol = { "2" },
						tooltiptxt = "在中間層的水池間" },
				dtl4  = { text = "第三可汗", colour = AM_RED, coords = { {80, 46} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl5  = { text = "凱雯德拉", colour = AM_GREEN, coords = { {48, 64} }, symbol = { "4" },
						tooltiptxt = "任務提供者", leaveGap = 1 },
				dtl6  = { text = "瑪拉頓傳送點", colour = AM_BLUE, coords = { {24, 47} }, symbol = { "P" },
						tooltiptxt = "需要塞雷布拉斯節杖" },
				dtl7  = { text = "瑪拉頓 (橙區)", colour = AM_ORANGE, coords = { {84, 71} }, symbol = { "X1" },
						tooltiptxt = "按下以開啟瑪拉頓副本地圖", toMap = "瑪拉頓" },
				dtl8  = { text = "瑪拉頓 (紫區)", colour = AM_PURPLE, coords = { {39, 12.4} }, symbol = { "X2" },
						tooltiptxt = "按下以開啟瑪拉頓副本地圖", toMap = "瑪拉頓" }
			},

			{	name = "奧達曼"..AM_EXTERIOR,		-- Uldaman Exterior
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 奧達曼",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\UldamanExt",
				location = "荒蕪之地 (44, 12)",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "Azeroth",
				wmData = { minX = 0.536226, maxX = 0.544795, minY =  0.57594, maxY = 0.586616 },
				amData = { minX = 0.075, maxX = 0.95, minY = 0.20, maxY = 0.935 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {95, 33}  }, symbol = { "X" },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = AM_INSTANCE_CHESTS, colour = AM_BLUE, coords = { {23, 64}, {33, 88} }, symbol = { AM_CHEST_SYMBOL },
						tooltiptxt = "Quests", leaveGap = 1 },
				dtl3  = { text = "奧達曼", colour = AM_GREEN, coords = { {30.5, 23} }, symbol = { "U" },
						tooltiptxt = "", toMap = "奧達曼", leaveGap = 1 }
			},

			{	name = "哀嚎洞穴"..AM_EXTERIOR,		-- Wailing Caverns Exterior
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 哀嚎洞穴",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\WailingCavernsExt",
				location = "貧瘠之地 (46, 36)",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "Kalimdor",
				wmData = { minX = 0.5178145, maxX = 0.529001, minY =  0.543372, maxY = 0.555871 },
				amData = { minX = 0.05, maxX = 0.97, minY = 0.15, maxY = 0.80 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {14.2, 81.5}  }, symbol = { "X" },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "哀嚎洞穴", colour = AM_GREEN, coords = { {55.1, 62.2} }, symbol = { "W" },
						tooltiptxt = "", toMap = "哀嚎洞穴", leaveGap = 1 }
			},

			{	name = "黑石山"..AM_EXTERIOR,			-- Blackrock Mountain
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 黑石山",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\BRMExt",
				location = "黑石山",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				wmData = { minX = 0.46707, maxX = 0.47864, minY = 0.67602, maxY = 0.69818 },
				amData = { minX = 0.14, maxX = 0.85, minY = 0.09, maxY = 0.985 },
				dtl1  = { text = "Burning Steppes", colour = AM_GREEN, coords = { {50.0, 38.0} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "Searing Gorge", colour = AM_GREEN, coords = { {53.2, 98.2} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "LBRS/UBRS/BWL", colour = AM_RED, coords = { {71, 59.4} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石塔", leaveGap = 1 },
				dtl4  = { text = "Lothos Riftwalker", colour = AM_BLUE, coords = { {40, 57} }, symbol = { "1" },
						tooltiptxt = "Attunement to Core\nTeleport to Molten Core", toMap = "熔火之心", leaveGap = 1 },
				dtl5  = { text = "Overmaster Pyron", colour = AM_RED, coords = { {21.1, 15.0} }, symbol = { "2" },
						tooltiptxt = "Lvl52 Elite Elemental", special = AM_WANDERS, leaveGap = 1 },
				dtl6  = { text = "BRD/MC", colour = AM_RED, coords = { {25, 9} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑石深淵", leaveGap = 1 }
			},

			{	name = "時光之穴"..AM_EXTERIOR,			-- CoT
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 時光之穴",
				displayshort = "CoT",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\CoT",
				location = "塔納利斯",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "Tanaris",
				wmData = { minX = 0.5521, maxX = 0.68239, minY =  0.47247, maxY = 0.63367 },
				amData = { minX = 0.09, maxX = 0.99, minY = 0.15, maxY = 0.86 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {81.6, 26.2} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "希爾斯布萊德丘陵", colour = AM_ORANGE, coords = { {1.5, 41.2} }, symbol = { "A" },
						tooltiptxt = "", toMap = "希爾斯布萊德丘陵" },
				dtl3  = { text = "黑色沼澤", colour = AM_ORANGE, coords = { {18.00, 86.22} }, symbol = { "B" },
						tooltiptxt = "", toMap = "黑色沼澤" },
				dtl4  = { text = "海加爾山", colour = AM_ORANGE, coords = { {22, 23} }, symbol = { "C" },
						tooltiptxt = "", toMap = "海加爾山", leaveGap = 1 },
				dtl5  = { text = "時間服務員", colour = AM_GREEN, coords = { {81.6, 26.2} }, symbol = { " " },
						tooltiptxt = "" },
				dtl6  = { text = "艾力克斯頓·科洛米", colour = AM_GREEN, coords = { {92, 25} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl7  = { text = "墓地", colour = AM_GREEN, coords = { {68, 23} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl8  = { text = "亞利", colour = AM_GREEN, coords = { {67.87, 56.0} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl9  = { text = "伯特卡", colour = AM_GREEN, coords = { {67, 61} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl10 = { text = "卡葛隆姆", colour = AM_GREEN, coords = { {67, 61} }, symbol = { " " },
						tooltiptxt = "" },
				dtl11 = { text = "阿勒米", colour = AM_GREEN, coords = { {67, 61} }, symbol = { " " },
						tooltiptxt = "" },
				dtl12 = { text = "薩拉多姆", colour = AM_GREEN, coords = { {37, 56} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl13 = { text = "索芮朵蜜", colour = AM_GREEN, coords = { {37, 56} }, symbol = { " " },
						tooltiptxt = "", special = AM_WANDERS },
				dtl14 = { text = "阿拉斯莫杜", colour = AM_GREEN, coords = { {37, 56} }, symbol = { " " },
						tooltiptxt = "", special = AM_WANDERS },
				dtl15 = { text = "月井", colour = AM_GREEN, coords = { {37, 33} }, symbol = { "6" },
						tooltiptxt = "" },
				dtl16 = { text = "安杜姆", colour = AM_GREEN, coords = { {31, 45} }, symbol = { "7" },
						tooltiptxt = "", special = "(兒年)" },
				dtl17 = { text = "諾札瑞", colour = AM_GREEN, coords = { {31, 45} }, symbol = { " " },
						tooltiptxt = "", special = "(兒年)" },
				dtl18 = { text = "安杜姆", colour = AM_GREEN, coords = { {25, 67} }, symbol = { "8" },
						tooltiptxt = "", special = "(成年)" },
				dtl19 = { text = "諾札瑞", colour = AM_GREEN, coords = { {25, 67} }, symbol = { " " },
						tooltiptxt = "", special = "(成年)" },
			},

			{	name = "盤牙洞穴"..AM_EXTERIOR,			-- Coilfang
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 盤牙洞穴",
				displayshort = "CR",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\CoilfangExt",
				location = "贊格沼澤",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "Zangarmarsh",
				wmData = { minX = 0.48742, maxX = 0.54289, minY =  0.33097, maxY = 0.38282 },
				amData = { minX = 0.14, maxX = 0.73, minY = 0.43, maxY = 0.80 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_GREEN, coords = { {48.24, 77.34} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "(水下)", leaveGap = 1 },
				dtl2  = { text = "奴隸監獄", colour = AM_ORANGE, coords = { {16.41, 62.89} }, symbol = { "A" },
						tooltiptxt = "", toMap = "奴隸監獄" },
				dtl3  = { text = "蒸汽洞窟", colour = AM_ORANGE, coords = { {31.05, 45.70} }, symbol = { "B" },
						tooltiptxt = "", toMap = "蒸汽洞窟" },
				dtl4  = { text = "毒蛇神殿洞穴", colour = AM_ORANGE, coords = { {48.05, 46.48} }, symbol = { "C" },
						tooltiptxt = "", toMap = "毒蛇神殿洞穴" },
				dtl5  = { text = "毒牙沼澤", colour = AM_ORANGE, coords = { {68.95, 59.375} }, symbol = { "D" },
						tooltiptxt = "", toMap = "毒牙沼澤", leaveGap = 1 },
				dtl6  = { text = "看守者詹汗格", colour = AM_GREEN, coords = { {49.8, 64.26} }, symbol = { "1" },
						tooltiptxt = "", special = "集合石" },
				dtl7  = { text = "莫塔格·史提海德", colour = AM_GREEN, coords = { {44.14, 59.96} }, symbol = { "2" },
						tooltiptxt = "" },
			},

			{	name = "奧齊頓"..AM_EXTERIOR,			-- Auchindoun
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 奧齊頓",
				displayshort = "Auch",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\AuchindounExt",
				location = "白骨荒野, 泰洛卡森林",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "TerokkarForest",
				wmData = { minX = 0.34323, maxX = 0.44944, minY =  0.57638, maxY = 0.73592 },
				amData = { minX = 0.11, maxX = 0.89, minY = 0.10, maxY = 0.88 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {21, 20}, {81, 20}, {21, 78}, {81, 78} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "奧奇奈地穴", colour = AM_ORANGE, coords = { {8, 49.5} }, symbol = { "A" },
						tooltiptxt = "", toMap = "奧奇奈地穴" },
				dtl3  = { text = "法力墓地", colour = AM_ORANGE, coords = { {50, 7} }, symbol = { "B" },
						tooltiptxt = "", toMap = "法力墓地" },
				dtl4  = { text = "塞司克大廳", colour = AM_ORANGE, coords = { {92, 49.5} }, symbol = { "C" },
						tooltiptxt = "", toMap = "塞司克大廳" },
				dtl5  = { text = "暗影迷宮", colour = AM_ORANGE, coords = { {50, 92} }, symbol = { "D" },
						tooltiptxt = "", toMap = "暗影迷宮", leaveGap = 1 },
				dtl6  = { text = "集合石", colour = AM_GREEN, coords = { {50, 44} }, symbol = { "1" },
						tooltiptxt = "", leaveGap = 1 },
				dtl7  = { text = "哈勒", colour = AM_GREEN, coords = { {18, 49.5} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl8  = { text = "大祖父阿爾崔瑪斯", colour = AM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl9  = { text = "克萊瑞莎", colour = AM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl10 = { text = "瘋狂者藍姆多", colour = AM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl11 = { text = "護甲匠霍沃", colour = AM_GREEN, coords = { {18, 49.5} }, symbol = { " " },
						tooltiptxt = "" },
				dtl12 = { text = "奈薩斯王子哈拉瑪德", colour = AM_GREEN, coords = { {50, 16} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl13 = { text = "工匠莫法利厄司", colour = AM_GREEN, coords = { {50, 16} }, symbol = { " " },
						tooltiptxt = "" },
				dtl14 = { text = "學家瑪姆迪", colour = AM_GREEN, coords = { {50, 16} }, symbol = { " " },
						tooltiptxt = "" },
				dtl15 = { text = "「史令姆」", colour = AM_GREEN, coords = { {50, 16} }, symbol = { " " },
						tooltiptxt = "" },
				dtl16 = { text = "隊長卡夫提茲", colour = AM_GREEN, coords = { {50, 16} }, symbol = { " " },
						tooltiptxt = "" },
				dtl17 = { text = "伊斯法", colour = AM_GREEN, coords = { {83, 49.5} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl18 = { text = "戰場元帥瑪赫范", colour = AM_GREEN, coords = { {50, 80} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl19 = { text = "間諜葛瑞克薩", colour = AM_GREEN, coords = { {50, 80} }, symbol = { " " },
						tooltiptxt = "" },
				dtl20 = { text = "糧食供應者·茲索特", colour = AM_GREEN, coords = { {50, 80} }, symbol = { " " },
						tooltiptxt = "" },
				dtl21 = { text = "商人塔爾利奎", colour = AM_GREEN, coords = { {50, 80} }, symbol = { " " },
						tooltiptxt = "" },
			},

			{	name = "血色修道院"..AM_EXTERIOR,			-- Scarlet Monastery
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 血色修道院",
				displayshort = "SM",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\SMExt",
				location = "提瑞斯法林地",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				wmData = { minX = 0.462834, maxX = 0.466359, minY =  0.30418, maxY = 0.30718 },
				amData = { minX = 0.02, maxX = 0.91, minY = 0.26, maxY = 0.695 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {5, 59}, {9, 71} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "墓地区", colour = AM_ORANGE, coords = { {76, 23} }, symbol = { "1" },
						tooltiptxt = "", toMap = "血色修道院" },
				dtl3  = { text = "大教堂", colour = AM_ORANGE, coords = { {89, 29} }, symbol = { "2" },
						tooltiptxt = "", toMap = "血色修道院" },
				dtl4  = { text = "军械库", colour = AM_ORANGE, coords = { {93, 43} }, symbol = { "3" },
						tooltiptxt = "", toMap = "血色修道院" },
				dtl5  = { text = "图书馆", colour = AM_ORANGE, coords = { {87, 55} }, symbol = { "4" },
						tooltiptxt = "", toMap = "血色修道院" },
				-- toMap = "Scarlet Monastery", "Das scharlachrote Kloster", "Monast\195\168re \195\169carlate"
			},

			{	name = "阿塔哈卡神庙"..AM_EXTERIOR,			-- Sunken Temple
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 阿塔哈卡神庙",
				displayshort = "ST",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\SunkenTempleExt",
				location = "悲伤沼泽",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				wmData = { minX = 0.53955, maxX = 0.54659, minY =  0.78631, maxY = 0.79619 },
				amData = { minX = 0.08, maxX = 0.815, minY = 0.23, maxY = 0.91 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {12, 89} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", special = "(玉龙 - 稀有)", leaveGap = 1 },
				dtl2  = { text = "邪恶的卡萨卡兹", colour = AM_RED, coords = { {46, 70} }, symbol = { "1" },
						tooltiptxt = "", special = "(上层)" },
				dtl3 = { text = "泽基斯", colour = AM_RED, coords = { {58, 38} }, symbol = { "2" },
						tooltiptxt = "", special = AM_RARE },
				dtl4 = { text = "食尸者维萨克", colour = AM_RED, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "", special = "(?) (稀有)", leaveGap = 1 },
				dtl5 = { text = "阿塔哈卡神庙", colour = AM_ORANGE, coords = { {57, 21} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "阿塔哈卡神庙", leaveGap = 1 },
				-- toMap = "The Temple of Atal'Hakkar", "Der versunkene Tempel", "Le temple d'Atal'Hakkar"
			},

			{	name = "黑暗深渊"..AM_EXTERIOR,			-- Blackfathom Deeps
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 黑暗深渊",
				displayshort = "BFD",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\BlackfathomDeepsExt",
				location = "灰谷",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				wmData = { minX = 0.4366733, maxX = 0.44610637, minY =  0.34415522, maxY = 0.35412708 },
				amData = { minX = 0.045, maxX = 0.975, minY = 0.14, maxY = 0.81 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {35, 80} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "黑暗深渊", colour = AM_ORANGE, coords = { {70, 43.8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "黑暗深渊", leaveGap = 1 },
				-- toMap = "Blackfathom Deeps", "Blackfathom-Tiefenl", "Profondeurs de Brassenoire"
			},

			{	name = "死亡矿井"..AM_EXTERIOR,			-- The Deadmines
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 死亡矿井",
				displayshort = "",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\TheDeadminesExt",
				location = "西部荒野",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				wmData = { minX = 0.404836, maxX = 0.410194, minY =  0.819415, maxY = 0.82981 },
				amData = { minX = 0.15, maxX = 0.89, minY = 0.01, maxY = 0.965 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_BLUE, coords = { {68, 1} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl2  = { text = "玛里莎·杜派格", colour = AM_RED, coords = { {62, 63}, {86, 39} }, symbol = { "1" },
						tooltiptxt = "", special = AM_VARIES },
				dtl3  = { text = "被洗脑的贵族", colour = AM_RED, coords = { { 70, 71 } }, symbol = { "2" },
						tooltiptxt = "", special = AM_RARE },
				dtl4  = { text = "工头希斯耐特", colour = AM_RED, coords = { {60, 86.8} }, symbol = { "3" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "死亡矿井", colour = AM_ORANGE, coords = { {15, 48} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "死亡矿井", leaveGap = 1 },
				-- toMap = "The Deadmines", "Die Todesminen", "Les Mortemines"
			},

			{	name = "卡拉赞"..AM_EXTERIOR,			-- Karazhan
				type = AM_TYP_EXTERIORS,
				displayname = AM_EXTERIOR.." - 卡拉赞",
				displayshort = "",
				filename = "Interface\\AddOns\\AlphaMap_Exteriors\\Maps\\KarazhanExt",
				location = "逆风小径",
				levels = "",
				players = "",
				prereq = "",
				general = "",
				area = "DeadwindPass",
				wmData = { minX = 0.41501, maxX = 0.5179492, minY =  0.6651555, maxY = 0.822 },	--8172344
				amData = { minX = 0.02, maxX = 1.0, minY = 0.0, maxY = 0.98 },
				dtl1  = { text = AM_INSTANCE_ENTRANCES, colour = AM_ORANGE, coords = { {53, 50} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉赞", special = "(前门入口)" },
				dtl2  = { text = AM_INSTANCE_ENTRANCES, colour = AM_ORANGE, coords = { {73, 8} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", toMap = "卡拉赞", special = "(后门入口)", leaveGap = 1 },
				dtl3  = { text = "集合石", colour = AM_BLUE, coords = { {44, 57} }, symbol = { "A" },
						tooltiptxt = "" },
				dtl4  = { text = "墓地", colour = AM_BLUE, coords = { {0, 62} }, symbol = { "B" },
						tooltiptxt = "", leaveGap = 1 },
				dtl5  = { text = "大法师蕾尔达", colour = AM_GREEN, coords = { {58, 51} }, symbol = { "1" },
						tooltiptxt = "" },
				dtl6  = { text = "学徒达里乌斯", colour = AM_GREEN, coords = { {53, 56} }, symbol = { "2" },
						tooltiptxt = "" },
				dtl7  = { text = "大法师奥图鲁斯", colour = AM_GREEN, coords = { {54, 61} }, symbol = { "3" },
						tooltiptxt = "" },
				dtl8  = { text = "通往地下水池的楼梯", colour = AM_GREEN, coords = { {59, 75} }, symbol = { "4" },
						tooltiptxt = "" },
				dtl9  = { text = "通往地下水井的楼梯", colour = AM_GREEN, coords = { {72, 77} }, symbol = { "5" },
						tooltiptxt = "" },
				dtl10 = { text = "焦骨碎块", colour = AM_GREEN, coords = { {31, 76} }, symbol = { "6" },
						tooltiptxt = "" },
				-- toMap = "The Deadmines", "Die Todesminen", "Les Mortemines"
			},

		};

end