-- [[
-- AlphaMap v2.11.11100 Traditional Chinese Localization File
-- Initial Translated by: Arith Hsu (2006/07/21)
-- Maintained by: Arith Hsu
-- Last Updated: 2006/07/26
-- Comments:
--    2006/07/27 Arith: 翻譯這個插件的文字，工作量是很龐大的，特別是要去查詢各副本裡的 boss 名稱，還有一些對應的任務名稱和
--                      一些任務注意事項等。期望看到後續有人熱心維護這個翻譯，但是請尊重各個維護翻譯的人的辛勞，你可以把你
--                      的名字加在檔頭，但是請勿移除其他人的名字。
--                      使用簡體中文的朋友如果是拿這個正體中文檔案直接轉簡體，我也沒什麼意見，但是請一樣保留原翻譯者的記錄
--                      另外請注意，正體中文和簡體中文的翻譯還是有諸多的不一致，請自行修正。
-- Revision History:
--    7/26: Complete about 95% translations.
-- ]]

if ( GetLocale() == "zhTW" ) then

	AM_TYP_BG			= "戰場";

	AM_ALPHAMAP_BATTLEGROUNDS_LIST = {

			{ 	name = "奧特蘭克山谷",			-- Alterac Valley
				type = AM_TYP_BG,
				displayname = "奧特蘭克山谷",
				displayshort = "AV",
				filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\AlteracValley",
				location = "奧特蘭克山脈 (63, 58)",
				levels = "51-60",
				players = "40",
				prereq = "",
				general = "",
				notescale = 0.7,
				wmData = { minX = 0.395, maxX = 0.586, minY =  0.106, maxY = 0.9187 },
				amData = { minX = 0.65, maxX = 0.95, minY = 0.036, maxY = 0.98 },
				dtl1  = { text = "聯盟入口", colour = AM_BLUE, coords = { {87.98, 2.69} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "" },
				dtl2  = { text = "部落入口", colour = AM_RED, coords = { {91.01, 71.03} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "", leaveGap = 1 },
				dtl3  = { text = "丹巴達爾", colour = AM_BLUE, coords = { {67.38, 6.47} }, symbol = { "!" },
						tooltiptxt = "殺死首領來贏得這場戰役" },
				dtl4  = { text = "霜狼要塞", colour = AM_RED, coords = { {75.38, 92.42} }, symbol = { "!" },
						tooltiptxt = "殺死首領來贏得這場戰役", leaveGap = 1 },
				dtl5  = { text = "墓地", colour = AM_GREEN, coords = { {68.26, 9.55}, {79.29, 8.36}, {83.68, 32.53}, {70.89, 44.37}, {83.49, 60.99}, {80.66, 80.18}, {80.27, 94.31} }, symbol = { " " },
						tooltiptxt = "佔領後可讓你的友方可以在此復活", bgPOI = true },
				dtl6  = { text = "雷矛急救站", colour = AM_GREEN, coords = { {68.26, 9.55}, {57, 9.55} }, symbol = { "1" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl7  = { text = "雷矛墓地", colour = AM_GREEN, coords = { {79.29, 8.36}, {57, 12} }, symbol = { "2" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl8  = { text = "石爐墓地", colour = AM_GREEN, coords = { {83.68, 32.53}, {57, 32.53} }, symbol = { "3" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl9  = { text = "落雪墓地", colour = AM_GREEN, coords = { {72.2, 44.8}, {57, 44.37} }, symbol = { "4" },
						tooltiptxt = "", bgPOI = true, bgTimer = 302 },
				dtl10 = { text = "冰血墓地", colour = AM_GREEN, coords = { {83.49, 60.99}, {57, 60.99} }, symbol = { "5" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl11 = { text = "霜狼墓地", colour = AM_GREEN, coords = { {82.0, 80.18}, {57, 80.18} }, symbol = { "6" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl12 = { text = "霜狼急救站", colour = AM_GREEN, coords = { {80.27, 94.31}, {57, 94.31} }, symbol = { "7" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245, leaveGap = 1 },
				dtl13 = { text = "石爐哨站", bgPOI = true, colour = AM_BLUE, coords = { {79, 36.71} }, symbol = { "C" },
						tooltiptxt = "" },
				dtl14 = { text = "巴林達上尉", colour = AM_BLUE, coords = { {79, 36.71} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true, leaveGap = 1 },
				dtl15 = { text = "冰血要塞", colour = AM_RED, coords = { {73.82, 57.7} }, symbol = { "C" },
						tooltiptxt = "", bgPOI = true },
				dtl16 = { text = "加爾范上尉", colour = AM_RED, coords = { {73.82, 57.7} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true, leaveGap = 1 },
				dtl17 = { text = "聯盟碉堡", colour = AM_BLUE, coords = { {85.54, 41.98}, {82.02, 27.16}, {70.50, 13.53}, {73.04, 7.37} }, symbol = { " " },
						tooltiptxt = "部落可以摧毀以取得榮譽\n摧毀後守衛將不會在重生", bgPOI = true },
				dtl18 = { text = "石爐碉堡", colour = AM_BLUE, coords = { {85.54, 41.98}, {60, 41.98} }, symbol = { "8" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl19 = { text = "冰翼碉堡", colour = AM_BLUE, coords = { {82.02, 27.16}, {60, 27.16} }, symbol = { "9" },
						tooltiptxt = "聯盟指揮官卡爾菲利普\n部落空軍指揮官古斯", bgPOI = true, bgTimer = 245 },
				dtl20 = { text = "丹巴達爾南部碉堡", colour = AM_BLUE, coords = { {71.00, 13.00}, {60, 13.53} }, symbol = { "10" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl21 = { text = "丹巴達爾北部碉堡", colour = AM_BLUE, coords = { {73.04, 7.37}, {60, 7.37} }, symbol = { "11" },
						tooltiptxt = "部落空軍指揮官穆維里克", bgPOI = true, bgTimer = 245, leaveGap = 1 },
				dtl22 = { text = "部落碉堡", colour = AM_RED, coords = { {78.31, 59.29}, {81.83, 67.25}, {80.4, 89.04}, {77, 88.5}  }, symbol = { " " },
						tooltiptxt = "聯盟可以摧毀以取得榮譽\n摧毀後守衛將不會在重生", bgPOI = true },
				dtl23 = { text = "冰血哨塔", colour = AM_RED, coords = { {78.31, 59.29}, {60, 59.29} }, symbol = { "12" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl24 = { text = "哨塔高地", colour = AM_RED, coords = { {81.83, 67.25}, {60, 67.25} }, symbol = { "13" },
						tooltiptxt = "部落指揮官路易斯菲利普\n聯盟空軍指揮官斯里多爾", bgPOI = true, bgTimer = 245 },
				dtl25 = { text = "東部霜狼哨塔", colour = AM_RED, coords = { {80.6, 89.04}, {63, 89.05} }, symbol = { "14" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245 },
				dtl26 = { text = "西部霜狼哨塔", colour = AM_RED, coords = { {78.5, 88.8}, {60.5, 88.5} }, symbol = { "15" },
						tooltiptxt = "", bgPOI = true, bgTimer = 245, leaveGap = 1 },
				dtl27 = { text = "礦坑", colour = AM_ORANGE, coords = { {81.15, 1.69}, {73.33, 74.61} }, symbol = { " " },
						tooltiptxt = "佔領以獲取資源", bgPOI = true },
				dtl28 = { text = "深鐵礦坑", colour = AM_GREEN, coords = { {81.15, 1.69}, {63, 1.69} }, symbol = { "IM" },
						tooltiptxt = "", bgPOI = true },
				dtl29 = { text = "金牙礦坑", colour = AM_GREEN, coords = { {73.33, 74.61}, {63, 74.61} }, symbol = {"CM" },
						tooltiptxt = "", bgPOI = true, leaveGap = 1 },
	-- Pad to dtl32 to control the page break
				dtl30 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "" },
				dtl31 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "" },
				dtl32 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
						tooltiptxt = "" },
	-- Pad to dtl32 to control the page break
				dtl33 = { text = "Summoning Zone", colour = AM_GREEN, coords = { {80.76, 44.27}, {73.14, 48.05} }, symbol = { " " },
						tooltiptxt = "Summon a Factions Avatar at these points" },
				dtl34 = { text = "Ivus the Forest Lord", colour = AM_BLUE, coords = { {80.76, 44.27} }, symbol = { "IF" },
						tooltiptxt = "Escort summoning NPCs to this point\nfrom Dun Baldar" },
				dtl35 = { text = "Lokholar the Ice Lord", colour = AM_RED, coords = { {73.14, 48.05} }, symbol = { "LI" },
						tooltiptxt = "Escort summoning NPCs to this point\nfrom Frostwolf Keep", leaveGap = 1 },
				dtl36 = { text = "Alliance Wing Commanders", colour = AM_BLUE, coords = { {82.02, 27.16}, {81.05, 85.46}, {81.83, 67.25}, {80.4, 89.04} }, symbol = { " " },
						tooltiptxt = "Rescue and escort back to base to get Air support", bgPOI = true },
				dtl37 = { text = "Karl Philips (9 Icewing Bunker)", colour = AM_BLUE, coords = { {82.02, 27.16} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true },
				dtl38 = { text = "Slidore (13 Tower Point)", colour = AM_BLUE, coords = { {81.83, 67.25} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true },
				dtl39 = { text = "Vipore", colour = AM_BLUE, coords = { {81.05, 85.46} }, symbol = { "W" },
						tooltiptxt = "" },
				dtl40 = { text = "Ichman (14 East Frostwolf Tower)", colour = AM_BLUE, coords = { {80.4, 89.04} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true, leaveGap = 1 },
				dtl41 = { text = "Horde Wing Commanders", colour = AM_RED, coords = { {81.83, 67.25}, {82.02, 27.16}, {88.96, 23.38}, {73.04, 7.37} }, symbol = { " " },
						tooltiptxt = "Rescue and escort back to base to get Air support", bgPOI = true },
				dtl42 = { text = "Louis Philips (13 Tower Point)", colour = AM_RED, coords = { {81.83, 67.25} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true },
				dtl43 = { text = "Guse (9 Icewing Bunker)", colour = AM_RED, coords = { {82.02, 27.16} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true },
				dtl44 = { text = "Jeztore", colour = AM_RED, coords = { {88.96, 23.38} }, symbol = { "W" },
						tooltiptxt = "" },
				dtl45 = { text = "Mulverick (11 Dun Baldar North Bunker)", colour = AM_RED, coords = { {73.04, 7.37} }, symbol = { " " },
						tooltiptxt = "", bgPOI = true, leaveGap = 1 },
				dtl46 = { text = "Steamsaw Locations", colour = AM_PURPLE, coords = { {83, 54.72}, {88.57, 15.42} }, symbol = { " " },
						tooltiptxt = "" },
				dtl47 = { text = "Alliance Steamsaw", colour = AM_BLUE, coords = { {83, 54.72} }, symbol = { "S" },
						tooltiptxt = "Required for Reaper quest" },
				dtl48 = { text = "Horde Steamsaw", colour = AM_RED, coords = { {88.57, 15.42} }, symbol = { "S" },
						tooltiptxt = "Required for Reaper quest", leaveGap = 1 },
				dtl49 = { text = "Caverns", colour = AM_GREEN, coords = { {64.54, 24.08}, {85.93, 94.71} }, symbol = { " " },
						tooltiptxt = "" },
				dtl50 = { text = "Icewing", colour = AM_GREEN, coords = { {64.54, 24.08} }, symbol = { "IC" },
						tooltiptxt = "" },
				dtl51 = { text = "Wildpaw", colour = AM_GREEN, coords = { {85.93, 94.71} }, symbol = { "WC" },
						tooltiptxt = "", leaveGap = 1 },
				dtl52 = { text = "Wolf Rider Commander", colour = AM_RED, coords = { {91.2, 86.55} }, symbol = { "WR" },
						tooltiptxt = "Tame Wolves and hand in Ram hides to summon Cavalry\nAlliance counterpart in Dun Baldar, just south of Aid Station GY", leaveGap = 2 },
				dtl53 = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "AVMisc" },
				dtl54 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "AVBlue" },
				dtl55 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "AVPurple", leaveGap = 1 }
			},

			{ 	name = "阿拉希盆地",			-- Arathi Basin
				type = AM_TYP_BG,
				displayname = "阿拉希盆地",
				displayshort = "AB",
				filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\ArathiBasin",
				location = "阿拉希高地 (73, 28)",
				levels = "20+ 帶狀",
				players = "15",
				prereq = "",
				general = "",
				wmData = { minX = 0.23, maxX = 0.71, minY =  0.09, maxY = 0.76 },
				amData = { minX = 0.15, maxX = 0.93, minY = 0.05, maxY = 0.87 },
				dtl1  = { text = "聯盟起始點", colour = AM_BLUE, coords = { {21.8, 12.98} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "聯盟玩家從此處開始", bgBase = "A" },
				dtl2  = { text = "部落起始點", colour = AM_RED, coords = { {91.89, 80.63} }, symbol = { AM_ENTRANCE_SYMBOL },
						tooltiptxt = "部落玩家從此處開始", bgBase = "H", leaveGap = 1 },
				dtl3  = { text = "獸欄", colour = AM_GREEN, coords = { {34.67, 29.6}, {9, 28.0} }, symbol = { "S" },
						tooltiptxt = "佔領", bgPOI = true, bgTimer = 62 },
				dtl4  = { text = "金礦", colour = AM_GREEN, coords = { {72.81, 30.54}, {9, 34.0} }, symbol = { "M" },
						tooltiptxt = "佔領", bgPOI = true, bgTimer = 62 },
				dtl5  = { text = "鐵匠舖", colour = AM_GREEN, coords = { {51.9, 50.2}, {9, 50.2} }, symbol = { "B" },
						tooltiptxt = "佔領", bgPOI = true, bgTimer = 62 },
				dtl6  = { text = "伐木廠", colour = AM_GREEN, coords = { {41.10, 62.37}, {9, 62.0} }, symbol = { "L" },
						tooltiptxt = "佔領", bgPOI = true, bgTimer = 62 },
				dtl7  = { text = "農場", colour = AM_GREEN, coords = { {70.52, 67.75}, {9, 68.0} }, symbol = { "F" },
						tooltiptxt = "佔領", bgPOI = true, bgTimer = 62, leaveGap = 1 },
				dtl8  = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "ABMisc" },
				dtl9  = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "ABBlue" },
				dtl10 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "ABPurple", leaveGap = 1 }
			},

			{ 	name = "暴風之眼",			-- Eye of the Storm
				type = AM_TYP_BG,
				displayname = "暴風之眼",
				displayshort = "",
				filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\NetherstormBG",			-- NetherstormBG
				location = "虛空風暴",
				levels = "61-69, 70",
				players = "15",
				prereq = "",
				general = "Accumulate 2000 victory points",
				wmData = { minX = 0.347, maxX = 0.614, minY =  0.164, maxY = 0.835 },
				amData = { minX = 0.245, maxX = 0.685, minY = 0.10, maxY = 0.86 },
				dtl1  = { text = "部落入口", colour = AM_RED, coords = { {44.8, 20.8} }, symbol = { "A" },
						tooltiptxt = "Horde players start here" },
				dtl2  = { text = "聯盟入口", colour = AM_RED, coords = { {48.8, 74.9} }, symbol = { "H" },
						tooltiptxt = "Alliance players start here", leaveGap = 2 },
				dtl3  = { text = "惡魔搶奪者廢墟", colour = AM_GREEN, coords = { {33, 58}, {20, 58} }, symbol = { "1" },
						tooltiptxt = "", bgPOI = true },
				dtl4  = { text = "法師塔", colour = AM_GREEN, coords = { {32.2, 39}, {20, 39} }, symbol = { "2" },
						tooltiptxt = "", bgPOI = true },
				dtl5  = { text = "德萊尼廢墟", colour = AM_GREEN, coords = { {59.5, 37.5}, {80, 37.5} }, symbol = { "3" },
						tooltiptxt = "", bgPOI = true },
				dtl6  = { text = "血精靈哨塔", colour = AM_GREEN, coords = { {60.8, 56}, {80, 56} }, symbol = { "4" },
						tooltiptxt = "", bgPOI = true },
				dtl7  = { text = "旗幟", colour = AM_GREEN, coords = { {47, 47} }, symbol = { "F" },
						tooltiptxt = "", bgFlag = "N", leaveGap = 2 },
				dtl8  = { text = "墓地", colour = AM_BLUE, coords = { {38, 58} }, symbol = { "GY" },
						tooltiptxt = "", bgPOI = true },
				dtl9  = { text = "墓地", colour = AM_BLUE, coords = { {37, 33} }, symbol = { "GY" },
						tooltiptxt = "", bgPOI = true },
				dtl10 = { text = "墓地", colour = AM_BLUE, coords = { {56, 33} }, symbol = { "GY" },
						tooltiptxt = "", bgPOI = true },
				dtl11 = { text = "墓地", colour = AM_BLUE, coords = { {56, 60} }, symbol = { "GY" },
						tooltiptxt = "", bgPOI = true, leaveGap = 2 },
				dtl12 = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid_ = "" },
				dtl13 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid_ = "" },
				dtl14 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid_ = "", leaveGap = 1 }
			},

			{ 	name = "戰歌峽谷",			-- Warsong Gulch
				type = AM_TYP_BG,
				displayname = "戰歌峽谷",
				displayshort = "WSG",
				filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\WarsongGulch",
				location = "梣谷 (62, 84) / 貧瘠之地 (47, 8)",
				levels = "10+ 帶狀",
				players = "10",
				prereq = "",
				general = "",
				wmData = { minX = 0.26, maxX = 0.74, minY =  0.05, maxY = 0.95 },
				amData = { minX = 0.33, maxX = 0.97, minY = 0.12, maxY = 0.88 },
				dtl1  = { text = "聯盟旗幟房", colour = AM_BLUE, coords = { {64.31, 14.15} }, symbol = { "F" },
						tooltiptxt = "聯盟玩家從這裡開始" },
				dtl2  = { text = "聯盟出口", colour = AM_BLUE, coords = { {45.93, 22.34} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "使用或輸入 /afk", leaveGap = 1 },
				dtl3  = { text = "部落旗幟房", colour = AM_RED, coords = { {70.75, 85.31} }, symbol = { "F" },
						tooltiptxt = "部落玩家從這裡開始" },
				dtl4  = { text = "部落出口", colour = AM_RED, coords = { {87.75, 77.12} }, symbol = { AM_EXIT_SYMBOL },
						tooltiptxt = "使用或輸入 /afk", leaveGap = 1 },
				dtl5  = { text = "增益點", colour = AM_GREEN, coords = { {55.35, 60.26}, {76.26, 39.67} }, symbol = { "P" },
						tooltiptxt = "" },
				dtl6  = { text = "回春", colour = AM_GREEN, coords = { {81.09, 61.43}, {56.04, 39.20} }, symbol = { "R" },
						tooltiptxt = "回復生命和法力", leaveGap = 2 },
				dtl7  = { text = "聯盟旗幟搬運者", colour = AM_BLUE, coords = { {30, 15} }, symbol = { "FC" },
						tooltiptxt = "", bgFlag = "A" },
				dtl8  = { text = "部落旗幟搬運者", colour = AM_RED, coords = { {30, 85} }, symbol = { "FC" },
						tooltiptxt = "", bgFlag = "H", leaveGap = 2 },
				dtl9  = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "WSGMisc" },
				dtl10 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "WSGBlue" },
				dtl11 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
						tooltiptxt = "", lootid = "WSGPurple", leaveGap = 1 }
			},

		};

end