--------------------------------------------------------------------------
-- localization.lua
--------------------------------------------------------------------------

AM_TYP_BG				= "BattleGrounds";	-- Register the Type of map

-- Define the Map details
-- the wmData and amData allow the positioning of Player/Party/Raid dots on the map and relate GetPlayerCoordinates to frame coordinates on the map

AM_ALPHAMAP_BATTLEGROUNDS_LIST = {

		{ 	name = "Alterac Valley",			-- Alterac Valley
			type = AM_TYP_BG,
			displayname = "Alterac Valley",
			displayshort = "AV",
			filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\AlteracValley",
			location = "Alterac Mountains (63, 58)",
			levels = "51-60",
			players = "40",
			prereq = "",
			general = "",
			notescale = 0.7,
			wmData = { minX = 0.395, maxX = 0.586, minY =  0.106, maxY = 0.9187 },
			amData = { minX = 0.65, maxX = 0.95, minY = 0.036, maxY = 0.98 },
			dtl1  = { text = "Alliance Entrance", colour = AM_BLUE, coords = { {87.98, 2.69} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "" },
			dtl2  = { text = "Horde Entrance", colour = AM_RED, coords = { {91.01, 71.03} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "", leaveGap = 1 },
			dtl3  = { text = "Dun Baldar", colour = AM_BLUE, coords = { {67.38, 6.47} }, symbol = { "!" },
					tooltiptxt = "Kill boss to win the game" },
			dtl4  = { text = "Frostwolf Keep", colour = AM_RED, coords = { {75.38, 92.42} }, symbol = { "!" },
					tooltiptxt = "Kill boss to win the game", leaveGap = 1 },
			dtl5  = { text = "Graveyards", colour = AM_GREEN, coords = { {68.26, 9.55}, {79.29, 8.36}, {83.68, 32.53}, {70.89, 44.37}, {83.49, 60.99}, {80.66, 80.18}, {80.27, 94.31} }, symbol = { " " },
					tooltiptxt = "Capture to allow your faction to resurrect here", bgPOI = true },
			dtl6  = { text = "Stormpike Aid Station", colour = AM_GREEN, coords = { {68.26, 9.55}, {57, 9.55} }, symbol = { "1" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl7  = { text = "Stormpike Graveyard", colour = AM_GREEN, coords = { {79.29, 8.36}, {57, 12} }, symbol = { "2" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl8  = { text = "Stonehearth Graveyard", colour = AM_GREEN, coords = { {83.68, 32.53}, {57, 32.53} }, symbol = { "3" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl9  = { text = "Snowfall Graveyard", colour = AM_GREEN, coords = { {72.2, 44.8}, {57, 44.37} }, symbol = { "4" },
					tooltiptxt = "", bgPOI = true, bgTimer = 302 },
			dtl10 = { text = "Iceblood Graveyard", colour = AM_GREEN, coords = { {83.49, 60.99}, {57, 60.99} }, symbol = { "5" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl11 = { text = "Frostwolf Graveyard", colour = AM_GREEN, coords = { {82.0, 80.18}, {57, 80.18} }, symbol = { "6" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl12 = { text = "Frostwolf Relief Hut", colour = AM_GREEN, coords = { {80.27, 94.31}, {57, 94.31} }, symbol = { "7" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245, leaveGap = 1 },
			dtl13 = { text = "Stonehearth Outpost", bgPOI = true, colour = AM_BLUE, coords = { {79, 36.71} }, symbol = { "C" },
					tooltiptxt = "" },
			dtl14 = { text = "Balinda", colour = AM_BLUE, coords = { {79, 36.71} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true, leaveGap = 1 },
			dtl15 = { text = "Iceblood Garrison", colour = AM_RED, coords = { {73.82, 57.7} }, symbol = { "C" },
					tooltiptxt = "", bgPOI = true },
			dtl16 = { text = "Glavangar", colour = AM_RED, coords = { {73.82, 57.7} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true, leaveGap = 1 },
			dtl17 = { text = "Alliance Bunkers", colour = AM_BLUE, coords = { {85.54, 41.98}, {82.02, 27.16}, {70.50, 13.53}, {73.04, 7.37} }, symbol = { " " },
					tooltiptxt = "Horde can destroy for honour\nGuards stop respawning when destroyed", bgPOI = true },
			dtl18 = { text = "Stonehearth Bunker", colour = AM_BLUE, coords = { {85.54, 41.98}, {60, 41.98} }, symbol = { "8" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl19 = { text = "Icewing Bunker", colour = AM_BLUE, coords = { {82.02, 27.16}, {60, 27.16} }, symbol = { "9" },
					tooltiptxt = "Alliance Wing Commander Karl Philips\nHorde Wing Commander Guse", bgPOI = true, bgTimer = 245 },
			dtl20 = { text = "Dun Baldar South Bunker", colour = AM_BLUE, coords = { {71.00, 13.00}, {60, 13.53} }, symbol = { "10" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl21 = { text = "Dun Baldar North Bunker", colour = AM_BLUE, coords = { {73.04, 7.37}, {60, 7.37} }, symbol = { "11" },
					tooltiptxt = "Horde Wing Commander Mulverick", bgPOI = true, bgTimer = 245, leaveGap = 1 },
			dtl22 = { text = "Horde Towers", colour = AM_RED, coords = { {78.31, 59.29}, {81.83, 67.25}, {80.4, 89.04}, {77, 88.5}  }, symbol = { " " },
					tooltiptxt = "Alliance can destroy for honour\nGuards stop respawning when destroyed", bgPOI = true },
			dtl23 = { text = "Iceblood Tower", colour = AM_RED, coords = { {78.31, 59.29}, {60, 59.29} }, symbol = { "12" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl24 = { text = "Tower Point", colour = AM_RED, coords = { {81.83, 67.25}, {60, 67.25} }, symbol = { "13" },
					tooltiptxt = "Alliance Wing Commander Louis Philips\nHorde Wing Commander Slidore", bgPOI = true, bgTimer = 245 },
			dtl25 = { text = "East Frostwolf Tower", colour = AM_RED, coords = { {80.6, 89.04}, {63, 89.05} }, symbol = { "14" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245 },
			dtl26 = { text = "West Frostwolf Tower", colour = AM_RED, coords = { {78.5, 88.8}, {60.5, 88.5} }, symbol = { "15" },
					tooltiptxt = "", bgPOI = true, bgTimer = 245, leaveGap = 1 },
			dtl27 = { text = "Mines", colour = AM_ORANGE, coords = { {81.15, 1.69}, {73.33, 74.61} }, symbol = { " " },
					tooltiptxt = "Capture to farm resources", bgPOI = true },
			dtl28 = { text = "Irondeep Mine", colour = AM_GREEN, coords = { {81.15, 1.69}, {63, 1.69} }, symbol = { "IM" },
					tooltiptxt = "", bgPOI = true },
			dtl29 = { text = "Coldtooth Mine", colour = AM_GREEN, coords = { {73.33, 74.61}, {63, 74.61} }, symbol = {"CM" },
					tooltiptxt = "", bgPOI = true, leaveGap = 1 },
-- Pad to dtl32 to control the page break
			dtl30 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "" },
			dtl31 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "" },
			dtl32 = { text = "", colour = AM_GREEN, coords = { {0, 0} }, symbol = { " " },
					tooltiptxt = "" },
-- Pad to dtl32 to control the page break
			dtl33 = { text = "Summoning Zones", colour = AM_GREEN, coords = { {80.76, 44.27}, {73.14, 48.05} }, symbol = { " " },
					tooltiptxt = "Summon a Factions Avatar at these points" },
			dtl34 = { text = "Ivus the Forest Lord", colour = AM_BLUE, coords = { {80.76, 44.27} }, symbol = { "IF" },
					tooltiptxt = "Escort summoning NPCs to this point\nfrom Dun Baldar" },
			dtl35 = { text = "Lokholar the Ice Lord", colour = AM_RED, coords = { {73.14, 48.05} }, symbol = { "LI" },
					tooltiptxt = "Escort summoning NPCs to this point\nfrom Frostwolf Keep", leaveGap = 1 },
			dtl36 = { text = "Alliance Wing Commanders", colour = AM_BLUE, coords = { {82.02, 27.16}, {81.05, 85.46}, {81.83, 67.25}, {80.4, 89.04} }, symbol = { " " },
					tooltiptxt = "Rescue and escort back to base to get Air support", bgPOI = true },
			dtl37 = { text = "Karl Philips (9 Icewing Bunker)", colour = AM_BLUE, coords = { {82.02, 27.16} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true },
			dtl38 = { text = "Slidore (13 Tower Point)", colour = AM_BLUE, coords = { {81.83, 67.25} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true },
			dtl39 = { text = "Vipore", colour = AM_BLUE, coords = { {81.05, 85.46} }, symbol = { "W" },
					tooltiptxt = "" },
			dtl40 = { text = "Ichman (14 East Frostwolf Tower)", colour = AM_BLUE, coords = { {80.4, 89.04} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true, leaveGap = 1 },
			dtl41 = { text = "Horde Wing Commanders", colour = AM_RED, coords = { {81.83, 67.25}, {82.02, 27.16}, {88.96, 23.38}, {73.04, 7.37} }, symbol = { " " },
					tooltiptxt = "Rescue and escort back to base to get Air support", bgPOI = true },
			dtl42 = { text = "Louis Philips (13 Tower Point)", colour = AM_RED, coords = { {81.83, 67.25} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true },
			dtl43 = { text = "Guse (9 Icewing Bunker)", colour = AM_RED, coords = { {82.02, 27.16} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true },
			dtl44 = { text = "Jeztore", colour = AM_RED, coords = { {88.96, 23.38} }, symbol = { "W" },
					tooltiptxt = "" },
			dtl45 = { text = "Mulverick (11 Dun Baldar North Bunker)", colour = AM_RED, coords = { {73.04, 7.37} }, symbol = { " " },
					tooltiptxt = "", bgPOI = true, leaveGap = 1 },
			dtl46 = { text = "Steamsaw Locations", colour = AM_PURPLE, coords = { {83, 54.72}, {88.57, 15.42} }, symbol = { " " },
					tooltiptxt = "" },
			dtl47 = { text = "Alliance Steamsaw", colour = AM_BLUE, coords = { {83, 54.72} }, symbol = { "S" },
					tooltiptxt = "Required for Reaper quest" },
			dtl48 = { text = "Horde Steamsaw", colour = AM_RED, coords = { {88.57, 15.42} }, symbol = { "S" },
					tooltiptxt = "Required for Reaper quest", leaveGap = 1 },
			dtl49 = { text = "Caverns", colour = AM_GREEN, coords = { {64.54, 24.08}, {85.93, 94.71} }, symbol = { " " },
					tooltiptxt = "" },
			dtl50 = { text = "Icewing", colour = AM_GREEN, coords = { {64.54, 24.08} }, symbol = { "IC" },
					tooltiptxt = "" },
			dtl51 = { text = "Wildpaw", colour = AM_GREEN, coords = { {85.93, 94.71} }, symbol = { "WC" },
					tooltiptxt = "", leaveGap = 1 },
			dtl52 = { text = "Wolf Rider Commander", colour = AM_RED, coords = { {91.2, 86.55} }, symbol = { "WR" },
					tooltiptxt = "Tame Wolves and hand in Ram hides to summon Cavalry\nAlliance counterpart in Dun Baldar, just south of Aid Station GY", leaveGap = 2 },
			dtl53 = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "AVMisc" },
			dtl54 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "AVBlue" },
			dtl55 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "AVPurple", leaveGap = 1 }
		},

		{ 	name = "Arathi Basin",			-- Arathi Basin
			type = AM_TYP_BG,
			displayname = "Arathi Basin",
			displayshort = "AB",
			filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\ArathiBasin",
			location = "Arathi Highlands (73, 28)",
			levels = "20+ Banded",
			players = "15",
			prereq = "",
			general = "",
			wmData = { minX = 0.23, maxX = 0.71, minY =  0.09, maxY = 0.76 },
			amData = { minX = 0.15, maxX = 0.93, minY = 0.05, maxY = 0.87 },
			dtl1  = { text = "Alliance Start", colour = AM_BLUE, coords = { {21.8, 12.98} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "Alliance players start here", bgBase = "A" },
			dtl2  = { text = "Horde Start", colour = AM_RED, coords = { {91.89, 80.63} }, symbol = { AM_ENTRANCE_SYMBOL },
					tooltiptxt = "Horde players start here", bgBase = "H", leaveGap = 1 },
			dtl3  = { text = "Stables", colour = AM_GREEN, coords = { {34.67, 29.6}, {9, 28.0} }, symbol = { "S" },
					tooltiptxt = "Capture", bgPOI = true, bgTimer = 62 },
			dtl4  = { text = "Gold Mine", colour = AM_GREEN, coords = { {72.81, 30.54}, {9, 34.0} }, symbol = { "M" },
					tooltiptxt = "Capture", bgPOI = true, bgTimer = 62 },
			dtl5  = { text = "Blacksmith", colour = AM_GREEN, coords = { {51.9, 50.2}, {9, 50.2} }, symbol = { "B" },
					tooltiptxt = "Capture", bgPOI = true, bgTimer = 62 },
			dtl6  = { text = "Lumber Mill", colour = AM_GREEN, coords = { {41.10, 62.37}, {9, 62.0} }, symbol = { "L" },
					tooltiptxt = "Capture", bgPOI = true, bgTimer = 62 },
			dtl7  = { text = "Farm", colour = AM_GREEN, coords = { {70.52, 67.75}, {9, 68.0} }, symbol = { "F" },
					tooltiptxt = "Capture", bgPOI = true, bgTimer = 62, leaveGap = 2 },
			dtl8  = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "ABMisc" },
			dtl9  = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "ABBlue" },
			dtl10 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "ABPurple", leaveGap = 1 }
		},
--62
		{ 	name = "Eye of the Storm",			-- Eye of the Storm
			type = AM_TYP_BG,
			displayname = "Eye of the Storm",
			displayshort = "",
			filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\NetherstormBG",			-- NetherstormBG
			location = "Netherstorm",
			levels = "61-69, 70",
			players = "15",
			prereq = "Four capture points and a flag to capture and return",
			general = "Accumulate 2000 victory points",
			wmData = { minX = 0.347, maxX = 0.614, minY =  0.164, maxY = 0.835 },
			amData = { minX = 0.245, maxX = 0.685, minY = 0.10, maxY = 0.86 },
			dtl1  = { text = "Alliance", colour = AM_BLUE, coords = { {44.8, 20.8} }, symbol = { "A" },
					tooltiptxt = "Horde players start here" },
			dtl2  = { text = "Horde", colour = AM_RED, coords = { {48.8, 74.9} }, symbol = { "H" },
					tooltiptxt = "Alliance players start here", leaveGap = 2 },
			dtl3  = { text = "Fel Reaver Ruins", colour = AM_GREEN, coords = { {33, 58}, {21, 58} }, symbol = { "1" },
					tooltiptxt = "", bgPOI = true },
			dtl4  = { text = "Mage Tower", colour = AM_GREEN, coords = { {32.2, 39}, {21, 39} }, symbol = { "2" },
					tooltiptxt = "", bgPOI = true },
			dtl5  = { text = "Draenei Ruins", colour = AM_GREEN, coords = { {59.5, 37.5}, {72, 37.5} }, symbol = { "3" },
					tooltiptxt = "", bgPOI = true },
			dtl6  = { text = "Blood Elf Tower", colour = AM_GREEN, coords = { {60.8, 56}, {72, 56} }, symbol = { "4" },
					tooltiptxt = "", bgPOI = true },
			dtl7  = { text = "Flag", colour = AM_GREEN, coords = { {47, 47} }, symbol = { "F" },
					tooltiptxt = "", bgFlag = "N", leaveGap = 2 },
			dtl8  = { text = "Graveyard", colour = AM_BLUE, coords = { {38, 58} }, symbol = { "GY" },
					tooltiptxt = "", bgPOI = true },
			dtl9  = { text = "Graveyard", colour = AM_BLUE, coords = { {37, 33} }, symbol = { "GY" },
					tooltiptxt = "", bgPOI = true },
			dtl10 = { text = "Graveyard", colour = AM_BLUE, coords = { {56, 33} }, symbol = { "GY" },
					tooltiptxt = "", bgPOI = true },
			dtl11 = { text = "Graveyard", colour = AM_BLUE, coords = { {56, 60} }, symbol = { "GY" },
					tooltiptxt = "", bgPOI = true, leaveGap = 2 },
			dtl12 = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid_ = "" },
			dtl13 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid_ = "" },
			dtl14 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid_ = "", leaveGap = 1 }
		},

		{ 	name = "Warsong Gulch",			-- Warsong Gulch
			type = AM_TYP_BG,
			displayname = "Warsong Gulch",
			displayshort = "WSG",
			filename = "Interface\\AddOns\\AlphaMap_Battlegrounds\\Maps\\WarsongGulch",
			location = "Ashenvale (62, 84) / The Barrens (47, 8)",
			levels = "10+ Banded",
			players = "10",
			prereq = "",
			general = "",
			wmData = { minX = 0.26, maxX = 0.74, minY =  0.05, maxY = 0.95 },
			amData = { minX = 0.33, maxX = 0.97, minY = 0.12, maxY = 0.88 },
			dtl1  = { text = "Alliance Flag Room", colour = AM_BLUE, coords = { {64.31, 14.15} }, symbol = { "F" },
					tooltiptxt = "Alliance players start here" },
			dtl2  = { text = "Alliance Exit", colour = AM_BLUE, coords = { {45.93, 22.34} }, symbol = { AM_EXIT_SYMBOL },
					tooltiptxt = "Use or /afk", leaveGap = 1 },
			dtl3  = { text = "Horde Flag Room", colour = AM_RED, coords = { {70.75, 85.31} }, symbol = { "F" },
					tooltiptxt = "Horde players start here" },
			dtl4  = { text = "Horde Exit", colour = AM_RED, coords = { {87.75, 77.12} }, symbol = { AM_EXIT_SYMBOL },
					tooltiptxt = "Use or /afk", leaveGap = 1 },
			dtl5  = { text = "Power Buff", colour = AM_GREEN, coords = { {55.35, 60.26}, {76.26, 39.67} }, symbol = { "P" },
					tooltiptxt = "" },
			dtl6  = { text = "Rejuvination", colour = AM_GREEN, coords = { {81.09, 61.43}, {56.04, 39.20} }, symbol = { "R" },
					tooltiptxt = "Restores HP & Mana", leaveGap = 2 },
			dtl7  = { text = "Alliance Flag Carrier", colour = AM_BLUE, coords = { {30, 15} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "A" },
			dtl8  = { text = "Horde Flag Carrier", colour = AM_RED, coords = { {30, 85} }, symbol = { "FC" },
					tooltiptxt = "", bgFlag = "H", leaveGap = 2 },
			dtl9  = { text = " ", colour = AM_GREEN, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "WSGMisc" },
			dtl10 = { text = " ", colour = AM_BLUE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "WSGBlue" },
			dtl11 = { text = " ", colour = AM_PURPLE, coords = { {0, 0 } }, symbol = { AM_PVP },
					tooltiptxt = "", lootid = "WSGPurple", leaveGap = 1 }
		},

};




