--------------------------------------------------------------------------
-- localization.lua
--------------------------------------------------------------------------



SLASH_ALPHAMAPSLASH1 = "/AlphaMap";
SLASH_ALPHAMAPSLASH2 = "/am";

AM_SLASH_LOAD_HELP_USAGE	= "Alpha Map"

BINDING_HEADER_ALPHAMAP		= "AlphaMap Key Bindings";
BINDING_NAME_TOGGLEALPHAMAP	= "Toggle AlphaMap";
BINDING_NAME_INCREMENTALPHAMAP 	= "Increase AlphaMap Opacity";
BINDING_NAME_DECREMENTALPHAMAP 	= "Decrease AlphaMap Opacity";
BINDING_NAME_CLEARVIEWALPHAMAP	= "Show/Hide all Notes/Icons";
BINDING_NAME_CYCLEWMMODE	= "Cycle WorldMap Modes";
BINDING_NAME_HOT_SPOT		= "Hot Spot";

--Colored State values
ALPHA_MAP_GREEN_ENABLED = "|c0000FF00Enabled|r";
ALPHA_MAP_RED_DISABLED = "|c00FF0000Disabled|r";

--Slash Help
AM_SLASH_HELP_USAGE         = "AlphaMap Usage: /alphamap or /am:";
AM_SLASH_HELP_ENABLE        = "/am enable - enable / re-enable AlphaMap";
AM_SLASH_HELP_DISABLE       = "/am disable - disable AlphaMap";
AM_SLASH_HELP_RESET         = "/am reset - reset AlphaMap options to default.";
AM_SLASH_HELP_RAID          = "/am raid - show Raid Pins";
AM_SLASH_HELP_PTIPS         = "/am ptips - show party tooltips";
AM_SLASH_HELP_MNTIPS        = "/am mntips - show MapNotes tips";
AM_SLASH_HELP_GTIPS         = "/am gtips - show Gatherer tips";
AM_SLASH_HELP_MNGTIPS       = "/am mngtips - show MapNotes Gathering tips";
AM_SLASH_HELP_MOVESLIDER    = "/am moveslider - toggle movement of the slider";
AM_SLASH_HELP_SLIDER        = "/am slider - toggle display of slider";
AM_SLASH_HELP_GATHERER      = "/am gatherer - toggle support for Gatherer";
AM_SLASH_HELP_MAPNOTES      = "/am mapnotes - toggle support for MapNotes";
AM_SLASH_HELP_GATHERING     = "/am gathering - toggle support for MapNotes Gathering";
AM_SLASH_HELP_AUTOCLOSE     = "/am combat - toggle Autoclose on Combat";
AM_SLASH_HELP_AUTOOPEN	    = "/am reopen - toggle Re-Open after Combat";
AM_SLASH_HELP_WMCLOSE       = "/am wmclose - toggle Autoclose on WorldMap close";
AM_SLASH_HELP_LOCK          = "/am lock - toggle movement of the AlphaMap";
AM_SLASH_HELP_SCALE         = "/am scale |c0000AA00<value>|r - set the alphamap window scale (Range 0.0 - 1.0)";
AM_SLASH_HELP_DDSCALE		= "/am ddscale |c0000AA00<value>|r - set the Map Selector scale (Range 0.3 - 1.4)";
AM_SLASH_HELP_TOG           = "|c00FF0000/am tog  - toggle display of alphamap|r";
AM_SLASH_HELP_ALPHA         = "/am alpha |c0000AA00<value>|r - set the transparency of alphamap (Range 0.0 - 1.0)";
AM_SLASH_HELP_MINIMAP	    = "/am minimap - toggle the display of the Minimap button";
AM_SLASH_HELP_SEARCH		= "/am -s <Text to search for>";
AM_SLASH_HELP_HELP	    = "/am help  <OR>  /am ?  - lists the AlphaMap slash commands";

ALPHA_MAP_LOAD_CONFIRM = "|c00A335EDAlphaMap |c0000FF00v."..ALPHA_MAP_VERSION.." |c00A335ED is Loaded - Type "..SLASH_ALPHAMAPSLASH1.." or "..SLASH_ALPHAMAPSLASH2.." for options|r";

ALPHA_MAP_ENABLED = "|c0000BFFFAlphaMap is now "..ALPHA_MAP_GREEN_ENABLED;
ALPHA_MAP_DISABLED = "|c0000BFFFAlphaMap is now "..ALPHA_MAP_RED_DISABLED;

ALPHA_MAP_UI_LOCKED = "AlphaMap: User Interface |c00FF0000Locked|r.";
ALPHA_MAP_UI_UNLOCKED = "AlphaMap: User Interface |c0000FF00Unlocked|r.";
ALPHA_MAP_UI_LOCK_HELP = "If this option is checked, the AlphaMap will be locked into place and can't be moved.";

ALPHA_MAP_DISABLED_HINT = "Hint: AlphaMap is "..ALPHA_MAP_RED_DISABLED..".  Type |C0000AA00'/am Enable'|R to re-enable.";

ALPHA_MAP_CONFIG_SLIDER_STATE       = "AlphaMap: Slider Movement ";
ALPHA_MAP_CONFIG_COMBAT_STATE       = "AlphaMap: AutoClose on Combat ";
ALPHA_MAP_CONFIG_REOPEN_STATE	    = "AlphaMap: Re-Open after Combat ";
ALPHA_MAP_CONFIG_RAID_STATE         = "AlphaMap: Raid Pins ";
ALPHA_MAP_CONFIG_PTIPS_STATE        = "AlphaMap: Party/Raid ToolTips ";
ALPHA_MAP_CONFIG_MNTIPS_STATE       = "AlphaMap: MapNotes ToolTips ";
ALPHA_MAP_CONFIG_MNGTIPS_STATE      = "AlphaMap: MapNotes Gathering ToolTips ";
ALPHA_MAP_CONFIG_GTIPS_STATE        = "AlphaMap: Gatherer ToolTips ";
ALPHA_MAP_CONFIG_WMCLOSE_STATE      = "AlphaMap: Close on WorldMap Close ";
ALPHA_MAP_CONFIG_GATHERING_STATE    = "AlphaMap: MapNotes Gathering Support ";
ALPHA_MAP_CONFIG_GATHERER_STATE     = "AlphaMap: Gatherer Support ";
ALPHA_MAP_CONFIG_MAPNOTES_STATE     = "AlphaMap: MapNotes Support ";

AM_OPTIONS			= "Options";
AM_OPTIONS_TITLE		= "AlphaMap "..AM_OPTIONS;
AM_OPTIONS_RESET		= "Reset ALL";
AM_OPTIONS_CLOSE		= "Close";
AM_OPTIONS_MAPNOTES		= "Enable Map Notes";
AM_OPTIONS_MAPNOTES_TOOLTIPS	= "Display Map Notes Tooltips";
AM_OPTIONS_MAPNOTESG		= "Enable MapNotes Gathering Icons";
AM_OPTIONS_MAPNOTESG_TOOLTIPS 	= "Display MapNotes Gathering Tooltips";
AM_OPTIONS_GATHERER		= "Enable Gatherer Icons";
AM_OPTIONS_GATHERER_TOOLTIPS	= "Display Gatherer Tooltips";
AM_OPTIONS_PARTY_TOOLTIPS	= "Display Group Tooltips";
AM_OPTIONS_RAID_PINS		= "Enable Group Pins";
AM_OPTIONS_SLIDER		= "Display Alpha Slider on Map";
AM_OPTIONS_SLIDER_MOVE		= "Allow Movement of Alpha Slider";
AM_OPTIONS_AUTOCLOSE_COMBAT	= "Close Map when Combat starts";
AM_OPTIONS_AUTOOPEN_COMBAT	= "Re-Open Map after Combat ends";
AM_OPTIONS_AUTOCLOSE_WORLDMAP	= "Close Map when World Map closes";
AM_OPTIONS_ANGLESLIDER		= "Minimap Angle  : ";
AM_OPTIONS_RADIUSLIDER		= "Minimap Radius : ";
AM_OPTIONS_ALPHASLIDER		= "Map Opacity : ";
AM_OPTIONS_SCALESLIDER		= " Map Scale  : ";
AM_OPTIONS_MAP_LOCK		= "Lock AlphaMap Position";
AM_OPTIONS_MINIMAP		= "Display Minimap Button";
AM_OPTIONS_CLEARVIEW_OFF	= "Hide Enabled Icons";
AM_OPTIONS_CLEARVIEW_ON		= "|c00FF0000All Icons Currently Hidden|r";
AM_OPTIONS_LEGACYPLAYER		= "Display Legacy style Player Icon";
AM_OPTIONS_ZONE_SELECTOR	= "Display Map Selector";
AM_OPTIONS_GENERAL_CHAT		= "General Chat";
AM_OPTIONS_DUNGEON		= "Dungeons";
AM_OPTIONS_MAPS			= "Map Selector";
AM_OPTIONS_ADDONS		= "WorldMap Notes & Icons : ";
AM_OPTIONS_MISC			= "Internal AddOn Options : ";
AM_OPTIONS_DUNGEON_NOTES	= "AlphaMap Note Options : ";
AM_OPTIONS_DUNGEON_FRAMES	= "AlphaMap Extra Information : ";
AM_OPTIONS_DM_NOTES		= "Display AlphaMap Notes";
AM_OPTIONS_DM_NOTES_TOOLTIPS	= "Display AlphaMap Note Tooltips";
AM_OPTIONS_DM_NOTES_BCKGRND	= "Show Note Background";
AM_OPTIONS_DM_NBG_SET		= "Set Note Background Colour";
AM_OPTIONS_DM_HEADER		= "Show Header Information";
AM_OPTIONS_DM_EXTRA		= "Show Footer Information";
AM_OPTIONS_DM_KEY		= "Show Map Key";
AM_OPTIONS_DM_KEY_TOOLTIPS	= "Show Map Key Tooltips";
AM_OPTIONS_DM_NOTESCALE		= "Set AlphaMap Note Size";
AM_OPTIONS_RESTORE		= "Apply";
AM_MISC				= "Miscellaneous";
AM_OPTIONS_DM_MISC		= AM_MISC.." : ";
AM_OPTIONS_DM_MAP_BCKGRND	= "Show Map Background";
AM_OPTIONS_DM_MBG_SET		= "Set Map Background Colour";
AM_OPTIONS_DM_TEXT_BCKGRND	= "Show Text Background";
AM_OPTIONS_DM_TEXTBG_SET	= "Set Text Background Colour";
AM_OPTIONS_MAP_BOXES		= "Position of AlphaMap Selector :";
AM_OPTIONS_UNDOCKED		= "AlphaMap Selector is : ";
AM_OPTIONS_FREE			= "Free Floating";
AM_OPTIONS_FREE_LOCKED		= "(Locked)";
AM_OPTIONS_MAPPED		= "Attached to AlphaMap";
AM_OPTIONS_DOCK_IT			= "Dock to Options Frame";
AM_OPTIONS_FREE_IT			= "Free Floating";
AM_OPTIONS_MAP_IT			= "Attach to AlphaMap";
AM_OPTIONS_HOW_TO_MAP		= "Anchor to AlphaMap by : ";
AM_OPTIONS_MAP_LINK			= "to";
AM_OPTIONS_HOTSPOT_BEHAVE	= "HotSpot Behaviour : ";
AM_OPTIONS_HOTSPOT_DISABLE	= "Enable HotSpot Functionality";
AM_OPTIONS_HOTSPOT_OPEN		= "Open AlphaMap if Closed";
AM_OPTIONS_HOTSPOT_OPACITY	= "Fully Opaque AlphaMap";
AM_OPTIONS_HOTSPOT_WORLDI	= "Toggle World Icons/Notes";
AM_OPTIONS_HOTSPOT_DUNGI	= "Toggle Dungeon AlphaMap Notes";
AM_OPTIONS_HOTSPOT_NBG		= "Toggle Note Backgrounds";
AM_OPTIONS_HOTSPOT_MBG		= "Toggle Map Background";
AM_OPTIONS_HOTSPOT_MINIMAP	= "Enable Minimap Button as HotSpot";
AM_OPTIONS_HOTSPOT_INFO		= "Toggle Key/Header/Footer";
AM_OPTIONS_BG_USE_AM		= "Use AlphaMap's BattleGround maps\nby default when in Battlegrounds";
AM_OPTIONS_TYPE_SAVE_LABEL	= "Control settings for all %s Maps : ";
AM_OPTIONS_TYPE_ALL			= "Setting Changes for %s Maps";
AM_MANUAL_APPLY				= "Manually";
AM_AUTO_APPLY				= "Auto";
AM_AUTO_SWITCH				= "Auto Switch to %s Maps";
AM_AUTO_OPEN				= "Auto Open BG Maps";
AM_OPTIONS_TYPE_SAVE		= "%s Apply to ALL %s Maps";
AM_OPTIONS_BG_MESSAGES		= "Send Battlefield Messages to : ";
AM_OPTIONS_RAID				= "Raid";
AM_OPTIONS_PARTY			= "Party";
AM_OPTIONS_GENERAL			= "General";
AM_OPTIONS_GUILD			= "Guild";
AM_OPTIONS_GROUP_DEFAULT	= "Group Dependant";
AM_OPTIONS_NUN_AUTO			= "Auto-Send NuN Note Settings";
AM_OPTIONS_NUN_FORMAT		= "Send Formatted Notes";
AM_OPTIONS_NUN_MESSAGES		= "Auto Send NuN Notes to : ";
AM_OPTIONS_WMAP_MODES		= "World Map View Modes :";
AM_OPTIONS_GMAP_MODES		= "Blizzard Map Settings :";
AM_OPTIONS_GMAP_ALLOW		= "Allow changes to Blizzard Map";
AM_OPTIONS_GMAP_CHANGE		= "Check to change Blizzard Map";
AM_OPTIONS_WMAP_SMODE		= "Standard";
AM_OPTIONS_WMAP_OMODE		= "Compact";
AM_OPTIONS_WMAP_MINIMODE	= "Minimap Textures";
AM_OPTIONS_WMAP_ZMINIMODE	= "Zoomed Minimap";
AM_OPTIONS_WMOTHER		= "Other Map Controls : ";
AM_OPTIONS_WM_ESCAPE		= "Enable <Escape> Closing";
AM_OPTIONS_WM_MOUSE		= "Enable Mouse Interaction";
AM_OPTIONS_MUTE			= "Mute";
AM_OPTIONS_COORDS		= "(x, y)";
AM_OPTIONS_MAPS1		= "AlphaMap Maps 1";
AM_OPTIONS_MAPS2		= "  ..... 2";
AM_OPTIONS_HELP_TIPS		= "Help Tooltips";

AM_INSTANCE_TITLE_LOCATION	= "Location ";
AM_INSTANCE_TITLE_LEVELS	= "Levels ";
AM_INSTANCE_TITLE_PLAYERS	= "Max. Players ";
AM_INSTANCE_CHESTS		= "Chest ";
AM_INSTANCE_STAIRS		= "Stairs";
AM_INSTANCE_ENTRANCES		= "Entrance ";
AM_INSTANCE_EXITS		= "Exit ";
AM_LEADSTO			= "Leads to...";
AM_INSTANCE_PREREQS		= "Prerequisites : ";
AM_INSTANCE_GENERAL		= "General Notes : ";
AM_RARE				= "(Rare)";
AM_VARIES			= "(Varies)";
AM_WANDERS			= "(Patrols)";
AM_OPTIONAL			= "(Optional)";

AM_NO_LIMIT			= "No Player Limit";

AM_MOB_LOOT 			= "Mob Loot";
AM_RBOSS_DROP 			= "Random Boss Drops";
AM_ENCHANTS			= "Enchants";
AM_PVP_SET			= "PvP Sets";

AM_PVP				= "PvP";

AM_ANCHOR_POINT 	= {	{ Display = "Top",			-- Localise
				  Command = "TOP" },					-- Do NOT Localise
				{ Display = "Top Right",		-- Localise
				  Command = "TOPRIGHT" },				-- Do NOT Localise
				{ Display = "Right",			-- Localise
				  Command = "RIGHT" },					-- Do NOT Localise
				{ Display = "Bottom Right",		-- Localise
				  Command = "BOTTOMRIGHT" },				-- Do NOT Localise
				{ Display = "Bottom",			-- Localise
				  Command = "BOTTOM" },					-- Do NOT Localise
				{ Display = "Bottom Left",		-- Localise
				  Command = "BOTTOMLEFT" },				-- Do NOT Localise
				{ Display = "Left",			-- Localise
				  Command = "LEFT" },					-- Do NOT Localise
				{ Display = "Top Left",			-- Localise
				  Command = "TOPLEFT" }					-- Do NOT Localise
			};

AM_BG_ONLY			= "Only";
AM_BG_ALL			= "All";
AM_BG_BASE			= "Base";
AM_BG_BASES			= "Bases";
AM_BG_REQUIRED		= "%s %d %s required to Win %s";

AM_EXTERIOR = " Exterior";

AM_RCMENU_INC			= " Inc ";		-- as in 5 inc Blacksmith   or  3 inc farm
AM_RCMENU_ZERG			= "Zerg";		-- as in Zerg Inc Frostwolf GY
AM_OK				= "OK";
AM_RCMENU_HIGHLIGHT		= "Highlight";		-- as in leave this note highlighted on the map
AM_RCMENU_NUN_AUTO		= "Auto-Send Note";	-- send the NotesUNeed note for the current map note to Raid/Party/...
AM_RCMENU_NUN_MAN		= "Manual Send Note";
AM_RCMENU_NUN_OPEN		= "Open Note";
AM_RCMENU_AFLAG			= "Alliance Flag ";
AM_RCMENU_HFLAG			= "Horde Flag ";
AM_RCMENU_FLAGLOC		= {	"Our Tunnel",
					"Our Roof",
					"Going West",
					"Going East",
					"In Middle",
					"Their Tunnel",
					"Their Roof",
					"Their Flag Room",
					"Their GY"
				};

AM_OPENING = "AQ Opening Quest Chain";

AM_HORDE		= "Horde";
AM_PICKED		= { 	word = "picked",
				posWord = " by ",
				extraChars = 1 };

-- Deutsch
--AM_PICKED		= {	word = "aufgenommen" };

-- Francais
--AM_PICKED		= {	word = "ramass\195\169",
--				posWord = " par ",
--				extraChars = 2 };

AM_NEUTRAL		= "Neutral";
AM_FRIENDLY		= "Friendly";
AM_HONOURED		= "Honoured";
AM_REVERED		= "Revered";
AM_EXALTED		= "Exalted";

AM_CONFIG_SAVED			= "AlphaMap Settings changed for : ";

AM_CANCEL			= "Cancel";

AM_CORPSE_TXT			= "Dead";
AM_RESET_INSTANCE		= "Reset";

AM_PERFORMANCE_WARNING1		= "AlphaMap has detected a Performance Problem with the following AddOn : ";
AM_PERFORMANCE_WARNING2		= "AlphaMap will ignore Map Updates Triggered by this AddOn.\nYou only need to report this Warning message if you think it has caused another problem.";

AM_UPDATE_WARNING	= AM_YELLOW.."AlphaMap|r\n\nMouse Interaction Mode (Map Zoom) Now Uses the "..AM_GREEN.."<ALT>|r Key.\nNOT the "..AM_RED.."<CONTROL>|r Key\n ";

--------------------------------------------------------------------------------------------------------------------------------------
-- TOOLTIPS															    --
--------------------------------------------------------------------------------------------------------------------------------------

AM_TT_MINIMAP_BUTTON	= "AlphaMap\nLeft Click Toggles AlphaMap\nRight Click Toggles Options";
AM_TT_ALPHA_BUTTON1	= "AlphaMap";
AM_TT_ALPHA_BUTTON2	= "Left Click Toggles AlphaMap\nRight Click Toggles Options";
AM_TT_PAUSE1		= "Pause";
AM_TT_PAUSE2		= "Click to Pause map updates and allow you to open/close without resetting to current map Also use if another conflicting AddOn continually resets the AlphaMap to the current zone";
AM_TT_PLAY1		= "Play";
AM_TT_PLAY2		= "i.e. Click now to Un-Pause map updates";
AM_TT_HOTSPOT1		= "HotSpot";
AM_TT_HOTSPOT2		= "Quick Mouse-Over facility to change the AlphaMap view e.g. show/hide the map or Notes/Icons, or make fully opaque See Map Selector Tab of Options for full list (Key Binding available)";
AM_TT_LOCK1		= "Lock Map Selector";
AM_TT_LOCK2		= "Un-lock to show a frame with which to move the Map Selection drop down boxes";
AM_TT_TAB1		= "Original AlphaMap Options";
AM_TT_TAB2A		= "Specific options only for Maps included with AlphaMap and NOT Blizzard maps.";
AM_TT_TAB2B		= "e.g. Map/Note/Text backgrounds, and which notes/extra information to show NOTE : Only applies to AlphaMap Maps, and not applicable when viewing world map zones";
AM_TT_TAB3A		= "Further settings only applicable to AlphaMap Maps";
AM_TT_TAB3B		= "NOTE : Only applies to AlphaMap Maps, and not applicable when viewing world map zones";
AM_TT_TAB4		= "Set the position of the Map Selector Drop Down box controls  and define Hot Spot behaviour";
AM_TT_TAB5		= "Miscallaneous AlphaMap settings and integration with other AddOns";
AM_TT_MAPNOTES		= "Enable display of MapNotes, CTMap_Mod notes, MetaMapNotes, MapNotes(Cosmos)";
AM_TT_RAID1		= "Un-Check to ONLY show Party Pins";
AM_TT_RAID2		= "(Even when in Raid)";
AM_TT_CLEAR1		= "Show/Hide all above Enabled Icons/Notes Also see Key Binding for same function";
AM_TT_CLEAR2		= "e.g. Quick way to un-clutter the map OR Hide all, and use Hot Spot to make them visible when needed";
AM_TT_SLIDER		= "Show an Opacity Slider Control On the AlphaMap";
AM_TT_SLIDERM1		= "Check to enable movement of the on-map Opacity Slider";
AM_TT_SLIDERM2		= "Drop anywhere on the Map to re-locate it there Drop 'off' the AlphaMap to detach it (Can also be moved with the mouse when the Alt key is pressed in Mouse Interaction mode)";
AM_TT_ACLOSE1		= "Auto-Close AlphaMap when entering Combat";
AM_TT_ACLOSE2		= "(Useful if you play with map always displayed)";
AM_TT_AOPEN		= "Auto-Re-Open AlphaMap when leaving Combat";
AM_TT_LEGACY1		= "Original Player & Party Directional Icons";
AM_TT_LEGACY2		= "May suffer from blinking Minimap Icons";
AM_TT_AM_NOTES1		= "Display AlphaMap's on-map notes";
AM_TT_AM_NOTES2		= "(These are NOT the same as MapNotes  and can not be changed)";
AM_TT_ALL_INSTANCE1	= "Un-check to save the settings for each Instance map seperately";
AM_TT_ALL_INSTANCE2	= "e.g. you might want a dark background for Zul'Farrak, but a light one for Molten Core. Keep checked if you want to make sure that when you make ANY change to ANY Instance Map then the settings will be copied to ALL the other Instance maps";
AM_TT_KEY		= "i.e. Show Map Legend";
AM_TT_ALL_BG1		= "Un-check to save the settings for each Battleground map seperately";
AM_TT_ALL_BG2		= "e.g. you might want AV to display at a larger scale than Warsong.  Keep checked if you want to make sure that when you make ANY change to ANY Battleground Map then the settings will be copied to ALL the other Battleground maps";
AM_TT_ALL_NI1		= "Un-check to save the settings for each Non-Instance map seperately";
AM_TT_ALL_NI2		= "e.g. you might not want to display the Map Legend for dungeon exteriors   but do want it for World Boss maps.  Keep checked if you want to make sure that when you make ANY change to ANY Non-Instance Map then the settings will be copied to ALL the other Non-Instance maps";
AM_TT_MSG		= "Battleground Messages will be sent to :";
AM_TT_MSG_DFLT2		= " - your Raid if you were in a Raid BEFORE you entered the Battleground\n - your Party if you were in a Party BEFORE you entered the Battleground\n - the Battleground channel otherwise";
AM_TT_MSG_PARTY2	= " - only your Party as long as you were in a Raid or Party BEFORE you entered the Battleground\n - the Battleground channel otherwise";
AM_TT_MSG_BG2		= " - the Battleground channel only";
AM_TT_AUTO_BG1		= "Makes AlphaMap's Battleground map the default map to be used in Battlegrounds";
AM_TT_AUTO_BG2		= "Battlegound maps will open automatically when you enter a Battleground if this option is checked Un-Check if you wish to use the normal Blizzard style map in Battlegrounds (The map will not open automatically when you enter a BG)";
AM_TT_NUN_F1		= "Formatted NotesUNeed notes can be added to the database of people who receive them";
AM_TT_NUN_F2		= "(However, people without NotesUNeed installed will see extra formatting characters rather than just the note's text.)";
AM_TT_NUN			= "NotesUNeed notes will be auto-sent to :";
AM_TT_NUN_DFLT2		= " - your Raid if in a Raid\n - your Party if in a Party\n - otherwise you will just '/Say' the note  \n\nNote that Raid/Party messages will fail inside Battlegrounds unless \nyou were in the Raid/Party BEFORE you entered the Battleground";
AM_TT_NUN_PARTY2	= " - only your Party, if you are in a Raid OR Party\n - otherwise you will just '/Say' the note \n\nNote that Raid/Party messages will fail inside Battlegrounds unless \nyou were in the Raid/Party BEFORE you entered the Battleground";
AM_TT_NUN_GUILD2	= " - your Guild";
AM_TT_MOUSE1		= "Mouse Interaction mode allows you to Alt-Click the AlphaMap";
AM_TT_MOUSE2		= "Normally the AlphaMap is invisible to the mouse. However, in mouse interaction mode, then when the Alt key is pressed you will be able to see the name of map regions that your mouse hovers  over, and can Alt-Left Click and Alt-Right Click to zoom in and out. When in Mouse Interaction mode, you can also Alt-Click on the AlphaMap Slider and on-map Coordinates to reposition them";
AM_TT_MUTE			= "Toggle the sound when Opening/Closing the AlphaMap";
AM_TT_XY			= "Toggle the display of Player/Cursor coordinates";
AM_TT_STANDARD		= "Standard View - world map Zones as displayed in the original Blizzard Map";
AM_TT_COMPACT1		= "Compact View - Only display explorable areas in the current Zone";
AM_TT_COMPACT2		= "Note that areas that you have NOT discovered will not be displayed unless you have installed MozzFullWorldMap (Fan's Update) AddOn";
AM_TT_BLIZZ_ALLOW1	= "While checked, AlphaMap will save any changes you make to the Blizzard Map position/opacity/scale";
AM_TT_BLIZZ_ALLOW2	= "Un-Check to restore the original Blizzard Map settings This requires a 'ReloadUI' during which the game will pause for a few seconds";
AM_TT_BLIZZ_CHANGE1	= "While checked, then changes to the opacity and scale sliders below Will only affect the original Blizzard Map";
AM_TT_HELP_TIPS1	= "Toggle Help Tooltips";
AM_TT_HELP_TIPS2	= "Does not affect on map icon tooltips";

--------------------------------------------------------------------------------------------------------------------------------------
-- Everything below should be localised apart from the 'filename', 'lootid' entries which should NOT be changed                     --
-- The first  'name'  field is used to equate with in game Zone name information to help determine when the player is in a specific --
-- Instance, and must therefore be spelt IDENTICALLY to the names of the Instances as displayed by the WoW Client in other native   --
-- frames.															    --
--------------------------------------------------------------------------------------------------------------------------------------

AM_TYP_WM			= "World Map";
AM_TYP_GM			= "Blizzard Map";

--AM_TYP_INSTANCE		= "Instances";
--AM_TYP_BG			= "Battlegrounds";
--AM_TYP_WORLDBOSSES	= "World Bosses";
--AM_TYP_CAVES		= "Caves";


