--[[
Name: AlarLib-2.0
Revision: $Rev: 70551 $
Author: Alar of Daggerspine
Email: alar@aspide.it
Website: http://wow.aspide.it
Documentation: http://wiki.wowace.com/index.php/!AlarLib
SVN: $HeadUrl:$g
Description: Generic library
Dependencies: Ace2,Waterfall-1.0,DewDrop-2.0,Babble-Inventory-2.0, TabletLib
License: LGPL v2.1
--]]
local _G = getfenv(0)
local L
BINDING_HEADER_ALARADDON="Alar's AddOns Biddings"
local MAJOR_VERSION = "AlarLib-2.0"
local MINOR_VERSION = tonumber(string.sub("$Revision: 70551 $", 12, -3))
local DEFAULT_LOCALE = "enUS"
local function pp(arg)
    DEFAULT_CHAT_FRAME:AddMessage(tostring(arg),1,0.5,0.2)
end
if (not IsAddOnLoaded('Ace2') and not AceLibrary) then
    local nome,title=GetAddOnInfo('Ace2')
    if (title) then
        EnableAddOn(nome)
        error(MAJOR_VERSION .. " requires Ace2. I enabled it for you. Please ReloadUI or Relog")
    else
        error(MAJOR_VERSION .. " requires Ace2. Please install it.")
    end
end
DisableAddOn("!AlarLib")
-- This ensures the code is only executed if the library doesn't already exist, or is a newer version
if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then
    pp("Skipping AlarLib revision " .. MAJOR_VERSION .. '.' .. MINOR_VERSION)
    return
end
------------------------------------------- Last Version ----------------------
local totw=800
local panw=600
local function str2num(versione)
    versione =versione or 0
    if (type(versione) == "string") then
        local a,b,c=versione:match("(%d*)%D?(%d*)%D?(%d*)%D*")
        a=tonumber(a) or 0
        b=tonumber(b) or 0
        c=tonumber(c) or 0
        return a*1000+b+c/100
    else
        return versione
    end
end
local devpc=ALARDEVELOPMENTPC
if (not AlarLibData) then
    AlarLibData={
        missingkey={},
        data={}
    }
end
-- Global Volatile Repository for shared in game data
if (not AMOCOMMON) then
    AMOCOMMON=
    {
        help={},
        Addons={
        AlarAutomation=1,
        AlarArtRemover=1,
        AlarCraftReverse=1,
        AlarBGHelper=1,
        AlarTTFrame=1,
        },
        Versioni={},
        Users={},
        LocalTip=CreateFrame("GameTooltip","AMO_Tip",UIParent,"GameTooltipTemplate"),
    }
    AMOCOMMON.LocalTip:SetOwner(UIParent, "ANCHOR_NONE")
    AMOCOMMON.texture =AMOCOMMON.LocalTip:CreateTexture()
    AMOCOMMON.fontstring =AMOCOMMON.LocalTip:CreateFontString()
    AMOCOMMON.Translations={}
end
local key = {"1","2","3","4","5","6","7","8","9","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"}
key[0] = "0"
local function to36(data)
	if not tonumber(data) then
		return data
	end
	local working = tonumber(data)
	local newstr = ""
	if working == 0 then
		newstr = "0"
	end
	while working > 0 do
		newstr = key[working%36]..newstr
		working = math.floor(working / 36)
	end
	return newstr
end
local alphakey={
    a=1,
    e=2,
    i=3,
    o=4,
    u=5,
    j=6,
    b=7,
    c=8,
    d=9,
    f=10,
    g=11,
    h=12,
    k=13,
    l=14,
    m=15,
    n=16,
    p=17,
    q=18,
    r=19,
    s=20,
    t=21,
    v=22,
    w=23,
    x=24,
    y=25,
    z=26
}
local function AlphaPack(nome)
    nome=strlower(nome)
    nome=nome:gsub('[^abcdefghijklmnopqrstuvwxyz]','')
    local x=strlen(nome)
    local valore=""
    local fattore=10
    for i=1,x,fattore do
        local hash=1
        for k=i,fattore-1 do
            hash=hash*alphakey[nome:sub(k,k)]
        end
        valore=valore .. to36(hash)
    end
    return valore
end

if (not AMOCOMMON.ItemCache) then
    AMOCOMMON.ItemCache={}
end
--[[ Remapping this function argument
itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount,
itemEquipLoc, itemTexture = GetItemInfo(itemID)
--]]
local itembuffer=setmetatable({},{__mode="kv"})
AMOib=itembuffer
local itemcachekey={
    id=1,
    name=2,
    link=3,
    rarity=4,
    level=5,
    minlevel=6,
    type=7,
    subtype=8,
    stackcount=9,
    equiploc=10,
    texture=11,
    full=7,
}
local itemcachemtdetails={
    __index = function(t,k)
        k=k or 1
        local i=itemcachekey[k] or 1
        return rawget(t,i)
    end,
}
local itemcachemt={
    __index= function(tbl,key)
        if (not key) then
            return {}
        end
        local a,b,c,d,e,f,g,h,i,j=GetItemInfo(key)
        if (a) then
            local z=b:match("Hitem:(%d+):")
            local tbx=setmetatable({z,a,b,c,d,e,f,g,h,i,j},itemcachemtdetails)
            rawset(tbl,a,tbx)
            rawset(tbl,z,tbx)
            return tbx
        else
            if (itembuffer[key]) then
                return itembuffer[key]
            else
                return {}
            end
        end
    end,
    __newindex=function(tbl,key,value)
        local id=value:match("Hitem:(%d+):")
        local tbx=setmetatable({id,key,value},itemcachemtdetails)
        rawset (itembuffer,id,tbx)
        rawset (itembuffer,key,tbx)
    end
}
setmetatable(AMOCOMMON.ItemCache,itemcachemt)

if (devpc) then
    AMOCOMMON.AlarTest=1
end

AMOCOMMON.messages=AMOCOMMON.messages or {}
--
function CheckLibraries(libs)
    local errors
    for desc,lib in ipairs(libs) do
        lib=lib or desc
        if not AceLibrary:HasInstance(lib) then
            DEFAULT_CHAT_FRAME:AddMessage(desc .. " required |r",1,0.5,0.2)
            local name,title=GetAddOnInfo(desc)
            if (title) then
                EnableAddOn(name)
                if (IsAddOnLoadOnDemand(name)) then
                    LoadAddOn(name)
                else
                    errors=true
                    DEFAULT_CHAT_FRAME:AddMessage("Enabling it.You need to relog)",1,0.5,0.2)
                end
            else
                errors=true
                DEFAULT_CHAT_FRAME:AddMessage("Please install it",1,0.5,0.2)
            end
        end
    end
    return errors
end
local new, del
do
	local list = setmetatable({}, {__mode="k"})
	function new()
		local t = next(list)
		if t then
			list[t] = nil
			return t
		else
			return {}
		end
	end
	function del(t)
		setmetatable(t, nil)
		for k in pairs(t) do
			t[k] = nil
		end
		list[t] = true
	end
end
local libs={
['Babble-Inventory-2.2']=nil,
DewdropLib='DewDrop-2.0',
TabletLib='Tablet-2.0',
['Waterfall-1.0']=nil,
}
CheckLibraries(libs)
local lib=new()

-----------------------------------------------------
-- Executed only for the newest version
-- Backdrops definition
local Backdrops={
dialog = {
    bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
    tile=true,
    tileSize=32,
    edgeSize=32,
    insets={bottom=5,left=5,right=5,top=5}
},
bubble={
	bgFile = "Interface\\Tooltips\\ChatBubble-Background",
	edgeFile = "Interface\\Tooltips\\ChatBubble-BackDrop",
	tile = true, tileSize = 32, edgeSize = 32,
	insets = { left = 32, right = 32, top = 32, bottom = 32 }
},
party = {
    bgFile="Interface\\CharacterFrame\\UI-Party-Background",
    edgeFile="Interface\\CharacterFrame\\UI-Party-Border",
    tile=true,
    tileSize=32,
    edgeSize=32,
    insets={bottom=32,left=32,right=32,top=32}
},
tooltip = {
    bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
    edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
    tile=true,
    tileSize=16,
    edgeSize=16,
    insets={bottom=5,left=5,right=5,top=5}
},
border = {
    bgFile="",
    edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
    tile=true,
    tileSize=16,
    edgeSize=16,
    insets={bottom=5,left=5,right=5,top=5}
},
tutorial = {
    bgFile="Interface\\TutorialFrame\\TutorialFrameBackground",
    edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
    tile=true,
    tileSize=16,
    edgeSize=16,
    insets={bottom=7,left=7,right=7,top=7}
},
background = {
    bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
    edgeFile="",
    tile=false,
    tileSize=8,
    edgeSize=8,
    insets={bottom=3,left=3,right=3,top=3}
},
minimal = {
    bgFile="Interface\\TutorialFrame\\TutorialFrameBackground",
    edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
    tile=false,
    tileSize=8,
    edgeSize=8,
    insets={bottom=3,left=3,right=3,top=3}

}
}
Backdrops.default=Backdrops.tutorial

----- New Global Function, I check if someone already defined then
if (not string.capitalize) then
    function string.capitalize(stringa)
        return string.gsub(strlower(stringa),
                "%w",function (s) return strupper(s) end,1)
    end
end
if (not capitalize) then
    capitalize=string.capitalize
end
if (not table.kpairs) then
    function table.kpairs(t,f)
      local a = {}
      for n in pairs(t) do table.insert(a, n) end
      table.sort(a, f)
      local i = 0      -- iterator variable
      local iter = function ()   -- iterator function
        i = i + 1
        if a[i] == nil then
            return nil
        else
            local k=a[i]
            a[i]=nil -- Should optimize memory usage
            return k, t[k]
        end
      end
      return iter
    end
end
if (not kpairs) then
    kpairs=table.kpairs
end

-------------- Constants area
--- WOW or PSEUDO WOW
UIERRORS_HOLD_TIME=UIERRORS_HOLD_TIME or 1.0 -- I think this is no longer used
MAX_BAGS=MAX_BAGS or 4
MAX_BANK_BAGS=MAX_BANK_BAGS or 11
-- General COlors
AMO_AZURE                   ="|c000C92DC"
AMO_Azure                   ={r=0.05,g=0.57,b=0.86}
AMO_BLACK                   ="|c00000000"
AMO_Black                   ={r=0,g=0,b=0}
AMO_BLUE                    ="|c000000FF"
AMO_Blue                    ={r=0,g=0,b=1}
AMO_BRIGHTGREY              ="|c00D0D0D0";
AMO_Brightgrey              ={r=0.82,g=0.82,b=0.82}
AMO_CONNECTION_COLOR        ="|c0033FF66"
AMO_COPPER                  ="|c00CC9900"
AMO_DEBUG_COLOR             ="|c0000FF00"
AMO_GOLD                    ="|c00FFFF66"
AMO_GRAY                    ="|c00808080"
AMO_Gray                    ={r=0.5,g=0.5,b=0.5}
AMO_GREEN                   ="|c0020ff20"
AMO_Green                   ={r=0.12,g=1,b=0.12}
AMO_GREEN2                  ="|c0000C000"
AMO_Green2                   ={r=0.0,g=0.77,b=0.0}
AMO_GREY                    ="|c00909090"
AMO_GUILDCHAT               ="|c00269926"
AMO_HIGHLIGHT_COLOR_CODE    ="|cffffffff"
AMO_LIGHTBLUE               ="|cff515179"
AMO_LIGHTYELLOW             ="|cffffff9a"
AMO_MONEY_COLOR             ="|c00FFCC33"
AMO_ORANGE                  ="|c00ff9900"
AMO_Orange                  ={r=1.0,g=0.6,b=0.0}
AMO_PARTYCHAT               ="|c00515179"
AMO_PURPLE                  ="|c00800080"
AMO_Purple                  ={r=0.50,g=0.00,b=0.50}
AMO_RAIDCHAT                ="|c0066331a"
AMO_RED                     ="|c00ff2020"
AMO_Red                     ={r=0.96,g=0.10,b=0.0}
AMO_RED2                    ="|c00F41400"
AMO_SILVER                  ="|c00C0C0C0"
AMO_STATUS_COLOR            ="|c000066FF"
AMO_WHITE                   ="|c00FFFFFF"
AMO_White                   ={r=1,g=1,b=1}
AMO_YELLOW                  ="|cffffd200"
AMO_Yellow                  ={r=1.0,g=0.93,b=0.10}
AMO_YELLOW2                 ="|c00FFED1A"
AMO_ENDCOLOR                ="|r"
AMO_NORMAL                  = AMO_ENDCOLOR
-- Class colors
AMO_COLOR_CLASS_DRUID       ="|C00ff7d0a"
AMO_COLOR_CLASS_Druid       ={r=1.0,g=0.49,b=0.04}
AMO_COLOR_CLASS_HUNTER      ="|C00abd473"
AMO_COLOR_CLASS_Hunter      ={r=0.67,g=0.83,b=0.45}
AMO_COLOR_CLASS_MAGE        ="|C0069ccf0"
AMO_COLOR_CLASS_Mage        ={r=0.41,0.8,0.94};
AMO_COLOR_CLASS_PALADIN     ="|C00f58cba"
AMO_COLOR_CLASS_Paladin     ={r=0.96,g=0.55,0.73};
AMO_COLOR_CLASS_PRIEST      ="|C00ffffff"
AMO_COLOR_CLASS_Priest      ={r=1.0,g=1.0,b=1.0};
AMO_COLOR_CLASS_ROGUE       ="|C00fff569"
AMO_COLOR_CLASS_Rogue       ={r=1.0,g=0.96,b=0.41};
AMO_COLOR_CLASS_SHAMAN      ="|C00f58cba"
AMO_COLOR_CLASS_Shaman      ={r=0.96,g=0.55,0.73};
AMO_COLOR_CLASS_WARLOCK     ="|C009482ca"
AMO_COLOR_CLASS_Warlock     ={r=0.58,g=0.51,b=0.79}
AMO_COLOR_CLASS_WARRIOR     ="|C00c79c6e"
AMO_COLOR_CLASS_Warrior     ={r=0.78,g=0.61,b=0.43}
AMO_COLOR=setmetatable({},{
    __index = function(tbl,key)
        local colore=_G['AMO_COLOR' .. key]
        if (colore) then
            return colore.r,colore.g,colore.b
        else
            return 1,1,1
        end
    end
    }
)
function AMO_color(colore)
    if (colore) then
        return colore.r,colore.g,colore.b
    else
        return 1,1,1
    end
end
BINDING_HEADER_AMO_HEADER="Alar General Bindings"
--Buff Texture
AMO_BUFFID=AMO_BUFFID or {}
AMO_BUFFID["Soulstone Resurrection"]="Spell_Shadow_SoulGem"
---- Old generic function. Compatibility issuese
local BI=AceLibrary("Babble-Inventory-2.2")
function AMO_TTAdd(frame,message)
    AMO:TTAdd(frame,message)
end
function AMO_TTClose()
    AMO:TTClose()
end

function AMO_TTFade()
    AMO:TTFade()
end

function AMO_TTFormat(lmessage,rmessage)
    AMO:TTOpen(lmessage,rmessage)
end
function AMO_TTOpen(message,message2)
    AMO:TTOpen(message)
end

--------------------------------------------------------------------------------
local AMO_Events={
    ADDON_ACTION_BLOCKED=nil,
    ADDON_ACTION_FORBIDDEN=nil,
    CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS=nil,
    MACRO_ACTION_BLOCKED=nil,
    MACRO_ACTION_FORBIDDEN=nil,
    ACTIONBAR_SLOT_CHANGED=0,
    CHAT_MSG_ADDON=0, -- Filtered out
    PLAYER_LEVEL_UP=0,
    PLAYER_REGEN_DISABLED=0,-- Time to make last precombat changes
    PLAYER_REGEN_ENABLED=0, -- TIme to make first postcombat changes
    SPELLS_CHANGED=0,
    UPDATE_BINDINGS=0,
    ZONE_CHANGED_NEW_AREA=0,
    UNIT_SPELLCAST_SENT=nil,
    UNIT_SPELLCAST_SUCCEEDED=nil,
}
lib=AceLibrary("AceAddon-2.0"):new("AceEvent-2.0","AceConsole-2.0","AceDebug-2.0")
--local AMO={}
lib.ID="AMO"
local quiver=BI["Quiver"]
local ammopouch=BI["Ammo Pouch"]
BI=nil
function lib:UnPack(token)
    tonumber(token,36)
end
function lib:Pack(valore)
    self:argCheck(valore,1,"string","number")
    if (type(valore)=="number") then
        return to36(valore)
    else
        return AlphaPack(valore)
    end
end
function lib:Alar()
    return ALARDEVELOPMENTPC
end
function lib:CheckLibraries(libs,crash)
    CheckLibraries(libs)
end
function lib:FindQuiver()
    return self:FindBag(quiver)
end
function lib:FindAmmoPouch()
    return self:FindBag(ammopouch)
end
function lib:Tooltip2Table(tooltip)
    local name=tooltip:GetName()
    local tt={}
    for i=1,tooltip:NumLines() do
       local mytext = getglobal(name .. "TextLeft" .. i)
       table.insert(tt,mytext:GetText())
    end
    return tt
end
function lib:FindBag(key)
    if (not key) then
        return 0
    end
    local bag
    for i=1,MAX_BAGS do
        bag=GetBagName(i)
        if (bag) then
            local slot=ContainerIDToInventoryID(i)
            local tip=self:GetTooltip()
            tip:SetInventoryItem("player",slot)
            local tt=self:Tooltip2Table(tip)
            if (self:TableFind(key,tt,true)>0) then
                return i
            end
        end
    end
    return 0
end

function lib:GetFreeSlotInBag(bag,slot,tipo)
    if (not bag) then
        return 0
    end
    slot=slot or 0
    if (slot==0) then
        slot=1
    end
    local l=GetContainerNumSlots(bag)
    for i=slot,l do
        local item=self:GetItemInfo(bag,i)
        if (item and tipo)  then
            if (item.Type ~= tipo) then
                return i
            end
        elseif (not item) then
            return i
        end
    end
    return  0
end
function lib:GetSmallestBag()
    local small={id=1,size=999,slot=1}
    for i=1,MAX_BAGS do
        local l = GetContainerNumSlots(i)
        if (l > 0 and l < small.size) then
            small.size=l
            small.id=i
        end
    end
    if (small.size < 999) then
        return small
    else
        return nil
    end
end
function lib:ExplodeBagId(id)
    local Bag=math.floor(id/1000);
    local Slot=id-(Bag*1000)
    return Bag,Slot
end
function lib:ImplodeBagId(bag,slot)
    return bag * 1000 + slot
end
function lib:BagUse(bagID,slot)
    local bag=bagID
    if (not slot) then
        bag=math.floor(bagID/1000);
        slot=bagID-(bag*1000)
    end
    UseContainerItem(bag,slot)
end
function lib:BagCount(bagID)
    local Bag=math.floor(bagID/1000);
    local Slot=bagID-(Bag*1000)
    _,count=GetContainerItemInfo(Bag,Slot)
    return count or 0
end
function lib:BagIdInBag(Inbag,bagID)
    local Bag=math.floor(bagID/1000);
    return (Inbag == Bag)
end
function lib:ItemCount(buff,partialmatch)
    local bagId=self:BagScan(buff,partialmatch)
    if (bagId) then
        return self:BagCount(bagId)
    else
        return 0
    end
end
function lib:ScanBags()
    for i = 0,MAX_BAGS do
        local l = GetContainerNumSlots(i)
        if (l > 0) then
            for k = 1,l do
                local item=self:GetItemInfo(i,k)
                AMOCOMMON.cache[item.Name]=item.Count
            end
        end
    end
end
-- Finds an object in bags
-- return BagId,link,name,count,texture
function lib:FindEmptySlots(bagtoavoid)
    return self:FindEmptySlot(bagtoavoid,true)
end
function lib:FindEmptySlot(bagtoavoid,all)
    bagtoavoid=bagtoavoid or -1
    local freeslots={}
    for i = 0,MAX_BAGS do
        if (not (i == bagtoavoid)) then
            local l = GetContainerNumSlots(i)
            for k = 1,l do
                if (not GetContainerItemInfo(i,k)) then
                    if (all) then
                        table.insert(freeslots,{bag=i,slot=k})
                    else
                        return i,k
                    end
                end
            end
        end
    end
    if (all) then
        return freeslots
    else
        return nil
    end
end
function lib:BagScan(buff,partialmatch)
    local l,item=self:BagFind(buff,partialmatch)
    if (l) then
        return l,item.Link
    end
    return
end

function lib:BankScan(buff,partialmatch)
    local l,item=self:BankFind(buff,partialmatch)
    if (l) then
        return l,item.Link
    end
    return
end


function lib:BagFind(buff,partialmatch)
    if (not buff) then return end
    buff=strupper(buff)
    for i = 0,MAX_BAGS do
        local l = GetContainerNumSlots(i)
        for k = 1,l do
            local item=self:GetItemInfo(i,k) or {}
            if (item.Name and item.Texture) then
                if (strupper(item.Texture)==buff) or
                    (strupper(item.Name) == buff) then
                    return i*1000+k, item
                end
                if (partialmatch) then
                    if (string.find(strupper(item.Texture),buff)) or
                        (string.find(strupper(item.Name),buff)) then
                        return i*1000+k, item
                    end
                end
            end
        end
    end
end

function lib:BankFind(buff,partialmatch)
    buff=strupper(buff)
    for i = -1,MAX_BANK_BAGS do
        if (i < 0 or i > MAX_BAGS) then
            local l = GetContainerNumSlots(i)
            for k = 1,l do
                local item=self:GetItemInfo(i,k) or {}
                if (item.Name and item.Texture) then
                    if (strupper(item.Texture)==buff) or
                        (strupper(item.Name) == buff) then
                        return i*1000+k, item
                    end
                    if (partialmatch) then
                        if (string.find(strupper(item.Texture),buff)) or
                            (string.find(strupper(item.Name),buff)) then
                            return i*1000+k, item
                        end
                    end
                end
            end
        end
    end
end
function lib:GetLanguageCache()
    return AMOCOMMON.L
end
function lib:GetItemCache()
    return AMOCOMMON.ItemCache
end
function lib:GetItemInfo(bag,slot)
    local item=new()
    local itemlink=bag
    if slot then
        itemlink=GetContainerItemLink(bag,slot)
    end
    if (not itemlink) then
        return nil
    end
    if (slot) then
        item.Texture,
        item.Count,
        item.Locked,
        item.Quality,
        item.Readable=GetContainerItemInfo(bag,slot)
    end
    item.Name,
    item.Link,
    item.Rarity,
    item.Level,
    item.MinLevel,
    item.Type,
    item.SubType,
    item.StackCount,
    item.EquipLoc,
    item.Texture=GetItemInfo(itemlink)
    return item
end

function lib:PickInBags(buff)
    if (buff) then
        local bagid=self:FindInBags(strlower(buff),true)
        if (bagid) then
            local bagID,slot=self:ExplodeBagId(bagid)
            ToggleBag(bagID)
            PickupContainerItem(bagID, slot)
        end
    end
end

function lib:iCmdEcho(subcmd,param,fullcmd)
    self:Printf("%s %s (%s)",subcmd,param,fullcmd)
end


function lib:ComDebug(...)
    if (not self.flagcomdebug) then return end
    self:PrintLiteral(...)
end

local tracked={}
function lib:iCmdTrack(arg1)
    if (arg1) then
        if (self:IsEventRegistered(arg1)) then
        	tracked[arg1]=nil
            self:UnregisterEvent(arg1)
        else
            self:RegisterEvent(arg1,"TRACK")
            tracked[arg1]=1
        end
    else
        self:PrintLiteral(tracked)
    end
end
function lib:iCmdRuler(arg)
    arg=arg or "border"
    if ( not self.db.profile.forms.AlarRuler) then
        self.db.profile.forms.AlarRuler={storage={Scale=1.0}}
    end
    local form=self:CreatePanel("AlarRuler",{noTip=1,noClose=1,noSave=1,noCancel=1,noResize=1})
    local s=500
    form:SetHeight(s)
    form:SetWidth(s)
    form:SetScale(1.0)
    for i=0,s,50 do
        self:FrameAddLLabel(form,"xxxx" .. i,"x" .. i ,i,20)
        self:FrameAddLLabel(form,"yyyy".. i,"y-" .. i ,-20,i*-1)
    end
	self:SetBackdrop(form,arg)
end
function lib:MemInfo(limen)
    local k=GetNumAddOns(limen)
    UpdateAddOnMemoryUsage()
    self:Print("Mem Scan Started for %d addons. Time to go: %.2f seconds. Over: %dK",
        k,k/50,limen)
    local l=new()
    for i = 1,k do
        local nome=GetAddOnInfo(i)
        local mem=GetAddOnMemoryUsage(i)
        l[nome]=mem
        coroutine:yield()
    end
    self:Print("Addons using more than " .. limen .. "K")
    table.sort(l)
    for k,m in pairs(l) do
        if (m > limen) then
            local color=AMO_GREEN
            if (m > limen * 4) then
                color=AMO_RED
            elseif ( m > limen * 3) then
                color=AMO_ORANGE
            elseif (m > limen * 2) then
                color=AMO_YELLOW
            end
            self:Print("%s: %s%6d" .. AMO_ENDCOLOR,k,color,m)
        end
    end
    del(l)
    self:Print("===============================")
end
function lib:iCmdGarbage()
    self:Print("Doing a full garbage collection cycle,please wait")
    collectgarbage("collect")
    self:Print("Done")
end
function lib:argForce(arg,typ,default)
    if (type(arg)==type) then
        return arg
    end
    local func=getglobal("to" .. typ)
    if (func) then
        arg=func(arg)
        if (type(arg) == type) then
            return arg
        end
    end
    return default
end
function lib:GetMemory(addon)
    if (not addon) then
        addon=self.fullname
    end
    addon=GetAddOnInfo(addon)
    if (not addon) then return -1 end
    collectgarbage("collect")
    UpdateAddOnMemoryUsage()
    return GetAddOnMemoryUsage(addon)
end
function lib:iCmdDebug()
    if (self:IsDebugging()) then
        self:SetDebugging(false)
    else
        self:SetDebugging(true)
    end
    self:PrintBoolean("Debug",self:IsDebugging())
end
function lib:iCmdMemory(arg)
    self:argCheck(arg,1,"number","nil","string")
    arg=arg or 100
    if (tonumber(arg)) then
        self:CoroutineExecute("MEMORY","MemInfo",1/50,tonumber(arg))
    else
        self:Print("Mem used by %s: %d",arg,self:GetMemory(arg))
    end

end
function lib:iCmdVcheck()
    self:_AskVersion()
end
function lib:iCmdBuffs()
    local u="target"
    if (not UnitName(u)) then
        u="player"
    end
    local b =self:ScanBuffDebuff(u)
    for nome,dati in pairs(b) do
        self:Printf("%s (%s): %s",nome,dati.rank,dati.name)
    end
end
function lib:iCmdDebuffs()
    local u="target"
    if (not UnitName(u)) then
        u="player"
    end
    local b =self:ScanBuffDebuff(u,true)
    for nome,dati in pairs(b) do
        self:Printf("%s (%s)[%s]: %s",nome,dati.rank,rank.type,dati.name)
    end
end
function lib:iCmdMonitor()
    self.monitor=not self.monitor
    self:PrintBoolean("Monitor",self.monitor)
end
function lib:iCmdDump(structure)
    local func,message=loadstring('lib:DumpTable(' .. structure .. ")")
    if (type(func)=="function") then
        func()
    else
        lib:Error(message)
    end
end

function lib:iCmdWhere()
    local x,y=GetPlayerMapPosition("player")
    self:Printf("You are in %s (%d,%d)",GetRealZoneText(),x*100,y*100)
end
function lib:iCmdMouse()
    self:Print(GetMouseFocus())
end
function lib:iCmdPoi()
    local f=getglobal("POI")
    if (not f) then
        f = CreateFrame("Frame","POI",UIParent)
        f:SetFrameStrata("BACKGROUND")
        f:SetWidth(256)  -- Set These to whatever height/width is needed
        f:SetHeight(256) -- for your Texture
        local t = f:CreateTexture(nil,"BACKGROUND")
        t:SetTexture("Interface\\Minimap\\POIIcons")
        t:SetAllPoints(f)
        f.texture = t
        f:SetPoint("CENTER",0,0)
    end
    if (f:IsShown()) then
        f:Hide()
    else
        f:Show()
    end
end
function lib:iCmdView(texture)
    local f=getglobal("VIEW")
    if (not f) then
        f = CreateFrame("Frame","VIEW",UIParent)
        f:SetFrameStrata("BACKGROUND")
        f:SetWidth(256)  -- Set These to whatever height/width is needed
        f:SetHeight(256) -- for your Texture
    end
    local t = f:CreateTexture("VIEWX","BACKGROUND")
    t:SetTexture("Interface\\Addons\\TrinketBar\\Buttons")
    t:SetAllPoints(f)
    f.texture = t
    f:SetPoint("CENTER",0,0)
    if (f:IsShown()) then
        f:Hide()
    else
        f:Show()
    end
end

function lib:SafeConcat(separator,...)
    local i=select("#",...)
    local fmt="";
    if (i > 0) then
        fmt=fmt .. string.rep("%s"..separator,i)
    end
    return self:Format(fmt,...)
end
-- It actually dumps any kind of variable
function lib:DumpTable(table)
    if (type(table) == "string") then
        table=getglobal(table)
    end
    self:PrintLiteral(table)
end
lib.Dump = lib.DumpTable
function lib:Scale(form,def,force)
-- Gestisce sia il rescaling, che l'applicazione del BackDrop
    local f=self:IsFrame(form)
    if (not f) then return end
    if (not force) then
        def=f.storage.Scale or def
    end
    f:SetScale(def or 1.0)

end
function lib:Channel(msg,channel)
    channel=channel or "SAY"
    SendChatMessage(msg,channel)
end
function lib:Format(...)
    local a={}
    for i=1,select("#",...) do
        local v=select(i,...)
        table.insert(a,tostring(v))
    end
    local rc,message = pcall (format,unpack(a))
    if (not rc) then
        self:Print(AMO_RED .. message)
        return ""
    else
        return message
    end
end

function lib:ChooseClick(click)
    button=0
	if (click == "LeftButton") then
        button=1
	elseif (click == "MiddleButton") then
        button=2
	elseif (click == "RightButton") then
        button=3
    end
    if (IsControlKeyDown()) then
        button=button+3
    end
    if (IsAltKeyDown()) then
        button=button+6
    end
    return button
end

function lib:Boolean(toggle)
    local stato
    if (toggle) then
        stato = AMO_GREEN .. "ON"
    else
        stato= AMO_RED .. "OFF"
    end
    return stato
end
function lib:PrintBoolean(msg,toggle)
    self:Printf("%s is %s",msg,self:Boolean(toggle))
end
function lib:Same()
    self:Print("Originale")
end
function lib:GetDebugPrefix()
	return ("|cff7fff7f(DEBUG) %s [%s.%3d]|r"):format( self.ID or 'AMO', date("%H:%M:%S"), (GetTime() % 1) * 1000)
end
function lib:CustomTrace(...)
    if (not self:Alar()) then
        return
    end
    local DBG="AlarDBG"
    local frame
    if (not AMOCOMMON.AlarDBG) then
        AMOCOMMON.AlarDBG=0
        for i = 3,NUM_CHAT_WINDOWS do
            local nome,_,_,_,_,_,shown,_=GetChatWindowInfo(i)
            local tab=getglobal("ChatFrame" .. i .. "Tab")
            if (nome == DBG ) then
                AMOCOMMON.AlarDBG=i
                SetChatWindowShown(i, 1);
                break
            end
        end
    end
    local frame = getglobal("ChatFrame" .. AMOCOMMON.AlarDBG)
    local stack={strsplit("\n",debugstack(3,1,1))}
    stack=stack[1]
    local _,_,msg=stack:find("in function .(%w*)'")
    msg=msg or ''
    if (frame) then
        local c=AMO_White
    	--self.CustomPrint(stack,r,g,b,frame,delay,"->")
    	self.CustomPrint(format("%s[%s:%s]|r",AMO_ORANGE,self.ID,msg),
        c.r, c.g, c.b, frame, delay, ...)
    end
end
function lib:Trace(...)
	return self:CustomTrace(", ", ...)

end
function lib:TraceLiteral(...)
	self:CustomTrace(true, ...)
end
function lib:PrintLiteral(...)
    local addon=self.ID or "AMO"
    self.CustomPrint(addon,nil,nil,nil,nil,nil,true,...)
end
function lib:Print(...)
    local addon=self.ID or "AMO"
    self.CustomPrint(addon,nil,nil,nil,nil,nil,nil,...)
end
function lib:LibError(...)
    local addon=self.ID or "AMO"
    local rc,message=pcall(error,self:Format(...),4)
    self.CustomPrint(AMO_RED .. addon ..AMO_ENDCOLOR,nil,nil,nil,nil,nil,nil,message)
end
function lib:Error(...)
    local rc,message=pcall(error,self:Format(...),3)
    local addon=self.ID or "AMO"
    self.CustomPrint(AMO_RED .. addon ..AMO_ENDCOLOR,nil,nil,nil,nil,nil,nil,message)
end
function lib:Notify(...)
    local addon=self.ID or "AMO"
    self.CustomPrint(AMO_ORANGE .. addon .. AMO_ENDCOLOR ,nil,nil,nil,nil,nil,nil,...)
end

function lib:Printf(...)
    self:Print(...)
end
function lib:SplitColor(c)
    if (type(c) ~= "table") then
        return 0.5,0.5,0.5
    else
        return c.r,c.g,c.b
    end
end
function lib:SetColor(frame,c)
    if (not c) then
         c={r=0.5,g=0.5,b=0.5}
    end
    frame:SetTextColor(c.r,c.g,c.b)
end

function lib:Long(msg)
	UIErrorsFrame:AddMessage(msg, AMO_Yellow.r,AMO_Yellow.g,AMO_Yellow.b, 1.0, UIERRORS_HOLD_TIME * 20);
end
function lib:Onscreen_Orange(msg)
-- Viola = 50%,0%,50%
	UIErrorsFrame:AddMessage(msg, AMO_Orange.r,AMO_Orange.g,AMO_Orange.b, 1.0, UIERRORS_HOLD_TIME * 2);
end
function lib:Onscreen_Purple(msg)
-- Viola = 50%,0%,50%
	UIErrorsFrame:AddMessage(msg, AMO_Purple.r,AMO_Purple.g,AMO_Purple.b, 1.0, UIERRORS_HOLD_TIME * 8);
end
function lib:Onscreen_Yellow(msg)
-- Giallo = 100%,93%,22%
	UIErrorsFrame:AddMessage(msg, AMO_Yellow.r,AMO_Yellow.g,AMO_Yellow.b, 1.0, UIERRORS_HOLD_TIME);
end
function lib:Onscreen_Azure(msg)
-- Viola = 50%,0%,50%
	UIErrorsFrame:AddMessage(msg, AMO_Azure.r,AMO_Azure.g,AMO_Azure.b, 1.0, UIERRORS_HOLD_TIME);
end
function lib:Onscreen_Red(msg)
-- Rosso = 96%,10%,0%
	UIErrorsFrame:AddMessage(msg, AMO_Red.r,AMO_Red.g,AMO_Red.b, 1.0, UIERRORS_HOLD_TIME);
end
function lib:Onscreen_Green(msg)
-- Verde = 0%,77%,0%
	UIErrorsFrame:AddMessage(msg, AMO_Green.r,AMO_Green.g,AMO_Green.b, 1.0, UIERRORS_HOLD_TIME);
end

-----------------------------------------------------------
-- function lib:Show(self,form)
--
-- :Show() a form, with scaling and backdropping
--
function lib:Show(form)
    local f=form
    if (type(form)=="string") then
        f=getglobal(form)
    else
        form=f:GetName()
    end
    self:Scale(form,1.0,nil)
    f:Show()
end
function lib:Flip(form,condizione)
    local f=form
    if (type(form)=="string") then
        f=getglobal(form)
    end
    if (type(f) ~= "table") then
        return
    end
    if (condizione) then
        f:Show()
    else
        f:Hide()
    end
end
    -- AMo Help System
function lib:ShowHelp(page)
    
    local wf=AceLibrary("Waterfall-1.0")


    if (not wf:IsRegistered("ACH_HELP")) then
        self:Trace("Registering help")
        local Opts={}
        for i,t in ipairs(AMOCOMMON.help) do
            local t=t.title
            self:Trace("Registering page ".. i .. " for " .. t)
            if (t=='About') then
                Opts[i]= {id=i .."_description",text=t ,}
            else
                Opts[i]= {
                    id=i.."_description",
                    text=t,
                    {text="Release Notes",
                     id=i .. "_notes",
                    },
                    {text="Commands",
                     id=i.. "_commands",
                    },
                    {text="Switches",
                     id=i .. "_switches",
                    },
                    {text="Credits",
                    id=i .. "_credits",
                    }
                }
            end
        end
        wf:Register("ACH_HELP",
        "tree",Opts,
        'treeLevels',2,
        "title","Alar Mods Help System",
        "width",totw,
        "children",
            function(id)
                if (id) then
                    local _,_,id,section=id:find("(%d*)_(.*)")
                    id=tonumber(id)
                    local h=AMOCOMMON.help[id]
                    if (section == "description") then
                        if (id > 1) then
                            wf:AddControl(
                            'type','button',
                            'text','Open gui',
                            'justifyH','CENTER',
                            'execArg1',id,
                            'execFunc',
                            function(id)
                                local lib=getglobal(h.ID)
                                local rc,message= pcall(function() lib:CmdConfig() end)
                                if (rc) then
                                    wf=AceLibrary("Waterfall-1.0")
                                    wf:Close("ACH_HELP")
                                else
                                    self:Print("Failed CmdConfig",id,h.ID)
                                end
                            end
                            )
                        end
                    end
                    if (section == "credits") then
                        wf:AddControl('type','label','width',panw,'text',L.LOCALIZEDBY)
                        return "Localization"
                    else
                        local lines={strsplit("\n",h.pages[section])}
                        for i,text in pairs(lines) do
                            wf:AddControl('type','label',"width",panw,"text",text,"noNewLine",false,"justifyH","LEFT")
                        end
                        return h.title
                    end
                else
                    return "Choose a module to display help for"
                end
            end
        )
    end
    if (type(page) ~= "number") then
        page=1
    end
    wf:Open("ACH_HELP")
    wf:Open("ACH_HELP",page .. "_description")
    wf:SetSize("ACH_HELP",801,601)

    --AlarHelpFrameShow(page)
    --AlarHelpFrame:Show()
end
function lib:Me(target)
    target=target or "player"
    if (target == "player") then
        if (not AMOCOMMON.Myname) then
            AMOCOMMON.Myname,AMOCOMMON.Myrealm=UnitName("player")
        end
        return AMOCOMMON.Myname,AMOCOMMON.MyRealm
    else
        local  rc,unitname,realmname=pcall(UnitName,target)
        if (rc) then
            return unitname,realmname
        else
            return false
        end
    end
end

-- class checks
function lib:Is(class,target)
    target=target or "player"
    if (target == "player") then
        if (not AMOCOMMON.Myclass) then
            _,AMOCOMMON.Myclass=UnitClass("player")
        end
        return AMOCOMMON.Myclass==strupper(class)
    else
        local    rc,_,unitclass=pcall(UnitClass,target)
        if (rc) then
            return unitclass==strupper(class)
        else
            return false
        end
    end
end
function lib:Health(unit)
    local totale=UnitHealthMax(unit) or 1
    local corrente=UnitHealth(unit) or 1
    if (corrente == 0) then corrente =1 end
    if (totale==0) then totale = corrente end
    local life=corrente/totale*100
    return math.ceil(life)
end
function lib:Age(secs)
    return self:TimeToStr(GetTime() - secs)
end
function lib:Mana(unit)
    local totale=UnitManaMax(unit) or 1
    local corrente=UnitMana(unit) or 1
    if (corrente == 0) then corrente =1 end
    if (totale==0) then totale = corrente end
    local life=corrente/totale*100
    return math.ceil(life)
end
function lib:GetUnitDistance(x,y,unit)
    unit=unit or "player"
    local from={}
    local to={}
    from.x,from.y=GetPlayerMapPosition(unit)
    to.x=x
    to.y=y
    return self:GetDistance(from,to) * 10000
end
function lib:GetDistance(a,b)
--------------
-- Calculates distance betweeb 2 points given as
-- a.x,a.y and b.x,b.y
	 local x=b.x - a.x
	 local y=b.y -a.y
	 local d=x*x + y* y
	 local rc,distance=pcall(math.sqrt,d)
	 if (rc) then
        return distance
    else
        return 99999
    end
end
function lib:NewMacro(...)
    free=self:CreateMacro(...)
    if (free) then
        PickupMacro(free)
    else
        PlaySound("igQuestLogAbandonQuest");
        self:Onscreen_Red("No more macro slots left")
    end
end
function lib:CreateMacro(nome,testo,icona,locale)
    silent=true
    if (not icona) then
        icona=1
    end
    if (not locale) then
        locale=1
    end
    local free=GetMacroIndexByName(nome)
    if (free) then
        DeleteMacro(free)
    end
    free=CreateMacro(nome,icona,testo,1,locale)
    if (not free) then
        return nil
    else
        return free
    end
end

---- miscellaneous checks
function lib:IsFriend(player)
    local i
    for i =1,GetNumFriends() do
        local name,_,_,_,_ =GetFriendInfo(i)
        if (name == player) then
            return true
        end
    end
    return false
end
function lib:StringWidth(stringa,font)
    if (not AMOCOMMON.Label) then
        AMOCOMMON.Label=CreateFrame("frame"):CreateFontString(nil,"OVERLAY","GameFontNormal")
    end
    local label=AMOCOMMON.Label
    if (type(stringa) ~= "string") then
        stringa=""
    end
    font=font or "GameFontNormal"
    label:ClearAllPoints()
    label:SetWidth(0)
    label:SetHeight(0)
    label:SetFontObject(font)
    label:SetText(stringa)
    return label:GetStringWidth(),label:GetWidth()
end

function lib:StringHeight(stringa,width,font)
    if (not AMOCOMMON.Label) then
        AMOCOMMON.Label=UIParent:CreateFontString(nil,"OVERLAY","GameFontNormal")
        AMOCOMMON.Label:Hide()
    end
    local label=AMOCOMMON.Label
    if (type(stringa) ~= "string") then
        stringa=""
    end
    font=font or "GameFontNormal"
    label:ClearAllPoints()
    label:SetWidth(width)
    label:SetFontObject(font)
    label:SetText(stringa)
    return label:GetWidth(),label:GetHeight()
end


function lib:FindMe()
	local totallandmarks = GetNumMapLandmarks()
	local IAM=""
	local ld=999999999
	local x,y=GetPlayerMapPosition("player")
	local a={x=x,y=y}
	for i = 1, totallandmarks, 1 do
		local name, description, typ, x, y = GetMapLandmarkInfo(i);
		local b={x=x,y=y}
		local d=lib:GetDistance(a,b)
		if (d < ld) then
            ld=d
            IAM=tostring(name) .. "(" .. tostring(description) .. ")"
        end
    end
    return IAM
end
function lib:AttachHelp(f,helptext)
    --UiFrameFadeIn(f,secondi,Alfada,Alfaa)
    helptext=helptext or ""
    helptext=tostring(helptext)
    if (type(f) == "string") then
        f=getglobal(f)
    end
    if (not f) then
        self:Print(tostring(f) .. " is not a global name")
        return
    end
    if (type(f) ~= "table") then
        self:Print(tostring(f) .. " is not a frame")
        return
    end
    local canoperate=f:IsObjectType("Frame")
    if (canoperate) then
        local b=self:FrameAddHelpButton(f)
        b:SetPoint("TOPLEFT",f,"TOPRIGHT",-5,17)
        b:Show()
        self:TTAdd(b,helptext,true)
    end
end
function lib:IsFrame(tf,verbose)
    local f
    if (type(tf) == "table") then
        f=tf
    else
        f=getglobal(tf)
    end
    if (not f) then
        return verbose and self:Print(tf , " is not a global name")
    end
    if (type(f) ~= "table") then
        return verbose and self:Print(tf .. " is not a table")
    end
    local canoperate=f.IsObjectType and f:IsObjectType("Frame")
    if (canoperate) then
        return f
    else
        return verbose and self:Print(tf .. " is not a frame")
    end
end
local OnDragStart,OnDragStartNoAlt,OnDragStop,OnDragInfoOn,OnDragInfoOff,savepanel,restorepanel
local ClipChildren,FitToChildren,ScanChildren,AddScript
function AddScript(frame,hook,script)
    local oldscript=frame:GetScript(hook)
    frame:EnableMouse(true)
    if (oldscript) then
        frame:SetScript(hook,function(...) oldscript(...) script(...) end)
    else
        frame:SetScript(hook,function(...) script(...) end)
    end
end
function ClipChildren(frame)
    AMO:Debug("Clip",frame:GetName())
    ScanChildren(frame,
                    function(frame,v,insideform)
                        if (type(v.compact) == "nil") then
                            if (insideform) then
                                v:Show()
                            else
                                v:Hide()
                            end
                        end
                    end
                )
end
function FitChildren(frame)
    AMO:Debug("Fit",frame:GetName())
    ScanChildren(frame,
                    function(frame,v,insideform)
                        if (not insideform) then
                            frame:SetHeight(v:GetTop()-v:GetBottom() + 10)
                            frame:SetWidth(v:GetRight()-v:GetLeft() + 10)
                        end
                    end
                )
end
function ScanChildren(frame,op)
    frame.lastclip=tonumber(frame.lastclip) or 0
    if (GetTime() - frame.lastclip < 0.5) then
        return
    end
    frame.lastclip=GetTime()
    local t=frame:GetTop()
    local b=frame:GetBottom()
    if (tonumber(t) and tonumber(b)) then
        for i,v in ipairs({frame:GetChildren()}) do
            if (not v.ignore) then
                local vt=v:GetTop()
                local vb=v:GetBottom()
                if (vt and vb) then
                    if (vt <= t and vb >= b) then
                        op(frame,v,true)
                    else
                        op(frame,v,false)
                    end
                end
            end
        end
    end
    for i,v in ipairs({frame:GetRegions()}) do
        if (not v) then
            break
        end
        if (not v.ignore) then
            local vt=v:GetTop()
            local vb=v:GetBottom()
            if (vb and vt) then
                if (vt <= t and vb >= b) then
                    op(frame,v,true)
                else
                    op(frame,v,false)
                end
            end
        end
    end
end

function restorepanel(f)
    if (f and f.storage and f.storage.Manage) then
        local rc,message
        if (type(f.storage.Point)=="table") then
            local p=f.storage.Point
            if (not p.anchor) then
                p.anchor=p[1] or "CENTER"
                p.parent=f:GetParent()
                if (p.parent) then
                    p.parent=p.parent:GetName()
                else
                    p.parent='UIParent'
                end
                p.relanchor=p[2] or "CENTER"
                p.x=p[3] or 0
                p.y=p[4] or 0
                p[1]=nil
                p[2]=nil
                p[3]=nil
                p[4]=nil
            end
            local parent=getglobal(p.parent) or UIParent
            rc,message=pcall(function(f,p)
                f:SetPoint(p.anchor,parent,p.relanchor,p.x,p.y)
                end,f,p)
        end
        if (not rc) then
            AMO:PrintLiteral(message,f.storage.Point)
        end
        if (f.storage.Width) then
            if (f.storage.MinWidth) then
                f:SetWidth(max(f.storage.Width,f.storage.MinWidth))
            else
                f:SetWidth(f.storage.Width)
            end
        end
        if (f.storage.Height) then
            if (f.storage.MinHeight) then
                f:SetHeight(max(f.storage.Height,f.storage.MinHeight))
            else
                f:SetHeight(f.storage.Height)
            end
        end
        f:SetScale(f.storage.Scale)
        f:SetBackdrop(Backdrops[f.storage.Backdrop])
    else
        f:SetPoint("CENTER")
    end
end
function savepanel(f)
    if (not f or not f.storage) then return end
    f.storage.Scale=f:GetScale()
    local anchor,parent,relanchor,x,y=f:GetPoint(1)
    if (parent) then
        parent=parent:GetName()
    else
        parent=nil
    end
    f.storage.Point=nil
    f.storage.Point={anchor=anchor,parent=parent,relanchor=relanchor,x=x,y=y}
    f.storage.Width=f:GetWidth()
    f.storage.Height=f:GetHeight()
    f.storage.Manage=1
    if (f.storage.MinHeight) then
        f:SetHeight(max(f.storage.Height,f.storage.MinHeight))
    end
    if (f.storage.MinWidth) then
        f:SetWidth(max(f.storage.Width,f.storage.MinWidth))
    end
end

function OnDragStart(this,...)
    if (IsAltKeyDown()) then
        OnDragStartNoAlt(this,...)
    else
        AMO_TTOpen("Moving....")
        this:StartMoving()
    end
end
function OnDragStartNoAlt(this,...)
    AMO_TTOpen("Sizing....")
    this.Sizing=true
    this:StartSizing("BOTTOMRIGHT")
end
function OnDragInfoOn(old,this,button)
    if (IsAltKeyDown()) then
        AMO_TTOpen("Ready to resize")
    else
        AMO_TTOpen(AMO_GREEN .."Right-click and drag:" .. AMO_ENDCOLOR .. " move\n" .. AMO_GREEN .. "Alt-Right-Click and drag:".. AMO_ENDCOLOR .. "resize")
    end
    if (type(old) == "function") then old(this,button) end
end
function OnDragInfoOff(old,this,button)
    AMO_TTFade()
    if (type(old) == "function") then old(this,button) end
end
function OnDragStop(this,...)
    AMO_TTFade()
    this:StopMovingOrSizing();
    AMO:Debug("DragStop")
    this.lastclip=0 -- forcing clip
    if (this.Sizing) then
        if (not this.IsCompact) then
            AMO:Debug("OnDragStop")
            this:ClipChildren()
        end
        this.Sizing=false
    end
    if (type(this.storage)=="table") then
        savepanel(this)
    end
    local f=this:GetParent()
    if (f) then
        if (f:GetName() ~= "UIParent" and not InCombatLockdown()) then
            this:ClearAllPoints()
            this:SetPoint("TOPLEFT",
                this:GetLeft()-f:GetLeft(),
                this:GetTop()-f:GetTop())
        end
    end
end
local OnDragStopParent
function OnDragStopParent(this,...)
    OnDragStop(this:GetParent(),'parent')
end
local OnDragStartParent
function OnDragStartParent(this)
    OnDragStart(this:GetParent(),'parent')
end
local OnDragStartParentNoAlt
function OnDragStartParentNoAlt(this)
    OnDragStartNoAlt(this:GetParent(),'parent')
end
function lib:MakeParentMovable(tf)
    local f=self:IsFrame(tf,true)
    local p=f:GetParent()
    if (not p) then
        return
    end
    self:MakeMovable(p,true)
    f:SetScript("OnDragStart",OnDragStartParent)
    f:SetScript("OnDragStop",OnDragStopParent)
end
function lib:MakeMovable(tf,noinfo)
    local f=self:IsFrame(tf,true)
    if (f) then
        f.oldparent=f:GetParent()
        if (not f.FitChildren) then
            f.FitChildren=function() end
        end
        if (not f.ClipChildren) then
            f.ClipChildren=function() end
        end
        f:SetMovable(true)
        f:EnableMouse(true)
        if (f:GetFrameStrata() == "BACKGROUND") then
            f:SetFrameStrata("LOW")
        end
        f:SetMovable(true)
        f:SetResizable(true)
        f:SetClampedToScreen(true)
        f:RegisterForDrag("RightButton")
        local fname=f:GetName()
        local rc,tt=pcall(function(self,fname) return self.db.profile.forms[fname].Point.x end,self,fname)
        if (not rc) then
            self.db.profile.forms[fname]={}
        end
        f.storage=self.db.profile.forms[fname]
        if (not noinfo) then
            local omd=f:GetScript("OnMouseDown")
            local omu=f:GetScript("OnMouseUp")
            f:SetScript("OnMouseDown",function(...) OnDragInfoOn(...) end)
            f:SetScript("OnMouseUp",function(...) OnDragInfoOff(...) end)
        end
        f:SetScript("OnDragStart",OnDragStart)
        f:SetScript("OnDragStop",OnDragStop)
    else
        self:Print("Sorry, ",tf," is not a frame object")
    end
end
function lib:Parse(msg)
    if (not msg) then
        return nil
    end
    local cmd,subcmd,param = strsplit(" ",msg,3)
    local _,fullarg=strsplit(" ",msg,2)
    return cmd,subcmd,param,fullarg
end
function lib:TableFind(key,table,approx)
    if (not key) then
        return 0
    end
    if (type(table) ~= "table") then
        return 0
    end
    for i,v in ipairs(table) do
        if (approx) then
            if (string.find(v,key)) then
                return i
            end
        else
            if v==key then
                return i
            end
        end
    end
    return 0
end
--- Comm Functions
function lib:CommSend(priority,distribution,...)
    priority=priority or self.Priority
    distribution=distribution or "GROUP"
    self:SendPrioritizedCommMessage(priority,distribution,...)
    if (ALARDEVELOPMENTPC) then
        self:SendPrioritizedCommMessage(priority,"WHISPER",self:Me(),...)
    end
    self:ComDebug(priority,distributino,...)
end
--- Templateless frame functions
local function AMO_ChangeBackdrop(this)
    lib:PrintLiteral(this)
end
function lib:PanelRestore(f)
    restorepanel(self:IsFrame(f))
end
function lib:PanelSave(f)
    savepanel(self:IsFrame(f))
end
function lib:PanelMinSize(f,x,y)
    if (not f.storage) then
        f.storage=self.db.profile.forms[f:GetName()]
    end
    f.storage.MinWidth=x or f.storage.MinWidth or f:GetWidth()
    f.storage.MinHeight=y or f.storage.MinHeight or f:GetHeight()
end
function lib:GetXY(f,b)
    local br=b:GetRight() or -1
    local fl=f:GetLeft() or -1
    local bb=b:GetBottom() or -1
    local ft=f:GetTop() or -1
    local x=br-fl
    local y=bb-ft
    return x,y
end
function lib:FrameAddScript(frame,hook,script)
    AddScript(frame,hook,script)
end
function lib:FrameAddXButton(f)
    local fname=f:GetName() .. "XButton"
    local b=self:Create("Button",fname,f,"UIPanelCloseButton")
    b:SetHeight(32)
    b:SetWidth(32)
    b:SetPoint("TOPRIGHT",f,"TOPRIGHT",f.rightmost,0)
    b:SetFrameLevel(10)
    b.ignore=true
    b:Show()
    return b
end
local Minimize
function Minimize(self,this)
    local base=16
    local height=32
    if (this.minimized) then
        base=3
        this.minimized=false
        height=this.oldwidth or 100
    else
        this.minimized=true
        this.oldwidth=this:GetParent():GetHeight()
    end
    self:SetTexCoord(this:GetNormalTexture(),base,8)
    self:SetTexCoord(this:GetPushedTexture(),base+1,8)
    this:GetParent():SetHeight(height)
end
function lib:FrameAddMinButton(f)
    local fname=f:GetName() .. "MinButton"
    local b=self:Create("Button",fname,f,"UIPanelCloseButton")
    b.ignore=true
    local t
    local ButtonsTexture=self:LoadTexture("Buttons")
    --------------- Normal
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,3,8)
    t:SetAllPoints(b)
    b:SetNormalTexture(t)
    --------------- Pushed
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,4,8)
    t:SetAllPoints(b)
    b:SetPushedTexture(t)
    --------------- HighLight
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,2,8)
    t:SetBlendMode("ADD")
    t:SetAllPoints(b)
    b:SetHighlightTexture(t)
    b:SetScript("OnClick",function(this) Minimize(self,this) end)
    b:SetHeight(24)
    b:SetWidth(24)
    b:SetScale(1)
    b:SetPoint("TOPRIGHT",f,"TOPRIGHT",f.rightmost,-2)
    b:SetFrameLevel(10)
    b:Show()
    return b
end
function lib:FrameAddConfigButton(f)
    local fname=f:GetName() .. "ConfigButton"
    local b=self:Create("Button",fname,f,"UIPanelCloseButton")
    b.ignore=true
    local t
    local ButtonsTexture=self:LoadTexture("Buttons")
    --------------- Normal
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,22,8)
    t:SetAllPoints(b)
    b:SetNormalTexture(t)
    --------------- Pushed
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,23,8)
    t:SetAllPoints(b)
    b:SetPushedTexture(t)
    --------------- HighLight
    t=b:CreateTexture()
    t:SetTexture(ButtonsTexture)
    self:SetTexCoord(t,2,8)
    t:SetBlendMode("ADD")
    t:SetAllPoints(b)
    b:SetHighlightTexture(t)
    if (type(f.Configure) ~= "function") then
        f.Configure=function() end
    end
    b:SetScript("OnClick",function(...) f:Configure(...) end)
    b:SetHeight(24)
    b:SetWidth(24)
    b:SetScale(1)
    b:SetPoint("TOPRIGHT",f,"TOPRIGHT",f.rightmost,-2)
    b:SetFrameLevel(10)
    b:Show()
    return b
end
function lib:FrameResetCastButtonList(f,rowlength)
    f.buttonlist=0
    f.rowlength=rowlength or 99
    local rowsize = 18 * f.rowlength
    local formsize=f:GetWidth()
    if ( rowsize >= formsize) then
        f.offset=0
    else
        f.offset =math.floor( (formsize -rowsize) /2)
    end
end
function lib:FrameAddCastButtonList(f,ord,spelltableorname,target,rank,tipo,mouse)
    if (not f.buttonlist) then
        self:FrameResetCastButtonList(f)
    end
    local x,y
    y=0
    ord =ord or f.buttonlist
    x=mod(ord,f.rowlength)
    y=math.floor(ord /f.rowlength)
    local spelltable=spelltableorname
    if (type(spelltableorname)=="string") then
        spelltable={spellname=spelltableorname,spelltarget=target,spellrank=rank,spelltype=tipo,spellmouse=mouse}
    end
    local b=self:FrameAddCastButton(f,f.buttonlist)
    f.buttonlist=f.buttonlist +1
    b:SetPoint("TOPLEFT",f,"BOTTOMLEFT",f.offset + x * 36,y * -36)
    b:SetScale(0.5)
    b:SetSpell(spelltable)
    b:Show()
    return b
end

local AddCastButton_SetSpell
-- Valid spelltype are: spell, macro, macrotext
function AddCastButton_SetSpell(this,t)
    if (type(t) == "string") then
        t={spellname=t,spelltype="spell"}
        t.spellname,t.rank=GetSpellName(t.spellname)
    end
    t=t or {spelltype='none'}
    local nome=this:GetName()
    local icon=getglobal(nome.. "Icon")
    if (t.spelltype=='none') then
        this.spelltarget=nil
        this.spellmouse=nil
        this.spelltype=nil
        this.spellname=nil
        this.spellrank=nil
        this.spelltexture=nil
        this.tooltipText=nil
        this.icon=icon
        if (this.icon) then
            this.icon:SetTexture(nil)
        end
        return
    end
    this.spelltarget=t.spelltarget or "target"
    this.spellmouse=t.spellmouse or ""
    this.spelltype=t.spelltype or "spell"
    this.spellname=t.spellname or ""
    this.spellrank=t.spellrank or ""
    this.spelltexture=t.spelltexture
    if (this.spelltype~="spell") then
        this.spellrank=""
        this.spellmouse=""
    end
    local rank=this.spellrank or ''
    if (rank ~= "") then
        rank=" ("..this.spellrank..")"
    end
    this.icon=icon
    if (icon) then
        local texture=this.spelltexture
        if (not texture) then
            if (this.spelltype == "macro") then
                _,texture=GetMacroInfo(this.spellname)
            elseif (this.spelltype == "spell") then
                texture=GetSpellTexture(this.spellname)
                if (not texture) then
                    texture=GetSpellTexture(this.spellname .. rank)
                end
            end
        end
        texture = texture or "Interface\\Icons\\INV_Misc_QuestionMark"
        icon:SetTexture(texture)
    else
        --ACE:Print("%sIcon not found",nome)
    end
    this.tooltipText=this.spellname .. rank
    if (t.noCast) then
        return
    end
    if (this.target) then
        self:SetAttribute("unit",this.target)
    end
    if (not this.spelltype) then
        return
    end
    local tipo=this.spelltype
    if (tipo=="macrotext") then
        tipo="macro"
    end
    this:SetAttribute("type"..this.spellmouse,tipo)
    this:SetAttribute(this.spelltype .. this.spellmouse,this.spellname .. strtrim(rank))
end
local UpdateCooldown
function UpdateCooldown(spellbutton)
    local type=spellbutton.spelltype
    if (not type) then return end
    if (type == "spell") then
        local c=spellbutton.cooldown
        if (c) then
            local start,duration,enable=GetSpellCooldown(spellbutton.spellname)
            if (start and duration) then
                CooldownFrame_SetTimer(c,start,duration,enable)
            end
        end
    end
end
local Checkrange
function CheckRange(this)
    if (this.spellname) then
        if (SpellHasRange(this.spellname)) then
            if (IsSpellInRange(this.spellname,this.unit) == 0) then
				this.icon:SetVertexColor(1.0, 0.1, 0.1);
			elseif (IsUsableSpell(this.spellname)) then
    			this.icon:SetVertexColor(1.0, 1.0, 1.0);
            else
                this.icon:SetVertexColor(0.1,0.1,1.0)
			end
        end
    end
end
function lib:FrameAddCastButton(f,name,x,y,spell)
    name=name or ""
    local fname=f:GetName() .. "Cast" ..name
    b=self:Create("CheckButton",fname,f,"SecureActionButtonTemplate,ActionButtonTemplate")
    b:RegisterForClicks("AnyUp")
    b:SetHeight(32)
    b:SetWidth(32)
    b:SetAttribute("useparent-unit", true);
    b.unit=b:GetAttribute("unit") or f:GetAttribute("unit")
    b.SetSpell=AddCastButton_SetSpell
    b.cooldown=getglobal(fname .. "Cooldown")
    b:SetScript("OnEnter",function() self.TTOpen() end)
    b:SetScript("OnLeave",self.TTClose)
    b:SetScript("PostClick",UpdateCooldown)
    b:SetScript("OnEvent",
        function(this,event)
            if (event == "ACTIONBAR_UPDATE_COOLDOWN") then
                UpdateCooldown(this)
                this:SetChecked(false)
            end
        end
        )
    b.rangetimer=0.5
    b:SetScript("OnUpdate",
        function(this,elapsed)
    		this.rangetimer = this.rangetimer - elapsed;
    		if ( this.rangetimer <= 0 ) then
			     CheckRange(this)
			     this.rangetimer=0.5
            end
		end
		)
    b:RegisterEvent("ACTIONBAR_UPDATE_COOLDOWN")
    if (x and y) then
        b:SetPoint("TOPLEFT",x,y)
    end
    if (spell) then
        b:SetSpell(spell)
    end
    b:Show()
    return b
end
local AddSpellButton_OnReceiveDrag
local AddSpellButton_SetSpell
local AddSpellButton_OnMouseUp
local AddSpellButton_SetText
function AddSpellButton_OnMouseUp(this,button)
    this:SetChecked(nil)
    AMO:Trace("MouseUp",this,button)
    if (not CursorHasMacro() and not CursorHasSpell()) then
        if (button == "RightButton") then
            AMO:Trace("Deleting",this,button)
            this:SetSpell(nil)
            return
        end
        AMO:Trace("Not Deleting",this,button)
    end
    AddSpellButton_OnReceiveDrag(this)
end
function AddSpellButton_OnReceiveDrag(this)
    this:SetChecked(nil)
    if (not CursorHasMacro() and not CursorHasSpell()) then
        return
    end
    local tipo,slot,book=GetCursorInfo()
    local spellname
    local rank
    if (tipo == "spell") then
        spellname,rank=GetSpellName(slot,book)
    end
    if (tipo == "macro") then
        spellname=GetMacroInfo(slot)
        rank=""
    end
    if (not spellname) then
        return
    end
    this.spelltype=tipo
    this.spellrank=rank
    this.spellname=spellname
    this:SetSpell{spelltype=tipo,spellrank=rank,spellname=spellname}
    ClearCursor()
end

function AddSpellButton_SetSpell(this,t)
    t=t or {spelltype='none'}
    t.noCast=true
    if (not t.spellttype and not t.spellname) then
        t.spelltype='none'
    end
    AddCastButton_SetSpell(this,t)
    if (t.spelltype=="none") then
        this:SetText('')
        return
    end
    local rank=this.spellrank or ''
    if (rank ~= "") then
        rank=" ("..this.spellrank..")"
    end
    this:SetText(t.spellname .. rank)
    local c=AMO_Yellow
    if (t.spellname and IsHelpfulSpell(t.spellname)) then
        c=AMO_Green
    end
    if (t.spellname and IsHarmfulSpell(t.spellname)) then
        c=AMO_Red
    end
    _= this.Label and this.Label:SetTextColor(c.r,c.g,c.b)
end
function lib:FrameAddSpellButton(f,name,x,y,spell,label)
    name=name or ""
    local fname=f:GetName() .. "Spell" ..name
    local b=self:Create("CheckButton",fname,f,"ActionButtonTemplate")
    b.spelltype=nil
    b.name="Empty"
    b:RegisterForClicks("RightButtonUp")
    b:SetScript("OnDragStart",function(this) this:SetSpell(nil) end );
	b:SetScript("OnReceiveDrag",AddSpellButton_OnReceiveDrag)
	b:SetScript("OnMouseUp",AddSpellButton_OnMouseUp)
	b:SetScript("OnClick",function(this) AddSpellButton_SetSpell(this,nil) end)
	b:SetScript("OnEnter",function() self:TTOpen() end)
	b:SetScript("OnLeave",self.TTClose)
	b:SetScript("PostClick",function(this) this:SetChecked(nil) end)
	b.SetSpell=AddSpellButton_SetSpell
    b:SetHeight(32)
    b:SetWidth(32)
    b:SetPoint("TOPLEFT",x or 0,y or 0)
    if (label) then
        b.Label=self:FrameAddLLabel(b,"Text" ,150,34,0)
    	b.SetText=function(this,...) this.Label:SetText(...) end
    	b.SetTextColor=function(this,...) this.Label:SetTextColor(...) end
    else
        b.SetText=function() return end
    end
    if (spell) then
        b:SetSpell(spell)
    end
    b:Show()
    return b
end
function lib:FrameAddHelpButton(f,testo)
    self:argCheck(f,1,"table")
    self:argCheck(testo,2,"string","nil")
    local fname=f:GetName() .. "BtHelp"
    local b=self:Create("Button",fname,f,"UIPanelCloseButton")
    b.ignore=true
    b:SetFrameLevel(10)
    b:SetNormalTexture("interface\\buttons\\ui-microbutton-help-up")
    b:SetPushedTexture("interface\\buttons\\ui-microbutton-help-down")
    b:SetHighlightTexture("interface\\buttons\\ui-microbutton-hilight")
    b:SetHeight(48)
    b:SetWidth(32)
    b:SetPoint("TOPLEFT",f,"TOPRIGHT",-5,16)
    b:SetScript("OnClick",function() self:CmdHelp() end)
    b:RegisterForClicks("LeftButtonUp")
    local h=getglobal(f:GetName() .. 'Header')
    if (h) then
        h:AddScript("OnEnter",function() b:SetAlpha(1) end)
        h:AddScript("OnLeave",function() b:SetAlpha(0) end)
    else
        f:AddScript("OnEnter",function() b:SetAlpha(0.5) end)
        f:AddScript("OnLeave",function() b:SetAlpha(0) end)
    end
    if (testo) then
        self:TTAdd(b,testo,true)
    end
    b:SetAlpha(0)
    b:Show()
    return b
end
local bminus="interface\\buttons\\ui-minusbutton-"
local bplus="interface\\buttons\\ui-plusbutton-"
local function flipbutton(this,status)
    status=status or ''
    if (this.texture == 'plus' or status == 'minus') then
        this:SetNormalTexture(bminus .. "up")
        this:SetPushedTexture(bminus.. "down")
        this:SetHighlightTexture(bminus .. "hilight")
        this.texture="minus"
    else
        this:SetNormalTexture(bplus .. "up")
        this:SetPushedTexture(bplus .. "down")
        this:SetHighlightTexture(bplus .. "hilight")
        this.texture="plus"
    end
end
function lib:DoResize(this,button)
    if (button == "LeftButton") then
        flipbutton(this)
        local form=this:GetParent()
        local current=math.floor(form:GetScale()*100)
        local min=50
        local max=200
        local fname=form:GetName() .. "SliderResizer"
        local s=getglobal(fname)

        if (s) then
            s:ClearAllPoints()
            s.percentage=true
            s.decimals=1
            if (s:IsShown()) then
                s:Hide()
                return
            end
            s:SetPoint("BOTTOMLEFT",form,"TOPLEFT", 0, 5)
            s:Show()
            s:ClearAllPoints()
        end
    elseif (button == "RightButton") then
        self:PrintLiteral("Frame data:",f.storage)
    end
end
function lib:FrameAddMiniHeader(f,titolo)
    local h=self:FrameAddHeader(f,titolo)
    h:SetHeight(16)
    h.ntexture:SetTexture(0,0,0,0)
    if (h.Label) then
        h:SetFontObject(GameFontNormal)
    end
end
function lib:FrameAddHeader(f,titolo,noTexture)
    self:argCheck(f,1,"table")
    self:argCheck(titolo,2,"string","nil")
    self:argCheck(noTexture,3,"nil","boolean")
    local fname=f:GetName() .. 'Header'
    local r=getglobal(fname)
    if (not r) then
        r=self:Create("Frame",fname,f)
        r.compact=true
        f:SetMovable(true)
        f:SetClampedToScreen(true)
        r.ignore=true
        r:SetMovable(true)
        r:EnableMouse(true)
        r:RegisterForDrag("LeftButton")
        r:SetHeight(24)
        r:SetPoint("TOPLEFT",3,-3)
        r:SetPoint("TOPRIGHT",-3,3)
        r:SetScript("OnDragStart",OnDragStartParent)
        r:SetScript("OnDragStop",OnDragStopParent)
        self:TTAdd(r,"Drag to move")
        if (not noTexture) then
            ---------------
            r.ntexture=r:CreateTexture(nil,"ARTWORK")
            r.ntexture:SetTexture(.5,.1,.1)
            r.ntexture:SetGradient("vertical",.4,.1,.1,.8,.2,.2)
            r.ntexture:SetAllPoints(r)
            ---------------
            r.htexture=r:CreateTexture(nil,"HIGHLIGHT")
            r.htexture:SetTexture(.5,.1,.1)
            r.htexture:SetGradient("vertical",.8,.2,.2,.4,.1,.1)
            r.htexture:SetBlendMode("ADD")
            r.htexture:SetAllPoints(r)
        end
    end
    if (titolo) then
        f.Label=f:CreateFontString(fname .. "Label","OVERLAY","GameFontNormal")
        local s=r:CreateFontString(nil,"OVERLAY","GameFontNormalLarge")
        s:SetPoint("TOPLEFT",f.leftmost,0)
        s:SetPoint("BOTTOMRIGHT",f.rightmost,0)
        s:SetJustifyH("LEFT")
        s:SetJustifyV("TOP")
        s:SetText(titolo)
    end
    return r
end
function lib:FrameAddResizer(f)
    local fname=f:GetName() .. 'Resizer'
    local r=self:Create("Frame",fname,f)
    f:SetResizable(true)
    f:SetClampedToScreen(true)
    r.ignore=true
    r:SetResizable(true)
    r:EnableMouse(true)
    r:RegisterForDrag("LeftButton")
    r:SetWidth(64)
    r:SetHeight(32)
    r:SetPoint("BOTTOMRIGHT",f,"BOTTOMRIGHT",18,-10)
    -----------------
    r.ntexture=r:CreateTexture()
    r.ntexture:SetTexture(self:LoadTexture("Buttons"))
    r.ntexture:SetTexCoord(.75,.875,0,.125)
    r.ntexture:SetAllPoints(r)
    -----------------
    r.htexture=r:CreateTexture(nil,"HIGHLIGHT")
    r.htexture:SetTexture(self:LoadTexture("Buttons"))
    r.htexture:SetTexCoord(.75,.875,0,.125)
    r.htexture:SetBlendMode("ADD")
    r.htexture:SetAllPoints(r)
    r:SetScript("OnDragStart",OnDragStartParentNoAlt)
    r:SetScript("OnDragStop",OnDragStopParent)
    return r
end
function lib:FrameAddSlider(f,tipo,testo,min,max,current,x,y)
    local fname=f:GetName() .. 'Slider' .. tipo
    min=min or 0
    max=max or 100
    current=current or 50
    s=self:Create("Slider",fname,f,"OptionsSliderTemplate")
    s.father=f
    s:SetScript("OnShow",function(this) self:SliderUpdate(this) end)
    s:SetScript("OnValueChanged",function(this) self:SliderUpdate(this) end)
    s:SetMinMaxValues(min,max)
    s:SetValue(current)
    s:SetPoint("TOPLEFT",x or 0,y or 0)
    s:Show()
    return s
end
function lib:FrameAddRescaleButton(f)
    f=self:IsFrame(f)
    local fname=f:GetName() .. "BtResize"
    -- Adding Button
    local b=self:Create("Button",fname,f,"UIPanelCloseButton")
    b:SetFrameLevel(10)
    b.ignore=true
    b:SetHeight(16)
    b:SetWidth(16)
    b:SetPoint("TOPLEFT",f,"TOPLEFT",0,0)
    flipbutton(b,"plus")
    self:TTAdd(b,"Rescale\n(Panel could look 'funny' until you reloadUI)")
    b:SetScript("OnClick",function(...) self:DoResize(...) end)
    b:Show()
    -- Adding Slider
    local s =self:FrameAddSlider(f,"Resizer","Scale",50,200,f:GetScale()*100)
    s:SetParent(UIParent)
    s.percentage=true
    s.decimals=1
    s:Hide()
    s:SetScript("OnMouseUp",function(this)
                self:DoResize(b,"LeftButton")
                end)
    local func=f:GetScript("OnHide")
    f:SetScript("OnHide",function ()
        s:Hide()
        pcall(func)
        flipbutton(b,"plus")
    end)
    s.OnRescaled=function(...) self:TestArgs(...) self:FormRescale(...) end
    return b
end
lib.FrameAddResizeButton=lib.FrameAddRescaleButton -- Compatibility

function lib:FormRescale(slider,form)
    local value=slider
    if (type(slider) ~= "number") then
        value=slider:GetValue()/100
    end
    local a,f,r,x,y=form:GetPoint()
    local oldscale=form:GetEffectiveScale()
    self:Scale(form,value,true)
    local newscale=form:GetEffectiveScale()
    form:SetPoint(a,f,r,x*oldscale/newscale,y*oldscale/newscale)
end

function lib:FrameAddCheckbox(f,tipo,GetSet,testo,x,y)
    self:argCheck(f,1,"table")
    self:argCheck(tipo,2,"string","number")
    self:argCheck(GetSet,3,"boolean","function")
    self:argCheck(testo,4,"string","number","nil")
    self:argCheck(x,5,"number","nil")
    self:argCheck(y,6,"number","nil")
    local fname=f:GetName() .. tipo
    local width=f:GetWidth()
    if (type(testo) == "number") then
        width=testo
        testo=""
    else
        testo = testo or ''
    end
    local frame=self:Create("Frame",fname,f)
    x =x or 0
    y= y or 0
    frame:SetPoint("TOPLEFT",x +16 ,y )
    frame:SetWidth(16)
    frame:SetHeight(32)
    if (not frame.Checkbox) then
        if (InterfaceOptions_AddCategory) then 
            frame.Checkbox=self:Create("CheckButton",fname .. 'CheckBox',frame,"InterfaceOptionsSmallCheckButtonTemplate")
        else
            frame.Checkbox=self:Create("CheckButton",fname .. 'CheckBox',frame,"UIOptionsCheckButtonTemplate")
        end
        frame.Checkbox:SetHeight(16)
        frame.Checkbox:SetWidth(16)
        local temp=frame.Checkbox:GetScript("OnClick")
        if (type("GetSet") == "function") then
            frame.Checkbox:SetChecked(GetSet(tipo))
            if (type(temp)=='function') then
                frame.Checkbox:SetScript('OnClick',function(...)
                                                temp(...)
                                                GetSet(tipo,(not not this:GetChecked()))
                                               end
                                    )
            else
                frame.Checkbox:SetScript('OnClick',function(...)
                                                GetSet(tipo,(not not this:GetChecked()))
                                               end
                                            )
            end
        else
            frame.Checkbox:SetChecked(GetSet)
        end
    end
    frame:SetWidth(width)
    if (not frame.Label) then
        frame.Label=frame:CreateFontString(fname .. "Label","OVERLAY","GameFontNormal")
    end
    frame.Checkbox:SetPoint("TOPRIGHT",frame,"TOPLEFT",0,-8)
    frame.Label:SetAllPoints(frame)
    frame.Label:SetJustifyH("LEFT")
    frame.SetText=function(this,testo) this.Label:SetText(testo) end
    frame.ResizeToString=function(this,testo) if (testo) then this:SetText(testo) end this:SetWidth(this.Label:GetStringWidth()) end
    frame.GetText=function(this) return this.Label:GetText() end
    frame.GetChecked=function(this) return this.Checkbox:GetChecked() end
    frame.SetChecked=function(this,testo) this.Checkbox:SetChecked(testo) end
    frame:SetText(testo)
    return frame

    
end

function lib:TestArgs(...)
    if (self) then
        self:Debug("TestArgs",...)
    else
        DEFAULT_CHAT_FRAME:AddMessage("TestArgs called with invalid self",1,0.5,0.2)
    end
end
function lib:SliderUpdate(Slider)
    local frame=Slider.father
    if (frame) then
        if (not Slider.percentage and not Slider.decimals) then
            Slider.decimals=1
        end
    	local vcurrent=Slider:GetValue()
        local formato="%"
        if (Slider.decimals) then
            formato=formato.. "." .. Slider.decimals .. "f"
            vcurrent=math.floor(vcurrent * 10 ^ Slider.decimals)/10 ^ Slider.decimals
        else
            formato=formato .. "d"
            vcurrent=math.floor(vcurrent)
        end
        if (Slider.percentage) then
            perc="%"
        else
            perc=""
        end
        local sn=Slider:GetName()
    	local vmin,vmax=Slider:GetMinMaxValues()
    	local x=getglobal(sn .. "Low")
    	if (x) then
    		x:SetText(format(formato,vmin) .. perc)
    	end
    	x=getglobal(sn .. "High")
    	if (x) then
    		x:SetText(format(formato,vmax) .. perc)
    	end
    	x =getglobal(sn .. "Text")
    	if (x) then
    		x:SetText(format(formato,vcurrent) .. perc)
    	end
    	if (type(Slider.OnRescaled) == "function") then
            Slider:OnRescaled(frame)
    	end
    end
end
function lib:FrameAddUnitButton(f,name,testo,unit,x,y)
    local b=self:FrameAddButton(f,name,testo,x,y,",SecureActionButtonTemplate")
    b:SetAttribute("type1","macro")
    b:SetAttribute("macrotext1","/target " .. unit)
    b.SetUnit=function(this,unit,extra)
        this:SetAttribute("macrotext1","/target " .. unit)
        this:SetText(unit .. (extra or  ''))
        this.Unit=unit
        end
    b.GetUnit=function(this) return this.Unit or 'none' end
    b:RegisterForClicks("AnyUp")
    return b
end
function lib:FrameAddText(...)
    local tt=new()
    for i=1,select('#',...),2 do
        local key,value=select(i,...)
        tt[key]=value
    end
    local f
    if (tt.clickable) then
        f=self:CreateFrame("Button")
    else
        f=self:CreateFrame("EditBox")
        f:SetMultiLine(true)
        f:SetAutoFocus(false)
    end
end
function lib:FrameAddButton(f,tipo,testo,x,y,moretemplate)
    moretemplate = moretemplate or ''
    tipo=tipo or 'AMO'
    testo=testo or tipo
    tipo=string.capitalize(tipo)
    local fname=f:GetName() .. "Bt" .. tipo
    local b=self:Create("Button",fname,f,"UIPanelButtonTemplate" .. moretemplate)
    local width=0
    b:SetText(testo)
    width=b:GetTextWidth() + 5 -- Allow for button border
    if (width < 32) then
        width=32
    elseif (width >200) then
        width=200
    end
    b:SetHeight(32)
    b:SetFrameLevel(10)
    b:SetWidth(width)
    fs=nil
    local function closefunc()
        local a=this:GetParent()
        if (a) then
            a:Hide()
        end
    end
    if (tipo=="Close") then
        self:TTAdd(b,"Close this panel")
        b:SetPoint("BOTTOM",f,"BOTTOM",0,10)
        b:SetScript("PostClick",closefunc)
    elseif (tipo == "Cancel") then
        self:TTAdd(b,"Exit without saving your changes")
        b:SetPoint("BOTTOMLEFT",f,"BOTTOMLEFT",30,15)
        b:SetScript("PostClick",closefunc)
    elseif (tipo=="Save") then
        self:TTAdd(b,"Save your changes and exit")
        b:SetPoint("BOTTOMRIGHT",f,"BOTTOMRIGHT",-30,15)
        b:SetScript("PostClick",closefunc)
    else
        local x = x or 0
        local y = y or 0
        b:SetPoint("TOPLEFT",x,y)
    end
    b:Show()
    return b,self:GetXY(f,b)
end
local function enhance(this,c,v)
    this:SetBackdropColor(c.r,c.g,c.b,v)
end
function lib:SetClick(f,func,color,alpha)
    self:argCheck(f,1,"table","string")
    self:argCheck(func,2,"function","nil")
    self:argCheck(color,3,"table","nil")
    self:argCheck(alpha,4,"number","nil")
    color=color or AMO_Yellow
    alpha=alpha or 0.5
    f=self:IsFrame(f)
	local highlight = f:CreateTexture(nil, "HIGHLIGHT")

	highlight:SetTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	highlight:SetBlendMode("ADD")
	highlight:SetAllPoints(f)
	--highlight:Hide()    
	--self.highlight = highlight
    f:EnableMouse(true)
    --[[
    self:SetBackdrop(f,"background",0)
    f:SetScript("OnEnter",function(this) enhance(this,color,alpha) end)
    f:SetScript("OnLeave",function(this) enhance(this,color,0) end)
    --]]
    if (func) then
        f:SetScript("OnMouseUp",func)
    end
end
function lib:FrameBOTH(f,x)
    x=x or 5
    if (type(f)=="string") then
        f=getglobal(f)
    end
    if (f) then
        local a1,p,a2,x,y=f:GetPoint()
        f:SetPoint("LEFT",p,"LEFT" ,x,y)
        f:SetPoint("RIGHT",p,"RIGHT" ,-x,y)
    end
end
function lib:FrameRIGHT(f,themost)
    if (type(f)=="string") then
        f=getglobal(f)
    end
    if (f) then
        local a1,p,a2,x,y=f:GetPoint()
        if (themost) then
            x=-10
        else
            x=x-p:GetWidth()
        end
        a1=a1:gsub("LEFT","RIGHT")
        a2=a2:gsub("LEFT","RIGHT")
        f:ClearAllPoints()
        f:SetPoint(a1,p,a2 ,x,y)
    end
end
function lib:FrameBOTTOM(f)
    if (type(f)=="string") then
        f=getglobal(f)
    end
    if (f) then
        local a1,p,a2,x,y=f:GetPoint()
        if (themost) then
            y=y+10
        else
            y=y+p:GetHeight()
        end
        a1=a1:gsub("TOP","BOTTOM")
        a2=a2:gsub("TOP","BOTTOM")
        f:SetPoint(a1,p,a2 ,x,y)
    end
end
function lib:FrameMove(f,x,y,rightalign)
    if (type(f)=="string") then
        f=getglobal(f)
    end
    if (f) then
        local a1,p,a2,ox,oy=f:GetPoint()
        f:SetPoint(a1,p,a2 ,x or ox,y or oy)
    end
end
function lib:FrameAddCloseButton(f)
    return self:FrameAddButton(f,"Close")
end
function lib:FrameAddSaveButton(f)
    return self:FrameAddButton(f,"Save")
end
function lib:FrameAddCancelButton(f)
    return self:FrameAddButton(f,"Cancel")
end
function lib:TTAdd(frame,message,autohide)
    frame=self:IsFrame(frame,true)
    if (frame) then
        if (message) then
            frame:EnableMouse(true)
            frame:SetScript("OnEnter",
                            function()
                                frame:SetAlpha(1)
                                self:TTOpen()
                            end)
            frame:SetScript("OnLeave",
                            function()
                            self:TTClose()
                                if (autohide) then
                                    frame:SetAlpha(0)
                                end
                            end)
            frame.Tooltip=tostring(message)
        else
            frame:SetScript("OnEnter",nil)
            frame:SetScript("OnLeave",nil)
        end
    end
end

function lib:FrameAddLabel(f,nome,testo,x,y)
    local width
    local fname=(f:GetName() or '') .. nome
    local frame=self:Create("Frame",fname,f)
    if (type(testo) == "number") then
        width=testo
        testo=nil
    end
    frame:SetPoint("TOPLEFT",x or 0,y or 0)
    frame:SetHeight(16)
    if (not frame.Label) then
        frame.Label=frame:CreateFontString(fname .. "Label","OVERLAY","GameFontNormal")
    end
    if (testo) then
        frame.Label:SetText(testo)
        if (not width) then
            width=frame.Label:GetStringWidth()
        end
    end
    if (not width) then
        width=f:GetWidth()
    end
    frame:SetWidth(width)
    frame.Label:SetAllPoints(frame)
    frame.SetText=function(this,text) this.Label:SetText(text) end
    frame.SetFormattedText=function(this,fmt,...) this.Label:SetFormattedText(fmt,...) end
    frame.SetTextColor=function(this,r,g,b,a) this.Label:SetTextColor(r,g,b,a) end
    frame.GetText=function(this) return this.Label:GetText() end
    return frame
end

function lib:FrameAddTitle(f,nome,testo,x,y)
    x=0
    y=y or 0
    local frame=self:FrameAddLabel(f,nome,testo,x,y)
    frame:SetPoint("TOPRIGHT",x,y) -- So it's resized automaigcally
    frame.Label:SetJustifyH("CENTER")
    return frame
end

function lib:FrameAddCLabel(f,nome,testo,x,y)
    local frame=self:FrameAddLabel(f,nome,testo,x,y)
    frame.Label:SetJustifyH("CENTER")
    frame.Label:SetNonSpaceWrap(false)
    return frame
end

function lib:FrameAddLLabel(f,nome,testo,x,y)
    local frame=self:FrameAddLabel(f,nome,testo,x,y)
    frame.Label:SetJustifyH("LEFT")
    frame.Label:SetNonSpaceWrap(false)
    return frame
end


function lib:FrameAddRLabel(f,nome,testo,x,y)
    local frame=self:FrameAddLabel(f,nome,testo,x,y)
    frame.Label:SetNonSpaceWrap(false)
    frame.Label:SetJustifyH("RIGHT")
    return frame
end


function lib:FrameAddIcon(f,tipo,texture,x,y)
    local b=f:CreateTexture((f:GetName() or '')  .. tipo .. "Icon")
    x=x or 0
    y=y or 0
    b:SetPoint("TOPLEFT",x,y)
    b:SetWidth(16)
    b:SetHeight(16)
    b:SetTexture(texture)
    --b:SetHeight(32)
    --b:SetWidth(32)
    return b
end
function lib:FrameAddPanel(f,nome,attach,x,y)
    local width=f:GetWidth()
    x = x or 0
    y = y or 0
    attach=attach or 'none'
    attach=strupper(attach)
    local fname=f:GetName() .. nome
    local frame=self:Create("Frame",fname,f)
    self:SetBackdrop(frame,f.storage.Backdrop)
    if (attach=='LEFT') then
        frame:SetPoint("TOPRIGHT",f,"TOPLEFT",0,0)
        frame:SetPoint("BOTTOMRIGHT",f,"BOTTOMLEFT",0,0)
    elseif (attach=='TOP') then
        frame:SetPoint("BOTTOMLEFT",f,"TOPLEFT",0,0)
        frame:SetPoint("BOTTOMRIGHT",f,"TOPRIGHT",0,0)
    elseif (attach=='RIGHT') then
        frame:SetPoint("TOPLEFT",f,"TOPRIGHT",0,0)
        frame:SetPoint("BOTTOMLEFT",f,"BOTTOMRIGHT",0,0)
    elseif (attach=='BOTTOM') then
        frame:SetPoint("TOPLEFT",f,"BOTTOMLEFT",0,0)
        frame:SetPoint("TOPRIGHT",f,"BOTTOMRIGHT",0,0)
    else
        f:SetPoint("TOPLEFT",x,y)
    end
    frame:SetWidth(width)
    frame:SetHeight(100)
    return frame
end
function lib:TRACK(...)
   local event = AceLibrary("AceEvent-2.0").currentEvent
   self:Print(self:GetDebugPrefix(),event,...)
end
function lib:TTClose()
	GameTooltip:FadeOut()
end

function lib:TTFade()
	GameTooltip:FadeOut()
end
function lib:TTFormat(lmessage,rmessage)
    lmessage=lmessage or ''
    rmessage=rmessage or ''
    self:TTOpen(
        AMO_GREEN .. lmessage .. AMO_GREEN .. rmessage .. AMO_ENDCOLOR
    )
end
function lib:TTOpen(message)
    if (this:GetAlpha() < 0.1) then
        return
    end
    local ex=0
    if (type(message)~="string") then
        if (type(this.tooltipFunction) == "function") then
            message=this:tooltipFunction(message)
            ex=1
        elseif (type(this.tooltipText)=="string") then
            message=this.tooltipText
            ex=2
        elseif (type(this.Tooltip)=="string") then
            message=this.Tooltip
            ex=3
        else
            message=nil
            ex=4
        end
    end
    if (not message) then
        return
    end
    if (tostring(message) == "nil") then
        return
    end
	local p=this:GetParent()
	if (p and p:GetFrameStrata() == "TOOLTIP") then
    	GameTooltip:SetOwner(this, "ANCHOR_RIGHT",0,-40)
        GameTooltip:SetFrameLevel(p:GetFrameLevel()-1)
    else
	   GameTooltip:SetOwner(this, "ANCHOR_CURSOR",50,0)
    end
	GameTooltip:SetText(message, AMO_Yellow.r,AMO_Yellow.g,AMO_Yellow.b,0.9, 1)
	if ( this.tooltipRequirement ) then
		GameTooltip:FrameAddLine(this.tooltipRequirement, "", 1.0, 1.0, 1.0);
	end
    GameTooltip:Show()

end
lib.PoiiOffsets={
MiNN=0, -- Neutral mine
MiHH=1,   -- Horde mine
MiAA=2,   -- Ally mine
GyAN=3,   -- Ally contested Graveyard
HoNN=4,   -- Neutral Home
ToNN=5,   -- Neutral Tower
ObNN=6,   -- Objective
GyNN=7,   -- Neutral Graveyard
ToAN=8,   -- Ally contested Tower
ToHH=9,   -- Horde Tower
ToAA=10,  -- Ally Tower
ToHN=11,  -- Horde Contested Tower
GyHH=12,  -- Horde Graveyard
GyHN=13,  -- Horde Contested Graveyard
GyAA=14,  -- Ally Graveyard
GmNN=16,  --Golden Mine
GmAN=17,
GmAA=18,
GmHN=19,
GmHH=20,
LmNN=21,  --Lumber Mill
LmAN=22,
LmAA=23,
LmHN=24,
LmHH=25,
BsNN=26,  --BlackSmith
BsAN=27,
BsAA=28,
BsHN=29,
BsHH=30,
FaAA=31,  --Farm
FaAN=32,
FaAA=33,
FaHN=34,
FaHH=35,
StAA=36,  --Stables
StAN=37,
StAA=38,
StHN=39,
StHH=40,
SkNN=41,  -- Skull
SkXX=42,  --Dunno...
FlAA=43,
FlHH=44,
FlNN=45,
BaAA=46,
BaAN=47,
BaHH=48,
BaHA=49,
INVI=55
}
function lib:GetTexCoord(typ,splitter)
    self:argCheck(typ,1,"number","nil")
    self:argCheck(splitter,2,"number","nil")
    typ=typ or 1
    splitter=splitter or 8
    local row,col=self:Split(typ,splitter) -- 8 icons each row
    return 1/splitter*col,1/splitter*(col+1),1/splitter*row,1/splitter*(row+1)
end
function lib:SetPoiiOffset(f,typ,splitter)
    self:argCheck(f,1,"table")
    f:SetTexCoord(unpack({self:GetTexCoord(typ,splitter)}))
end
lib.SetTexCoord=lib.SetPoiiOffset
----------------------------------------
function lib:GetTooltip()

    return AMOCOMMON.LocalTip
end
local MTFrame=CreateFrame("frame")
function lib:CreateMiniPanel(nome,titolo)
    return self:CreatePanel(nome,{
        Cancel=true,
        Save=true,
        backdrop='minimal',
        Rescale=false,Resize=true,Config=false,
        Header=self.L[titolo],
        Width=300,
})
end
function lib:CreateTrackerPanel(nome,titolo)
    return self:CreatePanel(nome,{
        noCancel=1,
        noSave=1,
        backdrop='none',
        noRescale=true,
        noResize=true,
        noConfig=true,
        noMin=true,
        MiniHeader=self.L[titolo],
        Width=250,
})
end
function lib:CreatePanel(nome,p,show)
    p=p or {}
    p.name=nome or "Panel" .. math.ceil(time())
    local f=self:Create("Panel",p.name,UIParent)
    self:SetBackdrop(f,p.backdrop)
    f:SetParent(UIParent)
    f:SetHeight(p.Height or 400)
    f:SetWidth(p.Width or 400)
    if (p.minsize) then
        self:PanelMinSize(f,f:GetWidth(),f:GetHeight())
    end
    f:SetScale(0.8) -- My default scale
    self:PanelRestore(f) -- If it was never saved, Panel restore does nothing
    -- I DONT save panel now, because the creation process could be change it
    -- and I dont want to create false defaults
    -- X Button
    f.rightmost=0
    f.leftmost=0
    local bx
    if (p.X or not p.noX) then --default: yes
        local b,x,y=self:FrameAddXButton(f)
        f.rightmost=f.rightmost - 30
        bx=b
    end
    if (p.Min or not p.noMin) then --default: yes
        local b,x,y=self:FrameAddMinButton(f)
        f.rightmost=f.rightmost - b:GetWidth() -2
    end
    if (p.Config and not p.noConfig) then --default: no
        local b,x,y=self:FrameAddConfigButton(f)
        f.rightmost=f.rightmost - b:GetWidth() -2
    end
    if (p.Close and not p.noClose ) then --default: no
        local b,x,y=self:FrameAddCloseButton(f)
        if (type(p.closefunc) == "function") then
            b:SetScript("OnClick",p.closefunc)
        end
        b.compact=true
    end
    if (p.Save or not p.noSave) then --default yes
        local b,x,y=self:FrameAddSaveButton(f)
        if (type(p.savefunc) == "function") then
            b:SetScript("OnClick",p.savefunc)
        end
        b.compact=true
    end
    if (p.Cancel or not p.noCancel) then --default yes
        local b,x,y=self:FrameAddCancelButton(f)
        if (type(p.cancelfunc) == "function") then
            b:SetScript("OnClick",p.cancelfunc)
        end
        b.compact=true
    end
    if (p.Rescale or not p.noRescale) then --default: true
        local b,x,y=self:FrameAddRescaleButton(f)
        b.compact=true
        f.leftmost=f.leftmost+b:GetWidth()+2
    end
    if (p.Help and not p.noHelp) then --default: no
        if (p.Helptext) then
            self:AttachHelp(f,p.Helptext)
        end
    end
    if (p.Movable and not p.noMovable) then --default: no
        self:MakeMovable(p.name,p.noTip)
    end
    if (p.Resize or not p.noResize) then -- default: yes
        self:FrameAddResizer(f)
    end
    if ((p.Header or not p.noHeader) and not p.MiniHeader) then
        self:FrameAddHeader(f,p.Header)
    end
    if (p.MiniHeader and  not p.noMiniHeader) then
        self:FrameAddMiniHeader(f,p.MiniHeader)
        if (bx) then
            bx:SetPoint("TOPRIGHT",5,5)
        end
    end
    if (show) then
        f:Show()
    end
    f:SetScript("OnSizeChanged",ClipChildren)
    return f
end

function lib:CreateTargetPanel(nome,show,unit)
    local f=self:Create("Panel",nome,UIParent)
    self:SetBackdrop(f,"border")
    f:SetParent(UIParent)
    f:SetHeight(37)
    f:SetWidth(94)
    self:FrameAddXButton(f)
    f.button=self:FrameAddUnitButton(f,"target",unit,unit,0,-5)
    f.SetUnit=(function(this,unit)
        this.button:SetUnit(unit)
        end)
end
function lib:CreateButtonPanel(nome,show,message,func)
    local f=self:Create("Frame",nome,UIParent)
    local x=0
    local y=0
    AMOCOMMON.CastPanels=AMOCOMMON.CastPanels or {}
    AMOCOMMON.CastPanels[f]=1
    self:SetBackdrop(f,nil)
    f:SetParent(UIParent)
    f:SetPoint("CENTER",UIParent,"CENTER",x,y)
    f:SetHeight(64)
    f:SetWidth(64)
    local b=self:FrameAddXButton(f)
    if (type(func) ~= "function") then
        func=function(...) self:Print(...) end
    end
    if (type(message) ~= "string") then
        message="Click!"
    end
    b=self:FrameAddButton(f,"",message,-10,-18)
    self:TTAdd(b,message)
    f.Button=b
    f.SetText=function(this,...) f.b:SetText(...) end
    b:SetHeight(32)
    b:SetWidth(64)
    b:SetScript("OnClick",function(...)
            func(...)
            this:GetParent():Hide()
            end
    )
    f.Pop=function(this,delay)
        delay=delay or 30
        local x=0
        for p in pairs(AMOCOMMON.CastPanels) do
            if (p:IsShown() and p ~= this) then
                x=x+64
            end
        end
        this:SetPoint("CENTER",UIParent,"CENTER",x,0)
        this:Show()
        UIFrameFadeOut(this,delay,1.0,0.5)
        AMO:ScheduleEvent(function() this:Hide() this:SetAlpha(1.0) end,delay)
    end
    if (show) then
        f:Pop()
    end
    return f
end

ScrollPanelMethods={
SetText=function(frame,stringa) 
        frame.testo:SetText(tostring(stringa))
        frame.child:SetHeight(frame.testo:GetHeight())
        frame:SetVerticalScroll(0)
        frame.child:SetWidth(frame:GetWidth())
    end,
SetWidth=function(frame,width,...) 
    frame.org.SetWidth(frame,width)
    frame.child:SetWidth(frame:GetWidth())
end,
SetTextColor=function(frame,...) frame.testo:SetTextColor(...) end,
SetFormattedText=function(frame,...) frame.testo:SetFormattedText(...) end,
SetJustifyH=function(frame,...) frame.testo:SetJustifyH(...) end,
SetJustifyV=function(frame,...) frame.testo:SetJustifyV(...) end,
SetFontObject=function(frame,font,...) frame.testo:SetFontObject(font) end,
}
function lib:CreateScrollPanel(nome)
    local frame=CreateFrame("ScrollFrame",nome,UIParent,"UIPanelScrollFrameTemplate")
    local child=CreateFrame("EditBox",nil,frame)
    child:SetAutoFocus(false)
    child:SetMultiLine(true)
    child:EnableKeyboard(false)
    child:EnableMouse(false)
    child:SetFontObject("GameFontNormalSmall")
    child:SetTextInsets(5,5,0,0)
    frame:SetScrollChild(child)
    frame.child=child
    frame.testo=child
--[[
    local child=CreateFrame("Frame",nome .. "child",frame)
    frame:SetScrollChild(child)
    frame.child=child
    frame.testo=child:CreateFontString(nil,"OVERLAY","GameFontNormalSmall")
    frame.testo:SetPoint("TOPLEFT",5,0)
    frame.testo:SetPoint("BOTTOMRIGHT",-5,0)
    frame.testo:SetNonSpaceWrap(true)
    frame.child:SetHeight(1000) -- TODO: Find a way to dinamically resize it
--]]
    frame.org={}
    for method,func in pairs(ScrollPanelMethods) do
        frame.org[method]=frame[method]
        frame[method]=func
    end
    frame:SetScript("OnShow",function(frame) frame.child:SetWidth(frame:GetWidth()) end )
    frame:SetScript("OnSizeChanged",function(frame) frame.child:SetWidth(frame:GetWidth()) end )
    frame:Show()
    return frame

end
function lib:CreateCastPanel(nome,show,spell)
    local f=self:Create("Frame",nome,UIParent)
    local x=0
    local y=0
    AMOCOMMON.CastPanels=AMOCOMMON.CastPanels or {}
    AMOCOMMON.CastPanels[f]=1
    self:SetBackdrop(f,nil)
    f:SetParent(UIParent)
    f:SetPoint("CENTER",UIParent,"CENTER",x,y)
    f:SetHeight(48)
    f:SetWidth(64)
    local b=self:FrameAddXButton(f)
    b=self:FrameAddCastButton(f,"",5,-5)
    f.SpellButton=b
    b:SetScript("PostClick",function(this)
          this:GetParent():Hide()

    end)
    if (spell) then
        b:SetSpell(spell)
    end
    f.SetSpell=function(this,t) this.SpellButton:SetSpell(t) end
    f.Pop=function(this,delay)
        delay=delay or 30
        local x=0
        for p in pairs(AMOCOMMON.CastPanels) do
            if (p:IsShown() and p ~= this) then
                x=x+64
            end
        end
        this:SetPoint("CENTER",UIParent,"CENTER",x,0)
        this:Show()
        UIFrameFadeOut(this,delay,1.0,0.5)
        AMO:ScheduleEvent(function() this:Hide() this:SetAlpha(1.0) end,delay)
    end
    if (show) then
        f:Pop()
    end
    return f
end
function lib:Create(tipo,nome,frameobject,template)
    local frameobject=frameobject or UIParent
    local isPanel
    if (tipo=="Panel") then
        isPanel=true
        tipo="Frame"
    end
    local f=getglobal(nome)
    if (not f) then
        r,f=pcall(CreateFrame,tipo,nome,frameobject,template)
        if (not r) then
            self:PrintLiteral(tipo,nome,frameobject,template)
            self:Error("Error AMO_Create: " .. f .. "-" ..tostring(nome))
            return nil
        end
    end
    if (isPanel) then
        f.storage=self.db.profile.forms[nome]
    end
    f.objectname=nome
    f.ClipChildren=ClipChildren
    f.FitChildren=FitChildren
    f.AddScript=AddScript
    return f
end
---------- Event System --------------------------------
function lib:Every(func,elapsed,every,key)
    if (not func) then
        return
    end
    if (not AMOCOMMON.Timers) then
        AMOCOMMON.Timers={}
    end
    key = key or tostring(func)
    if (not AMOCOMMON.Timers[key]) then
        AMOCOMMON.Timers[key]=0
    end
    AMOCOMMON.Timers[key]=AMOCOMMON.Timers[key] + elapsed
    while (AMOCOMMON.Timers[key] > every) do
        if (type(func) == "function") then
            func()
        else
            self:Print("Called with wrong func")
        end
        AMOCOMMON.Timers[key]=AMOCOMMON.Timers[key] - every
    end
end

function lib:EvtPLAYER_REGEN_ENABLED()
end
function lib:EvtPLAYER_REGEN_DISABLED()
end
function lib:EvtACTIONBAR_SLOT_CHANGED(numslot)
    AMOCOMMON.dirtybar=numslot
end
function lib:EvtUPDATE_BINDINGS()
    self:GetAllBinds()
end
function lib:SpellCache(key,book)
    book = book or BOOKTYPE_SPELL
    if (not AMOCOMMON.spellcache) then
        self:Debug("Cache regeneration")
        AMOCOMMON.spellcache={}
        AMOCOMMON.spellcache[BOOKTYPE_SPELL]={}
        AMOCOMMON.spellcache[BOOKTYPE_PET]={}
        local bases={BOOKTYPE_SPELL,BOOKTYPE_PET}
        for _,base in pairs(bases) do
            local i=1
            while true do
               local spell, rank = GetSpellName(i, base)
               if (not spell) then
                  break
               end
               AMOCOMMON.spellcache[base][spell]=i
               if (rank) then
                  spell = spell.." ("..rank..")"
                  AMOCOMMON.spellcache[base][spell]=i
               end
               i = i + 1
            end
        end
        self:Debug("Cache regenerated")
    end
    if (key) then
        return AMOCOMMON.spellcache[book][key]
    end
end
---------------- Deprecated functions
AMO_AddTooltip=AMO_TTAdd
--- For Version 2.0.1 20001
function lib:PushBind(action,key1,key2)
    if (not action or action) then
        return
    end
    local mod,command=string.split("_",action)
    if (not mod) then
        return
    end
    if (AMOCOMMON.Modules[mod]) then
        local modulo=getglobal(mod)
        local func=modulo['Bind']
        if (type(func)=="function") then
            local rc,message=pcall(func,modulo,command,key1,key2)
            if (not rc) then
                self:Error("Errore on action %s (%s)",action,message)
            end
        end
    end
end
function lib:GetSetProfile(key,value)
    self:argCheck(key,1,"string")
    if (type(value)~="nil") then
        self.db.profile.data[key]=value
    end
    return self.db.profile.data[key]
end
function lib:GetSetChar(key,value)
    self:argCheck(key,1,"string")
    if (type(value)~="nil") then
        self.db.char.data[key]=value
    end
    return self.db.char.data[key]
end
function lib:GetAllBinds(show)
    local header=nil
    for i=1,GetNumBindings() do
        action,key1,key2=GetBinding(i)
        local prefix=string.split("_",action)
        if (show) then
            self:Print(self:SafeConcat(" ",action,key1,key2))
        elseif (prefix == "HEADER") then
            header = action == "HEADER_AMO_HEADER"
        elseif (header) then
            self:PushBind(action,key1,key2)
        end
    end
end

function lib:MoneyFormat(amount)
    local c,s,g
    amount=tonumber(amount) or 0
    local signus=AMO_GREEN .. "got "
    if (amount < 0 ) then
        signus=AMO_RED .. "lost " .. AMO_ENDCOLOR
        amount=amount * -1
    end
    c=amount % 100
    amount=floor(amount / 100)
    s=amount % 100
    amount= floor(amount/100)
    g=amount
    g=AMO_GOLD .. g .. "g."
    s=AMO_SILVER .. s .. "s."
    c=AMO_COPPER .. c .. "c" .. AMO_ENDCOLOR
    return signus.. g..s..c
end
function lib:Split(id,rowlen)
    local row=math.floor(id/rowlen);
    local col=id-(row*rowlen)
    return row,col
end
function lib:TimeToStr(time) -- Converts time data to a string format
	local p,s, m , h;
	if (not time) then
        return ("0:00")
    end
    p=''
    if (time < 0) then
        time=math.abs(time)
        p='-'
    end
	s = math.floor(mod(time, 60));
	m = math.floor(time/ 60);
	if (m > 59) then
        h=math.floor(m/60)
        m=math.floor(mod(m,60))
    end
    if (h) then
	   if ( m < 10 ) then
            m = "0" .. m;
       end
       h=h .. ":"
    else
        h=''
    end
	if ( s < 10 ) then
        s = "0" .. s;
    end

	return p .. m .. ":" .. s;
end

function lib:SetBackdrop(f,tipo,alpha)
    self:argCheck(f,1,"table","string")
    self:argCheck(tipo,2,"table","string","nil")
    self:argCheck(alpha,3,"number","nil")
    f=self:IsFrame(f)
    if (not f) then
        return
    end
    if (not tipo and f.storage) then
        tipo=f.storage.Backdrop
    end
    if (type(tipo) == "table") then
        pcall(f.SetBackdrop,f,tipo)
    elseif (type("tipo") == "string") then
        pcall(f.SetBackdrop,f,Backdrops[tipo])
    else
        f:SetBackdrop(nil)
    end
    if (f.storage) then
        f.storage.Backdrop=tipo
    end
    if (alpha) then
        local r,g,b,a=f:GetBackdropColor()
        f:SetBackdropColor(r,g,b,alpha)
    end
    return f:GetBackdrop()
end
function lib:iCmdButton(arg1)
    arg1=arg1 or 'Heal'
    b=self:CreateCastPanel("amo_b",true,arg1)
end
function lib:iCmdTarget(arg1)
    arg1=arg1 or 'player'
    b=self:CreateTargetPanel("amo_t",true,arg1)
end
function lib:CoTest(...)
    for i=1,19 do
        self:PrintLiteral("CoTest",i,...)
        if (coroutine.yield()) then
            self:Print("Stopped in advance")
            return
        end
    end
    self:Print("Terminating CoRoutine")
end
function lib:iCmdCopause()
    self:CoroutinePause("TESTCO")
end
function lib:iCmdCocreate()
    self:CoroutineCreate("TESTCO","CoTest",5,"pippo","pluto","paperino")
end
function lib:iCmdCostart()
    self:CoroutineStart("TESTCO")
end
function lib:iCmdCostop()
    self:CoroutineTerminate("TESTCO")
end
function lib:iCmdColist()
    self:PrintLiteral(AMOCOMMON.coroutines)
end


function lib:iCmdPopup()
	local anchor = CreateFrame("CheckButton", "AnchorEnterTest", UIParent, "SecureAnchorEnterTemplate")
	anchor:SetPoint("TOPLEFT", UIParent, "CENTER")
	anchor:SetAttribute("*childraise-OnEnter", true)
	anchor:SetAttribute("*childstate-OnEnter", "enter");
	anchor:SetAttribute("*childstate-OnLeave", "leave");
	local hdr = CreateFrame("Frame", "AnchorEnterTest_hdr", anchor, "SecureStateHeaderTemplate")
	hdr:SetPoint("CENTER")
	hdr:SetAttribute("statemap-anchor-enter", "1")
	hdr:SetAttribute("statemap-anchor-leave", ";") -- a nonempty statemap.  to work with the delay
	hdr:SetAttribute("delaystatemap-anchor-leave", "1:0");
	hdr:SetAttribute("delaytimemap-anchor-leave",  "1:1");
	hdr:SetAttribute("delayhovermap-anchor-leave", "1:true");
	anchor:SetAttribute("anchorchild", hdr)
	for i = 1,6 do
		local btn = CreateFrame("CheckButton", "AnchorEnterButton"..i, hdr, "ActionBarButtonTemplate")
		btn:SetAttribute("ofspoint", "*:LEFT");
		btn:SetAttribute("ofsrelpoint", "*:RIGHT");
		btn:SetAttribute("ofsx", 40 * i);
		btn:SetAttribute("ofsy", 0);
		btn:SetAttribute("*type*", "action")
		btn:SetAttribute("*action*", 114+i)
		btn:SetAttribute("hidestates", 0)
		hdr:SetAttribute("addchild", btn)
	end
    anchor:SetHeight(AnchorEnterButton1:GetHeight())
	anchor:SetWidth(AnchorEnterButton1:GetWidth() * 6)
end
function lib:CoroutineCreate(name,method,tick,...)
    name=self.ID .. name
    self:Trace("CoCreate",name)
    tick=tick or 0.2
    local co=coroutine.create(self[method])
    if (not AMOCOMMON.coroutines) then
        AMOCOMMON.coroutines={}
    end
    AMOCOMMON.coroutines[name]={
        coroutine=co,
        method=method,
        tick=tick,
        args={...}
    }
end
function lib:CoroutineExecute(...)
    self:CoroutineCreate(...)
    self:CoroutineStart(...)
end
function lib:CoroutineStatus(name)
    name=self.ID .. name
    self:Trace(name)
    local cox=AMOCOMMON.coroutines[name]
    if (not cox) then
        self:Error("Coroutine %s not existent",name)
        return
    end
    self:Notify("Coroutine %s: %s",name,coroutine.status(cox.coroutine))
end
function lib:CoroutineStart(name)
    name=self.ID .. name
    self:Trace(name)
    local cox=AMOCOMMON.coroutines[name]
    if (not cox) then
        self:Error("Coroutine",name,"not existent")
        return
    end
    if (type(cox.coroutine) ~= "thread") then
        self:Trace("CoReCreate",name)
    -- Dead coroutine.. Automagically recreate it
        cox.coroutine=coroutine.create(self[cox.method])
        cox.paused=false
    end
    if (not cox.paused) then
        coroutine.resume(cox.coroutine,self,unpack(cox.args)) -- first iteration
        cox.paused=true
    else
        coroutine.resume(cox.coroutine) -- restarting, no parametersi needed
    end
    -- scheduling iterations
    self:ScheduleRepeatingEvent(
        name,
        function(self,name,co)
            --self:PrintLiteral(GetTime(),name,co)
            if (coroutine.status(co) == 'dead' ) then
                if (self:IsEventScheduled(name)) then
                    self:CancelScheduledEvent(name)
                end
                AMOCOMMON.coroutines[name].coroutine=nil
            end
            if (coroutine.status(co) == "suspended") then
                coroutine.resume(co)
            end
        end,
        cox.tick,self,name,cox.coroutine
    )
end
function lib:CoroutinePause(name)
    name=self.ID .. name
    self:Trace(name)
    if (self:IsEventScheduled(name)) then
        self:CancelScheduledEvent(name)
    end
end
function lib:CoroutineTerminate(name)
    name=self.ID .. name
    self:Trace(name)
    local cox=self.coroutines[name]
    local co=cox.coroutine
    if (type(co) ~= "thread") then
        if (coroutine.status == 'suspended') then
            coroutine.resume(co,"STOP") -- I Ask it to die
        end
    end
end
lib.CoroutineResume=lib.CoroutineStart
function lib:Popup(msg,timeout)
msg=msg or "Something strange happened"
       StaticPopupDialogs["AMO_POPUP"] = {
            text = TEXT(msg),
            button1 = TEXT("OK"),
            showAlert = 1,
            timeout = timeout or 60,
            exclusive = 1,
            whileDead = 1,
            interruptCinematic = 1
        };
        StaticPopup_Show("AMO_POPUP");
end
function lib:Cmd(...)
    self:Print(...)
    local cmd,subcmd,param,fullarg=self:Parse(strjoin('',...))
    cmd=string.capitalize(cmd or "help")
    local funcname=string.capitalize(cmd)
    local func=self["Cmd" .. funcname]
    if (not func) then
        func=self["iCmd" .. funcname]
    end
    if (type(func)=="function") then
        func(self,subcmd,param,fullarg)
    else
        self:ShowHelp()
    end
end
function lib:CmdConfig()
    AceLibrary("Waterfall-1.0"):Open(self.ID)
end
lib.CmdGui=lib.CmdConfig -- alias
function lib:Cmdreset()
    self:ResetDB()
    self.db.profile.settings={}
    for k,t in kpairs(self.Config) do
        self:Add(t)
    end
end
function lib:CmdComdebug()
    self.flagcomdebug=not self.flagcomdebug
    self:PrintBoolean("Comdebug",self.flagcomdebug)
end
function lib:CmdHelp()
    if (not InterfaceOptions_AddCategory) then 
        self:ShowHelp(self.helppage)
    else
        InterfaceOptionsFrame_OpenToFrame(self.fullname or '')
    end 
end
function lib:Cmdstatus()
    self:Print("Variables status for %s",self.fullname)
    local db=self.db.profile.settings
    for i,v in kpairs(db) do
        self:Print("%s: %s (%s)",i,v.value,v.type)
    end
end

function lib:Cmdversioncheck()
    AMO:_AskVersion("GUILD")
    self:Print("%s\n%s: version %s",self.fullname,self:Me(),self.version)
    if (AMOCOMMON.Users[self.fullname]) then
        local vv=str2num(self.version)
        for i,v in kpairs(AMOCOMMON.Users[self.fullname]) do
            local vx=str2num(v)
            local color=AMO_YELLOW
            if (vx > vv) then
                color = AMO_GREEN
            elseif (vx < vv) then
                color=AMO_RED
            end
            self:Print("%s: version %s%s|r",i,color,v)
        end
    end
end


function lib:iCmdWatcher()
    local f=self:Create("Frame","AMO_FrameWatcher",UIParent)
    f:SetHeight(20)
    f:SetWidth(250)
    f:SetPoint("TOP")
    local l=self:FrameAddTitle(f,"Frame","",10,-30)
    f.label=l
    self:SetBackdrop(f,"tooltip")
    f:SetScript("OnUpdate",
        function(elapsed)
            local frame=GetMouseFocus()
            if (frame ~= this.oldframe and frame) then
                this.oldframe=frame
                this.label:SetText(frame:GetName())
            end
        end)
end
function lib:ScanBuff(unit)
    return lib:ScanBuffDebuff(unit)
end
function lib:ScanDebuff(unit)
    return lib:ScanBuffDebuff(unit,true)
end
function lib:ScanBuffDebuff(unit,debuff)
    local f=UnitBuff
    if (debuff) then
        f=UnitDebuff
    end
    if (not unit) then
        unit="player"
    end
    local buffs={}
    for i=1,99 do
        local buffName,buffRank,buffTexture,buffApplications,debuffType=f(unit,i,true)
        if (buffName) then
            local tx=string.gsub(buffTexture,"Interface\\Icons\\","")
            buffs[tx]={name=buffName,rank=buffRank,texture=buffTexture,applications=buffApplications,type=debuffType}
            -- type= Magic Disease Poison Curse or nothing
        else
            break
        end
    end
    return buffs
end

function lib:CheckSelf()
    self:Print("Called from ",self.ID)
end
-- Help Syste,

function lib:LoadHelp(testo)
    if (testo) then
        self:Print(self.ID .. "Old use of loadhelp")
        return
    end
    local h=AMOCOMMON.help
    h.pagenum=(h.pagenum or 0) + 1
    h[h.pagenum]={}
    h[h.pagenum].title=self.fullname .. " " .. self.version
    h[h.pagenum].ID=self.ID
    self:HF_Paragraph("Alar's site")
    self:HF_Pre("http://wow.aspide.it")
    h[h.pagenum].pages=self.help
    self.helppage=h.pagenum
    self:BlizMenu()
end
function lib:BlizMenu()
if (not InterfaceOptions_AddCategory) then return end -- we need 2.4
-- Creazione pannello di help
    local fh=self:CreateScrollPanel(self.ID .. "_hdescription")
    self:Print("Container:",InterfaceOptionsFramePanelContainer:GetWidth())
    fh.name=self.fullname
    fh:SetTextColor(1,1,1)
    fh:SetText(self.help.description)
    fh:SetJustifyH("LEFT")
    fh:SetJustifyV("TOP")
    fh:SetVerticalScroll(0)
    fh:Show()
-- Livello due del tree
    local f2=CreateFrame("frame",self.ID .. "BLIZCONFIGCONFIG")
    f2.name="Configure"
    f2.parent=self.fullname
    f2:Show()
    local b2=self:FrameAddButton(f2,"OpenConfig","Configure",30,-30)
    b2:SetScript("OnClick",function() self:CmdConfig() end)
    InterfaceOptions_AddCategory(fh)
    for titolo,testo in pairs(self.help) do
        if (titolo ~= "description") then
            local fh=self:CreateScrollPanel(self.ID .. "_h" .. titolo)
            fh.parent=self.fullname
            fh.name=L[titolo]
            fh:SetTextColor(1,1,1)
            fh:SetText(testo)
            fh:SetJustifyH("LEFT")
            fh:SetJustifyV("TOP")
            fh:SetVerticalScroll(0)
            fh:Show()
            InterfaceOptions_AddCategory(fh)
        end
    end
    InterfaceOptions_AddCategory(f2)
    return true
end
local maxpanlen=70
function lib:RelNotes(major,minor,revision,t)
    local fmt=AMO_YELLOW .. "Release note for %d.%d.%d:" .. AMO_NORMAL .."\n%s"
    local lines={}
    local spacer=""
    lines={strsplit("\n",t)}
    for i,tt in ipairs(lines) do
        local prefix,text=tt:match("^(Fixed):(.*)")
        if (prefix == "Fixed") then
            prefix=AMO_RED .. "Fixed: "..AMO_ENDCOLOR
            spacer=           "       "
        else
            prefix,text=tt:match("^(Feature):(.*)")
            if (prefix == "Feature") then
                prefix=AMO_GREEN .. "Feature: "..AMO_ENDCOLOR
                spacer=             "         "
            else
                text=tt
                prefix=spacer
            end
        end
        local tta=""
        tt=text
        while (tt:len() > maxpanlen)  do
            local p=tt:find("[%s%p]",maxpanlen -10) or maxpanlen
            tta=tta..prefix..tt:sub(1,p) .. "\n"
            prefix=spacer
            tt=tt:sub(p+1)
        end
        tta=tta..prefix..tt
        tta=tta:gsub("Upgrade:",AMO_AZURE .."Upgrade:" ..AMO_ENDCOLOR)
        lines[i]=tta:gsub("Example:",AMO_ORANGE .."Example:" ..AMO_ENDCOLOR)
    end
    self:_push("notes",fmt:format(major,minor,revision,strjoin("\n",unpack(lines))))
end

function lib:_push(section,text)
    section=section or self.lastsection or 'description'
    self.lastsection=section
    self.help[section]=self.help[section] .. '\n' .. text
end

function lib:HF_Title(text,section)
    self:_push(section,AMO_YELLOW .. text or '' .. "\n")
end
function lib:HF_Toggle(flag,default,desc,tooltip)
    if (not flag) then return end
    if (flag:find("^_.")) then return end -- Internal
    self:_push("switches",format(
    "%s/%s toggle %s|r: %s",AMO_ORANGE,strlower(self.ID),strlower(flag),desc or flag))
end
    
function lib:HF_Cmd(cmd,parameters,text,tooltip)
    if (type(cmd) ~= "string") then
        return
    end
    if (type(parameters)=="string") then
        parameters=text
        text=tooltip
    end
    text=text or cmd
    tooltip=tooltip or text
    self.Cmds=self.Cmds or {}
    if (self.cmds) then return end
    self.Cmds[cmd]=text
    if (string.sub(cmd,1,1) ~= "/" ) then
        cmd="/" .. strlower(self.ID).. " " .. cmd
    end
    self:HF_Command(cmd,text,'commands')
end
function lib:HF_Command(cmd,text,section)
    if (not cmd) then return end
    self:_push(section,format("%s%s|r : %s",AMO_ORANGE,cmd,text or ''))
end
function lib:HF_Paragraph(text,section)
    self:_push(section,format("\n%s%s|r",AMO_GREEN,text))
end
function lib:HF_Pre(testo,section)
    self:_push(section,testo)
end
function lib:HF_Commands()
    modulo=strlower(self.ID)
    self:HF_Paragraph("General commands","commands")
    self:HF_Command("/"..modulo.." help","Opens this help page")
    self:HF_Command("/"..modulo.." gui","Opens GUI (if available)")
    self:HF_Command("/"..modulo.." status","Shows current settings")
end
function lib:HF_Enabled(n,v,d)
    self.helptext=self.helptext..lib:Format("Module %s%s|r %s (%s): "..AMO_GREEN.."Enabled|r\n",AMO_ORANGE,n,v,d)
end
function lib:HF_Disabled(modulo)
    self.helptext=self.helptext..lib:Format("Module $s%s|r %s (%s): "..AMO_RED.."Disabled|r\n",AMO_ORANGE,n,v,d)
end
function lib:HF_Color(color,text,section)
    self:_push(section,format("%s%s|r",getglobal("AMO_" .. strupper(color),text)))
end
-- Events
function lib:RemoveEvent(eventi)
    if (not eventi) then
        return
    end
    if (type(eventi)=="string") then
        eventi={eventi}
    end
    for evento,i in pairs(eventi) do
        self.Events[evento]=false
    end
end
function lib:RemoveBucketEvent(eventi)
    if (not eventi) then
        return
    end
    if (type(eventi)=="string") then
        eventi={eventi}
    end
    for i,evento in ipairs(eventi) do
        self.BucketEvents[evento]=false
    end
end
function lib:AddEvent(eventi,delayed)
    if (not eventi) then
        return
    end
    if (type(eventi)=="string") then
        eventi={eventi}
    end
    delayed = delayed or 0
    for evento,i in pairs(eventi) do
        self.Events[evento]=delayed
    end
end

function lib:AddBucketEvent(eventi,delayed)
    if (not eventi) then
        return
    end
    if (type(eventi)=="string") then
        eventi={eventi}
    end
    delayed = delayed or 0
    for i,evento in ipairs(eventi) do
        self.BucketEvents[evento]=delayed
    end
end

  -----------------------------------------------------------
  -- function lib:GetTime()
  --
  -- Return game time as (h,m,s) where s has 3 decimals of
  -- precision (though it's only likely to be precise down
  -- to ~20th of seconds since we're dependent on frame
  -- refreshrate).
  --
  -- During the first minute of play, the seconds will
  -- consistenly be "00", since we haven't observed any
  -- minute changes yet.
  --
  --

function lib:TimeGet()
  	if(AMOCOMMON.LastMinuteTimer == nil) then
  		local h,m = GetGameTime();
  		return tonumber(h),tonumber(m),0;
  	end
  	local s = GetTime() - AMOCOMMON.LastMinuteTimer;
  	if(s>59.999) then
  		s=59.999;
  	end
  	return tonumber(AMOCOMMON.LastGameHour), tonumber(AMOCOMMON.LastGameMinute), tonumber(s);
  end
  -----------------------------------------------------------
  -- function AMO_GameTime:TimeStamp()
  --
  -- Return game time as (h,m,s) where s has 3 decimals of
  -- precision (though it's only likely to be precise down
  -- to ~20th of seconds since we're dependent on frame
  -- refreshrate).
  --
  -- During the first minute of play, the seconds will
  -- consistenly be "00", since we haven't observed any
  -- minute changes yet.
  --
  --

function lib:TimeTimeStamp()
    local h,m,s=self:Get()
    return self:Format("%02d:%02d:%02d:%02d",AMOCOMMON.Day,h,m,s)
end


  -----------------------------------------------------------
  -- function AMO_GameTime:OnUpdate()
  --
  -- Called by: Private frame <OnUpdate> handler
  --
  -- Construct high precision server time by polling for
  -- server minute changes and remembering GetTime() when it
  -- last did
  --

local function TimeOnUpdate()
  	local h,m = GetGameTime();
  	if(AMOCOMMON.LastGameMinute == nil) then
  		AMOCOMMON.LastGameHour = h;
  		AMOCOMMON.LastGameMinute = m;
  		return;
  	end
  	if(AMOCOMMON.LastGameMinute == m) then
  		return;
  	end
  	if (AMOCOMMON.LastGameHour>h) then
        AMOCOMMON.Day=AMOCOMMON.Day+1
    end
  	AMOCOMMON.LastGameHour = h;
  	AMOCOMMON.LastGameMinute = m;
  	AMOCOMMON.LastMinuteTimer = GetTime();
end

  -----------------------------------------------------------
  -- function AMO_GameTime:Initialize()
  --
  -- Create frame to pulse OnUpdate() for us
  --

function lib:TimeInitialize()
    if (AMOCOMMON.Frame) then
        return
    end
    AMOCOMMON.Day=0
  	AMOCOMMON.Frame = CreateFrame("Frame");
  	AMOCOMMON.LastMinuteTimer = GetTime();
  	AMOCOMMON.Frame:SetScript("OnUpdate", function() TimeOnUpdate(); end);
end

function lib:ZapSpellCache()
    AMOCOMMON.spellcache=nil
end

function lib:LibVersion()
    self:Print("%s Rev. %s",MAJOR_VERSION,MINOR_VERSION)
end

function lib:PrettyVersion(versione)
    if (type(versione) == "string") then
        local a,b,c,d=versione:match("(%d*)%D?(%d*)%D?(%d*)%D*(%d*)%D*")
        a=tonumber(a) or 0
        b=tonumber(b) or 0
        c=tonumber(c) or 0
        d=tonumber(d) or 0
        return string.format("%d.%d.%d Rev: %d",a,b,c,d)
    else
        return "Beta"
    end
end
function lib:UpdateVersion()
    if (type(self.db.char) == "table") then
        self.db.char.version=str2num(self.version)
    end
end
function lib:IsNewVersion()
    return str2num(self.version) > str2num(self.db.char.version)
end
function lib:VersionIsAtLeast(compareto)
    return str2num(compareto) >= str2num(self.version)
end
-- Config Section
    -- Amo Config System
function lib:Vars()
    return next,self.db.profile.settings,nil
end
function lib:DumpVars(key)
    key=key or "<all>"
    key=strupper(key)
    local db=self.db.profile.settings
    for k,v in pairs(db) do
        k=strupper(k)
        if (key == "<ALL>" or key==k) then
            if (v.type == "boolean") then
                self:PrintBoolean(k,v.value)
            else
                self:Printf("%s is %s%s",k,AMO_WHITE,v.value)
            end
            if (key ==k) then
                return
            end
        end
    end
end
function lib:Add(t)
    local k=t.flagname or self:Format("%s_%d",self.ID,table.maxn(self.List))
    self.Config[k]=t
    if (not t.label) then
        t.label=self.L[strupper(k)]
    end
    if (not t.tooltip) then
        t.tooltip=self.L[strupper(k) .. "DESC"]
        if (t.tooltip == self.L[strupper(k)] .. "DESC") then
            t.tooltip=t.label
        end
    end
    table.insert(self.List,k)
    if (t.type == "C") then
        self:AddVar(t)
    elseif (t.type == "E") then
        self:AddVar(t)
    elseif (t.type == "B" and t.flagname) then
        self:AddVar(t)
    elseif (t.type == "S") then
        self:AddVar(t)
    end
end
-- compatibility with
--AddToggle("RETRACK",true,"Track cast reminder","Reminds you to recast your current tracking")
function lib:Empty(t)
    local value
    if (t=="boolean") then
        value=false
    elseif (t == "string") then
        value = ""
    elseif (t == "number") then
        value=0
    elseif (t == "table") then
        value={}
    elseif (t == "function") then
        value=function() end
    else
        value=nil
    end
    return value
end

function lib:AddCheckbox(flagname,defaultvalue,label,tooltip)
self:Add{type="C",label=label,tooltip=tooltip,flagname=flagname,defaultvalue=defaultvalue}
end
function lib:AddToggle(flagname,defaultvalue,label,tooltip)
self:HF_Toggle(flagname,defaultvalue,label,tooltip)
self:Add{type="C",label=label,tooltip=tooltip,flagname=flagname,defaultvalue=defaultvalue}
end
function lib:AddString(flagname,defaultvalue,label,tooltip)
self:Add{type="E",label=label,tooltip=tooltip,flagname=flagname,defaultvalue=defaultvalue}
end

function lib:AddEdit(flagname,defaultvalue,label,tooltip)
self:Add{type="E",label=label,tooltip=tooltip,flagname=flagname,defaultvalue=defaultvalue}
end
function lib:AddLabel(label,tooltip,colortable)
    colortable=colortable or AMO_Orange
    self:Add{type="L",label=label,tooltip=tooltip,colortable=colortable}
end
function lib:AddSubLabel(label,tooltip,colortable)
    colortable=colortable or AMO_Orange
    self:Add{type="SL",label=label,tooltip=tooltip,colortable=colortable}
end
function lib:AddExec(flagname,method,label,tooltip)
    self:Add{type="X",flagname=flagname,func=method,label=label,tooltip=tooltip}
end
function lib:AddButton(flagname,defaultvalue,func,label,tooltip,position)
    position=position or "flow"
    position=strupper(position)
    centered=position=="CENTER"
    flow=position=="FLOW"
    self:Add{type="B",flagname=flagname,defaultvalue=defaultvalue,label=label,func=func,tooltip=tooltip,flow=flow,centered=centered}
end
function lib:AddSlider(flagname,defaultvalue,min,max,label,tooltip,position)
    self:Add{type="S",flagname=flagname,defaultvalue=defaultvalue,label=label,tooltip=tooltip,min=min,max=max}
end
function lib:AddTitle(label,tooltip)
self:Add{type="L",label=label,centered=true,tooltip=tooltip}
end
function lib:GetToggle(flagname,newvalue)
    if (not self.db) then
        self:Print("Asked for " .. flagname .. " before db were loaded")
        return false
    end
    local db=self.db.profile.settings
    if (not db) then
        self:Print(GetTime(),flagname)
        return false
    end
    local v=db[flagname];
    if (type(newvalue) == "boolean") then
        self:SetVar(flagname,newvalue)
    end
    if (not v) then
        return false
    elseif (v.value==self:Empty(v.type)) then
        return false
    else
        return true
    end
end
function lib:ReApply()
    local db=self.db.profile.settings
    if (type(self.ApplyAll)=="function") then
        self:ApplyAll()
    else
        for i,v in self:Vars() do
            self:_Apply(i,v.value,true)
        end
    end
end
function lib:Apply(flagname,value)

end
function lib:_Apply(cmd,value,silent)
    cmd=strupper(cmd)
    local func
    if (type(self["Apply" .. cmd]) == "function") then
        func=function()
            self:Debug("Apply" .. cmd,value)
            self["Apply" .. cmd](self,value)
            end
    else
        func=function()
            self:Debug("Apply",cmd,value)
            self:Apply(cmd,value)
            end
    end
    if (InCombatLockdown()) then
        self:Print("Scheduling changes to %s for when you leave combat",cmd)
        self:ScheduleLeaveCombatAction(func)
    else
        func()
    end
    if (not silent) then
        if (type(value)=="boolean") then
            self:PrintBoolean(cmd,value)
        else
            self:Print("%s is %s",cmd,value)
        end
    end
end
function lib:SetVar (flagname,value)
    local flag=self.db.profile.settings[flagname]
    if (flag) then
        as=flag.type
        if (as =="string") then
            if (value) then
                flag.value=tostring(value)
            else
                flag.value=""
            end
        elseif (as =="number") then
            flag.value=(tonumber(value) or 0)
        elseif (as == "boolean") then
            if (value) then
                flag.value=true
            else
                flag.value=false
            end
        else
            flag.value=value
        end
        self.db.profile.settings[flagname]=flag
        return self.db.profile.settings[flagname].value
    else
        return nil
    end
end
function lib:ApplyVar(flagname,value)
    local old=self:GetVar(flagname)
    if (old ~= value) then
        -- SetVar can change a variable type, so the subsequent test
        -- is not useless ;-P
        local new=self:SetVar(flagname,value)
        if (new  ~= old) then
            self:_Apply(flagname,new)
        end
    end
end
function lib:CreateString(flagname,value)
    self:AddVar{flagname=flagname,defaultvalue=value,type="E"}
end
function lib:CreateNumber(flagname,value)
    value=tonumber(value) or 0
    self:AddVar{flagname=flagname,defaultvalue=value,type="N"}
end
function lib:CreateBoolean(flagname,value)
    self:AddVar{flagname=flagname,defaultvalue=value,type="B"}
end
function lib:AddValidate(flag,validate)
    if (self.Config[flag]) then
        self.Config[flag].validate=validate
    end
end
function lib:AddVar (t)
    self:argCheck(t,1,"table")
    if (t.debug) then self:PrintLiteral("Adding var",t.flagname,t) end
    local flag=self.db.profile.settings[t.flagname]
    if (t.debug) then self:PrintLiteral("Flag red",t.flagname) end
    if (t.type=="S" and flag) then
        local test=tonumber(flag.value) or 0
        if (test < t.min or test > t.max) then
            flag=nil -- forcing initialization
        end
    end
    if (t.debug) then self:Print("Adding var 1") end
    if (not flag) then
        flag={}
        if (t.type=="E") then --Editbox
            flag.value=t.defaultvalue or ''
            flag.type="string"
        elseif (t.type == "C" or t.type=="B") then -- Checkbox or Button
            flag.value=t.defaultvalue
            flag.type="boolean"
        elseif (t.type == "N" or t.type== "S") then -- Slider or number
            flag.value=(tonumber(t.defaultvalue) or 0)
            flag.type="number"
        end
        if (flag.type) then
            self.db.profile.settings[t.flagname]={}
            self.db.profile.settings[t.flagname].type=flag.type
            self.db.profile.settings[t.flagname].value=flag.value
        end
    end
    if (t.debug) then self:Print("Adding var done") end

end
function lib:IsVar(flagname)
    local db=self.db.profile.settings
    return db[flagname]
end
function lib:GetNumber(flagname)
    return self:GetVar(flagname,"number") or 0
end
function lib:GetString(flagname)
    return self:GetVar(flagname,"string") or ""
end
function lib:GetRawVar(flagname)
    return self:GetVar(flagname,"raw") or nil
end

function lib:GetVar(flagname,as)
    local db=self.db.profile.settings
    if (db[flagname]) then
        as=as or db[flagname].type
        if (as=="raw") then
            return db[flagname]
        elseif (as =="string") then
            if (not db[flagname].value) then
                return ""
            else
                return tostring(db[flagname].value)
            end
        elseif (as =="number") then
            return tonumber(db[flagname].value) or 0
        else
            if (db[flagname].value) then
                return true
            else
                return false
            end
        end
    else
        return self:Empty(as)
    end
end
function lib:ToggleApplyVar(flagname)
    self:ToggleVar(flagname,true)
end
function lib:ToggleVar(flagname,apply)
    local db=self.db.profile.settings
    if (db[flagname]) then
        if (db[flagname].type=="boolean") then
            db[flagname].value= not db[flagname].value
            if (apply) then
                self:_Apply(flagname,db[flagname].value)
            end
        end
    end
end

--[[
Struttura tabella configurazione=
Array di elementi di configurazione
Ogni elemento ha questa struttura
{
type="C" | "L" | "E" | | "S" | "B",
label="Etichetta"
tooltip="Testo tooltip"
flagname="Nomevariabile"
centered=true|false
}
--]]
function lib:DumpDb()
    for k,v in pairs(self.db.profile.settings) do
        self:PrintLiteral(k,v)
    end
end

function lib:AddCmdA(cmd,t,desc,usage)
    if (type(t) == "table") then
        t.standalone=true
    else
        t={set=t,desc=desc,usage=usage,standalone=true}
    end
    self:AddCmd(cmd,t)
end
function lib:AddCmd(cmd,t,desc,usage,standalone)
    if (type(t) == "string") then
        t={set=t,desc=desc,usage=usage,standalone=standalone}
    end
    t.type=t.type or "text"
    t.name=t.name or cmd
    t.desc=t.desc or "Self explicatory"
    t.get=t.get or false
    t.input=t.input or false
    t.usage=t.usage or "message"
    if (t.standalone) then
        self:RegisterChatCommand({"/" .. cmd},t)
        self:HF_Command("/" .. cmd .. " " .. t.usage ,t.desc)
    else
        self.Commands.args[cmd]=t
        self:HF_Command("/" .. strlower(self.ID) .. " " .. cmd .. " " .. t.usage ,t.desc)
    end
end
-- Start
function lib:Evt(...) --placeholder
   local event = AceLibrary("AceEvent-2.0").currentEvent
end
function lib:OnEvent(event,...)
    local func=self["Evt" .. event]
    if (type(func)=="function") then
        local rc,message=pcall(func,self,...)
        if (not rc) then
            self:Error("Evt%s %s",event,message)
        end
    else
        if (type(self.Evt)=="function") then
            local rc,message=pcall(self.Evt,self,event,...)
            if (not rc) then
                self:Error("Evt %s", message)
            end
        end
    end
end
function lib:_Evt()
    pcall (self.OnEvent,self,AceLibrary("AceEvent-2.0").currentEvent,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9)
end

function lib:Banner()
    self:Print(AMO_GREEN .. "%s %s ready. Use /%s help for info)",self.fullname,self.version,strlower(self.ID))
end
function lib:DependsOn()
    for lib in pairs(self.Libs) do
        self:PrintBoolean("Using " .. lib,AceLibrary:HasInstance(lib) or IsAddOnLoaded(lib))
    end
end
function lib:SecureShow(f,show)
    local hide=not show
    if (type(f)=="string") then
        f=getglobal(f)
    end
    if (hide) then
        self:ScheduleLeaveCombatAction(function() f:Hide() end)
    else
        self:ScheduleLeaveCombatAction(function() f:Show() end)
    end
end
function lib:InjectOptions(totable,fromtable,onlyupper)
    self:argCheck(totable, 1, "table")
    self:argCheck(fromtable, 2, "table")
    for k,v in pairs(fromtable.args) do
        if (onlyupper and k:find("^%u")) then
            totable.args[k]=v
            totable.args[k].handler=self
        end
    end
end
function lib:InjectCommands(totable)
    self:argCheck(totable, 1, "table")
    local fromtable=self.Commands
    self:InjectOptions(totable,fromtable,true)
end
function lib:InjectConfig(totable)
    self:argCheck(totable, 1, "table")
    local fromtable=self.Opts
    self:InjectOptions(totable,fromtable,true)
end
function lib:AddonManage(addon,op)
    op=op or "info"
    if (op == "disable") then
        AMOCOMMON.Addons[addon]=2
        DisableAddOn(addon)
    elseif (op == "load") then
        LoadAddon(addon)
    elseif (op == "enable") then
        AMOCOMMON.Addons[addon]=2
        EnableAddOn(addon)
    end
    return GetAddOnInfo(addon)
end
function lib:LoadTexture(v)
    local path="Interface\\Addons\\%s\\Media\\%s"
    AMOCOMMON.texture:SetTexture(nil)
    for _,i in pairs{"!AlarLib","AlarLib",self.fullname} do
        AMOCOMMON.texture:SetTexture(path:format(i,v))
        local t=AMOCOMMON.texture:GetTexture()
        if (t) then
            return t
        end
    end
end
function lib:FuCreate()
    local module=self
    if (not FuBar or not AceLibrary:HasInstance("FuBarPlugin-2.0") or not AceLibrary:HasInstance("Tablet-2.0")) then
        self.fu=false
        return
    else
        self:Print(AMO_ORANGE .. "FuBar support enabled")

    end
    local tablet = AceLibrary("Tablet-2.0")
    local fu=AlarModsFu
    if (not fu) then
        AlarModsFu=AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")
        fu=AlarModsFu
        fu.hasIcon = module:LoadTexture("icon")
        fu.hasNoColor= true
        fu.fullname="Alar"
        fu.title="FuBar - Alar AddOns"
        fu.name="Alar Modules"
        fu.notes="General Fubar interface"
        fu.version=MAJOR_VERSION .. "Rev." .. MINOR_VERSION
        fu.clickableTooltip = true
        fu.OnMenuRequest={type="group",
                            name='Alar',
                            desc='Alar modules Fubar Interface',
                            args={}
                        }
        function fu:OnTextUpdate()
            self:SetText(self.fullname)
        end
        function fu:OnInitialize()
            self.db=module:AcquireDBNamespace("fubar")
        end
        function fu:OnTooltipUpdate()
            tablet:SetHint("Right-click for Options")
    	    local cat = tablet:AddCategory(
            'id','AddonLoaded',
            'text','Modules',
            'columns',2,
            'child_textR',AMO_Yellow.r,
            'child_textG',AMO_Yellow.g,
            'child_textB',AMO_Yellow.b,
            'child_text2R',AMO_White.r,
            'child_text2G',AMO_White.g,
            'child_text2B',AMO_White.b
            )
    	   local line={}
    	   for k,e in pairs(AMOCOMMON.Addons) do
                if (e>0) then -- only enabled
                    local star=''
                    if (e==2) then
                        star = '*'
                    end
                    local status
                    local name,title,notes,enabled,loadable,reason,security=GetAddOnInfo(k)
                    line={text=name .. ' ' .. module:PrettyVersion(GetAddOnMetadata(name,"version")),
                        onEnterFunc=module.TTOpen,onEnterArg1=module,
                        onLeaveFunc=module.TTClose,onLeaveArg1=module,
                        func=module.AddonManage,arg1=module,arg2=name}
                    
                    if (IsAddOnLoaded(k)) then
                        line.text2='Loaded' .. star
                        line.text2R=AMO_Green.r
                        line.text2G=AMO_Green.g
                        line.text2B=AMO_Green.b
                        line.onEnterArg2="Click to disable on next login"
                        line.arg3="disable"
                        
                    elseif (IsAddOnLoadOnDemand(k)) then
                        line.text2="Loadable" .. star
                        line.text2R=AMO_Orange.r
                        line.text2G=AMO_Orange.g
                        line.text2B=AMO_Orange.b
                        line.onEnterArg2="Click to load"
                        line.arg3="load"
                    elseif (reason == "MISSING") then
                        line.text2="Not installed"
                        line.text2R=AMO_Red.r
                        line.text2G=AMO_Red.g
                        line.text2B=AMO_Red.b
                        line.onEnterArg2="Visit http://wow.aspide.it to download"
                        line.arg3="nop"
                    else
                        line.text2="Disabled" .. star
                        line.text2R=AMO_Red.r
                        line.text2G=AMO_Red.g
                        line.text2B=AMO_Red.b
                        line.onEnterArg2="Click to enable on next login"
                        line.arg3="enable"
                    end
                    cat:AddLine(line)
                end
            end
    	    cat = tablet:AddCategory(
            'id','AlarCommands',
            'text','Commands',
            'columns',1,
            'child_textR',AMO_Yellow.r,
            'child_textG',AMO_Yellow.g,
            'child_textB',AMO_Yellow.b
            )
            line.text2=""
            line.text="Open help system"
            line.onEnterArg2="Invoke Alarmods' help system"
            line.func=module.ShowHelp
            line.arg1=module
            line.arg2=1
            cat:AddLine(line)
            line.textR=AMO_Orange.r
            line.textG=AMO_Orange.g
            line.textB=AMO_Orange.b
            line.text="Reload User Interface"
            line.func=ReloadUI
            line.onEnterArg2="Click to reload interface"
            cat:AddLine(line)
            line.textR=AMO_Green.r
            line.textG=AMO_Green.g
            line.textB=AMO_Green.b
            line.text="Logout"
            line.func=Logout
            line.onEnterArg2="Click to logout"
            cat:AddLine(line)
            line.text="Istantly quit"
            line.textR=AMO_Red.r
            line.textG=AMO_Red.g
            line.textB=AMO_Red.b
            line.func=ForceQuit
            line.onEnterArg2="Click to quit with no timer"
            cat:AddLine(line)
            line.textR=nil
            line.textG=nil
            line.textB=nil
    	    cat = tablet:AddCategory(
            'id','AlarDaily',
            'text','DailyQuests',
            'columns',2,
            'child_textR',AMO_Yellow.r,
            'child_textG',AMO_Yellow.g,
            'child_textB',AMO_Yellow.b,
            'child_text2R',AMO_Green.r,
            'child_text2G',AMO_Green.g,
            'child_text2B',AMO_Green.b
            )
            line.textR=AMO_Yellow.r
            line.textG=AMO_Yellow.g
            line.textB=AMO_Yel
            line.text,line.text2=strsplit(':',QUEST_LOG_DAILY_COUNT_TEMPLATE:format(GetDailyQuestsCompleted(), GetMaxDailyQuests()))
            cat:AddLine(line)
            for questID=1,GetNumQuestLogEntries() do
                questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questID)
                if (isDaily) then
                    line.text=questTitle
                    line.text2=DAILY_QUEST_TAG_TEMPLATE:format(questTag or '')
                    line.onEnterArg2="Invoke Alarmods' help system"
                    line.func=module.ShowQuest
                    line.arg1=module
                    line.arg2=questID
                    local r,g,b=AMO_color(AMO_Red)
                    if (isComplete) then
                        r,g,b=AMO_color(AMO_Green)
                    end
                    line.text2R=r
                    line.text2G=g
                    line.text2B=b
                    line.onEnterArg2=nil
                    cat:AddLine(line)
                end
            end
        end
        fu.OnMenuRequest={
            type='group',
            args={},
            handler=fu,
        }
    end
    fu.OnMenuRequest.args[self.ID]={
        type="group",
        desc=self.description,
        name=self.fullname,
        handler=self,
        args={}
        }
    return fu
end
function lib:FuLoad()
    local fu=AlarModsFu
    if (fu) then
        self:InjectConfig(fu.OnMenuRequest.args[self.ID])
        self:InjectCommands(fu.OnMenuRequest.args[self.ID])
    end
end
function lib:ShowQuest(id)
    HideUIPanel(QuestLogFrame)
    SelectQuestLogEntry(id)
    ShowUIPanel(QuestLogFrame)


end
function lib:Commands2OptsNew()
    local c=self.Commands
    c.type="text"
    c.name=self.ID
    c.args=nil
    c.validate={}
    c.validateDesc={}
    local L=self.L
    for method in pairs(self) do
        local start,_,prefix,command=method:find("^(Cm%w)(.*)")
        local order=0
        if (start and type(self[method])=="function" and command~="") then
            local desc=self[command .. "Desc"] or  self.Cmds[command] or L[command] or 'No description'
            tinsert(c.validate,command)
            c.validateDesc[command]=desc
        end
    end
end
function lib:SetupCommand(order,args,method,command)
-- Dont step on things done by Addon private initialization
    if (args[command]) then return end
    local L=self.L
    if (command:find("^%l.*")) then
        step=-1000
    else
        step=0
    end
    args[command]={
        type = self[method .. 'Type'] or 'execute',
        pass = self[method .. 'Pass'],
        name = command,
        input= self[method .. "Input"],
        desc = L[self[method .. "Desc"]] or  self.Cmds[command] or L[command] or 'No description',
        set = method,
        func = method,
        get = false,
        order=order+step,
        usage=L[self[method .. 'Usage'] or ''],
        validate=self[method .. 'Validate'],
        confirm=self[method .. 'Confirm'],
        wfHidden=true,
        args=self[method .. 'Args'],
        pass=self[method .. 'Pass'],
    }
    --self:Trace(command,args[command].desc,args[command].usage)
end
function lib:Commands2Opts()
    local args=self.Commands.args
    local order=10
    local module=self
    args.a_info={
        type="header",
        name="Please use /" .. strlower(self.ID) .. " gui",
        cmdHidden=true,
    }
    args.b_exec={
        type="execute",
        name="Open Gui",
        desc="This addons uses his own GUI",
        func=function()
            self:CmdGui()
            if (this) then
                while (this) do
                    local p=this:GetParent()
                    if (not p or p == UIParent) then
                        this:Hide()
                        this=nil
                    else
                        this=p
                    end
                end
            end
        end,
        cmdHidden=true,
    }
    for method in pairs(self) do
        local start,_,prefix,command=method:find("^(Cm%w)(.*)")
        if (start and type(self[method])=="function" and command~="" and (prefix == "Cmd" or self:Alar())) then
            order=order+1
            self:SetupCommand(order,args,method,command)
        end
    end
    args.Toggle={
        type = "group",
        --pass = true,
        name = "Toggle",
        desc = "Toggle/Set flags",
        --set = "ApplyVar",
        --get = "GetRawVar",
        order=order+step,
        usage=" <var> <value>",
        --validate={},
        args={},
        guiHidden=true,
        
    }

end
function lib:Config2Opts()
    if (not self.Opts) then
        local wf=AceLibrary("Waterfall-1.0")
        local titolo= self.fullname .. " " .. self.version
        local Opts={ type="group",
                            desc=titolo,
                            args={},
                            handler=self,
                            name="Configuration Options"
                    }
        local root=Opts
        local gruppo=root.args
        local curlabel=nil
    	for order,id in ipairs(self.List) do
            v=self.Config[id]
            local tipo=v.type
            local color=v.colortable or AMO_Yellow
            local ID=string.capitalize(id)
            v.label=v.label or id or ''
            v.tooltip=v.tooltip or v.label or ''
            if (v.tooltip == "") then
                v.tooltip=v.label .. " related options"
            end
            if (tipo=="L") then -- Label
                gruppo=root.args
                curlabel=ID
                gruppo[ID] = {
                    order=order,
                    name=v.label,
                    type="group",
                    desc=v.tooltip,
                    args={},
                }
                gruppo=gruppo[ID].args
            elseif (tipo == "SL") then -- SubLabel
                gruppo=root.args
                gruppo=gruppo[curlabel].args
                gruppo[ID] = {
                    order=order,
                    name=v.label,
                    type="group",
                    desc=v.tooltip,
                    args={},
                }
                gruppo=gruppo[ID].args
            elseif (tipo == "E") then -- Editbox
                gruppo[ID] = {
                    type="text",
                    passValue=v.flagname,
                    get = "GetString",
                    set = "ApplyVar",
                    usage=v.usage or "<Enter string>",
                    desc="Press ENTER when done to save the value",
                }
                if (type(v.validate) == "table")then
                    gruppo[ID].validate=v.validate
                end
            elseif (tipo == "B" or tipo == "X") then -- Button
                gruppo[ID] = {
                    type="execute",
                    func=v.func,
                    passValue=v.flagname,
                }
            elseif (tipo == "C") then -- checkbox
                gruppo[ID] = {
                    type="toggle",
                    get="GetToggle",
                    passValue=v.flagname,
                    set="ApplyVar",
                }
            elseif (tipo == "S") then -- slider
                v.max=v.max or 100
                v.min=v.min or 0
                local int=v.max-v.min
                if (int <0) then
                    int=0.1
                else
                    int=int/100
                end
                gruppo[ID]= {
                    type="range",
                    min=v.min,
                    max=v.max,
                    step=int,
                    bigStep=int * 10,
                    get="GetNumber",
                    passValue=v.flagname,
                    set="ApplyVar",
                }
            end
            if (tipo ~= 'L' and tipo ~= 'SL') then
                gruppo[ID].order=order
                gruppo[ID].name=v.label
                gruppo[ID].desc=v.tooltip
                self.Commands.args.Toggle.args[ID]=gruppo[ID]
            end
        end
        self.Opts=Opts
        wf:Register(self.ID,"title",titolo,"aceOptions",self.Opts)
    end
end
lib.CmddepsDesc='Show dependencies for this AddOn'
function lib:Cmddeps()
    self:Print("Libraries marked KO could be available as embedded ones. If the addon is working, dont worry about that. Use this tool only if you experiences errors")
    self:DependsOn()
end
function lib:Cmdevents()
    for e in pairs(self.Events) do
        local colore=AMO_ORANGE
        local attivo,funzione=self:IsEventRegistered(e)
        if (attivo) then colore=AMO_GREEN end
        if (funzione == "Evt" .. e) then
            funzione="def"
        end
        self:Print("Event %s%s by %s%s",colore,e,AMO_ENDCOLOR,funzione)
    end
    for e in pairs(self.BucketEvents) do
        local colore=AMO_ORANGE
        local attivo,funzione=self:IsBucketEventRegistered(e)
        if (attivo) then colore=AMO_GREEN end
        self:Print("BucketEvent %s%s by %s%s",colore,e,AMO_ENDCOLOR,funzione)
    end
end

function lib:AutoEvents(debug)
    for method in pairs(self) do
        _=debug and self:Print(method)
        local s,f,event=string.find(method,"^Evt(.*)")
        if (s) then
            _= debug and self:Print("AutoAdding ",event)
            if (not self.BucketEvents[event]) then
                if (not self.Events[event]) then
                    self.Events[event]=0
                    _= debug and self:Print("Added ",event)
                end
            end
        end
    end
end

local function ae(self,event,td,bucket)
    local method="Evt" .. event
    if (not td) then
        if (self:IsEventRegistered(event)) then
            self:UnregisterEvent(event)
        end
        return
    else
        if (type(self[method]) ~= "function") then
            method="_Evt"
        end
    end
    if (bucket) then
        self:RegisterBucketEvent(event,td,method)
    else
        self:RegisterEvent(event,method,td)
    end
end

function lib:ApplyEvents()
    for event,throttle in pairs(self.Events) do
        ae(self,event,throttle,false)
    end
    for event,delay in pairs(self.BucketEvents) do
        ae(self,event,delay,true)
    end
end
function lib:UnApplyEvents()
    self:UnregisterAllBucketEvents()
    self:UnregisterAllEvents()
end
function lib:DbInit()
        self:RegisterDB(self.dbname,self.dbnamePC,'char')
        self:RegisterDefaults('profile',{
             settings={},
             forms={['*']={Scale=1.0,
                            Point={anchor="CENTER",
                                   relanchor="CENTER",
                                   x=0,
                                   y=0},
                        }
                    },
             cache={},
             data={}
             }
        )
        self:RegisterDefaults('account',{
            firstrun=true,
            lastversion=0,
            lastinterface=20200,
            data={},
            }
        )        
end
function lib:DbCheck()
    if (self.db.account) then 
        local dbversion=self.db.account.dbversion or 0
        if (dbversion < 1) then
            if (self.db and self.db.raw and self.db.raw.profiles) then
                for k,v in pairs(self.db.raw.profiles) do
                    if (v.forms) then
                        for formname,formdata in pairs(v.forms) do
                            if (formdata.Point and formdata.Point.parent) then
                                self.db.raw.profiles[k].forms[formname].Point.parent=nil
                            end
                        end
                    end
                end
            end
            self.db.account.dbversion=1
        end
    end
    local CurrentProfile=self:GetProfile()
    if (CurrentProfile == "Default") then
        self.db.profile.copied=1
        self:SetProfile("char")
        pcall(self.CopyProfileFrom,self,"Default")
    end
end
function lib:Locale(locale,table)
    self:argCheck(locale,1,"string")
    if (locale ~= GetLocale() and locale ~= DEFAULT_LOCALE) then
        return
    end
    self:argCheck(table,2,"table")
    for key,translation in pairs(table) do
        self:LocaleAdd(key,translation,locale)
    end
end

local localeAdd
function localeAdd(self,key,translation,locale,force)
    self:argCheck(key,1,"string")
    self:argCheck(translation,2,"string","boolean")
    self:argCheck(locale,3,"string")
    self:argCheck(force,4,"boolean")
    if (locale ~= GetLocale() and locale ~=DEFAULT_LOCALE) then
        return
    end
    if (type(translation) == "boolean") then
        translation=key
    end
    key=strupper(key) -- Normalize to upper key
    if (type(AMOCOMMON.L) ~="table") then
        AMOCOMMON.L={}
    end
    L=AMOCOMMON.L
    if (not rawget(AMOCOMMON.L,key) or locale ~= DEFAULT_LOCALE or force) then
        AMOCOMMON.L[key]=translation
    end
end
function lib:SendToOpenChat(message,replace)
    local c=ChatFrameEditBox
    if (c:IsShown()) then
        if (not replace) then
            message=c:GetText() .. message
        end
        c:SetText(message)
    end
end
function lib:LocaleReplace(key,translation)
    localeAdd(self,key,translation or true,GetLocale(),true)
end
function lib:LocaleAdd(key,translation,locale)
    localeAdd(self,key,translation or true,locale or GetLocale(),false)
end
function lib:LocaleLoad(locale)
    self:LocaleAdd("OK",AMO_GREEN .."Succesfull" .. AMO_ENDCOLOR)
    self:LocaleAdd("KO",AMO_RED .. "Failed" .. AMO_ENDCOLOR)
    self:LocaleAdd("WARN",AMO_ORANGE .. "Notice" .. AMO_ENDCOLOR)
    self:LocaleAdd("REM",AMO_ORANGE .. "Removed" .. AMO_ENDCOLOR)
    --[[
    self:LocaleAdd("OK",AMO_GREEN .."Riuscito" .. AMO_ENDCOLOR,"itIT")
    self:LocaleAdd("KO",AMO_RED .. "Fallito" .. AMO_ENDCOLOR,"itIT")
    self:LocaleAdd("WARN",AMO_ORANGE .. "Avviso" .. AMO_ENDCOLOR,"itIT")
    self:LocaleAdd("REM",AMO_RED .. "Rimosso" .. AMO_ENDCOLOR,"itIT")
    --]]
end

function lib:RescheduleEvent(event,...)
    if (self:IsEventScheduled(event)) then
        self:CancelEvent(event)
    end
    self:ScheduleEvent(event,...)
end
-- Addon start

function lib:new (o,...)
    local mixins=... or {}
    self:TimeInitialize()
    local class=AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0","AceDebug-2.0","AceHook-2.1","AceComm-2.0",unpack(mixins))
    class:SetDebugging(o.debug)
    class:LevelDebug(1,"New: %s (%s)",o.ID,o.fullname)
    if (not o) then
        class:Error("Nothing to initialize")
    end
    for k,v in pairs(o) do
        class[k]=v
    end
    if (not class.version and class.fullname) then
        class.version=GetAddOnMetadata(class.fullname,"Version"):gsub("[evision$:]","")
    else
        class.version="1.0"
    end
    class.revision=GetAddOnMetadata(class.fullname,"X-Revision"):gsub("[%a%s%$:]","")
    class.Dependencies=GetAddOnMetadata(class.fullname,"X-Embeds"):gsub(' ','')
    class.Libs={}
    for i,v in pairs({strsplit(',',class.Dependencies)}) do
        class.Libs[v]=v
    end
    class.dbnamePC="db"..o.ID
    class.dbname=class.dbnamePC .. "gen"
    class.Config={}
    class.List={}
    class._Memory={class.fullname}
    class.Cmds=o.Cmds or {}
    class.CmdConfigDesc="Open config GUI"
    class.CmdGuiDesc="Open config GUI"
    class.CmdresetDesc="Reset all data"
    class.CmdresetConfirm="Are you sure? You will lose all your customizations"
    class.CmddepsDesc="Show dependencies for this AddOn"
    class.CmdHelpDesc="Show help page"
    class.CmdstatusDesc="Display internal variables status"
    class.CmdeventsDesc="Show all hooked events for this addon"
    class.CmdversioncheckDesc="Version check"
    class.Events=o.Events or {}
    class.BucketEvents=o.BucketEvents or {}
    class.help={
        switches='',
        commands='',
        notes='',
        description=''
    }
    class.fu=o.fu or false
    class.titan=o.titan or false
    function class:TrackMem(msg)
        tinsert(self._Memory,format("%-30s: %.2f",msg or '',self:GetMemory()))
    end
    function class:OnEnable(first)
        if (first) then
            self:Banner()
        end
        if (type(self.Enable) == "function") then
            self:Enable(first)
        end
        self:ApplyEvents()

    end
    function class:OnDisable()
        self:UnApplyEvents()
        self:UnhookAll()
    end
    function class:OnInitialize ()
        self:TrackMem("OnInitialize start")
        self:Remap()
        self:TrackMem("DbInit")
        pcall(self.DbInit,self)
        self:_Initialize()
        if (self.Fu) then
            self:FuLoad()
        end
    end
    function class:_Initialize()
        pcall(self.DbCheck,self)
        self:SetDebugLevel(1)
        self.Commands={
            type='group',
            handler = self,
            desc='Commands',
            args= { }
        }
        self:LocaleLoad()
        self:TrackMem("LocaleLoad")
        self.L=AMOCOMMON.L
        if (type(self.Localize) == "function") then
            self:Localize()
            self:TrackMem("Localize")
        end
        if (type(self.Initialize) == "function") then
            self:Initialize()
            self:TrackMem("Initialize")
        end
        --------------------------------------
        self:Commands2Opts()
        self:Config2Opts()
        self:RegisterChatCommand({"/" .. self.ID,"/" .. self.fullname}, self.Commands)
        self:ReApply()
        self:LoadHelp()
        self:TrackMem("LoadHelp")
    end
    function class:OnGuildCommReceive()
    end
    function class:OnGroupCommReceive()
    end
    function class:_OnExit()
        if (type(self.OnExit)=="function") then
            self:OnExit()
        end
    end
    function class:Remap()
        -- Remapping all AMO function to class
        local i=0
        for k,v in pairs(AMO) do
            -- not a protected one
            if (not self[k] or k == 'Print' or k=='Error' or k == 'GetDebugPrefix' or k == 'PrintLiteral') then
                if (type(AMO[k]) == 'function') then
                    -- Doesnt exist in class AND is a function
                    self[k] = v
                    i=i+1
                end
            end
        end
        self:Print("Remapped %d methods",i)
    end
    function class:Register()
        self:SetDebugging(self.debug)
        self:Remap()
        self:TrackMem("Register Start")
        self:AutoEvents()
        self:TrackMem("AutoEvents")
        if (self.Fu) then
            self:FuCreate()
            self:TrackMem("FuCreate")
        end
        if (self.Titan) then
            self:Print("Titan support not yet factorized")
        end
        self:SetCommPrefix(self.fullname)
        self:SetDefaultCommPriority("BULK")
        self:RegisterComm(self.fullname,"GUILD","OnGuildCommReceive")
        self:RegisterComm(self.fullname,"GROUP","OnGroupCommReceive")
        self:RegisterEvent("PLAYER_LEAVING_WORLD","_OnExit")
        self:RegisterBucketEvent("PLAYER_MEMBERS_CHANGED",15,"_AskVersion")
        self:TrackMem("RegisterDone")
    end
    return class
end
local a_activate
function a_activate(self,oldLib,oldDeactivate)
    self:Trace("Activating AlarLib " .. self.minor)
    if (oldLib) then
        tinsert(AMOCOMMON.messages,GetTime() .. "Activating AlarLib " .. self.minor .. " over " .. oldLib.minor)
    else
        tinsert(AMOCOMMON.messages,GetTime() .. "Activating AlarLib " .. self.minor)
    end
    local registered=oldLib
    self.help={
        description='',
        notes='',
        commands='',
        switches='',
    }
    self.Commands = {
        type='group',
        handler = self,
        desc='Commands',
        args= { }
    }
    if (registered) then
        self.debug=oldLib.debug or false
        AMOCOMMON.help[1].title="Alarmod library"
    else
            ---- Help System
        AMOCOMMON.help.pagenum=1
        AMOCOMMON.help[1]={
            title="About",
            ID="AMO",
            fullname="AlarLib",
            pages={
            notes='',
            commands='',
            switches='',
            description=[[
|c00FFED1AAuthor:|r Alar of Daggerspine
|c00FFED1AEmail:|r alar@aspide.it
|c00FFED1AWebSite:|r http://wow.aspide.it
|c00FFED1AAceProfile:|r http://www.wowace.com/wiki/Category:Author:Alar_of_Daggerspine
]],}}
    AMOCOMMON.L={}
    local t=getmetatable(AMOCOMMON.L) or {}
    t.__index= function (table,key)
                    -- 1) locale specific
                    if (not key) then
                        return nil -- nil key are welcome in my implementation
                    end
                    local value=rawget(table,strupper(key))
                    if ( value) then
                        AlarLibData.missingkey[key]=nil
                        rawset(table,strupper(key),value)
                        return value
                    end
                    AlarLibData.missingkey[key]=true
                    return string.capitalize(key)
               end
    setmetatable(AMOCOMMON.L,t)
    self.L=AMOCOMMON.L
    end
end
local a_deactivate
function a_deactivate(self)
    tinsert(AMOCOMMON.messages,GetTime() .. " Dectivating AlarLib " .. self.minor)
    self=nil
end
local a_external
function a_external(self,major,instance)
    --DEFAULT_CHAT_FRAME:AddMessage("Loaded " .. major,0.5,0.5,0.5)
end
lib.minor=MINOR_VERSION
AceLibrary:Register(lib, MAJOR_VERSION, MINOR_VERSION, a_activate, a_deactivate, a_external)
del(lib)
AMO=AceLibrary("AlarLib-2.0")
function AMO:OnEnable(first)
    if (first) then
        self:Print(AMO_GREEN .. "%s.%s is ready. Use /%s help for info)",MAJOR_VERSION,MINOR_VERSION,strlower(self.ID))
        self:AddCmd("amo","Cmd","AlarLib","help",true)
        self:RegisterEvent("LEARNED_SPELL_IN_TAB","ZapSpellCache")
        self:RegisterEvent("SPELLS_CHANGED","ZapSpellCache")
        self:RegisterEvent("PLAYER_LEAVING_WORLD","UpdateVersion")
        AceLibrary("AceComm-2.0"):RegisterAddonVersionReceptor(self,"_VersionCheck")
        self:_AskVersion("GUILD")
    else
        self:Print(AMO_GREEN .. "%s updated to revision %s. Use /%s help for info)",MAJOR_VERSION,MINOR_VERSION,strlower(self.ID))
    end
    if (not self:Alar()) then -- voiding debug function
        AMO.Trace=function() return end
        AMO.TraceLiteral=function() return end
    end
end
function AMO:_AskVersion(channel)
    channel=channel or "GROUP"
    local com=AceLibrary("AceComm-2.0")
    com:QueryAddonVersion("AlarLib",channel)
    com:QueryAddonVersion("AlarBGHelper",channel)
    com:QueryAddonVersion("AlarTTFrame",channel)
    com:QueryAddonVersion("AlarAutomation",channel)
    com:QueryAddonVersion("AlarCrafter",channel)
end
function AMO:_VersionCheck(player,addon,version)
    if (version) then
        if (not AMOCOMMON.Users[addon]) then AMOCOMMON.Users[addon]={} end
        local oldversion=str2num(AMOCOMMON.Versioni[addon]) or 0
        if (str2num(version) > oldversion) then
            AMOCOMMON.Versioni[addon]=version
        end
        if (ATE) then
            if (not ATE.db.account.data.users) then
                ATE.db.account.data.users={}
            end
            ATE.db.account.data.users[addon .. '|' .. player]=version
        end
        AMOCOMMON.Users[addon][player]=version
    end
end

AMO.dbname="dummy"
AMO.dbname="dummychar"
AMO.db={
    profile={
         settings={},
         forms={},
         cache={},
         data={}
         },
    char={},
    account={}
}
--[[
PVPENTERQUEUE - Sound for entering BG queue and when it refreshes periodicly
PVPTHROUGHQUEUE - You are eligible to enter the battleground!
GLUESCREENSMALLBUTTONMOUSEDOWN
GLUESCREENSMALLBUTTONMOUSEUP
GLUESCREENSMALLBUTTONMOUSEOVER
GLUESCREENMEDIUMBUTTONMOUSEDOWN
GLUESCREENMEDIUMBUTTONMOUSEUP
GLUESCREENMEDIUMBUTTONMOUSEOVER
GLUESCREENLARGEBUTTONMOUSEDOWN
GLUESCREENLARGEBUTTONMOUSEUP
GLUESCREENLARGEBUTTONMOUSEOVER
GLUESCREENEDITBOXKEYCLICK
GLUECHECKBOXMOUSEDOWN
GLUECHECKBOXMOUSEUP
GLUECHECKBOXMOUSEOVER
GLUECHARCUSTOMIZATIONMOUSEDOWN
GLUECHARCUSTOMIZATIONMOUSEUP
GLUECHARCUSTOMIZATIONMOUSEOVER
GLUESCROLLBUTTONMOUSEDOWN
GLUESCROLLBUTTONMOUSEUP
GLUESCROLLBUTTONMOUSEOVER
GAMEABILITYBUTTONMOUSEDOWN
GAMESPELLBUTTONMOUSEDOWN
GAMEWINDOWOPEN
GAMEWINDOWCLOSE
GAMEDIALOGOPEN
GAMEDIALOGCLOSE
GAMENEWWINDOWTAB
GAMESCREENSMALLBUTTONMOUSEDOWN
GAMESCREENSMALLBUTTONMOUSEUP
GAMESCREENSMALLBUTTONMOUSEOVER
GAMESCREENMEDIUMBUTTONMOUSEDOWN
GAMESCREENMEDIUMBUTTONMOUSEUP
GAMESCREENMEDIUMBUTTONMOUSEOVER
GAMESCREENLARGEBUTTONMOUSEDOWN
GAMESCREENLARGEBUTTONMOUSEUP
GAMESCREENLARGEBUTTONMOUSEOVER
GAMETARGETFRIENDLYUNIT
GAMETARGETHOSTILEUNIT
GAMETARGETNEUTRALUNIT
GAMEHIGHLIGHTFRIENDLYUNIT
GAMEHIGHLIGHTHOSTILEUNIT
GAMEHIGHLIGHTNEUTRALUNIT
GAMEINITIALATTACK
GAMEERROROUTOFRANGE
GAMEERROROUTOFMANA
GAMEERRORUNABLETOEQUIP
GAMEERRORINVALIDTARGET
ACTIONBARBUTTONDOWN
MAINBUTTONBARMENU
MINIMAPZOOMOUT
MINIMAPZOOMIN
MINIMAPOPEN
MINIMAPCLOSE
BAGMENUBUTTONPRESS
LOOTWINDOWOPEN
LOOTWINDOWCLOSE
LOOTWINDOWCOINSOUND
ITEMWEAPONSOUND
ITEMARMORSOUND
ITEMGENERICSOUND
LEVELUPSOUND
GLUECREATECHARACTERBUTTON
GLUEENTERWORLDBUTTON
SPELLBOOKOPEN
SPELLBOOKCLOSE
SPELLBOOKCHANGEPAGE
PAPERDOLLOPEN
PAPERDOLLCLOSE
QUESTADDED
QUESTCOMPLETED
QUESTLOGOPEN
QUESTLOGCLOSE
GLUEGENERICBUTTONPRESS
GAMEGENERICBUTTONPRESS
INTERFACESOUND_MONEYFRAMEOPEN
INTERFACESOUND_MONEYFRAMECLOSE
INTERFACESOUND_CHARWINDOWOPEN
INTERFACESOUND_CHARWINDOWCLOSE
INTERFACESOUND_CHARWINDOWTAB
INTERFACESOUND_GAMEMENUOPEN
INTERFACESOUND_GAMEMENUCLOSE
INTERFACESOUND_LOSTTARGETUNIT
INTERFACESOUND_BACKPACKOPEN
INTERFACESOUND_BACKPACKCLOSE
INTERFACESOUND_GAMESCROLLBUTTON
INTERFACESOUND_CURSORGRABOBJECT
INTERFACESOUND_CURSORDROPOBJECT
SHEATHINGSHIELDSHEATHE
SHEATHINGWOODWEAPONSHEATHE
SHEATHINGMETALWEAPONSHEATHE
SHEATHINGWOODWEAPONUNSHEATHE
SHEATHINGMETALWEAPONUNSHEATHE
SHEATHINGSHIELDUNSHEATHE
igCreatureAggroDeselect
igQuestListOpen
igQuestListClose
igQuestListSelect
igQuestListComplete
igQuestCancel
igPlayerInvite
igPlayerInviteAccept
igPlayerInviteDecline
GAMEERRORUNABLETOEQUIP
ITEMGENERICSOUND
GAMEERRORINVALIDTARGET
LEVELUP
GAMEERROROUTOFRANGE
QUESTADDED
MONEYFRAMEOPEN
MONEYFRAMECLOSE
LOOTWINDOWOPEN
LOOTWINDOWCLOSE
LOOTWINDOWCOINSOUND
GAMEHIGHLIGHTHOSTILEUNIT
GAMEHIGHLIGHTNEUTRALUNIT
GAMEHIGHLIGHTFRIENDLYUNIT
INTERFACESOUND_LOSTTARGETUNIT
INTERFACESOUND_CURSORGRABOBJECT
INTERFACESOUND_CURSORDROPOBJECT
GAMESCREENMEDIUMBUTTONMOUSEDOWN
GAMEABILITYACTIVATE
GAMESPELLACTIVATE
gsTitleEnterWorld
gsTitleOptions
gsTitleQuit
gsTitleCredits
gsTitleIntroMovie
gsTitleOptionScreenResolution
gsTitleOption16bit
gsTitleOption32bit
gsTitleOptionOpenGL
gsTitleOptionDirect3D
gsTitleOptionFullScreenMode
gsTitleOptionOK
gsTitleOptionExit
gsLogin
gsLoginNewAccount
gsLoginChangeRealm
gsLoginExit
gsLoginChangeRealmOK
gsLoginChangeRealmSelect
gsLoginChangeRealmCancel
gsCharacterSelection
gsCharacterSelectionEnterWorld
gsCharacterSelectionDelCharacter
gsCharacterSelectionAcctOptions
gsCharacterSelectionExit
gsCharacterSelectionCreateNew
gsCharacterCreationClass
gsCharacterCreationRace
gsCharacterCreationGender
gsCharacterCreationLook
gsCharacterCreationCreateChar
gsCharacterCreationCancel
igCurrentActiveSpell
igMiniMapOpen
igMiniMapClose
igMiniMapZoomIn
igMiniMapZoomOut
igChatEmoteButton
igChatScrollUp
igChatScrollDown
igChatBottom
igSpellBookOpen
igSpellBookClose
igSpellBokPageTur n
igSpellBookSpellIconPickup
igSpellBookSpellIconDrop
igAbilityOpen
igAbilityClose
igAbiliityPageTurn
igAbilityIconPickup
igAbilityIconDrop
TalentScreenOpen
TalentScreenClose
igCharacterInfoOpen
igCharacterInfoClose
igCharacterInfoTab
igCharacterInfoScrollUp
igCharacterInfoScrollDown
igQuestLogOpen
igQuestLogClose
igQuestLogAbandonQuest
igQuestFailed
igSocialOepn                 [This is Not a Wiki Typo, "igSocialOepn" works in game]
igSocialClose
igMainMenuOpen
igMainMenuClose
igMainMenuOption
igMainMenuLogout
igMainMenuQuit
igMainMenuContinue
igMainMenuOptionCheckBoxOn
igMainMenuOptionCheckBoxOff
igMainMenuOptionFaerTab
igInventoryOepn               [This is Not a Wiki Typo, "igInventoryOepn" works in game]
igInventoryClose
igInventoryRotateCharacter
igBackPackOpen
igBackPackClose
igBackPackCoinSelect
igBackPackCoinOK
igBackPackCoinCancel
igCharacterNPCSelect
igCharacterNPCDeselect
igCharacterSelect
igCharacterDeselect
igCreatureNeutralSelect
igCreatureNeutralDeselect
igCreatureAggroSelect
UChatScrollButton
Deathbind Sound
LOOTWINDOWOPENEMPTY
TaxiNodeDiscovered
UnwrapGift
TellMessage
WriteQuest
MapPing
igBonusBarOpen
FriendJoinGame
Fishing Reel in
HumanExploration
OrcExploration
UndeadExploration
TaurenExploration
TrollExploration
NightElfExploration
GnomeExploration
DwarfExploration
igPVPUpdate
ReadyCheck
RaidWarning
AuctionWindowOpen
AuctionWindowClose
--]]
