local AMO=AceLibrary("AlarLib-2.0")

AMO:Print("Titan Support Loaded")
-- Titan Support
local TGN=TitanUtils_GetNormalText
    or function(text) return NORMAL_FONT_COLOR_CODE..tostring(text)..FONT_COLOR_CODE_CLOSE end
local TGH=TitanUtils_GetHighlightText
    or function(text) return HIGHLIGHT_FONT_COLOR_CODE..tostring(text)..FONT_COLOR_CODE_CLOSE end
local TGR=TitanUtils_GetRedText
    or function(text) return RED_FONT_COLOR_CODE..tostring(text)..FONT_COLOR_CODE_CLOSE end
local TGG=TitanUtils_GetGreenText
    or function(text) return GREEN_FONT_COLOR_CODE..tostring(text)..FONT_COLOR_CODE_CLOSE end
local TITAN_ABH_ID = "AlarBGHelper";
local TITAN_ABH_MENU_TEXT ="AlarBGHelper";
local TITAN_ABH_TOOLTIP ="AlarBGHelper";
local TITAN_ABH_ICON = "Interface\\GossipFrame\\BattleMasterGossipIcon"
function ABH_Titan_GetButtonText()
	local status, mapName, i, op,op2
	local bgs={}
	op=""
	op2=""
	for i = 1, MAX_BATTLEFIELD_QUEUES do
		status, mapName,prog = GetBattlefieldStatus(i);
		--op2=op2 .. mapName .. "=" .. status .. " "
		mapName=mapName or ""
		local bg=ABH.BGSHORTCUTS[ABH.BGS[mapName]]
		if (not bg) then
            bg=string.sub(mapName,1,3)
        end
        if (status == "active") then
            table.insert(bgs,TGH(bg ..  prog))
        elseif (status == "queued") then
            table.insert(bgs,TGR(bg))
        elseif (status == "confirm") then
            table.insert(bgs,TGG(bg .. prog .. " " .. AMO:TimeToStr(math.floor(GetBattlefieldPortExpiration(i)/1000))))
        end
    end
    i =table.getn(bgs)
    local op=""
    if (i > 1) then
        for k=1,i-1 do
            op=op .. bgs[k] .. "/"
        end
    end
    if (i > 0 ) then
        op=op .. bgs[i]
    end

    local Kills,Points=GetPVPSessionStats()
    local KS=TGH(AMO:Format("%d",Kills or 0))
    local KP=TGH(AMO:Format("%d",Points or 0))
    local KM=""
    for k,n in pairs(ABH.MARKS) do
        local marks=tonumber(ABH.markscount[k.."MARKS"]) or 0
        KM=KM .. TGH(ABH.BGSHORTCUTS[k]) .. ":" .. TGG(marks) .. " "
    end
    if (ABH.pgcache and ABH.pgcache[ABH:Me()]) then
        local cache=ABH.pgcache[ABH:Me()]
        return "KB:",TGG(cache.killingBlows), "BG:",op,"HK:",KS,"HP:",KP,"Marks:",KM
    else
        return "BG:",op,"Honor:",TGR(KS) .. "/" .. TGG(KP),"Marks:",KM
    end
end
if (not IsAddOnLoaded("Titan")) then
    return
end
local f=AMO:Create("Frame",nil,UIParent)
local b=AMO:Create("Button","TitanPanelAlarBGHelperButton",f,"TitanPanelComboTemplate")

ABHTITAN={}
-- If this function is missing, updating is done directly by titan
if (not TitanPanelPluginHandle_OnUpdate) then
    function TitanPanelPluginHandle_OnUpdate(id,mode)
        return
    end
end
function ABHTITAN:UpdateText()
    TitanPanelPluginHandle_OnUpdate(TITAN_ABH_ID,TITAN_PANEL_UPDATE_BUTTON)    
end
function ABHTITAN:UpdateDisplay()
    TitanPanelPluginHandle_OnUpdate(TITAN_ABH_ID,TITAN_PANEL_UPDATE_ALL)    
end
function ABHTITAN:UpdateTooltip()
    TitanPanelPluginHandle_OnUpdate(TITAN_ABH_ID,TITAN_PANEL_UPDATE_TOOLTIP)    
end

function ABH_Titan_OnLoad(this)
    AMO:Print("TitanOnLoad")
	this.registry = {
		id = TITAN_ABH_ID,
		version = ABH.version,
		category = "Combat",
		menuText = TITAN_ABH_MENU_TEXT,
		buttonTextFunction = "ABH_Titan_GetButtonText",
		tooltipTitle = TITAN_ABH_TOOLTIP,
		tooltipTextFunction = "ABH_Titan_GetTooltipText",
		frequency = 1.0,
		icon=TITAN_ABH_ICON,
		iconWidth=20,
		savedVariables= {
            ShowIcon = 1,
            ShowLabelText = 1,
        },
        updateType = TITAN_PANEL_UPDATE_BOTH
	}
end
function ABH_Titan_GetTooltipText()
    local status, mapName, i, op
    op=""
    for i = 1, MAX_BATTLEFIELD_QUEUES do
    	status, mapName,prog = GetBattlefieldStatus(i);
        status=status or ""
        mapName=mapName or ""
        prog=prog or 0
        local ops=string.format("%s in %s %d\t",status,mapName,prog)
        if (status == "queued") then
            op=op..ops..string.format("%s\n",TGH(AMO:TimeToStr(GetBattlefieldTimeWaited(i)/1000)))
        elseif (status == "none") then
            -- none
        elseif (status == "confirm") then
            op=op..ops..string.format("%s\n",TGH("accepted"))
            -- none
        elseif (status == "error") then
            op=op..ops.. string.format("%s\n",TGH("error"))
        end
    end
    for k,n in pairs(ABH.MARKS) do
        local marks=tonumber(ABH.markscount[k.."MARKS"]) or 0
        op=op .. TGH(n) .. "\t" .. TGG(marks) .. "\n"
    end
    return op
end

function ABH_Titan_ToggleVar()
    local toggle=this:GetText()
    local _,_,bg =string.find(toggle,"(%a+) Enabled")
    bg=strupper(bg)
    local command="OFF"
    ABH:ToggleVar(bg)
    TitanPanelRightClickMenu_PrepareAlarBGHelperMenu()
end

----------------------------
-- Rightclick Menu
----------------------------
function TitanPanelRightClickMenu_PrepareAlarBGHelperMenu()
	--TitanPanelRightClickMenu_AddTitle(TitanPlugins[TITAN_ABH_ID].menuText);
	TitanPanelRightClickMenu_AddTitle("AlarBGHelper");
	TitanPanelRightClickMenu_AddToggleIcon(TITAN_ABH_ID);
	TitanPanelRightClickMenu_AddToggleLabelText(TITAN_ABH_ID);
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddTitle("General Options");
	info = {};
	info.text = "AB Enabled";
	info.func = ABH_Titan_ToggleVar;
	info.checked = ABH:GetToggle("AB")
	UIDropDownMenu_AddButton(info);
	info.text = "AV Enabled";
	info.func = ABH_Titan_ToggleVar;
	info.checked = ABH:GetToggle("AV")
	UIDropDownMenu_AddButton(info);
	info.text = "WSG Enabled";
	info.func = ABH_Titan_ToggleVar;
	info.checked = ABH:GetToggle("WSG")
	UIDropDownMenu_AddButton(info);
	info.text = "EOS Enabled";
	info.func = ABH_Titan_ToggleVar;
	info.checked = ABH:GetToggle("EOS")
	UIDropDownMenu_AddButton(info);
	TitanPanelRightClickMenu_AddSpacer();
	local status, index, mapName;
    status=""
    local bgtoleave=0
	for i=1,MAX_BATTLEFIELD_QUEUES do
		status,mapName,_ = GetBattlefieldStatus(i);
		if(status == "confirm") then
            bgtoleave=bgtoleave+1
        	info = {}
        	info.text = "Leave " .. mapName
        	info.userdata=mapName
        	info.func = function()
                ABH_LeaveQueue(this.userdata)
            end
        	info.checked = nil
        	UIDropDownMenu_AddButton(info);
		end
	end
	if (bgtoleave > 1) then
    	info = {}
    	info.text = "Leave all queues"
    	info.func = ABH_LeaveQueue
    	info.checked = nil
    	UIDropDownMenu_AddButton(info);
    end
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, TITAN_ABH_ID, TITAN_PANEL_MENU_FUNC_HIDE);
end

if (not ABH.TitanSupport) then
    return
end
function ABH_Titan_OnClick()
	if (arg1 == "LeftButton") then
		ABH_Titan_ToggleVar_AlternateDisplay();
		TitanPanelButton_UpdateButton(TITAN_ABH_ID);
		TitanPanelButton_UpdateTooltip();
	else
		TitanPanelButton_OnClick(arg1);
	end
end
-- Creating and initializing frame
b:SetFrameStrata("FULLSCREEN")
b:SetToplevel(true)
do
this=b
ABH_Titan_OnLoad(this)
TitanPanelButton_OnLoad()
this=nil
end