ABHFU=nil
if (not ABH.FuBarSupport) then
    return
end
local L
local tablet = AceLibrary("Tablet-2.0")
ABHFU = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "FuBarPlugin-2.0")
local ABHFU = ABHFU
ABHFU.revision = tonumber(string.sub("$Revision: 64803 $", 12, -3)) or 1
ABHFU.colast=0
ABHFU.hasIcon = "Interface\\GossipFrame\\BattleMasterGossipIcon"
ABHFU.version = "2.0." .. string.sub("$Revision: 64803 $", 12, -3)
ABHFU.date = string.sub("$Date: 2008-03-17 04:02:44 -0400 (Mon, 17 Mar 2008) $", 8, 17)
ABHFU.title="FuBar - AlarBGHelper"
ABHFU.clickableTooltip = true
ABHFU.hasNoColor = true
ABHFU.cannotHideText = true
--ABHFU.canHideIcon = true
ABHFU.clickableTooltip = true
local pgcount=0
local Options={
    type='group',
    handler=self,
	pass = true,
    set='SetValue',
    get='GetValue',
    args={
        shortText={
            name='Short Text',
            desc="Hides value's descriptions in fubar text",
            type='toggle'
        },
        hideMarks={
            name='Hides honor marks',
            desc='Hides Honor Marks count in fubar text',
            type='toggle',
        }
    }
}

function ABHFU:OnTextUpdate()
    local lista={ABH_Titan_GetButtonText()}
    local testo=""
    if (type(self.db) ~= "table") then
        self:SetText("Initializing")
        return
    end
    local skipText=self.db.profile.shortText
    local skipMarks=self.db.profile.hideMarks
    for i= 1,#lista,2 do
        if (skipMarks and lista[i] == 'Marks:') then
            -- ignore
        else
            if (not skipText) then
                testo = testo ..' ' .. lista[i] .. ' ' .. lista[i+1]
            else
                testo = testo ..' ' .. lista[i+1]
            end
        end
    end
    if (ALARDEVELOPMENTPC) then
        testo = testo .. ' ' .. ABH:Age(self.colast)
    end
    self:SetText(testo)
end
--    ABH:ScheduleRepeatingEvent(ABH_FuSync,1)
function ABHFU:GetValue(key)
    return self.db.profile[key]
end
function ABHFU:SetValue(key,value)
    self.db.profile[key]=not self.db.profile[key]
    self:UpdateText()
end
function ABHFU:OnInitialize()
	self.db=ABH:AcquireDBNamespace("ABHFU")
    self.OnMenuRequest=Options
    L=ABH.L
	ABH:ScanForMarks()
end

function ABHFU:OnEnable()
    self:ScheduleRepeatingEvent(ABH_FuSync,1)
end

function ABHFU:OnDisable()
    self:RemoveAllScheduledEvents()
end
local line={}
function ABHFU:OnTooltipUpdate()
    tablet:SetHint("Right-click for Options")
	local cat = tablet:AddCategory(
        'id','Marks',
        'text','Queues',
        'columns',2,
        'child_textR',AMO_Yellow.r,
        'child_textG',AMO_Yellow.g,
        'child_textB',AMO_Yellow.b,
        'child_text2R',AMO_Green.r,
        'child_text2G',AMO_Green.g,
        'child_text2B',AMO_Green.b
        )
    local status, mapName, i, op
    local bg=nil
    for i = 1, MAX_BATTLEFIELD_QUEUES do
    	status, mapName,prog = GetBattlefieldStatus(i);
        status=status or ""
        mapName=mapName or ""
        prog=prog or 0
        local ops=string.format("%s (%d)",mapName,prog)
        local opt=nil
        if (status == "queued") then
            opt=AMO:TimeToStr(GetBattlefieldTimeWaited(i)/1000)
        elseif (status == "none") then
            -- none
        elseif (status == "confirm") then
            opt="accepted"
            -- none
        elseif (status == "error") then
            opt="error"
        end
        if (opt) then
            bg=true
    	    line={
                text = ops .. opt,
                text2 = 'Click to leave',
                justify= 'LEFT',
                justify2= 'RIGHT',
                wrap= false,
                func='OnNameClick',
                arg1=self,
                arg2=i,
            }
            cat:AddLine(line);
        end
	end
	if (bg) then
        line={
            text = L['Click to leave all (except the one you are in)'],
            text2 = '',
            justify= 'LEFT',
            justify2= 'RIGHT',
            wrap= false,
            func='OnNameClick',
            arg1=self,
            arg2=nil,
        }
        cat:AddLine(line);
    else
        line={
            text = L['You are not queued for any bg'],
            text2 = '',
            justify= 'LEFT',
            justify2= 'RIGHT',
            wrap= false,
        }
        cat:AddLine(line);
    end
end
function ABHFU:ShowData(pg)
    ABH:PrintLiteral(ABH.pgcache[pg])
    if (not self.Tooltip) then
        self.Tooltip=CreateFrame("GameTooltip","ABHFUTT",UIParent,"GameTooltipTemplate")
    end
    self.Tooltip:ClearLines()
    self.Tooltip:AddLine(pg,AMO_Yellow.r,AMO_Yellow.g,AMO_Yellow.b)
    for k,v in pairs(ABH.pgcache[pg]) do
        self.Tooltip:AddDoubleLine(k,v)
    end
    self.Tooltip:SetOwner(UIParent,"ANCHOR_CURSOR")
    self.Tooltip:Show()
end
function ABHFU:ResetCache()
        self:Print("Doing a full garbage collection cycle,please wait")
        for i,v in pairs(ABH.pgcache) do
            ABH.pgcache[i]=nil
        end
        for i,v in pairs(ABH.healedyou) do
            ABH.healedyou[i]=nil
        end
        collectgarbage("collect")
        self:Print("Done")

end
function ABHFU:OnClick()
    AMO:Trace("Clicked abh fubar")
end
function ABHFU:OnNameClick(text)
    ABH:LeaveQueue(text)
end
function ABHFU:ToggleAddon()
    self:Hide()
end
