--[[
Name: AlarBGHelper.lua
Revision: $Rev: 79065 $
Author: Alar of Daggerspine
Website: http://wow.aspide.it
Documentation:
SVN:
Description:
Dependencies:
License: GPL v2.1
]]
local Id="ABH"
local Fullname="AlarBGHelper"
local libs={
GloryLib='Glory-2.0',
}
for addon,major in pairs(libs) do
    if not AceLibrary:HasInstance(major) then
        error("AlarBGHelper requires " .. addon)
        return
    end
end
local AMO=AceLibrary("AlarLib-2.0")
local L =AMOCOMMON.L
local ShowTimers,CheckDebuff
local wsgtimer=120
local CarrierSpotted=0
local IsCarrier=nil
local myname=""
local wsgnotify
local function help(self)
--===DOCBEGIN===
    self:RelNotes(3,4,2,[[
Fixed: Randomly appearing message:  ..\AddOns\AlarBGHelper\AlarBGHelper.lua line 1649: attempt to index local 'obj' (a nil value)   
]])
    self:RelNotes(3,4,1,[[
Fixed: Found a little bug in the way AceDB-2.0 retrieve the addon name from the file path. If your path is too deep, it fails.
Guess it? The layout I choosed for my library WAS too deep
If you experienced: config not saved or addon loading but not working, this fix is for you.
]])
    self:RelNotes(3,4,0,[[
Last Ace2 version. Next one will be ace3 and mostly rewritten from scratch
Feature: Beta - In Warsong Gulch, show timers for carrier trackability and debuff. Timer are "approssimatives" because Blizzard itself says "about 10 minutes". Besides that.. testing it is awful.. I am waiting for some feedback from you.
Feature: timer bar for trackability when you are the flag carrier
Feature: You automatically announce when you are on enemy carrier (should not be spammy, check it)
Fixed: Resolves Message:  AlarLib-2.0-68657 (AlarBGHelper):2714: bad argument #1 to 'SetFormattedText' (string expected, got nil).    At last! This bug was showing up only for horde.. and I don't play horde, so it was a bit hard to find it ;-)
Fixed: Sometimes, when using an embedded copy of AlarLib, db didn't initialize and ABH was not loaded
]])
    self:RelNotes(3,3,8,[[
Fixed: Resolves Message: ...Auc-Advanced\Modules\Auc-Util-Appraiser\AprFrame.lua line 1198:
attempt to call global 'message' (a string value)
]])
    self:RelNotes(3,3,7,[[
Feature: slightly improved miniframes look
Feature: WoW 2.4 compatible
]])
    self:RelNotes(3,3,6,[[
Fixed: Removed error message related to missing Titan template missing when Titan not installed
]])
    self:RelNotes(3,3,5,[[
Fixed: Arathi Basin prediction was always showing Alliance victory conditions (non english versions only)
Fixed: Warsong gulch customization now fully works
]])
    self:RelNotes(3,3,4,[[
Feature: AutoRelease flag is now separed for each BG
]])
    self:RelNotes(3,3,3,[[
Feature: EOS now calculates flag taking rate, i.e. need n flag every second to win
Fixed: Frostwolf timers now work for german version too.
Fault was Blizzard, which for some esotic reason decided to call the towers sometimes ...liche , sometimes ...licher.
I will ask cknight to fix GloryLibg, meanwhile the workaround is inside AlarBGHelper
]])
    self:RelNotes(3,3,2,[[
Fixed: \AlarLib-2.0\AlarLib-2.0.lua:4689: bad argument #1 to 'pairs' (table expected, got nil)
Fixed: On screen messages in AV now works for deDE locale, too
]])
    self:RelNotes(3,3,1,[[
Fixed: AV window doesnt autoresize anymore on system messages
Fixed: If you installed ABH really long time ago, you had some garbage in your saved data. Now it is removed on first use. If ABH was more than one Megabyte for you, that is your case.
Now ABH should never use more then 350-370K
Feature: Timer bars have now icons
]])
    self:RelNotes(3,3,0,[[
Feature: Timers' spam have now different buttons for Horde and alliance
Feature: Boss status is spammable (left click it to announce)
Fixed: Thank you feature is now disabled outside bg as intended
]])
    self:RelNotes(3,2,2,[[
Feature: Holding down alt while you see the enter/hide popup for a battlefield,allow you to leave instead of hide when clickin on the hide button (which changes to "Leave queue" when alt is hold)
Fixed: There was a missing externals, so wowace was not upgrading files. You should see ABH again in wowaceupdater list
]])
    self:RelNotes(3,2,1,[[
Fixed: Battlegroup scan sometimes stopped to work
Feature: /abh show, when inside a battleground, resize the window to it's standard height
]])
    self:RelNotes(3,2,0,[[
Feature: You can automatically thanks people who heals you in battlegrounds. Antispam included (no more than 1 thanks every 4 minutes to the same one)
Feature: Localization done.  Now I need translators
Feature: Eye of the Storm result prediction improved
Feature: You can now hide Honor marks recap in Fubar text
Feature: You can customize text buttons and messages in WSG (/abh gui)
]])
    self:RelNotes(3,1,1,[[
Fixed: ..\AddOns\AlarBGHelper\AlarBGHelper.lua line 1826: table index is nil
]])
    self:RelNotes(3,1,0,[[
Feature: AV Boss status is back as EXPERIMENTAL. Enable SYNC to test it
Feature: Revamped panels. More intuitive and less invasive move/resize interface
]])
    self:RelNotes(3,0,3,[[
Feature: You can now disable showing bg related messages on screen.
Feature: Honor marks name localized to french
]])
    self:RelNotes(3,0,2,[[
Fixed: Health scan disabled in AV. Not useful
Feature: /abh cleancache to delete pg cache and free memory
]])
    self:RelNotes(3,0,1,[[
Fixed: Removed an error while displaying fubar tooltip
]])
    self:RelNotes(3,0,0,[[
Feature: Updated to WoW 2.3
Feature: WSG panel is shrinkable (via config menu)
Feature: EoS winner prediction is in
Feature: Tracks enemies health scannin your raidmates' target. Should not lag, but you can disable it
]])
	self:RelNotes(2,9,0,[[
Feature: Life spam is back: you can enable it so when you are guarding a base and your life goes under a configurable level, you ask for help automagically.
It disables itself after EVERY death
Feature: WSG messages contains info about carrier health, if available
Feature: Marks can show banked marks, too
Fixed: Titan and Fubar support should work fine. Let me know
]])
    self:RelNotes(2,8,1,[[
Fixed: Incompatibility with RockConfig resolved
]]);
    self:HF_Title("Battleground assistant","description")
    self:HF_Pre([[Displays a small window with status information.
Contested nodes are drawn in the color of the ATTACKING faction
Owned nodes are yellow (you have the icon to see who is controlling it)
Destroyed nodes are grey]])
    self:HF_Paragraph(L.AB)
    self:HF_Pre("Base messages:")
    self:HF_Command("Left click",L.BGHELP4)
    self:HF_Command("Middle click",L.BGHELP2)
    self:HF_Command("Right click",L.BGHELP1)
    self:HF_Command("Shift-Left click",L.BGHELP3)
    self:HF_Pre([[
    Clicking on "Ally/Horde wins in .." line, announce it in chat
    Same for the "We need ... bases to win"
    Time left and bases needed will be meaningfull only when at least one base has been taken by horde or ally
    Besides each contested nodes you will see the time left to cap.
    ]])
    self:HF_Paragraph("Warsong Gulch")
    self:HF_Pre([[
    Shows 2 big button with carrier's names. Click to target, shift-click to announce.
    Extending the window (click on the >> button) discovers some more button.
    ]])
    self:HF_Command("Left click","Help needed at location")
    self:HF_Command("Right click","location now safe")
    self:HF_Paragraph("Alterac Valley")
    self:HF_Pre([[
    Near each contested nodes you will see the time left to cap. Clicking on time will announce it in chat.
    You can click on objectives' descriptions too:
    ]])
    self:HF_Command("Left click","Help needed at objective")
    self:HF_Command("Right click","objective now safe")
    self:HF_Paragraph("Eye of The Storm")
    self:HF_Pre([[
    Towers recap
    Extimated faction and time to win based on owned towers
    Extimated flag captures needed to win for the team losing by towers
    ]])
    self:HF_Commands()
    self:HF_Cmd("Show","Redraw the current bg panel if it get lost")
    self:HF_Cmd("Marks ","Displays your Honor marks status")
    self:HF_Cmd("Cleancache","Clean pg cache","Clean pg cache")
--===DOCEND===
end
local Events={
    BATTLEFIELDS_SHOW=0,
    UPDATE_BATTLEFIELD_STATUS=0,
    CHAT_MSG_BG_SYSTEM_ALLIANCE=0,
    CHAT_MSG_BG_SYSTEM_HORDE=0,
    CHAT_MSG_BG_SYSTEM_NEUTRAL=0,
    CHAT_MSG_MONSTER_YELL=0,
    CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS=0,
    RAID_ROSTER_UPDATE=nil,
    ZONE_CHANGED_NEW_AREA=0,
    }
-- Questi eventi vengono generati anche fuori dai BG, quindi li attivo e disattivo
-- Gli eventi specifici dei BG invece li lascio sempre attivi tanto se non sono
-- in bg non partono
local localevents={
    GOSSIP_SHOW=0,
    PLAYER_DEAD=0,
    PLAYER_REGEN_ENABLED=0,
    PLAYER_UNGHOST=0,
    QUEST_COMPLETE=0,
    QUEST_PROGRESS=0,
    COMBAT_TEXT_UPDATE=0,
}



local Cmds= {
    Enable="Enable a battleground",
    Disable="Disable a battleground",
    
}
setglobal(Id,AMO:new{
    ID=Id,
    fullname=Fullname,
    description="Battleground Assistent",
    debug=false, -- Testing, debug sempre attivo
    Events=Events,
    Cmds=Cmds,
    markscount={},
    Fu=true,
})
local mod=getglobal(Id)
--ABH.ev=localevents
local thankspam=240 -- 4 minutes
local AV_HLevels={}
local AV_ALevels={}
local soulstoned=false
local hold
local needed
local ABH_RANGE=400
local vC
local HelpPage=1
local ShortHGen
local ShortAGen
local CurrentGeneral=1
local LastTimeUpdate=0
local LastSpamTime=nil
local LastZone=""
local AutoAlert=false
local HelpPage
local carrier={}
local baseupd=false
local LastBg="none"
local CurrentDuration=0
local CurrentBars=false
local CurrentBg="none"
local CurrentThreshold=0
local CurrentSpam=false
local onscreen=true
local syncrho=false
local CurrentForm=nil
local LastBg="none"
local dontspam=nil
local mylocation=nil
local G
local C
local startmessages=""
-- Creazione dei frames
local ABF="AlarABHelper"
local AVF="AlarAVHelper"
local WSGF="AlarWSGHelper"
local EOSF="AlarEOSHelper"
local ABB="AlarABHelperBars"
local AVB="AlarAVHelperBars"
local WSGB="AlarWSGHelperBars"
local EOSB="AlarEOSHelperBars"
local frames={ABF,AVF,WSGF,EOSF}
local shorts={'AB','AV','EOS','WSG'}
local formnames={
    AB=ABF,
    AV=AVF,
    WSG=WSGF,
    EOS=EOSF,
}
local minmarks={
    AB=5,
    AV=18,
    WSG=0,
    EOS=4,
    none=0,
}
local points={
    AB={},
    AV={},
    WSG={},
    EOS={},
}
local pgcachekeys={
    name=1,
    killingBlows=2,
    honorKills=3,
    deaths=4,
    honorGained=5,
    faction=6,
    rank=7,
    race=8,
    class=9,
    englishclass=10,
    damageDone=11,
    healingDone=12,
    health=13,
    updated=14
}
local t={
    __index= function (table,key)
            return 0
    end
}
local t2={
    __index=  function (table,key)
        if (not tonumber(key)) then
            key=pgcachekeys[key] or 1
            return rawget(table,key) or 0
        end
    end
}
local pgcache={}
local pgcachedata=setmetatable({},{
    __index=function (table,key)
        local simple=strsplit("-",key)
        table[key]=setmetatable({key,0,0,0,0,"",0,0,0,0,0,0,0},t2)
        if (simple ~= key) then
            table[simple]=rawget(table,key)
        end
        return rawget(table,simple)
    end
    }
)
local healedyou=setmetatable({},t)
local healedyoufor=setmetatable({},t)
setmetatable(pgcache,{
    __index=pgcachedata,
    __newindex=function(table,key,tbx)
        local i=tonumber(key)
        if (i) then
            if (tbx[1]) then
                key=tbx[1]
                if (tbx[6] == 0) then
                    tbx[6]=FACTION_HORDE
                else
                    tbx[6]=FACTION_ALLIANCE
                end
                local p=pgcachedata[key]
                for k,v in ipairs(tbx) do
                    if (k > 1) then
                        p[k]=v
                    end
                end
            end
        end
    end
})


function mod:Health(unit)
    local totale=UnitHealthMax(unit) or 1
    local corrente=UnitHealth(unit) or 1
    if (corrente == 0) then corrente =1 end
    if (totale==0) then totale = corrente end
    local life=corrente/totale*100
    return math.ceil(life)
end
local time
function time()
    return math.floor(GetBattlefieldInstanceRunTime()/1000)
end
function mod:Help(this,button,msg)
    local base=this.longname
    if (not msg) then
        msg=""
        if (self:ChooseClick(button)) == 3 then
            msg=format(L.BGHELP1,base);
        elseif (self:ChooseClick(button)) == 2 then
            msg=format(L.BGHELP2, base)
        else
            if (IsShiftKeyDown()) then
                msg=format(L.BGHELP3,base)
            else
                msg=format(L.BGHELP4,base)
            end
        end
    end
    self:Message(msg,"BATTLEGROUND")
    local x,y=GetPlayerMapPosition("player")

end
function mod:_CreateFrame(bg)
    local nome=formnames[bg]
    if (not nome) then
        self:Debug("Invalid bg",bg)
        return
    else
        if (getglobal(nome)) then
            return getglobal(nome)
        else
            self:Debug("Creating",nome)
        end
    end
    local nm=GetNumMapLandmarks() or 0
    local rm=minmarks[CurrentBg] or 99999
    if (nm < rm ) then
        self:Print(L.MAPWAITING,CurrentBg,nm,'<',rm)
        return
    end
    if (CurrentBg=='none') then
        self:Print("Not in bg??")
    end
    local form=self:CreatePanel(nome,{backdrop="bubble",noClose=1,noSave=1,noCancel=1})
    self:Debug(form)
    self:Scale(form)
	form.title=self:FrameAddLLabel(form,"title","AlarBGHelper",10,0)
	form.title:SetPoint("TOPRIGHT",0,0)
	form.marks={1,2,3,4,5}
    form.poi={}
    form.label={}
    form.timer={}
    self:Debug("Generata base comune per",form)
    local y=400
    local x=300
    if (nome == EOSF) then
        y,x=self:_EOSCreateFrame(form)
    elseif
        (nome == ABF) then
        y,x=self:_ABCreateFrame(form)
    elseif
        (nome == WSGF) then
        y,x=self:_WSGCreateFrame(form)
    elseif
        (nome == AVF) then
        y,x=self:_AVCreateFrame(form)
    end
    local cb=self:FrameAddCheckbox(form,bg .. 'SPAM',
        function(flag,value) self:ApplyVar(flag,value) end,L['Spam my life'],10,-y)
    y=y+32
    cb:ClearAllPoints()
    cb:SetPoint("BOTTOMLEFT",form,"BOTTOMLEFT",30,5)
    --form:SetHeight(y)
    --form:SetWidth(x)
    --self:PanelMinSize(form,x,y)
    form:FitChildren()
    self:PanelRestore(form)
    self:Debug("Restored sizes:",form:GetWidth(),form:GetHeight())
    self:ApplyWGB(self:GetToggle("WGB"))
    self:ApplyAVC(self:GetToggle("AVC"))
    return form
end
--[[
Note:
1=1
2=2.5
3=5
4=10
4 basi sembra 10 al secondo
Flags:
con 1 75
con 2 basi =85
con 3 basi = 105
]]
function mod:_EOSCreateFrame(form)
    local row,maxcol=self:CreatePoiRow(form,-20,true)
    local l=self:FrameAddLLabel(form,"AFlag","Flag:   0",10,row)
    l:SetWidth(80)
    self:SetColor(l,AMO_Azure)
    l=self:FrameAddRLabel(form,"HFlag","Flag:   0",0,row)
    l:SetWidth(80)
    self:SetColor(l,AMO_Red)
    l:ClearAllPoints()
    l:SetPoint("TOPRIGHT",form,"TOPRIGHT",-10,row)
    local middle=form:GetWidth()/2
    row=row - 20
    local ico
    -- Ally final points
    ico=self:FrameAddIcon(form,"AllyFinal","interface\\minimap\\poiicons",0,0)
    self:SetPoiiOffset(ico,46)
    l=self:FrameAddRLabel(form,"AllyFinal","00000",0,0)
    l:SetText("0")
    ico:ClearAllPoints()
    l:ClearAllPoints()
    ico:SetPoint("TOPLEFT",10,row-10)
    l:SetPoint("TOPLEFT",ico,"TOPRIGHT",5,0)
    -- Horde final points
    ico=self:FrameAddIcon(form,"HordeFinal","interface\\minimap\\poiicons",middle,row-10)
    self:SetPoiiOffset(ico,48)
    l=self:FrameAddRLabel(form,"HordeFinal","00000",middle+20,row)
    l:SetText("0")
    ico:ClearAllPoints()
    l:ClearAllPoints()
    l:SetPoint("TOPRIGHT",-10,row-10)
    ico:SetPoint("TOPRIGHT",l,"TOPLEFT",-5,0)
    row=row-30
    l=self:FrameAddTitle(form,"Status",L.DATAWAITING,0,row)
    l:EnableMouse(true)
    self:SetClick(l,function(...) self:Inform(...) end)
    --l:SetScript("OnMouseUp",function(...) self:Inform(...) end)
    row=row -20
    l=self:FrameAddTitle(form,"Status2",L.DATAWAITING,0,row)
    l.Label:SetNonSpaceWrap(true)
    l:EnableMouse(true)
    l:SetHeight(40)
    self:SetClick(l,function(...) self:Inform(...) end)
    --l:SetScript("OnMouseUp",function(...) self:Inform(...) end)
    row=row -30
    l=self:FrameAddTitle(form,"Status3",L.DATAWAITING,0,row)
    l:EnableMouse(true)
    self:SetClick(l,function(...) self:Inform(...) end)
    --l:SetScript("OnMouseUp",function(...) self:Inform(...) end)
    row=row-35
    return -row,maxcol
end
local exits={
             GY='GraveYard',
             TNL='Tunnel',
             RMP='Ramp',
             MDF='MiddleField'
            }
local WSGbuttons={
    {
        desc= 'Our carrier exits/is: ',
        carrier='FF',
        row=30,
        col=5,
        bts=exits,
    },
    {
        desc= 'Enemies in/from: ',
        row=60,
        col=5,
        bts={TNL='Tunnel',TER='Terrace',RF='Roof',FLG='Flag Room'}
    },
    {
        desc= 'Their carrier exits from: ',
        carrier='OF',
        row=100,
        col=5,
        bts=exits,
    },
    {
        desc='Their carrier is near: ',
        carrier='OF',
        row=130,
        col=5,
        bts={me='Myself',ORF='Our Roof',TRF='Their Roof',TGY='Their graveyard',TFLG="Their flag room"}
    }
}
function mod:_WSGCreateFrame(form)
    local spacer=5
    local fc={}
    self:FrameAddHelpButton(form,
    L.CARRIERBUTTONS .. " \n" ..
    AMO_GREEN .. "L-Click:" .. AMO_YELLOW .. L.TARGETCARRIER .. "\n" ..
    AMO_GREEN .. "R-Click:" .. AMO_YELLOW .. L.CARRIERINFO,true)
    fc.r,fc.g,fc.b=self.G:GetFactionColor(self.FF)

    local oc={}
    oc.r,oc.g,oc.b=self.G:GetFactionColor(self.OF)

    local buttons=WSGbuttons
    local col,row,maxrow
    local i=0
    for _,button in pairs(buttons) do
        local r,g,b
        col=button.col
        row=button.row * -1
        if (button.carrier == 'OF') then
            button.color=oc
        elseif (button.carrier =="FF") then
            button.color=fc
        else
            button.color=AMO_Yellow
        end
        r=button.color.r
        g=button.color.g
        b=button.color.b
        maxcol=0
        i=i+1
        local l=self:FrameAddLLabel(form,'Exits' .. i,L[button.desc],col,row)
        l:SetTextColor(r,g,b)
        l.compact=false
        col=col+l:GetWidth()

        for btk,btd in pairs(button.bts) do
            local bt=self:FrameAddButton(form,btk .. i,L[btk],col,row)
            self:TTAdd(bt,L[btd])
            bt:SetScript("OnClick",function() self:_WSGInform(L[button.desc] .. L[btd],button.carrier) end)
            col=col+bt:GetWidth()
            maxcol=max(maxcol,col)
            bt.compact=false
        end
    end
    local b
    row=-150
    b=self:FrameAddUnitButton(form,"ACarrier","No carrier","none",150,row)
    b:ClearAllPoints()
    b:SetPoint("BOTTOMLEFT",form,"BOTTOMLEFT",20,35)
    b:SetScript("PostClick",function(...) self:CarrierClick(...) end)
    b:SetWidth(150)
    b:SetTextColor(AMO_color(AMO_Azure))
    b.faction=FACTION_ALLIANCE
    b.compact=true
    form.Acarrier=b
    --
    b=self:FrameAddUnitButton(form,"HCarrier","No carrier","none",150,row)
    b:ClearAllPoints()
    b:SetPoint("BOTTOMRIGHT",form,"BOTTOMRIGHT",-20,35)
    b:SetScript("PostClick",function(...) self:CarrierClick(...) end)
    b:SetWidth(150)
    b:SetTextColor(AMO_color(AMO_Red))
    b.faction=FACTION_HORDE
    b.compact=true
    form.Hcarrier=b
    row=row-20
    b=self:FrameAddLLabel(form,"ACarrierTime","Carrier debuff status",0,row)
    b:ClearAllPoints()
    b:SetPoint("TOPLEFT",5,row)
    b:SetPoint("RIGHT",form,"CENTER",-5,0)
    b:SetTextColor(G:GetFactionColor(FACTION_ALLIANCE))
    b:SetHeight(40)
    b.compact=false
    form.ACarrierTrack=b
    self:SetClick(b,function(...) self:Inform(...) end)
    b=self:FrameAddRLabel(form,"HCarrierTrack","Carrier debuff status",0,row)
    b:ClearAllPoints()
    b:SetPoint("TOPRIGHT",-5,row)
    b:SetPoint("LEFT",form,"CENTER",5,0)
    b:SetTextColor(G:GetFactionColor(FACTION_HORDE))
    b:SetHeight(40)
    b.compact=false
    self:SetClick(b,function(...) self:Inform(...) end)
    form.HCarrierTrack=b
    row=row-45
    b=self:FrameAddCLabel(form,"DebuffTime","Debuff",0,row)
    self:SetClick(b,function(...) self:Inform(...) end)
    form.DebuffTime=b
    b:ClearAllPoints()
    b:SetPoint("TOPLEFT",5,row)
    b:SetPoint("TOPRIGHT",-5,row)
    return -row,maxcol
end

function mod:_AVCreateFrame(form)
    if (C) then -- Candybar support
        C:RegisterCandyBarGroup(AVB)
        C:SetCandyBarGroupPoint(AVB,"BOTTOMLEFT",AVF,"TOPLEFT",0,1)
        C:SetCandyBarGroupGrowth(AVB,true)
    end
    self:FrameAddHelpButton(form,
    AMO_GREEN .. "L-Click:" .. AMO_YELLOW .. format(L.BGHELP4,L.BGBASE).. "\n" ..
    AMO_GREEN .. "M-Click:" .. AMO_YELLOW .. format(L.BGHELP2,L.BGBASE).. "\n" ..
    AMO_GREEN .. "R-Click:" .. AMO_YELLOW .. format(L.BGHELP1,L.BGBASE).. "\n"..
    AMO_GREEN .. "Sh-L-Click:" .. AMO_YELLOW .. format(L.BGHELP3,L.BGBASE),true)
	form.marks={3,4,19,20,12,17,16,15,11,10,21,6,8,5,22}
    local row,maxcol=self:CreatePoiRow(form,-20)
    row=row-5
    local middle=math.floor(form:GetWidth()/2)
    form.AGEN=self:FrameAddLLabel(form,"AGEN",middle-10,5,row)
    form.AGEN:EnableMouse(true)
    self:SetClick(form.AGEN,function(...) self:Inform(...) end)
    form.HGEN=self:FrameAddRLabel(form,"HGEN",middle-10,middle+5,row)
    form.HGEN:EnableMouse(true)
    self:SetClick(form.HGEN,function(...) self:Inform(...) end)
    AlarAVHelperHGEN:SetFormattedText(ShortHGen,100)
    AlarAVHelperAGEN:SetFormattedText(ShortAGen,100)
    form.AGEN:SetTextColor(self:SplitColor(AMO_Azure))
    form.HGEN:SetTextColor(self:SplitColor(AMO_Red))
    self:FrameRIGHT(form.HGEN,true)
    b=self:FrameAddButton(form,"AllyTimers",L.SPAMALLYTIMERS,10,row)
    b:ClearAllPoints()
    b:SetPoint("BOTTOMLEFT", 10,30)
    b:SetScript("OnClick",function(...) self:TimeToCapAll(FACTION_ALLIANCE) end)
    b=self:FrameAddButton(form,"HordeTimers",L.SPAMHORDETIMERS,10,row)
    b:ClearAllPoints()
    b:SetPoint("BOTTOMRIGHT", -10,30)
    b:SetScript("OnClick",function(...) self:TimeToCapAll(FACTION_HORDE) end)
    local c=self:FrameAddPanel(form,"Commander",'bottom')
    local column
    local rox=0
    self:FrameAddTitle(c,"Commanders","Commanders",0,0)
    local tt={
        WINGCOMMANDERSLIDORE="SOLDIERSMEDAL",
        WINGCOMMANDERGUSE="SOLDIERSFLESH",
        WINGCOMMANDERVIPORE="LIEUTENANTSMEDAL",
        WINGCOMMANDERJEZTOR="LIEUTENANTSFLESH",
        WINGCOMMANDERICHMAN="COMMANDERSMEDAL",
        WINGCOMMANDERMULVERICK="COMMANDERSFLESH",
    }
    local i=1
    for m,n in pairs(tt) do
        local j=math.floor(math.fmod(i,2))
        rox=rox - 20 * j
        if (j==0) then
            column=middle
            l=self:FrameAddRLabel(c,m,n,column,rox)
        else
            column=10
            l=self:FrameAddLLabel(c,m,n,column,rox)
        end
        local commander=L[m]
        commander=commander:gsub(L.WINGCOMMANDER,'')
        l:SetText(commander)
        l:SetWidth(middle*0.9)
        self:TTAdd(l:GetName(),commander .. ' ' .. L.WANTS .. ' ' ..  AMO_ORANGE .. L[n])
        i=i+1
    end
    if (not self:GetToggle("AVC")) then
        c:Hide()
    end
    row=row+35
    return -row,max(205,maxcol)
end
function mod:_ABCreateFrame(form)
    if (C) then -- Candybar support
        C:RegisterCandyBarGroup(ABB)
        C:SetCandyBarGroupPoint(ABB,"BOTTOMLEFT",ABF,"TOPLEFT",0,1)
        C:SetCandyBarGroupGrowth(ABB,true)
    end
    self:FrameAddHelpButton(form,
    AMO_GREEN .. "L-Click:" .. AMO_YELLOW .. format(L.BGHELP4,L.BGBASE).. "\n" ..
    AMO_GREEN .. "M-Click:" .. AMO_YELLOW .. format(L.BGHELP2,L.BGBASE).. "\n" ..
    AMO_GREEN .. "R-Click:" .. AMO_YELLOW .. format(L.BGHELP1,L.BGBASE).. "\n"..
    AMO_GREEN .. "Sh-L-Click:" .. AMO_YELLOW .. format(L.BGHELP3,L.BGBASE),true)
    self:Debug("_ABCreateFrame - Rows")
    local row,maxcol=self:CreatePoiRow(form,-20)
	form:SetWidth(220)
    local middle=floor(form:GetWidth()/2) +5
    l=self:FrameAddTitle(form,"Base",L.DATAWAITING,10,row )
    l:EnableMouse(true)
    l:SetScript("OnMouseUp",function(...) self:Inform(...) end)
    row=row - 40
    local ico
    local l
    ico=self:FrameAddIcon(form,"AllyFinal","interface\\minimap\\poiicons",10,row-10)
    self:SetPoiiOffset(ico,46)
    l=self:FrameAddRLabel(form,"AllyFinal","00000",10+20,row)
    l:SetText("0")
    --
    ico=self:FrameAddIcon(form,"HordeFinal","interface\\minimap\\poiicons",middle,row-10)
    self:SetPoiiOffset(ico,48)
    l=self:FrameAddRLabel(form,"HordeFinal","00000",middle+20,row)
    l:SetText("0")
    row=row -20
    l=self:FrameAddTitle(form,"Status",L.DATAWAITING,0,row)
    l:EnableMouse(true)
    l:SetScript("OnMouseUp",function(...) self:Inform(...) end)
    row=row -20
    return -row,maxcol
end
function mod:CreatePoiRow(frame,row,notimer)
    row=row-10
    local cl1=10
    local cl2=30
    local cl3=0
    self:Trace(frame.marks)
    self:Trace("CurrentBg",CurrentBg)
    local pname=frame:GetName()
	for _,i in ipairs(frame.marks) do
    	local name, description, typ, x, y = GetMapLandmarkInfo(i)
    	points[CurrentBg][i]={x=x,y=y}
    	if (name) then
    	   -- Creating a frame to contain data
    	   local riga=CreateFrame("Frame",pname .. "row" ..i,frame)
    	   riga:SetID(i)
    	   riga:ClearAllPoints()
    	   riga:SetPoint("TOPLEFT",5,row)
    	   riga:SetPoint("TOPRIGHT",-5,row)
    	   riga:Show()
    	   riga:SetHeight(20)
            -- icon
            local t=self:FrameAddIcon(riga,i,"interface\\minimap\\poiicons",0,0)
            t.longname=name
            t.node=i
            frame.poi[i]=t
            self:SetPoiiOffset(t,typ)
            t:ClearAllPoints()
            t:SetPoint("LEFT")
            -- description
            local f=self:FrameAddLLabel(riga,"Name" .. i,name,0,0)
            cl3=max(cl3,f:GetWidth()+cl2)
            f.node=i
            f.longname=name
            f:EnableMouse(true)
            self:SetClick(f,function(...) self:Help(...) end)
            frame.label[i]=f
            f:ClearAllPoints()
            f:SetPoint("LEFT",t,"RIGHT",5,0)
            -- timer
            if (not notimer) then
                local tl=self:FrameAddRLabel(riga,"TimeLeft" .. i,"00:00",0,0)
                tl.longname=name
                tl.node=i
                tl:EnableMouse(true)
                --tl:SetScript("OnMouseUp",function(...) self:TimeToCap(...) end)
                self:SetClick(tl,function(...) self:TimeToCap(...) end)
                frame.timer[i]=tl
                tl:ClearAllPoints()
                tl:SetPoint("RIGHT")
                f:SetPoint("RIGHT",tl,"LEFT",-5,0)
            else
                f:SetPoint("RIGHT",riga,"RIGHT",-5,0)
            end
            row=row-20
        end
    end
    if (notimer) then
        return row,cl3+10
    else
        return row,cl3+10+40
    end
end
function mod:ScanPoiRows(form,clear)
    if (not form) then
        return
    end
    mylocation=nil
	for row,i in ipairs(form.marks) do
        local point=form.poi[i]
        if (point) then
            local label=form.label[i].Label
            local InConflict=false
            local c=AMO_Azure
        	local name, description, typ, x, y = GetMapLandmarkInfo(i)
            local tc1,tc2,tc3,tc4=self:GetTexCoord(typ)
            if (name) then
                if (form.Dirty) then
                    label:SetText(name)
                end
                InConflict=G:IsInConflict(i)
                point:SetTexCoord(tc1,tc2,tc3,tc4)
                if (name == GetMinimapZoneText()) then
                    self:SetColor(label,AMO_White)
                    mylocation=name
                elseif (self:GetUnitDistance(x,y,'player') < ABH_RANGE) then
                    point.Tooltip="Distance: " .. AMO:GetUnitDistance(x,y)
                    self:SetColor(label,AMO_White)
                    mylocation=name
                elseif (G:IsDestroyed(i)) then
                        self:SetColor(label,AMO_Gray)
                elseif (InConflict) then
                    InConflict=true
                    local faction=G:GetAttacker(i)
                    if (faction==FACTION_HORDE) then
                        self:SetColor(label,AMO_Red)
                        c=AMO_Red
                    else
                        self:SetColor(label,AMO_Azure)
                        c=AMO_Azure
                    end
                else
                    self:SetColor(label,AMO_Yellow)
                end
            end
            if (form.timer[i]) then
                local tt=0
                tt=G:GetTimeToCapture(i) or 0
                if (clear) then tt=0 end
                if (C and CurrentBars and name) then
                    if (InConflict) then
                        if (not C:IsCandyBarRegistered(name)) then
                            C:RegisterCandyBar(name,CurrentDuration + 2.5,name,nil,c.r,c.g,c.b)
                            C:RegisterCandyBarWithGroup(name,CurrentGroup)
                            C:StartCandyBar(name,true)
                            C:UpdateCandyBarGroup(CurrentGroup)
                            C:SetCandyBarOnClick(name,function(...) self:TimeToCapAll() end)
                            C:SetCandyBarTimeLeft(name,tt+2.5)
                        end
                        C:SetCandyBarIcon(name,point:GetTexture(),tc1,tc2,tc3,tc4)
                    end
                    if (tt==0) then
                        C:SetCandyBarTimeLeft(name,tt)
                    end
                end
                if (tt <0) then tt = 0 end
                form.timer[i]:SetText(self:TimeToStr(tt))
            end
        end
    end
end

function mod:Initialize()
    self.pgcache=pgcache
    self.healedyou=healedyou
    self.healedyoufor=healedyoufor
    myname=self:Me()
	DeleteMacro("ABH_ATarget")
	DeleteMacro("ABH_HTarget")
    G=AceLibrary("Glory-2.0")
    AceEvent=AceLibrary("AceEvent-2.0")
-- AV German workaround
if (GetLocale() == "deDE") then
function G:NodeToPOI(node)
	if type(node) == "number" then return node end
	if type(node) == "string" then
        if (node:lower() == "\195\182stliche frostwolfturm") then return 5 end
        if (node:lower() == "westliche frostwolfturm") then return 22 end
		for i = 1, GetNumMapLandmarks() do
			if node:lower() == GetMapLandmarkInfo(i):lower() then return i end
		end
	end
end
end
    
    if (AceLibrary:HasInstance("CandyBar-2.0")) then
        C=AceLibrary:GetInstance("CandyBar-2.0")
    else
        self:Notify("CandyBar missing. Install it if you want graphical timers in AlarBGHelper")
    end
    self:RegisterEvent("Glory_AllianceFlagCaptured","FlagEvent")
    self:RegisterEvent("Glory_AllianceFlagPickedUp", "FlagEvent")
    self:RegisterEvent("Glory_AllianceFlagDropped", "FlagEvent")
    self:RegisterEvent("Glory_AllianceFlagCarrierUpdate", "FlagEvent")
    self:RegisterEvent("Glory_HordeFlagCarrierUpdate","FlagEvent")
    self:RegisterEvent("Glory_HordeFlagCaptured", "FlagEvent")
    self:RegisterEvent("Glory_HordeFlagDropped", "FlagEvent")
    self:RegisterEvent("Glory_HordeFlagPickedUp", "FlagEvent")
    self:RegisterEvent("Glory_FriendlyFlagCarrierUpdate","FlagEvent")
    self:RegisterEvent("Glory_HostileFlagCarrierUpdate","FlagEvent")
    self:RegisterEvent("Glory_FriendlyFlagDropped", "FlagEvent")
    self:RegisterEvent("Glory_HostileFlagDropped", "FlagEvent")
    self:RegisterEvent("ABH_FlagReset", "FlagReset")
    self.BGSHORTCUTS={
        AB=G:GetBGAcronym(self.AB),
        WSG=G:GetBGAcronym(self.WSG),
        AV=G:GetBGAcronym(self.AV),
        EOS=G:GetBGAcronym(self.EOS),
    }
    _,self.MyFaction=UnitFactionGroup('player')
    if (self.MyFaction == FACTION_ALLIANCE) then
        self.FF=FACTION_ALLIANCE
        self.OF=FACTION_HORDE
    else
        self.OF=FACTION_ALLIANCE
        self.FF=FACTION_HORDE
    end
    self.G=G
	local default=not ICU_VERSION
	self:CreateBoolean("AUTOREL",true)
	local autorel=self:GetToggle("AUTOREL")
--===DOCBEGIN===
	self:AddLabel("General","",AMO_Green)
    self:AddToggle("AUTOLEAVE",true,"Alt-Click on hide button in battlefield alert leaves the queue")
	self:AddToggle("THANKYOU",false,"Thanks people who heal you","Incourage people to heal in battlegrounds..... thank them! (It doesnt thank the same one more than once ever 2 minutes)")
	self:AddToggle("SELFONLY",false,"Show messages ONLY in your console","If you like to experiment with the various messages without spamming your bg")
    self:AddToggle("ONSCREEN",true,"Show bg related messages on screen","Bg related messages are shown in a fading on screen frame")
	self:AddToggle("SYNC",true,AMO_RED.. "EXPERIMENTAL" .. AMO_ENDCOLOR .. " Synchronize timers with other ABH users","Disable this if you experiences lag.")
	self:AddToggle("FASTJOIN",true,"Fast join bg","Automatically joins first available bg when bg selection window appears. Join as a group if grouped")
	self:AddToggle("WITHBANK",true,"Count banked marks","When showing owned Honor Marks include bank")
    self:AddToggle("GUESSER",true,"Scan raid for information about enemies","Runs a background scanner. Should not impact on performance but you can disable it")
	self:AddToggle("MMAP",default,"Colorize minimap tooltip and gives info","If enabled, when overing on a minimap tooltip you get it colored according to faction and get class and race")

    self:AddLabel(L.AB,L.AB .. " Related options",AMO_Green)
	self:AddToggle("AB",true,"Enable")
	self:AddToggle("ABSPAM",false,"Spam your life status")
	self:AddToggle("ABAUTOREL",autorel,"Autorelease","Enables autoreleasing in battlegrounds")
	self:AddSlider("ABSPAMTHRESHOLD",20,10,80,"Life percentage","Under this life percentage you will start asking for help")
	self:AddToggle("ABBARS",true,"Show status bars for contested nodes","Show a progress bar for contested nodes")
	--self:AddSlider("ABdeath",30,20,40,"Resurrection timer interval")

    self:AddLabel(L.WSG,L.WSG .. " Related options",AMO_Green)
	self:AddToggle("WSG",true,"Enable")
	self:AddToggle("WSGSPAM",false,"Spam your life status")
	self:AddToggle("WSGNOTIFY",true,"Carrier notificaton","Automatically inform raid when you target enemy flag carrier. Should not become spammy but test it")
	self:AddToggle("WSGAUTOREL",autorel,"Autorelease","Enables autoreleasing in battlegrounds")
	self:AddSlider("WSGSPAMTHRESHOLD",20,10,80,"Life percentage","Under this life percentage you will start asking for help")
	self:AddToggle("WGB",true,"Show warning buttons","Displays the full panel with buttons for tactics")
	self:AddLabel(L.WSG .. " Customization (reloadui needed)","Change " .. L.WSG .. " appearence to suit your tastes.\nYou need to /rl to see changes.")
    self:AddSubLabel("Messages","You can customize " .. L.WSG .. " appeareance, changing messages.\n"..AMO_GREEN .. "Remember to press enter to save your changes.",AMO_Green)
    --
--===DOCEND===
    for _,button in pairs(WSGbuttons) do
    
        self:AddEdit('K_' .. button.desc,button.desc,button.desc,"Change messages for : " .. button.desc)
    end
    self:AddSubLabel("Buttons and locations","You can customize " .. L.WSG .. "appeareance, changing buttons and locations names.\n"..AMO_GREEN .."Remember to press enter to save your changes",AMO_Green)
    for _,button in pairs(WSGbuttons) do
        for btk,btd in pairs(button.bts) do
            self:AddEdit('K_' .. btk,btk,btk .. ": Button text","The text you see on the button")
            self:AddEdit('K_' .. btd,btd,btk .. ": Button message","The text you send when you click on the button")
        end
    end
    --
--===DOCBEGIN===
-- AV
    self:AddLabel(L.AV,L.AV .. " Related options",AMO_Green)
	self:AddToggle("AV",true,"Enable")
	self:AddToggle("AVSPAM",false,"Spam your life status")
	self:AddToggle("AVAUTOREL",autorel,"Autorelease","Enables autoreleasing in battlegrounds")
	self:AddSlider("AVSPAMTHRESHOLD",20,10,80,"Life percentage","Under this life percentage you will start asking for help")
	self:AddToggle("AVBARS",true,"Show status bars for contested nodes","Show a progress bar for contested nodes")
	self:AddToggle("AVC",true,"Show commanders info","If enabled, ABH will track commanders' status")
	self:AddToggle("AVTURNIN",true,"Auto turn in","If enabled, automatically turns in items for av quests")
    self:AddLabel(L.EOS,L.EOS .. " Related options",AMO_Green)
	self:AddToggle("EOS",true,"Enable")
	self:AddToggle("EOSSPAM",false,"Spam your life status")
	self:AddToggle("EOSAUTOREL",autorel,"Autorelease","Enables autoreleasing in battlegrounds")
	self:AddSlider("EOSSPAMTHRESHOLD",20,10,80,"Life percentage","Under this life percentage you will start asking for help")
--===DOCEND===
    help(self)
    for _,s in pairs({L.AV_START,L.AB_START,L.WSG_START,L.EOS_START}) do
        startmessages=startmessages .. "-" .. s
    end
    startmessages=strupper(startmessages)
    ShortAGen=L.AGEN:sub(1,10) .. " : %d%%"
    ShortHGen=L.HGEN:sub(1,10) .. " : %d%%"
    self:CoroutineCreate("INFOBG","GetInfoBg",0.1,true)
    -- Ace Events
    self:RegisterEvent("VCHECK","AceVCHECK")
end
function mod:AceVCHECK()
    local com=AceLibrary("AceComm-2.0")
    com:QueryAddonVersion("AlarBGHelper","GROUP")
end
function mod:Enable(first)
    --self:ScanForMarks()
    if (first) then
    	if (TitanSetVar) then
            vC=AMO.Myunique
            self:Printf("%s%s: Titan support enabled",AMO_YELLOW,"AlarBGHelper")
            TitanSetVar(TITAN_AV_ID,"AV Enabled",self:GetToggle("AV"))
            TitanSetVar(TITAN_AB_ID,"AB Enabled",self:GetToggle("AB"))
            TitanSetVar(TITAN_WSG_ID,"WSG Enabled",self:GetToggle("WSG"))
            TitanSetVar(TITAN_EOS_ID,"EOS Enabled",self:GetToggle("EOS"))
            self:ScheduleRepeatingEvent(ABH_TitanSync,1)            
        end
        if (ABHFU) then
            self:InjectConfig(ABHFU.OnMenuRequest)
        end
        self:EvtZONE_CHANGED_NEW_AREA()
    end

end
function mod:FlagEvent(...)
    local event=AceEvent.currentEvent
    event=event:sub(7)
    if (ALARDEVELOPMENTPC) then self:Print(event,...) end
    if (self[event]) then
        self[event](self,...)
    end
end
function mod:FriendlyFlagCarrierUpdate(carrier)
    if (myname==carrier) then
        IsCarrier=true
        if (C) then
            C:RegisterCandyBar("CarrierTrack",45 + 2.5,L.WSGTRACKME,nil,1,0,0)
            C:SetCandyBarPoint("CarrierTrack","BOTTOMLEFT",AlarWSGHelper,"TOPLEFT",0,5)
            C:StartCandyBar("CarrierTrack",true)
        end
    else
        IsCarrier=false
        if (C) then
            if (C:IsCandyBarRegistered("CarrierTrack")) then
                C:UnregisterCandyBar("CarrierTrack")
            end
        end
    end
end
function mod:FriendlyFlagDropped(carrier)
    if (wsgnotify and G:GetFriendlyFlagCarrier()) then
        self:Message(L.WSGDROPPED)
    end
end
function mod:FlagReset()
    self.HTrack=nil
    self.ATrack=nil
    wsgtimer=time()
    CheckDebuff()
end
function mod:HordeFlagCaptured()
    wsgtimer=nil
    self:ScheduleEvent("ABH_FlagReset",25)
    if (C) then
        C:RegisterCandyBar("FlagRespawn",25,L.FLAGRESPAWN,nil,0,0.5,1)
        C:SetCandyBarPoint("FlagRespawn","BOTTOMLEFT",AlarWSGHelper,"TOPLEFT",0,5)
        C:StartCandyBar("FlagRespawn",true)
    end
    
    self.HTrack=nil
    self.ATrack=nil
    CheckDebuff()
    
end
function mod:HordeFlagPickedUp(carrier)
    self.ATrack=time()
end
function mod:HordeFlagDropped(carrier)
    self.ATrack=nil
    ShowTimers(nil,nil,time(),nil,CurrentForm.ACarrierTrack)    
end

function mod:AllianceFlagCaptured()
    self:HordeFlagCaptured()
end
function mod:AllianceFlagPickedUp(carrier)
    self.HTrack=time()
end
function mod:AllianceFlagDropped(carrier)
    self.HTrack=nil
    ShowTimers(nil,nil,time(),nil,CurrentForm.HCarrierTrack)    
end
function mod:Disable()
    self:RemoveAllScheduledEvents()
end
function mod:SpamGenLife(life,levels,boss,method)
    self:argCheck(life,1,"number")
    self:argCheck(levels,2,"table")
    self:argCheck(boss,3,"string")
    self:argCheck(method,4,"string")
    local step=math.floor(life/5)
    local msg=false
    for i=1,19 do
        if (life <=( i*5)) then
            if (not levels[i]) then
                levels[i]=true
                msg=life .. "%"
            end
            break
        end
    end
    if (msg) then
        self[method](self,boss .. " status: " .. msg)
    end
end
function mod:AGen(life)
    if (life == 100) then
        AV_ALevels={}
    else
        self:SpamGenLife(life,AV_ALevels,L.AGEN,"Onscreen_Red")
    end
    self:Trace(CurrentForm,'AGEN',life)
    if (CurrentForm and CurrentForm.AGEN) then
        CurrentForm.AGEN:SetFormattedText(ShortAgen,self.AGEN)
    end
end
function mod:HGen(life)
    if (life == 100) then
        AV_HLevels={}
    else
        self:SpamGenLife(life,AV_HLevels,L.HGEN,"Onscreen_Azure")
    end
    self:Trace(CurrentForm,'HGEN',life)

    if (CurrentForm and CurrentForm.HGEN) then
        CurrentForm.HGEN:SetFormattedText(ShortHGen, self.HGEN)
    end
end
-------- Events
function mod:EvtRAID_ROSTER_UPDATE()
    RequestBattlefieldScoreData()
    self:RescheduleEvent("VCHECK",5)
end

function mod:GetInfoBg(ascoroutine)
    local BossTest
    function BossTest(self,pg,ph,boss)
        local agen=L.AGEN
        local hgen=L.HGEN
        if (pg and pg == boss) then
            if (boss==agen) then
                self.AGEN_OLD=self.AGEN
                self.AGEN=ph
            else
                self.HGEN_OLD=self.HGEN
                self.HGEN=ph
            end
            self.pgcache[pg][pgcachekeys.updated]=math.floor(GetTime())
            self.pgcache[pg][pgcachekeys.health]=ph
        end
    end
    local agen=L.AGEN
    local hgen=L.HGEN
    local doAgen=false
    local doHgen=false
    while true do
        if (ABHFU) then
            ABHFU.colast=GetTime()
        end
        if (UnitName("target") == agen) then
            BossTest(self,agen,self:Health("target"),agen)
            doAgen=false
        else
            doAgen=true
        end
        if (UnitName("target") == hgen) then
            BossTest(self,hgen,self:Health("target"),hgen)
            doHgen=false
        else
            doHgen=true
        end
        local l=GetNumRaidMembers()
        local safe=false
        for i=1,l do
            local pg,ph
            local px = UnitName("raid" ..i)
            pg =UnitName("raid" .. i .. "target")
            ph=self:Health("raid" .. i .. "target")
            if (pg) then
                self.pgcache[pg][pgcachekeys.updated]=math.floor(GetTime())
                self.pgcache[pg][pgcachekeys.health]=ph
            end
            if (CurrentBg=="AV") then
                BossTest(self,pg,ph)
            end
            ph=self:Health("raid" .. i)
            if (px) then
                self.pgcache[px][pgcachekeys.updated]=math.floor(GetTime())
                self.pgcache[px][pgcachekeys.health]=ph
            end
            if (CurrentBg == "AV") then
                pg=UnitName("raid" .. i .. "targettarget")
                ph=self:Health("raid" .. i)
                if (CurrentBg=="AV") then
                    if (doAgen) then BossTest(self,pg,ph,agen) end
                    if (doHgen) then BossTest(self,pg,ph,hgen) end
                end
            end
            if (ascoroutine) then
                collectgarbage("step")
                if (coroutine.yield()) then return end
            end
            safe=true
        end
        if (not ascoroutine) then
            break
        elseif (not safe) then
            if (coroutine.yield) then return end
        end
    end
    self:Trace("I should not be here")
    self:TraceLiteral(debugstack())
end
function mod:GetInfo(debug)
    for i = 1,GetNumBattlefieldScores() do
        self.pgcache[i]={GetBattlefieldScore(i)}
    end
end
function mod:EvtPLAYER_REGEN_ENABLED()
    dontspam=false
end
function mod:EvtCHAT_MSG_MONSTER_YELL(arg1,arg2,arg3,arg4)
    self:ChatEvent('MONSTER',arg1)
    self:Debug('MONSTER_YELL',arg1,arg2,arg3,arg4)
    -- Only used in AV
    if (arg2 == L.HERALD) then
        if (arg1:find(FACTION_ALLIANCE))then
            self:Onscreen_Azure(arg1)
        elseif (arg1:find(FACTION_HORDE))then
            self:Onscreen_Red(arg1)
        end
        return
    end
    for commander,faction in pairs(self.COMMANDERS) do

        if (arg2 == commander) then
            if (faction == "A") then
                self:Onscreen_Azure(arg1)
            elseif (faction == "H") then
                self:Onscreen_Red(arg1)
            end
            PlaySoundFile("Sound\\Spells\\PVPFlagTaken")
            return
        end
    end
end
function mod:EvtPLAYER_UNGHOST()
    if (CurrentBg == "none") then
        return
    end
    self.lastress=time()
end
-- Local Function

function mod:CmxList()
    for i,l in self.G:IterateObjectiveNodes() do
        self:PrintLiteral(i,l)
    end
end
function mod:CmxLists()
    for i,l in self.G:IterateSortedObjectiveNodes() do
        self:PrintLiteral(i,l)
    end
end

function mod:CmdShow()
    if (CurrentForm) then
        CurrentForm:Show()
        CurrentForm:SetHeight(250)
    end
end
function mod:ApplyWSGNOTIFY(value)
    wsgnotify=value
end
function mod:ApplyTHANKYOU(value)
    thankyou=value
end
function mod:ApplyAUTOLEAVE(valore)
    local popup=StaticPopupDialogs["CONFIRM_BATTLEFIELD_ENTRY"]
    if (valore) then
        popup.OnCancel=
            function(data,event)
                if (event == "clicked") then
                    if (IsAltKeyDown()) then
                        mod:LeaveQueue(data)
                        mod:Print(L.YOULEFTQUEUE)
                    end
                end
            end
        popup.OnUpdate=
            function(elapsed,dialog)
            	local button2 = getglobal(dialog:GetName().."Button2");
                if (IsAltKeyDown()) then
                    button2:SetText(LEAVE_QUEUE)
                else
                    button2:SetText(HIDE)
                end
            end
    else
        popup.OnCancel=nil
        popup.OnUpdate=nil
        popup.button2=HIDE
    end

end

function mod:ApplyAVC(value)
    local c=getglobal(AVF .. "Commander")
    if (c) then
        if (value) then
            c:Show()
        else
            c:Hide()
        end
    end
end
function mod:ApplyWGB(value)
    if (AlarWSGHelper) then
        AlarWSGHelper.IsCompact=not value
        for _,f in pairs({AlarWSGHelper:GetChildren()}) do
            if (not f.compact) then
                if (value) then f:Show() else f:Hide() end
            end
        end
        local h=90
        if (value) then
            h=310
        end
        AlarWSGHelper:SetHeight(h)
        self:PanelMinSize(AlarWSGHelper,nil,h)
    end
end
function mod:ApplyWITHBANK(value)
    self:ScanForMarks()
end
function mod:ApplyGUESSER(value)
    if (value and self.Active) then
        self:CoroutineStart("INFOBG")
    else
        self:CoroutinePause("INFOBG")
    end
end
function mod:ApplyONSCREEN(value)
    onscreen=value
end
function mod:ApplySYNC(value)
    synchro=value
end
function mod:Apply(key,value)
    if (key == "AV" or key == "AB" or key == "WSG" or key == "EOS") then
        self:EvtZONE_CHANGED_NEW_AREA()
    elseif (key:find('^K_')) then
        self:LocaleReplace(key:sub(3),value)
    end
    self:Init(CurrentBg)
end
function mod:Onscreen_Azure(msg)
return onscreen and AMO.Onscreen_Azure(self,msg)
end
function mod:Onscreen_Red(msg)
return onscreen and AMO.Onscreen_Red(self,msg)
end
function mod:Onscreen_Green(msg)
return onscreen and AMO.Onscreen_Green(self,msg)
end
function mod:Onscreen_Yellow(msg)
return onscreen and AMO.Onscreen_Yellow(self,msg)
end


function mod:EvtZONE_CHANGED_NEW_AREA(...)
    local zone=GetRealZoneText()
    mylocation=nil
    dontspam=nil
    LastBg=CurrentBg
    CurrentBg="none"
    self.Bg=G:GetActiveBattlefieldZone()
    self.Active=true
    if (G:IsInArathiBasin() and self:GetToggle("AB")) then
        CurrentBg="AB"
    elseif (G:IsInAlteracValley() and self:GetToggle("AV")) then
        CurrentBg="AV"
    elseif (G:IsInEyeOfTheStorm() and self:GetToggle("EOS")) then
        CurrentBg="EOS"
    elseif (G:IsInWarsongGulch() and self:GetToggle("WSG")) then
        CurrentBg="WSG"
        if (time()>120 and time() < 720) then
            wsgtimer=120
        end
    else
        self.Active=false
    end
    if (CurrentBg == LastBg) then
        return
    end
    if (CurrentBg ~= LastBg or CurrentBg == "none") then
        if (LastBg == "AB" or LastBg=="AV") then
            self:ScanPoiRows(CurrentForm,true)
            self:ResetBars()
        end
        CurrentForm=nil

        self:Trace("Disabling schedules")
        self:Print("Doing a full garbage collection cycle,please wait")
        for i,v in pairs(self.pgcache) do
            pgcachedata[i]=nil
        end
        for i,v in pairs(self.healedyou) do
            self.healedyou[i]=nil
        end
        for i,v in pairs(self.healedyoufor) do
            self.healedyoufor[i]=nil
        end
        collectgarbage("collect")
        self:Print("Done")
        self:RemoveEvent(localevents)
        self:CancelAllScheduledEvents()
        self:ApplyEvents()
        for _,f in pairs(frames) do
            local form=getglobal(f)
            _=form and form:Hide()
        end
    end
    if (CurrentBg ~= "none") then
        RequestBattlefieldScoreData()
    end
    if (CurrentBg ~= LastBg) then
        self:Init(CurrentBg)
        self:ScanForMarks(1)
    end
end
function mod:Reset()
    self:HordeFlagCaptured()
    self:RemoveEvent(localevents)
    self:CancelAllScheduledEvents()
    self:ApplyEvents()
end
function mod:Init(bg)
    if (bg) then
        CarrierSpotted=0
        onscreen=self:GetToggle("ONSCREEN")
        synchro=self:GetToggle("SYNC")
        CurrentThreshold=self:GetNumber(bg .. "SPAMTHRESHOLD") or 0
        CurrentSpam=self:GetToggle(bg .. "SPAM")
        CurrentBars=self:GetToggle(bg .. "BARS")
        if (bg == "AV") then
            CurrentDuration=240
            CurrentGroup=AVB
        elseif (bg == "AB") then
            CurrentDuration=60
            CurrentGroup=ABB
        else
            CurrentDuration=0
        end
        dontspam=CurrentSpam
        local cb=getglobal((formnames[bg] or '') .. bg .. "SPAM")
        if (cb) then
            local msg=L['TTSPAM'] .. '(' .. CurrentThreshold .. "%)\n" .. AMO_RED .. L['TTSPAMNOTE']
            self:TTAdd(cb,msg)
            self:TTAdd(cb.Checkbox,msg)
            cb.Checkbox:SetChecked(CurrentSpam)
        end
    end

end
function mod:Evt(event,arg1)
    if (event == "RAID_ROSTER_UPDATE" ) then
    end
    local method="_" .. CurrentBg .. "Event"
    local bgfunc=self[method]
    if (type(bgfunc)=="function") then
        bgfunc(self,event,arg1)
    else
        self:EvtZONE_CHANGED_NEW_AREA()
    end
end
function mod:EvtPLAYER_DEAD()
    if (self.Active) then
        if (self:GetToggle(CurrentBg .. "AUTOREL")) then
            if (not soulstoned) then
                RepopMe()
            end
        end
        self:SetVar(CurrentBg .. "SPAM",false)
    end
end
function mod:EvtCHAT_MSG_SPELL_PERIODIC_SELF_BUFFS()
    if (not Active) then
        return
    end
    local kk=self:ScanBuff("player")
    soulstoned=kk[AMO_BUFFID["Soulstone Resurrection"]]
    if (soulstoned) then
        self:Debug("Lucky one, you are soulstoned")
    else
        self:Debug("No soulstone? NO Alpitour? Ahiahiai")
    end
end
function mod:EvtUPDATE_BATTLEFIELD_SCORE(...)
        self:Debug("Starting",CurrentBg,self:TimeToStr(time()))
        self.Bg=G:GetActiveBattlefieldZone()
        CurrentForm=self:_CreateFrame(CurrentBg)
        if (not CurrentForm) then
            RequestBattlefieldScoreData()
            return
        end
        CurrentForm:Show()
        self:EvtCHAT_MSG_SPELL_PERIODIC_SELF_BUFFS()
        self:AddEvent(localevents)
        local method="_" .. CurrentBg .. "Event"
        local bgfunc=self[method]
        if (type(bgfunc)=="function") then
            bgfunc(self,"START",arg1)
        end
        if (not self:IsEventScheduled("INFO")) then
            -- attivazione eventi
            self.Active=true -- Got events running, so I must be active
            self:ApplyEvents()
            self:ScheduleRepeatingEvent("INFO",function() self:GetInfo() end,5)
            self:ScheduleRepeatingEvent("MAIN",function() self:_OnUpdate() end,1)
            self:ScheduleRepeatingEvent("MMAP",function() self:OnUpdate() end,0.1)
            if (self:GetToggle("GUESSER")) then
                self:CoroutineStart("INFOBG")
            end
            if (CurrentBg == "AV") then
                AlarAVHelperHGEN:SetFormattedText(ShortHGen,100)
                AlarAVHelperAGEN:SetFormattedText(ShortAGen,100)
            end

        end

end
function mod:EvtBATTLEFIELDS_SHOW()
    if (self:GetToggle("FASTJOIN")) then
        self:JoinBg()
        self.queued=true
    end
end
function mod:EvtCOMBAT_TEXT_UPDATE(tipo,arg2,arg3)
    if (not self.Active) then return end
    if (tipo == "HEAL" or tipo == "HEAL_CRIT" or tipo == "PERIODIC_HEAL") then
        local who=arg2
        if (who and thankyou and self.pgcache[who]) then
            if (who ~= self:Me() and not UnitIsUnit("playerpet",who)) then
                local amt=arg3 or 0
                self.healedyoufor[who]=self.healedyoufor[who]+amt
                if (GetTime() - self.healedyou[who] > thankspam) then
                    self:Print("%s healed you for %d",who,amt)
                    DoEmote("THANK",who)
                    self.healedyou[who]=GetTime()
                end
            end
        end
    end
end

function mod:EvtBAG_UPDATE()
    if (not self.Active) then
        self:ScanForMarks(2)
    end
end
function mod:EvtUPDATE_BATTLEFIELD_STATUS()
    if (ABHFU) then
        ABHFU:UpdateDisplay()
    end
    if (ABHTITAN) then
        ABHTITAN:UpdateDisplay()
    end
end
function mod:OnGroupReceive(prefix,sender,distribution,bg,command,...)
    self:ComDebug(prefix,sender,distribution,bg,command,...)
    if (bg == 'AV') then
        pcall(self[command],self,...)
    end
end
function mod:CheckBoss()
    if (self.AGEN_OLD and self.AGEN_OLD ~= self.AGEN) then
        self:AGen(self.AGEN or 100)
        self:Trace("Sending AGEN")
        self:Debug("Sending AGEN")
        self:CommSend("BULK","GROUP",'AV','AGen',self.AGEN)
    end
    if (self.HGEN_OLD and self.HGEN_OLD ~= self.HGEN) then
        self:HGen(self.HGEN or 100)
        self:Trace("Sending HGEN")
        self:Debug("Sending HGEN")
        self:CommSend("BULK","GROUP",'AV','HGen',self.HGEN)
    end
end
function mod:GetHealth(pg)
        local cache=self.pgcache
        if  (cache[pg]) then
            local carrier=cache[pg].name
            health=" - " .. (cache[carrier].health or '--') .. "%"
            age=cache[carrier].updated or 0
            age=math.floor(GetTime() - age)
            if (age < 11) then
                age="is " .. age .. " seconds old"
            else
                age="is very old (" .. age .. " seconds)"
            end
        else
            health=""
            age="no data"
        end
        return health,age
end

function ShowTimers(faction,carrier,now,t,obj)
    t=tonumber(t)
    if (t) then
        t=now-t
    end
    if (carrier and obj and t and t<45) then
        obj:SetFormattedText(L.WSGTRACK,faction,carrier,45-t)
    else
        obj:SetText("")
    end
end
function CheckDebuff()
    if (not CurrentForm) then
        return
    end
    local f=tonumber(wsgtimer)
    local obj=CurrentForm.DebuffTime
    if (not obj) then return end
    if (not f ) then
        if (obj) then
            obj:SetText("")
        end
        return 
    end
    f=time() - f
    if (f < 600) then
        obj:SetFormattedText(L.WSGDAMAGE,"50%",ABH:TimeToStr(600-f))
    elseif( f < 900) then
        obj:SetFormattedText(L.WSGDAMAGE,"100%",ABH:TimeToStr(900-f))
    elseif (f < 905) then
        obj:SetText("100% debuff")
    end        
end
function mod:CheckCarrier()
    local carrier = G:GetHostileFlagCarrier()
    local health
    local age
    local adesso=time()
    if (wsgnotify and carrier and UnitName("target") == carrier and time() - CarrierSpotted >30 and CheckInteractDistance("target",4)) then
        CarrierSpotted=time()
        self:Message(format(L.WSGHELPME,carrier))
    end
    if (CurrentForm.Acarrier) then
        carrier=G:GetAllianceFlagCarrier()
        if (carrier) then
            health,age=self:GetHealth(carrier)
            CurrentForm.Acarrier:SetUnit(carrier,health)
            self:TTAdd(CurrentForm.Acarrier,age)
        else
            CurrentForm.Acarrier:SetUnit(L.NOCARRIER,"")
            self:TTAdd(CurrentForm.Acarrier,L.NOCARRIER)
        end
        ShowTimers(FACTION_ALLIANCE,carrier,adesso,self.ATrack,CurrentForm.ACarrierTrack)
    end
    if (CurrentForm.Hcarrier) then
        carrier= G:GetHordeFlagCarrier()
        if (carrier) then
            health,age=self:GetHealth(carrier)
            CurrentForm.Hcarrier:SetUnit(carrier,health)
            self:TTAdd(CurrentForm.Hcarrier,age)
        else
            CurrentForm.Hcarrier:SetUnit(L.NOCARRIER,"")
            self:TTAdd(CurrentForm.Hcarrier,L.NOCARRIER)
        end
        ShowTimers(FACTION_HORDE,carrier,adesso,self.HTrack,CurrentForm.HCarrierTrack)
    end
    CheckDebuff()
end
function mod:ChatEvent(faction,arg1)
    --self:Print(faction,arg1)
    if (not CurrentForm) then return end
--    self:Debug("AC",G:GetAllianceFlagCarrier())
--    self:Debug("HC",G:GetHordeFlagCarrier())
--    self:Debug("AllyTTV",self:TimeToStr(G:GetAllianceTTV()))
--    self:Debug("HordeTTV",self:TimeToStr(G:GetHordeTTV()))
    self:ScheduleEvent(function() self:CheckCarrier() end,2)
end
function mod:EvtCHAT_MSG_BG_SYSTEM_ALLIANCE(arg1)
    self:Onscreen_Azure(arg1)
    self:ScanPoiRows(CurrentForm,true)
    self:ChatEvent(FACTION_ALLIANCE,arg1)
end
function mod:EvtCHAT_MSG_BG_SYSTEM_HORDE(arg1)
    self:Onscreen_Red(arg1)
    self:ScanPoiRows(CurrentForm,true)
    self:ChatEvent(FACTION_HORDE,arg1)
end
function mod:EvtCHAT_MSG_BG_SYSTEM_NEUTRAL(arg1)
    if (string.find(startmessages,strupper(arg1))) then
        self:Onscreen_Yellow("Good Luck!")
        self:TriggerEvent("ABH_FlagReset")
    end
    func="Event" .. CurrentBg
    if (type(self[func])== "function") then
        self[func](self,"CHAT_MSG_BG_SYSTEM_NEUTRAL",arg1)
    end
end

function mod:_AVEvent(event,arg1)
end
function mod:_WSGEvent(event,arg1)
end
function mod:_EOSEvent(event,arg1)
end
function mod:_ABEvent(event,arg1)
end

function ABH_FuSync(arg1)
    ABHFU:UpdateTooltip()
    if (MiniMapBattlefieldFrame.tooltip) then
        ABHFU:UpdateText()
    end
end

function ABH_TitanSync(arg1)
    ABHTITAN:UpdateTooltip()
    if (MiniMapBattlefieldFrame.tooltip) then
        ABHTITAN:UpdateText()
    end
end


function mod:OnUpdate(bg)
    if (not self.Active) then
        return
    else
    	if( self:GetToggle("MMAP") and GetMouseFocus() ) then
    	   if(MouseIsOver(Minimap)and GetMouseFocus():GetName()=="Minimap") then
            local tt=GameTooltipTextLeft1:GetText()
        		if (tt) then
        			GameTooltipTextLeft1:SetText(self:ReformatMMTooltip(tt));
        			GameTooltip:Show();
        		end
            end
    	end
	end

end
function mod:_OnUpdate()
    if (CurrentForm) then
        self:SpamIfNeeded(CurrentBg)
        CurrentForm.title:SetText(tostring(self.Bg) .. ' ' .. self:TimeToStr(time()-120))
        self:ScanPoiRows(CurrentForm,false)
        if (CurrentBg == "AB") then
            self:_ABPrediction()
        elseif (CurrentBg== "EOS") then
            self:_EOSPrediction()
            self:CheckCarrier()
        elseif (CurrentBg=="WSG") then
            self:CheckCarrier()
        elseif (CurrentBg == "AV") then
            self:CheckBoss()
        end
    end
end
local almostzero=0.00000000000000000000001
mod.EOSDATA={
    rates={
        almostzero, -- 0
        1/2, -- 1
        2.5/2, -- 2
        5/2, -- 3
        10/2 --4
    },
    flags={
        almostzero, -- 0
        75, -- 1
        85, -- 2
        100, -- 3
        500, -- 4
    }
}
mod.RESPATTERN="(%d+)%D*(%d+)/(%d+)"
function mod:_EOSPrediction()
	local estimatedTime, needed;
    local _,_,ally=GetWorldStateUIInfo(2)
    local _,_,horde=GetWorldStateUIInfo(3)
    local strAllyBases,strAllyScore, strHordeBases, strHordeScore,final
    if (horde and ally) then
    	_, _, strAllyBases, strAllyScore,final = ally:find(self.RESPATTERN)
    	_, _, strHordeBases, strHordeScore,final = horde:find(self.RESPATTERN)
    end
    final = tonumber(final) or 2000
	local allyBases = tonumber(strAllyBases) or 0;
	local hordeBases = tonumber(strHordeBases) or 0;
	local allyScore = tonumber(strAllyScore) or 0;
	local hordeScore = tonumber(strHordeScore) or 0;
	local allyRate=self.EOSDATA.rates[allyBases+1]
	local hordeRate=self.EOSDATA.rates[hordeBases+1]
	local allyFlag=self.EOSDATA.flags[allyBases+1] 
	local hordeFlag=self.EOSDATA.flags[hordeBases+1]
    local allySecs=math.floor((final-allyScore)/allyRate) or -1
    local hordeSecs=math.floor((final-hordeScore)/hordeRate) or -1
    local timeLeft=hordeSecs
    if (allySecs <hordeSecs) then
        timeLeft=allySecs
    end
    if (allySecs < 0 or hordeSecs < 0 ) then
        AlarEOSHelperStatusLabel:SetText(L.BGNODATA)
    elseif (allySecs > hordeSecs) then
        AlarEOSHelperStatusLabel:SetFormattedText(L.BGHORDEWINS,self:TimeToStr(timeLeft))
    elseif (allySecs < hordeSecs) then
        AlarEOSHelperStatusLabel:SetFormattedText(L.BGALLYWINS,self:TimeToStr(timeLeft))
    else
        AlarEOSHelperStatusLabel:SetText(L.BGNONEWINS)
    end
    local nFlag=L.EOSNEED1
    local n,m,t,delta
    local f=L.EOSNEED2
    local allyFinal=math.min(allyRate * timeLeft + allyScore,final)
    local hordeFinal=math.min(hordeRate * timeLeft + hordeScore,final)
    if (allyFinal > hordeFinal and hordeBases > 0) then -- Ally wins
        delta=(allyFinal - hordeFinal)+1
        n=math.ceil(delta/hordeFlag)
        nFlag=f:format(FACTION_HORDE,n,FACTION_ALLIANCE)
    elseif  (hordeFinal > allyFinal and allyBases > 0) then -- Horde Wins
        delta=(hordeFinal - allyFinal)+1
        n=math.ceil(delta/hordeFlag)
        nFlag=f:format(FACTION_ALLIANCE,n,FACTION_HORDE)
    elseif (allyFinal == hordeFinal) then
        nFlag=L.EOSNEED3
    elseif (allyFinal > hordeFinal ) then -- Ally wins
        nFlag=nFlag:format(FACTION_HORDE)
    elseif (allyFinal < hordeFinal ) then -- Horde wins
        nFlag=nFlag:format(FACTION_ALLIANCE)
    end
    AlarEOSHelperStatus2Label:SetText(nFlag)
    if (tonumber(delta) and tonumber(timeLeft)) then
        AlarEOSHelperStatus3Label:SetFormattedText(L.EOSNEED4,math.floor(timeLeft/n))
    else
        AlarEOSHelperStatus3Label:SetText("")
    end
    AlarEOSHelperAFlag:SetFormattedText("%s: %3d",L.BGFLAG,allyFlag or 0)
    AlarEOSHelperHFlag:SetFormattedText("%s: %3d",L.BGFLAG,hordeFlag or 0)
    AlarEOSHelperAllyFinal:SetFormattedText("%4d",allyFinal or 0)
    AlarEOSHelperHordeFinal:SetFormattedText("%4d",hordeFinal or 0)

end

function mod:_ABPrediction()
    local estimatedAlly, estimatedHorde, needed, estimatedTime = self:_ABGetData();
    local commento=""
	--SetMyBase()
	AlarABHelperAllyFinalLabel:SetText(estimatedAlly)
	AlarABHelperHordeFinalLabel:SetText(estimatedHorde)
	displayTime=tonumber(displayTime) or 0
	if (not estimatedTime) then
        estimatedTime=60*30
        lstestimatedTime=60*35
    end
    if (estimatedTime == lstestimatedTime) then
        displayTime=displayTime-1
    else
        lstestimatedTime=estimatedTime
        displayTime=estimatedTime
    end
    if (type(estimatedTime)== "number" and estimatedTime > 0) then
        needed=tonumber(needed)
        if (estimatedHorde > estimatedAlly) then
    	   AlarABHelperStatusLabel:SetFormattedText(L.BGHORDEWINS, self:TimeToStr(displayTime))
    	elseif (estimatedHorde < estimatedAlly) then
    	   AlarABHelperStatusLabel:SetFormattedText(L.BGALLYWINS, self:TimeToStr(displayTime))
        else
    	   AlarABHelperStatusLabel:SetText(L.BGNONEWINS)
    	end
    	local formato
    	if (needed <3 ) then
            formato = L.ABNEED1
        elseif (needed == 3) then
            formato=L.ABNEED2
        elseif (needed >3) then
            formato = L.ABNEED3
        end
        if (needed <= hold) then
            formato=L.ABNEED4
        end
        AlarABHelperBaseLabel:SetFormattedText(formato,needed)

    end
end
function mod:SpamIfNeeded()
	if (CurrentSpam) then
        local life=self:Health('player') or 100
        if (life < CurrentThreshold or self:IsDebugging()) then
    		if (not dontspam and InCombatLockdown()) then
                self:Message(format(L.BGENEMIESAT,mylocation or "me"))
    			dontspam=true
    		end
		end
	end
end
mod.rates	=
	{
		[0] = { time = 0, rate = 999999 },
		[1] = { time = 11, rate = 1.1 },
		[2] = { time = 10, rate = 1 },
		[3] = { time = 6, rate = 0.6 },
		[4] = { time = 3, rate = 0.3 },
		[5] = { time = 1, rate = 0.03333 }
	}
-------

function mod:_ABGetData()
-- Examine data for Arathi Basin
	local estimatedTime, needed;
    local _,_,ally=GetWorldStateUIInfo(1)
    local _,_,horde=GetWorldStateUIInfo(2)
    local rates=self.rates
    local strAllyBases,strAllyScore, strHordeBases, strHordeScore,final
    if (horde and ally) then
    	-- _, _, strAllyBases, strAllyScore = string.find(ally, "Bases: (%d+)  Resources: (%d+)/2000");
    	-- _, _, strHordeBases, strHordeScore = string.find(horde, "Bases: (%d+)  Resources: (%d+)/2000");
    	_, _, strAllyBases, strAllyScore,final = ally:find(self.RESPATTERN)
    	_, _, strHordeBases, strHordeScore,final = horde:find(self.RESPATTERN)

    end
    final = tonumber(final) or 2000
	local allyBases = tonumber(strAllyBases);
	local hordeBases = tonumber(strHordeBases);
	local allyScore = tonumber(strAllyScore);
	local hordeScore = tonumber(strHordeScore);

	-- check for data and victory
	if (not allyScore) or (not hordeScore) or (allyScore == "2000") or (hordeScore == "2000") then
		--getglobal("AlarABHelper"):Hide();
		self.ABTimeLeft = 0;
		return 0,0,0,"";
	end

	allyRate = (2000 - allyScore) * rates[allyBases].rate;
	hordeRate = (2000 - hordeScore) * rates[hordeBases].rate;
	estimatedTime = math.min(allyRate, hordeRate);
	needed = self:_ABGetNeeded(allyScore, hordeScore);
	estimatedAlly = 2000;
	estimatedHorde = 2000;
	if (self.MyFaction == FACTION_ALLIANCE) then
        hold = allyBases
        needed = needed
	else
        hold=hordeBases
		needed = 6 - needed;
	end
	-- Calculate alliance score
	if (allyBases == 0) then
		estimatedAlly = allyScore;
	elseif (hordeRate < allyRate) then
		estimatedAlly = allyScore + floor((hordeRate / rates[allyBases].time)) * 10;
	end
	-- Calculate horde score
	if (hordeBases == 0) then
		estimatedHorde = hordeScore;
	elseif (allyRate < hordeRate) then
		    estimatedHorde = hordeScore + floor((allyRate / rates[hordeBases].time)) * 10;
	end
	-- Check if we're just starting the game
	if (allyRate == 1999998000) and (hordeRate == 1999998000) then
       	estimatedAlly = "ind.";
       	estimatedHorde = "ind.";
   	end;

	--calculate estimated time
	if (estimatedTime == 1999998000) then
		return estimatedAlly, estimatedHorde, 5,0;
	else
		self.ABTimeLeft = estimatedTime;
		self.ABLastTimerUpdate = time();
		return estimatedAlly, estimatedHorde, needed, math.floor(estimatedTime);
	end
end

function mod:_ABGetNeeded(aScore, hScore)
    local rates=self.rates
	if (((2000 - aScore) * rates[1].rate) < ((2000 - hScore) * rates[4].rate)) then
		return 1;
	elseif (((2000 - aScore) * rates[2].rate) < ((2000 - hScore) * rates[3].rate)) then
		return 2;
	elseif (((2000 - aScore) * rates[3].rate) < ((2000 - hScore) * rates[2].rate)) then
		return 3;
	elseif (((2000 - aScore) * rates[4].rate) < ((2000 - hScore) * rates[1].rate)) then
		return 4;
	else
		return 5;
	end
end
function mod:LeaveQueue(index)
    if (type(index) == "number") then
        AcceptBattlefieldPort(index,nil)
    else
    	for i=1,MAX_BATTLEFIELD_QUEUES do
    		local status,mapName,_ = GetBattlefieldStatus(i);
    		self:Print(status,mapName)
    		if (status == "confirm" or status == 'queued' ) then
                if ((type(index) == "string" and mapName== index) or type(index) == "nil") then
                    self:Print(AMO_YELLOW .. "Leaving " .. mapName)
                    AcceptBattlefieldPort(i,nil)
                end
            end
        end
    end
end

function mod:Test()
    self:PrintLiteral(GetWorldStateUIInfo(1))
    self:PrintLiteral(GetWorldStateUIInfo(2))
    self:PrintLiteral(GetWorldStateUIInfo(3))
    self:Print("Onscreen = ", onscreen)
end
function mod:TimeToCapAll(faction)
    if (not CurrentForm) then
        return
    end
    for _,i in ipairs(CurrentForm.marks) do
        self:TimeToCap(CurrentForm.timer[i],"LeftButton",false,faction)
    end
end

function mod:TimeToCap(this,button,msg,onlyfaction)
    self:Debug(this,button,msg)
    if (button=="LeftButton" and this.node and type(this.node)=="number") then
        msg=msg or this:GetText()
        msg=msg or '0:00'
        if (msg == '0:00' or msg == '00:00' or msg == '') then
            return
        end
        local faction=G:GetAttacker(this.node) or 'Unknown'
        if (not onlyfaction or onlyfaction  == faction) then
            return type(msg)=="string" and self:Message(format(L.BGCAPTURE,faction,this.longname,msg))
        end
    end
end


function mod:Inform(this)
    self:Message(this:GetText())
end
function mod:RetrieveEnemyHealth(pg)
    if (not pg) then
        return
    end
    if (pg==UnitName('target')) then
        return UnitHealth('target')
    elseif (pg==UnitName('targettarget')) then
        return UnitHealth('targettarget')
    else
        for i=1,GetNumRaidMembers() do
            if (UnitName("raid" .. i .. "target")==pg) then
                return UnitHealth("raid" .. i .. "target")
            end
        end
    end
    if (self.pgcache[pg]) then
        local px=self.pgcache[pg]
        local age = px.updated or 0
        health=px.health or 100
        if ((GetTime() - age) > 10) then
            return -health
        end
    end
end
function mod:RetrieveFriendHealth(pg)
    for i=1,GetNumRaidMembers() do
        if (UnitName("raid" .. i)==pg) then
            return self:Health("raid" .. i)
        end
    end
end
function mod:_WSGInform(msg,carrier)
    local pg
    if (carrier) then
        pg=G:GetFlagCarrier(self[carrier])
        if (pg) then
            local health='unknown'
            if (carrier == "FF") then
                health=self:RetrieveFriendHealth(pg)
            else
                health=self:RetrieveEnemyHealth(pg)
            end
            if (health) then
                if (health < 0) then
                    pg=format(L.BGWSGMSG2,pg,-health)
                else
                    pg=format(L.BGWSGMSG1,pg,health)
                end

            end
        end
    end
    self:Message(msg .. ' ' .. (pg or ''))
end

function mod:CarrierClick(this,button)
    local enemy=this:GetUnit()
    if (not enemy) then
        return
    end
    local faction=this.faction or 'none'
    if (IsShiftKeyDown() or button == "RightButton") then
        local race,class=self:GetPlayerInfo(enemy,this.faction)
        if (this.faction == self.FF) then
            health=self:RetrieveFriendHealth(enemy)
        else
            health=self:RetrieveEnemyHealth(enemy)
        end
--BGWSGCARRIER1="Carrier: %s (%s %s Health: %s%%)",
        if (health) then
            if (health < 1) then
                self:Message(format(L.BGWSGCARRIER2,faction,enemy,race or "",class or "",-health),"BATTLEGROUND")
            else
                self:Message(format(L.BGWSGCARRIER1,faction,enemy,race or "",class or "",health),"BATTLEGROUND")
            end
        else
            self:Message(self:Format(L.BGWSGCARRIER2,faction,enemy,race or "",class or "","??"),"BATTLEGROUND")
        end
    else
        --Targeting done via macro
    end
end
function mod:GetPlayerInfo(player,faction)
    local data=self.pgcache[player]
    if (faction and data.faction ~=faction) then
            self:Debug("GPI",faction,data)
    else
        return data.race,data.class,data.faction,data.health
    end
end

function myGetNumMapLandmarks()
    AMO:Print ("Faking",CurrentBg)
    return minmarks[CurrentBg]
end
function myGetMapLandmarkInfo(i)
    AMO:Print ("Faking",i)
    return "Base " .. i .. " got a long name","Fake description " .. i,45,1,1
end
mod.CmdFakeValidate=shorts
mod.CmdFakeType="text"
function mod:CmdFake(arg1)
    local oGetNumMapLandmarks=GetNumMapLandmarks
    local oGetMapLandmarkInfo=GetMapLandmarkInfo
    CurrentBg=strupper(arg1)
    GetNumMapLandmarks=myGetNumMapLandmarks
    GetMapLandmarkInfo=myGetMapLandmarkInfo
    CurrentForm=self:_CreateFrame(CurrentBg)
    self:Init(CurrentBg)
    GetNumMapLandmarks=oGetNumMapLandmarks
    GetMapLandmarkInfo=oGetMapLandmarkInfo
    local f=getglobal("Alar" ..arg1 .. "Helper")
    if (f) then 
        f.Dirty=true
        f:Show() 
    end
end
function mod:CmdCleancache()
    self:Print("Cleaning cache")
    self.pgcache=nil
    self:iCmdGarbage()
    self.pgcache={}
end
function mod:ScanForMarks(n)
    if (InCombatLockdown()) then return end
    self:Debug("Called scan for marks " .. tostring(n))
    for i,v in pairs(self.MARKS) do
        local token=i .. "MARKS"
        local qt=0
        qt=GetItemCount(v,self:GetToggle("WITHBANK"))
        mod.markscount[token]=qt
    end
    if (ABHFU and ABHFU.frame) then
        ABHFU:UpdateText()
    end
    if (ABHTITAN ) then
        ABHTITAN:UpdateText()
    end
end
function mod:CmdMarks()
    self:ScanForMarks()
    for k,n in pairs(self.MARKS) do
        local marks=mod.markscount[k.."MARKS"]
        self:Printf("%s%s:%s%s",AMO_GREEN,n,AMO_YELLOW,marks)
    end
end
function mod:iCmdHook()
-- Debugging
    hooksecurefunc("SecureButton_GetModifiedAttribute",function(...) self:SecureButton_GetModifiedAttribute(...) end )
    hooksecurefunc(AlarWSGHelperHorde,"GetAttribute",function(...) self:GetAttribute(...) end )
end
function mod:JoinBg()
-- Joins last opened bg as group (handles if you are solo or if bg is AV
--if( CanJoinBattlefieldAsGroup() ) then
if (GetNumPartyMembers()>0 and CanJoinBattlefieldAsGroup()) then
  -- Queue as a group for the first available battleground
  JoinBattlefield(0, 1);
else
  -- Solo queue for the first available battleground
  JoinBattlefield(0);
end
HideUIPanel(BattlefieldFrame)
end
function mod:EvtGOSSIP_SHOW()
    if (CurrentBg ~= "AV") then
        return
    end
    if (not self:GetToggle("AVTURNIN")) then
        return
    end
	local target = UnitName("target");
    self:Debug(target,self.AVNPC.SMITHREGZAR,self.AVNPC.MURGOTDEEPFORGE)
	if( target == self.AVNPC.SMITHREGZAR or target == self.AVNPC.MURGOTDEEPFORGE ) then
		-- Open Quest to Smith or Murgot
		if (self:ItemCount(self.AVITEM.ARMORSCRAPS) >= 20) then
			SelectGossipAvailableQuest(1);
		end
	elseif( target == self.AVNPC.PRIMALISTTHURLOGA) then
		local n = self:ItemCount(self.AVITEM.SOLDIERSBLOOD);
		if (n >= 5) then
            SelectGossipAvailableQuest(2);
		elseif (n > 0) then
            SelectGossipAvailableQuest(1);
		end

	elseif( target == self.AVNPC.ARCHDRUIDRENFERAL) then
		local n = self:ItemCount(self.AVITEM.STORMCRYSTAL);
		if (n >= 5) then		SelectGossipAvailableQuest(2);
		elseif (n > 0) then		SelectGossipAvailableQuest(1);
		end

	elseif( target == self.AVNPC.STORMPIKERAMRIDERCOMMANDER) then	-- Ram Riders
		if (self:ItemCount(self.AVITEM.FROSTWOLFHIDE) > 0) then
			SelectGossipAvailableQuest(1);
		end

	elseif( target == self.AVNPC.FROSTWOLFWOLFRIDERCOMMANDER) then	-- Wolf Riders
		if (self:ItemCount(self.AVITEM.ALTERACRAMHIDE) > 0) then
			SelectGossipAvailableQuest(1);
		end
	end
 end
 function mod:EvtQUEST_PROGRESS()
    if (CurrentBg ~= "AV") then
        return
    end
    if (not self:GetToggle("AVTURNIN")) then
        return
    end

    local target = UnitName("target");
	if (target == self.AVNPC.WINGCOMMANDERJEZTOR
	   and self:ItemCount(self.AVITEM.LIEUTENANTSFLESH) == 0) then
       return;
	elseif (target == self.AVNPC.WINGCOMMANDERGUSE
	   and self:ItemCount(self.AVITEM.SOLDIERSFLESH) == 0) then
       return;
	elseif (target == self.AVNPC.WINGCOMMANDERMULVERICK
	   and self:ItemCount(self.AVITEM.COMMANDERSFLESH) == 0) then
       return;
	elseif (target == self.AVNPC.WINGCOMMANDERVIPORE
	   and self:ItemCount(self.AVITEM.LIEUTENANTSMEDAL) == 0) then
       return;
	elseif (target == self.AVNPC.WINDCOMMANDERSLIDORE
	   and self:ItemCount(self.AVITEM.SOLDIERSMEDAL) == 0) then
       return;
	elseif (target == self.AVNPC.WINGCOMMANDERICHMAN
	   and self:ItemCount(self.AVITEM.COMMANDERSMEDAL) == 0) then
       return;
   	end
	CompleteQuest();
end
function mod:ResetBars()
    local bargroup=CurrentForm:GetName() .."Bars"
    if (C and C.groups and C.groups[bargroup] and C.groups[bargroup].bars) then
        local lista=C.groups[bargroup].bars
        for _,nome in pairs(lista) do
            C:SetCandyBarTimeLeft(nome,0)
        end
    end
end
function mod:EvtQUEST_COMPLETE()
    if (CurrentBg ~= "AV") then
        return
    end
    if (not self:GetToggle("AVTURNIN")) then
        return
    end

	local target = UnitName("target");
	for index, value in pairs(self.AVNPC) do
		if (target == value) then
			GetQuestReward(0);
		end
	end
end
-- QUi le due cache per lo stato dei boss
function mod:ReformatMMTooltip( names )
	local ret = "";
	if( names == nil ) then
		return;
	end
	local wasreturn = false;
	for target in string.gmatch( names, "[^\n]*" ) do
        self:Debug("RMM",names,target)
		if( target:len() > 0) then
            if (not target:find("%(") ) then
                local race,class,faction,health=self:GetPlayerInfo(target)
    			--colorize names
    			local color=AMO_YELLOW
                if (not tonumber(race)) then
                    if (faction == FACTION_HORDE) then
                        color=AMO_RED
                    else
                        color=AMO_AZURE
                    end
                    ret=ret .. self:Format("%s%s (%s %s h:%s%%)",color,target,race,class,health)
                else
                    ret=ret .. self:Format("%s%s",color,target)
                end
            else
                ret=ret .. target
            end
    		wasreturn = false;
		else
			if( not wasreturn ) then
				ret = ret .. "\n";
				wasreturn = true;
			end
		end
	end
	return ret;
end
function mod:Message(msg,channel)
    if (msg) then
        self:Trace(msg)
        if (self:GetToggle("SELFONLY") or not G:IsInBattlegrounds()) then
            self:Print(msg)
        else
            SendChatMessage(msg,channel or "BATTLEGROUND")
        end
    end
end
function mod:Localize()
    L=self.L
    self.BGS={}
    if (AceLibrary:HasInstance("Babble-Zone-2.2")) then
        local BZ=AceLibrary("Babble-Zone-2.2")
        self.AB=BZ["Arathi Basin"]
        self.WSG=BZ["Warsong Gulch"]
        self.AV=BZ["Alterac Valley"]
        self.EOS=BZ["Eye of the Storm"]
        self.BGS[self.AB]="AB"
        self.BGS[self.AV]="AV"
        self.BGS[self.WSG]="WSG"
        self.BGS[self.EOS]="EOS"
        -- Will translate them with Glory later
        self.BGSHORTCUTS={
            AB="Ab", -- translation for shortcuts is here..
            WSG="WsG",
            AV="Av",
            EOS="EoS",
        }
    else
        self.AB=L.AB
        self.WSG=L.WSG
        self.AV=L.AV
        self.EOS=L.EOS
        self.BGS[self.AB]="AB"
        self.BGS[self.AV]="AV"
        self.BGS[self.WSG]="WSG"
        self.BGS[self.EOS]="EOS"
        -- Will translate them with Glory later
        self.BGSHORTCUTS={
            AB="Ab", -- translation for shortcuts is here..
            WSG="WsG",
            AV="Av",
            EOS="EoS",
        }
    end
    self.MARKS={
        AB=L.AB_MARK,
        AV=L.AV_MARK,
        WSG=L.WSG_MARK,
        EOS=L.EOS_MARK,
    }
    self.AVNPC = {
    SMITHREGZAR=L.SMITHREGZAR,
    PRIMALISTTHURLOGA=L.PRIMALISTTHURLOGA,
    WINGCOMMANDERJEZTOR=L.WINGCOMMANDERJEZTOR,
    WINGCOMMANDERGUSE=L.WINGCOMMANDERGUSE,
    WINGCOMMANDERMULVERICK=L.WINGCOMMANDERMULVERICK,
    WINGCOMMANDERVIPORE=L.WINGCOMMANDERVIPORE,
    WINGCOMMANDERSLIDORE=L.WINGCOMMANDERSLIDORE,
    WINGCOMMANDERICHMAN=L.WINGCOMMANDERICHMAN,
    MURGOTDEEPFORGE=L.MURGOTDEEPFORGE,
    ARCHDRUIDRENFERAL=L.ARCHDRUIDRENFERAL,
    STORMPIKERAMRIDERCOMMANDER=L.STORMPIKERAMRIDERCOMMANDER,
    FROSTWOLFWOLFRIDERCOMMANDER=L.FROSTWOLFWOLFRIDERCOMMANDER,
    }
    self.AVITEM = {
    ARMORSCRAPS=L.ARMORSCRAPS,
    SOLDIERSBLOOD=L.SOLDIERSBLOOD,
    LIEUTENANTSFLESH=L.LIEUTENANTSFLESH,
    SOLDIERSFLESH=L.SOLDIERSFLESH,
    COMMANDERSFLESH=L.COMMANDERSFLESH,
    STORMCRYSTAL=L.STORMCRYSTAL,
    LIEUTENANTSMEDAL=L.LIEUTENANTSMEDAL,
    SOLDIERSMEDAL=L.SOLDIERSMEDAL,
    COMMANDERSMEDAL=L.COMMANDERSMEDAL,
    FROSTWOLFHIDE=L.FROSTWOLFHIDE,
    ALTERACRAMHIDE=L.ALTERACRAMHIDE,
    }
    self.COMMANDERS={
        [L.WINGCOMMANDERVIPORE]='A',
        [L.WINGCOMMANDERSLIDORE]='A',
        [L.WINGCOMMANDERICHMAN]='A',
        [L.WINGCOMMANDERJEZTOR]='H',
        [L.WINGCOMMANDERGUSE]='H',
        [L.WINGCOMMANDERMULVERICK]='H',
    }
end
mod:Register()
if (not FuBar or not AceLibrary:HasInstance("FuBarPlugin-2.0") or not AceLibrary:HasInstance("Tablet-2.0")) then
    ABH.FuBarSupport=false
else
    ABH.FuBarSupport=true
end
ABH.TitanSupport=(TitanPanelButton_OnLoad or false)
