-- Copyright (c) 2008 kydori <kydori@gmail.com>

local al = LibStub("AceLocale-3.0"):GetLocale("Aesa")
local adbo = LibStub("AceDBOptions-3.0")

function Aesa:GetOptions()
	local db = self.db.profile
	local options = {
		type = "group", name = self.appName, childGroups = "tree",
		args = {
			enabled = {
				type = "toggle", name = al["Enabled"], order = 1,
				get = function() return Aesa:IsEnabled() end,
				set = function(_, v)
					db.enabled = v
					if v then Aesa:Enable() else Aesa:Disable() end
				end
			},
			lock = {
				type = "toggle", name = al["Lock (Uncheck to move)"], order = 2,
				get = function() return db.locked end,
				set = function(_, v)
					db.locked = v
					self:C_ApplySettings()
				end
			},
			cd = {
				type = "group", name = al["Cooldowns"], order = 3,
				args = {
					main = {
						type = "group", name = al["Target"], childGroups = "tab", order = 1,
						args = {}
					},
					aux = {
						type = "group", name = al["Focus"], childGroups = "tab", order = 2,
						args = {}
					}
				}
			},
			profiles = adbo:GetOptionsTable(self.db)
		}
	}
	self:AddTrackerOptions(options.args.cd.args.main.args, ".cd.target", "target", al["Target"])
	self:AddTrackerOptions(options.args.cd.args.aux.args, ".cd.focus", "focus", al["Focus"])
	return options
end

function Aesa:AddTrackerOptions(args, path, dbk, header)
	if not args then return end
	local db = self.db.profile.cd[dbk]
	local n = self:StrWordCount(path, ".")
	local to = {
		header = {type = "header", order = 1, name = header},
		enabled = {
			type = "toggle", name = al["Enabled"], order = 2,
			get = function() return db.enabled end,
			set = function(_, v)
				db.enabled = v
				self:C_ApplySettings()
			end
		},
		appearance = {
			type = "group", name = al["Appearance"], order = 3,
			get = function(info)
				if info.type == "color" and self:IsTable(db[info[n + 2]]) then
					do return unpack(db[info[n + 2]]) end
				else
					return db[info[n + 2]]
				end
			end,
			set = function(info, ...)
				if info.type == "color" then
					db[info[n + 2]] = {...}
				else
					db[info[n + 2]] = ...
				end
				self:C_ApplySettings()
			end,
			args = {
				width = {
					type = "range", name = al["Bar Width"], order = 1,
					min = 80, max = 600, step = 1
				},
				height = {
					type = "range", name = al["Bar Height"], order = 2,
					min = 15, max = 60, step = 1
				},
				scale = {
					type = "range", name = al["Scale"], order = 3,
					desc = al["Set the spacing between timer bars."],
					min = 0.1, max = 2, step = 0.01
				},
				spacing = {
					type = "range", name = al["Spacing"], order = 4,
					min = 0, max = 20, step = 1
				},
				barColor = {type = "color", name = al["Bar Color"], order = 5},
				highlightColor = {type = "color", name = al["Highlight Color"], order = 6},
				alpha = {
					type = "range", name = al["Alpha"], order = 7,
					min = 0, max = 1, step = 0.1
				},
				fontSize = {
					type = "range", name = al["Font Size"], order = 8,
					min = 5, max = 25, step = 1
				},
				iconSide = {
					type = "select", name = al["Icon Position"], order = 9,
					values = {LEFT = al["Left"], RIGHT = al["Right"]}
				},
				texture = {
					type = "select", name = al["Bar Texture"], order = 10,
					values = function() return self:SMList() end
				},
				growUp = {type = "toggle", name = al["Grow Up"], order = 11}
			}
		},
		tracking = {
			type = "group", name = al["Tracking"], order = 4,
			get = function(info) return db[info[n + 2]] end,
			set = function(info, value)
				db[info[n + 2]] = value
				self:C_ApplySettings()
				end,
			args = {
				rows = {
					type = "range", name = al["Shown Timers"], order = 1,
					desc = al["Maximum number of timer bars to be shown on screen."],
					min = 3, max = 16, step = 1
				},
				timeLimit = {
					type = "range", name = al["Time Limit"], order = 2,
					desc = al["Maximum cooldown duration to show (in seconds)."],
					min = 3, max = 3600, step = 1
				},
				highlightNew = {
					type = "toggle", name = al["Highlight New"], order = 3,
					desc = al["The last cooldown ability triggered by your target will be highlighted."],
				},
				hostileOnly = {
					type = "toggle", name = al["Hostile Units Only"], order = 4,
					desc = al["Track enemy cooldowns only."],
				}
			}
		},
		unitTabs = {
			type = "group", name = al["Unit Tabs"], order = 5,
			get = function(info) return db[info[n + 2]] end,
			set = function(info, value)
				db[info[n + 2]] = value
				self:C_ApplySettings()
			end,
			args = {
				tabbed = {
					type = "toggle", name = al["Tabbed"], order = 1,
					desc = al["Display a group of tabs stick on timers frame allow you to review cooldowns of units you've recently targeted."]
				},
				tabs = {
					type = "range", name = al["Tabs"], order = 2,
					desc = al["Maximum number of tabs to be shown."],
					min = 3, max = 6, step = 1
				},
				tabHeight = {
					type = "range", name = al["Tab Height"], order = 3,
					min = 15, max = 40, step = 1
				},
				tabSpacing = {
					type = "range", name = al["Spacing"], order = 4,
					min = 0, max = 20, step = 1
				},
				tabAlpha1 = {
					type = "range", name = al["Alpha 1"], order = 5,
					min = 0, max = 1, step = 0.1
				},
				tabAlpha2 = {
					type = "range", name = al["Alpha 2"], order = 6,
					min = 0, max = 1, step = 0.1
				},
				tabFontSize = {
					type = "range", name = al["Font Size"], order = 7,
					min = 5, max = 25, step = 1
				},
				tabTexture = {
					type = "select", name = al["Tab Texture"], order = 8,
					values = function() return self:SMList() end
				}
			}
		}
	}
	for k, v in pairs(to) do
		args[k] = v
	end
end
