-- AddonManager continued from Zwergin (Zwergin on Nethersturm-EU - wow-addons@o2online.de)

local version = "04"

SLASH_AM1 = "/am"
SLASH_AM2 = "/addonmanager"
SLASH_AM3 = "/addons"

local yspacing = 20
local yoffset = -6

local firstrowy = yoffset - yspacing * 0
local secondrowy = yoffset - yspacing * 1
local addonrowy = yoffset - yspacing * 2
local thirdrowy = yoffset - yspacing * 12
local fourthrowy = yoffset - yspacing * 13
local fifthrowy = yoffset - yspacing * 14

local addoname_leftx = 6
local cputotal_centerx = 190
local cpupercentage_centerx = 250

local memorytotal_centerx = 310
local memorypercentage_centerx = 370

local enablebox_rightx = 358+80
local status_leftx = 360+80
local dependances_rightx = 554+80

local mainframe = CreateFrame("Frame","AddonManager", UIParent)
mainframe:SetHeight(yoffset*2 + yspacing * 16)
mainframe:SetWidth(560+80)
mainframe:SetPoint("CENTER",UIParent,"CENTER")
mainframe:EnableMouse(true)
mainframe:SetToplevel(true)
mainframe:SetBackdrop({bgFile = "Interface\\ChatFrame\\ChatFrameBackground"})
mainframe:SetBackdropColor(0,0,0)

-- First Row --
mainframe.addontext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.addontext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.addontext:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,firstrowy)
mainframe.addontext:SetText("Addon Manager v"..version)

mainframe.addonbox = CreateFrame("CheckButton",nil, mainframe)
mainframe.addonbox:SetHeight(16)
mainframe.addonbox:SetWidth(100)
mainframe.addonbox:EnableMouse(true)
mainframe.addonbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,firstrowy)
mainframe.addonbox:SetScript("OnEnter",function()
	GameTooltip:ClearLines()
	GameTooltip:SetOwner(this,"ANCHOR_LEFT")
	GameTooltip:AddLine("Addon Manager v"..version,1,1,1)
	GameTooltip:AddLine("Written by Crepusculu of Stormrage",1,1,1)
	GameTooltip:AddLine("Find my addons listed at WoWInterface.com",1,1,1)
	GameTooltip:Show()
end)
mainframe.addonbox:SetScript("OnLeave",function()
	GameTooltip:Hide()
end)

mainframe.cpuprofilingtext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.cpuprofilingtext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.cpuprofilingtext:SetPoint("TOP",mainframe,"TOPLEFT",cputotal_centerx,firstrowy)
mainframe.cpuprofilingtext:SetText("CPU Profiling")
mainframe.cpuprofilingtext:SetTextColor(1,0,0)

mainframe.cpuprofilingbox = CreateFrame("CheckButton",nil, mainframe)
mainframe.cpuprofilingbox:SetHeight(16)
mainframe.cpuprofilingbox:SetWidth(16)
mainframe.cpuprofilingbox:SetChecked(true)
mainframe.cpuprofilingbox:SetCheckedTexture("Interface\\AddOns\\AddonManager\\checkmark.tga")
mainframe.cpuprofilingbox:GetCheckedTexture():SetBlendMode("BLEND")
mainframe.cpuprofilingbox:SetNormalTexture("Interface\\AddOns\\AddonManager\\checkbox.tga")
mainframe.cpuprofilingbox:SetPoint("TOP",mainframe,"TOPLEFT",cpupercentage_centerx,firstrowy)
mainframe.cpuprofilingbox:SetScript("OnClick",function()
	this:GetParent().cpuprofilingenabledtext:SetText("")
	if GetCVar("scriptProfile") == "0" then
		SetCVar("scriptProfile", "1")
		--if this:GetParent().cpuprofilingtext:GetTextColor() == 1 then
		this:GetParent().cpuprofilingenabledtext:SetText("CPU profiling enabled on next reload")
		this:GetParent().cpuprofilingenabledtext:SetTextColor(.4,1,.4)
		--end
	else 
		SetCVar("scriptProfile", "0")
		--if this:GetParent().cpuprofilingtext:GetTextColor() ~= 1 then
		this:GetParent().cpuprofilingenabledtext:SetText("CPU profiling disabled on next reload")
		this:GetParent().cpuprofilingenabledtext:SetTextColor(1,.4,.4)
		--end
	end
end)

mainframe.memorytext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.memorytext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.memorytext:SetPoint("TOP",mainframe,"TOPLEFT",(memorytotal_centerx + memorypercentage_centerx)/2,firstrowy)
mainframe.memorytext:SetText("Memory (KB)")
mainframe.memorytext:SetTextColor(1,1,1)

mainframe.enableallbutton = CreateFrame("Button",nil, mainframe)
mainframe.enableallbutton:SetHeight(16)
mainframe.enableallbutton:SetWidth(30)
mainframe.enableallbutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\smallbox.tga")
mainframe.enableallbutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.enableallbutton:SetFont("Fonts\\ARIALN.TTF",16,"OUTLINE")
mainframe.enableallbutton:SetText("All")
mainframe.enableallbutton:SetTextColor(.4,1,.4)
mainframe.enableallbutton:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",enablebox_rightx,firstrowy)

mainframe.exitbutton = CreateFrame("Button",nil, mainframe)
mainframe.exitbutton:SetHeight(16)
mainframe.exitbutton:SetWidth(36)
mainframe.exitbutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\smallbox.tga")
mainframe.exitbutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.exitbutton:SetFont("Fonts\\ARIALN.TTF",16,"OUTLINE")
mainframe.exitbutton:SetText("Exit")
mainframe.exitbutton:SetTextColor(1,.4,.4)
mainframe.exitbutton:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",dependances_rightx,firstrowy)
mainframe.exitbutton:SetScript("OnClick",function()
	this:GetParent():Hide()
end)

-- Second Row --
mainframe.scrollupbutton = CreateFrame("Button",nil, mainframe)
mainframe.scrollupbutton:SetHeight(16)
mainframe.scrollupbutton:SetWidth(46)
mainframe.scrollupbutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\upbox.tga")
mainframe.scrollupbutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.scrollupbutton:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,secondrowy)

mainframe.totalcputext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.totalcputext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.totalcputext:SetPoint("TOP",mainframe,"TOPLEFT",cputotal_centerx,secondrowy)
mainframe.totalcputext:SetText("Total")
mainframe.totalcputext:SetTextColor(1,1,1)

mainframe.percentagecputext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.percentagecputext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.percentagecputext:SetPoint("TOP",mainframe,"TOPLEFT",cpupercentage_centerx,secondrowy)
mainframe.percentagecputext:SetText("Percent")
mainframe.percentagecputext:SetTextColor(1,1,1)

mainframe.totalmemorytext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.totalmemorytext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.totalmemorytext:SetPoint("TOP",mainframe,"TOPLEFT",memorytotal_centerx,secondrowy)
mainframe.totalmemorytext:SetText("Total")
mainframe.totalmemorytext:SetTextColor(1,1,1)

mainframe.percentagememorytext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.percentagememorytext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.percentagememorytext:SetPoint("TOP",mainframe,"TOPLEFT",memorypercentage_centerx,secondrowy)
mainframe.percentagememorytext:SetText("Percent")
mainframe.percentagememorytext:SetTextColor(1,1,1)

mainframe.disableallbutton = CreateFrame("Button",nil, mainframe)
mainframe.disableallbutton:SetHeight(16)
mainframe.disableallbutton:SetWidth(30)
mainframe.disableallbutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\smallbox.tga")
mainframe.disableallbutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.disableallbutton:SetFont("Fonts\\ARIALN.TTF",16,"OUTLINE")
mainframe.disableallbutton:SetText("All")
mainframe.disableallbutton:SetTextColor(1,.4,.4)
mainframe.disableallbutton:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",enablebox_rightx,secondrowy)

mainframe.statustext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.statustext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.statustext:SetPoint("TOPLEFT",mainframe,"TOPLEFT",status_leftx,secondrowy)
mainframe.statustext:SetText("Status")
mainframe.statustext:SetTextColor(1,1,1)

mainframe.dependenciestext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.dependenciestext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.dependenciestext:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",dependances_rightx,secondrowy)
mainframe.dependenciestext:SetText("Dependencies")
mainframe.dependenciestext:SetTextColor(1,1,1)

-- Addon rows --
mainframe.addon = {}
for i=1,10 do
	mainframe.addon[i] = CreateFrame("Frame",nil, mainframe)
	mainframe.addon[i].yposition = addonrowy-(i-1)*20
	mainframe.addon[i].addonindex = i
	
	mainframe.addon[i].addonnametext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].addonnametext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].addonnametext:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,mainframe.addon[i].yposition)
	mainframe.addon[i].addonnametext:SetText("Addon Name")
	mainframe.addon[i].addonnametext:SetTextColor(.4,1,.4)
	
	mainframe.addon[i].addonnamebox = CreateFrame("Frame",nil, mainframe.addon[i])
	mainframe.addon[i].addonnamebox:EnableMouse(true)
	mainframe.addon[i].addonnamebox:SetHeight(16)
	mainframe.addon[i].addonnamebox:SetWidth(cputotal_centerx - 40 - addoname_leftx)
	mainframe.addon[i].addonnamebox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,mainframe.addon[i].yposition)
	mainframe.addon[i].addonnamebox:SetScript("OnEnter",function()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(this,"ANCHOR_LEFT")
		GameTooltip:AddLine(this:GetParent():GetParent().addons[ this:GetParent().addonindex ].title,1,1,1)
		GameTooltip:AddLine(this:GetParent():GetParent().addons[ this:GetParent().addonindex ].notes,1,1,1,true)
		GameTooltip:Show()
	end)
	mainframe.addon[i].addonnamebox:SetScript("OnLeave",function()
		GameTooltip:Hide()
	end)
	
	mainframe.addon[i].totalcputext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].totalcputext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].totalcputext:SetPoint("TOP",mainframe,"TOPLEFT",cputotal_centerx,mainframe.addon[i].yposition)
	mainframe.addon[i].totalcputext:SetText("CPU")
	mainframe.addon[i].totalcputext:SetTextColor(1,1,1)
	
	mainframe.addon[i].percentagecputext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].percentagecputext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].percentagecputext:SetPoint("TOP",mainframe,"TOPLEFT",cpupercentage_centerx,mainframe.addon[i].yposition)
	mainframe.addon[i].percentagecputext:SetText("CPU")
	mainframe.addon[i].percentagecputext:SetTextColor(.4,1,.4)
	
	mainframe.addon[i].totalmemorytext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].totalmemorytext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].totalmemorytext:SetPoint("TOP",mainframe,"TOPLEFT",memorytotal_centerx,mainframe.addon[i].yposition)
	mainframe.addon[i].totalmemorytext:SetText("MEMORY")
	mainframe.addon[i].totalmemorytext:SetTextColor(1,1,1)
	
	mainframe.addon[i].percentagememorytext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].percentagememorytext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].percentagememorytext:SetPoint("TOP",mainframe,"TOPLEFT",memorypercentage_centerx,mainframe.addon[i].yposition)
	mainframe.addon[i].percentagememorytext:SetText("MEMORY")
	mainframe.addon[i].percentagememorytext:SetTextColor(.4,1,.4)
	
	mainframe.addon[i].enabledbox = CreateFrame("CheckButton",nil, mainframe.addon[i])
	mainframe.addon[i].enabledbox:SetHeight(16)
	mainframe.addon[i].enabledbox:SetWidth(16)
	mainframe.addon[i].enabledbox:SetChecked(true)
	mainframe.addon[i].enabledbox:SetCheckedTexture("Interface\\AddOns\\AddonManager\\checkmark.tga")
	mainframe.addon[i].enabledbox:GetCheckedTexture():SetBlendMode("BLEND")
	mainframe.addon[i].enabledbox:SetNormalTexture("Interface\\AddOns\\AddonManager\\checkbox.tga")
	mainframe.addon[i].enabledbox:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",enablebox_rightx,mainframe.addon[i].yposition)
	mainframe.addon[i].enabledbox:SetScript("OnClick",function()
	
		if this:GetChecked() then
			EnableAddOn(this:GetParent().addonindex)
			this:GetParent():GetParent().addons[this:GetParent().addonindex].enabled = true
		else
			DisableAddOn(this:GetParent().addonindex)
			this:GetParent():GetParent().addons[this:GetParent().addonindex].enabled = false
		end
		this:GetParent():GetParent().updateaddondisplay()
	end)
	
	
	mainframe.addon[i].statustext = mainframe.addon[i]:CreateFontString(nil, "ARTWORK")
	mainframe.addon[i].statustext:SetFont("Fonts\\ARIALN.TTF",16)
	mainframe.addon[i].statustext:SetPoint("TOPLEFT",mainframe,"TOPLEFT",status_leftx,mainframe.addon[i].yposition)
	mainframe.addon[i].statustext:SetText("Loaded")
	mainframe.addon[i].statustext:SetTextColor(.4,1,.4)
	
	mainframe.addon[i].statusbox = CreateFrame("Frame",nil, mainframe.addon[i])
	mainframe.addon[i].statusbox:EnableMouse(true)
	mainframe.addon[i].statusbox:SetHeight(16)
	mainframe.addon[i].statusbox:SetWidth(dependances_rightx - 30 - status_leftx)
	mainframe.addon[i].statusbox:SetPoint("TOPLEFT",mainframe,"TOPLEFT",status_leftx,mainframe.addon[i].yposition)
	mainframe.addon[i].statusbox:SetScript("OnMouseDown",function()
		LoadAddOn(this:GetParent().addonindex)
		this:GetParent():GetParent().updateaddondisplay()
	end)
	
	mainframe.addon[i].dependencebox = CreateFrame("Frame",nil, mainframe.addon[i])
	mainframe.addon[i].dependencebox:SetHeight(16)
	mainframe.addon[i].dependencebox:SetWidth(16)
	mainframe.addon[i].dependencebox:EnableMouse(true)
	mainframe.addon[i].dependencebox:SetBackdrop({ bgFile="Interface\\Addons\\AddonManager\\ball.tga"})
	mainframe.addon[i].dependencebox:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",dependances_rightx,mainframe.addon[i].yposition)
	mainframe.addon[i].dependencebox:SetScript("OnEnter",function()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:AddLine("Dependencies:",1,1,1)
		for k,v in pairs(this:GetParent():GetParent().addons[ this:GetParent().addonindex ].dependencies) do
			if IsAddOnLoaded(v) then
				GameTooltip:AddLine(v,.4,1,.4)
			else
				GameTooltip:AddLine(v,1,.4,.4)
			end
		end
		GameTooltip:Show()
	end)
	mainframe.addon[i].dependencebox:SetScript("OnLeave",function()
		GameTooltip:Hide()
	end)
end

-- third Row --
mainframe.scrolldownbutton = CreateFrame("Button",nil, mainframe)
mainframe.scrolldownbutton:SetHeight(16)
mainframe.scrolldownbutton:SetWidth(46)
mainframe.scrolldownbutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\downbox.tga")
mainframe.scrolldownbutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.scrolldownbutton:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,thirdrowy)

mainframe.totalcputext2 = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.totalcputext2:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.totalcputext2:SetPoint("TOP",mainframe,"TOPLEFT",cputotal_centerx,thirdrowy)
mainframe.totalcputext2:SetText("###")
mainframe.totalcputext2:SetTextColor(.4,1,.4)

mainframe.percentagecputext2 = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.percentagecputext2:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.percentagecputext2:SetPoint("TOP",mainframe,"TOPLEFT",cpupercentage_centerx,thirdrowy)
mainframe.percentagecputext2:SetText("100%")
mainframe.percentagecputext2:SetTextColor(.4,1,.4)

mainframe.totalmemorytext2 = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.totalmemorytext2:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.totalmemorytext2:SetPoint("TOP",mainframe,"TOPLEFT",memorytotal_centerx,thirdrowy)
mainframe.totalmemorytext2:SetText("###")
mainframe.totalmemorytext2:SetTextColor(.4,1,.4)

mainframe.percentagememorytext2 = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.percentagememorytext2:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.percentagememorytext2:SetPoint("TOP",mainframe,"TOPLEFT",memorypercentage_centerx,thirdrowy)
mainframe.percentagememorytext2:SetText("100%")
mainframe.percentagememorytext2:SetTextColor(.4,1,.4)

-- fourth Row --
mainframe.updatecpubutton = CreateFrame("Button",nil, mainframe)
mainframe.updatecpubutton:SetHeight(16)
mainframe.updatecpubutton:SetWidth(60)
mainframe.updatecpubutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\mediumbox.tga")
mainframe.updatecpubutton:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.updatecpubutton:SetText("Update")
mainframe.updatecpubutton:SetTextColor(0,0,0)
mainframe.updatecpubutton:SetPoint("TOP",mainframe,"TOPLEFT",cputotal_centerx,fourthrowy)

mainframe.resetcpubutton = CreateFrame("Button",nil, mainframe)
mainframe.resetcpubutton:SetHeight(16)
mainframe.resetcpubutton:SetWidth(46)
mainframe.resetcpubutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\mediumbox.tga")
--mainframe.resetcpubutton:GetNormalTexture():SetTexCoord(0, 0.7, 0, 1)
mainframe.resetcpubutton:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.resetcpubutton:SetText("Reset")
mainframe.resetcpubutton:SetTextColor(0,0,0)
mainframe.resetcpubutton:SetPoint("TOP",mainframe,"TOPLEFT",cpupercentage_centerx,fourthrowy)

mainframe.updatememorybutton = CreateFrame("Button",nil, mainframe)
mainframe.updatememorybutton:SetHeight(16)
mainframe.updatememorybutton:SetWidth(60)
mainframe.updatememorybutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\mediumbox.tga")
mainframe.updatememorybutton:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.updatememorybutton:SetText("Update")
mainframe.updatememorybutton:SetTextColor(0,0,0)
mainframe.updatememorybutton:SetPoint("TOP",mainframe,"TOPLEFT",(memorytotal_centerx + memorypercentage_centerx)/2,fourthrowy)

mainframe.addonsenabledtext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.addonsenabledtext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.addonsenabledtext:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",dependances_rightx,fourthrowy)
mainframe.addonsenabledtext:SetText("# Addons enabled for next reload")
mainframe.addonsenabledtext:SetTextColor(.4,1,.4)




-- fifth Row --
mainframe.reloaduibutton = CreateFrame("Button",nil, mainframe)
mainframe.reloaduibutton:SetHeight(16)
mainframe.reloaduibutton:SetWidth(72)
mainframe.reloaduibutton:SetNormalTexture("Interface\\AddOns\\AddonManager\\mediumbox.tga")
mainframe.reloaduibutton:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.reloaduibutton:SetText("Reload UI")
mainframe.reloaduibutton:SetTextColor(0,0,0)
mainframe.reloaduibutton:SetPoint("TOPLEFT",mainframe,"TOPLEFT",addoname_leftx,fifthrowy)
mainframe.reloaduibutton:SetScript("OnClick",ReloadUI)

mainframe.cpuprofilingenabledtext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.cpuprofilingenabledtext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.cpuprofilingenabledtext:SetPoint("TOP",mainframe,"TOPLEFT",(cputotal_centerx+cpupercentage_centerx)/2,fifthrowy)
mainframe.cpuprofilingenabledtext:SetText("")
mainframe.cpuprofilingenabledtext:SetTextColor(.4,1,.4)

mainframe.addonsdisabledtext = mainframe:CreateFontString(nil, "ARTWORK")
mainframe.addonsdisabledtext:SetFont("Fonts\\ARIALN.TTF",16)
mainframe.addonsdisabledtext:SetPoint("TOPRIGHT",mainframe,"TOPLEFT",dependances_rightx,fifthrowy)
mainframe.addonsdisabledtext:SetText("# Addons disabled for next reload")
mainframe.addonsdisabledtext:SetTextColor(1,.4,.4)

mainframe.addons = {}
mainframe.totalcpu = 0
mainframe.totalmemory = 0
mainframe.scrolladdons = function(adjustment)
	if mainframe.addon[10].addonindex + adjustment > GetNumAddOns() then
		adjustment =  GetNumAddOns() - mainframe.addon[10].addonindex
	elseif mainframe.addon[1].addonindex + adjustment <  1 then
		adjustment = -(mainframe.addon[1].addonindex -1)
	end
	for i=1,10 do
		mainframe.addon[i].addonindex = mainframe.addon[i].addonindex + adjustment
	end
end

mainframe.updateaddondisplay = function()
	local name, title, notes, enabled, loadable, reason, security
	local dependances
	for i=1,10 do
		--mainframe.addon[i].addonindex
		if mainframe.addon[i].addonindex > GetNumAddOns() then
			mainframe.addon[i].addonnamebox:Hide()
			mainframe.addon[i].addonnametext:SetText("")
			mainframe.addon[i].totalcputext:SetText("")
			mainframe.addon[i].percentagecputext:SetText("")
			mainframe.addon[i].enabledbox:Hide()
			mainframe.addon[i].statusbox:Hide()
			mainframe.addon[i].statustext:SetText("")
			mainframe.addon[i].dependencebox:Hide()
		else
			
		
			name, title, notes, enabled, loadable, reason, security = GetAddOnInfo(mainframe.addon[i].addonindex)
			dependances = {GetAddOnDependencies(mainframe.addon[i].addonindex)}
		
			-- Addon name
			mainframe.addon[i].addonnametext:SetText(mainframe.addons[mainframe.addon[i].addonindex].name)
			if IsAddOnLoaded(mainframe.addon[i].addonindex) then
				mainframe.addon[i].addonnametext:SetTextColor(0,.6,0)
			else
				mainframe.addon[i].addonnametext:SetTextColor(.6,0,0)
			end
			if mainframe.addons[mainframe.addon[i].addonindex].title or mainframe.addons[mainframe.addon[i].addonindex].notes then
				mainframe.addon[i].addonnamebox:Show()
			else
				mainframe.addon[i].addonnamebox:Hide()
			end
					
			
			-- CPU
			if mainframe.addons[mainframe.addon[i].addonindex].cpu and mainframe.addons[mainframe.addon[i].addonindex].cpu > 0 then
				mainframe.addon[i].totalcputext:SetText(
				string.format("%.2f",mainframe.addons[mainframe.addon[i].addonindex].cpu))
				mainframe.addon[i].percentagecputext:SetText(
				string.format("%.1f",mainframe.addons[mainframe.addon[i].addonindex].cpu/mainframe.totalcpu*100))
				
				mainframe.addon[i].percentagecputext:SetTextColor(.4,1,.4)
				if mainframe.addons[mainframe.addon[i].addonindex].cpu/mainframe.totalcpu > .30 then
					mainframe.addon[i].percentagecputext:SetTextColor(1,.4,.4)
				elseif mainframe.addons[mainframe.addon[i].addonindex].cpu/mainframe.totalcpu > .10 then
					mainframe.addon[i].percentagecputext:SetTextColor(1,1,.4)
				end
			else
				mainframe.addon[i].totalcputext:SetText("--")
				mainframe.addon[i].percentagecputext:SetText("--")
			end
			
			-- Memory
			if mainframe.addons[mainframe.addon[i].addonindex].memory and mainframe.addons[mainframe.addon[i].addonindex].memory > 0 then
				mainframe.addon[i].totalmemorytext:SetText(
				string.format("%.2f",mainframe.addons[mainframe.addon[i].addonindex].memory))
				mainframe.addon[i].percentagememorytext:SetText(
				string.format("%.1f",mainframe.addons[mainframe.addon[i].addonindex].memory/mainframe.totalmemory*100))
				
				mainframe.addon[i].percentagememorytext:SetTextColor(.4,1,.4)
				if mainframe.addons[mainframe.addon[i].addonindex].memory/mainframe.totalmemory > .30 then
					mainframe.addon[i].percentagememorytext:SetTextColor(1,.4,.4)
				elseif mainframe.addons[mainframe.addon[i].addonindex].memory/mainframe.totalmemory > .10 then
					mainframe.addon[i].percentagememorytext:SetTextColor(1,1,.4)
				end
			else
				mainframe.addon[i].totalmemorytext:SetText("--")
				mainframe.addon[i].percentagememorytext:SetText("--")
			end
			
			-- Enable box
			mainframe.addon[i].enabledbox:Show()
			if mainframe.addons[mainframe.addon[i].addonindex].enabled then
				mainframe.addon[i].enabledbox:SetChecked(true)
			else
				mainframe.addon[i].enabledbox:SetChecked(false)
			end
			
			-- Status box
			--mainframe.addon[i].statustext:EnableMouse(false)
			mainframe.addon[i].statusbox:Hide()
			if IsAddOnLoaded(mainframe.addon[i].addonindex) then
				if mainframe.addons[mainframe.addon[i].addonindex].enabled then
					mainframe.addon[i].statustext:SetText("Loaded")
					mainframe.addon[i].statustext:SetTextColor(.4,1,.4)
				else
					mainframe.addon[i].statustext:SetText("Will disable on next reload")
					mainframe.addon[i].statustext:SetTextColor(1,.4,.4)
				end
			else
				if mainframe.addons[mainframe.addon[i].addonindex].loadable then
					mainframe.addon[i].statustext:SetText("Click to LoadOnDemand")
					mainframe.addon[i].statustext:SetTextColor(1,1,.4)
					mainframe.addon[i].statusbox:Show()
				elseif mainframe.addons[mainframe.addon[i].addonindex].enabled then
					if mainframe.addons[mainframe.addon[i].addonindex].reason == "DEP_DISABLED" then
						mainframe.addon[i].statustext:SetText("Missing Dependencies")
						mainframe.addon[i].statustext:SetTextColor(1,.4,.4)
					else
						mainframe.addon[i].statustext:SetText("Will start on next reload")
						mainframe.addon[i].statustext:SetTextColor(1,1,.4)
					end
				else
					mainframe.addon[i].statustext:SetText("Disabled")
					mainframe.addon[i].statustext:SetTextColor(1,.4,.4)
				end
			end
			
			-- Dependencies
			if table.getn(mainframe.addons[mainframe.addon[i].addonindex].dependencies) == 0 then
				mainframe.addon[i].dependencebox:Hide()
			else
				mainframe.addon[i].dependencebox:Show()
			end
		end
	end
	
	mainframe.totalcputext2:SetText(string.format("%.1f",mainframe.totalcpu))
	mainframe.totalmemorytext2:SetText(string.format("%.1f",mainframe.totalmemory))
	
	local numenabled,numdisabled = 0,0
	for i=1,GetNumAddOns() do
		if mainframe.addons[i].enabled and not IsAddOnLoaded(i) and not IsAddOnLoadOnDemand(i) then
			numenabled = numenabled + 1
		elseif not mainframe.addons[i].enabled and IsAddOnLoaded(i) then
			numdisabled = numdisabled + 1
		end
	end
	mainframe.addonsenabledtext:SetText("")
	if numenabled == 1 then
		mainframe.addonsenabledtext:SetText("1 addon enabled for next reload")
	end
	if numenabled > 1 then
		mainframe.addonsenabledtext:SetText(numenabled.." addons enabled for next reload")
	end
	mainframe.addonsdisabledtext:SetText("")
	if numdisabled == 1 then
		mainframe.addonsdisabledtext:SetText("1 addon disabled for next reload")
	end
	if numdisabled > 1 then
		mainframe.addonsdisabledtext:SetText(numdisabled.." addons disabled for next reload")
	end
end

mainframe:SetScript("OnShow",mainframe.updateaddondisplay)

mainframe:RegisterEvent("PLAYER_LOGIN")
mainframe:SetScript("OnEvent",function()
	if event == "PLAYER_LOGIN" then
		local name, title, notes, enabled, loadable, reason, security, dependencies
		for i=1,GetNumAddOns() do
			name, title, notes, enabled, loadable, reason, security = GetAddOnInfo(i)
			dependencies = {GetAddOnDependencies(i)}
			mainframe.addons[i] = {name=name,title=title,notes=notes,enabled=enabled,loadable=loadable,reason=reason,security=security,dependencies=dependencies}
		end
		
		this.cpuprofilingbox:SetChecked(true)
		this.cpuprofilingtext:SetTextColor(0,1,0)
		if GetCVar("scriptProfile") == "0" then
			this.cpuprofilingbox:SetChecked(false)
			this.cpuprofilingtext:SetTextColor(1,0,0)
		end
		mainframe.updateaddondisplay()
	end
end)

mainframe.resetcpubutton:SetScript("OnClick",function()
	ResetCPUUsage()
	for i=1,GetNumAddOns() do
		mainframe.addons[i].cpu = 0
	end
	mainframe.totalcpu = 0
	mainframe.updateaddondisplay()
end)

mainframe.updatecpubutton:SetScript("OnClick",function()
	UpdateAddOnCPUUsage()
	mainframe.totalcpu = 0
	for i=1,GetNumAddOns() do
		mainframe.addons[i].cpu = GetAddOnCPUUsage(i)
		mainframe.totalcpu = mainframe.totalcpu + mainframe.addons[i].cpu
	end
	mainframe.updateaddondisplay()
end)

mainframe.updatememorybutton:SetScript("OnClick",function()
	UpdateAddOnMemoryUsage()
	mainframe.totalmemory = 0
	for i=1,GetNumAddOns() do
		mainframe.addons[i].memory = GetAddOnMemoryUsage(i)
		mainframe.totalmemory = mainframe.totalmemory + mainframe.addons[i].memory
	end
	mainframe.updateaddondisplay()
end)

mainframe.scrollupbutton:SetScript("OnClick",function()
	mainframe.scrolladdons(-10)
	mainframe.updateaddondisplay()
end)
mainframe.scrolldownbutton:SetScript("OnClick",function()
	mainframe.scrolladdons(10)
	mainframe.updateaddondisplay()
end)

mainframe.enableallbutton:SetScript("OnClick",function()
	EnableAllAddOns()
	for i=1,GetNumAddOns() do
		mainframe.addons[i].enabled = true
	end
	mainframe.updateaddondisplay()
end)
mainframe.disableallbutton:SetScript("OnClick",function()
	DisableAllAddOns()
	for i=1,GetNumAddOns() do
		mainframe.addons[i].enabled = false
	end
	mainframe.updateaddondisplay()
end)

mainframe:Hide()
SlashCmdList["AM"] = function()
	mainframe:Show()
end