
AS_VERSION = "1.0.4";

function AS_RegisterLocalization()
  AS_ADDON_NAME = "ActionSwap";
  AS_PROFILE_CUSTOM = "custom";
  
  AS_COL_GR = "|cff80ff80";     -- Light green.
  AS_COL_BL = "|cff8080ff";     -- Light blue.
  AS_NRM = "|r";                -- Restores text to normal.
  
  AS_COMMAND_TEST = "test";
  AS_COMMAND_PROFILES = "profiles";
  AS_COMMAND_CREATE = "create";
  AS_COMMAND_CREATE_SYNTAX = "Syntax: /actionswap create <profile name>";
  AS_COMMAND_DELETE = "delete";
  AS_COMMAND_DELETE_SYNTAX = "Syntax: /actionswap delete <profile name>";
  AS_COMMAND_PROFILE = "profile";
  AS_COMMAND_REPLACE = "replace";
  AS_COMMAND_REPLACE_SYNTAX = "Syntax: /actionswap replace <profile name>";
  AS_COMMAND_DELETEALL = "deleteall";
  AS_COMMAND_DELETEALL_2 = "delete-all";
  AS_COMMAND_RAISE_SPELLS = "raise_spells";
  AS_COMMAND_RAISE_SPELLS_2 = "raise-spells";
  
  AS_LISTPROFILES_LINE1 = "ActionSwap profiles available for this character: ";
  AS_LISTPROFILES_LINE2 = "Current profile: ";
  
  AS_SYNTAX = {"ActionSwap syntax:",
    "  /actionswap or /as - display this help page.",
    AS_COL_BL .. "Primary commands:" .. AS_NRM,
    "  /actionswap " .. AS_COL_GR .. "create" .. AS_NRM .. " <profile name> - create a new profile",
    "  /actionswap " .. AS_COL_GR .. "delete" .. AS_NRM .. " <profile name> - delete a profile",
    "  /actionswap " .. AS_COL_GR .. "profile" .. AS_NRM .. " <profile name> - switch profiles",
    "  /actionswap " .. AS_COL_GR .. "profiles" .. AS_NRM .. " - list the available profiles",
    AS_COL_BL .. "Other commands:" .. AS_NRM,
    "  /actionswap " .. AS_COL_GR .. "replace" .. AS_NRM .. " <profile name> - replace a profile with current setup",
    "  /actionswap " .. AS_COL_GR .. "deleteall" .. AS_NRM .. " - delete all profiles",
    "  /actionswap " .. AS_COL_GR .. "raise_spells" .. AS_NRM .. " - raises all spells on the action bar to their highest rank"};
  
  AS_ERROR_ONLY_CHARACTERSPECIFIC = "Error: ActionSwap only works when character-specific key bindings are enabled.  Enable character-specific key bindings and type '/console reloadui' to enable ActionSwap.";
  AS_ERROR_CANT_DELETE_CUSTOM_PROFILE = "Error: Can't delete the 'custom' profile because it has special functionality.";
  AS_ERROR_INITIAL_VERIFY_FAILED = "Error: Your current action bar and key binding settings do not match the current profile.  I'm switching to the 'custom' profile so I don't mess up your saved action bars.";
  AS_ERROR_PROFILE_ALREADY_EXISTS = "Error: Profile already exists.";
  AS_ERROR_PROFILE_DOESNT_EXIST = "Error: Profile doesn't exist.";
  AS_ERROR_UNKNOWN_COMMAND_1 = "Error: Unknown command: '";
  AS_ERROR_UNKNOWN_COMMAND_2 = "'";
  AS_ERROR_UNKNOWN_ACTION_TYPE_1 = "Error: Unknown action button type: '";
  AS_ERROR_UNKNOWN_ACTION_TYPE_2 = "'";
  AS_ERROR_CANT_REPLACE_CUSTOM = "Error: Cannot replace 'custom' profile because it has special functionality.";
  
  AS_WARN_COULDNT_LOCATE_SPELL_1 = "Warning: Could not locate spell '";
  AS_WARN_COULDNT_LOCATE_SPELL_2 = "'";
  AS_WARN_COULDNT_LOCATE_ITEM = "Warning: Could not locate item: ";
  AS_WARN_COULDNT_LOCATE_MACRO_1 = "Warning: Could not locate macro '";
  AS_WARN_COULDNT_LOCATE_MACRO_2 = "'";
  AS_WARN_VERIFY_FAILED_1 = "|cFFFF0000ActionSwap Warning:|r|nYour current action bar / key binding setup does not match the current ActionSwap profile, so I'm switching to the 'custom' profile.  This probably means that your action bar or key binding setup was modified while this mod was disabled.  I recommend either:|n|na) Replace an existing profile with your current setup via|n  " .. AS_COL_GR .. "/as replace <profile>" .. AS_NRM .. "|nb) Create a new profile with your current setup via|n  " .. AS_COL_GR .. "/as create <profile>" .. AS_NRM .. "|n|nIf you switch to another profile before performing one of the two steps above, you will not be able to recover your current action bar / key binding setup.|n|n(The profile that caused this error is: " .. AS_COL_GR;
  AS_WARN_VERIFY_FAILED_2 = AS_NRM .. ")";
  
  AS_MSG_LOADED = AS_COL_GR .. "ActionSwap v" .. AS_VERSION .. " loaded." .. AS_NRM;
  AS_MSG_CREATED_PROFILE_1 = "ActionSwap profile " .. AS_COL_GR;
  AS_MSG_CREATED_PROFILE_2 = AS_NRM .. " created based on current settings.  Type /as profile to switch to another profile.";
  AS_MSG_PROFILE_SET_TO_1 = "Switched to ActionSwap profile " .. AS_COL_GR;
  AS_MSG_PROFILE_SET_TO_2 = AS_NRM;
  AS_MSG_DELETED_PROFILE_1 = "Deleted ActionSwap profile " .. AS_COL_GR;
  AS_MSG_DELETED_PROFILE_2 = AS_NRM;
  AS_MSG_DELETED_ALL = "All ActionSwap profiles deleted.";
  AS_MSG_ALREADY_RAISED = "All spells are already at their highest rank.";
  AS_MSG_REPLACED_PROFILE_1 = "Replaced ActionSwap profile " .. AS_COL_GR;
  AS_MSG_REPLACED_PROFILE_2 = AS_NRM .. " with current settings.";
end
