--[[

ARL-Tailor.lua

Tailoring data for all of AckisRecipeList

$Date: 2008-07-15 15:23:30 +0000 (Tue, 15 Jul 2008) $
$Rev: 748 $

]]--

local L			= LibStub("AceLocale-3.0"):GetLocale("Ackis Recipe List")
local BFAC		= LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BZONE		= LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BBOSS		= LibStub("LibBabble-Boss-3.0"):GetLookupTable()

local addon = AckisRecipeList

function addon:InitTailoring()

	-- Trainer Recipes
	self:addTradeSkillSpell(2963, 1, L["Trainer"],1,10)
	self:addTradeSkillSpell(2387, 1, L["Trainer"],1,10)
	self:addTradeSkillSpell(2393, 1, L["Trainer"],1,10)
	self:addTradeSkillSpell(3915, 1, L["Trainer"],1,10)
	self:addTradeSkillSpell(12044, 1, L["Trainer"],1,10)
	self:addTradeSkillSpell(2385, 10, L["Trainer"],1,10)
	self:addTradeSkillSpell(8776, 15, L["Trainer"],1,10)
	self:addTradeSkillSpell(12045, 20, L["Trainer"],1,10)
	self:addTradeSkillSpell(3914, 30, L["Trainer"],1,10)
	self:addTradeSkillSpell(7623, 30, L["Trainer"],1,10)
	self:addTradeSkillSpell(7624, 30, L["Trainer"],1,10)
	self:addTradeSkillSpell(3840, 35, L["Trainer"],1,10)
	self:addTradeSkillSpell(2392, 40, L["Trainer"],1,10)
	self:addTradeSkillSpell(2394, 40, L["Trainer"],1,10)
	self:addTradeSkillSpell(8465, 40, L["Trainer"],1,10)
	self:addTradeSkillSpell(3755, 45, L["Trainer"],1,10)
	self:addTradeSkillSpell(2397, 60, L["Trainer"],1,10)
	self:addTradeSkillSpell(3841, 60, L["Trainer"],1,10)
	self:addTradeSkillSpell(2386, 65, L["Trainer"],1,10)
	self:addTradeSkillSpell(2395, 70, L["Trainer"],1,10)
	self:addTradeSkillSpell(2964, 75, L["Trainer"],1,10)
	self:addTradeSkillSpell(2402, 75, L["Trainer"],1,10)
	self:addTradeSkillSpell(12046, 75, L["Trainer"],1,10)
	self:addTradeSkillSpell(3845, 80, L["Trainer"],1,10)
	self:addTradeSkillSpell(3757, 80, L["Trainer"],1,10)
	self:addTradeSkillSpell(2399, 85, L["Trainer"],1,10)
	self:addTradeSkillSpell(3843, 85, L["Trainer"],1,10)
	self:addTradeSkillSpell(6521, 90, L["Trainer"],1,10)
	self:addTradeSkillSpell(2396, 70, L["Trainer"],1,10)
	self:addTradeSkillSpell(3842, 70, L["Trainer"],1,10)
	self:addTradeSkillSpell(2401, 95, L["Trainer"],1,10)
	self:addTradeSkillSpell(2406, 100, L["Trainer"],1,10)
	self:addTradeSkillSpell(3848, 110, L["Trainer"],1,10)
	self:addTradeSkillSpell(3850, 110, L["Trainer"],1,10)
	self:addTradeSkillSpell(8467, 110, L["Trainer"],1,10)
	self:addTradeSkillSpell(3839, 125, L["Trainer"],1,10)
	self:addTradeSkillSpell(3855, 125, L["Trainer"],1,10)
	self:addTradeSkillSpell(3866, 110, L["Trainer"],1,10)
	self:addTradeSkillSpell(3852, 130, L["Trainer"],1,10)
	self:addTradeSkillSpell(6690, 135, L["Trainer"],1,10)
	self:addTradeSkillSpell(8758, 140, L["Trainer"],1,10)
	self:addTradeSkillSpell(8760, 145, L["Trainer"],1,10)
	self:addTradeSkillSpell(3859, 150, L["Trainer"],1,10)
	self:addTradeSkillSpell(3813, 150, L["Trainer"],1,10)
	self:addTradeSkillSpell(8483, 160, L["Trainer"],1,10)
	self:addTradeSkillSpell(8762, 160, L["Trainer"],1,10)
	self:addTradeSkillSpell(3871, 170, L["Trainer"],1,10)
	self:addTradeSkillSpell(8764, 170, L["Trainer"],1,10)
	self:addTradeSkillSpell(3865, 175, L["Trainer"],1,10)
	self:addTradeSkillSpell(8489, 175, L["Trainer"],1,10)
	self:addTradeSkillSpell(8766, 175, L["Trainer"],1,10)
	self:addTradeSkillSpell(8772, 175, L["Trainer"],1,10)
	self:addTradeSkillSpell(8774, 180, L["Trainer"],1,10)
	self:addTradeSkillSpell(3861, 185, L["Trainer"],1,10)
	self:addTradeSkillSpell(8791, 185, L["Trainer"],1,10)
	self:addTradeSkillSpell(8770, 190, L["Trainer"],1,10)
	self:addTradeSkillSpell(8799, 195, L["Trainer"],1,10)
	self:addTradeSkillSpell(12048, 205, L["Trainer"],1,10)
	self:addTradeSkillSpell(12049, 205, L["Trainer"],1,10)
	self:addTradeSkillSpell(8804, 210, L["Trainer"],1,10)
	self:addTradeSkillSpell(12050, 210, L["Trainer"],1,10)
	self:addTradeSkillSpell(12052, 210, L["Trainer"],1,10)
	self:addTradeSkillSpell(12053, 215, L["Trainer"],1,10)
	self:addTradeSkillSpell(12055, 215, L["Trainer"],1,10)
	self:addTradeSkillSpell(12061, 215, L["Trainer"],1,10)
	self:addTradeSkillSpell(12065, 225, L["Trainer"],1,10)
	self:addTradeSkillSpell(12067, 225, L["Trainer"],1,10)
	self:addTradeSkillSpell(12069, 225, L["Trainer"],1,10)
	self:addTradeSkillSpell(12070, 225, L["Trainer"],1,10)
	self:addTradeSkillSpell(12071, 225, L["Trainer"],1,10)
	self:addTradeSkillSpell(12072, 230, L["Trainer"],1,10)
	self:addTradeSkillSpell(12073, 230, L["Trainer"],1,10)
	self:addTradeSkillSpell(12074, 230, L["Trainer"],1,10)
	self:addTradeSkillSpell(12076, 235, L["Trainer"],1,10)
	self:addTradeSkillSpell(12077, 235, L["Trainer"],1,10)
	self:addTradeSkillSpell(12079, 235, L["Trainer"],1,10)
	self:addTradeSkillSpell(12082, 240, L["Trainer"],1,10)
	self:addTradeSkillSpell(12088, 245, L["Trainer"],1,10)
	self:addTradeSkillSpell(12092, 250, L["Trainer"],1,10)
	self:addTradeSkillSpell(18401, 250, L["Trainer"],1,10)
	self:addTradeSkillSpell(18402, 255, L["Trainer"],1,10)
	self:addTradeSkillSpell(18417, 275, L["Trainer"],1,10)
	self:addTradeSkillSpell(18423, 280, L["Trainer"],1,10)
	self:addTradeSkillSpell(31460, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(26745, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(26764, 310, L["Trainer"],1,10)
	self:addTradeSkillSpell(26765, 310, L["Trainer"],1,10)
	self:addTradeSkillSpell(26746, 315, L["Trainer"],1,10)
	self:addTradeSkillSpell(26770, 320, L["Trainer"],1,10)
	self:addTradeSkillSpell(26771, 325, L["Trainer"],1,10)
	self:addTradeSkillSpell(26772, 335, L["Trainer"],1,10)
	self:addTradeSkillSpell(18438, 285, L["Trainer"],1,10)
	self:addTradeSkillSpell(18442, 290, L["Trainer"],1,10)
	self:addTradeSkillSpell(18437, 285, L["Trainer"],1,10)
	self:addTradeSkillSpell(18444, 295, L["Trainer"],1,10)
	self:addTradeSkillSpell(18449, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(18453, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(18451, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(18446, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(18450, 300, L["Trainer"],1,10)
	self:addTradeSkillSpell(18441, 290, L["Trainer"],1,10)

	-- Skill Cap Increases
	--self:addTradeSkillSpell(3912, 50, L["Trainer"], L["Journeyman"])
	--self:addTradeSkillSpell(3913, 125, L["Trainer"], L["Expert"])
	
	-- Vendor Recipes
	self:addTradeSkillSpell(7639, 100, self:CombineVendors(52,5,7,26,18, false),2,10)
	self:addTradeSkillSpell(7630, 55, self:CombineVendors(1, 2, 3, 4, 5, false),2,10)
	self:addTradeSkillSpell(6686, 70, self:CombineVendors(6, 2, 7, 8, 9, false),2,10)
	self:addTradeSkillSpell(7633, 70, self:CombineVendors(1, 6, 10, 11, 12, false),2,10)
	self:addTradeSkillSpell(6688, 115, self:CombineVendors(13, 5, 14, 15, 9, 16, 17, 18, 19, false),2,10)
	self:addTradeSkillSpell(7643, 115, self:CombineVendors(11, 14, 16, 12, 17, 20, false),2,10)
	self:addTradeSkillSpell(3869, 135, self:CombineVendors(21, false), BFAC["Alliance"],2,10)
	self:addTradeSkillSpell(3854, 145, self:CombineVendors(24, 25, false),2,10)
	self:addTradeSkillSpell(3870, 155, self:CombineVendors(20, 26, false),2,10)
	self:addTradeSkillSpell(3857, 165, self:CombineVendors(27, false),2,10)
	self:addTradeSkillSpell(8786, 175, self:CombineVendors(22, 23, false),2,10)
	self:addTradeSkillSpell(8789, 180, self:CombineVendors(27, false),2,10)
	self:addTradeSkillSpell(3862, 200, self:CombineVendors(28, 29, false),2,10)
	self:addTradeSkillSpell(3873, 200, self:CombineVendors(30, false),2,10)
	self:addTradeSkillSpell(8802, 205, self:CombineVendors(31, false),2,10)
	self:addTradeSkillSpell(12064, 220, self:CombineVendors(9, 11, false),2,10)
	self:addTradeSkillSpell(27658, 225, self:CombineVendors(32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, false),2,10)
	self:addTradeSkillSpell(12075, 230, self:CombineVendors(5, 50, false),2,10)
	self:addTradeSkillSpell(12080, 235, self:CombineVendors(5, 50, false),2,10)
	self:addTradeSkillSpell(12081, 240,self:CombineVendors(51, false),2,10)
	self:addTradeSkillSpell(12085, 240, self:CombineVendors(16, 50, false),2,10)
	self:addTradeSkillSpell(12089, 245, self:CombineVendors(16, 50, false),2,10)
	self:addTradeSkillSpell(12091, 250, self:CombineVendors(9, 52, false),2,10)
	self:addTradeSkillSpell(12093, 250, self:CombineVendors(16, 50, false),2,10)
	self:addTradeSkillSpell(18560, 250, self:CombineVendors(53, false),2,10)
	self:addTradeSkillSpell(18406, 260, self:CombineVendors(55, false),2,10)
	self:addTradeSkillSpell(18405, 260, self:CombineVendors(53, false),2,10)
	self:addTradeSkillSpell(26085, 260, self:CombineVendors(31, false),2,10)
	self:addTradeSkillSpell(18409, 265, self:CombineVendors(55, false),2,10)
	self:addTradeSkillSpell(18419, 275, self:CombineVendors(56, false),2,10)
	self:addTradeSkillSpell(27659, 275, self:CombineVendors(39, false),2,10)
	self:addTradeSkillSpell(27724, 275, self:CombineVendors(57, false),2,10)
	self:addTradeSkillSpell(22902, 300, self:CombineVendors(54, false),2,10)
	self:addTradeSkillSpell(26747, 325, self:CombineVendors(58, 59, 60, false),2,10)
	self:addTradeSkillSpell(26749, 340, self:CombineVendors(59, 61, false),2,10)
	self:addTradeSkillSpell(26773, 340, self:CombineVendors(58, 59, 60, false),2,10)
	self:addTradeSkillSpell(26775, 340, self:CombineVendors(63, 64, false),2,10)
	self:addTradeSkillSpell(26750, 345, self:CombineVendors(153, 58, 61, 60, false),2,10)
	self:addTradeSkillSpell(26774, 345, self:CombineVendors(58, 59, 60, false),2,10)
	self:addTradeSkillSpell(26751, 350, self:CombineVendors(139, false),2,10)
	self:addTradeSkillSpell(26776, 350, self:CombineVendors(63, 64, false),2,10)
	self:addTradeSkillSpell(31373, 350, self:CombineVendors(65, false),2,10)
	self:addTradeSkillSpell(36686, 350, self:CombineVendors(66, false),2,10)
	self:addTradeSkillSpell(26779, 355, self:CombineVendors(61, 153, false),2,10)
	self:addTradeSkillSpell(26777, 360, self:CombineVendors(62, false),2,10)
	self:addTradeSkillSpell(26778, 360, self:CombineVendors(62, false),2,10)
	self:addTradeSkillSpell(26755, 375, self:CombineVendors(65, false),2,10)
	self:addTradeSkillSpell(26759, 375, self:CombineVendors(66, false),2,10)
	self:addTradeSkillSpell(26763, 375, self:CombineVendors(139, false),2,10)
	self:addTradeSkillSpell(26760, 355, self:CombineVendors(139, false), GetSpellInfo(26798),2,10)
	self:addTradeSkillSpell(26761, 365, self:CombineVendors(139, false), GetSpellInfo(26798),2,10)
	self:addTradeSkillSpell(26762, 375, self:CombineVendors(139, false), GetSpellInfo(26798),2,10)
	self:addTradeSkillSpell(26756, 355, self:CombineVendors(66, false), GetSpellInfo(26801),2,10)
	self:addTradeSkillSpell(26757, 365, self:CombineVendors(66, false), GetSpellInfo(26801),2,10)
	self:addTradeSkillSpell(26758, 375, self:CombineVendors(66, false), GetSpellInfo(26801),2,10)
	self:addTradeSkillSpell(26752, 355, self:CombineVendors(65, false), GetSpellInfo(26797),2,10)
	self:addTradeSkillSpell(26753, 365, self:CombineVendors(65, false), GetSpellInfo(26797),2,10)
	self:addTradeSkillSpell(26754, 370, self:CombineVendors(65, false), GetSpellInfo(26797),2,10)
	self:addTradeSkillSpell(49677, 250, self:CombineVendors(286, false),2,10)
	self:addTradeSkillSpell(50644, 250, self:CombineVendors(286, false),2,10)
	self:addTradeSkillSpell(50647, 245, self:CombineVendors(286, false),2,10)

	-- World Drops
	self:addTradeSkillSpell(2389, 40, L["UWD"],3,10)
	self:addTradeSkillSpell(7629, 55, L["UWD"],3,10)
	self:addTradeSkillSpell(3847, 95, L["UWD"],3,10)
	self:addTradeSkillSpell(3758, 95, L["UWD"],3,10)
	self:addTradeSkillSpell(3844, 100, L["UWD"],3,10)
	self:addTradeSkillSpell(2403, 105, L["UWD"],3,10)
	self:addTradeSkillSpell(3849, 120, L["UWD"],3,10)
	self:addTradeSkillSpell(7892, 120, L["UWD"],3,10)
	self:addTradeSkillSpell(7893, 120, L["UWD"],3,10)
	self:addTradeSkillSpell(12047, 120, L["UWD"],3,10)
	self:addTradeSkillSpell(3851, 125, L["UWD"],3,10)
	self:addTradeSkillSpell(3868, 125, L["UWD"],3,10)
	self:addTradeSkillSpell(3856, 140, L["UWD"],3,10)
	self:addTradeSkillSpell(8780, 145, L["UWD"],3,10)
	self:addTradeSkillSpell(8782, 150, L["UWD"],3,10)
	self:addTradeSkillSpell(8784, 165, L["UWD"],3,10)
	self:addTradeSkillSpell(3858, 170, L["UWD"],3,10)
	self:addTradeSkillSpell(3860, 175, L["UWD"],3,10)
	self:addTradeSkillSpell(6693, 175, L["UWD"],3,10)
	self:addTradeSkillSpell(3863, 180, L["UWD"],3,10)
	self:addTradeSkillSpell(3872, 185, L["UWD"],3,10)
	self:addTradeSkillSpell(8793, 190, L["UWD"],3,10)
	self:addTradeSkillSpell(8795, 190, L["UWD"],3,10)
	self:addTradeSkillSpell(8797, 195, L["UWD"],3,10)
	self:addTradeSkillSpell(3864, 200, L["UWD"],3,10)
	self:addTradeSkillSpell(12056, 215, L["UWD"],3,10)
	self:addTradeSkillSpell(12059, 215, L["UWD"],3,10)
	self:addTradeSkillSpell(12060, 215, L["UWD"],3,10)
	self:addTradeSkillSpell(12066, 225, L["UWD"],3,10)
	self:addTradeSkillSpell(12078, 235, L["UWD"],3,10)
	self:addTradeSkillSpell(12084, 240, L["UWD"],3,10)
	self:addTradeSkillSpell(18403, 255, L["UWD"],3,10)
	self:addTradeSkillSpell(18404, 255, L["UWD"],3,10)
	self:addTradeSkillSpell(18407, 260, L["UWD"],3,10)
	self:addTradeSkillSpell(18411, 265, L["UWD"],3,10)
	self:addTradeSkillSpell(18415, 270, L["UWD"],3,10)
	self:addTradeSkillSpell(18414, 270, L["UWD"],3,10)
	self:addTradeSkillSpell(18420, 275, L["UWD"],3,10)
	self:addTradeSkillSpell(18424, 280, L["UWD"],3,10)
	self:addTradeSkillSpell(18439, 290, L["UWD"],3,10)
	self:addTradeSkillSpell(18440, 290, L["UWD"],3,10)
	self:addTradeSkillSpell(18445, 300, L["UWD"],3,10)
	self:addTradeSkillSpell(18447, 300, L["UWD"],3,10)
	self:addTradeSkillSpell(18448, 300, L["UWD"],3,10)
	self:addTradeSkillSpell(18452, 300, L["RWD"],3,10)
	self:addTradeSkillSpell(18454, 300, L["EWD"],3,10)
	self:addTradeSkillSpell(18455, 300, L["RWD"],3,10)
	self:addTradeSkillSpell(31434, 350, L["RWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5,10)
	self:addTradeSkillSpell(31435, 350, L["UWD"],3,10)
	self:addTradeSkillSpell(31437, 350, L["UWD"],3,10)
	self:addTradeSkillSpell(31438, 350, L["UWD"],3,10)
	self:addTradeSkillSpell(31440, 350, L["UWD"],3,10)
	self:addTradeSkillSpell(31441, 350, L["UWD"],3,10)
	self:addTradeSkillSpell(31442, 365, L["EWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5,10)
	self:addTradeSkillSpell(31443, 365, L["EWD"],3,10)
	self:addTradeSkillSpell(31444, 365, L["UWD"],3,10)
	self:addTradeSkillSpell(31448, 365, L["UWD"],3,10)
	self:addTradeSkillSpell(31449, 365, L["UWD"],3,10)
	self:addTradeSkillSpell(31450, 365, L["UWD"],3,10)

	-- Seasonal
 	self:addTradeSkillSpell(21945, 190, L["WintersVeil"],7,10)
	self:addTradeSkillSpell(44958, 250, L["WintersVeil"],7,BFAC["Alliance"],10)
	self:addTradeSkillSpell(44950, 250, L["WintersVeil"],7,BFAC["Horde"],10)
	self:addTradeSkillSpell(26407, 250, L["WintersVeil"],7,10)
 	self:addTradeSkillSpell(26403, 250, L["Lunar Festival"],7,10)

	-- Specific Drops
	self:addTradeSkillSpell(6692, 150, self:CombineMobs(true,L["Robes of Arcana Obt"],BZONE["Darkshore"]) .. addon.br .. self:CombineMobs(true,L["Robes of Arcana Obt1"],BZONE["Duskwood"]),3,10)
	self:addTradeSkillSpell(6695, 185, self:CombineMobs(true,L["Black Silk Pack Obt"],BZONE["Alterac Mountains"]) .. addon.br .. self:CombineMobs(true,L["Black Silk Pack Obt1"],BZONE["Dustwallow Marsh"]) .. addon.br .. self:CombineMobs(true,L["Black Silk Pack Obt2"],BZONE["Hillsbrad Foothills"]),3,10)
	self:addTradeSkillSpell(12086, 245, self:CombineQuests(L["Shadoweave Mask Obt"],0,BZONE["Searing Gorge"]),8,10)
	self:addTradeSkillSpell(18408, 260, self:CombineMobs(true,L["Cindercloth Vest Obt"],BZONE["Searing Gorge"]),3,10)
	self:addTradeSkillSpell(18410, 265, self:CombineMobs(true,L["Ghostweave Belt Obt"],BZONE["Azshara"]),3,10)
	self:addTradeSkillSpell(18412, 270, self:CombineMobs(true,L["Cindercloth Gloves Obt"],BZONE["Searing Gorge"]),3,10)
	self:addTradeSkillSpell(18413, 270, self:CombineMobs(true,L["Ghostweave Gloves Obt"],BZONE["Azshara"]) .. addon.br .. self:CombineMobs(true,L["Ghostweave Gloves Obt1"],BZONE["Eastern Plaguelands"]),3,10)
	self:addTradeSkillSpell(18416, 275, self:CombineMobs(true,L["Ghostweave Vest Obt"],BZONE["Eastern Plaguelands"]),3,10)
	self:addTradeSkillSpell(18418, 275, self:CombineMobs(true,L["Cindercloth Cloak Obt"],BZONE["Burning Steppes"]),3,10)
	self:addTradeSkillSpell(18421, 275, self:CombineMobs(true,L["Wizardweave Leggings Obt"],BZONE["Eastern Plaguelands"] .. " " .. BZONE["Stratholme"]),3,10)
	self:addTradeSkillSpell(18422, 275, self:CombineMobs(false,L["Cloak of Fire Obt"],BZONE["Blackrock Mountain"]),4,10)
	self:addTradeSkillSpell(18434, 280, self:CombineMobs(true,L["Cindercloth Pants Obt"],BZONE["Burning Steppes"]),3,10)
	self:addTradeSkillSpell(18436, 285, self:CombineMobs(false,L["Robe of Winter Night Obt"],BZONE["Winterspring"]),4,10)
	self:addTradeSkillSpell(26086, 285, self:CombineMobs(false,L["Felcloth Bag Obt"],BZONE["Scholomance"]),4,5,10)
	self:addTradeSkillSpell(19435, 290, self:CombineQuests(L["Mooncloth Boots Obt"],0,BZONE["Felwood"]),8,10)
	self:addTradeSkillSpell(22813, 300, self:CombineQuests(L["Gordok Ogre Suit Obt"],0,BZONE["Dire Maul"]),5,10)
	self:addTradeSkillSpell(18456, 300, self:CombineMobs(true,BBOSS["Balnazzar"],BZONE["Stratholme"]),"PRIEST",3,5,10)
	self:addTradeSkillSpell(18457, 300, self:CombineMobs(true,L["Robe of the Archmage Obt"],BZONE["Lower Blackrock Spire"]),"MAGE",3,5,10)
	self:addTradeSkillSpell(18458, 300, self:CombineMobs(true,BBOSS["Darkmaster Gandling"],BZONE["Scholomance"]),"WARLOCK",3,5,10)
	self:addTradeSkillSpell(22866, 300, self:CombineMobs(false,L["DMCACHE"],BZONE["Dire Maul"]),4,5,10)
	self:addTradeSkillSpell(22867, 300, self:CombineMobs(false,L["DMCACHE"],BZONE["Dire Maul"]),4,5,10)
	self:addTradeSkillSpell(22868, 300, self:CombineMobs(false,L["DMCACHE"],BZONE["Dire Maul"]),4,5,10)
	self:addTradeSkillSpell(22869, 300, self:CombineMobs(false,L["DMCACHE"],BZONE["Dire Maul"]),4,5,10)
	self:addTradeSkillSpell(22870, 300, self:CombineMobs(false,L["DMCACHE"],BZONE["Dire Maul"]),4,5,10)
	self:addTradeSkillSpell(24902, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),8,10)
	self:addTradeSkillSpell(24903, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),8,10)
	self:addTradeSkillSpell(24901, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),8,10)
	self:addTradeSkillSpell(27660, 300, self:CombineMobs(true,BBOSS["Magister Kalendris"],BZONE["Dire Maul"]),3,5,10)
	self:addTradeSkillSpell(26782, 350, self:CombineMobs(false,L["Arcanoweave Bracers Obt"],BZONE["The Arcatraz"]),4,5,10)
	self:addTradeSkillSpell(26783, 360, self:CombineMobs(false,L["Arcanoweave Boots Obt"],BZONE["The Mechanar"]),4,5,10)
	self:addTradeSkillSpell(26784, 370, self:CombineMobs(false,BBOSS["Pathaleon the Calculator"],BZONE["The Mechanar"]),4,5,10)
	self:addTradeSkillSpell(31451, 375, self:CombineMobs(false,BBOSS["Dalliah the Doomsayer"],BZONE["The Arcatraz"]),4,5,10)
	self:addTradeSkillSpell(31452, 375, self:CombineMobs(false,BBOSS["Murmur"],BZONE["Shadow Labyrinth"]),4,5,10)
	self:addTradeSkillSpell(31453, 375, self:CombineMobs(false,BBOSS["Thorngrin the Tender"],BZONE["The Botanica"]),4,5,10)
	self:addTradeSkillSpell(31454, 375, self:CombineMobs(false,BBOSS["Warp Splinter"],BZONE["The Botanica"]),4,5,10)
	self:addTradeSkillSpell(31455, 375, self:CombineMobs(false,BBOSS["Grand Warlock Nethekurse"],BZONE["The Shattered Halls"]),4,5,10)
	self:addTradeSkillSpell(31456, 375, self:CombineMobs(false,BBOSS["Warlord Kalithresh"],BZONE["The Steamvault"]),4,5,10)

	-- Reputations
	self:addTradeSkillSpell(23662, 290, self:AddSingleReputation(2, BFAC["Timbermaw Hold"]), BFAC["Timbermaw Hold"],10)
	self:addTradeSkillSpell(23664, 290, self:AddSingleReputation(2, BFAC["Argent Dawn"]), BFAC["Argent Dawn"],10)
	self:addTradeSkillSpell(20848, 300, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"],10)
	self:addTradeSkillSpell(20849, 300, self:AddSingleReputation(1, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"],10)
	self:addTradeSkillSpell(23663, 300, self:AddSingleReputation(3, BFAC["Timbermaw Hold"]), BFAC["Timbermaw Hold"],10)
	self:addTradeSkillSpell(23665, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]), BFAC["Argent Dawn"],10)
	self:addTradeSkillSpell(23666, 300, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"],10)
	self:addTradeSkillSpell(23667, 300, self:AddSingleReputation(3, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"],10)
	self:addTradeSkillSpell(24093, 300, self:AddSingleReputation(1, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6,10)
	self:addTradeSkillSpell(24092, 300, self:AddSingleReputation(2, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6,10)
	self:addTradeSkillSpell(24091, 300, self:AddSingleReputation(3, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6,10)
	self:addTradeSkillSpell(27725, 300, self:AddSingleReputation(3, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"],10)
	self:addTradeSkillSpell(28210, 300, self:AddSingleReputation(3, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"],10)
	self:addTradeSkillSpell(28481, 300, self:AddSingleReputation(2, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"],10)
	self:addTradeSkillSpell(28482, 300, self:AddSingleReputation(1, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"],10)
	self:addTradeSkillSpell(28480, 300, self:AddSingleReputation(3, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"],10)
	self:addTradeSkillSpell(28205, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6,10)
	self:addTradeSkillSpell(28209, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6,10)
	self:addTradeSkillSpell(28207, 300, self:AddSingleReputation(4, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6,10)
	self:addTradeSkillSpell(28208, 300, self:AddSingleReputation(4, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6,10)
	self:addTradeSkillSpell(31430, 335, self:AddSingleReputation(2, BFAC["The Scryers"]), BFAC["The Scryers"],10)
	self:addTradeSkillSpell(31431, 335, self:AddSingleReputation(2, BFAC["The Aldor"]), BFAC["The Aldor"],10)
	self:addTradeSkillSpell(31459, 340, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"],10)
	self:addTradeSkillSpell(37873, 350, self:AddSingleReputation(2, BFAC["Lower City"]), BFAC["Lower City"],10)
	self:addTradeSkillSpell(37882, 350, self:AddSingleReputation(1, BFAC["The Aldor"]), BFAC["The Aldor"],10)
	self:addTradeSkillSpell(37883, 360, self:AddSingleReputation(2, BFAC["The Aldor"]), BFAC["The Aldor"],10)
	self:addTradeSkillSpell(37884, 370, self:AddSingleReputation(4, BFAC["The Aldor"]), BFAC["The Aldor"],10)
	self:addTradeSkillSpell(31432, 375, self:AddSingleReputation(4, BFAC["The Scryers"]), BFAC["The Scryers"],10)
	self:addTradeSkillSpell(31433, 375, self:AddSingleReputation(4, BFAC["The Aldor"]), BFAC["The Aldor"],10)
	self:addTradeSkillSpell(40060, 375, self:AddSingleReputation(2, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6,10)
	self:addTradeSkillSpell(40021, 375, self:AddSingleReputation(1, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6,10)
	self:addTradeSkillSpell(40024, 375, self:AddSingleReputation(1, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6,10)
	self:addTradeSkillSpell(40023, 375, self:AddSingleReputation(2, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6,10)
	self:addTradeSkillSpell(40020, 375, self:AddSingleReputation(2, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6,10)
	if (_G.GameTimeFrame_OnClick) then
		self:addTradeSkillSpell(50194, 375, self:AddSingleReputation(3, BFAC["Sporeggar"]), BFAC["Sporeggar"],10)
	end

	-- Raid Drops
	self:addTradeSkillSpell(22759, 300, L["MOLTENCORE"], 6,10)
	self:addTradeSkillSpell(26087, 300, L["MOLTENCORE"], 6,10)
	self:addTradeSkillSpell(26780, 365, self:CombineMobs(false,L["Soulcloth Shoulders Obt"],BZONE["Karazhan"]), 6,10)
	self:addTradeSkillSpell(26781, 375, self:CombineMobs(false,L["Soulcloth Vest Obt"],BZONE["Karazhan"]), 6,10)
	self:addTradeSkillSpell(36318, 375, L["SSC/TKBoE"], 6,10)
	self:addTradeSkillSpell(36316, 375, L["SSC/TKBoP"], 6,10)
	self:addTradeSkillSpell(36315, 375, L["SSC/TKBoP"], 6,10)
	self:addTradeSkillSpell(36317, 375, L["SSC/TKBoE"], 6,10)
	self:addTradeSkillSpell(41207, 375, L["BT/HYJALBoP"], 6,10)
	self:addTradeSkillSpell(41208, 375, L["BT/HYJALBoE"], 6,10)
	self:addTradeSkillSpell(41205, 375, L["BT/HYJALBoP"], 6,10)
	self:addTradeSkillSpell(41206, 375, L["BT/HYJALBoE"], 6,10)
	self:addTradeSkillSpell(46128, 365, L["SunwellBoP"], 6,10)
	self:addTradeSkillSpell(46129, 365, L["SunwellBoP"], 6,10)
	self:addTradeSkillSpell(46130, 365, L["SunwellBoP"], 6,10)
	self:addTradeSkillSpell(46131, 365, L["SunwellBoP"], 6,10)

end
