--[[

ARL-Jewelcraft.lua

Jewelcrafting data for all of AckisRecipeList

$Date: 2008-09-15 16:38:21 +0000 (Mon, 15 Sep 2008) $
$Rev: 867 $

]]--

local L			= LibStub("AceLocale-3.0"):GetLocale("Ackis Recipe List")
local BFAC		= LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BZONE		= LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BBOSS		= LibStub("LibBabble-Boss-3.0"):GetLookupTable()

local addon = AckisRecipeList

function addon:InitJewelcrafting()

	-- Trainer Recipes
	self:addTradeSkillSpell(25255, 1, L["Trainer"],1)
	self:addTradeSkillSpell(25493, 1, L["Trainer"],1)
	self:addTradeSkillSpell(26925, 1, L["Trainer"],1)
	self:addTradeSkillSpell(32259, 1, L["Trainer"],1)
	self:addTradeSkillSpell(26926, 5, L["Trainer"],1)
	self:addTradeSkillSpell(32178, 20, L["Trainer"],1)
	self:addTradeSkillSpell(32179, 20, L["Trainer"],1)
	self:addTradeSkillSpell(25283, 30, L["Trainer"],1)
	self:addTradeSkillSpell(26928, 30, L["Trainer"],1)
	self:addTradeSkillSpell(25278, 50, L["Trainer"],1)
	self:addTradeSkillSpell(25280, 50, L["Trainer"],1)
	self:addTradeSkillSpell(25490, 50, L["Trainer"],1)
	self:addTradeSkillSpell(26927, 50, L["Trainer"],1)
	self:addTradeSkillSpell(32801, 50, L["Trainer"],1)
	self:addTradeSkillSpell(25284, 60, L["Trainer"],1)
	self:addTradeSkillSpell(37818, 65, L["Trainer"],1)
	self:addTradeSkillSpell(25287, 70, L["Trainer"],1)
	self:addTradeSkillSpell(36523, 75, L["Trainer"],1)
	self:addTradeSkillSpell(38175, 80, L["Trainer"],1)
	self:addTradeSkillSpell(25305, 90, L["Trainer"],1)
	self:addTradeSkillSpell(25317, 80, L["Trainer"],1)
	self:addTradeSkillSpell(25318, 100, L["Trainer"],1)
	self:addTradeSkillSpell(36524, 105, L["Trainer"],1)
	self:addTradeSkillSpell(25498, 110, L["Trainer"],1)
	self:addTradeSkillSpell(32807, 110, L["Trainer"],1)
	self:addTradeSkillSpell(25321, 120, L["Trainer"],1)
	self:addTradeSkillSpell(25613, 135, L["Trainer"],1)
	self:addTradeSkillSpell(25615, 150, L["Trainer"],1)
	self:addTradeSkillSpell(25620, 170, L["Trainer"],1)
	self:addTradeSkillSpell(32808, 175, L["Trainer"],1)
	self:addTradeSkillSpell(25621, 180, L["Trainer"],1)
	self:addTradeSkillSpell(34955, 180, L["Trainer"],1)
	self:addTradeSkillSpell(26872, 200, L["Trainer"],1)
	self:addTradeSkillSpell(34959, 200, L["Trainer"],1)
	self:addTradeSkillSpell(26874, 210, L["Trainer"],1)
	self:addTradeSkillSpell(26876, 220, L["Trainer"],1)
	self:addTradeSkillSpell(26880, 225, L["Trainer"],1)
	self:addTradeSkillSpell(32809, 225, L["Trainer"],1)
	self:addTradeSkillSpell(36525, 230, L["Trainer"],1)
	self:addTradeSkillSpell(26883, 235, L["Trainer"],1)
	self:addTradeSkillSpell(26885, 240, L["Trainer"],1)
	self:addTradeSkillSpell(26902, 260, L["Trainer"],1)
	self:addTradeSkillSpell(36526, 275, L["Trainer"],1)
	self:addTradeSkillSpell(26903, 275, L["Trainer"],1)
	self:addTradeSkillSpell(26907, 280, L["Trainer"],1)
	self:addTradeSkillSpell(26908, 280, L["Trainer"],1)
	self:addTradeSkillSpell(34960, 280, L["Trainer"],1)
	self:addTradeSkillSpell(26911, 290, L["Trainer"],1)
	self:addTradeSkillSpell(34961, 290, L["Trainer"],1)
	self:addTradeSkillSpell(26916, 310, L["Trainer"],1)
	self:addTradeSkillSpell(31048, 310, L["Trainer"],1)
	self:addTradeSkillSpell(31049, 310, L["Trainer"],1)
	self:addTradeSkillSpell(31050, 320, L["Trainer"],1)
	self:addTradeSkillSpell(38068, 325, L["Trainer"],1)
	self:addTradeSkillSpell(31052, 335, L["Trainer"],1)
	self:addTradeSkillSpell(31051, 335, L["Trainer"],1)
	self:addTradeSkillSpell(41414, 325, L["Trainer"],1)
	self:addTradeSkillSpell(41418, 365, L["Trainer"],1)
	self:addTradeSkillSpell(40514, 340, L["Trainer"],1)
	self:addTradeSkillSpell(41420, 325, L["Trainer"],1)
	self:addTradeSkillSpell(41429, 350, L["Trainer"],1)
	self:addTradeSkillSpell(41415, 330, L["Trainer"],1)
	self:addTradeSkillSpell(47280, 350, L["Trainer"],1)

	-- Vendor Recipes
	self:addTradeSkillSpell(25339, 110, self:CombineVendors(190, 191, 192, 193, false),2)
	self:addTradeSkillSpell(25610, 120, self:CombineVendors(112, 194, false),2)
	self:addTradeSkillSpell(25323, 125, self:CombineVendors(195, 12, false),2)
	self:addTradeSkillSpell(25612, 125, self:CombineVendors(110, 29, false),2)
	self:addTradeSkillSpell(25320, 150, self:CombineVendors(190, 201, 212, 192, false),2)
	self:addTradeSkillSpell(25617, 150, self:CombineVendors(24, 29, false),2)
	self:addTradeSkillSpell(25619, 170, self:CombineVendors(190, 202, 203, 192, false),2)
	self:addTradeSkillSpell(26875, 215, self:CombineVendors(197, 116, false),2)
	self:addTradeSkillSpell(26878, 225, self:CombineVendors(111, 113, false),2)
	self:addTradeSkillSpell(26881, 225, self:CombineVendors(116, 205, false),2)
	self:addTradeSkillSpell(26897, 250, self:CombineVendors(190, 202, 192, 206, false),2)
	self:addTradeSkillSpell(26906, 275, self:CombineVendors(57, false),2)
	self:addTradeSkillSpell(26910, 285, self:CombineVendors(207, false),2)
	self:addTradeSkillSpell(28903, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28910, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28916, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28925, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28938, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28950, 300, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(26915, 305, self:CombineVendors(53, false),2)
	self:addTradeSkillSpell(28905, 305, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28917, 305, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28953, 305, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(34590, 305, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28914, 315, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28936, 325, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(28948, 325, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(34069, 325, self:CombineVendors(208, 209, false),2)
	self:addTradeSkillSpell(31101, 350, self:CombineVendors(162, 163, true),9,2)
	self:addTradeSkillSpell(43493, 350, self:CombineVendors(162, 163, true),9,2)
	
	-- World Drops
	self:addTradeSkillSpell(25622, 190, L["UWD"],3)
	self:addTradeSkillSpell(25618, 160, L["UWD"],3)
	self:addTradeSkillSpell(26873, 200, L["UWD"],3)
	self:addTradeSkillSpell(26882, 235, L["UWD"],3)
	self:addTradeSkillSpell(26887, 245, L["UWD"],3)
	self:addTradeSkillSpell(26896, 250, L["UWD"],3)
	self:addTradeSkillSpell(26900, 260, L["UWD"],3)
	self:addTradeSkillSpell(26909, 285, L["UWD"],3)
	self:addTradeSkillSpell(28955, 315, L["UWD"],3)
	self:addTradeSkillSpell(31058, 345, L["UWD"],3)
	self:addTradeSkillSpell(31089, 350, L["RWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5)
	self:addTradeSkillSpell(31096, 350, L["RWD"],3)
	self:addTradeSkillSpell(31112, 350, L["RWD"],3)
	self:addTradeSkillSpell(31085, 350, L["RWD"],3)
	self:addTradeSkillSpell(31110, 350, L["RWD"],3)
	self:addTradeSkillSpell(31106, 350, L["RWD"],3)
	self:addTradeSkillSpell(31091, 350, L["RWD"],3)
	self:addTradeSkillSpell(31099, 350, L["RWD"],3)
	self:addTradeSkillSpell(31109, 350, L["RWD"],3)
	self:addTradeSkillSpell(31104, 350, L["RWD"],3)
	self:addTradeSkillSpell(31113, 350, L["RWD"],3)
	self:addTradeSkillSpell(31108, 350, L["RWD"],3)
	self:addTradeSkillSpell(31094, 350, L["RWD"],3)
	self:addTradeSkillSpell(31107, 350, L["RWD"],3)
	self:addTradeSkillSpell(31111, 350, L["RWD"],3)
	self:addTradeSkillSpell(31098, 350, L["RWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5)
	self:addTradeSkillSpell(31105, 350, L["RWD"],3)
	self:addTradeSkillSpell(31088, 350, L["RWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5)
	self:addTradeSkillSpell(31103, 350, L["RWD"],3)
	self:addTradeSkillSpell(31097, 350, L["RWD"],3)
	self:addTradeSkillSpell(31102, 350, L["RWD"],3)
	self:addTradeSkillSpell(31092, 350, L["RWD"],3)
	self:addTradeSkillSpell(31149, 350, L["RWD"],3)
	self:addTradeSkillSpell(31095, 350, L["RWD"],3)
	self:addTradeSkillSpell(31090, 350, L["RWD"],3)
	self:addTradeSkillSpell(31087, 350, L["RWD"],3)
	self:addTradeSkillSpell(31100, 350, L["RWD"],3)
	self:addTradeSkillSpell(31084, 350, L["RWD"],3)
	self:addTradeSkillSpell(31060, 355, L["RWD"],3)
	self:addTradeSkillSpell(31067, 355, L["RWD"],3)
	self:addTradeSkillSpell(31068, 355, L["RWD"],3)
	self:addTradeSkillSpell(31070, 360, L["RWD"],3)
	self:addTradeSkillSpell(31071, 360, L["RWD"],3)
	self:addTradeSkillSpell(31061, 365, L["RWD"],3)
	self:addTradeSkillSpell(31072, 365, L["RWD"],3)
	self:addTradeSkillSpell(31076, 365, L["RWD"],3)
	self:addTradeSkillSpell(32869, 365, L["RWD"],3)
	self:addTradeSkillSpell(32868, 365, L["RWD"],3)
	self:addTradeSkillSpell(32871, 365, L["RWD"],3)
	self:addTradeSkillSpell(32872, 365, L["RWD"],3)
	self:addTradeSkillSpell(39463, 350, L["RWD"],3)
	self:addTradeSkillSpell(39452, 350, L["RWD"],3)
	self:addTradeSkillSpell(39462, 350, L["RWD"],3)
	self:addTradeSkillSpell(39963, 365, L["RWD"],3)
	self:addTradeSkillSpell(39470, 350, L["RWD"],3)
	self:addTradeSkillSpell(39471, 350, L["RWD"],3)

	-- Specific Drops
	self:addTradeSkillSpell(26912, 300, self:CombineMobs(false,BBOSS["Quartermaster Zigris"],BZONE["Lower Blackrock Spire"]),4,5)
	self:addTradeSkillSpell(31053, 350, self:CombineMobs(false,L["Khorium Band of Shadows Obt"],BZONE["Shadowmoon Valley"]),4)
	self:addTradeSkillSpell(31054, 355, self:CombineMobs(false,L["Khorium Band of Frost Obt"],BZONE["The Steamvault"]),4,5)
	self:addTradeSkillSpell(31055, 355, self:CombineMobs(false,BBOSS["Darkweaver Syth"],BZONE["Sethekk Halls"]),4,5)
	self:addTradeSkillSpell(31056, 360, self:CombineMobs(false,L["Khorium Band of Leaves Obt"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(31057, 365, self:CombineMobs(false,L["Arcane Khorium Band Obt"],BZONE["Netherstorm"]),4)
	self:addTradeSkillSpell(39451, 325, self:CombineMobs(false,L["Blades Edge Summon Bosses"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(39458, 325, self:CombineMobs(false,L["Blades Edge Summon Bosses"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(39467, 325, self:CombineMobs(false,L["Blades Edge Summon Bosses"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(39466, 325, self:CombineMobs(false,L["Blades Edge Summon Bosses"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(39455, 325, self:CombineMobs(false,L["Blades Edge Summon Bosses"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(26914, 300, self:CombineMobs(false,BBOSS["Golem Lord Argelmach"],BZONE["Blackrock Depths"]),4,5)
	self:addTradeSkillSpell(31077, 370, self:CombineMobs(false,L["Coronet of the Verdant Flame Obt"],BZONE["The Botanica"]),4,5)
	self:addTradeSkillSpell(31078, 370, self:CombineMobs(false,BBOSS["Epoch Hunter"],BZONE["Old Hillsbrad Foothills"]),4,5)
	self:addTradeSkillSpell(44794, 365, self:CombineMobs(false,L["Chaotic Skyfire Diamond Obt"],BZONE["Shadowmoon Valley"]),4)

	-- Reputations
	self:addTradeSkillSpell(42588, 360, self:AddSingleReputation(2, BFAC["The Sha'tar"]), BFAC["The Sha'tar"])	
	self:addTradeSkillSpell(42592, 360, self:AddSingleReputation(3, BFAC["The Sha'tar"]), BFAC["The Sha'tar"])
	self:addTradeSkillSpell(31082, 370, self:AddSingleReputation(3, BFAC["The Sha'tar"]), BFAC["The Sha'tar"])
	self:addTradeSkillSpell(37855, 360, self:AddSingleReputation(2, BFAC["The Sha'tar"]), BFAC["The Sha'tar"])
	self:addTradeSkillSpell(32870, 365, self:AddSingleReputation(1, BFAC["The Sha'tar"]), BFAC["The Sha'tar"])

	self:addTradeSkillSpell(32874, 365, self:AddSingleReputation(2, BFAC["Keepers of Time"]), BFAC["Keepers of Time"])
	self:addTradeSkillSpell(31062, 360, self:AddSingleReputation(3, BFAC["Keepers of Time"]), BFAC["Keepers of Time"])
	self:addTradeSkillSpell(31081, 370, self:AddSingleReputation(3, BFAC["Keepers of Time"]), BFAC["Keepers of Time"])
	self:addTradeSkillSpell(42591, 360, self:AddSingleReputation(3, BFAC["Keepers of Time"]), BFAC["Keepers of Time"])
	self:addTradeSkillSpell(42593, 360, self:AddSingleReputation(2, BFAC["Keepers of Time"]), BFAC["Keepers of Time"])
	self:addTradeSkillSpell(42590, 360, self:AddSingleReputation(3, BFAC["Lower City"]), BFAC["Lower City"])
	self:addTradeSkillSpell(31079, 370, self:AddSingleReputation(3, BFAC["Lower City"]), BFAC["Lower City"])
	self:addTradeSkillSpell(31063, 360, self:AddSingleReputation(3, BFAC["Lower City"]), BFAC["Lower City"])
	self:addTradeSkillSpell(28915, 325, self:AddSingleReputation(2, BFAC["Lower City"]), BFAC["Lower City"])

	self:addTradeSkillSpell(31064, 360, self:AddSingleReputation(3, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(28906, 315, self:AddSingleReputation(1, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(28924, 325, self:AddSingleReputation(2, BFAC["The Scryers"]), BFAC["The Scryers"])
	
	self:addTradeSkillSpell(31065, 360, self:AddSingleReputation(3, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(28927, 305, self:AddSingleReputation(2, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(28944, 305, self:AddSingleReputation(1, BFAC["The Aldor"]), BFAC["The Aldor"])

	self:addTradeSkillSpell(28918, 315, self:AddDoubleReputation(1, BFAC["Honor Hold"], BFAC["Thrallmar"]), BFAC["Thrallmar"])
	self:addTradeSkillSpell(31080, 370, self:AddDoubleReputation(3, BFAC["Honor Hold"], BFAC["Thrallmar"]), BFAC["Thrallmar"])
		
	self:addTradeSkillSpell(38503, 375, self:AddSingleReputation(2, BFAC["The Violet Eye"]), BFAC["The Violet Eye"], 6)
	
	self:addTradeSkillSpell(31083, 370, self:AddSingleReputation(3, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(38504, 375, self:AddSingleReputation(4, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])

	self:addTradeSkillSpell(28947, 315, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(28907, 325, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(28933, 325, self:AddSingleReputation(1, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(28957, 325, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(31066, 360, self:AddSingleReputation(3, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(32867, 365, self:AddSingleReputation(3, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(32866, 365, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(32873, 365, self:AddSingleReputation(2, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(42589, 360, self:AddSingleReputation(3, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(42558, 360, self:AddSingleReputation(3, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(28912, 305, self:AddSingleReputation(1, BFAC["The Consortium"]), BFAC["The Consortium"])
	self:addTradeSkillSpell(39961, 365, self:AddSingleReputation(4, BFAC["The Consortium"]), BFAC["The Consortium"])

	self:addTradeSkillSpell(39741, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39729, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39706, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39705, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39711, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39712, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39719, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39739, 375, self:AddSingleReputation(3, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39721, 375, self:AddSingleReputation(3, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39722, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39736, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39731, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39730, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39742, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39735, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39717, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39734, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39740, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(2, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39732, 375, self:AddSingleReputation(3, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39720, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39715, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39716, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39713, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39710, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39723, 375, self:AddSingleReputation(1, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(1, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39738, 375, self:AddSingleReputation(3, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46775, 375, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46776, 375, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46777, 375, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46778, 375, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46779, 375, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39714, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39718, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39724, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39725, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39727, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39728, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39733, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(39737, 375, L["HYJALBoP"] .. addon.br .. self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(47053, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(47054, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(47055, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(47056, 375, self:AddSingleReputation(2, BFAC["The Scale of the Sands"]) .. addon.br .. self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["The Scale of the Sands"], BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46597, 370, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46601, 370, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46803, 350, self:AddSingleReputation(3, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46403, 360, self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46404, 360, self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(46405, 350, self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])
	self:addTradeSkillSpell(48789, 375, self:AddSingleReputation(4, BFAC["Shattered Sun Offensive"]), BFAC["Shattered Sun Offensive"])

	-- Raid Drops
	self:addTradeSkillSpell(46127, 365, L["SunwellBoE"],6)
	self:addTradeSkillSpell(46125, 365, L["SunwellBoE"],6)
	self:addTradeSkillSpell(46126, 365, L["SunwellBoE"],6)
	self:addTradeSkillSpell(46124, 365, L["SunwellBoP"],6)
	self:addTradeSkillSpell(46122, 365, L["SunwellBoP"],6)
	self:addTradeSkillSpell(46123, 365, L["SunwellBoP"],6)

end
