--[[

ARL-Engineering.lua

Engineering data for all of AckisRecipeList

$Date: 2008-08-20 15:28:07 +0000 (Wed, 20 Aug 2008) $
$Rev: 817 $

]]--

local L			= LibStub("AceLocale-3.0"):GetLocale("Ackis Recipe List")
local BFAC		= LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BZONE		= LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BBOSS		= LibStub("LibBabble-Boss-3.0"):GetLookupTable()

local addon = AckisRecipeList

function addon:InitEngineering()

	-- Trainer Recipes
	self:addTradeSkillSpell(3918, 1, L["Trainer"],1)
	self:addTradeSkillSpell(3919, 1, L["Trainer"],1)
	self:addTradeSkillSpell(3920, 1, L["Trainer"],1)
	self:addTradeSkillSpell(3922, 30, L["Trainer"],1)
	self:addTradeSkillSpell(3923, 30, L["Trainer"],1)
	self:addTradeSkillSpell(3924, 50, L["Trainer"],1)
	self:addTradeSkillSpell(3925, 50, L["Trainer"],1)
	self:addTradeSkillSpell(7430, 50, L["Trainer"],1)
	self:addTradeSkillSpell(3977, 60, L["Trainer"],1)
	self:addTradeSkillSpell(3926, 65, L["Trainer"],1)
	self:addTradeSkillSpell(3929, 75, L["Trainer"],1)
	self:addTradeSkillSpell(3930, 75, L["Trainer"],1)
	self:addTradeSkillSpell(3931, 75, L["Trainer"],1)
	self:addTradeSkillSpell(3932, 85, L["Trainer"],1)
	self:addTradeSkillSpell(3973, 90, L["Trainer"],1)
	self:addTradeSkillSpell(3934, 100, L["Trainer"],1)
	self:addTradeSkillSpell(8334, 100, L["Trainer"],1)
	self:addTradeSkillSpell(3936, 105, L["Trainer"],1)
	self:addTradeSkillSpell(3937, 105, L["Trainer"],1)
	self:addTradeSkillSpell(3938, 105, L["Trainer"],1)
	self:addTradeSkillSpell(3978, 110, L["Trainer"],1)
	self:addTradeSkillSpell(3941, 120, L["Trainer"],1)
	self:addTradeSkillSpell(3942, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3945, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3946, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3947, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3949, 130, L["Trainer"],1)
	self:addTradeSkillSpell(6458, 135, L["Trainer"],1)
	self:addTradeSkillSpell(3950, 140, L["Trainer"],1)
	self:addTradeSkillSpell(3953, 145, L["Trainer"],1)
	self:addTradeSkillSpell(3955, 150, L["Trainer"],1)
	self:addTradeSkillSpell(3956, 150, L["Trainer"],1)
	self:addTradeSkillSpell(9271, 150, L["Trainer"],1)
	self:addTradeSkillSpell(12584, 150, L["Trainer"],1)
	self:addTradeSkillSpell(3958, 160, L["Trainer"],1)
	self:addTradeSkillSpell(3961, 170, L["Trainer"],1)
	self:addTradeSkillSpell(3962, 175, L["Trainer"],1)
	self:addTradeSkillSpell(3963, 175, L["Trainer"],1)
	self:addTradeSkillSpell(12585, 175, L["Trainer"],1)
	self:addTradeSkillSpell(12586, 175, L["Trainer"],1)
	self:addTradeSkillSpell(12590, 175, L["Trainer"],1)
	self:addTradeSkillSpell(3965, 185, L["Trainer"],1)
	self:addTradeSkillSpell(3967, 190, L["Trainer"],1)
	self:addTradeSkillSpell(12589, 195, L["Trainer"],1)
	self:addTradeSkillSpell(12591, 200, L["Trainer"],1)
	self:addTradeSkillSpell(15255, 200, L["Trainer"],1)
	self:addTradeSkillSpell(12594, 205, L["Trainer"],1)
	self:addTradeSkillSpell(12595, 205, L["Trainer"],1)
	self:addTradeSkillSpell(12596, 210, L["Trainer"],1)
	self:addTradeSkillSpell(12599, 215, L["Trainer"],1)
	self:addTradeSkillSpell(12603, 215, L["Trainer"],1)
	self:addTradeSkillSpell(12618, 230, L["Trainer"],1)
	self:addTradeSkillSpell(12619, 235, L["Trainer"],1)
	self:addTradeSkillSpell(12621, 245, L["Trainer"],1)
	self:addTradeSkillSpell(12622, 245, L["Trainer"],1)
	self:addTradeSkillSpell(19567, 250, L["Trainer"],1)
	self:addTradeSkillSpell(19788, 250, L["Trainer"],1)
	self:addTradeSkillSpell(23070, 250, L["Trainer"],1)
	self:addTradeSkillSpell(26011, 250, L["Trainer"],1)
	self:addTradeSkillSpell(19790, 260, L["Trainer"],1)
	self:addTradeSkillSpell(19791, 260, L["Trainer"],1)
	self:addTradeSkillSpell(23071, 260, L["Trainer"],1)
	self:addTradeSkillSpell(19794, 270, L["Trainer"],1)
	self:addTradeSkillSpell(19795, 275, L["Trainer"],1)
	self:addTradeSkillSpell(19825, 290, L["Trainer"],1)
	self:addTradeSkillSpell(30303, 300, L["Trainer"],1)
	self:addTradeSkillSpell(30304, 300, L["Trainer"],1)
	self:addTradeSkillSpell(30305, 300, L["Trainer"],1)
	self:addTradeSkillSpell(30310, 300, L["Trainer"],1)
	self:addTradeSkillSpell(30346, 310, L["Trainer"],1)
	self:addTradeSkillSpell(30312, 320, L["Trainer"],1)
	self:addTradeSkillSpell(30306, 325, L["Trainer"],1)
	self:addTradeSkillSpell(30311, 325, L["Trainer"],1)
	self:addTradeSkillSpell(30307, 350, L["Trainer"],1)
	self:addTradeSkillSpell(30308, 350, L["Trainer"],1)
	self:addTradeSkillSpell(30309, 350, L["Trainer"],1)
	self:addTradeSkillSpell(44155, 350, L["Trainer"],1)
	self:addTradeSkillSpell(39971, 335, L["Trainer"],1)
	self:addTradeSkillSpell(39973, 335, L["Trainer"],1)
	self:addTradeSkillSpell(40274, 350, L["Trainer"], "PALADIN", "WARRIOR",1)
	self:addTradeSkillSpell(41311, 350, L["Trainer"], "PALADIN",1)
	self:addTradeSkillSpell(41312, 350, L["Trainer"], "PALADIN", "WARRIOR",1)
	self:addTradeSkillSpell(41314, 350, L["Trainer"], "SHAMAN", "HUNTER",1)
	self:addTradeSkillSpell(41315, 350, L["Trainer"], "SHAMAN",1)
	self:addTradeSkillSpell(41316, 350, L["Trainer"], "SHAMAN",1)
	self:addTradeSkillSpell(41317, 350, L["Trainer"], "ROGUE", "DRUID",1)
	self:addTradeSkillSpell(41318, 350, L["Trainer"], "DRUID",1)
	self:addTradeSkillSpell(41319, 350, L["Trainer"], "DRUID",1)
	self:addTradeSkillSpell(41320, 350, L["Trainer"], "WARLOCK", "PRIEST", "MAGE",1)
	self:addTradeSkillSpell(41321, 350, L["Trainer"], "PRIEST")
	self:addTradeSkillSpell(41307, 375, L["Trainer"],1)
	self:addTradeSkillSpell(44157, 375, L["Trainer"],1)

	-- Vendor Recipes
	self:addTradeSkillSpell(3939, 120, self:CombineVendors(67, 68, false),2)
	self:addTradeSkillSpell(9269, 125, self:CombineVendors(68, 74, false), BFAC["Alliance"],2)
	self:addTradeSkillSpell(3952, 140, self:CombineVendors(67, 69, false)  .. addon.br .. L["Minor Recombobulator Obt"],2)
	self:addTradeSkillSpell(23066, 150, self:CombineVendors(70, false), BFAC["Horde"],2)
	self:addTradeSkillSpell(23067, 150, self:CombineVendors(73, 74, false), BFAC["Alliance"],2)
	self:addTradeSkillSpell(23068, 150, self:CombineVendors(71, 72, false),2)
	self:addTradeSkillSpell(3957, 155, self:CombineVendors(75, false),2)
	self:addTradeSkillSpell(9273, 165, self:CombineVendors(76, 77, 19, false),2)
	self:addTradeSkillSpell(3979, 180, self:CombineVendors(78, false),2)
	self:addTradeSkillSpell(3969, 200, self:CombineVendors(79, false),2)
	self:addTradeSkillSpell(3971, 200, self:CombineVendors(81, false),2)
	self:addTradeSkillSpell(23069, 200, self:CombineVendors(84, false),2)
	self:addTradeSkillSpell(12597, 210, self:CombineVendors(83, 82, false),2)
	self:addTradeSkillSpell(12617, 230, self:CombineVendors(85, true),2)
	self:addTradeSkillSpell(12624, 250, self:CombineVendors(80, true),2)
	self:addTradeSkillSpell(23507, 250, self:CombineVendors(86, false),2)
	self:addTradeSkillSpell(23077, 260, self:CombineVendors(87, false),2)
	self:addTradeSkillSpell(19814, 275, self:CombineVendors(87, false),2)
	self:addTradeSkillSpell(23080, 275, self:CombineVendors(87, false),2)
	self:addTradeSkillSpell(39895, 275, self:CombineVendors(87, 88, false),2)
	self:addTradeSkillSpell(19815, 285, self:CombineVendors(87, 88, false),2)
	self:addTradeSkillSpell(30348, 325, self:CombineVendors(92, 93, 94, false),2)
	self:addTradeSkillSpell(30329, 335, self:CombineVendors(89, 90, false),2)
	self:addTradeSkillSpell(30341, 335, self:CombineVendors(91, 92, 93, 94, false),2)
	self:addTradeSkillSpell(30347, 335, self:CombineVendors(92, 93, 94, false),2)
	self:addTradeSkillSpell(30316, 340, self:CombineVendors(95, 90, false),2)
	self:addTradeSkillSpell(30313, 350, self:CombineVendors(92, 88, 94, false),2)
	self:addTradeSkillSpell(30318, 350, self:CombineVendors(91, 95, false),2)

	-- World Drops
	self:addTradeSkillSpell(3928, 75, L["UWD"],3)
	self:addTradeSkillSpell(3933, 100, L["UWD"],3)
	self:addTradeSkillSpell(8339, 100, L["UWD"],3)
	self:addTradeSkillSpell(3940, 120, L["UWD"],3)
	self:addTradeSkillSpell(3954, 145, L["UWD"],3)
	self:addTradeSkillSpell(3960, 165, L["UWD"],3)
	self:addTradeSkillSpell(12587, 175, L["UWD"],3)
	self:addTradeSkillSpell(3966, 185, L["UWD"],3)
	self:addTradeSkillSpell(3968, 195, L["UWD"],3)
	self:addTradeSkillSpell(3972, 200, L["UWD"],3)
	self:addTradeSkillSpell(12607, 220, L["UWD"],3)
	self:addTradeSkillSpell(12614, 220, L["UWD"],3)
	self:addTradeSkillSpell(12615, 225, L["UWD"],3)
	self:addTradeSkillSpell(12616, 225, L["UWD"],3)
	self:addTradeSkillSpell(12620, 240, L["UWD"],3)
	self:addTradeSkillSpell(19792, 260, L["UWD"],3)
	self:addTradeSkillSpell(19793, 265, L["UWD"],3)
	self:addTradeSkillSpell(19800, 285, L["UWD"],3)
	self:addTradeSkillSpell(19831, 300, L["UWD"],3)
	self:addTradeSkillSpell(30337, 325, L["UWD"],3)
	self:addTradeSkillSpell(30551, 330, L["UWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5)
	self:addTradeSkillSpell(32814, 335, L["UWD"],3)
	self:addTradeSkillSpell(30317, 340, L["UWD"],3)
	self:addTradeSkillSpell(30552, 345, L["UWD"],3)
	self:addTradeSkillSpell(30315, 375, L["RWD"],3)

	-- Specific Drops
	self:addTradeSkillSpell(3944, 125, self:CombineMobs(true,BBOSS["Mekgineer Thermaplugg"],BZONE["Gnomeregan"]),3,5)
	self:addTradeSkillSpell(3959, 160, self:CombineMobs(true,BBOSS["Mekgineer Thermaplugg"],BZONE["Gnomeregan"]) .. addon.br .. L["Discombobulator Ray Obt"],3,5)
	self:addTradeSkillSpell(8243, 185, self:CombineQuests(L["Flash Bomb Obt"],0,BZONE["Badlands"]),8)
	self:addTradeSkillSpell(19796, 275, self:CombineMobs(true,L["Dark Iron Rifle Obt"],BZONE["Blackrock Depths"]),3,5)
	self:addTradeSkillSpell(23079, 275, self:CombineMobs(false,BBOSS["King Gordok"],BZONE["Dire Maul"]) .. L["Major Recombobulator Obt"],4,5)
	self:addTradeSkillSpell(28327, 275, self:CombineQuests(L["Steam Tonk Controller Obt"],0,L["Darkmoon Faire"]),8)
	self:addTradeSkillSpell(19799, 285, self:CombineMobs(true,L["Weapon Technician"],BZONE["Blackrock Depths"]),3,5)
	self:addTradeSkillSpell(19819, 290, self:CombineMobs(true,L["Crimson Inquisitor"],BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(23081, 290, self:CombineMobs(true,BBOSS["Solakar Flamewreath"],BZONE["Upper Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(19830, 300, self:CombineMobs(true,L["Arcanite Dragonling Obt"],BZONE["Winterspring"]),3,5)
	self:addTradeSkillSpell(19833, 300, self:CombineMobs(true,L["Flawless Arcanite Rifle Obt"],BZONE["Eastern Plaguelands"]),3,5)
	self:addTradeSkillSpell(22704, 300, self:CombineMobs(false,BBOSS["Golem Lord Argelmach"],BZONE["Blackrock Depths"]) .. L["Field Repair Bot 74A Obt"],4,5)
	self:addTradeSkillSpell(23082, 300, self:CombineMobs(true,L["Crimson Inquisitor"],BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(30548, 305, self:CombineQuests(L["Zapthrottle Mote Extractor Obt"],0,BZONE["Zangarmarsh"]),8)
	self:addTradeSkillSpell(43676, 335, self:CombineMobs(false,L["Adamantite Arrow Maker Obt"],BZONE["Netherstorm"]),4)
	self:addTradeSkillSpell(30556, 355, self:CombineMobs(false,BBOSS["Mekgineer Steamrigger"],BZONE["The Steamvault"]),4,5)
	self:addTradeSkillSpell(46697, 355, self:CombineMobs(false,BBOSS["Mechano-Lord Capacitus"],BZONE["The Mechanar"]),4,5)
	self:addTradeSkillSpell(30314, 360, self:CombineMobs(false,L["Felsteel Boomstick Obt"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(30325, 360, self:CombineMobs(false,L["Hyper-Vision Goggles Obt"],BZONE["Shadowmoon Valley"]),4)
	self:addTradeSkillSpell(30332, 360, self:CombineMobs(false,L["Khorium Scope Obt"],BZONE["Netherstorm"]),4)
	self:addTradeSkillSpell(44391, 360, self:CombineMobs(false,L["Field Repair Bot 110G Obt"],BZONE["Blade's Edge Mountains"]),4)

	-- Seasonal
	self:addTradeSkillSpell(26416, 125, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26417, 125, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26418, 125, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26420, 175, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26421, 175, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26422, 175, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(21940, 190, L["WintersVeil"], 7)
	self:addTradeSkillSpell(26423, 225, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26424, 225, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26425, 225, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26442, 225, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26426, 275, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26427, 275, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26428, 275, L["Lunar Festival"], 7)
	self:addTradeSkillSpell(26443, 275, L["Lunar Festival"], 7)


	-- Reputations
	self:addTradeSkillSpell(24356, 300, self:AddSingleReputation(2, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24357, 300, self:AddSingleReputation(1, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)

	self:addTradeSkillSpell(30344, 335, self:AddSingleReputation(1, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])

	self:addTradeSkillSpell(30547, 350, self:AddSingleReputation(3, BFAC["The Consortium"]), BFAC["The Consortium"])

	-- Raid
	self:addTradeSkillSpell(22793, 300, L["MOLTENCORE"], 6)
	self:addTradeSkillSpell(22795, 300, L["MOLTENCORE"], 6)
	self:addTradeSkillSpell(22797, 300, L["MOLTENCORE"], 6)
	self:addTradeSkillSpell(30334, 375, self:CombineMobs(false,BBOSS["Attumen the Huntsman"],BZONE["Karazhan"]), 6)
	self:addTradeSkillSpell(46106, 375, L["SunwellBoE"], 6, "DRUID")
	self:addTradeSkillSpell(46107, 375, L["SunwellBoE"], 6, "PALADIN")
	self:addTradeSkillSpell(46108, 375, L["SunwellBoE"], 6, "PRIEST")
	self:addTradeSkillSpell(46109, 375, L["SunwellBoE"], 6, "DRUID")
	self:addTradeSkillSpell(46110, 375, L["SunwellBoE"], 6, "SHAMAN")
	self:addTradeSkillSpell(46111, 375, L["SunwellBoE"], 6, "PRIEST", "MAGE", "WARLOCK")
	self:addTradeSkillSpell(46112, 375, L["SunwellBoE"], 6, "SHAMAN")
	self:addTradeSkillSpell(46113, 375, L["SunwellBoE"], 6, "SHAMAN", "HUNTER")
	self:addTradeSkillSpell(46114, 375, L["SunwellBoE"], 6, "PALADIN", "WARRIOR")
	self:addTradeSkillSpell(46115, 375, L["SunwellBoE"], 6, "PALADIN", "WARRIOR")
	self:addTradeSkillSpell(46116, 375, L["SunwellBoE"], 6, "DRUID", "ROGUE")

	-- Gnomish Engineering
	self:addTradeSkillSpell(12895, 200, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12899, 205, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(15633, 205, L["ENG_MEMBERSHIP_BENEFITS"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12897, 210, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12902, 210, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12903, 215, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12905, 225, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12906, 230, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12907, 235, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(12759, 240, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(23129, 260, self:CombineMobs(true,L["Weapon Technician"],BZONE["Blackrock Depths"]), GetSpellInfo(20219),1)
	self:addTradeSkillSpell(23489, 260, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(23096, 265, self:CombineMobs(true,L["Weapon Technician"],BZONE["Blackrock Depths"]), GetSpellInfo(20219),1)
	self:addTradeSkillSpell(30568, 325, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(30569, 340, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(30570, 350, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(36955, 350, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(30574, 375, L["Trainer"], GetSpellInfo(20219),1)
	self:addTradeSkillSpell(30575, 375, L["Trainer"], GetSpellInfo(20219),1)

	-- Goblin Engineering
	self:addTradeSkillSpell(12715, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12716, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12717, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12718, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12760, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(13240, 205, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(15628, 205, L["ENG_MEMBERSHIP_BENEFITS"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(8895, 225, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12755, 230, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12754, 235, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12908, 240, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(12758, 245, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(23486, 260, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(23078, 265, self:CombineMobs(true,BBOSS["Plugger Spazzring"],BZONE["Blackrock Depths"]), GetSpellInfo(20222),3,5)
	self:addTradeSkillSpell(30558, 325, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(30560, 340, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(30563, 350, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(36954, 350, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(30565, 375, L["Trainer"], GetSpellInfo(20222),1)
	self:addTradeSkillSpell(30566, 375, L["Trainer"], GetSpellInfo(20222),1)

end
