--[[

ARLBlackSmith-.lua

Blacksmithing data for all of AckisRecipeList

$Date: 2008-07-07 22:23:13 +0000 (Mon, 07 Jul 2008) $
$Rev: 732 $

]]--

local L			= LibStub("AceLocale-3.0"):GetLocale("Ackis Recipe List")
local BFAC		= LibStub("LibBabble-Faction-3.0"):GetLookupTable()
local BZONE		= LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local BBOSS		= LibStub("LibBabble-Boss-3.0"):GetLookupTable()

local addon = AckisRecipeList

function addon:InitBlackSmith()

	-- Trainer Recipes
	self:addTradeSkillSpell(2660, 1, L["Trainer"],1)
	self:addTradeSkillSpell(2663, 1, L["Trainer"],1)
	self:addTradeSkillSpell(12260, 1, L["Trainer"],1)
	self:addTradeSkillSpell(2662, 1, L["Trainer"],1)
	self:addTradeSkillSpell(2737, 15, L["Trainer"],1)
	self:addTradeSkillSpell(3319, 20, L["Trainer"],1)
	self:addTradeSkillSpell(2738, 20, L["Trainer"],1)
	self:addTradeSkillSpell(3115, 25, L["Trainer"],1)
	self:addTradeSkillSpell(3320, 25, L["Trainer"],1)
	self:addTradeSkillSpell(2739, 25, L["Trainer"],1)
	self:addTradeSkillSpell(8880, 30, L["Trainer"],1)
	self:addTradeSkillSpell(9983, 30, L["Trainer"],1)
	self:addTradeSkillSpell(3293, 35, L["Trainer"],1)
	self:addTradeSkillSpell(2661, 35, L["Trainer"],1)
	self:addTradeSkillSpell(3323, 40, L["Trainer"],1)
	self:addTradeSkillSpell(3324, 45, L["Trainer"],1)
	self:addTradeSkillSpell(3116, 65, L["Trainer"],1)
	self:addTradeSkillSpell(7408, 65, L["Trainer"],1)
	self:addTradeSkillSpell(2665, 65, L["Trainer"],1)
	self:addTradeSkillSpell(3326, 75, L["Trainer"],1)
	self:addTradeSkillSpell(2664, 90, L["Trainer"],1)
	self:addTradeSkillSpell(3294, 90, L["Trainer"],1)
	self:addTradeSkillSpell(2666, 90, L["Trainer"],1)
	self:addTradeSkillSpell(3292, 95, L["Trainer"],1)
	self:addTradeSkillSpell(7817, 95, L["Trainer"],1)
	self:addTradeSkillSpell(3491, 105, L["Trainer"],1)
	self:addTradeSkillSpell(7818, 100, L["Trainer"],1)
	self:addTradeSkillSpell(19666, 100, L["Trainer"],1)
	self:addTradeSkillSpell(34979, 100, L["Trainer"],1)
	self:addTradeSkillSpell(2668, 105, L["Trainer"],1)
	self:addTradeSkillSpell(2670, 105, L["Trainer"],1)
	self:addTradeSkillSpell(3328, 110, L["Trainer"],1)
	self:addTradeSkillSpell(2740, 110, L["Trainer"],1)
	self:addTradeSkillSpell(6517, 115, L["Trainer"],1)
	self:addTradeSkillSpell(2741, 115, L["Trainer"],1)
	self:addTradeSkillSpell(2742, 120, L["Trainer"],1)
	self:addTradeSkillSpell(2672, 120, L["Trainer"],1)
	self:addTradeSkillSpell(3117, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3337, 125, L["Trainer"],1)
	self:addTradeSkillSpell(9985, 125, L["Trainer"],1)
	self:addTradeSkillSpell(2674, 125, L["Trainer"],1)
	self:addTradeSkillSpell(3296, 130, L["Trainer"],1)
	self:addTradeSkillSpell(3331, 130, L["Trainer"],1)
	self:addTradeSkillSpell(9986, 130, L["Trainer"],1)
	self:addTradeSkillSpell(3333, 135, L["Trainer"],1)
	self:addTradeSkillSpell(9987, 135, L["Trainer"],1)
	self:addTradeSkillSpell(2675, 145, L["Trainer"],1)
	self:addTradeSkillSpell(8768, 150, L["Trainer"],1)
	self:addTradeSkillSpell(14379, 150, L["Trainer"],1)
	self:addTradeSkillSpell(19667, 150, L["Trainer"],1)
	self:addTradeSkillSpell(3506, 155, L["Trainer"],1)
	self:addTradeSkillSpell(3501, 165, L["Trainer"],1)
	self:addTradeSkillSpell(3502, 170, L["Trainer"],1)
	self:addTradeSkillSpell(3508, 180, L["Trainer"],1)
	self:addTradeSkillSpell(15972, 180, L["Trainer"],1)
	self:addTradeSkillSpell(7223, 185, L["Trainer"],1)
	self:addTradeSkillSpell(9916, 200, L["Trainer"],1)
	self:addTradeSkillSpell(9918, 200, L["Trainer"],1)
	self:addTradeSkillSpell(9921, 200, L["Trainer"],1)
	self:addTradeSkillSpell(9920, 200, L["Trainer"],1)
	self:addTradeSkillSpell(14380, 200, L["Trainer"],1)
	self:addTradeSkillSpell(19668, 200, L["Trainer"],1)
	self:addTradeSkillSpell(34981, 200, L["Trainer"],1)
	self:addTradeSkillSpell(9926, 205, L["Trainer"],1)
	self:addTradeSkillSpell(9928, 205, L["Trainer"],1)
	self:addTradeSkillSpell(9931, 210, L["Trainer"],1)
	self:addTradeSkillSpell(9993, 210, L["Trainer"],1)
	self:addTradeSkillSpell(9935, 215, L["Trainer"],1)
	self:addTradeSkillSpell(9959, 230, L["Trainer"],1)
	self:addTradeSkillSpell(9961, 230, L["Trainer"],1)
	self:addTradeSkillSpell(10001, 230, L["Trainer"],1)
	self:addTradeSkillSpell(9968, 235, L["Trainer"],1)
	self:addTradeSkillSpell(9972, 235, L["Trainer"],1)
	self:addTradeSkillSpell(9979, 240, L["Trainer"],1)
	self:addTradeSkillSpell(16641, 250, L["Trainer"],1)
	self:addTradeSkillSpell(16640, 250, L["Trainer"],1)
	self:addTradeSkillSpell(16639, 250, L["Trainer"],1)
	self:addTradeSkillSpell(19669, 275, L["Trainer"],1)
	self:addTradeSkillSpell(20201, 275, L["Trainer"],1)
	self:addTradeSkillSpell(34982, 300, L["Trainer"],1)
	self:addTradeSkillSpell(10003, 235 , L["Trainer"],1)
	self:addTradeSkillSpell(10007, 245, L["Trainer"],1)
	self:addTradeSkillSpell(10011, 250, L["Trainer"],1)
	self:addTradeSkillSpell(10015, 260, L["Trainer"],1)
  	self:addTradeSkillSpell(9954, 225, L["Trainer"],1)
	self:addTradeSkillSpell(9974, 245, L["Trainer"],1)
	self:addTradeSkillSpell(29654, 300, L["Trainer"],1)
	self:addTradeSkillSpell(34607, 300, L["Trainer"],1)
	self:addTradeSkillSpell(32655, 300, L["Trainer"],1)
	self:addTradeSkillSpell(29551, 300, L["Trainer"],1)
	self:addTradeSkillSpell(29545, 300, L["Trainer"],1)
	self:addTradeSkillSpell(29547, 305, L["Trainer"],1)
	self:addTradeSkillSpell(29557, 310, L["Trainer"],1)
	self:addTradeSkillSpell(29552, 310, L["Trainer"],1)
	self:addTradeSkillSpell(29548, 315, L["Trainer"],1)
	self:addTradeSkillSpell(29549, 315, L["Trainer"],1)
	self:addTradeSkillSpell(29553, 315, L["Trainer"],1)
	self:addTradeSkillSpell(29558, 315, L["Trainer"],1)
	self:addTradeSkillSpell(29565, 320, L["Trainer"],1)
	self:addTradeSkillSpell(29556, 320, L["Trainer"],1)
	self:addTradeSkillSpell(29550, 325, L["Trainer"],1)
	self:addTradeSkillSpell(32284, 325, L["Trainer"],1)
	self:addTradeSkillSpell(34983, 350, L["Trainer"],1)

	-- Vendor Recipes
	self:addTradeSkillSpell(3494, 155, self:CombineVendors(171, 172, 173, false),2)
	self:addTradeSkillSpell(3492, 160, self:CombineVendors(174, 175, 176, false),2)
	self:addTradeSkillSpell(3496, 180, self:CombineVendors(177, false),2)
	self:addTradeSkillSpell(3498, 185, self:CombineVendors(178, 179, false),2)
	self:addTradeSkillSpell(3503, 190, self:CombineVendors(180, false),2)
	self:addTradeSkillSpell(9937, 215, self:CombineVendors(181, 182, false),2)
	self:addTradeSkillSpell(29566, 325, self:CombineVendors(183, 184, 185, false),2)
	self:addTradeSkillSpell(29568, 330, self:CombineVendors(183, 184, 185, false),2)
	self:addTradeSkillSpell(29569, 330, self:CombineVendors(183, 184, 185, false),2)
	self:addTradeSkillSpell(29571, 335, self:CombineVendors(183, 184, 185, false),2)
	self:addTradeSkillSpell(29603, 335, self:CombineVendors(186, 187, false),2)
	self:addTradeSkillSpell(29605, 335, self:CombineVendors(186, 187, false),2)
	self:addTradeSkillSpell(29728, 340, self:CombineVendors(188, 189, false),2)
	self:addTradeSkillSpell(29606, 340, self:CombineVendors(186, 187, false),2)
	self:addTradeSkillSpell(32656, 350, self:CombineVendors(183, false),2)
	self:addTradeSkillSpell(32657, 375, self:CombineVendors(188, 189, false),2)

	-- World Drops
	self:addTradeSkillSpell(3321, 35, L["UWD"],3)
	self:addTradeSkillSpell(3325, 60, L["UWD"],3)
	self:addTradeSkillSpell(2667, 80, L["UWD"],3)
	self:addTradeSkillSpell(3295, 125, L["UWD"],3)
	self:addTradeSkillSpell(3330, 125, L["UWD"],3)
	self:addTradeSkillSpell(2673, 130, L["UWD"],3)
	self:addTradeSkillSpell(6518, 140, L["UWD"],3)
	self:addTradeSkillSpell(3297, 145, L["UWD"],3)
	self:addTradeSkillSpell(3334, 145, L["UWD"],3)
	self:addTradeSkillSpell(3336, 150, L["UWD"],3)
	self:addTradeSkillSpell(7221, 150, L["UWD"],3)
	self:addTradeSkillSpell(12259, 155, L["UWD"],3)
	self:addTradeSkillSpell(3504, 160, L["UWD"],3)
	self:addTradeSkillSpell(7222, 165, L["UWD"],3)
	self:addTradeSkillSpell(3495, 170, L["UWD"],3)
	self:addTradeSkillSpell(3507, 170, L["UWD"],3)
	self:addTradeSkillSpell(3493, 175, L["UWD"],3)
	self:addTradeSkillSpell(3505, 175, L["UWD"],3)
	self:addTradeSkillSpell(3513, 185, L["UWD"],3)
	self:addTradeSkillSpell(7224, 190, L["UWD"],3)
	self:addTradeSkillSpell(15973, 190, L["UWD"],3)
	self:addTradeSkillSpell(3511, 195, L["UWD"],3)
	self:addTradeSkillSpell(3497, 200, L["UWD"],3)
	self:addTradeSkillSpell(3500, 200, L["UWD"],3)
	self:addTradeSkillSpell(3515, 200, L["UWD"],3)
	self:addTradeSkillSpell(9933, 210, L["UWD"],3)
	self:addTradeSkillSpell(9939, 215, L["UWD"],3)
	self:addTradeSkillSpell(9995, 220, L["UWD"],3)
	self:addTradeSkillSpell(9997, 225, L["UWD"],3)
	self:addTradeSkillSpell(9964, 235, L["UWD"],3)
	self:addTradeSkillSpell(9966, 235, L["UWD"],3)
	self:addTradeSkillSpell(10005, 240, L["UWD"],3)
	self:addTradeSkillSpell(9970, 245, L["UWD"],3)
	self:addTradeSkillSpell(10009, 245, L["UWD"],3)
	self:addTradeSkillSpell(16642, 250, L["UWD"],3)
	self:addTradeSkillSpell(16643, 250, L["UWD"],3)
	self:addTradeSkillSpell(16644, 255, L["UWD"],3)
	self:addTradeSkillSpell(16645, 260, L["UWD"],3)
	self:addTradeSkillSpell(16648, 270, L["UWD"],3)
	self:addTradeSkillSpell(16651, 275, L["UWD"],3)
	self:addTradeSkillSpell(16652, 280, L["UWD"],3)
	self:addTradeSkillSpell(16653, 280, L["UWD"],3)
	self:addTradeSkillSpell(16654, 285, L["UWD"],3)
	self:addTradeSkillSpell(16656, 290, L["UWD"],3)
	self:addTradeSkillSpell(16659, 295, L["UWD"],3)
	self:addTradeSkillSpell(16662, 300, L["UWD"],3)
	self:addTradeSkillSpell(16725, 300, L["UWD"],3)
	self:addTradeSkillSpell(16650, 270, L["UWD"],3)
	self:addTradeSkillSpell(16660, 290, L["UWD"],3)
	self:addTradeSkillSpell(16724, 300, L["UWD"],3)
	self:addTradeSkillSpell(16728, 300, L["RWD"],3)
	self:addTradeSkillSpell(16729, 300, L["EWD"],3)
	self:addTradeSkillSpell(16741, 300, L["EWD"],3)
	self:addTradeSkillSpell(27829, 300, L["EWD"],3)
	self:addTradeSkillSpell(27832, 300, L["EWD"],3)
	self:addTradeSkillSpell(27830, 300, L["EWD"],3)
	self:addTradeSkillSpell(42688, 335, L["UWD"] .. addon.br .. self:CombineMobs(false,BBOSS["Kael'thas Sunstrider"],BZONE["Magisters' Terrace"]),3,5)
	self:addTradeSkillSpell(29622, 365, L["EWD"],3)
	self:addTradeSkillSpell(29658, 365, L["EWD"],3)
	self:addTradeSkillSpell(29662, 365, L["EWD"],3)
	self:addTradeSkillSpell(29663, 365, L["EWD"],3)
	self:addTradeSkillSpell(29664, 365, L["EWD"],3)
	self:addTradeSkillSpell(29668, 365, L["EWD"],3)
	self:addTradeSkillSpell(29669, 365, L["EWD"],3)
	self:addTradeSkillSpell(29671, 365, L["EWD"],3)
	self:addTradeSkillSpell(29672, 365, L["EWD"],3)
	self:addTradeSkillSpell(29692, 365, L["EWD"],3)
	self:addTradeSkillSpell(29693, 365, L["EWD"],3)
	self:addTradeSkillSpell(29694, 365, L["EWD"],3)
	self:addTradeSkillSpell(29695, 365, L["EWD"],3)
	self:addTradeSkillSpell(29696, 365, L["EWD"],3)
	self:addTradeSkillSpell(29697, 365, L["EWD"],3)
	self:addTradeSkillSpell(29698, 365, L["EWD"],3)
	self:addTradeSkillSpell(43846, 365, L["EWD"],3)
	self:addTradeSkillSpell(29699, 365, L["EWD"],3)
	self:addTradeSkillSpell(29700, 365, L["EWD"],3)

	-- Specific Drops
	self:addTradeSkillSpell(43549, 35, L["UWD"] .. addon.br .. self:CombineQuests(L["Heavy Copper Longsword Obt"],1,BZONE["Ironforge"]),3,8)
	self:addTradeSkillSpell(8367, 100, self:CombineQuests(L["Ironforge Breastplate Obt"],1,BZONE["Ironforge"]),BFAC["Alliance"],8)
	self:addTradeSkillSpell(9811, 160, self:CombineQuests(L["Barbaric Iron Shoulders Obt"],2,BZONE["Orgrimmar"]),BFAC["Horde"],8)
	self:addTradeSkillSpell(9813, 160, self:CombineQuests(L["Barbaric Iron Breastplate Obt"],2,BZONE["Orgrimmar"]),BFAC["Horde"],8)
	self:addTradeSkillSpell(9814, 175, self:CombineQuests(L["Barbaric Iron Helm Obt"],2,BZONE["Orgrimmar"]),BFAC["Horde"],8)
	self:addTradeSkillSpell(9818, 180, self:CombineQuests(L["Barbaric Iron Boots Obt"],2,BZONE["Orgrimmar"]),BFAC["Horde"],8)
	self:addTradeSkillSpell(9820, 185, self:CombineQuests(L["Barbaric Iron Gloves Obt"],2,BZONE["Orgrimmar"]),BFAC["Horde"],8)
	self:addTradeSkillSpell(11454, 200, L["Inlaid Mithril Cylinder Obt"])
	self:addTradeSkillSpell(11643, 205, self:CombineQuests(L["Golden Scale Gauntlets Obt"],1,BZONE["Stormwind City"]), BFAC["Alliance"],8)
	self:addTradeSkillSpell(9945, 220, self:CombineQuests(L["Ornate Mithril Pants Obt"],0,BZONE["Stranglethorn Vale"]),8)
	self:addTradeSkillSpell(9950, 220, self:CombineQuests(L["Ornate Mithril Gloves Obt"],0,BZONE["Stranglethorn Vale"]),8)
	self:addTradeSkillSpell(9952, 225, self:CombineQuests(L["Ornate Mithril Shoulder Obt"],0,BZONE["Stranglethorn Vale"]),8)
	self:addTradeSkillSpell(9980, 245, self:CombineQuests(L["Ornate Mithril Helm Obt"],0,BZONE["Stranglethorn Vale"]),8)
	self:addTradeSkillSpell(9957, 210, self:CombineQuests(L["Orcish War Leggings Obt"],2,BZONE["Orgrimmar"]), BFAC["Horde"],8)
	self:addTradeSkillSpell(16646, 265, self:CombineQuests(L["Imperial Plate Shoulders Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(16647, 265, self:CombineQuests(L["Imperial Plate Belt Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(15293, 270, self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Blackrock Depths"]) .. addon.br .. self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(16649, 270, self:CombineQuests(L["Imperial Plate Bracers Obt"],0,BZONE["Tanaris"]),3,8)
	self:addTradeSkillSpell(10013, 255, self:CombineQuests(L["Spectral Essence Obt"],0,BZONE["Western Plaguelands"]),8)
	self:addTradeSkillSpell(16971, 280, self:CombineQuests(L["Spectral Essence Obt"],0,BZONE["Western Plaguelands"]),8)
	self:addTradeSkillSpell(16661, 295, self:CombineQuests(L["Spectral Essence Obt"],0,BZONE["Western Plaguelands"]),8)
	self:addTradeSkillSpell(16969, 275, self:CombineQuests(L["Spectral Essence Obt"],0,BZONE["Western Plaguelands"]),8)
	self:addTradeSkillSpell(15295, 280, self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Blackrock Depths"]) .. addon.br .. self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(16657, 295, self:CombineQuests(L["Imperial Plate Boots Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(16658, 295, self:CombineQuests(L["Imperial Plate Helm Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(16663, 300, self:CombineQuests(L["Imperial Plate Chest Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(16664, 300, self:CombineMobs(false,L["Runic Plate Shoulders Obt"],BZONE["Dustwallow Marsh"]),4)
	self:addTradeSkillSpell(16665, 300, self:CombineMobs(false,L["Runic Plate Boots Obt"],BZONE["Western Plaguelands"]),4)
	self:addTradeSkillSpell(16726, 300, self:CombineMobs(false,L["Runic Plate Helm Obt"],BZONE["Dustwallow Marsh"]),4)
	self:addTradeSkillSpell(16730, 300, self:CombineQuests(L["Imperial Plate Leggings Obt"],0,BZONE["Tanaris"]),4,8)
	self:addTradeSkillSpell(16731, 300, self:CombineMobs(false,L["Runic Breastplate Obt"],BZONE["Dustwallow Marsh"]),4)
	self:addTradeSkillSpell(16732, 300, self:CombineMobs(false,L["Runic Plate Leggings Obt"],BZONE["Western Plaguelands"]),4)
	self:addTradeSkillSpell(21161, 300, self:CombineQuests(L["Sulfuron Hammer Obt"],0,BZONE["Blackrock Depths"]),6,8)
	self:addTradeSkillSpell(24914, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),3,8)
	self:addTradeSkillSpell(24912, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),3,8)
	self:addTradeSkillSpell(24913, 300, self:CombineQuests(L["TrueBelieverQuest"],0,BZONE["Silithus"]),3,8)
	self:addTradeSkillSpell(16984, 290, self:CombineMobs(true,L["Volcanic Hammer Obt"],BZONE["Burning Steppes"]),3)
	self:addTradeSkillSpell(15294, 275, self:CombineMobs(true,L["Dark Iron Sunderer Obt"],BZONE["Blackrock Depths"]),3,5)
	self:addTradeSkillSpell(16995, 300, self:CombineMobs(true,BBOSS["Cannon Master Willey"],BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(15296, 285, self:CombineMobs(true,BBOSS["Ribbly Screwspigot"],BZONE["Blackrock Depths"]),3,5)
	self:addTradeSkillSpell(16667, 285, self:CombineQuests(L["Demon Forged Breastplate Obt"],0,BZONE["Upper Blackrock Spire"]),5,8)
	self:addTradeSkillSpell(16655, 290, self:CombineQuests(L["Fiery Plate Gauntlets Obt"],0,BZONE["Winterspring"]),4,8)
	self:addTradeSkillSpell(16742, 300, self:CombineQuests(L["Enchanted Thorium Helm Obt"],0,BZONE["Dire Maul"]),3,5)
	self:addTradeSkillSpell(16744, 300, self:CombineQuests(L["Enchanted Thorium Leggings Obt"],0,BZONE["Dire Maul"]),3,5)
	self:addTradeSkillSpell(16745, 300, self:CombineQuests(L["Enchanted Thorium Breastplate Obt"],0,BZONE["Dire Maul"]),3,5)
	self:addTradeSkillSpell(16746, 300, L["EWD"] .. addon.br .. self:CombineMobs(true,BBOSS["Goraluk Anvilcrack"],BZONE["Upper Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(16990, 300, self:CombineMobs(true,BBOSS["Goraluk Anvilcrack"],BZONE["Upper Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(16992, 300, self:CombineMobs(true,L["Frostguard Obt"],BZONE["Western Plaguelands"]),3)
	self:addTradeSkillSpell(16985, 290, self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Blackrock Depths"]) .. addon.br .. self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(16983, 285, self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Blackrock Depths"]) .. addon.br .. self:CombineQuests(L["Blacksmithing Plans"],0,BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(16988, 300, self:CombineMobs(true,BBOSS["Maleki the Pallid"],BZONE["Stratholme"]),3,5)
	self:addTradeSkillSpell(16993, 300, self:CombineMobs(true,BBOSS["Goraluk Anvilcrack"],BZONE["Upper Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(16991, 300, self:CombineMobs(true,BBOSS["Quartermaster Zigris"],BZONE["Lower Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(16994, 300, self:CombineMobs(true,BBOSS["Bannok Grimaxe"],BZONE["Lower Blackrock Spire"]),3,5)
	self:addTradeSkillSpell(29619, 360, self:CombineMobs(false,L["Felsteel Gloves Obt"],BZONE["Auchenai Crypts"]),4,5)
	self:addTradeSkillSpell(29620, 360, self:CombineMobs(false,L["Felsteel Leggings Obt"],BZONE["The Arcatraz"]),4,5)
	self:addTradeSkillSpell(29628, 360, self:CombineMobs(false,L["Khorium Belt Obt"],BZONE["Nagrand"]),4)
	self:addTradeSkillSpell(29629, 360, self:CombineMobs(false,L["Khorium Pants Obt"],BZONE["Shadowmoon Valley"]),4)
	self:addTradeSkillSpell(29621, 365, self:CombineMobs(false,L["Felsteel Helm Obt"],BZONE["Shadow Labyrinth"]),4,5)
	self:addTradeSkillSpell(29630, 365, self:CombineMobs(false,L["Khorium Boots Obt"],BZONE["Netherstorm"]),4)
	self:addTradeSkillSpell(29642, 365, self:CombineMobs(false,L["Ragesteel Gloves Obt"],BZONE["Nagrand"]),4)
	self:addTradeSkillSpell(29643, 365, self:CombineMobs(false,L["Ragesteel Helm Obt"],BZONE["Blade's Edge Mountains"]),4)
	self:addTradeSkillSpell(29645, 370, self:CombineMobs(false,L["Ragesteel Breastplate Obt"],BZONE["Shadowmoon Valley"]),4)
	self:addTradeSkillSpell(29648, 370, self:CombineMobs(false,L["Swiftsteel Gloves Obt"],BZONE["Mana-Tombs"]),4,5)
 	self:addTradeSkillSpell(29649, 370, self:CombineMobs(false,BBOSS["High Botanist Freywinn"],BZONE["The Botanica"]),4,5)
	self:addTradeSkillSpell(29729, 375, self:CombineMobs(false,L["Greater Ward of Shielding Obt"],BZONE["Netherstorm"]),4)
	self:addTradeSkillSpell(42662, 365, self:CombineMobs(false,L["Ragesteel Shoulders Obt"],BZONE["Shadowmoon Valley"]),4)
	self:addTradeSkillSpell(16978, 280, self:CombineQuests(L["Blazing Rapier Obt"],0,BZONE["Stratholme"]),5,8)
	self:addTradeSkillSpell(16973, 280, self:CombineQuests(L["Enchanted Battlehammer Obt"],0,BZONE["Stratholme"]),5,8)
	self:addTradeSkillSpell(16970, 275, self:CombineQuests(L["Dawn's Edge Obt"],0,BZONE["Lower Blackrock Spire"]),5,8)

	-- Seasonal
	self:addTradeSkillSpell(21913, 190, L["WintersVeil"], 7)

	-- Reputations
	self:addTradeSkillSpell(23628, 290, self:AddSingleReputation(2, BFAC["Timbermaw Hold"]), BFAC["Timbermaw Hold"])
	self:addTradeSkillSpell(23632, 290, self:AddSingleReputation(2, BFAC["Argent Dawn"]), BFAC["Argent Dawn"])
	self:addTradeSkillSpell(23629, 300, self:AddSingleReputation(3, BFAC["Timbermaw Hold"]), BFAC["Timbermaw Hold"])
	self:addTradeSkillSpell(23633, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]), BFAC["Argent Dawn"])
	self:addTradeSkillSpell(24136, 300, self:AddSingleReputation(3, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24138, 300, self:AddSingleReputation(1, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24137, 300, self:AddSingleReputation(2, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24139, 300, self:AddSingleReputation(3, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24140, 300, self:AddSingleReputation(2, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(24141, 300, self:AddSingleReputation(1, BFAC["Zandalar Tribe"]), BFAC["Zandalar Tribe"], 6)
	self:addTradeSkillSpell(27585, 300, self:AddSingleReputation(1, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(27588, 300, self:AddSingleReputation(2, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(27586, 300, self:AddSingleReputation(3, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(20897, 300, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23653, 300, self:AddSingleReputation(4, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(28244, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6)
	self:addTradeSkillSpell(28243, 300, self:AddSingleReputation(3, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6)
	self:addTradeSkillSpell(28242, 300, self:AddSingleReputation(4, BFAC["Argent Dawn"]) .. addon.br .. L["ADNaxx"], BFAC["Argent Dawn"], 6)
	self:addTradeSkillSpell(23650, 300, self:AddSingleReputation(4, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(20890, 300, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23652, 300, self:AddSingleReputation(4, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(20876, 300, self:AddSingleReputation(4, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(20873, 300, self:AddSingleReputation(3, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23636, 300, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23637, 300, self:AddSingleReputation(3, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(24399, 300, self:AddSingleReputation(4, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(20874, 295, self:AddSingleReputation(1, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(20872, 295, self:AddSingleReputation(2, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23638, 300, self:AddSingleReputation(3, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(23639, 300, self:AddSingleReputation(3, BFAC["Thorium Brotherhood"]), BFAC["Thorium Brotherhood"])
	self:addTradeSkillSpell(28461, 300, self:AddSingleReputation(3, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(28462, 300, self:AddSingleReputation(2, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(28463, 300, self:AddSingleReputation(1, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(27590, 300, self:AddSingleReputation(4, BFAC["Cenarion Circle"]), BFAC["Cenarion Circle"])
	self:addTradeSkillSpell(29656, 350, self:AddSingleReputation(2, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(32285, 350, self:AddSingleReputation(2, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(34608, 350, self:AddSingleReputation(2, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(29614, 350, self:AddSingleReputation(1, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(29608, 355, self:AddSingleReputation(1, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(29611, 355, self:AddSingleReputation(2, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(29615, 355, self:AddSingleReputation(4, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(29610, 360, self:AddSingleReputation(3, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(29616, 360, self:AddSingleReputation(2, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(29657, 360, self:AddDoubleReputation(4, BFAC["Honor Hold"], BFAC["Thrallmar"]), BFAC["Thrallmar"])
	self:addTradeSkillSpell(29613, 365, self:AddSingleReputation(4, BFAC["The Scryers"]), BFAC["The Scryers"])
	self:addTradeSkillSpell(29617, 365, self:AddSingleReputation(3, BFAC["The Aldor"]), BFAC["The Aldor"])
	self:addTradeSkillSpell(38473, 375, self:AddSingleReputation(4, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(38475, 375, self:AddSingleReputation(3, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(38476, 375, self:AddSingleReputation(3, BFAC["Cenarion Expedition"]), BFAC["Cenarion Expedition"])
	self:addTradeSkillSpell(38477, 375, self:AddSingleReputation(2, BFAC["The Violet Eye"]), 6)
	self:addTradeSkillSpell(38478, 375, self:AddSingleReputation(3, BFAC["The Violet Eye"]), 6)
	self:addTradeSkillSpell(38479, 375, self:AddSingleReputation(2, BFAC["The Violet Eye"]), 6)
 	self:addTradeSkillSpell(40034, 375, self:AddSingleReputation(1, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6)
	self:addTradeSkillSpell(40036, 375, self:AddSingleReputation(1, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6)
	self:addTradeSkillSpell(40035, 375, self:AddSingleReputation(2, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6)
	self:addTradeSkillSpell(40033, 375, self:AddSingleReputation(2, BFAC["Ashtongue Deathsworn"]), BFAC["Ashtongue Deathsworn"], 6)

	-- Raid Drops
	self:addTradeSkillSpell(22757, 300, L["MOLTENCORE"],3,6)
	self:addTradeSkillSpell(27589, 300, self:CombineMobs(false,BBOSS["Moam"],BZONE["Ruins of Ahn'Qiraj"]),3,6)
	self:addTradeSkillSpell(27587, 300, self:CombineMobs(false,BBOSS["The Prophet Skeram"],BZONE["Temple of Ahn'Qiraj"]),3,6)
	self:addTradeSkillSpell(36392, 375, L["SSC/TKBoE"],2,6)
	self:addTradeSkillSpell(36389, 375, L["SSC/TKBoP"],3,6)
	self:addTradeSkillSpell(36390, 375, L["SSC/TKBoP"],3,6)
	self:addTradeSkillSpell(36391, 375, L["SSC/TKBoE"],2,6)
	self:addTradeSkillSpell(41134, 375, L["BT/HYJALBoP"],3,6)
	self:addTradeSkillSpell(41135, 375, L["BT/HYJALBoE"],2,6)
	self:addTradeSkillSpell(41132, 375, L["BT/HYJALBoP"],3,6)
	self:addTradeSkillSpell(41133, 375, L["BT/HYJALBoE"],2,6)
	self:addTradeSkillSpell(46140, 365, L["SunwellBoP"],3,6)
	self:addTradeSkillSpell(46141, 365, L["SunwellBoP"],3,6)
	self:addTradeSkillSpell(46142, 365, L["SunwellBoE"],2,6)
	self:addTradeSkillSpell(46144, 365, L["SunwellBoE"],2,6)

	-- Weaponsmith
	self:addTradeSkillSpell(36125, 260, L["Trainer"], GetSpellInfo(9787),1)
	self:addTradeSkillSpell(36128, 260, L["Trainer"], GetSpellInfo(9787),1)
	self:addTradeSkillSpell(36126, 260, L["Trainer"], GetSpellInfo(9787),1)
	self:addTradeSkillSpell(15292, 265, self:CombineMobs(true,BBOSS["Grizzle"],BZONE["Blackrock Depths"]), 3,GetSpellInfo(9787),5)

	-- Armorsmith
	self:addTradeSkillSpell(36122, 260, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(36124, 260, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(36129, 330, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(36130, 330, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(34529, 350, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(34533, 350, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(34530, 375, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(36256, 375, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(34534, 375, L["Trainer"], GetSpellInfo(9788),1)
	self:addTradeSkillSpell(36257, 375, L["Trainer"], GetSpellInfo(9788),1)
	
	-- Master Swordsmith
	self:addTradeSkillSpell(36131, 330, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(36133, 330, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(34535, 350, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(34538, 350, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(36258, 375, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(34537, 375, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(34540, 375, L["Trainer"], GetSpellInfo(17039),1)
	self:addTradeSkillSpell(36259, 375, L["Trainer"], GetSpellInfo(17039),1)

	-- Master Hammersmith
	self:addTradeSkillSpell(36137, 330, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(36136, 330, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(34545, 350, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(34547, 350, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(34548, 375, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(34546, 375, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(36262, 375, L["Trainer"], GetSpellInfo(17040),1)
	self:addTradeSkillSpell(36263, 375, L["Trainer"], GetSpellInfo(17040),1)

	-- Master Axesmith
	self:addTradeSkillSpell(36135, 330, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(36134, 330, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(34541, 350, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(34543, 350, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(34542, 375, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(36261, 375, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(34544, 375, L["Trainer"], GetSpellInfo(17041),1)
	self:addTradeSkillSpell(36260, 375, L["Trainer"], GetSpellInfo(17041),1)
	
end
