--[[

ARL-BeastTrain.lua

Beast Training data for all of AckisRecipeList

$Date: 2008-07-07 04:27:15 +0000 (Mon, 07 Jul 2008) $
$Rev: 729 $

]]--

local L			= LibStub("AceLocale-3.0"):GetLocale("Ackis Recipe List")
local BZONE		= LibStub("LibBabble-Zone-3.0"):GetLookupTable()

local addon = AckisRecipeList

function addon:InitBeastTraining()

	-- Add pets in which skill may be aquired.
	self:addPetList(1, L["Ragged Scavenger"], BZONE["Tirisfal Glades"], 2, 3, false, false)
	self:addPetList(2, L["Night Web Spider"], BZONE["Tirisfal Glades"], 3, 4, false, false)
	self:addPetList(3, L["Forest Spider"], BZONE["Elwynn Forest"], 5, 6, false, false)
	self:addPetList(4, L["Githyiss the Vile"], BZONE["Teldrassil"], 5, 5, false, false)
	self:addPetList(5, L["Night Web Matriarch"], BZONE["Tirisfal Glades"], 5, 5, false, false)
	self:addPetList(6, L["Prairie Wolf"], BZONE["Mulgore"], 5, 6, false, false)
	self:addPetList(7, L["Snow Tracker Wolf"], BZONE["Dun Morogh"], 6, 7, false, false)
	self:addPetList(8, L["Gray Forest Wolf"], BZONE["Elwynn Forest"], 7, 8, false, false)
	self:addPetList(9, L["Prairie Stalker"], BZONE["Mulgore"], 7, 8, false, false)
	self:addPetList(10, L["Webwood Venomfang"], BZONE["Teldrassil"], 7, 8, false, false)
	self:addPetList(11, L["Winter Wolf"], BZONE["Dun Morogh"], 7, 8, false, false)
	self:addPetList(12, L["Dreadmaw Crocolisk"], BZONE["Durotar"], 9, 11, false, false)
	self:addPetList(13, L["Starving Winter Wolf"], BZONE["Dun Morogh"], 8, 9, false, false)
	self:addPetList(14, L["Webwood Silkspinner"], BZONE["Teldrassil"], 8, 9, false, false)
	self:addPetList(15, L["Prairie Wolf Alpha"], BZONE["Mulgore"], 9, 10, false, false)
	self:addPetList(16, L["Prowler"], BZONE["Elwynn Forest"], 9, 10, false, false)
	self:addPetList(17, L["Ravager Specimen"], BZONE["Azuremyst Isle"], 9, 10, false, false)
	self:addPetList(18, L["Vicious Night Web Spider"], BZONE["Tirisfal Glades"], 9, 10, false, false)
	self:addPetList(19, L["Coyote"], BZONE["Westfall"], 10, 11, false, false)
	self:addPetList(20, L["Forest Lurker"], BZONE["Loch Modan"], 9, 11, false, false)
	self:addPetList(21, L["Giant Webwood Spider"], BZONE["Teldrassil"], 10, 11, false, false)
	self:addPetList(22, L["Timber"], BZONE["Dun Morogh"], 10, 10, false, true)
	self:addPetList(23, L["Worg"], BZONE["Silverpine Forest"], 10, 11, false, false)
	self:addPetList(24, L["Coyote Packleader"], BZONE["Westfall"], 11, 12, false, false)
	self:addPetList(25, L["Lady Sathrah"], BZONE["Teldrassil"], 12, 12, false, false)
	self:addPetList(26, L["Loch Crocolisk"], BZONE["Loch Modan"], 14, 15, false, false)
	self:addPetList(27, L["Oasis Snapjaw"], BZONE["The Barrens"], 15, 16, false, false)
	self:addPetList(28, L["Tarantula"], BZONE["Redridge Mountains"], 15, 16, false, false)
	self:addPetList(29, L["Bloodsnout Worg"], BZONE["Silverpine Forest"], 16, 16, false, false)
	self:addPetList(30, L["Deepmoss Creeper"], BZONE["Stonetalon Mountains"], 16, 17, false, false)
	self:addPetList(31, L["Ghostclaw Ravager"], BZONE["Ghostlands"], 16, 17, false, false)
	self:addPetList(32, L["Wood Lurker"], BZONE["Loch Modan"], 17, 18, false, false)
	self:addPetList(33, L["Deviate Crocolisk"], BZONE["Wailing Caverns"], 18, 19, false, false)
	self:addPetList(34, L["Deepmoss Webspinner"], BZONE["Stonetalon Mountains"], 19, 20, false, false)
	self:addPetList(35, L["Ghostpaw Runner"], BZONE["Ashenvale"], 19, 20, false, false)
	self:addPetList(36, L["Greater Tarantula"], BZONE["Redridge Mountains"], 19, 20, false, false)
	self:addPetList(37, L["Shanda the Spinner"], BZONE["Loch Modan"], 19, 19, false, true)
	self:addPetList(38, L["Forest Moss Creeper"], BZONE["Hillsbrad Foothills"], 20, 21, false, false)
	self:addPetList(39, L["Kresh"], BZONE["Wailing Caverns"], 20, 20, true, false)
	self:addPetList(40, L["Besseleth"], BZONE["Stonetalon Mountains"], 21, 21, true, false)
	self:addPetList(41, L["Green Recluse"], BZONE["Duskwood"], 21, 22, false, false)
	self:addPetList(42, L["Large Loch Crocolisk"], BZONE["Loch Modan"], 22, 22, false, true)
	self:addPetList(43, L["Aku'mai Fisher"], BZONE["Blackfathom Deeps"], 23, 24, true, false)
	self:addPetList(44, L["Chatter"], BZONE["Redridge Mountains"], 23, 23, false, true)
	self:addPetList(45, L["Lupos"], BZONE["Duskwood"], 23, 23, false, true)
	self:addPetList(46, L["Creepthess"], BZONE["Hillsbrad Foothills"], 24, 24, false, true)
	self:addPetList(47, L["Black Ravager"], BZONE["Duskwood"], 24, 25, false, false)
	self:addPetList(48, L["Giant Moss Creeper"], BZONE["Hillsbrad Foothills"], 24, 25, false, false)
	self:addPetList(49, L["Leech Widow"], BZONE["Wetlands"], 24, 24, false, true)
	self:addPetList(50, L["Black Ravager Mastiff"], BZONE["Duskwood"], 25, 26, false, false)
	self:addPetList(51, L["Ghamoo-ra"], BZONE["Blackfathom Deeps"], 25, 25, true, false)
	self:addPetList(52, L["Giant Wetlands Crocolisk"], BZONE["Wetlands"], 25, 26, false, false)
	self:addPetList(53, L["Aku'mai Snapjaw"], BZONE["Blackfathom Deeps"], 26, 27, true, false)
	self:addPetList(54, L["Elder Moss Creeper"], BZONE["Hillsbrad Foothills"], 26, 27, false, false)
	self:addPetList(55, L["Ghostpaw Alpha"], BZONE["Ashenvale"], 27, 28, false, false)
	self:addPetList(56, L["Naraxis"], BZONE["Duskwood"], 27, 27, false, true)
	self:addPetList(57, L["Wildthorn Lurker"], BZONE["Ashenvale"], 28, 29, false, false)
	self:addPetList(58, L["Snapjaw"], BZONE["Hillsbrad Foothills"], 30, 31, false, false)
	self:addPetList(59, L["Plains Creeper"], BZONE["Arathi Highlands"], 32, 33, false, false)
	self:addPetList(60, L["Sparkleshell Snapper"], BZONE["Thousand Needles"], 34, 35, false, false)
	self:addPetList(61, L["Crag Coyote"], BZONE["Badlands"], 35, 36, false, false)
	self:addPetList(62, L["Drywallow Crocolisk"], BZONE["Dustwallow Marsh"], 35, 36, false, false)
	self:addPetList(63, L["Giant Plains Creeper"], BZONE["Arathi Highlands"], 35, 36, false, false)
	self:addPetList(64, L["Barnabus"], BZONE["Badlands"], 38, 38, false, true)
	self:addPetList(65, L["Darkfang Creeper"], BZONE["Dustwallow Marsh"], 38, 39, false, false)
	self:addPetList(66, L["Mottled Drywallow Crocolisk"], BZONE["Dustwallow Marsh"], 38, 39, false, false)
	self:addPetList(67, L["Ripscale"], BZONE["Dustwallow Marsh"], 39, 39, false, true)
	self:addPetList(68, L["Deathstrike Tarantula"], BZONE["Swamp of Sorrows"], 40, 41, false, false)
	self:addPetList(69, L["Drywallow Daggermaw"], BZONE["Dustwallow Marsh"], 40, 41, false, false)
	self:addPetList(70, L["Longtooth Runner"], BZONE["Feralas"], 40, 41, false, false)
	self:addPetList(71, L["Mudrock Snapjaw"], BZONE["Dustwallow Marsh"], 41, 42, false, false)
	self:addPetList(72, L["Sawtooth Snapper"], BZONE["Swamp of Sorrows"], 41, 42, false, false)
	self:addPetList(73, L["Old Cliff Jumper"], BZONE["The Hinterlands"], 42, 42, false, true)
	self:addPetList(74, L["Snarler"], BZONE["Feralas"], 42, 42, false, true)
	self:addPetList(75, L["Deadmire"], BZONE["Dustwallow Marsh"], 45, 45, false, false)
	self:addPetList(76, L["Felpaw Wolf"], BZONE["Felwood"], 47, 48, false, false)
	self:addPetList(77, L["Timberweb Recluse"], BZONE["Azshara"], 47, 48, false, false)
	self:addPetList(78, L["Death Howl"], BZONE["Felwood"], 49, 49, false, true)
	self:addPetList(79, L["Rekk'tilac"], BZONE["Searing Gorge"], 48, 48, false, true)
	self:addPetList(80, L["Saltwater Snapjaw"], BZONE["The Hinterlands"], 49, 50, false, false)
	self:addPetList(81, L["Cave Creeper"], BZONE["Blackrock Depths"], 50, 52, false, false)
	self:addPetList(82, L["Vilebranch Raiding Wolf"], BZONE["The Hinterlands"], 50, 51, false, false)
	self:addPetList(83, L["Felpaw Ravager"], BZONE["Felwood"], 51, 52, false, false)
	self:addPetList(84, L["Ironback"], BZONE["The Hinterlands"], 51, 51, false, true)
	self:addPetList(85, L["Uhk'loc"], BZONE["Un'Goro Crater"], 52, 53, false, true)
	self:addPetList(86, L["Diseased Wolf"], BZONE["Western Plaguelands"], 53, 54, false, false)
	self:addPetList(87, L["Plague Lurker"], BZONE["Western Plaguelands"], 54, 55, false, false)
	self:addPetList(88, L["Bloodaxe Worg"], BZONE["Blackrock Spire"], 56, 57, true, false)
	self:addPetList(89, L["Quillfang Ravager"], BZONE["Hellfire Peninsula"], 62, 63, false, false)
	self:addPetList(90, L["Thornfang Venomspitter"], BZONE["Hellfire Peninsula"], 62, 63, false, false)
	self:addPetList(91, L["Dreadfang Lurker"], BZONE["Terokkar Forest"], 63, 64, false, false)
	self:addPetList(92, L["Dreadfang Widow"], BZONE["Terokkar Forest"], 64, 65, false, false)
	self:addPetList(93, L["Rema"], BZONE["Blade's Edge Mountains"], 66, 66, false, false)
	self:addPetList(94, L["Scorpid Worker"], BZONE["Durotar"], 3, 3, false, false)
	self:addPetList(95, L["Sarkoth"], BZONE["Durotar"], 4, 4, false, false)
	self:addPetList(96, L["Pygmy Surf Crawler"], BZONE["Durotar"], 5, 6, false, false)
	self:addPetList(97, L["Strigid Owl"], BZONE["Teldrassil"], 5, 6, false, false)
	self:addPetList(98, L["Ice Claw Bear"], BZONE["Dun Morogh"], 7, 8, false, false)
	self:addPetList(99, L["Elder Springpaw"], BZONE["Eversong Woods"], 8, 9, false, false)
	self:addPetList(100, L["Strigid Hunter"], BZONE["Teldrassil"], 8, 9, false, false)
	self:addPetList(101, L["Young Forest Bear"], BZONE["Elwynn Forest"], 8, 9, false, false)
	self:addPetList(102, L["Encrusted Surf Crawler"], BZONE["Durotar"], 9, 10, false, false)
	self:addPetList(103, L["Venomtail Scorpid"], BZONE["Durotar"], 9, 10, false, false)
	self:addPetList(104, L["Death Flayer"], BZONE["Durotar"], 11, 11, false, true)
	self:addPetList(105, L["Ferocious Grizzled Bear"], BZONE["Silverpine Forest"], 11, 12, false, false)
	self:addPetList(106, L["Mangeclaw"], BZONE["Dun Morogh"], 11, 11, false, false)
	self:addPetList(107, L["Thistle Bear"], BZONE["Darkshore"], 11, 12, false, false)
	self:addPetList(108, L["Bjarn"], BZONE["Dun Morogh"], 12, 12, false, true)
	self:addPetList(109, L["Tide Crawler"], BZONE["Darkshore"], 12, 14, false, false)
	self:addPetList(110, L["Ghostclaw Lynx"], BZONE["Ghostlands"], 13, 14, false, false)
	self:addPetList(111, L["Black Bear Patriarch"], BZONE["Loch Modan"], 16, 17, false, false)
	self:addPetList(113, L["Shore Crawler"], BZONE["Westfall"], 17, 18, false, false)
	self:addPetList(114, L["Den Mother"], BZONE["Darkshore"], 18, 19, false, false)
	self:addPetList(115, L["Clattering Crawler"], BZONE["Ashenvale"], 19, 20, false, false)
	self:addPetList(116, L["Ghost Saber"], BZONE["Darkshore"], 19, 20, false, false)
	self:addPetList(117, L["Ol' Sooty"], BZONE["Loch Modan"], 20, 20, false, false)
	self:addPetList(118, L["Ashenvale Bear"], BZONE["Ashenvale"], 21, 22, false, false)
	self:addPetList(119, L["Gray Bear"], BZONE["Hillsbrad Foothills"], 21, 22, false, false)
	self:addPetList(120, L["Skittering Crustacean"], BZONE["Blackfathom Deeps"], 22, 23, true, false)
	self:addPetList(121, L["Snapping Crustacean"], BZONE["Blackfathom Deeps"], 23, 24, true, false)
	self:addPetList(122, L["Barbed Crustacean"], BZONE["Blackfathom Deeps"], 25, 26, true, false)
	self:addPetList(123, L["Elder Ashenvale Bear"], BZONE["Ashenvale"], 25, 26, false, false)
	self:addPetList(124, L["Scorpashi Snapper"], BZONE["Desolace"], 30, 31, false, false)
	self:addPetList(125, L["Scorpid Reaver"], BZONE["Thousand Needles"], 31, 32, false, false)
	self:addPetList(126, L["Scorpashi Lasher"], BZONE["Desolace"], 34, 35, false, false)
	self:addPetList(127, L["Vile Sting"], BZONE["Thousand Needles"], 35, 35, true, false)
	self:addPetList(128, L["Drywallow Snapper"], BZONE["Dustwallow Marsh"], 37, 38, false, false)
	self:addPetList(129, L["Venomlash Scorpid"], BZONE["Uldaman"], 39, 40, false, true)
	self:addPetList(130, L["Scorpid Hunter"], BZONE["Tanaris"], 40, 41, false, false)
	self:addPetList(131, L["Silt Crawler"], BZONE["Swamp of Sorrows"], 40, 41, false, false)
	self:addPetList(132, L["Ironfur Bear"], BZONE["Feralas"], 41, 42, false, false)
	self:addPetList(133, L["King Bangalash"], BZONE["Stranglethorn Vale"], 43, 43, true, false)
	self:addPetList(134, L["Monstrous Crawler"], BZONE["Swamp of Sorrows"], 43, 44, false, false)
	self:addPetList(135, L["Old Grizzlegut"], BZONE["Feralas"], 43, 43, false, true)
	self:addPetList(136, L["Ironfur Patriarch"], BZONE["Feralas"], 48, 49, false, false)
	self:addPetList(137, L["Angerclaw Mauler"], BZONE["Felwood"], 49, 50, false, false)
	self:addPetList(138, L["Ironbeak Hunter"], BZONE["Felwood"], 50, 51, false, false)
	self:addPetList(139, L["Mongress"], BZONE["Felwood"], 50, 50, false, true)
	self:addPetList(140, L["Olm the Wise"], BZONE["Felwood"], 52, 52, false, true)
	self:addPetList(141, L["Clack the Reaver"], BZONE["Blasted Lands"], 53, 53, false, true)
	self:addPetList(142, L["Shardtooth Bear"], BZONE["Winterspring"], 53, 54, false, false)
	self:addPetList(143, L["Deathlash Scorpid"], BZONE["Burning Steppes"], 54, 55, false, false)
	self:addPetList(144, L["Winterspring Owl"], BZONE["Winterspring"], 54, 56, false, false)
	self:addPetList(145, L["Diseased Grizzly"], BZONE["Western Plaguelands"], 55, 56, false, false)
	self:addPetList(146, L["Elder Shardtooth"], BZONE["Winterspring"], 57, 58, false, false)
	self:addPetList(147, L["Winterspring Screecher"], BZONE["Winterspring"], 57, 59, false, false)
	self:addPetList(148, L["Male Kaliri Hatchling"], BZONE["Hellfire Peninsula"], 61, 61, false, false)
	self:addPetList(150, L["Scorpid Bonecrawler"], BZONE["Terokkar Forest"], 64, 65, false, false)
	self:addPetList(151, L["Ravenous Windroc"], BZONE["Nagrand"], 65, 66, false, false)
	self:addPetList(152, L["Windroc Hunter"], BZONE["Nagrand"], 65, 65, false, false)
	self:addPetList(153, L["Greater Windroc"], BZONE["Nagrand"], 66, 67, false, false)
	self:addPetList(154, L["Windroc Huntress"], BZONE["Nagrand"], 66, 66, false, false)
	self:addPetList(155, L["Gutripper"], BZONE["Nagrand"], 67, 67, true, false)
	self:addPetList(156, L["Shadowwing Owl"], BZONE["Shadowmoon Valley"], 67, 67, false, false)
	self:addPetList(157, L["Ripfang Lynx"], BZONE["Netherstorm"], 68, 69, false, false)
	self:addPetList(158, L["Mottled Boar"], BZONE["Durotar"], 1, 2, false, false)
	self:addPetList(159, L["Young Thistle Boar"], BZONE["Teldrassil"], 1, 2, false, false)
	self:addPetList(160, L["Thistle Boar"], BZONE["Teldrassil"], 2, 3, false, false)
	self:addPetList(161, L["Battleboar"], BZONE["Mulgore"], 3, 4, false, false)
	self:addPetList(162, L["Small Crag Boar"], BZONE["Dun Morogh"], 3, 3, false, false)
	self:addPetList(163, L["Bristleback Battleboar"], BZONE["Mulgore"], 4, 5, false, false)
	self:addPetList(164, L["Crag Boar"], BZONE["Dun Morogh"], 5, 6, false, false)
	self:addPetList(165, L["Dire Mottled Boar"], BZONE["Durotar"], 6, 7, false, false)
	self:addPetList(166, L["Large Crag Boar"], BZONE["Dun Morogh"], 6, 7, false, false)
	self:addPetList(167, L["Elder Crag Boar"], BZONE["Dun Morogh"], 7, 8, false, false)
	self:addPetList(168, L["Porcine Entourage"], BZONE["Elwynn Forest"], 7, 7, false, false)
	self:addPetList(169, L["Rockhide Boar"], BZONE["Elwynn Forest"], 7, 8, false, false)
	self:addPetList(170, L["Stonetusk Boar"], BZONE["Elwynn Forest"], 7, 8, false, false)
	self:addPetList(171, L["Elder Mottled Boar"], BZONE["Durotar"], 8, 9, false, false)
	self:addPetList(172, L["Princess"], BZONE["Elwynn Forest"], 9, 9, false, false)
	self:addPetList(173, L["Scarred Crag Boar"], BZONE["Dun Morogh"], 9, 10, false, false)
	self:addPetList(174, L["Corrupted Mottled Boar"], BZONE["Durotar"], 10, 11, false, false)
	self:addPetList(175, L["Longsnout"], BZONE["Elwynn Forest"], 10, 11, false, false)
	self:addPetList(176, L["Mountain Boar"], BZONE["Loch Modan"], 10, 11, false, false)
	self:addPetList(177, L["Young Goretusk"], BZONE["Westfall"], 12, 13, false, false)
	self:addPetList(178, L["Goretusk"], BZONE["Westfall"], 14, 15, false, false)
	self:addPetList(179, L["Mangy Mountain Boar"], BZONE["Loch Modan"], 14, 15, false, false)
	self:addPetList(180, L["Elder Mountain Boar"], BZONE["Loch Modan"], 16, 17, false, false)
	self:addPetList(181, L["Great Goretusk"], BZONE["Redridge Mountains"], 16, 17, false, false)
	self:addPetList(182, L["Agam'ar"], BZONE["Razorfen Kraul"], 24, 25, true, false)
	self:addPetList(183, L["Bellygrub"], BZONE["Redridge Mountains"], 24, 24, false, false)
	self:addPetList(184, L["Raging Agam'ar"], BZONE["Razorfen Kraul"], 25, 26, true, false)
	self:addPetList(185, L["Rotting Agam'ar"], BZONE["Razorfen Kraul"], 28, 28, true, false)
	self:addPetList(186, L["Ashmane Boar"], BZONE["Blasted Lands"], 48, 49, false, false)
	self:addPetList(187, L["Grunter"], BZONE["Blasted Lands"], 50, 50, false, true)
	self:addPetList(188, L["Plagued Swine"], BZONE["Eastern Plaguelands"], 60, 60, false, false)
	self:addPetList(189, L["Juvenile Snow Leopard"], BZONE["Dun Morogh"], 5, 6, false, false)
	self:addPetList(190, L["Nightsaber"], BZONE["Teldrassil"], 5, 6, false, false)
	self:addPetList(191, L["Greater Duskbat"], BZONE["Tirisfal Glades"], 6, 7, false, false)
	self:addPetList(192, L["Durotar Tiger"], BZONE["Durotar"], 7, 8, false, false)
	self:addPetList(193, L["Flatland Cougar"], BZONE["Mulgore"], 7, 8, false, false)
	self:addPetList(194, L["Elder Plainstrider"], BZONE["Mulgore"], 8, 9, false, false)
	self:addPetList(195, L["Mazzranache"], BZONE["Mulgore"], 9, 9, false, true)
	self:addPetList(196, L["Moonstalker Runt"], BZONE["Darkshore"], 10, 11, false, false)
	self:addPetList(197, L["Foreststrider Fledgling"], BZONE["Darkshore"], 11, 13, false, false)
	self:addPetList(198, L["Fleeting Plainstrider"], BZONE["The Barrens"], 12, 13, false, false)
	self:addPetList(199, L["Savannah Patriarch"], BZONE["The Barrens"], 15, 16, false, false)
	self:addPetList(200, L["Ornery Plainstrider"], BZONE["The Barrens"], 16, 17, false, false)
	self:addPetList(201, L["Giant Foreststrider"], BZONE["Darkshore"], 17, 19, false, false)
	self:addPetList(202, L["Moonstalker Sire"], BZONE["Darkshore"], 17, 18, false, false)
	self:addPetList(203, L["Starving Mountain Lion"], BZONE["Hillsbrad Foothills"], 23, 24, false, false)
	self:addPetList(204, L["Twilight Runner"], BZONE["Stonetalon Mountains"], 23, 24, false, false)
	self:addPetList(205, L["Crag Stalker"], BZONE["Thousand Needles"], 25, 26, false, false)
	self:addPetList(206, L["Feral Mountain Lion"], BZONE["Hillsbrad Foothills"], 27, 28, false, false)
	self:addPetList(207, L["Kraul Bat"], BZONE["Razorfen Kraul"], 30, 31, true, false)
	self:addPetList(208, L["Young Panther"], BZONE["Stranglethorn Vale"], 30, 31, false, false)
	self:addPetList(209, L["Young Stranglethorn Tiger"], BZONE["Stranglethorn Vale"], 30, 31, false, false)
	self:addPetList(210, L["Greater Kraul Bat"], BZONE["Razorfen Kraul"], 32, 32, true, false)
	self:addPetList(211, L["Panther"], BZONE["Stranglethorn Vale"], 32, 33, false, false)
	self:addPetList(212, L["Ridge Stalker"], BZONE["Badlands"], 36, 37, false, false)
	self:addPetList(213, L["Ridge Huntress"], BZONE["Badlands"], 38, 39, false, false)
	self:addPetList(214, L["Shrike Bat"], BZONE["Uldaman"], 38, 39, true, false)
	self:addPetList(215, L["Dark Screecher"], BZONE["Blackrock Depths"], 50, 52, false, false)
	self:addPetList(216, L["Jaguero Stalker"], BZONE["Stranglethorn Vale"], 50, 50, false, false)
	self:addPetList(217, L["Plaguebat"], BZONE["Eastern Plaguelands"], 53, 55, false, false)
	self:addPetList(218, L["Noxious Plaguebat"], BZONE["Eastern Plaguelands"], 54, 56, false, false)
	self:addPetList(219, L["Frostsaber Cub"], BZONE["Winterspring"], 55, 56, false, false)
	self:addPetList(220, L["Monstrous Plaguebat"], BZONE["Eastern Plaguelands"], 56, 58, false, false)
	self:addPetList(221, L["Grovestalker Lynx "], BZONE["Blade's Edge Mountains"], 65, 66, false, false)
	self:addPetList(223, L["Lost Torranche"], BZONE["Terokkar Forest"], 70, 70, false, false)
	self:addPetList(224, L["Kurzen War Tiger"], BZONE["Stranglethorn Vale"], 32, 33, false, false)
	self:addPetList(225, L["Stranglethorn Tiger"], BZONE["Stranglethorn Vale"], 32, 33, false, false)
	self:addPetList(226, L["Bonepaw Hyena"], BZONE["Desolace"], 33, 35, false, false)
	self:addPetList(227, L["Scarlet Tracking Hound"], BZONE["Scarlet Monastery"], 33, 34, true, false)
	self:addPetList(229, L["Spot"], BZONE["Dustwallow Marsh"], 35, 35, false, false)
	self:addPetList(230, L["Swamp Jaguar"], BZONE["Swamp of Sorrows"], 36, 37, false, false)
	self:addPetList(231, L["Broken Tooth"], BZONE["Badlands"], 37, 37, false, true)
	self:addPetList(232, L["Feral Crag Coyote"], BZONE["Badlands"], 37, 38, false, false)
	self:addPetList(233, L["Magram Bonepaw"], BZONE["Desolace"], 37, 38, false, false)
	self:addPetList(234, L["Sin'Dall"], BZONE["Stranglethorn Vale"], 37, 37, false, false)
	self:addPetList(235, L["Elder Crag Coyote"], BZONE["Badlands"], 39, 40, false, false)
	self:addPetList(236, L["Bhag'thera"], BZONE["Stranglethorn Vale"], 40, 40, true, false)
	self:addPetList(238, L["Ridge Stalker Patriarch"], BZONE["Badlands"], 40, 41, false, false)
	self:addPetList(239, L["Starving Blisterpaw"], BZONE["Tanaris"], 41, 42, false, false)
	self:addPetList(240, L["Elder Shadowmaw Panther"], BZONE["Stranglethorn Vale"], 42, 43, false, false)
	self:addPetList(242, L["Rabid Crag Coyote"], BZONE["Badlands"], 42, 43, false, false)
	self:addPetList(244, L["Blisterpaw Hyena"], BZONE["Tanaris"], 44, 45, false, false)
	self:addPetList(245, L["Rabid Blisterpaw"], BZONE["Tanaris"], 47, 48, false, false)
	self:addPetList(246, L["Silvermane Stalker"], BZONE["The Hinterlands"], 47, 48, false, false)
	self:addPetList(249, L["Ravage"], BZONE["Blasted Lands"], 51, 51, false, true)
	self:addPetList(250, L["Scarshield Worg"], BZONE["Blackrock Spire"], 53, 54, false, false)
	self:addPetList(251, L["Blackrock Worg"], BZONE["Burning Steppes"], 54, 55, false, false)
	self:addPetList(253, L["Rak'Shiri"], BZONE["Winterspring"], 57, 57, false, true)
	self:addPetList(254, L["Frostsaber Huntress"], BZONE["Winterspring"], 58, 59, false, false)
	self:addPetList(255, L["Frostsaber Stalker"], BZONE["Winterspring"], 59, 60, false, false)
	self:addPetList(256, L["Razorfang Hatchling"], BZONE["Hellfire Peninsula"], 59, 60, false, false)
	self:addPetList(257, L["Zulian Panther"], BZONE["Zul'Gurub"], 60, 60, true, false)
	self:addPetList(258, L["Zulian Stalker"], BZONE["Zul'Gurub"], 61, 61, true, false)
	self:addPetList(259, L["Rip-Blade Ravager"], BZONE["Blade's Edge Mountains"], 63, 63, false, false)
	self:addPetList(261, L["Young Mesa Buzzard"], BZONE["Arathi Highlands"], 31, 32, false, false)
	self:addPetList(263, L["Mesa Buzzard"], BZONE["Arathi Highlands"], 34, 35, false, false)
	self:addPetList(264, L["Wayward Buzzard"], BZONE["Badlands"], 35, 37, false, false)
	self:addPetList(265, L["Dread Flyer"], BZONE["Desolace"], 36, 37, false, false)
	self:addPetList(267, L["Vale Screecher"], BZONE["Feralas"], 41, 43, false, false)
	self:addPetList(268, L["Roc"], BZONE["Tanaris"], 42, 43, false, false)
	self:addPetList(269, L["Fire Roc"], BZONE["Tanaris"], 43, 45, false, false)
	self:addPetList(270, L["Rogue Vale Screecher"], BZONE["Feralas"], 44, 46, false, false)
	self:addPetList(271, L["Greater Firebird"], BZONE["Tanaris"], 46, 46, false, true)
	self:addPetList(272, L["Searing Roc"], BZONE["Tanaris"], 47, 49, false, false)
	self:addPetList(273, L["Ironbeak Owl"], BZONE["Felwood"], 48, 49, false, false)
	self:addPetList(274, L["Arash-ethis"], BZONE["Feralas"], 49, 49, false, true)
	self:addPetList(275, L["Carrion Vulture"], BZONE["Western Plaguelands"], 50, 52, false, false)
	self:addPetList(278, L["Spawn of Hakkar"], BZONE["The Temple of Atal'Hakkar"], 51, 51, false, false)
	self:addPetList(279, L["Ironbeak Screecher"], BZONE["Felwood"], 52, 53, true, false)
	self:addPetList(281, L["Spiteflayer"], BZONE["Blasted Lands"], 52, 52, false, true)
	self:addPetList(284, L["Zaricotl"], BZONE["Badlands"], 55, 55, false, false)
	self:addPetList(286, L["Kaliri Swooper"], BZONE["Hellfire Peninsula"], 60, 60, false, false)
	self:addPetList(287, L["Windroc"], BZONE["Nagrand"], 64, 65, false, false)
	self:addPetList(290, L["Windroc Matriarch"], BZONE["Nagrand"], 66, 66, false, true)
	self:addPetList(292, L["Skettis Kaliri"], BZONE["Terokkar Forest"], 70, 70, false, false)
	self:addPetList(293, L["Feral Dragonhawk Hatchling"], BZONE["Eversong Woods"], 5, 6, false, false)
	self:addPetList(294, L["Crazed Dragonhawk"], BZONE["Eversong Woods"], 7, 8, false, false)
	self:addPetList(295, L["Eclipsion Dragonhawk"], BZONE["Shadowmoon Valley"], 67, 68, false, false)
	self:addPetList(296, L["Bloodfalcon"], BZONE["The Botanica"], 69, 70, true, false)
	self:addPetList(297, L["Phoenix-Hawk Hatchling"], BZONE["Tempest Keep"], 70, 70, true, false)
	self:addPetList(300, L["Mist Howler"], BZONE["Ashenvale"], 22, 22, false, true)
	self:addPetList(304, L["Longtooth Howler"], BZONE["Feralas"], 43, 44, false, false)
	self:addPetList(305, L["Silvermane Howler"], BZONE["The Hinterlands"], 45, 46, false, false)
	self:addPetList(308, L["Silvermane Wolf"], BZONE["The Hinterlands"], 43, 44, false, false)
	self:addPetList(312, L["Timber Worg"], BZONE["Terokkar Forest"], 62, 63, false, false)
	self:addPetList(313, L["Dark Worg"], BZONE["Nagrand"], 64, 65, false, false)
	self:addPetList(314, L["Bloodmaul Dire Wolf"], BZONE["Blade's Edge Mountains"], 65, 65, false, false)
	self:addPetList(315, L["Bloodmaul Battle Worg"], BZONE["Blade's Edge Mountains"], 66, 67, false, false)
	self:addPetList(323, L["Enraged Ravager"], BZONE["Bloodmyst Isle"], 16, 17, false, false)
	self:addPetList(328, L["Quillfang Skitterer"], BZONE["Hellfire Peninsula"], 61, 62, false, false)
	self:addPetList(330, L["Thornfang Ravager"], BZONE["Hellfire Peninsula"], 62, 63, false, false)
	self:addPetList(332, L["Deviate Coiler Hatchling"], BZONE["Wailing Caverns"], 11, 11, true, false)
	self:addPetList(333, L["Deviate Coiler"], BZONE["Wailing Caverns"], 15, 16, true, false)
	self:addPetList(334, L["Deviate Stinglash"], BZONE["Wailing Caverns"], 16, 17, true, false)
	self:addPetList(335, L["Thunderhawk Hatchling"], BZONE["The Barrens"], 18, 20, false, false)
	self:addPetList(336, L["Deviate Dreadfang"], BZONE["Wailing Caverns"], 20, 21, true, false)
	self:addPetList(337, L["Deviate Venomwing"], BZONE["Wailing Caverns"], 20, 21, true, false)
	self:addPetList(338, L["Thunderhawk Cloudscraper"], BZONE["The Barrens"], 20, 22, false, false)
	self:addPetList(339, L["Greater Thunderhawk"], BZONE["The Barrens"], 23, 24, false, false)
	self:addPetList(340, L["Cloud Serpent"], BZONE["Thousand Needles"], 25, 26, false, false)
	self:addPetList(341, L["Washte Pawne"], BZONE["The Barrens"], 25, 25, false, false)
	self:addPetList(342, L["Venomous Cloud Serpent"], BZONE["Thousand Needles"], 26, 28, false, false)
	self:addPetList(343, L["Elder Cloud Serpent"], BZONE["Thousand Needles"], 27, 29, false, false)
	self:addPetList(347, L["Hakkar'i Frostwing"], BZONE["The Temple of Atal'Hakkar"], 49, 50, true, false)
	self:addPetList(348, L["Hakkar'i Sapper"], BZONE["The Temple of Atal'Hakkar"], 49, 50, true, false)
	self:addPetList(350, L["Son of Hakkar"], BZONE["Zul'Gurub"], 60, 60, true, false)
	self:addPetList(351, L["Soulflayer"], BZONE["Zul'Gurub"], 61, 61, true, false)
	self:addPetList(352, L["Felsworn Scalewing"], BZONE["Blade's Edge Mountains"], 66, 67, false, false)
	self:addPetList(353, L["Scalewing Serpent"], BZONE["Blade's Edge Mountains"], 66, 67, false, false)
	self:addPetList(354, L["Cobalt Serpent"], BZONE["Sethekk Halls"], 68, 71, true, false)
	self:addPetList(355, L["Swiftwing Shredder"], BZONE["Netherstorm"], 68, 69, false, false)
	self:addPetList(356, L["Deviate Adder"], BZONE["Wailing Caverns"], 18, 19, true, false)
	self:addPetList(357, L["Deviate Viper"], BZONE["Wailing Caverns"], 19, 20, true, false)
	self:addPetList(358, L["Deviate Moccasin"], BZONE["Wailing Caverns"], 20, 21, true, false)
	self:addPetList(359, L["Murk Slitherer"], BZONE["The Temple of Atal'Hakkar"], 45, 46, true, false)
	self:addPetList(360, L["Sandfury Guardian"], BZONE["The Temple of Atal'Hakkar"], 45, 46, true, false)
	self:addPetList(361, L["Murk Spitter"], BZONE["The Temple of Atal'Hakkar"], 46, 47, true, false)
	self:addPetList(362, L["Razzashi Adder"], BZONE["Zul'Gurub"], 60, 60, true, false)
	self:addPetList(363, L["Razzashi Cobra"], BZONE["Zul'Gurub"], 60, 60, true, false)
	self:addPetList(364, L["Razzashi Serpent"], BZONE["Zul'Gurub"], 60, 60, true, false)
	self:addPetList(365, L["Coilskar Cobra"], BZONE["Shadowmoon Valley"], 68, 68, false, false)
	self:addPetList(366, L["Mountain Lion"], BZONE["Alterac Mountains"], 32, 33, false, false)
	self:addPetList(368, L["Shadowmaw Panther"], BZONE["Stranglethorn Vale"], 37, 38, false, false)
	self:addPetList(369, L["Shadow Panther"], BZONE["Swamp of Sorrows"], 39, 40, false, false)
	self:addPetList(376, L["Corrupted Scorpid"], BZONE["Durotar"], 10, 11, false, false)
	self:addPetList(378, L["Silithid Creeper"], BZONE["The Barrens"], 20, 21, false, false)
	self:addPetList(379, L["Silithid Swarmer"], BZONE["The Barrens"], 21, 22, false, false)
	self:addPetList(382, L["Scorpid Terror"], BZONE["Thousand Needles"], 33, 34, false, false)
	self:addPetList(383, L["Cleft Scorpid"], BZONE["Uldaman"], 35, 36, false, false)
	self:addPetList(385, L["Scorpashi Venomlash"], BZONE["Desolace"], 38, 39, false, false)
	self:addPetList(387, L["Deadly Cleft Scorpid"], BZONE["Uldaman"], 42, 43, false, false)
	self:addPetList(388, L["Scorpid Tail Lasher"], BZONE["Tanaris"], 43, 44, false, false)
	self:addPetList(389, L["Scorpid Duneburrower"], BZONE["Tanaris"], 46, 47, false, false)
	self:addPetList(390, L["Scorpid Dunestalker"], BZONE["Tanaris"], 46, 47, false, false)
	self:addPetList(391, L["Deep Stinger"], BZONE["Blackrock Depths"], 50, 52, false, false)
	self:addPetList(392, L["Venomtip Scorpid"], BZONE["Burning Steppes"], 52, 53, false, false)
	self:addPetList(394, L["Stonelash Scorpid"], BZONE["Silithus"], 54, 55, false, false)
	self:addPetList(395, L["Firetail Scorpid"], BZONE["Burning Steppes"], 56, 57, false, false)
	self:addPetList(396, L["Krellack"], BZONE["Silithus"], 56, 56, false, true)
	self:addPetList(397, L["Stonelash Pincer"], BZONE["Silithus"], 56, 57, false, false)
	self:addPetList(398, L["Stonelash Flayer"], BZONE["Silithus"], 58, 59, false, false)
	self:addPetList(399, L["Scorpok Stinger"], BZONE["Blasted Lands"], 50, 51, false, false)
	self:addPetList(401, L["Scorchshell Pincer"], BZONE["Shadowmoon Valley"], 68, 69, false, false)
	self:addPetList(402, L["Greater Fleshripper"], BZONE["Westfall"], 16, 17, false, false)
	self:addPetList(403, L["Salt Flats Vulture"], BZONE["Thousand Needles"], 32, 34, false, false)
	self:addPetList(405, L["Dread Ripper"], BZONE["Desolace"], 39, 40, false, false)
	self:addPetList(411, L["Kaliri Matriarch"], BZONE["Hellfire Peninsula"], 63, 63, false, false)
	self:addPetList(421, L["Mistvale Gorilla"], BZONE["Stranglethorn Vale"], 32, 33, false, false)
	self:addPetList(422, L["Jungle Thunderer"], BZONE["Stranglethorn Vale"], 37, 38, false, false)
	self:addPetList(423, L["Elder Mistvale Gorilla"], BZONE["Stranglethorn Vale"], 40, 41, false, false)
	self:addPetList(424, L["Groddoc Thunderer"], BZONE["Feralas"], 49, 50, false, false)
	self:addPetList(425, L["Un'Goro Thunderer"], BZONE["Un'Goro Crater"], 52, 53, false, false)
	self:addPetList(426, L["U'cha"], BZONE["Un'Goro Crater"], 55, 55, false, false)
	self:addPetList(427, L["Warp Stalker"], BZONE["Terokkar Forest"], 63, 64, false, false)
	self:addPetList(428, L["Warp Hunter"], BZONE["Terokkar Forest"], 64, 65, false, false)
	self:addPetList(429, L["Warp Chaser"], BZONE["Netherstorm"], 67, 68, false, false)
	self:addPetList(430, L["Blackwind Warp Chaser"], BZONE["Terokkar Forest"], 69, 70, false, false)

	-- Add all possible beast skills
	--self:addTradeSkillBeast(1, 1, addon:CombinePets(1)) --This is my test skill for hunter abilities since my hunter has everything
	--self:addTradeSkillBeast(3, 3, addon:CombinePets(37)) --This is my test skill for hunter abilities since my hunter has everything
	--self:addTradeSkillBeast(4, 4, addon:CombinePets(39)) --This is my test skill for hunter abilities since my hunter has everything
	--self:addTradeSkillBeast(5, 5, addon:CombinePets(94,95,96,97,98)) --This is my test skill for hunter abilities since my hunter has everything
	--self:addTradeSkillBeast(7, 7, addon:CombinePets(423,424,425,426,427,428,429,430)) --This is my test skill for hunter abilities since my hunter has everything
	self:addTradeSkillBeast(24495, 20, L["Trainer"],1)
	self:addTradeSkillBeast(24508, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24509, 40, L["Trainer"],1)
	self:addTradeSkillBeast(24510, 50, L["Trainer"],1)
	self:addTradeSkillBeast(27350, 60, L["Trainer"],1)
	self:addTradeSkillBeast(35699, 30, L["Trainer"],1)
	self:addTradeSkillBeast(35700, 60, L["Trainer"],1)
	self:addTradeSkillBeast(25077, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24440, 20, L["Trainer"],1)
	self:addTradeSkillBeast(24441, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24463, 40, L["Trainer"],1)
	self:addTradeSkillBeast(24464, 50, L["Trainer"],1)
	self:addTradeSkillBeast(27351, 60, L["Trainer"],1)
	self:addTradeSkillBeast(24475, 20, L["Trainer"],1)
	self:addTradeSkillBeast(24476, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24477, 40, L["Trainer"],1)
	self:addTradeSkillBeast(24478, 50, L["Trainer"],1)
	self:addTradeSkillBeast(27352, 60, L["Trainer"],1)
	self:addTradeSkillBeast(4195, 10, L["Trainer"],1)
	self:addTradeSkillBeast(4196, 12, L["Trainer"],1)
	self:addTradeSkillBeast(4197, 18, L["Trainer"],1)
	self:addTradeSkillBeast(4198, 24, L["Trainer"],1)
	self:addTradeSkillBeast(4199, 30, L["Trainer"],1)
	self:addTradeSkillBeast(4200, 36, L["Trainer"],1)
	self:addTradeSkillBeast(4201, 42, L["Trainer"],1)
	self:addTradeSkillBeast(4202, 48, L["Trainer"],1)
	self:addTradeSkillBeast(5048, 54, L["Trainer"],1)
	self:addTradeSkillBeast(5049, 60, L["Trainer"],1)
	self:addTradeSkillBeast(27062, 70, L["Trainer"],1)
	self:addTradeSkillBeast(24547, 10, L["Trainer"],1)
	self:addTradeSkillBeast(24556, 12, L["Trainer"],1)
	self:addTradeSkillBeast(24557, 18, L["Trainer"],1)
	self:addTradeSkillBeast(24558, 24, L["Trainer"],1)
	self:addTradeSkillBeast(24559, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24560, 36, L["Trainer"],1)
	self:addTradeSkillBeast(24561, 42, L["Trainer"],1)
	self:addTradeSkillBeast(24562, 48, L["Trainer"],1)
	self:addTradeSkillBeast(24631, 54, L["Trainer"],1)
	self:addTradeSkillBeast(24632, 60, L["Trainer"],1)
	self:addTradeSkillBeast(27362, 70, L["Trainer"],1)
	self:addTradeSkillBeast(24494, 20, L["Trainer"],1)
	self:addTradeSkillBeast(24511, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24512, 40, L["Trainer"],1)
	self:addTradeSkillBeast(24513, 50, L["Trainer"],1)
	self:addTradeSkillBeast(27354, 60, L["Trainer"],1)
	self:addTradeSkillBeast(24490, 20, L["Trainer"],1)
	self:addTradeSkillBeast(24514, 30, L["Trainer"],1)
	self:addTradeSkillBeast(24515, 40, L["Trainer"],1)
	self:addTradeSkillBeast(24516, 50, L["Trainer"],1)
	self:addTradeSkillBeast(27353, 60, L["Trainer"],1)
	self:addTradeSkillBeast(1853, 10, L["Trainer"],1)
	self:addTradeSkillBeast(14922, 10, L["Trainer"],1)
	self:addTradeSkillBeast(14923, 20, L["Trainer"],1)
	self:addTradeSkillBeast(14924, 30, L["Trainer"],1)
	self:addTradeSkillBeast(14925, 40, L["Trainer"],1)
	self:addTradeSkillBeast(14926, 50, L["Trainer"],1)
	self:addTradeSkillBeast(14927, 60, L["Trainer"],1)
	self:addTradeSkillBeast(27344, 70, L["Trainer"],1)
	self:addTradeSkillBeast(17253, 1, addon:CombinePets(1,2,3,4,5,6,7,8,9,10,11,12))
	self:addTradeSkillBeast(17255, 10, addon:CombinePets(13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28))
	self:addTradeSkillBeast(17256, 16, addon:CombinePets(29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46))
	self:addTradeSkillBeast(17257, 24, addon:CombinePets(47,48,49,50,51,52,53,54,55,56,57,58))
	self:addTradeSkillBeast(17258, 32, addon:CombinePets(59,60,61,62,63,64,65,66,128))
	self:addTradeSkillBeast(17259, 40, addon:CombinePets(67,68,69,70,71,72,73,74,75,76,77,78))
	self:addTradeSkillBeast(17260, 48, addon:CombinePets(79,80,81,82,83,84,85,86,87))
	self:addTradeSkillBeast(17261, 56, addon:CombinePets(88,89,90,91))
	self:addTradeSkillBeast(27050, 64, addon:CombinePets(92,93))
	self:addTradeSkillBeast(16827, 1, addon:CombinePets(94,95,96,97,98))
	self:addTradeSkillBeast(16828, 10, addon:CombinePets(99,100,101,102,103,104,105,106,107,108,109,110))
	self:addTradeSkillBeast(16829, 16, addon:CombinePets(111,31,113,114,115,116,117,118,119,120,121))
	self:addTradeSkillBeast(16830, 24, addon:CombinePets(122,123,124,125))
	self:addTradeSkillBeast(16831, 32, addon:CombinePets(126,127,129))
	self:addTradeSkillBeast(16832, 40, addon:CombinePets(130,131,132,133,134,135))
	self:addTradeSkillBeast(3010, 48, addon:CombinePets(136,137,138,139,140,141,142,143,144,145))
	self:addTradeSkillBeast(3009, 56, addon:CombinePets(146,147,148))
	self:addTradeSkillBeast(27049, 64, addon:CombinePets(150,151,152,153,154,155,156,157))
	self:addTradeSkillBeast(7371, 10, addon:CombinePets(158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176))
	self:addTradeSkillBeast(26177, 12, addon:CombinePets(177,178,179,180,181))
	self:addTradeSkillBeast(26178, 24, addon:CombinePets(182,183,184,185))
	--self:addTradeSkillBeast(26179, 36, L["Charge (Rank 4) Obt"]) -- No charge rank 4 in the game
	self:addTradeSkillBeast(26201, 48, addon:CombinePets(186,187))
	self:addTradeSkillBeast(27685, 60, addon:CombinePets(188))
	self:addTradeSkillBeast(1747, 10, addon:CombinePets(189,190,191,192,193,194,195,196,197,198))
	self:addTradeSkillBeast(1748, 15, addon:CombinePets(199,200,201,202,203,204))
	self:addTradeSkillBeast(1749, 25, addon:CombinePets(205,206,207,208,209,210,211))
	self:addTradeSkillBeast(1750, 35, addon:CombinePets(212,213,214))
	self:addTradeSkillBeast(1751, 45, addon:CombinePets(215,216,217,218))
	self:addTradeSkillBeast(16698, 55, addon:CombinePets(219,220))
	self:addTradeSkillBeast(27346, 65, addon:CombinePets(221,157,223))
	self:addTradeSkillBeast(23100, 30, addon:CombinePets(224,225,226,227,61,229,230,231,232,233,234,235))
	self:addTradeSkillBeast(23111, 40, addon:CombinePets(236,70,238,239,240,73,242,133,244,245,246))
	self:addTradeSkillBeast(23112, 50, addon:CombinePets(187,82,249,250,251,88,253,254,255,256,257,258,259))
	self:addTradeSkillBeast(23145, 30, addon:CombinePets(207,261,210,263,264,265,214))
	self:addTradeSkillBeast(23147, 40, addon:CombinePets(267,268,269,270,271,272,273,274))
	self:addTradeSkillBeast(23148, 50, addon:CombinePets(275,215,138,278,279,140,281,217,144,284,147,286,287,152,154,290,156,292))
	self:addTradeSkillBeast(34889, 1, addon:CombinePets(293,294))
	self:addTradeSkillBeast(35323, 60, addon:CombinePets(295,296,297))
	self:addTradeSkillBeast(24604, 10, addon:CombinePets(23,24,300))
	self:addTradeSkillBeast(24605, 24, addon:CombinePets(50,55,235,304,305))
	self:addTradeSkillBeast(24603, 40, addon:CombinePets(70,74,308,76,78))
	self:addTradeSkillBeast(24597, 56, addon:CombinePets(88,312,313,314,315,93))
	self:addTradeSkillBeast(35290, 1, addon:CombinePets(160,161,163,165,166,169))
	self:addTradeSkillBeast(35291, 8, addon:CombinePets(171,17,174,176,178))
	self:addTradeSkillBeast(35292, 16, addon:CombinePets(180,323,181))
	self:addTradeSkillBeast(35293, 24, addon:CombinePets(183))
	--self:addTradeSkillBeast(35294, 32, L["Gore (Rank 5) Obt"]) -- Not in game
	--self:addTradeSkillBeast(35295, 40, L["Gore (Rank 6) Obt"]) -- Not in game
	self:addTradeSkillBeast(35296, 48, addon:CombinePets(186))
	self:addTradeSkillBeast(35297, 56, addon:CombinePets(188,328,89,330))
	self:addTradeSkillBeast(35298, 63, addon:CombinePets(259))
	self:addTradeSkillBeast(24844, 1, addon:CombinePets(332))
	self:addTradeSkillBeast(25008, 12, addon:CombinePets(333,334,335,336,337,338,339))
	self:addTradeSkillBeast(25009, 24, addon:CombinePets(340,341,342,343))
	self:addTradeSkillBeast(25010, 36, addon:CombinePets(267,270))
	self:addTradeSkillBeast(25011, 48, addon:CombinePets(274,347,348,278))
	self:addTradeSkillBeast(25012, 60, addon:CombinePets(350,351,352,353,354,355))
	self:addTradeSkillBeast(35387, 15, addon:CombinePets(356,357,358))
	self:addTradeSkillBeast(35389, 45, addon:CombinePets(359,360,361))
	self:addTradeSkillBeast(35392, 60, addon:CombinePets(362,363,364,365))	
	self:addTradeSkillBeast(24451, 30, addon:CombinePets(366,212,368,369))
	self:addTradeSkillBeast(24454, 40, addon:CombinePets(238,240))
	self:addTradeSkillBeast(24455, 50, addon:CombinePets(216,255,258))
	self:addTradeSkillBeast(24641, 10, addon:CombinePets(103,376,104,378,379))
	self:addTradeSkillBeast(24584, 24, addon:CombinePets(124,125,382,383,127,385))
	self:addTradeSkillBeast(24588, 40, addon:CombinePets(130,387,388,389,390,391,392,143,394))
	self:addTradeSkillBeast(24589, 56, addon:CombinePets(395,396,397,398))
	self:addTradeSkillBeast(27361, 64, addon:CombinePets(399,150,401))
	self:addTradeSkillBeast(24424, 10, addon:CombinePets(402))
	self:addTradeSkillBeast(24580, 24, addon:CombinePets(403,214,405))
	self:addTradeSkillBeast(24581, 48, addon:CombinePets(273,275, 215))
	self:addTradeSkillBeast(24582, 56, addon:CombinePets(220,147,411))
	self:addTradeSkillBeast(27349, 64, addon:CombinePets(153,290,155))
	self:addTradeSkillBeast(26064, 20, addon:CombinePets(39,43,51,53,58,84))
	self:addTradeSkillBeast(26090, 30, addon:CombinePets(421,422))
	self:addTradeSkillBeast(26187, 40, addon:CombinePets(423,424))
	self:addTradeSkillBeast(26188, 50, addon:CombinePets(425,426))
	--self:addTradeSkillBeast(27063, 60,  "HUNTER") -- Not in game
	self:addTradeSkillBeast(35348, 60, addon:CombinePets(427,428,429,430))

end