﻿--[[
****************************************************************************************

ARLLocals-ruRU.lua

ruRU localization strings for Ackis Recipe List

$Date: 2008-08-25 21:00:42 +0000 (Mon, 25 Aug 2008) $
$Rev: 825 $

Original translated by: 
Currently maintaince by: 

Please make sure you update the ToC file with any translations.

****************************************************************************************
]]--

local L = LibStub("AceLocale-3.0"):NewLocale("Ackis Recipe List", "ruRU", true)
if not L then return end

-- Addon Info
L["Version"] = "Version: "

-- Options Categories
L["About"] = true
L["Display"] = true
L["DISPLAY_OPTIONS"] = "Display Options"
L["DISPLAY_OPTIONS_LONG"] = "Allows you to customize how the GUI behaves."
L["Filter"] = true
L["FILTER_OPTIONS"] = "Filtering Options"
L["FILTER_OPTIONS_LONG"] = "Allows you to customize which recipes are filtered."
L["Reputation"] = true
L["REP_OPTIONS"] = "Reputation Options"
L["REP_OPTIONS_LONG"] = "Allows you to customize which reputations are included in the scan."
L["Binding"] = true
L["BINDING_OPTIONS"] = "Binding Options"
L["BINDING_OPTIONS_LONG"] = "Allows you to customize which types of binding are included in the scan."
L["Crafting"] = true
L["CRAFTING_OPTIONS"] = "Crafting Options"
L["CRAFTING_OPTIONS_LONG"] = "Allows you to customize which types of crafting items are included in the scan."
L["Armour"] = true
L["ARMOUR_OPTIONS"] = "Armour Options"
L["ARMOUR_OPTIONS_LONG"] = "Allows you to customize which armour types are included in the scan."
L["Obtain"] = true
L["OBTAIN_OPTIONS"] = "Obtain Options"
L["OBTAIN_OPTIONS_LONG"] = "Allows you to customize which methods of obtaining a recipe are included in the scan."
L["Sort"] = "Sorting"
L["SORT_OPTIONS"] = "Sorting Options"
L["SORT_OPTIONS_LONG"] = "Allows you to customize the way missing recipes are sorted and displayed."
L["Profile"] = true
L["Scan Recipes"] = true
L["Scans an open tradeskill for missing recipes."] = true
L["Text Dump"] = true
L["Displays all recipes in a comma seperated value format which can be copied and pasted into another client."] = true

-- Display Options
L["Use GUI"] = true
L["GUI_TOGGLE"] = "Toggle the use of the GUI on or off."
L["Include Filtered"] = true
L["FILTERCOUNT_TOGGLE"] = "Include filtered recipes in the count of total recipes."
L["Close GUI"] = true
L["CLOSEGUI_TOGGLE"] = "Close the ARL window when the crafting window is closed."

-- Filtering Options
L["Faction"] = true
L["FACTION_TOGGLE"] = "Both horde and alliance faction recipes should be included in the scan."
L["Classes"] = true
L["CLASS_TOGGLE"] = "Class specific recipes should be included in the scan."
L["Specialities"] = true
L["SPECIALITY_TOGGLE"] = "All trade-skill specialities should be included in the scan."
L["Skill"] = true
L["SKILL_TOGGLE"] = "Include all recipes regardless of your current skill level."
L["Old World"] = true
L["OLDWORLD_OPTIONS"] = "Original WoW Reputations"
L["OLDWORLD_OPTIONS_LONG"] = "Allows you to customize which Original WoW reputations should be included in the scan."
L["Burning Crusade"] = true
L["BC_OPTIONS"] = "Burning Crusade Reputations"
L["BC_OPTIONS_LONG"] = "Allows you to customize which Burning Crusade reputations should be included in the scan."
L["Wrath of the Lich King"]= true
L["WOTLK_OPTIONS"] = "Wrath of the Lich King Reputations"
L["WOTLK_OPTIONS_LONG"] = "Allows you to customize which Wrath of the Lich King reputations should be included in the scan."

-- Obtain Filter Options
L["BOEFilter"] = "Item Bind on Equip"
L["BOE_TOGGLE"] = "Recipes that make Bind on Equip items should be included in the scan."
L["BOPFilter"] = "Item Bind on Pickup"
L["BOP_TOGGLE"] = "Recipes that make Bind on Pickup items should be included in the scan."
L["RecipeBOEFilter"] = "Recipe Bind on Equip"
L["RECIPE_BOE_TOGGLE"] = "Recipes that are Bind on Equip should be included in the scan."
L["RecipeBOPFilter"] = "Recipe Bind on Pickup"
L["RECIPE_BOP_TOGGLE"] = "Recipes that are Bind on Pickup should be included in the scan."
L["PVP_TOGGLE"] = "PVP obtained recipes should be included in the scan."
L["RAID_TOGGLE"] = "Hard to get raid (ie: Molten Core, Serpent Shrine Cavern, etc.) recipes should be included in the scan."
L["SEASONAL_TOGGLE"] = "Seasonal obtained recipes should be included in the scan."
L["TRAINER_TOGGLE"] = "Trainer learned recipes should be included in the scan."
L["VENDOR_TOGGLE"] = "Vendor bought recipes should be included in the scan."
L["INSTANCE_TOGGLE"] = "Recipes which are obtained from instances should be included in the scan."
L["QUEST_TOGGLE"] = "Quest reward recipes should be included in the scan."
L["Cloth"] = true
L["CLOTH_TOGGLE"] = "Patterns that make cloth items should be included in the scan."
L["Leather"] = true
L["LEATHER_TOGGLE"] = "Patterns that make leather items should be included in the scan."
L["Mail"] = true
L["MAIL_TOGGLE"] = "Patterns that make mail items should be included in the scan."
L["Plate"] = true
L["PLATE_TOGGLE"] = "Patterns that make plate items should be included in the scan."
L["Melee"] = true
L["MELEE_TOGGLE"] = "Patterns that are used for melee/physical dps should be included in the scan."
L["Caster DPS"] = true
L["CASTERDPS_TOGGLE"] = "Patterns that are used for caster dps should be included in the scan."
L["Tanking"] = true
L["TANKING_TOGGLE"] = "Patterns that are used for tanking should be included in the scan."
L["Healing"] = true
L["HEALING_TOGGLE"] = "Patterns that are used for healing should be included in the scan."
L["World Drop"] = true
L["WORLD_DROP_TOGGLE"] = "Patterns that are World Drops should be included in the scan."

-- Sorting options
L["Name"] = true
L["Skill"] = true
L["Acquisition"] = true

-- Reputation Toggles
L["SPECIFIC_REP_TOGGLE"] = "Include %s faction."

-- Non-gui text
L["MissingFromDB"] = ": is is missing from the database. \nPlease inform the author of the add-on about this recipe."
L["MissingRecipePrefix"] = "Missing Recipe: "
L["InitiateScan"] = "Scanning %s for missing recipes at skill level %s.\n"
L["InitiateScanSpecial"] = "Scanning %s - %s for missing recipes at skill level %s.\n"
L["RecipeListSummary"] = "\nYou know %s out of %s total recipes (%s%%).\nYou are missing %s recipes."
L["UnknownTradeSkill"] = "You have opened up a trade skill window which is not supported by this add-on.  The trade skill is %s.  Please provide the author of the add-on with this information."
L["OpenTradeSkillWindow"] = "Please open trade skill window to scan."
L["TwoCraftingWindows"] = "Crafting window already open.  Please close the other window and re-open this one if you wish to scan for missing recipes."
L["SpellIDCache"] = "Spell ID: %s is not in your local cache.  Please submit a ticket at http://wow.curseforge.com/projects/ackis-recipe-list/tickets/ and include the spell ID and the profession in which you were scanning."
L["FactionError"] = "Warning: Reputation level of %s is unknown."
L["MissingFromDBWarning"] = "A recipe not in the database has been detected.  Tere may be some lag while we scan for the missing recipe spell ID."

-- GUI Text
L["Close"] = true
L["ScanButton"] = "Scan Skills"
L["Scan Skills"] = true
L["FILTER_OPEN"] = "Filter >>>"
L["FILTER_CLOSE"] = "<<< Filter"
L["Reset"] = true
L["Sort"] = true
L["World Drop"] = true
L["Mob Drop"] = true
L["Quest"] = true
L["Reputation"] = true
L["Instance"] = true
L["BoPMenu"] = "BoP"
L["Horde"] = true 
L["Alliance"] = true
L["Known"] = true
L["Unknown"] = true

-- More stuff for new gui, ZJ 7/26/08
L["General"] = true
L["Class Specific recipes"] = true
L["Craft Specialty recipes"] = true
L["All Skill Levels"] = true
L["Item Type"] = true
L["Armor"] = true
L["Weapon"] = true
L["Player Type"] = true
L["Tank"] = true
L["Healer"] = true
L["Melee DPS"] = true
L["All"] = true
L["None"] = true
L["Dagger"] = true
L["1H"] = true
L["2H"] = true
L["Axe"] = true
L["Mace"] = true
L["Sword"] = true
L["Polearm"] = true
L["Thrown"] = true
L["Ammo"] = true
-- unused, but included anyway. Who knows what the future may bring
L["Bow"] = true
L["Crossbow"] = true
L["Staff"] = true
-- More stuff for new GUI, ZJ 8/11/08
L["Search"] = true
L["SEARCH_TT"] = "Filter to recipes that contain text at left"
L["Apply"] = true
L["Apply_TT"] = "Apply the above selected filters to the recipe list"
L["ExpandAll"] = "+ All"
L["EXPAND_TT"] = "Expand all recipes listed below"
L["ContractAll"] = "- All"
L["CONTRACT_TT"] = "Minimize all recipes listed below"
L["Clear"] = "(X)"
L["CLEAR_TT"] = "Clear the search textbox"

-- Tooltip Text
L["Scan Skills Long"] = "Scan for missing recipes using Ackis Recipe List."
L["Close Window"] = "Close the Ackis Recipe List Window."
L["Expand All"] = "Expands all recipes."
L["Collapse All"] = "Collapses all recipes."
L["FILTER_OPEN_TT"] = "Open filter option panel."
L["FILTER_CLOSE_TT"] = "Close filter option panel."
L["RESET_TT"] = "Reset the search string."
L["SORT_TT"] = "Change the sort order for the list."
L["VENDOR_TT"] = "Check to include Vendor recipes in the list."
L["TRAINER_TT"]= "Check to include Trained recipes in the list."
L["WORLD_TT"] = "Check to include World Drop recipes in the list."
L["MOB_TT"] = "Check to include specific Mob Drop recipes in the list."
L["QUEST_TT"] = "Check to include Quest reward recipes in the list."
L["SEASON_TT"] = "Check to includes Seasonal recipes in the list."
L["REP_TT"] = "Check to include Reputation reward recipes in the list."
L["INSTANCE_TT"] = "Check in include recipes only found in instances in the list."
L["BOP_TT"] = "Check to only view Bind on Pickup recipes in the list."
L["HORDE_TT"] = "Check to include Horde only recipes in the list."
L["ALLIANCE_TT"] = "Check to include Alliance only recipes in the list."
L["KNOWN_TT"] = "Check to include known recipes in the list."
L["UNKNOWN_TT"] = "Check to include unknwon recipes in the list."
L["DISCOVERY_TT"] = "Check to include discovered recipes in the list."
L["ARMOR_TT"] = "Check to include Armor recipes in the list."
L["WEAPON_TT"] = "Check to include Weapon recipes in the list."

-- Recipe Database
L["Trainer"] = true
L["LimitedSupply"] = "Limited Supply Vendor"
L["Vendor"] = true
L["Discovery"] = true
L["PVP"] = true
L["Raid"] = true

--Skillup Levels
L["Journeyman"] = true
L["Expert"] = true
L["Artisan"] = true
L["Master"] = true

-- Common ways to obtain recipes
L["UZD"] = "Uncommon Zone Drop: "
L["CWD"] = "Common World Drop"
L["UWD"] = "Uncommon World Drop"
L["RWD"] = "Rare World Drop"
L["EWD"] = "Epic World Drop"
L["BoE"] = "Bind on Equip Drop: "
L["BoP"] = "Bind on Pickup Drop: "
L["QuestReward"] = "Quest Reward: "

-- Common quests/drops
L["DMCACHE"] = "Knot Thimblejack's Cache"
L["Gordok Ogre Suit"] = true
L["Gordok Ogre Suit Obt"] = "The Gordok Ogre Suit"
L["Spectral Essence Obt"] = "Kirtonos the Herald (allows you to see the vendor Magnus Frostwake near Scholomance)"
L["TrueBelieverQuest"] = "True Believers - Rare"

-- Raid Drop Obtain Info
L["ADNaxx"] = "Trainer: Master Craftsman Omarion in the Deathknight Wing of Naxxramas."
L["MOLTENCORE"] = "Raid Bind on Pickup Drop: Random bosses in MC."
L["AQ20/AQ40"] = "Raid BoP Mob Drop: Random bosses in AQ20/AQ40."
L["SSC/TKBoP"] = "Raid Bind on Pickup Drop: Random bosses and mobs in SSC/TK."
L["SSC/TKBoE"] = "Raid Bind on Equip Drop: Random bosses and mobs in SSC/TK."
L["BT/HYJALBoP"] = "Raid Bind on Pickup Drop: Random bosses and mobs in Hyjal/BT."
L["HYJALBoP"] = "Raid Bind on Pickup Drop: Random bosses in Hyjal."
L["SunwellBoP"] = "Raid Bind on Pickup Drop: Random bosses and mobs in Sunwell."
L["SunwellBoE"] = "Raid Bind on Equip Drop: Random bosses and mobs in Sunwell."
L["BT/HYJALBoE"] = "Raid Bind on Equip Drop: Random bosses and mobs in Hyjal/BT."
L["ZA"] = "Raid Bind on Pickup Drop: Random bosses in Zul'Aman."
L["Unknown"] = "Unknown Drop: The drop location of this recipe is unknown.  Please contribute by posting on the Ackis Recipe List thread at www.wowace.com/forums"

-- Faction info
L["WintersVeil"] = "Seasonal: Feast of Winters Veil"
L["Lunar Festival"] = "Seasonal: Lunar Festival"
L["Darkmoon Faire"] = true
L["Seasonal"] = true

-- Alchemy Obtain Information
L["Discovery - Flasks/Potions"] = "Discovery: Discovered by creating flasks, elixirs or potions containing Outland herbs."
L["Discovery - Protection Potions"] = "Discovery: Discovered by creating major protection potions."
L["Discovery - Transmutes"] = "Discovery: Discovered by transmuting items that contain Outland materials."
L["Goblin Rocket Fuel Obt"] = "Crafted: This recipe is crafted by Goblin Engineers"
L["Gurubashi Mojo Madness Obt"] = "Raid: You can learn this by clicking on a stone table in Zul'Gurub in the Edge of Madness"
L["Mighty Trolls Blood Potion Obt"] = "Trainer: Henry Stern, "
-- Mob Drop
L["Elixir of Greater Firepower Obt"] = "Dark Iron Slaver, Dark Iron Watchman, Dark Iron Taskmaster"
L["Elixir of the Mongoose Obt"] = "Jadefire Rogue, Legashi Rogue"
L["Elixir of the Sages Obt"] = "Scarlet Enchanter, Scarlet Cleric, Scarlet Curate, Scarlet Archmage, Scarlet Inquisitor"
L["Fel Mana Potion Obt"] = "Eclipsion Soldier, Eclipsion Bloodward, Eclipsion Blood Knight, Eclipsion Spellbinder, Eclipsion Archmage, Eclipsion Centurion, Eclipsion Cavalier, Torloth the Magnificent, Illidari Watcher"
L["Fel Regeneration Potion Obt"] = "Deathforge Imp, Deathforge Guardian, Deathforge Smith, Deathforge Tinkerer"
L["Fel Strength Elixir Obt"] = "Mo'arg Weaponsmiths, Terrormasters, Wrathwalkers, Shadow Council Warlocks"
L["Gift of Arthas Obt"] = "Skeletal Flayer, Slavering Ghoul"
L["Greater Arcane Protection Potion Obt"] = "Cobalt Mageweavers"
L["Greater Fire Protection Potion Obt"] = "Firebrand Invoker, Firebrand Pyromancer"
L["Greater Frost Protection Potion Obt"] = "Frostmaul Giants"
L["Greater Nature Protection Potion Obt"] = "Decaying Horror, Rotting Behemoths"
L["Greater Shadow Protection Potion Obt"] = "Dark Adepts, Shadowmages"
L["Major Arcane Protection Potion Obt"] = "Vir'aani Arcanists"
L["Major Fire Protection Potion Obt"] = "Sunseeker Astromages"
L["Major Holy Protection Potion Obt"] = "Abyssal Flamebringers"
L["Major Shadow Protection Potion Obt"] = "Shadow Council Warlock"
L["Mighty Rage Potion Obt"] = "Blackrock Slayer"
L["Wildvine Potion Obt"] = "Random Trolls"
-- Quest
L["Discolored Healing Potion Obt"] = "Wild Hearts"
L["Elixir of Brute Force Obt"] = "Dadanga is Hungry (Random reward)"
L["Lesser Stoneshield Potion Obt"] = "Liquid Stone"
L["Restorative Potion Obt"] = "Badlands Reagent Run II"

-- Blacksmithin Obtain Information
L["Inlaid Mithril Cylinder Obt"] = "Crafted: This recipe is crafted by Gnomish Engineers"
L["Blacksmithing Plans"] = "Randomly drops from blacksmithing plans"
-- Mob Drop
L["Dark Iron Sunderer Obt"] = "Hammered Patrons, Ribbly's Crony"
L["Felsteel Gloves Obt"] = "Auchenai Monks"
L["Felsteel Helm Obt"] = "Cabal Fanatic"
L["Felsteel Leggings Obt"] = "Unchained Doombringer"
L["Frostguard Obt"] = "Foreman Marcrid"
L["Greater Ward of Shielding Obt"] = "Sunfury Bloodwatchers"
L["Khorium Belt Obt"] = "Murkblood Raiders"
L["Khorium Boots Obt"] = "Disembodied Protector"
L["Khorium Pants Obt"] = "Deathforge Guardians"
L["Ragesteel Breastplate Obt"] = "Ashtongue Warrior"
L["Ragesteel Gloves Obt"] = "Boulderfist Warrior"
L["Ragesteel Helm Obt"] = "Anger Guards"
L["Ragesteel Shoulders Obt"] = "Enraged Earth Spirit, Enraged Air Spirirt, Enraged Fire Spirirt, Enraged Water Spirirt"
L["Runic Breastplate Obt"] = "Strashaz Myrmidons"
L["Runic Plate Boots Obt"] = "Scarlet Cavaliers"
L["Runic Plate Helm Obt"] = "Strashaz Warriors"
L["Runic Plate Leggings Obt"] = "Scarlet Smiths"
L["Runic Plate Shoulders Obt"] = "Strashaz Serpent Guards"
L["Swiftsteel Gloves Obt"] = "Nexus Stalkers"
L["Volcanic Hammer Obt"] = "Volchan"
-- Quest
L["Barbaric Iron Boots Obt"] = "Trampled Under Foot"
L["Barbaric Iron Breastplate Obt"] = "Barbaric Battlements"
L["Barbaric Iron Gloves Obt"] = "Joys of Omosh"
L["Barbaric Iron Helm Obt"] = "Horns of Frenzy"
L["Barbaric Iron Shoulders Obt"] = "On Iron Pauldroms"
L["Blazing Rapier Obt"] = "Corruption"
L["Dawn's Edge Obt"] = "Snakestone of the Shadow Huntress"
L["Demon Forged Breastplate Obt"] = "The Demon Forge"
L["Enchanted Battlehammer Obt"] = "Sweet Serenity"
L["Enchanted Thorium Breastplate Obt"] = "Enchanted Thorium Platemail Vol I (Requires drops from other instances to get the quest)"
L["Enchanted Thorium Helm Obt"] = "Enchanted Thorium Platemail Vol III (Requires drops from other instances to get the quest)"
L["Enchanted Thorium Leggings Obt"] = "Enchanted Thorium Platemail Vol II (Requires drops from other instances to get the quest)"
L["Fiery Plate Gauntlets Obt"] = "Fiery Plate Gauntlets"
L["Golden Scale Gauntlets Obt"] = "The Origins of Smithing"
L["Heavy Copper Longsword Obt"] = "Supplying the Front"
L["Imperial Plate Belt Obt"] = "Imperial Plate Belt"
L["Imperial Plate Boots Obt"] = "Imperial Plate Boots"
L["Imperial Plate Bracers Obt"] = "Imperial Plate Bracers"
L["Imperial Plate Chest Obt"] = "Imperial Plate Chest"
L["Imperial Plate Helm Obt"] = "Imperial Plate Helm"
L["Imperial Plate Leggings Obt"] = "Imperial Plate Leggings"
L["Imperial Plate Shoulders Obt"] = "Imperial Plate Shoulders"
L["Ironforge Breastplate Obt"] = "Gearing Redridge"
L["Orcish War Leggings Obt"] = "The Old Ways"
L["Ornate Mithril Gloves Obt"] = "The Great Silver Deceiver"
L["Ornate Mithril Helm Obt"] = "A Good Head on Your Shoulders"
L["Ornate Mithril Pants Obt"] = "Smelt On, Smelt Off"
L["Ornate Mithril Shoulder Obt"] = "The Art of the Imbue"
L["Sulfuron Hammer Obt"] = "A Binding Contract"

-- Cooking Obtain Information
L["Fishing Daily"] = "Quest Reward: Random reward from the fishing daily quest."
L["Cooking Daily"] = "Quest Reward: Random reward from the cooking daily quest."
L["Goldthorn Tea Obt"] = "Talk to Henry Stern in RFD"
L["Stewed Trout Obt"] = "Trainer: Kylene"
-- Mob Drop
L["Runn Tum Tuber Surprise Obt"] = "Pusillin"
-- Quest
L["Barbecued Buzzard Wing Obt"] = "Barbecued Buzzard Wings"
L["Beer Basted Boar Ribs Obt"] = "Beer Basted Boar Ribs"
L["Big Bear Steak Obt"] = "The Rescue"
L["Blood Sausage Obt"] = "Thelsamar Blood Sausages"
L["Buzzard Bites Obt"] = "Smooth as Butter"
L["Crocolisk Gumbo Obt"] = "Apprentice's Duties"
L["Crocolisk Steak Obt"] = "Crocolisk Hunting"
L["Crunchy Serpent Obt"] = "Mok'Nathal Treats"
L["Crunchy Spider Surprise Obt"] = "Culinary Crunch"
L["Curiously Tasty Omelet Obt"] = "Ormer's Revenge"
L["Dig Rat Stew Obt"] = "Dig Rat Stew"
L["Dirge's Kickin' Chimaerok Chops Obt"] = "Dirge's Kickin' Chimaerok Chops"
L["Gooey Spider Cake Obt"] = "Dusky Crab Cakes"
L["Goretusk Liver Pie Obt"] = "Goretusk Liver Pie"
L["Hot Lion Chops Obt"] = "Elixir of Pain"
L["Kaldorei Spider Kabob Obt"] = "Recipe of the Kaldorei"
L["Murloc Fin Soup Obt"] = "Selling Fish"
L["Redridge Goulash Obt"] = "Redridge Goulash"
L["Roasted Moongraze Tenderloin Obt"] = "The Great Moongraze Hunt"
L["Seasoned Wolf Kabob Obt"] = "Seasoned Wolf Kabobs"
L["Smoked Desert Dumplings Obt"] = "Desert Recipe"
L["Soothing Turtle Bisque Obt"] = "Soothing Turtle Bisque"
L["Strider Stew Obt"] = "Easy Strider Living"
L["Tasty Lion Steak Obt"] = "Costly Menace"
L["Thistle Tea Ally Obt"] = "Klaven's Tower"
L["Thistle Tea Horde Obt"] = "Mission: Possible But Not Probable"
L["Westfall Stew Obt"] = "Westfall Stew"

-- Enchanting Obtain Information
L["Enchant 2H Weapon - Major Agility Obt"] = "Eredar Deathbringer"
L["Enchant 2H Weapon - Major Intellect Obt"] = "Crimson Sorcerer"
L["Enchant 2H Weapon - Major Spirit Obt"] = "Scholomance Adept"
L["Enchant 2H Weapon - Savagery Obt"] = "Shattered Hand Centurions"
L["Enchant 2H Weapon - Superior Impact Obt"] = "Blackhand Elite"
L["Enchant Boots - Dexterity Obt"] = "Raging Skeletons"
L["Enchant Boots - Fortitude Obt"] = "Ethereal Priest"
L["Enchant Boots - Surefooted Obt"] = "Phantom Stagehand"
L["Enchant Bracer - Fortitude Obt"] = "Coilfang Oracles"
L["Enchant Bracer - Major Defense Obt"] = "Ethereum Nullifier"
L["Enchant Bracer - Spellpower Obt"] = "Bloodmaul Geomancers"
L["Enchant Bracer - Superior Strength Obt"] = "Deadwind Warlock"
L["Enchant Cloak - Greater Arcane Resistance Obt"] = "Eclipsion Archmages"
L["Enchant Cloak - Greater Shadow Resistance Obt"] = "Voidshriekers"
L["Enchant Cloak - Lesser Agility Obt"] = "Syndicate Assassin"
L["Enchant Cloak - Lesser Agility Obt1"] = "Wastewander Assassin, Wastewander Scofflaw"
L["Enchant Gloves - Advanced Herbalism Obt"] = "Mire Lord, Molt Thorn, Swampwalker, Swampwalker Elder, Tangled Horror"
L["Enchant Gloves - Advanced Mining Obt"] = "Venture Co. Strip Miner"
L["Enchant Gloves - Fishing Obt"] = "Scargil, Torn Fin Coastrunner, Torn Fin Oracle, Torn Fin Muckdweller, Torn Fin Tidehunter"
L["Enchant Gloves - Herbalism Obt"] = "Crazed Ancient, Withered Ancient"
L["Enchant Gloves - Herbalism Obt1"] = "Vengeful Ancient, Blackened Ancient, Charred Ancient"
L["Enchant Gloves - Mining Obt"] = "Dark Iron Dwarf, Dark Iron Demonlitionist, Dark Iron Tunneler, Dark Iron Saboteur, Balgaras the Foul"
L["Enchant Gloves - Skinning Obt"] = "Nimar the Slayer, Witherbark Berserker, Witherbark Headhunter, Witherbark Shadow Hunter"
L["Enchant Weapon - Crusader Obt"] = "Scarlet Spellbinder"
L["Enchant Weapon - Crusader Obt1"] = "Scarlet Archmage"
L["Enchant Weapon - Deathfrost Obt"] = "Lord Ahune - Midsummer Fire Festival"
L["Enchant Weapon - Fiery Weapon Obt"] = "Pyromancer Loregrain"
L["Enchant Weapon - Icy Chill Obt"] = "Anguished Highborne"
L["Enchant Weapon - Lifestealing Obt"] = "Spectral Researcher"
L["Enchant Weapon - Major Intellect Obt"] = "Sunfury Researchers"
L["Enchant Weapon - Major Spellpower Obt"] = "Bash'ir Spell-Thief"
L["Enchant Weapon - Superior Striking Obt"] = "Spirestone Warlord"
L["Enchant Weapon - Unholy Weapon Obt"] = "Thuzadin Shadowcaster"
L["Smoking Heart of the Mountain Obt"] = "Lord Roccor"

-- Engineering Obtain Information
L["ENG_MEMBERSHIP_BENEFITS"] = "Random Quest Reward: Renewing Membership"
L["Field Repair Bot 74A Obt"] = " Clickable scroll near the boss."
L["Minor Recombobulator Obt"] = "Use White Punch Card in slot Matrix Punchograph 3005-A.  Next, use Yellow Punch Card in Matrix Punchograph 3005-B."
L["Discombobulator Ray Obt"] = "Use Security DELTA Data Access Card on the D machine."
-- Mob Drop
L["Adamantite Arrow Maker Obt"] = "Sunfury Archer"
L["Arcanite Dragonling Obt"] = "Cobalt Mageweaver"
L["Dark Iron Rifle Obt"] = "Doomforge Craftsman"
L["Felsteel Boomstick Obt"] = "Doomforge Engineer"
L["Field Repair Bot 110G Obt"] = "Gan'Arg Analyzers"
L["Flawless Arcanite Rifle Obt"] = "Mossflayer Shadowhunter"
L["Hyper-Vision Goggles Obt"] = "Mo'arg Weaponsmiths"
L["Khorium Scope Obt"] = "Sunfury Bowman"
L["Major Recombobulator Obt"] = " Tribute Run Chest"
L["Weapon Technician"] = true
L["Crimson Inquisitor"] = true
-- Quest
L["Flash Bomb Obt"] = "Flash Bomb Recipe"
L["Steam Tonk Controller Obt"] = "40 Tickets - Schematic: Steam Tonk Controller"
L["Zapthrottle Mote Extractor Obt"] = "Zapthrottle Mote Extractor!"

-- First Aid Obtain Information
-- Nothing here needed yet

-- Jewelcrafting Obtain Information
L["Blades Edge Summon Bosses"] = "Ogri'la summon bosses"
-- Mob Drop
L["Arcane Khorium Band Obt"] = "Mageslayers"
L["Chaotic Skyfire Diamond Obt"] = "Coilskar Sirens"
L["Coronet of the Verdant Flame Obt"] = "Sunseeker Botanists"
L["Khorium Band of Frost Obt"] = "Coilfang Sorceresses"
L["Khorium Band of Leaves Obt"] = "Vekh'nir Dreadhawks"
L["Khorium Band of Shadows Obt"] = "Dark Conclave Shadowmancers"
-- Quest

-- Leatheworking Obtain Information
-- Mob Drop
L["Bag of Many Hides Obt"] = "Gordunni Back-Breaker, Gordunni Head-Splitter, Gordunni Elementalist, Gordunni Soulreaper"
L["Anvilrage Captain"] = "Anvilrage Captain"
L["Blue Dragonscale Shoulders Obt"] = "Cliff Breaker"
L["Devilsaur Leggings Obt"] = "Cloned Ooze, Muculent Ooze"
L["Flame Armor Kit Obt"] = "Gargantuan Abyssals"
L["Frostsaber Gloves Obt"] = "Winterfall Totemic"
L["Frostsaber Leggings Obt"] = "Winterfall Den Watcher"
L["Frostsaber Tunic Obt"] = "Winterfall Ursa"
L["Green Dragonscale Leggings Obt"] = "Murk Worm"
L["Heavy Scorpid Leggings Obt"] = "Blackrock Slayer"
L["Heavy Scorpid Shoulders Obt"] = "Blackrock Battlemaster"
L["Heavy Scorpid Vest Obt"] = "Portal Seeker"
L["Ironfeather Breastplate Obt"] = "Vilebranch Hideskinner"
L["Living Breastplate Obt"] = "Decaying Horror"
L["Living Leggings Obt"] = "Deadwood Shaman"
L["Shadow Armor Kit Obt"] = "Time-Lost Shadowmages"
L["Stormshroud Armor Obt"] = "Arkkoran Oracle"
L["Stormshroud Gloves Obt"] = "The Windreaver"
L["Stormshroud Gloves Obt1"] = "Princess Tempestria, Winterspring"
L["Stormshroud Shoulders Obt"] = "Son of Arkkoroc"
L["Stylin' Adventure Hat Obt"] = "Durnholde Riflemen"
L["Stylin' Crimson Hat Obt"] = "Sethekk Ravenguard"
L["Stylin' Jungle Hat Obt"] = "Rift Lords, Rift Keepers"
L["Tough Scorpid Boots Obt"] = "Wastewander Rogue"
L["Tough Scorpid Bracers Obt"] = "Wastewander Shadow Mage"
L["Tough Scorpid Breastplate Obt"] = "Wastewander Bandit"
L["Tough Scorpid Gloves Obt"] = "Wastewander Thief"
L["Tough Scorpid Helm Obt"] = "Andre Firebeard, Wastewander Scofflaw"
L["Tough Scorpid Leggings Obt"] = "Wastewander Rogue"
L["Volcanic Breastplate Obt"] = "Firebrand Grunt"
L["Volcanic Leggings Obt"] = "Firegut Brute"
L["Volcanic Shoulders Obt"] = "Firebrand Legionnaire"
-- Quest
L["Deviate Scale Belt Obt"] = "Deviate Eradication"
L["Kodo Hide Bag Obt"] = "Kodo Hide Bag"
L["Moonglow Vest Obt"] = "Moonglow Vest"
L["Onyxia Scale Cloak Obt"] = "The Journey Has Just Begun after turning in Head of Onyxia"
L["Wild Leather Boots Obt"] = "Wild Leather Boots"
L["Wild Leather Cloak Obt"] = "Master of the Wild Leather"
L["Wild Leather Helmet Obt"] = "Wild Leather Helmet"
L["Wild Leather Leggings Obt"] = "Wild Leather Leggings"
L["Wild Leather Shoulders Obt"] = "Wild Leather Shoulders"
L["Wild Leather Vest Obt"] = "Wild Leather Vest"

-- Smelting Obtain Information
L["Dark Iron Obt"] = "Requires 20 Gold Bars, 2 Star Rubies, and 10 Truesilver Bars - Talk to Gloom'Rel, who is one of the undead in the Summoner's Tomb."
L["Elementium Obt"] = "Mind control Krixix in BWL.  On the pet bar there will be an option to train this ability for yourself and others."

-- Rogue Poison Obtain Information
-- Nothing here needed yet

-- Tailoring Obtain Information
L["Arcanoweave Boots Obt"] = "Sunseeker Astromages"
L["Arcanoweave Bracers Obt"] = "Arcatraz Sentinels"
L["Black Silk Pack Obt"] = "Syndicate Spy"
L["Black Silk Pack Obt1"] = "Theramore Infiltrator"
L["Black Silk Pack Obt2"] = "Shadowy Assassin"
L["Cindercloth Cloak Obt"] = "Thaurissan Firewalker"
L["Cindercloth Gloves Obt"] = "Twilight Fire Guard"
L["Cindercloth Pants Obt"] = "Thaurissan Firewalker"
L["Cindercloth Vest Obt"] = "Twilight Fire Guard"
L["Cloak of Fire Obt"] = "Overmaster Pyron"
L["Felcloth Bag Obt"] = "Book that spawns after killing Jandice Barov"
L["Ghostweave Belt Obt"] = "Lingering Highborne"
L["Ghostweave Gloves Obt"] = "Lingering Highborne"
L["Ghostweave Gloves Obt1"] = "Unseen Servant"
L["Ghostweave Vest Obt"] = "Unseen Servant"
L["Mooncloth Boots Obt"] = "Sacred Cloth"
L["Robe of the Archmage Obt"] = "Firebrand Pyromancer"
L["Robe of Winter Night Obt"] = "Cobalt Mageweaver"
L["Robes of Arcana Obt"] = "Dark Strand Voidcaller"
L["Robes of Arcana Obt1"] = "Defias Enchanter"
L["Shadoweave Mask Obt"] = "The Undermarket"
L["Soulcloth Shoulders Obt"] = "Phantom Attendants"
L["Soulcloth Vest Obt"] = "Phantom Valet"
L["Wizardweave Leggings Obt"] = "Dark Summoner"

-- Beast Training Obtain Information
L["Rare"] = true
L["Elite"] = true
-- Beasts which have training skills
L["Agam'ar"] = true
L["Aku'mai Fisher"] = true
L["Aku'mai Snapjaw"] = true
L["Angerclaw Mauler"] = true
L["Arash-ethis"] = true
L["Ashenvale Bear"] = true
L["Ashmane Boar"] = true
L["Barbed Crustacean"] = true
L["Barnabus"] = true
L["Battleboar"] = true
L["Bellygrub"] = true
L["Besseleth"] = true
L["Bhag'thera"] = true
L["Bjarn"] = true
L["Black Bear Patriarch"] = true
L["Black Ravager Mastiff"] = true
L["Black Ravager"] = true
L["Blackrock Worg"] = true
L["Blackwind Warp Chaser"] = true
L["Blisterpaw Hyena"] = true
L["Bloodaxe Worg"] = true
L["Bloodfalcon"] = true
L["Bloodmaul Battle Worg"] = true
L["Bloodmaul Dire Wolf"] = true
L["Bloodsnout Worg"] = true
L["Bonepaw Hyena"] = true
L["Bristleback Battleboar"] = true
L["Broken Tooth"] = true
L["Carrion Vulture"] = true
L["Cave Creeper"] = true
L["Chatter"] = true
L["Clack the Reaver"] = true
L["Clattering Crawler"] = true
L["Cleft Scorpid"] = true
L["Cloud Serpent"] = true
L["Cobalt Serpent"] = true
L["Coilskar Cobra"] = true
L["Corrupted Mottled Boar"] = true
L["Corrupted Scorpid"] = true
L["Coyote Packleader"] = true
L["Coyote"] = true
L["Crag Boar"] = true
L["Crag Coyote"] = true
L["Crag Stalker"] = true
L["Crazed Dragonhawk"] = true
L["Creepthess"] = true
L["Dark Screecher"] = true
L["Dark Worg"] = true
L["Darkfang Creeper"] = true
L["Deadly Cleft Scorpid"] = true
L["Deadmire"] = true
L["Death Flayer"] = true
L["Death Howl"] = true
L["Deathlash Scorpid"] = true
L["Deathstrike Tarantula"] = true
L["Deep Stinger"] = true
L["Deepmoss Creeper"] = true
L["Deepmoss Webspinner"] = true
L["Den Mother"] = true
L["Deviate Adder"] = true
L["Deviate Coiler Hatchling"] = true
L["Deviate Coiler"] = true
L["Deviate Crocolisk"] = true
L["Deviate Dreadfang"] = true
L["Deviate Moccasin"] = true
L["Deviate Stinglash"] = true
L["Deviate Venomwing"] = true
L["Deviate Viper"] = true
L["Dire Mottled Boar"] = true
L["Diseased Grizzly"] = true
L["Diseased Wolf"] = true
L["Dread Flyer"] = true
L["Dread Ripper"] = true
L["Dreadfang Lurker"] = true
L["Dreadfang Widow"] = true
L["Dreadmaw Crocolisk"] = true
L["Drywallow Crocolisk"] = true
L["Drywallow Daggermaw"] = true
L["Drywallow Snapper"] = true
L["Durotar Tiger"] = true
L["Eclipsion Dragonhawk"] = true
L["Elder Ashenvale Bear"] = true
L["Elder Cloud Serpent"] = true
L["Elder Crag Boar"] = true
L["Elder Crag Coyote"] = true
L["Elder Mistvale Gorilla"] = true
L["Elder Moss Creeper"] = true
L["Elder Mottled Boar"] = true
L["Elder Mountain Boar"] = true
L["Elder Plainstrider"] = true
L["Elder Shadowmaw Panther"] = true
L["Elder Shardtooth"] = true
L["Elder Springpaw"] = true
L["Encrusted Surf Crawler"] = true
L["Enraged Ravager"] = true
L["Felpaw Ravager"] = true
L["Felpaw Wolf"] = true
L["Felsworn Scalewing"] = true
L["Feral Crag Coyote"] = true
L["Feral Dragonhawk Hatchling"] = true
L["Feral Mountain Lion"] = true
L["Ferocious Grizzled Bear"] = true
L["Fire Roc"] = true
L["Firetail Scorpid"] = true
L["Flatland Cougar"] = true
L["Fleeting Plainstrider"] = true
L["Forest Lurker"] = true
L["Forest Moss Creeper"] = true
L["Forest Spider"] = true
L["Foreststrider Fledgling"] = true
L["Frostsaber Cub"] = true
L["Frostsaber Huntress"] = true
L["Frostsaber Stalker"] = true
L["Ghamoo-ra"] = true
L["Ghost Saber"] = true
L["Ghostclaw Lynx"] = true
L["Ghostclaw Ravager"] = true
L["Ghostpaw Alpha"] = true
L["Ghostpaw Runner"] = true
L["Giant Foreststrider"] = true
L["Giant Moss Creeper"] = true
L["Giant Plains Creeper"] = true
L["Giant Webwood Spider"] = true
L["Giant Wetlands Crocolisk"] = true
L["Githyiss the Vile"] = true
L["Goretusk"] = true
L["Gray Bear"] = true
L["Gray Forest Wolf"] = true
L["Great Goretusk"] = true
L["Greater Duskbat"] = true
L["Greater Firebird"] = true
L["Greater Fleshripper"] = true
L["Greater Kraul Bat"] = true
L["Greater Tarantula"] = true
L["Greater Thunderhawk"] = true
L["Greater Windroc"] = true
L["Green Recluse"] = true
L["Groddoc Thunderer"] = true
L["Grovestalker Lynx "] = true
L["Grunter"] = true
L["Gutripper"] = true
L["Hakkar'i Frostwing"] = true
L["Hakkar'i Sapper"] = true
L["Ice Claw Bear"] = true
L["Ironback"] = true
L["Ironbeak Hunter"] = true
L["Ironbeak Owl"] = true
L["Ironbeak Screecher"] = true
L["Ironfur Bear"] = true
L["Ironfur Patriarch"] = true
L["Jaguero Stalker"] = true
L["Jungle Thunderer"] = true
L["Juvenile Snow Leopard"] = true
L["Kaliri Matriarch"] = true
L["Kaliri Swooper"] = true
L["King Bangalash"] = true
L["Kraul Bat"] = true
L["Krellack"] = true
L["Kresh"] = true
L["Kurzen War Tiger"] = true
L["Lady Sathrah"] = true
L["Large Crag Boar"] = true
L["Large Loch Crocolisk"] = true
L["Leech Widow"] = true
L["Loch Crocolisk"] = true
L["Longsnout"] = true
L["Longtooth Howler"] = true
L["Longtooth Runner"] = true
L["Lost Torranche"] = true
L["Lupos"] = true
L["Magram Bonepaw"] = true
L["Male Kaliri Hatchling"] = true
L["Mangeclaw"] = true
L["Mangy Mountain Boar"] = true
L["Mazzranache"] = true
L["Mesa Buzzard"] = true
L["Mist Howler"] = true
L["Mistvale Gorilla"] = true
L["Mongress"] = true
L["Monstrous Crawler"] = true
L["Monstrous Plaguebat"] = true
L["Moonstalker Runt"] = true
L["Moonstalker Sire"] = true
L["Mottled Boar"] = true
L["Mottled Drywallow Crocolisk"] = true
L["Mountain Boar"] = true
L["Mountain Lion"] = true
L["Mudrock Snapjaw"] = true
L["Murk Slitherer"] = true
L["Murk Spitter"] = true
L["Naraxis"] = true
L["Night Web Matriarch"] = true
L["Night Web Spider"] = true
L["Nightsaber"] = true
L["Noxious Plaguebat"] = true
L["Oasis Snapjaw"] = true
L["Ol' Sooty"] = true
L["Old Cliff Jumper"] = true
L["Old Grizzlegut"] = true
L["Olm the Wise"] = true
L["Ornery Plainstrider"] = true
L["Panther"] = true
L["Phoenix-Hawk Hatchling"] = true
L["Plague Lurker"] = true
L["Plaguebat"] = true
L["Plagued Swine"] = true
L["Plains Creeper"] = true
L["Porcine Entourage"] = true
L["Prairie Stalker"] = true
L["Prairie Wolf Alpha"] = true
L["Prairie Wolf"] = true
L["Princess"] = true
L["Prowler"] = true
L["Pygmy Surf Crawler"] = true
L["Quillfang Ravager"] = true
L["Quillfang Skitterer"] = true
L["Rabid Blisterpaw"] = true
L["Rabid Crag Coyote"] = true
L["Ragged Scavenger"] = true
L["Raging Agam'ar"] = true
L["Rak'Shiri"] = true
L["Ravage"] = true
L["Ravager Specimen"] = true
L["Ravenous Windroc"] = true
L["Razorfang Hatchling"] = true
L["Razzashi Adder"] = true
L["Razzashi Cobra"] = true
L["Razzashi Serpent"] = true
L["Rekk'tilac"] = true
L["Rema"] = true
L["Ridge Huntress"] = true
L["Ridge Stalker Patriarch"] = true
L["Ridge Stalker"] = true
L["Rip-Blade Ravager"] = true
L["Ripfang Lynx"] = true
L["Ripscale"] = true
L["Roc"] = true
L["Rockhide Boar"] = true
L["Rogue Vale Screecher"] = true
L["Rotting Agam'ar"] = true
L["Salt Flats Vulture"] = true
L["Saltwater Snapjaw"] = true
L["Sandfury Guardian"] = true
L["Sarkoth"] = true
L["Savannah Patriarch"] = true
L["Sawtooth Snapper"] = true
L["Scalewing Serpent"] = true
L["Scarlet Tracking Hound"] = true
L["Scarred Crag Boar"] = true
L["Scarshield Worg"] = true
L["Scorchshell Pincer"] = true
L["Scorpashi Lasher"] = true
L["Scorpashi Snapper"] = true
L["Scorpashi Venomlash"] = true
L["Scorpid Bonecrawler"] = true
L["Scorpid Duneburrower"] = true
L["Scorpid Dunestalker"] = true
L["Scorpid Hunter"] = true
L["Scorpid Reaver"] = true
L["Scorpid Tail Lasher"] = true
L["Scorpid Terror"] = true
L["Scorpid Worker"] = true
L["Scorpok Stinger"] = true
L["Searing Roc"] = true
L["Shadow Panther"] = true
L["Shadowmaw Panther"] = true
L["Shadowwing Owl"] = true
L["Shanda the Spinner"] = true
L["Shardtooth Bear"] = true
L["Shore Crawler"] = true
L["Shrike Bat"] = true
L["Silithid Creeper"] = true
L["Silithid Swarmer"] = true
L["Silt Crawler"] = true
L["Silvermane Howler"] = true
L["Silvermane Stalker"] = true
L["Silvermane Wolf"] = true
L["Sin'Dall"] = true
L["Skettis Kaliri"] = true
L["Skittering Crustacean"] = true
L["Small Crag Boar"] = true
L["Snapjaw"] = true
L["Snapping Crustacean"] = true
L["Snarler"] = true
L["Snow Tracker Wolf"] = true
L["Son of Hakkar"] = true
L["Soulflayer"] = true
L["Sparkleshell Snapper"] = true
L["Spawn of Hakkar"] = true
L["Spiteflayer"] = true
L["Spot"] = true
L["Starving Blisterpaw"] = true
L["Starving Mountain Lion"] = true
L["Starving Winter Wolf"] = true
L["Stonelash Flayer"] = true
L["Stonelash Pincer"] = true
L["Stonelash Scorpid"] = true
L["Stonetusk Boar"] = true
L["Stranglethorn Tiger"] = true
L["Strigid Hunter"] = true
L["Strigid Owl"] = true
L["Swamp Jaguar"] = true
L["Swiftwing Shredder"] = true
L["Tarantula"] = true
L["Thistle Bear"] = true
L["Thistle Boar"] = true
L["Thornfang Ravager"] = true
L["Thornfang Venomspitter"] = true
L["Thunderhawk Cloudscraper"] = true
L["Thunderhawk Hatchling"] = true
L["Tide Crawler"] = true
L["Timber Worg"] = true
L["Timber"] = true
L["Timberweb Recluse"] = true
L["Twilight Runner"] = true
L["U'cha"] = true
L["Uhk'loc"] = true
L["Un'Goro Thunderer"] = true
L["Vale Screecher"] = true
L["Venomlash Scorpid"] = true
L["Venomous Cloud Serpent"] = true
L["Venomtail Scorpid"] = true
L["Venomtip Scorpid"] = true
L["Vicious Night Web Spider"] = true
L["Vile Sting"] = true
L["Vilebranch Raiding Wolf"] = true
L["Warp Chaser"] = true
L["Warp Hunter"] = true
L["Warp Stalker"] = true
L["Washte Pawne"] = true
L["Wayward Buzzard"] = true
L["Webwood Silkspinner"] = true
L["Webwood Venomfang"] = true
L["Wildthorn Lurker"] = true
L["Windroc Hunter"] = true
L["Windroc Huntress"] = true
L["Windroc Matriarch"] = true
L["Windroc"] = true
L["Winter Wolf"] = true
L["Winterspring Owl"] = true
L["Winterspring Screecher"] = true
L["Wood Lurker"] = true
L["Worg"] = true
L["Young Forest Bear"] = true
L["Young Goretusk"] = true
L["Young Mesa Buzzard"] = true
L["Young Panther"] = true
L["Young Stranglethorn Tiger"] = true
L["Young Thistle Boar"] = true
L["Zaricotl"] = true
L["Zulian Panther"] = true
L["Zulian Stalker"] = true

-- Vendor Names
L["Aaron Hollman"] = true
L["Abigail Shiel"] = true
L["Aged Dalaran Wizard"] = true
L["Alchemist Gribble"] = true
L["Alchemist Pestlezugg"] = true
L["Aldraan"] = true
L["Alexandra Bolero"] = true
L["Algernon"] = true
L["Altaa"] = true
L["Amy Davenport"] = true
L["Andrew Hilbert"] = true
L["Andrion Darkspinner"] = true
L["Androd Fadran"] = true
L["Apothecary Antonivich"] = true
L["Aresella"] = true
L["Arras"] = true
L["Arred"] = true
L["Arrond"] = true
L["Asarnan"] = true
L["Balai Lok'Wein"] = true
L["Bale"] = true
L["Banalash"] = true
L["Blimo Gadgetspring"] = true
L["Blixrez Goodstitch"] = true
L["Blizrik Buckshot"] = true
L["Bliztik"] = true
L["Bombus Finespindle"] = true
L["Borto"] = true
L["Borya"] = true
L["Brienna Starglow"] = true
L["Bro'kin"] = true
L["Bronk"] = true
L["Burbik Gearspanner"] = true
L["Burko"] = true
L["Captured Gnome"] = true
L["Catherine Leland"] = true
L["Christoph Jeffcoat"] = true
L["Clyde Ranthal"] = true
L["Constance Brisboise"] = true
L["Cookie McWeaksauce"] = true
L["Cookie One-Eye"] = true
L["Coreiel"] = true
L["Corporal Bluth"] = true
L["Cowardly Crosby"] = true
L["Crazk Sparks"] = true
L["Cro Threadstrong"] = true
L["Daga Ramba"] = true
L["Daggle Ironshaper"] = true
L["Dalria"] = true
L["Daniel Bartlett"] = true
L["Danielle Zipstitch"] = true
L["Darian Singh"] = true
L["Darnall"] = true
L["Dealer Malij"] = true
L["Defias Profiteer"] = true
L["Deneb Walker"] = true
L["Derak Nightfall"] = true
L["Deynna"] = true
L["Dirge Quikcleave"] = true
L["Doba"] = true
L["Drac Roughcut"] = true
L["Drake Lindgren"] = true
L["Drovnar Strongbrew"] = true
L["Edna Mullby"] = true
L["Egomis"] = true
L["Eiin"] = true
L["Elynna"] = true
L["Emrul Riknussun"] = true
L["Eriden"] = true
L["Erika Tate"] = true
L["Erilia"] = true
L["Feera"] = true
L["Felannia"] = true
L["Felicia Doan"] = true
L["Felika"] = true
L["Fradd Swiftgear"] = true
L["Fyldan"] = true
L["Gagsprocket"] = true
L["Gambarinka"] = true
L["Gearcutter Cogspinner"] = true
L["Gelanthis"] = true
L["George Candarte"] = true
L["Gharash"] = true
L["Ghok'kah"] = true
L["Gidge Spellweaver"] = true
L["Gigget Zipcoil"] = true
L["Gikkix"] = true
L["Gina MacGregor"] = true
L["Gloria Femmel"] = true
L["Glyx Brewright"] = true
L["Gnaz Blunderflame"] = true
L["Gretta Ganter"] = true
L["Grimtak"] = true
L["Haalrun"] = true
L["Haferet"] = true
L["Hagrus"] = true
L["Hammon Karwn"] = true
L["Harggan"] = true
L["Harklan Moongrove"] = true
L["Harlown Darkweave"] = true
L["Harn Longcast"] = true
L["Haughty Modiste"] = true
L["Heldan Galesong"] = true
L["Helenia Olden"] = true
L["Himmik"] = true
L["Hula'mahi"] = true
L["Innkeeper Biribi"] = true
L["Innkeeper Fizzgrimble"] = true
L["Innkeeper Grilka"] = true
L["Jabbey"] = true
L["Jandia"] = true
L["Janet Hommers"] = true
L["Jangdor Swiftstrider"] = true
L["Jannos Ironwill"] = true
L["Jaquilina Dramet"] = true
L["Jase Farlane"] = true
L["Jazzrik"] = true
L["Jeeda"] = true
L["Jennabink Powerseam"] = true
L["Jessara Cordell"] = true
L["Jim Saltit"] = true
L["Jinky Twizzlefixxit"] = true
L["Johan Barnes"] = true
L["Joseph Moore"] = true
L["Jubie Gadgetspring"] = true
L["Jun'ha"] = true
L["Juno Dufrain"] = true
L["Jutak"] = true
L["Kaita Deepforge"] = true
L["Kalaen"] = true
L["Kalldan Felmoon"] = true
L["Kania"] = true
L["Keena"] = true
L["Kelsey Yance"] = true
L["Kendor Kabonka"] = true
L["Khara Deepwater"] = true
L["Kiknikle"] = true
L["Killian Sanatha"] = true
L["Kilxx"] = true
L["Kireena"] = true
L["Kithas"] = true
L["Knaz Blunderflame"] = true
L["Kor'geld"] = true
L["Krek Cragcrush"] = true
L["Kriggon Talsone"] = true
L["Krinkle Goodsteel"] = true
L["Kulwia"] = true
L["Kzixx"] = true
L["Laird"] = true
L["Landraelanis"] = true
L["Lardan"] = true
L["Lebowski"] = true
L["Leeli Longhaggle"] = true
L["Leo Sarn"] = true
L["Leonard Porter"] = true
L["Lilly"] = true
L["Lindea Rabonne"] = true
L["Lizbeth Cromwell"] = true
L["Logannas"] = true
L["Loolruna"] = true
L["Lorelae Wintersong"] = true
L["Lyna"] = true
L["Madame Ruby"] = true
L["Mahu"] = true
L["Mallen Swain"] = true
L["Malygen"] = true
L["Mari Stonehand"] = true
L["Maria Lumere"] = true
L["Martine Tramblay"] = true
L["Masat T'andr"] = true
L["Master Chef Mouldier"] = true
L["Mathar G'ochar"] = true
L["Mavralyn"] = true
L["Mazk Snipeshot"] = true
L["Melaris"] = true
L["Micha Yance"] = true
L["Millie Gregorian"] = true
L["Mishta"] = true
L["Mixie Farshot"] = true
L["Montarr"] = true
L["Muheru the Weaver"] = true
L["Muuran"] = true
L["Mythrin'dir"] = true
L["Naal Mistrunner"] = true
L["Namdo Bizzfizzle"] = true
L["Nandar Branson"] = true
L["Narkk"] = true
L["Nasmara Moonsong"] = true
L["Nata Dawnstrider"] = true
L["Neal Allen"] = true
L["Neii"] = true
L["Nergal"] = true
L["Nerrist"] = true
L["Nessa Shadowsong"] = true
L["Nina Lightbrew"] = true
L["Nioma"] = true
L["Nula the Butcher"] = true
L["Nyoma"] = true
L["Ogg'marr"] = true
L["Otho Moji'ko"] = true
L["Outfitter Eric"] = true
L["Phea"] = true
L["Plugger Spazzring"] = true
L["Pratt McGrubben"] = true
L["Qia"] = true
L["Quartermaster Davian Vaclav"] = true
L["Quartermaster Jaffrey Noreliqe"] = true
L["Quelis"] = true
L["Ranik"] = true
L["Rann Flamespinner"] = true
L["Rartar"] = true
L["Rathis Tomber"] = true
L["Rikqiz"] = true
L["Rizz Loosebolt"] = true
L["Rohok"] = true
L["Ronald Burch"] = true
L["Rungor"] = true
L["Ruppo Zipcoil"] = true
L["Saenorion"] = true
L["Seer Janidi"] = true
L["Sewa Mistrunner"] = true
L["Shadi Mistrunner"] = true
L["Shankys"] = true
L["Sheendra Tallgrass"] = true
L["Shen'dralar Provisioner"] = true
L["Sheri Zipstitch"] = true
L["Sid Limbardi"] = true
L["Skreah"] = true
L["Soolie Berryfizz"] = true
L["Sovik"] = true
L["Stuart Fleming"] = true
L["Sumi"] = true
L["Super-Seller 680"] = true
L["Supply Officer Mills"] = true
L["Tamar"] = true
L["Tansy Puddlefizz"] = true
L["Tarban Hearthgrain"] = true
L["Tari'qa"] = true
L["Tatiana"] = true
L["Thaddeus Webb"] = true
L["Tharynn Bouden"] = true
L["Thomas Yance"] = true
L["Tilli Thistlefuzz"] = true
L["Truk Wildbeard"] = true
L["Tunkk"] = true
L["Ulthaan"] = true
L["Ulthir"] = true
L["Uriku"] = true
L["Uthok"] = true
L["Vaean"] = true
L["Valdaron"] = true
L["Veenix"] = true
L["Vendor-Tron 1000"] = true
L["Vharr"] = true
L["Viggz Shinesparked"] = true
L["Vivianna"] = true
L["Vizzklick"] = true
L["Vodesiin"] = true
L["Wenna Silkbeard"] = true
L["Werg Thickblade"] = true
L["Wik'Tar"] = true
L["Wind Trader Lathrai"] = true
L["Wrahk"] = true
L["Wulan"] = true
L["Wunna Darkmane"] = true
L["Xandar Goodbeard"] = true
L["Xen'to"] = true
L["Xizk Goodstitch"] = true
L["Xizzer Fizzbolt"] = true
L["Yatheon"] = true
L["Yonada"] = true
L["Yuka Screwspigot"] = true
L["Yurial Soulwater"] = true
L["Zan Shivsproket"] = true
L["Zannok Hidepiercer"] = true
L["Zansoa"] = true
L["Zaralda"] = true
L["Zarena Cromwind"] = true
L["Zixil"] = true
L["Zorbin Fandazzle"] = true
L["Zurai"] = true
L["Narj Deepslice"] = true
L["Fazu"] = true
L["Zargh"] = true
L["Smudge Thunderwood"] = true
L["Sassa Weldwell"] = true
