﻿--[[
****************************************************************************************

ARLLocals-frFR.lua

frFR localization strings for Ackis Recipe List

$Date: 2008-08-29 20:43:38 +0000 (Fri, 29 Aug 2008) $
$Rev: 845 $

Original translated by: Pettigrow
Currently maintaince by: Pettigrow & Trasher
Thank you all translators! (From Ackis)

Please make sure you update the ToC file with any translations.

****************************************************************************************
]]--
local L = LibStub("AceLocale-3.0"):NewLocale("Ackis Recipe List", "frFR", false);
if not L then return end

-- Addon Info
L["Version"] = "Version : "

-- Options Categories
L["About"] = "À propos"
L["Display"] = "Affichage"
L["DISPLAY_OPTIONS"] = "Options d'affichage"
L["DISPLAY_OPTIONS_LONG"] = "Vous permet de personnaliser le comportement de l'IUG."
L["Filter"] = "Filtrage"
L["Filters"] = "Filtres"
L["FILTER_OPTIONS"] = "Options de filtrage"
L["FILTER_OPTIONS_LONG"] = "Vous permet de personnaliser les recettes qui sont filtrées."
L["Reputation"] = "Réputation"
L["REP_OPTIONS"] = "Options de réputation"
L["REP_OPTIONS_LONG"] = "Vous permet de personnaliser les réputations prises en compte dans l'analyse."
L["Binding"] = "Lien"
L["BINDING_OPTIONS"] = "Options de lien"
L["BINDING_OPTIONS_LONG"] = "Vous permet de personnaliser les types de liens pris en compte dans l'analyse."
L["Crafting"] = "Fabrication"
L["CRAFTING_OPTIONS"] = "Options de fabrication"
L["CRAFTING_OPTIONS_LONG"] = "Vous permet de personnaliser les types de fabrications pris en compte dans l'analyse."
L["Armour"] = "Armure"
L["ARMOUR_OPTIONS"] = "Options des armures"
L["ARMOUR_OPTIONS_LONG"] = "Vous permet de personnaliser les types d'armure (tissu, cuir, ...) pris en compte dans l'analyse."
L["Obtain"] = "Obtention"
L["OBTAIN_OPTIONS"] = "Options d'obtention"
L["OBTAIN_OPTIONS_LONG"] = "Vous permet de personnaliser les méthodes d'obtention prises en compte dans l'analyse."
L["Sort"] = "Trier par"
L["SORT_OPTIONS"] = "Options de tri"
L["SORT_OPTIONS_LONG"] = "Vous permet de personnaliser la façon dont les recettes manquantes sont triées et affichées."
L["Profile"] = "Profil"
L["Scan Recipes"] = "Analyser les recettes"
L["Scans an open tradeskill for missing recipes."] = "Analyse une fenêtre de métier ouverte à la recherche des recettes manquantes."
L["Text Dump"] = "Transfert"
L["Displays all recipes in a comma seperated value format which can be copied and pasted into another client."] = "Affiche toutes les recettes dans un format de valeurs séparées par des virgules qui peut être copié et collé dans un autre client."

-- Display Options
L["Include Filtered"] = "Compter les filtrés"
L["FILTERCOUNT_TOGGLE"] = "Intègre les recettes filtrées dans le nombre total des recettes."
L["Close GUI"] = "Fermer l'IUG"
L["CLOSEGUI_TOGGLE"] = "Ferme la fenêtre de ARL quand la fenêtre de métier est fermée."

-- Filtering Options
L["Faction"] = "Faction"
L["FACTION_TOGGLE"] = "Intègre ou non les recettes des deux factions dans l'analyse."
L["Classes"] = "Classes"
L["CLASS_TOGGLE"] = "Intègre ou non les recettes spécifiques à certaines classes dans l'analyse."
L["Specialities"] = "Spécialités"
L["SPECIALITY_TOGGLE"] = "Intègre ou non toutes les spécialisations des métiers dans l'analyse."
L["Skill"] = "Compétence"
L["SKILL_TOGGLE"] = "Intègre ou non toutes les recettes quelque soit votre niveau de compétence actuel."
L["Old World"] = "WoW classique"
L["OLDWORLD_OPTIONS"] = "Réputations de WoW classique"
L["OLDWORLD_OPTIONS_LONG"] = "Vous permet de déterminer les réputations du jeu original qui doivent être intégrées dans l'analyse."
L["Burning Crusade"] = "Burning Crusade"
L["BC_OPTIONS"] = "Réputations de Burning Crusade"
L["BC_OPTIONS_LONG"] = "Vous permet de déterminer les réputations de Burning Crusade qui doivent être intégrées dans l'analyse."
L["Wrath of the Lich King"]= "Wrath of the Lich King"
L["WOTLK_OPTIONS"] = "Réputations de Wrath of the Lich King"
L["WOTLK_OPTIONS_LONG"] = "Vous permet de déterminer les réputations de Wrath of the Lich King qui doivent être intégrées dans l'analyse."

-- Obtain Filter Options
L["BOEFilter"] = "Objets LqE"
L["BOE_TOGGLE"] = "Intègre ou non les recettes qui permettent de fabriquer des objets liés quand équipés dans l'analyse."
L["BOPFilter"] = "Objets LqR"
L["BOP_TOGGLE"] = "Intègre ou non les recettes qui permettent de fabriquer des objets liés quand ramassés dans l'analyse."
L["RecipeBOEFilter"] = "Recettes LqE"
L["RECIPE_BOE_TOGGLE"] = "Intègre ou non les recettes liées quand équipées dans l'analyse."
L["RecipeBOPFilter"] = "Recettes LqR"
L["RECIPE_BOP_TOGGLE"] = "Intègre ou non les recettes liées quand ramassées dans l'analyse."
L["PVP_TOGGLE"] = "Intègre ou non les recettes obtenues en JcJ dans l'analyse."
L["RAID_TOGGLE"] = "Intègre ou non les recettes de raid difficiles à obtenir (Coeur du Magma, Caverne du sanctuaire du Serpent, etc.) dans l'analyse."
L["SEASONAL_TOGGLE"] = "Intègre ou non les recettes saisonnières dans l'analyse."
L["TRAINER_TOGGLE"] = "Intègre ou non les recettes apprises aux entraîneurs dans l'analyse."
L["VENDOR_TOGGLE"] = "Intègre ou non les recettes achetées aux marchands dans l'analyse."
L["INSTANCE_TOGGLE"] = "Intègre ou non les recettes obtenues en instances dans l'analyse."
L["QUEST_TOGGLE"] = "Intègre ou non les recettes obtenues dans les récompenses de quête dans l'analyse."
L["Cloth"] = "Tissu"
L["CLOTH_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets en tissu dans l'analyse."
L["Leather"] = "Cuir"
L["LEATHER_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets en cuir dans l'analyse."
L["Mail"] = "Mailles"
L["MAIL_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets en mailles dans l'analyse."
L["Plate"] = "Plaques"
L["PLATE_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets en plaques dans l'analyse."
L["Melee"] = "Mêlée"
L["MELEE_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets pour mêlée/dps physique dans l'analyse."
L["Caster DPS"] = "Lanceur de sort"
L["CASTERDPS_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets pour lanceur de sort dans l'analyse."
L["Tanking"] = "Tank"
L["TANKING_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets pour tank dans l'analyse."
L["Healing"] = "Soigneur"
L["HEALING_TOGGLE"] = "Intègre ou non les recettes avec lesquelles on peut fabriquer des objets pour soigneur dans l'analyse."
L["World Drop"] = "Butin mondial"
L["WORLD_DROP_TOGGLE"] = "Intègre ou non les recettes trouvées dans le monde dans l'analyse."
L["MOB_DROP_TOGGLE"] = "Intègre ou non les recettes trouvées aléatoirement sur les monstres d'une même fourchette de niveaux dans l'analyse."

-- Sorting options
L["Name"] = "Nom"
L["Skill"] = "Compétence"
L["Acquisition"] = "Acquisition"

-- Reputation Toggles
L["SPECIFIC_REP_TOGGLE"] = "Intègre ou non les recettes spécifiques à la faction %s."

-- Non-gui text
L["MissingFromDB"] = ": n'est pas présent dans la base de données. \nVeuillez en informer l'auteur de cet addon."
L["MissingRecipePrefix"] = "Recette manquante : "
L["InitiateScan"] = "Analyse des recettes manquantes en %s au niveau de compétence %s.\n"
L["InitiateScanSpecial"] = "Analyse des recettes manquantes en %s - %s au niveau de compétence %s.\n"
L["RecipeListSummary"] = "\nVous connaissez %s des %s recettes totales (%s%%).\nIl vous manque %s recettes."
L["UnknownTradeSkill"] = "Vous avez ouvert une fenêtre de métier qui n'est pas supporté par cet addon. Le métier en question est %s. Veuillez en informer l'auteur de cet addon."
L["OpenTradeSkillWindow"] = "Veuillez ouvrir la fenêtre de métier à analyser."
L["TwoCraftingWindows"] = "La fenêtre de craft est déjà ouverte. Veuillez fermer celle ci et la ré-ouvrir si vous souhaitez scanner les recettes manquantes."
L["SpellIDCache"] = "L'ID du sort %s n'est pas dans votre cache local.  Veuillez soumettre un ticket (en anglais) sur http://wow.curseforge.com/projects/ackis-recipe-list/tickets/ en indiquant l'ID du sort et la profession que vous analysiez."
L["FactionError"] = "Avertissement : le niveau de réputation %s est inconnu."
L["MissingFromDBWarning"] = "Une recette non présente dans la base de données a été détectée. Il se peut que le jeu saccade un peu pendant l'analyse de l'ID du sort de la recette manquante."

-- GUI Text
L["Close"] = "Fermer"
L["ScanButton"] = "Analyser"
L["Scan Skills"] = "Analyser"
L["FILTER_OPEN"] = "Filtre >>>"
L["FILTER_CLOSE"] = "<<< Filtre"
L["Reset"] = "Réinitialiser"
L["Sort"] = "Trier"
L["World Drop"] = "Butin mondial"
L["Mob Drop"] = "Butin de monstre"
L["Quest"] = "Quête"
L["Reputation"] = "Réputation"
L["Instance"] = "Instance"
L["BoPMenu"] = "LqR"
L["Horde"] = "Horde"
L["Alliance"] = "Alliance"
L["Known"] = "Connu"
L["Unknown"] = "Inconnu"

-- More stuff for new gui, ZJ 7/26/08
L["General"] = "Général"
L["Class Specific recipes"] = "Recettes spécifique à une classe"
L["Craft Specialty recipes"] = "Recettes spécifiques à une spécialisation"
L["All Skill Levels"] = "Tous les niveaux de compétence"
L["Item Type"] = "Type d'objet"
L["Armor"] = "Armure"
L["Weapon"] = "Arme"
L["Player Type"] = "Type de joueur"
L["Tank"] = "Tank"
L["Healer"] = "Soigneur"
L["Melee DPS"] = "DPS en mêlée"
L["All"] = "Tous"
L["None"] = "Aucun"
L["Dagger"] = "Dague"
L["1H"] = "1M"
L["2H"] = "2M"
L["Axe"] = "Hache"
L["Mace"] = "Masse"
L["Sword"] = "Épée"
L["Polearm"] = "Arme d'hast"
L["Thrown"] = "Arme de jet"
L["Ammo"] = "Munitions"
-- unused, but included anyway. Who knows what the future may bring
L["Bow"] = "Arc"
L["Crossbow"] = "Arbalète"
L["Staff"] = "Bâton"
-- More stuff for new GUI, ZJ 8/11/08
L["Search"] = "Rechercher"
L["SEARCH_TT"] = "Garde dans l'affichage les recettes contenant le texte de gauche."
L["Apply"] = "Appliquer"
L["Apply_TT"] = "Applique les filtres sélectionnés ci-dessus à la liste des recettes."
L["ExpandAll"] = "+ Tous"
L["EXPAND_TT"] = "Étend toutes les recettes listées ci-dessous."
L["ContractAll"] = "- Tous"
L["CONTRACT_TT"] = "Minimise toutes les recettes listées ci-dessous."
L["Clear"] = "(X)"
L["CLEAR_TT"] = "Efface le texte de la boîte de saisie de la recherche."
-- new GUI, ZJ 8/26/08
L["General_TT"] = "Cliquez pour configurer les options générales de filtration."
L["Obtain_TT"] = "Cliquez pour configurer les options de filtration des obtentions."
L["Binding_TT"] = "Cliquez pour configurer les options de filtration des liens."
L["Item_TT"] = "Cliquez pour configurer les options de filtration des objets."
L["Player_TT"] = "Cliquez pour configurer les options de filtration des joueurs."
L["Reputation_TT"] = "Cliquez pour configurer les options de filtration des réputations."
L["IBOE_TT"] = "Les objets liés quand équipés seront intégrés dans l'analyse."
L["IBOE"] = "Objet LqE"
L["IBOP_TT"] = "Les objets fabriqués liés quand ramassés seront intégrés dans l'analyse"
L["IBOP"] = "Objet LqR"
L["RBOE_TT"] = "Les recettes liées quand équipées seront intégrées dans l'analyse."
L["RBOE"] = "Recette LqE"
L["RBOP_TT"] = "Les recettes liées quand ramassées seront intégrées dans l'analyse."
L["RBOP"] = "Recette LqR"
L["ArmorAll_TT"] = "Intègre toutes les recettes permettant de fabriquer des pièces d'armure dans l'analyse"
L["ArmorNone_TT"] = "N'intègre aucune recette permettant de fabriquer des pièces d'armure dans l'analyse."
L["WeaponAll_TT"] = "Intègre toutes les recettes permettant de fabriquer des armes dans l'analyse."
L["WeaponNone_TT"] = "N'intégre aucune recette permettant de fabriquer des armes dans l'analyse."
L["Weapon1H_TT"] = "Intègre les recettes permettant de fabriquer des armes à 1 main dans l'analyse."
L["Weapon2H_TT"] = "Intègre les recettes permettant de fabriquer des armes à 2 mains dans l'analyse."
L["WeaponDagger_TT"] = "Intègre les recettes permettant de fabriquer des dagues dans l'analyse."
L["WeaponAxe_TT"] = "Intègre les recettes permettant de fabriquer des haches dans l'analyse."
L["WeaponMace_TT"] = "Intègre les recettes permettant de fabriquer des masses dans l'analyse."
L["WeaponSword_TT"] = "Intègre les recettes permettant de fabriquer des épées dans l'analyse."
L["WeaponPolearm_TT"] = "Intègre les recettes permettant de fabriquer des armes d'hast dans l'analyse."
L["WeaponThrown_TT"] = "Intègre les recettes permettant de fabriquer des armes de jet dans l'analyse."
L["WeaponBow_TT"] = "Intègre les recettes permettant de fabriquer des arcs dans l'analyse."
L["WeaponCrossbow_TT"] = "Intègre les recettes permettant de fabriquer des arbalètes dans l'analyse."
L["WeaponStaff_TT"] = "Intègre les recettes permettant de fabriquer des bâtons dans l'analyse."
L["WeaponAmmo_TT"] = "Intègre les recettes permettant de fabriquer des munitions dans l'analyse."
L["WeaponWand_TT"] = "Intègre les recettes permettant de fabriquer des baguettes dans l'analyse."
L["MOB_DROP_TT"] = "Intègre les recettes tombant sur les montres dans l'analyse."
-- ZJ 8/28/08
L["CLOAK_TOGGLE"] = "Intègre les recettes permettant de fabriquer des capes dans l'analyse."
L["Cloak"] = "Cape"
L["NECKLACE_TOGGLE"] = "Intègre les recettes permettant de fabriquer des colliers dans l'analyse."
L["Necklace"] = "Collier"
L["RING_TOGGLE"] = "Intègre les recettes permettant de fabriquer des anneaux dans l'analyse."
L["Ring"] = "Anneau"
L["TRINKET_TOGGLE"] = "Intègre les recettes permettant de fabriquer des bijoux dans l'analyse."
L["Trinket"] = "Bijou"
L["Wand"] = "Baguette"
L["OLD_WORLD_REP_TT"] = "Cliquez pour configurer les options de filtration des réputations de WoW classique."
L["BC_REP_TT"] = "Cliquez pour configurer les options de filtration des réputations de Burning Crusade."

-- Tooltip Text
L["Scan Skills Long"] = "Analyse les recettes manquantes à l'aide de Ackis Recipe List."
L["Close Window"] = "Ferme la fenêtre de Ackis Recipe List."
L["Expand All"] = "Étend toutes les recettes."
L["Collapse All"] = "Réduit toutes les recettes."
L["FILTER_OPEN_TT"] = "Ouvre le panneau des options de tri."
L["FILTER_CLOSE_TT"] = "Ferme le panneau des options de tri."
L["RESET_TT"] = "Réinitialise le string de recherche."
L["SORT_TT"] = "Change l'ordre de tri de la liste."
L["VENDOR_TT"] = "Cochez pour intégrer les recettes des marchands dans la liste."
L["TRAINER_TT"]= "Cochez pour intégrer les recettes apprises auprès de l'entraîneur dans la liste."
L["WORLD_TT"] = "Cochez pour intégrer les recettes des butins mondiaux dans la liste."
L["MOB_TT"] = "Cochez pour intégrer les recettes trouvées sur des monstres spécifiques dans la liste."
L["QUEST_TT"] = "Cochez pour intégrer les recettes des récompétences de quête dans la liste."
L["SEASON_TT"] = "Cochez pour intégrer les recettes saisonnières dans la liste."
L["REP_TT"] = "Cochez pour intégrer les recettes des réputations dans la liste."
L["INSTANCE_TT"] = "Cochez pour intégrer uniquement les recettes trouvées en instance dans la liste."
L["BOP_TT"] = "Cochez pour afficher uniquement les recettes liées quand ramassées dans la liste."
L["HORDE_TT"] = "Cochez pour intégrer les recettes spécifiques à la Horde dans la liste."
L["ALLIANCE_TT"] = "Cochez pour intégrer les recettes spécifiques à l'Alliance dans la liste."
L["KNOWN_TT"] = "Cochez pour intéger les recettes connues dans la liste."
L["UNKNOWN_TT"] = "Cochez pour intégrer les recettes inconnues dans la liste."
L["DISCOVERY_TT"] = "Cochez pour intégrer les recettes découvertes dans la liste."
L["ARMOR_TT"] = "Cochez pour intégrer les recettes d'armure dans la liste."
L["WEAPON_TT"] = "Cochez pour intégrer les recettes d'arme dans la liste."

-- Recipe Database
L["Trainer"] = "Entraîneur"
L["LimitedSupply"] = "Stock limité d'un marchand"
L["Vendor"] = "Marchand"
L["Discovery"] = "Découverte"
L["PVP"] = "JcJ"
L["Raid"] = "Raid"

--Skillup Levels
L["Journeyman"] = "Compagnon"
L["Expert"] = "Expert"
L["Artisan"] = "Artisan"
L["Master"] = "Maître"

-- Common ways to obtain recipes
L["UZD"] = "Butin de zone inhabituel : "
L["CWD"] = "Butin mondial commun"
L["UWD"] = "Butin mondial inhabituel"
L["RWD"] = "Butin mondial rare"
L["EWD"] = "Butin mondial épique"
L["BoE"] = "Butin LqE : "
L["BoP"] = "Butin LqR : "
L["QuestReward"] = "Récompense de quête : "

-- Common quests/drops
L["DMCACHE"] = "Cache de Noué Dédodevie"
L["Gordok Ogre Suit"] = "Tenue d'ogre gordok"
L["Gordok Ogre Suit Obt"] = "La tenue d'ogre gordok"
L["Spectral Essence Obt"] = "Kirtonos le Hérault (vous permet de voir le vendeur Magnus Givréveil près de Scholomance)"
L["TrueBelieverQuest"] = "Les vrais croyants - Rare"

-- Raid Drop Obtain Info
L["ADNaxx"] = "Entraîneur : Maître-artisan Omarion de l'aile des chevaliers de la mort de Naxxramas."
L["MOLTENCORE"] = "Butin de raid LqR : N'importe quel boss à CM."
L["AQ20/AQ40"] = "Butin de raid LqR : N'importe quel boss à AQ20/AQ40."
L["SSC/TKBoP"] = "Butin de raid LqR : N'importe quel monstre et boss à CSS/DT."
L["SSC/TKBoE"] = "Butin de raid LqR : N'importe quel monstre et boss à CSS/DT."
L["BT/HYJALBoP"] = "Butin de raid LqR : N'importe quel monstre et boss à Hyjal/TN."
L["HYJALBoP"] = "Butin de raid LqR : N'importe quel boss à Hyjal."
L["SunwellBoP"] = "Butin de raid LqR : N'importe quel monstre et boss au Puits de soleil."
L["SunwellBoE"] = "Butin de raid LqE : N'importe quel monstre et boss au Puits de soleil."
L["BT/HYJALBoE"] = "Butin de raid LqR : N'importe quel monstre et boss à Hyjal/TN."
L["ZA"] = "Butin de raid LqR : N'importe quel boss à ZA."
L["Unknown"] = "Butin inconnu : le moyen d'obtenir cette recette est inconnu. Veuillez en informer l'auteur de cet addon."

-- Faction info
L["WintersVeil"] = "Saisonnier : Fête du Voile d'hiver"
L["Lunar Festival"] = "Saisonnier : Fête lunaire"
L["Darkmoon Faire"] = "Foire de Sombrelune"
L["Seasonal"] = "Saisonnier"

-- Alchemy Obtain Information
L["Discovery - Flasks/Potions"] = "Découverte : S'apprend en fabriquant des flacons, des élixirs ou des potions contenant des herbes de l'Outreterre."
L["Discovery - Protection Potions"] = "Découverte : S'apprend en fabriquant des potions de protection majeures."
L["Discovery - Transmutes"] = "Découverte : S'apprend en transmutant des objets contenant des matériaux de l'Outreterre."
L["Goblin Rocket Fuel Obt"] = "Création : cette recette est créée par les ingénieurs gobelins"
L["Gurubashi Mojo Madness Obt"] = "Raid : Vous pouvez apprendre ceci en cliquant sur une tablette de pierre à la Frontière de la folie de Zul'Gurub"
L["Mighty Trolls Blood Potion Obt"] = "Entraîneur : Henry Stern"
-- Mob Drop
L["Elixir of Greater Firepower Obt"] = "Esclavagiste Sombrefer, Garde Sombrefer, Sous-chef Sombrefer"
L["Elixir of the Mongoose Obt"] = "Voleur Jadefeu (Gangrebois), Voleur Legashi"
L["Elixir of the Sages Obt"] = "Enchanteur écarlate, Clerc écarlate, Vicaire écarlate, Archimage écarlate, Inquisiteur écarlate"
L["Fel Mana Potion Obt"] = "Soldat éclipsion, Garde-sang éclipsion, Chevalier de sang éclipsion, Lieur de sort éclipsion, Archimage éclipsion, Centurion éclipsion, Cavalier éclipsion, Torloth le Magnifique, Guetteur Illidari"
L["Fel Regeneration Potion Obt"] = "Diablotin de la Forgemort, Gardien de la Forgemort, Forgeron de la Forgemort, Bricoleur de la Forgemort"
L["Fel Strength Elixir Obt"] = "Fabricant d'armes mo'arg, Maître de Terreur, Marche-courroux, Démoniste du Conseil des ombres"
L["Gift of Arthas Obt"] = "Ecorcheur Squelette, Goule écumante"
L["Greater Arcane Protection Potion Obt"] = "Tisse-magie cobalt"
L["Greater Fire Protection Potion Obt"] = "Invocateur de Brandefeu, Pyromancien de Brandefeu"
L["Greater Frost Protection Potion Obt"] = "Géant Cognegivre"
L["Greater Nature Protection Potion Obt"] = "Horreur décomposée, Béhémoth pourrissant"
L["Greater Shadow Protection Potion Obt"] = "Adepte noir, Ombremage"
L["Major Arcane Protection Potion Obt"] = "Arcaniste vir'aani"
L["Major Fire Protection Potion Obt"] = "Astromage Cherche-soleil"
L["Major Holy Protection Potion Obt"] = "Porte-flamme abyssal"
L["Major Shadow Protection Potion Obt"] = "Démoniste du Conseil des ombres"
L["Mighty Rage Potion Obt"] = "Pourfendeur Rochenoire"
L["Wildvine Potion Obt"] = "Divers trolls"
-- Quest
L["Discolored Healing Potion Obt"] = "Coeurs sauvages"
L["Elixir of Brute Force Obt"] = "Dadanga a faim (récompense aléatoire)"
L["Lesser Stoneshield Potion Obt"] = "Pierre liquide"
L["Restorative Potion Obt"] = "Rechercher les composants à Uldaman"

-- Blacksmithin Obtain Information
L["Inlaid Mithril Cylinder Obt"] = "Création : Cette recette est créée par les ingénieurs gnomes"
L["Blacksmithing Plans"] = "Recette aléatoire obtenue en cliquant sur les Plans de forgeron situés dans les Profondeurs de Rochenoire ou Stratholme."
-- Mob Drop
L["Dark Iron Sunderer Obt"] = "Client fin saoul, Compère de Ribbly"
L["Felsteel Gloves Obt"] = "Moine auchenaï"
L["Felsteel Helm Obt"] = "Fanatique de la Cabale"
L["Felsteel Leggings Obt"] = "Porte-destin sans chaîne"
L["Frostguard Obt"] = "Contremaître Marcrid"
L["Greater Ward of Shielding Obt"] = "Garde-sang solfurie"
L["Khorium Belt Obt"] = "Ecumeur bourbesang"
L["Khorium Boots Obt"] = "Protecteur désincarné"
L["Khorium Pants Obt"] = "Gardien de la Forgemort"
L["Ragesteel Breastplate Obt"] = "Guerrier cendrelangue"
L["Ragesteel Gloves Obt"] = "Guerrier Rochepoing"
L["Ragesteel Helm Obt"] = "Garde de Colère"
L["Ragesteel Shoulders Obt"] = "Esprit de la terre enragé, Esprit du feu enragé, Esprit de l'air enragé, Esprit de l'eau enragé"
L["Runic Breastplate Obt"] = "Myrmidon Strashaz"
L["Runic Plate Boots Obt"] = "Cavalier écarlate "
L["Runic Plate Helm Obt"] = "Guerrier Strashaz"
L["Runic Plate Leggings Obt"] = "Forgeron écarlate"
L["Runic Plate Shoulders Obt"] = "Garde-serpent Strashaz"
L["Swiftsteel Gloves Obt"] = "Traqueur de nexus"
L["Volcanic Hammer Obt"] = "Volchan"
-- Quest
L["Barbaric Iron Boots Obt"] = "Piétinés"
L["Barbaric Iron Breastplate Obt"] = "Remparts barbares"
L["Barbaric Iron Gloves Obt"] = "Les joies des Omosh"
L["Barbaric Iron Helm Obt"] = "Les cornes de Frénésie"
L["Barbaric Iron Shoulders Obt"] = "Épaulettes en fer"
L["Blazing Rapier Obt"] = "Corruption"
L["Dawn's Edge Obt"] = "Pierre du serpent de la chasseresse des ombres"
L["Demon Forged Breastplate Obt"] = "La Forge démoniaque"
L["Enchanted Battlehammer Obt"] = "Douce sérénité"
L["Enchanted Thorium Breastplate Obt"] = "Mailles plaquées en thorium enchantées - Volume I (nécessite le butin des autres instances poir obtenir la quête)"
L["Enchanted Thorium Helm Obt"] = "Mailles plaquées en thorium enchantées - Volume III (nécessite le butin des autres instances poir obtenir la quête)"
L["Enchanted Thorium Leggings Obt"] = "Mailles plaquées en thorium enchantées - Volume II (nécessite le butin des autres instances poir obtenir la quête)"
L["Fiery Plate Gauntlets Obt"] = "Gantelets en plaque de feu"
L["Golden Scale Gauntlets Obt"] = "Les origines de la forge"
L["Heavy Copper Longsword Obt"] = "Rééquiper le front"
L["Imperial Plate Belt Obt"] = "La Ceinture impériale en plaques"
L["Imperial Plate Boots Obt"] = "Les Bottes impériales en plaques"
L["Imperial Plate Bracers Obt"] = "Les Bracelets impériaux en plaques"
L["Imperial Plate Chest Obt"] = "La Pansière impériale"
L["Imperial Plate Helm Obt"] = "Le Heaume impérial en Plaques"
L["Imperial Plate Leggings Obt"] = "Les Jambières impériales en plaques"
L["Imperial Plate Shoulders Obt"] = "Les Epaulières impériales en plaques"
L["Ironforge Breastplate Obt"] = "Le rééquipement des Carmines"
L["Orcish War Leggings Obt"] = "Les vieilles voies"
L["Ornate Mithril Gloves Obt"] = "Le vif-argent n'est pas de l'argent"
L["Ornate Mithril Helm Obt"] = "Une tête bien faite sur les épaules"
L["Ornate Mithril Pants Obt"] = "Ça fond, ça ne fond pas"
L["Ornate Mithril Shoulder Obt"] = "L'art de l'imprégnation"
L["Sulfuron Hammer Obt"] = "Un contrat contraignant"

-- Cooking Obtain Information
L["Fishing Daily"] = "Récompense de quête : récompense aléatoire de la quête journalière en pêche"
L["Cooking Daily"] = "Récompense de quête : récompense aléatoire de la quête journalière en cuisine"
L["Goldthorn Tea Obt"] = "Parlez à Henry Stern aux Souilles de Tranchebauge"
L["Stewed Trout Obt"] = "Entraîneur : Kylene"
-- Mob Drop
L["Runn Tum Tuber Surprise Obt"] = "Pusillin"
-- Quest
L["Barbecued Buzzard Wing Obt"] = "Ailes de busard grillées"
L["Beer Basted Boar Ribs Obt"] = "Côtes de sanglier à la bière"
L["Big Bear Steak Obt"] = "Sauvetage"
L["Blood Sausage Obt"] = "Les boudins de Thelsamar"
L["Buzzard Bites Obt"] = "Les doigts dans le nez"
L["Crocolisk Gumbo Obt"] = "Les devoirs de l'apprenti"
L["Crocolisk Steak Obt"] = "Chasse aux crocilisques"
L["Crunchy Serpent Obt"] = "Délices de Mok'Nathal"
L["Crunchy Spider Surprise Obt"] = "Il faut que ça croustille !"
L["Curiously Tasty Omelet Obt"] = "La vengeance d'Ormer"
L["Dig Rat Stew Obt"] = "Brouet de rat"
L["Dirge's Kickin' Chimaerok Chops Obt"] = "Pyro-côtelettes de chimaerok à la Dirge"
L["Gooey Spider Cake Obt"] = "Gâteaux au crabe brun"
L["Goretusk Liver Pie Obt"] = "Tourte au foie de Broche-tripes"
L["Hot Lion Chops Obt"] = "L'élixir de douleur"
L["Kaldorei Spider Kabob Obt"] = "Une recette kaldorei"
L["Murloc Fin Soup Obt"] = "Criée aux poissons"
L["Redridge Goulash Obt"] = "Goulash des Carmines"
L["Roasted Moongraze Tenderloin Obt"] = "La grande chasse aux frôle-lune"
L["Seasoned Wolf Kabob Obt"] = "Kébab de loup assaisonné"
L["Smoked Desert Dumplings Obt"] = "Recette du désert"
L["Soothing Turtle Bisque Obt"] = "Bisque de tortue apaisante"
L["Strider Stew Obt"] = "Brouet de trotteur"
L["Tasty Lion Steak Obt"] = "Un problème très coûteux"
L["Thistle Tea Obt"] = "La Tour de Klaven"
L["Thistle Tea Horde Obt"] = "Mission : Possible mais non probable"
L["Westfall Stew Obt"] = "Ragoût de la marche de l'Ouest"

-- Enchanting Obtain Information
L["Enchant 2H Weapon - Major Agility Obt"] = "Porte-mort érédar"
L["Enchant 2H Weapon - Major Intellect Obt"] = "Ensorceleur cramoisi"
L["Enchant 2H Weapon - Major Spirit Obt"] = "Adepte de la Scholomance"
L["Enchant 2H Weapon - Savagery Obt"] = "Centurion de la Main brisée"
L["Enchant 2H Weapon - Superior Impact Obt"] = "Elite Main-noire"
L["Enchant Boots - Dexterity Obt"] = "Squelette déchaîné"
L["Enchant Boots - Fortitude Obt"] = "Prêtre éthérien"
L["Enchant Boots - Surefooted Obt"] = "Machiniste fantôme"
L["Enchant Bracer - Fortitude Obt"] = "Oracle de Glissecroc"
L["Enchant Bracer - Major Defense Obt"] = "Annulateur de l'Ethereum"
L["Enchant Bracer - Spellpower Obt"] = "Géomancien de la Masse-sanglante"
L["Enchant Bracer - Superior Strength Obt"] = "Démoniste de Deuillevent"
L["Enchant Cloak - Greater Arcane Resistance Obt"] = "Archimage éclipsion"
L["Enchant Cloak - Greater Shadow Resistance Obt"] = "Hurleur du Vide"
L["Enchant Cloak - Lesser Agility Obt"] = "Assassin du Syndicat"
L["Enchant Cloak - Lesser Agility Obt1"] = "Assassin Bat-le-désert, Hors-la-loi Bat-le-désert"
L["Enchant Gloves - Advanced Herbalism Obt"] = "Seigneur du bourbier, Rougeronce, Maraistreur, Ancien Maraistreur, Horreur enchevêtrée"
L["Enchant Gloves - Advanced Mining Obt"] = "Carrier de la KapitalRisk"
L["Enchant Gloves - Fishing Obt"] = "Scargil, Cours-la-côte Aileron déchiré, Oracle Aileron déchiré, Marche-boue Aileron déchiré, Chasse-marée Aileron déchiré"
L["Enchant Gloves - Herbalism Obt"] = "Ancien affolé, Ancien flétri"
L["Enchant Gloves - Herbalism Obt1"] = "Ancien vengeur, Ancien noirci, Ancien calciné"
L["Enchant Gloves - Mining Obt"] = "Nain Sombrefer, Démolisseur Sombrefer, Tunnelier Sombrefer, Saboteur Sombrefer, Balgaras le Crasseux"
L["Enchant Gloves - Skinning Obt"] = "Nimar le Pourfendeur, Berserker Fânécorce, Chasseur de têtes Fânécorce, Chasseur des ombres Fânécorce"
L["Enchant Weapon - Crusader Obt"] = "Lieur de sort écarlate"
L["Enchant Weapon - Crusader Obt1"] = "Archimage écarlate"
L["Enchant Weapon - Deathfrost Obt"] = "Seigneur Ahune - La fête du Feu"
L["Enchant Weapon - Fiery Weapon Obt"] = "Pyromancien Blé-du-savoir"
L["Enchant Weapon - Icy Chill Obt"] = "Bien-née angoissée"
L["Enchant Weapon - Lifestealing Obt"] = "Chercheur spectral"
L["Enchant Weapon - Major Intellect Obt"] = "Chercheur solfurie"
L["Enchant Weapon - Major Spellpower Obt"] = "Voleur de sort bash'ir"
L["Enchant Weapon - Superior Striking Obt"] = "Chef de guerre Pierre-du-pic"
L["Enchant Weapon - Unholy Weapon Obt"] = "Exhalombre Thuzadin"
L["Smoking Heart of the Mountain Obt"] = "Seigneur Roccor"

-- Engineering Obtain Information
L["ENG_MEMBERSHIP_BENEFITS"] = "Récompense de quête aléatoire : Renouveler sa carte de membre ingénieur"
L["Field Repair Bot 74A Obt"] = " Parchemin interactif près du boss."
L["Minor Recombobulator Obt"] = "Utiliser une Carte perforée blanche dans le Matrix Punchograph 3005-A.  Ensuite, utiliser une Carte perfoirée jaune dans le Matrix Punchograph 3005-B."
L["Discombobulator Ray Obt"] = "Utilisez une Carte d'accès aux données niveau DELTA sur la machine D."
-- Mob Drop
L["Adamantite Arrow Maker Obt"] = "Archer solfurie"
L["Arcanite Dragonling Obt"] = "Tisse-magie cobalt"
L["Dark Iron Rifle Obt"] = "Artisan Forge-ruine"
L["Felsteel Boomstick Obt"] = "Ingénieur Forge-ruine"
L["Field Repair Bot 110G Obt"] = "Analyseur gan'arg"
L["Flawless Arcanite Rifle Obt"] = "Chasseur des ténèbres Ecorchemousse"
L["Hyper-Vision Goggles Obt"] = "Fabricant d'armes mo'arg"
L["Khorium Scope Obt"] = "Franc-archer solfurie"
L["Major Recombobulator Obt"] = "Tribu des Gordok"
L["Weapon Technician"] = "Ingénieur de siège"
L["Crimson Inquisitor"] = "Inquisiteur cramoisi"
-- Quest
L["Flash Bomb Obt"] = "Recette de la bombe éclairante"
L["Steam Tonk Controller Obt"] = "40 tickets - Schéma : Commande de chariotte à vapeur"
L["Zapthrottle Mote Extractor Obt"] = "L'extracteur de granules Zappeur-Gazier !"

-- First Aid Obtain Information
-- Nothing here needed yet

-- Jewelcrafting Obtain Information
L["Blades Edge Summon Bosses"] = "Boss invoqués d'Ogri'la"
-- Mob Drop
L["Arcane Khorium Band Obt"] = "Pourfend-mage"
L["Chaotic Skyfire Diamond Obt"] = "Sirène glissentaille"
L["Coronet of the Verdant Flame Obt"] = "Botaniste Cherche-soleil"
L["Khorium Band of Frost Obt"] = "Sorcière de Glissecroc"
L["Khorium Band of Leaves Obt"] = "Aigleffroi vekh'nir"
L["Khorium Band of Shadows Obt"] = "Ténébromancien du sombre Conclave"
-- Quest

-- Leatherworking Obtain Information
-- Mob Drop
L["Bag of Many Hides Obt"] = "Brise-dos Gordunni, Casse-tête Gordunni, Elémentaliste Gordunni, Fauche-l'âme Gordunni"
L["Anvilrage Captain"] = "Capitaine Ragenclume"
L["Blue Dragonscale Shoulders Obt"] = "Brise-falaises"
L["Devilsaur Leggings Obt"] = "Limon cloné, Limon de mucus"
L["Flame Armor Kit Obt"] = "Abyssal gargantuesque"
L["Frostsaber Gloves Obt"] = "otémique Tombe-hiver"
L["Frostsaber Leggings Obt"] = "Protecteur Tombe-hiver"
L["Frostsaber Tunic Obt"] = "Ursa Tombe-hiver"
L["Green Dragonscale Leggings Obt"] = "Ver des boues"
L["Heavy Scorpid Leggings Obt"] = "Pourfendeur Rochenoire"
L["Heavy Scorpid Shoulders Obt"] = "Maître de guerre Rochenoire"
L["Heavy Scorpid Vest Obt"] = "Chercheur du portail"
L["Ironfeather Breastplate Obt"] = "Ecorcheur Vilebranche"
L["Living Breastplate Obt"] = "Horreur décomposée"
L["Living Leggings Obt"] = "Chaman Mort-bois"
L["Shadow Armor Kit Obt"] = "Ombremage perdu dans le temps"
L["Stormshroud Armor Obt"] = "Oracle Arkkoran"
L["Stormshroud Gloves Obt"] = "Le Déchirevent"
L["Stormshroud Gloves Obt1"] = "Princesse Tempestria (Berceau-de-l'Hiver)"
L["Stormshroud Shoulders Obt"] = "Fils d'Arkkoroc"
L["Stylin' Adventure Hat Obt"] = "Fusilier de Fort-de-Durn"
L["Stylin' Crimson Hat Obt"] = "Garde-corbeau Sethekk"
L["Stylin' Jungle Hat Obt"] = "Gardien des failles, Seigneur des failles"
L["Tough Scorpid Boots Obt"] = "Voleur Bat-le-désert"
L["Tough Scorpid Bracers Obt"] = "Mage de l'ombre Bat-le-désert"
L["Tough Scorpid Breastplate Obt"] = "Bandit Bat-le-désert"
L["Tough Scorpid Gloves Obt"] = "Larron Bat-le-désert"
L["Tough Scorpid Helm Obt"] = "Andre Barbe-en-feu, Hors-la-loi Bat-le-désert"
L["Tough Scorpid Leggings Obt"] = "Voleur Bat-le-désert"
L["Volcanic Breastplate Obt"] = "Grunt de Brandefeu"
L["Volcanic Leggings Obt"] = "Brute Brûlentrailles"
L["Volcanic Shoulders Obt"] = "Légionnaire de Brandefeu"
-- Quest
L["Deviate Scale Belt Obt"] = "L'éradication des déviants"
L["Kodo Hide Bag Obt"] = "Sac en peau de kodo"
L["Moonglow Vest Obt"] = "Le gilet Lueur-de-lune"
L["Onyxia Scale Cloak Obt"] = "Le voyage commence à peine après avoir rendu la Tête d'Onyxia"
L["Wild Leather Boots Obt"] = "Les bottes en cuir fauve"
L["Wild Leather Cloak Obt"] = "Maître du cuir fauve"
L["Wild Leather Helmet Obt"] = "Le casque en cuir fauve"
L["Wild Leather Leggings Obt"] = "Les jambières en cuir fauve"
L["Wild Leather Shoulders Obt"] = "Les épaulières en cuir fauve"
L["Wild Leather Vest Obt"] = "Le gilet en cuir fauve"

-- Smelting Obtain Information
L["Dark Iron Obt"] = "Nécessite 20 Barres d'or, 2 Rubis étoilé, et 10 Barres de vrai-argent - Parlez à Funéb'rel, l'un des mort-vivants dans la Tombe des invocateurs."
L["Elementium Obt"] = "Prenez le contrôle mental de Krixix à BWL. Sur sa barre de familier, une option est disponible pour apprendre cette capacité à votre cible actuelle."

-- Rogue Poison Obtain Information
-- Nothing here needed yet

-- Tailoring Obtain Information
L["Arcanoweave Boots Obt"] = "Astromage Cherche-soleil"
L["Arcanoweave Bracers Obt"] = "Sentinelle de l'Arcatraz"
L["Black Silk Pack Obt"] = "Espion du Syndicat"
L["Black Silk Pack Obt1"] = "Infiltrateur de Theramore"
L["Black Silk Pack Obt2"] = "Assassin ténébreux"
L["Cindercloth Cloak Obt"] = "Marchefeu de Thaurissan"
L["Cindercloth Gloves Obt"] = "Gardefeu du crépuscule"
L["Cindercloth Pants Obt"] = "Marchefeu de Thaurissan"
L["Cindercloth Vest Obt"] = "Gardefeu du crépuscule"
L["Cloak of Fire Obt"] = "Grand seigneur Pyron"
L["Felcloth Bag Obt"] = "Livre qui apparaît à côté du cadavre de Jandice Barov"
L["Ghostweave Belt Obt"] = "Bien-né survivant"
L["Ghostweave Gloves Obt"] = "Bien-né survivant"
L["Ghostweave Gloves Obt1"] = "Serviteur invisible"
L["Ghostweave Vest Obt"] = "Serviteur invisible"
L["Mooncloth Boots Obt"] = "Le vêtement sacré"
L["Robe of the Archmage Obt"] = "Pyromancien de Brandefeu"
L["Robe of Winter Night Obt"] = "Tisse-magie cobalt"
L["Robes of Arcana Obt"] = "Implorateur du Vide de la Rive noire"
L["Robes of Arcana Obt1"] = "Enchanteur défias"
L["Shadoweave Mask Obt"] = "Le Sous-marché"
L["Soulcloth Shoulders Obt"] = "Domestique fantôme"
L["Soulcloth Vest Obt"] = "Valet fantôme"
L["Wizardweave Leggings Obt"] = "Invocateur des ténèbres"

-- Beast Training Obtain Information
L["Rare"] = "Rare"
L["Elite"] = "Élite"
-- Beasts which have training skills
L["Agam'ar"] = "Agam'ar"
L["Aku'mai Fisher"] = "Pêcheur Aku'mai"
L["Aku'mai Snapjaw"] = "Gueule d'acier d'Aku'mai"
L["Angerclaw Mauler"] = "Marteleur de la griffe colérique"
L["Arash-ethis"] = "Arash-ethis"
L["Ashenvale Bear"] = "Ours d’Orneval"
L["Ashmane Boar"] = "Sanglier cendré"
L["Barbed Crustacean"] = "Crustacé épineux"
L["Barnabus"] = "Barnabus"
L["Battleboar"] = "Sanglier de guerre"
L["Bellygrub"] = "Fouailleventre"
L["Besseleth"] = "Besseleth"
L["Bhag'thera"] = "Bhag'thera"
L["Bjarn"] = "Bjarn"
L["Black Bear Patriarch"] = "Patriarche ours noir"
L["Black Ravager Mastiff"] = "Dogue Ravageur noir"
L["Black Ravager"] = "Ravageur noir"
L["Blackrock Worg"] = "Worg Rochenoire"
L["Blackwind Warp Chaser"] = "Poursuivant dimensionnel de Noirvent"
L["Blisterpaw Hyena"] = "Hyène Brûlepatte"
L["Bloodaxe Worg"] = "Worg Hache-sanglante"
L["Bloodfalcon"] = "Faucon de sang"
L["Bloodmaul Battle Worg"] = "Worg de guerre de la Masse-sanglante"
L["Bloodmaul Dire Wolf"] = "Loup redoutable de la Masse-sanglante"
L["Bloodsnout Worg"] = "Flaire-sang worg"
L["Bonepaw Hyena"] = "Hyène Pattes-d'os"
L["Bristleback Battleboar"] = "Sanglier de guerre Dos-hirsute"
L["Broken Tooth"] = "Brèchedent"
L["Carrion Vulture"] = "Vautour putride"
L["Cave Creeper"] = "Rampant des cavernes"
L["Chatter"] = "Cliqueteuse"
L["Clack the Reaver"] = "Clack le Saccageur"
L["Clattering Crawler"] = "Clampant cliquetant"
L["Cleft Scorpid"] = "Scorpide de la Faille"
L["Cloud Serpent"] = "Serpent-nuage"
L["Cobalt Serpent"] = "Serpent de cobalt"
L["Coilskar Cobra"] = "Cobra glissentaille"
L["Corrupted Mottled Boar"] = "Sanglier tacheté corrompu"
L["Corrupted Scorpid"] = "Scorpide corrompu"
L["Coyote Packleader"] = "Chef de meute coyote"
L["Coyote"] = "Coyote"
L["Crag Boar"] = "Sanglier des rochers"
L["Crag Coyote"] = "Coyote des rochers"
L["Crag Stalker"] = "Traqueur des combes"
L["Crazed Dragonhawk"] = "Faucon-dragon affolé"
L["Creepthess"] = "Insinueuse"
L["Dark Screecher"] = "Hurleur noir"
L["Dark Worg"] = "Worg sombre"
L["Darkfang Creeper"] = "Rampant Sombrecroc"
L["Deadly Cleft Scorpid"] = "Scorpide de la Faille mortel"
L["Deadmire"] = "Mortebourbe"
L["Death Flayer"] = "Ecorcheur mortel"
L["Death Howl"] = "Hurlemort"
L["Deathlash Scorpid"] = "Scorpide fouet-mortel"
L["Deathstrike Tarantula"] = "Tarentule mortelle"
L["Deep Stinger"] = "Dard des Abysses"
L["Deepmoss Creeper"] = "Rampant des mousses profondes"
L["Deepmoss Webspinner"] = "Tisseuse des mousses profondes"
L["Den Mother"] = "Mère de la tanière"
L["Deviate Adder"] = "Aspic déviant"
L["Deviate Coiler Hatchling"] = "Jeune embobineur déviant"
L["Deviate Coiler"] = "Embobineur déviant"
L["Deviate Crocolisk"] = "Crocilisque déviant"
L["Deviate Dreadfang"] = "Croc-d'effroi déviant"
L["Deviate Moccasin"] = "Mocassin d'eau déviant"
L["Deviate Stinglash"] = "Aiguillonneur déviant"
L["Deviate Venomwing"] = "Venimeux des airs déviant"
L["Deviate Viper"] = "Vipère déviante"
L["Dire Mottled Boar"] = "Sanglier tacheté redoutable"
L["Diseased Grizzly"] = "Grizzly malade"
L["Diseased Wolf"] = "Loup malade"
L["Dread Flyer"] = "Volant de l'effroi"
L["Dread Ripper"] = "Déchiqueteur de l’effroi"
L["Dreadfang Lurker"] = "Rôdeuse croc-d'effroi"
L["Dreadfang Widow"] = "Veuve croc-d'effroi"
L["Dreadmaw Crocolisk"] = "Crocilisque Gueule-d'effroi"
L["Drywallow Crocolisk"] = "Crocilisque Sèchefange"
L["Drywallow Daggermaw"] = "Crocs-lames Sèchefange"
L["Drywallow Snapper"] = "Mordeur Sèchefange"
L["Durotar Tiger"] = "Tigre de Durotar"
L["Eclipsion Dragonhawk"] = "Faucon-dragon éclipsion"
L["Elder Ashenvale Bear"] = "Vieil ours d’Orneval"
L["Elder Cloud Serpent"] = "Ancien serpent-nuage"
L["Elder Crag Boar"] = "Ancien sanglier des rochers"
L["Elder Crag Coyote"] = "Ancien coyote des rochers"
L["Elder Mistvale Gorilla"] = "Ancien gorille de Valbrume"
L["Elder Moss Creeper"] = "Ancienne Rampemousse"
L["Elder Mottled Boar"] = "Ancien sanglier tacheté"
L["Elder Mountain Boar"] = "Ancien sanglier des montagnes"
L["Elder Plainstrider"] = "Vieux trotteur des plaines"
L["Elder Shadowmaw Panther"] = "Ancienne panthère Ombregueule"
L["Elder Shardtooth"] = "Ancien Croc acéré"
L["Elder Springpaw"] = "Ancien Preste-patte"
L["Encrusted Surf Crawler"] = "Clampant de l'écume incrusté"
L["Enraged Ravager"] = "Ravageur enragé"
L["Felpaw Ravager"] = "Ravageur Gangrepatte"
L["Felpaw Wolf"] = "Loup Gangrepatte"
L["Felsworn Scalewing"] = "Gangrelige ailécaille"
L["Feral Crag Coyote"] = "Coyote farouche des rochers"
L["Feral Dragonhawk Hatchling"] = "Jeune faucon-dragon farouche"
L["Feral Mountain Lion"] = "Lion des montagnes farouche"
L["Ferocious Grizzled Bear"] = "Vieil ours féroce"
L["Fire Roc"] = "Roc de feu"
L["Firetail Scorpid"] = "Scorpide queue-de-feu"
L["Flatland Cougar"] = "Puma des basses plaines"
L["Fleeting Plainstrider"] = "Trotteur des plaines fugitif"
L["Forest Lurker"] = "Rôdeuse des forêts"
L["Forest Moss Creeper"] = "Rampemousse forestière"
L["Forest Spider"] = "Araignée forestière"
L["Foreststrider Fledgling"] = "Jeune trotteur des forêts"
L["Frostsaber Cub"] = "Jeune sabre-de-givre"
L["Frostsaber Huntress"] = "Chasseresse sabre-de-givre"
L["Frostsaber Stalker"] = "Traqueur sabre-de-givre"
L["Ghamoo-ra"] = "Ghamoo-ra"
L["Ghost Saber"] = "Sabre-fantôme"
L["Ghostclaw Lynx"] = "Lynx Griffe-fantôme"
L["Ghostclaw Ravager"] = "Ravageur Griffe-fantôme"
L["Ghostpaw Alpha"] = "Alpha Patte-fantôme"
L["Ghostpaw Runner"] = "Coureur Patte-fantôme"
L["Giant Foreststrider"] = "Trotteur des forêts géant"
L["Giant Moss Creeper"] = "Rampemousse géante"
L["Giant Plains Creeper"] = "Rampant des plaines géant"
L["Giant Webwood Spider"] = "Araignée Tissebois géante"
L["Giant Wetlands Crocolisk"] = "Crocilisque géant des Paluns"
L["Githyiss the Vile"] = "Githyiss la Vile"
L["Goretusk"] = "Broche-tripes"
L["Gray Bear"] = "Ours gris"
L["Gray Forest Wolf"] = "Loup forestier gris"
L["Great Goretusk"] = "Grand Broche-tripes"
L["Greater Duskbat"] = "Grande chauve-souris du crépuscule"
L["Greater Firebird"] = "Grand oiseau de feu"
L["Greater Fleshripper"] = "Grand déchireur"
L["Greater Kraul Bat"] = "Grande chauve-souris du kraal"
L["Greater Tarantula"] = "Grande tarentule"
L["Greater Thunderhawk"] = "Grand faucon-tonnerre"
L["Greater Windroc"] = "Venteroc supérieur"
L["Green Recluse"] = "Solitaire verte"
L["Groddoc Thunderer"] = "Foudroyeur Groddoc"
L["Grovestalker Lynx "] = "Lynx traquebosquet"
L["Grunter"] = "Grunter"
L["Gutripper"] = "Arrache-tripes"
L["Hakkar'i Frostwing"] = "Aile-de-givre hakkari"
L["Hakkar'i Sapper"] = "Sapeur Hakkari"
L["Ice Claw Bear"] = "Ours Griffeglace"
L["Ironback"] = "Dos-de-fer"
L["Ironbeak Hunter"] = "Chasseur Bec-de-fer"
L["Ironbeak Owl"] = "Chouette Bec-de-fer"
L["Ironbeak Screecher"] = "Hurleur Bec-de-fer"
L["Ironfur Bear"] = "Ours Ferpoil"
L["Ironfur Patriarch"] = "Patriarche Ferpoil"
L["Jaguero Stalker"] = "Traqueur jaguero"
L["Jungle Thunderer"] = "Foudroyeur de la Jungle"
L["Juvenile Snow Leopard"] = "Jeune Léopard des neiges"
L["Kaliri Matriarch"] = "Matriarche kaliri"
L["Kaliri Swooper"] = "Rapace kaliri"
L["King Bangalash"] = "Roi Bangalash"
L["Kraul Bat"] = "Chauve-souris du kraal"
L["Krellack"] = "Krellack"
L["Kresh"] = "Kresh"
L["Kurzen War Tiger"] = "Tigre de guerre de Kurzen"
L["Lady Sathrah"] = "Dame Sathrah"
L["Large Crag Boar"] = "Grand sanglier des rochers"
L["Large Loch Crocolisk"] = "Grand crocilisque du loch"
L["Leech Widow"] = "Veuve sanguine"
L["Loch Crocolisk"] = "Crocilisque du loch"
L["Longsnout"] = "Longroin"
L["Longtooth Howler"] = "Hurleur Longues-dents"
L["Longtooth Runner"] = "Messager Longues-dents"
L["Lost Torranche"] = "Torranche perdu"
L["Lupos"] = "Lupos"
L["Magram Bonepaw"] = "Pattes-d'os magram"
L["Male Kaliri Hatchling"] = "Jeune mâle kaliri"
L["Mangeclaw"] = "Griffe galeuse"
L["Mangy Mountain Boar"] = "Sanglier des montagnes galeux"
L["Mazzranache"] = "Mazzranache"
L["Mesa Buzzard"] = "Busard des mésas"
L["Mist Howler"] = "Hurleur des brumes"
L["Mistvale Gorilla"] = "Gorille de Valbrume"
L["Mongress"] = "Mongress"
L["Monstrous Crawler"] = "Clampant monstrueux"
L["Monstrous Plaguebat"] = "Chauve-souris pestiférée monstrueuse"
L["Moonstalker Runt"] = "Traquelune chétif"
L["Moonstalker Sire"] = "Géniteur traquelune"
L["Mottled Boar"] = "Sanglier tacheté"
L["Mottled Drywallow Crocolisk"] = "Crocilisque tacheté Sèchefange"
L["Mountain Boar"] = "Sanglier des montagnes"
L["Mountain Lion"] = "Lion des montagnes"
L["Mudrock Snapjaw"] = true -- ?
L["Murk Slitherer"] = "Siffleur des boues"
L["Murk Spitter"] = "Cracheur des boues"
L["Naraxis"] = true
L["Night Web Matriarch"] = true
L["Night Web Spider"] = true
L["Nightsaber"] = true
L["Noxious Plaguebat"] = true
L["Oasis Snapjaw"] = true
L["Ol' Sooty"] = true
L["Old Cliff Jumper"] = true
L["Old Grizzlegut"] = true
L["Olm the Wise"] = true
L["Ornery Plainstrider"] = true
L["Panther"] = true
L["Phoenix-Hawk Hatchling"] = true
L["Plague Lurker"] = true
L["Plaguebat"] = true
L["Plagued Swine"] = true
L["Plains Creeper"] = true
L["Porcine Entourage"] = true
L["Prairie Stalker"] = true
L["Prairie Wolf Alpha"] = true
L["Prairie Wolf"] = true
L["Princess"] = true
L["Prowler"] = true
L["Pygmy Surf Crawler"] = true
L["Quillfang Ravager"] = true
L["Quillfang Skitterer"] = true
L["Rabid Blisterpaw"] = true
L["Rabid Crag Coyote"] = true
L["Ragged Scavenger"] = true
L["Raging Agam'ar"] = true
L["Rak'Shiri"] = true
L["Ravage"] = true
L["Ravager Specimen"] = true
L["Ravenous Windroc"] = true
L["Razorfang Hatchling"] = true
L["Razzashi Adder"] = true
L["Razzashi Cobra"] = true
L["Razzashi Serpent"] = true
L["Rekk'tilac"] = true
L["Rema"] = true
L["Ridge Huntress"] = true
L["Ridge Stalker Patriarch"] = true
L["Ridge Stalker"] = true
L["Rip-Blade Ravager"] = true
L["Ripfang Lynx"] = true
L["Ripscale"] = true
L["Roc"] = true
L["Rockhide Boar"] = true
L["Rogue Vale Screecher"] = true
L["Rotting Agam'ar"] = true
L["Salt Flats Vulture"] = true
L["Saltwater Snapjaw"] = true
L["Sandfury Guardian"] = true
L["Sarkoth"] = true
L["Savannah Patriarch"] = true
L["Sawtooth Snapper"] = true
L["Scalewing Serpent"] = true
L["Scarlet Tracking Hound"] = true
L["Scarred Crag Boar"] = true
L["Scarshield Worg"] = true
L["Scorchshell Pincer"] = true
L["Scorpashi Lasher"] = true
L["Scorpashi Snapper"] = true
L["Scorpashi Venomlash"] = true
L["Scorpid Bonecrawler"] = true
L["Scorpid Duneburrower"] = true
L["Scorpid Dunestalker"] = true
L["Scorpid Hunter"] = true
L["Scorpid Reaver"] = true
L["Scorpid Tail Lasher"] = true
L["Scorpid Terror"] = true
L["Scorpid Worker"] = true
L["Scorpok Stinger"] = true
L["Searing Roc"] = true
L["Shadow Panther"] = true
L["Shadowmaw Panther"] = true
L["Shadowwing Owl"] = true
L["Shanda the Spinner"] = true
L["Shardtooth Bear"] = true
L["Shore Crawler"] = true
L["Shrike Bat"] = true
L["Silithid Creeper"] = true
L["Silithid Swarmer"] = true
L["Silt Crawler"] = true
L["Silvermane Howler"] = true
L["Silvermane Stalker"] = true
L["Silvermane Wolf"] = true
L["Sin'Dall"] = true
L["Skettis Kaliri"] = true
L["Skittering Crustacean"] = true
L["Small Crag Boar"] = true
L["Snapjaw"] = true
L["Snapping Crustacean"] = true
L["Snarler"] = true
L["Snow Tracker Wolf"] = true
L["Son of Hakkar"] = true
L["Soulflayer"] = true
L["Sparkleshell Snapper"] = true
L["Spawn of Hakkar"] = true
L["Spiteflayer"] = true
L["Spot"] = true
L["Starving Blisterpaw"] = true
L["Starving Mountain Lion"] = true
L["Starving Winter Wolf"] = true
L["Stonelash Flayer"] = true
L["Stonelash Pincer"] = true
L["Stonelash Scorpid"] = true
L["Stonetusk Boar"] = true
L["Stranglethorn Tiger"] = true
L["Strigid Hunter"] = true
L["Strigid Owl"] = true
L["Swamp Jaguar"] = true
L["Swiftwing Shredder"] = true
L["Tarantula"] = true
L["Thistle Bear"] = true
L["Thistle Boar"] = true
L["Thornfang Ravager"] = true
L["Thornfang Venomspitter"] = true
L["Thunderhawk Cloudscraper"] = true
L["Thunderhawk Hatchling"] = true
L["Tide Crawler"] = true
L["Timber Worg"] = true
L["Timber"] = true
L["Timberweb Recluse"] = true
L["Twilight Runner"] = true
L["U'cha"] = true
L["Uhk'loc"] = true
L["Un'Goro Thunderer"] = true
L["Vale Screecher"] = true
L["Venomlash Scorpid"] = true
L["Venomous Cloud Serpent"] = true
L["Venomtail Scorpid"] = true
L["Venomtip Scorpid"] = true
L["Vicious Night Web Spider"] = true
L["Vile Sting"] = true
L["Vilebranch Raiding Wolf"] = true
L["Warp Chaser"] = true
L["Warp Hunter"] = true
L["Warp Stalker"] = true
L["Washte Pawne"] = true
L["Wayward Buzzard"] = true
L["Webwood Silkspinner"] = true
L["Webwood Venomfang"] = true
L["Wildthorn Lurker"] = true
L["Windroc Hunter"] = true
L["Windroc Huntress"] = true
L["Windroc Matriarch"] = true
L["Windroc"] = true
L["Winter Wolf"] = true
L["Winterspring Owl"] = true
L["Winterspring Screecher"] = true
L["Wood Lurker"] = true
L["Worg"] = true
L["Young Forest Bear"] = true
L["Young Goretusk"] = true
L["Young Mesa Buzzard"] = true
L["Young Panther"] = true
L["Young Stranglethorn Tiger"] = true
L["Young Thistle Boar"] = true
L["Zaricotl"] = true
L["Zulian Panther"] = true
L["Zulian Stalker"] = true

-- Vendor Names
L["Aaron Hollman"] = "Aaron Hollman"
L["Abigail Shiel"] = "Abigail Shiel"
L["Aged Dalaran Wizard"] = "Sorcier de Dalaran âgé"
L["Alchemist Gribble"] = "Alchimiste Limnorie"
L["Alchemist Pestlezugg"] = "Alchimiste Pilonzugg"
L["Aldraan"] = "Aldraan"
L["Alexandra Bolero"] = "Alexandra Bolero"
L["Algernon"] = "Algernon"
L["Altaa"] = "Altaa"
L["Amy Davenport"] = "Amy Davenport"
L["Andrew Hilbert"] = "Andrew Hilbert"
L["Andrion Darkspinner"] = "Andrion Sombrefileur"
L["Androd Fadran"] = "Androd Fadran"
L["Apothecary Antonivich"] = "Apothicaire Antonivich"
L["Aresella"] = "Aresella"
L["Arras"] = "Arras"
L["Arred"] = "Arred"
L["Arrond"] = "Arrond"
L["Asarnan"] = "Asarnan"
L["Balai Lok'Wein"] = "Balai Lok'Wein"
L["Bale"] = "Bale"
L["Banalash"] = "Banalash"
L["Blimo Gadgetspring"] = "Blimo Gadgettaressort"
L["Blixrez Goodstitch"] = "Blixrez Beaupiqué"
L["Blizrik Buckshot"] = "Blizrik Chevrotine"
L["Bliztik"] = "Bliztik"
L["Bombus Finespindle"] = "Bombus Finfuseau"
L["Borto"] = "Borto"
L["Borya"] = "Borya"
L["Brienna Starglow"] = "Brienna Luisétoile"
L["Bro'kin"] = "Bro'kin"
L["Bronk"] = "Bronk"
L["Burbik Gearspanner"] = "Burbik Clépharnaüm"
L["Burko"] = "Burko"
L["Captured Gnome"] = "Gnome capturé"
L["Catherine Leland"] = "Catherine Leland"
L["Christoph Jeffcoat"] = "Christoph Jeffcoat"
L["Clyde Ranthal"] = "Clyde Ranthal"
L["Constance Brisboise"] = "Constance Brisboise"
L["Cookie McWeaksauce"] = "Cuistot McFadesauce"
L["Cookie One-Eye"] = "Qu'un-oeil le cuistot"
L["Coreiel"] = "Coreiel"
L["Corporal Bluth"] = "Caporal Bluth"
L["Cowardly Crosby"] = "Crosby La Trouille"
L["Crazk Sparks"] = "Crazk Escarbilles"
L["Cro Threadstrong"] = "Cro Fermefil"
L["Daga Ramba"] = "Daga Ramba"
L["Daggle Ironshaper"] = "Détrempe Sculptefer"
L["Dalria"] = "Dalria"
L["Daniel Bartlett"] = "Daniel Bartlett"
L["Danielle Zipstitch"] = "Danielle Vivaiguille"
L["Darian Singh"] = "Darian Singh"
L["Darnall"] = "Darnall"
L["Dealer Malij"] = "Camelot Malij"
L["Defias Profiteer"] = "Profiteur défias"
L["Deneb Walker"] = "Deneb Walker"
L["Derak Nightfall"] = "Derak Crépucule"
L["Deynna"] = "Deynna"
L["Dirge Quikcleave"] = "Dirge Hachilico"
L["Doba"] = "Doba"
L["Drac Roughcut"] = "Drac Taillebrute"
L["Drake Lindgren"] = "Drac Lindgren"
L["Drovnar Strongbrew"] = "Drovnar Fortebière"
L["Edna Mullby"] = "Edna Mullby"
L["Egomis"] = "Egomis"
L["Eiin"] = "Eiin"
L["Elynna"] = "Elynna"
L["Emrul Riknussun"] = "Emrul Riknussun"
L["Eriden"] = "Eriden"
L["Erika Tate"] = "Erika Tate"
L["Erilia"] = "Erilia"
L["Feera"] = "Feera"
L["Felannia"] = "Felannia"
L["Felicia Doan"] = "Felicia Doan"
L["Felika"] = "Felika"
L["Fradd Swiftgear"] = "Fradd Vifembraye"
L["Fyldan"] = "Fyldan"
L["Gagsprocket"] = "Muserouage"
L["Gambarinka"] = "Gambarinka"
L["Gearcutter Cogspinner"] = "Coupebraquet Tournepignon"
L["Gelanthis"] = "Gelanthis"
L["George Candarte"] = "George Candarte"
L["Gharash"] = "Gharash"
L["Ghok'kah"] = "Ghok'kah"
L["Gidge Spellweaver"] = "Gidge Tisse-sort"
L["Gigget Zipcoil"] = "Giguette Filebobine"
L["Gikkix"] = "Gikkix"
L["Gina MacGregor"] = "Gina MacGregor"
L["Gloria Femmel"] = "Gloria Femmel"
L["Glyx Brewright"] = "Glyx Bonbouilleur"
L["Gnaz Blunderflame"] = "Gnaz Bourdeflamme"
L["Gretta Ganter"] = "Gretta Ganter"
L["Grimtak"] = "Grimtak"
L["Haalrun"] = "Haalrun"
L["Haferet"] = "Haferet"
L["Hagrus"] = "Hagrus"
L["Hammon Karwn"] = "Hammon Karwn"
L["Harggan"] = "Harggan"
L["Harklan Moongrove"] = "Harklan Bosquelune"
L["Harlown Darkweave"] = "Harlown Tisselombre"
L["Harn Longcast"] = "Harn Jette-loin"
L["Haughty Modiste"] = "Hautaine Lamodiste"
L["Heldan Galesong"] = "Heldan Chantetrombe"
L["Helenia Olden"] = "Helenia Olden"
L["Himmik"] = "Himmik"
L["Hula'mahi"] = "Hula'mahi"
L["Innkeeper Biribi"] = "Aubergiste Biribi"
L["Innkeeper Fizzgrimble"] = "Aubergiste Rouspétille"
L["Innkeeper Grilka"] = "Aubergiste Grilka"
L["Jabbey"] = "Jabbey"
L["Jandia"] = "Jandia"
L["Janet Hommers"] = "Janet Hommers"
L["Jangdor Swiftstrider"] = "Jangdor Rôdeur-agile"
L["Jannos Ironwill"] = "Jannos Volonté-de-fer"
L["Jaquilina Dramet"] = "Jaquilina Dramet"
L["Jase Farlane"] = "Jase Farlane"
L["Jazzrik"] = "Jazzrik"
L["Jeeda"] = "Jeeda"
L["Jennabink Powerseam"] = "Jennabink Doublepiqûre"
L["Jessara Cordell"] = "Jessara Cordell"
L["Jim Saltit"] = "Jim Poivressel"
L["Jinky Twizzlefixxit"] = "Jinky Rafistépingle"
L["Johan Barnes"] = "Johan Barnes"
L["Joseph Moore"] = "Joseph Moore"
L["Jubie Gadgetspring"] = "Jubie Gadgettaressort"
L["Jun'ha"] = "Jun'ha"
L["Juno Dufrain"] = "Juno Dufrain"
L["Jutak"] = "Jutak"
L["Kaita Deepforge"] = "Kaita Forge-profonde"
L["Kalaen"] = "Kalaen"
L["Kalldan Felmoon"] = "Kalldan Gangrelune"
L["Kania"] = "Kania"
L["Keena"] = "Keena"
L["Kelsey Yance"] = "Kelsey Yance"
L["Kendor Kabonka"] = "Kendor Kabonka"
L["Khara Deepwater"] = "Khara Eau-profonde"
L["Kiknikle"] = "Piéniklé"
L["Killian Sanatha"] = "Killian Sanatha"
L["Kilxx"] = "Kilxx"
L["Kireena"] = "Kireena"
L["Kithas"] = "Kithas"
L["Knaz Blunderflame"] = "Knaz Bourdeflamme"
L["Kor'geld"] = "Kor'geld"
L["Krek Cragcrush"] = "Krek Cragcrush"
L["Kriggon Talsone"] = "Kriggon Talsone"
L["Krinkle Goodsteel"] = "Froisse Bonnacier"
L["Kulwia"] = "Kulwia"
L["Kzixx"] = "Kzixx"
L["Laird"] = "Laird"
L["Landraelanis"] = "Landraelanis"
L["Lardan"] = "Lardan"
L["Lebowski"] = "Lebowski"
L["Leeli Longhaggle"] = "Leeli Longnégoce"
L["Leo Sarn"] = "Leo Sarn"
L["Leonard Porter"] = "Leonard Porter"
L["Lilly"] = "Lilly"
L["Lindea Rabonne"] = "Lindea Rabonne"
L["Lizbeth Cromwell"] = "Lizbeth Cromwell"
L["Logannas"] = "Logannas"
L["Loolruna"] = "Loolruna"
L["Lorelae Wintersong"] = "Lorelae Chante-hiver"
L["Lyna"] = "Lyna"
L["Madame Ruby"] = "Madame Ruby"
L["Mahu"] = "Mahu"
L["Mallen Swain"] = "Mallen Legallant"
L["Malygen"] = "Malygen"
L["Mari Stonehand"] = "Mari Main-de-pierre"
L["Maria Lumere"] = "Maria Lumere"
L["Martine Tramblay"] = "Martine Tramblay"
L["Masat T'andr"] = "Masat T'andr"
L["Master Chef Mouldier"] = "Maître cuisinier Mouldier"
L["Mathar G'ochar"] = "Mathar G'ochar"
L["Mavralyn"] = "Mavralyn"
L["Mazk Snipeshot"] = "Mazk Tiraubut"
L["Melaris"] = "Melaris"
L["Micha Yance"] = "Micha Yance"
L["Millie Gregorian"] = "Millie Gregorian"
L["Mishta"] = "Mishta"
L["Mixie Farshot"] = "Mixie Vise-loin"
L["Montarr"] = "Montarr"
L["Muheru the Weaver"] = "Muheru le Tisserand"
L["Muuran"] = "Muuran"
L["Mythrin'dir"] = "Mythrin'dir"
L["Naal Mistrunner"] = "Naal Cours-la-brume"
L["Namdo Bizzfizzle"] = "Namdo Ventaperte"
L["Nandar Branson"] = "Nandar Branson"
L["Narkk"] = "Narkk"
L["Nasmara Moonsong"] = "Nasmara Lunechant"
L["Nata Dawnstrider"] = "Nata Aube-glorieuse"
L["Neal Allen"] = "Neal Allen"
L["Neii"] = "Neii"
L["Nergal"] = "Nergal"
L["Nerrist"] = "Nerrist"
L["Nessa Shadowsong"] = "Nessa Chantelombre"
L["Nina Lightbrew"] = "Nina Bouillelume"
L["Nioma"] = "Nioma"
L["Nula the Butcher"] = "Nula la Bouchère"
L["Nyoma"] = "Nyoma"
L["Ogg'marr"] = "Ogg'marr"
L["Otho Moji'ko"] = "Otho Moji'ko"
L["Outfitter Eric"] = "Eric le tailleur"
L["Phea"] = "Phea"
L["Plugger Spazzring"] = "Lanfiche Brouillecircuit"
L["Pratt McGrubben"] = "Pratt McGrubben"
L["Qia"] = "Qia"
L["Quartermaster Davian Vaclav"] = "Intendant Davian Vaclav"
L["Quartermaster Jaffrey Noreliqe"] = "Intendant Jaffrey Noreliqe"
L["Quelis"] = "Quelis"
L["Ranik"] = "Ranik"
L["Rann Flamespinner"] = "Rann Tisseflamme"
L["Rartar"] = "Rartar"
L["Rathis Tomber"] = "Rathis Tombal"
L["Rikqiz"] = "Rikqiz"
L["Rizz Loosebolt"] = "Rizz Court-boulon"
L["Rohok"] = "Rohok"
L["Ronald Burch"] = "Ronald Burch"
L["Rungor"] = "Rungor"
L["Ruppo Zipcoil"] = "Ruppo Filebobine"
L["Saenorion"] = "Saenorion"
L["Seer Janidi"] = "Prophète Janidi"
L["Sewa Mistrunner"] = "Sewa Cours-la-brume"
L["Shadi Mistrunner"] = "Shadi Cours-la-brume"
L["Shankys"] = "Shankys"
L["Sheendra Tallgrass"] = "Sheendra Hautes-herbes"
L["Shen'dralar Provisioner"] = "Approvisionneur Shen'dralar"
L["Sheri Zipstitch"] = "Sheri Vivaiguille"
L["Sid Limbardi"] = "Sid Limbardi"
L["Skreah"] = "Skreah"
L["Soolie Berryfizz"] = "Soolie Baiedesbulles"
L["Sovik"] = "Sovik"
L["Stuart Fleming"] = "Stuart Fleming"
L["Sumi"] = "Sumi"
L["Super-Seller 680"] = "Super-Vendeur 680"
L["Supply Officer Mills"] = "Officier de ravitaillement Mills"
L["Tamar"] = "Tamar"
L["Tansy Puddlefizz"] = "Tansy Flaquabulle"
L["Tarban Hearthgrain"] = "Tarban Blé-du-foyer"
L["Tari'qa"] = "Tari'qa"
L["Tatiana"] = "Tatiana"
L["Thaddeus Webb"] = "Thaddeus Webb"
L["Tharynn Bouden"] = "Tharynn Bouden"
L["Thomas Yance"] = "Thomas Yance"
L["Tilli Thistlefuzz"] = "Tilli Duvechardon"
L["Truk Wildbeard"] = "Truk Barbe-hirsute"
L["Tunkk"] = "Tunkk"
L["Ulthaan"] = "Ulthaan"
L["Ulthir"] = "Ulthir"
L["Uriku"] = "Uriku"
L["Uthok"] = "Uthok"
L["Vaean"] = "Vaean"
L["Valdaron"] = "Valdaron"
L["Veenix"] = "Veenix"
L["Vendor-Tron 1000"] = "Vendeur-o-tron 1000"
L["Vharr"] = "Vharr"
L["Viggz Shinesparked"] = "Viggz Fibriller"
L["Vivianna"] = "Vivianna"
L["Vizzklick"] = "Vizzklick"
L["Vodesiin"] = "Vodesiin"
L["Wenna Silkbeard"] = "Wenna Barbe-de-soie"
L["Werg Thickblade"] = "Werg Largelame"
L["Wik'Tar"] = "Wik'Tar"
L["Wind Trader Lathrai"] = "Marchand des vents Lathrai"
L["Wrahk"] = "Wrahk"
L["Wulan"] = "Wulan"
L["Wunna Darkmane"] = "Wunna Sombre-crin"
L["Xandar Goodbeard"] = "Xandar Bonnebarbe"
L["Xen'to"] = "Xen'to"
L["Xizk Goodstitch"] = "Xizk Beaupiqué"
L["Xizzer Fizzbolt"] = "Xizzer Klaqueboulon"
L["Yatheon"] = "Yatheon"
L["Yonada"] = "Yonada"
L["Yuka Screwspigot"] = "Yuka Fermevanne"
L["Yurial Soulwater"] = "Yurial Âmeflot"
L["Zan Shivsproket"] = "Zan Tympeustache"
L["Zannok Hidepiercer"] = "Zannok Percecuir"
L["Zansoa"] = "Zansoa"
L["Zaralda"] = "Zaralda"
L["Zarena Cromwind"] = "Zarena Cromwind"
L["Zixil"] = "Zixil"
L["Zorbin Fandazzle"] = "Zorbin Poudrozieu"
L["Zurai"] = "Zurai"
L["Narj Deepslice"] = "Narj Tranchefond"
L["Fazu"] = "Fazu"
L["Zargh"] = "Zargh"
L["Smudge Thunderwood"] = "Smudge Tonnebois"
L["Sassa Weldwell"] = "Sassa Belsoudure"