﻿--[[
****************************************************************************************

ARLLocals-esMX.lua

esES localization strings for Ackis Recipe List

$Date: 2008-08-25 21:00:42 +0000 (Mon, 25 Aug 2008) $
$Rev: 825 $

Original translated by: StiviS
Currently maintaince by: StiviS

Thank you all translators! (From Ackis)

Please make sure you update the ToC file with any translations.

****************************************************************************************
]]--

local L = LibStub("AceLocale-3.0"):NewLocale("Ackis Recipe List", "esMX", false)
if not L then return end

local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()

-- Addon Info
L["Version"] = "Version: "

-- Options Categories
L["Display"] = "Visualización"
L["DISPLAY_OPTIONS"] = "Opciones de Visualización"
L["DISPLAY_OPTIONS_LONG"] = "Le permite personalizar la forma en que se muestra el GUI."
L["Filter"] = "Filtrar"
L["FILTER_OPTIONS"] = "Opciones de Filtrado"
L["FILTER_OPTIONS_LONG"] = "Le permite personalizar las recetas que se filtran."
L["Reputation"] = "Reputación"
L["REP_OPTIONS"] = "Opciones de Reputación"
L["REP_OPTIONS_LONG"] = "Le permite personalizar que reputaciones se incluyen en el análisis."
L["Obtain"] = "Obtener"
L["OBTAIN_OPTIONS"] = "Opciones de Obtener"
L["OBTAIN_OPTIONS_LONG"] = "Le permite personalizar los métodos de obtención de una receta se incluyen en la exploración."
L["Sort"] = "Clasificación"
L["SORT_OPTIONS"] = "Opciones de Clasificación"
L["SORT_OPTIONS_LONG"] = "Le permite personalizar la forma en que se ordenan y se muestran la recetas que faltan."
L["Profile"] = "Perfil"

-- Display Options
L["Use GUI"] = "Utilizar el GUI"
L["GUI_TOGGLE"] = "Activar o Desactivar el uso del GUI."
L["Include Filtered"] = "Incluir filtradas"
L["FILTERCOUNT_TOGGLE"] = "Incluye recetas filtradas en el contador total de recetas."
L["Close GUI"] = "Cerrar el GUI"
L["CLOSEGUI_TOGGLE"] = "Cierra la ventana de ARL cuando la ventana de fabricación es cerrada."

-- Filtering Options
L["Faction"] = "Facción"
L["FACTION_TOGGLE"] = "Las Recetas de ambas facciones (horda y alianza) serán incluidas en la exploración."
L["Classes"] = "Clases"
L["CLASS_TOGGLE"] = "Las Recetas específicas de la clase serán incluidas en la exploración."
L["Specialities"] = "Especialidades"
L["SPECIALITY_TOGGLE"] = "Todas las especialidades de las Habilidades de Comercio serán incluidas en la exploración."
L["Skill"] = "Habilidad"
L["SKILL_TOGGLE"] = "Incluye todas las recetas, independientemente de su nivel actual de habilidad."

-- Obtain Filter Options
L["BOEFilter"] = "Se Liga al Equiparlo (LaE)"
L["BOE_TOGGLE"] = "Las recetas 'LaE' serán incluidas en la exploración."
L["BOPFilter"] = "Se Liga al Recogerlo (LaR)"
L["BOP_TOGGLE"] = "Las recetas 'LaR' serán incluidas en la exploración."
L["PVP_TOGGLE"] = "Las Recetas obtenidas de JcJ serán incluidas en la exploración."
L["RAID_TOGGLE"] = "Recetas Difíciles de obtener de Jefes (ej: "..BZ["Molten Core"]..", "..BZ["Serpentshrine Cavern"]..", etc.) serán incluidas en la exploración."
L["SEASONAL_TOGGLE"] = "Las recetas de Temporada obtenidas serán incluidas en la exploración."
L["TRAINER_TOGGLE"] = "Las recetas que se aprenden en los instructores serán incluidas en la exploración."
L["VENDOR_TOGGLE"] = "Las recetas que se compran en los vendedores serán incluidas en la exploración."
L["INSTANCE_TOGGLE"] = "Las recetas que se obtienen de las instancias serán incluidas en la exploración."
L["QUEST_TOGGLE"] = "Las recetas obtenidas como recompesa de misión serán incluidas en la exploración."
L["Cloth"] = "Tela"
L["CLOTH_TOGGLE"] = "Los patrones que hacen elementos de tela serán incluidos en la exploración."
L["Leather"] = "Cuero"
L["LEATHER_TOGGLE"] = "Los patrones que hacen elementos de cuero serán incluidos en la exploración."
L["Mail"] = "Malla"
L["MAIL_TOGGLE"] = "Los patrones que hacen elementos de malla serán incluidos en la exploración."
L["Plate"] = "Placas"
L["PLATE_TOGGLE"] = "Los patrones que hacen elementos de placas serán incluidos en la exploración."
L["Melee"] = "Cuerpo a cuerpo"
L["MELEE_TOGGLE"] = "Los patrones que se utilizan para el cuerpo a cuerpo/DPS físico serán incluidos en la exploración."
L["Caster DPS"] = "Conjurador DPS"
L["CASTERDPS_TOGGLE"] = "Los patrones que se utilizan para el Conjurador DPS serán incluidos en la exploración."
L["Tanking"] = "Tanquear"
L["TANKING_TOGGLE"] = "Los patrones que se utilizan para el tanqueo serán incluidos en la exploración."
L["Healing"] = "Curación"
L["HEALING_TOGGLE"] = "Los patrones que se utilizan para la curación serán incluidos en la exploración."

-- Sorting options
L["Name"] = "Nombre"
L["Skill"] = "Habilidad"
L["Acquisition"] = "Adquisición"

-- Reputation Toggles
L["SPECIFIC_REP_TOGGLE"] = "Incluir facción %s."

-- Non-gui text
L["MissingFromDB"] = ": no se encuentra en la base de datos.\nPor favor, informe al autor del add-on sobre esta receta."
L["MissingRecipePrefix"] = "Receta Inexistente: "
L["InitiateScan"] = "Explorando %s para recetas inexistentes del nivel %s.\n"
L["InitiateScanSpecial"] = "Explorando %s - %s para recetas inexistentes para el nivel %s.\n"
L["RecipeListSummary"] = "\nYa has aprendido %s de las %s recetas totales(%s%%).\nTe faltan %s recetas."
L["UnknownTradeSkill"] = "Tiene abierta una ventana de Habilidades de Comercio que no es soportada por este add-on.  La ventana es %s.  Por favor envíe al autor del add-on esta información."
L["OpenTradeSkillWindow"] = "Por favor abra la ventana de Habilidades de Comercio para explorar."

-- GUI Text
L["Close"] = "Cerrar"
L["ScanButton"] = "Explorar"
L["Scan Skills"] = "Explorar"
L["FILTER_OPEN"] = "Filtro >>>"
L["FILTER_CLOSE"] = "<<< Filtro"
L["Reset"] = "Reiniciar"
L["Sort"] = "Ordenar"
L["World Drop"] = "Soltado en el Mundo"
L["Mob Drop"] = "Soltado por Monstruo"
L["Quest"] = "Misión"
L["Reputation"] = "Reputación"
L["Instance"] = "Instancia"
L["BoPMenu"] = "Ligado Al Recogerlo (LaR)"
L["Horde"] = "Horda"
L["Alliance"] = "Alianza"
L["Known"] = "Conocido"
L["Unknown"] = "Desconocido"

-- Tooltip Text
L["Scan Skills Long"] = "Explorar recetas inexistentes utilizando Ackis Recipe List."
L["Close Window"] = "Cerrar la Ventana de Ackis Recipe List."
L["Expand All"] = "Expandir todas las recetas."
L["Collapse All"] = "Colapsar todas las recetas."
L["FILTER_OPEN_TT"] = "Abrir el panel de la opción del filtro."
L["FILTER_CLOSE_TT"] = "Cerrar el panel de la opción del filtro."
L["RESET_TT"] = "Restablecer la cadena de búsqueda."
L["SORT_TT"] = "Cambiar el orden de clasificación de la lista."
L["VENDOR_TT"] = "Marcar para incluir en la lista recetas de Vendedores."
L["TRAINER_TT"]= "Marcar para incluir en la lista recetas Aprendidas."
L["WORLD_TT"] = "Marcar para incluir en la lista recetas Soltadas en el Mundo."
L["MOB_TT"] = "Marcar para incluir en la lista recetas específicas Soltadas por Monstruos en el mundo."
L["QUEST_TT"] = "Marcar para incluir en la lista recetas de Recompensa de Misión."
L["SEASON_TT"] = "Marcar para incluir en la lista recetas de Temporada."
L["REP_TT"] = "Marcar para incluir en la lista recetas de Recompensa de Reputación."
L["INSTANCE_TT"] = "Marcar para incluir en la lista recetas solamente encontradas en instancias."
L["BOP_TT"] = "Marcar para ver en la lista solamente recetas que Se Ligan al Recogerlas."
L["HORDE_TT"] = "Marcar para incluir en la lista solamente recetas de la Horda."
L["ALLIANCE_TT"] = "Marcar para incluir en la lista solamente recetas de la Alianza."
L["KNOWN_TT"] = "Marcar para incluir en la lista recetas aprendidas."
L["UNKNOWN_TT"] = "Marcar para incluir en la lista recetas no aprendidas."

-- Recipe Database
Discovery = "Descubierto"
Raid = "Jefe"
L["Trainer"] = "Entrenador"
L["LimitedSupply"] = "Vendedor de Suministros Limitados"
L["Vendor"] = "Vendedor"
L["Discovery"] = Discovery
L["PVP"] = "JcJ"
L["Raid"] = Raid

--Skillup Levels
L["Journeyman"] = "Oficial"
L["Expert"] = "Experto"
L["Artisan"] = "Artesano"
L["Master"] = "Maestro"

-- Common ways to obtain recipes
L["UZD"] = "Soltado - Zona - Poco frecuente: "
L["CWD"] = "Soltado - Mundo - Común"
L["UWD"] = "Soltado - Mundo - No Común"
L["RWD"] = "Soltado - Mundo - Raro"
L["EWD"] = "Soltado - Mundo - Epico"
L["BoE"] = "Soltado - Se Liga Al Equiparlo: "
L["BoP"] = "Soltado - Se Liga Al Recogerlo: "
L["QuestReward"] = "Recompensa de Misión: "

-- Common quests/drops
QuestReward = "Recompensa de Misión: "
L["DMCACHE"] = "Caché de Knot Thimblejack"
L["Gordok Ogre Suit"] = "Conjunto del Ogro Gordok"
L["Gordok Ogre Suit Obt"] = "El conjunto del Ogro Gordok"
L["Spectral Essence Obt"] = QuestReward.."Kirtonos el Heraldo (le permite ver al vendedor Magnus Frostwake cerca de "..BZ["Scholomance"]..")"
L["TrueBelieverQuest"] = "Creyentes Verdaderos - Raro"

-- Raid Drop Obtain Info
RaidBindOnPickupDrop = "Soltado por Jefe (Se Liga al Recogerlo): "
RaidBindOnEquipDrop = "Soltado por Jefe (Se Liga al Equiparlo): "
RandomBossesIn = "Jefes Aleatorios en "
RandomBossesAndMobsIn = "Jefes y monstruos Aleatorios en "
RandomQuestReward = "Recompensa de Misión Aleatoria: "
Crafted = "Fabricado: "
Trainer = "Entrenador: "
UnknownDrop = "Soltado Desconocido: "
Mission = "Misión: "
Seasonal = "Temporada: "

L["ADNaxx"] = Trainer.."Master Craftsman Omarion en Deathknight Wing en "..BZ["Naxxramas"].."."
L["MOLTENCORE"] = RaidBindOnPickupDrop..RandomBossesIn..BZ["Molten Core"]
L["AQ20/AQ40"] = RaidBindOnPickupDrop..RandomBossesIn.."AQ20/AQ40."
L["SSC/TKBoP"] = RaidBindOnPickupDrop..RandomBossesAndMobsIn..BZ["Serpentshrine Cavern"].."/"..BZ["Tempest Keep"].."."
L["SSC/TKBoE"] = RaidBindOnEquipDrop..RandomBossesAndMobsIn..BZ["Serpentshrine Cavern"].."/"..BZ["Tempest Keep"].."."
L["BT/HYJALBoP"] = RaidBindOnPickupDrop..RandomBossesAndMobsIn..BZ["Hyjal"].."/"..BZ["Black Temple"].."."
L["HYJALBoP"] = RaidBindOnPickupDrop..RandomBossesIn..BZ["Hyjal"].."."
L["SunwellBoP"] = RaidBindOnPickupDrop..RandomBossesAndMobsIn..BZ["Sunwell Plateau"].."."
L["SunwellBoE"] = RaidBindOnEquipDrop..RandomBossesAndMobsIn..BZ["Sunwell Plateau"].."."
L["BT/HYJALBoE"] = RaidBindOnEquipDrop..RandomBossesAndMobsIn..BZ["Hyjal"].."/"..BZ["Black Temple"].."."
L["ZA"] = RaidBindOnPickupDrop..RandomBossesIn..BZ["Zul'Aman"].."."
L["Unknown"] = UnknownDrop.."La localización para obtener esta receta es desconocida.  Por favor contribuye comunicándolo en el hilo del foro de Ackis Recipe List en www.wowace.com/forums"

-- Faction info
L["WintersVeil"] = Seasonal.."Fiesta del Velo de los Inviernos"
L["Lunar Festival"] = Seasonal.."Festival Lunar"
L["Darkmoon Faire"] = "Feria de la Luna Negra"
L["Seasonal"] = "Estacional"

-- Alchemy Obtain Information
L["Discovery - Flasks/Potions"] = Discovery..": Descubierto al fabricar frascos, elixires o pociones que contienen hierbas de "..BZ["Outland"].."."
L["Discovery - Protection Potions"] = Discovery..": Descubierto al fabricar pociones de proteccion mayor."
L["Discovery - Transmutes"] = Discovery..": Descubierto al transmutar objetos que contenian materiales de "..BZ["Outland"].."."
L["Goblin Rocket Fuel Obt"] = Crafted.."Esta receta es fabricada por Ingenieros Goblin"
L["Gurubashi Mojo Madness Obt"] = Raid..": Puedes aprender esto clickeando en una mesa de piedra en "..BZ["Zul'Gurub"].." en Borde de la Locura"
L["Mighty Trolls Blood Potion Obt"] = Trainer.."Henry Stern"
-- Mob Drop
L["Elixir of Greater Firepower Obt"] = "Esclavo del Hierro Oscuro, Vigilante del Hierro Oscuro, Taskmaster del Hierro Oscuro"
L["Elixir of the Mongoose Obt"] = "Pícaro Fuego de Jade, Pícaro Legashi"
L["Elixir of the Sages Obt"] = "Scarlet Enchanter, Scarlet Cleric, Scarlet Curate, Scarlet Archmage, Scarlet Inquisitor"
L["Fel Mana Potion Obt"] = "Eclipsion Soldier, Eclipsion Bloodward, Eclipsion Blood Knight, Eclipsion Spellbinder, Eclipsion Archmage, Eclipsion Centurion, Eclipsion Cavalier, Torloth the Magnificent, Illidari Watcher"
L["Fel Regeneration Potion Obt"] = "Deathforge Imp, Deathforge Guardian, Deathforge Smith, Deathforge Tinkerer"
L["Fel Strength Elixir Obt"] = "Mo'arg Weaponsmiths, Terrormasters, Wrathwalkers, Shadow Council Warlocks"
L["Gift of Arthas Obt"] = "Skeletal Flayer, Slavering Ghoul"
L["Greater Arcane Protection Potion Obt"] = "Cobalt Mageweavers"
L["Greater Fire Protection Potion Obt"] = "Firebrand Invoker, Firebrand Pyromance"
L["Greater Frost Protection Potion Obt"] = "Frostmaul Giants"
L["Greater Nature Protection Potion Obt"] = "Decaying Horror, Rotting Behemoths"
L["Greater Shadow Protection Potion Obt"] = "Dark Adepts, Shadowmages"
L["Major Arcane Protection Potion Obt"] = "Vir'aani Arcanists"
L["Major Fire Protection Potion Obt"] = "Sunseeker Astromages"
L["Major Holy Protection Potion Obt"] = "Abyssal Flamebringers"
L["Major Shadow Protection Potion Obt"] = "Brujo del Consejo de las Sombras"
L["Mighty Rage Potion Obt"] = "Destripador Roca Negra"
L["Wildvine Potion Obt"] = "Trolls Aleatorios"
-- Quest
L["Discolored Healing Potion Obt"] = "Corazones Salvajes"
L["Elixir of Brute Force Obt"] = "Dadanga esta Hambriento (Recompensa Aleatoria)"
L["Lesser Stoneshield Potion Obt"] = "Piedra Líquida"
L["Restorative Potion Obt"] = "Funcionamiento del Reactivo "..BZ["Uldaman"]

-- Blacksmithin Obtain Information
L["Inlaid Mithril Cylinder Obt"] = Crafted.."Esta receta está fabricada por Ingenieros Gnomos"
L["Blacksmithing Plans"] = "Soltado aleatoriamente por los planes de herrería"
-- Mob Drop
L["Dark Iron Sunderer Obt"] = "Hammered Patrons, Ribbly's Crony"
L["Felsteel Gloves Obt"] = "Auchenai Monks"
L["Felsteel Helm Obt"] = "Fanático de la Cábala"
L["Felsteel Leggings Obt"] = "Unchained Doombringer"
L["Frostguard Obt"] = "Foreman Marcrid"
L["Greater Ward of Shielding Obt"] = "Bloodwatchers Furia del Sol"
L["Khorium Belt Obt"] = "Murkblood Raiders"
L["Khorium Boots Obt"] = "Disembodied Protector"
L["Khorium Pants Obt"] = "Guardián Forja Muerta"
L["Ragesteel Breastplate Obt"] = "Guerrero Lengua de ceniza"
L["Ragesteel Gloves Obt"] = "Guerrero Puño de Roca"
L["Ragesteel Helm Obt"] = "Protectores de la Cólera"
L["Ragesteel Shoulders Obt"] = "Enraged Earth Spirit, Enraged Air Spirirt, Enraged Fire Spirirt, Enraged Water Spirirt"
L["Runic Breastplate Obt"] = "Strashaz Myrmidons"
L["Runic Plate Boots Obt"] = "Hidalgo Escarlata"
L["Runic Plate Helm Obt"] = "Guerreros de Strashaz"
L["Runic Plate Leggings Obt"] = "Herrero Escarlata"
L["Runic Plate Shoulders Obt"] = "Guardias Serpiente de Strashaz"
L["Swiftsteel Gloves Obt"] = "Acechadores Nexo"
L["Volcanic Hammer Obt"] = "Volchan"
-- Quest
L["Barbaric Iron Boots Obt"] = "¡Aplástalos!"
L["Barbaric Iron Breastplate Obt"] = "Almenas barbáricas"
L["Barbaric Iron Gloves Obt"] = "Alegrías de Omosh"
L["Barbaric Iron Helm Obt"] = "Cuernos del Frenesí"
L["Barbaric Iron Shoulders Obt"] = "On Iron Pauldroms"
L["Blazing Rapier Obt"] = "Corrupción"
L["Dawn's Edge Obt"] = "Piedra culebra de la cazadora de las Sombras"
L["Demon Forged Breastplate Obt"] = "La Fragua del Demonio"
L["Enchanted Battlehammer Obt"] = "Dulce Serenidad"
L["Enchanted Thorium Breastplate Obt"] = "Malla de placas de torio encantado Vol I (Necesita objetos soltados en otras instancias para conseguir la misión)"
L["Enchanted Thorium Helm Obt"] = "Malla de placas de torio encantado Vol III (Necesita objetos soltados en otras instancias para conseguir la misión)"
L["Enchanted Thorium Leggings Obt"] = "Malla de placas de torio encantado Vol II (Necesita objetos soltados en otras instancias para conseguir la misión)"
L["Fiery Plate Gauntlets Obt"] = "Guantes Ardientes de Placas"
L["Golden Scale Gauntlets Obt"] = "Los Orígenes de Smithing"
L["Heavy Copper Longsword Obt"] = "Suministros Para el Frente"
L["Imperial Plate Belt Obt"] = "Correa de Placas imperiales"
L["Imperial Plate Boots Obt"] = "Botas de Placas imperiales"
L["Imperial Plate Bracers Obt"] = "Brazales de Placas imperiales"
L["Imperial Plate Chest Obt"] = "Pechera de Placas imperiales"
L["Imperial Plate Helm Obt"] = "Yelmo de Placas imperiales"
L["Imperial Plate Leggings Obt"] = "Piernas de Placas imperiales"
L["Imperial Plate Shoulders Obt"] = "Sobrehombros de Placas imperiales"
L["Ironforge Breastplate Obt"] = "Equipar Crestagrana"
L["Orcish War Leggings Obt"] = "Las Viejas Costumbres"
L["Ornate Mithril Gloves Obt"] = "El Gran Mentiroso de Plata"
L["Ornate Mithril Helm Obt"] = "Una Buena Cabeza Sobre Sus Hombros"
L["Ornate Mithril Pants Obt"] = "Fundir On, Fundir Off"
L["Ornate Mithril Shoulder Obt"] = "El Arte de la Impregnación"
L["Sulfuron Hammer Obt"] = "Un Contrato Obligatorio"

-- Cooking Obtain Information
L["Fishing Daily"] = QuestReward.."Recompensa al azar de la misión diaria de pesca."
L["Cooking Daily"] = QuestReward.."Recompensa al azar de la misión diaria de cocina."
L["Goldthorn Tea Obt"] = "Habla con Henry Stern en "..BZ["Razorfen Downs"]
L["Stewed Trout Obt"] = Trainer.."Kylene"
-- Mob Drop
L["Runn Tum Tuber Surprise Obt"] = "Pusillin"
-- Quest
L["Barbecued Buzzard Wing Obt"] = "Alas Asadas a la Parilla del Halcón"
L["Beer Basted Boar Ribs Obt"] = "Costillas a la Cerveza del Verraco"
L["Big Bear Steak Obt"] = "El Rescate"
L["Blood Sausage Obt"] = "Morcillas de Thelsamar"
L["Buzzard Bites Obt"] = "Suave como la Mantequilla"
L["Crocolisk Gumbo Obt"] = "Deberes del Aprendiz"
L["Crocolisk Steak Obt"] = "Caza de Crocolisk"
L["Crunchy Serpent Obt"] = "Tratados Mok'Nathal"
L["Crunchy Spider Surprise Obt"] = "Crujido Culinario"
L["Curiously Tasty Omelet Obt"] = "Venganza de Ormer"
L["Dig Rat Stew Obt"] = "Guiso de Rata Dig"
L["Dirge's Kickin' Chimaerok Chops Obt"] = "Dirge's Kickin' Chimaerok Chops"
L["Gooey Spider Cake Obt"] = "Tortas de Cangrejo Oscuras"
L["Goretusk Liver Pie Obt"] = "Empanada del Hígado de Goretusk"
L["Hot Lion Chops Obt"] = "Elixir del Dolor"
L["Kaldorei Spider Kabob Obt"] = "Receta de Kaldorei"
L["Murloc Fin Soup Obt"] = "Venta de Pescado"
L["Redridge Goulash Obt"] = "Cocido húngaro de Redridge"
L["Roasted Moongraze Tenderloin Obt"] = "La Gran Caza De Moongraze"
L["Seasoned Wolf Kabob Obt"] = "Kabobs Sazonados de Lobo"
L["Smoked Desert Dumplings Obt"] = "Receta del Desierto"
L["Soothing Turtle Bisque Obt"] = "Sopa de Mariscos Calmante de Tortuga"
L["Strider Stew Obt"] = "Easy Strider Living"
L["Tasty Lion Steak Obt"] = "Amenaza Costosa"
L["Thistle Tea Ally Obt"] = "Torre de Klaven"
L["Thistle Tea Horde Obt"] = Mission.."Posible Pero No Probable"
L["Westfall Stew Obt"] = "Guiso de "..BZ["Westfall"]

-- Enchanting Obtain Information
L["Enchant 2H Weapon - Major Agility Obt"] = "Eredar Deathbringer"
L["Enchant 2H Weapon - Major Intellect Obt"] = "Hechicero Carmesí"
L["Enchant 2H Weapon - Major Spirit Obt"] = "Adepto de "..BZ["Scholomance"]
L["Enchant 2H Weapon - Savagery Obt"] = "Shattered Hand Centurions"
L["Enchant 2H Weapon - Superior Impact Obt"] = "Blackhand Elite"
L["Enchant Boots - Dexterity Obt"] = "Raging Skeletons"
L["Enchant Boots - Fortitude Obt"] = "Sacerdote Etéreo"
L["Enchant Boots - Surefooted Obt"] = "Phantom Stagehand"
L["Enchant Bracer - Fortitude Obt"] = "Oráculos del Colmillo Torcido"
L["Enchant Bracer - Major Defense Obt"] = "Ethereum Nullifier"
L["Enchant Bracer - Spellpower Obt"] = "Bloodmaul Geomancers"
L["Enchant Bracer - Superior Strength Obt"] = "Brujo de Deadwind"
L["Enchant Cloak - Greater Arcane Resistance Obt"] = "Archimagos Eclipsion"
L["Enchant Cloak - Greater Shadow Resistance Obt"] = "Voidshriekers"
L["Enchant Cloak - Lesser Agility Obt"] = "Asesino del Sindicato"
L["Enchant Cloak - Lesser Agility Obt1"] = "Wastewander Assassin, Wastewander Scofflaw"
L["Enchant Gloves - Advanced Herbalism Obt"] = "Mire Lord, Molt Thorn, Swampwalker, Swampwalker Elder, Tangled Horror"
L["Enchant Gloves - Advanced Mining Obt"] = "Venture Co. Strip Miner"
L["Enchant Gloves - Fishing Obt"] = "Scargil, Torn Fin Coastrunner, Torn Fin Oracle, Torn Fin Muckdweller, Torn Fin Tidehunter"
L["Enchant Gloves - Herbalism Obt"] = "Crazed Ancient, Withered Ancient"
L["Enchant Gloves - Herbalism Obt1"] = "Antiguo Vengativo, Antiguo Ennegrecido, Antiguo Carbonizado"
L["Enchant Gloves - Mining Obt"] = "Dark Iron Dwarf, Dark Iron Demonlitionist, Dark Iron Tunneler, Dark Iron Saboteur, Balgaras the Foul"
L["Enchant Gloves - Skinning Obt"] = "Nimar the Slayer, Witherbark Berserker, Witherbark Headhunter, Witherbark Shadow Hunter"
L["Enchant Weapon - Crusader Obt"] = "Scarlet Spellbinder"
L["Enchant Weapon - Crusader Obt1"] = "Archimago Escarlata"
L["Enchant Weapon - Deathfrost Obt"] = "Lord Ahune - Midsummer Fire Festival"
L["Enchant Weapon - Fiery Weapon Obt"] = "Pyromancer Loregrain"
L["Enchant Weapon - Icy Chill Obt"] = "Anguished Highborne"
L["Enchant Weapon - Lifestealing Obt"] = "Investigador Espectral"
L["Enchant Weapon - Major Intellect Obt"] = "Researchers Furia del Sol"
L["Enchant Weapon - Major Spellpower Obt"] = "Bash'ir Spell-Thief"
L["Enchant Weapon - Superior Striking Obt"] = "Spirestone Warlord"
L["Enchant Weapon - Unholy Weapon Obt"] = "Thuzadin Shadowcaster"
L["Smoking Heart of the Mountain Obt"] = "Señor Roccor"

-- Engineering Obtain Information
L["ENG_MEMBERSHIP_BENEFITS"] = RandomQuestReward.."Renovación de Miembro"
L["Field Repair Bot 74A Obt"] = "Manuscrito clickeable cerca del Jefe"
L["Minor Recombobulator Obt"] = "Utilice la Tarjeta Blanca en la ranura de Matrix Punchograph 3005-A.  A continuación, utilice la Tarjeta Amarilla en Perforágrafo Matriz 3005-B."
L["Discombobulator Ray Obt"] = "Utilice la Tarjeta de Seguridad de Acceso de Datos DELTA en la máquina D"
-- Mob Drop
L["Adamantite Arrow Maker Obt"] = "Arquero de Furia del Sol"
L["Arcanite Dragonling Obt"] = "Tejemagia de cobalto"
L["Dark Iron Rifle Obt"] = "Artesano de la Forja Maldita"
L["Felsteel Boomstick Obt"] = "Ingeniero de la Forja Maldita"
L["Field Repair Bot 110G Obt"] = "Analizadores de Gan'Arg"
L["Flawless Arcanite Rifle Obt"] = "Cazasombras Fustamusgo"
L["Hyper-Vision Goggles Obt"] = "Forjador de armas Mo'arg"
L["Khorium Scope Obt"] = "Arquero de Furia del Sol"
L["Major Recombobulator Obt"] = " Tribute Run Chest"
L["Weapon Technician"] = "Técnico de Armas"
L["Crimson Inquisitor"] = "Inquisidor Carmesí"
-- Quest
L["Flash Bomb Obt"] = "Receta de Bomba Cegadora"
L["Steam Tonk Controller Obt"] = "40 Boletos - Esquema: Mando de tonque de vapor"
L["Zapthrottle Mote Extractor Obt"] = "¡Extractor de motas de zapacelerador!"

-- First Aid Obtain Information
-- Nothing here needed yet

-- Jewelcrafting Obtain Information
L["Blades Edge Summon Bosses"] = "Invoca Jefes en Filospada"
-- Mob Drop
L["Arcane Khorium Band Obt"] = "Mageslayers"
L["Chaotic Skyfire Diamond Obt"] = "Coilskar Sirens"
L["Coronet of the Verdant Flame Obt"] = "Sunseeker Botanists"
L["Khorium Band of Frost Obt"] = "Coilfang Sorceresses"
L["Khorium Band of Leaves Obt"] = "Vekh'nir Dreadhawks"
L["Khorium Band of Shadows Obt"] = "Dark Conclave Shadowmancers"
-- Quest

-- Leatheworking Obtain Information
-- Mob Drop
L["Bag of Many Hides Obt"] = "Gordunni Back-Breaker, Gordunni Head-Splitter, Gordunni Elementalist, Gordunni Soulreaper"
L["Anvilrage Captain"] = "Anvilrage Captain"
L["Blue Dragonscale Shoulders Obt"] = "Cliff Breaker"
L["Devilsaur Leggings Obt"] = "Cloned Ooze, Muculent Ooze"
L["Flame Armor Kit Obt"] = "Gargantuan Abyssals"
L["Frostsaber Gloves Obt"] = "Winterfall Totemic"
L["Frostsaber Leggings Obt"] = "Winterfall Den Watcher"
L["Frostsaber Tunic Obt"] = "Winterfall Ursa"
L["Green Dragonscale Leggings Obt"] = "Murk Worm"
L["Heavy Scorpid Leggings Obt"] = "Asesino de la Roca Negra"
L["Heavy Scorpid Shoulders Obt"] = "Blackrock Battlemaster"
L["Heavy Scorpid Vest Obt"] = "Portal Seeker"
L["Ironfeather Breastplate Obt"] = "Vilebranch Hideskinner"
L["Living Breastplate Obt"] = "Decaying Horror"
L["Living Leggings Obt"] = "Deadwood Shaman"
L["Shadow Armor Kit Obt"] = "Time-Lost Shadowmages"
L["Stormshroud Armor Obt"] = "Arkkoran Oracle"
L["Stormshroud Gloves Obt"] = "The Windreaver"
L["Stormshroud Gloves Obt1"] = "Princess Tempestria, Winterspring"
L["Stormshroud Shoulders Obt"] = "Son of Arkkoroc"
L["Stylin' Adventure Hat Obt"] = "Durnholde Riflemen"
L["Stylin' Crimson Hat Obt"] = "Sethekk Ravenguard"
L["Stylin' Jungle Hat Obt"] = "Rift Lords, Rift Keepers"
L["Tough Scorpid Boots Obt"] = "Wastewander Rogue"
L["Tough Scorpid Bracers Obt"] = "Wastewander Shadow Mage"
L["Tough Scorpid Breastplate Obt"] = "Wastewander Bandit"
L["Tough Scorpid Gloves Obt"] = "Wastewander Thief"
L["Tough Scorpid Helm Obt"] = "Andre Firebeard, Wastewander Scofflaw"
L["Tough Scorpid Leggings Obt"] = "Pícaro Deambulador"
L["Volcanic Breastplate Obt"] = "Bruto Pirotigma"
L["Volcanic Leggings Obt"] = "Tosco Pirontraña"
L["Volcanic Shoulders Obt"] = "Legionario Pirotigma"
-- Quest
L["Deviate Scale Belt Obt"] = "Erradicación de Descarriados"
L["Kodo Hide Bag Obt"] = "Bolsa de pellejo de Kodo"
L["Moonglow Vest Obt"] = "Jubón resplandor lunar"
L["Onyxia Scale Cloak Obt"] = "El Viaje Acaba de Empezar después de dar la vuelta a la Cabeza de Onyxia"
L["Wild Leather Boots Obt"] = "Botas de Cuero Salvaje"
L["Wild Leather Cloak Obt"] = "Maestro de Cuero Salvaje"
L["Wild Leather Helmet Obt"] = "Casco de Cuero Salvaje"
L["Wild Leather Leggings Obt"] = "Leotardos de Cuero Salvaje"
L["Wild Leather Shoulders Obt"] = "Sobrehombros de Cuero Salvaje"
L["Wild Leather Vest Obt"] = "Jubón de Cuero Salvaje"

-- Smelting Obtain Information
L["Dark Iron Obt"] = "Requiere 20 Barras de Oro, 2 Rubies estrella, y 10 Barras de Veraplata - Habla con Gloom'Rel, que es uno de los no-muertos en Summoner's Tomb."
L["Elementium Obt"] = "Control mental Krixix en BWL.  En la barra de mascota habrá una opción para entrenar esta habilidad para ti y los demás."

-- Rogue Poison Obtain Information
-- Nothing here needed yet

-- Tailoring Obtain Information
L["Arcanoweave Boots Obt"] = "Astromago Buscasol"
L["Arcanoweave Bracers Obt"] = "Centinelas de Alcatraz"
L["Black Silk Pack Obt"] = "Espía del Sindicato"
L["Black Silk Pack Obt1"] = "Infiltrado de Theramore"
L["Black Silk Pack Obt2"] = "Asesino de las Sombras"
L["Cindercloth Cloak Obt"] = "Caminafuego Thaurissan"
L["Cindercloth Gloves Obt"] = "Protector Crepuscular de Fuego"
L["Cindercloth Pants Obt"] = "Caminafuego Thaurissan"
L["Cindercloth Vest Obt"] = "Protector Crepuscular de Fuego"
L["Cloak of Fire Obt"] = "Maestro Supremo Pyron"
L["Felcloth Bag Obt"] = "Libro que aparece después de la muerte de Jandice Barov"
L["Ghostweave Belt Obt"] = "Altonato persistente"
L["Ghostweave Gloves Obt"] = "Altonato persistente"
L["Ghostweave Gloves Obt1"] = "Siervo No Visto"
L["Ghostweave Vest Obt"] = "Siervo No Visto"
L["Mooncloth Boots Obt"] = "Tela Sagrada"
L["Robe of the Archmage Obt"] = "Piromántico Pirotigma"
L["Robe of Winter Night Obt"] = "Tejemagia de cobalto"
L["Robes of Arcana Obt"] = "Clamavacío de la Facción Oscura"
L["Robes of Arcana Obt1"] = "Encantador Defias"
L["Shadoweave Mask Obt"] = "The Undermarket"
L["Soulcloth Shoulders Obt"] = "Asistentes Fantasmas"
L["Soulcloth Vest Obt"] = "Aparición de ayuda de cámara"
L["Wizardweave Leggings Obt"] = "Invocador Oscuro"

-- Beast Training Obtain Information
L["Rare"] = "Raro"
L["Elite"] = "Elite"
-- Beasts which have training skills
L["Agam'ar"] = true
L["Aku'mai Fisher"] = true
L["Aku'mai Snapjaw"] = true
L["Angerclaw Mauler"] = true
L["Arash-ethis"] = true
L["Ashenvale Bear"] = true
L["Ashmane Boar"] = true
L["Barbed Crustacean"] = true
L["Barnabus"] = true
L["Battleboar"] = true
L["Bellygrub"] = true
L["Besseleth"] = true
L["Bhag'thera"] = true
L["Bjarn"] = true
L["Black Bear Patriarch"] = true
L["Black Ravager Mastiff"] = true
L["Black Ravager"] = true
L["Blackrock Worg"] = true
L["Blackwind Warp Chaser"] = true
L["Blisterpaw Hyena"] = true
L["Bloodaxe Worg"] = true
L["Bloodfalcon"] = true
L["Bloodmaul Battle Worg"] = true
L["Bloodmaul Dire Wolf"] = true
L["Bloodsnout Worg"] = true
L["Bonepaw Hyena"] = true
L["Bristleback Battleboar"] = true
L["Broken Tooth"] = true
L["Carrion Vulture"] = true
L["Cave Creeper"] = true
L["Chatter"] = true
L["Clack the Reaver"] = true
L["Clattering Crawler"] = true
L["Cleft Scorpid"] = true
L["Cloud Serpent"] = true
L["Cobalt Serpent"] = true
L["Coilskar Cobra"] = true
L["Corrupted Mottled Boar"] = true
L["Corrupted Scorpid"] = true
L["Coyote Packleader"] = true
L["Coyote"] = true
L["Crag Boar"] = true
L["Crag Coyote"] = true
L["Crag Stalker"] = true
L["Crazed Dragonhawk"] = true
L["Creepthess"] = true
L["Dark Screecher"] = true
L["Dark Worg"] = true
L["Darkfang Creeper"] = true
L["Deadly Cleft Scorpid"] = true
L["Deadmire"] = true
L["Death Flayer"] = true
L["Death Howl"] = true
L["Deathlash Scorpid"] = true
L["Deathstrike Tarantula"] = true
L["Deep Stinger"] = true
L["Deepmoss Creeper"] = true
L["Deepmoss Webspinner"] = true
L["Den Mother"] = true
L["Deviate Adder"] = true
L["Deviate Coiler Hatchling"] = true
L["Deviate Coiler"] = true
L["Deviate Crocolisk"] = true
L["Deviate Dreadfang"] = true
L["Deviate Moccasin"] = true
L["Deviate Stinglash"] = true
L["Deviate Venomwing"] = true
L["Deviate Viper"] = true
L["Dire Mottled Boar"] = true
L["Diseased Grizzly"] = true
L["Diseased Wolf"] = true
L["Dread Flyer"] = true
L["Dread Ripper"] = true
L["Dreadfang Lurker"] = true
L["Dreadfang Widow"] = true
L["Dreadmaw Crocolisk"] = true
L["Drywallow Crocolisk"] = true
L["Drywallow Daggermaw"] = true
L["Drywallow Snapper"] = true
L["Durotar Tiger"] = true
L["Eclipsion Dragonhawk"] = true
L["Elder Ashenvale Bear"] = true
L["Elder Cloud Serpent"] = true
L["Elder Crag Boar"] = true
L["Elder Crag Coyote"] = true
L["Elder Mistvale Gorilla"] = true
L["Elder Moss Creeper"] = true
L["Elder Mottled Boar"] = true
L["Elder Mountain Boar"] = true
L["Elder Plainstrider"] = true
L["Elder Shadowmaw Panther"] = true
L["Elder Shardtooth"] = true
L["Elder Springpaw"] = true
L["Encrusted Surf Crawler"] = true
L["Enraged Ravager"] = true
L["Felpaw Ravager"] = true
L["Felpaw Wolf"] = true
L["Felsworn Scalewing"] = true
L["Feral Crag Coyote"] = true
L["Feral Dragonhawk Hatchling"] = true
L["Feral Mountain Lion"] = true
L["Ferocious Grizzled Bear"] = true
L["Fire Roc"] = true
L["Firetail Scorpid"] = true
L["Flatland Cougar"] = true
L["Fleeting Plainstrider"] = true
L["Forest Lurker"] = true
L["Forest Moss Creeper"] = true
L["Forest Spider"] = true
L["Foreststrider Fledgling"] = true
L["Frostsaber Cub"] = true
L["Frostsaber Huntress"] = true
L["Frostsaber Stalker"] = true
L["Ghamoo-ra"] = true
L["Ghost Saber"] = true
L["Ghostclaw Lynx"] = true
L["Ghostclaw Ravager"] = true
L["Ghostpaw Alpha"] = true
L["Ghostpaw Runner"] = true
L["Giant Foreststrider"] = true
L["Giant Moss Creeper"] = true
L["Giant Plains Creeper"] = true
L["Giant Webwood Spider"] = true
L["Giant Wetlands Crocolisk"] = true
L["Githyiss the Vile"] = true
L["Goretusk"] = true
L["Gray Bear"] = true
L["Gray Forest Wolf"] = true
L["Great Goretusk"] = true
L["Greater Duskbat"] = true
L["Greater Firebird"] = true
L["Greater Fleshripper"] = true
L["Greater Kraul Bat"] = true
L["Greater Tarantula"] = true
L["Greater Thunderhawk"] = true
L["Greater Windroc"] = true
L["Green Recluse"] = true
L["Groddoc Thunderer"] = true
L["Grovestalker Lynx "] = true
L["Grunter"] = true
L["Gutripper"] = true
L["Hakkar'i Frostwing"] = true
L["Hakkar'i Sapper"] = true
L["Ice Claw Bear"] = true
L["Ironback"] = true
L["Ironbeak Hunter"] = true
L["Ironbeak Owl"] = true
L["Ironbeak Screecher"] = true
L["Ironfur Bear"] = true
L["Ironfur Patriarch"] = true
L["Jaguero Stalker"] = true
L["Jungle Thunderer"] = true
L["Juvenile Snow Leopard"] = true
L["Kaliri Matriarch"] = true
L["Kaliri Swooper"] = true
L["King Bangalash"] = true
L["Kraul Bat"] = true
L["Krellack"] = true
L["Kresh"] = true
L["Kurzen War Tiger"] = true
L["Lady Sathrah"] = true
L["Large Crag Boar"] = true
L["Large Loch Crocolisk"] = true
L["Leech Widow"] = true
L["Loch Crocolisk"] = true
L["Longsnout"] = true
L["Longtooth Howler"] = true
L["Longtooth Runner"] = true
L["Lost Torranche"] = true
L["Lupos"] = true
L["Magram Bonepaw"] = true
L["Male Kaliri Hatchling"] = true
L["Mangeclaw"] = true
L["Mangy Mountain Boar"] = true
L["Mazzranache"] = true
L["Mesa Buzzard"] = true
L["Mist Howler"] = true
L["Mistvale Gorilla"] = true
L["Mongress"] = true
L["Monstrous Crawler"] = true
L["Monstrous Plaguebat"] = true
L["Moonstalker Runt"] = true
L["Moonstalker Sire"] = true
L["Mottled Boar"] = true
L["Mottled Drywallow Crocolisk"] = true
L["Mountain Boar"] = true
L["Mountain Lion"] = true
L["Mudrock Snapjaw"] = true
L["Murk Slitherer"] = true
L["Murk Spitter"] = true
L["Naraxis"] = true
L["Night Web Matriarch"] = true
L["Night Web Spider"] = true
L["Nightsaber"] = true
L["Noxious Plaguebat"] = true
L["Oasis Snapjaw"] = true
L["Ol' Sooty"] = true
L["Old Cliff Jumper"] = true
L["Old Grizzlegut"] = true
L["Olm the Wise"] = true
L["Ornery Plainstrider"] = true
L["Panther"] = true
L["Phoenix-Hawk Hatchling"] = true
L["Plague Lurker"] = true
L["Plaguebat"] = true
L["Plagued Swine"] = true
L["Plains Creeper"] = true
L["Porcine Entourage"] = true
L["Prairie Stalker"] = true
L["Prairie Wolf Alpha"] = true
L["Prairie Wolf"] = true
L["Princess"] = true
L["Prowler"] = true
L["Pygmy Surf Crawler"] = true
L["Quillfang Ravager"] = true
L["Quillfang Skitterer"] = true
L["Rabid Blisterpaw"] = true
L["Rabid Crag Coyote"] = true
L["Ragged Scavenger"] = true
L["Raging Agam'ar"] = true
L["Rak'Shiri"] = true
L["Ravage"] = true
L["Ravager Specimen"] = true
L["Ravenous Windroc"] = true
L["Razorfang Hatchling"] = true
L["Razzashi Adder"] = true
L["Razzashi Cobra"] = true
L["Razzashi Serpent"] = true
L["Rekk'tilac"] = true
L["Rema"] = true
L["Ridge Huntress"] = true
L["Ridge Stalker Patriarch"] = true
L["Ridge Stalker"] = true
L["Rip-Blade Ravager"] = true
L["Ripfang Lynx"] = true
L["Ripscale"] = true
L["Roc"] = true
L["Rockhide Boar"] = true
L["Rogue Vale Screecher"] = true
L["Rotting Agam'ar"] = true
L["Salt Flats Vulture"] = true
L["Saltwater Snapjaw"] = true
L["Sandfury Guardian"] = true
L["Sarkoth"] = true
L["Savannah Patriarch"] = true
L["Sawtooth Snapper"] = true
L["Scalewing Serpent"] = true
L["Scarlet Tracking Hound"] = true
L["Scarred Crag Boar"] = true
L["Scarshield Worg"] = true
L["Scorchshell Pincer"] = true
L["Scorpashi Lasher"] = true
L["Scorpashi Snapper"] = true
L["Scorpashi Venomlash"] = true
L["Scorpid Bonecrawler"] = true
L["Scorpid Duneburrower"] = true
L["Scorpid Dunestalker"] = true
L["Scorpid Hunter"] = true
L["Scorpid Reaver"] = true
L["Scorpid Tail Lasher"] = true
L["Scorpid Terror"] = true
L["Scorpid Worker"] = true
L["Scorpok Stinger"] = true
L["Searing Roc"] = true
L["Shadow Panther"] = true
L["Shadowmaw Panther"] = true
L["Shadowwing Owl"] = true
L["Shanda the Spinner"] = true
L["Shardtooth Bear"] = true
L["Shore Crawler"] = true
L["Shrike Bat"] = true
L["Silithid Creeper"] = true
L["Silithid Swarmer"] = true
L["Silt Crawler"] = true
L["Silvermane Howler"] = true
L["Silvermane Stalker"] = true
L["Silvermane Wolf"] = true
L["Sin'Dall"] = true
L["Skettis Kaliri"] = true
L["Skittering Crustacean"] = true
L["Small Crag Boar"] = true
L["Snapjaw"] = true
L["Snapping Crustacean"] = true
L["Snarler"] = true
L["Snow Tracker Wolf"] = true
L["Son of Hakkar"] = true
L["Soulflayer"] = true
L["Sparkleshell Snapper"] = true
L["Spawn of Hakkar"] = true
L["Spiteflayer"] = true
L["Spot"] = true
L["Starving Blisterpaw"] = true
L["Starving Mountain Lion"] = true
L["Starving Winter Wolf"] = true
L["Stonelash Flayer"] = true
L["Stonelash Pincer"] = true
L["Stonelash Scorpid"] = true
L["Stonetusk Boar"] = true
L["Stranglethorn Tiger"] = true
L["Strigid Hunter"] = true
L["Strigid Owl"] = true
L["Swamp Jaguar"] = true
L["Swiftwing Shredder"] = true
L["Tarantula"] = true
L["Thistle Bear"] = true
L["Thistle Boar"] = true
L["Thornfang Ravager"] = true
L["Thornfang Venomspitter"] = true
L["Thunderhawk Cloudscraper"] = true
L["Thunderhawk Hatchling"] = true
L["Tide Crawler"] = true
L["Timber Worg"] = true
L["Timber"] = true
L["Timberweb Recluse"] = true
L["Twilight Runner"] = true
L["U'cha"] = true
L["Uhk'loc"] = true
L["Un'Goro Thunderer"] = true
L["Vale Screecher"] = true
L["Venomlash Scorpid"] = true
L["Venomous Cloud Serpent"] = true
L["Venomtail Scorpid"] = true
L["Venomtip Scorpid"] = true
L["Vicious Night Web Spider"] = true
L["Vile Sting"] = true
L["Vilebranch Raiding Wolf"] = true
L["Warp Chaser"] = true
L["Warp Hunter"] = true
L["Warp Stalker"] = true
L["Washte Pawne"] = true
L["Wayward Buzzard"] = true
L["Webwood Silkspinner"] = true
L["Webwood Venomfang"] = true
L["Wildthorn Lurker"] = true
L["Windroc Hunter"] = true
L["Windroc Huntress"] = true
L["Windroc Matriarch"] = true
L["Windroc"] = true
L["Winter Wolf"] = true
L["Winterspring Owl"] = true
L["Winterspring Screecher"] = true
L["Wood Lurker"] = true
L["Worg"] = true
L["Young Forest Bear"] = true
L["Young Goretusk"] = true
L["Young Mesa Buzzard"] = true
L["Young Panther"] = true
L["Young Stranglethorn Tiger"] = true
L["Young Thistle Boar"] = true
L["Zaricotl"] = true
L["Zulian Panther"] = true
L["Zulian Stalker"] = true

-- Vendor Names
L["Aaron Hollman"] = true
L["Abigail Shiel"] = true
L["Aged Dalaran Wizard"] = true
L["Alchemist Gribble"] = true
L["Alchemist Pestlezugg"] = true
L["Aldraan"] = true
L["Alexandra Bolero"] = true
L["Algernon"] = true
L["Altaa"] = true
L["Amy Davenport"] = true
L["Andrew Hilbert"] = true
L["Andrion Darkspinner"] = true
L["Androd Fadran"] = true
L["Apothecary Antonivich"] = true
L["Aresella"] = true
L["Arras"] = true
L["Arred"] = true
L["Arrond"] = true
L["Asarnan"] = true
L["Balai Lok'Wein"] = true
L["Bale"] = true
L["Banalash"] = true
L["Blimo Gadgetspring"] = true
L["Blixrez Goodstitch"] = true
L["Blizrik Buckshot"] = true
L["Bliztik"] = true
L["Bombus Finespindle"] = true
L["Borto"] = true
L["Borya"] = true
L["Brienna Starglow"] = true
L["Bro'kin"] = true
L["Bronk"] = true
L["Burbik Gearspanner"] = true
L["Burko"] = true
L["Captured Gnome"] = true
L["Catherine Leland"] = true
L["Christoph Jeffcoat"] = true
L["Clyde Ranthal"] = true
L["Constance Brisboise"] = true
L["Cookie McWeaksauce"] = true
L["Cookie One-Eye"] = true
L["Coreiel"] = true
L["Corporal Bluth"] = true
L["Cowardly Crosby"] = true
L["Crazk Sparks"] = true
L["Cro Threadstrong"] = true
L["Daga Ramba"] = true
L["Daggle Ironshaper"] = true
L["Dalria"] = true
L["Daniel Bartlett"] = true
L["Danielle Zipstitch"] = true
L["Darian Singh"] = true
L["Darnall"] = true
L["Dealer Malij"] = true
L["Defias Profiteer"] = true
L["Deneb Walker"] = true
L["Derak Nightfall"] = true
L["Deynna"] = true
L["Dirge Quikcleave"] = true
L["Doba"] = true
L["Drac Roughcut"] = true
L["Drake Lindgren"] = true
L["Drovnar Strongbrew"] = true
L["Edna Mullby"] = true
L["Egomis"] = true
L["Eiin"] = true
L["Elynna"] = true
L["Emrul Riknussun"] = true
L["Eriden"] = true
L["Erika Tate"] = true
L["Erilia"] = true
L["Feera"] = true
L["Felannia"] = true
L["Felicia Doan"] = true
L["Felika"] = true
L["Fradd Swiftgear"] = true
L["Fyldan"] = true
L["Gagsprocket"] = true
L["Gambarinka"] = true
L["Gearcutter Cogspinner"] = true
L["Gelanthis"] = true
L["George Candarte"] = true
L["Gharash"] = true
L["Ghok'kah"] = true
L["Gidge Spellweaver"] = true
L["Gigget Zipcoil"] = true
L["Gikkix"] = true
L["Gina MacGregor"] = true
L["Gloria Femmel"] = true
L["Glyx Brewright"] = true
L["Gnaz Blunderflame"] = true
L["Gretta Ganter"] = true
L["Grimtak"] = true
L["Haalrun"] = true
L["Haferet"] = true
L["Hagrus"] = true
L["Hammon Karwn"] = true
L["Harggan"] = true
L["Harklan Moongrove"] = true
L["Harlown Darkweave"] = true
L["Harn Longcast"] = true
L["Haughty Modiste"] = true
L["Heldan Galesong"] = true
L["Helenia Olden"] = true
L["Himmik"] = true
L["Hula'mahi"] = true
L["Innkeeper Biribi"] = true
L["Innkeeper Fizzgrimble"] = true
L["Innkeeper Grilka"] = true
L["Jabbey"] = true
L["Jandia"] = true
L["Janet Hommers"] = true
L["Jangdor Swiftstrider"] = true
L["Jannos Ironwill"] = true
L["Jaquilina Dramet"] = true
L["Jase Farlane"] = true
L["Jazzrik"] = true
L["Jeeda"] = true
L["Jennabink Powerseam"] = true
L["Jessara Cordell"] = true
L["Jim Saltit"] = true
L["Jinky Twizzlefixxit"] = true
L["Johan Barnes"] = true
L["Joseph Moore"] = true
L["Jubie Gadgetspring"] = true
L["Jun'ha"] = true
L["Juno Dufrain"] = true
L["Jutak"] = true
L["Kaita Deepforge"] = true
L["Kalaen"] = true
L["Kalldan Felmoon"] = true
L["Kania"] = true
L["Keena"] = true
L["Kelsey Yance"] = true
L["Kendor Kabonka"] = true
L["Khara Deepwater"] = true
L["Kiknikle"] = true
L["Killian Sanatha"] = true
L["Kilxx"] = true
L["Kireena"] = true
L["Kithas"] = true
L["Knaz Blunderflame"] = true
L["Kor'geld"] = true
L["Krek Cragcrush"] = true
L["Kriggon Talsone"] = true
L["Krinkle Goodsteel"] = true
L["Kulwia"] = true
L["Kzixx"] = true
L["Laird"] = true
L["Landraelanis"] = true
L["Lardan"] = true
L["Lebowski"] = true
L["Leeli Longhaggle"] = true
L["Leo Sarn"] = true
L["Leonard Porter"] = true
L["Lilly"] = true
L["Lindea Rabonne"] = true
L["Lizbeth Cromwell"] = true
L["Logannas"] = true
L["Loolruna"] = true
L["Lorelae Wintersong"] = true
L["Lyna"] = true
L["Madame Ruby"] = true
L["Mahu"] = true
L["Mallen Swain"] = true
L["Malygen"] = true
L["Mari Stonehand"] = true
L["Maria Lumere"] = true
L["Martine Tramblay"] = true
L["Masat T'andr"] = true
L["Master Chef Mouldier"] = true
L["Mathar G'ochar"] = true
L["Mavralyn"] = true
L["Mazk Snipeshot"] = true
L["Melaris"] = true
L["Micha Yance"] = true
L["Millie Gregorian"] = true
L["Mishta"] = true
L["Mixie Farshot"] = true
L["Montarr"] = true
L["Muheru the Weaver"] = true
L["Muuran"] = true
L["Mythrin'dir"] = true
L["Naal Mistrunner"] = true
L["Namdo Bizzfizzle"] = true
L["Nandar Branson"] = true
L["Narkk"] = true
L["Nasmara Moonsong"] = true
L["Nata Dawnstrider"] = true
L["Neal Allen"] = true
L["Neii"] = true
L["Nergal"] = true
L["Nerrist"] = true
L["Nessa Shadowsong"] = true
L["Nina Lightbrew"] = true
L["Nioma"] = true
L["Nula the Butcher"] = true
L["Nyoma"] = true
L["Ogg'marr"] = true
L["Otho Moji'ko"] = true
L["Outfitter Eric"] = true
L["Phea"] = true
L["Plugger Spazzring"] = true
L["Pratt McGrubben"] = true
L["Qia"] = true
L["Quartermaster Davian Vaclav"] = true
L["Quartermaster Jaffrey Noreliqe"] = true
L["Quelis"] = true
L["Ranik"] = true
L["Rann Flamespinner"] = true
L["Rartar"] = true
L["Rathis Tomber"] = true
L["Rikqiz"] = true
L["Rizz Loosebolt"] = true
L["Rohok"] = true
L["Ronald Burch"] = true
L["Rungor"] = true
L["Ruppo Zipcoil"] = true
L["Saenorion"] = true
L["Seer Janidi"] = true
L["Sewa Mistrunner"] = true
L["Shadi Mistrunner"] = true
L["Shankys"] = true
L["Sheendra Tallgrass"] = true
L["Shen'dralar Provisioner"] = true
L["Sheri Zipstitch"] = true
L["Sid Limbardi"] = true
L["Skreah"] = true
L["Soolie Berryfizz"] = true
L["Sovik"] = true
L["Stuart Fleming"] = true
L["Sumi"] = true
L["Super-Seller 680"] = true
L["Supply Officer Mills"] = true
L["Tamar"] = true
L["Tansy Puddlefizz"] = true
L["Tarban Hearthgrain"] = true
L["Tari'qa"] = true
L["Tatiana"] = true
L["Thaddeus Webb"] = true
L["Tharynn Bouden"] = true
L["Thomas Yance"] = true
L["Tilli Thistlefuzz"] = true
L["Truk Wildbeard"] = true
L["Tunkk"] = true
L["Ulthaan"] = true
L["Ulthir"] = true
L["Uriku"] = true
L["Uthok"] = true
L["Vaean"] = true
L["Valdaron"] = true
L["Veenix"] = true
L["Vendor-Tron 1000"] = true
L["Vharr"] = true
L["Viggz Shinesparked"] = true
L["Vivianna"] = true
L["Vizzklick"] = true
L["Vodesiin"] = true
L["Wenna Silkbeard"] = true
L["Werg Thickblade"] = true
L["Wik'Tar"] = true
L["Wind Trader Lathrai"] = true
L["Wrahk"] = true
L["Wulan"] = true
L["Wunna Darkmane"] = true
L["Xandar Goodbeard"] = true
L["Xen'to"] = true
L["Xizk Goodstitch"] = true
L["Xizzer Fizzbolt"] = true
L["Yatheon"] = true
L["Yonada"] = true
L["Yuka Screwspigot"] = true
L["Yurial Soulwater"] = true
L["Zan Shivsproket"] = true
L["Zannok Hidepiercer"] = true
L["Zansoa"] = true
L["Zaralda"] = true
L["Zarena Cromwind"] = true
L["Zixil"] = true
L["Zorbin Fandazzle"] = true
L["Zurai"] = true
L["Narj Deepslice"] = true
L["Fazu"] = true
L["Zargh"] = true
L["Smudge Thunderwood"] = true
L["Sassa Weldwell"] = true
