﻿--[[
****************************************************************************************

ARLLocals-deDE.lua

deDE localization strings for Ackis Recipe List

$Date: 2008-08-25 21:00:42 +0000 (Mon, 25 Aug 2008) $
$Rev: 825 $

Original translated by: 
Currently maintaince by:  Winkiller

Thank you all translators! (From Ackis)

Please make sure you update the ToC file with any translations.

****************************************************************************************
]]--

local L = LibStub("AceLocale-3.0"):NewLocale("Ackis Recipe List", "deDE", false);
if not L then return end

-- Options Categories
L["About"] = "Über"
L["Display"] = "Anzeige"
L["DISPLAY_OPTIONS"] = "Anzeigeoptionen"
L["DISPLAY_OPTIONS_LONG"] = "Erlaubt es, das Verhalten der GUI einzustellen."
L["FILTER_OPTIONS"] = "Filteroptionen"
L["FILTER_OPTIONS_LONG"] = "Erlaubt es, die zu filternden Rezepte einzustellen."
L["REP_OPTIONS"] = "Fraktionsoptionen"
L["REP_OPTIONS_LONG"] = "Erlaubt es einzustellen, welche Fraktionen berücksichtigt werden sollen."
L["Obtain"] = "Beschaffung"
L["OBTAIN_OPTIONS"] = "Beschaffungsoptionen"
L["OBTAIN_OPTIONS_LONG"] = "Erlaubt es einzustellen, welche Methoden zur Beschaffung berücksichtigt werden sollen."
L["Sort"] = "Sortierung"
L["SORT_OPTIONS"] = "Sortierung der Rezeptliste"
L["SORT_OPTIONS_LONG"] = "Erlaubt es einzustellen, wie fehlende Rezepte sortiert und dargestellt werden sollen."
L["Profile"] = "Profil"

-- Display Options
L["Use GUI"] = "GUI benutzen"
L["GUI_TOGGLE"] = "Schalte die Nutzung des GUIs an oder aus."
L["Include Filtered"] = "Gefilterte anzeigen"
L["FILTERCOUNT_TOGGLE"] = "Gefilterte Rezepte zu den Gesamtrezepten zählen."
L["Close GUI"] = "GUI schließen"
L["CLOSEGUI_TOGGLE"] = "Schließt das ARL-Fenster, wenn das Handwerksfenster geschlossen wird."

-- Filtering Options
L["Faction"] = "Fraktionen"
L["FACTION_TOGGLE"] = "Alle Fraktionen in den Scan einbeziehen."
L["Classes"] = "Klassen"
L["CLASS_TOGGLE"] = "Alle Klassen in den Scan einbeziehen."
L["Specialities"] = "Spezialisierungen"
L["SPECIALITY_TOGGLE"] = "Alle Spezialisierungen in den Scan einbeziehen."
L["Skill"] = "Skill"
L["SKILL_TOGGLE"] = "Alle Skill-Level in den Scan einbeziehen."

-- Obtain Filter Options
L["BOE_TOGGLE"] = "BoE-Rezepte sollen in den Scan einbezogen werden."
L["BOP_TOGGLE"] = "BoP-Rezepte sollen in den Scan einbezogen werden."
L["PVP_TOGGLE"] = "Bezieht die PVP-Rezepte in den Scan ein."
L["RAID_TOGGLE"] = "Schwer zu bekommende Rezepte aus Schlachtzügen in den Scan einbeziehen."
L["SEASONAL_TOGGLE"] = "Bezieht saisonal erhältliche Rezepte in den Scan ein."
L["TRAINER_TOGGLE"] = "Bezieht vom Lehrer erlernte Rezepte in den Scan ein."
L["VENDOR_TOGGLE"] = "Bezieht von Händlern erworbene Rezepte in den Scan ein."
L["INSTANCE_TOGGLE"] = "Bezieht Rezepte aus Instanzen in den Scan ein."
L["QUEST_TOGGLE"] = "Bezieht Rezepte von Questbelohnungen in den Scan ein."
L["Cloth"] = "Stoff"
L["CLOTH_TOGGLE"] = "Bezieht Rezepte für Stoffgegenständer in den Scan ein."
L["Leather"] = "Leder"
L["LEATHER_TOGGLE"] = "Bezieht Rezepte für Ledergegenstände in den Scan ein."
L["Mail"] = "Schwere Rüstung"
L["MAIL_TOGGLE"] = "Bezieht Rezepte für Schwere Rüstung in den Scan ein."
L["Plate"] = "Platte"
L["PLATE_TOGGLE"] = "Bezieht Rezepte für Platte in den Scan ein."
L["Melee"] = "Nahkämpfer"
L["MELEE_TOGGLE"] = "Bezieht Rezepte für Nahkämpfer in den Scan ein."
L["Caster DPS"] = "Caster-DPS"
L["CASTERDPS_TOGGLE"] = "Bezieht Rezepte für Caster-DPS in den Scan ein."
L["Tanking"] = "Tanks"
L["TANKING_TOGGLE"] = "Bezieht Rezepte für Tanks in den Scan ein."
L["Healing"] = "Heiler"
L["HEALING_TOGGLE"] = "Bezieht Rezepte für Heiler in den Scan ein."

-- Sorting options
L["Acquisition"] = "Quelle"

-- Reputation Toggles
L["SPECIFIC_REP_TOGGLE"] = "inkl. %s."

-- Non-gui text
L["MissingFromDB"] = ": fehlt in der Datenbank. \nBitte informiere den Autor dieses Addons über das Rezept."
L["MissingRecipePrefix"] = "Fehlendes Rezept: "
L["InitiateScan"] = "Scanne %s auf fehlende Rezepte mit Skill-Level %s.\n"
L["InitiateScanSpecial"] = "Scanne %s - %s auf fehlende Rezepte mit Skill-Level %s.\n"
L["RecipeListSummary"] = "\nDu kennst %s von %s Rezepten (%s%%).\nDir fehlen %s Rezepte."
L["UnknownTradeSkill"] = "Du hast ein Handwerksfenster geöffnet das nicht von diesem Addon unterstützt wird.  Die Handwerksfähigkeit ist %s.  Bitte kontaktiere den Autor dieses Addons mit dieser Information."
L["OpenTradeSkillWindow"] = "Bitte öffne ein Handwerksfenster zum Scannen."

-- GUI Text
L["Instance"] = "Instanz"
L["Alliance"] = "Allianz"
L["Known"] = "Bekannt"
L["Unknown"] = "Unbekannt"

-- Tooltip Text
L["Close"] = "Schließen"
L["NoObtain"] = "Keine Information verfügbar."
L["ScanButton"] = "Scan"
L["Scan Skills"] = "Rezeptscan"
L["Scan Skills Long"] = "Nach fehlenden Rezepten scannen."

-- Recipe Database
L["Trainer"] = "Lehrer"
L["LimitedSupply"] = "Eingeschränkter Händlerverkauf"
L["Vendor"] = "Händler"
L["Discovery"] = "Geistesblitz"
L["PVP"] = "PVP"
L["Raid"] = "Schlachtzug"

--Skillup Levels
L["Journeyman"] = "Geselle"
L["Expert"] = "Experte"
L["Artisan"] = "Fachmann"
L["Master"] = "Meister"

-- Common ways to obtain recipes
L["CWD"] = "Gewöhnlicher World Drop"
L["UWD"] = "Seltener World Drop"
L["RWD"] = "Rarer World Drop"
L["EWD"] = "Epischer World Drop"
L["BoE"] = "Gebunden beim Anlegen (BoE) Drop: "
L["BoP"] = "Gebunden beim Aufnehmen (BoP) Drop: "
L["DMCACHE"] = "Knot Zwingschraubs Behälter, Düsterbruch (Nord)"
L["Gordok Ogre Suit"] = "Ogeranzug der Gordok"
L["Gordok Ogre Suit Obt"] = "Questbelohnung: Der Ogeranzug der Gordok"
L["Spectral Essence Obt"] = "Questbelohnung: Kirtonos der Herold (erlaubt dir den Händler Magnus Frostrufer in der Nähe von Scholomance zu sehen)"
L["TrueBelieverQuest"] = "Questbelohnung: Wahrer Glauben - Seltener Drop von Entschlüsselte Ausschnitte des Wahren Glaubens"
L["QuestReward"] = "Questbelohnung: "

-- Raid Drop Obtain Info
L["MOLTENCORE"] = "BoP Mob Drop: Zufällige Bosse in MC."
L["AQ20/AQ40"] = "BoP Mob Drop: Zufällige Bosse in AQ20/AQ40."
L["ADNaxx"] = "Erlernbar von Meisterhandwerker Omarion im Todesritter-Flügel von Naxxramas."
L["SSC/TKBoP"] = "BoP Mob Drop: Zufällige Bosse und Mobs in SSC/TK."
L["SSC/TKBoE"] = "BoE Mob Drop: Zufällige Bosse und Mobs in SSC/TK."
L["BT/HYJALBoP"] = "BoP Mob Drop: Zufällige Bosse und Mobs in Hyjal/BT."
L["HYJALBoP"] = "BoP Mob Drop: Zufällige Bosse in Hyjal."
L["SunwellBoP"] = "BoP Mob Drop: Zufällige Bosse and Mobs im Sonnenbrunnenplateau."
L["SunwellBoE"] = "BoE Mob Drop: Zufällige Bosse and Mobs im Sonnenbrunnenplateau."
L["BT/HYJALBoE"] = "BoE Mob Drop: Zufällige Bosse und Mobs in Hyjal/BT."
L["ZA"] = "BoP Mob Drop: Zufällige Bosse in Zul'Aman"
L["Unknown"] = "Der Droport dieses Rezepts ist unbekannt."

-- Faction info
L["WintersVeil"] = "Saisonbedingt: Winterhauchfest"
L["Lunar Festival"] = "Saisonbedingt: Mondfest"
L["Darkmoon Faire"] = "Dunkelmond-Jahrmarkt"
L["Seasonal"] = "Saisonbedingt"

-- Alchemy Obtain Information
L["Discovery - Flasks/Potions"] = "Entdeckung: Fläschchen, Elixiere oder Tränke, die Kräuter aus der Scherbenwelt benötigen."
L["Discovery - Protection Potions"] = "Entdeckung: Erhebliche Schutztränke."
L["Discovery - Transmutes"] = "Entdeckung: Transmutationen, die Material aus der Scherbenwelt benötigen."
L["Goblin Rocket Fuel Obt"] = "Hergestellt: Dieses Rezept kann von Gobliningenieuren hergestellt werden"
L["Gurubashi Mojo Madness Obt"] = "Kann an einer Schrifttafel am Rande des Wahnsinns gelernt werden, ZG"
L["Mighty Trolls Blood Potion Obt"] = "Rede mit Henry Stern im Hügel der Klingenhauer"
-- Mob Drop
L["Elixir of Greater Firepower Obt"] = "BoE Mob Drop: Wachmann, Zuchtmeister und Sklavenhändler der Dunkeleisenzwerge, Sengende Schlucht"
L["Elixir of the Mongoose Obt"] = "BoE Mob Drop: Jadefeuerschurke, Teufelswald, Schurke der Legashi, Azshara"
L["Elixir of the Sages Obt"] = "BoE Mob Drop: Scharlachroter Erzmagier, Scharlachroter Kleriker, ÖPL"
L["Fel Mana Potion Obt"] = "BoP Mob Drop: Chevalier, Blutritter, Soldat, Erzmagier, Blutwärter, Zenturio und Zauberbinder der Mondfinsternis, Schattenmondtal"
L["Fel Regeneration Potion Obt"] = "BoP Mob Drop: Wächter, Wichtel, Tüftler und Schmied der Todesschmiede, Schattenmondtal"
L["Fel Strength Elixir Obt"] = "BoP Mob Drop: Waffenschmied der Mo'arg, Schreckensmeister, Schreckensmeister und Hexenmeister des Schattenrats, Schattenmondtal"
L["Gift of Arthas Obt"] = "BoE Mob Drop: Sabbernder Guhl, Skelettschinder, WPL"
L["Greater Arcane Protection Potion Obt"] = "BoE Mob Drop: Kobaltblauer Magiewirker, Winterquell"
L["Greater Fire Protection Potion Obt"] = "BoE Mob Drop: Herbeirufer und Pyromant der Feuerbrand, LBRS"
L["Greater Frost Protection Potion Obt"] = "BoE Mob Drop: Frosthagelriese, Winterquell"
L["Greater Nature Protection Potion Obt"] = "BoE Mob Drop: Verfallender Schrecken, Faulendes Ungetüm, WPL"
L["Greater Shadow Protection Potion Obt"] = "BoE Mob Drop: Dunkler Adept, Schattenmagier, ÖPL"
L["Major Arcane Protection Potion Obt"] = "BoP Mob Drop: Arkanist der Vir'aani, Nagrand"
L["Major Fire Protection Potion Obt"] = "BoP Mob Drop: Astromagier der Sonnensucher, Die Mechanar"
L["Major Frost Protection Potion Obt"] = "BoP Mob Drop: Nexusprinz Shaffar, Managruft"
L["Major Holy Protection Potion Obt"] = "BoP Mob Drop: Abyssischer Flammenbringer, Schergrat"
L["Major Shadow Protection Potion Obt"] = "BoP Mob Drop: Hexenmeister des Schattenrats, Schattenmondtal"
L["Mighty Rage Potion Obt"] = "BoE Mob Drop: Töter des Schwarzfels, Brennende Steppe"
L["Wildvine Potion Obt"] = "BoE Mob Drop: Trolle im Hinterland und Schlingendorntal"
-- Quest
L["Discolored Healing Potion Obt"] = "Wilde Herzen"
L["Elixir of Brute Force Obt"] = "Blutblütensprösslinge bei Dadanga im Krater von Un'Goro abgeben.\n      Seit 2.0 beim Lehrer erlernbar"
L["Lesser Stoneshield Potion Obt"] = "Flüssigstein"
L["Restorative Potion Obt"] = "Reagenzien-Suche im Ödland II (Elite, Uldaman)"


-- Beast Training Obtain Information
L["Rare"] = true
L["Elite"] = true
-- Beasts which have training skills
L["Agam'ar"] =			"Agam'ar"
L["Aku'mai Fisher"] =		"Fischschnapper von Aku'mai"
L["Aku'mai Snapjaw"] =		"Schnappkiefer von Aku'mai"
L["Angerclaw Mauler"] =		"Wutklauenraufer"
L["Arash-ethis"] =		"Arash-ethis"
L["Ashenvale Bear"] =		"Ashenvale-B?r"
L["Ashmane Boar"] =		"Aschm?hneneber"
L["Barbed Crustacean"] =	"Stacheliges Krustentier"
L["Barnabus"] =			"Barnabus"
L["Battleboar"] =		"Kampfeber"
L["Bellygrub"] =		"Stopfwanst"
L["Besseleth"] =		"Besseleth"
L["Bhag'thera"] =		"Bhag'thera"
L["Bjarn"] =			"Bjarn"
L["Black Bear Patriarch"] =	"Schwarzb?renpatriarch"
L["Black Ravager Mastiff"] =	"Schwarzer Verheerermastiff"
L["Black Ravager"] =		"Schwarzer Verheerer"
L["Blackrock Worg"] =		"Worg des Schwarzfels"
L["Blackwind Warp Chaser"] =	"Schattenwindhetzer"
--L["Blind Hunter"] = 		"Blinder J?ger"
L["Blisterpaw Hyena"] =		"Eiterpfotenhy?ne"
L["Bloodaxe Worg"] =		"Worg der Blut?xte"
L["Bloodfalcon"] =		"Bluthabicht"
L["Bloodmaul Battle Worg"] =	"Kampfworg der Blutschl?ger"
L["Bloodmaul Dire Wolf"] =	"Terrorwolf der Blutschl?ger"
L["Bloodsnout Worg"] =		"Blutschnauzenworg"
L["Bonepaw Hyena"] =		"Skelettpfotenhy?ne"
L["Bristleback Battleboar"] =	"Kampfeber der Borstennacken"
L["Broken Tooth"] =		"Zerbrochener Zahn"
L["Carrion Vulture"] =		"Aasgeier"
L["Cave Creeper"] =		"H?hlenkrabbler"
L["Chatter"] =			"Chatter"
L["Clack the Reaver"] =		"Clack der H?scher"
L["Clattering Crawler"] =	"Rasselnder Kriecher"
L["Cleft Scorpid"] =		"Kluftskorpid"
L["Cloud Serpent"] =		"Wolkenschlange"
L["Cobalt Serpent"] =		"Kobaltblaue Schlange"
L["Coilskar Cobra"] =		"Kobra der Echsennarbe"
L["Corrupted Mottled Boar"] =	"Verderbter scheckiger Eber"
L["Corrupted Scorpid"] =	"Verderbter Skorpid"
L["Coyote Packleader"] =	"Kojotenrudelanf?hrer"
L["Coyote"] =			"Kojote"
L["Crag Boar"] =		"Klippeneber"
L["Crag Coyote"] =		"Klippenkojote"
L["Crag Stalker"] =		"Klippenpirscher"
L["Crazed Dragonhawk"] =	"Wahnsinniger Drachenfalke"
L["Creepthess"] =		"Kriechf?nger"
L["Dark Screecher"] =		"Dunkelkreischer"
L["Dark Worg"] =		"Dunkelworg"
L["Darkfang Creeper"] =		"Dunkelzahnkrabbler"
L["Deadly Cleft Scorpid"] =	"T?dlicher Kluftskorpid"
L["Deadmire"] =			"Schlammw?hler"
L["Death Flayer"] =		"Todesschinder"
L["Death Howl"] =		"Todesheuler"
L["Deathlash Scorpid"] =	"Todespeitschenskorpid"
L["Deathstrike Tarantula"] =	"Todessto?tarantel"
L["Deep Stinger"] =		"Tiefstecher"
L["Deepmoss Creeper"] =		"Kluftmooskrabbler"
L["Deepmoss Webspinner"] =	"Kluftmoosnetzweber"
L["Den Mother"] =		"H?hlenmutter"
L["Deviate Adder"] =		"Deviatotter"
L["Deviate Coiler Hatchling"] =	"Deviatwinderjungtier"
L["Deviate Coiler"] =		"Deviatwinder"
L["Deviate Crocolisk"] =	"Deviatkrokilisk"
L["Deviate Dreadfang"] =	"Deviatschreckensfang"
L["Deviate Moccasin"] =		"Deviatmokassinschlange"
L["Deviate Stinglash"] =	"Deviatdornenpeitscher"
L["Deviate Venomwing"] =	"Deviatvenomwing"
L["Deviate Viper"] =		"Deviatviper"
L["Dire Mottled Boar"] =	"Scheckiger Terroreber"
--L["Dire Raven"] =		"Terrorrabe"
L["Diseased Grizzly"] =		"Kranker Grizzly"
L["Diseased Wolf"] =		"Kranker Wolf"
L["Dread Flyer"] =		"Schreckensflieger"
L["Dread Ripper"] =		"Schreckensschlitzer"
L["Dreadfang Lurker"] =		"Schreckenslauerer"
L["Dreadfang Widow"] =		"Schreckenswitwe"
L["Dreadmaw Crocolisk"] =	"Schaudermagenkrokilisk"
L["Drywallow Crocolisk"] =	"Staubsuhlerkrokilisk"
L["Drywallow Daggermaw"] =	"Staubsuhlerdolchrachen"
L["Drywallow Snapper"] =	"Staubsuhlerschnapper"
L["Durotar Tiger"] =		"Durotar-Tiger"
L["Eclipsion Dragonhawk"] =	"Drachenfalke der Mondfinsternis"
L["Elder Ashenvale Bear"] =	"Alter Ashenvaleb?r"
L["Elder Cloud Serpent"] =	"Alte Wolkenschlange"
L["Elder Crag Boar"] =		"Alter Klippeneber"
L["Elder Crag Coyote"] =	"Alter Klippenkojote"
L["Elder Mistvale Gorilla"] =	"Alter Nebeltalgorilla"
L["Elder Moss Creeper"] =	"Alter Mooskrabbler"
L["Elder Mottled Boar"] =	"Alter scheckiger Eber"
L["Elder Mountain Boar"] =	"Alter Bergeber"
L["Elder Plainstrider"] =	"Alter Ebenenschreiter"
L["Elder Shadowmaw Panther"] =	"Alter Schattentatzenpanther"
L["Elder Shardtooth"] =		"Alter Splitterzahn"
L["Elder Springpaw"] =		"Alte Bachtatze"
L["Encrusted Surf Crawler"] =	"Verkrusteter Brandungskriecher"
L["Enraged Ravager"] =		"W?tender Blutfelshetzer"
L["Felpaw Ravager"] =		"Teufelspfotenverheerer"
L["Felpaw Wolf"] =		"Teufelspfotenwolf"
L["Felsworn Scalewing"] =	"Schuppenfl?gelteufelsbrut"
--L["Female Kaliri Hatchling"] = "Junges Kaliriweibchen"
L["Feral Crag Coyote"] =	"Wilder Klippenkojote"
L["Feral Dragonhawk Hatchling"] = "Wildes Drachenfalkenjunges"
L["Feral Mountain Lion"] =	"Wilder Bergl?we"
L["Ferocious Grizzled Bear"] =	"Wilder ergrauter B?r"
L["Fire Roc"] =			"Feuerroc"
L["Firetail Scorpid"] =		"Feuerschwanzskorpid"
L["Flatland Cougar"] =		"Flachlandpuma"
L["Fleeting Plainstrider"] =	"Fl?chtiger Ebenenschreiter"
L["Forest Lurker"] =		"Waldlauerer"
L["Forest Moss Creeper"] =	"Waldmooskrabbler"
L["Forest Spider"] =		"Waldspinne"
L["Foreststrider Fledgling"] =	"Waldschreiterjunges"
L["Frostsaber Cub"] =		"Frosts?blerjunges"
L["Frostsaber Huntress"] =	"Frosts?blerj?gerin"
L["Frostsaber Stalker"] =	"Frosts?blerpirscherin"
L["Ghamoo-ra"] =		"Ghamoo-ra"
L["Ghost Saber"] =		"Geisters?bler"
L["Ghostclaw Lynx"] =		"Geisterklauenluchs"
L["Ghostclaw Ravager"] =	"Geisterklauenverheerer"
L["Ghostpaw Alpha"] =		"Geisterpfotenalpha"
L["Ghostpaw Runner"] =		"Geisterpfotenl?ufer"
L["Giant Foreststrider"] =	"Riesiger Waldschreiter"
L["Giant Moss Creeper"] =	"Riesiger Mooskrabbler"
L["Giant Plains Creeper"] =	"Riesiger Ebenenkrabbler"
L["Giant Webwood Spider"] =	"Riesige Waldweberspinne"
L["Giant Wetlands Crocolisk"] =	"Riesiger Sumpflandkrokilisk"
L["Githyiss the Vile"] =	"Githyiss die ?ble"
L["Goretusk"] =			"Geiferzahn"
L["Gray Bear"] =		"Graub?r"
L["Gray Forest Wolf"] =		"Grauer Forstwolf"
L["Great Goretusk"] =		"Gro?er Geiferzahn"
L["Greater Duskbat"] =		"Gro?er Nachtsauger"
L["Greater Firebird"] =		"Gro?er Feuervogel"
L["Greater Fleshripper"] =	"Gro?er Fleischrei?er"
L["Greater Kraul Bat"] =	"Gro?e Kralfledermaus"
L["Greater Tarantula"] =	"Gro?e Tarantel"
L["Greater Thunderhawk"] =	"Gro?er Donnerfalke"
L["Greater Windroc"] =		"Gro?er Windroc"
L["Green Recluse"] =		"Gr?ner Eremit"
L["Groddoc Thunderer"] =	"Groddoc-Donnerer"
L["Grovestalker Lynx "] =	"Hainpirscherluchs"
L["Grunter"] =			"Suhlaman"
L["Gutripper"] =		"Aaskralle"
L["Hakkar'i Frostwing"] =	"Frostfl?gler der Hakkari"
L["Hakkar'i Sapper"] =		"Randalierer der Hakkari"
L["Ice Claw Bear"] =		"Eisklauenb?r"
L["Ironback"] =			"Eisenpanzer"
L["Ironbeak Hunter"] =		"Eisenschnabelj?ger"
L["Ironbeak Owl"] =		"Eisenschnabeleule"
L["Ironbeak Screecher"] =	"Eisenschnabelkreischer"
L["Ironfur Bear"] =		"Eisenfellb?r"
L["Ironfur Patriarch"] =	"Eisenfellpatriarch"
L["Jaguero Stalker"] =		"Jaguero-Pirscher"
L["Jungle Thunderer"] =		"Dschungeldonnerer"
L["Juvenile Snow Leopard"] =	"Halbw?chsiger Schneeleopard"
L["Kaliri Matriarch"] =		"Kalirimatriarchin"
L["Kaliri Swooper"] =		"Kaliristurzflieger"
L["King Bangalash"] =		"K?nig Bangalash"
L["Kraul Bat"] =		"Kral-Fledermaus"
L["Krellack"] =			"Krellack"
L["Kresh"] =			"Kresh"
L["Kurzen War Tiger"] =		"Kurzens Kriegstiger"
L["Lady Sathrah"] =		"Dame Sathrah"
L["Large Crag Boar"] =		"Gro?er Klippeneber"
L["Large Loch Crocolisk"] =	"Gro?er Lochkrokilisk"
L["Leech Widow"] =		"Egelwitwe"
L["Loch Crocolisk"] =		"Lochkrokilisk"
L["Longsnout"] =		"Langschnauze"
L["Longtooth Howler"] =		"Langzahnheuler"
L["Longtooth Runner"] =		"Langzahnl?ufer"
L["Lost Torranche"] =		"Verirrter Torranche"
L["Lupos"] =			"Lupos"
L["Magram Bonepaw"] =		"Skelettpfote der Magram"
L["Male Kaliri Hatchling"] =	"Junges Kalirim?nnchen"
L["Mangeclaw"] =		"Marterklaue"
L["Mangy Mountain Boar"] =	"R?udiger Bergeber"
L["Mazzranache"] =		"Mazzranache"
L["Mesa Buzzard"] =		"Mesabussard"
L["Mist Howler"] =		"Nebelheuler"
L["Mistvale Gorilla"] =		"Nebeltalgorilla"
L["Mongress"] =			"Mongress"
L["Monstrous Crawler"] =	"Monstr?ser Kriecher"
L["Monstrous Plaguebat"] =	"Monstr?se Seuchenfledermaus"
L["Moonstalker Runt"] =		"Mondpirscherwicht"
L["Moonstalker Sire"] =		"Mondpirschervater"
L["Mottled Boar"] =		"Scheckiger Eber"
L["Mottled Drywallow Crocolisk"] = "Scheckiger Staubsuhlerkrokilisk"
L["Mountain Boar"] =		"Bergeber"
L["Mountain Lion"] =		"Bergl?we"
L["Mudrock Snapjaw"] =		"Schlammpanzerschnappkiefer"
--L["Murderous Blisterpaw"] =	"Mordlustige Eiterpfote"
L["Murk Slitherer"] =		"D?stergleiter"
L["Murk Spitter"] =		"D?sterspeier"
L["Naraxis"] =			"Naraxis"
L["Night Web Matriarch"] =	"Nachtwebermatriarchin"
L["Night Web Spider"] =		"Nachtweber"
L["Nightsaber"] =		"Nachts?bler"
L["Noxious Plaguebat"] =	"Giftige Seuchenfledermaus"
--L["Noxious Reaver"] =	"Giftiger H?scher"
--L["Noxious Shredder"] =	"Giftiger Schredder"
L["Oasis Snapjaw"] =		"Oasenschnappkiefer"
L["Ol' Sooty"] =		"Old Sooty"
L["Old Cliff Jumper"] =		"Klippenspringer"
L["Old Grizzlegut"] =		"Silbergrimm der Weise"
L["Olm the Wise"] =		"Olm der Weise"
L["Ornery Plainstrider"] =	"St?rrischer Ebenenschreiter"
L["Panther"] =			"Panther"
L["Phoenix-Hawk Hatchling"] =	"Ph?nixfalkenjunges"
L["Plague Lurker"] =		"Seuchenlauerer"
L["Plaguebat"] =		"Seuchenfledermaus"
L["Plagued Swine"] =		"Verseuchtes Schwein"
L["Plains Creeper"] =		"Ebenenkrabbler"
L["Porcine Entourage"] =	"Gefolgsschwein"
L["Prairie Stalker"] =		"Pr?riepirscher"
L["Prairie Wolf Alpha"] =	"Alpha-Pr?riewolf"
L["Prairie Wolf"] =		"Pr?riewolf"
L["Princess"] =			"Prinzessin"
L["Prowler"] =			"Streuner"
L["Pygmy Surf Crawler"] =	"Zwergbrandungskriecher"
L["Quillfang Ravager"] =	"Stachelklauenfelshetzer"
L["Quillfang Skitterer"] =	"Stachelklauenhuscher"
L["Rabid Blisterpaw"] =		"Tollw?tige Eiterpfote"
L["Rabid Crag Coyote"] =	"Tollw?tiger Klippenkojote"
L["Ragged Scavenger"] =		"Struppiger Aasfresser"
L["Raging Agam'ar"] =		"Tobender Agam'ar"
L["Rak'Shiri"] =		"Rak'shiri"
L["Ravage"] =			"Verheeren"
L["Ravager Specimen"] =		"Felshetzerexemplar"
L["Ravenous Windroc"] =		"Gefr??iger Windroc"
L["Razorfang Hatchling"] =	"Messerklauenjungtier"
L["Razzashi Adder"] =		"Razzashiotter"
--L["Razzashi Broodwidow"] =	"Razzashibrutwitwe"
L["Razzashi Cobra"] =		"Razzashikobra"
L["Razzashi Serpent"] =		"Razzashischlange"
L["Rekk'tilac"] =		"Rekk'tilac"
L["Rema"] =			"Rema"
L["Ridge Huntress"] =		"Kammj?gerin"
L["Ridge Stalker Patriarch"] =	"Kammpirscherpatriarch"
L["Ridge Stalker"] =		"Kammpirscher"
L["Rip-Blade Ravager"] =	"Rei?klingenhetzer"
L["Ripfang Lynx"] =		"Rei?zahnluchs"
L["Ripscale"] =			"Rei?erschuppe"
L["Roc"] =			"Roc"
L["Rockhide Boar"] =		"Felsnischeneber"
L["Rogue Vale Screecher"] =	"Wilder Talkreischer"
L["Rotting Agam'ar"] =		"Faulender Agam'ar"
L["Salt Flats Vulture"] =	"Salzw?stengeier"
L["Saltwater Snapjaw"] =	"Salzwasserschnappkiefer"
L["Sandfury Guardian"] =	"W?chter der Sandw?ter"
L["Sarkoth"] =			"Sarkoth"
L["Savannah Patriarch"] =	"Savannenpatriarch"
L["Sawtooth Snapper"] =		"S?gezahnschnapper"
L["Scalewing Serpent"] =	"Schuppenfl?gelschlange"
L["Scarlet Tracking Hound"] =	"Scharlachroter F?hrtenleserhund"
L["Scarred Crag Boar"] =	"Vernarbter Klippeneber"
L["Scarshield Worg"] =		"Worg der Schmetterschilde"
L["Scorchshell Pincer"] =	"Sengpanzerzange"
L["Scorpashi Lasher"] =		"Skorpashipeitscher"
L["Scorpashi Snapper"] =	"Skorpashischnapper"
L["Scorpashi Venomlash"] =	"Skorpashigiftpeitscher"
L["Scorpid Bonecrawler"] =	"Skorpidknochenkletterer"
L["Scorpid Duneburrower"] =	"D?nenbuddlerskorpid"
L["Scorpid Dunestalker"] =	"Skorpidd?nenpirscher"
L["Scorpid Hunter"] =		"Skorpidj?ger"
L["Scorpid Reaver"] =		"Skorpidh?scher"
L["Scorpid Tail Lasher"] =	"Skorpidschwanzpeitscher"
L["Scorpid Terror"] =		"Skorpidschrecker"
L["Scorpid Worker"] =		"Skorpidarbeiter"
L["Scorpok Stinger"] =		"Skorpokstecher"
--L["Scythetooth Raptor"] =	"Sichelzahnraptor"
L["Searing Roc"] =		"Sengender Roc"
--L["Sewer Beast"] =		"Kanalbestie"
L["Shadow Panther"] =		"Schattenpanther"
L["Shadowmaw Panther"] =	"Alter Schattentatzenpanther"
L["Shadowwing Owl"] =		"Schattenfl?geleule"
L["Shanda the Spinner"] =	"Shanda die Weberin"
L["Shardtooth Bear"] =		"Splitterzahnb?r"
L["Shore Crawler"] =		"K?stenkriecher"
L["Shrike Bat"] =		"W?rgerfledermaus"
L["Silithid Creeper"] =		"Silithidkrabbler"
L["Silithid Swarmer"] =		"Silithidschw?rmer"
L["Silt Crawler"] =		"Schlickkriecher"
L["Silvermane Howler"] =	"Silberm?hnenheuler"
L["Silvermane Stalker"] =	"Silberm?hnenpirscher"
L["Silvermane Wolf"] =		"Silberm?hnenwolf"
L["Sin'Dall"] =			"Sin'Dall"
L["Skettis Kaliri"] =		"Kaliri von Skettis"
L["Skittering Crustacean"] =	"Huschendes Krustentier"
L["Small Crag Boar"] =		"Kleiner Klippeneber"
L["Snapjaw"] =			"Schnappkiefer"
L["Snapping Crustacean"] =	"Schnappendes Krustentier"
L["Snarler"] =			"Knurrer"
L["Snow Tracker Wolf"] =	"Schneef?hrtenleserwolf"
L["Son of Hakkar"] =		"Sohn von Hakkar"
L["Soulflayer"] =		"Seelenschinder"
L["Sparkleshell Snapper"] =	"Spiegelpanzerschnapper"
L["Spawn of Hakkar"] =		"Brut von Hakkar"
L["Spiteflayer"] =		"Fledderschnabel"
L["Spot"] =			"Spot"
L["Starving Blisterpaw"] =	"Verhungernde Eiterpfote"
L["Starving Mountain Lion"] =	"Verhungernder Bergl?we"
L["Starving Winter Wolf"] =	"Verhungernder Winterwolf"
--L["Stolid Snapjaw"] =	"Phlegmatischer Schnappkiefer"
L["Stonelash Flayer"] =		"Steinpanzerschinder"
L["Stonelash Pincer"] =		"Steinpanzerzange"
L["Stonelash Scorpid"] =	"Steinpanzerskorpid"
L["Stonetusk Boar"] =		"Steinhauereber"
L["Stranglethorn Tiger"] =	"Stranglethorn-Tiger"
L["Strigid Hunter"] =		"Strigidj?ger"
L["Strigid Owl"] =		"Strigideule"
L["Swamp Jaguar"] =		"Sumpfjaguar"
L["Swiftwing Shredder"] =	"Flinkfl?gelschredder"
L["Tarantula"] =		"Tarantel"
L["Thistle Bear"] =		"Distelb?r"
L["Thistle Boar"] =		"Disteleber"
L["Thornfang Ravager"] =	"Dornenfangfelshetzer"
L["Thornfang Venomspitter"] =	"Dornenfanggiftspucker"
L["Thunderhawk Cloudscraper"] =	"Donnerfalkenwolkenkitzler"
L["Thunderhawk Hatchling"] =	"Donnerfalkenjungtier"
L["Tide Crawler"] =		"Gezeitenkriecher"
L["Timber Worg"] =		"Waldworg"
L["Timber"] =			"Holzplanke"
L["Timberweb Recluse"] =	"Baumspinnereremit"
L["Twilight Runner"] =		"Mondlichtl?ufer"
L["U'cha"] =			"U'cha"
L["Uhk'loc"] =			"Uhk'loc"
L["Un'Goro Thunderer"] =	"Donnerer von Un'Goro"
L["Vale Screecher"] =		"Talkreischer"
L["Venomlash Scorpid"] =	"Giftpeitscherskorpid"
L["Venomous Cloud Serpent"] =	"Giftige Wolkenschlange"
L["Venomtail Scorpid"] =	"Siechstachelskorpid"
L["Venomtip Scorpid"] =		"Giftstichskorpid"
L["Vicious Night Web Spider"] =	"Heimt?ckischer Nachtweber"
L["Vile Sting"] =		"?belstich"
L["Vilebranch Raiding Wolf"] =	"Raubwolf der Vilebranch"
L["Warp Chaser"] =		"Sph?renhetzer"
L["Warp Hunter"] =		"Sph?renpirscher"
L["Warp Stalker"] =		"Sph?renj?ger"
L["Washte Pawne"] =		"Washte Pawne"
L["Wayward Buzzard"] =		"Entflogener Bussard"
L["Webwood Silkspinner"] =	"Waldweberseidenspinner"
L["Webwood Venomfang"] =	"Waldwebergiftzahn"
L["Wildthorn Lurker"] =		"Wilddornlauerer"
L["Windroc Hunter"] =		"Windrocj?ger"
L["Windroc Huntress"] =		"Windrocj?gerin"
L["Windroc Matriarch"] =	"Windrocmatriarchin"
L["Windroc"] =			"Windroc"
L["Winter Wolf"] =		"Winterwolf"
L["Winterspring Owl"] =		"Winterquelleule"
L["Winterspring Screecher"] =	"Wintersquellkreischer"
L["Wood Lurker"] =		"Holzlauerer"
L["Worg"] =			"Worg"
L["Young Forest Bear"] =	"Junger Waldb?r"
L["Young Goretusk"] =		"Junger Geiferzahn"
L["Young Mesa Buzzard"] =	"Junger Mesabussard"
L["Young Panther"] =		"Junger Panther"
L["Young Stranglethorn Tiger"] = "Junger Stranglethorntiger"
L["Young Thistle Boar"] =	"Junger Disteleber"
L["Zaricotl"] =			"Zaricotl"
L["Zulian Panther"] =		"Zulianischer Panther"
L["Zulian Stalker"] =		"Zulianischer Pirscher"

-- Blacksmithin Obtain Information
L["Annihilator Obt"] = "BoE Mob Drop: Rüstmeister Zigris, LBRS"
L["Arcanite Champion Obt"] = "BoE Mob Drop: Goraluk Hammerbruch, UBRS"
L["Arcanite Reaper Obt"] = "BoE Mob Drop: Bannok Grimmaxt, LBRS"
L["Barbaric Iron Boots Obt"] = "Questbelohnung (H): In den Boden getrampelt"
L["Barbaric Iron Breastplate Obt"] = "Questbelohnung (H): Barbarische Waffenschmiedekunst"
L["Barbaric Iron Gloves Obt"] = "Questbelohnung (H): Freude der Omoshs"
L["Barbaric Iron Helm Obt"] = "Questbelohnung (H): Hörner der Raserei"
L["Barbaric Iron Shoulders Obt"] = "Questbelohnung (H): Über Eisenschulterstücke"
L["Black Grasp of the Destroyer Obt"] = "BoP Mob Drop: Moam, AQ20"
L["Blacksmithing Plans"] = "Item Drop: Zufallsdropps aus Plänen in BRT und Stratholme"
L["Blazing Rapier Obt"] = "Questbelohnung: Verderbnis"
L["Dark Iron Plate Obt"] = "BoE Mob Drop: Ribbly Schraubstutz, BRT"
L["Dark Iron Pulverizer Obt"] = "BoE Mob Drop: Grizzle, BRT"
L["Dark Iron Sunderer Obt"] = "BoE Mob Drop: Betrunkener Gast, Ribblys Spießgeselle, BRT"
L["Dawn's Edge Obt"] = "Questbelohnung: Schlangenstein der Schattenjägerin"
L["Demon Forged Breastplate Obt"] = "Questbelohnung: Die Dämonenschmiede"
L["Earthpeace Breastplate Obt"] = "BoP Mob Drop, Hochbotaniker Freywinn, Die Botanika"
L["Enchanted Battlehammer Obt"] = "Questbelohnung: Süße Beschaulichkeit"
L["Enchanted Thorium Breastplate Obt"] = "Questbelohnung: Verzauberter Thoriumplattenpanzer: Band I"
L["Enchanted Thorium Helm Obt"] = "Questbelohnung: Verzauberter Thoriumplattenpanzer: Band III"
L["Enchanted Thorium Leggings Obt"] = "Questbelohnung: Verzauberter Thoriumplattenpanzer: Band II"
L["Felsteel Gloves Obt"] = "BoP Mob Drop: Mönch der Auchenai, Auchenaikrypta"
L["Felsteel Helm Obt"] = "BoP Mob Drop: Fanatiker der Kabale, Schattenlabyrinth"
L["Felsteel Leggings Obt"] = "BoP Mob Drop: Entfesselter Verdammnisbringer, Die Arkatraz"
L["Fiery Plate Gauntlets Obt"] = "Questbelohnung: Feurige Plattenstulpen"
L["Frostguard Obt"] = "BoE Mob Drop: Großknecht Marcrid, WPL"
L["Golden Scale Gauntlets Obt"] = "Questbelohnung (A): Die Herkunft der Schmiedekunst"
L["Greater Ward of Shielding Obt"] = "BoP Mob Drop: Blutwärter des Sonnenzorns, Nethersturm"
L["Hammer of the Titans Obt"] = "BoE Mob Drop: Maleki der Leichenblasse, Stratholme"
L["Heartseeker Obt"] = "BoE Mob Drop: Kanonenmeister Willey, Stratholme"
L["Heavy Copper Longsword Obt"] = "Questbelohnung (A): Nachschub für die Front (neu)"
L["Imperial Plate Belt Obt"] = "Questbelohnung: Imperialer Plattengürtel"
L["Imperial Plate Boots Obt"] = "Questbelohnung: Imperiale Plattenstiefel"
L["Imperial Plate Bracers Obt"] = "Questbelohnung: Imperiale Plattenarmschienen"
L["Imperial Plate Chest Obt"] = "Questbelohnung: Imperiale Plattenrüstung"
L["Imperial Plate Helm Obt"] = "Questbelohnung: Imperialer Plattenhelm"
L["Imperial Plate Leggings Obt"] = "Questbelohnung: Imperiale Plattengamaschen"
L["Imperial Plate Shoulders Obt"] = "Questbelohnung: Imperiale Plattenschultern"
L["Inlaid Mithril Cylinder Obt"] = "Hergestellt: Das Rezept kann von Gnomeningieuren hergestellt werden."
L["Invulnerable Mail Obt"] = "BoE Mob Drop: Goraluk Hammerbruch, UBRS"
L["Ironforge Breastplate Obt"] = "Questbelohnung (A): Die Aufrüstung im Rotkammgebirge"
L["Khorium Belt Obt"] = "BoP Mob Drop: Räuber der Finsterblut, Nagrand"
L["Khorium Boots Obt"] = "BoP Mob Drop: Körperloser Beschützer, Nethersturm"
L["Khorium Pants Obt"] = "BoP Mob Drop: Wächter der Todesschmiedes, Schattenmondtal"
L["Masterwork Stormhammer Obt"] = "BoE Mob Drop: Goraluk Hammerbruch, UBRS"
L["Orcish War Leggings Obt"] = "Questbelohnung (H): Die alten Traditionen"
L["Ornate Mithril Gloves Obt"] = "Questbelohnung: Der große silberne Betrüger"
L["Ornate Mithril Helm Obt"] = "Questbelohnung: Ein schlauer Kopf auf den Schultern"
L["Ornate Mithril Pants Obt"] = "Questbelohnung: Hier verhütten, da verhütten"
L["Ornate Mithril Shoulder Obt"] = "Questbelohnung: Die Kunst der Magieerfüllung"
L["Ragesteel Breastplate Obt"] = "BoP Mob Drop, Krieger der Aschenzungen, Schattenmondtal"
L["Ragesteel Gloves Obt"] = "BoP Mob Drop: Krieger der Felsfäuste, Nagrand"
L["Ragesteel Helm Obt"] = "BoP Mob Drop: Grollwaches, Schergrat"
L["Ragesteel Shoulders Obt"] = "BoP Mob Drop: Wütender Erdgeist, Wütender Luftgeist, Wütender Feuergeist, Wütender Wassergeist, Schattenmondtal"
L["Runic Breastplate Obt"] = "BoE Mob Drop: Strashazmyrmidone, Düstermarschen (Alcaz Insel)"
L["Runic Plate Boots Obt"] = "BoE Mob Drop: Scharlachroter Chevalier, WPL"
L["Runic Plate Helm Obt"] = "BoE Mob Drop: Strashazkrieger, Düstermarschen (Alcaz Insel)"
L["Runic Plate Leggings Obt"] = "BoE Mob Drop: Scharlachroter Schmied, WPL"
L["Runic Plate Shoulders Obt"] = "BoE Mob Drop: Strashazschlangenwache, Düstermarschen (Alcaz Insel)"
L["Sulfuron Hammer Obt"] = "Questbelohnung: Ein verbindlicher Vertrag"
L["Swiftsteel Gloves Obt"] = "BoP Mob Drop, Nexuswandler, Managruft"
L["Thick Obsidian Breastplate Obt"] = "BoP Mob Drop: Der Prophet Skeram, AQ40"
L["Volcanic Hammer Obt"] = "BoE Mob Drop: Volchan (Rar), Brennende Steppe"

-- Cooking Obtain Information
L["Fishing Daily"] = "Questbelohnung: Zufällige Belohnung von der täglichen Angelquest."
L["Cooking Daily"] = "Questbelohnung: Zufällige Belohnung von der täglichen Kochquest."
L["Goldthorn Tea Obt"] = "Rede mit Henry Stern im Hügel der Klingenhauer"
L["Stewed Trout Obt"] = "Lehrer: Kylene"
-- Mob Drop
L["Runn Tum Tuber Surprise Obt"] = "Pusillin"
L["Savory Deviate Delight Obt"] = "Seltener World Drop: Brachland"
-- Quest
L["Barbecued Buzzard Wing Obt"] = "Gegrillte Bussardflügel"
L["Beer Basted Boar Ribs Obt"] = "Eberrippchen in Biersauce"
L["Big Bear Steak Obt"] = "Die Rettung"
L["Blood Sausage Obt"] = "Blutwurst aus Thelsamar"
L["Buzzard Bites Obt"] = "Questbelohnung: So weich wie Butter"
L["Crocolisk Gumbo Obt"] = "Lehrlingspflichten"
L["Crocolisk Steak Obt"] = "Krokiliskenjagd"
L["Crunchy Serpent Obt"] = "Leckerbissen der Mok'Nathal"
L["Crunchy Spider Surprise Obt"] = "Knusperkost"
L["Curiously Tasty Omelet Obt"] = "Ormers Rache"
L["Dig Rat Stew Obt"] = "Grubenratteneintopf"
L["Dirge's Kickin' Chimaerok Chops Obt"] = "Dirges abgefahrene Chimaerokkoteletts"
L["Gooey Spider Cake Obt"] = "Schwärzliche Krebsküchlein"
L["Goretusk Liver Pie Obt"] = "Pastete aus Geiferzahnleber"
L["Hot Lion Chops Obt"] = "Elixier der Schmerzen"
L["Kaldorei Spider Kabob Obt"] = "Rezept der Kaldorei"
L["Murloc Fin Soup Obt"] = "Fischhandel"
L["Redridge Goulash Obt"] = "Rotkammgulasch"
L["Roasted Moongraze Tenderloin Obt"] = "Die große Mondweidenjagd"
L["Seasoned Wolf Kabob Obt"] = "Gewürzter Wolfskebab"
L["Smoked Desert Dumplings Obt"] = "Wüstenrezept"
L["Soothing Turtle Bisque Obt"] = "Milde Schildkrötensuppe"
L["Strider Stew Obt"] = "Schreitereintopf"
L["Tasty Lion Steak Obt"] = "Teure Bedrohung"
L["Thistle Tea Ally Obt"] = "Klavens Turm"
L["Thistle Tea Horde Obt"] = "Mission: möglich, aber nicht sehr wahrscheinlich"
L["Westfall Stew Obt"] = "Westfalleintopf"

-- Enchanting Obtain Information
L["Enchant 2H Weapon - Major Agility Obt"] = "Todesbringer der Eredar"
L["Enchant 2H Weapon - Major Intellect Obt"] = "Purpurroter Zauberhexer"
L["Enchant 2H Weapon - Major Spirit Obt"] = "Adept aus Scholomance"
L["Enchant 2H Weapon - Savagery Obt"] = "Zenturio der Zerschmetterten Hand"
L["Enchant 2H Weapon - Superior Impact Obt"] = "Elitesoldat der Schwarzfaustlegion"
L["Enchant Boots - Dexterity Obt"] = "Tobendes Skelett"
L["Enchant Boots - Fortitude Obt"] = "Astraler Priester"
L["Enchant Boots - Surefooted Obt"] = "Phantombühnenarbeiter"
L["Enchant Bracer - Fortitude Obt"] = "Orakel des Echsenkessels"
L["Enchant Bracer - Major Defense Obt"] = "Auslöscher des Astraleums"
L["Enchant Bracer - Spellpower Obt"] = "Geomant der Blutschläger"
L["Enchant Bracer - Superior Strength Obt"] = "Hexenmeister der Totenwindoger"
L["Enchant Cloak - Greater Arcane Resistance Obt"] = "Erzmagier der Mondfinsternis"
L["Enchant Cloak - Greater Shadow Resistance Obt"] = "Leerkreischer"
L["Enchant Cloak - Lesser Agility Obt"] = "Auftragsmörder des Syndikats"
L["Enchant Cloak - Lesser Agility Obt1"] = "Auftragsmörder der Wüstenläufer, Gesetzloser der Wüstenläufer"
L["Enchant Gloves - Advanced Herbalism Obt"] = "Morastlord, Moosbart, Sumpfwandler, Sumpfwandlerältester, Wuchernder Schrecken"
L["Enchant Gloves - Advanced Mining Obt"] = "Akkordminenarbeiter der Venture Co."
L["Enchant Gloves - Fishing Obt"] = "Narbenflosse, Küstenläufer der Fetzenflossen, Orakel der Fetzenflossen, Matschkrabbler der Fetzenflossen, Gezeitenjäger der Fetzenflossen"
L["Enchant Gloves - Herbalism Obt"] = "Wahnsinniges Urtum, Welkes Urtum"
L["Enchant Gloves - Herbalism Obt1"] = "Rachsüchtiges Urtum, Geschwärztes Urtum, Verkohltes Urtum"
L["Enchant Gloves - Mining Obt"] = "Dunkeleisenzwerg, Demolierer der Dunkeleisenzwerge, Tunnelgräber der Dunkeleisenzwerge, Saboteur der Dunkeleisenzwerge, Balgaras der Niederträchtige"
L["Enchant Gloves - Skinning Obt"] = "Nimar der Töter, Berserker der Bleichborken, Kopfjäger der Bleichborken, Schattenjäger der Bleichborken"
L["Enchant Weapon - Crusader Obt"] = "Scharlachroter Zauberbinder"
L["Enchant Weapon - Deathfrost Obt"] = "Lord Ahune - Sonnenwendfest"
L["Enchant Weapon - Fiery Weapon Obt"] = "Pyromant Weisenkorn"
L["Enchant Weapon - Icy Chill Obt"] = "Gepeinigter Hochgeborener"
L["Enchant Weapon - Lifestealing Obt"] = "Spektraler Forscher"
L["Enchant Weapon - Major Intellect Obt"] = "Forscher des Sonnenzorns"
L["Enchant Weapon - Major Spellpower Obt"] = "Zauberdieb von Bash'ir"
L["Enchant Weapon - Superior Striking Obt"] = "Kriegsherr der Felsspitzoger"
L["Enchant Weapon - Unholy Weapon Obt"] = "Thuzadinschattenzauberer"
L["Smoking Heart of the Mountain Obt"] = "Lord Roccor"

-- Engineering Obtain Information
L["ENG_MEMBERSHIP_BENEFITS"] = "Zufällige Questbelohnung: Mitgliedskarten-Erneuerung, Tanaris"
L["Adamantite Arrow Maker Obt"] = "BoP Mob Drop: Bogenschütze des Sonnenzorns, Nethersturm"
L["Alarm-O-Bot Obt"] = "BoE Mob Drop: Waffentechniker, BRT"
L["Arcanite Dragonling Obt"] = "BoE Mob Drop: Kobaltblauer Magiewirker, Winterquell"
L["Dark Iron Bomb Obt"] = "BoE Mob Drop: Waffentechniker, BRT"
L["Dark Iron Rifle Obt"] = "BoE Mob Drop: Schicksalsträchtiger Handwerker, BRT"
L["Discombobulator Ray Obt"] = "Benutze DELTA-Daten-Sicherheitszugangskarte im Matrix Punchograph 3005-D in Gnomeregan.\n    - BoE Mob Drop: Robogenieur Thermadraht, Gnomeregan"
L["Felsteel Boomstick Obt"] = "BoP Mob Drop: Ingenieur der Schicksalsschmiede, Schergrat"
L["Field Repair Bot 110G Obt"] = "BoP Mob Drop: Analysator der Gan'arg, Schergrat"
L["Field Repair Bot 74A Obt"] = "Klickbare Rolle neben Golemlord Argelmach, BRT"
L["Flame Detector Obt"] = "BoE Mob Drop: Robogenieur Thermadraht, Gnomeregan"
L["Flash Bomb Obt"] = "Questbelohnung: Perlentauchen (danach Quest Blitzstrahlbombenanleitung für Ingenieure)"
L["Flawless Arcanite Rifle Obt"] = "BoE Mob Drop: Schattenjäger der Moosschinder, ÖPL"
L["Goblin Jumper Cables XL Obt"] = "BoE Mob Drop: Stöpsel Zapfring, BRT"
L["Hyper-Radiant Flame Reflector Pbt"] = "BoE Mob Drop: Solakar Feuerkrone, UBRS"
L["Hyper-Vision Goggles Obt"] = "BoP Mob Drop: Waffenschmied der Mo'arg, Schattenmondtal"
L["Khorium Scope Obt"] = "BoP Mob Drop: Jagdschütze des Sonnenzorns, Nethersturm"
L["Major Recombobulator Obt"] = "Düsterbruch Nord Tribute Run, Kiste"
L["Minor Recombobulator Obt"] = "Benutze die Weiße Lochkarte im Matrix Punchograph 3005-A, danach die Gelbe Lochkarte im Matrix Punchograph 3005-B in Gnomeregan."
L["Rocket Boots Xtreme Lite Obt"] = "BoP Mob Drop: Mechanolord Kapazitus, Die Mechanar"
L["Rocket Boots Xtreme Obt"] = "BoP Mob Drop: Robogenieur Dampfhammer, Die Dampfkammer"
L["Stabilized Eternium Scope Obt"] = "BoP Mob Drop: Attumen der Jäger, Karazhan"
L["Steam Tonk Controller Obt"] = "Questbelohnung: 40 Gewinnlose - Bauplan: Dampfpanzersteuerung (Dunkelmond-Jahrmarkt)"
L["Ultra-Flash Shadow Reflector Obt"] = "BoE Mob Drop: Purpurroter Inquisitor, Stratholme"
L["Voice Amplification Modulator Obt"] = "BoE Mob Drop: Purpurroter Inquisitor, Stratholme"
L["World Enlarger Obt"] = "BoE Mob Drop: Waffentechniker, BRT"
L["Zapthrottle Mote Extractor Obt"] = "Questbelohnung: Der schockdrosselnde Partikelextraktor!"

-- First Aid Obtain Information
-- Nothing here needed yet

-- Jewelcrafting Obtain Information
L["Arcane Khorium Band Obt"] = "BoP Mob Drop: Magiertöter, Nethersturm"
L["Blades Edge Summon Bosses"] = "BoP Mob Drop: Verschieden Elitebosse im Schergrat"
L["Chaotic Skyfire Diamond Obt"] = "BoP Mob Drop: Sirene der Echsennarbe, Schattenmondtal"
L["Circlet of Arcane Might Obt"] = "BoP Mob Drop: Epochenjäger, Vorgebirge des Alten Hügellands"
L["Coronet of the Verdant Flame Obt"] = "BoP Mob Drop: Botaniker der Sonnensucher, Die Botanika"
L["Dark Iron Scorpid Obt"] = "BoP Mob Drop: Golemlord Argelmach, BRT"
L["Figurine - Black Diamond Crab Obt"] = "BoP Mob Drop: Rüstmeister Zigris, UBRS"
L["Khorium Band of Frost Obt"] = "BoP Mob Drop: Zauberhexerin des Echsenkessels, Die Dampfkammer"
L["Khorium Band of Leaves Obt"] = "BoP Mob Drop: Schreckensfalke der Vekh'nir, Schergrat"
L["Khorium Band of Shadows Obt"] = "BoP Mob Drop: Schattenbeschwörer des Dunklen Rats, Schattenmondtal"
L["Khorium Inferno Band Obt"] = "BoP Mob Drop: Dunkelwirker Syth, Sethekkhallen"

-- Leatheworking Obtain Information
L["Arcane Armor Kit Obt"] = "BoP Mob Drop: Chronolord Deja, Der schwarze Morast"
L["Bag of Many Hides Obt"] = "BoP Mob Drop: Oger, Hügelwand (nordwestlich oberhalb von Shattrath)"
L["Black Dragonscale Leggings Obt"] = "BoE Mob Drop: Hauptmann der Zorneshämmer, BRT"
L["Black Dragonscale Shoulders Obt"] = "BoE Mob Drop: Hauptmann der Zorneshämmer, BRT"
L["Blue Dragonscale Shoulders Obt"] = "BoE Mob Drop: Klippenbrecher, Azshara"
L["Deviate Scale Belt Obt"] = "Questbelohnung: Ausrottung der Deviat"
L["Devilsaur Leggings Obt"] = "BoE Mob Drop: Geklonter Brühschlammer, Dickflüssiger Brühschlammer, Krater von Un'Goro"
L["Flame Armor Kit Obt"] = "BoP Mob Drop: Riesengroßer Abyss, Die Arkatraz"
L["Frost Armor Kit Obt"] = "BoP Mob Drop: Wasserbeschwörerin Thespia, Die Dampfkammer"
L["Frostsaber Gloves Obt"] = "BoE Mob Drop: Totemiker der Winterfelle, Winterquell"
L["Frostsaber Leggings Obt"] = "BoE Mob Drop: Höhlenbehüter der Winterfelle, Winterquell"
L["Frostsaber Tunic Obt"] = "BoE Mob Drop: Ursa der Winterfelle, Winterquell"
L["Green Dragonscale Leggings Obt"] = "BoE Mob Drop: Düsterwurm, Versunkener Tempel"
L["Heavy Scorpid Leggings Obt"] = "BoE Mob Drop: Töter des Schwarzfels, Brennende Steppe"
L["Heavy Scorpid Shoulders Obt"] = "BoE Mob Drop: Kampfmeister des Schwarzfels, Brennende Steppe"
L["Heavy Scorpid Vest Obt"] = "BoE Mob Drop: Portalsucher, Verwüstete Lande"
L["Ironfeather Breastplate Obt"] = "BoE Mob Drop: Balgabzieher der Blutfratzen, Hinterland"
L["Kodo Hide Bag Obt"] = "Questbelohnung(H): Kodobalgtasche"
L["Living Breastplate Obt"] = "BoE Mob Drop: Verfallender Schrecken, WPL"
L["Living Leggings Obt"] = "BoE Mob Drop: Schamane der Totenwaldfelle, Teufelswald"
L["Moonglow Vest Obt"] = "Questbelohnung(A): Mondscheinweste"
L["Nature Armor Kit Obt"] = "BoP Mob Drop: Mennu der Verräter, Die Sklavenunterkünfte"
L["Onyxia Scale Cloak Obt"] = "Questbelohnung: Onyxias Kopf besorgen, in Sturmwind/Orgrimmar abgeben, danach lernt man es"
L["Red Dragonscale Breastplate Obt"] = "BoP Mob Drop: General Drakkisath, UBRS"
L["Runic Leather Armor Obt"] = "BoE Mob Drop: Dunkler Beschwörer aus Scholomance, Scholomance"
L["Runic Leather Bracers Obt"] = "BoE Mob Drop: Kultist von Jaedenar, Teufelswald"
L["Runic Leather Shoulders Obt"] = "BoE Mob Drop: Purpurroter Kampfmagier, Stratholme"
L["Shadow Armor Kit Obt"] = "BoP Mob Drop: Zeitverlorener Schattenmagier, Sethekkhallen"
L["Stormshroud Armor Obt"] = "BoE Mob Drop: Arkkoranorakel, Azshara"
L["Stormshroud Gloves Obt"] = "BoE Mob Drop: Der Windhäscher, Silithus, Prinzessin Tempestria, Winterquell"
L["Stormshroud Shoulders Obt"] = "BoE Mob Drop: Arkkorocs Sohn, Azshara"
L["Stylin' Adventure Hat Obt"] = "BoP Mob Drop: Scharfschütze von Durnholde, Vorgebirge des Alten Hügellands"
L["Stylin' Crimson Hat Obt"] = "BoP Mob Drop: Rabenwächter der Sethekk, Sethekkhallen"
L["Stylin' Jungle Hat Obt"] = "BoP Mob Drop: Bewahrerin der Zeitrisse, Bewahrerin der Zeitrisse, Der schwarze Morast"
L["Stylin' Purple Hat Obt"] = "BoP Mob Drop: Schwarzherz der Hetzer, Schattenlabyrinth"
L["Tough Scorpid Boots Obt"] = "BoE Mob Drop: Schurke der Wüstenläufer, Tanaris"
L["Tough Scorpid Bracers Obt"] = "BoE Mob Drop: Schattenmagier der Wüstenläufer, Tanaris"
L["Tough Scorpid Breastplate Obt"] = "BoE Mob Drop: Bandit der Wüstenläufer, Tanaris"
L["Tough Scorpid Gloves Obt"] = "BoE Mob Drop: Dieb der Wüstenläufer, Tanaris"
L["Tough Scorpid Helm Obt"] = "BoE Mob Drop: Andre Feuerbart, Gesetzloser der Wüstenläufer, Tanaris"
L["Tough Scorpid Leggings Obt"] = "BoE Mob Drop: Schurke der Wüstenläufer, Tanaris"
L["Tough Scorpid Shoulders Obt"] = "BoE Mob Drop: Andre Feuerbart, Gesetzloser der Wüstenläufer, Tanaris"
L["Volcanic Breastplate Obt"] = "BoE Mob Drop: Grunzer der Feuerbrand, LBRS"
L["Volcanic Leggings Obt"] = "BoE Mob Drop: Schläger der Feuermägen, Brennende Steppe"
L["Volcanic Shoulders Obt"] = "BoE Mob Drop: Legionär der Feuerbrand, LBRS"
L["Wicked Leather Armor Obt"] = "BoE Mob Drop: Spektraler Forscher, Scholomance"
L["Wicked Leather Belt Obt"] = "BoE Mob Drop: Tobsüchtiger Ghul, Stratholme"
L["Wicked Leather Bracers Obt"] = "BoE Mob Drop: Schurke der Legashi, Azshara"
L["Wicked Leather Headband Obt"] = "BoE Mob Drop: Jadefeuerschwindler, Teufelswald"
L["Wild Leather Boots Obt"] = "Questbelohnung: Wildlederstiefel"
L["Wild Leather Cloak Obt"] = "Questbelohnung: Meister des Wildleders"
L["Wild Leather Helmet Obt"] = "Questbelohnung: Wildlederhelm"
L["Wild Leather Leggings Obt"] = "Questbelohnung: Wildledergamaschen"
L["Wild Leather Shoulders Obt"] = "Questbelohnung: Wildlederschultern"
L["Wild Leather Vest Obt"] = "Questbelohnung: Wildlederweste"

-- Smelting Obtain Information
L["Dark Iron Obt"] = "Questbelohnung: BRT. Benötigt 2 Sternrubine, 20 Gold- und 10 Echtsilberbarren. Rede mit Dunk'rel."
L["Elementium Obt"] = "Gedankenkontrolle Krixix in BWL. In der Begleiterleiste ist ein Zauber, den man sich selbst oder anderen Spielern beibringen kann."

-- Rogue Poison Obtain Information
-- Nothing here needed yet

-- Tailoring Obtain Information
L["Arcanoweave Boots Obt"] = "Astromagier der Sonnensucher"
L["Arcanoweave Bracers Obt"] = "Schildwache der Arkatraz"
L["Black Silk Pack Obt"] = "Spion des Syndikats"
L["Black Silk Pack Obt1"] = "Spitzel von Theramore"
L["Black Silk Pack Obt2"] = "Schattenhafter Auftragsmörder"
L["Cindercloth Cloak Obt"] = "Thaurissanischer Feuerwandler"
L["Cindercloth Gloves Obt"] = "Feuerwache des Schattenhammers"
L["Cindercloth Pants Obt"] = "Thaurissanischer Feuerwandler"
L["Cindercloth Vest Obt"] = "Feuerwache des Schattenhammers"
L["Cloak of Fire Obt"] = "Übermeister Pyron"
L["Felcloth Bag Obt"] = "Aus Buch neben Jandice Barov lernbar"
L["Ghostweave Belt Obt"] = "Verweilender Hochgeborener"
L["Ghostweave Gloves Obt"] = "Verweilender Hochgeborener"
L["Ghostweave Gloves Obt1"] = "Ungesehener Diener"
L["Ghostweave Pants Obt"] = "Spektraler Bürger"
L["Ghostweave Vest Obt"] = "Ungesehener Diener"
L["Mooncloth Boots Obt"] = "Hochheiliger Stoff"
L["Robe of the Archmage Obt"] = "Pyromant der Feuerbrand"
L["Robe of Winter Night Obt"] = "Kobaltblauer Magiewirker"
L["Robes of Arcana Obt"] = "Leerruferin des dunklen Strangs"
L["Robes of Arcana Obt1"] = "Verzauberer der Defias"
L["Shadoweave Mask Obt"] = "Questbelohnung: Der Untermarkt"
L["Soulcloth Shoulders Obt"] = "Phantomknecht"
L["Soulcloth Vest Obt"] = "Phantomdiener"
L["Wizardweave Leggings Obt"] = "Dunkler Beschwörer"
L["Wizardweave Robe Obt"] = "Dunkler Zauberer"
L["Wizardweave Turban Obt"] = "Dunkler Zauberer"

-- Vendor Names
L["Aaron Hollman"] = "Aaron Hollmann"
L["Abigail Shiel"] = "Abigail Shiel"
L["Aged Dalaran Wizard"] = "Gealterter Hexer von Dalaran"
L["Alchemist Gribble"] = "Alchimist Grabbel"
L["Alchemist Pestlezugg"] = "Alchimist Stößelbruch"
L["Aldraan"] = "Aldraan"
L["Alexandra Bolero"] = "Alexandra Bolero"
L["Algernon"] = "Algernon"
L["Altaa"] = "Altaa"
L["Amy Davenport"] = "Amy Davenport"
L["Andrew Hilbert"] = "Andrew Hilbert"
L["Andrion Darkspinner"] = "Andrion Dunkelweber"
L["Androd Fadran"] = "Androd Fadran"
L["Apothecary Antonivich"] = "Apotheker Antonivich"
L["Aresella"] = "Aresella"
L["Arras"] = "Arras"
L["Arred"] = "Arred"
L["Arrond"] = "Arrond"
L["Asarnan"] = "Asarnan"
L["Balai Lok'Wein"] = "Balai Lok'Wein"
L["Bale"] = "Bale"
L["Banalash"] = "Banalash"
L["Blimo Gadgetspring"] = "Blimo Federdings"
L["Blixrez Goodstitch"] = "Blixrez Gutstich"
L["Blizrik Buckshot"] = "Blizrik Bockschuss"
L["Bliztik"] = "Bliztik"
L["Bombus Finespindle"] = "Bombus Feinspindel"
L["Borto"] = "Borto"
L["Borya"] = "Borya"
L["Brienna Starglow"] = "Brienna Sternenglanz"
L["Bro'kin"] = "Bro'kin"
L["Bronk"] = "Bronk"
L["Burbik Gearspanner"] = "Burbik Ritzelspann"
L["Burko"] = "Burko"
L["Captured Gnome"] = "Gefangener Gnom"
L["Catherine Leland"] = "Catherine Leland"
L["Christoph Jeffcoat"] = "Christoph Jeffkott"
L["Clyde Ranthal"] = "Clyde Ranthal"
L["Constance Brisboise"] = "Constance Brisboise"
L["Cookie McWeaksauce"] = "Kräcka Aschebäscha"
L["Cookie One-Eye"] = "Kräcka Einauge"
L["Coreiel"] = "Coreiel"
L["Corporal Bluth"] = "Korporal Bluth"
L["Cowardly Crosby"] = "Feiger Crosby"
L["Crazk Sparks"] = "Crazk Funks"
L["Cro Threadstrong"] = "Cro Dickfädel"
L["Daga Ramba"] = "Daga Ramba"
L["Daggle Ironshaper"] = "Daggle Eisenformer"
L["Dalria"] = "Dalria"
L["Daniel Bartlett"] = "Daniel Bartlett"
L["Danielle Zipstitch"] = "Danielle Stichelnaht"
L["Darian Singh"] = "Darian Singh"
L["Darnall"] = "Darnall"
L["Dealer Malij"] = "Händler Malij"
L["Defias Profiteer"] = "Schieber der Defias"
L["Deneb Walker"] = "Deneb Wandler"
L["Derak Nightfall"] = "Derak Nachtlauer"
L["Deynna"] = "Deynna"
L["Dirge Quikcleave"] = "Dirge Schnetzelhack"
L["Doba"] = "Doba"
L["Drac Roughcut"] = "Drac Grobschnitt"
L["Drake Lindgren"] = "Drake Lindgren"
L["Drovnar Strongbrew"] = "Drovnar Starkbräu"
L["Edna Mullby"] = "Edna Mullby"
L["Egomis"] = "Egomis"
L["Eiin"] = "Eiin"
L["Elynna"] = "Elynna"
L["Emrul Riknussun"] = "Emrul Riknussun"
L["Eriden"] = "Eriden"
L["Erika Tate"] = "Erika Tate"
L["Erilia"] = "Erilia"
L["Feera"] = "Feera"
L["Felannia"] = "Felannia"
L["Felicia Doan"] = "Felicia Doan"
L["Felika"] = "Felika"
L["Fradd Swiftgear"] = "Fradd Schnellschalt"
L["Fyldan"] = "Fyldan"
L["Gagsprocket"] = "Quietschspross"
L["Gambarinka"] = "Gambarinka"
L["Gearcutter Cogspinner"] = "Ritzelschnitt Zahnrad"
L["Gelanthis"] = "Gelanthis"
L["George Candarte"] = "George Candarte"
L["Gharash"] = "Gharash"
L["Ghok'kah"] = "Ghok'kah"
L["Gidge Spellweaver"] = "Gidge Spruchwirker"
L["Gigget Zipcoil"] = "Gigget Reißspule"
L["Gikkix"] = "Gikkix"
L["Gina MacGregor"] = "Gina MacGregor"
L["Gloria Femmel"] = "Gloria Femmel"
L["Glyx Brewright"] = "Glyx Gutbräu"
L["Gnaz Blunderflame"] = "Gnaz Dusselflamm"
L["Gretta Ganter"] = "Gretta Ganter"
L["Grimtak"] = "Grimtak"
L["Haalrun"] = "Haalrun"
L["Haferet"] = "Haferet"
L["Hagrus"] = "Hagrus"
L["Hammon Karwn"] = "Hammon Karwn"
L["Harggan"] = "Harggan"
L["Harklan Moongrove"] = "Harklan Mondhain"
L["Harlown Darkweave"] = "Harlown Dunkelwirker"
L["Harn Longcast"] = "Harn Rutenwurf"
L["Heldan Galesong"] = "Heldan Sturmgesang"
L["Helenia Olden"] = "Helenia Olden"
L["Himmik"] = "Himmik"
L["Hula'mahi"] = "Hula'mahi"
L["Innkeeper Biribi"] = "Gastwirtin Biribi"
L["Innkeeper Fizzgrimble"] = "Gastwirt Zischgrimbel"
L["Innkeeper Grilka"] = "Gastwirtin Grilka"
L["Jabbey"] = "Stupser"
L["Jandia"] = "Jandia"
L["Janet Hommers"] = "Janet Hommers"
L["Jangdor Swiftstrider"] = "Jangdor Flinkschreiter"
L["Jannos Ironwill"] = "Jannos Eisenwill"
L["Jaquilina Dramet"] = "Jaquilina Dramet"
L["Jase Farlane"] = "Jase Langweg"
L["Jazzrik"] = "Jazzrik"
L["Jeeda"] = "Jeeda"
L["Jennabink Powerseam"] = "Jennabink Starksaum"
L["Jessara Cordell"] = "Jessara Cordell"
L["Jim Saltit"] = "Jim Salzit"
L["Jinky Twizzlefixxit"] = "Jinky Pfuschelfix"
L["Johan Barnes"] = "Johan Barnes"
L["Joseph Moore"] = "Joseph Moor"
L["Jubie Gadgetspring"] = "Jubie Federdings"
L["Jun'ha"] = "Jun'ha"
L["Juno Dufrain"] = "Juno Dufrain"
L["Jutak"] = "Jutak"
L["Kaita Deepforge"] = "Kaita Tiefenschmied"
L["Kalaen"] = "Kalaen"
L["Kalldan Felmoon"] = "Kalldan Teufelsmond"
L["Kania"] = "Kania"
L["Keena"] = "Keena"
L["Kelsey Yance"] = "Kelsey Yance"
L["Kendor Kabonka"] = "Kendor Kabonka"
L["Khara Deepwater"] = "Khara Tiefenwasser"
L["Kiknikle"] = "Kiknikle"
L["Killian Sanatha"] = "Killian Sanatha"
L["Kilxx"] = "Kilxx"
L["Kireena"] = "Kireena"
L["Kithas"] = "Kithas"
L["Knaz Blunderflame"] = "Knaz Dusselflamm"
L["Kor'geld"] = "Kor'geld"
L["Krek Cragcrush"] = "Krek Schmetterfels"
L["Kriggon Talsone"] = "Kriggon Talsone"
L["Krinkle Goodsteel"] = "Krinkle Goldstahl"
L["Kulwia"] = "Kulwia"
L["Kzixx"] = "Kzixx"
L["Laird"] = "Laird"
L["Landraelanis"] = "Landraelanis"
L["Lardan"] = "Lardan"
L["Lebowski"] = "Lebowski"
L["Leeli Longhaggle"] = "Leeli Langfeilsch"
L["Leo Sarn"] = "Leo Sarn"
L["Leonard Porter"] = "Leonard Porter"
L["Lilly"] = "Lilly"
L["Lindea Rabonne"] = "Lindea Rabonne"
L["Lizbeth Cromwell"] = "Lizbeth Kromwell"
L["Logannas"] = "Logannas"
L["Loolruna"] = "Loolruna"
L["Lorelae Wintersong"] = "Lorelae Winterklang"
L["Lyna"] = "Lyna"
L["Madame Ruby"] = "Madame Rubin"
L["Mahu"] = "Mahu"
L["Mallen Swain"] = "Mallen Knab"
L["Malygen"] = "Malygen"
L["Mari Stonehand"] = "Mari Steinhand"
L["Maria Lumere"] = "Maria Lumere"
L["Martine Tramblay"] = "Martine Tramblei"
L["Masat T'andr"] = "Masat T'andr"
L["Master Chef Mouldier"] = "Meisterkoch Mouldier"
L["Mathar G'ochar"] = "Mathar G'ochar"
L["Mavralyn"] = "Mavralyn"
L["Mazk Snipeshot"] = "Mazk Zielschuss"
L["Melaris"] = "Melaris"
L["Micha Yance"] = "Micha Yance"
L["Millie Gregorian"] = "Millie Gregorian"
L["Mishta"] = "Mishta"
L["Mixie Farshot"] = "Mixie Weitschuss"
L["Montarr"] = "Montarr"
L["Muheru the Weaver"] = "Muheru der Weber"
L["Muuran"] = "Muuran"
L["Mythrin'dir"] = "Mythrin'dir"
L["Naal Mistrunner"] = "Naal Nebelläufer"
L["Namdo Bizzfizzle"] = "Namdo Blitzzischel"
L["Nandar Branson"] = "Nandar Branson"
L["Narkk"] = "Narkk"
L["Nasmara Moonsong"] = "Nasmara Mondweise"
L["Nata Dawnstrider"] = "Nata Morgenwandler"
L["Neal Allen"] = "Neal Allen"
L["Neii"] = "Neii"
L["Nergal"] = "Nergal"
L["Nerrist"] = "Nerrist"
L["Nessa Shadowsong"] = "Nessa Schattensang"
L["Nina Lightbrew"] = "Nina Brauleicht"
L["Nioma"] = "Nioma"
L["Nula the Butcher"] = "Nula die Metzgerin"
L["Nyoma"] = "Nyoma"
L["Ogg'marr"] = "Ogg'marr"
L["Otho Moji'ko"] = "Otho Moji'ko"
L["Outfitter Eric"] = "Ausstatter Eric"
L["Phea"] = "Phea"
L["Plugger Spazzring"] = "Stöpsel Zapfring"
L["Pratt McGrubben"] = "Pratt McGrubben"
L["Qia"] = "Qia"
L["Quartermaster Davian Vaclav"] = "Rüstmeister Davian Watzlav"
L["Quartermaster Jaffrey Noreliqe"] = "Rüstmeister Jaffrey Keinespuhr"
L["Quelis"] = "Quelis"
L["Ranik"] = "Ranik"
L["Rann Flamespinner"] = "Rann Flammenweber"
L["Rartar"] = "Rartar"
L["Rathis Tomber"] = "Rathis Tomber"
L["Rikqiz"] = "Rikqiz"
L["Rizz Loosebolt"] = "Rizz Wackelbolz"
L["Rohok"] = "Rohok"
L["Ronald Burch"] = "Ronald Burch"
L["Rungor"] = "Rungor"
L["Ruppo Zipcoil"] = "Ruppo Reißspule"
L["Saenorion"] = "Saenorion"
L["Seer Janidi"] = "Seherin Janidi"
L["Sewa Mistrunner"] = "Sewa Nebelläufer"
L["Shadi Mistrunner"] = "Shadi Nebelläufer"
L["Shankys"] = "Shankys"
L["Sheendra Tallgrass"] = "Sheendra Hochschilf"
L["Shen'dralar Provisioner"] = "Versorger der Shen'dralar"
L["Sheri Zipstitch"] = "Sheri Stichelnaht"
L["Sid Limbardi"] = "Sid Limbardi"
L["Skreah"] = "Skreah"
L["Soolie Berryfizz"] = "Soolie Brausefitz"
L["Sovik"] = "Sovik"
L["Stuart Fleming"] = "Stuart Fleming"
L["Sumi"] = "Sumi"
L["Super-Seller 680"] = "Superverkaufomat 680"
L["Supply Officer Mills"] = "Versorgungsoffizier Mühlens"
L["Tamar"] = "Tamar"
L["Tansy Puddlefizz"] = "Tansy Pfützplatsch"
L["Tarban Hearthgrain"] = "Tarban Kornbäcker"
L["Tari'qa"] = "Tari'qa"
L["Tatiana"] = "Tatiana"
L["Thaddeus Webb"] = "Thaddeus Webner"
L["Tharynn Bouden"] = "Tharynn Bouden"
L["Thomas Yance"] = "Thomas Yance"
L["Tilli Thistlefuzz"] = "Tilli Distelflaum"
L["Truk Wildbeard"] = "Truk Wildbart"
L["Tunkk"] = "Tunkk"
L["Ulthaan"] = "Ulthaan"
L["Ulthir"] = "Ulthir"
L["Uriku"] = "Uriku"
L["Uthok"] = "Uthok"
L["Vaean"] = "Vaean"
L["Valdaron"] = "Valdaron"
L["Veenix"] = "Veenix"
L["Vendor-Tron 1000"] = "Kaufotron 1000"
L["Vharr"] = "Vharr"
L["Viggz Shinesparked"] = "Viggz Funkenschimmer"
L["Vivianna"] = "Vivianna"
L["Vizzklick"] = "Vizzklick"
L["Vodesiin"] = "Vodesiin"
L["Wenna Silkbeard"] = "Wenna Seidenbart"
L["Werg Thickblade"] = "Werg Breitklinge"
L["Wik'Tar"] = "Wik'Tar"
L["Wind Trader Lathrai"] = "Windhändler Lathrai"
L["Wrahk"] = "Wrahk"
L["Wulan"] = "Wulan"
L["Wunna Darkmane"] = "Wunna Dunkelmähne"
L["Xandar Goodbeard"] = "Xandar Gutbart"
L["Xen'to"] = "Xen'to"
L["Xizk Goodstitch"] = "Xizk Gutstich"
L["Xizzer Fizzbolt"] = "Xizzer Zischbolz"
L["Yatheon"] = "Yatheon"
L["Yonada"] = "Yonada"
L["Yuka Screwspigot"] = "Yuka Schraubstutz"
L["Yurial Soulwater"] = "Yurial Seelenwasser"
L["Zan Shivsproket"] = "Zan Messerritzel"
L["Zannok Hidepiercer"] = "Zannok Ledernaht"
L["Zansoa"] = "Zansoa"
L["Zaralda"] = "Zaralda"
L["Zarena Cromwind"] = "Zarena Stahlwind"
L["Zixil"] = "Zixil"
L["Zorbin Fandazzle"] = "Zorbin von Schiller"
L["Zurai"] = "Zurai"
L["Narj Deepslice"] = "Narj Schnitzelschnitt"
L["Fazu"] = "Fazu"
L["Zargh"] = "Zargh"
L["Smudge Thunderwood"] = "Smudge Donnerholz"
L["Sassa Weldwell"] = "Sassa Nahtgut"