﻿AMPFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0");

local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")

AMPFu.title = "Answering Machine Plus";
AMPFu.category = "Chat/Communication";
AMPFu.cannotDetachTooltip  = true;
AMPFu.tooltipHiddenWhenEmpty  = true;

local COLOR_TELL = "ff7fff"
local COLOR_SYSTEM = "ffff00"
local COLOR_WHITE = "ffffff"

function AMPFu:OnInitialize()
	self.cannotHideText = false
	self.cannotAttachToMinimap = true
	self.hasNoColor = false
	self.hasIcon = true
	self:SetIcon(true)
	self:RegisterDB("AMPFuDB")
	self:RegisterDefaults('profile', {
		showText = true,
		showIcon = true
	})
end

function AMPFu:ToggleMSGPersist()
    AMP_ToggleMsgPersist()
    self:Update()
end

function AMPFu:ToggleAMPFrame()
    AMP_ToggleAMPFrame()
    self:Update()
end

function AMPFu:ToggleRecordAFK()
    AMP_ToggleRecAFK()
    self:Update()
end

function AMPFu:ToggleAutoClear()
    AMP_ToggleAutoClear()
    self:Update()
end

function AMPFu:ToggleRecordDND()
    AMP_ToggleRecDND()
    self:Update()
end

function AMPFu:ToggleRecordAuction()
    AMP_ToggleRecAUCTION()
    self:Update()
end

function AMPFu:ToggleCheckIgnore()
    AMP_ToggleChkIgnore()
    self:Update()
end

function AMPFu:OnMenuRequest(level, value)
	if level == 1 then
		dewdrop:AddLine(
			'text', AMP_REC_AFK_MENU,
			'arg1', self,
			'func', "ToggleRecordAFK",
			'checked', AMPConfig.rec_AFK,
			'closeWhenClicked', false
		)
		dewdrop:AddLine(
			'text', AMP_REC_DND_MENU,
			'arg1', self,
			'func', "ToggleRecordDND",
			'checked', AMPConfig.rec_DND,
			'closeWhenClicked', false
		)
		dewdrop:AddLine(
			'text', AMP_REC_AUCTION_MENU,
			'arg1', self,
			'func', "ToggleRecordAuction",
			'checked', AMPConfig.rec_AUCTION,
			'closeWhenClicked', false
		)
		dewdrop:AddLine()
		dewdrop:AddLine(
			'text', AMP_IN_COMBAT_MENU,
			'hasArrow', true,
			'value', AMP_IN_COMBAT_MENU
		)
		dewdrop:AddLine(
			'text', AMP_IGNORE_MENU,
			'arg1', self,
			'func', "ToggleCheckIgnore",
			'checked', AMPConfig.chk_Ignore,
			'closeWhenClicked', false
		)
		dewdrop:AddLine(
			'text', AMP_AUTOCLEAR_MENU,
			'arg1', self,
			'func', "ToggleAutoClear",
			'checked', AMPConfig.autoclear,
			'closeWhenClicked', false
		)
		dewdrop:AddLine(
			'text', AMP_FRAME_MENU,
			'arg1', self,
			'func', "ToggleAMPFrame",
			'checked', AMPConfig.AMP_Frame,
			'closeWhenClicked', false
		)
		dewdrop:AddLine(
			'text', AMP_MSG_MENU,
			'arg1', self,
			'func', "ToggleMSGPersist",
			'checked', AMPConfig.MSG_Persists,
			'closeWhenClicked', false
		)
	elseif level == 2 then
		if value == AMP_IN_COMBAT_MENU then
			dewdrop:AddLine(
				'text', AMP_ON,
				'arg1', self,
				'func', function()
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_ON)
				end,
				'isRadio', true,
				'checked', AMPConfig.autoreply_COMBAT == AMP_COMBAT_MODE_ON,
				'closeWhenClicked', false
			)
			dewdrop:AddLine(
				'text', AMP_ALWAYS,
				'arg1', self,
				'func', function()
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_ALWAYS)
				end,
				'isRadio', true,
				'checked', AMPConfig.autoreply_COMBAT == AMP_COMBAT_MODE_ALWAYS,
				'closeWhenClicked', false
			)
			dewdrop:AddLine(
				'text', AMP_OFF,
				'arg1', self,
				'func', function()
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_NEVER)
				end,
				'isRadio', true,
				'checked', AMPConfig.autoreply_COMBAT == AMP_COMBAT_MODE_NEVER,
				'closeWhenClicked', false
			)
		end
	end
end

function AMPFu:OnDataUpdate()
end

function AMPFu:OnTextUpdate()
    	local text
	if self:IsTextColored() then
		text = format("|cff%s%d|r|cff%s/|r|cff%s%d|r", COLOR_TELL, AMP_getMissedTells(),COLOR_WHITE, COLOR_SYSTEM, AMP_getMissedAuctions())
	else
		text = AMP_getMissedTells() .. "/" .. AMP_getMissedAuctions()
	end
	if self:IsTextShown() then
		self:SetText(text)
	end
	if self:IsIconShown() then
		self:ShowIcon()
	else
		self:HideIcon()
	end
end

function AMPFu:OnTooltipUpdate()
    local cat = tablet:AddCategory(
        'text', "",
        'columns', 1,
        'child_textR', 1,
        'child_textG', 1,
        'child_textB', 0
    )
    
    cat:AddLine(
        'text', AMP_GetTooltipText()
    )
end

function AMPFu:OnClick()
	if (arg1 == "LeftButton") then
		AMP_Retell_Msgs()
	end
end