﻿AMP_Missed_Auctions = { }
AMP_Missed_Tells = { }
AMP_Missed_Authors = { }

local Is_RECORDING = false
local Is_COMBAT = false
local Is_AFK = false
local Is_DND = false
local Is_BG = false
local Autoreplies = {}
local LCLICK, RCLICK, DCLICK = 1, 2, 3

local variables = {
	{"!target!", "local x,y=UnitName(\"target\");return x" },
	{"!targethp!", "local x,y=UnitName(\"target\");if x then return UnitHealth(\"target\")..\"%%\" else return nil end" },
	{"!targetlevel!", "local x,y=UnitName(\"target\");if x then return UnitLevel(\"target\") else return nil end" },
	{"!loc!", "local x, y = GetPlayerMapPosition(\"player\");return format(\"(%s,%s)\",floor(x*100),floor(y*100))" },
	{"!z!", "return GetZoneText()" },
	{"!sz!", "return GetMinimapZoneText()" },
}

-- Ignore strings are case insenstive
local Default_AMPConfig = {
	["Version"] = AMP_VERSION,
	["Ignore_Strings"] = {
		[1] = "<GA",
		[2] = "<GEM",
	 },
	["chk_Ignore"] = true,
	["autoreply_COMBAT"] = AMP_COMBAT_MODE_NEVER,
	["rec_AFK"] = true,
	["rec_DND"] = true,
	["rec_AUCTION"] = true,
	["autoclear"] = true,
	["AMP_Frame"] = false,
	["AMP_Frame_Click"] = DCLICK,
	["AFK_Msg"] = "",
	["Msg_Persist"] = false,
	["DND_Msg"] = "",
	["Combat_Msg"] = AMP_IN_COMBAT_AUTO_MSG,
}
AMPConfig = {}

function AMP_OnLoad()
	AMPFrame:RegisterEvent("ADDON_LOADED")
	AMPFrame:RegisterEvent("ZONE_CHANGED")
	AMPFrame:RegisterEvent("ZONE_CHANGED_NEW_AREA")
	AMPFrame:RegisterEvent("CHAT_MSG_SYSTEM")
	AMPFrame:RegisterEvent("CHAT_MSG_WHISPER")
	AMPFrame:RegisterForDrag("LeftButton")
	AMP_Print(AMP_MENU..AMP_LOADED, 1.0, 1.0, 0)
end

function AMP_OnEvent(frame, event, arg_1, arg_2)
	if event == "PLAYER_REGEN_ENABLED" then
		Is_COMBAT = false
	elseif event == "PLAYER_REGEN_DISABLED" then
		Is_COMBAT = true
	elseif event == "CHAT_MSG_SYSTEM" then
		if strfind(arg_1, strsub(MARKED_AFK_MESSAGE, 1, strlen(MARKED_AFK_MESSAGE) - 4), 1) then
			if AMPConfig.rec_AFK then
				AMP_Record()
			elseif Is_DND then
				AMP_Stop()
			end
			Is_AFK = true
			if Is_DND then
				Is_DND = false
			end
		elseif strfind(arg_1, strsub(MARKED_DND, 1, strlen(MARKED_DND) - 3), 1) then
			if AMPConfig.rec_DND then
				AMP_Record()
			elseif Is_AFK then
				AMP_Stop()
			end
			Is_DND = true
			if Is_AFK then
				Is_AFK = false
			end
		elseif arg_1 == CLEARED_AFK then
			AMP_Stop()
			Is_AFK = false
		elseif arg_1 == CLEARED_DND then
			AMP_Stop()
			Is_DND = false
		elseif strfind(arg_1, AMP_AUCTION_SOLD) then
			AMP_RecordAH(arg_1)
		elseif strfind(arg_1, AMP_AUCTION_EXPIRE) then
			AMP_RecordAH(arg_1)
		elseif strfind(arg_1, AMP_AUCTION_OUTBID) then
			AMP_RecordAH(arg_1)
		elseif strfind(arg_1, AMP_AUCTION_WON) then
			AMP_RecordAH(arg_1)
		elseif strfind(arg_1, AMP_AUCTION_BID) then
			AMP_RecordAH(arg_1)
		end
	elseif event == "CHAT_MSG_WHISPER" then
		if AMPConfig.autoreply_COMBAT ~= AMP_COMBAT_MODE_NEVER and Is_COMBAT then
			local Autoreplied = false
			if AMPConfig.autoreply_COMBAT == AMP_COMBAT_MODE_ON then
				for i=1, #(Autoreplies) do
					if (Autoreplies[i] == arg_2) then
						Autoreplied = true
						break
					end
				end
			end
			if Autoreplied == false and UnitName("player") ~= arg_2 then
				SendChatMessage(AMP_ReplaceVariables(AMPConfig.Combat_Msg), "WHISPER", GetDefaultLanguage("player"), arg_2)
				table.insert(Autoreplies, arg_2)
			end
		end
		if Is_RECORDING then
			if AMPConfig.chk_Ignore then
				if (AMP_Check_Ignore_Strings(arg_1) == false) then
					AMP_RecordWhispers(arg_1, arg_2)
				end
			else
				AMP_RecordWhispers(arg_1, arg_2)
			end
		end
	elseif event == "ZONE_CHANGED" or event == "ZONE_CHANGED_NEW_AREA" then
		Is_BG = false
		local currentZoneName = GetZoneText()
		for i=1, #(AMP_BG) do
			if (currentZoneName == AMP_BG[i]) then
				Is_BG = true
				break
			end
		end
	elseif event == "ADDON_LOADED" and arg_1 == "AMP" then
		SlashCmdList["AMP"] = AMP_SlashHandler
		SLASH_AMP1 = "/answer"
		SLASH_AMP2 = "/amp"
		if AMPConfig == nil or AMPConfig.Version ~= Default_AMPConfig.Version then
			AMPConfig = Default_AMPConfig
		else
			if AMPConfig.Msg_Persist then
				if AMPConfig.AFK_Msg ~= "" then
					DEFAULT_AFK_MESSAGE = AMPConfig.AFK_Msg
				end
				if AMPConfig.DND_Msg ~= "" then
					DEFAULT_DND_MESSAGE = AMPConfig.DND_Msg
				end
			end
		end
	end
end

function AMP_SlashHandler(msg)
	local words = {}
	for word in string.gmatch(msg, "%w+") do
		table.insert(words, word)
	end
	if #(words) == 0 then
		AMP_Print(AMP_AFK_MSG_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_DND_MSG_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_COMBAT_MSG_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_MSG_PERSIST_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_FRAME_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_REC_AFK_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_REC_DND_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_REC_AUCTION_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_REC_COMBAT_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_PLAY_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_CLEAR_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_AUTOCLEAR_HELP.."\n\n", 1.0, 1.0, 0.0)
		AMP_Print(AMP_IGNORE_HELP, 1.0, 1.0, 0.0)
	else
		local cmd = strlower(words[1])
		if cmd == "clear" then
			AMP_Clear()
		elseif cmd == "play" then
			AMP_Retell_Msgs()
		elseif cmd == "afkmsg" then
			if #(words) > 1 then
				local afk_msg = AMP_Strip(msg, cmd.." ")
				if afk_msg == nil or afk_msg == "" then
					AMP_Print(AMP_AWAY_MSG..DEFAULT_AFK_MESSAGE, 1.0, 1.0, 0.0)
				else
					AMPConfig.AFK_Msg = afk_msg
					DEFAULT_AFK_MESSAGE = AMPConfig.AFK_Msg
					AMP_Print(AMP_DEFAULT_AFK..DEFAULT_AFK_MESSAGE, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "dndmsg" then
			if #(words) > 1 then
				local dnd_msg = AMP_Strip(msg, cmd.." ")
				if dnd_msg == nil or dnd_msg == "" then
					AMP_Print(AMP_DND_MSG..DEFAULT_DND_MESSAGE, 1.0, 1.0, 0.0)
				else
					AMPConfig.DND_Msg = dnd_msg
					DEFAULT_DND_MESSAGE = AMPConfig.DND_Msg
					AMP_Print(AMP_DEFAULT_DND..DEFAULT_DND_MESSAGE, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "combatmsg" then
			if #(words) > 1 then
				local combat_msg = AMP_Strip(msg, cmd.." ")
				if combat_msg == nil or combat_msg == "" then
					AMP_Print(AMP_COMBAT_MSG..AMPConfig.Combat_Msg, 1.0, 1.0, 0.0)
				else
					AMPConfig.Combat_Msg = combat_msg
					AMP_Print(AMP_COMBAT_MSG..AMPConfig.Combat_Msg, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "msgpersist" then
			if #(words) == 1 then
				AMP_MsgPersist(AMPConfig.Msg_Persist)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_MsgPersist(true)
				elseif param == "off" then
					AMP_MsgPersist(false)
				else
					AMP_Print(AMP_MSG_PERSIST_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "frame" then
			if #(words) == 1 then
				AMP_AMPFrame(AMPConfig.AMP_Frame)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_AMPFrame(true)
				elseif param == "off" then
					AMP_AMPFrame(false)
				elseif param == "right" then
					AMP_Print(AMP_FRAME_STATUS..AMP_RCLICK, 1.0, 1.0, 0.0)
					AMPConfig.AMP_Frame_Click = RCLICK
				elseif param == "left" then
					AMP_Print(AMP_FRAME_STATUS..AMP_LCLICK, 1.0, 1.0, 0.0)
					AMPConfig.AMP_Frame_Click = LCLICK
				elseif param == "double" then
					AMP_Print(AMP_FRAME_STATUS..AMP_DCLICK, 1.0, 1.0, 0.0)
					AMPConfig.AMP_Frame_Click = DCLICK
				else
					AMP_Print(AMP_FRAME_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "afk" then
			if #(words) == 1 then
				AMP_RecAFK(AMPConfig.rec_AFK)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_RecAFK(true)
				elseif param == "off" then
					AMP_RecAFK(false)
				else
					AMP_Print(AMP_REC_AFK_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "dnd" then
			if #(words) == 1 then
				AMP_RecDND(AMPConfig.rec_DND)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_RecDND(true)
				elseif param == "off" then
					AMP_RecDND(false)
				else
					AMP_Print(AMP_REC_DND_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "auction" then
			if #(words) == 1 then
				AMP_RecAuction(AMPConfig.rec_AUCTION)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_RecAuction(true)
				elseif param == "off" then
					AMP_RecAuction(false)
				else
					AMP_Print(AMP_REC_AUCTION_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "ignore" then
			if #(words) == 1 then
				AMP_ChkIgnore(AMPConfig.chk_Ignore)
			elseif strlower(words[2]) == "on" then
				AMP_ChkIgnore(true)
			elseif strlower(words[2]) == "off" then
				AMP_ChkIgnore(false)
			elseif #(words) == 3 then
				if strlower(words[2]) == "add" then
					AMP_Insert_Ignore_String(words[3])
				elseif strlower(words[2]) == "remove" then
					AMP_Remove_Ignore_String(words[3])
				end
			elseif strlower(words[2]) == "list" then
				AMP_Print_Ignore_Strings()
			else
				AMP_Print(AMP_IGNORE_HELP, 1.0, 1.0, 0.0)
			end
		elseif cmd == "combat" then
			if #(words) == 1 then
				AMP_AutoReplyInCombat(AMPConfig.autoreply_COMBAT)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_ON)
				elseif param == "off" then
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_NEVER)
				elseif param == "AMP_COMBAT_MODE_ALWAYS" then
					AMP_AutoReplyInCombat(AMP_COMBAT_MODE_ALWAYS)
				else
					AMP_Print(AMP_REC_COMBAT_HELP, 1.0, 1.0, 0.0)
				end
			end
		elseif cmd == "autoclear" then
			if #(words) == 1 then
				AMP_AutoClear(AMPConfig.autoclear)
			else
				local param = strlower(words[2])
				if param == "on" then
					AMP_AutoClear(true)
				elseif param == "off" then
					AMP_AutoClear(false)
				else
					AMP_Print(AMP_AUTOCLEAR_HELP, 1.0, 1.0, 0.0)
				end
			end
		end
	end
end

function AMP_RecordAH(x)
	if Is_RECORDING and AMPConfig.rec_AUCTION then
		table.insert(AMP_Missed_Auctions, x)
		AMP_Text:SetText(AMP_MISSED1..#(AMP_Missed_Auctions)..AMP_MISSED3)
	else
		AMP_Error(x, 1.0, 1.0, 0.0, 1.0, 10)
		PlaySound("AuctionWindowClose")
	end
	if IsAddOnLoaded("AMPFu") then
		AMPFu:Update()
	end
end

function AMP_RecordWhispers(x, y)
	table.insert(AMP_Missed_Tells, x)
	table.insert(AMP_Missed_Authors, y)
	AMP_Text:SetText(AMP_MISSED1..#(AMP_Missed_Tells)..AMP_MISSED2)
	if IsAddOnLoaded("AMPFu") then
		AMPFu:Update()
	end
end

function AMP_getMissedTells()
	return #(AMP_Missed_Tells)
end

function AMP_getMissedAuctions()
	return #(AMP_Missed_Auctions)
end

function AMP_Record()
	if Is_BG then
		AMP_Print(AMP_REC..AMP_BG_DISABLED..GetZoneText(), 1.0, 1.0, 0)
	else
		Is_RECORDING = true
		AMP_Print(AMP_REC..AMP_ON, 1.0, 1.0, 0)
		if AMPConfig.AMP_Frame then
			AMPFrame:Show()
		end
	end
end

function AMP_Stop()
	if Is_RECORDING then
		Is_RECORDING = false
		AMP_Retell_Msgs()
		Autoreplies = {}
		AMPFrame:Hide()
		AMP_Print(AMP_REC..AMP_OFF, 1.0, 1.0, 0)
	end
end

function AMP_Clear()
	AMP_Missed_Tells = { }
	AMP_Missed_Auctions = { }
	AMP_Missed_Authors = { }
	AMP_Text:SetText("")
	if IsAddOnLoaded("AMPFu") then
		AMPFu:Update()
	end
end

function AMP_Retell_Msgs()
	if #(AMP_Missed_Tells) > 0 then
		AMP_Print(AMP_SEPARATOR.."\n"..AMP_MISSED1..#(AMP_Missed_Tells)..AMP_MISSED2, 1.0, 0.5, 1.0)
		for i=1,#(AMP_Missed_Tells) do
			AMP_Print("[|Hplayer:"..AMP_Missed_Authors[i].."|h"..AMP_Missed_Authors[i].."|h]: "..AMP_Missed_Tells[i], 1.0, 0.5, 1.0)
		end
		AMP_Print(AMP_SEPARATOR, 1.0, 0.5, 1.0)
	else
		AMP_Print(AMP_NOTELLS, 1.0, 1.0, 0.0)
	end
	if #(AMP_Missed_Auctions) > 0 then
		AMP_Print(AMP_SEPARATOR.."\n"..AMP_MISSED1..#(AMP_Missed_Auctions)..AMP_MISSED3, 1.0, 1.0, 0)
		for i=1,#(AMP_Missed_Auctions) do
			AMP_Print(AMP_Missed_Auctions[i], 1.0, 1.0, 0)
		end
		AMP_Print(AMP_SEPARATOR, 1.0, 1.0, 0)
	else
		AMP_Print(AMP_NOAUCTIONS, 1.0, 1.0, 0)
	end
	if AMPConfig.autoclear then
		AMP_Clear()
	end
end

-- ===================
-- AMPFRAME FUNCTIONS 
-- ===================

function AMP_AMPFrame(x)
	AMPConfig.AMP_Frame = x
	if x then
		if Is_RECORDING then
			AMPFrame:Show()
			AMP_Text:SetText(AMP_MISSED1..#(AMP_Missed_Tells)..AMP_MISSED2)
		end
		AMP_Print(AMP_FRAME_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMPFrame:Hide()
		AMP_Print(AMP_FRAME_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_OnDragStart(frame, arg_1)
	AMPFrame:StartMoving()
end

function AMP_OnDragStop(frame, arg_1)
	AMPFrame:StopMovingOrSizing()
end

function AMP_Frame_OnClick(frame, arg_1, arg_2)
	if AMPFrame.isMoving ~= true then
		if AMPConfig.AMP_Frame_Click == LCLICK and arg_1 == "LeftButton" then
			AMP_Retell_Msgs()
		elseif AMPConfig.AMP_Frame_Click == RCLICK and arg_1 == "RightButton" then
			AMP_Retell_Msgs()
		end
	end
end

function AMP_Frame_OnDoubleClick(frame, arg_1)
	if AMPFrame.isMoving ~= true and AMPConfig.AMP_Frame_Click == DCLICK then
		AMP_Retell_Msgs()
	end
end

-- =================
-- IGNORE FUNCTIONS 
-- =================

function AMP_Print_Ignore_Strings()
	local ignore_strings = #(AMPConfig.Ignore_Strings)
	if ignore_strings > 0 then
		AMP_Print(AMP_SEPARATOR.."\n"..AMP_IGNORE_STATUS..ignore_strings, 1.0, 1.0, 0)
		for k,v in pairs(AMPConfig.Ignore_Strings) do
			AMP_Print(v, 1.0, 1.0, 0)
		end
		AMP_Print(AMP_SEPARATOR, 1.0, 1.0, 0)
	else
		AMP_Print(AMP_NOIGNORES, 1.0, 1.0, 0)
	end
end

function AMP_Insert_Ignore_String(x)
	if strlen(x) > 0 and AMP_Check_Ignore_Strings_Exists(x) == false then
		table.insert(AMPConfig.Ignore_Strings, strupper(x))
		AMP_Print(x..AMP_IGNORE_ADDED, 1.0, 1.0, 0)
	else
		AMP_Print(x..AMP_IGNORE_PREEXISTS, 1.0, 1.0, 0)
	end
end

function AMP_Remove_Ignore_String(x)
	if strlen(x) > 0 then
		local index = AMP_Check_Ignore_Strings_Exists(x)
		if index then
			table.remove(AMPConfig.Ignore_Strings, index)
			AMP_Print(x..AMP_IGNORE_REMOVED, 1.0, 1.0, 0)
		else
			AMP_Print(x..AMP_IGNORE_NOTEXISTS, 1.0, 1.0, 0)
		end
	end
end

function AMP_Check_Ignore_Strings_Exists(x)
	for k,v in pairs(AMPConfig.Ignore_Strings) do
		if strupper(x) == v then
			return k
		end
	end
	return false
end

function AMP_Check_Ignore_Strings(x)
	for k,v in pairs(AMPConfig.Ignore_Strings) do
		if strfind(strupper(x), v) then
			return k
		end
	end
	return false
end

-- =====================
-- BAR PLUGIN FUNCTIONS 
-- =====================

function AMP_GetTooltipText()
	local text = ""
	if Is_BG then
		text = AMP_REC..AMP_BG_DISABLED..GetZoneText()
	elseif Is_RECORDING then
		text = AMP_REC..AMP_ON.."\n"..AMP_MISSED1..#(AMP_Missed_Tells)..AMP_MISSED2.."\n"..AMP_MISSED1..#(AMP_Missed_Auctions)..AMP_MISSED3.."\n|cff00ff00".. AMP_HINT.."|r"
	else
		text = AMP_REC..AMP_OFF
	end
	if AMPConfig.Msg_Persist then
		if AMPConfig.AFK_Msg then
			text = text.."\n\nAFK: "..AMPConfig.AFK_Msg
		end
		if AMPConfig.DND_Msg then
			text = text.."\nDND: "..AMPConfig.DND_Msg
		end
	end
	if AMPConfig.autoreply_COMBAT ~= AMP_COMBAT_MODE_NEVER then
		text = text.."\nCombat: "..AMP_ReplaceVariables(AMPConfig.Combat_Msg)
	end
	return text
end

-- =================
-- OPTION FUNCTIONS 
-- =================

function AMP_MsgPersist(x)
	AMPConfig.Msg_Persist = x
	if x then
		AMP_Print(AMP_MSG_PERSIST_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMP_Print(AMP_MSG_PERSIST_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_AutoClear(x)
	AMPConfig.autoclear = x
	if x then
		AMP_Print(AMP_AUTOCLEAR_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMP_Print(AMP_AUTOCLEAR_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_ChkIgnore(x)
	AMPConfig.chk_Ignore = x
	if x then
		AMP_Print(AMP_IGNORE_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMP_Print(AMP_IGNORE_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_RecAuction(x)
	AMPConfig.rec_AUCTION = x
	if x then
		AMP_Print(AMP_REC_AUCTION_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMP_Print(AMP_REC_AUCTION_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_RecDND(x)
	AMPConfig.rec_DND = x
	if x then
		AMP_Print(AMP_REC_DND_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		if (Is_DND) then
			AMP_Stop()
		end
		AMP_Print(AMP_REC_DND_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_RecAFK(x)
	AMPConfig.rec_AFK = x
	if x then
		AMP_Print(AMP_REC_AFK_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		if (Is_AFK) then
			AMP_Stop()
		end
		AMP_Print(AMP_REC_AFK_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_AutoReplyInCombat(x)
	AMPConfig.autoreply_COMBAT = x
	if x == AMP_COMBAT_MODE_ON then
		AMP_Print(AMP_REC_COMBAT_STATUS..AMP_ON, 1.0, 1.0, 0.0)
		AMPFrame:RegisterEvent("PLAYER_REGEN_DISABLED")
		AMPFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
	elseif x == AMP_COMBAT_MODE_ALWAYS then
		AMP_Print(AMP_REC_COMBAT_STATUS..AMP_ALWAYS, 1.0, 1.0, 0.0)
		AMPFrame:RegisterEvent("PLAYER_REGEN_DISABLED")
		AMPFrame:RegisterEvent("PLAYER_REGEN_ENABLED")
	elseif x == AMP_COMBAT_MODE_NEVER then
		AMP_Print(AMP_REC_COMBAT_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
		AMPFrame:UnregisterEvent("PLAYER_REGEN_DISABLED")
		AMPFrame:UnregisterEvent("PLAYER_REGEN_ENABLED")
		Is_COMBAT = false
	end
end

function AMP_ChkIgnore(x)
	AMPConfig.chk_Ignore = x
	if x then
		AMP_Print(AMP_IGNORE_STATUS..AMP_ON, 1.0, 1.0, 0.0)
	else
		AMP_Print(AMP_IGNORE_STATUS..AMP_OFF, 1.0, 1.0, 0.0)
	end
end

function AMP_ToggleAMPFrame()
	AMP_AMPFrame(not AMPConfig.AMP_Frame)
end

function AMP_ToggleMsgPersist()
	AMP_MsgPersist(not AMPConfig.Msg_Persist)
end

function AMP_ToggleAutoClear()
	AMP_AutoClear(not AMPConfig.autoclear)
end

function AMP_ToggleRecAFK()
	AMP_RecAFK(not AMPConfig.rec_AFK)
end

function AMP_ToggleRecDND()
	AMP_RecDND(not AMPConfig.rec_DND)
end

function AMP_ToggleRecAUCTION()
	AMP_RecAuction(not AMPConfig.rec_AUCTION)
end

function AMP_ToggleChkIgnore()
	AMP_ChkIgnore(not AMPConfig.chk_Ignore)
end

function AMP_IsAFK()
	return Is_AFK
end

function AMP_IsDND()
	return Is_DND
end

function AMP_IsBG()
	return Is_BG
end

-- ===============
-- MISC FUNCTIONS 
-- ===============

function AMP_Print(x, r, g, b)
	DEFAULT_CHAT_FRAME:AddMessage(x, r, g, b)
end

function AMP_Error(x, a, r, g, b, t)
	UIErrorsFrame:AddMessage(x, a, r, g, b, t)
end

function AMP_Strip(x, y)
	local p, n = strfind(strlower(strtrim(x)), strlower(y), 1, true)
	if p and p == 1 and n then
		return strtrim(strsub(x, n+1, strlen(x)))
	end
	return nil
end

function AMP_ReplaceVariables(x)
	for i=1, #(variables) do
		local var, value = variables[i][1],variables[i][2]
		if strfind(x,var,1,true) and value then
			if strfind(value, "return ",1,true) then
				local func, err = loadstring(value)
				if func then
					value = func()
				end
			end
			if value == nil then
				value = ""
			end
			x = gsub(x,var,value)
		end
	end
	return x
end
