-- ----------------------------------------------------------------------------
-- AHsearchNext by Evan
-- --------------------------
-- Extends AHsearch to add a next button
--
-- ----------------------------------------------------------------------------

AHsearchNext = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")
AHsearchNext:RegisterDB("AHsearchNextDB")

local SortedPairs
-- ----------------------------------------------------------------------------
-- print
-- --------------------------
function AHsearchNext:print(text)
	if DEFAULT_CHAT_FRAME and self.db.profile.chatOutput then
		DEFAULT_CHAT_FRAME:AddMessage("|cffffff7fAHsearchNext: |r"..text)
	end
end
-- --------------------------
-- print
-- ----------------------------------------------------------------------------

-- ----------------------------------------------------------------------------
-- OnInitialize
-- --------------------------
function AHsearchNext:OnInitialize()
	self:RegisterDefaults("profile", {
		chatOutput = false,
		ttDisplay = true,
		ttFiltersDisplay = true
		}
	)
end
-- --------------------------
-- OnInitialize
-- ----------------------------------------------------------------------------


-- ----------------------------------------------------------------------------
-- CreatePullDownButton
-- --------------------------
function AHsearchNext:CreateButton()
	if not AHsearchButton then return end
	-- button
	AHsearchNextButtonNext = CreateFrame("Button", "AHsearchNextButtonNext", AHsearchButton)
	AHsearchNextButtonNext:SetWidth(25)
	AHsearchNextButtonNext:SetHeight(25)
	AHsearchNextButtonNext:SetPoint("BOTTOM", "AHsearchButton", "TOP", 0, -7)
	AHsearchNextButtonNext:SetNormalTexture("Interface\\Buttons\\UI-RotationRight-Button-Up")
	AHsearchNextButtonNext:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
	AHsearchNextButtonNext:SetPushedTexture("Interface\\Buttons\\UI-RotationRight-Button-Down")
	-- script
	AHsearchNextButtonNext:SetScript("OnClick", function() AHsearchNext:SearchNext() end)
	
	-- button
	AHsearchNextButtonPrev = CreateFrame("Button", "AHsearchNextButtonPrev", AHsearchNextButtonNext)
	AHsearchNextButtonPrev:SetWidth(25)
	AHsearchNextButtonPrev:SetHeight(25)
	AHsearchNextButtonPrev:SetPoint("RIGHT", "AHsearchNextButtonNext", "LEFT", 0, 0)
	AHsearchNextButtonPrev:SetNormalTexture("Interface\\Buttons\\UI-RotationLeft-Button-Up")
	AHsearchNextButtonPrev:SetHighlightTexture("Interface\\Buttons\\UI-Common-MouseHilight")
	AHsearchNextButtonPrev:SetPushedTexture("Interface\\Buttons\\UI-RotationLeft-Button-Down")
	-- script
	AHsearchNextButtonPrev:SetScript("OnClick", function() AHsearchNext:SearchPrev() end)

end
hooksecurefunc(AHsearch, "CreateAHsearchButton", AHsearchNext.CreateButton)


-- ----------------------------------------------------------------------------
-- SearchNext
-- --------------------------
function AHsearchNext:SearchNext()
	local a = self.db.profile.chatOutput
	self.db.profile.chatOutput = true


	local cat = ""
	local sq = ""
	local next = 0
	local fcat = ""
	local fsq = ""

	local cats = {}
	for tcat,v in SortedPairs(AHsearch.db.profile.search) do
		table.insert(cats,tcat)
	end

	for v,tcat in pairs(cats) do
		for tsq,v2 in SortedPairs(AHsearch.db.profile.search[tcat].queries) do
			if fcat == "" and fsq == "" then
				fcat = tcat
				fsq = tsq
			end
			if next == 1 then
				cat = tcat
				sq = tsq
				next = 0
			end
			if v2.name == BrowseName:GetText() then
				if v2.minLevel == BrowseMinLevel:GetText() then
					if v2.maxLevel == BrowseMaxLevel:GetText() then
						if v2.invTypeIndex == AuctionFrameBrowse.selectedInvtypeIndex then
							if v2.classIndex == AuctionFrameBrowse.selectedClassIndex then
								if CLASS_FILTERS[v2.classIndex] == AuctionFrameBrowse.selectedClass then
									if v2.subclassIndex == AuctionFrameBrowse.selectedSubclassIndex then
										if v2.isUsable == IsUsableCheckButton:GetChecked() then  
											---- disabled, was giving me trouble
 											-- if v2.qualityIndex == UIDropDownMenu_GetSelectedValue(BrowseDropDown) then
												next = 1
											-- else 
											--	self:print("quality is different")
											-- end
										else
--											self:print("is usable is different")
										end
									else
--										self:print("subclass is different")
									end
								else
--									self:print("classfilters are different")
								end
							else
--								self:print("class is different")
							end
						else
--							self:print("inv type is different")
						end
					else 
--						self:print("max level is different")
					end
				else
--					self:print("min level is different")
				end
			else
--				self:print("text is different")
			end
		end
	end
	if cat == "" and sq == "" then
		cat = fcat
		sq = fsq
	end

	if cat ~= "" and sq ~= "" then
		AHsearch:Search(cat, sq)
	end
	PanelTemplates_SetTab(AuctionFrame, 1);
	--AuctionFrameAuctions:Hide();
	--AuctionFrameBrowse:Hide();
	--AuctionFrameBid:Hide();
	-- Browse tab
	AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopLeft");
	AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Top");
	AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopRight");
	AuctionFrameBotLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-BotLeft");
	AuctionFrameBot:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Bot");
	AuctionFrameBotRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-BotRight");
	AuctionFrameBrowse:Show();
	AuctionFrame.type = "list";
end


-- ----------------------------------------------------------------------------
-- SearchPrev
-- --------------------------
function AHsearchNext:SearchPrev()
	local a = self.db.profile.chatOutput
	self.db.profile.chatOutput = true


	local cat = ""  -- cat to execute
	local sq = ""   -- query to execute
	local found = 0
	local fcat = "" -- first
	local fsq = ""  -- first
	local pcat = "" -- previous category
	local psq = ""  -- previous 
	local lcat = "" -- last 
	local lsq = ""  -- last 
	local tcat = "" -- this
	local tsq = ""  -- this

	local cats = {}
	for tcat,v in SortedPairs(AHsearch.db.profile.search) do
		table.insert(cats,tcat)
	end

	for v,tcat in pairs(cats) do
		for tsq,v2 in SortedPairs(AHsearch.db.profile.search[tcat].queries) do
			if fcat == "" and fsq == "" then
				fcat = tcat
				fsq = tsq
			end
			if v2.name == BrowseName:GetText() then
				if v2.minLevel == BrowseMinLevel:GetText() then
					if v2.maxLevel == BrowseMaxLevel:GetText() then
						if v2.invTypeIndex == AuctionFrameBrowse.selectedInvtypeIndex then
							if v2.classIndex == AuctionFrameBrowse.selectedClassIndex then
								if CLASS_FILTERS[v2.classIndex] == AuctionFrameBrowse.selectedClass then
									if v2.subclassIndex == AuctionFrameBrowse.selectedSubclassIndex then
										if v2.isUsable == IsUsableCheckButton:GetChecked() then  
											---- disabled, was giving me trouble
 											-- if v2.qualityIndex == UIDropDownMenu_GetSelectedValue(BrowseDropDown) then
												found = 1
											-- else 
											--	self:print("quality is different")
											-- end
										else
--											self:print("is usable is different")
										end
									else
--										self:print("subclass is different")
									end
								else
--									self:print("classfilters are different")
								end
							else
--								self:print("class is different")
							end
						else
--							self:print("inv type is different")
						end
					else 
--						self:print("max level is different")
					end
				else
--					self:print("min level is different")
				end
			else
--				self:print("text is different")
			end
			if found == 1 then
				cat = pcat
				sq = psq
			else
				pcat = tcat
				psq = tsq
			end
			lcat = tcat
			lsq = tsq
		end
	end
	if cat == "" and sq == "" then
		cat = lcat
		sq = lsq
	end


	if cat ~= "" and sq ~= "" then
		AHsearch:Search(cat, sq)
	end
	PanelTemplates_SetTab(AuctionFrame, 1);
	AuctionFrameAuctions:Hide();
	AuctionFrameBrowse:Hide();
	AuctionFrameBid:Hide();
	-- Browse tab
	AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopLeft");
	AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Top");
	AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopRight");
	AuctionFrameBotLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-BotLeft");
	AuctionFrameBot:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Bot");
	AuctionFrameBotRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-BotRight");
	AuctionFrameBrowse:Show();
	AuctionFrame.type = "list";
end

-- ----------------------------------------------------------------------------
-- local functions
-- AHsearch made this local, so I had to copy it here.
-- --------------------------
SortedPairs = function(t,lvl)
	_G.ntab = {}
	for k,v in pairs(t) do
		table.insert(_G.ntab,k)
	end

	if lvl then
		table.sort(_G.ntab,
			function(a,b)
				if t[a].order == t[b].order then
					if t[a].qualityIndex == t[b].qualityIndex then
						if a < b then
							return true
						end
					end
					if t[a].qualityIndex > t[b].qualityIndex then
						return true
					end	
				end
				if t[a].order < t[b].order then
					return true
				end
			end
		)
	else
		table.sort(_G.ntab,
			function(a,b)
				if t[a].order == t[b].order then
					if a < b then
						return true
					end
				end
				if t[a].order < t[b].order then
					return true					
				end
			end
		)
	end

	local i = 0
	local function _f(_s,_v)
		i = i + 1
		local k = _G.ntab[i]
		if (k) then
			return k,t[k]
		end
	end
	return _f,nil,nil
end

-- --------------------------
-- SearchNext
-- ----------------------------------------------------------------------------