-- 1.8.2
-- Added support for Siena's Gem Viewer (http://www.wowinterface.com/downloads/info6922-sienasGemViewer.html)

-- 1.8
-- Update for patch 2.4.
--
-- 1.7
-- Fixed a bug with Auctions tab. Tab now shows 17 auctions.
--
-- 1.6
-- Fixed another small bug that caused errors on first start. 
--
-- 1.5
-- Fixed a bug with the preview option.

-- 1.5
-- Fixed a bug with the preview option.
-- Added full support for Auctioneer. 
--
-- 1.4
-- Could't fix the broken scroll bar textures. Due to this I just removed them. 
-- The scroll bars are still shown and usable ... just without the thin border.
-- Guess you will not notice that the scroll bars changed at all. :)
--
-- 1.3
-- AH frame position and size is now saved between sessions per character
--
-- 1.2
-- Auction house frame is now moveable with right mouse button 
-- Auction house frame is now resizable with /ahe [size between 0.5 and 1.5]
-- To reset the auction house frame size use /ahe reset
--
-- 1.1
--
-- 1.0
-- First release

AHExtend_ver = "1.8.2."
AHExtend_CONST_Ver = "Duugus AHExtend "..AHExtend_ver.." loaded"
AHExtend_first = true
AHExtend_Page = 1
AHExtend_Size = 1
AHExtend_PosX = 0
AHExtend_PosY = -104
AHExtend_point = "TOPLEFT"
AHExtend_relativeTo = "UIParent"
AHExtend_relativePoint ="TOPLEFT"

AHExtend_oPosX = 0
AHExtend_oPosY = -104
AHExtend_opoint = "TOPLEFT"
AHExtend_orelativeTo = "UIParent"
AHExtend_orelativePoint ="TOPLEFT"

function AHExtendSlash(cmd)
	if cmd then
		cmd = string.lower(cmd)
		if cmd == "" or cmd == "help" or cmd == "hilfe" or cmd == "?" or cmd == "Hilfe" then
			DEFAULT_CHAT_FRAME:AddMessage("AHExtend:")
			DEFAULT_CHAT_FRAME:AddMessage("/ahe [size between 0.5 and 1.5] - to resize the auction house window (only if ah is visible)")
			DEFAULT_CHAT_FRAME:AddMessage("/ahe reset - to set action house window back to default size and position (only if ah is visible)")
		end
		if getglobal("AuctionFrame") then
			if getglobal("AuctionFrame"):IsVisible() then
				if cmd == "reset" then
					getglobal("AuctionFrame"):SetScale(1)
					AHExtend_Size = 1
					AHExtend_point = AHExtend_opoint
					AHExtend_relativeTo = AHExtend_orelativeTo 
					AHExtend_relativePoint = AHExtend_orelativePoint 
					AHExtend_PosX = AHExtend_oPosX 
					AHExtend_PosY = AHExtend_oPosY 
					getglobal("AuctionFrame"):SetPoint(AHExtend_point, AHExtend_relativeTo, AHExtend_relativePoint, AHExtend_PosX, AHExtend_PosY)
				end
				if string.find(cmd, "size") then
					if tonumber(string.sub(cmd, 5), 10) then
						if tonumber(string.sub(cmd, 5), 10) <= 1.5 and tonumber(string.sub(cmd, 5), 10) >= 0.5 then
							getglobal("AuctionFrame"):SetScale(tonumber(string.sub(cmd, 5), 10))
							AHExtend_Size = tonumber(string.sub(cmd, 5), 10)
						end
					end
				end
			end
		end
	end
end

function nAuctionFrameTab_OnClick(index)
	DEFAULT_CHAT_FRAME:AddMessage(this:GetName())	
	oAuctionFrameTab_OnClick(index)
	if ( not index ) then		
		index = this:GetID()	
	end	
	AHExtend_Page = index
	if index < 4 or this:GetName() == "SGV_SearchFrameTab" then

		local ah = nil
		local texSize = 3
		local scrollSize = 2
		local frameSize = 1.79
	
		NUM_BROWSE_TO_DISPLAY = 16
		NUM_FILTERS_TO_DISPLAY = 30
		NUM_BIDS_TO_DISPLAY = 17
		NUM_AUCTIONS_TO_DISPLAY = 17	
	
		ah = getglobal("BrowseNextPageButton")
		ah:SetPoint("RIGHT", "BrowseButton16", 2, 0) 
		ah = getglobal("BrowsePrevPageButton")
		ah:SetPoint("LEFT", "BrowseButton16", 5, 0) 
	
		
		ah = getglobal("AuctionFrame")
		ah:SetHeight(447*frameSize)
		
		ah = getglobal("AuctionFrameBrowse")
		ah:SetHeight(447*frameSize)
		ah = getglobal("AuctionFrameBid")
		ah:SetHeight(447*frameSize)
		ah = getglobal("AuctionFrameAuctions")
		ah:SetHeight(447*frameSize)
		
		ah = getglobal("AuctionFrameBotLeft")
		ah:SetHeight(256*texSize)
		ah = getglobal("AuctionFrameBotRight")
		ah:SetHeight(256*texSize)
		ah = getglobal("AuctionFrameBot")
		ah:SetHeight(256*texSize)
		
		ah = getglobal("BrowseScrollFrame")
		ah:SetHeight(306*scrollSize)
		ah = getglobal("BrowseFilterScrollFrame")
		ah:SetHeight(305*scrollSize)
		ah = getglobal("AuctionsScrollFrame")
		ah:SetHeight(339*scrollSize)
		ah = getglobal("BidScrollFrame")
		ah:SetHeight(335*scrollSize)



		PanelTemplates_SetTab(AuctionFrame, index)	
		AuctionFrameAuctions:Hide()	
		AuctionFrameBrowse:Hide()	
		AuctionFrameBid:Hide()	
		PlaySound("igCharacterInfoTab")
	
		if ( index == 1 ) then
			AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopLeft")		
			AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Top")		
			AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopRight")
			AuctionFrameBotLeft:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-BotLeft")		
			AuctionFrameBot:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-Bot")		
			AuctionFrameBotRight:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-BotRight")		
			AuctionFrameBrowse:Show()		
			AuctionFrame.type = "list"
		elseif ( index == 2 ) then
			AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-TopLeft")		AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-Top")		AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-TopRight")
			AuctionFrameBotLeft:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-BotLeft")	
			AuctionFrameBot:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-Bot")	
			AuctionFrameBotRight:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-BotRight")	
			AuctionFrameBid:Show()		AuctionFrame.type = "bidder"
		elseif ( index == 3 ) then
			AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Auction-TopLeft")		AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Auction-Top")		AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Auction-TopRight")
			AuctionFrameBotLeft:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Auction-BotLeft")		
			AuctionFrameBot:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Auction-Bot")	
			AuctionFrameBotRight:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Auction-BotRight")	
			AuctionFrameAuctions:Show()
		elseif (this:GetName() == "SGV_SearchFrameTab") then
			AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-TopLeft")		
			AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-Top")		
			AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Bid-TopRight")
			AuctionFrameBotLeft:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-BotLeft")	
			AuctionFrameBot:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-Bot")	
			AuctionFrameBotRight:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Bid-BotRight")	
--~ 			AuctionFrameBid:Show()		
--~ 			AuctionFrame.type = "bidder"
		end
		BrowseFilterScrollFrame:DisableDrawLayer("ARTWORK") 
		BrowseScrollFrame:DisableDrawLayer("ARTWORK") 
		BidScrollFrame:DisableDrawLayer("ARTWORK") 
		AuctionsScrollFrame:DisableDrawLayer("ARTWORK") 
	else
		local ah = nil
	
		NUM_BROWSE_TO_DISPLAY = 8
	
		ah = getglobal("BrowseNextPageButton")
		ah:SetPoint("RIGHT", "BrowseButton8", 2, 0) 
		ah = getglobal("BrowsePrevPageButton")
		ah:SetPoint("LEFT", "BrowseButton8", 5, 0) 
	
		
		ah = getglobal("AuctionFrame")
		ah:SetHeight(447)
		
		ah = getglobal("AuctionFrameBrowse")
		ah:SetHeight(447)
		ah = getglobal("AuctionFrameBid")
		ah:SetHeight(447)
		ah = getglobal("AuctionFrameAuctions")
		ah:SetHeight(447)
		
		ah = getglobal("AuctionFrameBotLeft")
		ah:SetHeight(256)
		ah = getglobal("AuctionFrameBotRight")
		ah:SetHeight(256)
		ah = getglobal("AuctionFrameBot")
		ah:SetHeight(256)
		
		ah = getglobal("BrowseScrollFrame")
		ah:SetHeight(306)
		ah = getglobal("BrowseFilterScrollFrame")
		ah:SetHeight(305)
		ah = getglobal("AuctionsScrollFrame")
		ah:SetHeight(339)
		ah = getglobal("BidScrollFrame")
		ah:SetHeight(335)	
		NUM_FILTERS_TO_DISPLAY = 15
		NUM_BIDS_TO_DISPLAY = 9
		NUM_AUCTIONS_TO_DISPLAY = 9	
	end
	AHExtend_relativeTo = "UIParent"
	getglobal("AuctionFrame"):SetPoint(AHExtend_point, AHExtend_relativeTo, AHExtend_relativePoint, AHExtend_PosX, AHExtend_PosY)

end

function nAuctionFrame_OnShow()
	getglobal("AuctionFrame"):SetMovable(true)  
	getglobal("AuctionFrame"):RegisterForDrag("RightButton")
	getglobal("AuctionFrame"):SetScript("OnDragStart", 	function() 
															getglobal("AuctionFrame"):StartMoving() 
														end)
	getglobal("AuctionFrame"):SetScript("OnDragStop", 	function() 
															getglobal("AuctionFrame"):StopMovingOrSizing() 
															AHExtend_PosX = getglobal("AuctionFrame"):GetTop()
															AHExtend_PosY = getglobal("AuctionFrame"):GetLeft()
															AHExtend_point, AHExtend_relativeTo, AHExtend_relativePoint, AHExtend_PosX, AHExtend_PosY = getglobal("AuctionFrame"):GetPoint() 
														end)

	local ah = nil
	local texSize = 3
	local scrollSize = 2
	local frameSize = 1.79
	for x = 9, 16, 1 do 
		local tframe = nil
		tframe = CreateFrame("Button", "BrowseButton"..x, getglobal("AuctionFrameBrowse"), "BrowseButtonTemplate") 
		tframe:SetPoint("TOPLEFT", "BrowseButton"..x-1, "BOTTOMLEFT", 0, 0) 
		tframe:SetID(x) 
	end 
	NUM_BROWSE_TO_DISPLAY = 16

	ah = getglobal("BrowseNextPageButton")
	ah:SetPoint("RIGHT", "BrowseButton16", 2, 0) 
	ah = getglobal("BrowsePrevPageButton")
	ah:SetPoint("LEFT", "BrowseButton16", 5, 0) 

	
	ah = getglobal("AuctionFrame")
	ah:SetHeight(447*frameSize)
	
	ah = getglobal("AuctionFrameBrowse")
	ah:SetHeight(447*frameSize)
	ah = getglobal("AuctionFrameBid")
	ah:SetHeight(447*frameSize)
	ah = getglobal("AuctionFrameAuctions")
	ah:SetHeight(447*frameSize)
	
	ah = getglobal("AuctionFrameBotLeft")
	ah:SetHeight(256*texSize)
	ah = getglobal("AuctionFrameBotRight")
	ah:SetHeight(256*texSize)
	ah = getglobal("AuctionFrameBot")
	ah:SetHeight(256*texSize)
	
	ah = getglobal("BrowseScrollFrame")
	ah:SetHeight(306*scrollSize)
	ah = getglobal("BrowseFilterScrollFrame")
	ah:SetHeight(305*scrollSize)
	ah = getglobal("AuctionsScrollFrame")
	ah:SetHeight(339*scrollSize)
	ah = getglobal("BidScrollFrame")
	ah:SetHeight(335*scrollSize)

	
	for x = 16, 30, 1 do 
		tframe = CreateFrame("Button", "AuctionFilterButton"..x, getglobal("AuctionFrameBrowse"), "AuctionClassButtonTemplate") 
		tframe:SetPoint("TOPLEFT", "AuctionFilterButton"..x-1, "BOTTOMLEFT", 0, 0) 
		tframe:SetID(x) 
	end 
	NUM_FILTERS_TO_DISPLAY = 30

	
	for x = 10, 17, 1 do 
		local tframe = nil
		tframe = CreateFrame("Button", "BidButton"..x, getglobal("AuctionFrameBid"), "BidButtonTemplate") 
		tframe:SetPoint("TOPLEFT", "BidButton"..x-1, "BOTTOMLEFT", 0, 0) 
		tframe:SetID(x) 
	end 
	NUM_BIDS_TO_DISPLAY = 17
	
	for x = 10, 17, 1 do 
		local tframe = nil
		tframe = CreateFrame("Button", "AuctionsButton"..x, getglobal("AuctionFrameAuctions"), "AuctionsButtonTemplate") 
		tframe:SetPoint("TOPLEFT", "AuctionsButton"..x-1, "BOTTOMLEFT", 0, 0) 
		tframe:SetID(x) 
	end 
	NUM_AUCTIONS_TO_DISPLAY = 17	

	AHExtend_relativeTo = "UIParent"
	getglobal("AuctionFrame"):SetPoint(AHExtend_point, AHExtend_relativeTo, AHExtend_relativePoint, AHExtend_PosX, AHExtend_PosY)
	getglobal("AuctionFrame"):SetScale(AHExtend_Size)


	AuctionFrameTab_OnClick(1)
	AuctionFrameTopLeft:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopLeft")		
	AuctionFrameTop:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-Top")		
	AuctionFrameTopRight:SetTexture("Interface\\AuctionFrame\\UI-AuctionFrame-Browse-TopRight")
	AuctionFrameBotLeft:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-BotLeft")		
	AuctionFrameBot:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-Bot")		
	AuctionFrameBotRight:SetTexture("Interface\\AddOns\\AHExtend\\UI-AuctionFrame-Browse-BotRight")		

	BrowseFilterScrollFrame:DisableDrawLayer("ARTWORK") 
	BrowseScrollFrame:DisableDrawLayer("ARTWORK") 
	BidScrollFrame:DisableDrawLayer("ARTWORK") 
	AuctionsScrollFrame:DisableDrawLayer("ARTWORK") 
	
	if SGV_NUM_BIDS_TO_DISPLAY then
		SGV_NUM_BIDS_TO_DISPLAY = 17
		for x = 10, 18, 1 do 
			local tframe = nil
			tframe = CreateFrame("Button", "SGV_GemButton"..x, getglobal("SGV_Frame"), "SGV_GemButtonTemplate") 
			tframe:SetPoint("TOPLEFT", "SGV_GemButton"..x-1, "BOTTOMLEFT", 0, 0) 
			tframe:SetID(x) 
		end 
		local ah = getglobal("SGV_GemScrollFrame")
		ah:SetHeight(329*scrollSize)
		ah:DisableDrawLayer("ARTWORK") 
		local ah = getglobal("SGV_Frame")
		ah:SetHeight((447*frameSize) - 5)

	end
	
end

function nAuctionDressUpFrame_OnShow()	
	oAuctionDressUpFrame_OnShow()
	nAuctionFrameTab_OnClick(AHExtend_Page)
end






