
local AFKFix_Debug = 0

AFKFix_Enabled = true
local AFKFix_Orig_SendChatMessage;

function AFKFix_Init()
  AFKFix_Orig_SendChatMessage = SendChatMessage;
  SendChatMessage = AFKFix_SendChatMessage;
  if (AFKFix_Debug == 1) then
    AFKFix_DebugMsg("AFK Fix v"..GetAddOnMetadata("AFKFix", "Version").." loaded.")
  end

  SLASH_AFKFix1 = "/afkfix";
  SlashCmdList["AFKFix"] = AFKFix_SlashHandler;
end

function AFKFix_SlashHandler()
  if (AFKFix_Enabled) then
    AFKFix_Enabled = false
    DEFAULT_CHAT_FRAME:AddMessage("AFK Fix disabled.", 1,1,0.2);
  else
    AFKFix_Enabled = true
    DEFAULT_CHAT_FRAME:AddMessage("AFK Fix enabled.", 1,1,0.2);
  end
end

function AFKFix_SendChatMessage(msg, chatType, language, channel, ...)
  local IsHiddenChannel = false;

  if (AFKFix_Enabled and UnitIsAFK("player") and chatType == "CHANNEL" and GetCVar("autoClearAFK") == "1") then
    local _, cname = GetChannelName(channel)
    cname = AFKFix_Trim(cname)
    IsHiddenChannel = (not AFKFix_IsChannelShown(cname));
    if (IsHiddenChannel) then
      SetCVar("autoClearAFK", "0");
      AFKFix_DebugMsg("* AFK Fix thinks '"..cname.."' is hidden, so it set autoClearAFK to 0.")
    else
      AFKFix_DebugMsg("* AFK Fix thinks '"..cname.."' is NOT hidden.")
    end
  end

  -- Call original function and remember what it returned.
  local returnval = AFKFix_Orig_SendChatMessage(msg, chatType, language, channel, ...);

  if (IsHiddenChannel) then
  -- Return autoClearAFK to its old value.
    SetCVar("autoClearAFK", "1");
    AFKFix_DebugMsg("* AFK Fix returned autoClearAFK to 1.")
  end

  return returnval
end

function AFKFix_IsChannelShown(name)
  local chatFrame;
  for i=1,NUM_CHAT_WINDOWS do
    -- AFKFix_DebugMsg("Checking ChatFrame"..i..":");
    chatFrame = getglobal("ChatFrame"..i);
    if (AFKFix_IsChannelShownInFrame(chatFrame, name)) then
      return true;
    end
  end
  return false;
end

function AFKFix_IsChannelShownInFrame(chatFrame, name)
  for index, value in pairs(chatFrame.channelList) do
    -- AFKFix_DebugMsg("- channelList["..index.."] = "..chatFrame.channelList[index])
    if ( strupper(name) == strupper(value) ) then
      return true;
    end
  end
  return false;
end

function AFKFix_Trim(cname)
  -- Remove spaces and anything that follows from channel name (e.g. "Trade - City" becomes "Trade").
  local pos = strfind(cname," ")
  if (pos) then
    cname = strsub(cname, 1, pos-1);
  end
  return cname
end

function AFKFix_DebugMsg(msg)
  if (AFKFix_Debug == 1) then
    DEFAULT_CHAT_FRAME:AddMessage(msg, 1,1,0.6);
  end
end

AFKFix_MainFrame = CreateFrame("Frame")
AFKFix_MainFrame:RegisterEvent("VARIABLES_LOADED")
AFKFix_MainFrame:SetScript("OnEvent", function(this, event, arg1) AFKFix_Init() end)

