--- -----------------------------------------------------------------------------------------------------------
--- AEmotes addon by: ZacWolf<zac@zacwolf.com - www.zacwolf.com> 
---					  - ZacWolf-The Thorium Brotherhood
---               	  - EarthBrother-<EatMorChikin>-The Thorium Brotherhood
---					  - http://www.wowace.com/wiki/AEmotes
---              	  - http://eatmorchikin.guildportal.com
---                   - http://www.zacwolf.com
---
--- This addons allows playing combination Audio Soundbites and Character Emotes as an Audio Emote
--- -----------------------------------------------------------------------------------------------------------
--- How to Install
---
--- * Unzip the package into: World of Warcraft\Interface\AddOns\
--- * Your zip software must preserve directory structures.
---
--- For this addon to actually do anything you need to add additional artist mods:
--- These can be found at: http://www.wowace.com/wiki/AEmotes
--- -----------------------------------------------------------------------------------------------------------
--- == Commands:== 
--- /ae {artist} {track}
--- /aemote {artist} {track}
--- /aemotes {artist} {track}
--- -----------------------------------------------------------------------------------------------------------
--- == Changes==
--- -----------------------------------------------------------------------------------------------------------
--- == License ==
--- The AEmotes addon is released under the GNU General Public License (GPL) 
--- For the full licence text please see gpl-v2.txt
--- Unofficial translations of the GPL can be found here: 
--- [http://www.gnu.org/licenses.../translations.html] 
--- -----------------------------------------------------------------------------------------------------------
--- == Notes==
---
--- Losely Based on: Power of LeeroyHillCats
---                  combined cross-faction mod! (Leeroy / Benny Hill / Thundercats / HEMAN!)
---                  originally Written by Barogio <Victory or Valhalla> of Thunderhorn with help from Moomin!
---
--- To add a quick Graphic Interface to this add, checkout the FuBar addon and FuBar_AEmotesFu
--- -----------------------------------------------------------------------------------------------------------


AEMOTES							= {};
AEMOTES.artists					= {};
AEMOTES.TimeTilNext 			= time();


---
--- Define the global event processor
---
function AEMOTES.OnEvent(event, a1)
  if (a1 and event=="CHAT_MSG_SAY" and time()>=AEMOTES.TimeTilNext) then
    local artist;
	local found;
	for _,artist in pairs(AEMOTES.artists) do
		if (AEMOTES[artist] and AEMOTES[artist].parms) then
			for _,parm in pairs(AEMOTES[artist].parms) do
				if (parm.msgs) then
					for _,msg in pairs(parm.msgs) do
	  					if (a1=="* "..msg.." *") then
      						PlaySoundFile(AEMOTES[artist].AddonPath..parm.track..".mp3");
							if (parm.emote ~= nil) then
						    	DoEmote(parm.emote);
							end
						    AEMOTES.TimeTilNext = time() + parm.len;
							found = 1;
							break;
						end
					end
				end
				if (found) then
				  break;
				end
			end
		end
		if (found) then
		  break;
		end
	end
  end
end


---
--- Define the global slash command processor
---
function AEMOTES.process_slash_command(msg)
	--DEFAULT_CHAT_FRAME:AddMessage("Command: " .. msg);
	local s,ss					= string.find(msg, " ");
	if (s) then
		local artist 			= string.sub(msg,1,s-1);
		local track				= string.sub(msg,s+1);
		--DEFAULT_CHAT_FRAME:AddMessage("artist: "..artist.." track:"..track..".mp3");
		if (AEMOTES[artist] and AEMOTES[artist].parms) then
			local parm;
			for _,parm in pairs(AEMOTES[artist].parms) do
				if (parm.track==track) then
					SendChatMessage("* "..parm.msgs.common.." *", "SAY");
					break;
				end
			end
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("AEmote usage: /ae {artist} {track}");
	end
end

---
--- Define the slash commands
---
SLASH_AEMOTES1					= "/ae";
SLASH_AEMOTES2					= "/aemote";
SLASH_AEMOTES3					= "/aemotes";
SlashCmdList["AEMOTES"] 		= AEMOTES.process_slash_command;