--[[


TODO:


]]


ABHelperOptions = {};

--LOCALIZED
local ABHNodeStatus = {TRANSLATION_FARM, 
		       TRANSLATION_GOLDMINE, 
                       TRANSLATION_BLACKSMITH, 
                       TRANSLATION_LUMBERMILL, 
                       TRANSLATION_STABLES,
                       TRANSLATION_TOWER1, 
                       TRANSLATION_TOWER2, 
                       TRANSLATION_TOWER3, 
                       TRANSLATION_TOWER4, 
                       TRANSLATION_CENTER};

local Node1TimerValue = -1;
local Node2TimerValue = -1;
local Node3TimerValue = -1;
local Node4TimerValue = -1;
local Node5TimerValue = -1;

local Node1OldClockTime = 0;
local Node2OldClockTime = 0;
local Node3OldClockTime = 0;
local Node4OldClockTime = 0;
local Node5OldClockTime = 0;

local ABHCounter = 0;

local ABHelper_HideStatus = nil;

local ALLIANCE_CONTROLS = -1;
local ALLIANCE_CONTESTED = -2;
local HORDE_CONTROLS = 1;
local HORDE_CONTESTED = 2;
local UNCONTESTED = 0;

local ABH_BGStatus = nil;
local ABH_BGName = nil;

local CurrentButton = nil;

local ABH_Popup_Counter = 0;
local ABH_UserStatementPopup_Counter = 0;

ABH_IsInWindow = nil;
ABH_IsInUserWindow = nil;

ABH_DebugMode = nil;
ABH_InParty = 1;
ABH_RaidResetCounter = 0;


lower = string.lower;


function ABH_GetPosition(xp, yp)
	--[[
	if ( xp == nil and yp == nil) then
		
		xp = ABHelperFrame:GetLeft();
		yp = ABHelperFrame:GetTop();
		
	end
	]]

	local point,relativeTo,relativePoint,xOfs,yOfs = ABHelperFrame:GetPoint();
	
	

	ABHelperOptions["Xpos"] = xOfs
	ABHelperOptions["Ypos"] = yOfs
end

function DEBUGIT1()

	local xp = ABHelperFrame:GetLeft();
	local yp = ABHelperFrame:GetTop();
	local point,relativeTo,relativePoint,xOfs,yOfs = ABHelperFrame:GetPoint();
	DEFAULT_CHAT_FRAME:AddMessage(xOfs.." "..yOfs.." "..xp.." "..yp);
end

function ABH_SetPosition()

	--[[
	if ( ABHelperOptions["Xpos"] ~= nil and ABHelperOptions["Ypos"] ~= nil ) then
		ABHelperFrame:ClearAllPoints();
		ABHelperFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ABHelperOptions["Xpos"], ABHelperOptions["Ypos"]);
		--ABHelperFrame:SetPoint("TOPLEFT", ABHelperOptions["Xpos"], ABHelperOptions["Ypos"]);
	end
	]]
end

function ABH_DEBUG8()
	
	local point,relativeTo,relativePoint,xOfs,yOfs = ABHelperFrame:GetPoint()
	DEFAULT_CHAT_FRAME:AddMessage(point)
	--DEFAULT_CHAT_FRAME:AddMessage(relativeTo:GetName())
	DEFAULT_CHAT_FRAME:AddMessage(relativePoint)
	DEFAULT_CHAT_FRAME:AddMessage(xOfs)
	DEFAULT_CHAT_FRAME:AddMessage(yOfs)

	--ABHelperFrame:SetPoint("TOPLEFT", UIParent x, y);
end


function ABH_DEBUG7(x, y)
	ABHelperFrame:ClearAllPoints();
	ABHelperFrame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", x, y);
end

function ABHDEBUG_GetPosition()
	local xp = ABHelperFrame:GetLeft();
	local yp = ABHelperFrame:GetTop();
	DEFAULT_CHAT_FRAME:AddMessage("Saved: "..ABHelperOptions["Xpos"]..", "..ABHelperOptions["Ypos"]);
	DEFAULT_CHAT_FRAME:AddMessage("Actual: "..xp..", "..yp);
end


function ABH_ResetPosition()
	ABHelperFrame:ClearAllPoints();
	ABHelperFrame:SetPoint("TOPLEFT", UIParent, 100, -200);
	--ABHelperFrame:SetPoint("BOTTOMLEFT", 100, 300);
	--ABH_GetPosition();
	--getglobal("Solitaire_CardButton1"):SetPoint("TOPLEFT", Solitaire_StackButton1, 0, 0);
end


--****************************************************************
-- ABH_ResetMod_EyeOfStorm
--
-- Purpose: Used to reset the mod at the start of a Eye of the 
--          Storm bg match.
--****************************************************************
function ABH_ResetMod_EyeOfStorm()

	ABH_SetText("ABH_Node2Text", 1, 1, 1);	
	ABH_SetText("ABH_Node4Text", 1, 1, 1);	
	ABH_SetText("ABH_Node1Text", 1, 1, 1);	
	ABH_SetText("ABH_Node3Text", 1, 1, 1);	
	ABH_SetText("ABH_Node5Text", 1, 1, 1);
	
--LOCALIZED
	ABHNodeStatus[TRANSLATION_TOWER1] = 0;
	ABHNodeStatus[TRANSLATION_TOWER2] = 0;
	ABHNodeStatus[TRANSLATION_TOWER3] = 0;
	ABHNodeStatus[TRANSLATION_TOWER4] = 0;
	ABHNodeStatus[TRANSLATION_CENTER] = 0;

--GRAPPLE1

--****************************************************************
-- Set up the node pictures to show the grey tower icon.
--****************************************************************

--	getglobal("Node1Icon"):SetTexCoord(0.75, 0.875, 0.0, 0.125);		Horde Token
--      getglobal("Node5Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);		Gray Tower
--	getglobal("Node5Icon"):SetTexCoord(0.125, 0.25, 0.125, 0.25);		Red Tower
--	getglobal("Node5Icon"):SetTexCoord(0.5, 0.625, 0.625, 0.75);		Blue Tower
--	getglobal("Node5Icon"):SetTexCoord(0.625, 0.75, 0.625, 0.75);		Gray Flag
--	getglobal("Node5Icon"):SetTexCoord(0.5, 0.625, 0.625, 0.75);		Red Flag
--	getglobal("Node5Icon"):SetTexCoord(0.375, 0.5, 0.625, 0.75);		Blue Flag
	
	getglobal("Node1Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
	getglobal("Node2Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
	getglobal("Node3Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
	getglobal("Node4Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
	getglobal("Node5Icon"):SetTexCoord(0.625, 0.75, 0.625, 0.75);

--****************************************************************
--Hide the timer windows, they aren't needed for Eye of the Storm.
--****************************************************************
	getglobal("Node5TimerFrame"):Hide();
	getglobal("Node4TimerFrame"):Hide();
	getglobal("Node1TimerFrame"):Hide();
	getglobal("Node2TimerFrame"):Hide();
	getglobal("Node3TimerFrame"):Hide();

--****************************************************************
-- Set up the node names on the node buttons.
--****************************************************************
	getglobal("ABH_Node1Text"):SetText(TRANSLATION_TOWER1);
	getglobal("ABH_Node2Text"):SetText(TRANSLATION_TOWER2);
	getglobal("ABH_Node3Text"):SetText(TRANSLATION_TOWER3);
	getglobal("ABH_Node4Text"):SetText(TRANSLATION_TOWER4);
	getglobal("ABH_Node5Text"):SetText(TRANSLATION_CENTER);

end


--****************************************************************
-- ABH_ResetMod_ArathiBasin
--
-- Purpose: used to reset the mod for a new Arathi Basin bg match.
--
--****************************************************************
function ABH_ResetMod_ArathiBasin()

	ABH_SetText("ABH_Node2Text", 1, 1, 1);	
	ABH_SetText("ABH_Node4Text", 1, 1, 1);	
	ABH_SetText("ABH_Node1Text", 1, 1, 1);	
	ABH_SetText("ABH_Node3Text", 1, 1, 1);	
	ABH_SetText("ABH_Node5Text", 1, 1, 1);

--LOCALIZED
	ABHNodeStatus[TRANSLATION_LUMBERMILL] = 0;
	ABHNodeStatus[TRANSLATION_GOLDMINE] = 0;
	ABHNodeStatus[TRANSLATION_FARM] = 0;
	ABHNodeStatus[TRANSLATION_BLACKSMITH] = 0;
	ABHNodeStatus[TRANSLATION_STABLES] = 0;
	
	Node1OldClockTime = 0;
	Node2OldClockTime = 0;
	Node3OldClockTime = 0;
	Node4OldClockTime = 0;
	Node5OldClockTime = 0;

	Node1TimerValue = -1;
	Node2TimerValue = -1;
	Node3TimerValue = -1;
	Node4TimerValue = -1;
	Node5TimerValue = -1;

	getglobal("Node1Icon"):SetTexCoord(0.875, 1, 0.375, 0.5);
	getglobal("Node2Icon"):SetTexCoord(0.625, 0.75, 0.25, 0.375);
	getglobal("Node3Icon"):SetTexCoord(0.25, 0.375, 0.375, 0.5);
	getglobal("Node4Icon"):SetTexCoord(0, 0.125, 0.25, 0.375);
	getglobal("Node5Icon"):SetTexCoord(0.5, 0.625, 0.5, 0.625);

	getglobal("Node1TimerText"):SetTextColor(1, 1, 0);
	getglobal("Node2TimerText"):SetTextColor(1, 1, 0);
	getglobal("Node3TimerText"):SetTextColor(1, 1, 0);
	getglobal("Node4TimerText"):SetTextColor(1, 1, 0);
	getglobal("Node5TimerText"):SetTextColor(1, 1, 0);

	getglobal("Node5TimerFrame"):Hide();
	getglobal("Node4TimerFrame"):Hide();
	getglobal("Node1TimerFrame"):Hide();
	getglobal("Node2TimerFrame"):Hide();
	getglobal("Node3TimerFrame"):Hide();

	getglobal("ABH_Node1Text"):SetText(TRANSLATION_FARM);
	getglobal("ABH_Node2Text"):SetText(TRANSLATION_LUMBERMILL);
	getglobal("ABH_Node3Text"):SetText(TRANSLATION_BLACKSMITH);
	getglobal("ABH_Node4Text"):SetText(TRANSLATION_GOLDMINE);
	getglobal("ABH_Node5Text"):SetText(TRANSLATION_STABLES);

end


function ABHToggle()

	if (ABHelperFrame:IsVisible()) then
		ABHelperFrame:Hide();
	else
		
		 ABHelperFrame:Show();
	end
end


function ABH_OnLoad()
	--this:RegisterEvent("CHAT_MSG_WHISPER");
	--this:RegisterEvent("CHAT_MSG_SYSTEM");
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_ALLIANCE");
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_HORDE");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("WORLD_MAP_UPDATE");
	this:RegisterEvent("CHAT_MSG_BG_SYSTEM_NEUTRAL");
	this:RegisterForDrag("LeftButton");

	--Tie into the slash command system.
	SlashCmdList["ABHelper"] = ABHelper_SlashHandler;
		SLASH_ABHelper1 = "/abHelper";
		SLASH_ABHelper2 = "/abh";

	--ABH_SetPosition();

	getglobal("ABH_Node1Text"):SetText(TRANSLATION_FARM);
	getglobal("ABH_Node2Text"):SetText(TRANSLATION_LUMBERMILL);
	getglobal("ABH_Node3Text"):SetText(TRANSLATION_BLACKSMITH);
	getglobal("ABH_Node4Text"):SetText(TRANSLATION_GOLDMINE);
	getglobal("ABH_Node5Text"):SetText(TRANSLATION_STABLES);

	--getglobal("ABH_Node1Text2"):SetText(TRANSLATION_FARM);
	--getglobal("ABH_Node2Text2"):SetText(TRANSLATION_LUMBERMILL);
	--getglobal("ABH_Node3Text2"):SetText(TRANSLATION_BLACKSMITH);
	--getglobal("ABH_Node4Text2"):SetText(TRANSLATION_GOLDMINE);
	--getglobal("ABH_Node5Text2"):SetText(TRANSLATION_STABLES);

--LOCALIZED
	DEFAULT_CHAT_FRAME:AddMessage("Arathi Basin Helper by Necrophob (www.totaliterritory.com): type /abh or /abhelper for help.");
end


-- Used to set the timer text to green.
function SetTimerColor(node)
	
	if(node ~= nil) then
		getglobal(node.."TimerText"):SetTextColor(0, 1, 0);
	end

	--if(node ~= nil) then
	--	getglobal(node.."TimerText2"):SetTextColor(0, 1, 0);
	--end

end


-- Used to make a node button flash briefly, to indicate a change in the node's status.
function ABH_PulseButton(node)

	local pulsetime = 2;
	local pulseperiod = 0.2;

	if ( node == 2 ) then
		SetButtonPulse(ABHButton1, pulsetime, pulseperiod);
	elseif ( node == 0 ) then
		SetButtonPulse(ABHButton2, pulsetime, pulseperiod);
	elseif ( node == 3 ) then
		SetButtonPulse(ABHButton3, pulsetime, pulseperiod);
	elseif ( node == 1 ) then
		SetButtonPulse(ABHButton4, pulsetime, pulseperiod);
	elseif ( node == 4 ) then
		SetButtonPulse(ABHButton5, pulsetime, pulseperiod);
	end
end


function ABH_OnEvent()

	if( event == "VARIABLES_LOADED") then

		--DEFAULT_CHAT_FRAME:AddMessage("Event thrown: VARIABLES_LOADED");

		--ABH_SetPosition();

		getglobal("Node1TimerFrame"):SetBackdropColor(0, 0.1, 0.9, 0.25);
		getglobal("Node1TimerFrame"):SetBackdropBorderColor(1, 1, 1, 1);
		getglobal("Node2TimerFrame"):SetBackdropColor(0, 0.1, 0.9, 0.25);
		getglobal("Node2TimerFrame"):SetBackdropBorderColor(1, 1, 1, 1);
		getglobal("Node3TimerFrame"):SetBackdropColor(0, 0.1, 0.9, 0.25);
		getglobal("Node3TimerFrame"):SetBackdropBorderColor(1, 1, 1, 0.5);
		getglobal("Node4TimerFrame"):SetBackdropColor(0, 0.1, 0.9, 0.25);
		getglobal("Node4TimerFrame"):SetBackdropBorderColor(1, 1, 1, 0.5);
		getglobal("Node5TimerFrame"):SetBackdropColor(0, 0.1, 0.9, 0.25);
		getglobal("Node5TimerFrame"):SetBackdropBorderColor(1, 1, 1, 0.5);
		ABH_ShowOptionButtons(0);


--LOCALIZED
		if (ABHelperOptions["AssaultText"] == nil) then
			ABHelperOptions["AssaultText"] = TRANSLATION_DEFAULT_ASSAULT_MSG;
		end

--LOCALIZED
		if (ABHelperOptions["IncomingText"] == nil) then
			ABHelperOptions["IncomingText"] = TRANSLATION_DEFAULT_INCOMING_MSG
		end


		if( ABHelperOptions["LowProfile"] == nil) then
			ABHelperOptions["LowProfile"] = 0;
		end
		
		if( ABHelperOptions["Mode"] == nil) then
			ABHelperOptions["Mode"] = 0;
		end
		
		--[[
		if( ABHelperOptions["Mode"] == 0 ) then
			ABH_Vertical_Mode();
		else
			ABH_Horizontal_Mode();
		end
		]]

		ABH_Change_Mode( ABHelperOptions["Mode"] );

		ABH_ResetMod_ArathiBasin();


		if (ABHelperOptions["UserStatements"] == nil) then
			ABHelperOptions["UserStatements"] = {};
		end

		
		if( ABHelperOptions["TimerMode"] == nil ) then
			ABHelperOptions["TimerMode"] = "0";
		end

		ABH_SetTimerMode(ABHelperOptions["TimerMode"]);

		if( ABHelperOptions["UserMsgMode"] == nil ) then
			ABHelperOptions["UserMsgMode"] = 0;
		end

		--ABH_SetUserMsgMode( ABHelperOptions["UserMsgMode"] );

		if (ABHelperOptions["UserStatements"]["NotFirstTime"] == nil) then
			ABH_ResetPosition();
			ABH_Reset_UserStatements();	
			ABHelperOptions["UserStatements"]["NotFirstTime"] = 1;
		end
		
		--if (ABHelperOptions["UserStatements"]["NotFirstTime"] == nil) then
		--	ABHelperOptions["UserStatements"]["NotFirstTime"] = 1;
		--end

		if (ABHelperOptions["TransValue"] == nil ) then
			ABHelperOptions["TransValue"] = 100;
		end

		ABH_SetTransparency(ABHelperOptions["TransValue"]);
		
		ABHelperOptionsFrameSlider_Transparency:SetValue( ABHelperOptions["TransValue"] );

		if (ABHelperOptions["ScaleValue"] == nil ) then
			ABHelperOptions["ScaleValue"] = 1.0;
		end

		ABHelperFrame:SetScale( ABHelperOptions["ScaleValue"] );

		ABHelperOptionsFrameSlider_Scale:SetValue( ABHelperOptions["ScaleValue"] );
		--ABH_SetPosition();

		if ( ABHelperOptions["LowProfile"] == 0 ) then
			
			ABHelper_Hide(0);
			--ABHelperFrame:Hide();
		elseif ( ABHelperOptions["LowProfile"] == 1 ) then
			
			ABHelper_Hide(1);
			--ABHelperFrame:Hide();
		end
		
		if(ABHelperOptions["Disabled"] == nil) then
			ABHelperOptions["Disabled"] = 0;
		end

		ABHelperOptionsFrameCheck_Lowprofile:SetChecked( ABHelperOptions["LowProfile"] );
		ABHelperOptionsFrameCheck_HorzMode:SetChecked( ABHelperOptions["Mode"] );
		ABHelperOptionsFrameCheck_TimerMode:SetChecked( ABHelperOptions["TimerMode"] );
		ABHelperOptionsFrameCheck_Auto:SetChecked( ABHelperOptions["Disabled"] );
		ABHelperOptionsFrameCheck_UserMsgMode:SetChecked( ABHelperOptions["UserMsgMode"] );
		
	elseif ( event == "PLAYER_ENTERING_WORLD" ) then

		--ABH_SetPosition();

		if ( ABHelperOptions["LowProfile"] == 0 ) then
			
			ABHelper_Hide(0);
			--ABHelperFrame:Hide();
		elseif ( ABHelperOptions["LowProfile"] == 1 ) then
			
			ABHelper_Hide(1);
			--ABHelperFrame:Hide();
		end


		for i=1, MAX_BATTLEFIELD_QUEUES do
			ABH_BGStatus, ABH_BGName,_ = GetBattlefieldStatus(i);

			if ( ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_ARATHIBASIN) then
				break;
			elseif ( ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_EYEOFSTORM) then
				break;
			end
		end

--LOCALIZED
		if ( ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_ARATHIBASIN) then
			currentBG = "ARATHIBASIN";

			ToggleWorldMap();
			ToggleWorldMap();
			ABH_ResetMod_ArathiBasin();
			ABH_SetEntryNodeStatus_ArathiBasin();

			if(ABHelperOptions["Disabled"] == 0) then
				ABH_ShowHelper();
			end
		elseif (ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_EYEOFSTORM) then
			currentBG = "EYEOFSTORM";
			ToggleWorldMap();
			ToggleWorldMap();
			ABH_ResetMod_EyeOfStorm();
			ABH_SetEntryNodeStatus_EyeOfStorm();

			if(ABHelperOptions["Disabled"] == nil) then
				ABH_ShowHelper();
			end
		else
			ABH_ResetMod_ArathiBasin();
			ABHelperFrame:Hide();
		end
		

	elseif ( event == "WORLD_MAP_UPDATE" ) then

--LOCALIZED
		if ( ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_ARATHIBASIN) then
			ABH_SetEntryNodeStatus_ArathiBasin();
		elseif ( ABH_BGStatus == "active" and ABH_BGName == TRANSLATION_EYEOFSTORM) then
			ABH_SetEntryNodeStatus_EyeOfStorm();
		end

	else

		if( ABH_BGName == TRANSLATION_ARATHIBASIN ) then
			ABH_OnEvent_ArathiBasin( event, arg1 );
		elseif( ABH_BGName == TRANSLATION_EYEOFSTORM ) then
			ABH_OnEvent_EyeOfStorm( event, arg1 );
		end

	end

end


function ABH_OnEvent_EyeOfStorm( event, arg1 )

	tmparg1 = lower(arg1);

	if (event == "CHAT_MSG_BG_SYSTEM_ALLIANCE") then
	
		--DEFAULT_CHAT_FRAME:AddMessage("Event thrown: CHAT_MSG_BG_SYSTEM_ALLIANCE");

		

		if(string.find(tmparg1, lower(TRANSLATION_TOWER1))) then
				ABH_PulseButton( 2 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER2))) then
				ABH_PulseButton( 0 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER3))) then
				ABH_PulseButton( 3 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER4))) then
				ABH_PulseButton( 1 );
			elseif(string.find(tmparg1, lower(TRANSLATION_CENTER))) then
				ABH_PulseButton( 4 );
				--ABH_FlagHack(tmparg1, 0);
				ABH_SetIcon(TRANSLATION_CENTER, ALLIANCE_CONTROLS);
		end
--LOCALIZED


	elseif(event == "CHAT_MSG_BG_SYSTEM_NEUTRAL") then

		if(string.find(tmparg1, lower(TRANSLATION_CENTER))) then
			ABH_PulseButton( 4 );
			--ABH_FlagHack(tmparg1, 1);
			ABH_SetIcon(TRANSLATION_CENTER, UNCONTESTED);
		end

	elseif(event == "CHAT_MSG_BG_SYSTEM_HORDE") then
		
		--DEFAULT_CHAT_FRAME:AddMessage("Event thrown: CHAT_MSG_BG_SYSTEM_HORDE");

--LOCALIZED	
		if(string.find(tmparg1, lower(TRANSLATION_TOWER1))) then
				ABH_PulseButton( 2 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER2))) then
				ABH_PulseButton( 0 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER3))) then
				ABH_PulseButton( 3 );
			elseif(string.find(tmparg1, lower(TRANSLATION_TOWER4))) then
				ABH_PulseButton( 1 );
			elseif(string.find(tmparg1, lower(TRANSLATION_CENTER))) then
				ABH_PulseButton( 4 );
				--ABH_FlagHack(tmparg1, 1);
				ABH_SetIcon(TRANSLATION_CENTER, HORDE_CONTROLS);
		end

	end
end


function ABH_OnEvent_ArathiBasin( event, arg1 )

	local i;

	if (event == "CHAT_MSG_BG_SYSTEM_ALLIANCE") then
	
		--DEFAULT_CHAT_FRAME:AddMessage("Event thrown: CHAT_MSG_BG_SYSTEM_ALLIANCE");

		tmparg1 = lower(arg1);
--LOCALIZED
		if(string.find(arg1, TRANSLATION_ASSAULTED) or string.find(arg1, TRANSLATION_CLAIMS)) then
			

			if(string.find(tmparg1, lower(TRANSLATION_MILL))) then
				ABH_PulseButton( 0 );
				getglobal("Node2TimerFrame"):Show();
				
				Node2TimerValue = 61;
				Node2OldClockTime = time();
				SetTimerColor("Node2");

			elseif(string.find(tmparg1, lower(TRANSLATION_MINE))) then
				ABH_PulseButton( 1 );
				getglobal("Node4TimerFrame"):Show();
				Node4TimerValue = 61;
				Node4OldClockTime = time();				
				SetTimerColor("Node4");

			elseif(string.find(tmparg1, lower(TRANSLATION_FARM))) then
				ABH_PulseButton( 2 );
				getglobal("Node1TimerFrame"):Show();
				
				Node1TimerValue = 61;
				Node1OldClockTime = time();
				SetTimerColor("Node1");

			elseif(string.find(tmparg1, lower(TRANSLATION_BLACKSMITH))) then
				ABH_PulseButton( 3 );
				getglobal("Node3TimerFrame"):Show();
				
				Node3TimerValue = 61;
				Node3OldClockTime = time();
				SetTimerColor("Node3");

			elseif(string.find(tmparg1, lower(TRANSLATION_STABLES))) then
				ABH_PulseButton( 4 );
				getglobal("Node5TimerFrame"):Show();
				
				Node5TimerValue = 61;
				Node5OldClockTime = time();
				SetTimerColor("Node5");
			end
--LOCALIZED
		elseif(string.find(tmparg1, TRANSLATION_TAKEN) or string.find(tmparg1, TRANSLATION_DEFENDED)) then
			
			if(string.find(tmparg1, lower(TRANSLATION_MILL))) then
				ABH_PulseButton( 0 );
				Node2TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_MINE))) then
				ABH_PulseButton( 1 );
				Node4TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_FARM))) then
				ABH_PulseButton( 2 );
				Node1TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_BLACKSMITH))) then
				ABH_PulseButton( 3 );
				Node3TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_STABLES))) then
				ABH_PulseButton( 4 );
				Node5TimerValue = 0;
			end
		end

	elseif(event == "CHAT_MSG_BG_SYSTEM_HORDE") then
		
		--DEFAULT_CHAT_FRAME:AddMessage("Event thrown: CHAT_MSG_BG_SYSTEM_HORDE");

		tmparg1 = lower(arg1);
--LOCALIZED	
		if(string.find(tmparg1, TRANSLATION_ASSAULTED) or string.find(tmparg1, TRANSLATION_CLAIMS)) then
			
			if(string.find(tmparg1, lower(TRANSLATION_MILL))) then
				ABH_PulseButton( 0 );
				getglobal("Node2TimerFrame"):Show();
				
				Node2TimerValue = 61;
				Node2OldClockTime = time();
				SetTimerColor("Node2");

			elseif(string.find(tmparg1, lower(TRANSLATION_MINE))) then
				ABH_PulseButton( 1 );
				getglobal("Node4TimerFrame"):Show();	
				
				Node4TimerValue = 61;
				Node4OldClockTime = time();
				SetTimerColor("Node4");

			elseif(string.find(tmparg1, lower(TRANSLATION_FARM))) then
				ABH_PulseButton( 2 );
				getglobal("Node1TimerFrame"):Show();
				
				Node1TimerValue = 61;
				Node1OldClockTime = time();
				SetTimerColor("Node1");

			elseif(string.find(tmparg1, lower(TRANSLATION_BLACKSMITH))) then
				ABH_PulseButton( 3 );
				getglobal("Node3TimerFrame"):Show();
				
				Node3TimerValue = 61;
				Node3OldClockTime = time();
				SetTimerColor("Node3");

			elseif(string.find(tmparg1, lower(TRANSLATION_STABLES))) then	
				ABH_PulseButton( 4 );
				getglobal("Node5TimerFrame"):Show();
				
				Node5TimerValue = 61;
				Node5OldClockTime = time();
				SetTimerColor("Node5");
			end

--LOCALIZED
		elseif(string.find(tmparg1, TRANSLATION_TAKEN) or string.find(tmparg1, TRANSLATION_DEFENDED)) then
			
			if(string.find(tmparg1, lower(TRANSLATION_MILL))) then
				ABH_PulseButton( 0 );
				Node2TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_MINE))) then
				ABH_PulseButton( 1 );
				Node4TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_FARM))) then
				ABH_PulseButton( 2 );
				Node1TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_BLACKSMITH))) then
				ABH_PulseButton( 3 );
				Node3TimerValue = 0;

			elseif(string.find(tmparg1, lower(TRANSLATION_STABLES))) then
				ABH_PulseButton( 4 );
				Node5TimerValue = 0;

			end
		
		end

	end

end


--LOCALIZED
function ABH_UserButtonOnEnter(num)
	local node = ABH_UserStatementPopupTitle:GetText();
	local TmpStr = {};

--ARATHI BASIN

	if ( node == TRANSLATION_FARM ) then
		TmpStr = ABHelperOptions["UserStatements"]["Farm"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_LUMBERMILL ) then
		TmpStr = ABHelperOptions["UserStatements"]["Mill"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_BLACKSMITH ) then
		TmpStr = ABHelperOptions["UserStatements"]["Smith"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_GOLDMINE ) then
		TmpStr = ABHelperOptions["UserStatements"]["Mine"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_STABLES ) then
		TmpStr = ABHelperOptions["UserStatements"]["Stables"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);

--EYE OF STORM (be sure to rename the placeholders...)

	elseif ( node == TRANSLATION_TOWER1 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower1"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_TOWER2 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower2"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_TOWER3 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower3"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_TOWER4 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower4"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	elseif ( node == TRANSLATION_CENTER ) then
		TmpStr = ABHelperOptions["UserStatements"]["Center"..num];
		GameTooltip_SetDefaultAnchor(GameTooltip, UIParent); 
		GameTooltip:SetText(TmpStr);
	end
end
				

--NOT LOCALIZED
function ABH_Reset_UserStatements()

	ABHelperOptions["UserStatements"] = {};

--FARM
	if (ABHelperOptions["UserStatements"]["Farm1"] == nil) then
		ABHelperOptions["UserStatements"]["Farm1"] = "Inc farm from mines.";
	end

	if (ABHelperOptions["UserStatements"]["Farm2"] == nil) then
		ABHelperOptions["UserStatements"]["Farm2"] = "Inc farm from mill.";
	end

	if (ABHelperOptions["UserStatements"]["Farm3"] == nil) then
		ABHelperOptions["UserStatements"]["Farm3"] = "Inc farm from blacksmith.";
	end

	if (ABHelperOptions["UserStatements"]["Farm4"] == nil) then
		ABHelperOptions["UserStatements"]["Farm4"] = "Sapped at farm!";
	end

	if (ABHelperOptions["UserStatements"]["Farm5"] == nil) then
		ABHelperOptions["UserStatements"]["Farm5"] = "Nobody defending farm.";
	end

--MILL
	if (ABHelperOptions["UserStatements"]["Mill1"] == nil) then
		ABHelperOptions["UserStatements"]["Mill1"] = "Inc mill from stables.";
	end

	if (ABHelperOptions["UserStatements"]["Mill2"] == nil) then
		ABHelperOptions["UserStatements"]["Mill2"] = "Inc mill from farm.";
	end

	if (ABHelperOptions["UserStatements"]["Mill3"] == nil) then
		ABHelperOptions["UserStatements"]["Mill3"] = "Inc mill from blacksmith.";
	end

	if (ABHelperOptions["UserStatements"]["Mill4"] == nil) then
		ABHelperOptions["UserStatements"]["Mill4"] = "Sapped at mill!";
	end

	if (ABHelperOptions["UserStatements"]["Mill5"] == nil) then
		ABHelperOptions["UserStatements"]["Mill5"] = "Nobody defending mill.";
	end

--SMITH
	if (ABHelperOptions["UserStatements"]["Smith1"] == nil) then
		ABHelperOptions["UserStatements"]["Smith1"] = "Inc smith from farm.";
	end

	if (ABHelperOptions["UserStatements"]["Smith2"] == nil) then
		ABHelperOptions["UserStatements"]["Smith2"] = "Inc smith from mill.";
	end

	if (ABHelperOptions["UserStatements"]["Smith3"] == nil) then
		ABHelperOptions["UserStatements"]["Smith3"] = "Inc smith from mines.";
	end

	if (ABHelperOptions["UserStatements"]["Smith4"] == nil) then
		ABHelperOptions["UserStatements"]["Smith4"] = "Inc smith from stables.";
	end

	if (ABHelperOptions["UserStatements"]["Smith5"] == nil) then
		ABHelperOptions["UserStatements"]["Smith5"] = "Sapped at smith!";
	end

	if (ABHelperOptions["UserStatements"]["Smith6"] == nil) then
		ABHelperOptions["UserStatements"]["Smith6"] = "Nobody defending smith.";
	end

--MINE
	if (ABHelperOptions["UserStatements"]["Mine1"] == nil) then
		ABHelperOptions["UserStatements"]["Mine1"] = "Inc mines from farm.";
	end

	if (ABHelperOptions["UserStatements"]["Mine2"] == nil) then
		ABHelperOptions["UserStatements"]["Mine2"] = "Inc mines from stables.";
	end

	if (ABHelperOptions["UserStatements"]["Mine3"] == nil) then
		ABHelperOptions["UserStatements"]["Mine3"] = "Inc mines from blacksmith.";
	end

	if (ABHelperOptions["UserStatements"]["Mine4"] == nil) then
		ABHelperOptions["UserStatements"]["Mine4"] = "Sapped at mines!";
	end

	if (ABHelperOptions["UserStatements"]["Mine5"] == nil) then
		ABHelperOptions["UserStatements"]["Mine5"] = "Nobody defending mines.";
	end

--STABLES
	if (ABHelperOptions["UserStatements"]["Stables1"] == nil) then
		ABHelperOptions["UserStatements"]["Stables1"] = "Inc stables from blacksmith.";
	end

	if (ABHelperOptions["UserStatements"]["Stables2"] == nil) then
		ABHelperOptions["UserStatements"]["Stables2"] = "Inc stables from mills.";
	end

	if (ABHelperOptions["UserStatements"]["Stables3"] == nil) then
		ABHelperOptions["UserStatements"]["Stables3"] = "Inc stables from mines.";
	end

	if (ABHelperOptions["UserStatements"]["Stables4"] == nil) then
		ABHelperOptions["UserStatements"]["Stables4"] = "Inc stables from Alliance base.";
	end

	if (ABHelperOptions["UserStatements"]["Stables5"] == nil) then
		ABHelperOptions["UserStatements"]["Stables5"] = "Sapped at stables!";
	end

	if (ABHelperOptions["UserStatements"]["Stables6"] == nil) then
		ABHelperOptions["UserStatements"]["Stables6"] = "Nobody defending stables.";
	end

	if (ABHelperOptions["UserStatements"]["Stables7"] == nil) then
		ABHelperOptions["UserStatements"]["Stables7"] = "Get the hell away from the stables, jesus newbs...";
	end

--TOWER1
	if (ABHelperOptions["UserStatements"]["Tower11"] == nil) then
		ABHelperOptions["UserStatements"]["Tower11"] = "Incoming to blood elf tower from bridge.";
	end

	if (ABHelperOptions["UserStatements"]["Tower12"] == nil) then
		ABHelperOptions["UserStatements"]["Tower12"] = "Incoming to blood elf tower from center.";
	end

--TOWER2
	if (ABHelperOptions["UserStatements"]["Tower21"] == nil) then
		ABHelperOptions["UserStatements"]["Tower21"] = "Incoming to draenei ruins from bridge.";
	end

	if (ABHelperOptions["UserStatements"]["Tower22"] == nil) then
		ABHelperOptions["UserStatements"]["Tower22"] = "Incoming to draenei ruins from center.";
	end

--TOWER3
	if (ABHelperOptions["UserStatements"]["Tower31"] == nil) then
		ABHelperOptions["UserStatements"]["Tower31"] = "Incoming to fel reaver ruins from bridge.";
	end

	if (ABHelperOptions["UserStatements"]["Tower32"] == nil) then
		ABHelperOptions["UserStatements"]["Tower32"] = "Incoming to fel reaver ruins from center.";
	end

--TOWER4
	if (ABHelperOptions["UserStatements"]["Tower41"] == nil) then
		ABHelperOptions["UserStatements"]["Tower41"] = "Incoming to mage tower from bridge.";
	end

	if (ABHelperOptions["UserStatements"]["Tower42"] == nil) then
		ABHelperOptions["UserStatements"]["Tower42"] = "Incoming to mage tower from center.";
	end

--CENTER
	if (ABHelperOptions["UserStatements"]["Center1"] == nil) then
		ABHelperOptions["UserStatements"]["Center1"] = "Need more people at flag.";
	end

	if (ABHelperOptions["UserStatements"]["Center2"] == nil) then
		ABHelperOptions["UserStatements"]["Center2"] = "Too many people at flag.";
	end
end


function ABH_PopulatePopUpButtons(name, id)
	--DEFAULT_CHAT_FRAME:AddMessage(getglobal(name):GetText());
	getglobal(name.."Text"):SetText(id);
end


-- Populates the user defined statement popup.
function ABH_Populate_UserStatements(button)
	local i;
	local TmpStr  = {};
	local TmpStr2 = {};

--ARATHI BASIN
	if (  button == TRANSLATION_FARM ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Farm"..i] ~= nil and ABHelperOptions["UserStatements"]["Farm"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Farm"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Farm"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end
					
				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif (  button == TRANSLATION_LUMBERMILL ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Mill"..i] ~= nil and ABHelperOptions["UserStatements"]["Mill"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Mill"..i], 1, 14);
				
				if(strlen(ABHelperOptions["UserStatements"]["Mill"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_BLACKSMITH ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Smith"..i] ~= nil and ABHelperOptions["UserStatements"]["Smith"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Smith"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Smith"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_GOLDMINE ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Mine"..i] ~= nil and ABHelperOptions["UserStatements"]["Mine"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Mine"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Mine"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_STABLES ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Stables"..i] ~= nil and ABHelperOptions["UserStatements"]["Stables"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Stables"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Stables"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
			
		end

--EYE OF STORM
	elseif ( button == TRANSLATION_TOWER1 ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Tower1"..i] ~= nil and ABHelperOptions["UserStatements"]["Tower1"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Tower1"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Tower1"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_TOWER2 ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Tower2"..i] ~= nil and ABHelperOptions["UserStatements"]["Tower2"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Tower2"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Tower2"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_TOWER3 ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Tower3"..i] ~= nil and ABHelperOptions["UserStatements"]["Tower3"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Tower3"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Tower3"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_TOWER4 ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Tower4"..i] ~= nil and ABHelperOptions["UserStatements"]["Tower4"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Tower4"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Tower4"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	elseif ( button == TRANSLATION_CENTER ) then
		for i=1,8 do
			if ( ABHelperOptions["UserStatements"]["Center"..i] ~= nil and ABHelperOptions["UserStatements"]["Center"..i] ~= "") then
				TmpStr = strsub(ABHelperOptions["UserStatements"]["Center"..i], 1, 14);

				if(strlen(ABHelperOptions["UserStatements"]["Center"..i]) > 14) then
					TmpStr = TmpStr.."...";
				end

				--getglobal("ABHUserStatementButton"..i):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i.."Text"):SetText(TmpStr);
				getglobal("ABHUserStatementButton"..i):Show();
			else
				getglobal("ABHUserStatementButton"..i):Hide();
			end
		end
	end
end


function ABH_ShowHelper()
	if ( ABHelperOptions["LowProfile"] == 0 ) then
		ABHelper_Hide(0);
	elseif ( ABHelperOptions["LowProfile"] == 1 ) then
		ABHelper_Hide(1);
	end

	ABHelperFrame:Show();
	ABH_Change_Mode( ABHelperOptions["Mode"] );
	
end


function ABH_ShowOptionButtons(val)

	if(val == 0) then
		ABHelperCloseButton:SetAlpha(0);
		ABHelperHideButton:SetAlpha(0);
		ABHelperHelpButton:SetAlpha(0);
		--ABHelperConvertRaidButton:SetAlpha(0);

	elseif (val == 1) then
		ABHelperCloseButton:SetAlpha(1);
		ABHelperHideButton:SetAlpha(1);
		ABHelperHelpButton:SetAlpha(1);
		--ABHelperConvertRaidButton:SetAlpha(1);
		
	end
end


function ABH_SetTransparency(transval)
	ABHelperFrame:SetAlpha(transval/100);
end


--LOCALIZED
function ABH_SetIcon(node, status)

--ARATHI BASIN

	if ( node == TRANSLATION_FARM ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node1Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_FARM] = UNCONTESTED;
			getglobal("Node1Icon"):SetTexCoord(0.875, 1, 0.375, 0.5);

		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node1Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_FARM] = ALLIANCE_CONTROLS;
			getglobal("Node1Icon"):SetTexCoord(0.125, 0.25, 0.5, 0.625);

		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node1Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_FARM] = HORDE_CONTROLS;
			getglobal("Node1Icon"):SetTexCoord(0.375, 0.5, 0.5, 0.625);

		elseif ( status == ALLIANCE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_FARM] = ALLIANCE_CONTESTED;
			ABH_SetText("ABH_Node1Text", 0, 0, 0.5);
			getglobal("Node1Icon"):SetTexCoord(0, 0.125, 0.5, 0.625);

		elseif ( status == HORDE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_FARM] = HORDE_CONTESTED;
			ABH_SetText("ABH_Node1Text", 0.5, 0, 0);
			getglobal("Node1Icon"):SetTexCoord(0.25, 0.375, 0.5, 0.625);

		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure1");
		end

	elseif ( node == TRANSLATION_GOLDMINE ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node4Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_GOLDMINE] = UNCONTESTED;	
			getglobal("Node4Icon"):SetTexCoord(0, 0.125, 0.25, 0.375);

		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node4Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_GOLDMINE] = -1;
			getglobal("Node4Icon"):SetTexCoord(0.25, 0.375, 0.25, 0.375);

		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node4Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_GOLDMINE] = HORDE_CONTROLS;
			getglobal("Node4Icon"):SetTexCoord(0.5, 0.625, 0.25, 0.375);	

		elseif ( status == ALLIANCE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_GOLDMINE] = ALLIANCE_CONTESTED;
			ABH_SetText("ABH_Node4Text", 0, 0, 0.5);
			getglobal("Node4Icon"):SetTexCoord(0.125, 0.25, 0.25, 0.375);
	
		elseif ( status == HORDE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_GOLDMINE] = HORDE_CONTESTED;
			ABH_SetText("ABH_Node4Text", 0.5, 0, 0);
			getglobal("Node4Icon"):SetTexCoord(0.375, 0.5, 0.25, 0.375);
			
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure2");
		end
	elseif ( node == TRANSLATION_BLACKSMITH ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node3Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_BLACKSMITH] = UNCONTESTED;	
			getglobal("Node3Icon"):SetTexCoord(0.25, 0.375, 0.375, 0.5);
			
		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node3Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_BLACKSMITH] = ALLIANCE_CONTROLS;
			getglobal("Node3Icon"):SetTexCoord(0.5, 0.625, 0.375, 0.5);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node3Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_BLACKSMITH] = HORDE_CONTROLS;
			getglobal("Node3Icon"):SetTexCoord(0.75, 0.875, 0.375, 0.5);
			
		elseif ( status == ALLIANCE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_BLACKSMITH] = ALLIANCE_CONTESTED;
			ABH_SetText("ABH_Node3Text", 0, 0, 0.5);
			getglobal("Node3Icon"):SetTexCoord(0.375, 0.5, 0.375, 0.5);
			
		elseif ( status == HORDE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_BLACKSMITH] = HORDE_CONTESTED;
			ABH_SetText("ABH_Node3Text", 0.5, 0, 0);
			getglobal("Node3Icon"):SetTexCoord(0.625, 0.75, 0.375, 0.5);
			
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure3");
		end
	elseif ( node == TRANSLATION_LUMBERMILL ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node2Text", 1, 1, 1);	
			ABHNodeStatus[TRANSLATION_LUMBERMILL] = UNCONTESTED;
			getglobal("Node2Icon"):SetTexCoord(0.625, 0.75, 0.25, 0.375);
			
		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node2Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_LUMBERMILL] = ALLIANCE_CONTROLS;
			getglobal("Node2Icon"):SetTexCoord(0.875, 1, 0.25, 0.375);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node2Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_LUMBERMILL] = HORDE_CONTROLS;
			getglobal("Node2Icon"):SetTexCoord(0.125, 0.25, 0.375, 0.5);
			
		elseif ( status == ALLIANCE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_LUMBERMILL] = ALLIANCE_CONTESTED;
			ABH_SetText("ABH_Node2Text", 0, 0, 0.5);
			getglobal("Node2Icon"):SetTexCoord(0.75, 0.875, 0.25, 0.375);
			
		elseif ( status == HORDE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_LUMBERMILL] = HORDE_CONTESTED;
			ABH_SetText("ABH_Node2Text", 0.5, 0, 0);
			getglobal("Node2Icon"):SetTexCoord(0, 0.125, 0.375, 0.5);
			
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure4");	
		end
	elseif ( node == TRANSLATION_STABLES ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node5Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_STABLES] = UNCONTESTED;
			getglobal("Node5Icon"):SetTexCoord(0.5, 0.625, 0.5, 0.625);
			
		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node5Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_STABLES] = ALLIANCE_CONTROLS;
			getglobal("Node5Icon"):SetTexCoord(0.75, 0.875, 0.5, 0.625);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node5Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_STABLES] = HORDE_CONTROLS;
			getglobal("Node5Icon"):SetTexCoord(0, 0.125, 0.625, 0.75);
			
		elseif ( status == ALLIANCE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_STABLES] = ALLIANCE_CONTESTED;	
			ABH_SetText("ABH_Node5Text", 0, 0, 0.5);
			getglobal("Node5Icon"):SetTexCoord(0.625, 0.75, 0.5, 0.625);	

		elseif ( status == HORDE_CONTESTED ) then
			ABHNodeStatus[TRANSLATION_STABLES] = HORDE_CONTESTED;
			ABH_SetText("ABH_Node5Text", 0.5, 0, 0);
			getglobal("Node5Icon"):SetTexCoord(0.875, 1, 0.5, 0.625);
		
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure5");
		end
-- GRAPPLE2

--EYE OF STORM
	elseif ( node == TRANSLATION_TOWER1 ) then
		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node1Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_TOWER1] = UNCONTESTED;
			getglobal("Node1Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);

		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node1Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_TOWER1] = ALLIANCE_CONTROLS;
			getglobal("Node1Icon"):SetTexCoord(0.25, 0.375, 0.125, 0.25);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node1Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_TOWER1] = HORDE_CONTROLS;
			getglobal("Node1Icon"):SetTexCoord(0.125, 0.25, 0.125, 0.25);

		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure6");
		end

	elseif ( node == TRANSLATION_TOWER2 ) then

		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node2Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_TOWER2] = UNCONTESTED;
			getglobal("Node2Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
			
		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node2Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_TOWER2] = ALLIANCE_CONTROLS;
			getglobal("Node2Icon"):SetTexCoord(0.25, 0.375, 0.125, 0.25);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node2Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_TOWER2] = HORDE_CONTROLS;
			getglobal("Node2Icon"):SetTexCoord(0.125, 0.25, 0.125, 0.25);
			
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure7");
		end
	elseif ( node == TRANSLATION_TOWER3 ) then

		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node3Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_TOWER3] = UNCONTESTED;
			getglobal("Node3Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);
			
		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node3Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_TOWER3] = ALLIANCE_CONTROLS;
			getglobal("Node3Icon"):SetTexCoord(0.25, 0.375, 0.125, 0.25);

		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node3Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_TOWER3] = HORDE_CONTROLS;
			getglobal("Node3Icon"):SetTexCoord(0.125, 0.25, 0.125, 0.25);

		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure8");
		end
	elseif ( node == TRANSLATION_TOWER4 ) then

		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node4Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_TOWER4] = UNCONTESTED;
			getglobal("Node4Icon"):SetTexCoord(0.625, 0.75, 0.0, 0.125);

		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node4Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_TOWER4] = ALLIANCE_CONTROLS;
			getglobal("Node4Icon"):SetTexCoord(0.25, 0.375, 0.125, 0.25);
			
		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node4Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_TOWER4] = HORDE_CONTROLS;
			getglobal("Node4Icon"):SetTexCoord(0.125, 0.25, 0.125, 0.25);

		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure9");
		end
	elseif ( node == TRANSLATION_CENTER ) then

		if ( status == UNCONTESTED ) then
			ABH_SetText("ABH_Node5Text", 1, 1, 1);
			ABHNodeStatus[TRANSLATION_CENTER] = UNCONTESTED;
			getglobal("Node5Icon"):SetTexCoord(0.625, 0.75, 0.625, 0.75);

		elseif ( status == ALLIANCE_CONTROLS ) then
			ABH_SetText("ABH_Node5Text", 0, 0, 1);
			ABHNodeStatus[TRANSLATION_CENTER] = ALLIANCE_CONTROLS;
			getglobal("Node5Icon"):SetTexCoord(0.375, 0.5, 0.625, 0.75);

		elseif ( status == HORDE_CONTROLS ) then
			ABH_SetText("ABH_Node5Text", 1, 0, 0);
			ABHNodeStatus[TRANSLATION_CENTER] = HORDE_CONTROLS;
			getglobal("Node5Icon"):SetTexCoord(0.5, 0.625, 0.625, 0.75);
			
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure10");
		end
	else
		DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure11");
	end
end


function ABH_SetEntryNodeStatus_EyeOfStorm()

	local name, description, textID, x, y, i;
	
	for i = 1,4 do
		name, description, textID, x, y = GetMapLandmarkInfo(i);

		if ( description ~= nil) then
			if ( string.find(description, TRANSLATION_ALLIANCE) ) then
				ABH_SetIcon(name, ALLIANCE_CONTROLS)
			elseif ( string.find(description, TRANSLATION_HORDE) ) then
				ABH_SetIcon(name, HORDE_CONTROLS)
			elseif ( string.find(description, TRANSLATION_UNCONTROLLED) ) then

				ABH_SetIcon(name, UNCONTESTED);
			end
		end
	end

end


--LOCALIZED
--DEBUG will have to figure out the textID's for Eye Of Storm.
function ABH_SetEntryNodeStatus_ArathiBasin()

	local name, description, textID, x, y, i;
	
	for i = 1,5 do
		name, description, textID, x, y = GetMapLandmarkInfo(i);

		if ( description ~= nil) then
			if ( string.find(description, TRANSLATION_ALLIANCE) ) then
				ABH_SetIcon(name, ALLIANCE_CONTROLS)
			elseif ( string.find(description, TRANSLATION_HORDE) ) then
				ABH_SetIcon(name, HORDE_CONTROLS)
			elseif ( string.find(description, TRANSLATION_CONFLICT) ) then
			
				if( textID == 29 or textID == 34 or textID == 19 or textID == 24 or textID == 39) then
					ABH_SetIcon(name, HORDE_CONTESTED)
				elseif( textID == 27 or textID == 32 or textID == 17 or textID == 22 or textID == 37) then
					ABH_SetIcon(name, ALLIANCE_CONTESTED)
				end
			end
		end
	end

end


--LOCALIZED
function ABH_Raid_Warning(node, number)
	local GroupType, GroupSize, RaidSize, ChannelNum;
	local faction;

	GroupSize = GetNumPartyMembers();
	RaidSize = GetNumRaidMembers();

	if ( number == nil) then
		number = "";
	end

	GroupType = "BATTLEGROUND";
	ChannelNum = "player";

	if (ABH_DebugMode) then
		GroupType = "WHISPER";
		ChannelNum = UnitName("player");
	end


--LOCALIZED
	faction = UnitFactionGroup("player");

	if(faction == "Horde") then
		if( ABHNodeStatus[node] == ALLIANCE_CONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == ALLIANCE_CONTROLS ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == UNCONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == HORDE_CONTROLS ) then
			SendChatMessage( number.." "..ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == HORDE_CONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum );
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure12"..ABHNodeStatus[node]);
		end
		
		--DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Horde");		

	elseif(faction == "Alliance") then
		if( ABHNodeStatus[node] == HORDE_CONTROLS ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == HORDE_CONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == UNCONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == ALLIANCE_CONTESTED ) then
			SendChatMessage( number.." "..ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum );
		elseif( ABHNodeStatus[node] == ALLIANCE_CONTROLS ) then
			SendChatMessage( number.." "..ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum );
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure13");
		end

		--DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Alliance");	
	end

	
end


function ABH_UserStatement_Send(num)
	local GroupType, GroupSize, RaidSize, ChannelNum;
	local node = ABH_UserStatementPopupTitle:GetText();
	local TmpStr = {};
	GroupSize = GetNumPartyMembers();
	RaidSize = GetNumRaidMembers();


	GroupType = "BATTLEGROUND";
	ChannelNum = "player";

--ARATHI BASIN
	if ( node == TRANSLATION_FARM ) then
		TmpStr = ABHelperOptions["UserStatements"]["Farm"..num];
		
	elseif ( node == TRANSLATION_LUMBERMILL ) then
		TmpStr = ABHelperOptions["UserStatements"]["Mill"..num];
		
	elseif ( node == TRANSLATION_BLACKSMITH ) then
		TmpStr = ABHelperOptions["UserStatements"]["Smith"..num];
		
	elseif ( node == TRANSLATION_GOLDMINE ) then
		TmpStr = ABHelperOptions["UserStatements"]["Mine"..num];
		
	elseif ( node == TRANSLATION_STABLES ) then
		TmpStr = ABHelperOptions["UserStatements"]["Stables"..num];

--EYE OF STORM
	elseif ( node == TRANSLATION_TOWER1 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower1"..num];	

	elseif ( node == TRANSLATION_TOWER2 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower2"..num];

	elseif ( node == TRANSLATION_TOWER3 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower3"..num];

	elseif ( node == TRANSLATION_TOWER4 ) then
		TmpStr = ABHelperOptions["UserStatements"]["Tower4"..num];

	elseif ( node == TRANSLATION_CENTER ) then
		TmpStr = ABHelperOptions["UserStatements"]["Center"..num];	
	end

	if (TmpStr ~= nil and TmpStr ~= "") then
		SendChatMessage(TmpStr, GroupType, nil, ChannelNum );
	end
	
	ABHUserStatementPopup:Hide();
end


function ABH_DEBUG2(num)
		node = "Farm";
		ABHNodeStatus["Farm"] = num;
		
		GroupType = "WHISPER"
		ChannelNum = "Thronk"

		if(ABHNodeStatus[node] == 1) then
			SendChatMessage(ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum);
		elseif(ABHNodeStatus[node] == 2) then
			SendChatMessage(ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum);
		elseif(ABHNodeStatus[node] == 0) then
			SendChatMessage(ABHelperOptions["AssaultText"].." "..node, GroupType, nil, ChannelNum);
		elseif(ABHNodeStatus[node] == -2) then
			SendChatMessage(ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum);
		elseif(ABHNodeStatus[node] == -1) then
			SendChatMessage(ABHelperOptions["IncomingText"].." "..node, GroupType, nil, ChannelNum);
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUG: Failure14");
		end
end


function ABH_SetText(node, r, g, b)
	getglobal(node):SetTextColor(r, g, b);
end


function ABHelper_Hide(val)
	
	if (val == 1) then
		ABHelperOptions["LowProfile"] = 1;

		getglobal("ABHBack1"):SetTexture("");
		getglobal("ABHBack2"):SetTexture("");
		getglobal("ABHBack3"):SetTexture("");
		getglobal("IconFrame1"):SetTexture("");
		getglobal("IconFrame2"):SetTexture("");
		getglobal("IconFrame3"):SetTexture("");
		getglobal("IconFrame4"):SetTexture("");
		getglobal("IconFrame5"):SetTexture("");
		getglobal("ABHButton1Texture"):SetTexture("");
		getglobal("ABHButton2Texture"):SetTexture("");
		getglobal("ABHButton3Texture"):SetTexture("");
		getglobal("ABHButton4Texture"):SetTexture("");
		getglobal("ABHButton5Texture"):SetTexture("");

		getglobal("ABH_Title"):Hide();
		getglobal("ABHelperHideButton"):SetText("+");
		--getglobal("ABHelperFrame"):SetMovable("False");
		--getglobal("ABHelperFrame"):SetHeight(0);
		ABHelper_HideStatus = 1;

	elseif (val == 0) then
		ABHelperOptions["LowProfile"] = 0;

		getglobal("IconFrame1"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\IconFrame");
		getglobal("IconFrame2"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\IconFrame");
		getglobal("IconFrame3"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\IconFrame");
		getglobal("IconFrame4"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\IconFrame");
		getglobal("IconFrame5"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\IconFrame");
		getglobal("ABHButton1Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton2Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton3Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton4Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton5Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		

		getglobal("ABH_Title"):Show();
		getglobal("ABHelperHideButton"):SetText("-");
		--getglobal("ABHelperFrame"):SetMovable("True");
		ABHelper_HideStatus = 0;

		if( ABHelperOptions["Mode"] == 1 ) then
			getglobal("ABHBack1"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzLeft");
			getglobal("ABHBack2"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzMiddle");
			getglobal("ABHBack3"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzRight");
			ABHBack1:SetTexCoord(0, 0.585, 0, 1);
			ABHBack2:SetTexCoord(0, 1, 0, 1);
		else
			getglobal("ABHBack1"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABBackTop");
			getglobal("ABHBack2"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABBackBottom");
			getglobal("ABHBack3"):SetTexture("");
			ABHBack1:SetTexCoord(0, 1, 0, 1);
			ABHBack2:SetTexCoord(0, 1, 0, 1);
		end
		--ABH_Change_Mode( ABHelperOptions["Mode"] );
	end

end


--LOCALIZED
function ABHelper_Help()
	DEFAULT_CHAT_FRAME:AddMessage("Arathi Basin Helper usage:");
	DEFAULT_CHAT_FRAME:AddMessage("/abh show (displays the mod, whether you're in AB or not).");
	DEFAULT_CHAT_FRAME:AddMessage("/abh hide (hides the mod).");
	DEFAULT_CHAT_FRAME:AddMessage("/abh reset (resets the position of the mod to the middle of the screen).");
	DEFAULT_CHAT_FRAME:AddMessage("/abh options (displays the options window).");
	DEFAULT_CHAT_FRAME:AddMessage("Hover just over the top of the mod window to make three buttons appear");
	DEFAULT_CHAT_FRAME:AddMessage("the _, ?, and X buttons. _ puts the mod in lowprofile mode, while ? brings");
	DEFAULT_CHAT_FRAME:AddMessage("up the options window, and X closes the mod window.");
end


function ABH_DEBUG(i)

--[[
	if(i == 1) then
		Node1OldClockTime = time();
		Node1TimerValue = 61;
		SetTimerColor("Farm");
		getglobal("Node1TimerFrame"):Show();
		getglobal("Node1TimerFrame2"):Show();
	elseif(i == 2) then
		Node2OldClockTime = time();
		Node2TimerValue = 61;
		SetTimerColor("Mill");
		getglobal("Node2TimerFrame"):Show();
		getglobal("Node2TimerFrame2"):Show();

	elseif(i == 3) then
		Node3OldClockTime = time();
		Node3TimerValue = 61;
		SetTimerColor("Blacksmith");
		getglobal("Node3TimerFrame"):Show();
		getglobal("Node3TimerFrame2"):Show();
	elseif(i == 4) then
		Node4OldClockTime = time();
		Node4TimerValue = 61;
		SetTimerColor("Mine");
		getglobal("Node4TimerFrame"):Show();
		getglobal("Node4TimerFrame2"):Show();
	elseif(i == 5) then
		Node5OldClockTime = time();
		Node5TimerValue = 61;
		SetTimerColor("Stables");
		getglobal("Node5TimerFrame"):Show();
		getglobal("Node5TimerFrame2"):Show();
	end
]]
	--local name, description, textID, x, y = GetMapLandmarkInfo(i);
	--DEFAULT_CHAT_FRAME:AddMessage("name: "..name.." textID: "..textID);
	local uiType, state, text, icon, isFlashing, dynamicIcon = GetWorldStateUIInfo(i);
	DEFAULT_CHAT_FRAME:AddMessage("Type: "..uiType.." state: "..state.." text: "..text.." icon: "..icon.." flash: "..isFlashing);
end


--DEBUG
function ABH_Resource(i, num)
	local name, description, textureIndex, x, y;

	name, description, textureIndex, x, y = GetMapLandmarkInfo(i);
	
	--if(name == nil) then
	--	DEFAULT_CHAT_FRAME:AddMessage("DEBUG: nil");
	--	return;
	--end

	if(num == 1) then	
		DEFAULT_CHAT_FRAME:AddMessage(name);
	elseif(num == 2) then
		DEFAULT_CHAT_FRAME:AddMessage(description);
	elseif(num == 3) then
		DEFAULT_CHAT_FRAME:AddMessage(textureIndex);
	elseif(num == 4) then
		DEFAULT_CHAT_FRAME:AddMessage(x.." "..y);
	end
end


function ABH_PopupVanishTimer(arg1)
	
	if ( ABH_IsInWindow == nil ) then
		
		ABH_Popup_Counter = ABH_Popup_Counter + arg1;

		if(ABH_Popup_Counter >= 2) then
			ABHPickNumberPopup:Hide();
			--ABHUserStatementPopup:Hide();

			ABH_Popup_Counter = 0;
		end
	else
		ABH_Popup_Counter = 0;
	end
end


function ABH_UserStatementPopupVanishTimer(arg1)
	
	if ( ABH_IsInUserWindow == nil ) then
		
		ABH_UserStatementPopup_Counter = ABH_UserStatementPopup_Counter + arg1;

		if(ABH_UserStatementPopup_Counter >= 2) then
			--ABHPickNumberPopup:Hide();
			ABHUserStatementPopup:Hide();

			ABH_UserStatementPopup_Counter = 0;
		end
	else
		ABH_UserStatementPopup_Counter = 0;
	end
end


function ABH_OnUpdate(arg1)
	local CurrentTime = 0;

	--[[
	ABH_RaidResetCounter = ABH_RaidResetCounter + arg1;

	if ( ABH_RaidResetCounter >= 20 ) then
		ABH_InParty = 1;
		ABH_RaidResetCounter = 0;
		
		--ABHelperConvertRaidButton2:SetText("1");
	end
	]]

	ABHCounter = ABHCounter + arg1;

	if(ABHCounter >= 1) then

		CurrentTime = time();

		if(Node1TimerValue >= 0) then

			Node1TimerValue = Node1TimerValue - (CurrentTime - Node1OldClockTime);
			
			if(Node1TimerValue < 10) then
				getglobal("Node1TimerText"):SetTextColor(1, 0, 0);
				
			end

			if(Node1TimerValue >= 0) then
				getglobal("Node1TimerText"):SetText(date("%M:%S ", Node1TimerValue));
				
			else
				getglobal("Node1TimerFrame"):Hide();
				
			end
			
			Node1OldClockTime = CurrentTime;
			
		end
		
		if(Node2TimerValue >= 0) then
				
			
			Node2TimerValue = Node2TimerValue - (CurrentTime - Node2OldClockTime);
			
			if(Node2TimerValue < 10) then
				getglobal("Node2TimerText"):SetTextColor(1, 0, 0);
				
			end

			if(Node2TimerValue >= 0) then
				getglobal("Node2TimerText"):SetText(date("%M:%S ", Node2TimerValue));
				
			else
				getglobal("Node2TimerFrame"):Hide();
				
			end

			Node2OldClockTime = CurrentTime;

		end

		if(Node3TimerValue >= 0) then
			Node3TimerValue = Node3TimerValue - (CurrentTime - Node3OldClockTime);
			
			if(Node3TimerValue < 10) then
				getglobal("Node3TimerText"):SetTextColor(1, 0, 0);
				
			end

			if(Node3TimerValue >= 0) then
				getglobal("Node3TimerText"):SetText(date("%M:%S ", Node3TimerValue));
				
			else
				getglobal("Node3TimerFrame"):Hide();
				
			end
			Node3OldClockTime = CurrentTime;

		end

		if(Node4TimerValue >= 0) then
			Node4TimerValue = Node4TimerValue - (CurrentTime - Node4OldClockTime);
			
			if(Node4TimerValue < 10) then
				getglobal("Node4TimerText"):SetTextColor(1, 0, 0);
				
			end

			if(Node4TimerValue >= 0) then
				getglobal("Node4TimerText"):SetText(date("%M:%S ", Node4TimerValue));
				
			else
				getglobal("Node4TimerFrame"):Hide();
				
			end
			Node4OldClockTime = CurrentTime;

		end

		if(Node5TimerValue >= 0) then
			Node5TimerValue = Node5TimerValue - (CurrentTime - Node5OldClockTime);
			
			if(Node5TimerValue < 10) then
				getglobal("Node5TimerText"):SetTextColor(1, 0, 0);
				
			end

			if(Node5TimerValue >= 0) then
				getglobal("Node5TimerText"):SetText(date("%M:%S ", Node5TimerValue));
				
			else
				getglobal("Node5TimerFrame"):Hide();
				
			end
			Node5OldClockTime = CurrentTime;

		end

		ABHCounter = 0;
	end
end


--LOCALIZED
function ABHelper_SlashHandler(cmd)
	
	local args = {};
	local counter = 0;
	local i, w;
	local status;
	local TmpStr = {};
	TmpStr = "";

	for w in string.gmatch(cmd, "%w+") do
		counter = counter + 1;
		args[counter] = w;
	end

	if (args[1] == "show" and args[2] == nil) then
		ABH_ShowHelper();
	elseif (args[1] == "hide" and args[2] == nil) then
		ABHelperFrame:Hide();
	elseif (args[1] == "reset" ) then
		ABH_ResetPosition();
	elseif (args[1] == "options" ) then
		ABHelperOptionsFrame:Show();
	else
		ABHelper_Help();
	end
end


function ABHPopupButtonClick(num)
	ABH_Raid_Warning(ABH_PopupTitle:GetText(), num);
	ABHPickNumberPopup:Hide();
end


function ABH_Show_PopUp()

	if (ABHPickNumberPopup:IsVisible()) then
		ABHPickNumberPopup:Hide();
	else
		
		 ABHPickNumberPopup:Show();
	end
end


function ABH_Show_UserStatementPopUp()
	
	if (ABHUserStatementPopup:IsVisible()) then
		ABHUserStatementPopup:Hide();
	else
		
		 ABHUserStatementPopup:Show();
	end
end


--****************************************************************
-- ABHButtonOnClick
--
-- Purpose: event handler for the node buttons. Called when node
--          button clicked.
--****************************************************************
function ABHButtonOnClick( num )
	local button;
	local x;
	local y;

		

	if( ABH_BGName == TRANSLATION_ARATHIBASIN) then
 		if( num == 1) then
			button = TRANSLATION_FARM;
		elseif( num == 2) then
			button = TRANSLATION_LUMBERMILL;
		elseif( num == 3) then
			button = TRANSLATION_BLACKSMITH;
		elseif( num == 4) then
			button = TRANSLATION_GOLDMINE;
		elseif( num == 5) then
			button = TRANSLATION_STABLES;
		end

		--DEFAULT_CHAT_FRAME:AddMessage("DEBUGG");
	elseif( ABH_BGName == TRANSLATION_EYEOFSTORM ) then
		if( num == 1) then
			button = TRANSLATION_TOWER1;
		elseif( num == 2) then
			button = TRANSLATION_TOWER2;
		elseif( num == 3) then
			button = TRANSLATION_TOWER3;
		elseif( num == 4) then
			button = TRANSLATION_TOWER4;
		elseif( num == 5) then
			button = TRANSLATION_CENTER;
		end

		--DEFAULT_CHAT_FRAME:AddMessage("DEBUGD");
	else
		if( num == 1) then
			button = TRANSLATION_FARM;
		elseif( num == 2) then
			button = TRANSLATION_LUMBERMILL;
		elseif( num == 3) then
			button = TRANSLATION_BLACKSMITH;
		elseif( num == 4) then
			button = TRANSLATION_GOLDMINE;
		elseif( num == 5) then
			button = TRANSLATION_STABLES;
		end
		--DEFAULT_CHAT_FRAME:AddMessage("DEBUGH");
	end
	
	
	
	if ( IsShiftKeyDown() ) then
		ABH_Popup_Counter = 0;
		ABHUserStatementPopup:Hide();

		if (ABH_PopupTitle:GetText() ~= button) then
			ABH_PopupTitle:SetText(button);
			ABHPickNumberPopup:Show();
		else
			ABH_Show_PopUp();
		end

		if( ABHelperOptions["UserMsgMode"] == 0 ) then
			x = 136;
			y = -100;
		else
			x = -90;
			y = 100;
		end

		if (button == TRANSLATION_FARM or button == TRANSLATION_TOWER1) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHPickNumberPopup:SetPoint("TOPLEFT", 44, y);
			else
				ABHPickNumberPopup:SetPoint("TOPLEFT", x, -50);
			end
		elseif (button == TRANSLATION_LUMBERMILL or button == TRANSLATION_TOWER2) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHPickNumberPopup:SetPoint("TOPLEFT", 164, y);
			else
				ABHPickNumberPopup:SetPoint("TOPLEFT", x, -84);
			end
		elseif (button == TRANSLATION_BLACKSMITH or button == TRANSLATION_TOWER3) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHPickNumberPopup:SetPoint("TOPLEFT", 284, y);
			else
				ABHPickNumberPopup:SetPoint("TOPLEFT", x, -118);
			end
		elseif (button == TRANSLATION_GOLDMINE or button == TRANSLATION_TOWER4) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHPickNumberPopup:SetPoint("TOPLEFT", 404, y);
			else
				ABHPickNumberPopup:SetPoint("TOPLEFT", x, -150);
			end
		elseif (button == TRANSLATION_STABLES or button == TRANSLATION_CENTER) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHPickNumberPopup:SetPoint("TOPLEFT", 524, y);
			else
				ABHPickNumberPopup:SetPoint("TOPLEFT", x, -180);
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUGA");
		end

--DEBUG1
	elseif ( IsControlKeyDown() ) then
		ABH_UserStatementPopup_Counter = 0;
		ABHPickNumberPopup:Hide();
		ABH_Populate_UserStatements(button);

		if( ABHelperOptions["UserMsgMode"] == 0 ) then
			x = 136;
			y = -100;
		else
			x = -130;
			y = 180;
		end

		if (ABH_UserStatementPopupTitle:GetText() ~= button) then
			ABH_UserStatementPopupTitle:SetText(button);
			ABHUserStatementPopup:Show();
		else
			ABH_Show_UserStatementPopUp();
		end

		if (button == TRANSLATION_FARM or button == TRANSLATION_TOWER1) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHUserStatementPopup:SetPoint("TOPLEFT", 24, y);
			else
				ABHUserStatementPopup:SetPoint("TOPLEFT", x, -50);
			end
		elseif (button == TRANSLATION_LUMBERMILL or button == TRANSLATION_TOWER2) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHUserStatementPopup:SetPoint("TOPLEFT", 144, y);
			else
				ABHUserStatementPopup:SetPoint("TOPLEFT", x, -84);
			end
		elseif (button == TRANSLATION_BLACKSMITH or button == TRANSLATION_TOWER3) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHUserStatementPopup:SetPoint("TOPLEFT", 264, y);
			else
				ABHUserStatementPopup:SetPoint("TOPLEFT", x, -118);
			end
		elseif (button == TRANSLATION_GOLDMINE or button == TRANSLATION_TOWER4) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHUserStatementPopup:SetPoint("TOPLEFT", 384, y);
			else
				ABHUserStatementPopup:SetPoint("TOPLEFT", x, -150);
			end
		elseif (button == TRANSLATION_STABLES or button == TRANSLATION_CENTER) then
			if (ABHelperOptions["Mode"] == 1) then
				ABHUserStatementPopup:SetPoint("TOPLEFT", 504, y);
			else
				ABHUserStatementPopup:SetPoint("TOPLEFT", x, -180);
			end
		else
			DEFAULT_CHAT_FRAME:AddMessage("DEBUGB");
		end

	else
		ABH_Raid_Warning(button);
	end
end


function ABH_ShowTimers1(val)

	if( val == 0 ) then
		Node1TimerFrame:Hide();
		Node2TimerFrame:Hide();
		Node3TimerFrame:Hide();
		Node4TimerFrame:Hide();
		Node5TimerFrame:Hide();
	else
		Node1TimerFrame:Show();
		Node2TimerFrame:Show();
		Node3TimerFrame:Show();
		Node4TimerFrame:Show();
		Node5TimerFrame:Show();
	end

end


function ABH_SetTimerMode(mode)

	--ABH_ShowTimers1(1);
	--ABH_ShowTimers2(1);

	if( ABHelperOptions["Mode"] == 0) then

		if( mode == 0 ) then
		
			ABHelperOptions["TimerMode"] = 0;
			getglobal("Node1TimerFrame"):SetPoint("RIGHT", ABHButton1, "RIGHT", 70, 0);
			getglobal("Node2TimerFrame"):SetPoint("RIGHT", ABHButton2, "RIGHT", 70, 0);
			getglobal("Node3TimerFrame"):SetPoint("RIGHT", ABHButton3, "RIGHT", 70, 0);
			getglobal("Node4TimerFrame"):SetPoint("RIGHT", ABHButton4, "RIGHT", 70, 0);
			getglobal("Node5TimerFrame"):SetPoint("RIGHT", ABHButton5, "RIGHT", 70, 0);

		else
		
			ABHelperOptions["TimerMode"] = 1;
			getglobal("Node1TimerFrame"):SetPoint("RIGHT", ABHButton1, "RIGHT", -130, 0);
			getglobal("Node2TimerFrame"):SetPoint("RIGHT", ABHButton2, "RIGHT", -130, 0);
			getglobal("Node3TimerFrame"):SetPoint("RIGHT", ABHButton3, "RIGHT", -130, 0);
			getglobal("Node4TimerFrame"):SetPoint("RIGHT", ABHButton4, "RIGHT", -130, 0);
			getglobal("Node5TimerFrame"):SetPoint("RIGHT", ABHButton5, "RIGHT", -130, 0);

		end
	else
		if( mode == 0 ) then
		
			ABHelperOptions["TimerMode"] = 0;
			getglobal("Node1TimerFrame"):SetPoint("RIGHT", ABHButton1, "TOP", 32, -60);
			getglobal("Node2TimerFrame"):SetPoint("RIGHT", ABHButton2, "TOP", 32, -60);
			getglobal("Node3TimerFrame"):SetPoint("RIGHT", ABHButton3, "TOP", 32, -60);
			getglobal("Node4TimerFrame"):SetPoint("RIGHT", ABHButton4, "TOP", 32, -60);
			getglobal("Node5TimerFrame"):SetPoint("RIGHT", ABHButton5, "TOP", 32, -60);

		else
		
			
			ABHelperOptions["TimerMode"] = 1;
			getglobal("Node1TimerFrame"):SetPoint("RIGHT", ABHButton1, "TOP", 32, 30);
			getglobal("Node2TimerFrame"):SetPoint("RIGHT", ABHButton2, "TOP", 32, 30);
			getglobal("Node3TimerFrame"):SetPoint("RIGHT", ABHButton3, "TOP", 32, 30);
			getglobal("Node4TimerFrame"):SetPoint("RIGHT", ABHButton4, "TOP", 32, 30);
			getglobal("Node5TimerFrame"):SetPoint("RIGHT", ABHButton5, "TOP", 32, 30);

		end
	
	end
	
end

--[[
function ABH_SetUserMsgMode( mode )
	if( ABHelperOptions["Mode"] == 0) then

		if( mode == 0 ) then
			ABHelperOptions["UserMsgMode"] = 0;
			ABHUserStatementPopup:SetPoint("TOPLEFT", 136, -180);
		else
			ABHelperOptions["UserMsgMode"] = 1;
			ABHUserStatementPopup:SetPoint("TOPLEFT", 136, -180);
		end
	else
		if( mode == 0 ) then
			ABHelperOptions["UserMsgMode"] = 0;
			ABHUserStatementPopup:SetPoint("TOPLEFT", 504, -100);
		else
			ABHelperOptions["UserMsgMode"] = 1;
			ABHUserStatementPopup:SetPoint("TOPLEFT", 504, -100);
		end
	
	end

end
]]


function ABH_Change_Mode( mode )

	if( mode == 0 ) then
		--ABHelperFrame:ClearAllPoints();
		ABHelperFrame:SetWidth(140);
		ABHelperFrame:SetHeight(192);

		ABH_Title:SetText("Arathi Basin Helper");

		getglobal("ABHBack1"):SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 0, 0);
		ABHBack1:SetWidth(140);
		ABHBack1:SetHeight(128);
		ABHBack1:SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABBackTop");
		ABHBack1:SetTexCoord(0, 1, 0, 1);

		getglobal("ABHBack2"):SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 0, -128);
		ABHBack2:SetWidth(140);
		ABHBack2:SetHeight(64);
		ABHBack2:SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABBackBottom");
		ABHBack2:SetTexCoord(0, 1, 0, 1);		

		ABHBack3:SetTexture("");

		IconFrame1:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -20);
		IconFrame2:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -52);
		IconFrame3:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -84);
		IconFrame4:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -116);
		IconFrame5:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -148);

		Node1Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -28);
		Node2Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -60);
		Node3Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -92);
		Node4Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -124);
		Node5Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -156);

		ABHelperCloseButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -18, 20);
		ABHelperHideButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -58, 20);
		ABHelperHelpButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -38, 20);

		getglobal("ABHButton1Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton2Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton3Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton4Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton5Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");

		ABHButton1:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -13, -20);
		ABHButton2:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -13, -52);
		ABHButton3:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -13, -85);
		ABHButton4:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -13, -117);
		ABHButton5:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -13, -149);
	else
		--ABHelperFrame:ClearAllPoints();
		ABHelperFrame:SetWidth(600);
		ABHelperFrame:SetHeight(64);

		ABH_Title:SetText("");

		ABHBack1:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", -10, -4);
		ABHBack1:SetWidth(64);
		ABHBack1:SetHeight(64);
		ABHBack1:SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzLeft");
		ABHBack1:SetTexCoord(0, 0.585, 0, 1);

		getglobal("ABHBack2"):SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 54, -4);
		ABHBack2:SetWidth(512);
		ABHBack2:SetHeight(64);
		ABHBack2:SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzMiddle");
		ABHBack2:SetTexCoord(0, 1, 0, 1);

		ABHBack3:SetTexture("Interface\\AddOns\\ABHelper\\Images\\ABHorzRight");

		IconFrame1:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 12, -20);
		IconFrame2:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 132, -20);
		IconFrame3:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 252, -20);
		IconFrame4:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 372, -20);
		IconFrame5:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 492, -20);

		Node1Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 20, -28);
		Node2Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 140, -28);
		Node3Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 260, -28);
		Node4Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 380, -28);
		Node5Icon:SetPoint("TOPLEFT", ABHelperFrame, "TOPLEFT", 500, -28);

		ABHelperCloseButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -478, 20);
		ABHelperHelpButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -498, 20);
		ABHelperHideButton:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -518, 20);

		getglobal("ABHButton1Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton2Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton3Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton4Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");
		getglobal("ABHButton5Texture"):SetTexture("Interface\\AddOns\\ABHelper\\Images\\Button2");

		ABHButton1:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -471, -20);
		ABHButton2:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -351, -20);
		ABHButton3:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -231, -20);
		ABHButton4:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", -111, -20);
		ABHButton5:SetPoint("TOPRIGHT", ABHelperFrame, "TOPRIGHT", 9, -20);
	end


	ABHelper_Hide( ABHelperOptions["LowProfile"] );
	ABH_SetTimerMode( ABHelperOptions["TimerMode"] );
	
end

