FourTwentyCompass = {
	TWOPI = 6.283185307179586476925286766559;
	
	_updateInterval = 0.01;
	_lastUpdate = 0;
	_lastDir = -1;
	_minimapArrow = nil;

	
};
_420_compass_saved_options = {};

function FourTwentyCompass:onLoad()

	self._minimapArrow = self:getMiniMapArrow();
	

	SlashCmdList["420COMPASS"] = self.runSlashCommand;
	SLASH_420COMPASS1 = "/420compass";
	self:runSlashCommand("reset");
	
	self.compassTexture = _420_compass_Texture;
	self.border = _420_compass_Texture;
	self.compassBorder = _420_compass_BorderFrame;
	self.compassLocation = _420_compass_LocationFrame;
	
	this:RegisterEvent("VARIABLES_LOADED");
end



function FourTwentyCompass:chatPrint(msg)
	if (DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage(msg, 0.25, 0.55, 1.0);
	end
end

function FourTwentyCompass:GetCmd(msg)
 	if msg then
 		local a,b,c=strfind(msg, "(%S+)");
 		if a then
 			return c, strsub(msg, b+2);
 		else	
 			return "";
 		end
 	end
 end

function FourTwentyCompass:runSlashCommand(args)
	local Cmd, SubCmd = FourTwentyCompass:GetCmd(args);
	--FourTwentyCompass:chatPrint("args: " .. args);
	if(Cmd == "hide")then
		this:Hide();
		_420_compass_saved_options['hidden'] = true;
	elseif (Cmd == "show")then 
		this:Show();
		_420_compass_saved_options['hidden'] = false;
	elseif (Cmd == "hideborder")then
		_420_compass_BorderFrame:Hide();
		_420_compass_saved_options['borderhidden'] = true;
	elseif (Cmd == "showborder")then
		_420_compass_BorderFrame:Show();
		_420_compass_saved_options['borderhidden'] = false;
	elseif(Cmd == "scale")then
		this:SetScale(SubCmd);
		this:ClearAllPoints();
		this:SetPoint("TOP", 0, -30);
		_420_compass_saved_options['scale'] = SubCmd;
	elseif(Cmd == "hideloc")then
		_420_compass_LocationFrame:Hide();
		_420_compass_saved_options['lochidden'] = true;
	elseif(Cmd == "showloc")then
		_420_compass_LocationFrame:Show();
		_420_compass_saved_options['lochidden'] = false;
	elseif(Cmd == "reset")then
		self:runSlashCommand("scale 1");
		self:runSlashCommand("showborder");
		self:runSlashCommand("showloc");
		self:runSlashCommand("show");
	else
		FourTwentyCompass:chatPrint("420compass - Help");
		FourTwentyCompass:chatPrint("/420compass show - Shows the compass");
		FourTwentyCompass:chatPrint("/420compass hide - Hides the compass");
		FourTwentyCompass:chatPrint("/420compass showborder - Shows the border");
		FourTwentyCompass:chatPrint("/420compass hideborder - Hides the border");
		FourTwentyCompass:chatPrint("/420compass showloc - Shows the location indecator");
		FourTwentyCompass:chatPrint("/420compass hideloc - Hides the location indecator");
		FourTwentyCompass:chatPrint("/420compass reset - resets 420compass to the default settings");
	end
end

function FourTwentyCompass:getMiniMapArrow()
	local arrow = nil;
	local kids = { Minimap:GetChildren() };
	
	for _,child in ipairs(kids) do
		--self:chatPrint("kid: " .. child:GetModel());
		if(child:GetFrameType() == "Model") then
			if(child:GetModel() == "interface\\minimap\\minimaparrow.m2") then 
				arrow = child;
			end
		end
	end
	return arrow;
end

function FourTwentyCompass:getDirection()
	return self._minimapArrow:GetFacing() / self.TWOPI * 360;
end


function FourTwentyCompass:drawTexture(degrees)
	local dir = self:getDirection();
	if(dir ~= self._lastDir) then
		local dirFactor = (dir / 720);
		local sliceFactor = degrees / 720;
		if(dir < 180)then
			self.compassTexture:SetTexCoord(0.5 - dirFactor - sliceFactor , 0.5 - dirFactor + sliceFactor ,0,1);
		else
			self.compassTexture:SetTexCoord(1.0 - dirFactor - sliceFactor, 1.0 - dirFactor + sliceFactor,0,1);
		end
			local posX, posY = GetPlayerMapPosition("player");
			if(posX == 0 and posY == 0) then
				self.compassLocation:Hide();
			else
				self.compassLocation:Show();
				_420_compass_LocationXString:SetText(math.floor(posX * 100));
				_420_compass_LocationYString:SetText(math.floor(posY * 100));
				_420_compass_LocationXString:SetAlpha(0.42);
				_420_compass_LocationYString:SetAlpha(0.42);
			end
	end
end


function FourTwentyCompass:onUpdate(elapsed)
	if(self._minimapArrow ~= nil and _420_compass_saved_options['hidden'] == false) then
		self._lastUpdate = self._lastUpdate + elapsed; 	
  		if (self._lastUpdate  > self._updateInterval) then
			self:drawTexture(140);
			self._lastUpdate  = 0;
  		end
	end
end	


