#! /usr/bin/env python
# -*- coding: utf-8 -*-
#Playlist.Creator.v0.14
import codecs
import re, os, sys, math, locale,time
import MP3Info
import id3reader
###########################################################
# Change the following options to customize this playlist
# generator for your addon
addonName = 'SimpleMp3'
mp3Dir = 'Mp3'
useFullPath = 'false'
removeExtension = 'true'
listFileName = mp3Dir + '\\' + 'SimpleMp3Library.lua'
listType = 'Library' #Library or PlayList(or Playlist)
playlistType = 'array' # 'array' 'numArray' or 'dictionary'
tagsUsed = 'length, title, artist, album, genre, bitrate'
lengthName = 'Length'
titleName = 'Title'
artistName = 'Artist'
albumName = 'Album'
genreName = 'Genre'
nameName = 'Name'
bitrateName = 'BitRate'
# available tags are:
# length, title, artist, album, genre, bitrate
askPauseOnError = 'true'
###########################################################
musicPath = os.path.dirname(sys.argv[0]) + '\\' + mp3Dir
pathToMp3s = 'Interface\\Addons\\' + addonName + '\\' + mp3Dir + '\\'
pauseOnError = 'false'
pauseOnUnicode = 'true'
found = 0
tagError = 0
lengthError = 0
bitrateError = 0
unicodeError = 0
filePathError = 0
corruptError = 0
windowsError5 = 0
windowsError = 0
tc = 0

def IsInt(str):
	"""Is the given string an integer?"""
	try:int(str)
	except ValueError:return 0
	else:return 1

def GetTrackInfo(filePath):
	
	global pauseOnError
	global pauseOnUnicode
	global found
	global tagError
	global lengthError
	global bitrateError
	global unicodeError
	global filePathError
	global corruptError
	global windowsError5
	global windowsError

	length = 0
	bitrate = 0
	title = ""
	artist = ""
	album = ""
	genre = ""
	_genres = [
	    # 0-19
	    'Blues', 'Classic Rock', 'Country', 'Dance', 'Disco', 'Funk', 'Grunge', 'Hip - Hop', 'Jazz', 'Metal',
	    'New Age', 'Oldies', 'Other', 'Pop', 'R&B', 'Rap', 'Reggae', 'Rock', 'Techno', 'Industrial',
	    # 20-39
	    'Alternative', 'Ska', 'Death Metal', 'Pranks', 'Soundtrack', 'Euro - Techno', 'Ambient', 'Trip - Hop', 'Vocal', 'Jazz + Funk',
	    'Fusion', 'Trance', 'Classical', 'Instrumental', 'Acid', 'House', 'Game', 'Sound Clip', 'Gospel', 'Noise',
	    # 40-59
	    'Alt Rock', 'Bass', 'Soul', 'Punk', 'Space', 'Meditative', 'Instrumental Pop', 'Instrumental Rock', 'Ethnic', 'Gothic',
	    'Darkwave', 'Techno - Industrial', 'Electronic', 'Pop - Folk', 'Eurodance', 'Dream', 'Southern Rock', 'Comedy', 'Cult', 'Gangsta Rap',
	    # 60-79
	    'Top 40', 'Christian Rap', 'Pop / Funk', 'Jungle', 'Native American', 'Cabaret', 'New Wave', 'Psychedelic', 'Rave', 'Showtunes',
	    'Trailer', 'Lo - Fi', 'Tribal', 'Acid Punk', 'Acid Jazz', 'Polka', 'Retro', 'Musical', 'Rock & Roll', 'Hard Rock',
	    # 80-99
	    'Folk', 'Folk / Rock', 'National Folk', 'Swing', 'Fast - Fusion', 'Bebob', 'Latin', 'Revival', 'Celtic', 'Bluegrass',
	    'Avantgarde', 'Gothic Rock', 'Progressive Rock', 'Psychedelic Rock', 'Symphonic Rock', 'Slow Rock', 'Big Band', 'Chorus', 'Easy Listening', 'Acoustic',
	    # 100-119
	    'Humour', 'Speech', 'Chanson', 'Opera', 'Chamber Music', 'Sonata', 'Symphony', 'Booty Bass', 'Primus', 'Porn Groove',
	    'Satire', 'Slow Jam', 'Club', 'Tango', 'Samba', 'Folklore', 'Ballad', 'Power Ballad', 'Rhythmic Soul', 'Freestyle',
	    # 120-139
	    'Duet', 'Punk Rock', 'Drum Solo', 'A Cappella', 'Euro - House', 'Dance Hall', 'Goa', 'Drum & Bass', 'Club - House', 'Hardcore',
	    'Terror', 'Indie', 'BritPop', 'Negerpunk', 'Polsk Punk', 'Beat', 'Christian Gangsta Rap', 'Heavy Metal', 'Black Metal', 'Crossover',
	    # 140-147
	    'Contemporary Christian', 'Christian Rock', 'Merengue', 'Salsa', 'Thrash Metal', 'Anime', 'JPop', 'Synthpop'
	    ]
	
	# Construct a reader from a file or filename.
	id3r = id3reader.Reader(filePath)
	try:
		op = 'retrieving length';
		f = codecs.open(filePath, 'rb')
		i = MP3Info.MP3Info(f)
		length = i.mpeg.length
		op = 'retrieving bitrate';
		bitrate = i.mpeg.bitrate
		f.close()
		op = 'retrieving title';
		title = id3r.getValue(u'title')
		op = 'retrieving artist';
		artist = id3r.getValue(u'performer')
		op = 'retrieving album';
		album = id3r.getValue(u'album')
		op = 'retrieving genre';
		try:
			genre = id3r.getValue(u'genre').replace('(','').replace(')','')
		except:
			genre = "None"
		genreTemp = "";
		for character in genre:
			if (IsInt(character)):
				genreTemp = genreTemp + character
		if (genreTemp != ""):
			genre = genreTemp
		if (IsInt(genre)):
		    try:
			genre = _genres[int(genre)]
		    except IndexError:
			genre = "None"
			
	
	except UnicodeEncodeError:
		unicodeError = unicodeError + 1
		try:
			if pauseOnUnicode == 'true':
				print "Error with Unicode in %s while %s" % (filePath, op);
				raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			if pauseOnUnicode == 'true':
				print " unprintable filename";
				raw_input("Press ENTER to continue...")
	except:
		try:
			if op == 'retrieving length':
				lengthError = lengthError + 1
				if pauseOnError == 'true':
					print "Unhandled Exception in %s while %s" % (filePath, op);
					raw_input("Press ENTER to continue...")
			if op == 'retrieving bitrate':
				bitrateError = bitrateError + 1
				if pauseOnError == 'true':
					print "Unhandled Exception in %s while %s" % (filePath, op);
					raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			unicodeError = unicodeError + 1
			if pauseOnError == 'true':
				print " unprintable filename";
				raw_input("Press ENTER to continue...")

	return length, title, artist, album, genre, bitrate

def WriteLibraryFolder(f, curPath, rootPath):
	trackCount = 0;
        global pauseOnError
        global pauseOnUnicode
	global found
	global tagError
	global lengthError
	global bitrateError
	global unicodeError
	global filePathError
	global corruptError
	global windowsError5
	global windowsError
	global tc

	dirs = []
	try:
		os.chdir(curPath)
		op = 'reading directory';
		for fileName in os.listdir(u'.'):
			op = 'reading fullname';
			fullName = os.path.normpath(os.path.join(curPath, fileName))
			fullName = fullName.replace('\\', '/')

			if os.path.isdir(fullName):
				dirs.append(fullName)

			else:
				if fullName.lower().endswith('.mp3'):
					found = found + 1
					# Strip the root and the extension
					shortName = fullName.replace(rootPath + '/', '')
					if removeExtension == 'true':
						shortName = shortName.replace('.mp3', '')
						shortName = shortName.replace('.Mp3', '')
						shortName = shortName.replace('.mP3', '')
						shortName = shortName.replace('.MP3', '')
					shortName = shortName.replace('/', '\\')
					shortName = clean(shortName)

					# Fetch the length of the track in seconds.
					op = 'retrieving tags';
					length, title, artist, album, genre, bitrate = GetTrackInfo(fullName)

					# Replace unicode and quotes
					if (title):
						title = clean(title)
					if (artist):
						artist = clean(artist)
					if (album):
						album = clean(album)
					if (genre):
						genre = clean(genre) 

					if length > 0:
						try:
							print 'Found %s (%s secs)' % (shortName, length)
							if useFullPath == 'true':
								shortName = pathToMp3s.replace('\\', '\\\\') + shortName
							op = 'adding to playlist'
							if playlistType == 'array':
								f.write('	{\n')
								f.write('		["%s"] = "%s",\n' % (albumName, album));
								f.write('		["%s"] = "%s",\n' % (nameName, shortName));
								f.write('		["%s"] = "%s",\n' % (genreName, genre));
								f.write('		["%s"] = %d,\n' % (lengthName, length));
								f.write('		["%s"] = %d,\n' % (bitrateName, int(round(float(bitrate)))));
								f.write('		["%s"] = "%s",\n' % (artistName, artist));
								f.write('		["%s"] = "%s",\n' % (titleName, title));
								f.write('	}, -- [%s]\n' % (tc + 1));
							elif playlistType == 'numArray':
								f.write('	[%s] = {\n' % (tc + 1))
								f.write('		["%s"] = "%s",\n' % (albumName, album));
								f.write('		["%s"] = "%s",\n' % (nameName, shortName));
								f.write('		["%s"] = "%s",\n' % (genreName, genre));
								f.write('		["%s"] = %d,\n' % (lengthName, length));
								f.write('		["%s"] = %d,\n' % (bitrateName, int(round(float(bitrate)))));
								f.write('		["%s"] = "%s",\n' % (artistName, artist));
								f.write('		["%s"] = "%s",\n' % (titleName, title));
								f.write('	},\n');
							elif playlistType == 'dictionary':
								f.write('	[%s] = {\n' % shortName)
								f.write('		["%s"] = "%s",\n' % (albumName, album));
								f.write('		["%s"] = "%s",\n' % (genreName, genre));
								f.write('		["%s"] = %d,\n' % (lengthName, length));
								f.write('		["%s"] = %d,\n' % (bitrateName, int(round(float(bitrate)))));
								f.write('		["%s"] = "%s",\n' % (artistName, artist));
								f.write('		["%s"] = "%s",\n' % (titleName, title));
								f.write('	},\n');

							trackCount = trackCount + 1
							tc = tc + 1
						except UnicodeEncodeError:
							unicodeError = unicodeError + 1
							try:
								if pauseOnUnicode == 'true':
									print "Error with Unicode in %s (%s) while %s" % (fullName, shortName, op);
									raw_input("Press ENTER to continue...")
							except UnicodeEncodeError, (strerror):
								if pauseOnUnicode == 'true':
									print "unprintable filename while ", (op);
									print strerror;
									raw_input("Press ENTER to continue...")
						except IOError:
							if len(fullName) > 255:
								filePathError = filePathError + 1
								if pauseOnError == 'true':
									print "File error in %s (%s) while %s, The filepath is too long." % (fullName, shortName, op);
									raw_input("Press ENTER to continue...")
							else:
								corruptError = corruptError + 1
								if pauseOnError == 'true':
									print "Unknown Error in %s while %s" % (fullName, op);
									raw_input("Press ENTER to continue...")

						except UnicodeDecodeError:
							unicodeError = unicodeError + 1
							try:
								if pauseOnUnicode == 'true':
									print "Error with Unicode in %s (%s) while %s" % (fullName, shortName, op);
									raw_input("Press ENTER to continue...")
							except UnicodeEncodeError:
								if pauseOnUnicode == 'true':
									print "unprintable filename while ", (op);
									raw_input("Press ENTER to continue...")
	except UnicodeEncodeError:
		unicodeError = unicodeError + 1
		try:
			if pauseOnUnicode == 'true':
				print "Error with Unicode in %s while %s" % (curPath, op);
				raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			if pauseOnUnicode == 'true':
				print " unprintable directory name";
				raw_input("Press ENTER to continue...")
	except UnicodeDecodeError:
		unicodeError = unicodeError + 1
		try:
			if pauseOnUnicode == 'true':
				print "Error with Unicode in %s (%s) while %s" % (curPath, shortName, op);
				raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			if pauseOnUnicode == 'true':
				print "unprintable filename while ", (op);
				raw_input("Press ENTER to continue...")
	except IOError:
		if len(curPath) > 255:
			filePathError = filePathError + 1
			if pauseOnError == 'true':
				print "Directory error in %s while %s, The filepath is too long." % (curPath, op);
				raw_input("Press ENTER to continue...")
		else:
			corruptError = corruptError + 1
			if pauseOnError == 'true':
				print "Unknown Error in %s" % curPath;
				raw_input("Press ENTER to continue...")
	except WindowsError, (errno, strerror):
		if errno == 5:
			windowsError5 = windowsError5 + 1
			if pauseOnError == 'true':
				print curPath;
				print strerror;
				raw_input("Press ENTER to continue...")
		else:
			windowsError = windowsError + 1
			if pauseOnError == 'true':
				print errno
				print strerror;
				raw_input("Press ENTER to continue...")
			
			
	for dirName in dirs:
		trackCount = WriteLibraryFolder(f, dirName, rootPath) + trackCount
	
	return trackCount
def clean(x):
        global pauseOnError
        global pauseOnUnicode
	global unicodeError
	try:
		op = 'cleaning'
		x = x.replace('\\', '\\\\')
		x = x.replace('"', '\\"')
		x = x.replace("'", "\\'")
		x = x.replace(u'\xb4' , '\\195\\116')
		x = x.replace(u'\xda' , '\\195\\154')
		x = x.replace(u'\xf8' , '\\195\\184')
	except UnicodeEncodeError:
		try:
			if pauseOnUnicode == 'true':
				print "Error with Unicode in %s while %s" % (x, op);
				raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			if pauseOnUnicode == 'true':
				print "unprintable tag while ", (op);
				raw_input("Press ENTER to continue...")
	except UnicodeDecodeError:
		try:
			if pauseOnUnicode == 'true':
				print "Error with Unicode in %s while %s" % (x, op);
				raw_input("Press ENTER to continue...")
		except UnicodeEncodeError:
			if pauseOnUnicode == 'true':
				print "unprintable tag while ", (op);
				raw_input("Press ENTER to continue...")
	return x

def main(argv, stdout, environ):
	pathname = musicPath
	workingPath = os.path.abspath(pathname)	
	workingPath = workingPath.replace('\\', '/')
	
	mp3Path = workingPath
	scriptFilePath = listFileName.replace('\\', '/')
	global pauseOnError
	global pauseOnUnicode
	global found
	global tagError
	global lengthError
	global bitrateError
	global unicodeError
	global filePathError
	global corruptError
	global windowsError5
	global windowsError
	global tc

	if not os.path.isdir(mp3Path):
		print 'ERROR : Cannot find the Music folder'
		print addonName + ' needs to have your music under Interface/AddOns/' + addonName + '/' + mp3Dir
		raw_input("Press ENTER to continue...")

	trackCount = 0;
	if askPauseOnError == 'true':
		if raw_input("Pause on Unicode errors? (y/n)\n") == 'y':
			pauseOnUnicode = 'true'
		else:
			pauseOnUnicode = 'false'

		if raw_input("Pause on other errors? (y/n)\n") == 'y':
			pauseOnError = 'true'
		else:
			pauseOnError = 'false'

	f = codecs.open(scriptFilePath, "w", "utf-8")
	f.write('-- This file is automatically generated\n')
	f.write('-- Please do not edit it.\n')
	f.write(addonName + '_PL_VERSION = "')
	f.write(time.ctime())
	f.write('"\n')
	f.write(addonName + listType + ' = {\n')
    
	print 'Scanning ' + mp3Path

	trackCount = WriteLibraryFolder(f, mp3Path, mp3Path) + trackCount

	f.write('}\n')
	f.close()

	print ' '
	print 'Finished writing' + addonName + 'Library.lua.'
	print 'Found %s track(s).' % trackCount
	print 'The tracks should now be available within the Library!'
	print ' '
	if (found > trackCount):
		print 'Some interesting facts about your mp3s:'
		print '%i mp3s were found' % found
		if tagError > 0:
			print '%i of them had errors while retrieving tags' % tagError
		if lengthError > 0:
			print '%i of them had errors while retrieving length' % lengthError
		if bitrateError > 0:
			print '%i of them had errors while retrieving bitrate' % bitrateError
		if unicodeError > 0:
			print '%i of them had errors with Unicode characters' % unicodeError
		if filePathError > 0:
			print '%i of them had errors with the filepath length' % filePathError
		if corruptError > 0:
			print '%i of them may be corrupt in some way' % corruptError
		if windowsError5 > 0:
			print 'There were also %i errors from inaccessible directories' % windowsError5
		if windowsError > 0:
			print 'There were also %i other errors' % windowsError
		print ' '
	raw_input("Press ENTER to continue...")


if __name__ == "__main__":
  main(sys.argv, sys.stdout, os.environ)

