do return end --this module is complete but there's a bug in LibRockComm-1.0 that causes the theme send to fail 95% of the time

local module = RBM:NewPlugin("Theme Share", "LibRockComm-1.0")
local Core = RBM

local function Print(...)
	DEFAULT_CHAT_FRAME:AddMessage("|cff37FDFFRBM Theme Share: |r"..format(...))
end

local db
local pendingThemes
function module:OnInitialize()
	local currentSender = ""
	local currentTheme
	local delay
	local tempList
	local function PendingHidden()
		return not pendingThemes
	end
	self:SetOptionsTable{
		args = {
			SelectSender = {
				type = "string",
				name = "Send to:",
				desc = "The name of the person you wish to send the theme to, set this blank if you wish to send it to your entire group.",
				get = function()
					return currentSender == "" and "Entire Group" or currentSender
				end,
				set = function(sender)
					currentSender = sender == "Entire Group" and "" or sender
				end,
				validate = function(string)
					if string == "Entire Group" then
					elseif string:match("%d") then
						return false, "Player names cannot have numbers!"
					elseif string:match("%s") then
						return false, "Player names cannot have spaces!"
					end
					return true
				end,
				order = 10,
				usage = "Type the exact name of the person, or set it blank and press enter.",
			},
			SelectTheme = {
				type = "choice",
				name = "Select theme:",
				desc = "Select a theme to send, if you have no saved themes you will be unable to select a theme.",
				get = function()
					return currentTheme
				end,
				set = function(theme)
					currentTheme = theme
				end,
				disabled = function()
					local themes = Core:GetThemes()
					return not themes or not next(themes)
				end,
				order = 20,
				choices = function()
					local themes = Core:GetThemes()
					if themes then
						if not tempList then
							tempList = {}
						else
							for k in pairs(tempList) do
								tempList[k] = nil
							end
						end
						for name, theme in pairs(themes) do
							tempList[#tempList + 1] = name
						end
						return tempList
					end
					return "@list" --send a blank list if we have none
				end,
			},
			SendTheme = {
				type = "execute",
				name = "Send theme",
				desc = "Sends the theme using the settings selected above. There's a short delay after sending a theme before another can be sent. Even after the delay is finished if the other party has not received the theme be patient, it can take several minutes to send large themes.",
				func = function()
					self:SendTheme(currentTheme, currentSender ~= "" and currentSender or nil)
					delay = true
					self:ScheduleTimer(function() delay = nil _G.LibStub("AceConfigRegistry-3.0"):NotifyChange("RBM") end, 5)
				end,
				buttonText = function()
					if currentTheme then
						return ("Send %s to %s"):format(currentTheme, currentSender == "" and "the entire group" or currentSender)
					end
					return "(Theme not selected)"
				end,
				disabled = function()
					return delay or not currentTheme
				end,
				order = 30,
			},
			ApprovePendingThemes = {
				type = "multichoice",
				name = "Approve theme",
				desc = "Themes sent by other players waiting your approval, simply selecting a theme will approve it and add it to your theme list. Themes can then be applied to frames in Frame options => Frame name => Misc options.",
				get = function() end,
				set = function(themeName)
					local theme = pendingThemes[themeName]
					pendingThemes[themeName] = nil
					Core:AddTheme(themeName, theme)
					if not next(pendingThemes) then
						pendingThemes = nil
					end
				end,
				choices = function()
					if not tempList then
						tempList = {}
					else
						for k in pairs(tempList) do
							tempList[k] = nil
						end
					end
					for name in pairs(pendingThemes) do
						tempList[#tempList + 1] = name
					end
					return tempList
				end,
				hidden = PendingHidden,
				order = 40,
			},
			DeclinePendingThemes = {
				type = "multichoice",
				name = "Decline theme",
				desc = "Themes sent by other players waiting your approval, selecting a theme in this list will decline the theme and remove it.",
				get = function() end,
				set = function(themeName)
					pendingThemes[themeName] = nil
					if not next(pendingThemes) then
						pendingThemes = nil
					end
				end,
				choices = function()
					if not tempList then
						tempList = {}
					else
						for k in pairs(tempList) do
							tempList[k] = nil
						end
					end
					for name in pairs(pendingThemes) do
						tempList[#tempList + 1] = name
					end
					return tempList
				end,
				hidden = PendingHidden,
				order = 50,
			},
			PrintMessage = {
				type = "boolean",
				name = "Print message",
				desc = "Prints a message to your chat window when a new theme is received.",
				order = 60,
				set = function(value)
					db.PrintMessage = value
				end,
				get = function()
					return db.PrintMessage
				end,
			},
		},
	}

	self:SetDatabaseDefaults("profile", {
		PrintMessage = true,
	})
end

local first = true
function module:OnEnable()
	db = self.db.profile

	self:AddCommListener("RTS", "GROUP")
	self:AddCommListener("RTS", "WHISPER")

	if not first then
		return
	else
		first = false
	end
	self:AddMemoizations("Height", "Width", "Spacing")
	self:SetCommPrefix("RTS")
	self:SetDefaultCommPriority("BULK")
end

function module:OnCommReceive(_, _, sender, themeName, theme)
	if true or not Core:GetTheme(themeName) then
		if db.PrintMessage then
			Print("A theme named %q has been received from %s! Open RBM (/rbm) plugin options to Theme Share to accept or decline.", themeName, sender)
		end
		if not pendingThemes then
			pendingThemes = {}
		end
		pendingThemes[themeName] = theme
	end
end

function module:SendTheme(themeName, who)
	local theme = Core:GetTheme(themeName)
	if theme then
		if who then
			self:SendCommMessage("WHISPER", who, themeName, theme)
		else
			self:SendCommMessage("GROUP", themeName, theme)
		end
	end
end