local path = debugstack():match("^(.+)\\ThemePack.lua").."\\Statusbar\\"
LibStub("LibSharedMedia-3.0"):Register("statusbar", "Minimalist", path.."Minimalist.tga")

local module = RBM:NewPlugin("Theme Pack")

function module:OnEnable()
	if not RBM:GetTheme("BigWigs") then
		RBM:AddTheme("BigWigs", {
			BarBackdrop = {
				tile = false,
				bgFile = "Solid",
				edgeSize = 0,
				edgeFile = "None",
			},

			BarBackdropColor = {0.74, 0.078, 0.035, 0.179,},

			BarHeight = 18,
			BarWidth = 0.9,
			Spacing = 1,

			TimerAdjust = 15,
			TimerFont = "Arial Narrow",
			TimerJustifyH = "LEFT",
			TimerFontSize = 12,
			

			StatusBottomSpacing = 0,
			StatusLeftSpacing = 0,
			StatusTopSpacing = 0,
			StatusRightSpacing = 0,
			StatusTexture = "BantoBar",

			SparkHeight = 2.4,

			LabelAdjust = 45,
		})
	end
	if not RBM:GetTheme("Rounded") then
		RBM:AddTheme("Rounded", {
			BarBackdropColor = {
				[4] = 0,
			},

			StatusBottomSpacing = 4,
			StatusLeftSpacing = 4,
			StatusTopSpacing = 4,
			StatusRightSpacing = 4,
			StatusTexture = "Blizzard",

			LabelAdjust = 8,
			LabelFontSize = 11,

			TimerAdjust = -10,
			TimerFont = "Arial Narrow",
			TimerFontSize = 11,

			Spacing = 2,
			BarBackdrop = {
				bgFile = "Solid",
				edgeSize = 15,
				edgeFile = "Blizzard Tooltip",
			},
			BarBackdropBorderColor = {[4] = 0.550000011920929,},
		})
	end
	if not RBM:GetTheme("Minimalist") then
		RBM:AddTheme("Minimalist", {
			BarWidth = 0.9,
			BarHeight = 18,

			Spacing = 1,
			
			BarBackdropColor = {
				[3] = 0.2392156862745098,
				[4] = 0.3100000023841858,
			},


			BarBackdrop = {
				tile = false,
				bgFile = "Solid",
				edgeSize = 0,
				edgeFile = "None",
			},
			SparkColor = {[4] = 0.8199999928474426,},
			SparkHeight = 1.4,
			SparkWidth = 1.2,

			LabelAdjust = 3,
			TimerAdjust = -5,
			TimerFont = "Arial Narrow",
			TimerFontSize = 12,

			IconLocation = "RIGHT",

			StatusBottomSpacing = 1,
			StatusLeftSpacing = 1,
			StatusTopSpacing = 1,
			StatusRightSpacing = 1,
			StatusTexture = "Minimalist",
		})
	end
end