-- Credits goes to the BigWigs crew with their BossBlock Module
local module = RBM:NewPlugin("Spam Block")
local player = UnitName("player")

local L = module:GetTranslations()

module:RegisterTranslations("enUS", -- translation automatically generated
	"Boss emotes", true,
	"Group chat", true,
	"Raid warning", true,
	"Raid warning chat", true,
	"Suppresses boss emote messages.", true,
	"Suppresses raid or party messages from boss mods that appear in your chat.", true,
	"Suppresses raid warning messages from boss mods that appear in your chat.", true,
	"Suppresses raid warning messages from boss mods that appear near the center of the screen.", true,
	"Suppresses whisper messages from boss mods that appear in your chat.", true,
	"Whisper chat", true
)

module:RegisterTranslations("zhCN",
	"Boss emotes", "首领表情",
	"Group chat", "队伍",
	"Raid warning", "团队警告（屏幕）",
	"Raid warning chat", "团队警告（聊天窗口）",
	"Suppresses boss emote messages.", "屏蔽首领的表情。",
	"Suppresses raid or party messages from boss mods that appear in your chat.", "在小队和（或）团队频道中屏蔽首领模块发出的报警信息。",
	"Suppresses raid warning messages from boss mods that appear in your chat.", "在团队警告频道中屏蔽首领模块发出的报警信息。",
	"Suppresses raid warning messages from boss mods that appear near the center of the screen.", "屏蔽由首领模块发出的，显示在屏幕上中部的团队警告信息。",
	"Suppresses whisper messages from boss mods that appear in your chat.", "屏幕首领模块发出的密语信息。",
	"Whisper chat", "密语"
)

module:RegisterTranslations("zhTW",
	"Boss emotes", "首領表情",
	"Group chat", "隊伍",
	"Raid warning", "團隊警告（螢幕）",
	"Raid warning chat", "團隊警告（對話）",
	"Suppresses boss emote messages.", "隱藏首領的表情。",
	"Suppresses raid or party messages from boss mods that appear in your chat.", "在小隊和（或）團隊頻道中隱藏首領模組發出的報警資訊。",
	"Suppresses raid warning messages from boss mods that appear in your chat.", "在團隊警告頻道中隱藏首領模組發出的報警資訊。",
	"Suppresses raid warning messages from boss mods that appear near the center of the screen.", "隱藏由首領模組發出的，顯示在螢幕上中部的團隊警告資訊。",
	"Suppresses whisper messages from boss mods that appear in your chat.", "螢幕首領模組發出的密語資訊。",
	"Whisper chat", "密語"
)

module:RegisterTranslations("koKR",
	"Boss emotes", "보스 감정표현",
	"Group chat", "그룹 대화",
	"Raid warning", "공격대 경고",
	"Raid warning chat", "공격대 경고 대화",
	"Suppresses boss emote messages.", "보스 감정표현 메세지를 차단합니다.",
	"Suppresses raid or party messages from boss mods that appear in your chat.", "보스 모드에 의해 대화창에 나타나는 파티 또는 공격대 메세지를 차단합니다.",
	"Suppresses raid warning messages from boss mods that appear in your chat.", "보스 모드에 의해 대화창에 나타나는 공격대 경고 메세지를 차단합니다.",
	"Suppresses raid warning messages from boss mods that appear near the center of the screen.", "보스 모드에 의해 화면 중앙에 나타나는 공격대 경고 메세지를 차단합니다.",
	"Suppresses whisper messages from boss mods that appear in your chat.", "보스 모드에 의해 대화창에 나타나는 귓속말 메세지를 차단합니다.",
	"Whisper chat", "귓속말 대화"
)

local chat = {
	CHAT_MSG_WHISPER = "ChatWhisper",--#NO_LOCALIZE
	CHAT_MSG_RAID_WARNING = "ChatRaidWarn",--#NO_LOCALIZE
	CHAT_MSG_RAID_LEADER = "ChatGroup",--#NO_LOCALIZE
	CHAT_MSG_RAID = "ChatGroup",--#NO_LOCALIZE
	CHAT_MSG_PARTY = "ChatGroup",--#NO_LOCALIZE
}

local db
local SetHooks
function module:OnInitialize()
	local function IsHidden()
		return not db
	end
	local function GetOption(info)
		return db[info[#info]]
	end
	local function SetOption(info, value)
		db[info[#info]] = value
		SetHooks()
	end
	self:SetOptionsTable{
		get = GetOption,
		set = SetOption,
		args = {
			RaidWarning = {
				type = "toggle",
				name = L["Raid warning"],
				desc = L["Suppresses raid warning messages from boss mods that appear near the center of the screen."],
				order = 10,
				hidden = IsHidden,
			},
			BossEmote = {
				type = "toggle",
				name = L["Boss emotes"],
				desc = L["Suppresses boss emote messages."],
				order = 20,
				hidden = IsHidden,
			},
			ChatRaidWarn = {
				type = "toggle",
				name = L["Raid warning chat"],
				desc = L["Suppresses raid warning messages from boss mods that appear in your chat."],
				order = 30,
				hidden = IsHidden,
			},
			ChatGroup = {
				type = "toggle",
				name = L["Group chat"],
				desc = L["Suppresses raid or party messages from boss mods that appear in your chat."],
				order = 40,
				hidden = IsHidden,
			},
			ChatWhisper = {
				type = "toggle",
				name = L["Whisper chat"],
				desc = L["Suppresses whisper messages from boss mods that appear in your chat."],
				order = 50,
				hidden = IsHidden,
			},
		},
	}

	self.db:RegisterDefaults({ 
		profile = {
			BossEmote = true,
			RaidWarning = true,
			ChatRaidWarn = false,
			ChatGroup = false,
			ChatWhisper = false,
		}
	})
end

local HookBossEmote
do
	local orig_RaidNotice_AddMessage
	function HookBossEmote()
		if not orig_RaidNotice_AddMessage then
			local RaidBossEmoteFrame = RaidBossEmoteFrame
			orig_RaidNotice_AddMessage = RaidNotice_AddMessage
			function RaidNotice_AddMessage(frame, ...)
				if not db or not db.BossEmote or RaidBossEmoteFrame ~= frame then
					orig_RaidNotice_AddMessage(frame, ...)
				end
			end
		end
	end
end

local HookRaidWarning
do
	local orig_RaidWarningFrame_OnEvent
	function HookRaidWarning()
		if not orig_RaidWarningFrame_OnEvent then
			orig_RaidWarningFrame_OnEvent = RaidWarningFrame_OnEvent
			function RaidWarningFrame_OnEvent(frame, event, msg, ...)
				if not db or not db.RaidWarning or not msg or not msg:match("%*%*%*") then
					return orig_RaidWarningFrame_OnEvent(frame, event, msg, ...)
				end
			end
		end

	end
end

local HookChat
do
	local orig_ChatFrame_MessageEventHandler
	function HookChat()
		if not orig_ChatFrame_MessageEventHandler then
			orig_ChatFrame_MessageEventHandler = ChatFrame_MessageEventHandler
			function ChatFrame_MessageEventHandler(event, ...) --what a poorly written function Blizzard, you should be ashamed
				if not db or not chat[event] or not db[chat[event]] or not arg1:match("%*%*%*") then
					return orig_ChatFrame_MessageEventHandler(event, ...)
				end
			end
		end
	end
end

function module:OnEnable()
	db = self.db.profile
	SetHooks()
end

function module:OnDisable()
	db = nil
end


function SetHooks()
	if db.BossEmote then
		HookBossEmote()
	end
	if db.RaidWarning then
		HookRaidWarning()
	end
	if db.ChatRaidWarn or db.ChatGroup or db.ChatWhisper then
		HookChat()
	end
end