-- Author      : Apoco
-- Create Date : 5/1/2008 12:20:01 PM
-- Credits: Ammo, Rabbit, and the rest of the BigWigs Team.
-- I, Apoco, Author of RBM, do not take any credit for the gradient work.  
-- The gradient's code was copied from CandyBar-2.0 with permissions
-- This plugin exists and is fully supported by myself because RBM is not a boss mod.
-- While it does have the capability of running bossmods on its own, and yes I do write my own bossmods for RBM,
-- It is not DESIGNED to be a bossmod.
if not RBM or not BigWigs then return end

local module = RBM:NewPlugin("BigWigs")
AceLibrary("AceEvent-2.0"):embed(module)
local colorModule
local L = module:GetTranslations()
local modLst = {}
module:RegisterTranslations("enUS", -- translation automatically generated
	"Use BigWigs Colors", true
)

module:RegisterTranslations("zhCN",
	"Use BigWigs Colors", "使用BigWigs的颜色"
)

module:RegisterTranslations("koKR",
	"Use BigWigs Colors", "BigWigs 색상 사용"
)

function module:OnInitialize()
	self:SetDefaultEnabledState(false)
	self:RegisterToggles(L["Announce"], false,
						 L["Use BigWigs Colors"], false)
	self.BarsEnabled = false
end

function module:OnEnable()
	self:RegisterEvent("BigWigs_StartBar")
	self:RegisterEvent("BigWigs_StopBar")
	if self.BarsEnabled then
		BigWigs:ToggleModuleActive("Bars", false)
	end
	self:RegisterEvent("Ace2_AddonEnabled")
	self:RegisterEvent("Ace2_AddonDisabled")
	self:RegisterCategory("BigWigs", "BigWigs Bars", 0.2, 0.22, 1.0)
	if BigWigs:HasModule("Colors") then
		colorModule = BigWigs:GetModule("Colors")
	end
end

function module:Ace2_AddonEnabled(module)
	if BigWigs:HasModule(module.name) and module.name == "Bars" then
		self.BarsEnabled = true
		BigWigs:ToggleModuleActive(module.name, false)
	end
	if BigWigs:HasModule(module.name) and module.name == "Colors" then
		colorModule = BigWigs:GetModule("Colors")
	end
end


function module:Ace2_AddonDisabled(module)
	if modLst[module.title] then
		for label in pairs(modLst[module.title]) do
			self:CancelBar(label)
			modLst[module.title][label] = nil
		end
		modLst[module.title] = nil
	end
end

function module:OnDisable()
	for i in pairs(modLst) do
		modLst[i] = nil
	end
	self:UnregisterAllEvents()
	if BigWigs:HasModule("Bars") then
		BigWigs:ToggleModuleActive("Bars", true)
	end
end

function module:BigWigs_StartBar(module, name, time, icon, color, r, g, b, ...)
	if not name or not time then return end
	if not modLst[module.title] then
		modLst[module.title] = {}
	end
	if not modLst[module.title][name] then
		modLst[module.title][name] = name
	end
	
	local usebwfade
	if self:CheckToggle(L["Use BigWigs Colors"]) and colorModule and type(colorModule) == "table" and not color then
		usebwfade = true
	end
	if not color and usebwfade then
		--self:TimedBar(name, "BigWigs", time, icon or "@random", true, nil, colorModule:BarColor(time))
		self:LocalTimedBar(name, "BigWigs", time, icon, true, nil, colorModule:BarColor(time))
	elseif color then
		--self:TimedBar(name, "BigWigs", time, icon or "@random", true, nil, r, g, b)
		self:LocalTimedBar(name, "BigWigs", time, icon, true, nil, r, g, b)
	else
		--self:TimedBar(name, "BigWigs", time, icon or "@random", true)
		self:LocalTimedBar(name, "BigWigs", time, icon, true)
	end
end

function module:BigWigs_StopBar(module, name)
	if modLst[module.title] and modLst[module.title][name] then
		modLst[module.title][name] = nil
	end
	self:CancelBar(name)
end