local type = type
local pairs = pairs

setfenv(1, RBM.FunctionEnviroment)
local PluginClass = PluginClass
--#AUTODOC_NAMESPACE PluginClass

BaseClass:Embed(PluginClass)
local Super = BaseClass


local Core = Core

--[[=================================================================]]--
--[[==========================Bar Creation===========================]]--
--[[=================================================================]]--

--[[==========================Simple Local Creation===========================]]--

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	number - The time, in seconds, that the bar should run
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]number - The number of times the bar should repeat before canceling (default: 0)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the current player will see them
	*Timed bars are standard bars that continually count down from the initial time
]]
function PluginClass:LocalTimedBar(label, subCategory, time, icon, reverse, numRepeat, red, green, blue, ...)
	self:StartBar(false, label, self:GetName(), subCategory, time, icon, reverse, numRepeat, nil, red, green, blue, ...)
end

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the player will see them
	*Timeless bars are shown until canceled.
]]
function PluginClass:LocalTimelessBar(label, subCategory, icon, reverse, red, green, blue)
	self:StartBar(false, label, self:GetName(), subCategory, nil, icon, reverse, nil, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	integer - The maximum count of the bar
	[optional]integer - The initial count of the bar (default: 1)
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Local bars are never announced to the group, only the player will see them
	*Count bars count from some number to another number, for example a certain amount of adds killed in an encounter may be shown as 2/4
]]
function PluginClass:LocalCountBar(label, subCategory, maxCount, count, icon, reverse, red, green, blue)
	self:StartBar(false, label, self:GetName(), subCategory, nil, icon, reverse, maxCount, count, red, green, blue)
end

--[[=========================Simple Announced Creation===========================]]--
--These methods are announced to the raid if self:CheckToggle("Announce") is true

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	number - The time, in seconds, that the bar should run
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]number - The number of times the bar should repeat before canceling (default: 0)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Bars created through this method will be announced if self:CheckToggle("Announce") is true, local otherwise
	*Timed bars are standard bars that continually count down from the initial time
]]
function PluginClass:TimedBar(label, subCategory, time, icon, reverse, numRepeat, red, green, blue, ...)
	self:StartBar(nil, label, self:GetName(), subCategory, time, icon, reverse, numRepeat, nil, red, green, blue, ...)
end

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Bars created through this method will be announced if self:CheckToggle("Announce") is true, local otherwise
	*Timeless bars are shown until canceled.
]]
function PluginClass:TimelessBar(label, subCategory, icon, reverse, red, green, blue)
	self:StartBar(nil, label, self:GetName(), subCategory, nil, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	integer - The maximum count of the bar
	[optional]integer - The initial count of the bar (default: 1)
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Bars created through this method will be announced if self:CheckToggle("Announce") is true, local otherwise
	*Count bars count from some number to another number, for example a certain amount of adds killed in an encounter may be shown as 2/4
]]
function PluginClass:CountBar(label, subCategory, maxCount, count, icon, reverse, red, green, blue)
	self:StartBar(nil, label, self:GetName(), subCategory, nil, icon, reverse, maxCount, count, red, green, blue)
end

--[[=========================Advanced Announced Creation===========================]]--
--[[
Arguments:
	boolean|nil - If true the bar is announced, false the bar is local, nil the bar is checked agaisnt self:CheckToggle("Announce") to determine whether it's announced or not
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	number - The time, in seconds, that the bar should run
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]number - The number of times the bar should repeat before canceling (default: 0)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Advanced bar creation methods are ideal for user configurable announce options
	*Timed bars are standard bars that continually count down from the initial time
]]
function PluginClass:AdvancedTimedBar(check, label, subCategory, time, icon, reverse, numRepeat, red, green, blue)
	self:StartBar(check, label, self:GetName(), subCategory, time, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	boolean|nil - If true the bar is announced, false the bar is local, nil the bar is checked agaisnt self:CheckToggle("Announce") to determine whether it's announced or not
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Advanced bar creation methods are ideal for user configurable announce options
	*Timeless bars are shown until canceled.
]]
function PluginClass:AdvancedTimelessBar(check, label, subCategory, icon, reverse, red, green, blue)
	self:StartBar(check, label, self:GetName(), subCategory, nil, icon, reverse, numRepeat, nil, red, green, blue)
end

--[[
Arguments:
	boolean|nil - If true the bar is announced, false the bar is local, nil the bar is checked agaisnt self:CheckToggle("Announce") to determine whether it's announced or not
	string - The label of the bar
	string - The category the bar belongs to, should be registered with :RegisterCategory first
	integer - The maximum count of the bar
	[optional]integer - The initial count of the bar (default: 1)
	[optional]string - Path to the icon, or "@random" for a random icon (default: "@random")
	[optional]boolean - True if the bar should empty instead of fill (default: false)
	[optional]float[0,1] - The red value of the bar (default: category coloring)
	[optional]float[0,1] - The green value of the bar (default: category coloring)
	[optional]float[0,1] - The blue value of the bar (default: category coloring)
Notes:
	*The icon path can be either be the full path like: "Interface/Icons/Spell_Shadow_ShadowBolt" or just the icon name like: "Spell_Shadow_ShadowBolt"; use the latter when possible
	*Advanced bar creation methods are ideal for user configurable announce options
	*Count bars count from some number to another number, for example a certain amount of adds killed in an encounter may be shown as 2/4
]]
function PluginClass:AdvancedCountBar(check, label, subCategory, maxCount, count, icon, reverse, red, green, blue)
	self:StartBar(check, label, self:GetName(), subCategory, nil, icon, reverse, maxCount, count, red, green, blue)
end

--[[
Arguments:
	[optional]boolean - If true the plugin will be enabled by default, false the plugin is disabled by default (default: enabled)
Notes:
	*If the plugin should be disabled by default set this to true
	*If the plugin has been enabled or disabled by the player this setting is ignored
]]
function PluginClass:SetDefaultEnabledState(state)
	if state == true or state == false or state == nil then
		self._DefaultEnabledState = state
	end
end

--[[
Returns:
	*boolean|nil - If true or nil the plugin will be enabled by default, false the plugin is disabled by default
]]
function PluginClass:GetDefaultEnabledState()
	return self._DefaultEnabledState
end

--[[
	Notes:
		* Upgrades the profile of the plugin from using self.db.char to self.db.profile
		* Will be removed in the future
]]
function PluginClass:UpgradeProfiles()
	if self.db.sv.char then
		for i,v in pairs(self.db.char) do
			self.db.profile[i] = v
		end
		self.db.sv.char = nil
		Core:print("Upgraded database for "..self:GetName())
	end
end
--[[
Returns:
	*boolean - If true if the plugin is a boss mod, false if its a plugin
]]
function PluginClass:IsBossMod() return false end
do
	local descs = {}
	local mc = {}
	local colors = {}
	--[[
	Returns:
		*string|nil - The category description if available, nil if not
	Arguments:
		string - The name of the category to get a description about
	]]
	function PluginClass:GetCategoryDescription(category)
		local name = self:GetName()
		return descs[name] and descs[name][category]
	end
	--[[
	Returns:
		*table|nil - The default category color table if available, nil if not
	Arguments:
		string - The name of the category to get information about
	Notes:
		*The color table is in the format {[1] = red, [2] = green, [3] = blue,}
	]]
	function PluginClass:GetCategoryColors(category)
		local name = self:GetName()
		return colors[name] and colors[name][category]
	end
	--[[
	Returns:
		*table|nil - A table describing the categories belonging to this module if available, nil if not
	Notes:
		*The table is in the format {categoryName = true, anotherCategoryName = true}
	]]
	function PluginClass:GetCategories()
		return mc[self:GetName()]
	end
	--[[
	Arguments:
		string - A very short phrase or word that names the category (such as "Enemy Casts")
		[optional] string - A short description of the category
		[optional] float[0,1] - The red value of the bar (default: random)
		[optional] float[0,1] - The green value of the bar (default: random)
		[optional] float[0,1] - The blue value of the bar (default: random)
	Notes:
		*This method MUST be called during or after the call to :OnInitialize, call it before will cause an error
		*It's a good idea to give color values and a description for each category
	]]
	function PluginClass:RegisterCategory(category, desc, r, g, b)
		if not self:IsInitialized() then
			error("RegisterCategory must be called during or after OnInitialize. [%q]", self:GetName())
		elseif type(category) ~= "string" then
			error("Bad argument #2 'category' to `RegisterCategory' (string expected, got %s)", type(category))
		end
		local name = self:GetName()

		if not mc[name] then
			mc[name] = {}
		end

		mc[name][category] = true

		if desc then
			if not descs[name] then
				descs[name] = {}
			end
			descs[name][category] = desc
		end

		if not colors[name] then
			colors[name] = {}
		end
		r, g, b = r or random(), g or random(), b or random()
		if not colors[name][category] then
			colors[name][category] = {["r"] = r, ["g"] = g, ["b"] = b}
		end

		Core:UpdateModuleCategories()
	end
	--[[
	Arguments:
		string - The name of the frame to get filter information on
		string - The name of the category to get information about
	Returns:
		boolean|nil - True if it's filtered, false if not, nil if the frame is not filtering categories or category doesn't exist
	]]
	function PluginClass:IsCategoryFiltered(frameName, category)
		local frame = Core:GetBarFrame(frameName)
		if frame then
			local name = self:GetName()
			if mc[name] and mc[name][category] then
				local db = frame.db.profile
				if db.Categories then
					return db.CategoriesList.Modules[name][category]
				end
			end
		end
	end

	--[[
	Notes:
		*Sets a category to be filtered or unfiltered on a specific frame.
		*This should NEVER be set without the user's consent. That is, don't set this automatically to be (un)filtered because YOU prefer it that way.
		*This should be used to simplify setting up plugin categories:
		In that an option can be provided to automatically unfilter all categories belonging to a plugin without the user having to do so manually.
		*Note that if the frame is set to not filter by categories then this won't have an effect until that is changed.
	Arguments:
		string - The name of the frame to set filter information on
		string - The name of the category to set filter information on
		boolean - True if the category should be filtered, false otherwise.
	]]
	function PluginClass:SetCategoryFiltered(frameName, category, filtered)
		local frame = Core:GetBarFrame(frameName)
		if frame then
			local name = self:GetName()
			if mc[name] and mc[name][category] then
				frame.db.profile.CategoriesList.Modules[name][category] = not not filtered
			end
		end
	end
end

--[[
Returns:
	*table - A list of frames that are currently in use, and will be updated automatically
Notes:
	*The frames list is in the format {[1] = firstFrame, [2] = secondFrame, [3] = thirdFrame}
Arguments:
	string - The name of the frame to set filter information on
	string - The name of the category to set filter information on
	boolean - True if the category should be filtered, false otherwise.
Example:
	*--options table can make use of this providing a quick and easy filtering/unfiltering option
	*CategoryFilters = {
	*	type = "multichoice",
	*	name = L["Frames"],
	*	desc = L["A frame with a checkmark indicates that categories will be sent to that frame. If a frame has the 'Filter by category' option disabled then bars will always be sent to that frame."],
	*	get = "AreAllCategoriesUnfiltered",
	*	set = "ToggleAllCategoriesFiltered",
	*	choices = "GetFramesList",
	*}
]]
function PluginClass:GetFramesList()
	return Core:GetFramesList()
end

--[[
Returns:
	*boolean|string|nil - True if all categories are unfiltered, false if all categories are filtered or "HALF" if some are filtered and some not; nil if the module doesn't have categories
Arguments:
	string - The name of the frame to get filter information on
]]
function PluginClass:AreAllCategoriesUnfiltered(frameName, aceName)
	if aceName then frameName = aceName end
	local cats = self:GetCategories()
	if cats then
		local unfiltered = false
		for category in pairs(cats) do
			if self:IsCategoryFiltered(frameName, category) then
				if unfiltered then
					return "HALF"
				end
			else
				unfiltered = true
			end
		end
		return unfiltered
	end
end

--[[
Notes:
	*Toggles all categories, if categories are partially filtered and partially unfiltered then toggling will set them all to unfiltered
Arguments:
	string - The name of the frame to set filter information on
]]
function PluginClass:ToggleAllCategoriesFiltered(frameName)
	local cats = self:GetCategories()
	if cats then
		local filtered = self:AreAllCategoriesUnfiltered(frameName)
		for category in pairs(cats) do
			self:SetCategoryFiltered(frameName, category, filtered)
		end
	end
end