local rawget = rawget
local setmetatable = setmetatable
local currentLocale = GetLocale()
local select = select
local type = type
currentLocale = currentLocale == "enGB" and "enUS" or currentLocale
setfenv(1, RBM.FunctionEnviroment)

local locales = {}
local common = {}
local boss = {}

local TRANSLATE_MESSAGE
TRANSLATE_MESSAGE = "|cff37FDFCRBM_%s|r is not fully translated for %q, please help translate." --<name><locale>

if currentLocale == "koKR" then
	TRANSLATE_MESSAGE = "|cff37FDFCRBM_%s|r의 %q에 충분한 번역이 없을 수 있습니다. 빠진 번역의 도움을 부탁드립니다." --<name><locale>
end

--[[if currentLocale == "deDE" then
		TRANSLATE_MESSAGE = "de translation"
	end
]]
local TRANSLATE_MESSAGE_DEBUG = "%s:   :%s:"
local TRANSLATE_MESSAGE_DEBUG_BOSS = "BOSS: %s:   :%s:"


local localesMT = {
	__index = function(self, key)
		if not common[key] then
			self[key] = key
			if not rawget(self, "__Nagged") then
				Core:print(TRANSLATE_MESSAGE:format(self.__Name, currentLocale))
				self.__Nagged = true
			end
			if false then	-- code used by apoco for lazy enUS locales
				if not _G.RBM.db.profile.locales then _G.RBM.db.profile.locales = {} end
				if not _G.RBM.db.profile.locales[self.__Name] then
					_G.RBM.db.profile.locales[self.__Name] = {}
				end
				if not _G.RBM.db.profile.locales[self.__Name][key] then
					_G.table.insert(_G.RBM.db.profile.locales[self.__Name], key)
				end
			end
			if false then	-- if true will input what is not translated and what module it belongs to in Chatframe3 or ChatFrame2
				debug(TRANSLATE_MESSAGE_DEBUG:format(self.__Name, key))
			end
		else
			self[key] = common[key]
		end
		return self[key]
	end,
}
local localesBossMT = {
	__index = function(self, key)
		if not common[key] and not boss[key] then
			self[key] = key
			if not rawget(self, "__Nagged") then
				Core:print(TRANSLATE_MESSAGE:format(self.__Name, currentLocale))
				self.__Nagged = true
			end
			if true then
				debug(TRANSLATE_MESSAGE_DEBUG_BOSS:format(self.__Name, key))
			end
		else
			self[key] = boss[key]
		end
		return self[key]
	end,
}


function Core:GetTranslations(arg)
	if arg then
		if not locales[self] then
			locales[self] = setmetatable({__Name = self:GetName()}, localesBossMT)
		end
		return locales[self]
	else
		if not locales[self] then
			locales[self] = setmetatable({__Name = self:GetName()}, localesMT)
		end
		return locales[self]
	end
end

function Core:RegisterTranslations(locale, ...)
	if locale == currentLocale then
		local L = self:GetTranslations()
		for i=1, select("#", ...), 2 do
			local k, v = select(i, ...)
			if type(k) == "string" and (type(v) == "string" or v == true) then
				L[k] = v == true and k or v
			end
		end
	end
end

function Core:RegisterCommonTranslations(locale, ...)
	if locale == currentLocale then
		for i=1, select("#", ...), 2 do
			local k, v = select(i, ...)
			if type(k) == "string" and (type(v) == "string" or v == true) then
				common[k] = v == true and k or v
			end
		end
	end
end

function Core:RegisterBossTranslations(locale, ...)
	if locale == currentLocale then
		for i=1, select("#", ...), 2 do
			local k, v = select(i, ...)
			if type(k) == "string" and (type(v) == "string" or v == true) then
				boss[k] = v == true and k or v
			end
		end
	end
end


locales[Core] = setmetatable({__Name = "Core"}, localesMT)
L = locales[Core]