BINDING_HEADER_RBM = "RBM"
BINDING_NAME_RBM_FORCE_SHOW = "Force Show Frames"

--sets our function enviroment to a table in our addon object, this allows us to declare variables "globally" without polluting the global namespace
--instead they're created in our namespace

--this is especially useful to avoid awkward chain calls from the core, or for utility functions shared by several other non-related classes

--it forces global functions to be made into upvalues for a minor speed increase
--also helps catch globals that were supposed to be local
--however, in the end the difference is simply in readability which in turn depends on coding style

RBM = LibStub("AceAddon-3.0"):NewAddon("RBM", "AceEvent-3.0", "AceConsole-3.0", "AceTimer-3.0", "AceComm-3.0", "AceSerializer-3.0", "LibSink-2.0")

-- Silently fail embedding if it doesn't exist -- Idea from Omen
LibStub("AceAddon-3.0"):EmbedLibrary(RBM, "LibFuBarPlugin-Mod-3.0", true)

--The icons table caches all valid paths or randomly assigned paths for non-valid paths or the special "@random" key
local Icons
do
	local GetMacroIconInfo = GetMacroIconInfo
	local GetNumMacroIcons = GetNumMacroIcons
	local random = math.random
	local Texture
	Icons = setmetatable({}, {
		__index = function(self, key)
			if not key or key == "@random" then
				return GetMacroIconInfo(random(1, GetNumMacroIcons()))
			end
			if type(key) == "number" then
				key = GetSpellInfo(key) and select(3, GetSpellInfo(key)):match("Interface\\Icons\\(.+)") or GetItemInfo(key) and select(2, GetItemInfo(key)):match("Interface\\Icons\\(.+)") or GetMacroIconInfo(random(1, GetNumMacroIcons()))
			end
			if not Texture then
				Texture = CreateFrame("Frame"):CreateTexture()
			end
			if Texture:SetTexture(key) then
				self[key] = key
			elseif Texture:SetTexture([[Interface/Icons/]] .. key) then
				self[key] = [[Interface/Icons/]] .. key
			else
				self[key] = self[false]
			end
			return self[key]
		end,
	})
end

local debugfunc = function(...)
	local frame = ChatFrame3 or ChatFrame2
	if AceLibrary and AceLibrary:HasInstance("AceConsole-2.0") then
		AceLibrary("AceConsole-2.0"):CustomPrint(nil, nil, nil, frame, nil, true, ...)
	elseif Rock and Rock:HasLibrary("LibRockConsole-1.0") then
		Rock("LibRockConsole-1.0"):CustomPrint(nil, nil, nil, frame, nil, true, ...)
	else
		LibStub("AceConsole-3.0"):Print(frame, ...)
	end
end

debug = debug or UnitName("player") == "Apoco" and debugfunc or function() end


local select = select
RBM.FunctionEnviroment = {
	Core = RBM,
	CreateFrame = CreateFrame,
	_G = _G,
	Icons = Icons,
	error = function(a1, ...)
		if ... and type(a1) == "string" and a1:match("%%") then
			error(a1:format(...), 2)
		else
			error(a1, 2)
		end
	end,
	MediaHandler = LibStub("LibSharedMedia-3.0"),
	Noop = function() end,
	debug = debug,
}