--Credits: Ammo, Rabbit, and the rest of the BigWigs Team.
--I, Apoco, Author of RBM, do not take any credit for the gradient work.  
--The gradient's code was copied from CandyBar-2.0 with permissions
local unpack, random, format, next = unpack, math.random, string.format, next
local sort, insert, remove = table.sort, table.insert, table.remove
local floor, min, max = math.floor, math.min, math.max
local GetTime, pairs, ipairs, type, select, rawget = GetTime, pairs, ipairs, type, select, rawget
local GetMouseFocus = GetMouseFocus

local AceConfigDialog = LibStub("AceConfigDialog-3.0")

setfenv(1, RBM.FunctionEnviroment)
local L = L

local Core = Core
local OnUpdate

do
	local function OnMouseDown(self)
		local parent = self:GetParent()
		parent.IsMovingOrResizing = true
		parent:SetHeight(parent.db.profile.Height)

		parent:StartSizing("BOTTOMRIGHT")
	end
	local function OnMouseUp(self)
		local parent = self:GetParent()
		parent:StopMovingOrSizing()

		parent.IsMovingOrResizing = false

		local db = parent.db.profile

		db.Xoffset, db.Yoffset = parent:GetCenter()
		db.Height = parent:GetHeight()
		db.Width = parent:GetWidth()
		
		parent:RefreshFrameSettings()
	end
	local function OnLeave(self)
		self:Hide()
	end
	function FrameClass:New(name)
		if self ~= FrameClass then return end
		local frame = CreateFrame("Frame", nil, _G.UIParent)

		frame:SetMinResize(100, 80)
		frame:SetClampedToScreen(true)

		local drag = CreateFrame("Frame", nil, frame)
		drag:Hide()
		drag:SetHeight(16)
		drag:SetWidth(16)
		drag:EnableMouse(true)
		drag:SetPoint("BOTTOMRIGHT", frame, "BOTTOMRIGHT")

		drag:SetScript("OnMouseDown", OnMouseDown)
		drag:SetScript("OnMouseUp", OnMouseUp)
		drag:SetScript("OnLeave", OnLeave)

		frame.DragHandle = drag

		local title = frame:CreateFontString()
		title:SetFontObject("GameFontNormal")
		title:SetPoint("TOP", frame, "TOP", 0, 5)

		frame.Title = title

		
		
		local texture = drag:CreateTexture(nil, "BACKGROUND")
		texture:SetBlendMode("ADD")
		texture:SetAllPoints(drag)
		texture:SetTexture[[Interface\AddOns\RBM\Images\DragHandle]]

		self:Embed(frame)

		frame.BarList = {}
		frame.BarSortList = {}
		frame:Initialize(name)

		if _G.VisualThemes then
			_G.VisualThemes:RegisterFrames(L["RBM Frames"], 0, frame)
		end

		return frame
	end
end

function FrameClass:Destroy(saveSettings)
	self:ClearAllPoints()
	self:Hide()
	self:CancelAllBars()
	if not saveSettings then
		local dbName = "Frame"..self.Name
		local current = Core.db:GetCurrentProfile()
		--perhaps an easier way to remove a namespace is in order?
		_G.rawset(Core.db.children[dbName].profiles, current, nil)
		_G.rawset(Core.db.sv.namespaces[dbName].profiles, current, nil)
		_G.rawset(Core.db.children[dbName], "profile", nil)
	end
	self.db = nil
	self.Name = nil
	self:SetScript("OnMouseDown", nil)
	self:SetScript("OnMouseUp", nil)

	self:SetScript("OnUpdate", nil)

	self:SetScript("OnEnter", nil)
	self:SetScript("OnLeave", nil)
end

do
	local function OnMouseDown(self, button)
		if button == "LeftButton" and self:IsMovable() then
			self.IsMovingOrResizing = true
			self:SetHeight(self.db.profile.Height)
			self:StartMoving()
		end
	end
	local function OnMouseUp(self, button)
		if button == "LeftButton" then
			if self:IsMovable() then
				self:StopMovingOrSizing()
				self.IsMovingOrResizing = false

				self.db.profile.Xoffset, self.db.profile.Yoffset = self:GetCenter()

				self:RefreshFrameSettings()
			end
		elseif button == "RightButton" then
			self:OnRightClick()
		end
	end
	local function OnEnter(self)
		if not self.db.profile.Locked then
			self.DragHandle:Show()
		end
	end
	local function OnLeave(self)
		if GetMouseFocus() ~= self.DragHandle then
			self.DragHandle:Hide()
		end
	end
	function OnUpdate(self, delta)
		local now = GetTime()
		for label, bar in pairs(self.BarList) do
			if not bar.paused and bar.startTime then
				local remains = bar.endTime - now
				local continue = true
				if not bar.transferring then
					if bar.transferAboveAt and now < bar.transferAboveAt then
						local transferto
						if self.db.profile.TransferAboveTo == "parent" then
							transferto = bar.parentFrame or ""
						else
							transferto = self.db.profile.TransferAboveTo
						end
						self:StartBarTransfer(bar, transferto, true)
						bar.parentFrame = self.Name
						continue = false
						
					elseif bar.transferBelowAt and now > bar.transferBelowAt then
						local transferto
						if self.db.profile.TransferBelowTo == "parent" then
							transferto = bar.parentFrame or ""
						else
							transferto = self.db.profile.TransferBelowTo
						end
						self:StartBarTransfer(bar, transferto)
						bar.parentFrame = self.Name
						continue = false
					end
				end
				if continue then
					if remains <= 0 then
						if bar.numRepeat and bar.numRepeat > 0 then
							bar.numRepeat = bar.numRepeat - 1
							self:StartBar(bar.module, 
								bar.label, 
								bar.category,
								bar.subCategory,
								bar.endTime - bar.startTime,
								bar.iconBase,
								bar.reverse,
								bar.numRepeat,
								nil,
								bar.r, bar.g, bar.b)
						else
							if self.db.profile.FadeWhenComplete then
								bar:UpdateFade(self.db.profile)
							else
								bar:Cancel()
							end
						end
					else
						bar:OnUpdate(remains, now, self)
					end
				end
			end
			if bar.count and bar.maxCount and not bar.startTime then
				if not bar.transferring then
					local perc = bar.count / bar.maxCount
					if bar.transferAboveAt and perc > bar.transferAboveAt then
						self:StartBarTransfer(bar, self.db.profile.TransferAboveTo, true)
					elseif bar.transferBelowAt and perc < bar.transferBelowAt then
						self:StartBarTransfer(bar, self.db.profile.TransferBelowTo)
					end
				end
			end
		end
		if self.idealHeight and not self.IsForceShown and not self.IsMovingOrResizing then
			local height = self:GetHeight()
			local diff = self.idealHeight - height
			if (diff < 0 and -diff or diff) < 3 then
				self:SetHeight(self.idealHeight)
				self.idealHeight = nil
				if not next(self.BarList) then
					if self.db.profile.HideWhenEmpty then
						self:Hide()
					else
						self:SetScript("OnUpdate", nil)
					end
				end
			else
				self:SetHeight(height + diff * .1)
			end
		end
	end
	function FrameClass:Initialize(name)
		self.Name = name
		local dbName = "Frame"..name
		self.db = Core.db.children and Core.db.children[dbName] or Core.db:RegisterNamespace(dbName, FrameDefaults)
		
		self.IsForceShown = nil

		self:SetScript("OnMouseDown", OnMouseDown)
		self:SetScript("OnMouseUp", OnMouseUp)

		self:SetScript("OnUpdate", OnUpdate)

		self:SetScript("OnEnter", OnEnter)
		self:SetScript("OnLeave", OnLeave)


		self:RefreshFrameSettings()
		self.Title:SetText(name)

		return self
	end
end

function FrameClass:UpdateAnchor()
	self:ClearAllPoints()
	local db = self.db.profile
	if not db.Xoffset then
		db.Xoffset = _G.GetScreenWidth() / 2
	end
	if not db.Yoffset then
		db.Yoffset = _G.GetScreenHeight() / 2
	end

	if db.FrameAnchor == "BOTTOM" then
		self:SetPoint("BOTTOM", self:GetParent(), "BOTTOMLEFT", db.Xoffset, db.Yoffset - db.Height / 2)
		self.GetAnimationPoint = self.GetTop
	else
		self:SetPoint("TOP", self:GetParent(), "BOTTOMLEFT", db.Xoffset, db.Yoffset + db.Height / 2)
		self.GetAnimationPoint = self.GetBottom
	end
end

function FrameClass:ResetAnchor()
	self.db.profile.Xoffset = nil
	self.db.profile.Yoffset = nil
	self:UpdateAnchor()
end

function FrameClass:Reset()
	Core.db.ResetProfile(self.db)
	self:Initialize(self.Name)	
end

function FrameClass:ForceShow()
	self.IsForceShown = true
	self:Show()
	self:EnableMouse(true)
	self:SetMovable(true)

	self:UpdateBackdrop(true)
	self:SetHeight(self.db.profile.Height)

	for label, bar in pairs(self.BarList) do
		bar:EnableMouse(true)
	end

end

function FrameClass:ResetForceShow()
	self.IsForceShown = nil
	self:RefreshFrameSettings()
end

do
	local bars = {}
	function FrameClass:AcquireBar(label)
		if self.BarList[label] then
			self.BarList[label]:RefreshBase()
			return self.BarList[label]
		end
		if #self.BarSortList < self.MaxBars then
			local bar = remove(bars) or BarClass:New()
			self.BarList[label] = bar
			insert(self.BarSortList, bar)
			bar:Initialize(self)
			return bar
		end
	end
	function FrameClass:ReclaimBar(bar)
		self.BarList[bar.label] = nil
		for i, b in ipairs(self.BarSortList) do
			if b == bar then
				remove(self.BarSortList, i)
				break
			end
		end
		bar.transferring = nil
		insert(bars, bar)
		self:OnBarChange()
	end
end

function FrameClass:StartBarTransfer(bar, to, above)
	if above then
		bar.transferAboveAt = nil
	else
		bar.transferBelowAt = nil
	end
	
	local other = Core:GetBarFrame(to)
	if not other then return end
	if not self:GetIgnoreFilter() then
		if other.db.profile.Categories then
			local category, subCategory = bar.category, bar.subCategory
			if not other.db.profile.CategoriesList[category][subCategory] then
				if not bar.FilterSpam then
					_G["DEFAULT_CHAT_FRAME"]:AddMessage(format(L["<RBM> Attempted to transfer bar: %s to filtered frame: %s"], bar.label, to), 1, 0, 0)
					_G["DEFAULT_CHAT_FRAME"]:AddMessage(format(L["<RBM> Category: %s   SubCategory: %s"], category, subCategory), 1, 0, 0)
					bar.FilterSpam = true
				end
				return 
			end
		end
	end
	self.BarList[bar.label] = nil
	for i, b in ipairs(self.BarSortList) do
		if b == bar then
			remove(self.BarSortList, i)
			break
		end
	end
	self:OnBarChange()
	if above then
		other:AcceptBarTransfer(bar, self.db.profile.TransferAboveAnimate, self.db.profile.TransferAboveRate)
	else
		other:AcceptBarTransfer(bar, self.db.profile.TransferBelowAnimate, self.db.profile.TransferBelowRate)
	end
	
end

do
	--animation functions should avoid unnecessary function calls (such as cos or abs) and be as optimized as reasonably possible
	--rate should be "normalized" so that .01 is very slow and 1 is very fast
	local function CurveUpPower(currentx, currenty, endingx, endingy, rate)
		rate = rate * .8
		local xDiff = endingx - currentx
		local offset = (xDiff > 0 and xDiff or -xDiff) ^ .1
		return currentx + xDiff * rate, currenty + ((endingy * (offset > 1 and offset or 1)) - currenty) * rate
	end
	local function CurveUpConstant(currentx, currenty, endingx, endingy, rate)
		local xDiff = endingx - currentx
		local yDiff = endingy - currenty

		local x
		local change = rate * 50
		if (xDiff < 0 and -xDiff or xDiff) > change then
			if endingx > currentx then
				x = currentx + change
			else
				x = currentx - change
			end
		else
			x = endingx
		end
		local offset = ((xDiff > 0 and xDiff or -xDiff) ^ .5) * .07
		return x, currenty + ((endingy * (offset > 1 and offset or 1)) - currenty) * rate
	end
	local function CurveDownPower(currentx, currenty, endingx, endingy, rate)
		rate = rate * .8
		local xDiff = endingx - currentx
		local offset = (xDiff > 0 and xDiff or -xDiff) ^ .1
		return currentx + xDiff * rate, currenty + ((endingy / (offset > 1 and offset or 1)) - currenty) * rate
	end
	local function CurveDownConstant(currentx, currenty, endingx, endingy, rate)
		local xDiff = endingx - currentx
		local yDiff = endingy - currenty

		local x
		local change = rate * 50
		if (xDiff < 0 and -xDiff or xDiff) > change then
			if endingx > currentx then
				x = currentx + change
			else
				x = currentx - change
			end
		else
			x = endingx
		end
		local offset = ((xDiff > 0 and xDiff or -xDiff) ^ .5) * .07
		return x, currenty + ((endingy / (offset > 1 and offset or 1)) - currenty) * rate
	end
	local function XThenY(currentx, currenty, endingx, endingy, rate)
		local xDiff = endingx - currentx
		local yDiff = endingy - currenty

		local x, y
		local change = rate * 50
		if (xDiff < 0 and -xDiff or xDiff) > change then
			if endingx > currentx then
				x = currentx + change
			else
				x = currentx - change
			end
		else
			x = endingx
		end
		if x == endingx then
			if (yDiff < 0 and -yDiff or yDiff) > change then
				if endingy > currenty then
					y = currenty + change
				else
					y = currenty - change
				end
			else
				y = endingy
			end
		else
			y = currenty
		end
		
		return x, y
	end
	local function YThenX(currentx, currenty, endingx, endingy, rate)
		local xDiff = endingx - currentx
		local yDiff = endingy - currenty

		local x, y
		local change = rate * 50
		if (yDiff < 0 and -yDiff or yDiff) > change then
			if endingy > currenty then
				y = currenty + change
			else
				y = currenty - change
			end
		else
			y = endingy
		end
		if y == endingy then
			if (xDiff < 0 and -xDiff or xDiff) > change then
				if endingx > currentx then
					x = currentx + change
				else
					x = currentx - change
				end
			else
				x = endingx
			end
		else
			x = currentx
		end
		return x, y
	end
	
	local function SlidePower(currentx, currenty, endingx, endingy, rate)
		rate = rate * .1
		local min, xDiff, yDiff = rate * 100, (endingx - currentx) * rate, (endingy - currenty) * rate
		return (xDiff > 0 and ((endingx - currentx) < min and endingx or currentx + (xDiff > min and xDiff or min))) or (endingx - currentx) > -min and endingx or currentx + (xDiff < -min and xDiff or -min), (yDiff > 0 and ((endingy - currenty) < min and endingy or currenty + (yDiff > min and yDiff or min))) or (endingy - currenty) > -min and endingy or currenty + (yDiff < -min and yDiff or -min)
	end
	
	local function SlideConstant(currentx, currenty, endingx, endingy, rate)
		local xDiff, yDiff, change = endingx - currentx, endingy - currenty, rate * 50
		return ((xDiff < 0 and -xDiff or xDiff) > change and (endingx > currentx and currentx + change or currentx - change)) or endingx, ((yDiff < 0 and -yDiff or yDiff) > change and (endingy > currenty and currenty + change or currenty - change)) or endingy
	end
	
	function FrameClass:AcceptBarTransfer(bar, animate, rate)
		local x, y = bar:GetCenter()
		if self.BarList[bar.label] then
			self.BarList[bar.label]:Cancel()
		end
		self.BarList[bar.label] = bar

		if animate ~= "None" then
			self:Show()
			self:SetScript("OnUpdate", OnUpdate)
			bar:Show()
			bar:ClearAllPoints()
			bar:SetPoint("CENTER", _G.UIParent, "BOTTOMLEFT", x, y)
			bar.transferring = true
			if animate == "CurveDownConstant" then bar.GetTransferAnimationPoints = CurveDownConstant
			elseif animate == "CurveUpConstant" then bar.GetTransferAnimationPoints = CurveUpConstant
			elseif animate == "CurveUpPower" then bar.GetTransferAnimationPoints = CurveUpPower
			elseif animate == "CurveDownPower" then bar.GetTransferAnimationPoints = CurveDownPower
			elseif animate == "XThenY" then bar.GetTransferAnimationPoints = XThenY
			elseif animate == "YThenX" then bar.GetTransferAnimationPoints = YThenX
			elseif animate == "SlidePower" then bar.GetTransferAnimationPoints = SlidePower
			elseif animate == "SlideConstant" then bar.GetTransferAnimationPoints = SlideConstant
			end

			bar.rate = rate
		else
			insert(self.BarSortList, bar)
			self:OnBarChange()
		end
		bar:Initialize(self)
	end
end

function FrameClass:FinishBarTransfer(bar)
	bar.transferring = nil
	insert(self.BarSortList, bar)
	self:OnBarChange()
end

do
	local order
	local sortings = {
		["Time Left"] = function(a, b)
			local now = GetTime()
			if order then
				return (a.startTime and a.endTime - (a.paused or now) or a.count and 0 or -1) < (b.startTime and b.endTime - (b.paused or now) or b.count and 0 or -1)
			end
			return (a.startTime and a.endTime - (a.paused or now) or a.count and 0 or -1) > (b.startTime and b.endTime - (b.paused or now) or b.count and 0 or -1)
		end,

		["Time Total Length"] = function(a, b)
			if order then
				return (a.startTime and a.endTime - a.startTime or a.count and 0 or -1) < (b.startTime and b.endTime - b.startTime or b.count and 0 or -1)
			end
			return (a.startTime and a.endTime - a.startTime or a.count and 0 or -1) > (b.startTime and b.endTime - b.startTime or b.count and 0 or -1)
		end,

		["Label"] = function(a, b)
			if order then
				return a.label > b.label
			end
			return a.label < b.label
		end,

		["Category"] = function(a, b)
			if order then
				return a.category < b.category
			end
			return a.category > b.category
		end,

		["SubCategory"] = function(a, b)
			if order then
				return a.subCategory > b.subCategory
			end
			return a.subCategory < b.subCategory
		end,
	}
	function FrameClass:OnBarChange()
		local db = self.db.profile

		if db.SortBars then
			order = db.SortBarsOrder == "Up"
			sort(self.BarSortList, sortings[db.SortBarsMethod])
		end
		do
			local anchor = db.FrameAnchor
			local height, adjust
			local bottom = anchor == "BOTTOM"
			for k, bar in ipairs(self.BarSortList) do
				height = height or bar:GetHeight()
				adjust = adjust or db.IconVisible and db.IconLocation == "RIGHT" and -(height / 2) or db.IconVisible and (height / 2) or 0
				adjust = bar.iconName and adjust or 0
				bar:ClearAllPoints()
				if k == 1 then
					local edgeSize = db.Backdrop.edgeSize
					bar:SetPoint(anchor, self, anchor, adjust, bottom and edgeSize / 4 or -edgeSize / 4)
				else
					--bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), 0, bottom and db.Spacing or -db.Spacing)
					local xadjust
					if self.BarSortList[k-1].iconName and not bar.iconName then
						xadjust = db.IconLocation == "RIGHT" and (db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2 or -((db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2)
					elseif not self.BarSortList[k-1] and bar.iconName then
						xadjust = db.IconLocation == "LEFT" and (db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2 or -((db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2)
					end
					if xadjust then
						bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), xadjust, bottom and db.Spacing or -db.Spacing)
					else
						bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), 0, bottom and db.Spacing or -db.Spacing)
					end
					--[[
					if not bar.iconName then
						if self.BarSortList[k-1].iconName then
							local xadjust = db.IconLocation == "RIGHT" and (db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2 or -((db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2)
							bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), xadjust, bottom and db.Spacing or -db.Spacing)
						else
							bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), 0, bottom and db.Spacing or -db.Spacing)
						end
					else
						if not self.BarSortList[k-1].iconName then
							local xadjust = db.IconLocation == "LEFT" and (db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2 or -((db.IconWidth == 0 and bar:GetHeight() or db.IconWidth)/2)
							bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), xadjust, bottom and db.Spacing or -db.Spacing)
						else
							bar:SetPoint(anchor, self.BarSortList[k - 1], bar:GetRelativePoint(anchor), 0, bottom and db.Spacing or -db.Spacing)
						end
					end	
					]]					
				end
			end
		end
		if db.DynamicResize then
			if #self.BarSortList > 0 then
				self.idealHeight = self.BarHeight * (#self.BarSortList + 0.5)
			else
				self.idealHeight = self.BarHeight * .85
			end
		else
			self.idealHeight = nil
		end

		if not self.idealHeight and not self.IsForceShown and not next(self.BarList) then
			if db.HideWhenEmpty then
				self:Hide()
			else
				self:SetScript("OnUpdate", nil)
			end
		end
	end
end

do
	local ignoreFilters = false
	local Icons = Icons
	--##NO_DOC  Do not call, only used by Plugin's
	function FrameClass:StartBar(module, label, category, subCategory, time, icon, reverse, numRepeat, count, red, green, blue, ...)
		if not label or not category or not subCategory or (time and time < 0) then return end
		local db = self.db.profile
		local custom = db.CustomLabels[label]
		if not ignoreFilters then
			if db.Categories then
				if not db.CategoriesList[category][subCategory] then return end
			end
			if time then
				if db.ByMaxLength and time > db.MaxLength then return end
				if db.ByMinLength and time < db.MinLength then return end
			end
			if numRepeat and count then
				if db.ByMaxLength and count > db.MaxLength then return end
				if db.ByMinLength and count < db.MinLength then return end
			end
			if custom.Filtered then
				return
			else
				local filtered
				for k, info in pairs(db.CustomLabels) do
					if not custom and info.Partial then
						if label:match(k) then
							custom = info
						end
					end
					if (filtered or filtered == nil) and info.Exception then
						if label:match(k) then
							filtered = false
						else
							filtered = true
						end
					end
				end
				if filtered then return end
			end
		end
		local bar = self:AcquireBar(label)
		if bar then
			bar.label = label
			bar.dur = time
			bar.startTime = time and GetTime() or nil
			bar.endTime = time and bar.startTime + time or nil
			bar.iconBase = icon
			bar.iconName = icon and Icons[icon] or nil
			bar.category = category
			bar.subCategory = subCategory
			--bar.reverse = db.StatusBarDirection == "default" and reverse or db.StatusBarDirection == "reverse" and false or db.StatusBarDirection == "notreverse" and true
			reverse = db.StatusBarDirection == "default" and reverse or db.StatusBarDirection == "reverse" and false or db.StatusBarDirection == "notreverse" and true
			bar.reverse = reverse
			bar.numRepeat = numRepeat
			bar.module = module or "<Unknown>"
			do
				if custom.CustomColor then
					red = custom.r
					green = custom.g
					blue = custom.b
				else
					local ct = Profile.ColorTables[category][subCategory]
					red = red or ct.r or random()
					green = green or ct.g or random()
					blue = blue or ct.b or random()
					
					if Profile.ColorTables[category][subCategory]["GradientNum"] and Profile.ColorTables[category][subCategory]["GradientNum"] > 0 then
						local num = Profile.ColorTables[category][subCategory]["GradientNum"]
						bar.gradient = true
						bar.gradientTable = {}
						bar.cachedGradient = {}

						bar.gradientTable[1] = {}
						bar.gradientTable[1][1] = red
						bar.gradientTable[1][2] = green
						bar.gradientTable[1][3] = blue
						gradientid = format("%d%d%d", red, green, blue)
						for i=1, num do
							local ct = Profile.ColorTables[category][subCategory]["Gradient"..i]
							if ct.r and ct.g and ct.b then
								local t = {}
								t[1], t[2], t[3] = ct.r, ct.g, ct.b
								insert(bar.gradientTable, t)
								gradientid = format("%s_%d%d%d", gradientid, ct.r, ct.g, ct.b)
							else
								break
							end
						end
					end
				end
				-- gradient code was copied from CandyBar-2.0 with Permission from Ammo.  Thanks!
				if ... and type(select(1, ...)) == "number" then
					bar.gradient = true
					bar.gradientTable = {}
					bar.cachedGradient = {}
					local n = select("#", ...)
					if n >= 3 then
						bar.gradientTable[1] = {}
						bar.gradientTable[1][1] = red
						bar.gradientTable[1][2] = green
						bar.gradientTable[1][3] = blue
						gradientid = format("%d%d%d", red, green, blue)
						for i=1, n, 3 do
							local r, g, b = select(i, ...)
							if r and g and b then
								local t = {}
								t[1], t[2], t[3] = r, g, b
								insert(bar.gradientTable, t)
								gradientid = format("%s_%d%d%d", gradientid, r, g, b)
							else
								break
							end
						end
					else
						Core:print(L["Must have more than 3 values to have a gradient"])
					end
				end
				if bar.gradient then
					local max = #bar.gradientTable
					for i = 1, max do
						bar.gradientTable[i][4] = (i-1) / (max-1)
					end
					bar.gradientid = gradientid
					if not bar.cachedGradient[gradientid] then
						bar.cachedGradient[gradientid] = {}
					end
				end
			end
			bar.r, bar.g, bar.b = red, green, blue
			bar.maxCount = not time and numRepeat or nil
			bar.count = bar.maxCount and (count or 1) or nil

			if time then
				if reverse then
					if db.NormalizeTime > 0 then
						bar.status:SetMinMaxValues(-bar.endTime, -(bar.endTime - db.NormalizeTime))
					else
						bar.status:SetMinMaxValues(-bar.endTime, -bar.startTime)
					end
					bar.status:SetValue(-bar.startTime)
				else
					if db.NormalizeTime > 0 then
						bar.status:SetMinMaxValues(bar.endTime - db.NormalizeTime, bar.endTime)
					else
						bar.status:SetMinMaxValues(bar.startTime, bar.endTime)
					end
					bar.status:SetValue(bar.startTime)
				end
				
				bar:OnUpdate(bar.endTime - bar.startTime, bar.startTime, self)
			elseif bar.count and bar.maxCount then
				bar.status:SetMinMaxValues(0, bar.maxCount)
				bar.status:SetValue(bar.count)
				bar.timer:SetText(format("%d/%d", bar.count, bar.maxCount))
				bar.spark:SetPoint("CENTER", bar.status, "LEFT", (bar.count / bar.maxCount) * bar.status:GetWidth())
			else
				bar.status:SetMinMaxValues(0, 1)
				bar.status:SetValue(reverse and 0 or 1)
				bar.timer:SetText("")
				bar.spark:Hide()
			end
			bar.text:SetText(bar.label)
			bar.icon:SetTexture(bar.iconName)
			bar.status:SetStatusBarColor(bar.r, bar.g, bar.b)
			
			bar:RefreshSettings()

			bar:Show()

			self:SetScript("OnUpdate", OnUpdate)
			self:Show()
			self:OnBarChange()
		end		
	end
	function FrameClass:TestBar()
		local maxtime, mintime
		if self.db.profile.ByMaxLength then
			maxtime = self.db.profile.MaxLength
		end
		if self.db.profile.ByMinLength then
			mintime = self.db.profile.MinLength
		end
		local reverse = random() >= .5
		local num = random(1, 4)
		local subcat = num == 1 and "Cast" or num == 2 and "Cooldown" or num == 3 and "Buff" or "Debuff"
		
		local reverseFormat, reverseFormatLabel
		if reverse then
			reverseFormat = "(R)"
			reverseFormatLabel = "%s :: %s %s"
		end
		ignoreFilters = self.db.profile.TestIgnoresFilter
		self:StartBar(
			"Internal TestBar", 
			(reverseFormatLabel or "%s :: %s"):format(L["Boss Abilities"], subcat, reverseFormat).." :: "..random(1, 1000),
			"Boss Abilities",
			subcat,
			random(mintime or maxtime and maxtime / 5 or 10, maxtime or mintime and mintime * 5 or 300),
			"@random",
			reverse
		)
		ignoreFilters = false
	end
	function FrameClass:MaxTestBars()
		for i=1, self.MaxBars do
			self:TestBar()
		end
	end
	function FrameClass:GetIgnoreFilter()
		return ignoreFilter
	end
end

function FrameClass:CancelAllBars()
	for label, bar in pairs(self.BarList) do
		bar:Cancel()
	end
end

function FrameClass:LabelBar(label, newLabel)
	if label and newLabel and self.BarList[label] then
		local bar = self.BarList[label]
		self.BarList[label] = nil
		bar:SetLabel(newLabel)
		self.BarList[newLabel] = bar
		self:OnBarChange()
	end
end

function FrameClass:TimeBar(label, time)
	if label and self.BarList[label] then
		self.BarList[label]:SetTime(time)
		self:OnBarChange()
	end
end

function FrameClass:CurrentTime(label, time)
	if label and self.BarList[label] then
		self.BarList[label]:SetCurrentTime(time)
		self:OnBarChange()
	end
end

function FrameClass:ShiftBar(label, value)
	if label and self.BarList[label] then
		self.BarList[label]:Shift(value)
		self:OnBarChange()
	end
end

function FrameClass:SetMinMaxBar(label, min, max)
	if label and self.BarList[label] then
		self.BarList[label]:SetMinMax(min, max)
		self:OnBarChange()
	end
end

function FrameClass:IconBar(label, icon)
	if label and self.BarList[label] then
		self.BarList[label]:SetIcon(icon)
	end
end

function FrameClass:IconCoords(label, l, r, t, b)
	if label and self.BarList[label] then
		self.BarList[label]:SetIconCoords(l,r,t,b)
	end
end

function FrameClass:ColorBar(label, r, g, b, a)
	if label and self.BarList[label] then
		self.BarList[label]:SetColor(r, g, b, a)
	end
end

function FrameClass:SetMaxCount(label, maxcount)
	if label and self.BarList[label] then
		self.BarList[label]:SetMaxCount(maxcount)
	end
end


function FrameClass:SetCount(label, count)
	if label and self.BarList[label] then
		self.BarList[label]:SetCount(count)
		self:OnBarChange()
	end
end

function FrameClass:IncreaseCount(label)
	if label and self.BarList[label] then
		self.BarList[label]:IncreaseCount()
		self:OnBarChange()
	end
end

function FrameClass:DecreaseCount(label)
	if label and self.BarList[label] then
		self.BarList[label]:DecreaseCount()
		self:OnBarChange()
	end
end

function FrameClass:PauseBar(label)
	if label and self.BarList[label] then
		self.BarList[label]:Pause()
		self:OnBarChange()
	end
end

function FrameClass:UnpauseBar(label)
	if label and self.BarList[label] then
		self.BarList[label]:Unpause()
		self:OnBarChange()
	end
end

function FrameClass:CancelBar(label)
	if label and self.BarList[label] then
		self.BarList[label]:Cancel()
	end
end

function FrameClass:CancelModule(name)
	for i=#self.BarSortList, 1, -1 do
		local bar = self.BarSortList[i]
		if bar.module == name then
			bar:Cancel()
		end
	end
	for label, bar in pairs(self.BarList) do --any bars that aren't being sorted
		if bar.module == name then
			bar:Cancel()
		end
	end
end

function FrameClass:IsSortingEnabled()
	return self.db.profile.SortBars
end

function FrameClass:GetMaxBarHeight()
	return floor(self.db.profile.Height * .5)
end

local function GetTableKey(db, ...)
	local num = select("#", ...)
	for i=num, 1, -1 do
		local key = select(i, ...)
		if db[key] ~= nil then
			local opt = db
			for i=i, num - 1 do
				local t = opt[select(i, ...)]
				if type(t) == "table" then
					opt = t
				else
					return opt, select(num - i, ...)
				end
			end
			return opt, select(num, ...)
		end
	end
end

function FrameClass:SetOption(info, ...)
	local swap = info[#info]
	if swap == "StatusTextureA" or swap == "StatusTextureB" then info[#info] = "StatusTexture" end
	local table, key = GetTableKey(self.db.profile, unpack(info))
	if table and type(table[key]) == "table" then
		if key == "SoundPercent" or key == "SoundTime" or key == "SoundByTime" or key == "SoundByPercent" or key == "SoundToPlay" then
			table[key][select(1, ...)][select(2, ...)] = select(3, ...)-- ##NODOC table[key][cat][subCat] = val
		else
			table[key].r = select(1, ...)
			table[key].g = select(2, ...)
			table[key].b = select(3, ...)
			table[key].a = select(4, ...)
		end
	else
		if key == "ShowTextureBars" and ... then
			rbmConfigMediaListStatusTextures()
		end
		table[key] = ...
	end
	self:RefreshFrameSettings()
end

function FrameClass:GetOption(info, ...)
	local swap = info[#info]
	if swap == "StatusTextureA" or swap == "StatusTextureB" then info[#info] = "StatusTexture" end
	
	local table, key = GetTableKey(self.db.profile, unpack(info))
	if table and type(table[key]) == "table" then
		if key == "SoundPercent" or key == "SoundTime" or key == "SoundByTime" or key == "SoundByPercent" or key == "SoundToPlay" then
			return table[key][select(1, ...)][select(2, ...)]-- ##NODOC return table[key][cat][subCat]
		else
			local ct = table[key]
			return ct.r, ct.g, ct.b, ct.a
		end
	end
	return table[key]
end

function FrameClass:GetDisabledOption(info)
	local key = info[#info]
	local db = self.db.profile
	if key == "SortBarsOrder" or key == "SortBarsMethod" then return not db.SortBars
	elseif key == "CategoryList" then return not db.Categories
	elseif key == "MaxLength" then return not db.ByMaxLength
	elseif key == "MinLength" then return not db.ByMinLength
	elseif key == "SparkTexture" or key == "SparkBlend" or key == "SparkHeight" or key == "SparkWidth" or key == "SparkColor" then
		return not db.SparkVisible
	elseif key == "IconLocation" or key == "IconColorUsed" then return not db.IconVisible
	elseif key == "IconColor" then return not db.IconColorUsed
	elseif key == "TransferAbovePercent" then return not db.TransferAboveByPercent
	elseif key == "TransferAboveTime" then return not db.TransferAboveByTime
	elseif key == "TransferBelowPercent" then return not db.TransferBelowByPercent
	elseif key == "TransferBelowTime" then return not db.TransferBelowByTime
	elseif key == "BlinkPercent" then return not db.BlinkByPercent
	elseif key == "BlinkTime" then return not db.BlinkByTime
	elseif key == "PulsePercent" then return not db.PulseByPercent
	elseif key == "PulseTime" then return not db.PulseByTime
	elseif key == "FadePercent" then return not db.FadeByPercent
	elseif key == "FadeTime" then return not db.FadeByTime
	elseif key == "FadeComplete" then return not db.FadeWhenComplete
	elseif key == "LabelShadowOffsetX" or key == "LabelShadowOffsetY" or key == "LabelShadowColor" then
		return not db.LabelUseShadowColor
	elseif key == "StatusBarTextures" then return not db.ShowTextureBars
	end
end

function FrameClass:RefreshAllBars()
	for label, bar in pairs(self.BarList) do
		bar:RefreshSettings()
	end
end

function FrameClass:UpdateBackdrop(show)
	local db = self.db.profile
	if not self.IsForceShown and show ~= true and not db.Visible then
		self:SetBackdrop(nil)
	else
		local backdrop = db.Backdrop
		local bg, edge = backdrop.bgFile, backdrop.edgeFile

		backdrop.bgFile, backdrop.edgeFile = MediaHandler:Fetch("background", bg), MediaHandler:Fetch("border", edge)
		self:SetBackdrop(backdrop)

		backdrop.bgFile, backdrop.edgeFile = bg, edge
	end

	self:SetBackdropColor(db.BackdropColor.r,db.BackdropColor.g, db.BackdropColor.b, db.BackdropColor.a)
	self:SetBackdropBorderColor(db.BackdropBorderColor.r, db.BackdropBorderColor.g, db.BackdropBorderColor.b, db.BackdropBorderColor.a)
end

function FrameClass:UpdateMaxBars()
	local db = self.db.profile
	self.BarHeight = db.BarHeight + db.Spacing
	self.MaxBars = floor(db.Height / self.BarHeight)
	for i=#self.BarSortList, self.MaxBars + 1, -1 do
		local bar = self.BarSortList[i]
		bar:Cancel()
	end
end

function FrameClass:RefreshFrameSettings(saveSize)
	local db = self.db.profile
	local h
	if saveSize and db.DynamicResize then
		h = self:GetHeight()
	end

	if db.TransferBelowTo == self.Name then
		db.TransferBelowTo = ""
	end
	if db.TransferAboveTo == self.Name then
		db.TransferAboveTo = ""
	end

	self:SetHeight(db.Height)
	self:SetWidth(db.Width)

	if db.BarHeight > self:GetMaxBarHeight() then
		db.BarHeight = self:GetMaxBarHeight()
	end


	if not self.IsForceShown then
		self:UpdateBackdrop()
		self:EnableMouse(not (db.Locked or not db.Visible))
		self:SetMovable(not db.Locked)
		self:SetResizable(not db.Locked)

		if db.HideWhenEmpty then
			if not next(self.BarList) then
				self:Hide()
			end
		else
			self:Show()
		end
	end

	self:UpdateMaxBars()


	self:RefreshAllBars()

	self:UpdateAnchor()

	self:SetAlpha(db.Alpha)
	

	if db.ShowTitle then
		self.Title:Show()
	else
		self.Title:Hide()
	end
	if not self.IsForceShown and #self.BarSortList == 0 and db.DynamicResize then
		self:SetHeight(self.BarHeight)
	elseif h then
		self:SetHeight(h)
	end
	self:OnBarChange()
end

--only used by the gui when destroying a frame
function FrameClass:GUIDestroy()
	Core:DestroyBarFrame(self.Name)
end

function FrameClass:OnRightClick()
	local opt
	if _G.IsControlKeyDown() then
		opt = Profile.FrameControlRightClick
	elseif _G.IsShiftKeyDown() then
		opt = Profile.FrameShiftRightClick
	else
		opt = Profile.FrameRightClick
	end
	if opt == "TestBar" then
		self:TestBar()
	elseif opt == "CancelAll" then
		self:CancelAllBars()
	elseif opt == "ShowMenu" then
		AceConfigDialog:Open("RBM")
	end
end

local function FormatTime(secs, val)
	if secs < 60 then --under a minute
		return format(val and "%.1f" or "%.1f "..L["secs"], secs)
	elseif secs < 3600 then --under an hour
		return format(val and "%d:%02d" or "%d:%02d "..L["min"], secs / 60, secs % 60)
	elseif secs < 86400 then --under a day
		return format(val and "%d:%02d" or "%d:%02d "..L["hr"], secs / 3600, secs % 3600 / 60)
	elseif secs < 604800 then --under a week
		return format(val and "%d+" or "%d+ "..L["days"], secs / 86400)
	else
		return format(val and "%d+" or "%d+ "..L["wks"], secs / 604800)
	end
end

function FrameClass:OnBarClick(bar, button)
	if _G.IsShiftKeyDown() then
		local db = self.db.profile
		local msg
		if bar.startTime then
			local now = GetTime()
			local perctime = format("%d", ((now - bar.startTime) / (bar.endTime - bar.startTime)) * 100)
			msg = db.CustomTimeMessage
			msg = msg:gsub("<curtime>", FormatTime(now - bar.startTime))
			msg = msg:gsub("<curtimetrue>", FormatTime(now - bar.startTime, true))
			msg = msg:gsub("<maxtime>", FormatTime(bar.endTime - bar.startTime))
			msg = msg:gsub("<maxtimetrue>", FormatTime(bar.endTime - bar.startTime, true))
			msg = msg:gsub("<remaintime>", FormatTime(bar.endTime - now))
			msg = msg:gsub("<remaintimetrue>", FormatTime(bar.endTime - now, true))
			msg = msg:gsub("<perctime>", perctime.."%%")
			msg = msg:gsub("<perctimetrue>", perctime)
			
		elseif bar.maxCount then
			msg = db.CustomCountMessage
			msg = msg:gsub("<maxcount>", bar.maxCount)
			msg = msg:gsub("<count>", bar.count)
			msg = msg:gsub("<remaincount>", bar.reverse and _G.abs(bar.count - bar.maxCount) or (bar.maxCount - bar.count))
		else
			msg = (L["%q is a timeless bar"]):format(bar.label)
		end
		msg = msg:gsub("<label>", bar.label)
		
		if _G.ChatFrameEditBox:IsVisible() then
			_G.ChatFrameEditBox:Insert(msg)
		else
			if _G.UnitInRaid("player") then
				_G.SendChatMessage(msg, "RAID")
			elseif _G.GetNumPartyMembers() ~= 0 then
				_G.SendChatMessage(msg, "PARTY")
			end
		end
		return
	end
	local opt
	if button == "RightButton" then
		opt = Profile.BarRightClick
	elseif button == "MiddleButton" then
		opt = Profile.BarMiddleClick
	else
		opt = Profile.BarLeftClick
	end
	if opt == "Cancel" then
		bar:Cancel()
	elseif opt == "ShowMenu" then
		AceConfigDialog:Open("RBM")
	elseif opt == "Pause" then
		if bar.startTime then
			if bar.paused then
				bar:Unpause()
			else
				bar:Pause()
			end
		end
	elseif opt == "Filter" then
		self:AddFilteredLabel(bar.label)
	elseif opt == "Color" then
		self:AddColoredLabel(bar.label)
	end
end


local function Copy(from, against)
	if not from then return end
	local to
	for k, v in pairs(from) do
		if type(v) == "table" then
			if next(v) then
				local t = Copy(v, against and against[k])
				if t then
					if not to then
						to = {}
					end
					to[k] = t
				end
			end
		elseif not against or against[k] ~= v then
			if not to then
				to = {}
			end
			to[k] = v
		end
	end
	return to
end

function FrameClass:SaveTheme(themeOpts, themeName)
	local theme = Copy(self.db.profile, FrameDefaults)
	if theme then
		Core:AddTheme(themeName, theme, themeOpts)
	end
end

local function Merge(from, to)
	for k, v in pairs(from) do
		if type(v) == "table" then
			if next(v) then
				if type(to[k]) ~= "table" then
					to[k] = {}
				end
				Merge(v, to[k])
			end
		else
			to[k] = v
		end
	end
end

function FrameClass:ApplyTheme(themeName)
	local theme = Core:GetTheme(themeName)
	if theme then
		local db = self.db.profile
		local x, y
		local keepAnchor = db.KeepAnchorPoints
		if keepAnchor then
			x, y = db.Xoffset, db.Yoffset
		end
		local savedFilters = db.SaveFilters
		local filters
		if savedFilters then
			filters = {
				Categories = db.Categories,
				CategoriesList = Copy(db.CategoriesList),
				Custom = db.Custom,
				CustomList = Copy(db.CustomList),

				CustomException = db.CustomException,
				CustomExceptionList = Copy(db.CustomExceptionList),

				Labels = db.Labels,
				LabelsList = Copy(db.LabelsList),

				ByMaxLength = db.ByMaxLength,
				ByMinLength = db.ByMinLength,
				MinLength = db.MinLength,
				MaxLength = db.MaxLength,
			}
		end
		local merge = db.MergeWithExisting
		if not merge then
			Core.db.ResetProfile(self.db)
			db = self.db.profile
		end
		Merge(theme, db)
		db.Xoffset, db.Yoffset = x, y --if KeepAnchorPoints is false this will nil the anchor and reset it to the center of the screen since themes don't save position
		db.MergeWithExisting = merge
		db.KeepAnchorPoints = keepAnchor
		db.SaveFilters = savedFilters
		if savedFilters then
			Merge(filters, db)
		end
		self:RefreshFrameSettings()
	end
end


function FrameClass:SetAllSounds(on)
	local db = self.db.profile
	for i, category in ipairs{"Cast", "Cooldown", "Buff", "Debuff", "Timeless", "Count"} do
		db.SoundByPercent["Boss Abilities"][category] = on or false
		db.SoundByTime["Boss Abilities"][category] = on or false
	end
	for name, module in Core:IterateModules("Plugin") do
		local cats = module:GetCategories()
		if cats then
			for category in pairs(cats) do
				db.SoundByPercent[name][category] = on or false
				db.SoundByTime[name][category] = on or false
			end
		end
	end
end

function FrameClass:ResetCustomMessages(info)
	local key = info[#info]
	local db = self.db.profile
	if key == "ResetTimedMessage" then
		db.CustomTimeMessage = "<label> is <curtimetrue>/<maxtime> with <remaintime> left."
	elseif key == "ResetCountMessage" then
		db.CustomCountMessage = "<label> is <count>/<maxcount>(<remaincount>)"
	end
end
do
	local cat, subCat
	function FrameClass:GetSoundDisabledSetting(info)
		if info[#info] == "SoundPercent" then
			info = { [1] = "SoundByPercent" }
		elseif info[#info] == "SoundTime" then
			info = { [1] = "SoundByTime" }
		end
		
		if cat and subCat then
			return not self:GetOption(info, cat, subCat)
		end
		return true
	end

	function FrameClass:SetCurrentSoundCategory(_, category)
		if category == "Boss Abilities" then
			subCat = "Cast"
		else
			subCat = next(Core:GetModule("Plugin", category):GetCategories())
		end
		cat = category
	end
	function FrameClass:GetCurrentSoundCategory()
		if not cat then
			cat = "Boss Abilities"
			subCat = "Cast"
		end
		return cat
	end

	function FrameClass:SetCurrentSoundSubCategory(_, subcategory)
		subCat = subcategory
	end
	
	function FrameClass:GetCurrentSoundSubCategory()
		return subCat
	end
	
	local bossSoundLst = {}
	function FrameClass:GetSoundSubCategoryChoices() 
		if cat == "Boss Abilities" then
			return { ["Cast"] = L["Cast"], ["Cooldown"] = L["Cooldown"], ["Buff"] = L["Buff"], ["Debuff"] = L["Debuff"], ["Timeless"] = L["Timeless"], ["Count"] = L["Count"]}
		else
			for i in pairs(bossSoundLst) do
				bossSoundLst[i] = nil
			end
			
			local module = Core:GetModule("Plugin", cat)
			for subCat in pairs(module:GetCategories()) do
				bossSoundLst[subCat] = subCat
			end
			return bossSoundLst
		end
	end
	function FrameClass:SetSoundOption(info, opt, value)
		if cat and subCat then
			self:SetOption(info, cat, subCat, opt, value)
		end
		
	end
	function FrameClass:GetSoundOption(info, opt)
		if cat and subCat then
			return self:GetOption(info, cat, subCat, opt)
		end
	end

	function FrameClass:PlayCurrentSound()
		_G.PlaySoundFile(MediaHandler:Fetch("sound", self.db.profile.SoundToPlay[cat][subCat]))
	end
end