local format = format
local GetRealZoneText = GetRealZoneText
local LibStub = LibStub
setfenv(1, RBM.FunctionEnviroment)

local nagged
LibStub("AceConfig-3.0"):RegisterOptionsTable("RBM", function() --true on-demand configuration
	if nagged or not ConfigLoaded then
		if not nagged then
			local success, reason = _G.LoadAddOn("RBM_Config")
			if not success then
				if reason == "DISABLED" then
					Core:print(L["RBM Config could not be loaded because it is disabled."])
				elseif reason == "MISSING" then
					_G.message(L["RBM Config could not be loaded because it is missing."])
				else 
					_G.message(L["RBM Config could not be loaded because of an unknown error code."])
				end
				nagged = true
			end
		end
		if nagged then
			return {
				type = "group",
				name = "RBM",
				args = {
					NotLoaded = {
						type = "execute",
						name = L["RBM Config Not Loaded"],
						width = "full",
						disabled = true,
					},
				},
			}
		end
	end
	return Core:RefreshAndReturnConfig()
end)

Core:RegisterChatCommand("rbm", function()
	LibStub("AceConfigDialog-3.0"):Open("RBM")
end)

function Core:OnUpdateFuBarTooltip()
	local gtt = _G.GameTooltip
	local zones
	gtt:AddDoubleLine(L["RBM - v%s"]:format(Core.version), Core.revision)
	local realzone
	if Profile.TooltipSameZone then
		realzone = GetRealZoneText()
	end
	for name, module in self:IterateModules("BossModule") do
		if not realzone or module:HasZone(realzone) then
			zones = true
			if module:IsRunning() then
				gtt:AddDoubleLine(name, L["Running"], 1, 1, 1, .5, 1, .5)
			elseif module:IsBossDead() then
				gtt:AddDoubleLine(name, L["Dead"], 1, 1, 1, .8, .4, .3)
			elseif module:IsEnabled() then
				gtt:AddDoubleLine(name, L["Monitoring"], 1, 1, 1, .2, 1, .2)
			else
				gtt:AddDoubleLine(name, L["Inactive"], 1, 1, 1, 1, .2, .2)
			end
		end
	end
	if not zones then
		gtt:AddLine("|cffffff00"..L["Right-click|r to open the options menu"])
	end
end