------------------------------
--      Are you local?      --
------------------------------

local name = "Brutallus Assist"
local L = AceLibrary("AceLocale-2.2"):new("BigWigs"..name)
local boss = BB["Brutallus"]

local db = nil

local pName = UnitName("player")

local RANGE = 3 -- 9.9 yards... the closest we can check for
local SID_BURN = 46394
--local SID_BURN = 6788  -- weakened soul, used for testing

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	cmd = "BrutallusAssist",

	on = "On",
	on_desc = "Toggle BigWigs_BrutAssist module on or off.",
	
	warning = "Warn on burn expiration",
	warning_desc = "Warn in /say when burn is about to run out on you",

	burnsay = "%d secs left on my burn!",
} end )

----------------------------------
--      Module Declaration      --
----------------------------------

local mod = BigWigs:NewModule(name)
mod.synctoken = name
mod.zonename = BZ["Sunwell Plateau"]
mod.enabletrigger = boss
mod.toggleoptions = {"on", "warning", "proximity"}
mod.revision = tonumber(("$Revision: 80605 $"):sub(12, -3))
mod.external = true
mod.proximitySilent = false
mod.proximityCheck = function(unit) return CheckInteractDistance(unit, RANGE) end

------------------------------
--      Initialization      --
------------------------------

function mod:OnEnable()
	
	self:AddCombatListener("SPELL_AURA_APPLIED", "Burn", SID_BURN)
	self:AddCombatListener("SPELL_AURA_REMOVED", "BurnRemove", SID_BURN)
	
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "CheckForWipe")
	
	db = self.db.profile
end

------------------------------
--      Event Handlers      --
------------------------------

function mod:Burn(player)
	if player == pName then
		self:TriggerEvent("BigWigs_ShowProximity", self)
		if db.warning then
			self:ScheduleEvent("Burn10warn", self.BurnShoutWarn, 50, self, 10)
			self:ScheduleEvent("Burn5warn", self.BurnShoutWarn, 55, self, 5)
		end
	end
end

function mod:BurnRemove(player)
	if player == pName then
		self:TriggerEvent("BigWigs_HideProximity", self)
		if db.warning then
			self:CancelScheduledEvent("Burn10warn")
			self:CancelScheduledEvent("Burn5warn")
		end
	end
end

function mod:BurnShoutWarn(time)
	SendChatMessage(L["burnsay"]:format(time), "SAY")
end